"use strict";
(self["webpackChunkipybertin"] = self["webpackChunkipybertin"] || []).push([["vendors-node_modules_d3-geo-projection_src_index_js"],{

/***/ "./node_modules/d3-array/src/merge.js":
/*!********************************************!*\
  !*** ./node_modules/d3-array/src/merge.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ merge)
/* harmony export */ });
function* flatten(arrays) {
  for (const array of arrays) {
    yield* array;
  }
}

function merge(arrays) {
  return Array.from(flatten(arrays));
}


/***/ }),

/***/ "./node_modules/d3-array/src/range.js":
/*!********************************************!*\
  !*** ./node_modules/d3-array/src/range.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ range)
/* harmony export */ });
function range(start, stop, step) {
  start = +start, stop = +stop, step = (n = arguments.length) < 2 ? (stop = start, start = 0, 1) : n < 3 ? 1 : +step;

  var i = -1,
      n = Math.max(0, Math.ceil((stop - start) / step)) | 0,
      range = new Array(n);

  while (++i < n) {
    range[i] = start + i * step;
  }

  return range;
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/airy.js":
/*!****************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/airy.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "airyRaw": () => (/* binding */ airyRaw),
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function airyRaw(beta) {
  var tanBeta_2 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.tan)(beta / 2),
      b = 2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.log)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(beta / 2)) / (tanBeta_2 * tanBeta_2);

  function forward(x, y) {
    var cosx = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(x),
        cosy = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(y),
        siny = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(y),
        cosz = cosy * cosx,
        k = -((1 - cosz ? (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.log)((1 + cosz) / 2) / (1 - cosz) : -0.5) + b / (1 + cosz));
    return [k * cosy * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(x), k * siny];
  }

  forward.invert = function(x, y) {
    var r = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(x * x + y * y),
        z = -beta / 2,
        i = 50, delta;
    if (!r) return [0, 0];
    do {
      var z_2 = z / 2,
          cosz_2 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(z_2),
          sinz_2 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(z_2),
          tanz_2 = sinz_2 / cosz_2,
          lnsecz_2 = -(0,_math_js__WEBPACK_IMPORTED_MODULE_1__.log)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(cosz_2));
      z -= delta = (2 / tanz_2 * lnsecz_2 - b * tanz_2 - r) / (-lnsecz_2 / (sinz_2 * sinz_2) + 1 - b / (2 * cosz_2 * cosz_2)) * (cosz_2 < 0 ? 0.7 : 1);
    } while ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(delta) > _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon && --i > 0);
    var sinz = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(z);
    return [(0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)(x * sinz, r * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(z)), (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(y * sinz / r)];
  };

  return forward;
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  var beta = _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi,
      m = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjectionMutator)(airyRaw),
      p = m(beta);

  p.radius = function(_) {
    return arguments.length ? m(beta = _ * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians) : beta * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees;
  };

  return p
      .scale(179.976)
      .clipAngle(147);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/aitoff.js":
/*!******************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/aitoff.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "aitoffRaw": () => (/* binding */ aitoffRaw),
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function aitoffRaw(x, y) {
  var cosy = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(y), sincia = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sinci)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.acos)(cosy * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(x /= 2)));
  return [2 * cosy * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(x) * sincia, (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(y) * sincia];
}

// Abort if [x, y] is not within an ellipse centered at [0, 0] with
// semi-major axis pi and semi-minor axis pi/2.
aitoffRaw.invert = function(x, y) {
  if (x * x + 4 * y * y > _math_js__WEBPACK_IMPORTED_MODULE_1__.pi * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi + _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon) return;
  var x1 = x, y1 = y, i = 25;
  do {
    var sinx = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(x1),
        sinx_2 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(x1 / 2),
        cosx_2 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(x1 / 2),
        siny = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(y1),
        cosy = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(y1),
        sin_2y = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(2 * y1),
        sin2y = siny * siny,
        cos2y = cosy * cosy,
        sin2x_2 = sinx_2 * sinx_2,
        c = 1 - cos2y * cosx_2 * cosx_2,
        e = c ? (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.acos)(cosy * cosx_2) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(f = 1 / c) : f = 0,
        f,
        fx = 2 * e * cosy * sinx_2 - x,
        fy = e * siny - y,
        dxdx = f * (cos2y * sin2x_2 + e * cosy * cosx_2 * sin2y),
        dxdy = f * (0.5 * sinx * sin_2y - e * 2 * siny * sinx_2),
        dydx = f * 0.25 * (sin_2y * sinx_2 - e * siny * cos2y * sinx),
        dydy = f * (sin2y * cosx_2 + e * sin2x_2 * cosy),
        z = dxdy * dydx - dydy * dxdx;
    if (!z) break;
    var dx = (fy * dxdy - fx * dydy) / z,
        dy = (fx * dydx - fy * dxdx) / z;
    x1 -= dx, y1 -= dy;
  } while (((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(dx) > _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon || (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(dy) > _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon) && --i > 0);
  return [x1, y1];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(aitoffRaw)
      .scale(152.63);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/armadillo.js":
/*!*********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/armadillo.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "armadilloRaw": () => (/* binding */ armadilloRaw),
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function armadilloRaw(phi0) {
  var sinPhi0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi0),
      cosPhi0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi0),
      sPhi0 = phi0 >= 0 ? 1 : -1,
      tanPhi0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.tan)(sPhi0 * phi0),
      k = (1 + sinPhi0 - cosPhi0) / 2;

  function forward(lambda, phi) {
    var cosPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi),
        cosLambda = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(lambda /= 2);
    return [
      (1 + cosPhi) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(lambda),
      (sPhi0 * phi > -(0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)(cosLambda, tanPhi0) - 1e-3 ? 0 : -sPhi0 * 10) + k + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi) * cosPhi0 - (1 + cosPhi) * sinPhi0 * cosLambda // TODO D3 core should allow null or [NaN, NaN] to be returned.
    ];
  }

  forward.invert = function(x, y) {
    var lambda = 0,
        phi = 0,
        i = 50;
    do {
      var cosLambda = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(lambda),
          sinLambda = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(lambda),
          cosPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi),
          sinPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi),
          A = 1 + cosPhi,
          fx = A * sinLambda - x,
          fy = k + sinPhi * cosPhi0 - A * sinPhi0 * cosLambda - y,
          dxdLambda = A * cosLambda / 2,
          dxdPhi = -sinLambda * sinPhi,
          dydLambda = sinPhi0 * A * sinLambda / 2,
          dydPhi = cosPhi0 * cosPhi + sinPhi0 * cosLambda * sinPhi,
          denominator = dxdPhi * dydLambda - dydPhi * dxdLambda,
          dLambda = (fy * dxdPhi - fx * dydPhi) / denominator / 2,
          dPhi = (fx * dydLambda - fy * dxdLambda) / denominator;
      if ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(dPhi) > 2) dPhi /= 2;
      lambda -= dLambda, phi -= dPhi;
    } while (((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(dLambda) > _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon || (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(dPhi) > _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon) && --i > 0);
    return sPhi0 * phi > -(0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(lambda), tanPhi0) - 1e-3 ? [lambda * 2, phi] : null;
  };

  return forward;
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  var phi0 = 20 * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians,
      sPhi0 = phi0 >= 0 ? 1 : -1,
      tanPhi0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.tan)(sPhi0 * phi0),
      m = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjectionMutator)(armadilloRaw),
      p = m(phi0),
      stream_ = p.stream;

  p.parallel = function(_) {
    if (!arguments.length) return phi0 * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees;
    tanPhi0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.tan)((sPhi0 = (phi0 = _ * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians) >= 0 ? 1 : -1) * phi0);
    return m(phi0);
  };

  p.stream = function(stream) {
    var rotate = p.rotate(),
        rotateStream = stream_(stream),
        sphereStream = (p.rotate([0, 0]), stream_(stream)),
        precision = p.precision();
    p.rotate(rotate);
    rotateStream.sphere = function() {
      sphereStream.polygonStart(), sphereStream.lineStart();
      for (var lambda = sPhi0 * -180; sPhi0 * lambda < 180; lambda += sPhi0 * 90)
        sphereStream.point(lambda, sPhi0 * 90);
      if (phi0) while (sPhi0 * (lambda -= 3 * sPhi0 * precision) >= -180) {
        sphereStream.point(lambda, sPhi0 * -(0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(lambda * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians / 2), tanPhi0) * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees);
      }
      sphereStream.lineEnd(), sphereStream.polygonEnd();
    };
    return rotateStream;
  };

  return p
      .scale(218.695)
      .center([0, 28.0974]);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/august.js":
/*!******************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/august.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "augustRaw": () => (/* binding */ augustRaw),
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function augustRaw(lambda, phi) {
  var tanPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.tan)(phi / 2),
      k = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(1 - tanPhi * tanPhi),
      c = 1 + k * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(lambda /= 2),
      x = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(lambda) * k / c,
      y = tanPhi / c,
      x2 = x * x,
      y2 = y * y;
  return [
    4 / 3 * x * (3 + x2 - 3 * y2),
    4 / 3 * y * (3 + 3 * x2 - y2)
  ];
}

augustRaw.invert = function(x, y) {
  x *= 3 / 8, y *= 3 / 8;
  if (!x && (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(y) > 1) return null;
  var x2 = x * x,
      y2 = y * y,
      s = 1 + x2 + y2,
      sin3Eta = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)((s - (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(s * s - 4 * y * y)) / 2),
      eta = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(sin3Eta) / 3,
      xi = sin3Eta ? (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.arcosh)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(y / sin3Eta)) / 3 : (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.arsinh)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(x)) / 3,
      cosEta = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(eta),
      coshXi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cosh)(xi),
      d = coshXi * coshXi - cosEta * cosEta;
  return [
    (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(x) * 2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sinh)(xi) * cosEta, 0.25 - d),
    (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(y) * 2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)(coshXi * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(eta), 0.25 + d)
  ];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(augustRaw)
      .scale(66.1603);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/baker.js":
/*!*****************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/baker.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "bakerRaw": () => (/* binding */ bakerRaw),
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



var sqrt8 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(8),
    phi0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.log)(1 + _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt2);

function bakerRaw(lambda, phi) {
  var phi0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(phi);
  return phi0 < _math_js__WEBPACK_IMPORTED_MODULE_1__.quarterPi
      ? [lambda, (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.log)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.tan)(_math_js__WEBPACK_IMPORTED_MODULE_1__.quarterPi + phi / 2))]
      : [lambda * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi0) * (2 * _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt2 - 1 / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi0)), (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(phi) * (2 * _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt2 * (phi0 - _math_js__WEBPACK_IMPORTED_MODULE_1__.quarterPi) - (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.log)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.tan)(phi0 / 2)))];
}

bakerRaw.invert = function(x, y) {
  if ((y0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(y)) < phi0) return [x, 2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.exp)(y)) - _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi];
  var phi = _math_js__WEBPACK_IMPORTED_MODULE_1__.quarterPi, i = 25, delta, y0;
  do {
    var cosPhi_2 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi / 2), tanPhi_2 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.tan)(phi / 2);
    phi -= delta = (sqrt8 * (phi - _math_js__WEBPACK_IMPORTED_MODULE_1__.quarterPi) - (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.log)(tanPhi_2) - y0) / (sqrt8 - cosPhi_2 * cosPhi_2 / (2 * tanPhi_2));
  } while ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(delta) > _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon2 && --i > 0);
  return [x / ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi) * (sqrt8 - 1 / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi))), (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(y) * phi];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(bakerRaw)
      .scale(112.314);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/berghaus.js":
/*!********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/berghaus.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "berghausRaw": () => (/* binding */ berghausRaw),
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function berghausRaw(lobes) {
  var k = 2 * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi / lobes;

  function forward(lambda, phi) {
    var p = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoAzimuthalEquidistantRaw)(lambda, phi);
    if ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(lambda) > _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi) { // back hemisphere
      var theta = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)(p[1], p[0]),
          r = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(p[0] * p[0] + p[1] * p[1]),
          theta0 = k * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.round)((theta - _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi) / k) + _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi,
          alpha = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(theta -= theta0), 2 - (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(theta)); // angle relative to lobe end
      theta = theta0 + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(_math_js__WEBPACK_IMPORTED_MODULE_1__.pi / r * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(alpha)) - alpha;
      p[0] = r * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(theta);
      p[1] = r * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(theta);
    }
    return p;
  }

  forward.invert = function(x, y) {
    var r = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(x * x + y * y);
    if (r > _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi) {
      var theta = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)(y, x),
          theta0 = k * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.round)((theta - _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi) / k) + _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi,
          s = theta > theta0 ? -1 : 1,
          A = r * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(theta0 - theta),
          cotAlpha = 1 / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.tan)(s * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.acos)((A - _math_js__WEBPACK_IMPORTED_MODULE_1__.pi) / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(_math_js__WEBPACK_IMPORTED_MODULE_1__.pi * (_math_js__WEBPACK_IMPORTED_MODULE_1__.pi - 2 * A) + r * r)));
      theta = theta0 + 2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan)((cotAlpha + s * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(cotAlpha * cotAlpha - 3)) / 3);
      x = r * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(theta), y = r * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(theta);
    }
    return d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoAzimuthalEquidistantRaw.invert(x, y);
  };

  return forward;
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  var lobes = 5,
      m = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjectionMutator)(berghausRaw),
      p = m(lobes),
      projectionStream = p.stream,
      epsilon = 1e-2,
      cr = -(0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(epsilon * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians),
      sr = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(epsilon * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians);

  p.lobes = function(_) {
    return arguments.length ? m(lobes = +_) : lobes;
  };

  p.stream = function(stream) {
    var rotate = p.rotate(),
        rotateStream = projectionStream(stream),
        sphereStream = (p.rotate([0, 0]), projectionStream(stream));
    p.rotate(rotate);
    rotateStream.sphere = function() {
      sphereStream.polygonStart(), sphereStream.lineStart();
      for (var i = 0, delta = 360 / lobes, delta0 = 2 * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi / lobes, phi = 90 - 180 / lobes, phi0 = _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi; i < lobes; ++i, phi -= delta, phi0 -= delta0) {
        sphereStream.point((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)(sr * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi0), cr) * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees, (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(sr * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi0)) * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees);
        if (phi < -90) {
          sphereStream.point(-90, -180 - phi - epsilon);
          sphereStream.point(-90, -180 - phi + epsilon);
        } else {
          sphereStream.point(90, phi + epsilon);
          sphereStream.point(90, phi - epsilon);
        }
      }
      sphereStream.lineEnd(), sphereStream.polygonEnd();
    };
    return rotateStream;
  };

  return p
      .scale(87.8076)
      .center([0, 17.1875])
      .clipAngle(180 - 1e-3);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/bertin.js":
/*!******************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/bertin.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "bertin1953Raw": () => (/* binding */ bertin1953Raw),
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _hammer_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./hammer.js */ "./node_modules/d3-geo-projection/src/hammer.js");
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");
/* harmony import */ var _newton_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./newton.js */ "./node_modules/d3-geo-projection/src/newton.js");





// Bertin 1953 as a modified Briesemeister
// https://bl.ocks.org/Fil/5b9ee9636dfb6ffa53443c9006beb642
function bertin1953Raw() {
  var hammer = (0,_hammer_js__WEBPACK_IMPORTED_MODULE_1__.hammerRaw)(1.68, 2),
      fu = 1.4, k = 12;

  function forward(lambda, phi) {

    if (lambda + phi < -fu) {
      var u = (lambda - phi + 1.6) * (lambda + phi + fu) / 8;
      lambda += u;
      phi -= 0.8 * u * (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.sin)(phi + _math_js__WEBPACK_IMPORTED_MODULE_2__.pi / 2);
    }

    var r = hammer(lambda, phi);

    var d = (1 - (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.cos)(lambda * phi)) / k;

    if (r[1] < 0) {
      r[0] *= 1 + d;
    }
    if (r[1] > 0) {
      r[1] *= 1 + d / 1.5 * r[0] * r[0];
    }

    return r;
  }
  
  forward.invert = (0,_newton_js__WEBPACK_IMPORTED_MODULE_3__.solve2d)(forward);
  return forward;
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  // this projection should not be rotated
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(bertin1953Raw())
    .rotate([-16.5, -42])
    .scale(176.57)
    .center([7.93, 0.09]);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/boggs.js":
/*!*****************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/boggs.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "boggsRaw": () => (/* binding */ boggsRaw),
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mollweide_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./mollweide.js */ "./node_modules/d3-geo-projection/src/mollweide.js");
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");




var k = 2.00276,
    w = 1.11072;

function boggsRaw(lambda, phi) {
  var theta = (0,_mollweide_js__WEBPACK_IMPORTED_MODULE_1__.mollweideBromleyTheta)(_math_js__WEBPACK_IMPORTED_MODULE_2__.pi, phi);
  return [k * lambda / (1 / (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.cos)(phi) + w / (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.cos)(theta)), (phi + _math_js__WEBPACK_IMPORTED_MODULE_2__.sqrt2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.sin)(theta)) / k];
}

boggsRaw.invert = function(x, y) {
  var ky = k * y, theta = y < 0 ? -_math_js__WEBPACK_IMPORTED_MODULE_2__.quarterPi : _math_js__WEBPACK_IMPORTED_MODULE_2__.quarterPi, i = 25, delta, phi;
  do {
    phi = ky - _math_js__WEBPACK_IMPORTED_MODULE_2__.sqrt2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.sin)(theta);
    theta -= delta = ((0,_math_js__WEBPACK_IMPORTED_MODULE_2__.sin)(2 * theta) + 2 * theta - _math_js__WEBPACK_IMPORTED_MODULE_2__.pi * (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.sin)(phi)) / (2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.cos)(2 * theta) + 2 + _math_js__WEBPACK_IMPORTED_MODULE_2__.pi * (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.cos)(phi) * _math_js__WEBPACK_IMPORTED_MODULE_2__.sqrt2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.cos)(theta));
  } while ((0,_math_js__WEBPACK_IMPORTED_MODULE_2__.abs)(delta) > _math_js__WEBPACK_IMPORTED_MODULE_2__.epsilon && --i > 0);
  phi = ky - _math_js__WEBPACK_IMPORTED_MODULE_2__.sqrt2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.sin)(theta);
  return [x * (1 / (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.cos)(phi) + w / (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.cos)(theta)) / k, phi];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(boggsRaw)
      .scale(160.857);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/bonne.js":
/*!*****************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/bonne.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "bonneRaw": () => (/* binding */ bonneRaw),
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _parallel1_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./parallel1.js */ "./node_modules/d3-geo-projection/src/parallel1.js");
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");
/* harmony import */ var _sinusoidal_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./sinusoidal.js */ "./node_modules/d3-geo-projection/src/sinusoidal.js");




function bonneRaw(phi0) {
  if (!phi0) return _sinusoidal_js__WEBPACK_IMPORTED_MODULE_0__.sinusoidalRaw;
  var cotPhi0 = 1 / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.tan)(phi0);

  function forward(lambda, phi) {
    var rho = cotPhi0 + phi0 - phi,
        e = rho ? lambda * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi) / rho : rho;
    return [rho * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(e), cotPhi0 - rho * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(e)];
  }

  forward.invert = function(x, y) {
    var rho = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(x * x + (y = cotPhi0 - y) * y),
        phi = cotPhi0 + phi0 - rho;
    return [rho / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)(x, y), phi];
  };

  return forward;
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,_parallel1_js__WEBPACK_IMPORTED_MODULE_2__["default"])(bonneRaw)
      .scale(123.082)
      .center([0, 26.1441])
      .parallel(45);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/bottomley.js":
/*!*********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/bottomley.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "bottomleyRaw": () => (/* binding */ bottomleyRaw),
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function bottomleyRaw(sinPsi) {

  function forward(lambda, phi) {
    var rho = _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi - phi,
        eta = rho ? lambda * sinPsi * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(rho) / rho : rho;
    return [rho * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(eta) / sinPsi, _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi - rho * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(eta)];
  }

  forward.invert = function(x, y) {
    var x1 = x * sinPsi,
        y1 = _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi - y,
        rho = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(x1 * x1 + y1 * y1),
        eta = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)(x1, y1);
    return [(rho ? rho / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(rho) : 1) * eta / sinPsi, _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi - rho];
  };

  return forward;
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  var sinPsi = 0.5,
      m = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjectionMutator)(bottomleyRaw),
      p = m(sinPsi);

  p.fraction = function(_) {
    return arguments.length ? m(sinPsi = +_) : sinPsi;
  };

  return p
      .scale(158.837);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/bromley.js":
/*!*******************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/bromley.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "bromleyRaw": () => (/* binding */ bromleyRaw),
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");
/* harmony import */ var _mollweide_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./mollweide.js */ "./node_modules/d3-geo-projection/src/mollweide.js");




var bromleyRaw = (0,_mollweide_js__WEBPACK_IMPORTED_MODULE_1__.mollweideBromleyRaw)(1, 4 / _math_js__WEBPACK_IMPORTED_MODULE_2__.pi, _math_js__WEBPACK_IMPORTED_MODULE_2__.pi);

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(bromleyRaw)
      .scale(152.63);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/chamberlin.js":
/*!**********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/chamberlin.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "chamberlinAfrica": () => (/* binding */ chamberlinAfrica),
/* harmony export */   "chamberlinRaw": () => (/* binding */ chamberlinRaw),
/* harmony export */   "default": () => (/* binding */ chamberlin)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");
/* harmony import */ var _newton_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./newton.js */ "./node_modules/d3-geo-projection/src/newton.js");




// Azimuthal distance.
function distance(dPhi, c1, s1, c2, s2, dLambda) {
  var cosdLambda = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(dLambda), r;
  if ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(dPhi) > 1 || (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(dLambda) > 1) {
    r = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.acos)(s1 * s2 + c1 * c2 * cosdLambda);
  } else {
    var sindPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(dPhi / 2), sindLambda = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(dLambda / 2);
    r = 2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(sindPhi * sindPhi + c1 * c2 * sindLambda * sindLambda));
  }
  return (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(r) > _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon ? [r, (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)(c2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(dLambda), c1 * s2 - s1 * c2 * cosdLambda)] : [0, 0];
}

// Angle opposite a, and contained between sides of lengths b and c.
function angle(b, c, a) {
  return (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.acos)((b * b + c * c - a * a) / (2 * b * c));
}

// Normalize longitude.
function longitude(lambda) {
  return lambda - 2 * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.floor)((lambda + _math_js__WEBPACK_IMPORTED_MODULE_1__.pi) / (2 * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi));
}

function chamberlinRaw(p0, p1, p2) {
  var points = [
    [p0[0], p0[1], (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(p0[1]), (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(p0[1])],
    [p1[0], p1[1], (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(p1[1]), (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(p1[1])],
    [p2[0], p2[1], (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(p2[1]), (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(p2[1])]
  ];

  for (var a = points[2], b, i = 0; i < 3; ++i, a = b) {
    b = points[i];
    a.v = distance(b[1] - a[1], a[3], a[2], b[3], b[2], b[0] - a[0]);
    a.point = [0, 0];
  }

  var beta0 = angle(points[0].v[0], points[2].v[0], points[1].v[0]),
      beta1 = angle(points[0].v[0], points[1].v[0], points[2].v[0]),
      beta2 = _math_js__WEBPACK_IMPORTED_MODULE_1__.pi - beta0;

  points[2].point[1] = 0;
  points[0].point[0] = -(points[1].point[0] = points[0].v[0] / 2);

  var mean = [
    points[2].point[0] = points[0].point[0] + points[2].v[0] * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(beta0),
    2 * (points[0].point[1] = points[1].point[1] = points[2].v[0] * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(beta0))
  ];

  function forward(lambda, phi) {
    var sinPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi),
        cosPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi),
        v = new Array(3), i;

    // Compute distance and azimuth from control points.
    for (i = 0; i < 3; ++i) {
      var p = points[i];
      v[i] = distance(phi - p[1], p[3], p[2], cosPhi, sinPhi, lambda - p[0]);
      if (!v[i][0]) return p.point;
      v[i][1] = longitude(v[i][1] - p.v[1]);
    }

    // Arithmetic mean of interception points.
    var point = mean.slice();
    for (i = 0; i < 3; ++i) {
      var j = i == 2 ? 0 : i + 1;
      var a = angle(points[i].v[0], v[i][0], v[j][0]);
      if (v[i][1] < 0) a = -a;

      if (!i) {
        point[0] += v[i][0] * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(a);
        point[1] -= v[i][0] * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(a);
      } else if (i == 1) {
        a = beta1 - a;
        point[0] -= v[i][0] * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(a);
        point[1] -= v[i][0] * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(a);
      } else {
        a = beta2 - a;
        point[0] += v[i][0] * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(a);
        point[1] += v[i][0] * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(a);
      }
    }

    point[0] /= 3, point[1] /= 3;
    return point;
  }

  return forward;
}

function pointRadians(p) {
  return p[0] *= _math_js__WEBPACK_IMPORTED_MODULE_1__.radians, p[1] *= _math_js__WEBPACK_IMPORTED_MODULE_1__.radians, p;
}

function chamberlinAfrica() {
  return chamberlin([0, 22], [45, 22], [22.5, -22])
      .scale(380)
      .center([22.5, 2]);
}

function chamberlin(p0, p1, p2) { // TODO order matters!
  var c = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoCentroid)({type: "MultiPoint", coordinates: [p0, p1, p2]}),
      R = [-c[0], -c[1]],
      r = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoRotation)(R),
      f = chamberlinRaw(pointRadians(r(p0)), pointRadians(r(p1)), pointRadians(r(p2)));
  f.invert = (0,_newton_js__WEBPACK_IMPORTED_MODULE_2__.solve2d)(f);
  var p = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(f).rotate(R),
      center = p.center;

  delete p.rotate;

  p.center = function(_) {
    return arguments.length ? center(r(_)) : r.invert(center());
  };

  return p
      .clipAngle(90);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/collignon.js":
/*!*********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/collignon.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "collignonRaw": () => (/* binding */ collignonRaw),
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function collignonRaw(lambda, phi) {
  var alpha = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(1 - (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi));
  return [(2 / _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrtPi) * lambda * alpha, _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrtPi * (1 - alpha)];
}

collignonRaw.invert = function(x, y) {
  var lambda = (lambda = y / _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrtPi - 1) * lambda;
  return [lambda > 0 ? x * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(_math_js__WEBPACK_IMPORTED_MODULE_1__.pi / lambda) / 2 : 0, (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(1 - lambda)];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(collignonRaw)
      .scale(95.6464)
      .center([0, 30]);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/craig.js":
/*!*****************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/craig.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "craigRaw": () => (/* binding */ craigRaw),
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");
/* harmony import */ var _parallel1_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./parallel1.js */ "./node_modules/d3-geo-projection/src/parallel1.js");



function craigRaw(phi0) {
  var tanPhi0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.tan)(phi0);

  function forward(lambda, phi) {
    return [lambda, (lambda ? lambda / (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sin)(lambda) : 1) * ((0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sin)(phi) * (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.cos)(lambda) - tanPhi0 * (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.cos)(phi))];
  }

  forward.invert = tanPhi0 ? function(x, y) {
    if (x) y *= (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sin)(x) / x;
    var cosLambda = (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.cos)(x);
    return [x, 2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.atan2)((0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sqrt)(cosLambda * cosLambda + tanPhi0 * tanPhi0 - y * y) - cosLambda, tanPhi0 - y)];
  } : function(x, y) {
    return [x, (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.asin)(x ? y * (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.tan)(x) / x : y)];
  };

  return forward;
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,_parallel1_js__WEBPACK_IMPORTED_MODULE_1__["default"])(craigRaw)
      .scale(249.828)
      .clipAngle(90);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/craster.js":
/*!*******************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/craster.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "crasterRaw": () => (/* binding */ crasterRaw),
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



var sqrt3 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(3);

function crasterRaw(lambda, phi) {
  return [sqrt3 * lambda * (2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(2 * phi / 3) - 1) / _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrtPi, sqrt3 * _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrtPi * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi / 3)];
}

crasterRaw.invert = function(x, y) {
  var phi = 3 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(y / (sqrt3 * _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrtPi));
  return [_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrtPi * x / (sqrt3 * (2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(2 * phi / 3) - 1)), phi];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(crasterRaw)
      .scale(156.19);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/cylindricalEqualArea.js":
/*!********************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/cylindricalEqualArea.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "cylindricalEqualAreaRaw": () => (/* binding */ cylindricalEqualAreaRaw),
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");
/* harmony import */ var _parallel1_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./parallel1.js */ "./node_modules/d3-geo-projection/src/parallel1.js");



function cylindricalEqualAreaRaw(phi0) {
  var cosPhi0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.cos)(phi0);

  function forward(lambda, phi) {
    return [lambda * cosPhi0, (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sin)(phi) / cosPhi0];
  }

  forward.invert = function(x, y) {
    return [x / cosPhi0, (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.asin)(y * cosPhi0)];
  };

  return forward;
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,_parallel1_js__WEBPACK_IMPORTED_MODULE_1__["default"])(cylindricalEqualAreaRaw)
      .parallel(38.58) // acos(sqrt(width / height / pi)) * radians
      .scale(195.044); // width / (sqrt(width / height / pi) * 2 * pi)
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/cylindricalStereographic.js":
/*!************************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/cylindricalStereographic.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "cylindricalStereographicRaw": () => (/* binding */ cylindricalStereographicRaw),
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");
/* harmony import */ var _parallel1_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./parallel1.js */ "./node_modules/d3-geo-projection/src/parallel1.js");



function cylindricalStereographicRaw(phi0) {
  var cosPhi0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.cos)(phi0);

  function forward(lambda, phi) {
    return [lambda * cosPhi0, (1 + cosPhi0) * (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.tan)(phi / 2)];
  }

  forward.invert = function(x, y) {
    return [x / cosPhi0, (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.atan)(y / (1 + cosPhi0)) * 2];
  };

  return forward;
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,_parallel1_js__WEBPACK_IMPORTED_MODULE_1__["default"])(cylindricalStereographicRaw)
      .scale(124.75);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/eckert1.js":
/*!*******************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/eckert1.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "eckert1Raw": () => (/* binding */ eckert1Raw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function eckert1Raw(lambda, phi) {
  var alpha = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(8 / (3 * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi));
  return [
    alpha * lambda * (1 - (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(phi) / _math_js__WEBPACK_IMPORTED_MODULE_1__.pi),
    alpha * phi
  ];
}

eckert1Raw.invert = function(x, y) {
  var alpha = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(8 / (3 * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi)),
      phi = y / alpha;
  return [
    x / (alpha * (1 - (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(phi) / _math_js__WEBPACK_IMPORTED_MODULE_1__.pi)),
    phi
  ];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(eckert1Raw)
      .scale(165.664);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/eckert2.js":
/*!*******************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/eckert2.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "eckert2Raw": () => (/* binding */ eckert2Raw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function eckert2Raw(lambda, phi) {
  var alpha = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(4 - 3 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(phi)));
  return [
    2 / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(6 * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi) * lambda * alpha,
    (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(phi) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(2 * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi / 3) * (2 - alpha)
  ];
}

eckert2Raw.invert = function(x, y) {
  var alpha = 2 - (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(y) / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(2 * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi / 3);
  return [
    x * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(6 * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi) / (2 * alpha),
    (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(y) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)((4 - alpha * alpha) / 3)
  ];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(eckert2Raw)
      .scale(165.664);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/eckert3.js":
/*!*******************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/eckert3.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "eckert3Raw": () => (/* binding */ eckert3Raw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function eckert3Raw(lambda, phi) {
  var k = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(_math_js__WEBPACK_IMPORTED_MODULE_1__.pi * (4 + _math_js__WEBPACK_IMPORTED_MODULE_1__.pi));
  return [
    2 / k * lambda * (1 + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(1 - 4 * phi * phi / (_math_js__WEBPACK_IMPORTED_MODULE_1__.pi * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi))),
    4 / k * phi
  ];
}

eckert3Raw.invert = function(x, y) {
  var k = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(_math_js__WEBPACK_IMPORTED_MODULE_1__.pi * (4 + _math_js__WEBPACK_IMPORTED_MODULE_1__.pi)) / 2;
  return [
    x * k / (1 + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(1 - y * y * (4 + _math_js__WEBPACK_IMPORTED_MODULE_1__.pi) / (4 * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi))),
    y * k / 2
  ];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(eckert3Raw)
      .scale(180.739);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/eckert4.js":
/*!*******************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/eckert4.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "eckert4Raw": () => (/* binding */ eckert4Raw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function eckert4Raw(lambda, phi) {
  var k = (2 + _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi);
  phi /= 2;
  for (var i = 0, delta = Infinity; i < 10 && (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(delta) > _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon; i++) {
    var cosPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi);
    phi -= delta = (phi + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi) * (cosPhi + 2) - k) / (2 * cosPhi * (1 + cosPhi));
  }
  return [
    2 / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(_math_js__WEBPACK_IMPORTED_MODULE_1__.pi * (4 + _math_js__WEBPACK_IMPORTED_MODULE_1__.pi)) * lambda * (1 + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi)),
    2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(_math_js__WEBPACK_IMPORTED_MODULE_1__.pi / (4 + _math_js__WEBPACK_IMPORTED_MODULE_1__.pi)) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi)
  ];
}

eckert4Raw.invert = function(x, y) {
  var A = y * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)((4 + _math_js__WEBPACK_IMPORTED_MODULE_1__.pi) / _math_js__WEBPACK_IMPORTED_MODULE_1__.pi) / 2,
      k = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(A),
      c = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(k);
  return [
    x / (2 / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(_math_js__WEBPACK_IMPORTED_MODULE_1__.pi * (4 + _math_js__WEBPACK_IMPORTED_MODULE_1__.pi)) * (1 + c)),
    (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)((k + A * (c + 2)) / (2 + _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi))
  ];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(eckert4Raw)
      .scale(180.739);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/eckert5.js":
/*!*******************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/eckert5.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "eckert5Raw": () => (/* binding */ eckert5Raw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function eckert5Raw(lambda, phi) {
  return [
    lambda * (1 + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi)) / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(2 + _math_js__WEBPACK_IMPORTED_MODULE_1__.pi),
    2 * phi / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(2 + _math_js__WEBPACK_IMPORTED_MODULE_1__.pi)
  ];
}

eckert5Raw.invert = function(x, y) {
  var k = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(2 + _math_js__WEBPACK_IMPORTED_MODULE_1__.pi),
      phi = y * k / 2;
  return [
    k * x / (1 + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi)),
    phi
  ];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(eckert5Raw)
      .scale(173.044);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/eckert6.js":
/*!*******************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/eckert6.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "eckert6Raw": () => (/* binding */ eckert6Raw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function eckert6Raw(lambda, phi) {
  var k = (1 + _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi);
  for (var i = 0, delta = Infinity; i < 10 && (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(delta) > _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon; i++) {
    phi -= delta = (phi + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi) - k) / (1 + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi));
  }
  k = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(2 + _math_js__WEBPACK_IMPORTED_MODULE_1__.pi);
  return [
    lambda * (1 + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi)) / k,
    2 * phi / k
  ];
}

eckert6Raw.invert = function(x, y) {
  var j = 1 + _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi,
      k = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(j / 2);
  return [
    x * 2 * k / (1 + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(y *= k)),
    (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)((y + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(y)) / j)
  ];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(eckert6Raw)
      .scale(173.044);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/eisenlohr.js":
/*!*********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/eisenlohr.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "eisenlohrRaw": () => (/* binding */ eisenlohrRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _august_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./august.js */ "./node_modules/d3-geo-projection/src/august.js");
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");




var eisenlohrK = 3 + 2 * _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt2;

function eisenlohrRaw(lambda, phi) {
  var s0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(lambda /= 2),
      c0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(lambda),
      k = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi)),
      c1 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi /= 2),
      t = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi) / (c1 + _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt2 * c0 * k),
      c = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(2 / (1 + t * t)),
      v = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)((_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt2 * c1 + (c0 + s0) * k) / (_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt2 * c1 + (c0 - s0) * k));
  return [
    eisenlohrK * (c * (v - 1 / v) - 2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.log)(v)),
    eisenlohrK * (c * t * (v + 1 / v) - 2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan)(t))
  ];
}

eisenlohrRaw.invert = function(x, y) {
  if (!(p = _august_js__WEBPACK_IMPORTED_MODULE_2__.augustRaw.invert(x / 1.2, y * 1.065))) return null;
  var lambda = p[0], phi = p[1], i = 20, p;
  x /= eisenlohrK, y /= eisenlohrK;
  do {
    var _0 = lambda / 2,
        _1 = phi / 2,
        s0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(_0),
        c0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(_0),
        s1 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(_1),
        c1 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(_1),
        cos1 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi),
        k = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(cos1),
        t = s1 / (c1 + _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt2 * c0 * k),
        t2 = t * t,
        c = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(2 / (1 + t2)),
        v0 = (_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt2 * c1 + (c0 + s0) * k),
        v1 = (_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt2 * c1 + (c0 - s0) * k),
        v2 = v0 / v1,
        v = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(v2),
        vm1v = v - 1 / v,
        vp1v = v + 1 / v,
        fx = c * vm1v - 2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.log)(v) - x,
        fy = c * t * vp1v - 2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan)(t) - y,
        deltatDeltaLambda = s1 && _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt1_2 * k * s0 * t2 / s1,
        deltatDeltaPhi = (_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt2 * c0 * c1 + k) / (2 * (c1 + _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt2 * c0 * k) * (c1 + _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt2 * c0 * k) * k),
        deltacDeltat = -0.5 * t * c * c * c,
        deltacDeltaLambda = deltacDeltat * deltatDeltaLambda,
        deltacDeltaPhi = deltacDeltat * deltatDeltaPhi,
        A = (A = 2 * c1 + _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt2 * k * (c0 - s0)) * A * v,
        deltavDeltaLambda = (_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt2 * c0 * c1 * k + cos1) / A,
        deltavDeltaPhi = -(_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt2 * s0 * s1) / (k * A),
        deltaxDeltaLambda = vm1v * deltacDeltaLambda - 2 * deltavDeltaLambda / v + c * (deltavDeltaLambda + deltavDeltaLambda / v2),
        deltaxDeltaPhi = vm1v * deltacDeltaPhi - 2 * deltavDeltaPhi / v + c * (deltavDeltaPhi + deltavDeltaPhi / v2),
        deltayDeltaLambda = t * vp1v * deltacDeltaLambda - 2 * deltatDeltaLambda / (1 + t2) + c * vp1v * deltatDeltaLambda + c * t * (deltavDeltaLambda - deltavDeltaLambda / v2),
        deltayDeltaPhi = t * vp1v * deltacDeltaPhi - 2 * deltatDeltaPhi / (1 + t2) + c * vp1v * deltatDeltaPhi + c * t * (deltavDeltaPhi - deltavDeltaPhi / v2),
        denominator = deltaxDeltaPhi * deltayDeltaLambda - deltayDeltaPhi * deltaxDeltaLambda;
    if (!denominator) break;
    var deltaLambda = (fy * deltaxDeltaPhi - fx * deltayDeltaPhi) / denominator,
        deltaPhi = (fx * deltayDeltaLambda - fy * deltaxDeltaLambda) / denominator;
    lambda -= deltaLambda;
    phi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.max)(-_math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi, (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.min)(_math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi, phi - deltaPhi));
  } while (((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(deltaLambda) > _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon || (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(deltaPhi) > _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon) && --i > 0);
  return (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(phi) - _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi) < _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon ? [0, phi] : i && [lambda, phi];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(eisenlohrRaw)
      .scale(62.5271);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/elliptic.js":
/*!********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/elliptic.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ellipticF": () => (/* binding */ ellipticF),
/* harmony export */   "ellipticFi": () => (/* binding */ ellipticFi),
/* harmony export */   "ellipticJ": () => (/* binding */ ellipticJ),
/* harmony export */   "ellipticJi": () => (/* binding */ ellipticJi)
/* harmony export */ });
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");


// Returns [sn, cn, dn](u + iv|m).
function ellipticJi(u, v, m) {
  var a, b, c;
  if (!u) {
    b = ellipticJ(v, 1 - m);
    return [
      [0, b[0] / b[1]],
      [1 / b[1], 0],
      [b[2] / b[1], 0]
    ];
  }
  a = ellipticJ(u, m);
  if (!v) return [[a[0], 0], [a[1], 0], [a[2], 0]];
  b = ellipticJ(v, 1 - m);
  c = b[1] * b[1] + m * a[0] * a[0] * b[0] * b[0];
  return [
    [a[0] * b[2] / c, a[1] * a[2] * b[0] * b[1] / c],
    [a[1] * b[1] / c, -a[0] * a[2] * b[0] * b[2] / c],
    [a[2] * b[1] * b[2] / c, -m * a[0] * a[1] * b[0] / c]
  ];
}

// Returns [sn, cn, dn, ph](u|m).
function ellipticJ(u, m) {
  var ai, b, phi, t, twon;
  if (m < _math_js__WEBPACK_IMPORTED_MODULE_0__.epsilon) {
    t = (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sin)(u);
    b = (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.cos)(u);
    ai = m * (u - t * b) / 4;
    return [
      t - ai * b,
      b + ai * t,
      1 - m * t * t / 2,
      u - ai
    ];
  }
  if (m >= 1 - _math_js__WEBPACK_IMPORTED_MODULE_0__.epsilon) {
    ai = (1 - m) / 4;
    b = (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.cosh)(u);
    t = (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.tanh)(u);
    phi = 1 / b;
    twon = b * (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sinh)(u);
    return [
      t + ai * (twon - u) / (b * b),
      phi - ai * t * phi * (twon - u),
      phi + ai * t * phi * (twon + u),
      2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.atan)((0,_math_js__WEBPACK_IMPORTED_MODULE_0__.exp)(u)) - _math_js__WEBPACK_IMPORTED_MODULE_0__.halfPi + ai * (twon - u) / b
    ];
  }

  var a = [1, 0, 0, 0, 0, 0, 0, 0, 0],
      c = [(0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sqrt)(m), 0, 0, 0, 0, 0, 0, 0, 0],
      i = 0;
  b = (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sqrt)(1 - m);
  twon = 1;

  while ((0,_math_js__WEBPACK_IMPORTED_MODULE_0__.abs)(c[i] / a[i]) > _math_js__WEBPACK_IMPORTED_MODULE_0__.epsilon && i < 8) {
    ai = a[i++];
    c[i] = (ai - b) / 2;
    a[i] = (ai + b) / 2;
    b = (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sqrt)(ai * b);
    twon *= 2;
  }

  phi = twon * a[i] * u;
  do {
    t = c[i] * (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sin)(b = phi) / a[i];
    phi = ((0,_math_js__WEBPACK_IMPORTED_MODULE_0__.asin)(t) + phi) / 2;
  } while (--i);

  return [(0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sin)(phi), t = (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.cos)(phi), t / (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.cos)(phi - b), phi];
}

// Calculate F(phi+iPsi|m).
// See Abramowitz and Stegun, 17.4.11.
function ellipticFi(phi, psi, m) {
  var r = (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.abs)(phi),
      i = (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.abs)(psi),
      sinhPsi = (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sinh)(i);
  if (r) {
    var cscPhi = 1 / (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sin)(r),
        cotPhi2 = 1 / ((0,_math_js__WEBPACK_IMPORTED_MODULE_0__.tan)(r) * (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.tan)(r)),
        b = -(cotPhi2 + m * (sinhPsi * sinhPsi * cscPhi * cscPhi) - 1 + m),
        c = (m - 1) * cotPhi2,
        cotLambda2 = (-b + (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sqrt)(b * b - 4 * c)) / 2;
    return [
      ellipticF((0,_math_js__WEBPACK_IMPORTED_MODULE_0__.atan)(1 / (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sqrt)(cotLambda2)), m) * (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sign)(phi),
      ellipticF((0,_math_js__WEBPACK_IMPORTED_MODULE_0__.atan)((0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sqrt)((cotLambda2 / cotPhi2 - 1) / m)), 1 - m) * (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sign)(psi)
    ];
  }
  return [
    0,
    ellipticF((0,_math_js__WEBPACK_IMPORTED_MODULE_0__.atan)(sinhPsi), 1 - m) * (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sign)(psi)
  ];
}

// Calculate F(phi|m) where m = k² = sin²α.
// See Abramowitz and Stegun, 17.6.7.
function ellipticF(phi, m) {
  if (!m) return phi;
  if (m === 1) return (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.log)((0,_math_js__WEBPACK_IMPORTED_MODULE_0__.tan)(phi / 2 + _math_js__WEBPACK_IMPORTED_MODULE_0__.quarterPi));
  var a = 1,
      b = (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sqrt)(1 - m),
      c = (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sqrt)(m);
  for (var i = 0; (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.abs)(c) > _math_js__WEBPACK_IMPORTED_MODULE_0__.epsilon; i++) {
    if (phi % _math_js__WEBPACK_IMPORTED_MODULE_0__.pi) {
      var dPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.atan)(b * (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.tan)(phi) / a);
      if (dPhi < 0) dPhi += _math_js__WEBPACK_IMPORTED_MODULE_0__.pi;
      phi += dPhi + ~~(phi / _math_js__WEBPACK_IMPORTED_MODULE_0__.pi) * _math_js__WEBPACK_IMPORTED_MODULE_0__.pi;
    } else phi += phi;
    c = (a + b) / 2;
    b = (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sqrt)(a * b);
    c = ((a = c) - b) / 2;
  }
  return phi / ((0,_math_js__WEBPACK_IMPORTED_MODULE_0__.pow)(2, i) * a);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/fahey.js":
/*!*****************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/fahey.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "faheyRaw": () => (/* binding */ faheyRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



var faheyK = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(35 * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians);

function faheyRaw(lambda, phi) {
  var t = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.tan)(phi / 2);
  return [lambda * faheyK * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(1 - t * t), (1 + faheyK) * t];
}

faheyRaw.invert = function(x, y) {
  var t = y / (1 + faheyK);
  return [x && x / (faheyK * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(1 - t * t)), 2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan)(t)];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(faheyRaw)
      .scale(137.152);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/foucaut.js":
/*!*******************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/foucaut.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "foucautRaw": () => (/* binding */ foucautRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function foucautRaw(lambda, phi) {
  var k = phi / 2, cosk = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(k);
  return [ 2 * lambda / _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrtPi * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi) * cosk * cosk, _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrtPi * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.tan)(k)];
}

foucautRaw.invert = function(x, y) {
  var k = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan)(y / _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrtPi), cosk = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(k), phi = 2 * k;
  return [x * _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrtPi / 2 / ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi) * cosk * cosk), phi];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(foucautRaw)
      .scale(135.264);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/foucautSinusoidal.js":
/*!*****************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/foucautSinusoidal.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "foucautSinusoidalRaw": () => (/* binding */ foucautSinusoidalRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");
/* harmony import */ var _newton_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./newton.js */ "./node_modules/d3-geo-projection/src/newton.js");




function foucautSinusoidalRaw(alpha) {
  var beta = 1 - alpha,
      equatorial = raw(_math_js__WEBPACK_IMPORTED_MODULE_1__.pi, 0)[0] - raw(-_math_js__WEBPACK_IMPORTED_MODULE_1__.pi, 0)[0],
      polar = raw(0, _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi)[1] - raw(0, -_math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi)[1],
      ratio = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(2 * polar / equatorial);

  function raw(lambda, phi) {
    var cosphi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi),
        sinphi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi);
    return [
      cosphi / (beta + alpha * cosphi) * lambda,
      beta * phi + alpha * sinphi
    ];
  }

  function forward(lambda, phi) {
    var p = raw(lambda, phi);
    return [p[0] * ratio, p[1] / ratio];
  }

  function forwardMeridian(phi) {
    return forward(0, phi)[1];
  }

  forward.invert = function(x, y) {
    var phi = (0,_newton_js__WEBPACK_IMPORTED_MODULE_2__.solve)(forwardMeridian, y),
        lambda = x / ratio * (alpha + beta / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi));
    return [lambda, phi];
  };

  return forward;
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  var alpha = 0.5,
      m = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjectionMutator)(foucautSinusoidalRaw),
      p = m(alpha);

  p.alpha = function(_) {
    return arguments.length ? m(alpha = +_) : alpha;
  };

  return p
      .scale(168.725);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/gilbert.js":
/*!*******************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/gilbert.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function gilbertForward(point) {
  return [point[0] / 2, (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.tan)(point[1] / 2 * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians)) * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees];
}

function gilbertInvert(point) {
  return [point[0] * 2, 2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(point[1] * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians)) * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees];
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(projectionType) {
  if (projectionType == null) projectionType = d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoOrthographic;
  var projection = projectionType(),
      equirectangular = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoEquirectangular)().scale(_math_js__WEBPACK_IMPORTED_MODULE_1__.degrees).precision(0).clipAngle(null).translate([0, 0]); // antimeridian cutting

  function gilbert(point) {
    return projection(gilbertForward(point));
  }

  if (projection.invert) gilbert.invert = function(point) {
    return gilbertInvert(projection.invert(point));
  };

  gilbert.stream = function(stream) {
    var s1 = projection.stream(stream), s0 = equirectangular.stream({
      point: function(lambda, phi) { s1.point(lambda / 2, (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.tan)(-phi / 2 * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians)) * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees); },
      lineStart: function() { s1.lineStart(); },
      lineEnd: function() { s1.lineEnd(); },
      polygonStart: function() { s1.polygonStart(); },
      polygonEnd: function() { s1.polygonEnd(); }
    });
    s0.sphere = s1.sphere;
    return s0;
  };

  function property(name) {
    gilbert[name] = function() {
      return arguments.length ? (projection[name].apply(projection, arguments), gilbert) : projection[name]();
    };
  }

  gilbert.rotate = function(_) {
    return arguments.length ? (equirectangular.rotate(_), gilbert) : equirectangular.rotate();
  };

  gilbert.center = function(_) {
    return arguments.length ? (projection.center(gilbertForward(_)), gilbert) : gilbertInvert(projection.center());
  };

  property("angle");
  property("clipAngle");
  property("clipExtent");
  property("fitExtent");
  property("fitHeight");
  property("fitSize");
  property("fitWidth");
  property("scale");
  property("translate");
  property("precision");

  return gilbert
      .scale(249.5);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/gingery.js":
/*!*******************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/gingery.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "gingeryRaw": () => (/* binding */ gingeryRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function gingeryRaw(rho, n) {
  var k = 2 * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi / n,
      rho2 = rho * rho;

  function forward(lambda, phi) {
    var p = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoAzimuthalEquidistantRaw)(lambda, phi),
        x = p[0],
        y = p[1],
        r2 = x * x + y * y;

    if (r2 > rho2) {
      var r = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(r2),
          theta = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)(y, x),
          theta0 = k * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.round)(theta / k),
          alpha = theta - theta0,
          rhoCosAlpha = rho * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(alpha),
          k_ = (rho * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(alpha) - alpha * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(rhoCosAlpha)) / (_math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi - rhoCosAlpha),
          s_ = gingeryLength(alpha, k_),
          e = (_math_js__WEBPACK_IMPORTED_MODULE_1__.pi - rho) / gingeryIntegrate(s_, rhoCosAlpha, _math_js__WEBPACK_IMPORTED_MODULE_1__.pi);

      x = r;
      var i = 50, delta;
      do {
        x -= delta = (rho + gingeryIntegrate(s_, rhoCosAlpha, x) * e - r) / (s_(x) * e);
      } while ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(delta) > _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon && --i > 0);

      y = alpha * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(x);
      if (x < _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi) y -= k_ * (x - _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi);

      var s = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(theta0),
          c = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(theta0);
      p[0] = x * c - y * s;
      p[1] = x * s + y * c;
    }
    return p;
  }

  forward.invert = function(x, y) {
    var r2 = x * x + y * y;
    if (r2 > rho2) {
      var r = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(r2),
          theta = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)(y, x),
          theta0 = k * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.round)(theta / k),
          dTheta = theta - theta0;

      x = r * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(dTheta);
      y = r * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(dTheta);

      var x_halfPi = x - _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi,
          sinx = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(x),
          alpha = y / sinx,
          delta = x < _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi ? Infinity : 0,
          i = 10;

      while (true) {
        var rhosinAlpha = rho * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(alpha),
            rhoCosAlpha = rho * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(alpha),
            sinRhoCosAlpha = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(rhoCosAlpha),
            halfPi_RhoCosAlpha = _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi - rhoCosAlpha,
            k_ = (rhosinAlpha - alpha * sinRhoCosAlpha) / halfPi_RhoCosAlpha,
            s_ = gingeryLength(alpha, k_);

        if ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(delta) < _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon2 || !--i) break;

        alpha -= delta = (alpha * sinx - k_ * x_halfPi - y) / (
          sinx - x_halfPi * 2 * (
            halfPi_RhoCosAlpha * (rhoCosAlpha + alpha * rhosinAlpha * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(rhoCosAlpha) - sinRhoCosAlpha) -
            rhosinAlpha * (rhosinAlpha - alpha * sinRhoCosAlpha)
          ) / (halfPi_RhoCosAlpha * halfPi_RhoCosAlpha));
      }
      r = rho + gingeryIntegrate(s_, rhoCosAlpha, x) * (_math_js__WEBPACK_IMPORTED_MODULE_1__.pi - rho) / gingeryIntegrate(s_, rhoCosAlpha, _math_js__WEBPACK_IMPORTED_MODULE_1__.pi);
      theta = theta0 + alpha;
      x = r * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(theta);
      y = r * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(theta);
    }
    return d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoAzimuthalEquidistantRaw.invert(x, y);
  };

  return forward;
}

function gingeryLength(alpha, k) {
  return function(x) {
    var y_ = alpha * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(x);
    if (x < _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi) y_ -= k;
    return (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(1 + y_ * y_);
  };
}

// Numerical integration: trapezoidal rule.
function gingeryIntegrate(f, a, b) {
  var n = 50,
      h = (b - a) / n,
      s = f(a) + f(b);
  for (var i = 1, x = a; i < n; ++i) s += 2 * f(x += h);
  return s * 0.5 * h;
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  var n = 6,
      rho = 30 * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians,
      cRho = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(rho),
      sRho = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(rho),
      m = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjectionMutator)(gingeryRaw),
      p = m(rho, n),
      stream_ = p.stream,
      epsilon = 1e-2,
      cr = -(0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(epsilon * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians),
      sr = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(epsilon * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians);

  p.radius = function(_) {
    if (!arguments.length) return rho * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees;
    cRho = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(rho = _ * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians);
    sRho = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(rho);
    return m(rho, n);
  };

  p.lobes = function(_) {
    if (!arguments.length) return n;
    return m(rho, n = +_);
  };

  p.stream = function(stream) {
    var rotate = p.rotate(),
        rotateStream = stream_(stream),
        sphereStream = (p.rotate([0, 0]), stream_(stream));
    p.rotate(rotate);
    rotateStream.sphere = function() {
      sphereStream.polygonStart(), sphereStream.lineStart();
      for (var i = 0, delta = 2 * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi / n, phi = 0; i < n; ++i, phi -= delta) {
        sphereStream.point((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)(sr * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi), cr) * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees, (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(sr * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi)) * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees);
        sphereStream.point((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)(sRho * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi - delta / 2), cRho) * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees, (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(sRho * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi - delta / 2)) * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees);
      }
      sphereStream.lineEnd(), sphereStream.polygonEnd();
    };
    return rotateStream;
  };

  return p
      .rotate([90, -40])
      .scale(91.7095)
      .clipAngle(180 - 1e-3);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/ginzburg4.js":
/*!*********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/ginzburg4.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "ginzburg4Raw": () => (/* binding */ ginzburg4Raw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ginzburgPolyconic_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ginzburgPolyconic.js */ "./node_modules/d3-geo-projection/src/ginzburgPolyconic.js");



var ginzburg4Raw = (0,_ginzburgPolyconic_js__WEBPACK_IMPORTED_MODULE_1__["default"])(2.8284, -1.6988, 0.75432, -0.18071, 1.76003, -0.38914, 0.042555);

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(ginzburg4Raw)
      .scale(149.995);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/ginzburg5.js":
/*!*********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/ginzburg5.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "ginzburg5Raw": () => (/* binding */ ginzburg5Raw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ginzburgPolyconic_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ginzburgPolyconic.js */ "./node_modules/d3-geo-projection/src/ginzburgPolyconic.js");



var ginzburg5Raw = (0,_ginzburgPolyconic_js__WEBPACK_IMPORTED_MODULE_1__["default"])(2.583819, -0.835827, 0.170354, -0.038094, 1.543313, -0.411435,0.082742);

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(ginzburg5Raw)
      .scale(153.93);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/ginzburg6.js":
/*!*********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/ginzburg6.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "ginzburg6Raw": () => (/* binding */ ginzburg6Raw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ginzburgPolyconic_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ginzburgPolyconic.js */ "./node_modules/d3-geo-projection/src/ginzburgPolyconic.js");
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");




var ginzburg6Raw = (0,_ginzburgPolyconic_js__WEBPACK_IMPORTED_MODULE_1__["default"])(5 / 6 * _math_js__WEBPACK_IMPORTED_MODULE_2__.pi, -0.62636, -0.0344, 0, 1.3493, -0.05524, 0, 0.045);

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(ginzburg6Raw)
      .scale(130.945);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/ginzburg8.js":
/*!*********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/ginzburg8.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "ginzburg8Raw": () => (/* binding */ ginzburg8Raw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function ginzburg8Raw(lambda, phi) {
  var lambda2 = lambda * lambda,
      phi2 = phi * phi;
  return [
    lambda * (1 - 0.162388 * phi2) * (0.87 - 0.000952426 * lambda2 * lambda2),
    phi * (1 + phi2 / 12)
  ];
}

ginzburg8Raw.invert = function(x, y) {
  var lambda = x,
      phi = y,
      i = 50, delta;
  do {
    var phi2 = phi * phi;
    phi -= delta = (phi * (1 + phi2 / 12) - y) / (1 + phi2 / 4);
  } while ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(delta) > _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon && --i > 0);
  i = 50;
  x /= 1 -0.162388 * phi2;
  do {
    var lambda4 = (lambda4 = lambda * lambda) * lambda4;
    lambda -= delta = (lambda * (0.87 - 0.000952426 * lambda4) - x) / (0.87 - 0.00476213 * lambda4);
  } while ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(delta) > _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon && --i > 0);
  return [lambda, phi];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(ginzburg8Raw)
      .scale(131.747);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/ginzburg9.js":
/*!*********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/ginzburg9.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "ginzburg9Raw": () => (/* binding */ ginzburg9Raw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ginzburgPolyconic_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ginzburgPolyconic.js */ "./node_modules/d3-geo-projection/src/ginzburgPolyconic.js");



var ginzburg9Raw = (0,_ginzburgPolyconic_js__WEBPACK_IMPORTED_MODULE_1__["default"])(2.6516, -0.76534, 0.19123, -0.047094, 1.36289, -0.13965,0.031762);

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(ginzburg9Raw)
      .scale(131.087);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/ginzburgPolyconic.js":
/*!*****************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/ginzburgPolyconic.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(a, b, c, d, e, f, g, h) {
  if (arguments.length < 8) h = 0;

  function forward(lambda, phi) {
    if (!phi) return [a * lambda / _math_js__WEBPACK_IMPORTED_MODULE_0__.pi, 0];
    var phi2 = phi * phi,
        xB = a + phi2 * (b + phi2 * (c + phi2 * d)),
        yB = phi * (e - 1 + phi2 * (f - h + phi2 * g)),
        m = (xB * xB + yB * yB) / (2 * yB),
        alpha = lambda * (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.asin)(xB / m) / _math_js__WEBPACK_IMPORTED_MODULE_0__.pi;
    return [m * (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sin)(alpha), phi * (1 + phi2 * h) + m * (1 - (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.cos)(alpha))];
  }

  forward.invert = function(x, y) {
    var lambda = _math_js__WEBPACK_IMPORTED_MODULE_0__.pi * x / a,
        phi = y,
        deltaLambda, deltaPhi, i = 50;
    do {
      var phi2 = phi * phi,
          xB = a + phi2 * (b + phi2 * (c + phi2 * d)),
          yB = phi * (e - 1 + phi2 * (f - h + phi2 * g)),
          p = xB * xB + yB * yB,
          q = 2 * yB,
          m = p / q,
          m2 = m * m,
          dAlphadLambda = (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.asin)(xB / m) / _math_js__WEBPACK_IMPORTED_MODULE_0__.pi,
          alpha = lambda * dAlphadLambda,
          xB2 = xB * xB,
          dxBdPhi = (2 * b + phi2 * (4 * c + phi2 * 6 * d)) * phi,
          dyBdPhi = e + phi2 * (3 * f + phi2 * 5 * g),
          dpdPhi = 2 * (xB * dxBdPhi + yB * (dyBdPhi - 1)),
          dqdPhi = 2 * (dyBdPhi - 1),
          dmdPhi = (dpdPhi * q - p * dqdPhi) / (q * q),
          cosAlpha = (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.cos)(alpha),
          sinAlpha = (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sin)(alpha),
          mcosAlpha = m * cosAlpha,
          msinAlpha = m * sinAlpha,
          dAlphadPhi = ((lambda / _math_js__WEBPACK_IMPORTED_MODULE_0__.pi) * (1 / (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sqrt)(1 - xB2 / m2)) * (dxBdPhi * m - xB * dmdPhi)) / m2,
          fx = msinAlpha - x,
          fy = phi * (1 + phi2 * h) + m - mcosAlpha - y,
          deltaxDeltaPhi = dmdPhi * sinAlpha + mcosAlpha * dAlphadPhi,
          deltaxDeltaLambda = mcosAlpha * dAlphadLambda,
          deltayDeltaPhi = 1 + dmdPhi - (dmdPhi * cosAlpha - msinAlpha * dAlphadPhi),
          deltayDeltaLambda = msinAlpha * dAlphadLambda,
          denominator = deltaxDeltaPhi * deltayDeltaLambda - deltayDeltaPhi * deltaxDeltaLambda;
      if (!denominator) break;
      lambda -= deltaLambda = (fy * deltaxDeltaPhi - fx * deltayDeltaPhi) / denominator;
      phi -= deltaPhi = (fx * deltayDeltaLambda - fy * deltaxDeltaLambda) / denominator;
    } while (((0,_math_js__WEBPACK_IMPORTED_MODULE_0__.abs)(deltaLambda) > _math_js__WEBPACK_IMPORTED_MODULE_0__.epsilon || (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.abs)(deltaPhi) > _math_js__WEBPACK_IMPORTED_MODULE_0__.epsilon) && --i > 0);
    return [lambda, phi];
  };

  return forward;
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/gringorten.js":
/*!**********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/gringorten.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "gringortenRaw": () => (/* binding */ gringortenRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");
/* harmony import */ var _square_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./square.js */ "./node_modules/d3-geo-projection/src/square.js");




function gringortenRaw(lambda, phi) {
  var sLambda = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(lambda),
      sPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(phi),
      cosPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi),
      x = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(lambda) * cosPhi,
      y = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(lambda) * cosPhi,
      z = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(sPhi * phi);
  lambda = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)(y, z));
  phi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(x);
  if ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(lambda - _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi) > _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon) lambda %= _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi;
  var point = gringortenHexadecant(lambda > _math_js__WEBPACK_IMPORTED_MODULE_1__.pi / 4 ? _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi - lambda : lambda, phi);
  if (lambda > _math_js__WEBPACK_IMPORTED_MODULE_1__.pi / 4) z = point[0], point[0] = -point[1], point[1] = -z;
  return (point[0] *= sLambda, point[1] *= -sPhi, point);
}

gringortenRaw.invert = function(x, y) {
  if ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(x) > 1) x = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(x) * 2 - x;
  if ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(y) > 1) y = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(y) * 2 - y;
  var sx = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(x),
      sy = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(y),
      x0 = -sx * x,
      y0 = -sy * y,
      t = y0 / x0 < 1,
      p = gringortenHexadecantInvert(t ? y0 : x0, t ? x0 : y0),
      lambda = p[0],
      phi = p[1],
      cosPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi);
  if (t) lambda = -_math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi - lambda;
  return [sx * ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(lambda) * cosPhi, -(0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi)) + _math_js__WEBPACK_IMPORTED_MODULE_1__.pi), sy * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(lambda) * cosPhi)];
};

function gringortenHexadecant(lambda, phi) {
  if (phi === _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi) return [0, 0];

  var sinPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi),
      r = sinPhi * sinPhi,
      r2 = r * r,
      j = 1 + r2,
      k = 1 + 3 * r2,
      q = 1 - r2,
      z = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(1 / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(j)),
      v = q + r * j * z,
      p2 = (1 - sinPhi) / v,
      p = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(p2),
      a2 = p2 * j,
      a = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(a2),
      h = p * q,
      x,
      i;

  if (lambda === 0) return [0, -(h + r * a)];

  var cosPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi),
      secPhi = 1 / cosPhi,
      drdPhi = 2 * sinPhi * cosPhi,
      dvdPhi = (-3 * r + z * k) * drdPhi,
      dp2dPhi = (-v * cosPhi - (1 - sinPhi) * dvdPhi) / (v * v),
      dpdPhi = (0.5 * dp2dPhi) / p,
      dhdPhi = q * dpdPhi - 2 * r * p * drdPhi,
      dra2dPhi = r * j * dp2dPhi + p2 * k * drdPhi,
      mu = -secPhi * drdPhi,
      nu = -secPhi * dra2dPhi,
      zeta = -2 * secPhi * dhdPhi,
      lambda1 = 4 * lambda / _math_js__WEBPACK_IMPORTED_MODULE_1__.pi,
      delta;

  // Slower but accurate bisection method.
  if (lambda > 0.222 * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi || phi < _math_js__WEBPACK_IMPORTED_MODULE_1__.pi / 4 && lambda > 0.175 * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi) {
    x = (h + r * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(a2 * (1 + r2) - h * h)) / (1 + r2);
    if (lambda > _math_js__WEBPACK_IMPORTED_MODULE_1__.pi / 4) return [x, x];
    var x1 = x, x0 = 0.5 * x;
    x = 0.5 * (x0 + x1), i = 50;
    do {
      var g = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(a2 - x * x),
          f = (x * (zeta + mu * g) + nu * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(x / a)) - lambda1;
      if (!f) break;
      if (f < 0) x0 = x;
      else x1 = x;
      x = 0.5 * (x0 + x1);
    } while ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(x1 - x0) > _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon && --i > 0);
  }

  // Newton-Raphson.
  else {
    x = _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon, i = 25;
    do {
      var x2 = x * x,
          g2 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(a2 - x2),
          zetaMug = zeta + mu * g2,
          f2 = x * zetaMug + nu * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(x / a) - lambda1,
          df = zetaMug + (nu - mu * x2) / g2;
      x -= delta = g2 ? f2 / df : 0;
    } while ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(delta) > _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon && --i > 0);
  }

  return [x, -h - r * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(a2 - x * x)];
}

function gringortenHexadecantInvert(x, y) {
  var x0 = 0,
      x1 = 1,
      r = 0.5,
      i = 50;

  while (true) {
    var r2 = r * r,
        sinPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(r),
        z = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(1 / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(1 + r2)),
        v = (1 - r2) + r * (1 + r2) * z,
        p2 = (1 - sinPhi) / v,
        p = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(p2),
        a2 = p2 * (1 + r2),
        h = p * (1 - r2),
        g2 = a2 - x * x,
        g = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(g2),
        y0 = y + h + r * g;
    if ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(x1 - x0) < _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon2 || --i === 0 || y0 === 0) break;
    if (y0 > 0) x0 = r;
    else x1 = r;
    r = 0.5 * (x0 + x1);
  }

  if (!i) return null;

  var phi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(sinPhi),
      cosPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi),
      secPhi = 1 / cosPhi,
      drdPhi = 2 * sinPhi * cosPhi,
      dvdPhi = (-3 * r + z * (1 + 3 * r2)) * drdPhi,
      dp2dPhi = (-v * cosPhi - (1 - sinPhi) * dvdPhi) / (v * v),
      dpdPhi = 0.5 * dp2dPhi / p,
      dhdPhi = (1 - r2) * dpdPhi - 2 * r * p * drdPhi,
      zeta = -2 * secPhi * dhdPhi,
      mu = -secPhi * drdPhi,
      nu = -secPhi * (r * (1 + r2) * dp2dPhi + p2 * (1 + 3 * r2) * drdPhi);

  return [_math_js__WEBPACK_IMPORTED_MODULE_1__.pi / 4 * (x * (zeta + mu * g) + nu * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(x / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(a2))), phi];
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)((0,_square_js__WEBPACK_IMPORTED_MODULE_2__["default"])(gringortenRaw))
      .scale(239.75);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/guyou.js":
/*!*****************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/guyou.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "guyouRaw": () => (/* binding */ guyouRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _elliptic_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./elliptic.js */ "./node_modules/d3-geo-projection/src/elliptic.js");
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");
/* harmony import */ var _square_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./square.js */ "./node_modules/d3-geo-projection/src/square.js");





function guyouRaw(lambda, phi) {
  var k_ = (_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt2 - 1) / (_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt2 + 1),
      k = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(1 - k_ * k_),
      K = (0,_elliptic_js__WEBPACK_IMPORTED_MODULE_2__.ellipticF)(_math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi, k * k),
      f = -1,
      psi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.log)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.tan)(_math_js__WEBPACK_IMPORTED_MODULE_1__.pi / 4 + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(phi) / 2)),
      r = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.exp)(f * psi) / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(k_),
      at = guyouComplexAtan(r * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(f * lambda), r * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(f * lambda)),
      t = (0,_elliptic_js__WEBPACK_IMPORTED_MODULE_2__.ellipticFi)(at[0], at[1], k * k);
  return [-t[1], (phi >= 0 ? 1 : -1) * (0.5 * K - t[0])];
}

function guyouComplexAtan(x, y) {
  var x2 = x * x,
      y_1 = y + 1,
      t = 1 - x2 - y * y;
  return [
   0.5 * ((x >= 0 ? _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi : -_math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi) - (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)(t, 2 * x)),
    -0.25 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.log)(t * t + 4 * x2) +0.5 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.log)(y_1 * y_1 + x2)
  ];
}

function guyouComplexDivide(a, b) {
  var denominator = b[0] * b[0] + b[1] * b[1];
  return [
    (a[0] * b[0] + a[1] * b[1]) / denominator,
    (a[1] * b[0] - a[0] * b[1]) / denominator
  ];
}

guyouRaw.invert = function(x, y) {
  var k_ = (_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt2 - 1) / (_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt2 + 1),
      k = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(1 - k_ * k_),
      K = (0,_elliptic_js__WEBPACK_IMPORTED_MODULE_2__.ellipticF)(_math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi, k * k),
      f = -1,
      j = (0,_elliptic_js__WEBPACK_IMPORTED_MODULE_2__.ellipticJi)(0.5 * K - y, -x, k * k),
      tn = guyouComplexDivide(j[0], j[1]),
      lambda = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)(tn[1], tn[0]) / f;
  return [
    lambda,
    2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.exp)(0.5 / f * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.log)(k_ * tn[0] * tn[0] + k_ * tn[1] * tn[1]))) - _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi
  ];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)((0,_square_js__WEBPACK_IMPORTED_MODULE_3__["default"])(guyouRaw))
      .scale(151.496);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/hammer.js":
/*!******************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/hammer.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "hammerRaw": () => (/* binding */ hammerRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function hammerRaw(A, B) {
  if (arguments.length < 2) B = A;
  if (B === 1) return d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoAzimuthalEqualAreaRaw;
  if (B === Infinity) return hammerQuarticAuthalicRaw;

  function forward(lambda, phi) {
    var coordinates = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoAzimuthalEqualAreaRaw)(lambda / B, phi);
    coordinates[0] *= A;
    return coordinates;
  }

  forward.invert = function(x, y) {
    var coordinates = d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoAzimuthalEqualAreaRaw.invert(x / A, y);
    coordinates[0] *= B;
    return coordinates;
  };

  return forward;
}

function hammerQuarticAuthalicRaw(lambda, phi) {
  return [
    lambda * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi) / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi /= 2),
    2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi)
  ];
}

hammerQuarticAuthalicRaw.invert = function(x, y) {
  var phi = 2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(y / 2);
  return [
    x * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi / 2) / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi),
    phi
  ];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  var B = 2,
      m = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjectionMutator)(hammerRaw),
      p = m(B);

  p.coefficient = function(_) {
    if (!arguments.length) return B;
    return m(B = +_);
  };

  return p
    .scale(169.529);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/hammerRetroazimuthal.js":
/*!********************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/hammerRetroazimuthal.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "hammerRetroazimuthalRaw": () => (/* binding */ hammerRetroazimuthalRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function hammerRetroazimuthalRaw(phi0) {
  var sinPhi0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi0),
      cosPhi0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi0),
      rotate = hammerRetroazimuthalRotation(phi0);

  rotate.invert = hammerRetroazimuthalRotation(-phi0);

  function forward(lambda, phi) {
    var p = rotate(lambda, phi);
    lambda = p[0], phi = p[1];
    var sinPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi),
        cosPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi),
        cosLambda = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(lambda),
        z = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.acos)(sinPhi0 * sinPhi + cosPhi0 * cosPhi * cosLambda),
        sinz = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(z),
        K = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(sinz) > _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon ? z / sinz : 1;
    return [
      K * cosPhi0 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(lambda),
      ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(lambda) > _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi ? K : -K) // rotate for back hemisphere
        * (sinPhi0 * cosPhi - cosPhi0 * sinPhi * cosLambda)
    ];
  }

  forward.invert = function(x, y) {
    var rho = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(x * x + y * y),
        sinz = -(0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(rho),
        cosz = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(rho),
        a = rho * cosz,
        b = -y * sinz,
        c = rho * sinPhi0,
        d = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(a * a + b * b - c * c),
        phi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)(a * c + b * d, b * c - a * d),
        lambda = (rho > _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi ? -1 : 1) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)(x * sinz, rho * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi) * cosz + y * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi) * sinz);
    return rotate.invert(lambda, phi);
  };

  return forward;
}

// Latitudinal rotation by phi0.
// Temporary hack until D3 supports arbitrary small-circle clipping origins.
function hammerRetroazimuthalRotation(phi0) {
  var sinPhi0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi0),
      cosPhi0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi0);

  return function(lambda, phi) {
    var cosPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi),
        x = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(lambda) * cosPhi,
        y = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(lambda) * cosPhi,
        z = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi);
    return [
      (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)(y, x * cosPhi0 - z * sinPhi0),
      (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(z * cosPhi0 + x * sinPhi0)
    ];
  };
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  var phi0 = 0,
      m = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjectionMutator)(hammerRetroazimuthalRaw),
      p = m(phi0),
      rotate_ = p.rotate,
      stream_ = p.stream,
      circle = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoCircle)();

  p.parallel = function(_) {
    if (!arguments.length) return phi0 * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees;
    var r = p.rotate();
    return m(phi0 = _ * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians).rotate(r);
  };

  // Temporary hack; see hammerRetroazimuthalRotation.
  p.rotate = function(_) {
    if (!arguments.length) return (_ = rotate_.call(p), _[1] += phi0 * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees, _);
    rotate_.call(p, [_[0], _[1] - phi0 * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees]);
    circle.center([-_[0], -_[1]]);
    return p;
  };

  p.stream = function(stream) {
    stream = stream_(stream);
    stream.sphere = function() {
      stream.polygonStart();
      var epsilon = 1e-2,
          ring = circle.radius(90 - epsilon)().coordinates[0],
          n = ring.length - 1,
          i = -1,
          p;
      stream.lineStart();
      while (++i < n) stream.point((p = ring[i])[0], p[1]);
      stream.lineEnd();
      ring = circle.radius(90 + epsilon)().coordinates[0];
      n = ring.length - 1;
      stream.lineStart();
      while (--i >= 0) stream.point((p = ring[i])[0], p[1]);
      stream.lineEnd();
      stream.polygonEnd();
    };
    return stream;
  };

  return p
      .scale(79.4187)
      .parallel(45)
      .clipAngle(180 - 1e-3);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/healpix.js":
/*!*******************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/healpix.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "healpixRaw": () => (/* binding */ healpixRaw)
/* harmony export */ });
/* harmony import */ var d3_array__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! d3-array */ "./node_modules/d3-array/src/range.js");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _collignon_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./collignon.js */ "./node_modules/d3-geo-projection/src/collignon.js");
/* harmony import */ var _cylindricalEqualArea_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./cylindricalEqualArea.js */ "./node_modules/d3-geo-projection/src/cylindricalEqualArea.js");
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");






var K = 3,
    healpixParallel = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(1 - 1 / K) * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees,
    healpixLambert = (0,_cylindricalEqualArea_js__WEBPACK_IMPORTED_MODULE_2__.cylindricalEqualAreaRaw)(0);

function healpixRaw(H) {
  var phi0 = healpixParallel * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians,
      dx = (0,_collignon_js__WEBPACK_IMPORTED_MODULE_3__.collignonRaw)(_math_js__WEBPACK_IMPORTED_MODULE_1__.pi, phi0)[0] - (0,_collignon_js__WEBPACK_IMPORTED_MODULE_3__.collignonRaw)(-_math_js__WEBPACK_IMPORTED_MODULE_1__.pi, phi0)[0],
      y0 = healpixLambert(0, phi0)[1],
      y1 = (0,_collignon_js__WEBPACK_IMPORTED_MODULE_3__.collignonRaw)(0, phi0)[1],
      dy1 = _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrtPi - y1,
      k = _math_js__WEBPACK_IMPORTED_MODULE_1__.tau / H,
      w = 4 / _math_js__WEBPACK_IMPORTED_MODULE_1__.tau,
      h = y0 + (dy1 * dy1 * 4) / _math_js__WEBPACK_IMPORTED_MODULE_1__.tau;

  function forward(lambda, phi) {
    var point,
        phi2 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(phi);
    if (phi2 > phi0) {
      var i = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.min)(H - 1, (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.max)(0, (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.floor)((lambda + _math_js__WEBPACK_IMPORTED_MODULE_1__.pi) / k)));
      lambda += _math_js__WEBPACK_IMPORTED_MODULE_1__.pi * (H - 1) / H - i * k;
      point = (0,_collignon_js__WEBPACK_IMPORTED_MODULE_3__.collignonRaw)(lambda, phi2);
      point[0] = point[0] * _math_js__WEBPACK_IMPORTED_MODULE_1__.tau / dx - _math_js__WEBPACK_IMPORTED_MODULE_1__.tau * (H - 1) / (2 * H) + i * _math_js__WEBPACK_IMPORTED_MODULE_1__.tau / H;
      point[1] = y0 + (point[1] - y1) * 4 * dy1 / _math_js__WEBPACK_IMPORTED_MODULE_1__.tau;
      if (phi < 0) point[1] = -point[1];
    } else {
      point = healpixLambert(lambda, phi);
    }
    point[0] *= w, point[1] /= h;
    return point;
  }

  forward.invert = function(x, y) {
    x /= w, y *= h;
    var y2 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(y);
    if (y2 > y0) {
      var i = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.min)(H - 1, (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.max)(0, (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.floor)((x + _math_js__WEBPACK_IMPORTED_MODULE_1__.pi) / k)));
      x = (x + _math_js__WEBPACK_IMPORTED_MODULE_1__.pi * (H - 1) / H - i * k) * dx / _math_js__WEBPACK_IMPORTED_MODULE_1__.tau;
      var point = _collignon_js__WEBPACK_IMPORTED_MODULE_3__.collignonRaw.invert(x, 0.25 * (y2 - y0) * _math_js__WEBPACK_IMPORTED_MODULE_1__.tau / dy1 + y1);
      point[0] -= _math_js__WEBPACK_IMPORTED_MODULE_1__.pi * (H - 1) / H - i * k;
      if (y < 0) point[1] = -point[1];
      return point;
    }
    return healpixLambert.invert(x, y);
  };

  return forward;
}

function sphereTop(x, i) {
  return [x, i & 1 ? 90 - _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon : healpixParallel];
}

function sphereBottom(x, i) {
  return [x, i & 1 ? -90 + _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon : -healpixParallel];
}

function sphereNudge(d) {
  return [d[0] * (1 - _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon), d[1]];
}

function sphere(step) {
  var c = [].concat(
    (0,d3_array__WEBPACK_IMPORTED_MODULE_4__["default"])(-180, 180 + step / 2, step).map(sphereTop),
    (0,d3_array__WEBPACK_IMPORTED_MODULE_4__["default"])(180, -180 - step / 2, -step).map(sphereBottom)
  );
  return {
    type: "Polygon",
    coordinates: [step === 180 ? c.map(sphereNudge) : c]
  };
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  var H = 4,
      m = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjectionMutator)(healpixRaw),
      p = m(H),
      stream_ = p.stream;

  p.lobes = function(_) {
    return arguments.length ? m(H = +_) : H;
  };

  p.stream = function(stream) {
    var rotate = p.rotate(),
        rotateStream = stream_(stream),
        sphereStream = (p.rotate([0, 0]), stream_(stream));
    p.rotate(rotate);
    rotateStream.sphere = function() { (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoStream)(sphere(180 / H), sphereStream); };
    return rotateStream;
  };

  return p
      .scale(239.75);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/hill.js":
/*!****************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/hill.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "hillRaw": () => (/* binding */ hillRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function hillRaw(K) {
  var L = 1 + K,
      sinBt = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(1 / L),
      Bt = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(sinBt),
      A = 2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(_math_js__WEBPACK_IMPORTED_MODULE_1__.pi / (B = _math_js__WEBPACK_IMPORTED_MODULE_1__.pi + 4 * Bt * L)),
      B,
      rho0 = 0.5 * A * (L + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(K * (2 + K))),
      K2 = K * K,
      L2 = L * L;

  function forward(lambda, phi) {
    var t = 1 - (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi),
        rho,
        omega;
    if (t && t < 2) {
      var theta = _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi - phi, i = 25, delta;
      do {
        var sinTheta = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(theta),
            cosTheta = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(theta),
            Bt_Bt1 = Bt + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)(sinTheta, L - cosTheta),
            C = 1 + L2 - 2 * L * cosTheta;
        theta -= delta = (theta - K2 * Bt - L * sinTheta + C * Bt_Bt1 -0.5 * t * B) / (2 * L * sinTheta * Bt_Bt1);
      } while ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(delta) > _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon2 && --i > 0);
      rho = A * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(C);
      omega = lambda * Bt_Bt1 / _math_js__WEBPACK_IMPORTED_MODULE_1__.pi;
    } else {
      rho = A * (K + t);
      omega = lambda * Bt / _math_js__WEBPACK_IMPORTED_MODULE_1__.pi;
    }
    return [
      rho * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(omega),
      rho0 - rho * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(omega)
    ];
  }

  forward.invert = function(x, y) {
    var rho2 = x * x + (y -= rho0) * y,
        cosTheta = (1 + L2 - rho2 / (A * A)) / (2 * L),
        theta = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.acos)(cosTheta),
        sinTheta = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(theta),
        Bt_Bt1 = Bt + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)(sinTheta, L - cosTheta);
    return [
      (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(x / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(rho2)) * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi / Bt_Bt1,
      (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(1 - 2 * (theta - K2 * Bt - L * sinTheta + (1 + L2 - 2 * L * cosTheta) * Bt_Bt1) / B)
    ];
  };

  return forward;
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  var K = 1,
      m = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjectionMutator)(hillRaw),
      p = m(K);

  p.ratio = function(_) {
    return arguments.length ? m(K = +_) : K;
  };

  return p
      .scale(167.774)
      .center([0, 18.67]);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/homolosine.js":
/*!**********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/homolosine.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "homolosineRaw": () => (/* binding */ homolosineRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");
/* harmony import */ var _mollweide_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./mollweide.js */ "./node_modules/d3-geo-projection/src/mollweide.js");
/* harmony import */ var _sinusoidal_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./sinusoidal.js */ "./node_modules/d3-geo-projection/src/sinusoidal.js");
/* harmony import */ var _sinuMollweide_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sinuMollweide.js */ "./node_modules/d3-geo-projection/src/sinuMollweide.js");






function homolosineRaw(lambda, phi) {
  return (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(phi) > _sinuMollweide_js__WEBPACK_IMPORTED_MODULE_2__.sinuMollweidePhi
      ? (lambda = (0,_mollweide_js__WEBPACK_IMPORTED_MODULE_3__.mollweideRaw)(lambda, phi), lambda[1] -= phi > 0 ? _sinuMollweide_js__WEBPACK_IMPORTED_MODULE_2__.sinuMollweideY : -_sinuMollweide_js__WEBPACK_IMPORTED_MODULE_2__.sinuMollweideY, lambda)
      : (0,_sinusoidal_js__WEBPACK_IMPORTED_MODULE_4__.sinusoidalRaw)(lambda, phi);
}

homolosineRaw.invert = function(x, y) {
  return (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(y) > _sinuMollweide_js__WEBPACK_IMPORTED_MODULE_2__.sinuMollweidePhi
      ? _mollweide_js__WEBPACK_IMPORTED_MODULE_3__.mollweideRaw.invert(x, y + (y > 0 ? _sinuMollweide_js__WEBPACK_IMPORTED_MODULE_2__.sinuMollweideY : -_sinuMollweide_js__WEBPACK_IMPORTED_MODULE_2__.sinuMollweideY))
      : _sinusoidal_js__WEBPACK_IMPORTED_MODULE_4__.sinusoidalRaw.invert(x, y);
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(homolosineRaw)
      .scale(152.63);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/hufnagel.js":
/*!********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/hufnagel.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "hufnagelRaw": () => (/* binding */ hufnagelRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");
/* harmony import */ var _newton_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./newton.js */ "./node_modules/d3-geo-projection/src/newton.js");




function hufnagelRaw(a, b, psiMax, ratio) {
  var k = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(
      (4 * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi) /
        (2 * psiMax +
          (1 + a - b / 2) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(2 * psiMax) +
          ((a + b) / 2) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(4 * psiMax) +
          (b / 2) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(6 * psiMax))
    ),
    c = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(
      ratio *
        (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(psiMax) *
        (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)((1 + a * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(2 * psiMax) + b * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(4 * psiMax)) / (1 + a + b))
    ),
    M = psiMax * mapping(1);

  function radius(psi) {
    return (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(1 + a * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(2 * psi) + b * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(4 * psi));
  }

  function mapping(t) {
    var psi = t * psiMax;
    return (
      (2 * psi +
        (1 + a - b / 2) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(2 * psi) +
        ((a + b) / 2) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(4 * psi) +
        (b / 2) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(6 * psi)) /
      psiMax
    );
  }

  function inversemapping(psi) {
    return radius(psi) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(psi);
  }

  var forward = function(lambda, phi) {
    var psi = psiMax * (0,_newton_js__WEBPACK_IMPORTED_MODULE_2__.solve)(mapping, (M * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi)) / psiMax, phi / _math_js__WEBPACK_IMPORTED_MODULE_1__.pi);
    if (isNaN(psi)) psi = psiMax * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(phi);
    var kr = k * radius(psi);
    return [((kr * c * lambda) / _math_js__WEBPACK_IMPORTED_MODULE_1__.pi) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(psi), (kr / c) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(psi)];
  };

  forward.invert = function(x, y) {
    var psi = (0,_newton_js__WEBPACK_IMPORTED_MODULE_2__.solve)(inversemapping, (y * c) / k);
    return [
      (x * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi) / ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(psi) * k * c * radius(psi)),
      (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)((psiMax * mapping(psi / psiMax)) / M)
    ];
  };

  if (psiMax === 0) {
    k = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(ratio / _math_js__WEBPACK_IMPORTED_MODULE_1__.pi);
    forward = function(lambda, phi) {
      return [lambda * k, (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi) / k];
    };
    forward.invert = function(x, y) {
      return [x / k, (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(y * k)];
    };
  }

  return forward;
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  var a = 1,
    b = 0,
    psiMax = 45 * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians,
    ratio = 2,
    mutate = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjectionMutator)(hufnagelRaw),
    projection = mutate(a, b, psiMax, ratio);

  projection.a = function(_) {
    return arguments.length ? mutate((a = +_), b, psiMax, ratio) : a;
  };
  projection.b = function(_) {
    return arguments.length ? mutate(a, (b = +_), psiMax, ratio) : b;
  };
  projection.psiMax = function(_) {
    return arguments.length
      ? mutate(a, b, (psiMax = +_ * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians), ratio)
      : psiMax * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees;
  };
  projection.ratio = function(_) {
    return arguments.length ? mutate(a, b, psiMax, (ratio = +_)) : ratio;
  };

  return projection.scale(180.739);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/hyperelliptical.js":
/*!***************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/hyperelliptical.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "hyperellipticalRaw": () => (/* binding */ hyperellipticalRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");
/* harmony import */ var _integrate_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./integrate.js */ "./node_modules/d3-geo-projection/src/integrate.js");




function hyperellipticalRaw(alpha, k, gamma) {

  function elliptic (f) {
    return alpha + (1 - alpha) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.pow)(1 - (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.pow)(f, k), 1 / k);
  }

  function z(f) {
    return (0,_integrate_js__WEBPACK_IMPORTED_MODULE_2__.integrate)(elliptic, 0, f, 1e-4);
  }

  var G = 1 / z(1),
      n = 1000,
      m = (1 + 1e-8) * G,
      approx = [];
  for (var i = 0; i <= n; i++)
      approx.push(z(i / n) * m);

  function Y(sinphi) {
    var rmin = 0, rmax = n, r = n >> 1;
    do {
      if (approx[r] > sinphi) rmax = r; else rmin = r;
      r = (rmin + rmax) >> 1;
    } while (r > rmin);
    var u = approx[r + 1] - approx[r];
    if (u) u = (sinphi - approx[r + 1]) / u;
    return (r + 1 + u) / n;
  }

  var ratio = 2 * Y(1) / _math_js__WEBPACK_IMPORTED_MODULE_1__.pi * G / gamma;

  var forward = function(lambda, phi) {
    var y = Y((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi))),
        x = elliptic(y) * lambda;
    y /= ratio;
    return [ x, (phi >= 0) ? y : -y ];
  };

  forward.invert = function(x, y) {
    var phi;
    y *= ratio;
    if ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(y) < 1) phi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(y) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(z((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(y)) * G);
    return [ x / elliptic((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(y)), phi ];
  };

  return forward;
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  var alpha = 0,
      k = 2.5,
      gamma = 1.183136, // affine = sqrt(2 * gamma / pi) = 0.8679
      m = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjectionMutator)(hyperellipticalRaw),
      p = m(alpha, k, gamma);

  p.alpha = function(_) {
    return arguments.length ? m(alpha = +_, k, gamma) : alpha;
  };

  p.k = function(_) {
    return arguments.length ? m(alpha, k = +_, gamma) : k;
  };

  p.gamma = function(_) {
    return arguments.length ? m(alpha, k, gamma = +_) : gamma;
  };

  return p
      .scale(152.63);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/index.js":
/*!*****************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "geoAiry": () => (/* reexport safe */ _airy_js__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   "geoAiryRaw": () => (/* reexport safe */ _airy_js__WEBPACK_IMPORTED_MODULE_0__.airyRaw),
/* harmony export */   "geoAitoff": () => (/* reexport safe */ _aitoff_js__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   "geoAitoffRaw": () => (/* reexport safe */ _aitoff_js__WEBPACK_IMPORTED_MODULE_1__.aitoffRaw),
/* harmony export */   "geoArmadillo": () => (/* reexport safe */ _armadillo_js__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   "geoArmadilloRaw": () => (/* reexport safe */ _armadillo_js__WEBPACK_IMPORTED_MODULE_2__.armadilloRaw),
/* harmony export */   "geoAugust": () => (/* reexport safe */ _august_js__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   "geoAugustRaw": () => (/* reexport safe */ _august_js__WEBPACK_IMPORTED_MODULE_3__.augustRaw),
/* harmony export */   "geoBaker": () => (/* reexport safe */ _baker_js__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   "geoBakerRaw": () => (/* reexport safe */ _baker_js__WEBPACK_IMPORTED_MODULE_4__.bakerRaw),
/* harmony export */   "geoBerghaus": () => (/* reexport safe */ _berghaus_js__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   "geoBerghausRaw": () => (/* reexport safe */ _berghaus_js__WEBPACK_IMPORTED_MODULE_5__.berghausRaw),
/* harmony export */   "geoBertin1953": () => (/* reexport safe */ _bertin_js__WEBPACK_IMPORTED_MODULE_6__["default"]),
/* harmony export */   "geoBertin1953Raw": () => (/* reexport safe */ _bertin_js__WEBPACK_IMPORTED_MODULE_6__.bertin1953Raw),
/* harmony export */   "geoBoggs": () => (/* reexport safe */ _boggs_js__WEBPACK_IMPORTED_MODULE_7__["default"]),
/* harmony export */   "geoBoggsRaw": () => (/* reexport safe */ _boggs_js__WEBPACK_IMPORTED_MODULE_7__.boggsRaw),
/* harmony export */   "geoBonne": () => (/* reexport safe */ _bonne_js__WEBPACK_IMPORTED_MODULE_8__["default"]),
/* harmony export */   "geoBonneRaw": () => (/* reexport safe */ _bonne_js__WEBPACK_IMPORTED_MODULE_8__.bonneRaw),
/* harmony export */   "geoBottomley": () => (/* reexport safe */ _bottomley_js__WEBPACK_IMPORTED_MODULE_9__["default"]),
/* harmony export */   "geoBottomleyRaw": () => (/* reexport safe */ _bottomley_js__WEBPACK_IMPORTED_MODULE_9__.bottomleyRaw),
/* harmony export */   "geoBromley": () => (/* reexport safe */ _bromley_js__WEBPACK_IMPORTED_MODULE_10__["default"]),
/* harmony export */   "geoBromleyRaw": () => (/* reexport safe */ _bromley_js__WEBPACK_IMPORTED_MODULE_10__.bromleyRaw),
/* harmony export */   "geoChamberlin": () => (/* reexport safe */ _chamberlin_js__WEBPACK_IMPORTED_MODULE_11__["default"]),
/* harmony export */   "geoChamberlinAfrica": () => (/* reexport safe */ _chamberlin_js__WEBPACK_IMPORTED_MODULE_11__.chamberlinAfrica),
/* harmony export */   "geoChamberlinRaw": () => (/* reexport safe */ _chamberlin_js__WEBPACK_IMPORTED_MODULE_11__.chamberlinRaw),
/* harmony export */   "geoCollignon": () => (/* reexport safe */ _collignon_js__WEBPACK_IMPORTED_MODULE_12__["default"]),
/* harmony export */   "geoCollignonRaw": () => (/* reexport safe */ _collignon_js__WEBPACK_IMPORTED_MODULE_12__.collignonRaw),
/* harmony export */   "geoCraig": () => (/* reexport safe */ _craig_js__WEBPACK_IMPORTED_MODULE_13__["default"]),
/* harmony export */   "geoCraigRaw": () => (/* reexport safe */ _craig_js__WEBPACK_IMPORTED_MODULE_13__.craigRaw),
/* harmony export */   "geoCraster": () => (/* reexport safe */ _craster_js__WEBPACK_IMPORTED_MODULE_14__["default"]),
/* harmony export */   "geoCrasterRaw": () => (/* reexport safe */ _craster_js__WEBPACK_IMPORTED_MODULE_14__.crasterRaw),
/* harmony export */   "geoCylindricalEqualArea": () => (/* reexport safe */ _cylindricalEqualArea_js__WEBPACK_IMPORTED_MODULE_15__["default"]),
/* harmony export */   "geoCylindricalEqualAreaRaw": () => (/* reexport safe */ _cylindricalEqualArea_js__WEBPACK_IMPORTED_MODULE_15__.cylindricalEqualAreaRaw),
/* harmony export */   "geoCylindricalStereographic": () => (/* reexport safe */ _cylindricalStereographic_js__WEBPACK_IMPORTED_MODULE_16__["default"]),
/* harmony export */   "geoCylindricalStereographicRaw": () => (/* reexport safe */ _cylindricalStereographic_js__WEBPACK_IMPORTED_MODULE_16__.cylindricalStereographicRaw),
/* harmony export */   "geoEckert1": () => (/* reexport safe */ _eckert1_js__WEBPACK_IMPORTED_MODULE_17__["default"]),
/* harmony export */   "geoEckert1Raw": () => (/* reexport safe */ _eckert1_js__WEBPACK_IMPORTED_MODULE_17__.eckert1Raw),
/* harmony export */   "geoEckert2": () => (/* reexport safe */ _eckert2_js__WEBPACK_IMPORTED_MODULE_18__["default"]),
/* harmony export */   "geoEckert2Raw": () => (/* reexport safe */ _eckert2_js__WEBPACK_IMPORTED_MODULE_18__.eckert2Raw),
/* harmony export */   "geoEckert3": () => (/* reexport safe */ _eckert3_js__WEBPACK_IMPORTED_MODULE_19__["default"]),
/* harmony export */   "geoEckert3Raw": () => (/* reexport safe */ _eckert3_js__WEBPACK_IMPORTED_MODULE_19__.eckert3Raw),
/* harmony export */   "geoEckert4": () => (/* reexport safe */ _eckert4_js__WEBPACK_IMPORTED_MODULE_20__["default"]),
/* harmony export */   "geoEckert4Raw": () => (/* reexport safe */ _eckert4_js__WEBPACK_IMPORTED_MODULE_20__.eckert4Raw),
/* harmony export */   "geoEckert5": () => (/* reexport safe */ _eckert5_js__WEBPACK_IMPORTED_MODULE_21__["default"]),
/* harmony export */   "geoEckert5Raw": () => (/* reexport safe */ _eckert5_js__WEBPACK_IMPORTED_MODULE_21__.eckert5Raw),
/* harmony export */   "geoEckert6": () => (/* reexport safe */ _eckert6_js__WEBPACK_IMPORTED_MODULE_22__["default"]),
/* harmony export */   "geoEckert6Raw": () => (/* reexport safe */ _eckert6_js__WEBPACK_IMPORTED_MODULE_22__.eckert6Raw),
/* harmony export */   "geoEisenlohr": () => (/* reexport safe */ _eisenlohr_js__WEBPACK_IMPORTED_MODULE_23__["default"]),
/* harmony export */   "geoEisenlohrRaw": () => (/* reexport safe */ _eisenlohr_js__WEBPACK_IMPORTED_MODULE_23__.eisenlohrRaw),
/* harmony export */   "geoFahey": () => (/* reexport safe */ _fahey_js__WEBPACK_IMPORTED_MODULE_24__["default"]),
/* harmony export */   "geoFaheyRaw": () => (/* reexport safe */ _fahey_js__WEBPACK_IMPORTED_MODULE_24__.faheyRaw),
/* harmony export */   "geoFoucaut": () => (/* reexport safe */ _foucaut_js__WEBPACK_IMPORTED_MODULE_25__["default"]),
/* harmony export */   "geoFoucautRaw": () => (/* reexport safe */ _foucaut_js__WEBPACK_IMPORTED_MODULE_25__.foucautRaw),
/* harmony export */   "geoFoucautSinusoidal": () => (/* reexport safe */ _foucautSinusoidal_js__WEBPACK_IMPORTED_MODULE_26__["default"]),
/* harmony export */   "geoFoucautSinusoidalRaw": () => (/* reexport safe */ _foucautSinusoidal_js__WEBPACK_IMPORTED_MODULE_26__.foucautSinusoidalRaw),
/* harmony export */   "geoGilbert": () => (/* reexport safe */ _gilbert_js__WEBPACK_IMPORTED_MODULE_27__["default"]),
/* harmony export */   "geoGingery": () => (/* reexport safe */ _gingery_js__WEBPACK_IMPORTED_MODULE_28__["default"]),
/* harmony export */   "geoGingeryRaw": () => (/* reexport safe */ _gingery_js__WEBPACK_IMPORTED_MODULE_28__.gingeryRaw),
/* harmony export */   "geoGinzburg4": () => (/* reexport safe */ _ginzburg4_js__WEBPACK_IMPORTED_MODULE_29__["default"]),
/* harmony export */   "geoGinzburg4Raw": () => (/* reexport safe */ _ginzburg4_js__WEBPACK_IMPORTED_MODULE_29__.ginzburg4Raw),
/* harmony export */   "geoGinzburg5": () => (/* reexport safe */ _ginzburg5_js__WEBPACK_IMPORTED_MODULE_30__["default"]),
/* harmony export */   "geoGinzburg5Raw": () => (/* reexport safe */ _ginzburg5_js__WEBPACK_IMPORTED_MODULE_30__.ginzburg5Raw),
/* harmony export */   "geoGinzburg6": () => (/* reexport safe */ _ginzburg6_js__WEBPACK_IMPORTED_MODULE_31__["default"]),
/* harmony export */   "geoGinzburg6Raw": () => (/* reexport safe */ _ginzburg6_js__WEBPACK_IMPORTED_MODULE_31__.ginzburg6Raw),
/* harmony export */   "geoGinzburg8": () => (/* reexport safe */ _ginzburg8_js__WEBPACK_IMPORTED_MODULE_32__["default"]),
/* harmony export */   "geoGinzburg8Raw": () => (/* reexport safe */ _ginzburg8_js__WEBPACK_IMPORTED_MODULE_32__.ginzburg8Raw),
/* harmony export */   "geoGinzburg9": () => (/* reexport safe */ _ginzburg9_js__WEBPACK_IMPORTED_MODULE_33__["default"]),
/* harmony export */   "geoGinzburg9Raw": () => (/* reexport safe */ _ginzburg9_js__WEBPACK_IMPORTED_MODULE_33__.ginzburg9Raw),
/* harmony export */   "geoGringorten": () => (/* reexport safe */ _gringorten_js__WEBPACK_IMPORTED_MODULE_34__["default"]),
/* harmony export */   "geoGringortenQuincuncial": () => (/* reexport safe */ _quincuncial_gringorten_js__WEBPACK_IMPORTED_MODULE_73__["default"]),
/* harmony export */   "geoGringortenRaw": () => (/* reexport safe */ _gringorten_js__WEBPACK_IMPORTED_MODULE_34__.gringortenRaw),
/* harmony export */   "geoGuyou": () => (/* reexport safe */ _guyou_js__WEBPACK_IMPORTED_MODULE_35__["default"]),
/* harmony export */   "geoGuyouRaw": () => (/* reexport safe */ _guyou_js__WEBPACK_IMPORTED_MODULE_35__.guyouRaw),
/* harmony export */   "geoHammer": () => (/* reexport safe */ _hammer_js__WEBPACK_IMPORTED_MODULE_36__["default"]),
/* harmony export */   "geoHammerRaw": () => (/* reexport safe */ _hammer_js__WEBPACK_IMPORTED_MODULE_36__.hammerRaw),
/* harmony export */   "geoHammerRetroazimuthal": () => (/* reexport safe */ _hammerRetroazimuthal_js__WEBPACK_IMPORTED_MODULE_37__["default"]),
/* harmony export */   "geoHammerRetroazimuthalRaw": () => (/* reexport safe */ _hammerRetroazimuthal_js__WEBPACK_IMPORTED_MODULE_37__.hammerRetroazimuthalRaw),
/* harmony export */   "geoHealpix": () => (/* reexport safe */ _healpix_js__WEBPACK_IMPORTED_MODULE_38__["default"]),
/* harmony export */   "geoHealpixRaw": () => (/* reexport safe */ _healpix_js__WEBPACK_IMPORTED_MODULE_38__.healpixRaw),
/* harmony export */   "geoHill": () => (/* reexport safe */ _hill_js__WEBPACK_IMPORTED_MODULE_39__["default"]),
/* harmony export */   "geoHillRaw": () => (/* reexport safe */ _hill_js__WEBPACK_IMPORTED_MODULE_39__.hillRaw),
/* harmony export */   "geoHomolosine": () => (/* reexport safe */ _homolosine_js__WEBPACK_IMPORTED_MODULE_40__["default"]),
/* harmony export */   "geoHomolosineRaw": () => (/* reexport safe */ _homolosine_js__WEBPACK_IMPORTED_MODULE_40__.homolosineRaw),
/* harmony export */   "geoHufnagel": () => (/* reexport safe */ _hufnagel_js__WEBPACK_IMPORTED_MODULE_41__["default"]),
/* harmony export */   "geoHufnagelRaw": () => (/* reexport safe */ _hufnagel_js__WEBPACK_IMPORTED_MODULE_41__.hufnagelRaw),
/* harmony export */   "geoHyperelliptical": () => (/* reexport safe */ _hyperelliptical_js__WEBPACK_IMPORTED_MODULE_42__["default"]),
/* harmony export */   "geoHyperellipticalRaw": () => (/* reexport safe */ _hyperelliptical_js__WEBPACK_IMPORTED_MODULE_42__.hyperellipticalRaw),
/* harmony export */   "geoInterrupt": () => (/* reexport safe */ _interrupted_index_js__WEBPACK_IMPORTED_MODULE_43__["default"]),
/* harmony export */   "geoInterruptedBoggs": () => (/* reexport safe */ _interrupted_boggs_js__WEBPACK_IMPORTED_MODULE_44__["default"]),
/* harmony export */   "geoInterruptedHomolosine": () => (/* reexport safe */ _interrupted_homolosine_js__WEBPACK_IMPORTED_MODULE_45__["default"]),
/* harmony export */   "geoInterruptedMollweide": () => (/* reexport safe */ _interrupted_mollweide_js__WEBPACK_IMPORTED_MODULE_46__["default"]),
/* harmony export */   "geoInterruptedMollweideHemispheres": () => (/* reexport safe */ _interrupted_mollweideHemispheres_js__WEBPACK_IMPORTED_MODULE_47__["default"]),
/* harmony export */   "geoInterruptedQuarticAuthalic": () => (/* reexport safe */ _interrupted_quarticAuthalic_js__WEBPACK_IMPORTED_MODULE_64__["default"]),
/* harmony export */   "geoInterruptedSinuMollweide": () => (/* reexport safe */ _interrupted_sinuMollweide_js__WEBPACK_IMPORTED_MODULE_48__["default"]),
/* harmony export */   "geoInterruptedSinusoidal": () => (/* reexport safe */ _interrupted_sinusoidal_js__WEBPACK_IMPORTED_MODULE_49__["default"]),
/* harmony export */   "geoKavrayskiy7": () => (/* reexport safe */ _kavrayskiy7_js__WEBPACK_IMPORTED_MODULE_50__["default"]),
/* harmony export */   "geoKavrayskiy7Raw": () => (/* reexport safe */ _kavrayskiy7_js__WEBPACK_IMPORTED_MODULE_50__.kavrayskiy7Raw),
/* harmony export */   "geoLagrange": () => (/* reexport safe */ _lagrange_js__WEBPACK_IMPORTED_MODULE_51__["default"]),
/* harmony export */   "geoLagrangeRaw": () => (/* reexport safe */ _lagrange_js__WEBPACK_IMPORTED_MODULE_51__.lagrangeRaw),
/* harmony export */   "geoLarrivee": () => (/* reexport safe */ _larrivee_js__WEBPACK_IMPORTED_MODULE_52__["default"]),
/* harmony export */   "geoLarriveeRaw": () => (/* reexport safe */ _larrivee_js__WEBPACK_IMPORTED_MODULE_52__.larriveeRaw),
/* harmony export */   "geoLaskowski": () => (/* reexport safe */ _laskowski_js__WEBPACK_IMPORTED_MODULE_53__["default"]),
/* harmony export */   "geoLaskowskiRaw": () => (/* reexport safe */ _laskowski_js__WEBPACK_IMPORTED_MODULE_53__.laskowskiRaw),
/* harmony export */   "geoLittrow": () => (/* reexport safe */ _littrow_js__WEBPACK_IMPORTED_MODULE_54__["default"]),
/* harmony export */   "geoLittrowRaw": () => (/* reexport safe */ _littrow_js__WEBPACK_IMPORTED_MODULE_54__.littrowRaw),
/* harmony export */   "geoLoximuthal": () => (/* reexport safe */ _loximuthal_js__WEBPACK_IMPORTED_MODULE_55__["default"]),
/* harmony export */   "geoLoximuthalRaw": () => (/* reexport safe */ _loximuthal_js__WEBPACK_IMPORTED_MODULE_55__.loximuthalRaw),
/* harmony export */   "geoMiller": () => (/* reexport safe */ _miller_js__WEBPACK_IMPORTED_MODULE_56__["default"]),
/* harmony export */   "geoMillerRaw": () => (/* reexport safe */ _miller_js__WEBPACK_IMPORTED_MODULE_56__.millerRaw),
/* harmony export */   "geoModifiedStereographic": () => (/* reexport safe */ _modifiedStereographic_js__WEBPACK_IMPORTED_MODULE_57__["default"]),
/* harmony export */   "geoModifiedStereographicAlaska": () => (/* reexport safe */ _modifiedStereographic_js__WEBPACK_IMPORTED_MODULE_57__.modifiedStereographicAlaska),
/* harmony export */   "geoModifiedStereographicGs48": () => (/* reexport safe */ _modifiedStereographic_js__WEBPACK_IMPORTED_MODULE_57__.modifiedStereographicGs48),
/* harmony export */   "geoModifiedStereographicGs50": () => (/* reexport safe */ _modifiedStereographic_js__WEBPACK_IMPORTED_MODULE_57__.modifiedStereographicGs50),
/* harmony export */   "geoModifiedStereographicLee": () => (/* reexport safe */ _modifiedStereographic_js__WEBPACK_IMPORTED_MODULE_57__.modifiedStereographicLee),
/* harmony export */   "geoModifiedStereographicMiller": () => (/* reexport safe */ _modifiedStereographic_js__WEBPACK_IMPORTED_MODULE_57__.modifiedStereographicMiller),
/* harmony export */   "geoModifiedStereographicRaw": () => (/* reexport safe */ _modifiedStereographic_js__WEBPACK_IMPORTED_MODULE_57__.modifiedStereographicRaw),
/* harmony export */   "geoMollweide": () => (/* reexport safe */ _mollweide_js__WEBPACK_IMPORTED_MODULE_58__["default"]),
/* harmony export */   "geoMollweideRaw": () => (/* reexport safe */ _mollweide_js__WEBPACK_IMPORTED_MODULE_58__.mollweideRaw),
/* harmony export */   "geoMtFlatPolarParabolic": () => (/* reexport safe */ _mtFlatPolarParabolic_js__WEBPACK_IMPORTED_MODULE_59__["default"]),
/* harmony export */   "geoMtFlatPolarParabolicRaw": () => (/* reexport safe */ _mtFlatPolarParabolic_js__WEBPACK_IMPORTED_MODULE_59__.mtFlatPolarParabolicRaw),
/* harmony export */   "geoMtFlatPolarQuartic": () => (/* reexport safe */ _mtFlatPolarQuartic_js__WEBPACK_IMPORTED_MODULE_60__["default"]),
/* harmony export */   "geoMtFlatPolarQuarticRaw": () => (/* reexport safe */ _mtFlatPolarQuartic_js__WEBPACK_IMPORTED_MODULE_60__.mtFlatPolarQuarticRaw),
/* harmony export */   "geoMtFlatPolarSinusoidal": () => (/* reexport safe */ _mtFlatPolarSinusoidal_js__WEBPACK_IMPORTED_MODULE_61__["default"]),
/* harmony export */   "geoMtFlatPolarSinusoidalRaw": () => (/* reexport safe */ _mtFlatPolarSinusoidal_js__WEBPACK_IMPORTED_MODULE_61__.mtFlatPolarSinusoidalRaw),
/* harmony export */   "geoNaturalEarth2": () => (/* reexport safe */ _naturalEarth2_js__WEBPACK_IMPORTED_MODULE_62__["default"]),
/* harmony export */   "geoNaturalEarth2Raw": () => (/* reexport safe */ _naturalEarth2_js__WEBPACK_IMPORTED_MODULE_62__.naturalEarth2Raw),
/* harmony export */   "geoNellHammer": () => (/* reexport safe */ _nellHammer_js__WEBPACK_IMPORTED_MODULE_63__["default"]),
/* harmony export */   "geoNellHammerRaw": () => (/* reexport safe */ _nellHammer_js__WEBPACK_IMPORTED_MODULE_63__.nellHammerRaw),
/* harmony export */   "geoNicolosi": () => (/* reexport safe */ _nicolosi_js__WEBPACK_IMPORTED_MODULE_65__["default"]),
/* harmony export */   "geoNicolosiRaw": () => (/* reexport safe */ _nicolosi_js__WEBPACK_IMPORTED_MODULE_65__.nicolosiRaw),
/* harmony export */   "geoPatterson": () => (/* reexport safe */ _patterson_js__WEBPACK_IMPORTED_MODULE_66__["default"]),
/* harmony export */   "geoPattersonRaw": () => (/* reexport safe */ _patterson_js__WEBPACK_IMPORTED_MODULE_66__.pattersonRaw),
/* harmony export */   "geoPeirceQuincuncial": () => (/* reexport safe */ _quincuncial_peirce_js__WEBPACK_IMPORTED_MODULE_74__["default"]),
/* harmony export */   "geoPolyconic": () => (/* reexport safe */ _polyconic_js__WEBPACK_IMPORTED_MODULE_67__["default"]),
/* harmony export */   "geoPolyconicRaw": () => (/* reexport safe */ _polyconic_js__WEBPACK_IMPORTED_MODULE_67__.polyconicRaw),
/* harmony export */   "geoPolyhedral": () => (/* reexport safe */ _polyhedral_index_js__WEBPACK_IMPORTED_MODULE_68__["default"]),
/* harmony export */   "geoPolyhedralButterfly": () => (/* reexport safe */ _polyhedral_butterfly_js__WEBPACK_IMPORTED_MODULE_69__["default"]),
/* harmony export */   "geoPolyhedralCollignon": () => (/* reexport safe */ _polyhedral_collignon_js__WEBPACK_IMPORTED_MODULE_70__["default"]),
/* harmony export */   "geoPolyhedralWaterman": () => (/* reexport safe */ _polyhedral_waterman_js__WEBPACK_IMPORTED_MODULE_71__["default"]),
/* harmony export */   "geoProject": () => (/* reexport safe */ _project_index_js__WEBPACK_IMPORTED_MODULE_72__["default"]),
/* harmony export */   "geoQuantize": () => (/* reexport safe */ _quantize_js__WEBPACK_IMPORTED_MODULE_75__["default"]),
/* harmony export */   "geoQuincuncial": () => (/* reexport safe */ _quincuncial_index_js__WEBPACK_IMPORTED_MODULE_76__["default"]),
/* harmony export */   "geoRectangularPolyconic": () => (/* reexport safe */ _rectangularPolyconic_js__WEBPACK_IMPORTED_MODULE_77__["default"]),
/* harmony export */   "geoRectangularPolyconicRaw": () => (/* reexport safe */ _rectangularPolyconic_js__WEBPACK_IMPORTED_MODULE_77__.rectangularPolyconicRaw),
/* harmony export */   "geoRobinson": () => (/* reexport safe */ _robinson_js__WEBPACK_IMPORTED_MODULE_78__["default"]),
/* harmony export */   "geoRobinsonRaw": () => (/* reexport safe */ _robinson_js__WEBPACK_IMPORTED_MODULE_78__.robinsonRaw),
/* harmony export */   "geoSatellite": () => (/* reexport safe */ _satellite_js__WEBPACK_IMPORTED_MODULE_79__["default"]),
/* harmony export */   "geoSatelliteRaw": () => (/* reexport safe */ _satellite_js__WEBPACK_IMPORTED_MODULE_79__.satelliteRaw),
/* harmony export */   "geoSinuMollweide": () => (/* reexport safe */ _sinuMollweide_js__WEBPACK_IMPORTED_MODULE_80__["default"]),
/* harmony export */   "geoSinuMollweideRaw": () => (/* reexport safe */ _sinuMollweide_js__WEBPACK_IMPORTED_MODULE_80__.sinuMollweideRaw),
/* harmony export */   "geoSinusoidal": () => (/* reexport safe */ _sinusoidal_js__WEBPACK_IMPORTED_MODULE_81__["default"]),
/* harmony export */   "geoSinusoidalRaw": () => (/* reexport safe */ _sinusoidal_js__WEBPACK_IMPORTED_MODULE_81__.sinusoidalRaw),
/* harmony export */   "geoStitch": () => (/* reexport safe */ _stitch_js__WEBPACK_IMPORTED_MODULE_82__["default"]),
/* harmony export */   "geoTimes": () => (/* reexport safe */ _times_js__WEBPACK_IMPORTED_MODULE_83__["default"]),
/* harmony export */   "geoTimesRaw": () => (/* reexport safe */ _times_js__WEBPACK_IMPORTED_MODULE_83__.timesRaw),
/* harmony export */   "geoTwoPointAzimuthal": () => (/* reexport safe */ _twoPointAzimuthal_js__WEBPACK_IMPORTED_MODULE_84__["default"]),
/* harmony export */   "geoTwoPointAzimuthalRaw": () => (/* reexport safe */ _twoPointAzimuthal_js__WEBPACK_IMPORTED_MODULE_84__.twoPointAzimuthalRaw),
/* harmony export */   "geoTwoPointAzimuthalUsa": () => (/* reexport safe */ _twoPointAzimuthal_js__WEBPACK_IMPORTED_MODULE_84__.twoPointAzimuthalUsa),
/* harmony export */   "geoTwoPointEquidistant": () => (/* reexport safe */ _twoPointEquidistant_js__WEBPACK_IMPORTED_MODULE_85__["default"]),
/* harmony export */   "geoTwoPointEquidistantRaw": () => (/* reexport safe */ _twoPointEquidistant_js__WEBPACK_IMPORTED_MODULE_85__.twoPointEquidistantRaw),
/* harmony export */   "geoTwoPointEquidistantUsa": () => (/* reexport safe */ _twoPointEquidistant_js__WEBPACK_IMPORTED_MODULE_85__.twoPointEquidistantUsa),
/* harmony export */   "geoVanDerGrinten": () => (/* reexport safe */ _vanDerGrinten_js__WEBPACK_IMPORTED_MODULE_86__["default"]),
/* harmony export */   "geoVanDerGrinten2": () => (/* reexport safe */ _vanDerGrinten2_js__WEBPACK_IMPORTED_MODULE_87__["default"]),
/* harmony export */   "geoVanDerGrinten2Raw": () => (/* reexport safe */ _vanDerGrinten2_js__WEBPACK_IMPORTED_MODULE_87__.vanDerGrinten2Raw),
/* harmony export */   "geoVanDerGrinten3": () => (/* reexport safe */ _vanDerGrinten3_js__WEBPACK_IMPORTED_MODULE_88__["default"]),
/* harmony export */   "geoVanDerGrinten3Raw": () => (/* reexport safe */ _vanDerGrinten3_js__WEBPACK_IMPORTED_MODULE_88__.vanDerGrinten3Raw),
/* harmony export */   "geoVanDerGrinten4": () => (/* reexport safe */ _vanDerGrinten4_js__WEBPACK_IMPORTED_MODULE_89__["default"]),
/* harmony export */   "geoVanDerGrinten4Raw": () => (/* reexport safe */ _vanDerGrinten4_js__WEBPACK_IMPORTED_MODULE_89__.vanDerGrinten4Raw),
/* harmony export */   "geoVanDerGrintenRaw": () => (/* reexport safe */ _vanDerGrinten_js__WEBPACK_IMPORTED_MODULE_86__.vanDerGrintenRaw),
/* harmony export */   "geoWagner": () => (/* reexport safe */ _wagner_js__WEBPACK_IMPORTED_MODULE_90__["default"]),
/* harmony export */   "geoWagner4": () => (/* reexport safe */ _wagner4_js__WEBPACK_IMPORTED_MODULE_91__["default"]),
/* harmony export */   "geoWagner4Raw": () => (/* reexport safe */ _wagner4_js__WEBPACK_IMPORTED_MODULE_91__.wagner4Raw),
/* harmony export */   "geoWagner6": () => (/* reexport safe */ _wagner6_js__WEBPACK_IMPORTED_MODULE_92__["default"]),
/* harmony export */   "geoWagner6Raw": () => (/* reexport safe */ _wagner6_js__WEBPACK_IMPORTED_MODULE_92__.wagner6Raw),
/* harmony export */   "geoWagner7": () => (/* reexport safe */ _wagner_js__WEBPACK_IMPORTED_MODULE_90__.wagner7),
/* harmony export */   "geoWagnerRaw": () => (/* reexport safe */ _wagner_js__WEBPACK_IMPORTED_MODULE_90__.wagnerRaw),
/* harmony export */   "geoWiechel": () => (/* reexport safe */ _wiechel_js__WEBPACK_IMPORTED_MODULE_93__["default"]),
/* harmony export */   "geoWiechelRaw": () => (/* reexport safe */ _wiechel_js__WEBPACK_IMPORTED_MODULE_93__.wiechelRaw),
/* harmony export */   "geoWinkel3": () => (/* reexport safe */ _winkel3_js__WEBPACK_IMPORTED_MODULE_94__["default"]),
/* harmony export */   "geoWinkel3Raw": () => (/* reexport safe */ _winkel3_js__WEBPACK_IMPORTED_MODULE_94__.winkel3Raw)
/* harmony export */ });
/* harmony import */ var _airy_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./airy.js */ "./node_modules/d3-geo-projection/src/airy.js");
/* harmony import */ var _aitoff_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./aitoff.js */ "./node_modules/d3-geo-projection/src/aitoff.js");
/* harmony import */ var _armadillo_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./armadillo.js */ "./node_modules/d3-geo-projection/src/armadillo.js");
/* harmony import */ var _august_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./august.js */ "./node_modules/d3-geo-projection/src/august.js");
/* harmony import */ var _baker_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./baker.js */ "./node_modules/d3-geo-projection/src/baker.js");
/* harmony import */ var _berghaus_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./berghaus.js */ "./node_modules/d3-geo-projection/src/berghaus.js");
/* harmony import */ var _bertin_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./bertin.js */ "./node_modules/d3-geo-projection/src/bertin.js");
/* harmony import */ var _boggs_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./boggs.js */ "./node_modules/d3-geo-projection/src/boggs.js");
/* harmony import */ var _bonne_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./bonne.js */ "./node_modules/d3-geo-projection/src/bonne.js");
/* harmony import */ var _bottomley_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./bottomley.js */ "./node_modules/d3-geo-projection/src/bottomley.js");
/* harmony import */ var _bromley_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./bromley.js */ "./node_modules/d3-geo-projection/src/bromley.js");
/* harmony import */ var _chamberlin_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./chamberlin.js */ "./node_modules/d3-geo-projection/src/chamberlin.js");
/* harmony import */ var _collignon_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./collignon.js */ "./node_modules/d3-geo-projection/src/collignon.js");
/* harmony import */ var _craig_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./craig.js */ "./node_modules/d3-geo-projection/src/craig.js");
/* harmony import */ var _craster_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./craster.js */ "./node_modules/d3-geo-projection/src/craster.js");
/* harmony import */ var _cylindricalEqualArea_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./cylindricalEqualArea.js */ "./node_modules/d3-geo-projection/src/cylindricalEqualArea.js");
/* harmony import */ var _cylindricalStereographic_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./cylindricalStereographic.js */ "./node_modules/d3-geo-projection/src/cylindricalStereographic.js");
/* harmony import */ var _eckert1_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./eckert1.js */ "./node_modules/d3-geo-projection/src/eckert1.js");
/* harmony import */ var _eckert2_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./eckert2.js */ "./node_modules/d3-geo-projection/src/eckert2.js");
/* harmony import */ var _eckert3_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./eckert3.js */ "./node_modules/d3-geo-projection/src/eckert3.js");
/* harmony import */ var _eckert4_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./eckert4.js */ "./node_modules/d3-geo-projection/src/eckert4.js");
/* harmony import */ var _eckert5_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./eckert5.js */ "./node_modules/d3-geo-projection/src/eckert5.js");
/* harmony import */ var _eckert6_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./eckert6.js */ "./node_modules/d3-geo-projection/src/eckert6.js");
/* harmony import */ var _eisenlohr_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./eisenlohr.js */ "./node_modules/d3-geo-projection/src/eisenlohr.js");
/* harmony import */ var _fahey_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./fahey.js */ "./node_modules/d3-geo-projection/src/fahey.js");
/* harmony import */ var _foucaut_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./foucaut.js */ "./node_modules/d3-geo-projection/src/foucaut.js");
/* harmony import */ var _foucautSinusoidal_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./foucautSinusoidal.js */ "./node_modules/d3-geo-projection/src/foucautSinusoidal.js");
/* harmony import */ var _gilbert_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./gilbert.js */ "./node_modules/d3-geo-projection/src/gilbert.js");
/* harmony import */ var _gingery_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./gingery.js */ "./node_modules/d3-geo-projection/src/gingery.js");
/* harmony import */ var _ginzburg4_js__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./ginzburg4.js */ "./node_modules/d3-geo-projection/src/ginzburg4.js");
/* harmony import */ var _ginzburg5_js__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./ginzburg5.js */ "./node_modules/d3-geo-projection/src/ginzburg5.js");
/* harmony import */ var _ginzburg6_js__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./ginzburg6.js */ "./node_modules/d3-geo-projection/src/ginzburg6.js");
/* harmony import */ var _ginzburg8_js__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./ginzburg8.js */ "./node_modules/d3-geo-projection/src/ginzburg8.js");
/* harmony import */ var _ginzburg9_js__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ./ginzburg9.js */ "./node_modules/d3-geo-projection/src/ginzburg9.js");
/* harmony import */ var _gringorten_js__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ./gringorten.js */ "./node_modules/d3-geo-projection/src/gringorten.js");
/* harmony import */ var _guyou_js__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ./guyou.js */ "./node_modules/d3-geo-projection/src/guyou.js");
/* harmony import */ var _hammer_js__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ./hammer.js */ "./node_modules/d3-geo-projection/src/hammer.js");
/* harmony import */ var _hammerRetroazimuthal_js__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ./hammerRetroazimuthal.js */ "./node_modules/d3-geo-projection/src/hammerRetroazimuthal.js");
/* harmony import */ var _healpix_js__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ./healpix.js */ "./node_modules/d3-geo-projection/src/healpix.js");
/* harmony import */ var _hill_js__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ./hill.js */ "./node_modules/d3-geo-projection/src/hill.js");
/* harmony import */ var _homolosine_js__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ./homolosine.js */ "./node_modules/d3-geo-projection/src/homolosine.js");
/* harmony import */ var _hufnagel_js__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ./hufnagel.js */ "./node_modules/d3-geo-projection/src/hufnagel.js");
/* harmony import */ var _hyperelliptical_js__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ./hyperelliptical.js */ "./node_modules/d3-geo-projection/src/hyperelliptical.js");
/* harmony import */ var _interrupted_index_js__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! ./interrupted/index.js */ "./node_modules/d3-geo-projection/src/interrupted/index.js");
/* harmony import */ var _interrupted_boggs_js__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! ./interrupted/boggs.js */ "./node_modules/d3-geo-projection/src/interrupted/boggs.js");
/* harmony import */ var _interrupted_homolosine_js__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(/*! ./interrupted/homolosine.js */ "./node_modules/d3-geo-projection/src/interrupted/homolosine.js");
/* harmony import */ var _interrupted_mollweide_js__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(/*! ./interrupted/mollweide.js */ "./node_modules/d3-geo-projection/src/interrupted/mollweide.js");
/* harmony import */ var _interrupted_mollweideHemispheres_js__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(/*! ./interrupted/mollweideHemispheres.js */ "./node_modules/d3-geo-projection/src/interrupted/mollweideHemispheres.js");
/* harmony import */ var _interrupted_sinuMollweide_js__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__(/*! ./interrupted/sinuMollweide.js */ "./node_modules/d3-geo-projection/src/interrupted/sinuMollweide.js");
/* harmony import */ var _interrupted_sinusoidal_js__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__(/*! ./interrupted/sinusoidal.js */ "./node_modules/d3-geo-projection/src/interrupted/sinusoidal.js");
/* harmony import */ var _kavrayskiy7_js__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__(/*! ./kavrayskiy7.js */ "./node_modules/d3-geo-projection/src/kavrayskiy7.js");
/* harmony import */ var _lagrange_js__WEBPACK_IMPORTED_MODULE_51__ = __webpack_require__(/*! ./lagrange.js */ "./node_modules/d3-geo-projection/src/lagrange.js");
/* harmony import */ var _larrivee_js__WEBPACK_IMPORTED_MODULE_52__ = __webpack_require__(/*! ./larrivee.js */ "./node_modules/d3-geo-projection/src/larrivee.js");
/* harmony import */ var _laskowski_js__WEBPACK_IMPORTED_MODULE_53__ = __webpack_require__(/*! ./laskowski.js */ "./node_modules/d3-geo-projection/src/laskowski.js");
/* harmony import */ var _littrow_js__WEBPACK_IMPORTED_MODULE_54__ = __webpack_require__(/*! ./littrow.js */ "./node_modules/d3-geo-projection/src/littrow.js");
/* harmony import */ var _loximuthal_js__WEBPACK_IMPORTED_MODULE_55__ = __webpack_require__(/*! ./loximuthal.js */ "./node_modules/d3-geo-projection/src/loximuthal.js");
/* harmony import */ var _miller_js__WEBPACK_IMPORTED_MODULE_56__ = __webpack_require__(/*! ./miller.js */ "./node_modules/d3-geo-projection/src/miller.js");
/* harmony import */ var _modifiedStereographic_js__WEBPACK_IMPORTED_MODULE_57__ = __webpack_require__(/*! ./modifiedStereographic.js */ "./node_modules/d3-geo-projection/src/modifiedStereographic.js");
/* harmony import */ var _mollweide_js__WEBPACK_IMPORTED_MODULE_58__ = __webpack_require__(/*! ./mollweide.js */ "./node_modules/d3-geo-projection/src/mollweide.js");
/* harmony import */ var _mtFlatPolarParabolic_js__WEBPACK_IMPORTED_MODULE_59__ = __webpack_require__(/*! ./mtFlatPolarParabolic.js */ "./node_modules/d3-geo-projection/src/mtFlatPolarParabolic.js");
/* harmony import */ var _mtFlatPolarQuartic_js__WEBPACK_IMPORTED_MODULE_60__ = __webpack_require__(/*! ./mtFlatPolarQuartic.js */ "./node_modules/d3-geo-projection/src/mtFlatPolarQuartic.js");
/* harmony import */ var _mtFlatPolarSinusoidal_js__WEBPACK_IMPORTED_MODULE_61__ = __webpack_require__(/*! ./mtFlatPolarSinusoidal.js */ "./node_modules/d3-geo-projection/src/mtFlatPolarSinusoidal.js");
/* harmony import */ var _naturalEarth2_js__WEBPACK_IMPORTED_MODULE_62__ = __webpack_require__(/*! ./naturalEarth2.js */ "./node_modules/d3-geo-projection/src/naturalEarth2.js");
/* harmony import */ var _nellHammer_js__WEBPACK_IMPORTED_MODULE_63__ = __webpack_require__(/*! ./nellHammer.js */ "./node_modules/d3-geo-projection/src/nellHammer.js");
/* harmony import */ var _interrupted_quarticAuthalic_js__WEBPACK_IMPORTED_MODULE_64__ = __webpack_require__(/*! ./interrupted/quarticAuthalic.js */ "./node_modules/d3-geo-projection/src/interrupted/quarticAuthalic.js");
/* harmony import */ var _nicolosi_js__WEBPACK_IMPORTED_MODULE_65__ = __webpack_require__(/*! ./nicolosi.js */ "./node_modules/d3-geo-projection/src/nicolosi.js");
/* harmony import */ var _patterson_js__WEBPACK_IMPORTED_MODULE_66__ = __webpack_require__(/*! ./patterson.js */ "./node_modules/d3-geo-projection/src/patterson.js");
/* harmony import */ var _polyconic_js__WEBPACK_IMPORTED_MODULE_67__ = __webpack_require__(/*! ./polyconic.js */ "./node_modules/d3-geo-projection/src/polyconic.js");
/* harmony import */ var _polyhedral_index_js__WEBPACK_IMPORTED_MODULE_68__ = __webpack_require__(/*! ./polyhedral/index.js */ "./node_modules/d3-geo-projection/src/polyhedral/index.js");
/* harmony import */ var _polyhedral_butterfly_js__WEBPACK_IMPORTED_MODULE_69__ = __webpack_require__(/*! ./polyhedral/butterfly.js */ "./node_modules/d3-geo-projection/src/polyhedral/butterfly.js");
/* harmony import */ var _polyhedral_collignon_js__WEBPACK_IMPORTED_MODULE_70__ = __webpack_require__(/*! ./polyhedral/collignon.js */ "./node_modules/d3-geo-projection/src/polyhedral/collignon.js");
/* harmony import */ var _polyhedral_waterman_js__WEBPACK_IMPORTED_MODULE_71__ = __webpack_require__(/*! ./polyhedral/waterman.js */ "./node_modules/d3-geo-projection/src/polyhedral/waterman.js");
/* harmony import */ var _project_index_js__WEBPACK_IMPORTED_MODULE_72__ = __webpack_require__(/*! ./project/index.js */ "./node_modules/d3-geo-projection/src/project/index.js");
/* harmony import */ var _quincuncial_gringorten_js__WEBPACK_IMPORTED_MODULE_73__ = __webpack_require__(/*! ./quincuncial/gringorten.js */ "./node_modules/d3-geo-projection/src/quincuncial/gringorten.js");
/* harmony import */ var _quincuncial_peirce_js__WEBPACK_IMPORTED_MODULE_74__ = __webpack_require__(/*! ./quincuncial/peirce.js */ "./node_modules/d3-geo-projection/src/quincuncial/peirce.js");
/* harmony import */ var _quantize_js__WEBPACK_IMPORTED_MODULE_75__ = __webpack_require__(/*! ./quantize.js */ "./node_modules/d3-geo-projection/src/quantize.js");
/* harmony import */ var _quincuncial_index_js__WEBPACK_IMPORTED_MODULE_76__ = __webpack_require__(/*! ./quincuncial/index.js */ "./node_modules/d3-geo-projection/src/quincuncial/index.js");
/* harmony import */ var _rectangularPolyconic_js__WEBPACK_IMPORTED_MODULE_77__ = __webpack_require__(/*! ./rectangularPolyconic.js */ "./node_modules/d3-geo-projection/src/rectangularPolyconic.js");
/* harmony import */ var _robinson_js__WEBPACK_IMPORTED_MODULE_78__ = __webpack_require__(/*! ./robinson.js */ "./node_modules/d3-geo-projection/src/robinson.js");
/* harmony import */ var _satellite_js__WEBPACK_IMPORTED_MODULE_79__ = __webpack_require__(/*! ./satellite.js */ "./node_modules/d3-geo-projection/src/satellite.js");
/* harmony import */ var _sinuMollweide_js__WEBPACK_IMPORTED_MODULE_80__ = __webpack_require__(/*! ./sinuMollweide.js */ "./node_modules/d3-geo-projection/src/sinuMollweide.js");
/* harmony import */ var _sinusoidal_js__WEBPACK_IMPORTED_MODULE_81__ = __webpack_require__(/*! ./sinusoidal.js */ "./node_modules/d3-geo-projection/src/sinusoidal.js");
/* harmony import */ var _stitch_js__WEBPACK_IMPORTED_MODULE_82__ = __webpack_require__(/*! ./stitch.js */ "./node_modules/d3-geo-projection/src/stitch.js");
/* harmony import */ var _times_js__WEBPACK_IMPORTED_MODULE_83__ = __webpack_require__(/*! ./times.js */ "./node_modules/d3-geo-projection/src/times.js");
/* harmony import */ var _twoPointAzimuthal_js__WEBPACK_IMPORTED_MODULE_84__ = __webpack_require__(/*! ./twoPointAzimuthal.js */ "./node_modules/d3-geo-projection/src/twoPointAzimuthal.js");
/* harmony import */ var _twoPointEquidistant_js__WEBPACK_IMPORTED_MODULE_85__ = __webpack_require__(/*! ./twoPointEquidistant.js */ "./node_modules/d3-geo-projection/src/twoPointEquidistant.js");
/* harmony import */ var _vanDerGrinten_js__WEBPACK_IMPORTED_MODULE_86__ = __webpack_require__(/*! ./vanDerGrinten.js */ "./node_modules/d3-geo-projection/src/vanDerGrinten.js");
/* harmony import */ var _vanDerGrinten2_js__WEBPACK_IMPORTED_MODULE_87__ = __webpack_require__(/*! ./vanDerGrinten2.js */ "./node_modules/d3-geo-projection/src/vanDerGrinten2.js");
/* harmony import */ var _vanDerGrinten3_js__WEBPACK_IMPORTED_MODULE_88__ = __webpack_require__(/*! ./vanDerGrinten3.js */ "./node_modules/d3-geo-projection/src/vanDerGrinten3.js");
/* harmony import */ var _vanDerGrinten4_js__WEBPACK_IMPORTED_MODULE_89__ = __webpack_require__(/*! ./vanDerGrinten4.js */ "./node_modules/d3-geo-projection/src/vanDerGrinten4.js");
/* harmony import */ var _wagner_js__WEBPACK_IMPORTED_MODULE_90__ = __webpack_require__(/*! ./wagner.js */ "./node_modules/d3-geo-projection/src/wagner.js");
/* harmony import */ var _wagner4_js__WEBPACK_IMPORTED_MODULE_91__ = __webpack_require__(/*! ./wagner4.js */ "./node_modules/d3-geo-projection/src/wagner4.js");
/* harmony import */ var _wagner6_js__WEBPACK_IMPORTED_MODULE_92__ = __webpack_require__(/*! ./wagner6.js */ "./node_modules/d3-geo-projection/src/wagner6.js");
/* harmony import */ var _wiechel_js__WEBPACK_IMPORTED_MODULE_93__ = __webpack_require__(/*! ./wiechel.js */ "./node_modules/d3-geo-projection/src/wiechel.js");
/* harmony import */ var _winkel3_js__WEBPACK_IMPORTED_MODULE_94__ = __webpack_require__(/*! ./winkel3.js */ "./node_modules/d3-geo-projection/src/winkel3.js");

































































































/***/ }),

/***/ "./node_modules/d3-geo-projection/src/integrate.js":
/*!*********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/integrate.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "integrate": () => (/* binding */ integrate)
/* harmony export */ });
// https://github.com/scijs/integrate-adaptive-simpson

// This algorithm adapted from pseudocode in:
// http://www.math.utk.edu/~ccollins/refs/Handouts/rich.pdf
function adsimp (f, a, b, fa, fm, fb, V0, tol, maxdepth, depth, state) {
  if (state.nanEncountered) {
    return NaN;
  }

  var h, f1, f2, sl, sr, s2, m, V1, V2, err;

  h = b - a;
  f1 = f(a + h * 0.25);
  f2 = f(b - h * 0.25);

  // Simple check for NaN:
  if (isNaN(f1)) {
    state.nanEncountered = true;
    return;
  }

  // Simple check for NaN:
  if (isNaN(f2)) {
    state.nanEncountered = true;
    return;
  }

  sl = h * (fa + 4 * f1 + fm) / 12;
  sr = h * (fm + 4 * f2 + fb) / 12;
  s2 = sl + sr;
  err = (s2 - V0) / 15;

  if (depth > maxdepth) {
    state.maxDepthCount++;
    return s2 + err;
  } else if (Math.abs(err) < tol) {
    return s2 + err;
  } else {
    m = a + h * 0.5;

    V1 = adsimp(f, a, m, fa, f1, fm, sl, tol * 0.5, maxdepth, depth + 1, state);

    if (isNaN(V1)) {
      state.nanEncountered = true;
      return NaN;
    }

    V2 = adsimp(f, m, b, fm, f2, fb, sr, tol * 0.5, maxdepth, depth + 1, state);

    if (isNaN(V2)) {
      state.nanEncountered = true;
      return NaN;
    }

    return V1 + V2;
  }
}

function integrate (f, a, b, tol, maxdepth) {
  var state = {
    maxDepthCount: 0,
    nanEncountered: false
  };

  if (tol === undefined) {
    tol = 1e-8;
  }
  if (maxdepth === undefined) {
    maxdepth = 20;
  }

  var fa = f(a);
  var fm = f(0.5 * (a + b));
  var fb = f(b);

  var V0 = (fa + 4 * fm + fb) * (b - a) / 6;

  var result = adsimp(f, a, b, fa, fm, fb, V0, tol, maxdepth, 1, state);

/*
  if (state.maxDepthCount > 0 && console && console.warn) {
    console.warn('integrate-adaptive-simpson: Warning: maximum recursion depth (' + maxdepth + ') reached ' + state.maxDepthCount + ' times');
  }

  if (state.nanEncountered && console && console.warn) {
    console.warn('integrate-adaptive-simpson: Warning: NaN encountered. Halting early.');
  }
*/

  return result;
}

/***/ }),

/***/ "./node_modules/d3-geo-projection/src/interrupted/boggs.js":
/*!*****************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/interrupted/boggs.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _boggs_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../boggs.js */ "./node_modules/d3-geo-projection/src/boggs.js");
/* harmony import */ var _index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./index.js */ "./node_modules/d3-geo-projection/src/interrupted/index.js");



var lobes = [[ // northern hemisphere
  [[-180,   0], [-100,  90], [ -40,   0]],
  [[ -40,   0], [  30,  90], [ 180,   0]]
], [ // southern hemisphere
  [[-180,   0], [-160, -90], [-100,   0]],
  [[-100,   0], [ -60, -90], [ -20,   0]],
  [[ -20,   0], [  20, -90], [  80,   0]],
  [[  80,   0], [ 140, -90], [ 180,   0]]
]];

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_boggs_js__WEBPACK_IMPORTED_MODULE_1__.boggsRaw, lobes)
      .scale(160.857);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/interrupted/homolosine.js":
/*!**********************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/interrupted/homolosine.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _homolosine_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../homolosine.js */ "./node_modules/d3-geo-projection/src/homolosine.js");
/* harmony import */ var _index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./index.js */ "./node_modules/d3-geo-projection/src/interrupted/index.js");



var lobes = [[ // northern hemisphere
  [[-180,   0], [-100,  90], [ -40,   0]],
  [[ -40,   0], [  30,  90], [ 180,   0]]
], [ // southern hemisphere
  [[-180,   0], [-160, -90], [-100,   0]],
  [[-100,   0], [ -60, -90], [ -20,   0]],
  [[ -20,   0], [  20, -90], [  80,   0]],
  [[  80,   0], [ 140, -90], [ 180,   0]]
]];

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_homolosine_js__WEBPACK_IMPORTED_MODULE_1__.homolosineRaw, lobes)
      .scale(152.63);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/interrupted/index.js":
/*!*****************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/interrupted/index.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var d3_array__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! d3-array */ "./node_modules/d3-array/src/merge.js");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../math.js */ "./node_modules/d3-geo-projection/src/math.js");




function pointEqual(a, b) {
  return (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(a[0] - b[0]) < _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon && (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(a[1] - b[1]) < _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon;
}

function interpolateLine(coordinates, m) {
  var i = -1,
      n = coordinates.length,
      p0 = coordinates[0],
      p1,
      dx,
      dy,
      resampled = [];
  while (++i < n) {
    p1 = coordinates[i];
    dx = (p1[0] - p0[0]) / m;
    dy = (p1[1] - p0[1]) / m;
    for (var j = 0; j < m; ++j) resampled.push([p0[0] + j * dx, p0[1] + j * dy]);
    p0 = p1;
  }
  resampled.push(p1);
  return resampled;
}

function interpolateSphere(lobes) {
  var coordinates = [],
      lobe,
      lambda0, phi0, phi1,
      lambda2, phi2,
      i, n = lobes[0].length;

  // Northern Hemisphere
  for (i = 0; i < n; ++i) {
    lobe = lobes[0][i];
    lambda0 = lobe[0][0], phi0 = lobe[0][1], phi1 = lobe[1][1];
    lambda2 = lobe[2][0], phi2 = lobe[2][1];
    coordinates.push(interpolateLine([
      [lambda0 + _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon, phi0 + _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon],
      [lambda0 + _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon, phi1 - _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon],
      [lambda2 - _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon, phi1 - _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon],
      [lambda2 - _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon, phi2 + _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon]
    ], 30));
  }

  // Southern Hemisphere
  for (i = lobes[1].length - 1; i >= 0; --i) {
    lobe = lobes[1][i];
    lambda0 = lobe[0][0], phi0 = lobe[0][1], phi1 = lobe[1][1];
    lambda2 = lobe[2][0], phi2 = lobe[2][1];
    coordinates.push(interpolateLine([
      [lambda2 - _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon, phi2 - _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon],
      [lambda2 - _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon, phi1 + _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon],
      [lambda0 + _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon, phi1 + _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon],
      [lambda0 + _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon, phi0 - _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon]
    ], 30));
  }

  return {
    type: "Polygon",
    coordinates: [(0,d3_array__WEBPACK_IMPORTED_MODULE_2__["default"])(coordinates)]
  };
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(project, lobes, inverse) {
  var sphere, bounds;

  function forward(lambda, phi) {
    var sign = phi < 0 ? -1 : +1, lobe = lobes[+(phi < 0)];
    for (var i = 0, n = lobe.length - 1; i < n && lambda > lobe[i][2][0]; ++i);
    var p = project(lambda - lobe[i][1][0], phi);
    p[0] += project(lobe[i][1][0], sign * phi > sign * lobe[i][0][1] ? lobe[i][0][1] : phi)[0];
    return p;
  }

  if (inverse) {
    forward.invert = inverse(forward);
  } else if (project.invert) {
    forward.invert = function(x, y) {
      var bound = bounds[+(y < 0)], lobe = lobes[+(y < 0)];
      for (var i = 0, n = bound.length; i < n; ++i) {
        var b = bound[i];
        if (b[0][0] <= x && x < b[1][0] && b[0][1] <= y && y < b[1][1]) {
          var p = project.invert(x - project(lobe[i][1][0], 0)[0], y);
          p[0] += lobe[i][1][0];
          return pointEqual(forward(p[0], p[1]), [x, y]) ? p : null;
        }
      }
    };
  }

  var p = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(forward),
      stream_ = p.stream;

  p.stream = function(stream) {
    var rotate = p.rotate(),
        rotateStream = stream_(stream),
        sphereStream = (p.rotate([0, 0]), stream_(stream));
    p.rotate(rotate);
    rotateStream.sphere = function() { (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoStream)(sphere, sphereStream); };
    return rotateStream;
  };
  
  p.lobes = function(_) {
    if (!arguments.length) return lobes.map(function(lobe) {
      return lobe.map(function(l) {
        return [
          [l[0][0] * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees, l[0][1] * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees],
          [l[1][0] * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees, l[1][1] * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees],
          [l[2][0] * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees, l[2][1] * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees]
        ];
      });
    });

    sphere = interpolateSphere(_);

    lobes = _.map(function(lobe) {
      return lobe.map(function(l) {
        return [
          [l[0][0] * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians, l[0][1] * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians],
          [l[1][0] * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians, l[1][1] * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians],
          [l[2][0] * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians, l[2][1] * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians]
        ];
      });
    });

    bounds = lobes.map(function(lobe) {
      return lobe.map(function(l) {
        var x0 = project(l[0][0], l[0][1])[0],
            x1 = project(l[2][0], l[2][1])[0],
            y0 = project(l[1][0], l[0][1])[1],
            y1 = project(l[1][0], l[1][1])[1],
            t;
        if (y0 > y1) t = y0, y0 = y1, y1 = t;
        return [[x0, y0], [x1, y1]];
      });
    });

    return p;
  };

  if (lobes != null) p.lobes(lobes);

  return p;
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/interrupted/mollweide.js":
/*!*********************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/interrupted/mollweide.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mollweide_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../mollweide.js */ "./node_modules/d3-geo-projection/src/mollweide.js");
/* harmony import */ var _index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./index.js */ "./node_modules/d3-geo-projection/src/interrupted/index.js");



var lobes = [[ // northern hemisphere
  [[-180,   0], [-100,  90], [ -40,   0]],
  [[ -40,   0], [  30,  90], [ 180,   0]]
], [ // southern hemisphere
  [[-180,   0], [-160, -90], [-100,   0]],
  [[-100,   0], [ -60, -90], [ -20,   0]],
  [[ -20,   0], [  20, -90], [  80,   0]],
  [[  80,   0], [ 140, -90], [ 180,   0]]
]];

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_mollweide_js__WEBPACK_IMPORTED_MODULE_1__.mollweideRaw, lobes)
      .scale(169.529);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/interrupted/mollweideHemispheres.js":
/*!********************************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/interrupted/mollweideHemispheres.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _mollweide_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../mollweide.js */ "./node_modules/d3-geo-projection/src/mollweide.js");
/* harmony import */ var _index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./index.js */ "./node_modules/d3-geo-projection/src/interrupted/index.js");



var lobes = [[ // northern hemisphere
  [[-180,   0], [ -90,  90], [   0,   0]],
  [[   0,   0], [  90,  90], [ 180,   0]]
], [ // southern hemisphere
  [[-180,   0], [ -90, -90], [   0,   0]],
  [[   0,   0], [  90, -90], [ 180,   0]]
]];

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_mollweide_js__WEBPACK_IMPORTED_MODULE_1__.mollweideRaw, lobes)
      .scale(169.529)
      .rotate([20, 0]);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/interrupted/quarticAuthalic.js":
/*!***************************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/interrupted/quarticAuthalic.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _hammer_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../hammer.js */ "./node_modules/d3-geo-projection/src/hammer.js");
/* harmony import */ var _index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./index.js */ "./node_modules/d3-geo-projection/src/interrupted/index.js");



var lobes = [[ // northern hemisphere
  [[-180,  0],  [-90,  90], [   0,  0]],
  [[   0,  0], [  90,  90], [ 180, 0]]
], [ // southern hemisphere
  [[-180, 0], [-90, -90], [  0, 0]],
  [[   0, 0], [ 90, -90], [180, 0]]
]];

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])((0,_hammer_js__WEBPACK_IMPORTED_MODULE_1__.hammerRaw)(Infinity), lobes)
      .rotate([20, 0])
      .scale(152.63);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/interrupted/sinuMollweide.js":
/*!*************************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/interrupted/sinuMollweide.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _sinuMollweide_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../sinuMollweide.js */ "./node_modules/d3-geo-projection/src/sinuMollweide.js");
/* harmony import */ var _index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./index.js */ "./node_modules/d3-geo-projection/src/interrupted/index.js");
/* harmony import */ var _newton_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../newton.js */ "./node_modules/d3-geo-projection/src/newton.js");




var lobes = [[ // northern hemisphere
  [[-180,  35], [ -30,  90], [   0,  35]],
  [[   0,  35], [  30,  90], [ 180,  35]]
], [ // southern hemisphere
  [[-180, -10], [-102, -90], [ -65, -10]],
  [[ -65, -10], [   5, -90], [  77, -10]],
  [[  77, -10], [ 103, -90], [ 180, -10]]
]];

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_sinuMollweide_js__WEBPACK_IMPORTED_MODULE_1__.sinuMollweideRaw, lobes, _newton_js__WEBPACK_IMPORTED_MODULE_2__.solve2d)
      .rotate([-20, -55])
      .scale(164.263)
      .center([0, -5.4036]);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/interrupted/sinusoidal.js":
/*!**********************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/interrupted/sinusoidal.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _sinusoidal_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../sinusoidal.js */ "./node_modules/d3-geo-projection/src/sinusoidal.js");
/* harmony import */ var _index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./index.js */ "./node_modules/d3-geo-projection/src/interrupted/index.js");



var lobes = [[ // northern hemisphere
  [[-180,   0], [-110,  90], [ -40,   0]],
  [[ -40,   0], [   0,  90], [  40,   0]],
  [[  40,   0], [ 110,  90], [ 180,   0]]
], [ // southern hemisphere
  [[-180,   0], [-110, -90], [ -40,   0]],
  [[ -40,   0], [   0, -90], [  40,   0]],
  [[  40,   0], [ 110, -90], [ 180,   0]]
]];

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_sinusoidal_js__WEBPACK_IMPORTED_MODULE_1__.sinusoidalRaw, lobes)
      .scale(152.63)
      .rotate([-20, 0]);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/kavrayskiy7.js":
/*!***********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/kavrayskiy7.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "kavrayskiy7Raw": () => (/* binding */ kavrayskiy7Raw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function kavrayskiy7Raw(lambda, phi) {
  return [3 / _math_js__WEBPACK_IMPORTED_MODULE_1__.tau * lambda * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(_math_js__WEBPACK_IMPORTED_MODULE_1__.pi * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi / 3 - phi * phi), phi];
}

kavrayskiy7Raw.invert = function(x, y) {
  return [_math_js__WEBPACK_IMPORTED_MODULE_1__.tau / 3 * x / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(_math_js__WEBPACK_IMPORTED_MODULE_1__.pi * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi / 3 - y * y), y];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(kavrayskiy7Raw)
      .scale(158.837);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/lagrange.js":
/*!********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/lagrange.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "lagrangeRaw": () => (/* binding */ lagrangeRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function lagrangeRaw(n) {

  function forward(lambda, phi) {
    if ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(phi) - _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi) < _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon) return [0, phi < 0 ? -2 : 2];
    var sinPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi),
        v = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.pow)((1 + sinPhi) / (1 - sinPhi), n / 2),
        c = 0.5 * (v + 1 / v) + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(lambda *= n);
    return [
      2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(lambda) / c,
      (v - 1 / v) / c
    ];
  }

  forward.invert = function(x, y) {
    var y0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(y);
    if ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(y0 - 2) < _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon) return x ? null : [0, (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(y) * _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi];
    if (y0 > 2) return null;

    x /= 2, y /= 2;
    var x2 = x * x,
        y2 = y * y,
        t = 2 * y / (1 + x2 + y2); // tanh(nPhi)
    t = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.pow)((1 + t) / (1 - t), 1 / n);
    return [
      (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)(2 * x, 1 - x2 - y2) / n,
      (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)((t - 1) / (t + 1))
    ];
  };

  return forward;
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  var n = 0.5,
      m = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjectionMutator)(lagrangeRaw),
      p = m(n);

  p.spacing = function(_) {
    return arguments.length ? m(n = +_) : n;
  };

  return p
      .scale(124.75);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/larrivee.js":
/*!********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/larrivee.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "larriveeRaw": () => (/* binding */ larriveeRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



var pi_sqrt2 = _math_js__WEBPACK_IMPORTED_MODULE_1__.pi / _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt2;

function larriveeRaw(lambda, phi) {
  return [
    lambda * (1 + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi))) / 2,
    phi / ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi / 2) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(lambda / 6))
  ];
}

larriveeRaw.invert = function(x, y) {
  var x0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(x),
      y0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(y),
      lambda = _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon,
      phi = _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi;
  if (y0 < pi_sqrt2) phi *= y0 / pi_sqrt2;
  else lambda += 6 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.acos)(pi_sqrt2 / y0);
  for (var i = 0; i < 25; i++) {
    var sinPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi),
        sqrtcosPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi)),
        sinPhi_2 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi / 2),
        cosPhi_2 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi / 2),
        sinLambda_6 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(lambda / 6),
        cosLambda_6 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(lambda / 6),
        f0 = 0.5 * lambda * (1 + sqrtcosPhi) - x0,
        f1 = phi / (cosPhi_2 * cosLambda_6) - y0,
        df0dPhi = sqrtcosPhi ? -0.25 * lambda * sinPhi / sqrtcosPhi : 0,
        df0dLambda = 0.5 * (1 + sqrtcosPhi),
        df1dPhi = (1 + 0.5 * phi * sinPhi_2 / cosPhi_2) / (cosPhi_2 * cosLambda_6),
        df1dLambda = (phi / cosPhi_2) * (sinLambda_6 / 6) / (cosLambda_6 * cosLambda_6),
        denom = df0dPhi * df1dLambda - df1dPhi * df0dLambda,
        dPhi = (f0 * df1dLambda - f1 * df0dLambda) / denom,
        dLambda = (f1 * df0dPhi - f0 * df1dPhi) / denom;
    phi -= dPhi;
    lambda -= dLambda;
    if ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(dPhi) < _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon && (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(dLambda) < _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon) break;
  }
  return [x < 0 ? -lambda : lambda, y < 0 ? -phi : phi];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(larriveeRaw)
      .scale(97.2672);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/laskowski.js":
/*!*********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/laskowski.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "laskowskiRaw": () => (/* binding */ laskowskiRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function laskowskiRaw(lambda, phi) {
  var lambda2 = lambda * lambda, phi2 = phi * phi;
  return [
    lambda * (0.975534 + phi2 * (-0.119161 + lambda2 * -0.0143059 + phi2 * -0.0547009)),
    phi * (1.00384 + lambda2 * (0.0802894 + phi2 * -0.02855 + lambda2 * 0.000199025) + phi2 * (0.0998909 + phi2 * -0.0491032))
  ];
}

laskowskiRaw.invert = function(x, y) {
  var lambda = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(x) * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi,
      phi = y / 2,
      i = 50;
  do {
    var lambda2 = lambda * lambda,
        phi2 = phi * phi,
        lambdaPhi = lambda * phi,
        fx = lambda * (0.975534 + phi2 * (-0.119161 + lambda2 * -0.0143059 + phi2 * -0.0547009)) - x,
        fy = phi * (1.00384 + lambda2 * (0.0802894 + phi2 * -0.02855 + lambda2 * 0.000199025) + phi2 * (0.0998909 + phi2 * -0.0491032)) - y,
        deltaxDeltaLambda = 0.975534 - phi2 * (0.119161 + 3 * lambda2 * 0.0143059 + phi2 * 0.0547009),
        deltaxDeltaPhi = -lambdaPhi * (2 * 0.119161 + 4 * 0.0547009 * phi2 + 2 * 0.0143059 * lambda2),
        deltayDeltaLambda = lambdaPhi * (2 * 0.0802894 + 4 * 0.000199025 * lambda2 + 2 * -0.02855 * phi2),
        deltayDeltaPhi = 1.00384 + lambda2 * (0.0802894 + 0.000199025 * lambda2) + phi2 * (3 * (0.0998909 - 0.02855 * lambda2) - 5 * 0.0491032 * phi2),
        denominator = deltaxDeltaPhi * deltayDeltaLambda - deltayDeltaPhi * deltaxDeltaLambda,
        deltaLambda = (fy * deltaxDeltaPhi - fx * deltayDeltaPhi) / denominator,
        deltaPhi = (fx * deltayDeltaLambda - fy * deltaxDeltaLambda) / denominator;
    lambda -= deltaLambda, phi -= deltaPhi;
  } while (((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(deltaLambda) > _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon || (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(deltaPhi) > _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon) && --i > 0);
  return i && [lambda, phi];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(laskowskiRaw)
      .scale(139.98);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/littrow.js":
/*!*******************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/littrow.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "littrowRaw": () => (/* binding */ littrowRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function littrowRaw(lambda, phi) {
  return [
    (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(lambda) / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi),
    (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.tan)(phi) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(lambda)
  ];
}

littrowRaw.invert = function(x, y) {
  var x2 = x * x,
      y2 = y * y,
      y2_1 = y2 + 1,
      x2_y2_1 = x2 + y2_1,
      cosPhi = x
          ? _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt1_2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)((x2_y2_1 - (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(x2_y2_1 * x2_y2_1 - 4 * x2)) / x2)
          : 1 / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(y2_1);
  return [
    (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(x * cosPhi),
    (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(y) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.acos)(cosPhi)
  ];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(littrowRaw)
      .scale(144.049)
      .clipAngle(90 - 1e-3);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/loximuthal.js":
/*!**********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/loximuthal.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "loximuthalRaw": () => (/* binding */ loximuthalRaw)
/* harmony export */ });
/* harmony import */ var _parallel1_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./parallel1.js */ "./node_modules/d3-geo-projection/src/parallel1.js");
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function loximuthalRaw(phi0) {
  var cosPhi0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.cos)(phi0),
      tanPhi0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.tan)(_math_js__WEBPACK_IMPORTED_MODULE_0__.quarterPi + phi0 / 2);

  function forward(lambda, phi) {
    var y = phi - phi0,
        x = (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.abs)(y) < _math_js__WEBPACK_IMPORTED_MODULE_0__.epsilon ? lambda * cosPhi0
            : (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.abs)(x = _math_js__WEBPACK_IMPORTED_MODULE_0__.quarterPi + phi / 2) < _math_js__WEBPACK_IMPORTED_MODULE_0__.epsilon || (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.abs)((0,_math_js__WEBPACK_IMPORTED_MODULE_0__.abs)(x) - _math_js__WEBPACK_IMPORTED_MODULE_0__.halfPi) < _math_js__WEBPACK_IMPORTED_MODULE_0__.epsilon
            ? 0 : lambda * y / (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.log)((0,_math_js__WEBPACK_IMPORTED_MODULE_0__.tan)(x) / tanPhi0);
    return [x, y];
  }

  forward.invert = function(x, y) {
    var lambda,
        phi = y + phi0;
    return [
      (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.abs)(y) < _math_js__WEBPACK_IMPORTED_MODULE_0__.epsilon ? x / cosPhi0
          : ((0,_math_js__WEBPACK_IMPORTED_MODULE_0__.abs)(lambda = _math_js__WEBPACK_IMPORTED_MODULE_0__.quarterPi + phi / 2) < _math_js__WEBPACK_IMPORTED_MODULE_0__.epsilon || (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.abs)((0,_math_js__WEBPACK_IMPORTED_MODULE_0__.abs)(lambda) - _math_js__WEBPACK_IMPORTED_MODULE_0__.halfPi) < _math_js__WEBPACK_IMPORTED_MODULE_0__.epsilon) ? 0
          : x * (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.log)((0,_math_js__WEBPACK_IMPORTED_MODULE_0__.tan)(lambda) / tanPhi0) / y,
      phi
    ];
  };

  return forward;
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,_parallel1_js__WEBPACK_IMPORTED_MODULE_1__["default"])(loximuthalRaw)
      .parallel(40)
      .scale(158.837);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/math.js":
/*!****************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/math.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "abs": () => (/* binding */ abs),
/* harmony export */   "acos": () => (/* binding */ acos),
/* harmony export */   "arcosh": () => (/* binding */ arcosh),
/* harmony export */   "arsinh": () => (/* binding */ arsinh),
/* harmony export */   "asin": () => (/* binding */ asin),
/* harmony export */   "atan": () => (/* binding */ atan),
/* harmony export */   "atan2": () => (/* binding */ atan2),
/* harmony export */   "ceil": () => (/* binding */ ceil),
/* harmony export */   "cos": () => (/* binding */ cos),
/* harmony export */   "cosh": () => (/* binding */ cosh),
/* harmony export */   "degrees": () => (/* binding */ degrees),
/* harmony export */   "epsilon": () => (/* binding */ epsilon),
/* harmony export */   "epsilon2": () => (/* binding */ epsilon2),
/* harmony export */   "exp": () => (/* binding */ exp),
/* harmony export */   "floor": () => (/* binding */ floor),
/* harmony export */   "halfPi": () => (/* binding */ halfPi),
/* harmony export */   "log": () => (/* binding */ log),
/* harmony export */   "max": () => (/* binding */ max),
/* harmony export */   "min": () => (/* binding */ min),
/* harmony export */   "pi": () => (/* binding */ pi),
/* harmony export */   "pow": () => (/* binding */ pow),
/* harmony export */   "quarterPi": () => (/* binding */ quarterPi),
/* harmony export */   "radians": () => (/* binding */ radians),
/* harmony export */   "round": () => (/* binding */ round),
/* harmony export */   "sign": () => (/* binding */ sign),
/* harmony export */   "sin": () => (/* binding */ sin),
/* harmony export */   "sinci": () => (/* binding */ sinci),
/* harmony export */   "sinh": () => (/* binding */ sinh),
/* harmony export */   "sqrt": () => (/* binding */ sqrt),
/* harmony export */   "sqrt1_2": () => (/* binding */ sqrt1_2),
/* harmony export */   "sqrt2": () => (/* binding */ sqrt2),
/* harmony export */   "sqrtPi": () => (/* binding */ sqrtPi),
/* harmony export */   "tan": () => (/* binding */ tan),
/* harmony export */   "tanh": () => (/* binding */ tanh),
/* harmony export */   "tau": () => (/* binding */ tau)
/* harmony export */ });
var abs = Math.abs;
var atan = Math.atan;
var atan2 = Math.atan2;
var ceil = Math.ceil;
var cos = Math.cos;
var exp = Math.exp;
var floor = Math.floor;
var log = Math.log;
var max = Math.max;
var min = Math.min;
var pow = Math.pow;
var round = Math.round;
var sign = Math.sign || function(x) { return x > 0 ? 1 : x < 0 ? -1 : 0; };
var sin = Math.sin;
var tan = Math.tan;

var epsilon = 1e-6;
var epsilon2 = 1e-12;
var pi = Math.PI;
var halfPi = pi / 2;
var quarterPi = pi / 4;
var sqrt1_2 = Math.SQRT1_2;
var sqrt2 = sqrt(2);
var sqrtPi = sqrt(pi);
var tau = pi * 2;
var degrees = 180 / pi;
var radians = pi / 180;

function sinci(x) {
  return x ? x / Math.sin(x) : 1;
}

function asin(x) {
  return x > 1 ? halfPi : x < -1 ? -halfPi : Math.asin(x);
}

function acos(x) {
  return x > 1 ? 0 : x < -1 ? pi : Math.acos(x);
}

function sqrt(x) {
  return x > 0 ? Math.sqrt(x) : 0;
}

function tanh(x) {
  x = exp(2 * x);
  return (x - 1) / (x + 1);
}

function sinh(x) {
  return (exp(x) - exp(-x)) / 2;
}

function cosh(x) {
  return (exp(x) + exp(-x)) / 2;
}

function arsinh(x) {
  return log(x + sqrt(x * x + 1));
}

function arcosh(x) {
  return log(x + sqrt(x * x - 1));
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/miller.js":
/*!******************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/miller.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "millerRaw": () => (/* binding */ millerRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function millerRaw(lambda, phi) {
  return [lambda, 1.25 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.log)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.tan)(_math_js__WEBPACK_IMPORTED_MODULE_1__.quarterPi + 0.4 * phi))];
}

millerRaw.invert = function(x, y) {
  return [x, 2.5 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.exp)(0.8 * y)) - 0.625 * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(millerRaw)
      .scale(108.318);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/modifiedStereographic.js":
/*!*********************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/modifiedStereographic.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ modifiedStereographic),
/* harmony export */   "modifiedStereographicAlaska": () => (/* binding */ modifiedStereographicAlaska),
/* harmony export */   "modifiedStereographicGs48": () => (/* binding */ modifiedStereographicGs48),
/* harmony export */   "modifiedStereographicGs50": () => (/* binding */ modifiedStereographicGs50),
/* harmony export */   "modifiedStereographicLee": () => (/* binding */ modifiedStereographicLee),
/* harmony export */   "modifiedStereographicMiller": () => (/* binding */ modifiedStereographicMiller),
/* harmony export */   "modifiedStereographicRaw": () => (/* binding */ modifiedStereographicRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function modifiedStereographicRaw(C) {
  var m = C.length - 1;

  function forward(lambda, phi) {
    var cosPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi),
        k = 2 / (1 + cosPhi * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(lambda)),
        zr = k * cosPhi * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(lambda),
        zi = k * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi),
        i = m,
        w = C[i],
        ar = w[0],
        ai = w[1],
        t;
    while (--i >= 0) {
      w = C[i];
      ar = w[0] + zr * (t = ar) - zi * ai;
      ai = w[1] + zr * ai + zi * t;
    }
    ar = zr * (t = ar) - zi * ai;
    ai = zr * ai + zi * t;
    return [ar, ai];
  }

  forward.invert = function(x, y) {
    var i = 20,
        zr = x,
        zi = y;
    do {
      var j = m,
          w = C[j],
          ar = w[0],
          ai = w[1],
          br = 0,
          bi = 0,
          t;

      while (--j >= 0) {
        w = C[j];
        br = ar + zr * (t = br) - zi * bi;
        bi = ai + zr * bi + zi * t;
        ar = w[0] + zr * (t = ar) - zi * ai;
        ai = w[1] + zr * ai + zi * t;
      }
      br = ar + zr * (t = br) - zi * bi;
      bi = ai + zr * bi + zi * t;
      ar = zr * (t = ar) - zi * ai - x;
      ai = zr * ai + zi * t - y;

      var denominator = br * br + bi * bi, deltar, deltai;
      zr -= deltar = (ar * br + ai * bi) / denominator;
      zi -= deltai = (ai * br - ar * bi) / denominator;
    } while ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(deltar) + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(deltai) > _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon * _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon && --i > 0);

    if (i) {
      var rho = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(zr * zr + zi * zi),
          c = 2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan)(rho * 0.5),
          sinc = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(c);
      return [(0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)(zr * sinc, rho * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(c)), rho ? (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(zi * sinc / rho) : 0];
    }
  };

  return forward;
}

var alaska = [[0.9972523, 0], [0.0052513, -0.0041175], [0.0074606, 0.0048125], [-0.0153783, -0.1968253], [0.0636871, -0.1408027], [0.3660976, -0.2937382]],
    gs48 = [[0.98879, 0], [0, 0], [-0.050909, 0], [0, 0], [0.075528, 0]],
    gs50 = [[0.9842990, 0], [0.0211642, 0.0037608], [-0.1036018, -0.0575102], [-0.0329095, -0.0320119], [0.0499471, 0.1223335], [0.0260460, 0.0899805], [0.0007388, -0.1435792], [0.0075848, -0.1334108], [-0.0216473, 0.0776645], [-0.0225161, 0.0853673]],
    miller = [[0.9245, 0], [0, 0], [0.01943, 0]],
    lee = [[0.721316, 0], [0, 0], [-0.00881625, -0.00617325]];

function modifiedStereographicAlaska() {
  return modifiedStereographic(alaska, [152, -64])
      .scale(1400)
      .center([-160.908, 62.4864])
      .clipAngle(30)
      .angle(7.8);
}

function modifiedStereographicGs48() {
  return modifiedStereographic(gs48, [95, -38])
      .scale(1000)
      .clipAngle(55)
      .center([-96.5563, 38.8675]);
}

function modifiedStereographicGs50() {
  return modifiedStereographic(gs50, [120, -45])
      .scale(359.513)
      .clipAngle(55)
      .center([-117.474, 53.0628]);
}

function modifiedStereographicMiller() {
  return modifiedStereographic(miller, [-20, -18])
      .scale(209.091)
      .center([20, 16.7214])
      .clipAngle(82);
}

function modifiedStereographicLee() {
  return modifiedStereographic(lee, [165, 10])
      .scale(250)
      .clipAngle(130)
      .center([-165, -10]);
}

function modifiedStereographic(coefficients, rotate) {
  var p = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(modifiedStereographicRaw(coefficients)).rotate(rotate).clipAngle(90),
      r = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoRotation)(rotate),
      center = p.center;

  delete p.rotate;

  p.center = function(_) {
    return arguments.length ? center(r(_)) : r.invert(center());
  };

  return p;
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/mollweide.js":
/*!*********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/mollweide.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "mollweideBromleyRaw": () => (/* binding */ mollweideBromleyRaw),
/* harmony export */   "mollweideBromleyTheta": () => (/* binding */ mollweideBromleyTheta),
/* harmony export */   "mollweideRaw": () => (/* binding */ mollweideRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function mollweideBromleyTheta(cp, phi) {
  var cpsinPhi = cp * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi), i = 30, delta;
  do phi -= delta = (phi + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi) - cpsinPhi) / (1 + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi));
  while ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(delta) > _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon && --i > 0);
  return phi / 2;
}

function mollweideBromleyRaw(cx, cy, cp) {

  function forward(lambda, phi) {
    return [cx * lambda * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi = mollweideBromleyTheta(cp, phi)), cy * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi)];
  }

  forward.invert = function(x, y) {
    return y = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(y / cy), [x / (cx * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(y)), (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)((2 * y + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(2 * y)) / cp)];
  };

  return forward;
}

var mollweideRaw = mollweideBromleyRaw(_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt2 / _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi, _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt2, _math_js__WEBPACK_IMPORTED_MODULE_1__.pi);

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(mollweideRaw)
      .scale(169.529);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/mtFlatPolarParabolic.js":
/*!********************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/mtFlatPolarParabolic.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "mtFlatPolarParabolicRaw": () => (/* binding */ mtFlatPolarParabolicRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



var sqrt6 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(6),
    sqrt7 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(7);

function mtFlatPolarParabolicRaw(lambda, phi) {
  var theta = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(7 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi) / (3 * sqrt6));
  return [
    sqrt6 * lambda * (2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(2 * theta / 3) - 1) / sqrt7,
    9 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(theta / 3) / sqrt7
  ];
}

mtFlatPolarParabolicRaw.invert = function(x, y) {
  var theta = 3 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(y * sqrt7 / 9);
  return [
    x * sqrt7 / (sqrt6 * (2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(2 * theta / 3) - 1)),
    (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(theta) * 3 * sqrt6 / 7)
  ];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(mtFlatPolarParabolicRaw)
      .scale(164.859);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/mtFlatPolarQuartic.js":
/*!******************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/mtFlatPolarQuartic.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "mtFlatPolarQuarticRaw": () => (/* binding */ mtFlatPolarQuarticRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function mtFlatPolarQuarticRaw(lambda, phi) {
  var k = (1 + _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt1_2) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi),
      theta = phi;
  for (var i = 0, delta; i < 25; i++) {
    theta -= delta = ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(theta / 2) + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(theta) - k) / (0.5 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(theta / 2) + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(theta));
    if ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(delta) < _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon) break;
  }
  return [
    lambda * (1 + 2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(theta) / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(theta / 2)) / (3 * _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt2),
    2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(3) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(theta / 2) / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(2 + _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt2)
  ];
}

mtFlatPolarQuarticRaw.invert = function(x, y) {
  var sinTheta_2 = y * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(2 + _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt2) / (2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(3)),
      theta = 2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(sinTheta_2);
  return [
    3 * _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt2 * x / (1 + 2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(theta) / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(theta / 2)),
    (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)((sinTheta_2 + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(theta)) / (1 + _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt1_2))
  ];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(mtFlatPolarQuarticRaw)
      .scale(188.209);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/mtFlatPolarSinusoidal.js":
/*!*********************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/mtFlatPolarSinusoidal.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "mtFlatPolarSinusoidalRaw": () => (/* binding */ mtFlatPolarSinusoidalRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function mtFlatPolarSinusoidalRaw(lambda, phi) {
  var A = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(6 / (4 + _math_js__WEBPACK_IMPORTED_MODULE_1__.pi)),
      k = (1 + _math_js__WEBPACK_IMPORTED_MODULE_1__.pi / 4) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi),
      theta = phi / 2;
  for (var i = 0, delta; i < 25; i++) {
    theta -= delta = (theta / 2 + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(theta) - k) / (0.5 + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(theta));
    if ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(delta) < _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon) break;
  }
  return [
    A * (0.5 + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(theta)) * lambda / 1.5,
    A * theta
  ];
}

mtFlatPolarSinusoidalRaw.invert = function(x, y) {
  var A = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(6 / (4 + _math_js__WEBPACK_IMPORTED_MODULE_1__.pi)),
      theta = y / A;
  if ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(theta) - _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi) < _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon) theta = theta < 0 ? -_math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi : _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi;
  return [
    1.5 * x / (A * (0.5 + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(theta))),
    (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)((theta / 2 + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(theta)) / (1 + _math_js__WEBPACK_IMPORTED_MODULE_1__.pi / 4))
  ];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(mtFlatPolarSinusoidalRaw)
      .scale(166.518);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/naturalEarth2.js":
/*!*************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/naturalEarth2.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "naturalEarth2Raw": () => (/* binding */ naturalEarth2Raw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function naturalEarth2Raw(lambda, phi) {
  var phi2 = phi * phi, phi4 = phi2 * phi2, phi6 = phi2 * phi4;
  return [
    lambda * (0.84719 - 0.13063 * phi2 + phi6 * phi6 * (-0.04515 + 0.05494 * phi2 - 0.02326 * phi4 + 0.00331 * phi6)),
    phi * (1.01183 + phi4 * phi4 * (-0.02625 + 0.01926 * phi2 - 0.00396 * phi4))
  ];
}

naturalEarth2Raw.invert = function(x, y) {
  var phi = y, i = 25, delta, phi2, phi4, phi6;
  do {
    phi2 = phi * phi; phi4 = phi2 * phi2;
    phi -= delta = ((phi * (1.01183 + phi4 * phi4 * (-0.02625 + 0.01926 * phi2 - 0.00396 * phi4))) - y) /
      (1.01183 + phi4 * phi4 * ((9 * -0.02625) + (11 * 0.01926) * phi2 + (13 * -0.00396) * phi4));
  } while ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(delta) > _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon2 && --i > 0);
  phi2 = phi * phi; phi4 = phi2 * phi2; phi6 = phi2 * phi4;
  return [
    x / (0.84719 - 0.13063 * phi2 + phi6 * phi6 * (-0.04515 + 0.05494 * phi2 - 0.02326 * phi4 + 0.00331 * phi6)),
    phi
  ];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(naturalEarth2Raw)
      .scale(175.295);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/nellHammer.js":
/*!**********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/nellHammer.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "nellHammerRaw": () => (/* binding */ nellHammerRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function nellHammerRaw(lambda, phi) {
  return [
    lambda * (1 + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi)) / 2,
    2 * (phi - (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.tan)(phi / 2))
  ];
}

nellHammerRaw.invert = function(x, y) {
  var p = y / 2;
  for (var i = 0, delta = Infinity; i < 10 && (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(delta) > _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon; ++i) {
    var c = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(y / 2);
    y -= delta = (y - (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.tan)(y / 2) - p) / (1 - 0.5 / (c * c));
  }
  return [
    2 * x / (1 + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(y)),
    y
  ];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(nellHammerRaw)
      .scale(152.63);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/newton.js":
/*!******************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/newton.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "solve": () => (/* binding */ solve),
/* harmony export */   "solve2d": () => (/* binding */ solve2d)
/* harmony export */ });
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");


// Approximate Newton-Raphson
// Solve f(x) = y, start from x
function solve(f, y, x) {
  var steps = 100, delta, f0, f1;
  x = x === undefined ? 0 : +x;
  y = +y;
  do {
    f0 = f(x);
    f1 = f(x + _math_js__WEBPACK_IMPORTED_MODULE_0__.epsilon);
    if (f0 === f1) f1 = f0 + _math_js__WEBPACK_IMPORTED_MODULE_0__.epsilon;
    x -= delta = (-1 * _math_js__WEBPACK_IMPORTED_MODULE_0__.epsilon * (f0 - y)) / (f0 - f1);
  } while (steps-- > 0 && (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.abs)(delta) > _math_js__WEBPACK_IMPORTED_MODULE_0__.epsilon);
  return steps < 0 ? NaN : x;
}

// Approximate Newton-Raphson in 2D
// Solve f(a,b) = [x,y]
function solve2d(f, MAX_ITERATIONS, eps) {
  if (MAX_ITERATIONS === undefined) MAX_ITERATIONS = 40;
  if (eps === undefined) eps = _math_js__WEBPACK_IMPORTED_MODULE_0__.epsilon2;
  return function(x, y, a, b) {
    var err2, da, db;
    a = a === undefined ? 0 : +a;
    b = b === undefined ? 0 : +b;
    for (var i = 0; i < MAX_ITERATIONS; i++) {
      var p = f(a, b),
        // diffs
        tx = p[0] - x,
        ty = p[1] - y;
      if ((0,_math_js__WEBPACK_IMPORTED_MODULE_0__.abs)(tx) < eps && (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.abs)(ty) < eps) break; // we're there!

      // backtrack if we overshot
      var h = tx * tx + ty * ty;
      if (h > err2) {
        a -= da /= 2;
        b -= db /= 2;
        continue;
      }
      err2 = h;

      // partial derivatives
      var ea = (a > 0 ? -1 : 1) * eps,
        eb = (b > 0 ? -1 : 1) * eps,
        pa = f(a + ea, b),
        pb = f(a, b + eb),
        dxa = (pa[0] - p[0]) / ea,
        dya = (pa[1] - p[1]) / ea,
        dxb = (pb[0] - p[0]) / eb,
        dyb = (pb[1] - p[1]) / eb,
        // determinant
        D = dyb * dxa - dya * dxb,
        // newton step — or half-step for small D
        l = ((0,_math_js__WEBPACK_IMPORTED_MODULE_0__.abs)(D) < 0.5 ? 0.5 : 1) / D;
      da = (ty * dxb - tx * dyb) * l;
      db = (tx * dya - ty * dxa) * l;
      a += da;
      b += db;
      if ((0,_math_js__WEBPACK_IMPORTED_MODULE_0__.abs)(da) < eps && (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.abs)(db) < eps) break; // we're crawling
    }
    return [a, b];
  };
}

/***/ }),

/***/ "./node_modules/d3-geo-projection/src/nicolosi.js":
/*!********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/nicolosi.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "nicolosiRaw": () => (/* binding */ nicolosiRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");
/* harmony import */ var _newton_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./newton.js */ "./node_modules/d3-geo-projection/src/newton.js");




// Based on Torben Jansen's implementation
// https://beta.observablehq.com/@toja/nicolosi-globular-projection
// https://beta.observablehq.com/@toja/nicolosi-globular-inverse

function nicolosiRaw(lambda, phi) {
  var sinPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi),
    q = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi),
    s = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(lambda);

  if (lambda === 0 || (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(phi) === _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi) return [0, phi];
  else if (phi === 0) return [lambda, 0];
  else if ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(lambda) === _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi) return [lambda * q, _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi * sinPhi];

  var b = _math_js__WEBPACK_IMPORTED_MODULE_1__.pi / (2 * lambda) - (2 * lambda) / _math_js__WEBPACK_IMPORTED_MODULE_1__.pi,
    c = (2 * phi) / _math_js__WEBPACK_IMPORTED_MODULE_1__.pi,
    d = (1 - c * c) / (sinPhi - c);

  var b2 = b * b,
    d2 = d * d,
    b2d2 = 1 + b2 / d2,
    d2b2 = 1 + d2 / b2;

  var M = ((b * sinPhi) / d - b / 2) / b2d2,
    N = ((d2 * sinPhi) / b2 + d / 2) / d2b2,
    m = M * M + (q * q) / b2d2,
    n = N * N - ((d2 * sinPhi * sinPhi) / b2 + d * sinPhi - 1) / d2b2;

  return [
    _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi * (M + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(m) * s),
    _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi * (N + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(n < 0 ? 0 : n) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(-phi * b) * s)
  ];
}

nicolosiRaw.invert = function(x, y) {

  x /= _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi;
  y /= _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi;

  var x2 = x * x,
    y2 = y * y,
    x2y2 = x2 + y2,
    pi2 = _math_js__WEBPACK_IMPORTED_MODULE_1__.pi * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi;

  return [
    x ? (x2y2 -1 + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)((1 - x2y2) * (1 - x2y2) + 4 * x2)) / (2 * x) * _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi : 0,
    (0,_newton_js__WEBPACK_IMPORTED_MODULE_2__.solve)(function(phi) {
      return (
        x2y2 * (_math_js__WEBPACK_IMPORTED_MODULE_1__.pi * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi) - 2 * phi) * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi +
        4 * phi * phi * (y - (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi)) +
        2 * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi * phi -
        pi2 * y
      );
    }, 0)
  ];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(nicolosiRaw)
    .scale(127.267);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/noop.js":
/*!****************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/noop.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (() => {});


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/parallel1.js":
/*!*********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/parallel1.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(projectAt) {
  var phi0 = 0,
      m = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjectionMutator)(projectAt),
      p = m(phi0);

  p.parallel = function(_) {
    return arguments.length ? m(phi0 = _ * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians) : phi0 * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees;
  };

  return p;
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/patterson.js":
/*!*********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/patterson.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "pattersonRaw": () => (/* binding */ pattersonRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



// Based on Java implementation by Bojan Savric.
// https://github.com/OSUCartography/JMapProjLib/blob/master/src/com/jhlabs/map/proj/PattersonProjection.java

var pattersonK1 = 1.0148,
    pattersonK2 = 0.23185,
    pattersonK3 = -0.14499,
    pattersonK4 = 0.02406,
    pattersonC1 = pattersonK1,
    pattersonC2 = 5 * pattersonK2,
    pattersonC3 = 7 * pattersonK3,
    pattersonC4 = 9 * pattersonK4,
    pattersonYmax = 1.790857183;

function pattersonRaw(lambda, phi) {
  var phi2 = phi * phi;
  return [
    lambda,
    phi * (pattersonK1 + phi2 * phi2 * (pattersonK2 + phi2 * (pattersonK3 + pattersonK4 * phi2)))
  ];
}

pattersonRaw.invert = function(x, y) {
  if (y > pattersonYmax) y = pattersonYmax;
  else if (y < -pattersonYmax) y = -pattersonYmax;
  var yc = y, delta;

  do { // Newton-Raphson
    var y2 = yc * yc;
    yc -= delta = ((yc * (pattersonK1 + y2 * y2 * (pattersonK2 + y2 * (pattersonK3 + pattersonK4 * y2)))) - y) / (pattersonC1 + y2 * y2 * (pattersonC2 + y2 * (pattersonC3 + pattersonC4 * y2)));
  } while ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(delta) > _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon);

  return [x, yc];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(pattersonRaw)
      .scale(139.319);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/polyconic.js":
/*!*********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/polyconic.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "polyconicRaw": () => (/* binding */ polyconicRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function polyconicRaw(lambda, phi) {
  if ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(phi) < _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon) return [lambda, 0];
  var tanPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.tan)(phi),
      k = lambda * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi);
  return [
    (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(k) / tanPhi,
    phi + (1 - (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(k)) / tanPhi
  ];
}

polyconicRaw.invert = function(x, y) {
  if ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(y) < _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon) return [x, 0];
  var k = x * x + y * y,
      phi = y * 0.5,
      i = 10, delta;
  do {
    var tanPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.tan)(phi),
        secPhi = 1 / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi),
        j = k - 2 * y * phi + phi * phi;
    phi -= delta = (tanPhi * j + 2 * (phi - y)) / (2 + j * secPhi * secPhi + 2 * (phi - y) * tanPhi);
  } while ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(delta) > _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon && --i > 0);
  tanPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.tan)(phi);
  return [
    ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(y) < (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(phi + 1 / tanPhi) ? (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(x * tanPhi) : (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(y) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(x) * ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.acos)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(x * tanPhi)) + _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi)) / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi),
    phi
  ];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(polyconicRaw)
      .scale(103.74);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/polyhedral/butterfly.js":
/*!********************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/polyhedral/butterfly.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../math.js */ "./node_modules/d3-geo-projection/src/math.js");
/* harmony import */ var _index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./index.js */ "./node_modules/d3-geo-projection/src/polyhedral/index.js");
/* harmony import */ var _octahedron_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./octahedron.js */ "./node_modules/d3-geo-projection/src/polyhedral/octahedron.js");





/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(faceProjection) {

  faceProjection = faceProjection || function(face) {
    var c = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoCentroid)({type: "MultiPoint", coordinates: face});
    return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoGnomonic)().scale(1).translate([0, 0]).rotate([-c[0], -c[1]]);
  };

  var faces = _octahedron_js__WEBPACK_IMPORTED_MODULE_1__["default"].map(function(face) {
    return {face: face, project: faceProjection(face)};
  });

  [-1, 0, 0, 1, 0, 1, 4, 5].forEach(function(d, i) {
    var node = faces[d];
    node && (node.children || (node.children = [])).push(faces[i]);
  });

  return (0,_index_js__WEBPACK_IMPORTED_MODULE_2__["default"])(faces[0], function(lambda, phi) {
        return faces[lambda < -_math_js__WEBPACK_IMPORTED_MODULE_3__.pi / 2 ? phi < 0 ? 6 : 4
            : lambda < 0 ? phi < 0 ? 2 : 0
            : lambda < _math_js__WEBPACK_IMPORTED_MODULE_3__.pi / 2 ? phi < 0 ? 3 : 1
            : phi < 0 ? 7 : 5];
      })
      .angle(-30)
      .scale(101.858)
      .center([0, 45]);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/polyhedral/collignon.js":
/*!********************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/polyhedral/collignon.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _collignon_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../collignon.js */ "./node_modules/d3-geo-projection/src/collignon.js");
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../math.js */ "./node_modules/d3-geo-projection/src/math.js");
/* harmony import */ var _index_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./index.js */ "./node_modules/d3-geo-projection/src/polyhedral/index.js");
/* harmony import */ var _octahedron_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./octahedron.js */ "./node_modules/d3-geo-projection/src/polyhedral/octahedron.js");






var kx = 2 / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(3);

function collignonK(a, b) {
  var p = (0,_collignon_js__WEBPACK_IMPORTED_MODULE_2__.collignonRaw)(a, b);
  return [p[0] * kx, p[1]];
}

collignonK.invert = function(x,y) {
  return _collignon_js__WEBPACK_IMPORTED_MODULE_2__.collignonRaw.invert(x / kx, y);
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(faceProjection) {

  faceProjection = faceProjection || function(face) {
    var c = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoCentroid)({type: "MultiPoint", coordinates: face});
    return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(collignonK).translate([0, 0]).scale(1).rotate(c[1] > 0 ? [-c[0], 0] : [180 - c[0], 180]);
  };

  var faces = _octahedron_js__WEBPACK_IMPORTED_MODULE_3__["default"].map(function(face) {
    return {face: face, project: faceProjection(face)};
  });

  [-1, 0, 0, 1, 0, 1, 4, 5].forEach(function(d, i) {
    var node = faces[d];
    node && (node.children || (node.children = [])).push(faces[i]);
  });

  return (0,_index_js__WEBPACK_IMPORTED_MODULE_4__["default"])(faces[0], function(lambda, phi) {
        return faces[lambda < -_math_js__WEBPACK_IMPORTED_MODULE_1__.pi / 2 ? phi < 0 ? 6 : 4
            : lambda < 0 ? phi < 0 ? 2 : 0
            : lambda < _math_js__WEBPACK_IMPORTED_MODULE_1__.pi / 2 ? phi < 0 ? 3 : 1
            : phi < 0 ? 7 : 5];
      })
      .angle(-30)
      .scale(121.906)
      .center([0, 48.5904]);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/polyhedral/index.js":
/*!****************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/polyhedral/index.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../math.js */ "./node_modules/d3-geo-projection/src/math.js");
/* harmony import */ var _matrix_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./matrix.js */ "./node_modules/d3-geo-projection/src/polyhedral/matrix.js");




// Creates a polyhedral projection.
//  * root: a spanning tree of polygon faces.  Nodes are automatically
//    augmented with a transform matrix.
//  * face: a function that returns the appropriate node for a given {lambda, phi}
//    point (radians).
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(root, face) {

  recurse(root, {transform: null});

  function recurse(node, parent) {
    node.edges = faceEdges(node.face);
    // Find shared edge.
    if (parent.face) {
      var shared = node.shared = sharedEdge(node.face, parent.face),
          m = (0,_matrix_js__WEBPACK_IMPORTED_MODULE_1__["default"])(shared.map(parent.project), shared.map(node.project));
      node.transform = parent.transform ? (0,_matrix_js__WEBPACK_IMPORTED_MODULE_1__.multiply)(parent.transform, m) : m;
      // Replace shared edge in parent edges array.
      var edges = parent.edges;
      for (var i = 0, n = edges.length; i < n; ++i) {
        if (pointEqual(shared[0], edges[i][1]) && pointEqual(shared[1], edges[i][0])) edges[i] = node;
        if (pointEqual(shared[0], edges[i][0]) && pointEqual(shared[1], edges[i][1])) edges[i] = node;
      }
      edges = node.edges;
      for (i = 0, n = edges.length; i < n; ++i) {
        if (pointEqual(shared[0], edges[i][0]) && pointEqual(shared[1], edges[i][1])) edges[i] = parent;
        if (pointEqual(shared[0], edges[i][1]) && pointEqual(shared[1], edges[i][0])) edges[i] = parent;
      }
    } else {
      node.transform = parent.transform;
    }
    if (node.children) {
      node.children.forEach(function(child) {
        recurse(child, node);
      });
    }
    return node;
  }

  function forward(lambda, phi) {
    var node = face(lambda, phi),
        point = node.project([lambda * _math_js__WEBPACK_IMPORTED_MODULE_2__.degrees, phi * _math_js__WEBPACK_IMPORTED_MODULE_2__.degrees]),
        t;
    if (t = node.transform) {
      return [
        t[0] * point[0] + t[1] * point[1] + t[2],
        -(t[3] * point[0] + t[4] * point[1] + t[5])
      ];
    }
    point[1] = -point[1];
    return point;
  }

  // Naive inverse!  A faster solution would use bounding boxes, or even a
  // polygonal quadtree.
  if (hasInverse(root)) forward.invert = function(x, y) {
    var coordinates = faceInvert(root, [x, -y]);
    return coordinates && (coordinates[0] *= _math_js__WEBPACK_IMPORTED_MODULE_2__.radians, coordinates[1] *= _math_js__WEBPACK_IMPORTED_MODULE_2__.radians, coordinates);
  };

  function faceInvert(node, coordinates) {
    var invert = node.project.invert,
        t = node.transform,
        point = coordinates;
    if (t) {
      t = (0,_matrix_js__WEBPACK_IMPORTED_MODULE_1__.inverse)(t);
      point = [
        t[0] * point[0] + t[1] * point[1] + t[2],
        (t[3] * point[0] + t[4] * point[1] + t[5])
      ];
    }
    if (invert && node === faceDegrees(p = invert(point))) return p;
    var p,
        children = node.children;
    for (var i = 0, n = children && children.length; i < n; ++i) {
      if (p = faceInvert(children[i], coordinates)) return p;
    }
  }

  function faceDegrees(coordinates) {
    return face(coordinates[0] * _math_js__WEBPACK_IMPORTED_MODULE_2__.radians, coordinates[1] * _math_js__WEBPACK_IMPORTED_MODULE_2__.radians);
  }

  var proj = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(forward),
      stream_ = proj.stream;

  proj.stream = function(stream) {
    var rotate = proj.rotate(),
        rotateStream = stream_(stream),
        sphereStream = (proj.rotate([0, 0]), stream_(stream));
    proj.rotate(rotate);
    rotateStream.sphere = function() {
      sphereStream.polygonStart();
      sphereStream.lineStart();
      outline(sphereStream, root);
      sphereStream.lineEnd();
      sphereStream.polygonEnd();
    };
    return rotateStream;
  };

  return proj.angle(-30);
}

function outline(stream, node, parent) {
  var point,
      edges = node.edges,
      n = edges.length,
      edge,
      multiPoint = {type: "MultiPoint", coordinates: node.face},
      notPoles = node.face.filter(function(d) { return (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.abs)(d[1]) !== 90; }),
      b = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoBounds)({type: "MultiPoint", coordinates: notPoles}),
      inside = false,
      j = -1,
      dx = b[1][0] - b[0][0];
  // TODO
  var c = dx === 180 || dx === 360
      ? [(b[0][0] + b[1][0]) / 2, (b[0][1] + b[1][1]) / 2]
      : (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoCentroid)(multiPoint);
  // First find the shared edge…
  if (parent) while (++j < n) {
    if (edges[j] === parent) break;
  }
  ++j;
  for (var i = 0; i < n; ++i) {
    edge = edges[(i + j) % n];
    if (Array.isArray(edge)) {
      if (!inside) {
        stream.point((point = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoInterpolate)(edge[0], c)(_math_js__WEBPACK_IMPORTED_MODULE_2__.epsilon))[0], point[1]);
        inside = true;
      }
      stream.point((point = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoInterpolate)(edge[1], c)(_math_js__WEBPACK_IMPORTED_MODULE_2__.epsilon))[0], point[1]);
    } else {
      inside = false;
      if (edge !== parent) outline(stream, edge, node);
    }
  }
}

// Tests equality of two spherical points.
function pointEqual(a, b) {
  return a && b && a[0] === b[0] && a[1] === b[1];
}

// Finds a shared edge given two clockwise polygons.
function sharedEdge(a, b) {
  var x, y, n = a.length, found = null;
  for (var i = 0; i < n; ++i) {
    x = a[i];
    for (var j = b.length; --j >= 0;) {
      y = b[j];
      if (x[0] === y[0] && x[1] === y[1]) {
        if (found) return [found, x];
        found = x;
      }
    }
  }
}

// Converts an array of n face vertices to an array of n + 1 edges.
function faceEdges(face) {
  var n = face.length,
      edges = [];
  for (var a = face[n - 1], i = 0; i < n; ++i) edges.push([a, a = face[i]]);
  return edges;
}

function hasInverse(node) {
  return node.project.invert || node.children && node.children.some(hasInverse);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/polyhedral/matrix.js":
/*!*****************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/polyhedral/matrix.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "inverse": () => (/* binding */ inverse),
/* harmony export */   "multiply": () => (/* binding */ multiply)
/* harmony export */ });
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../math.js */ "./node_modules/d3-geo-projection/src/math.js");


// Note: 6-element arrays are used to denote the 3x3 affine transform matrix:
// [a, b, c,
//  d, e, f,
//  0, 0, 1] - this redundant row is left out.

// Transform matrix for [a0, a1] -> [b0, b1].
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(a, b) {
  var u = subtract(a[1], a[0]),
      v = subtract(b[1], b[0]),
      phi = angle(u, v),
      s = length(u) / length(v);

  return multiply([
    1, 0, a[0][0],
    0, 1, a[0][1]
  ], multiply([
    s, 0, 0,
    0, s, 0
  ], multiply([
    (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.cos)(phi), (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sin)(phi), 0,
    -(0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sin)(phi), (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.cos)(phi), 0
  ], [
    1, 0, -b[0][0],
    0, 1, -b[0][1]
  ])));
}

// Inverts a transform matrix.
function inverse(m) {
  var k = 1 / (m[0] * m[4] - m[1] * m[3]);
  return [
    k * m[4], -k * m[1], k * (m[1] * m[5] - m[2] * m[4]),
    -k * m[3], k * m[0], k * (m[2] * m[3] - m[0] * m[5])
  ];
}

// Multiplies two 3x2 matrices.
function multiply(a, b) {
  return [
    a[0] * b[0] + a[1] * b[3],
    a[0] * b[1] + a[1] * b[4],
    a[0] * b[2] + a[1] * b[5] + a[2],
    a[3] * b[0] + a[4] * b[3],
    a[3] * b[1] + a[4] * b[4],
    a[3] * b[2] + a[4] * b[5] + a[5]
  ];
}

// Subtracts 2D vectors.
function subtract(a, b) {
  return [a[0] - b[0], a[1] - b[1]];
}

// Magnitude of a 2D vector.
function length(v) {
  return (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sqrt)(v[0] * v[0] + v[1] * v[1]);
}

// Angle between two 2D vectors.
function angle(a, b) {
  return (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.atan2)(a[0] * b[1] - a[1] * b[0], a[0] * b[0] + a[1] * b[1]);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/polyhedral/octahedron.js":
/*!*********************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/polyhedral/octahedron.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
// TODO generate on-the-fly to avoid external modification.
var octahedron = [
  [0, 90],
  [-90, 0], [0, 0], [90, 0], [180, 0],
  [0, -90]
];

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ([
  [0, 2, 1],
  [0, 3, 2],
  [5, 1, 2],
  [5, 2, 3],
  [0, 1, 4],
  [0, 4, 3],
  [5, 4, 1],
  [5, 3, 4]
].map(function(face) {
  return face.map(function(i) {
    return octahedron[i];
  });
}));


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/polyhedral/waterman.js":
/*!*******************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/polyhedral/waterman.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../math.js */ "./node_modules/d3-geo-projection/src/math.js");
/* harmony import */ var _index_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./index.js */ "./node_modules/d3-geo-projection/src/polyhedral/index.js");
/* harmony import */ var _octahedron_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./octahedron.js */ "./node_modules/d3-geo-projection/src/polyhedral/octahedron.js");





/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(faceProjection) {

  faceProjection = faceProjection || function(face) {
    var c = face.length === 6 ? (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoCentroid)({type: "MultiPoint", coordinates: face}) : face[0];
    return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoGnomonic)().scale(1).translate([0, 0]).rotate([-c[0], -c[1]]);
  };

  var w5 = _octahedron_js__WEBPACK_IMPORTED_MODULE_1__["default"].map(function(face) {
    var xyz = face.map(cartesian),
        n = xyz.length,
        a = xyz[n - 1],
        b,
        hexagon = [];
    for (var i = 0; i < n; ++i) {
      b = xyz[i];
      hexagon.push(spherical([
        a[0] * 0.9486832980505138 + b[0] * 0.31622776601683794,
        a[1] * 0.9486832980505138 + b[1] * 0.31622776601683794,
        a[2] * 0.9486832980505138 + b[2] * 0.31622776601683794
      ]), spherical([
        b[0] * 0.9486832980505138 + a[0] * 0.31622776601683794,
        b[1] * 0.9486832980505138 + a[1] * 0.31622776601683794,
        b[2] * 0.9486832980505138 + a[2] * 0.31622776601683794
      ]));
      a = b;
    }
    return hexagon;
  });

  var cornerNormals = [];

  var parents = [-1, 0, 0, 1, 0, 1, 4, 5];

  w5.forEach(function(hexagon, j) {
    var face = _octahedron_js__WEBPACK_IMPORTED_MODULE_1__["default"][j],
        n = face.length,
        normals = cornerNormals[j] = [];
    for (var i = 0; i < n; ++i) {
      w5.push([
        face[i],
        hexagon[(i * 2 + 2) % (2 * n)],
        hexagon[(i * 2 + 1) % (2 * n)]
      ]);
      parents.push(j);
      normals.push(cross(
        cartesian(hexagon[(i * 2 + 2) % (2 * n)]),
        cartesian(hexagon[(i * 2 + 1) % (2 * n)])
      ));
    }
  });

  var faces = w5.map(function(face) {
    return {
      project: faceProjection(face),
      face: face
    };
  });

  parents.forEach(function(d, i) {
    var parent = faces[d];
    parent && (parent.children || (parent.children = [])).push(faces[i]);
  });

  function face(lambda, phi) {
    var cosphi = (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.cos)(phi),
        p = [cosphi * (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.cos)(lambda), cosphi * (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.sin)(lambda), (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.sin)(phi)];

    var hexagon = lambda < -_math_js__WEBPACK_IMPORTED_MODULE_2__.pi / 2 ? phi < 0 ? 6 : 4
        : lambda < 0 ? phi < 0 ? 2 : 0
        : lambda < _math_js__WEBPACK_IMPORTED_MODULE_2__.pi / 2 ? phi < 0 ? 3 : 1
        : phi < 0 ? 7 : 5;

    var n = cornerNormals[hexagon];

    return faces[dot(n[0], p) < 0 ? 8 + 3 * hexagon
        : dot(n[1], p) < 0 ? 8 + 3 * hexagon + 1
        : dot(n[2], p) < 0 ? 8 + 3 * hexagon + 2
        : hexagon];
  }

  return (0,_index_js__WEBPACK_IMPORTED_MODULE_3__["default"])(faces[0], face)
      .angle(-30)
      .scale(110.625)
      .center([0,45]);
}

function dot(a, b) {
  for (var i = 0, n = a.length, s = 0; i < n; ++i) s += a[i] * b[i];
  return s;
}

function cross(a, b) {
  return [
    a[1] * b[2] - a[2] * b[1],
    a[2] * b[0] - a[0] * b[2],
    a[0] * b[1] - a[1] * b[0]
  ];
}

// Converts 3D Cartesian to spherical coordinates (degrees).
function spherical(cartesian) {
  return [
    (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.atan2)(cartesian[1], cartesian[0]) * _math_js__WEBPACK_IMPORTED_MODULE_2__.degrees,
    (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.asin)((0,_math_js__WEBPACK_IMPORTED_MODULE_2__.max)(-1, (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.min)(1, cartesian[2]))) * _math_js__WEBPACK_IMPORTED_MODULE_2__.degrees
  ];
}

// Converts spherical coordinates (degrees) to 3D Cartesian.
function cartesian(coordinates) {
  var lambda = coordinates[0] * _math_js__WEBPACK_IMPORTED_MODULE_2__.radians,
      phi = coordinates[1] * _math_js__WEBPACK_IMPORTED_MODULE_2__.radians,
      cosphi = (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.cos)(phi);
  return [
    cosphi * (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.cos)(lambda),
    cosphi * (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.sin)(lambda),
    (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.sin)(phi)
  ];
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/project/clockwise.js":
/*!*****************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/project/clockwise.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(ring) {
  if ((n = ring.length) < 4) return false;
  var i = 0,
      n,
      area = ring[n - 1][1] * ring[0][0] - ring[n - 1][0] * ring[0][1];
  while (++i < n) area += ring[i - 1][1] * ring[i][0] - ring[i - 1][0] * ring[i][1];
  return area <= 0;
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/project/contains.js":
/*!****************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/project/contains.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(ring, point) {
  var x = point[0],
      y = point[1],
      contains = false;
  for (var i = 0, n = ring.length, j = n - 1; i < n; j = i++) {
    var pi = ring[i], xi = pi[0], yi = pi[1],
        pj = ring[j], xj = pj[0], yj = pj[1];
    if (((yi > y) ^ (yj > y)) && (x < (xj - xi) * (y - yi) / (yj - yi) + xi)) contains = !contains;
  }
  return contains;
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/project/index.js":
/*!*************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/project/index.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _noop_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../noop.js */ "./node_modules/d3-geo-projection/src/noop.js");
/* harmony import */ var _clockwise_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./clockwise.js */ "./node_modules/d3-geo-projection/src/project/clockwise.js");
/* harmony import */ var _contains_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./contains.js */ "./node_modules/d3-geo-projection/src/project/contains.js");





/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(object, projection) {
  var stream = projection.stream, project;
  if (!stream) throw new Error("invalid projection");
  switch (object && object.type) {
    case "Feature": project = projectFeature; break;
    case "FeatureCollection": project = projectFeatureCollection; break;
    default: project = projectGeometry; break;
  }
  return project(object, stream);
}

function projectFeatureCollection(o, stream) {
  return {
    type: "FeatureCollection",
    features: o.features.map(function(f) {
      return projectFeature(f, stream);
    })
  };
}

function projectFeature(o, stream) {
  return {
    type: "Feature",
    id: o.id,
    properties: o.properties,
    geometry: projectGeometry(o.geometry, stream)
  };
}

function projectGeometryCollection(o, stream) {
  return {
    type: "GeometryCollection",
    geometries: o.geometries.map(function(o) {
      return projectGeometry(o, stream);
    })
  };
}

function projectGeometry(o, stream) {
  if (!o) return null;
  if (o.type === "GeometryCollection") return projectGeometryCollection(o, stream);
  var sink;
  switch (o.type) {
    case "Point": sink = sinkPoint; break;
    case "MultiPoint": sink = sinkPoint; break;
    case "LineString": sink = sinkLine; break;
    case "MultiLineString": sink = sinkLine; break;
    case "Polygon": sink = sinkPolygon; break;
    case "MultiPolygon": sink = sinkPolygon; break;
    case "Sphere": sink = sinkPolygon; break;
    default: return null;
  }
  (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoStream)(o, stream(sink));
  return sink.result();
}

var points = [],
    lines = [];

var sinkPoint = {
  point: function(x, y) {
    points.push([x, y]);
  },
  result: function() {
    var result = !points.length ? null
        : points.length < 2 ? {type: "Point", coordinates: points[0]}
        : {type: "MultiPoint", coordinates: points};
    points = [];
    return result;
  }
};

var sinkLine = {
  lineStart: _noop_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  point: function(x, y) {
    points.push([x, y]);
  },
  lineEnd: function() {
    if (points.length) lines.push(points), points = [];
  },
  result: function() {
    var result = !lines.length ? null
        : lines.length < 2 ? {type: "LineString", coordinates: lines[0]}
        : {type: "MultiLineString", coordinates: lines};
    lines = [];
    return result;
  }
};

var sinkPolygon = {
  polygonStart: _noop_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  lineStart: _noop_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  point: function(x, y) {
    points.push([x, y]);
  },
  lineEnd: function() {
    var n = points.length;
    if (n) {
      do points.push(points[0].slice()); while (++n < 4);
      lines.push(points), points = [];
    }
  },
  polygonEnd: _noop_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  result: function() {
    if (!lines.length) return null;
    var polygons = [],
        holes = [];

    // https://github.com/d3/d3/issues/1558
    lines.forEach(function(ring) {
      if ((0,_clockwise_js__WEBPACK_IMPORTED_MODULE_2__["default"])(ring)) polygons.push([ring]);
      else holes.push(ring);
    });

    holes.forEach(function(hole) {
      var point = hole[0];
      polygons.some(function(polygon) {
        if ((0,_contains_js__WEBPACK_IMPORTED_MODULE_3__["default"])(polygon[0], point)) {
          polygon.push(hole);
          return true;
        }
      }) || polygons.push([hole]);
    });

    lines = [];

    return !polygons.length ? null
        : polygons.length > 1 ? {type: "MultiPolygon", coordinates: polygons}
        : {type: "Polygon", coordinates: polygons[0]};
  }
};


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/quantize.js":
/*!********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/quantize.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(input, digits) {
  if (!(0 <= (digits = +digits) && digits <= 20)) throw new Error("invalid digits");

  function quantizePoint(input) {
    var n = input.length, i = 2, output = new Array(n);
    output[0] = +input[0].toFixed(digits);
    output[1] = +input[1].toFixed(digits);
    while (i < n) output[i] = input[i], ++i;
    return output;
  }

  function quantizePoints(input) {
    return input.map(quantizePoint);
  }

  function quantizePointsNoDuplicates(input) {
    var point0 = quantizePoint(input[0]);
    var output = [point0];
    for (var i = 1; i < input.length; i++) {
      var point = quantizePoint(input[i]);
      if (point.length > 2 || point[0] != point0[0] || point[1] != point0[1]) {
        output.push(point);
        point0 = point;
      }
    }
    if (output.length === 1 && input.length > 1) {
      output.push(quantizePoint(input[input.length - 1]));
    }
    return output;
  }

  function quantizePolygon(input) {
    return input.map(quantizePointsNoDuplicates);
  }

  function quantizeGeometry(input) {
    if (input == null) return input;
    var output;
    switch (input.type) {
      case "GeometryCollection": output = {type: "GeometryCollection", geometries: input.geometries.map(quantizeGeometry)}; break;
      case "Point": output = {type: "Point", coordinates: quantizePoint(input.coordinates)}; break;
      case "MultiPoint": output = {type: input.type, coordinates: quantizePoints(input.coordinates)}; break;
      case "LineString": output = {type: input.type, coordinates: quantizePointsNoDuplicates(input.coordinates)}; break;
      case "MultiLineString": case "Polygon": output = {type: input.type, coordinates: quantizePolygon(input.coordinates)}; break;
      case "MultiPolygon": output = {type: "MultiPolygon", coordinates: input.coordinates.map(quantizePolygon)}; break;
      default: return input;
    }
    if (input.bbox != null) output.bbox = input.bbox;
    return output;
  }

  function quantizeFeature(input) {
    var output = {type: "Feature", properties: input.properties, geometry: quantizeGeometry(input.geometry)};
    if (input.id != null) output.id = input.id;
    if (input.bbox != null) output.bbox = input.bbox;
    return output;
  }

  if (input != null) switch (input.type) {
    case "Feature": return quantizeFeature(input);
    case "FeatureCollection": {
      var output = {type: "FeatureCollection", features: input.features.map(quantizeFeature)};
      if (input.bbox != null) output.bbox = input.bbox;
      return output;
    }
    default: return quantizeGeometry(input);
  }

  return input;
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/quincuncial/gringorten.js":
/*!**********************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/quincuncial/gringorten.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _gringorten_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../gringorten.js */ "./node_modules/d3-geo-projection/src/gringorten.js");
/* harmony import */ var _index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./index.js */ "./node_modules/d3-geo-projection/src/quincuncial/index.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_gringorten_js__WEBPACK_IMPORTED_MODULE_1__.gringortenRaw)
      .scale(176.423);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/quincuncial/index.js":
/*!*****************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/quincuncial/index.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../math.js */ "./node_modules/d3-geo-projection/src/math.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(project) {
  var dx = project(_math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi, 0)[0] - project(-_math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi, 0)[0];

  function projectQuincuncial(lambda, phi) {
    var t = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(lambda) < _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi,
        p = project(t ? lambda : lambda > 0 ? lambda - _math_js__WEBPACK_IMPORTED_MODULE_1__.pi : lambda + _math_js__WEBPACK_IMPORTED_MODULE_1__.pi, phi),
        x = (p[0] - p[1]) * _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt1_2,
        y = (p[0] + p[1]) * _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt1_2;
    if (t) return [x, y];
    var d = dx * _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt1_2,
        s = x > 0 ^ y > 0 ? -1 : 1;
    return [s * x - (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(y) * d, s * y - (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(x) * d];
  }

  if (project.invert) projectQuincuncial.invert = function(x0, y0) {
    var x = (x0 + y0) * _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt1_2,
        y = (y0 - x0) * _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt1_2,
        t = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(x) < 0.5 * dx && (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(y) < 0.5 * dx;

    if (!t) {
      var d = dx * _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt1_2,
          s = x > 0 ^ y > 0 ? -1 : 1,
          x1 = -s * x0 + (y > 0 ? 1 : -1) * d,
          y1 = -s * y0 + (x > 0 ? 1 : -1) * d;
      x = (-x1 - y1) * _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt1_2;
      y = (x1 - y1) * _math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt1_2;
    }

    var p = project.invert(x, y);
    if (!t) p[0] += x > 0 ? _math_js__WEBPACK_IMPORTED_MODULE_1__.pi : -_math_js__WEBPACK_IMPORTED_MODULE_1__.pi;
    return p;
  };

  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(projectQuincuncial)
      .rotate([-90, -90, 45])
      .clipAngle(180 - 1e-3);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/quincuncial/peirce.js":
/*!******************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/quincuncial/peirce.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _guyou_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../guyou.js */ "./node_modules/d3-geo-projection/src/guyou.js");
/* harmony import */ var _index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./index.js */ "./node_modules/d3-geo-projection/src/quincuncial/index.js");



/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_guyou_js__WEBPACK_IMPORTED_MODULE_1__.guyouRaw)
      .scale(111.48);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/rectangularPolyconic.js":
/*!********************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/rectangularPolyconic.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "rectangularPolyconicRaw": () => (/* binding */ rectangularPolyconicRaw)
/* harmony export */ });
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");
/* harmony import */ var _parallel1_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./parallel1.js */ "./node_modules/d3-geo-projection/src/parallel1.js");



function rectangularPolyconicRaw(phi0) {
  var sinPhi0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sin)(phi0);

  function forward(lambda, phi) {
    var A = sinPhi0 ? (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.tan)(lambda * sinPhi0 / 2) / sinPhi0 : lambda / 2;
    if (!phi) return [2 * A, -phi0];
    var E = 2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.atan)(A * (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sin)(phi)),
        cotPhi = 1 / (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.tan)(phi);
    return [
      (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sin)(E) * cotPhi,
      phi + (1 - (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.cos)(E)) * cotPhi - phi0
    ];
  }

  // TODO return null for points outside outline.
  forward.invert = function(x, y) {
    if ((0,_math_js__WEBPACK_IMPORTED_MODULE_0__.abs)(y += phi0) < _math_js__WEBPACK_IMPORTED_MODULE_0__.epsilon) return [sinPhi0 ? 2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.atan)(sinPhi0 * x / 2) / sinPhi0 : x, 0];
    var k = x * x + y * y,
        phi = 0,
        i = 10, delta;
    do {
      var tanPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.tan)(phi),
          secPhi = 1 / (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.cos)(phi),
          j = k - 2 * y * phi + phi * phi;
      phi -= delta = (tanPhi * j + 2 * (phi - y)) / (2 + j * secPhi * secPhi + 2 * (phi - y) * tanPhi);
    } while ((0,_math_js__WEBPACK_IMPORTED_MODULE_0__.abs)(delta) > _math_js__WEBPACK_IMPORTED_MODULE_0__.epsilon && --i > 0);
    var E = x * (tanPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.tan)(phi)),
        A = (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.tan)((0,_math_js__WEBPACK_IMPORTED_MODULE_0__.abs)(y) < (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.abs)(phi + 1 / tanPhi) ? (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.asin)(E) * 0.5 : (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.acos)(E) * 0.5 + _math_js__WEBPACK_IMPORTED_MODULE_0__.pi / 4) / (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.sin)(phi);
    return [
      sinPhi0 ? 2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.atan)(sinPhi0 * A) / sinPhi0 : 2 * A,
      phi
    ];
  };

  return forward;
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,_parallel1_js__WEBPACK_IMPORTED_MODULE_1__["default"])(rectangularPolyconicRaw)
      .scale(131.215);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/robinson.js":
/*!********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/robinson.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "robinsonRaw": () => (/* binding */ robinsonRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



var K = [
  [0.9986, -0.062],
  [1.0000, 0.0000],
  [0.9986, 0.0620],
  [0.9954, 0.1240],
  [0.9900, 0.1860],
  [0.9822, 0.2480],
  [0.9730, 0.3100],
  [0.9600, 0.3720],
  [0.9427, 0.4340],
  [0.9216, 0.4958],
  [0.8962, 0.5571],
  [0.8679, 0.6176],
  [0.8350, 0.6769],
  [0.7986, 0.7346],
  [0.7597, 0.7903],
  [0.7186, 0.8435],
  [0.6732, 0.8936],
  [0.6213, 0.9394],
  [0.5722, 0.9761],
  [0.5322, 1.0000]
];

K.forEach(function(d) {
  d[1] *= 1.593415793900743;
});

function robinsonRaw(lambda, phi) {
  var i = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.min)(18, (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(phi) * 36 / _math_js__WEBPACK_IMPORTED_MODULE_1__.pi),
      i0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.floor)(i),
      di = i - i0,
      ax = (k = K[i0])[0],
      ay = k[1],
      bx = (k = K[++i0])[0],
      by = k[1],
      cx = (k = K[(0,_math_js__WEBPACK_IMPORTED_MODULE_1__.min)(19, ++i0)])[0],
      cy = k[1],
      k;
  return [
    lambda * (bx + di * (cx - ax) / 2 + di * di * (cx - 2 * bx + ax) / 2),
    (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(phi) * (by + di * (cy - ay) / 2 + di * di * (cy - 2 * by + ay) / 2)
  ];
}

robinsonRaw.invert = function(x, y) {
  var phi = y * 90,
      i = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.min)(18, (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(phi / 5)),
      i0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.max)(0, (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.floor)(i));
  do {
    var ay = K[i0][1],
        by = K[i0 + 1][1],
        cy = K[(0,_math_js__WEBPACK_IMPORTED_MODULE_1__.min)(19, i0 + 2)][1],
        u = cy - ay,
        v = cy - 2 * by + ay,
        t = 2 * ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(y) - by) / u,
        c = v / u,
        di = t * (1 - c * t * (1 - 2 * c * t));
    if (di >= 0 || i0 === 1) {
      phi = (y >= 0 ? 5 : -5) * (di + i);
      var j = 50, delta;
      do {
        i = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.min)(18, (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(phi) / 5);
        i0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.floor)(i);
        di = i - i0;
        ay = K[i0][1];
        by = K[i0 + 1][1];
        cy = K[(0,_math_js__WEBPACK_IMPORTED_MODULE_1__.min)(19, i0 + 2)][1];
        phi -= (delta = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(y) * (by + di * (cy - ay) / 2 + di * di * (cy - 2 * by + ay) / 2) - y) * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees;
      } while ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(delta) > _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon2 && --j > 0);
      break;
    }
  } while (--i0 >= 0);
  var ax = K[i0][0],
      bx = K[i0 + 1][0],
      cx = K[(0,_math_js__WEBPACK_IMPORTED_MODULE_1__.min)(19, i0 + 2)][0];
  return [
    x / (bx + di * (cx - ax) / 2 + di * di * (cx - 2 * bx + ax) / 2),
    phi * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians
  ];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(robinsonRaw)
      .scale(152.63);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/satellite.js":
/*!*********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/satellite.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "satelliteRaw": () => (/* binding */ satelliteRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function satelliteVerticalRaw(P) {
  function forward(lambda, phi) {
    var cosPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi),
        k = (P - 1) / (P - cosPhi * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(lambda));
    return [
      k * cosPhi * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(lambda),
      k * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi)
    ];
  }

  forward.invert = function(x, y) {
    var rho2 = x * x + y * y,
        rho = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(rho2),
        sinc = (P - (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(1 - rho2 * (P + 1) / (P - 1))) / ((P - 1) / rho + rho / (P - 1));
    return [
      (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)(x * sinc, rho * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(1 - sinc * sinc)),
      rho ? (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(y * sinc / rho) : 0
    ];
  };

  return forward;
}

function satelliteRaw(P, omega) {
  var vertical = satelliteVerticalRaw(P);
  if (!omega) return vertical;
  var cosOmega = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(omega),
      sinOmega = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(omega);

  function forward(lambda, phi) {
    var coordinates = vertical(lambda, phi),
        y = coordinates[1],
        A = y * sinOmega / (P - 1) + cosOmega;
    return [
      coordinates[0] * cosOmega / A,
      y / A
    ];
  }

  forward.invert = function(x, y) {
    var k = (P - 1) / (P - 1 - y * sinOmega);
    return vertical.invert(k * x, k * y * cosOmega);
  };

  return forward;
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  var distance = 2,
      omega = 0,
      m = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjectionMutator)(satelliteRaw),
      p = m(distance, omega);

  // As a multiple of radius.
  p.distance = function(_) {
    if (!arguments.length) return distance;
    return m(distance = +_, omega);
  };

  p.tilt = function(_) {
    if (!arguments.length) return omega * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees;
    return m(distance, omega = _ * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians);
  };

  return p
      .scale(432.147)
      .clipAngle((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.acos)(1 / distance) * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees - 1e-6);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/sinuMollweide.js":
/*!*************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/sinuMollweide.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "sinuMollweidePhi": () => (/* binding */ sinuMollweidePhi),
/* harmony export */   "sinuMollweideRaw": () => (/* binding */ sinuMollweideRaw),
/* harmony export */   "sinuMollweideY": () => (/* binding */ sinuMollweideY)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mollweide_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./mollweide.js */ "./node_modules/d3-geo-projection/src/mollweide.js");
/* harmony import */ var _sinusoidal_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sinusoidal.js */ "./node_modules/d3-geo-projection/src/sinusoidal.js");




var sinuMollweidePhi = 0.7109889596207567;

var sinuMollweideY = 0.0528035274542;

function sinuMollweideRaw(lambda, phi) {
  return phi > -sinuMollweidePhi
      ? (lambda = (0,_mollweide_js__WEBPACK_IMPORTED_MODULE_1__.mollweideRaw)(lambda, phi), lambda[1] += sinuMollweideY, lambda)
      : (0,_sinusoidal_js__WEBPACK_IMPORTED_MODULE_2__.sinusoidalRaw)(lambda, phi);
}

sinuMollweideRaw.invert = function(x, y) {
  return y > -sinuMollweidePhi
      ? _mollweide_js__WEBPACK_IMPORTED_MODULE_1__.mollweideRaw.invert(x, y - sinuMollweideY)
      : _sinusoidal_js__WEBPACK_IMPORTED_MODULE_2__.sinusoidalRaw.invert(x, y);
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(sinuMollweideRaw)
      .rotate([-20, -55])
      .scale(164.263)
      .center([0, -5.4036]);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/sinusoidal.js":
/*!**********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/sinusoidal.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "sinusoidalRaw": () => (/* binding */ sinusoidalRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function sinusoidalRaw(lambda, phi) {
  return [lambda * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi), phi];
}

sinusoidalRaw.invert = function(x, y) {
  return [x / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(y), y];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(sinusoidalRaw)
      .scale(152.63);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/square.js":
/*!******************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/square.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");


/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(project) {
  var dx = project(_math_js__WEBPACK_IMPORTED_MODULE_0__.halfPi, 0)[0] - project(-_math_js__WEBPACK_IMPORTED_MODULE_0__.halfPi, 0)[0];

  function projectSquare(lambda, phi) {
    var s = lambda > 0 ? -0.5 : 0.5,
        point = project(lambda + s * _math_js__WEBPACK_IMPORTED_MODULE_0__.pi, phi);
    point[0] -= s * dx;
    return point;
  }

  if (project.invert) projectSquare.invert = function(x, y) {
    var s = x > 0 ? -0.5 : 0.5,
        location = project.invert(x + s * dx, y),
        lambda = location[0] - s * _math_js__WEBPACK_IMPORTED_MODULE_0__.pi;
    if (lambda < -_math_js__WEBPACK_IMPORTED_MODULE_0__.pi) lambda += 2 * _math_js__WEBPACK_IMPORTED_MODULE_0__.pi;
    else if (lambda > _math_js__WEBPACK_IMPORTED_MODULE_0__.pi) lambda -= 2 * _math_js__WEBPACK_IMPORTED_MODULE_0__.pi;
    location[0] = lambda;
    return location;
  };

  return projectSquare;
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/stitch.js":
/*!******************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/stitch.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var epsilon = 1e-4,
    epsilonInverse = 1e4,
    x0 = -180, x0e = x0 + epsilon,
    x1 = 180, x1e = x1 - epsilon,
    y0 = -90, y0e = y0 + epsilon,
    y1 = 90, y1e = y1 - epsilon;

function nonempty(coordinates) {
  return coordinates.length > 0;
}

function quantize(x) {
  return Math.floor(x * epsilonInverse) / epsilonInverse;
}

function normalizePoint(y) {
  return y === y0 || y === y1 ? [0, y] : [x0, quantize(y)]; // pole or antimeridian?
}

function clampPoint(p) {
  var x = p[0], y = p[1], clamped = false;
  if (x <= x0e) x = x0, clamped = true;
  else if (x >= x1e) x = x1, clamped = true;
  if (y <= y0e) y = y0, clamped = true;
  else if (y >= y1e) y = y1, clamped = true;
  return clamped ? [x, y] : p;
}

function clampPoints(points) {
  return points.map(clampPoint);
}

// For each ring, detect where it crosses the antimeridian or pole.
function extractFragments(rings, polygon, fragments) {
  for (var j = 0, m = rings.length; j < m; ++j) {
    var ring = rings[j].slice();

    // By default, assume that this ring doesn’t need any stitching.
    fragments.push({index: -1, polygon: polygon, ring: ring});

    for (var i = 0, n = ring.length; i < n; ++i) {
      var point = ring[i],
          x = point[0],
          y = point[1];

      // If this is an antimeridian or polar point…
      if (x <= x0e || x >= x1e || y <= y0e || y >= y1e) {
        ring[i] = clampPoint(point);

        // Advance through any antimeridian or polar points…
        for (var k = i + 1; k < n; ++k) {
          var pointk = ring[k],
              xk = pointk[0],
              yk = pointk[1];
          if (xk > x0e && xk < x1e && yk > y0e && yk < y1e) break;
        }

        // If this was just a single antimeridian or polar point,
        // we don’t need to cut this ring into a fragment;
        // we can just leave it as-is.
        if (k === i + 1) continue;

        // Otherwise, if this is not the first point in the ring,
        // cut the current fragment so that it ends at the current point.
        // The current point is also normalized for later joining.
        if (i) {
          var fragmentBefore = {index: -1, polygon: polygon, ring: ring.slice(0, i + 1)};
          fragmentBefore.ring[fragmentBefore.ring.length - 1] = normalizePoint(y);
          fragments[fragments.length - 1] = fragmentBefore;
        }

        // If the ring started with an antimeridian fragment,
        // we can ignore that fragment entirely.
        else fragments.pop();

        // If the remainder of the ring is an antimeridian fragment,
        // move on to the next ring.
        if (k >= n) break;

        // Otherwise, add the remaining ring fragment and continue.
        fragments.push({index: -1, polygon: polygon, ring: ring = ring.slice(k - 1)});
        ring[0] = normalizePoint(ring[0][1]);
        i = -1;
        n = ring.length;
      }
    }
  }
}

// Now stitch the fragments back together into rings.
function stitchFragments(fragments) {
  var i, n = fragments.length;

  // To connect the fragments start-to-end, create a simple index by end.
  var fragmentByStart = {},
      fragmentByEnd = {},
      fragment,
      start,
      startFragment,
      end,
      endFragment;

  // For each fragment…
  for (i = 0; i < n; ++i) {
    fragment = fragments[i];
    start = fragment.ring[0];
    end = fragment.ring[fragment.ring.length - 1];

    // If this fragment is closed, add it as a standalone ring.
    if (start[0] === end[0] && start[1] === end[1]) {
      fragment.polygon.push(fragment.ring);
      fragments[i] = null;
      continue;
    }

    fragment.index = i;
    fragmentByStart[start] = fragmentByEnd[end] = fragment;
  }

  // For each open fragment…
  for (i = 0; i < n; ++i) {
    fragment = fragments[i];
    if (fragment) {
      start = fragment.ring[0];
      end = fragment.ring[fragment.ring.length - 1];
      startFragment = fragmentByEnd[start];
      endFragment = fragmentByStart[end];

      delete fragmentByStart[start];
      delete fragmentByEnd[end];

      // If this fragment is closed, add it as a standalone ring.
      if (start[0] === end[0] && start[1] === end[1]) {
        fragment.polygon.push(fragment.ring);
        continue;
      }

      if (startFragment) {
        delete fragmentByEnd[start];
        delete fragmentByStart[startFragment.ring[0]];
        startFragment.ring.pop(); // drop the shared coordinate
        fragments[startFragment.index] = null;
        fragment = {index: -1, polygon: startFragment.polygon, ring: startFragment.ring.concat(fragment.ring)};

        if (startFragment === endFragment) {
          // Connect both ends to this single fragment to create a ring.
          fragment.polygon.push(fragment.ring);
        } else {
          fragment.index = n++;
          fragments.push(fragmentByStart[fragment.ring[0]] = fragmentByEnd[fragment.ring[fragment.ring.length - 1]] = fragment);
        }
      } else if (endFragment) {
        delete fragmentByStart[end];
        delete fragmentByEnd[endFragment.ring[endFragment.ring.length - 1]];
        fragment.ring.pop(); // drop the shared coordinate
        fragment = {index: n++, polygon: endFragment.polygon, ring: fragment.ring.concat(endFragment.ring)};
        fragments[endFragment.index] = null;
        fragments.push(fragmentByStart[fragment.ring[0]] = fragmentByEnd[fragment.ring[fragment.ring.length - 1]] = fragment);
      } else {
        fragment.ring.push(fragment.ring[0]); // close ring
        fragment.polygon.push(fragment.ring);
      }
    }
  }
}

function stitchFeature(input) {
  var output = {type: "Feature", geometry: stitchGeometry(input.geometry)};
  if (input.id != null) output.id = input.id;
  if (input.bbox != null) output.bbox = input.bbox;
  if (input.properties != null) output.properties = input.properties;
  return output;
}

function stitchGeometry(input) {
  if (input == null) return input;
  var output, fragments, i, n;
  switch (input.type) {
    case "GeometryCollection": output = {type: "GeometryCollection", geometries: input.geometries.map(stitchGeometry)}; break;
    case "Point": output = {type: "Point", coordinates: clampPoint(input.coordinates)}; break;
    case "MultiPoint": case "LineString": output = {type: input.type, coordinates: clampPoints(input.coordinates)}; break;
    case "MultiLineString": output = {type: "MultiLineString", coordinates: input.coordinates.map(clampPoints)}; break;
    case "Polygon": {
      var polygon = [];
      extractFragments(input.coordinates, polygon, fragments = []);
      stitchFragments(fragments);
      output = {type: "Polygon", coordinates: polygon};
      break;
    }
    case "MultiPolygon": {
      fragments = [], i = -1, n = input.coordinates.length;
      var polygons = new Array(n);
      while (++i < n) extractFragments(input.coordinates[i], polygons[i] = [], fragments);
      stitchFragments(fragments);
      output = {type: "MultiPolygon", coordinates: polygons.filter(nonempty)};
      break;
    }
    default: return input;
  }
  if (input.bbox != null) output.bbox = input.bbox;
  return output;
}

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(input) {
  if (input == null) return input;
  switch (input.type) {
    case "Feature": return stitchFeature(input);
    case "FeatureCollection": {
      var output = {type: "FeatureCollection", features: input.features.map(stitchFeature)};
      if (input.bbox != null) output.bbox = input.bbox;
      return output;
    }
    default: return stitchGeometry(input);
  }
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/times.js":
/*!*****************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/times.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "timesRaw": () => (/* binding */ timesRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function timesRaw(lambda, phi) {
  var t = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.tan)(phi / 2),
      s = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(_math_js__WEBPACK_IMPORTED_MODULE_1__.quarterPi * t);
  return [
    lambda * (0.74482 - 0.34588 * s * s),
    1.70711 * t
  ];
}

timesRaw.invert = function(x, y) {
  var t = y / 1.70711,
      s = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(_math_js__WEBPACK_IMPORTED_MODULE_1__.quarterPi * t);
  return [
    x / (0.74482 - 0.34588 * s * s),
    2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan)(t)
  ];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(timesRaw)
      .scale(146.153);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/twoPoint.js":
/*!********************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/twoPoint.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



// Compute the origin as the midpoint of the two reference points.
// Rotate one of the reference points by the origin.
// Apply the spherical law of sines to compute gamma rotation.
/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__(raw, p0, p1) {
  var i = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoInterpolate)(p0, p1),
      o = i(0.5),
      a = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoRotation)([-o[0], -o[1]])(p0),
      b = i.distance / 2,
      y = -(0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(a[1] * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians) / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(b)),
      R = [-o[0], -o[1], -(a[0] > 0 ? _math_js__WEBPACK_IMPORTED_MODULE_1__.pi - y : y) * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees],
      p = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(raw(b)).rotate(R),
      r = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoRotation)(R),
      center = p.center;

  delete p.rotate;

  p.center = function(_) {
    return arguments.length ? center(r(_)) : r.invert(center());
  };

  return p
      .clipAngle(90);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/twoPointAzimuthal.js":
/*!*****************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/twoPointAzimuthal.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ twoPointAzimuthal),
/* harmony export */   "twoPointAzimuthalRaw": () => (/* binding */ twoPointAzimuthalRaw),
/* harmony export */   "twoPointAzimuthalUsa": () => (/* binding */ twoPointAzimuthalUsa)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");
/* harmony import */ var _twoPoint_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./twoPoint.js */ "./node_modules/d3-geo-projection/src/twoPoint.js");




function twoPointAzimuthalRaw(d) {
  var cosd = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(d);

  function forward(lambda, phi) {
    var coordinates = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoGnomonicRaw)(lambda, phi);
    coordinates[0] *= cosd;
    return coordinates;
  }

  forward.invert = function(x, y) {
    return d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoGnomonicRaw.invert(x / cosd, y);
  };

  return forward;
}

function twoPointAzimuthalUsa() {
  return twoPointAzimuthal([-158, 21.5], [-77, 39])
      .clipAngle(60)
      .scale(400);
}

function twoPointAzimuthal(p0, p1) {
  return (0,_twoPoint_js__WEBPACK_IMPORTED_MODULE_2__["default"])(twoPointAzimuthalRaw, p0, p1);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/twoPointEquidistant.js":
/*!*******************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/twoPointEquidistant.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ twoPointEquidistant),
/* harmony export */   "twoPointEquidistantRaw": () => (/* binding */ twoPointEquidistantRaw),
/* harmony export */   "twoPointEquidistantUsa": () => (/* binding */ twoPointEquidistantUsa)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");
/* harmony import */ var _twoPoint_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./twoPoint.js */ "./node_modules/d3-geo-projection/src/twoPoint.js");




function twoPointEquidistantRaw(z0) {
  if (!(z0 *= 2)) return d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoAzimuthalEquidistantRaw;
  var lambdaa = -z0 / 2,
      lambdab = -lambdaa,
      z02 = z0 * z0,
      tanLambda0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.tan)(lambdab),
      S = 0.5 / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(lambdab);

  function forward(lambda, phi) {
    var za = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.acos)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(lambda - lambdaa)),
        zb = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.acos)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(lambda - lambdab)),
        ys = phi < 0 ? -1 : 1;
    za *= za, zb *= zb;
    return [
      (za - zb) / (2 * z0),
      ys * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(4 * z02 * zb - (z02 - za + zb) * (z02 - za + zb)) / (2 * z0)
    ];
  }

  forward.invert = function(x, y) {
    var y2 = y * y,
        cosza = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(y2 + (t = x + lambdaa) * t)),
        coszb = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(y2 + (t = x + lambdab) * t)),
        t,
        d;
    return [
      (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)(d = cosza - coszb, t = (cosza + coszb) * tanLambda0),
      (y < 0 ? -1 : 1) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.acos)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(t * t + d * d) * S)
    ];
  };

  return forward;
}

function twoPointEquidistantUsa() {
  return twoPointEquidistant([-158, 21.5], [-77, 39])
      .clipAngle(130)
      .scale(122.571);
}

function twoPointEquidistant(p0, p1) {
  return (0,_twoPoint_js__WEBPACK_IMPORTED_MODULE_2__["default"])(twoPointEquidistantRaw, p0, p1);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/vanDerGrinten.js":
/*!*************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/vanDerGrinten.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "vanDerGrintenRaw": () => (/* binding */ vanDerGrintenRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function vanDerGrintenRaw(lambda, phi) {
  if ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(phi) < _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon) return [lambda, 0];
  var sinTheta = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(phi / _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi),
      theta = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(sinTheta);
  if ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(lambda) < _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon || (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(phi) - _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi) < _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon) return [0, (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(phi) * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.tan)(theta / 2)];
  var cosTheta = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(theta),
      A = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(_math_js__WEBPACK_IMPORTED_MODULE_1__.pi / lambda - lambda / _math_js__WEBPACK_IMPORTED_MODULE_1__.pi) / 2,
      A2 = A * A,
      G = cosTheta / (sinTheta + cosTheta - 1),
      P = G * (2 / sinTheta - 1),
      P2 = P * P,
      P2_A2 = P2 + A2,
      G_P2 = G - P2,
      Q = A2 + G;
  return [
    (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(lambda) * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi * (A * G_P2 + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(A2 * G_P2 * G_P2 - P2_A2 * (G * G - P2))) / P2_A2,
    (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(phi) * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi * (P * Q - A * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)((A2 + 1) * P2_A2 - Q * Q)) / P2_A2
  ];
}

vanDerGrintenRaw.invert = function(x, y) {
  if ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(y) < _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon) return [x, 0];
  if ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(x) < _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon) return [0, _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan)(y / _math_js__WEBPACK_IMPORTED_MODULE_1__.pi))];
  var x2 = (x /= _math_js__WEBPACK_IMPORTED_MODULE_1__.pi) * x,
      y2 = (y /= _math_js__WEBPACK_IMPORTED_MODULE_1__.pi) * y,
      x2_y2 = x2 + y2,
      z = x2_y2 * x2_y2,
      c1 = -(0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(y) * (1 + x2_y2),
      c2 = c1 - 2 * y2 + x2,
      c3 = -2 * c1 + 1 + 2 * y2 + z,
      d = y2 / c3 + (2 * c2 * c2 * c2 / (c3 * c3 * c3) - 9 * c1 * c2 / (c3 * c3)) / 27,
      a1 = (c1 - c2 * c2 / (3 * c3)) / c3,
      m1 = 2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(-a1 / 3),
      theta1 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.acos)(3 * d / (a1 * m1)) / 3;
  return [
    _math_js__WEBPACK_IMPORTED_MODULE_1__.pi * (x2_y2 - 1 + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(1 + 2 * (x2 - y2) + z)) / (2 * x),
    (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(y) * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi * (-m1 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(theta1 + _math_js__WEBPACK_IMPORTED_MODULE_1__.pi / 3) - c2 / (3 * c3))
  ];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(vanDerGrintenRaw)
      .scale(79.4183);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/vanDerGrinten2.js":
/*!**************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/vanDerGrinten2.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "vanDerGrinten2Raw": () => (/* binding */ vanDerGrinten2Raw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function vanDerGrinten2Raw(lambda, phi) {
  if ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(phi) < _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon) return [lambda, 0];
  var sinTheta = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(phi / _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi),
      theta = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(sinTheta);
  if ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(lambda) < _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon || (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(phi) - _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi) < _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon) return [0, (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(phi) * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.tan)(theta / 2)];
  var cosTheta = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(theta),
      A = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(_math_js__WEBPACK_IMPORTED_MODULE_1__.pi / lambda - lambda / _math_js__WEBPACK_IMPORTED_MODULE_1__.pi) / 2,
      A2 = A * A,
      x1 = cosTheta * ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(1 + A2) - A * cosTheta) / (1 + A2 * sinTheta * sinTheta);
  return [
    (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(lambda) * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi * x1,
    (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(phi) * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(1 - x1 * (2 * A + x1))
  ];
}

vanDerGrinten2Raw.invert = function(x, y) {
  if (!x) return [0, _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan)(y / _math_js__WEBPACK_IMPORTED_MODULE_1__.pi))];
  var x1 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(x / _math_js__WEBPACK_IMPORTED_MODULE_1__.pi),
      A = (1 - x1 * x1 - (y /= _math_js__WEBPACK_IMPORTED_MODULE_1__.pi) * y) / (2 * x1),
      A2 = A * A,
      B = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(A2 + 1);
  return [
    (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(x) * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi * (B - A),
    (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(y) * _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)((1 - 2 * A * x1) * (A + B) - x1), (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(B + A + x1)))
  ];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(vanDerGrinten2Raw)
      .scale(79.4183);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/vanDerGrinten3.js":
/*!**************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/vanDerGrinten3.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "vanDerGrinten3Raw": () => (/* binding */ vanDerGrinten3Raw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function vanDerGrinten3Raw(lambda, phi) {
  if ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(phi) < _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon) return [lambda, 0];
  var sinTheta = phi / _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi,
      theta = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(sinTheta);
  if ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(lambda) < _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon || (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(phi) - _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi) < _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon) return [0, _math_js__WEBPACK_IMPORTED_MODULE_1__.pi * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.tan)(theta / 2)];
  var A = (_math_js__WEBPACK_IMPORTED_MODULE_1__.pi / lambda - lambda / _math_js__WEBPACK_IMPORTED_MODULE_1__.pi) / 2,
      y1 = sinTheta / (1 + (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(theta));
  return [
    _math_js__WEBPACK_IMPORTED_MODULE_1__.pi * ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(lambda) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(A * A + 1 - y1 * y1) - A),
    _math_js__WEBPACK_IMPORTED_MODULE_1__.pi * y1
  ];
}

vanDerGrinten3Raw.invert = function(x, y) {
  if (!y) return [x, 0];
  var y1 = y / _math_js__WEBPACK_IMPORTED_MODULE_1__.pi,
      A = (_math_js__WEBPACK_IMPORTED_MODULE_1__.pi * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi * (1 - y1 * y1) - x * x) / (2 * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi * x);
  return [
    x ? _math_js__WEBPACK_IMPORTED_MODULE_1__.pi * ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(x) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(A * A + 1) - A) : 0,
    _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan)(y1))
  ];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(vanDerGrinten3Raw)
        .scale(79.4183);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/vanDerGrinten4.js":
/*!**************************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/vanDerGrinten4.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "vanDerGrinten4Raw": () => (/* binding */ vanDerGrinten4Raw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function vanDerGrinten4Raw(lambda, phi) {
  if (!phi) return [lambda, 0];
  var phi0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(phi);
  if (!lambda || phi0 === _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi) return [0, phi];
  var B = phi0 / _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi,
      B2 = B * B,
      C = (8 * B - B2 * (B2 + 2) - 5) / (2 * B2 * (B - 1)),
      C2 = C * C,
      BC = B * C,
      B_C2 = B2 + C2 + 2 * BC,
      B_3C = B + 3 * C,
      lambda0 = lambda / _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi,
      lambda1 = lambda0 + 1 / lambda0,
      D = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(lambda) - _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi) * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(lambda1 * lambda1 - 4),
      D2 = D * D,
      F = B_C2 * (B2 + C2 * D2 - 1) + (1 - B2) * (B2 * (B_3C * B_3C + 4 * C2) + 12 * BC * C2 + 4 * C2 * C2),
      x1 = (D * (B_C2 + C2 - 1) + 2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(F)) / (4 * B_C2 + D2);
  return [
    (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(lambda) * _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi * x1,
    (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(phi) * _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(1 + D * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(x1) - x1 * x1)
  ];
}

vanDerGrinten4Raw.invert = function(x, y) {
  var delta;
  if (!x || !y) return [x, y];
  var sy = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(y);
  y = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(y) / _math_js__WEBPACK_IMPORTED_MODULE_1__.pi;
  var x1 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(x) * x / _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi,
      D = (x1 * x1 - 1 + 4 * y * y) / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(x1),
      D2 = D * D,
      B = y * (2 - (y > 0.5 ? (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.min)(y, (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.abs)(x)) : 0)),
      r = x * x + y * y,
      i = 50;
  do {
    var B2 = B * B,
        C = (8 * B - B2 * (B2 + 2) - 5) / (2 * B2 * (B - 1)),
        C_ = (3 * B - B2 * B - 10) / (2 * B2 * B),
        C2 = C * C,
        BC = B * C,
        B_C = B + C,
        B_C2 = B_C * B_C,
        B_3C = B + 3 * C,
        F = B_C2 * (B2 + C2 * D2 - 1) + (1 - B2) * (B2 * (B_3C * B_3C + 4 * C2) + C2 * (12 * BC + 4 * C2)),
        F_ = -2 * B_C * (4 * BC * C2 + (1 - 4 * B2 + 3 * B2 * B2) * (1 + C_) + C2 * (-6 + 14 * B2 - D2 + (-8 + 8 * B2 - 2 * D2) * C_) + BC * (-8 + 12 * B2 + (-10 + 10 * B2 - D2) * C_)),
        sqrtF = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(F),
        f = D * (B_C2 + C2 - 1) + 2 * sqrtF - x1 * (4 * B_C2 + D2),
        f_ = D * (2 * C * C_ + 2 * B_C * (1 + C_)) + F_ / sqrtF - 8 * B_C * (D * (-1 + C2 + B_C2) + 2 * sqrtF) * (1 + C_) / (D2 + 4 * B_C2);
    B -= delta = f / f_;
  } while (delta * r * r > _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon && --i > 0);
  return [
    (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sign)(x) * ((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(D * D + 4) + D) * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi / 4,
    sy * _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi * B
  ];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(vanDerGrinten4Raw)
      .scale(127.16);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/wagner.js":
/*!******************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/wagner.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ wagner),
/* harmony export */   "wagner7": () => (/* binding */ wagner7),
/* harmony export */   "wagnerRaw": () => (/* binding */ wagnerRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function wagnerFormula(cx, cy, m1, m2, n) {
  function forward(lambda, phi) {
    var s = m1 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(m2 * phi),
        c0 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(1 - s * s),
        c1 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(2 / (1 + c0 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(lambda *= n)));
    return [
      cx * c0 * c1 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(lambda),
      cy * s * c1
    ];
  }

  forward.invert = function(x, y) {
    var t1 = x / cx,
        t2 = y / cy,
        p = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(t1 * t1 + t2 * t2),
        c = 2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(p / 2);
    return [
      (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)(x * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.tan)(c), cx * p) / n,
      p && (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(y * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(c) / (cy * m1 * p)) / m2
    ];
  };

  return forward;
}

function wagnerRaw(poleline, parallels, inflation, ratio) {
  // 60 is always used as reference parallel
  var phi1 = _math_js__WEBPACK_IMPORTED_MODULE_1__.pi / 3;

  // sanitizing the input values
  // poleline and parallels may approximate but never equal 0
  poleline = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.max)(poleline, _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon);
  parallels = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.max)(parallels, _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon);
  // poleline must be <= 90; parallels may approximate but never equal 180
  poleline = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.min)(poleline, _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi);
  parallels = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.min)(parallels, _math_js__WEBPACK_IMPORTED_MODULE_1__.pi - _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon);
  // 0 <= inflation <= 99.999
  inflation = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.max)(inflation, 0);
  inflation = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.min)(inflation, 100 - _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon);
  // ratio > 0.
  // sensible values, i.e. something that renders a map which still can be
  // recognized as world map, are e.g. 20 <= ratio <= 1000.
  ratio = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.max)(ratio, _math_js__WEBPACK_IMPORTED_MODULE_1__.epsilon);

  // convert values from boehm notation
  // areal inflation e.g. from 0 to 1 or 20 to 1.2:
  var vinflation = inflation/100 + 1;
  // axial ratio e.g. from 200 to 2:
  var vratio  = ratio / 100;
  // the other ones are a bit more complicated...
  var m2 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.acos)(vinflation * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi1)) / phi1,
      m1 = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(poleline) / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(m2 * _math_js__WEBPACK_IMPORTED_MODULE_1__.halfPi),
      n = parallels / _math_js__WEBPACK_IMPORTED_MODULE_1__.pi,
      k = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(vratio * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(poleline / 2) / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(parallels / 2)),
      cx = k / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(n * m1 * m2),
      cy = 1 / (k * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(n * m1 * m2));

  return wagnerFormula(cx, cy, m1, m2, n);
}

function wagner() {
  // default values generate wagner8
  var poleline = 65 * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians,
      parallels = 60 * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians,
      inflation = 20,
      ratio = 200,
      mutate = (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjectionMutator)(wagnerRaw),
      projection = mutate(poleline, parallels, inflation, ratio);

  projection.poleline = function(_) {
    return arguments.length ? mutate(poleline = +_ * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians, parallels, inflation, ratio) : poleline * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees;
  };

  projection.parallels = function(_) {
    return arguments.length ? mutate(poleline, parallels = +_ * _math_js__WEBPACK_IMPORTED_MODULE_1__.radians, inflation, ratio) : parallels * _math_js__WEBPACK_IMPORTED_MODULE_1__.degrees;
  };
  projection.inflation = function(_) {
    return arguments.length ? mutate(poleline, parallels, inflation = +_, ratio) : inflation;
  };
  projection.ratio = function(_) {
    return arguments.length ? mutate(poleline, parallels, inflation, ratio = +_) : ratio;
  };

  return projection
    .scale(163.775);
}

function wagner7() {
  return wagner()
      .poleline(65)
      .parallels(60)
      .inflation(0)
      .ratio(200)
      .scale(172.633);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/wagner4.js":
/*!*******************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/wagner4.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "wagner4Raw": () => (/* binding */ wagner4Raw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");
/* harmony import */ var _mollweide_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./mollweide.js */ "./node_modules/d3-geo-projection/src/mollweide.js");




var A = 4 * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi + 3 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(3),
    B = 2 * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(2 * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(3) / A);

var wagner4Raw = (0,_mollweide_js__WEBPACK_IMPORTED_MODULE_2__.mollweideBromleyRaw)(B * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(3) / _math_js__WEBPACK_IMPORTED_MODULE_1__.pi, B, A / 6);

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(wagner4Raw)
      .scale(176.84);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/wagner6.js":
/*!*******************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/wagner6.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "wagner6Raw": () => (/* binding */ wagner6Raw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function wagner6Raw(lambda, phi) {
  return [lambda * (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(1 - 3 * phi * phi / (_math_js__WEBPACK_IMPORTED_MODULE_1__.pi * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi)), phi];
}

wagner6Raw.invert = function(x, y) {
  return [x / (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(1 - 3 * y * y / (_math_js__WEBPACK_IMPORTED_MODULE_1__.pi * _math_js__WEBPACK_IMPORTED_MODULE_1__.pi)), y];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(wagner6Raw)
      .scale(152.63);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/wiechel.js":
/*!*******************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/wiechel.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "wiechelRaw": () => (/* binding */ wiechelRaw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");



function wiechelRaw(lambda, phi) {
  var cosPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(phi),
      sinPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(lambda) * cosPhi,
      sin1_Phi = 1 - sinPhi,
      cosLambda = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.cos)(lambda = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)((0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(lambda) * cosPhi, -(0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(phi))),
      sinLambda = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sin)(lambda);
  cosPhi = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(1 - sinPhi * sinPhi);
  return [
    sinLambda * cosPhi - cosLambda * sin1_Phi,
    -cosLambda * cosPhi - sinLambda * sin1_Phi
  ];
}

wiechelRaw.invert = function(x, y) {
  var w = (x * x + y * y) / -2,
      k = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(-w * (2 + w)),
      b = y * w + x * k,
      a = x * w - y * k,
      D = (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.sqrt)(a * a + b * b);
  return [
    (0,_math_js__WEBPACK_IMPORTED_MODULE_1__.atan2)(k * b, D * (1 + w)),
    D ? -(0,_math_js__WEBPACK_IMPORTED_MODULE_1__.asin)(k * a / D) : 0
  ];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(wiechelRaw)
      .rotate([0, -90, 45])
      .scale(124.75)
      .clipAngle(180 - 1e-3);
}


/***/ }),

/***/ "./node_modules/d3-geo-projection/src/winkel3.js":
/*!*******************************************************!*\
  !*** ./node_modules/d3-geo-projection/src/winkel3.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* export default binding */ __WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   "winkel3Raw": () => (/* binding */ winkel3Raw)
/* harmony export */ });
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! d3-geo */ "webpack/sharing/consume/default/d3-geo/d3-geo?f8f1");
/* harmony import */ var d3_geo__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(d3_geo__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aitoff_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./aitoff.js */ "./node_modules/d3-geo-projection/src/aitoff.js");
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./math.js */ "./node_modules/d3-geo-projection/src/math.js");




function winkel3Raw(lambda, phi) {
  var coordinates = (0,_aitoff_js__WEBPACK_IMPORTED_MODULE_1__.aitoffRaw)(lambda, phi);
  return [
    (coordinates[0] + lambda / _math_js__WEBPACK_IMPORTED_MODULE_2__.halfPi) / 2,
    (coordinates[1] + phi) / 2
  ];
}

winkel3Raw.invert = function(x, y) {
  var lambda = x, phi = y, i = 25;
  do {
    var cosphi = (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.cos)(phi),
        sinphi = (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.sin)(phi),
        sin_2phi = (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.sin)(2 * phi),
        sin2phi = sinphi * sinphi,
        cos2phi = cosphi * cosphi,
        sinlambda = (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.sin)(lambda),
        coslambda_2 = (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.cos)(lambda / 2),
        sinlambda_2 = (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.sin)(lambda / 2),
        sin2lambda_2 = sinlambda_2 * sinlambda_2,
        C = 1 - cos2phi * coslambda_2 * coslambda_2,
        E = C ? (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.acos)(cosphi * coslambda_2) * (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.sqrt)(F = 1 / C) : F = 0,
        F,
        fx = 0.5 * (2 * E * cosphi * sinlambda_2 + lambda / _math_js__WEBPACK_IMPORTED_MODULE_2__.halfPi) - x,
        fy = 0.5 * (E * sinphi + phi) - y,
        dxdlambda = 0.5 * F * (cos2phi * sin2lambda_2 + E * cosphi * coslambda_2 * sin2phi) + 0.5 / _math_js__WEBPACK_IMPORTED_MODULE_2__.halfPi,
        dxdphi = F * (sinlambda * sin_2phi / 4 - E * sinphi * sinlambda_2),
        dydlambda = 0.125 * F * (sin_2phi * sinlambda_2 - E * sinphi * cos2phi * sinlambda),
        dydphi = 0.5 * F * (sin2phi * coslambda_2 + E * sin2lambda_2 * cosphi) + 0.5,
        denominator = dxdphi * dydlambda - dydphi * dxdlambda,
        dlambda = (fy * dxdphi - fx * dydphi) / denominator,
        dphi = (fx * dydlambda - fy * dxdlambda) / denominator;
    lambda -= dlambda, phi -= dphi;
  } while (((0,_math_js__WEBPACK_IMPORTED_MODULE_2__.abs)(dlambda) > _math_js__WEBPACK_IMPORTED_MODULE_2__.epsilon || (0,_math_js__WEBPACK_IMPORTED_MODULE_2__.abs)(dphi) > _math_js__WEBPACK_IMPORTED_MODULE_2__.epsilon) && --i > 0);
  return [lambda, phi];
};

/* harmony default export */ function __WEBPACK_DEFAULT_EXPORT__() {
  return (0,d3_geo__WEBPACK_IMPORTED_MODULE_0__.geoProjection)(winkel3Raw)
      .scale(158.837);
}


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_d3-geo-projection_src_index_js.7af8d0d686bc6e52d0f1.js.map