import warnings
from typing import Dict, Optional
from uuid import UUID

from rest_framework import __version__ as drf_version
from rest_framework import fields, relations
from versio.version import Version
from versio.version_scheme import Pep440VersionScheme

from .action import Actions
from .mixins import (
    ActionMixin,
    ChoiceMixin,
    ConditionalVisibilityMixin,
    DateFieldMixin,
    DateTimeFieldMixin,
    DFField,
    DisplayMode,
    EnableCopyMixin,
    FieldAlignment,
    FieldHelpTextMixin,
    FieldRenderMixin,
    FileFieldMixin,
    HiddenFieldMixin,
    NullValueMixin,
    PasswordFieldMixin,
    RelatedFieldAJAXMixin,
    RTFFieldMixin,
    Statement,
    TimeFieldMixin,
)

assert DFField  # So that the linter does not complain


class AutoGeneratedField(dict):
    pass


class BooleanField(FieldRenderMixin, ActionMixin, FieldHelpTextMixin, ConditionalVisibilityMixin, fields.BooleanField):
    def __init__(
        self,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.LEFT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DCheckbox")
        kwargs["render_params"].setdefault("input_type", "checkbox")
        kwargs["render_params"].setdefault("table", "df-tablecell-bool")
        kwargs["render_params"].setdefault("field_class", "form-check-input position-checkbox-static")
        kwargs["render_params"].setdefault("label_class", "form-check-label")
        kwargs["render_params"].setdefault("container_class", "form-check form-group")
        super().__init__(**kwargs)


class CharField(
    PasswordFieldMixin, FieldRenderMixin, ActionMixin, FieldHelpTextMixin, ConditionalVisibilityMixin, fields.CharField
):
    def __init__(
        self,
        allow_blank: bool = False,
        trim_whitespace: bool = True,
        min_length: Optional[int] = None,
        max_length: Optional[int] = None,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        password_field=False,
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.LEFT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DInput")
        kwargs["render_params"].setdefault("input_type", "text")
        kwargs["render_params"].setdefault("table", "df-tablecell-plaintext")
        super().__init__(**kwargs)


class EmailField(
    PasswordFieldMixin, FieldRenderMixin, ActionMixin, FieldHelpTextMixin, ConditionalVisibilityMixin, fields.EmailField
):
    def __init__(
        self,
        allow_blank: bool = False,
        trim_whitespace: bool = True,
        min_length: Optional[int] = None,
        max_length: Optional[int] = None,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        password_field=False,
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.LEFT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DInput")
        kwargs["render_params"].setdefault("input_type", "email")
        kwargs["render_params"].setdefault("table", "df-tablecell-email")
        super().__init__(**kwargs)


class RegexField(
    PasswordFieldMixin, FieldRenderMixin, ActionMixin, FieldHelpTextMixin, ConditionalVisibilityMixin, fields.RegexField
):
    def __init__(
        self,
        regex,
        allow_blank: bool = False,
        trim_whitespace: bool = True,
        min_length: Optional[int] = None,
        max_length: Optional[int] = None,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        password_field=False,
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.LEFT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DInput")
        kwargs["render_params"].setdefault("input_type", "text")
        kwargs["render_params"].setdefault("table", "df-tablecell-plaintext")
        super().__init__(**kwargs)


class SlugField(
    PasswordFieldMixin, FieldRenderMixin, ActionMixin, FieldHelpTextMixin, ConditionalVisibilityMixin, fields.SlugField
):
    def __init__(
        self,
        allow_unicode=False,
        allow_blank: bool = False,
        trim_whitespace: bool = True,
        min_length: Optional[int] = None,
        max_length: Optional[int] = None,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        password_field=False,
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.LEFT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DInput")
        kwargs["render_params"].setdefault("input_type", "text")
        kwargs["render_params"].setdefault("table", "df-tablecell-plaintext")
        super().__init__(**kwargs)


class URLField(
    PasswordFieldMixin, FieldRenderMixin, ActionMixin, FieldHelpTextMixin, ConditionalVisibilityMixin, fields.URLField
):
    def __init__(
        self,
        allow_blank: bool = False,
        trim_whitespace: bool = True,
        min_length: Optional[int] = None,
        max_length: Optional[int] = None,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        password_field=False,
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.LEFT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DInput")
        kwargs["render_params"].setdefault("input_type", "url")
        kwargs["render_params"].setdefault("table", "df-tablecell-link")
        kwargs["render_params"].setdefault("pattern", "https?://.*")
        super().__init__(**kwargs)


class UUIDField(FieldRenderMixin, ActionMixin, FieldHelpTextMixin, ConditionalVisibilityMixin, fields.UUIDField):
    def __init__(
        self,
        format: str = "hex_verbose",
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.LEFT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DInput")
        kwargs["render_params"].setdefault("input_type", "text")
        kwargs["render_params"].setdefault("table", "df-tablecell-plaintext")
        super().__init__(**kwargs)


class IPAddressField(
    PasswordFieldMixin,
    FieldRenderMixin,
    ActionMixin,
    FieldHelpTextMixin,
    ConditionalVisibilityMixin,
    fields.IPAddressField,
):
    def __init__(
        self,
        protocol="both",
        allow_blank: bool = False,
        trim_whitespace: bool = True,
        min_length: Optional[int] = None,
        max_length: Optional[int] = None,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        password_field=False,
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.LEFT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DInput")
        kwargs["render_params"].setdefault("input_type", "text")
        kwargs["render_params"].setdefault("table", "df-tablecell-ipaddr")
        kwargs["render_params"].setdefault("minlength", 7)
        kwargs["render_params"].setdefault("maxlength", 15)
        kwargs["render_params"].setdefault("size", 15)
        super().__init__(**kwargs)


class IntegerField(
    NullValueMixin, FieldRenderMixin, ActionMixin, FieldHelpTextMixin, ConditionalVisibilityMixin, fields.IntegerField
):
    def __init__(
        self,
        max_value: int = None,
        min_value: int = None,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.RIGHT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DInput")
        kwargs["render_params"].setdefault("input_type", "number")
        kwargs["render_params"].setdefault("table", "df-tablecell-plaintext")
        super().__init__(**kwargs)


class FloatField(FieldRenderMixin, ActionMixin, FieldHelpTextMixin, ConditionalVisibilityMixin, fields.FloatField):
    def __init__(
        self,
        max_value: int = None,
        min_value: int = None,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.DECIMAL,
        render_params: Optional[Dict] = None,
        **kw
    ):
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DInput")
        kwargs["render_params"].setdefault("input_type", "number")
        kwargs["render_params"].setdefault("table", "#TableCellFloat")
        kwargs["render_params"].setdefault("table_show_zeroes", True)
        kwargs["render_params"].setdefault("step", "0.1")
        super().__init__(**kwargs)


class DecimalField(FieldRenderMixin, ActionMixin, FieldHelpTextMixin, ConditionalVisibilityMixin, fields.DecimalField):
    def __init__(
        self,
        max_digits,
        decimal_places,
        coerce_to_string=None,
        max_value=None,
        min_value=None,
        localize=False,
        rounding=None,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.RIGHT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DInput")
        kwargs["render_params"].setdefault("input_type", "number")
        kwargs["render_params"].setdefault("table", "#TableCellFloat")
        kwargs["render_params"].setdefault("table_show_zeroes", True)
        kwargs["render_params"].setdefault("step", "0.1")
        super().__init__(**kwargs)


# noinspection PyShadowingBuiltins
class DateTimeField(
    DateTimeFieldMixin,
    NullValueMixin,
    FieldRenderMixin,
    ActionMixin,
    FieldHelpTextMixin,
    ConditionalVisibilityMixin,
    fields.DateTimeField,
):
    def __init__(
        self,
        format=fields.empty,
        input_formats=None,
        default_timezone=None,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.LEFT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DDateTime")
        kwargs["render_params"].setdefault("input_type", "datetime")
        kwargs["render_params"].setdefault("table", "#TableCellDateTime")
        kwargs["render_params"].setdefault("table_format", "dd.MM.yyyy HH:mm")
        kwargs["render_params"].setdefault("form_format", "dd.MM.yyyy HH:mm")
        super().__init__(**kwargs)


# noinspection PyShadowingBuiltins
class DateField(
    DateFieldMixin,
    NullValueMixin,
    FieldRenderMixin,
    ActionMixin,
    FieldHelpTextMixin,
    ConditionalVisibilityMixin,
    fields.DateField,
):
    def __init__(
        self,
        format=fields.empty,
        input_formats=None,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.LEFT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        self.time_step = kw.pop("time_step", None)
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DDateTime")
        kwargs["render_params"].setdefault("input_type", "date")
        kwargs["render_params"].setdefault("table", "#TableCellDateTime")
        kwargs["render_params"].setdefault("table_format", "dd.MM.yyyy")
        kwargs["render_params"].setdefault("form_format", "dd.MM.yyyy")
        super().__init__(**kwargs)


# noinspection PyShadowingBuiltins
class TimeField(
    TimeFieldMixin,
    NullValueMixin,
    FieldRenderMixin,
    ActionMixin,
    FieldHelpTextMixin,
    ConditionalVisibilityMixin,
    fields.TimeField,
):
    def __init__(
        self,
        format=fields.empty,
        input_formats=None,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.LEFT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        self.time_step = kw.pop("time_step", None)
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DDateTime")
        kwargs["render_params"].setdefault("input_type", "time")
        kwargs["render_params"].setdefault("table", "#TableCellDateTime")
        kwargs["render_params"].setdefault("table_format", "HH:mm")
        kwargs["render_params"].setdefault("form_format", "HH:mm")
        super().__init__(**kwargs)


class DurationField(
    FieldRenderMixin, ActionMixin, FieldHelpTextMixin, ConditionalVisibilityMixin, fields.DurationField
):
    def __init__(
        self,
        max_value: int = None,
        min_value: int = None,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.RIGHT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DInput")
        kwargs["render_params"].setdefault("input_type", "text")
        kwargs["render_params"].setdefault("table", "df-tablecell-plaintext")
        super().__init__(**kwargs)


class ChoiceField(
    ChoiceMixin,
    EnableCopyMixin,
    FieldRenderMixin,
    ActionMixin,
    FieldHelpTextMixin,
    ConditionalVisibilityMixin,
    fields.ChoiceField,
):
    def __init__(
        self,
        choices,
        html_cutoff: int = fields.ChoiceField.html_cutoff,
        html_cutoff_text: str = fields.ChoiceField.html_cutoff_text,
        allow_blank: bool = False,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        allow_tags=False,
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.LEFT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DSelect")
        kwargs["render_params"].setdefault("input_type", "text")
        kwargs["render_params"].setdefault("table", "df-tablecell-plaintext")
        kwargs["render_params"].setdefault("multiple", False)
        kwargs["render_params"].setdefault("allow_tags", allow_tags)
        super().__init__(**kwargs)


class MultipleChoiceField(
    ChoiceMixin,
    EnableCopyMixin,
    FieldRenderMixin,
    ActionMixin,
    FieldHelpTextMixin,
    ConditionalVisibilityMixin,
    fields.MultipleChoiceField,
):
    def __init__(
        self,
        allow_empty: bool = True,
        html_cutoff: int = fields.ChoiceField.html_cutoff,
        html_cutoff_text: str = fields.ChoiceField.html_cutoff_text,
        allow_blank: bool = False,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        allow_tags=False,
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.LEFT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DSelect")
        kwargs["render_params"].setdefault("input_type", "text")
        kwargs["render_params"].setdefault("table", "df-tablecell-plaintext")
        kwargs["render_params"].setdefault("multiple", True)
        kwargs["render_params"].setdefault("allow_tags", allow_tags)
        super().__init__(**kwargs)


class FilePathField(
    ChoiceMixin,
    EnableCopyMixin,
    FieldRenderMixin,
    ActionMixin,
    FieldHelpTextMixin,
    ConditionalVisibilityMixin,
    fields.FilePathField,
):
    def __init__(
        self,
        path,
        match=None,
        recursive=False,
        allow_files=True,
        allow_folders=False,
        required=None,
        html_cutoff: int = fields.ChoiceField.html_cutoff,
        html_cutoff_text: str = fields.ChoiceField.html_cutoff_text,
        allow_blank: bool = False,
        read_only=False,
        write_only=False,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        allow_tags=False,
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.LEFT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DSelect")
        kwargs["render_params"].setdefault("input_type", "text")
        kwargs["render_params"].setdefault("table", "df-tablecell-plaintext")
        kwargs["render_params"].setdefault("multiple", False)
        kwargs["render_params"].setdefault("allow_tags", allow_tags)
        super().__init__(**kwargs)


class FileField(
    FileFieldMixin, FieldRenderMixin, ActionMixin, FieldHelpTextMixin, ConditionalVisibilityMixin, fields.FileField
):
    def __init__(
        self,
        max_length: Optional[int] = None,
        allow_empty_file: bool = False,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.LEFT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DFile")
        kwargs["render_params"].setdefault("input_type", "file")
        kwargs["render_params"].setdefault("table", "df-tablecell-file")
        super().__init__(**kwargs)


class ImageField(FieldRenderMixin, ActionMixin, FieldHelpTextMixin, ConditionalVisibilityMixin, fields.ImageField):
    def __init__(
        self,
        max_length: Optional[int] = None,
        allow_empty_file: bool = False,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.LEFT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DFile")
        kwargs["render_params"].setdefault("input_type", "file")
        kwargs["render_params"].setdefault("table", "df-tablecell-file")
        super().__init__(**kwargs)


class ListField(FieldRenderMixin, ActionMixin, FieldHelpTextMixin, ConditionalVisibilityMixin, fields.ListField):
    def __init__(
        self,
        child=fields.ListField.child,
        allow_empty: bool = True,
        max_length: Optional[int] = None,
        min_length: Optional[int] = None,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.LEFT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DFWidgetListField")
        kwargs["render_params"].setdefault("input_type", "text")
        kwargs["render_params"].setdefault("table", "df-tablecell-plaintext")
        super().__init__(**kwargs)


class DictField(FieldRenderMixin, ActionMixin, FieldHelpTextMixin, ConditionalVisibilityMixin, fields.DictField):
    def __init__(
        self,
        child=fields.DictField.child,
        allow_empty: bool = True,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.LEFT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DFWidgetDictField")
        kwargs["render_params"].setdefault("input_type", "text")
        kwargs["render_params"].setdefault("table", "df-tablecell-plaintext")
        super().__init__(**kwargs)


if hasattr(fields, "HStoreField"):

    class HStoreField(
        FieldRenderMixin, ActionMixin, FieldHelpTextMixin, ConditionalVisibilityMixin, fields.HStoreField
    ):
        def __init__(
            self,
            child=fields.DictField.child,
            allow_empty: bool = True,
            read_only=False,
            write_only=False,
            required=None,
            default=fields.empty,
            initial=fields.empty,
            source=None,
            label=None,
            help_text=None,
            style=None,
            error_messages=None,
            validators=None,
            allow_null=False,
            actions: Actions = None,
            conditional_visibility: "Statement" = None,
            uuid: UUID = None,
            display: DisplayMode = None,
            display_table: DisplayMode = None,
            display_form: DisplayMode = None,
            table_classes: str = "",
            alignment: FieldAlignment = FieldAlignment.LEFT,
            render_params: Optional[Dict] = None,
            **kw
        ):
            kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
            kwargs.update(kw)
            kwargs["render_params"] = kwargs.get("render_params", None) or {}
            kwargs["render_params"].setdefault("form_component_name", "DFWidgetDictField")
            kwargs["render_params"].setdefault("input_type", "text")
            kwargs["render_params"].setdefault("table", "df-tablecell-plaintext")
            super().__init__(**kwargs)


class JSONField(FieldRenderMixin, ActionMixin, FieldHelpTextMixin, ConditionalVisibilityMixin, fields.JSONField):
    def __init__(
        self,
        binary: bool = False,
        encoder=None,
        decoder=None,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.LEFT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        if Version(drf_version, scheme=Pep440VersionScheme) < Version("3.12", scheme=Pep440VersionScheme):
            kwargs.pop("decoder", None)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DTextArea")
        kwargs["render_params"].setdefault("input_type", "text")
        kwargs["render_params"].setdefault("table", "df-tablecell-plaintext")
        super().__init__(**kwargs)


# noinspection PyAbstractClass
class ReadOnlyField(
    FieldRenderMixin, ActionMixin, FieldHelpTextMixin, ConditionalVisibilityMixin, fields.ReadOnlyField
):
    def __init__(
        self,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.LEFT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        warnings.warn("deprecated - wrong approach! Use read_only attribute instead.", DeprecationWarning, stacklevel=2)
        read_only = True  # NOQA
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DInput")
        kwargs["render_params"].setdefault("input_type", "text")
        kwargs["render_params"].setdefault("table", "df-tablecell-plaintext")
        super().__init__(**kwargs)


# noinspection PyAbstractClass
class HiddenField(
    HiddenFieldMixin, FieldRenderMixin, ActionMixin, FieldHelpTextMixin, ConditionalVisibilityMixin, fields.HiddenField
):
    def __init__(
        self,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.LEFT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        warnings.warn(
            "deprecated - wrong approach! Use display(|_table|_form) attributes instead.",
            DeprecationWarning,
            stacklevel=2,
        )
        display = DisplayMode.HIDDEN  # NOQA
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DInput")
        kwargs["render_params"].setdefault("input_type", "text")
        kwargs["render_params"].setdefault("table", "df-tablecell-plaintext")
        super().__init__(**kwargs)


# noinspection PyAbstractClass
class SerializerMethodField(
    FieldRenderMixin, ActionMixin, FieldHelpTextMixin, ConditionalVisibilityMixin, fields.SerializerMethodField
):
    def __init__(
        self,
        method_name=None,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.LEFT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DInput")
        kwargs["render_params"].setdefault("input_type", "text")
        kwargs["render_params"].setdefault("table", "df-tablecell-plaintext")
        super().__init__(**kwargs)


class ModelField(FieldRenderMixin, ActionMixin, FieldHelpTextMixin, ConditionalVisibilityMixin, fields.ModelField):
    def __init__(
        self,
        model_field,
        max_length: Optional[int] = None,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.LEFT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DInput")
        kwargs["render_params"].setdefault("input_type", "text")
        kwargs["render_params"].setdefault("table", "df-tablecell-plaintext")
        super().__init__(**kwargs)


class StringRelatedField(
    RelatedFieldAJAXMixin,
    FieldRenderMixin,
    ActionMixin,
    FieldHelpTextMixin,
    ConditionalVisibilityMixin,
    relations.StringRelatedField,
):
    def __init__(
        self,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        url_reverse: Optional[str] = None,
        placeholder: Optional[str] = None,
        additional_parameters: Optional[Dict] = None,
        query_field: str = "query",
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.LEFT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DSelect")
        kwargs["render_params"].setdefault("input_type", "text")
        kwargs["render_params"].setdefault("table", "df-tablecell-plaintext")
        kwargs["render_params"].setdefault("multiple", False)
        super().__init__(**kwargs)


class PrimaryKeyRelatedField(
    RelatedFieldAJAXMixin,
    FieldRenderMixin,
    ActionMixin,
    FieldHelpTextMixin,
    ConditionalVisibilityMixin,
    relations.PrimaryKeyRelatedField,
):
    def __init__(
        self,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        url_reverse: Optional[str] = None,
        placeholder: Optional[str] = None,
        additional_parameters: Optional[Dict] = None,
        query_field: str = "query",
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.LEFT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DSelect")
        kwargs["render_params"].setdefault("input_type", "text")
        kwargs["render_params"].setdefault("table", "df-tablecell-plaintext")
        kwargs["render_params"].setdefault("multiple", False)
        super().__init__(**kwargs)


class HyperlinkedRelatedField(
    RelatedFieldAJAXMixin,
    FieldRenderMixin,
    ActionMixin,
    FieldHelpTextMixin,
    ConditionalVisibilityMixin,
    relations.HyperlinkedRelatedField,
):
    def __init__(
        self,
        view_name=None,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        url_reverse: Optional[str] = None,
        placeholder: Optional[str] = None,
        additional_parameters: Optional[Dict] = None,
        query_field: str = "query",
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.LEFT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DSelect")
        kwargs["render_params"].setdefault("input_type", "text")
        kwargs["render_params"].setdefault("table", "df-tablecell-plaintext")
        kwargs["render_params"].setdefault("multiple", False)
        super().__init__(**kwargs)


class HyperlinkedIdentityField(
    RelatedFieldAJAXMixin,
    FieldRenderMixin,
    ActionMixin,
    FieldHelpTextMixin,
    ConditionalVisibilityMixin,
    relations.HyperlinkedIdentityField,
):
    def __init__(
        self,
        view_name=None,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        url_reverse: Optional[str] = None,
        placeholder: Optional[str] = None,
        additional_parameters: Optional[Dict] = None,
        query_field: str = "query",
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.LEFT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DSelect")
        kwargs["render_params"].setdefault("input_type", "text")
        kwargs["render_params"].setdefault("table", "df-tablecell-plaintext")
        kwargs["render_params"].setdefault("multiple", False)
        super().__init__(**kwargs)


class SlugRelatedField(
    RelatedFieldAJAXMixin,
    FieldRenderMixin,
    ActionMixin,
    FieldHelpTextMixin,
    ConditionalVisibilityMixin,
    relations.SlugRelatedField,
):
    def __init__(
        self,
        slug_field=None,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=False,
        url_reverse: Optional[str] = None,
        placeholder: Optional[str] = None,
        additional_parameters: Optional[Dict] = None,
        query_field: str = "query",
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.LEFT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DSelect")
        kwargs["render_params"].setdefault("input_type", "text")
        kwargs["render_params"].setdefault("table", "df-tablecell-plaintext")
        kwargs["render_params"].setdefault("multiple", False)
        super().__init__(**kwargs)


class ManyRelatedField(
    RelatedFieldAJAXMixin,
    FieldRenderMixin,
    ActionMixin,
    FieldHelpTextMixin,
    ConditionalVisibilityMixin,
    relations.ManyRelatedField,
):
    def __init__(
        self,
        child_relation=None,
        read_only=False,
        write_only=False,
        required=None,
        default=fields.empty,
        initial=fields.empty,
        source=None,
        label=None,
        help_text=None,
        style=None,
        error_messages=None,
        validators=None,
        allow_null=True,
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.LEFT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        kwargs["render_params"].setdefault("form_component_name", "DSelect")
        kwargs["render_params"].setdefault("input_type", "text")
        kwargs["render_params"].setdefault("table", "df-tablecell-plaintext")
        kwargs["render_params"].setdefault("multiple", True)
        super().__init__(**kwargs)


class RTFField(
    RTFFieldMixin, FieldRenderMixin, ActionMixin, FieldHelpTextMixin, ConditionalVisibilityMixin, fields.CharField
):
    def __init__(
        self,
        actions: Actions = None,
        conditional_visibility: "Statement" = None,
        uuid: UUID = None,
        display: DisplayMode = None,
        display_table: DisplayMode = None,
        display_form: DisplayMode = None,
        table_classes: str = "",
        alignment: FieldAlignment = FieldAlignment.LEFT,
        render_params: Optional[Dict] = None,
        **kw
    ):
        kwargs = {k: v for k, v in locals().items() if not k.startswith(("__", "self", "kw"))}
        kwargs.update(kw)
        kwargs["render_params"] = kwargs.get("render_params", None) or {}
        super().__init__(**kwargs)
