"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import artifact.artifact.v1alpha.chunk_pb2
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class Conversation(google.protobuf.message.Message):
    """Conversation represents a chat conversation"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UID_FIELD_NUMBER: builtins.int
    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    LAST_USED_CATALOG_UID_FIELD_NUMBER: builtins.int
    LAST_USED_TOP_K_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    uid: builtins.str
    """unique identifier of the conversation created by the system"""
    namespace_id: builtins.str
    """namespace id"""
    app_id: builtins.str
    """app id"""
    id: builtins.str
    """conversation id/name"""
    last_used_catalog_uid: builtins.str
    """last used catalog uid"""
    last_used_top_k: builtins.int
    """last used top k"""
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """creation time of the conversation"""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """update time of the conversation"""
    def __init__(
        self,
        *,
        uid: builtins.str = ...,
        namespace_id: builtins.str = ...,
        app_id: builtins.str = ...,
        id: builtins.str = ...,
        last_used_catalog_uid: builtins.str | None = ...,
        last_used_top_k: builtins.int | None = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_last_used_catalog_uid", b"_last_used_catalog_uid", "_last_used_top_k", b"_last_used_top_k", "create_time", b"create_time", "last_used_catalog_uid", b"last_used_catalog_uid", "last_used_top_k", b"last_used_top_k", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_last_used_catalog_uid", b"_last_used_catalog_uid", "_last_used_top_k", b"_last_used_top_k", "app_id", b"app_id", "create_time", b"create_time", "id", b"id", "last_used_catalog_uid", b"last_used_catalog_uid", "last_used_top_k", b"last_used_top_k", "namespace_id", b"namespace_id", "uid", b"uid", "update_time", b"update_time"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_last_used_catalog_uid", b"_last_used_catalog_uid"]) -> typing_extensions.Literal["last_used_catalog_uid"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_last_used_top_k", b"_last_used_top_k"]) -> typing_extensions.Literal["last_used_top_k"] | None: ...

global___Conversation = Conversation

@typing_extensions.final
class Message(google.protobuf.message.Message):
    """Message represents a single message in a conversation"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _MessageType:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _MessageTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Message._MessageType.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        MESSAGE_TYPE_UNSPECIFIED: Message._MessageType.ValueType  # 0
        """unspecified"""
        MESSAGE_TYPE_TEXT: Message._MessageType.ValueType  # 1
        """text"""

    class MessageType(_MessageType, metaclass=_MessageTypeEnumTypeWrapper):
        """message type"""

    MESSAGE_TYPE_UNSPECIFIED: Message.MessageType.ValueType  # 0
    """unspecified"""
    MESSAGE_TYPE_TEXT: Message.MessageType.ValueType  # 1
    """text"""

    UID_FIELD_NUMBER: builtins.int
    APP_UID_FIELD_NUMBER: builtins.int
    CONVERSATION_UID_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    CREATE_TIME_FIELD_NUMBER: builtins.int
    UPDATE_TIME_FIELD_NUMBER: builtins.int
    MSG_SENDER_UID_FIELD_NUMBER: builtins.int
    uid: builtins.str
    """message uid"""
    app_uid: builtins.str
    """app uid"""
    conversation_uid: builtins.str
    """conversation uid"""
    content: builtins.str
    """message content"""
    role: builtins.str
    """message role e.g., "user" or "assistant" """
    type: global___Message.MessageType.ValueType
    """message type"""
    @property
    def create_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """creation time of the message"""
    @property
    def update_time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """update time of the message"""
    msg_sender_uid: builtins.str
    """message sender uid"""
    def __init__(
        self,
        *,
        uid: builtins.str = ...,
        app_uid: builtins.str = ...,
        conversation_uid: builtins.str = ...,
        content: builtins.str = ...,
        role: builtins.str = ...,
        type: global___Message.MessageType.ValueType = ...,
        create_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        msg_sender_uid: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["create_time", b"create_time", "update_time", b"update_time"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["app_uid", b"app_uid", "content", b"content", "conversation_uid", b"conversation_uid", "create_time", b"create_time", "msg_sender_uid", b"msg_sender_uid", "role", b"role", "type", b"type", "uid", b"uid", "update_time", b"update_time"]) -> None: ...

global___Message = Message

@typing_extensions.final
class CreateConversationRequest(google.protobuf.message.Message):
    """CreateConversationRequest is used to create a new conversation"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    CONVERSATION_ID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """namespace id"""
    app_id: builtins.str
    """app id"""
    conversation_id: builtins.str
    """conversation id. only allow kebab case"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        app_id: builtins.str = ...,
        conversation_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["app_id", b"app_id", "conversation_id", b"conversation_id", "namespace_id", b"namespace_id"]) -> None: ...

global___CreateConversationRequest = CreateConversationRequest

@typing_extensions.final
class CreateConversationResponse(google.protobuf.message.Message):
    """CreateConversationResponse returns the created conversation"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONVERSATION_FIELD_NUMBER: builtins.int
    @property
    def conversation(self) -> global___Conversation:
        """conversation"""
    def __init__(
        self,
        *,
        conversation: global___Conversation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["conversation", b"conversation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["conversation", b"conversation"]) -> None: ...

global___CreateConversationResponse = CreateConversationResponse

@typing_extensions.final
class ListConversationsRequest(google.protobuf.message.Message):
    """ListConversationsRequest is used to list conversations"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    CONVERSATION_UID_FIELD_NUMBER: builtins.int
    CONVERSATION_ID_FIELD_NUMBER: builtins.int
    IF_ALL_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """namespace id"""
    app_id: builtins.str
    """app id"""
    page_size: builtins.int
    """page size"""
    page_token: builtins.str
    """page token"""
    conversation_uid: builtins.str
    """conversation_uid this is optional, if provided, only the conversation with the given conversation_uid will be returned
    first check conversation_uid, then check conversation_id, then check if_all
    """
    conversation_id: builtins.str
    """conversation_id this is optional, if provided, only the conversation with the given conversation_id will be returned"""
    if_all: builtins.bool
    """If true, all conversations will be returned. This has higher priority over conversation_id, page_size, and page_token."""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        app_id: builtins.str = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        conversation_uid: builtins.str = ...,
        conversation_id: builtins.str = ...,
        if_all: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["app_id", b"app_id", "conversation_id", b"conversation_id", "conversation_uid", b"conversation_uid", "if_all", b"if_all", "namespace_id", b"namespace_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListConversationsRequest = ListConversationsRequest

@typing_extensions.final
class ListConversationsResponse(google.protobuf.message.Message):
    """ListConversationsResponse returns a list of conversations"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONVERSATIONS_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    @property
    def conversations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Conversation]:
        """conversations"""
    next_page_token: builtins.str
    """next page token"""
    total_size: builtins.int
    """total size"""
    def __init__(
        self,
        *,
        conversations: collections.abc.Iterable[global___Conversation] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["conversations", b"conversations", "next_page_token", b"next_page_token", "total_size", b"total_size"]) -> None: ...

global___ListConversationsResponse = ListConversationsResponse

@typing_extensions.final
class UpdateConversationRequest(google.protobuf.message.Message):
    """UpdateConversationRequest is used to update a conversation"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    CONVERSATION_ID_FIELD_NUMBER: builtins.int
    NEW_CONVERSATION_ID_FIELD_NUMBER: builtins.int
    LAST_USED_CATALOG_UID_FIELD_NUMBER: builtins.int
    LAST_USED_TOP_K_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """namespace id"""
    app_id: builtins.str
    """app id"""
    conversation_id: builtins.str
    """conversation id"""
    new_conversation_id: builtins.str
    """new conversation id"""
    last_used_catalog_uid: builtins.str
    """last used catalog uid"""
    last_used_top_k: builtins.int
    """last used top k"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        app_id: builtins.str = ...,
        conversation_id: builtins.str = ...,
        new_conversation_id: builtins.str | None = ...,
        last_used_catalog_uid: builtins.str | None = ...,
        last_used_top_k: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_last_used_catalog_uid", b"_last_used_catalog_uid", "_last_used_top_k", b"_last_used_top_k", "_new_conversation_id", b"_new_conversation_id", "last_used_catalog_uid", b"last_used_catalog_uid", "last_used_top_k", b"last_used_top_k", "new_conversation_id", b"new_conversation_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_last_used_catalog_uid", b"_last_used_catalog_uid", "_last_used_top_k", b"_last_used_top_k", "_new_conversation_id", b"_new_conversation_id", "app_id", b"app_id", "conversation_id", b"conversation_id", "last_used_catalog_uid", b"last_used_catalog_uid", "last_used_top_k", b"last_used_top_k", "namespace_id", b"namespace_id", "new_conversation_id", b"new_conversation_id"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_last_used_catalog_uid", b"_last_used_catalog_uid"]) -> typing_extensions.Literal["last_used_catalog_uid"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_last_used_top_k", b"_last_used_top_k"]) -> typing_extensions.Literal["last_used_top_k"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_new_conversation_id", b"_new_conversation_id"]) -> typing_extensions.Literal["new_conversation_id"] | None: ...

global___UpdateConversationRequest = UpdateConversationRequest

@typing_extensions.final
class UpdateConversationResponse(google.protobuf.message.Message):
    """UpdateConversationResponse returns the updated conversation"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONVERSATION_FIELD_NUMBER: builtins.int
    @property
    def conversation(self) -> global___Conversation:
        """conversation"""
    def __init__(
        self,
        *,
        conversation: global___Conversation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["conversation", b"conversation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["conversation", b"conversation"]) -> None: ...

global___UpdateConversationResponse = UpdateConversationResponse

@typing_extensions.final
class DeleteConversationRequest(google.protobuf.message.Message):
    """DeleteConversationRequest is used to delete a conversation"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    CONVERSATION_ID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """namespace id"""
    app_id: builtins.str
    """app id"""
    conversation_id: builtins.str
    """conversation id"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        app_id: builtins.str = ...,
        conversation_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["app_id", b"app_id", "conversation_id", b"conversation_id", "namespace_id", b"namespace_id"]) -> None: ...

global___DeleteConversationRequest = DeleteConversationRequest

@typing_extensions.final
class DeleteConversationResponse(google.protobuf.message.Message):
    """DeleteConversationResponse is empty as no content needs to be returned"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteConversationResponse = DeleteConversationResponse

@typing_extensions.final
class CreateMessageRequest(google.protobuf.message.Message):
    """CreateMessageRequest is used to create a new message"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    CONVERSATION_ID_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """namespace id"""
    app_id: builtins.str
    """app id"""
    conversation_id: builtins.str
    """conversation id"""
    content: builtins.str
    """message content"""
    role: builtins.str
    """message role"""
    type: global___Message.MessageType.ValueType
    """message type"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        app_id: builtins.str = ...,
        conversation_id: builtins.str = ...,
        content: builtins.str = ...,
        role: builtins.str = ...,
        type: global___Message.MessageType.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["app_id", b"app_id", "content", b"content", "conversation_id", b"conversation_id", "namespace_id", b"namespace_id", "role", b"role", "type", b"type"]) -> None: ...

global___CreateMessageRequest = CreateMessageRequest

@typing_extensions.final
class CreateMessageResponse(google.protobuf.message.Message):
    """CreateMessageResponse returns the created message"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESSAGE_FIELD_NUMBER: builtins.int
    @property
    def message(self) -> global___Message:
        """message"""
    def __init__(
        self,
        *,
        message: global___Message | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["message", b"message"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["message", b"message"]) -> None: ...

global___CreateMessageResponse = CreateMessageResponse

@typing_extensions.final
class MessageSenderProfile(google.protobuf.message.Message):
    """MessageSenderProfile describes the public data of a message sender.
    refer to core.mgmt.v1beta.UserProfile for more details.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MSG_SENDER_UID_FIELD_NUMBER: builtins.int
    MSG_SENDER_ID_FIELD_NUMBER: builtins.int
    DISPLAY_NAME_FIELD_NUMBER: builtins.int
    AVATAR_FIELD_NUMBER: builtins.int
    msg_sender_uid: builtins.str
    """sender uid"""
    msg_sender_id: builtins.str
    """sender id"""
    display_name: builtins.str
    """Display name."""
    avatar: builtins.str
    """Avatar url. this url might be expired or not exist."""
    def __init__(
        self,
        *,
        msg_sender_uid: builtins.str = ...,
        msg_sender_id: builtins.str = ...,
        display_name: builtins.str | None = ...,
        avatar: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_avatar", b"_avatar", "_display_name", b"_display_name", "avatar", b"avatar", "display_name", b"display_name"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_avatar", b"_avatar", "_display_name", b"_display_name", "avatar", b"avatar", "display_name", b"display_name", "msg_sender_id", b"msg_sender_id", "msg_sender_uid", b"msg_sender_uid"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_avatar", b"_avatar"]) -> typing_extensions.Literal["avatar"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_display_name", b"_display_name"]) -> typing_extensions.Literal["display_name"] | None: ...

global___MessageSenderProfile = MessageSenderProfile

@typing_extensions.final
class ListMessagesRequest(google.protobuf.message.Message):
    """ListMessagesRequest is used to list messages in a conversation"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    CONVERSATION_ID_FIELD_NUMBER: builtins.int
    LATEST_K_FIELD_NUMBER: builtins.int
    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    INCLUDE_SYSTEM_MESSAGES_FIELD_NUMBER: builtins.int
    IF_ALL_FIELD_NUMBER: builtins.int
    MESSAGE_UID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """namespace id"""
    app_id: builtins.str
    """app id"""
    conversation_id: builtins.str
    """conversation id"""
    latest_k: builtins.int
    """latest k messages"""
    page_size: builtins.int
    """page size"""
    page_token: builtins.str
    """page token"""
    include_system_messages: builtins.bool
    """include system messages"""
    if_all: builtins.bool
    """If true, all messages will be returned. This has higher priority over latest_k, page_size, and page_token."""
    message_uid: builtins.str
    """message_uid this is optional, if provided, only the message with the given message_uid will be returned"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        app_id: builtins.str = ...,
        conversation_id: builtins.str = ...,
        latest_k: builtins.int = ...,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        include_system_messages: builtins.bool = ...,
        if_all: builtins.bool = ...,
        message_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["app_id", b"app_id", "conversation_id", b"conversation_id", "if_all", b"if_all", "include_system_messages", b"include_system_messages", "latest_k", b"latest_k", "message_uid", b"message_uid", "namespace_id", b"namespace_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListMessagesRequest = ListMessagesRequest

@typing_extensions.final
class ListMessagesResponse(google.protobuf.message.Message):
    """ListMessagesResponse returns a list of messages"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESSAGES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    TOTAL_SIZE_FIELD_NUMBER: builtins.int
    SENDER_PROFILES_FIELD_NUMBER: builtins.int
    @property
    def messages(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Message]:
        """messages"""
    next_page_token: builtins.str
    """next page token"""
    total_size: builtins.int
    """total size"""
    @property
    def sender_profiles(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MessageSenderProfile]:
        """message sender profiles"""
    def __init__(
        self,
        *,
        messages: collections.abc.Iterable[global___Message] | None = ...,
        next_page_token: builtins.str = ...,
        total_size: builtins.int = ...,
        sender_profiles: collections.abc.Iterable[global___MessageSenderProfile] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["messages", b"messages", "next_page_token", b"next_page_token", "sender_profiles", b"sender_profiles", "total_size", b"total_size"]) -> None: ...

global___ListMessagesResponse = ListMessagesResponse

@typing_extensions.final
class UpdateMessageRequest(google.protobuf.message.Message):
    """UpdateMessageRequest is used to update a message"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    CONVERSATION_ID_FIELD_NUMBER: builtins.int
    MESSAGE_UID_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """namespace id"""
    app_id: builtins.str
    """app id"""
    conversation_id: builtins.str
    """conversation id"""
    message_uid: builtins.str
    """message uid"""
    content: builtins.str
    """new message content"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        app_id: builtins.str = ...,
        conversation_id: builtins.str = ...,
        message_uid: builtins.str = ...,
        content: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["app_id", b"app_id", "content", b"content", "conversation_id", b"conversation_id", "message_uid", b"message_uid", "namespace_id", b"namespace_id"]) -> None: ...

global___UpdateMessageRequest = UpdateMessageRequest

@typing_extensions.final
class UpdateMessageResponse(google.protobuf.message.Message):
    """UpdateMessageResponse returns the updated message"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESSAGE_FIELD_NUMBER: builtins.int
    @property
    def message(self) -> global___Message:
        """message"""
    def __init__(
        self,
        *,
        message: global___Message | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["message", b"message"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["message", b"message"]) -> None: ...

global___UpdateMessageResponse = UpdateMessageResponse

@typing_extensions.final
class DeleteMessageRequest(google.protobuf.message.Message):
    """DeleteMessageRequest is used to delete a message"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    CONVERSATION_ID_FIELD_NUMBER: builtins.int
    MESSAGE_UID_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """namespace id"""
    app_id: builtins.str
    """app id"""
    conversation_id: builtins.str
    """conversation id"""
    message_uid: builtins.str
    """message uid"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        app_id: builtins.str = ...,
        conversation_id: builtins.str = ...,
        message_uid: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["app_id", b"app_id", "conversation_id", b"conversation_id", "message_uid", b"message_uid", "namespace_id", b"namespace_id"]) -> None: ...

global___DeleteMessageRequest = DeleteMessageRequest

@typing_extensions.final
class DeleteMessageResponse(google.protobuf.message.Message):
    """DeleteMessageResponse is empty as no content needs to be returned"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteMessageResponse = DeleteMessageResponse

@typing_extensions.final
class ChatRequest(google.protobuf.message.Message):
    """ChatRequest represents a request to send a message
    to a chatbot synchronously and streams back the results.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAMESPACE_ID_FIELD_NUMBER: builtins.int
    APP_ID_FIELD_NUMBER: builtins.int
    CATALOG_ID_FIELD_NUMBER: builtins.int
    CONVERSATION_UID_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    TOP_K_FIELD_NUMBER: builtins.int
    namespace_id: builtins.str
    """Namespace ID"""
    app_id: builtins.str
    """App ID"""
    catalog_id: builtins.str
    """Catalog ID"""
    conversation_uid: builtins.str
    """Conversation UID"""
    message: builtins.str
    """User message"""
    top_k: builtins.int
    """top k, defaults to 5"""
    def __init__(
        self,
        *,
        namespace_id: builtins.str = ...,
        app_id: builtins.str = ...,
        catalog_id: builtins.str = ...,
        conversation_uid: builtins.str = ...,
        message: builtins.str = ...,
        top_k: builtins.int | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_top_k", b"_top_k", "top_k", b"top_k"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_top_k", b"_top_k", "app_id", b"app_id", "catalog_id", b"catalog_id", "conversation_uid", b"conversation_uid", "message", b"message", "namespace_id", b"namespace_id", "top_k", b"top_k"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_top_k", b"_top_k"]) -> typing_extensions.Literal["top_k"] | None: ...

global___ChatRequest = ChatRequest

@typing_extensions.final
class ChatResponse(google.protobuf.message.Message):
    """ChatResponse contains the chatbot response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OUTPUTS_FIELD_NUMBER: builtins.int
    CHUNKS_FIELD_NUMBER: builtins.int
    @property
    def outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.struct_pb2.Struct]:
        """Conversation responses."""
    @property
    def chunks(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[artifact.artifact.v1alpha.chunk_pb2.SimilarityChunk]:
        """Reference chunks"""
    def __init__(
        self,
        *,
        outputs: collections.abc.Iterable[google.protobuf.struct_pb2.Struct] | None = ...,
        chunks: collections.abc.Iterable[artifact.artifact.v1alpha.chunk_pb2.SimilarityChunk] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["chunks", b"chunks", "outputs", b"outputs"]) -> None: ...

global___ChatResponse = ChatResponse
