"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import abc
import collections.abc
import grpc
import grpc.aio
import model.model.v1alpha.model_definition_pb2
import model.model.v1alpha.model_pb2
import typing

_T = typing.TypeVar('_T')

class _MaybeAsyncIterator(collections.abc.AsyncIterator[_T], collections.abc.Iterator[_T], metaclass=abc.ABCMeta):
    ...

class _ServicerContext(grpc.ServicerContext, grpc.aio.ServicerContext):  # type: ignore
    ...

class ModelPublicServiceStub:
    """Model

    ModelPublicService exposes the public endpoints that allow clients to manage
    models.
    """

    def __init__(self, channel: typing.Union[grpc.Channel, grpc.aio.Channel]) -> None: ...
    Liveness: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.LivenessRequest,
        model.model.v1alpha.model_pb2.LivenessResponse,
    ]
    """Check if the model server is alive

    See https://github.com/grpc/grpc/blob/master/doc/health-checking.md.
    """
    Readiness: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.ReadinessRequest,
        model.model.v1alpha.model_pb2.ReadinessResponse,
    ]
    """Check if the model server is ready

    See https://github.com/grpc/grpc/blob/master/doc/health-checking.md
    """
    ListModelDefinitions: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_definition_pb2.ListModelDefinitionsRequest,
        model.model.v1alpha.model_definition_pb2.ListModelDefinitionsResponse,
    ]
    """List model definitions

    Returns a paginated list of model definitions.
    """
    ListAvailableRegions: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.ListAvailableRegionsRequest,
        model.model.v1alpha.model_pb2.ListAvailableRegionsResponse,
    ]
    """List available regions

    Returns a paginated list of available regions.
    """
    GetModelDefinition: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_definition_pb2.GetModelDefinitionRequest,
        model.model.v1alpha.model_definition_pb2.GetModelDefinitionResponse,
    ]
    """Get a model definition

    Returns the details of a model definition.
    """
    ListModels: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.ListModelsRequest,
        model.model.v1alpha.model_pb2.ListModelsResponse,
    ]
    """List models

    Returns a paginated list of models.
    """
    LookUpModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.LookUpModelRequest,
        model.model.v1alpha.model_pb2.LookUpModelResponse,
    ]
    """Get a model by UID

    Returns the details of a model by a permalink defined by the resource UID.
    """
    ListNamespaceModels: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.ListNamespaceModelsRequest,
        model.model.v1alpha.model_pb2.ListNamespaceModelsResponse,
    ]
    """List namespace models

    Returns a paginated list of models.
    """
    CreateNamespaceModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.CreateNamespaceModelRequest,
        model.model.v1alpha.model_pb2.CreateNamespaceModelResponse,
    ]
    """Create a new model

    Creates a new model under the parenthood of a namespace. This is an
    asynchronous endpoint, i.e., the server will not wait for the model to be
    created in order to respond. Instead, it will return a response with the
    necessary information to access the result and status of the creation
    operation.
    """
    GetNamespaceModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.GetNamespaceModelRequest,
        model.model.v1alpha.model_pb2.GetNamespaceModelResponse,
    ]
    """Get a model

    Returns the detail of a model, accessing it by the model ID and its parent namespace.
    """
    UpdateNamespaceModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.UpdateNamespaceModelRequest,
        model.model.v1alpha.model_pb2.UpdateNamespaceModelResponse,
    ]
    """Update a model

    Updates a model, accessing it by its resource name, which is defined by
    the parent namespace and the ID of the model.

    In REST requests, only the supplied model fields will be taken into
    account when updating the resource.
    """
    DeleteNamespaceModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.DeleteNamespaceModelRequest,
        model.model.v1alpha.model_pb2.DeleteNamespaceModelResponse,
    ]
    """Delete a model

    Deletes a model, accesing it by its resource name, which is defined by the
    parent namespace and the ID of the model.
    """
    RenameNamespaceModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.RenameNamespaceModelRequest,
        model.model.v1alpha.model_pb2.RenameNamespaceModelResponse,
    ]
    """Rename a model

    Renames a model, accesing it by its resource name, which is defined by the
    parent namespace and the ID of the model.
    """
    WatchNamespaceModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.WatchNamespaceModelRequest,
        model.model.v1alpha.model_pb2.WatchNamespaceModelResponse,
    ]
    """Watch the state of a model version

    Returns the state of a model. The model resource allocation and scaling actions take some
    time, during which a model will be in various state. This endpoint
    allows clients to track the state.
    """
    WatchNamespaceLatestModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.WatchNamespaceLatestModelRequest,
        model.model.v1alpha.model_pb2.WatchNamespaceLatestModelResponse,
    ]
    """Watch the state of the latest model version

    Returns the state of the latest model version. The model resource allocation and scaling actions
    take some time, during which a model will be in various state. This endpoint
    allows clients to track the state.
    """
    ListNamespaceModelVersions: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.ListNamespaceModelVersionsRequest,
        model.model.v1alpha.model_pb2.ListNamespaceModelVersionsResponse,
    ]
    """List namespace model versions

    Returns a paginated list of version of a model namespace that belong to the specified namespace.
    Contains model version and digest.
    """
    DeleteNamespaceModelVersion: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.DeleteNamespaceModelVersionRequest,
        model.model.v1alpha.model_pb2.DeleteNamespaceModelVersionResponse,
    ]
    """Delete a model version

    Deletes a model version, accesing it by its resource name, which is defined by the
    parent namespace and the ID of the model, and version.
    """
    TriggerNamespaceModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerNamespaceModelRequest,
        model.model.v1alpha.model_pb2.TriggerNamespaceModelResponse,
    ]
    """Trigger model inference

    Triggers a deployed model to infer the result of a set of task or
    questions.
    """
    TriggerAsyncNamespaceModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerAsyncNamespaceModelRequest,
        model.model.v1alpha.model_pb2.TriggerAsyncNamespaceModelResponse,
    ]
    """Trigger model inference asynchronously

    Triggers a deployed model to infer the result of a set of task or
    questions.
    """
    TriggerNamespaceLatestModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerNamespaceLatestModelRequest,
        model.model.v1alpha.model_pb2.TriggerNamespaceLatestModelResponse,
    ]
    """Trigger model inference

    Triggers the latest deployed model version to infer the result of a set of task or
    questions.
    """
    TriggerAsyncNamespaceLatestModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerAsyncNamespaceLatestModelRequest,
        model.model.v1alpha.model_pb2.TriggerAsyncNamespaceLatestModelResponse,
    ]
    """Trigger model inference asynchronously

    Triggers the latest deployed model version to infer the result of a set of task or
    questions.
    """
    TriggerNamespaceModelBinaryFileUpload: grpc.StreamUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerNamespaceModelBinaryFileUploadRequest,
        model.model.v1alpha.model_pb2.TriggerNamespaceModelBinaryFileUploadResponse,
    ]
    """Trigger model inference with a binary input

    Triggers a deployed model to infer the result of a task or question,
    submitted as a binary file.
    """
    TriggerNamespaceLatestModelBinaryFileUpload: grpc.StreamUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerNamespaceLatestModelBinaryFileUploadRequest,
        model.model.v1alpha.model_pb2.TriggerNamespaceLatestModelBinaryFileUploadResponse,
    ]
    """Trigger model inference with a binary input

    Triggers the latest deployed model version to infer the result of a set of task or
    questions, submitted as a binary file.
    """
    GetNamespaceModelOperation: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.GetNamespaceModelOperationRequest,
        model.model.v1alpha.model_pb2.GetNamespaceModelOperationResponse,
    ]
    """Get the details of the long-running operation from a namespace model
    with a particular version

    This method allows requesters to request the status and outcome of
    long-running operations in a model, such as trigger.
    """
    GetNamespaceLatestModelOperation: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.GetNamespaceLatestModelOperationRequest,
        model.model.v1alpha.model_pb2.GetNamespaceLatestModelOperationResponse,
    ]
    """Get the details of the latest long-running operation from a namespace model

    This method allows requesters to request the status and outcome of
    long-running operations in a model, such as trigger.
    """
    GetModelOperation: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.GetModelOperationRequest,
        model.model.v1alpha.model_pb2.GetModelOperationResponse,
    ]
    """Get the details of a long-running operation

    This method allows requesters to request the status and outcome of
    long-running operations in a model, such as trigger.
    """
    ListUserModels: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.ListUserModelsRequest,
        model.model.v1alpha.model_pb2.ListUserModelsResponse,
    ]
    """The following endpoints are all deprecated

    List user models

    Returns a paginated list of models that belong to the specified user. The
    parent user may be different from the authenticated user, in which case
    the results will contain the models that are visible to the latter.
    """
    CreateUserModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.CreateUserModelRequest,
        model.model.v1alpha.model_pb2.CreateUserModelResponse,
    ]
    """Create a new model

    Creates a new model under the parenthood of a user. This is an
    asynchronous endpoint, i.e., the server will not wait for the model to be
    created in order to respond. Instead, it will return a response with the
    necessary information to access the result and status of the creation
    operation.
    """
    GetUserModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.GetUserModelRequest,
        model.model.v1alpha.model_pb2.GetUserModelResponse,
    ]
    """Get a model

    Returns the detail of a model, accessing it by the model ID and its parent user.
    """
    UpdateUserModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.UpdateUserModelRequest,
        model.model.v1alpha.model_pb2.UpdateUserModelResponse,
    ]
    """Update a model

    Updates a model, accessing it by its resource name, which is defined by
    the parent user and the ID of the model.

    In REST requests, only the supplied model fields will be taken into
    account when updating the resource.
    """
    DeleteUserModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.DeleteUserModelRequest,
        model.model.v1alpha.model_pb2.DeleteUserModelResponse,
    ]
    """Delete a model

    Deletes a model, accesing it by its resource name, which is defined by the
    parent user and the ID of the model.
    """
    RenameUserModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.RenameUserModelRequest,
        model.model.v1alpha.model_pb2.RenameUserModelResponse,
    ]
    """Rename a model

    Renames a model, accesing it by its resource name, which is defined by the
    parent user and the ID of the model.
    """
    WatchUserModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.WatchUserModelRequest,
        model.model.v1alpha.model_pb2.WatchUserModelResponse,
    ]
    """Watch the state of a model version

    Returns the state of a model. The model resource allocation and scaling actions take some
    time, during which a model will be in various state. This endpoint
    allows clients to track the state.
    """
    WatchUserLatestModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.WatchUserLatestModelRequest,
        model.model.v1alpha.model_pb2.WatchUserLatestModelResponse,
    ]
    """Watch the state of the latest model version

    Returns the state of the latest model version. The model resource allocation and scaling actions
    take some time, during which a model will be in various state. This endpoint
    allows clients to track the state.
    """
    ListUserModelVersions: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.ListUserModelVersionsRequest,
        model.model.v1alpha.model_pb2.ListUserModelVersionsResponse,
    ]
    """List user model versions

    Returns a paginated list of version of a model namespace that belong to the specified user.
    Contains model version and digest.
    """
    DeleteUserModelVersion: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.DeleteUserModelVersionRequest,
        model.model.v1alpha.model_pb2.DeleteUserModelVersionResponse,
    ]
    """Delete a model version

    Deletes a model version, accesing it by its resource name, which is defined by the
    parent user and the ID of the model, and version.
    """
    TriggerUserModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerUserModelRequest,
        model.model.v1alpha.model_pb2.TriggerUserModelResponse,
    ]
    """/////////////////////////////////////////////////////

    Trigger model inference

    Triggers a deployed model to infer the result of a set of task or
    questions.
    """
    TriggerAsyncUserModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerAsyncUserModelRequest,
        model.model.v1alpha.model_pb2.TriggerAsyncUserModelResponse,
    ]
    """Trigger model inference asynchronously

    Triggers a deployed model to infer the result of a set of task or
    questions.
    """
    TriggerUserLatestModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerUserLatestModelRequest,
        model.model.v1alpha.model_pb2.TriggerUserLatestModelResponse,
    ]
    """Trigger model inference

    Triggers the latest deployed model version to infer the result of a set of task or
    questions.
    """
    TriggerAsyncUserLatestModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerAsyncUserLatestModelRequest,
        model.model.v1alpha.model_pb2.TriggerAsyncUserLatestModelResponse,
    ]
    """Trigger model inference asynchronously

    Triggers the latest deployed model version to infer the result of a set of task or
    questions.
    """
    TriggerUserModelBinaryFileUpload: grpc.StreamUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerUserModelBinaryFileUploadRequest,
        model.model.v1alpha.model_pb2.TriggerUserModelBinaryFileUploadResponse,
    ]
    """Trigger model inference with a binary input

    Triggers a deployed model to infer the result of a task or question,
    submitted as a binary file.
    """
    ListOrganizationModels: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.ListOrganizationModelsRequest,
        model.model.v1alpha.model_pb2.ListOrganizationModelsResponse,
    ]
    """List organization models

    Returns a paginated list of models that belong to the specified organization. The
    parent organization may be different from the authenticated organization, in which case
    the results will contain the models that are visible to the latter.
    """
    CreateOrganizationModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.CreateOrganizationModelRequest,
        model.model.v1alpha.model_pb2.CreateOrganizationModelResponse,
    ]
    """Create a new model

    Creates a new model under the parenthood of an organization. This is an
    asynchronous endpoint, i.e., the server will not wait for the model to be
    created in order to respond. Instead, it will return a response with the
    necessary information to access the result and status of the creation
    operation.
    """
    GetOrganizationModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.GetOrganizationModelRequest,
        model.model.v1alpha.model_pb2.GetOrganizationModelResponse,
    ]
    """Get a model

    Returns the detail of a model, accessing it by the model ID and its parent organization.
    """
    UpdateOrganizationModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.UpdateOrganizationModelRequest,
        model.model.v1alpha.model_pb2.UpdateOrganizationModelResponse,
    ]
    """Update a model

    Updates a model, accessing it by its resource name, which is defined by
    the parent organization and the ID of the model.

    In REST requests, only the supplied model fields will be taken into
    account when updating the resource.
    """
    DeleteOrganizationModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.DeleteOrganizationModelRequest,
        model.model.v1alpha.model_pb2.DeleteOrganizationModelResponse,
    ]
    """Delete a model

    Deletes a model, accesing it by its resource name, which is defined by the
    parent organization and the ID of the model.
    """
    RenameOrganizationModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.RenameOrganizationModelRequest,
        model.model.v1alpha.model_pb2.RenameOrganizationModelResponse,
    ]
    """Rename a model

    Renames a model, accesing it by its resource name, which is defined by the
    parent organization and the ID of the model.
    """
    WatchOrganizationModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.WatchOrganizationModelRequest,
        model.model.v1alpha.model_pb2.WatchOrganizationModelResponse,
    ]
    """Watch the state of a model version

    Returns the state of a model.  The model resource allocation and scaling actions
    take some time, during which a model will be in various state. This endpoint
    allows clients to track the state.
    """
    WatchOrganizationLatestModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.WatchOrganizationLatestModelRequest,
        model.model.v1alpha.model_pb2.WatchOrganizationLatestModelResponse,
    ]
    """Watch the state of the latest model version

    Returns the state of the latest model version.  The model resource allocation and scaling actions
    take some time, during which a model will be in various state. This endpoint
    allows clients to track the state.
    """
    ListOrganizationModelVersions: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.ListOrganizationModelVersionsRequest,
        model.model.v1alpha.model_pb2.ListOrganizationModelVersionsResponse,
    ]
    """List organization model versions

    Returns a paginated list of version of a model namespace that belong to the specified organization.
    Contains model version and digest.
    """
    DeleteOrganizationModelVersion: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.DeleteOrganizationModelVersionRequest,
        model.model.v1alpha.model_pb2.DeleteOrganizationModelVersionResponse,
    ]
    """Delete a model version

    Deletes a model version, accesing it by its resource name, which is defined by the
    parent organization and the ID of the model, and version.
    """
    TriggerOrganizationModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerOrganizationModelRequest,
        model.model.v1alpha.model_pb2.TriggerOrganizationModelResponse,
    ]
    """/////////////////////////////////////////////////////

    Trigger model inference

    Triggers a deployed model to infer the result of a set of task or
    questions.
    """
    TriggerAsyncOrganizationModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerAsyncOrganizationModelRequest,
        model.model.v1alpha.model_pb2.TriggerAsyncOrganizationModelResponse,
    ]
    """Trigger model inference asynchronously

    Triggers a deployed model to infer the result of a set of task or
    questions.
    """
    TriggerOrganizationLatestModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerOrganizationLatestModelRequest,
        model.model.v1alpha.model_pb2.TriggerOrganizationLatestModelResponse,
    ]
    """Trigger model inference

    Triggers the latest deployed model version to infer the result of a set of task or
    questions.
    """
    TriggerAsyncOrganizationLatestModel: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerAsyncOrganizationLatestModelRequest,
        model.model.v1alpha.model_pb2.TriggerAsyncOrganizationLatestModelResponse,
    ]
    """Trigger model inference asynchronously

    Triggers the latest deployed model version to infer the result of a set of task or
    questions.
    """
    TriggerOrganizationModelBinaryFileUpload: grpc.StreamUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerOrganizationModelBinaryFileUploadRequest,
        model.model.v1alpha.model_pb2.TriggerOrganizationModelBinaryFileUploadResponse,
    ]
    """Trigger model inference with a binary input

    Triggers a deployed model to infer the result of a task or question,
    submitted as a binary file.
    """
    GetUserLatestModelOperation: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.GetUserLatestModelOperationRequest,
        model.model.v1alpha.model_pb2.GetUserLatestModelOperationResponse,
    ]
    """Get the details of the latest long-running operation from a user model

    This method allows requesters to request the status and outcome of
    long-running operations in a model, such as trigger.
    """
    GetOrganizationLatestModelOperation: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.GetOrganizationLatestModelOperationRequest,
        model.model.v1alpha.model_pb2.GetOrganizationLatestModelOperationResponse,
    ]
    """Get the details of the latest long-running operation from a organization model

    This method allows requesters to request the status and outcome of
    long-running operations in a model, such as trigger.
    """
    ListModelRuns: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.ListModelRunsRequest,
        model.model.v1alpha.model_pb2.ListModelRunsResponse,
    ]
    """List model runs

    Returns a paginated list of model runs.
    """
    ListModelRunsByRequester: grpc.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.ListModelRunsByRequesterRequest,
        model.model.v1alpha.model_pb2.ListModelRunsByRequesterResponse,
    ]
    """List Model Runs of a Namespace (user or organization)

    Returns a paginated list of runs for 1 or more models. This is mainly used by dashboard.
    The requester can view all the runs by the requester across different models.
    """

class ModelPublicServiceAsyncStub:
    """Model

    ModelPublicService exposes the public endpoints that allow clients to manage
    models.
    """

    Liveness: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.LivenessRequest,
        model.model.v1alpha.model_pb2.LivenessResponse,
    ]
    """Check if the model server is alive

    See https://github.com/grpc/grpc/blob/master/doc/health-checking.md.
    """
    Readiness: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.ReadinessRequest,
        model.model.v1alpha.model_pb2.ReadinessResponse,
    ]
    """Check if the model server is ready

    See https://github.com/grpc/grpc/blob/master/doc/health-checking.md
    """
    ListModelDefinitions: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_definition_pb2.ListModelDefinitionsRequest,
        model.model.v1alpha.model_definition_pb2.ListModelDefinitionsResponse,
    ]
    """List model definitions

    Returns a paginated list of model definitions.
    """
    ListAvailableRegions: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.ListAvailableRegionsRequest,
        model.model.v1alpha.model_pb2.ListAvailableRegionsResponse,
    ]
    """List available regions

    Returns a paginated list of available regions.
    """
    GetModelDefinition: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_definition_pb2.GetModelDefinitionRequest,
        model.model.v1alpha.model_definition_pb2.GetModelDefinitionResponse,
    ]
    """Get a model definition

    Returns the details of a model definition.
    """
    ListModels: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.ListModelsRequest,
        model.model.v1alpha.model_pb2.ListModelsResponse,
    ]
    """List models

    Returns a paginated list of models.
    """
    LookUpModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.LookUpModelRequest,
        model.model.v1alpha.model_pb2.LookUpModelResponse,
    ]
    """Get a model by UID

    Returns the details of a model by a permalink defined by the resource UID.
    """
    ListNamespaceModels: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.ListNamespaceModelsRequest,
        model.model.v1alpha.model_pb2.ListNamespaceModelsResponse,
    ]
    """List namespace models

    Returns a paginated list of models.
    """
    CreateNamespaceModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.CreateNamespaceModelRequest,
        model.model.v1alpha.model_pb2.CreateNamespaceModelResponse,
    ]
    """Create a new model

    Creates a new model under the parenthood of a namespace. This is an
    asynchronous endpoint, i.e., the server will not wait for the model to be
    created in order to respond. Instead, it will return a response with the
    necessary information to access the result and status of the creation
    operation.
    """
    GetNamespaceModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.GetNamespaceModelRequest,
        model.model.v1alpha.model_pb2.GetNamespaceModelResponse,
    ]
    """Get a model

    Returns the detail of a model, accessing it by the model ID and its parent namespace.
    """
    UpdateNamespaceModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.UpdateNamespaceModelRequest,
        model.model.v1alpha.model_pb2.UpdateNamespaceModelResponse,
    ]
    """Update a model

    Updates a model, accessing it by its resource name, which is defined by
    the parent namespace and the ID of the model.

    In REST requests, only the supplied model fields will be taken into
    account when updating the resource.
    """
    DeleteNamespaceModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.DeleteNamespaceModelRequest,
        model.model.v1alpha.model_pb2.DeleteNamespaceModelResponse,
    ]
    """Delete a model

    Deletes a model, accesing it by its resource name, which is defined by the
    parent namespace and the ID of the model.
    """
    RenameNamespaceModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.RenameNamespaceModelRequest,
        model.model.v1alpha.model_pb2.RenameNamespaceModelResponse,
    ]
    """Rename a model

    Renames a model, accesing it by its resource name, which is defined by the
    parent namespace and the ID of the model.
    """
    WatchNamespaceModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.WatchNamespaceModelRequest,
        model.model.v1alpha.model_pb2.WatchNamespaceModelResponse,
    ]
    """Watch the state of a model version

    Returns the state of a model. The model resource allocation and scaling actions take some
    time, during which a model will be in various state. This endpoint
    allows clients to track the state.
    """
    WatchNamespaceLatestModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.WatchNamespaceLatestModelRequest,
        model.model.v1alpha.model_pb2.WatchNamespaceLatestModelResponse,
    ]
    """Watch the state of the latest model version

    Returns the state of the latest model version. The model resource allocation and scaling actions
    take some time, during which a model will be in various state. This endpoint
    allows clients to track the state.
    """
    ListNamespaceModelVersions: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.ListNamespaceModelVersionsRequest,
        model.model.v1alpha.model_pb2.ListNamespaceModelVersionsResponse,
    ]
    """List namespace model versions

    Returns a paginated list of version of a model namespace that belong to the specified namespace.
    Contains model version and digest.
    """
    DeleteNamespaceModelVersion: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.DeleteNamespaceModelVersionRequest,
        model.model.v1alpha.model_pb2.DeleteNamespaceModelVersionResponse,
    ]
    """Delete a model version

    Deletes a model version, accesing it by its resource name, which is defined by the
    parent namespace and the ID of the model, and version.
    """
    TriggerNamespaceModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerNamespaceModelRequest,
        model.model.v1alpha.model_pb2.TriggerNamespaceModelResponse,
    ]
    """Trigger model inference

    Triggers a deployed model to infer the result of a set of task or
    questions.
    """
    TriggerAsyncNamespaceModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerAsyncNamespaceModelRequest,
        model.model.v1alpha.model_pb2.TriggerAsyncNamespaceModelResponse,
    ]
    """Trigger model inference asynchronously

    Triggers a deployed model to infer the result of a set of task or
    questions.
    """
    TriggerNamespaceLatestModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerNamespaceLatestModelRequest,
        model.model.v1alpha.model_pb2.TriggerNamespaceLatestModelResponse,
    ]
    """Trigger model inference

    Triggers the latest deployed model version to infer the result of a set of task or
    questions.
    """
    TriggerAsyncNamespaceLatestModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerAsyncNamespaceLatestModelRequest,
        model.model.v1alpha.model_pb2.TriggerAsyncNamespaceLatestModelResponse,
    ]
    """Trigger model inference asynchronously

    Triggers the latest deployed model version to infer the result of a set of task or
    questions.
    """
    TriggerNamespaceModelBinaryFileUpload: grpc.aio.StreamUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerNamespaceModelBinaryFileUploadRequest,
        model.model.v1alpha.model_pb2.TriggerNamespaceModelBinaryFileUploadResponse,
    ]
    """Trigger model inference with a binary input

    Triggers a deployed model to infer the result of a task or question,
    submitted as a binary file.
    """
    TriggerNamespaceLatestModelBinaryFileUpload: grpc.aio.StreamUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerNamespaceLatestModelBinaryFileUploadRequest,
        model.model.v1alpha.model_pb2.TriggerNamespaceLatestModelBinaryFileUploadResponse,
    ]
    """Trigger model inference with a binary input

    Triggers the latest deployed model version to infer the result of a set of task or
    questions, submitted as a binary file.
    """
    GetNamespaceModelOperation: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.GetNamespaceModelOperationRequest,
        model.model.v1alpha.model_pb2.GetNamespaceModelOperationResponse,
    ]
    """Get the details of the long-running operation from a namespace model
    with a particular version

    This method allows requesters to request the status and outcome of
    long-running operations in a model, such as trigger.
    """
    GetNamespaceLatestModelOperation: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.GetNamespaceLatestModelOperationRequest,
        model.model.v1alpha.model_pb2.GetNamespaceLatestModelOperationResponse,
    ]
    """Get the details of the latest long-running operation from a namespace model

    This method allows requesters to request the status and outcome of
    long-running operations in a model, such as trigger.
    """
    GetModelOperation: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.GetModelOperationRequest,
        model.model.v1alpha.model_pb2.GetModelOperationResponse,
    ]
    """Get the details of a long-running operation

    This method allows requesters to request the status and outcome of
    long-running operations in a model, such as trigger.
    """
    ListUserModels: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.ListUserModelsRequest,
        model.model.v1alpha.model_pb2.ListUserModelsResponse,
    ]
    """The following endpoints are all deprecated

    List user models

    Returns a paginated list of models that belong to the specified user. The
    parent user may be different from the authenticated user, in which case
    the results will contain the models that are visible to the latter.
    """
    CreateUserModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.CreateUserModelRequest,
        model.model.v1alpha.model_pb2.CreateUserModelResponse,
    ]
    """Create a new model

    Creates a new model under the parenthood of a user. This is an
    asynchronous endpoint, i.e., the server will not wait for the model to be
    created in order to respond. Instead, it will return a response with the
    necessary information to access the result and status of the creation
    operation.
    """
    GetUserModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.GetUserModelRequest,
        model.model.v1alpha.model_pb2.GetUserModelResponse,
    ]
    """Get a model

    Returns the detail of a model, accessing it by the model ID and its parent user.
    """
    UpdateUserModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.UpdateUserModelRequest,
        model.model.v1alpha.model_pb2.UpdateUserModelResponse,
    ]
    """Update a model

    Updates a model, accessing it by its resource name, which is defined by
    the parent user and the ID of the model.

    In REST requests, only the supplied model fields will be taken into
    account when updating the resource.
    """
    DeleteUserModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.DeleteUserModelRequest,
        model.model.v1alpha.model_pb2.DeleteUserModelResponse,
    ]
    """Delete a model

    Deletes a model, accesing it by its resource name, which is defined by the
    parent user and the ID of the model.
    """
    RenameUserModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.RenameUserModelRequest,
        model.model.v1alpha.model_pb2.RenameUserModelResponse,
    ]
    """Rename a model

    Renames a model, accesing it by its resource name, which is defined by the
    parent user and the ID of the model.
    """
    WatchUserModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.WatchUserModelRequest,
        model.model.v1alpha.model_pb2.WatchUserModelResponse,
    ]
    """Watch the state of a model version

    Returns the state of a model. The model resource allocation and scaling actions take some
    time, during which a model will be in various state. This endpoint
    allows clients to track the state.
    """
    WatchUserLatestModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.WatchUserLatestModelRequest,
        model.model.v1alpha.model_pb2.WatchUserLatestModelResponse,
    ]
    """Watch the state of the latest model version

    Returns the state of the latest model version. The model resource allocation and scaling actions
    take some time, during which a model will be in various state. This endpoint
    allows clients to track the state.
    """
    ListUserModelVersions: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.ListUserModelVersionsRequest,
        model.model.v1alpha.model_pb2.ListUserModelVersionsResponse,
    ]
    """List user model versions

    Returns a paginated list of version of a model namespace that belong to the specified user.
    Contains model version and digest.
    """
    DeleteUserModelVersion: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.DeleteUserModelVersionRequest,
        model.model.v1alpha.model_pb2.DeleteUserModelVersionResponse,
    ]
    """Delete a model version

    Deletes a model version, accesing it by its resource name, which is defined by the
    parent user and the ID of the model, and version.
    """
    TriggerUserModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerUserModelRequest,
        model.model.v1alpha.model_pb2.TriggerUserModelResponse,
    ]
    """/////////////////////////////////////////////////////

    Trigger model inference

    Triggers a deployed model to infer the result of a set of task or
    questions.
    """
    TriggerAsyncUserModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerAsyncUserModelRequest,
        model.model.v1alpha.model_pb2.TriggerAsyncUserModelResponse,
    ]
    """Trigger model inference asynchronously

    Triggers a deployed model to infer the result of a set of task or
    questions.
    """
    TriggerUserLatestModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerUserLatestModelRequest,
        model.model.v1alpha.model_pb2.TriggerUserLatestModelResponse,
    ]
    """Trigger model inference

    Triggers the latest deployed model version to infer the result of a set of task or
    questions.
    """
    TriggerAsyncUserLatestModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerAsyncUserLatestModelRequest,
        model.model.v1alpha.model_pb2.TriggerAsyncUserLatestModelResponse,
    ]
    """Trigger model inference asynchronously

    Triggers the latest deployed model version to infer the result of a set of task or
    questions.
    """
    TriggerUserModelBinaryFileUpload: grpc.aio.StreamUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerUserModelBinaryFileUploadRequest,
        model.model.v1alpha.model_pb2.TriggerUserModelBinaryFileUploadResponse,
    ]
    """Trigger model inference with a binary input

    Triggers a deployed model to infer the result of a task or question,
    submitted as a binary file.
    """
    ListOrganizationModels: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.ListOrganizationModelsRequest,
        model.model.v1alpha.model_pb2.ListOrganizationModelsResponse,
    ]
    """List organization models

    Returns a paginated list of models that belong to the specified organization. The
    parent organization may be different from the authenticated organization, in which case
    the results will contain the models that are visible to the latter.
    """
    CreateOrganizationModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.CreateOrganizationModelRequest,
        model.model.v1alpha.model_pb2.CreateOrganizationModelResponse,
    ]
    """Create a new model

    Creates a new model under the parenthood of an organization. This is an
    asynchronous endpoint, i.e., the server will not wait for the model to be
    created in order to respond. Instead, it will return a response with the
    necessary information to access the result and status of the creation
    operation.
    """
    GetOrganizationModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.GetOrganizationModelRequest,
        model.model.v1alpha.model_pb2.GetOrganizationModelResponse,
    ]
    """Get a model

    Returns the detail of a model, accessing it by the model ID and its parent organization.
    """
    UpdateOrganizationModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.UpdateOrganizationModelRequest,
        model.model.v1alpha.model_pb2.UpdateOrganizationModelResponse,
    ]
    """Update a model

    Updates a model, accessing it by its resource name, which is defined by
    the parent organization and the ID of the model.

    In REST requests, only the supplied model fields will be taken into
    account when updating the resource.
    """
    DeleteOrganizationModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.DeleteOrganizationModelRequest,
        model.model.v1alpha.model_pb2.DeleteOrganizationModelResponse,
    ]
    """Delete a model

    Deletes a model, accesing it by its resource name, which is defined by the
    parent organization and the ID of the model.
    """
    RenameOrganizationModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.RenameOrganizationModelRequest,
        model.model.v1alpha.model_pb2.RenameOrganizationModelResponse,
    ]
    """Rename a model

    Renames a model, accesing it by its resource name, which is defined by the
    parent organization and the ID of the model.
    """
    WatchOrganizationModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.WatchOrganizationModelRequest,
        model.model.v1alpha.model_pb2.WatchOrganizationModelResponse,
    ]
    """Watch the state of a model version

    Returns the state of a model.  The model resource allocation and scaling actions
    take some time, during which a model will be in various state. This endpoint
    allows clients to track the state.
    """
    WatchOrganizationLatestModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.WatchOrganizationLatestModelRequest,
        model.model.v1alpha.model_pb2.WatchOrganizationLatestModelResponse,
    ]
    """Watch the state of the latest model version

    Returns the state of the latest model version.  The model resource allocation and scaling actions
    take some time, during which a model will be in various state. This endpoint
    allows clients to track the state.
    """
    ListOrganizationModelVersions: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.ListOrganizationModelVersionsRequest,
        model.model.v1alpha.model_pb2.ListOrganizationModelVersionsResponse,
    ]
    """List organization model versions

    Returns a paginated list of version of a model namespace that belong to the specified organization.
    Contains model version and digest.
    """
    DeleteOrganizationModelVersion: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.DeleteOrganizationModelVersionRequest,
        model.model.v1alpha.model_pb2.DeleteOrganizationModelVersionResponse,
    ]
    """Delete a model version

    Deletes a model version, accesing it by its resource name, which is defined by the
    parent organization and the ID of the model, and version.
    """
    TriggerOrganizationModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerOrganizationModelRequest,
        model.model.v1alpha.model_pb2.TriggerOrganizationModelResponse,
    ]
    """/////////////////////////////////////////////////////

    Trigger model inference

    Triggers a deployed model to infer the result of a set of task or
    questions.
    """
    TriggerAsyncOrganizationModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerAsyncOrganizationModelRequest,
        model.model.v1alpha.model_pb2.TriggerAsyncOrganizationModelResponse,
    ]
    """Trigger model inference asynchronously

    Triggers a deployed model to infer the result of a set of task or
    questions.
    """
    TriggerOrganizationLatestModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerOrganizationLatestModelRequest,
        model.model.v1alpha.model_pb2.TriggerOrganizationLatestModelResponse,
    ]
    """Trigger model inference

    Triggers the latest deployed model version to infer the result of a set of task or
    questions.
    """
    TriggerAsyncOrganizationLatestModel: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerAsyncOrganizationLatestModelRequest,
        model.model.v1alpha.model_pb2.TriggerAsyncOrganizationLatestModelResponse,
    ]
    """Trigger model inference asynchronously

    Triggers the latest deployed model version to infer the result of a set of task or
    questions.
    """
    TriggerOrganizationModelBinaryFileUpload: grpc.aio.StreamUnaryMultiCallable[
        model.model.v1alpha.model_pb2.TriggerOrganizationModelBinaryFileUploadRequest,
        model.model.v1alpha.model_pb2.TriggerOrganizationModelBinaryFileUploadResponse,
    ]
    """Trigger model inference with a binary input

    Triggers a deployed model to infer the result of a task or question,
    submitted as a binary file.
    """
    GetUserLatestModelOperation: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.GetUserLatestModelOperationRequest,
        model.model.v1alpha.model_pb2.GetUserLatestModelOperationResponse,
    ]
    """Get the details of the latest long-running operation from a user model

    This method allows requesters to request the status and outcome of
    long-running operations in a model, such as trigger.
    """
    GetOrganizationLatestModelOperation: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.GetOrganizationLatestModelOperationRequest,
        model.model.v1alpha.model_pb2.GetOrganizationLatestModelOperationResponse,
    ]
    """Get the details of the latest long-running operation from a organization model

    This method allows requesters to request the status and outcome of
    long-running operations in a model, such as trigger.
    """
    ListModelRuns: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.ListModelRunsRequest,
        model.model.v1alpha.model_pb2.ListModelRunsResponse,
    ]
    """List model runs

    Returns a paginated list of model runs.
    """
    ListModelRunsByRequester: grpc.aio.UnaryUnaryMultiCallable[
        model.model.v1alpha.model_pb2.ListModelRunsByRequesterRequest,
        model.model.v1alpha.model_pb2.ListModelRunsByRequesterResponse,
    ]
    """List Model Runs of a Namespace (user or organization)

    Returns a paginated list of runs for 1 or more models. This is mainly used by dashboard.
    The requester can view all the runs by the requester across different models.
    """

class ModelPublicServiceServicer(metaclass=abc.ABCMeta):
    """Model

    ModelPublicService exposes the public endpoints that allow clients to manage
    models.
    """

    @abc.abstractmethod
    def Liveness(
        self,
        request: model.model.v1alpha.model_pb2.LivenessRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.LivenessResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.LivenessResponse]]:
        """Check if the model server is alive

        See https://github.com/grpc/grpc/blob/master/doc/health-checking.md.
        """
    @abc.abstractmethod
    def Readiness(
        self,
        request: model.model.v1alpha.model_pb2.ReadinessRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.ReadinessResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.ReadinessResponse]]:
        """Check if the model server is ready

        See https://github.com/grpc/grpc/blob/master/doc/health-checking.md
        """
    @abc.abstractmethod
    def ListModelDefinitions(
        self,
        request: model.model.v1alpha.model_definition_pb2.ListModelDefinitionsRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_definition_pb2.ListModelDefinitionsResponse, collections.abc.Awaitable[model.model.v1alpha.model_definition_pb2.ListModelDefinitionsResponse]]:
        """List model definitions

        Returns a paginated list of model definitions.
        """
    @abc.abstractmethod
    def ListAvailableRegions(
        self,
        request: model.model.v1alpha.model_pb2.ListAvailableRegionsRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.ListAvailableRegionsResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.ListAvailableRegionsResponse]]:
        """List available regions

        Returns a paginated list of available regions.
        """
    @abc.abstractmethod
    def GetModelDefinition(
        self,
        request: model.model.v1alpha.model_definition_pb2.GetModelDefinitionRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_definition_pb2.GetModelDefinitionResponse, collections.abc.Awaitable[model.model.v1alpha.model_definition_pb2.GetModelDefinitionResponse]]:
        """Get a model definition

        Returns the details of a model definition.
        """
    @abc.abstractmethod
    def ListModels(
        self,
        request: model.model.v1alpha.model_pb2.ListModelsRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.ListModelsResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.ListModelsResponse]]:
        """List models

        Returns a paginated list of models.
        """
    @abc.abstractmethod
    def LookUpModel(
        self,
        request: model.model.v1alpha.model_pb2.LookUpModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.LookUpModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.LookUpModelResponse]]:
        """Get a model by UID

        Returns the details of a model by a permalink defined by the resource UID.
        """
    @abc.abstractmethod
    def ListNamespaceModels(
        self,
        request: model.model.v1alpha.model_pb2.ListNamespaceModelsRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.ListNamespaceModelsResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.ListNamespaceModelsResponse]]:
        """List namespace models

        Returns a paginated list of models.
        """
    @abc.abstractmethod
    def CreateNamespaceModel(
        self,
        request: model.model.v1alpha.model_pb2.CreateNamespaceModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.CreateNamespaceModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.CreateNamespaceModelResponse]]:
        """Create a new model

        Creates a new model under the parenthood of a namespace. This is an
        asynchronous endpoint, i.e., the server will not wait for the model to be
        created in order to respond. Instead, it will return a response with the
        necessary information to access the result and status of the creation
        operation.
        """
    @abc.abstractmethod
    def GetNamespaceModel(
        self,
        request: model.model.v1alpha.model_pb2.GetNamespaceModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.GetNamespaceModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.GetNamespaceModelResponse]]:
        """Get a model

        Returns the detail of a model, accessing it by the model ID and its parent namespace.
        """
    @abc.abstractmethod
    def UpdateNamespaceModel(
        self,
        request: model.model.v1alpha.model_pb2.UpdateNamespaceModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.UpdateNamespaceModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.UpdateNamespaceModelResponse]]:
        """Update a model

        Updates a model, accessing it by its resource name, which is defined by
        the parent namespace and the ID of the model.

        In REST requests, only the supplied model fields will be taken into
        account when updating the resource.
        """
    @abc.abstractmethod
    def DeleteNamespaceModel(
        self,
        request: model.model.v1alpha.model_pb2.DeleteNamespaceModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.DeleteNamespaceModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.DeleteNamespaceModelResponse]]:
        """Delete a model

        Deletes a model, accesing it by its resource name, which is defined by the
        parent namespace and the ID of the model.
        """
    @abc.abstractmethod
    def RenameNamespaceModel(
        self,
        request: model.model.v1alpha.model_pb2.RenameNamespaceModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.RenameNamespaceModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.RenameNamespaceModelResponse]]:
        """Rename a model

        Renames a model, accesing it by its resource name, which is defined by the
        parent namespace and the ID of the model.
        """
    @abc.abstractmethod
    def WatchNamespaceModel(
        self,
        request: model.model.v1alpha.model_pb2.WatchNamespaceModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.WatchNamespaceModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.WatchNamespaceModelResponse]]:
        """Watch the state of a model version

        Returns the state of a model. The model resource allocation and scaling actions take some
        time, during which a model will be in various state. This endpoint
        allows clients to track the state.
        """
    @abc.abstractmethod
    def WatchNamespaceLatestModel(
        self,
        request: model.model.v1alpha.model_pb2.WatchNamespaceLatestModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.WatchNamespaceLatestModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.WatchNamespaceLatestModelResponse]]:
        """Watch the state of the latest model version

        Returns the state of the latest model version. The model resource allocation and scaling actions
        take some time, during which a model will be in various state. This endpoint
        allows clients to track the state.
        """
    @abc.abstractmethod
    def ListNamespaceModelVersions(
        self,
        request: model.model.v1alpha.model_pb2.ListNamespaceModelVersionsRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.ListNamespaceModelVersionsResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.ListNamespaceModelVersionsResponse]]:
        """List namespace model versions

        Returns a paginated list of version of a model namespace that belong to the specified namespace.
        Contains model version and digest.
        """
    @abc.abstractmethod
    def DeleteNamespaceModelVersion(
        self,
        request: model.model.v1alpha.model_pb2.DeleteNamespaceModelVersionRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.DeleteNamespaceModelVersionResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.DeleteNamespaceModelVersionResponse]]:
        """Delete a model version

        Deletes a model version, accesing it by its resource name, which is defined by the
        parent namespace and the ID of the model, and version.
        """
    @abc.abstractmethod
    def TriggerNamespaceModel(
        self,
        request: model.model.v1alpha.model_pb2.TriggerNamespaceModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.TriggerNamespaceModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.TriggerNamespaceModelResponse]]:
        """Trigger model inference

        Triggers a deployed model to infer the result of a set of task or
        questions.
        """
    @abc.abstractmethod
    def TriggerAsyncNamespaceModel(
        self,
        request: model.model.v1alpha.model_pb2.TriggerAsyncNamespaceModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.TriggerAsyncNamespaceModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.TriggerAsyncNamespaceModelResponse]]:
        """Trigger model inference asynchronously

        Triggers a deployed model to infer the result of a set of task or
        questions.
        """
    @abc.abstractmethod
    def TriggerNamespaceLatestModel(
        self,
        request: model.model.v1alpha.model_pb2.TriggerNamespaceLatestModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.TriggerNamespaceLatestModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.TriggerNamespaceLatestModelResponse]]:
        """Trigger model inference

        Triggers the latest deployed model version to infer the result of a set of task or
        questions.
        """
    @abc.abstractmethod
    def TriggerAsyncNamespaceLatestModel(
        self,
        request: model.model.v1alpha.model_pb2.TriggerAsyncNamespaceLatestModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.TriggerAsyncNamespaceLatestModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.TriggerAsyncNamespaceLatestModelResponse]]:
        """Trigger model inference asynchronously

        Triggers the latest deployed model version to infer the result of a set of task or
        questions.
        """
    @abc.abstractmethod
    def TriggerNamespaceModelBinaryFileUpload(
        self,
        request_iterator: _MaybeAsyncIterator[model.model.v1alpha.model_pb2.TriggerNamespaceModelBinaryFileUploadRequest],
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.TriggerNamespaceModelBinaryFileUploadResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.TriggerNamespaceModelBinaryFileUploadResponse]]:
        """Trigger model inference with a binary input

        Triggers a deployed model to infer the result of a task or question,
        submitted as a binary file.
        """
    @abc.abstractmethod
    def TriggerNamespaceLatestModelBinaryFileUpload(
        self,
        request_iterator: _MaybeAsyncIterator[model.model.v1alpha.model_pb2.TriggerNamespaceLatestModelBinaryFileUploadRequest],
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.TriggerNamespaceLatestModelBinaryFileUploadResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.TriggerNamespaceLatestModelBinaryFileUploadResponse]]:
        """Trigger model inference with a binary input

        Triggers the latest deployed model version to infer the result of a set of task or
        questions, submitted as a binary file.
        """
    @abc.abstractmethod
    def GetNamespaceModelOperation(
        self,
        request: model.model.v1alpha.model_pb2.GetNamespaceModelOperationRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.GetNamespaceModelOperationResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.GetNamespaceModelOperationResponse]]:
        """Get the details of the long-running operation from a namespace model
        with a particular version

        This method allows requesters to request the status and outcome of
        long-running operations in a model, such as trigger.
        """
    @abc.abstractmethod
    def GetNamespaceLatestModelOperation(
        self,
        request: model.model.v1alpha.model_pb2.GetNamespaceLatestModelOperationRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.GetNamespaceLatestModelOperationResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.GetNamespaceLatestModelOperationResponse]]:
        """Get the details of the latest long-running operation from a namespace model

        This method allows requesters to request the status and outcome of
        long-running operations in a model, such as trigger.
        """
    @abc.abstractmethod
    def GetModelOperation(
        self,
        request: model.model.v1alpha.model_pb2.GetModelOperationRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.GetModelOperationResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.GetModelOperationResponse]]:
        """Get the details of a long-running operation

        This method allows requesters to request the status and outcome of
        long-running operations in a model, such as trigger.
        """
    @abc.abstractmethod
    def ListUserModels(
        self,
        request: model.model.v1alpha.model_pb2.ListUserModelsRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.ListUserModelsResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.ListUserModelsResponse]]:
        """The following endpoints are all deprecated

        List user models

        Returns a paginated list of models that belong to the specified user. The
        parent user may be different from the authenticated user, in which case
        the results will contain the models that are visible to the latter.
        """
    @abc.abstractmethod
    def CreateUserModel(
        self,
        request: model.model.v1alpha.model_pb2.CreateUserModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.CreateUserModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.CreateUserModelResponse]]:
        """Create a new model

        Creates a new model under the parenthood of a user. This is an
        asynchronous endpoint, i.e., the server will not wait for the model to be
        created in order to respond. Instead, it will return a response with the
        necessary information to access the result and status of the creation
        operation.
        """
    @abc.abstractmethod
    def GetUserModel(
        self,
        request: model.model.v1alpha.model_pb2.GetUserModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.GetUserModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.GetUserModelResponse]]:
        """Get a model

        Returns the detail of a model, accessing it by the model ID and its parent user.
        """
    @abc.abstractmethod
    def UpdateUserModel(
        self,
        request: model.model.v1alpha.model_pb2.UpdateUserModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.UpdateUserModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.UpdateUserModelResponse]]:
        """Update a model

        Updates a model, accessing it by its resource name, which is defined by
        the parent user and the ID of the model.

        In REST requests, only the supplied model fields will be taken into
        account when updating the resource.
        """
    @abc.abstractmethod
    def DeleteUserModel(
        self,
        request: model.model.v1alpha.model_pb2.DeleteUserModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.DeleteUserModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.DeleteUserModelResponse]]:
        """Delete a model

        Deletes a model, accesing it by its resource name, which is defined by the
        parent user and the ID of the model.
        """
    @abc.abstractmethod
    def RenameUserModel(
        self,
        request: model.model.v1alpha.model_pb2.RenameUserModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.RenameUserModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.RenameUserModelResponse]]:
        """Rename a model

        Renames a model, accesing it by its resource name, which is defined by the
        parent user and the ID of the model.
        """
    @abc.abstractmethod
    def WatchUserModel(
        self,
        request: model.model.v1alpha.model_pb2.WatchUserModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.WatchUserModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.WatchUserModelResponse]]:
        """Watch the state of a model version

        Returns the state of a model. The model resource allocation and scaling actions take some
        time, during which a model will be in various state. This endpoint
        allows clients to track the state.
        """
    @abc.abstractmethod
    def WatchUserLatestModel(
        self,
        request: model.model.v1alpha.model_pb2.WatchUserLatestModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.WatchUserLatestModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.WatchUserLatestModelResponse]]:
        """Watch the state of the latest model version

        Returns the state of the latest model version. The model resource allocation and scaling actions
        take some time, during which a model will be in various state. This endpoint
        allows clients to track the state.
        """
    @abc.abstractmethod
    def ListUserModelVersions(
        self,
        request: model.model.v1alpha.model_pb2.ListUserModelVersionsRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.ListUserModelVersionsResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.ListUserModelVersionsResponse]]:
        """List user model versions

        Returns a paginated list of version of a model namespace that belong to the specified user.
        Contains model version and digest.
        """
    @abc.abstractmethod
    def DeleteUserModelVersion(
        self,
        request: model.model.v1alpha.model_pb2.DeleteUserModelVersionRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.DeleteUserModelVersionResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.DeleteUserModelVersionResponse]]:
        """Delete a model version

        Deletes a model version, accesing it by its resource name, which is defined by the
        parent user and the ID of the model, and version.
        """
    @abc.abstractmethod
    def TriggerUserModel(
        self,
        request: model.model.v1alpha.model_pb2.TriggerUserModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.TriggerUserModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.TriggerUserModelResponse]]:
        """/////////////////////////////////////////////////////

        Trigger model inference

        Triggers a deployed model to infer the result of a set of task or
        questions.
        """
    @abc.abstractmethod
    def TriggerAsyncUserModel(
        self,
        request: model.model.v1alpha.model_pb2.TriggerAsyncUserModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.TriggerAsyncUserModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.TriggerAsyncUserModelResponse]]:
        """Trigger model inference asynchronously

        Triggers a deployed model to infer the result of a set of task or
        questions.
        """
    @abc.abstractmethod
    def TriggerUserLatestModel(
        self,
        request: model.model.v1alpha.model_pb2.TriggerUserLatestModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.TriggerUserLatestModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.TriggerUserLatestModelResponse]]:
        """Trigger model inference

        Triggers the latest deployed model version to infer the result of a set of task or
        questions.
        """
    @abc.abstractmethod
    def TriggerAsyncUserLatestModel(
        self,
        request: model.model.v1alpha.model_pb2.TriggerAsyncUserLatestModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.TriggerAsyncUserLatestModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.TriggerAsyncUserLatestModelResponse]]:
        """Trigger model inference asynchronously

        Triggers the latest deployed model version to infer the result of a set of task or
        questions.
        """
    @abc.abstractmethod
    def TriggerUserModelBinaryFileUpload(
        self,
        request_iterator: _MaybeAsyncIterator[model.model.v1alpha.model_pb2.TriggerUserModelBinaryFileUploadRequest],
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.TriggerUserModelBinaryFileUploadResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.TriggerUserModelBinaryFileUploadResponse]]:
        """Trigger model inference with a binary input

        Triggers a deployed model to infer the result of a task or question,
        submitted as a binary file.
        """
    @abc.abstractmethod
    def ListOrganizationModels(
        self,
        request: model.model.v1alpha.model_pb2.ListOrganizationModelsRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.ListOrganizationModelsResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.ListOrganizationModelsResponse]]:
        """List organization models

        Returns a paginated list of models that belong to the specified organization. The
        parent organization may be different from the authenticated organization, in which case
        the results will contain the models that are visible to the latter.
        """
    @abc.abstractmethod
    def CreateOrganizationModel(
        self,
        request: model.model.v1alpha.model_pb2.CreateOrganizationModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.CreateOrganizationModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.CreateOrganizationModelResponse]]:
        """Create a new model

        Creates a new model under the parenthood of an organization. This is an
        asynchronous endpoint, i.e., the server will not wait for the model to be
        created in order to respond. Instead, it will return a response with the
        necessary information to access the result and status of the creation
        operation.
        """
    @abc.abstractmethod
    def GetOrganizationModel(
        self,
        request: model.model.v1alpha.model_pb2.GetOrganizationModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.GetOrganizationModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.GetOrganizationModelResponse]]:
        """Get a model

        Returns the detail of a model, accessing it by the model ID and its parent organization.
        """
    @abc.abstractmethod
    def UpdateOrganizationModel(
        self,
        request: model.model.v1alpha.model_pb2.UpdateOrganizationModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.UpdateOrganizationModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.UpdateOrganizationModelResponse]]:
        """Update a model

        Updates a model, accessing it by its resource name, which is defined by
        the parent organization and the ID of the model.

        In REST requests, only the supplied model fields will be taken into
        account when updating the resource.
        """
    @abc.abstractmethod
    def DeleteOrganizationModel(
        self,
        request: model.model.v1alpha.model_pb2.DeleteOrganizationModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.DeleteOrganizationModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.DeleteOrganizationModelResponse]]:
        """Delete a model

        Deletes a model, accesing it by its resource name, which is defined by the
        parent organization and the ID of the model.
        """
    @abc.abstractmethod
    def RenameOrganizationModel(
        self,
        request: model.model.v1alpha.model_pb2.RenameOrganizationModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.RenameOrganizationModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.RenameOrganizationModelResponse]]:
        """Rename a model

        Renames a model, accesing it by its resource name, which is defined by the
        parent organization and the ID of the model.
        """
    @abc.abstractmethod
    def WatchOrganizationModel(
        self,
        request: model.model.v1alpha.model_pb2.WatchOrganizationModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.WatchOrganizationModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.WatchOrganizationModelResponse]]:
        """Watch the state of a model version

        Returns the state of a model.  The model resource allocation and scaling actions
        take some time, during which a model will be in various state. This endpoint
        allows clients to track the state.
        """
    @abc.abstractmethod
    def WatchOrganizationLatestModel(
        self,
        request: model.model.v1alpha.model_pb2.WatchOrganizationLatestModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.WatchOrganizationLatestModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.WatchOrganizationLatestModelResponse]]:
        """Watch the state of the latest model version

        Returns the state of the latest model version.  The model resource allocation and scaling actions
        take some time, during which a model will be in various state. This endpoint
        allows clients to track the state.
        """
    @abc.abstractmethod
    def ListOrganizationModelVersions(
        self,
        request: model.model.v1alpha.model_pb2.ListOrganizationModelVersionsRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.ListOrganizationModelVersionsResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.ListOrganizationModelVersionsResponse]]:
        """List organization model versions

        Returns a paginated list of version of a model namespace that belong to the specified organization.
        Contains model version and digest.
        """
    @abc.abstractmethod
    def DeleteOrganizationModelVersion(
        self,
        request: model.model.v1alpha.model_pb2.DeleteOrganizationModelVersionRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.DeleteOrganizationModelVersionResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.DeleteOrganizationModelVersionResponse]]:
        """Delete a model version

        Deletes a model version, accesing it by its resource name, which is defined by the
        parent organization and the ID of the model, and version.
        """
    @abc.abstractmethod
    def TriggerOrganizationModel(
        self,
        request: model.model.v1alpha.model_pb2.TriggerOrganizationModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.TriggerOrganizationModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.TriggerOrganizationModelResponse]]:
        """/////////////////////////////////////////////////////

        Trigger model inference

        Triggers a deployed model to infer the result of a set of task or
        questions.
        """
    @abc.abstractmethod
    def TriggerAsyncOrganizationModel(
        self,
        request: model.model.v1alpha.model_pb2.TriggerAsyncOrganizationModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.TriggerAsyncOrganizationModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.TriggerAsyncOrganizationModelResponse]]:
        """Trigger model inference asynchronously

        Triggers a deployed model to infer the result of a set of task or
        questions.
        """
    @abc.abstractmethod
    def TriggerOrganizationLatestModel(
        self,
        request: model.model.v1alpha.model_pb2.TriggerOrganizationLatestModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.TriggerOrganizationLatestModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.TriggerOrganizationLatestModelResponse]]:
        """Trigger model inference

        Triggers the latest deployed model version to infer the result of a set of task or
        questions.
        """
    @abc.abstractmethod
    def TriggerAsyncOrganizationLatestModel(
        self,
        request: model.model.v1alpha.model_pb2.TriggerAsyncOrganizationLatestModelRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.TriggerAsyncOrganizationLatestModelResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.TriggerAsyncOrganizationLatestModelResponse]]:
        """Trigger model inference asynchronously

        Triggers the latest deployed model version to infer the result of a set of task or
        questions.
        """
    @abc.abstractmethod
    def TriggerOrganizationModelBinaryFileUpload(
        self,
        request_iterator: _MaybeAsyncIterator[model.model.v1alpha.model_pb2.TriggerOrganizationModelBinaryFileUploadRequest],
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.TriggerOrganizationModelBinaryFileUploadResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.TriggerOrganizationModelBinaryFileUploadResponse]]:
        """Trigger model inference with a binary input

        Triggers a deployed model to infer the result of a task or question,
        submitted as a binary file.
        """
    @abc.abstractmethod
    def GetUserLatestModelOperation(
        self,
        request: model.model.v1alpha.model_pb2.GetUserLatestModelOperationRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.GetUserLatestModelOperationResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.GetUserLatestModelOperationResponse]]:
        """Get the details of the latest long-running operation from a user model

        This method allows requesters to request the status and outcome of
        long-running operations in a model, such as trigger.
        """
    @abc.abstractmethod
    def GetOrganizationLatestModelOperation(
        self,
        request: model.model.v1alpha.model_pb2.GetOrganizationLatestModelOperationRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.GetOrganizationLatestModelOperationResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.GetOrganizationLatestModelOperationResponse]]:
        """Get the details of the latest long-running operation from a organization model

        This method allows requesters to request the status and outcome of
        long-running operations in a model, such as trigger.
        """
    @abc.abstractmethod
    def ListModelRuns(
        self,
        request: model.model.v1alpha.model_pb2.ListModelRunsRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.ListModelRunsResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.ListModelRunsResponse]]:
        """List model runs

        Returns a paginated list of model runs.
        """
    @abc.abstractmethod
    def ListModelRunsByRequester(
        self,
        request: model.model.v1alpha.model_pb2.ListModelRunsByRequesterRequest,
        context: _ServicerContext,
    ) -> typing.Union[model.model.v1alpha.model_pb2.ListModelRunsByRequesterResponse, collections.abc.Awaitable[model.model.v1alpha.model_pb2.ListModelRunsByRequesterResponse]]:
        """List Model Runs of a Namespace (user or organization)

        Returns a paginated list of runs for 1 or more models. This is mainly used by dashboard.
        The requester can view all the runs by the requester across different models.
        """

def add_ModelPublicServiceServicer_to_server(servicer: ModelPublicServiceServicer, server: typing.Union[grpc.Server, grpc.aio.Server]) -> None: ...
