import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CosmosdbSqlFunctionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_function.html#body CosmosdbSqlFunction#body}.
     *
     * @stability stable
     */
    readonly body: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_function.html#container_id CosmosdbSqlFunction#container_id}.
     *
     * @stability stable
     */
    readonly containerId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_function.html#name CosmosdbSqlFunction#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_function.html#timeouts CosmosdbSqlFunction#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CosmosdbSqlFunctionTimeouts;
}
/**
 * @stability stable
 */
export interface CosmosdbSqlFunctionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_function.html#create CosmosdbSqlFunction#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_function.html#delete CosmosdbSqlFunction#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_function.html#read CosmosdbSqlFunction#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_function.html#update CosmosdbSqlFunction#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function cosmosdbSqlFunctionTimeoutsToTerraform(struct?: CosmosdbSqlFunctionTimeoutsOutputReference | CosmosdbSqlFunctionTimeouts): any;
/**
 * @stability stable
 */
export declare class CosmosdbSqlFunctionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CosmosdbSqlFunctionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CosmosdbSqlFunctionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_function.html azurerm_cosmosdb_sql_function}.
 *
 * @stability stable
 */
export declare class CosmosdbSqlFunction extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_function.html azurerm_cosmosdb_sql_function} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CosmosdbSqlFunctionConfig);
    private _body?;
    /**
     * @stability stable
     */
    get body(): string;
    /**
     * @stability stable
     */
    set body(value: string);
    /**
     * @stability stable
     */
    get bodyInput(): string | undefined;
    private _containerId?;
    /**
     * @stability stable
     */
    get containerId(): string;
    /**
     * @stability stable
     */
    set containerId(value: string);
    /**
     * @stability stable
     */
    get containerIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): CosmosdbSqlFunctionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CosmosdbSqlFunctionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CosmosdbSqlFunctionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
