import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface HpcCacheConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#cache_size_in_gb HpcCache#cache_size_in_gb}.
     *
     * @stability stable
     */
    readonly cacheSizeInGb: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#location HpcCache#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#mtu HpcCache#mtu}.
     *
     * @stability stable
     */
    readonly mtu?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#name HpcCache#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#ntp_server HpcCache#ntp_server}.
     *
     * @stability stable
     */
    readonly ntpServer?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#resource_group_name HpcCache#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#root_squash_enabled HpcCache#root_squash_enabled}.
     *
     * @stability stable
     */
    readonly rootSquashEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#sku_name HpcCache#sku_name}.
     *
     * @stability stable
     */
    readonly skuName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#subnet_id HpcCache#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#tags HpcCache#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * default_access_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#default_access_policy HpcCache#default_access_policy}
     *
     * @stability stable
     */
    readonly defaultAccessPolicy?: HpcCacheDefaultAccessPolicy;
    /**
     * directory_active_directory block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#directory_active_directory HpcCache#directory_active_directory}
     *
     * @stability stable
     */
    readonly directoryActiveDirectory?: HpcCacheDirectoryActiveDirectory;
    /**
     * directory_flat_file block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#directory_flat_file HpcCache#directory_flat_file}
     *
     * @stability stable
     */
    readonly directoryFlatFile?: HpcCacheDirectoryFlatFile;
    /**
     * directory_ldap block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#directory_ldap HpcCache#directory_ldap}
     *
     * @stability stable
     */
    readonly directoryLdap?: HpcCacheDirectoryLdap;
    /**
     * dns block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#dns HpcCache#dns}
     *
     * @stability stable
     */
    readonly dns?: HpcCacheDns;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#timeouts HpcCache#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: HpcCacheTimeouts;
}
/**
 * @stability stable
 */
export interface HpcCacheDefaultAccessPolicyAccessRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#access HpcCache#access}.
     *
     * @stability stable
     */
    readonly access: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#anonymous_gid HpcCache#anonymous_gid}.
     *
     * @stability stable
     */
    readonly anonymousGid?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#anonymous_uid HpcCache#anonymous_uid}.
     *
     * @stability stable
     */
    readonly anonymousUid?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#filter HpcCache#filter}.
     *
     * @stability stable
     */
    readonly filter?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#root_squash_enabled HpcCache#root_squash_enabled}.
     *
     * @stability stable
     */
    readonly rootSquashEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#scope HpcCache#scope}.
     *
     * @stability stable
     */
    readonly scope: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#submount_access_enabled HpcCache#submount_access_enabled}.
     *
     * @stability stable
     */
    readonly submountAccessEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#suid_enabled HpcCache#suid_enabled}.
     *
     * @stability stable
     */
    readonly suidEnabled?: boolean | cdktf.IResolvable;
}
export declare function hpcCacheDefaultAccessPolicyAccessRuleToTerraform(struct?: HpcCacheDefaultAccessPolicyAccessRule): any;
/**
 * @stability stable
 */
export interface HpcCacheDefaultAccessPolicy {
    /**
     * access_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#access_rule HpcCache#access_rule}
     *
     * @stability stable
     */
    readonly accessRule: HpcCacheDefaultAccessPolicyAccessRule[];
}
export declare function hpcCacheDefaultAccessPolicyToTerraform(struct?: HpcCacheDefaultAccessPolicyOutputReference | HpcCacheDefaultAccessPolicy): any;
/**
 * @stability stable
 */
export declare class HpcCacheDefaultAccessPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HpcCacheDefaultAccessPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HpcCacheDefaultAccessPolicy | undefined);
    private _accessRule?;
    /**
     * @stability stable
     */
    get accessRule(): HpcCacheDefaultAccessPolicyAccessRule[];
    /**
     * @stability stable
     */
    set accessRule(value: HpcCacheDefaultAccessPolicyAccessRule[]);
    /**
     * @stability stable
     */
    get accessRuleInput(): HpcCacheDefaultAccessPolicyAccessRule[] | undefined;
}
/**
 * @stability stable
 */
export interface HpcCacheDirectoryActiveDirectory {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#cache_netbios_name HpcCache#cache_netbios_name}.
     *
     * @stability stable
     */
    readonly cacheNetbiosName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#dns_primary_ip HpcCache#dns_primary_ip}.
     *
     * @stability stable
     */
    readonly dnsPrimaryIp: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#dns_secondary_ip HpcCache#dns_secondary_ip}.
     *
     * @stability stable
     */
    readonly dnsSecondaryIp?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#domain_name HpcCache#domain_name}.
     *
     * @stability stable
     */
    readonly domainName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#domain_netbios_name HpcCache#domain_netbios_name}.
     *
     * @stability stable
     */
    readonly domainNetbiosName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#password HpcCache#password}.
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#username HpcCache#username}.
     *
     * @stability stable
     */
    readonly username: string;
}
export declare function hpcCacheDirectoryActiveDirectoryToTerraform(struct?: HpcCacheDirectoryActiveDirectoryOutputReference | HpcCacheDirectoryActiveDirectory): any;
/**
 * @stability stable
 */
export declare class HpcCacheDirectoryActiveDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HpcCacheDirectoryActiveDirectory | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HpcCacheDirectoryActiveDirectory | undefined);
    private _cacheNetbiosName?;
    /**
     * @stability stable
     */
    get cacheNetbiosName(): string;
    /**
     * @stability stable
     */
    set cacheNetbiosName(value: string);
    /**
     * @stability stable
     */
    get cacheNetbiosNameInput(): string | undefined;
    private _dnsPrimaryIp?;
    /**
     * @stability stable
     */
    get dnsPrimaryIp(): string;
    /**
     * @stability stable
     */
    set dnsPrimaryIp(value: string);
    /**
     * @stability stable
     */
    get dnsPrimaryIpInput(): string | undefined;
    private _dnsSecondaryIp?;
    /**
     * @stability stable
     */
    get dnsSecondaryIp(): string;
    /**
     * @stability stable
     */
    set dnsSecondaryIp(value: string);
    /**
     * @stability stable
     */
    resetDnsSecondaryIp(): void;
    /**
     * @stability stable
     */
    get dnsSecondaryIpInput(): string | undefined;
    private _domainName?;
    /**
     * @stability stable
     */
    get domainName(): string;
    /**
     * @stability stable
     */
    set domainName(value: string);
    /**
     * @stability stable
     */
    get domainNameInput(): string | undefined;
    private _domainNetbiosName?;
    /**
     * @stability stable
     */
    get domainNetbiosName(): string;
    /**
     * @stability stable
     */
    set domainNetbiosName(value: string);
    /**
     * @stability stable
     */
    get domainNetbiosNameInput(): string | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HpcCacheDirectoryFlatFile {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#group_file_uri HpcCache#group_file_uri}.
     *
     * @stability stable
     */
    readonly groupFileUri: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#password_file_uri HpcCache#password_file_uri}.
     *
     * @stability stable
     */
    readonly passwordFileUri: string;
}
export declare function hpcCacheDirectoryFlatFileToTerraform(struct?: HpcCacheDirectoryFlatFileOutputReference | HpcCacheDirectoryFlatFile): any;
/**
 * @stability stable
 */
export declare class HpcCacheDirectoryFlatFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HpcCacheDirectoryFlatFile | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HpcCacheDirectoryFlatFile | undefined);
    private _groupFileUri?;
    /**
     * @stability stable
     */
    get groupFileUri(): string;
    /**
     * @stability stable
     */
    set groupFileUri(value: string);
    /**
     * @stability stable
     */
    get groupFileUriInput(): string | undefined;
    private _passwordFileUri?;
    /**
     * @stability stable
     */
    get passwordFileUri(): string;
    /**
     * @stability stable
     */
    set passwordFileUri(value: string);
    /**
     * @stability stable
     */
    get passwordFileUriInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HpcCacheDirectoryLdapBind {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#dn HpcCache#dn}.
     *
     * @stability stable
     */
    readonly dn: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#password HpcCache#password}.
     *
     * @stability stable
     */
    readonly password: string;
}
export declare function hpcCacheDirectoryLdapBindToTerraform(struct?: HpcCacheDirectoryLdapBindOutputReference | HpcCacheDirectoryLdapBind): any;
/**
 * @stability stable
 */
export declare class HpcCacheDirectoryLdapBindOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HpcCacheDirectoryLdapBind | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HpcCacheDirectoryLdapBind | undefined);
    private _dn?;
    /**
     * @stability stable
     */
    get dn(): string;
    /**
     * @stability stable
     */
    set dn(value: string);
    /**
     * @stability stable
     */
    get dnInput(): string | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HpcCacheDirectoryLdap {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#base_dn HpcCache#base_dn}.
     *
     * @stability stable
     */
    readonly baseDn: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#certificate_validation_uri HpcCache#certificate_validation_uri}.
     *
     * @stability stable
     */
    readonly certificateValidationUri?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#download_certificate_automatically HpcCache#download_certificate_automatically}.
     *
     * @stability stable
     */
    readonly downloadCertificateAutomatically?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#encrypted HpcCache#encrypted}.
     *
     * @stability stable
     */
    readonly encrypted?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#server HpcCache#server}.
     *
     * @stability stable
     */
    readonly server: string;
    /**
     * bind block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#bind HpcCache#bind}
     *
     * @stability stable
     */
    readonly bind?: HpcCacheDirectoryLdapBind;
}
export declare function hpcCacheDirectoryLdapToTerraform(struct?: HpcCacheDirectoryLdapOutputReference | HpcCacheDirectoryLdap): any;
/**
 * @stability stable
 */
export declare class HpcCacheDirectoryLdapOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HpcCacheDirectoryLdap | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HpcCacheDirectoryLdap | undefined);
    private _baseDn?;
    /**
     * @stability stable
     */
    get baseDn(): string;
    /**
     * @stability stable
     */
    set baseDn(value: string);
    /**
     * @stability stable
     */
    get baseDnInput(): string | undefined;
    private _certificateValidationUri?;
    /**
     * @stability stable
     */
    get certificateValidationUri(): string;
    /**
     * @stability stable
     */
    set certificateValidationUri(value: string);
    /**
     * @stability stable
     */
    resetCertificateValidationUri(): void;
    /**
     * @stability stable
     */
    get certificateValidationUriInput(): string | undefined;
    private _downloadCertificateAutomatically?;
    /**
     * @stability stable
     */
    get downloadCertificateAutomatically(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set downloadCertificateAutomatically(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDownloadCertificateAutomatically(): void;
    /**
     * @stability stable
     */
    get downloadCertificateAutomaticallyInput(): boolean | cdktf.IResolvable | undefined;
    private _encrypted?;
    /**
     * @stability stable
     */
    get encrypted(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set encrypted(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEncrypted(): void;
    /**
     * @stability stable
     */
    get encryptedInput(): boolean | cdktf.IResolvable | undefined;
    private _server?;
    /**
     * @stability stable
     */
    get server(): string;
    /**
     * @stability stable
     */
    set server(value: string);
    /**
     * @stability stable
     */
    get serverInput(): string | undefined;
    private _bind;
    /**
     * @stability stable
     */
    get bind(): HpcCacheDirectoryLdapBindOutputReference;
    /**
     * @stability stable
     */
    putBind(value: HpcCacheDirectoryLdapBind): void;
    /**
     * @stability stable
     */
    resetBind(): void;
    /**
     * @stability stable
     */
    get bindInput(): HpcCacheDirectoryLdapBind | undefined;
}
/**
 * @stability stable
 */
export interface HpcCacheDns {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#search_domain HpcCache#search_domain}.
     *
     * @stability stable
     */
    readonly searchDomain?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#servers HpcCache#servers}.
     *
     * @stability stable
     */
    readonly servers: string[];
}
export declare function hpcCacheDnsToTerraform(struct?: HpcCacheDnsOutputReference | HpcCacheDns): any;
/**
 * @stability stable
 */
export declare class HpcCacheDnsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HpcCacheDns | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HpcCacheDns | undefined);
    private _searchDomain?;
    /**
     * @stability stable
     */
    get searchDomain(): string;
    /**
     * @stability stable
     */
    set searchDomain(value: string);
    /**
     * @stability stable
     */
    resetSearchDomain(): void;
    /**
     * @stability stable
     */
    get searchDomainInput(): string | undefined;
    private _servers?;
    /**
     * @stability stable
     */
    get servers(): string[];
    /**
     * @stability stable
     */
    set servers(value: string[]);
    /**
     * @stability stable
     */
    get serversInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface HpcCacheTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#create HpcCache#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#delete HpcCache#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#read HpcCache#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html#update HpcCache#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function hpcCacheTimeoutsToTerraform(struct?: HpcCacheTimeoutsOutputReference | HpcCacheTimeouts): any;
/**
 * @stability stable
 */
export declare class HpcCacheTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HpcCacheTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HpcCacheTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html azurerm_hpc_cache}.
 *
 * @stability stable
 */
export declare class HpcCache extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache.html azurerm_hpc_cache} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: HpcCacheConfig);
    private _cacheSizeInGb?;
    /**
     * @stability stable
     */
    get cacheSizeInGb(): number;
    /**
     * @stability stable
     */
    set cacheSizeInGb(value: number);
    /**
     * @stability stable
     */
    get cacheSizeInGbInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    /**
     * @stability stable
     */
    get mountAddresses(): string[];
    private _mtu?;
    /**
     * @stability stable
     */
    get mtu(): number;
    /**
     * @stability stable
     */
    set mtu(value: number);
    /**
     * @stability stable
     */
    resetMtu(): void;
    /**
     * @stability stable
     */
    get mtuInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _ntpServer?;
    /**
     * @stability stable
     */
    get ntpServer(): string;
    /**
     * @stability stable
     */
    set ntpServer(value: string);
    /**
     * @stability stable
     */
    resetNtpServer(): void;
    /**
     * @stability stable
     */
    get ntpServerInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _rootSquashEnabled?;
    /**
     * @stability stable
     */
    get rootSquashEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set rootSquashEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRootSquashEnabled(): void;
    /**
     * @stability stable
     */
    get rootSquashEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _skuName?;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    set skuName(value: string);
    /**
     * @stability stable
     */
    get skuNameInput(): string | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _defaultAccessPolicy;
    /**
     * @stability stable
     */
    get defaultAccessPolicy(): HpcCacheDefaultAccessPolicyOutputReference;
    /**
     * @stability stable
     */
    putDefaultAccessPolicy(value: HpcCacheDefaultAccessPolicy): void;
    /**
     * @stability stable
     */
    resetDefaultAccessPolicy(): void;
    /**
     * @stability stable
     */
    get defaultAccessPolicyInput(): HpcCacheDefaultAccessPolicy | undefined;
    private _directoryActiveDirectory;
    /**
     * @stability stable
     */
    get directoryActiveDirectory(): HpcCacheDirectoryActiveDirectoryOutputReference;
    /**
     * @stability stable
     */
    putDirectoryActiveDirectory(value: HpcCacheDirectoryActiveDirectory): void;
    /**
     * @stability stable
     */
    resetDirectoryActiveDirectory(): void;
    /**
     * @stability stable
     */
    get directoryActiveDirectoryInput(): HpcCacheDirectoryActiveDirectory | undefined;
    private _directoryFlatFile;
    /**
     * @stability stable
     */
    get directoryFlatFile(): HpcCacheDirectoryFlatFileOutputReference;
    /**
     * @stability stable
     */
    putDirectoryFlatFile(value: HpcCacheDirectoryFlatFile): void;
    /**
     * @stability stable
     */
    resetDirectoryFlatFile(): void;
    /**
     * @stability stable
     */
    get directoryFlatFileInput(): HpcCacheDirectoryFlatFile | undefined;
    private _directoryLdap;
    /**
     * @stability stable
     */
    get directoryLdap(): HpcCacheDirectoryLdapOutputReference;
    /**
     * @stability stable
     */
    putDirectoryLdap(value: HpcCacheDirectoryLdap): void;
    /**
     * @stability stable
     */
    resetDirectoryLdap(): void;
    /**
     * @stability stable
     */
    get directoryLdapInput(): HpcCacheDirectoryLdap | undefined;
    private _dns;
    /**
     * @stability stable
     */
    get dns(): HpcCacheDnsOutputReference;
    /**
     * @stability stable
     */
    putDns(value: HpcCacheDns): void;
    /**
     * @stability stable
     */
    resetDns(): void;
    /**
     * @stability stable
     */
    get dnsInput(): HpcCacheDns | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): HpcCacheTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: HpcCacheTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): HpcCacheTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
