def return_simple(Pt: float, Pt_prev: float) -> float:
    """
    Calculate the simple return of a stock between two periods.
    
    Simple return is calculated as (Pt / Pt_prev) - 1, representing
    how much the stock gained/lost relative to its previous price.
    
    Args:
        Pt: Current price
        Pt_prev: Previous price (must be non-zero)
        
    Returns:
        Simple return as a decimal (e.g., 0.05 for 5% gain)
        
    Raises:
        ValueError: If Pt_prev is zero
        
    Example:
        >>> return_simple(105.0, 100.0)
        0.05
        >>> return_simple(95.0, 100.0) 
        -0.05
    """
    if Pt_prev == 0:
        raise ValueError("Previous price must be nonzero")
    return (Pt / Pt_prev) - 1.0
