import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CosmosdbMongoCollectionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_collection.html#account_name CosmosdbMongoCollection#account_name}.
     *
     * @stability stable
     */
    readonly accountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_collection.html#analytical_storage_ttl CosmosdbMongoCollection#analytical_storage_ttl}.
     *
     * @stability stable
     */
    readonly analyticalStorageTtl?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_collection.html#database_name CosmosdbMongoCollection#database_name}.
     *
     * @stability stable
     */
    readonly databaseName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_collection.html#default_ttl_seconds CosmosdbMongoCollection#default_ttl_seconds}.
     *
     * @stability stable
     */
    readonly defaultTtlSeconds?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_collection.html#name CosmosdbMongoCollection#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_collection.html#resource_group_name CosmosdbMongoCollection#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_collection.html#shard_key CosmosdbMongoCollection#shard_key}.
     *
     * @stability stable
     */
    readonly shardKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_collection.html#throughput CosmosdbMongoCollection#throughput}.
     *
     * @stability stable
     */
    readonly throughput?: number;
    /**
     * autoscale_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_collection.html#autoscale_settings CosmosdbMongoCollection#autoscale_settings}
     *
     * @stability stable
     */
    readonly autoscaleSettings?: CosmosdbMongoCollectionAutoscaleSettings;
    /**
     * index block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_collection.html#index CosmosdbMongoCollection#index}
     *
     * @stability stable
     */
    readonly index?: CosmosdbMongoCollectionIndex[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_collection.html#timeouts CosmosdbMongoCollection#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CosmosdbMongoCollectionTimeouts;
}
/**
 * @stability stable
 */
export declare class CosmosdbMongoCollectionSystemIndexes extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get keys(): string[];
    /**
     * @stability stable
     */
    get unique(): any;
}
/**
 * @stability stable
 */
export interface CosmosdbMongoCollectionAutoscaleSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_collection.html#max_throughput CosmosdbMongoCollection#max_throughput}.
     *
     * @stability stable
     */
    readonly maxThroughput?: number;
}
export declare function cosmosdbMongoCollectionAutoscaleSettingsToTerraform(struct?: CosmosdbMongoCollectionAutoscaleSettingsOutputReference | CosmosdbMongoCollectionAutoscaleSettings): any;
/**
 * @stability stable
 */
export declare class CosmosdbMongoCollectionAutoscaleSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CosmosdbMongoCollectionAutoscaleSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CosmosdbMongoCollectionAutoscaleSettings | undefined);
    private _maxThroughput?;
    /**
     * @stability stable
     */
    get maxThroughput(): number;
    /**
     * @stability stable
     */
    set maxThroughput(value: number);
    /**
     * @stability stable
     */
    resetMaxThroughput(): void;
    /**
     * @stability stable
     */
    get maxThroughputInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface CosmosdbMongoCollectionIndex {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_collection.html#keys CosmosdbMongoCollection#keys}.
     *
     * @stability stable
     */
    readonly keys: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_collection.html#unique CosmosdbMongoCollection#unique}.
     *
     * @stability stable
     */
    readonly unique?: boolean | cdktf.IResolvable;
}
export declare function cosmosdbMongoCollectionIndexToTerraform(struct?: CosmosdbMongoCollectionIndex): any;
/**
 * @stability stable
 */
export interface CosmosdbMongoCollectionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_collection.html#create CosmosdbMongoCollection#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_collection.html#delete CosmosdbMongoCollection#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_collection.html#read CosmosdbMongoCollection#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_collection.html#update CosmosdbMongoCollection#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function cosmosdbMongoCollectionTimeoutsToTerraform(struct?: CosmosdbMongoCollectionTimeoutsOutputReference | CosmosdbMongoCollectionTimeouts): any;
/**
 * @stability stable
 */
export declare class CosmosdbMongoCollectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CosmosdbMongoCollectionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CosmosdbMongoCollectionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_collection.html azurerm_cosmosdb_mongo_collection}.
 *
 * @stability stable
 */
export declare class CosmosdbMongoCollection extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_mongo_collection.html azurerm_cosmosdb_mongo_collection} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CosmosdbMongoCollectionConfig);
    private _accountName?;
    /**
     * @stability stable
     */
    get accountName(): string;
    /**
     * @stability stable
     */
    set accountName(value: string);
    /**
     * @stability stable
     */
    get accountNameInput(): string | undefined;
    private _analyticalStorageTtl?;
    /**
     * @stability stable
     */
    get analyticalStorageTtl(): number;
    /**
     * @stability stable
     */
    set analyticalStorageTtl(value: number);
    /**
     * @stability stable
     */
    resetAnalyticalStorageTtl(): void;
    /**
     * @stability stable
     */
    get analyticalStorageTtlInput(): number | undefined;
    private _databaseName?;
    /**
     * @stability stable
     */
    get databaseName(): string;
    /**
     * @stability stable
     */
    set databaseName(value: string);
    /**
     * @stability stable
     */
    get databaseNameInput(): string | undefined;
    private _defaultTtlSeconds?;
    /**
     * @stability stable
     */
    get defaultTtlSeconds(): number;
    /**
     * @stability stable
     */
    set defaultTtlSeconds(value: number);
    /**
     * @stability stable
     */
    resetDefaultTtlSeconds(): void;
    /**
     * @stability stable
     */
    get defaultTtlSecondsInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _shardKey?;
    /**
     * @stability stable
     */
    get shardKey(): string;
    /**
     * @stability stable
     */
    set shardKey(value: string);
    /**
     * @stability stable
     */
    resetShardKey(): void;
    /**
     * @stability stable
     */
    get shardKeyInput(): string | undefined;
    /**
     * @stability stable
     */
    systemIndexes(index: string): CosmosdbMongoCollectionSystemIndexes;
    private _throughput?;
    /**
     * @stability stable
     */
    get throughput(): number;
    /**
     * @stability stable
     */
    set throughput(value: number);
    /**
     * @stability stable
     */
    resetThroughput(): void;
    /**
     * @stability stable
     */
    get throughputInput(): number | undefined;
    private _autoscaleSettings;
    /**
     * @stability stable
     */
    get autoscaleSettings(): CosmosdbMongoCollectionAutoscaleSettingsOutputReference;
    /**
     * @stability stable
     */
    putAutoscaleSettings(value: CosmosdbMongoCollectionAutoscaleSettings): void;
    /**
     * @stability stable
     */
    resetAutoscaleSettings(): void;
    /**
     * @stability stable
     */
    get autoscaleSettingsInput(): CosmosdbMongoCollectionAutoscaleSettings | undefined;
    private _index?;
    /**
     * @stability stable
     */
    get index(): CosmosdbMongoCollectionIndex[];
    /**
     * @stability stable
     */
    set index(value: CosmosdbMongoCollectionIndex[]);
    /**
     * @stability stable
     */
    resetIndex(): void;
    /**
     * @stability stable
     */
    get indexInput(): CosmosdbMongoCollectionIndex[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): CosmosdbMongoCollectionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CosmosdbMongoCollectionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CosmosdbMongoCollectionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
