"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateFlinkApplicationProps = validateFlinkApplicationProps;
const core = require("aws-cdk-lib/core");
/**
 * Early validation for the props used to create FlinkApplications.
 */
function validateFlinkApplicationProps(props) {
    validateApplicationName(props.applicationName);
    validateParallelism(props.parallelism);
    validateParallelismPerKpu(props.parallelismPerKpu);
    validateVpcProps(props);
}
function validateApplicationName(applicationName) {
    if (applicationName === undefined || core.Token.isUnresolved(applicationName)) {
        return;
    }
    if (applicationName.length === 0) {
        throw new Error('applicationName cannot be empty. It must contain at least 1 character.');
    }
    if (!/^[a-zA-Z0-9_.-]+$/.test(applicationName)) {
        throw new Error(`applicationName may only contain letters, numbers, underscores, hyphens, and periods. Name: ${applicationName}`);
    }
    if (applicationName.length > 128) {
        throw new Error(`applicationName max length is 128. Name: ${applicationName} is ${applicationName.length} characters.`);
    }
}
function validateParallelism(parallelism) {
    if (parallelism === undefined || core.Token.isUnresolved(parallelism)) {
        return;
    }
    if (parallelism < 1) {
        throw new Error('parallelism must be at least 1');
    }
}
function validateParallelismPerKpu(parallelismPerKpu) {
    if (parallelismPerKpu === undefined || core.Token.isUnresolved(parallelismPerKpu)) {
        return;
    }
    if (parallelismPerKpu < 1) {
        throw new Error('parallelismPerKpu must be at least 1');
    }
}
function validateVpcProps({ vpc, securityGroups = [], vpcSubnets }) {
    if (!vpc) {
        if (vpcSubnets) {
            throw new Error('vpc prop required when passing vpcSubnets');
        }
        if (securityGroups.length > 0) {
            throw new Error('vpc prop required when passing securityGroups');
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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