# coding: utf-8

"""
  Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.

  Licensed under the Apache License, Version 2.0 (the "License").
  You may not use this file except in compliance with the License.
  A copy of the License is located at

      http://www.apache.org/licenses/LICENSE-2.0

  or in the "license" file accompanying this file. This file is distributed
  on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
  express or implied. See the License for the specific language governing
  permissions and limitations under the License.
"""


"""
    ProductAdvertisingAPI

    https://webservices.amazon.com/paapi5/documentation/index.html  # noqa: E501
"""


import pprint
import re  # noqa: F401

import six


class OfferAvailability(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'max_order_quantity': 'int',
        'message': 'str',
        'min_order_quantity': 'int',
        'type': 'str'
    }

    attribute_map = {
        'max_order_quantity': 'MaxOrderQuantity',
        'message': 'Message',
        'min_order_quantity': 'MinOrderQuantity',
        'type': 'Type'
    }

    def __init__(self, max_order_quantity=None, message=None, min_order_quantity=None, type=None):  # noqa: E501
        """OfferAvailability - a model defined in Swagger"""  # noqa: E501

        self._max_order_quantity = None
        self._message = None
        self._min_order_quantity = None
        self._type = None
        self.discriminator = None

        if max_order_quantity is not None:
            self.max_order_quantity = max_order_quantity
        if message is not None:
            self.message = message
        if min_order_quantity is not None:
            self.min_order_quantity = min_order_quantity
        if type is not None:
            self.type = type

    @property
    def max_order_quantity(self):
        """Gets the max_order_quantity of this OfferAvailability.  # noqa: E501


        :return: The max_order_quantity of this OfferAvailability.  # noqa: E501
        :rtype: int
        """
        return self._max_order_quantity

    @max_order_quantity.setter
    def max_order_quantity(self, max_order_quantity):
        """Sets the max_order_quantity of this OfferAvailability.


        :param max_order_quantity: The max_order_quantity of this OfferAvailability.  # noqa: E501
        :type: int
        """

        self._max_order_quantity = max_order_quantity

    @property
    def message(self):
        """Gets the message of this OfferAvailability.  # noqa: E501


        :return: The message of this OfferAvailability.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this OfferAvailability.


        :param message: The message of this OfferAvailability.  # noqa: E501
        :type: str
        """

        self._message = message

    @property
    def min_order_quantity(self):
        """Gets the min_order_quantity of this OfferAvailability.  # noqa: E501


        :return: The min_order_quantity of this OfferAvailability.  # noqa: E501
        :rtype: int
        """
        return self._min_order_quantity

    @min_order_quantity.setter
    def min_order_quantity(self, min_order_quantity):
        """Sets the min_order_quantity of this OfferAvailability.


        :param min_order_quantity: The min_order_quantity of this OfferAvailability.  # noqa: E501
        :type: int
        """

        self._min_order_quantity = min_order_quantity

    @property
    def type(self):
        """Gets the type of this OfferAvailability.  # noqa: E501


        :return: The type of this OfferAvailability.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this OfferAvailability.


        :param type: The type of this OfferAvailability.  # noqa: E501
        :type: str
        """

        self._type = type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(OfferAvailability, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OfferAvailability):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
