"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const app = new core_1.App();
const stack = new core_1.Stack(app, 'aws-cdk-s3');
// Test a lifecycle rule with an expiration DATE
new lib_1.Bucket(stack, 'MyBucket', {
    lifecycleRules: [{
            expirationDate: new Date('2019-10-01'),
        }],
    removalPolicy: core_1.RemovalPolicy.DESTROY,
});
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcubGlmZWN5Y2xlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcubGlmZWN5Y2xlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsd0NBQTBEO0FBQzFELGdDQUFnQztBQUVoQyxNQUFNLEdBQUcsR0FBRyxJQUFJLFVBQUcsRUFBRSxDQUFDO0FBRXRCLE1BQU0sS0FBSyxHQUFHLElBQUksWUFBSyxDQUFDLEdBQUcsRUFBRSxZQUFZLENBQUMsQ0FBQztBQUUzQyxnREFBZ0Q7QUFDaEQsSUFBSSxZQUFNLENBQUMsS0FBSyxFQUFFLFVBQVUsRUFBRTtJQUM1QixjQUFjLEVBQUUsQ0FBQztZQUNmLGNBQWMsRUFBRSxJQUFJLElBQUksQ0FBQyxZQUFZLENBQUM7U0FDdkMsQ0FBQztJQUNGLGFBQWEsRUFBRSxvQkFBYSxDQUFDLE9BQU87Q0FDckMsQ0FBQyxDQUFDO0FBRUgsR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQXBwLCBSZW1vdmFsUG9saWN5LCBTdGFjayB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgQnVja2V0IH0gZnJvbSAnLi4vbGliJztcblxuY29uc3QgYXBwID0gbmV3IEFwcCgpO1xuXG5jb25zdCBzdGFjayA9IG5ldyBTdGFjayhhcHAsICdhd3MtY2RrLXMzJyk7XG5cbi8vIFRlc3QgYSBsaWZlY3ljbGUgcnVsZSB3aXRoIGFuIGV4cGlyYXRpb24gREFURVxubmV3IEJ1Y2tldChzdGFjaywgJ015QnVja2V0Jywge1xuICBsaWZlY3ljbGVSdWxlczogW3tcbiAgICBleHBpcmF0aW9uRGF0ZTogbmV3IERhdGUoJzIwMTktMTAtMDEnKSxcbiAgfV0sXG4gIHJlbW92YWxQb2xpY3k6IFJlbW92YWxQb2xpY3kuREVTVFJPWSxcbn0pO1xuXG5hcHAuc3ludGgoKTtcbiJdfQ==