from typing import List, Optional, Dict, Iterable, Any, overload
import io
import collections.abc
from collections.abc import Sequence
from datetime import datetime
from aspose.pyreflection import Type
import aspose.pycore
import aspose.pydrawing
from uuid import UUID
import aspose.cells
import aspose.cells.charts
import aspose.cells.datamodels
import aspose.cells.digitalsignatures
import aspose.cells.drawing
import aspose.cells.drawing.activexcontrols
import aspose.cells.drawing.equations
import aspose.cells.drawing.texts
import aspose.cells.externalconnections
import aspose.cells.json
import aspose.cells.loading
import aspose.cells.lowcode
import aspose.cells.markdown
import aspose.cells.markup
import aspose.cells.metadata
import aspose.cells.metas
import aspose.cells.numbers
import aspose.cells.ods
import aspose.cells.pivot
import aspose.cells.properties
import aspose.cells.querytables
import aspose.cells.rendering
import aspose.cells.rendering.pdfsecurity
import aspose.cells.revisions
import aspose.cells.saving
import aspose.cells.settings
import aspose.cells.slicers
import aspose.cells.slides
import aspose.cells.tables
import aspose.cells.timelines
import aspose.cells.utility
import aspose.cells.vba
import aspose.cells.webextensions

class Axis:
    '''Encapsulates the object that represents an axis of chart.'''
    
    def get_axis_texts(self) -> List[str]:
        '''Gets the labels of the axis after call Chart.Calculate() method.'''
        raise NotImplementedError()
    
    @property
    def area(self) -> aspose.cells.drawing.Area:
        '''Gets the :py:attr:`aspose.cells.charts.Axis.area`.'''
        raise NotImplementedError()
    
    @property
    def is_automatic_min_value(self) -> bool:
        '''Indicates whether the min value is automatically assigned.'''
        raise NotImplementedError()
    
    @is_automatic_min_value.setter
    def is_automatic_min_value(self, value : bool) -> None:
        '''Indicates whether the min value is automatically assigned.'''
        raise NotImplementedError()
    
    @property
    def min_value(self) -> Any:
        '''Represents the minimum value on the value axis.'''
        raise NotImplementedError()
    
    @min_value.setter
    def min_value(self, value : Any) -> None:
        '''Represents the minimum value on the value axis.'''
        raise NotImplementedError()
    
    @property
    def is_automatic_max_value(self) -> bool:
        '''Indicates whether the max value is automatically assigned.'''
        raise NotImplementedError()
    
    @is_automatic_max_value.setter
    def is_automatic_max_value(self, value : bool) -> None:
        '''Indicates whether the max value is automatically assigned.'''
        raise NotImplementedError()
    
    @property
    def max_value(self) -> Any:
        '''Represents the maximum value on the value axis.'''
        raise NotImplementedError()
    
    @max_value.setter
    def max_value(self, value : Any) -> None:
        '''Represents the maximum value on the value axis.'''
        raise NotImplementedError()
    
    @property
    def is_automatic_major_unit(self) -> bool:
        '''Indicates whether the major unit of the axis is automatically assigned.'''
        raise NotImplementedError()
    
    @is_automatic_major_unit.setter
    def is_automatic_major_unit(self, value : bool) -> None:
        '''Indicates whether the major unit of the axis is automatically assigned.'''
        raise NotImplementedError()
    
    @property
    def major_unit(self) -> float:
        '''Represents the major units for the axis.'''
        raise NotImplementedError()
    
    @major_unit.setter
    def major_unit(self, value : float) -> None:
        '''Represents the major units for the axis.'''
        raise NotImplementedError()
    
    @property
    def is_automatic_minor_unit(self) -> bool:
        '''Indicates whether the minor unit of the axis is automatically assigned.'''
        raise NotImplementedError()
    
    @is_automatic_minor_unit.setter
    def is_automatic_minor_unit(self, value : bool) -> None:
        '''Indicates whether the minor unit of the axis is automatically assigned.'''
        raise NotImplementedError()
    
    @property
    def minor_unit(self) -> float:
        '''Represents the minor units for the axis.'''
        raise NotImplementedError()
    
    @minor_unit.setter
    def minor_unit(self, value : float) -> None:
        '''Represents the minor units for the axis.'''
        raise NotImplementedError()
    
    @property
    def axis_line(self) -> aspose.cells.drawing.Line:
        '''Gets the appearance of an Axis.'''
        raise NotImplementedError()
    
    @property
    def major_tick_mark(self) -> aspose.cells.charts.TickMarkType:
        '''Represents the type of major tick mark for the specified axis.'''
        raise NotImplementedError()
    
    @major_tick_mark.setter
    def major_tick_mark(self, value : aspose.cells.charts.TickMarkType) -> None:
        '''Represents the type of major tick mark for the specified axis.'''
        raise NotImplementedError()
    
    @property
    def minor_tick_mark(self) -> aspose.cells.charts.TickMarkType:
        '''Represents the type of minor tick mark for the specified axis.'''
        raise NotImplementedError()
    
    @minor_tick_mark.setter
    def minor_tick_mark(self, value : aspose.cells.charts.TickMarkType) -> None:
        '''Represents the type of minor tick mark for the specified axis.'''
        raise NotImplementedError()
    
    @property
    def tick_label_position(self) -> aspose.cells.charts.TickLabelPositionType:
        '''Represents the position of tick-mark labels on the specified axis.'''
        raise NotImplementedError()
    
    @tick_label_position.setter
    def tick_label_position(self, value : aspose.cells.charts.TickLabelPositionType) -> None:
        '''Represents the position of tick-mark labels on the specified axis.'''
        raise NotImplementedError()
    
    @property
    def cross_at(self) -> float:
        '''Represents the point on the value axis where the category axis crosses it.'''
        raise NotImplementedError()
    
    @cross_at.setter
    def cross_at(self, value : float) -> None:
        '''Represents the point on the value axis where the category axis crosses it.'''
        raise NotImplementedError()
    
    @property
    def cross_type(self) -> aspose.cells.charts.CrossType:
        '''Represents the :py:attr:`aspose.cells.charts.Axis.cross_type` on the specified axis where the other axis crosses.'''
        raise NotImplementedError()
    
    @cross_type.setter
    def cross_type(self, value : aspose.cells.charts.CrossType) -> None:
        '''Represents the :py:attr:`aspose.cells.charts.Axis.cross_type` on the specified axis where the other axis crosses.'''
        raise NotImplementedError()
    
    @property
    def log_base(self) -> float:
        '''Represents the logarithmic base. Default value is 10.Only applies for Excel2007.'''
        raise NotImplementedError()
    
    @log_base.setter
    def log_base(self, value : float) -> None:
        '''Represents the logarithmic base. Default value is 10.Only applies for Excel2007.'''
        raise NotImplementedError()
    
    @property
    def is_logarithmic(self) -> bool:
        '''Represents if the value axis scale type is logarithmic or not.'''
        raise NotImplementedError()
    
    @is_logarithmic.setter
    def is_logarithmic(self, value : bool) -> None:
        '''Represents if the value axis scale type is logarithmic or not.'''
        raise NotImplementedError()
    
    @property
    def is_plot_order_reversed(self) -> bool:
        '''Represents if Microsoft Excel plots data points from last to first.'''
        raise NotImplementedError()
    
    @is_plot_order_reversed.setter
    def is_plot_order_reversed(self, value : bool) -> None:
        '''Represents if Microsoft Excel plots data points from last to first.'''
        raise NotImplementedError()
    
    @property
    def axis_between_categories(self) -> bool:
        '''Represents if the value axis crosses the category axis between categories.'''
        raise NotImplementedError()
    
    @axis_between_categories.setter
    def axis_between_categories(self, value : bool) -> None:
        '''Represents if the value axis crosses the category axis between categories.'''
        raise NotImplementedError()
    
    @property
    def tick_labels(self) -> aspose.cells.charts.TickLabels:
        '''Returns a :py:attr:`aspose.cells.charts.Axis.tick_labels` object that represents the tick-mark labels for the specified axis.'''
        raise NotImplementedError()
    
    @property
    def tick_label_spacing(self) -> int:
        '''Represents the number of categories or series between tick-mark labels. Applies only to category and series axes.'''
        raise NotImplementedError()
    
    @tick_label_spacing.setter
    def tick_label_spacing(self, value : int) -> None:
        '''Represents the number of categories or series between tick-mark labels. Applies only to category and series axes.'''
        raise NotImplementedError()
    
    @property
    def is_auto_tick_label_spacing(self) -> bool:
        '''Indicates whether the spacing of tick label is automatic'''
        raise NotImplementedError()
    
    @is_auto_tick_label_spacing.setter
    def is_auto_tick_label_spacing(self, value : bool) -> None:
        '''Indicates whether the spacing of tick label is automatic'''
        raise NotImplementedError()
    
    @property
    def tick_mark_spacing(self) -> int:
        '''Returns the number of categories or series between tick marks. Applies only to category and series axes.'''
        raise NotImplementedError()
    
    @tick_mark_spacing.setter
    def tick_mark_spacing(self, value : int) -> None:
        '''Returns or sets the number of categories or series between tick marks. Applies only to category and series axes.'''
        raise NotImplementedError()
    
    @property
    def display_unit(self) -> aspose.cells.charts.DisplayUnitType:
        '''Represents the unit label for the specified axis.'''
        raise NotImplementedError()
    
    @display_unit.setter
    def display_unit(self, value : aspose.cells.charts.DisplayUnitType) -> None:
        '''Represents the unit label for the specified axis.'''
        raise NotImplementedError()
    
    @property
    def cust_unit(self) -> int:
        '''Specifies a custom value for the display unit.'''
        raise NotImplementedError()
    
    @cust_unit.setter
    def cust_unit(self, value : int) -> None:
        '''Specifies a custom value for the display unit.'''
        raise NotImplementedError()
    
    @property
    def custom_unit(self) -> int:
        '''Specifies a custom value for the display unit.'''
        raise NotImplementedError()
    
    @custom_unit.setter
    def custom_unit(self, value : int) -> None:
        '''Specifies a custom value for the display unit.'''
        raise NotImplementedError()
    
    @property
    def custom_display_unit(self) -> float:
        '''Specifies a custom value for the display unit.'''
        raise NotImplementedError()
    
    @custom_display_unit.setter
    def custom_display_unit(self, value : float) -> None:
        '''Specifies a custom value for the display unit.'''
        raise NotImplementedError()
    
    @property
    def display_unit_label(self) -> aspose.cells.charts.DisplayUnitLabel:
        '''Represents a unit label on an axis in the specified chart.
        Unit labels are useful for charting large values— for example, in the millions or billions.'''
        raise NotImplementedError()
    
    @property
    def is_display_unit_label_shown(self) -> bool:
        '''Represents if the display unit label is shown on the specified axis.'''
        raise NotImplementedError()
    
    @is_display_unit_label_shown.setter
    def is_display_unit_label_shown(self, value : bool) -> None:
        '''Represents if the display unit label is shown on the specified axis.'''
        raise NotImplementedError()
    
    @property
    def title(self) -> aspose.cells.charts.Title:
        '''Gets the axis\' title.'''
        raise NotImplementedError()
    
    @property
    def category_type(self) -> aspose.cells.charts.CategoryType:
        '''Represents the category axis type.'''
        raise NotImplementedError()
    
    @category_type.setter
    def category_type(self, value : aspose.cells.charts.CategoryType) -> None:
        '''Represents the category axis type.'''
        raise NotImplementedError()
    
    @property
    def base_unit_scale(self) -> aspose.cells.charts.TimeUnit:
        '''Represents the base unit scale for the category axis.'''
        raise NotImplementedError()
    
    @base_unit_scale.setter
    def base_unit_scale(self, value : aspose.cells.charts.TimeUnit) -> None:
        '''Represents the base unit scale for the category axis.'''
        raise NotImplementedError()
    
    @property
    def major_unit_scale(self) -> aspose.cells.charts.TimeUnit:
        '''Represents the major unit scale for the category axis.'''
        raise NotImplementedError()
    
    @major_unit_scale.setter
    def major_unit_scale(self, value : aspose.cells.charts.TimeUnit) -> None:
        '''Represents the major unit scale for the category axis.'''
        raise NotImplementedError()
    
    @property
    def minor_unit_scale(self) -> aspose.cells.charts.TimeUnit:
        '''Represents the major unit scale for the category axis.'''
        raise NotImplementedError()
    
    @minor_unit_scale.setter
    def minor_unit_scale(self, value : aspose.cells.charts.TimeUnit) -> None:
        '''Represents the major unit scale for the category axis.'''
        raise NotImplementedError()
    
    @property
    def is_visible(self) -> bool:
        '''Represents if the axis is visible.'''
        raise NotImplementedError()
    
    @is_visible.setter
    def is_visible(self, value : bool) -> None:
        '''Represents if the axis is visible.'''
        raise NotImplementedError()
    
    @property
    def major_grid_lines(self) -> aspose.cells.drawing.Line:
        '''Represents major gridlines on a chart axis.'''
        raise NotImplementedError()
    
    @property
    def minor_grid_lines(self) -> aspose.cells.drawing.Line:
        '''Represents minor gridlines on a chart axis.'''
        raise NotImplementedError()
    
    @property
    def has_multi_level_labels(self) -> bool:
        '''Indicates whether the labels shall be shown as multi level.'''
        raise NotImplementedError()
    
    @has_multi_level_labels.setter
    def has_multi_level_labels(self, value : bool) -> None:
        '''Indicates whether the labels shall be shown as multi level.'''
        raise NotImplementedError()
    
    @property
    def axis_labels(self) -> List[Any]:
        '''Gets the labels of the axis after call Chart.Calculate() method.'''
        raise NotImplementedError()
    
    @property
    def bins(self) -> aspose.cells.charts.AxisBins:
        '''Represents bins on a chart(Histogram/Pareto) axis'''
        raise NotImplementedError()
    

class AxisBins:
    '''Represents axis bins'''
    
    def reset_overflow(self) -> None:
        '''Reset the overflow'''
        raise NotImplementedError()
    
    def reset_underflow(self) -> None:
        '''Reset the underflow'''
        raise NotImplementedError()
    
    @property
    def is_by_category(self) -> bool:
        '''Indicates whether grouping data by category'''
        raise NotImplementedError()
    
    @is_by_category.setter
    def is_by_category(self, value : bool) -> None:
        '''Indicates whether grouping data by category'''
        raise NotImplementedError()
    
    @property
    def is_automatic(self) -> bool:
        '''Indicates whether the axis bins are automatic.'''
        raise NotImplementedError()
    
    @is_automatic.setter
    def is_automatic(self, value : bool) -> None:
        '''Indicates whether the axis bins are automatic.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> float:
        '''Gets the width of axis bin'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : float) -> None:
        '''Sets the width of axis bin'''
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        '''Gets or set the count of axis bins'''
        raise NotImplementedError()
    
    @count.setter
    def count(self, value : int) -> None:
        '''Set the count of axis bins'''
        raise NotImplementedError()
    
    @property
    def overflow(self) -> float:
        '''Gets or set the overflow of axis bins'''
        raise NotImplementedError()
    
    @overflow.setter
    def overflow(self, value : float) -> None:
        '''Set the overflow of axis bins'''
        raise NotImplementedError()
    
    @property
    def underflow(self) -> float:
        '''Gets or set the underflow of axis bins'''
        raise NotImplementedError()
    
    @underflow.setter
    def underflow(self, value : float) -> None:
        '''Set the underflow of axis bins'''
        raise NotImplementedError()
    

class Chart:
    '''Encapsulates the object that represents a single Excel chart.'''
    
    @overload
    def calculate(self) -> None:
        '''Calculates the custom position of plot area, axes if the position of them are auto assigned.'''
        raise NotImplementedError()
    
    @overload
    def calculate(self, calculate_options : aspose.cells.charts.ChartCalculateOptions) -> None:
        '''Calculates the custom position of plot area, axes if the position of them are auto assigned, with Chart Calculate Options.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, image_file : str) -> None:
        '''Creates the chart image and saves it to a file.
        The extension of the file name determines the format of the image.
        
        :param image_file: The image file name with full path.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, image_file : str, image_type : aspose.cells.drawing.ImageType) -> None:
        '''Creates the chart image and saves it to a file in the specified image type.
        
        :param image_file: The image file name with full path.
        :param image_type: The image type in which to save the image.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, image_file : str, jpeg_quality : int) -> None:
        '''Creates the chart image and saves it to a file in the Jpeg format.
        
        :param image_file: The image file name with full path.
        :param jpeg_quality: Jpeg quality.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, stream : io._IOBase, jpeg_quality : int) -> None:
        '''Creates the chart image and saves it to a stream in the Jpeg format.
        
        :param stream: The output stream.
        :param jpeg_quality: Jpeg quality.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, stream : io._IOBase, image_type : aspose.cells.drawing.ImageType) -> None:
        '''Creates the chart image and saves it to a stream in the specified format.
        
        :param stream: The output stream.
        :param image_type: The image type in which to save the image.'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, image_file : str, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Creates the chart image and saves it to a file.
        The extension of the file name determines the format of the image.
        
        :param image_file: The image file name with full path.
        :param options: Additional image creation options'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, stream : io._IOBase, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Creates the chart image and saves it to a stream in the specified format.
        
        :param stream: The output stream.
        :param options: Additional image creation options'''
        raise NotImplementedError()
    
    @overload
    def to_pdf(self, file_name : str) -> None:
        '''Saves the chart to a pdf file.
        
        :param file_name: the pdf file name with full path'''
        raise NotImplementedError()
    
    @overload
    def to_pdf(self, file_name : str, desired_page_width : float, desired_page_height : float, h_alignment_type : aspose.cells.PageLayoutAlignmentType, v_alignment_type : aspose.cells.PageLayoutAlignmentType) -> None:
        '''Saves the chart to a pdf file.
        
        :param file_name: the pdf file name with full path
        :param desired_page_width: The desired page width in inches.
        :param desired_page_height: The desired page height in inches.
        :param h_alignment_type: The chart horizontal alignment type in the output page.
        :param v_alignment_type: The chart vertical alignment type in the output page.'''
        raise NotImplementedError()
    
    @overload
    def to_pdf(self, stream : io._IOBase) -> None:
        '''Creates the chart pdf and saves it to a stream.
        
        :param stream: The output stream.'''
        raise NotImplementedError()
    
    @overload
    def to_pdf(self, stream : io._IOBase, desired_page_width : float, desired_page_height : float, h_alignment_type : aspose.cells.PageLayoutAlignmentType, v_alignment_type : aspose.cells.PageLayoutAlignmentType) -> None:
        '''Creates the chart pdf and saves it to a stream.
        
        :param stream: The output stream.
        :param desired_page_width: The desired page width in inches.
        :param desired_page_height: The desired page height in inches.
        :param h_alignment_type: The chart horizontal alignment type in the output page.
        :param v_alignment_type: The chart vertical alignment type in the output page.'''
        raise NotImplementedError()
    
    def is_refered_by_chart(self, row_index : int, column_index : int) -> bool:
        '''Returns whether the cell refered by the chart.
        
        :param row_index: The row index
        :param column_index: The column index'''
        raise NotImplementedError()
    
    def is_cell_refered_by_chart(self, sheet_index : int, row_index : int, column_index : int) -> bool:
        '''Returns whether the cell refered by the chart.
        
        :param sheet_index: The sheet Index.-1 means the worksheet which contains current chart.
        :param row_index: The row index
        :param column_index: The column index'''
        raise NotImplementedError()
    
    def is_chart_data_changed(self) -> bool:
        '''Detects if a chart\'s data source has changed.
        
        :returns: Returns true if the chart has changed otherwise returns false'''
        raise NotImplementedError()
    
    def refresh_pivot_data(self) -> None:
        '''Refreshes chart\'s data from pivot table.'''
        raise NotImplementedError()
    
    def change_template(self, data : List[int]) -> None:
        '''Change chart type with preset template.
        
        :param data: The data of chart template file(.crtx).'''
        raise NotImplementedError()
    
    def move(self, upper_left_row : int, upper_left_column : int, lower_right_row : int, lower_right_column : int) -> None:
        '''Moves the chart to a specified location.
        
        :param upper_left_column: Upper left column index.
        :param upper_left_row: Upper left row index.
        :param lower_right_column: Lower right column index
        :param lower_right_row: Lower right row index'''
        raise NotImplementedError()
    
    def get_actual_size(self) -> List[int]:
        '''Gets actual size of chart in unit of pixels.
        
        :returns: Actual size in an array(width and height).
        [0] is width; [1] is height.'''
        raise NotImplementedError()
    
    def has_axis(self, aixs_type : aspose.cells.charts.AxisType, is_primary : bool) -> bool:
        '''Returns which axes exist on the chart.'''
        raise NotImplementedError()
    
    def switch_row_column(self) -> bool:
        '''Switches row/column.
        
        :returns: False means switching row/column fails.'''
        raise NotImplementedError()
    
    def get_chart_data_range(self) -> str:
        '''Gets the data source range of the chart.
        
        :returns: The data source.'''
        raise NotImplementedError()
    
    def set_chart_data_range(self, area : str, is_vertical : bool) -> None:
        '''Specifies data range for a chart.
        
        :param area: Specifies values from which to plot the data series
        :param is_vertical: Specifies whether to plot the series from a range of cell values by row or by column.'''
        raise NotImplementedError()
    
    @property
    def style(self) -> int:
        '''Gets and sets the builtin style.'''
        raise NotImplementedError()
    
    @style.setter
    def style(self, value : int) -> None:
        '''Gets and sets the builtin style.'''
        raise NotImplementedError()
    
    @property
    def chart_object(self) -> aspose.cells.drawing.ChartShape:
        '''Represents the chartShape;'''
        raise NotImplementedError()
    
    @property
    def hide_pivot_field_buttons(self) -> bool:
        '''Indicates whether hide the pivot chart field buttons only when the chart is PivotChart.'''
        raise NotImplementedError()
    
    @hide_pivot_field_buttons.setter
    def hide_pivot_field_buttons(self, value : bool) -> None:
        '''Indicates whether hide the pivot chart field buttons only when the chart is PivotChart.'''
        raise NotImplementedError()
    
    @property
    def pivot_options(self) -> aspose.cells.charts.PivotOptions:
        '''Specifies the pivot controls that appear on the chart'''
        raise NotImplementedError()
    
    @property
    def pivot_source(self) -> str:
        '''The source is the data of the pivotTable.
        If PivotSource is not empty ,the chart is PivotChart.'''
        raise NotImplementedError()
    
    @pivot_source.setter
    def pivot_source(self, value : str) -> None:
        '''The source is the data of the pivotTable.
        If PivotSource is not empty ,the chart is PivotChart.'''
        raise NotImplementedError()
    
    @property
    def plot_by(self) -> aspose.cells.charts.PlotDataByType:
        '''Gets and sets whether plot by row or column.'''
        raise NotImplementedError()
    
    @property
    def plot_empty_cells_type(self) -> aspose.cells.charts.PlotEmptyCellsType:
        '''Gets and sets  how to plot the empty cells.'''
        raise NotImplementedError()
    
    @plot_empty_cells_type.setter
    def plot_empty_cells_type(self, value : aspose.cells.charts.PlotEmptyCellsType) -> None:
        '''Gets and sets  how to plot the empty cells.'''
        raise NotImplementedError()
    
    @property
    def plot_visible_cells(self) -> bool:
        '''Indicates whether only plot visible cells.'''
        raise NotImplementedError()
    
    @plot_visible_cells.setter
    def plot_visible_cells(self, value : bool) -> None:
        '''Indicates whether only plot visible cells.'''
        raise NotImplementedError()
    
    @property
    def plot_visible_cells_only(self) -> bool:
        '''Indicates whether plot visible cells only.'''
        raise NotImplementedError()
    
    @plot_visible_cells_only.setter
    def plot_visible_cells_only(self, value : bool) -> None:
        '''Indicates whether plot visible cells only.'''
        raise NotImplementedError()
    
    @property
    def display_na_as_blank(self) -> bool:
        '''Indicates whether displaying #N/A as blank value.'''
        raise NotImplementedError()
    
    @display_na_as_blank.setter
    def display_na_as_blank(self, value : bool) -> None:
        '''Indicates whether displaying #N/A as blank value.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets and sets the name of the chart.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Gets and sets the name of the chart.'''
        raise NotImplementedError()
    
    @property
    def size_with_window(self) -> bool:
        '''True if Microsoft Excel resizes the chart to match the size of the chart sheet window.'''
        raise NotImplementedError()
    
    @size_with_window.setter
    def size_with_window(self, value : bool) -> None:
        '''True if Microsoft Excel resizes the chart to match the size of the chart sheet window.'''
        raise NotImplementedError()
    
    @property
    def worksheet(self) -> aspose.cells.Worksheet:
        '''Gets the worksheet which contains this chart.'''
        raise NotImplementedError()
    
    @property
    def shapes(self) -> aspose.cells.drawing.ShapeCollection:
        '''Returns all drawing shapes in this chart.'''
        raise NotImplementedError()
    
    @property
    def print_size(self) -> aspose.cells.PrintSizeType:
        '''Gets and sets the printed chart size.'''
        raise NotImplementedError()
    
    @print_size.setter
    def print_size(self, value : aspose.cells.PrintSizeType) -> None:
        '''Gets and sets the printed chart size.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.charts.ChartType:
        '''Gets a chart\'s type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.cells.charts.ChartType) -> None:
        '''Sets a chart\'s type.'''
        raise NotImplementedError()
    
    @property
    def n_series(self) -> aspose.cells.charts.SeriesCollection:
        '''Gets a :py:class:`aspose.cells.charts.SeriesCollection` collection representing the data series in the chart.'''
        raise NotImplementedError()
    
    @property
    def filtered_n_series(self) -> aspose.cells.charts.SeriesCollection:
        '''Gets a :py:class:`aspose.cells.charts.SeriesCollection` collection representing the data series that are filtered in the chart.'''
        raise NotImplementedError()
    
    @property
    def title(self) -> aspose.cells.charts.Title:
        '''Gets the chart\'s title.'''
        raise NotImplementedError()
    
    @property
    def sub_title(self) -> aspose.cells.charts.Title:
        '''Gets the chart\'s sub-title.
        Only for ODS format file.'''
        raise NotImplementedError()
    
    @property
    def plot_area(self) -> aspose.cells.charts.PlotArea:
        '''Gets the chart\'s plot area which includes axis tick labels.'''
        raise NotImplementedError()
    
    @property
    def chart_area(self) -> aspose.cells.charts.ChartArea:
        '''Gets the chart area in the worksheet.'''
        raise NotImplementedError()
    
    @property
    def category_axis(self) -> aspose.cells.charts.Axis:
        '''Gets the chart\'s X axis.'''
        raise NotImplementedError()
    
    @property
    def value_axis(self) -> aspose.cells.charts.Axis:
        '''Gets the chart\'s Y axis.'''
        raise NotImplementedError()
    
    @property
    def second_value_axis(self) -> aspose.cells.charts.Axis:
        '''Gets the chart\'s second Y axis.'''
        raise NotImplementedError()
    
    @property
    def second_category_axis(self) -> aspose.cells.charts.Axis:
        '''Gets the chart\'s second X axis.'''
        raise NotImplementedError()
    
    @property
    def series_axis(self) -> aspose.cells.charts.Axis:
        '''Gets the chart\'s series axis.'''
        raise NotImplementedError()
    
    @property
    def legend(self) -> aspose.cells.charts.Legend:
        '''Gets the chart legend.'''
        raise NotImplementedError()
    
    @property
    def chart_data_table(self) -> aspose.cells.charts.ChartDataTable:
        '''Represents the chart data table.'''
        raise NotImplementedError()
    
    @property
    def show_legend(self) -> bool:
        '''Gets a value indicating whether the chart legend will be displayed. Default is true.'''
        raise NotImplementedError()
    
    @show_legend.setter
    def show_legend(self, value : bool) -> None:
        '''Sets a value indicating whether the chart legend will be displayed. Default is true.'''
        raise NotImplementedError()
    
    @property
    def is_rectangular_cornered(self) -> bool:
        '''Gets a value indicating whether the chart area is rectangular cornered.
        Default is true.'''
        raise NotImplementedError()
    
    @is_rectangular_cornered.setter
    def is_rectangular_cornered(self, value : bool) -> None:
        '''Sets a value indicating whether the chart area is rectangular cornered.
        Default is true.'''
        raise NotImplementedError()
    
    @property
    def show_data_table(self) -> bool:
        '''Gets a value indicating whether the chart displays a data table.'''
        raise NotImplementedError()
    
    @show_data_table.setter
    def show_data_table(self, value : bool) -> None:
        '''Sets a value indicating whether the chart displays a data table.'''
        raise NotImplementedError()
    
    @property
    def first_slice_angle(self) -> int:
        '''Gets the angle of the first pie-chart or doughnut-chart slice, in degrees (clockwise from vertical).
        Applies only to pie, 3-D pie, and doughnut charts, 0 to 360.'''
        raise NotImplementedError()
    
    @first_slice_angle.setter
    def first_slice_angle(self, value : int) -> None:
        '''Sets the angle of the first pie-chart or doughnut-chart slice, in degrees (clockwise from vertical).
        Applies only to pie, 3-D pie, and doughnut charts, 0 to 360.'''
        raise NotImplementedError()
    
    @property
    def gap_width(self) -> int:
        '''Returns the space between bar or column clusters, as a percentage of the bar or column width.
        The value of this property must be between 0 and 500.'''
        raise NotImplementedError()
    
    @gap_width.setter
    def gap_width(self, value : int) -> None:
        '''Returns or sets the space between bar or column clusters, as a percentage of the bar or column width.
        The value of this property must be between 0 and 500.'''
        raise NotImplementedError()
    
    @property
    def gap_depth(self) -> int:
        '''Gets the distance between the data series in a 3-D chart, as a percentage of the marker width.
        The value of this property must be between 0 and 500.'''
        raise NotImplementedError()
    
    @gap_depth.setter
    def gap_depth(self, value : int) -> None:
        '''Sets the distance between the data series in a 3-D chart, as a percentage of the marker width.
        The value of this property must be between 0 and 500.'''
        raise NotImplementedError()
    
    @property
    def floor(self) -> aspose.cells.charts.Floor:
        '''Returns a :py:attr:`aspose.cells.charts.Chart.floor` object that represents the walls of a 3-D chart.'''
        raise NotImplementedError()
    
    @property
    def walls(self) -> aspose.cells.charts.Walls:
        '''Returns a :py:attr:`aspose.cells.charts.Chart.walls` object that represents the walls of a 3-D chart.'''
        raise NotImplementedError()
    
    @property
    def back_wall(self) -> aspose.cells.charts.Walls:
        '''Returns a :py:attr:`aspose.cells.charts.Chart.walls` object that represents the back wall of a 3-D chart.'''
        raise NotImplementedError()
    
    @property
    def side_wall(self) -> aspose.cells.charts.Walls:
        '''Returns a :py:attr:`aspose.cells.charts.Chart.walls` object that represents the side wall of a 3-D chart.'''
        raise NotImplementedError()
    
    @property
    def walls_and_gridlines_2d(self) -> bool:
        '''True if gridlines are drawn two-dimensionally on a 3-D chart.'''
        raise NotImplementedError()
    
    @walls_and_gridlines_2d.setter
    def walls_and_gridlines_2d(self, value : bool) -> None:
        '''True if gridlines are drawn two-dimensionally on a 3-D chart.'''
        raise NotImplementedError()
    
    @property
    def rotation_angle(self) -> int:
        '''Represents the rotation of the 3-D chart view (the rotation of the plot area around the z-axis, in degrees).'''
        raise NotImplementedError()
    
    @rotation_angle.setter
    def rotation_angle(self, value : int) -> None:
        '''Represents the rotation of the 3-D chart view (the rotation of the plot area around the z-axis, in degrees).'''
        raise NotImplementedError()
    
    @property
    def elevation(self) -> int:
        '''Represents the elevation of the 3-D chart view, in degrees.'''
        raise NotImplementedError()
    
    @elevation.setter
    def elevation(self, value : int) -> None:
        '''Represents the elevation of the 3-D chart view, in degrees.'''
        raise NotImplementedError()
    
    @property
    def right_angle_axes(self) -> bool:
        '''True if the chart axes are at right angles. Applies only for 3-D charts(except Column3D and 3-D Pie Charts).'''
        raise NotImplementedError()
    
    @right_angle_axes.setter
    def right_angle_axes(self, value : bool) -> None:
        '''True if the chart axes are at right angles. Applies only for 3-D charts(except Column3D and 3-D Pie Charts).'''
        raise NotImplementedError()
    
    @property
    def auto_scaling(self) -> bool:
        '''True if Microsoft Excel scales a 3-D chart so that it\'s closer in size to the equivalent 2-D chart.
        The RightAngleAxes property must be True.'''
        raise NotImplementedError()
    
    @auto_scaling.setter
    def auto_scaling(self, value : bool) -> None:
        '''True if Microsoft Excel scales a 3-D chart so that it\'s closer in size to the equivalent 2-D chart.
        The RightAngleAxes property must be True.'''
        raise NotImplementedError()
    
    @property
    def height_percent(self) -> int:
        '''Returns the height of a 3-D chart as a percentage of the chart width (between 5 and 500 percent).'''
        raise NotImplementedError()
    
    @height_percent.setter
    def height_percent(self, value : int) -> None:
        '''Returns or sets the height of a 3-D chart as a percentage of the chart width (between 5 and 500 percent).'''
        raise NotImplementedError()
    
    @property
    def perspective(self) -> int:
        '''Returns the perspective for the 3-D chart view. Must be between 0 and 100.
        This property is ignored if the RightAngleAxes property is True.'''
        raise NotImplementedError()
    
    @perspective.setter
    def perspective(self, value : int) -> None:
        '''Returns or sets the perspective for the 3-D chart view. Must be between 0 and 100.
        This property is ignored if the RightAngleAxes property is True.'''
        raise NotImplementedError()
    
    @property
    def is_3d(self) -> bool:
        '''Indicates whether the chart is a 3d chart.'''
        raise NotImplementedError()
    
    @property
    def depth_percent(self) -> int:
        '''Represents the depth of a 3-D chart as a percentage of the chart width (between 20 and 2000 percent).'''
        raise NotImplementedError()
    
    @depth_percent.setter
    def depth_percent(self, value : int) -> None:
        '''Represents the depth of a 3-D chart as a percentage of the chart width (between 20 and 2000 percent).'''
        raise NotImplementedError()
    
    @property
    def actual_chart_size(self) -> aspose.pydrawing.Size:
        '''Gets actual size of chart in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def placement(self) -> aspose.cells.drawing.PlacementType:
        '''Represents the way the chart is attached to the cells below it.'''
        raise NotImplementedError()
    
    @placement.setter
    def placement(self, value : aspose.cells.drawing.PlacementType) -> None:
        '''Represents the way the chart is attached to the cells below it.'''
        raise NotImplementedError()
    
    @property
    def page_setup(self) -> aspose.cells.PageSetup:
        '''Represents the page setup description in this chart.'''
        raise NotImplementedError()
    
    @property
    def line(self) -> aspose.cells.drawing.Line:
        '''Gets the line.'''
        raise NotImplementedError()
    

class ChartArea(ChartFrame):
    '''Encapsulates the object that represents the chart area in the worksheet.'''
    
    def set_position_auto(self) -> None:
        '''Set position of the frame to automatic'''
        raise NotImplementedError()
    
    @property
    def is_inner_mode(self) -> bool:
        '''Indicates whether the size of the plot area size includes the tick marks, and the axis labels.
        False specifies that the size shall determine the size of the plot area, the tick marks, and the axis labels.'''
        raise NotImplementedError()
    
    @is_inner_mode.setter
    def is_inner_mode(self, value : bool) -> None:
        '''Indicates whether the size of the plot area size includes the tick marks, and the axis labels.
        False specifies that the size shall determine the size of the plot area, the tick marks, and the axis labels.'''
        raise NotImplementedError()
    
    @property
    def border(self) -> aspose.cells.drawing.Line:
        '''Gets the :py:class:`aspose.cells.drawing.Line`.'''
        raise NotImplementedError()
    
    @property
    def area(self) -> aspose.cells.drawing.Area:
        '''Gets the :py:attr:`aspose.cells.charts.ChartFrame.area`.'''
        raise NotImplementedError()
    
    @property
    def text_font(self) -> aspose.cells.Font:
        '''Gets a :py:attr:`aspose.cells.charts.ChartFrame.font` object of the specified ChartFrame object.'''
        raise NotImplementedError()
    
    @property
    def text_options(self) -> aspose.cells.drawing.texts.TextOptions:
        '''Gets and sets the options of the text.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Gets a :py:attr:`aspose.cells.charts.ChartArea.font` object of the specified chartarea object.'''
        raise NotImplementedError()
    
    @property
    def auto_scale_font(self) -> bool:
        '''True if the text in the object changes font size when the object size changes. The default value is True.'''
        raise NotImplementedError()
    
    @auto_scale_font.setter
    def auto_scale_font(self, value : bool) -> None:
        '''True if the text in the object changes font size when the object size changes. The default value is True.'''
        raise NotImplementedError()
    
    @property
    def background_mode(self) -> aspose.cells.charts.BackgroundMode:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @background_mode.setter
    def background_mode(self, value : aspose.cells.charts.BackgroundMode) -> None:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @property
    def background(self) -> aspose.cells.charts.BackgroundMode:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @background.setter
    def background(self, value : aspose.cells.charts.BackgroundMode) -> None:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @property
    def is_automatic_size(self) -> bool:
        '''Indicates whether the chart frame is automatic sized.'''
        raise NotImplementedError()
    
    @is_automatic_size.setter
    def is_automatic_size(self, value : bool) -> None:
        '''Indicates whether the chart frame is automatic sized.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets or gets the horizontal offset from its upper left corner column, in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Gets or gets the horizontal offset from its upper left corner column, in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets or gets the vertical offset from its upper left corner row, in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Gets or gets the vertical offset from its upper left corner row, in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Gets the vertical offset from its lower right corner row, in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Sets the vertical offset from its lower right corner row, in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Gets the horizontal offset from its lower right corner column, in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Sets the horizontal offset from its lower right corner column, in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def shadow(self) -> bool:
        '''True if the frame has a shadow.'''
        raise NotImplementedError()
    
    @shadow.setter
    def shadow(self, value : bool) -> None:
        '''True if the frame has a shadow.'''
        raise NotImplementedError()
    
    @property
    def shape_properties(self) -> aspose.cells.drawing.ShapePropertyCollection:
        '''Gets the :py:attr:`aspose.cells.charts.ChartFrame.shape_properties` object.'''
        raise NotImplementedError()
    
    @property
    def is_default_pos_be_set(self) -> bool:
        '''Indicates whether default position(DefaultX, DefaultY, DefaultWidth and DefaultHeight) are set.'''
        raise NotImplementedError()
    
    @property
    def default_x(self) -> int:
        '''Represents x of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_y(self) -> int:
        '''Represents y of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_width(self) -> int:
        '''Represents width of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_height(self) -> int:
        '''Represents height of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_x_ratio_to_chart(self) -> float:
        '''Represents x of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_y_ratio_to_chart(self) -> float:
        '''Represents y of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_width_ratio_to_chart(self) -> float:
        '''Represents width of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_height_ratio_to_chart(self) -> float:
        '''Represents height of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def x_ratio_to_chart(self) -> float:
        '''Gets or gets the horizontal offset from its upper left corner column, in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @x_ratio_to_chart.setter
    def x_ratio_to_chart(self, value : float) -> None:
        '''Gets or gets the horizontal offset from its upper left corner column, in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def y_ratio_to_chart(self) -> float:
        '''Gets or gets the vertical offset from its upper left corner row, in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @y_ratio_to_chart.setter
    def y_ratio_to_chart(self, value : float) -> None:
        '''Gets or gets the vertical offset from its upper left corner row, in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def width_ratio_to_chart(self) -> float:
        '''Gets the horizontal offset from its lower right corner column, in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @width_ratio_to_chart.setter
    def width_ratio_to_chart(self, value : float) -> None:
        '''Sets the horizontal offset from its lower right corner column, in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def height_ratio_to_chart(self) -> float:
        '''Gets the vertical offset from its lower right corner row, in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @height_ratio_to_chart.setter
    def height_ratio_to_chart(self, value : float) -> None:
        '''Sets the vertical offset from its lower right corner row, in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def x_pixel(self) -> int:
        '''Gets the x coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @x_pixel.setter
    def x_pixel(self, value : int) -> None:
        '''Sets the x coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @property
    def y_pixel(self) -> int:
        '''Gets the y coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @y_pixel.setter
    def y_pixel(self, value : int) -> None:
        '''Sets the y coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @property
    def width_pixel(self) -> int:
        '''Gets the width of frame in units of Pixel.'''
        raise NotImplementedError()
    
    @width_pixel.setter
    def width_pixel(self, value : int) -> None:
        '''Sets the width of frame in units of Pixel.'''
        raise NotImplementedError()
    
    @property
    def height_pixel(self) -> int:
        '''Gets the height of frame in units of Pixel.'''
        raise NotImplementedError()
    
    @height_pixel.setter
    def height_pixel(self, value : int) -> None:
        '''Sets the height of frame in units of Pixel.'''
        raise NotImplementedError()
    

class ChartCalculateOptions:
    '''Represents the options for calculating chart.'''
    
    def __init__(self) -> None:
        '''Creates the options for calculating chart.'''
        raise NotImplementedError()
    
    @property
    def update_all_points(self) -> bool:
        '''Whether update all data points when performing the chart calculation. Default: False.
        When you want to get the value for each data point in the chart specifically, set it to true.
        If this parameter is set to True, the new data points may be generated when chart is calculated. This could make the Excel file larger.'''
        raise NotImplementedError()
    
    @update_all_points.setter
    def update_all_points(self, value : bool) -> None:
        '''Whether update all data points when performing the chart calculation. Default: False.
        When you want to get the value for each data point in the chart specifically, set it to true.
        If this parameter is set to True, the new data points may be generated when chart is calculated. This could make the Excel file larger.'''
        raise NotImplementedError()
    

class ChartCollection:
    '''Encapsulates a collection of :py:class:`aspose.cells.charts.Chart` objects.'''
    
    @overload
    def add(self, type : aspose.cells.charts.ChartType, upper_left_row : int, upper_left_column : int, lower_right_row : int, lower_right_column : int) -> int:
        '''Adds a chart to the collection.
        
        :param type: Chart type
        :param upper_left_row: Upper left row index.
        :param upper_left_column: Upper left column index.
        :param lower_right_row: Lower right row index
        :param lower_right_column: Lower right column index
        :returns: :py:class:`aspose.cells.charts.Chart` object index.'''
        raise NotImplementedError()
    
    @overload
    def add(self, type : aspose.cells.charts.ChartType, data_range : str, top_row : int, left_column : int, right_row : int, bottom_column : int) -> int:
        '''Adds a chart to the collection.
        
        :param type: Chart type
        :param data_range: Specifies the data range of the chart
        :param top_row: Upper left row index.
        :param left_column: Upper left column index.
        :param right_row: Lower right row index
        :param bottom_column: Lower right column index
        :returns: :py:class:`aspose.cells.charts.Chart` object index.'''
        raise NotImplementedError()
    
    @overload
    def add(self, data : List[int], data_range : str, is_vertical : bool, top_row : int, left_column : int, right_row : int, bottom_column : int) -> int:
        '''Adds a chart with preset template.
        
        :param data: The data of chart template file(.crtx).
        :param data_range: Specifies the data range of the chart
        :param is_vertical: Specifies whether to plot the series from a range of cell values by row or by column.
        :param top_row: Upper left row index.
        :param left_column: Upper left column index.
        :param right_row: Lower right row index
        :param bottom_column: Lower right column index
        :returns: :py:class:`aspose.cells.charts.Chart` object index.'''
        raise NotImplementedError()
    
    @overload
    def add(self, type : aspose.cells.charts.ChartType, data_range : str, is_vertical : bool, top_row : int, left_column : int, right_row : int, bottom_column : int) -> int:
        '''Adds a chart to the collection.
        
        :param type: Chart type
        :param data_range: Specifies the data range of the chart
        :param is_vertical: Specifies whether to plot the series from a range of cell values by row or by column.
        :param top_row: Upper left row index.
        :param left_column: Upper left column index.
        :param right_row: Lower right row index
        :param bottom_column: Lower right column index
        :returns: :py:class:`aspose.cells.charts.Chart` object index.'''
        raise NotImplementedError()
    
    @overload
    def get(self, index : int) -> aspose.cells.charts.Chart:
        '''Add API for Python Via .Net.since this[int index] is unsupported
        
        :param index: The zero based index of the element.'''
        raise NotImplementedError()
    
    @overload
    def get(self, name : str) -> aspose.cells.charts.Chart:
        '''Add API for Python Via .Net.since this[string Chart] is unsupported
        
        :param name: Chart name'''
        raise NotImplementedError()
    
    @overload
    def copy_to(self, array : List[aspose.cells.charts.Chart]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.charts.Chart], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.charts.Chart, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.charts.Chart, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.charts.Chart) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.charts.Chart, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.charts.Chart, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def add_floating_chart(self, type : aspose.cells.charts.ChartType, left : int, top : int, width : int, height : int) -> int:
        '''Adds a chart to the collection.
        
        :param type: Chart type
        :param left: The x offset to corner
        :param top: The y offset to corner
        :param width: The chart width
        :param height: The chart height
        :returns: :py:class:`aspose.cells.charts.Chart` object index.'''
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.charts.Chart) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class ChartDataTable:
    '''Represents a chart data table.'''
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Gets a :py:attr:`aspose.cells.charts.ChartDataTable.font` object which represents the font setting of the specified chart data table.'''
        raise NotImplementedError()
    
    @property
    def auto_scale_font(self) -> bool:
        '''True if the text in the object changes font size when the object size changes.
        The default value is True.'''
        raise NotImplementedError()
    
    @auto_scale_font.setter
    def auto_scale_font(self, value : bool) -> None:
        '''True if the text in the object changes font size when the object size changes.
        The default value is True.'''
        raise NotImplementedError()
    
    @property
    def background_mode(self) -> aspose.cells.charts.BackgroundMode:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @background_mode.setter
    def background_mode(self, value : aspose.cells.charts.BackgroundMode) -> None:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @property
    def has_border_horizontal(self) -> bool:
        '''True if the chart data table has horizontal cell borders'''
        raise NotImplementedError()
    
    @has_border_horizontal.setter
    def has_border_horizontal(self, value : bool) -> None:
        '''True if the chart data table has horizontal cell borders'''
        raise NotImplementedError()
    
    @property
    def has_horizontal_border(self) -> bool:
        '''True if the chart data table has horizontal cell borders'''
        raise NotImplementedError()
    
    @has_horizontal_border.setter
    def has_horizontal_border(self, value : bool) -> None:
        '''True if the chart data table has horizontal cell borders'''
        raise NotImplementedError()
    
    @property
    def has_border_vertical(self) -> bool:
        '''True if the chart data table has vertical cell borders'''
        raise NotImplementedError()
    
    @has_border_vertical.setter
    def has_border_vertical(self, value : bool) -> None:
        '''True if the chart data table has vertical cell borders'''
        raise NotImplementedError()
    
    @property
    def has_vertical_border(self) -> bool:
        '''True if the chart data table has vertical cell borders'''
        raise NotImplementedError()
    
    @has_vertical_border.setter
    def has_vertical_border(self, value : bool) -> None:
        '''True if the chart data table has vertical cell borders'''
        raise NotImplementedError()
    
    @property
    def has_border_outline(self) -> bool:
        '''True if the chart data table has outline borders'''
        raise NotImplementedError()
    
    @has_border_outline.setter
    def has_border_outline(self, value : bool) -> None:
        '''True if the chart data table has outline borders'''
        raise NotImplementedError()
    
    @property
    def has_outline_border(self) -> bool:
        '''True if the chart data table has outline borders'''
        raise NotImplementedError()
    
    @has_outline_border.setter
    def has_outline_border(self, value : bool) -> None:
        '''True if the chart data table has outline borders'''
        raise NotImplementedError()
    
    @property
    def show_legend_key(self) -> bool:
        '''True if the data label legend key is visible.'''
        raise NotImplementedError()
    
    @show_legend_key.setter
    def show_legend_key(self, value : bool) -> None:
        '''True if the data label legend key is visible.'''
        raise NotImplementedError()
    
    @property
    def border(self) -> aspose.cells.drawing.Line:
        '''Returns a Border object that represents the border of the object'''
        raise NotImplementedError()
    

class ChartFrame:
    '''Encapsulates the object that represents the frame object in a chart.'''
    
    def set_position_auto(self) -> None:
        '''Set position of the frame to automatic'''
        raise NotImplementedError()
    
    @property
    def is_inner_mode(self) -> bool:
        '''Indicates whether the size of the plot area size includes the tick marks, and the axis labels.
        False specifies that the size shall determine the size of the plot area, the tick marks, and the axis labels.'''
        raise NotImplementedError()
    
    @is_inner_mode.setter
    def is_inner_mode(self, value : bool) -> None:
        '''Indicates whether the size of the plot area size includes the tick marks, and the axis labels.
        False specifies that the size shall determine the size of the plot area, the tick marks, and the axis labels.'''
        raise NotImplementedError()
    
    @property
    def border(self) -> aspose.cells.drawing.Line:
        '''Gets the :py:class:`aspose.cells.drawing.Line`.'''
        raise NotImplementedError()
    
    @property
    def area(self) -> aspose.cells.drawing.Area:
        '''Gets the :py:attr:`aspose.cells.charts.ChartFrame.area`.'''
        raise NotImplementedError()
    
    @property
    def text_font(self) -> aspose.cells.Font:
        '''Gets a :py:attr:`aspose.cells.charts.ChartFrame.font` object of the specified ChartFrame object.'''
        raise NotImplementedError()
    
    @property
    def text_options(self) -> aspose.cells.drawing.texts.TextOptions:
        '''Gets and sets the options of the text.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Gets a :py:attr:`aspose.cells.charts.ChartFrame.font` object of the specified ChartFrame object.'''
        raise NotImplementedError()
    
    @property
    def auto_scale_font(self) -> bool:
        '''True if the text in the object changes font size when the object size changes. The default value is True.'''
        raise NotImplementedError()
    
    @auto_scale_font.setter
    def auto_scale_font(self, value : bool) -> None:
        '''True if the text in the object changes font size when the object size changes. The default value is True.'''
        raise NotImplementedError()
    
    @property
    def background_mode(self) -> aspose.cells.charts.BackgroundMode:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @background_mode.setter
    def background_mode(self, value : aspose.cells.charts.BackgroundMode) -> None:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @property
    def background(self) -> aspose.cells.charts.BackgroundMode:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @background.setter
    def background(self, value : aspose.cells.charts.BackgroundMode) -> None:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @property
    def is_automatic_size(self) -> bool:
        '''Indicates whether the chart frame is automatic sized.'''
        raise NotImplementedError()
    
    @is_automatic_size.setter
    def is_automatic_size(self, value : bool) -> None:
        '''Indicates whether the chart frame is automatic sized.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets the x coordinate of the upper left corner in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Sets the x coordinate of the upper left corner in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets the y coordinate of the upper left corner in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Sets the y coordinate of the upper left corner in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Gets the height of frame in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Sets the height of frame in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Gets the width of frame in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Sets the width of frame in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def shadow(self) -> bool:
        '''True if the frame has a shadow.'''
        raise NotImplementedError()
    
    @shadow.setter
    def shadow(self, value : bool) -> None:
        '''True if the frame has a shadow.'''
        raise NotImplementedError()
    
    @property
    def shape_properties(self) -> aspose.cells.drawing.ShapePropertyCollection:
        '''Gets the :py:attr:`aspose.cells.charts.ChartFrame.shape_properties` object.'''
        raise NotImplementedError()
    
    @property
    def is_default_pos_be_set(self) -> bool:
        '''Indicates whether default position(DefaultX, DefaultY, DefaultWidth and DefaultHeight) are set.'''
        raise NotImplementedError()
    
    @property
    def default_x(self) -> int:
        '''Represents x of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_y(self) -> int:
        '''Represents y of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_width(self) -> int:
        '''Represents width of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_height(self) -> int:
        '''Represents height of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_x_ratio_to_chart(self) -> float:
        '''Represents x of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_y_ratio_to_chart(self) -> float:
        '''Represents y of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_width_ratio_to_chart(self) -> float:
        '''Represents width of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_height_ratio_to_chart(self) -> float:
        '''Represents height of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def x_ratio_to_chart(self) -> float:
        '''Gets the x coordinate of the upper left corner in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @x_ratio_to_chart.setter
    def x_ratio_to_chart(self, value : float) -> None:
        '''Sets the x coordinate of the upper left corner in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def y_ratio_to_chart(self) -> float:
        '''Gets the y coordinate of the upper left corner in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @y_ratio_to_chart.setter
    def y_ratio_to_chart(self, value : float) -> None:
        '''Sets the y coordinate of the upper left corner in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def width_ratio_to_chart(self) -> float:
        '''Gets the width of frame in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @width_ratio_to_chart.setter
    def width_ratio_to_chart(self, value : float) -> None:
        '''Sets the width of frame in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def height_ratio_to_chart(self) -> float:
        '''Gets the height of frame in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @height_ratio_to_chart.setter
    def height_ratio_to_chart(self, value : float) -> None:
        '''Sets the height of frame in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def x_pixel(self) -> int:
        '''Gets the x coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @x_pixel.setter
    def x_pixel(self, value : int) -> None:
        '''Sets the x coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @property
    def y_pixel(self) -> int:
        '''Gets the y coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @y_pixel.setter
    def y_pixel(self, value : int) -> None:
        '''Sets the y coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @property
    def width_pixel(self) -> int:
        '''Gets the width of frame in units of Pixel.'''
        raise NotImplementedError()
    
    @width_pixel.setter
    def width_pixel(self, value : int) -> None:
        '''Sets the width of frame in units of Pixel.'''
        raise NotImplementedError()
    
    @property
    def height_pixel(self) -> int:
        '''Gets the height of frame in units of Pixel.'''
        raise NotImplementedError()
    
    @height_pixel.setter
    def height_pixel(self, value : int) -> None:
        '''Sets the height of frame in units of Pixel.'''
        raise NotImplementedError()
    

class ChartGlobalizationSettings:
    '''Represents the globalization settings for chart.'''
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    def get_series_name(self) -> str:
        '''Gets the name of Series in the Chart.'''
        raise NotImplementedError()
    
    def get_chart_title_name(self) -> str:
        '''Gets the name of Chart Title.'''
        raise NotImplementedError()
    
    def get_legend_increase_name(self) -> str:
        '''Gets the name of increase for Legend.'''
        raise NotImplementedError()
    
    def get_legend_decrease_name(self) -> str:
        '''Gets the name of Decrease for Legend.'''
        raise NotImplementedError()
    
    def get_legend_total_name(self) -> str:
        '''Gets the name of Total for Legend.'''
        raise NotImplementedError()
    
    def get_axis_title_name(self) -> str:
        '''Gets the name of Title for Axis.'''
        raise NotImplementedError()
    
    def get_other_name(self) -> str:
        '''Gets the name of "Other" labels for Chart.'''
        raise NotImplementedError()
    
    def get_axis_unit_name(self, type : aspose.cells.charts.DisplayUnitType) -> str:
        '''Gets the Name of Axis Unit.'''
        raise NotImplementedError()
    

class ChartPoint:
    '''Represents a single point in a series in a chart.'''
    
    def get_top_point_count(self) -> int:
        '''Gets the number of top points after calls Chart.Calculate() method.'''
        raise NotImplementedError()
    
    def get_top_point_x_px(self, index : int) -> float:
        '''Gets x-coordinate of the top point of shape after calls Chart.Calculate() method.
        Applies 3D charts: Column3D, Bar3D, Cone, Cylinder, Pyramid and Area3D'''
        raise NotImplementedError()
    
    def get_top_point_y_px(self, index : int) -> float:
        '''Gets y-coordinate of the top point of shape after calls Chart.Calculate() method.
        Applies 3D charts: Column3D, Bar3D, Cone, Cylinder, Pyramid and Area3D'''
        raise NotImplementedError()
    
    def get_bottom_point_count(self) -> int:
        '''Gets the number of bottom points  after calls Chart.Calculate() method.'''
        raise NotImplementedError()
    
    def get_bottom_point_x_px(self, index : int) -> float:
        '''Gets x-coordinate of the bottom point of shape after calls Chart.Calculate() method.
        Applies 3D charts: Column3D, Bar3D, Cone, Cylinder, Pyramid'''
        raise NotImplementedError()
    
    def get_bottom_point_y_px(self, index : int) -> float:
        '''Gets y-coordinate of the bottom point of shape  after calls Chart.Calculate() method.
        Applies 3D charts: Column3D, Bar3D, Cone, Cylinder, Pyramid'''
        raise NotImplementedError()
    
    def get_on_category_axis_point_count(self) -> int:
        '''Gets the number of the points on category axis after calls Chart.Calculate() method. Only applies to area chart.'''
        raise NotImplementedError()
    
    def get_on_category_axis_point_x_px(self, index : int) -> float:
        '''Gets x-coordinate of the point on category axis after calls Chart.Calculate() method. Only applies to Area chart.'''
        raise NotImplementedError()
    
    def get_on_category_axis_point_y_px(self, index : int) -> float:
        '''Gets y-coordinate of the point on category axis after calls Chart.Calculate() method. Only applies to Area chart.'''
        raise NotImplementedError()
    
    @property
    def explosion(self) -> int:
        '''The distance of an open pie slice from the center of the pie chart is expressed as a percentage of the pie diameter.'''
        raise NotImplementedError()
    
    @explosion.setter
    def explosion(self, value : int) -> None:
        '''The distance of an open pie slice from the center of the pie chart is expressed as a percentage of the pie diameter.'''
        raise NotImplementedError()
    
    @property
    def shadow(self) -> bool:
        '''True if the chartpoint has a shadow.'''
        raise NotImplementedError()
    
    @shadow.setter
    def shadow(self, value : bool) -> None:
        '''True if the chartpoint has a shadow.'''
        raise NotImplementedError()
    
    @property
    def border(self) -> aspose.cells.drawing.Line:
        '''Gets the :py:class:`aspose.cells.drawing.Line`.'''
        raise NotImplementedError()
    
    @property
    def area(self) -> aspose.cells.drawing.Area:
        '''Gets the :py:attr:`aspose.cells.charts.ChartPoint.area`.'''
        raise NotImplementedError()
    
    @property
    def marker(self) -> aspose.cells.charts.Marker:
        '''Gets the :py:attr:`aspose.cells.charts.ChartPoint.marker`.'''
        raise NotImplementedError()
    
    @property
    def data_labels(self) -> aspose.cells.charts.DataLabels:
        '''Returns a :py:attr:`aspose.cells.charts.ChartPoint.data_labels` object that represents the data label associated with this chart point.'''
        raise NotImplementedError()
    
    @property
    def y_value(self) -> Any:
        '''Gets the Y value of the chart point.'''
        raise NotImplementedError()
    
    @y_value.setter
    def y_value(self, value : Any) -> None:
        '''Sets the Y value of the chart point.'''
        raise NotImplementedError()
    
    @property
    def y_value_type(self) -> aspose.cells.CellValueType:
        '''Gets Y value type of the chart point.'''
        raise NotImplementedError()
    
    @property
    def x_value(self) -> Any:
        '''Gets the X value of the chart point.'''
        raise NotImplementedError()
    
    @x_value.setter
    def x_value(self, value : Any) -> None:
        '''Sets the X value of the chart point.'''
        raise NotImplementedError()
    
    @property
    def x_value_type(self) -> aspose.cells.CellValueType:
        '''Gets X value type of the chart point.'''
        raise NotImplementedError()
    
    @property
    def shape_properties(self) -> aspose.cells.drawing.ShapePropertyCollection:
        '''Gets the :py:class:`aspose.cells.drawing.ShapePropertyCollection` object that holds the visual shape properties of the ChartPoint.'''
        raise NotImplementedError()
    
    @property
    def is_in_secondary_plot(self) -> bool:
        '''Gets a value indicates whether this data points is in the second pie or bar
        on a pie of pie or bar of pie chart'''
        raise NotImplementedError()
    
    @is_in_secondary_plot.setter
    def is_in_secondary_plot(self, value : bool) -> None:
        '''Sets a value indicates whether this data points is in the second pie or bar
        on a pie of pie or bar of pie chart'''
        raise NotImplementedError()
    
    @property
    def shape_x(self) -> int:
        '''Gets the x coordinate of the upper left corner in units of 1/4000 of chart\'s width after calls Chart.Calculate() method.'''
        raise NotImplementedError()
    
    @property
    def shape_y(self) -> int:
        '''Gets the y coordinate of the upper left corner in units of 1/4000 of chart\'s height after calls Chart.Calculate() method.'''
        raise NotImplementedError()
    
    @property
    def shape_width(self) -> int:
        '''Gets the width in units of 1/4000 of chart\'s width after calls Chart.Calculate() method.'''
        raise NotImplementedError()
    
    @property
    def shape_height(self) -> int:
        '''Gets the height in units of 1/4000 of chart\'s height after calls Chart.Calculate() method.'''
        raise NotImplementedError()
    
    @property
    def shape_x_px(self) -> int:
        '''Gets the x coordinate of the upper left corner in units of pixels after calls Chart.Calculate() method.'''
        raise NotImplementedError()
    
    @property
    def shape_y_px(self) -> int:
        '''Gets the y coordinate of the upper left corner in units of pixels after calls Chart.Calculate() method.'''
        raise NotImplementedError()
    
    @property
    def shape_width_px(self) -> int:
        '''Gets the width in units of pixels after calls Chart.Calculate() method.'''
        raise NotImplementedError()
    
    @property
    def shape_height_px(self) -> int:
        '''Gets the height in units of pixels after calls Chart.Calculate() method.'''
        raise NotImplementedError()
    
    @property
    def border_width_px(self) -> int:
        '''Gets the width of border in units of pixels after calls Chart.Calculate() method.'''
        raise NotImplementedError()
    
    @property
    def radius_px(self) -> int:
        '''Gets the radius of bubble, pie or doughnut in units of pixels after calls Chart.Calculate() method.'''
        raise NotImplementedError()
    
    @property
    def doughnut_inner_radius(self) -> int:
        '''Gets the inner radius of doughnut slice in units of pixels after calls Chart.Calculate() method.
        Applies to Doughnut chart.'''
        raise NotImplementedError()
    
    @property
    def inner_radius_px(self) -> int:
        '''Gets the inner radius of doughnut slice in units of pixels after calls Chart.Calculate() method.
        Applies to Doughnut chart.'''
        raise NotImplementedError()
    
    @property
    def start_angle(self) -> float:
        '''Gets the starting angle for the pie section, measured in degrees clockwise from the x-axis after calls Chart.Calculate() method.
        Applies to Pie chart.'''
        raise NotImplementedError()
    
    @property
    def end_angle(self) -> float:
        '''Gets the ending angle for the pie section, measured in degrees clockwise from the x-axis after calls Chart.Calculate() method.
        Applies to Pie chart.'''
        raise NotImplementedError()
    
    @property
    def arc_start_point_x_px(self) -> float:
        '''Gets the x coordinate of starting point for the pie section after calls Chart.Calculate() method.
        Applies to Pie and Doughnut  chart.'''
        raise NotImplementedError()
    
    @property
    def arc_start_point_y_px(self) -> float:
        '''Gets the y coordinate of starting point for the pie section after calls Chart.Calculate() method.
        Applies to Pie and Doughnut  chart.'''
        raise NotImplementedError()
    
    @property
    def arc_end_point_x_px(self) -> float:
        '''Gets the x coordinate of ending point for the pie section after calls Chart.Calculate() method.
        Applies to Pie and Doughnut  chart.'''
        raise NotImplementedError()
    
    @property
    def arc_end_point_y_px(self) -> float:
        '''Gets the y coordinate of ending point for the pie section after calls Chart.Calculate() method.
        Applies to Pie and Doughnut chart.'''
        raise NotImplementedError()
    
    @property
    def inner_arc_start_point_x_px(self) -> float:
        '''Gets the x coordinate of starting point for the pie section after calls Chart.Calculate() method.
        Applies to Doughnut chart.'''
        raise NotImplementedError()
    
    @property
    def inner_arc_start_point_y_px(self) -> float:
        '''Gets the y coordinate of starting point for the pie section after calls Chart.Calculate() method.
        Applies to Doughnut chart.'''
        raise NotImplementedError()
    
    @property
    def inner_arc_end_point_x_px(self) -> float:
        '''Gets the x coordinate of ending point for the pie section after calls Chart.Calculate() method.
        Applies to Doughnut chart.'''
        raise NotImplementedError()
    
    @property
    def inner_arc_end_point_y_px(self) -> float:
        '''Gets the y coordinate of ending point for the pie section after calls Chart.Calculate() method.
        Applies to Doughnut chart.'''
        raise NotImplementedError()
    

class ChartPointCollection:
    '''Represents a collection that contains all the points in one series.'''
    
    def clear(self) -> None:
        '''Remove all setting of the chart points.'''
        raise NotImplementedError()
    
    def remove_at(self, index : int) -> None:
        '''Removes point at the index of the series..
        
        :param index: The index of the point.'''
        raise NotImplementedError()
    
    @property
    def count(self) -> int:
        '''Gets the count of the chart point.'''
        raise NotImplementedError()
    
    def __getitem__(self, key : int) -> aspose.cells.charts.ChartPoint:
        '''Gets the :py:class:`aspose.cells.charts.ChartPoint` element at the specified index in the series.'''
        raise NotImplementedError()
    

class ChartTextFrame(ChartFrame):
    '''Encapsulates the object that represents the frame object which contains text.'''
    
    def set_position_auto(self) -> None:
        '''Set position of the frame to automatic'''
        raise NotImplementedError()
    
    def characters(self, start_index : int, length : int) -> aspose.cells.FontSetting:
        '''Returns a Characters object that represents a range of characters within the text.
        
        :param start_index: The index of the start of the character.
        :param length: The number of characters.
        :returns: Characters object.'''
        raise NotImplementedError()
    
    @property
    def is_inner_mode(self) -> bool:
        '''Indicates whether the size of the plot area size includes the tick marks, and the axis labels.
        False specifies that the size shall determine the size of the plot area, the tick marks, and the axis labels.'''
        raise NotImplementedError()
    
    @is_inner_mode.setter
    def is_inner_mode(self, value : bool) -> None:
        '''Indicates whether the size of the plot area size includes the tick marks, and the axis labels.
        False specifies that the size shall determine the size of the plot area, the tick marks, and the axis labels.'''
        raise NotImplementedError()
    
    @property
    def border(self) -> aspose.cells.drawing.Line:
        '''Gets the :py:class:`aspose.cells.drawing.Line`.'''
        raise NotImplementedError()
    
    @property
    def area(self) -> aspose.cells.drawing.Area:
        '''Gets the :py:attr:`aspose.cells.charts.ChartFrame.area`.'''
        raise NotImplementedError()
    
    @property
    def text_font(self) -> aspose.cells.Font:
        '''Gets a :py:attr:`aspose.cells.charts.ChartFrame.font` object of the specified ChartFrame object.'''
        raise NotImplementedError()
    
    @property
    def text_options(self) -> aspose.cells.drawing.texts.TextOptions:
        '''Gets and sets the options of the text.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Gets a :py:attr:`aspose.cells.charts.ChartFrame.font` object of the specified ChartFrame object.'''
        raise NotImplementedError()
    
    @property
    def auto_scale_font(self) -> bool:
        '''True if the text in the object changes font size when the object size changes. The default value is True.'''
        raise NotImplementedError()
    
    @auto_scale_font.setter
    def auto_scale_font(self, value : bool) -> None:
        '''True if the text in the object changes font size when the object size changes. The default value is True.'''
        raise NotImplementedError()
    
    @property
    def background_mode(self) -> aspose.cells.charts.BackgroundMode:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @background_mode.setter
    def background_mode(self, value : aspose.cells.charts.BackgroundMode) -> None:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @property
    def background(self) -> aspose.cells.charts.BackgroundMode:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @background.setter
    def background(self, value : aspose.cells.charts.BackgroundMode) -> None:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @property
    def is_automatic_size(self) -> bool:
        '''Indicates whether the chart frame is automatic sized.'''
        raise NotImplementedError()
    
    @is_automatic_size.setter
    def is_automatic_size(self, value : bool) -> None:
        '''Indicates whether the chart frame is automatic sized.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets the x coordinate of the upper left corner in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Sets the x coordinate of the upper left corner in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets the y coordinate of the upper left corner in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Sets the y coordinate of the upper left corner in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Gets the height of frame in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Sets the height of frame in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Gets the width of frame in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Sets the width of frame in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def shadow(self) -> bool:
        '''True if the frame has a shadow.'''
        raise NotImplementedError()
    
    @shadow.setter
    def shadow(self, value : bool) -> None:
        '''True if the frame has a shadow.'''
        raise NotImplementedError()
    
    @property
    def shape_properties(self) -> aspose.cells.drawing.ShapePropertyCollection:
        '''Gets the :py:attr:`aspose.cells.charts.ChartFrame.shape_properties` object.'''
        raise NotImplementedError()
    
    @property
    def is_default_pos_be_set(self) -> bool:
        '''Indicates whether default position(DefaultX, DefaultY, DefaultWidth and DefaultHeight) are set.'''
        raise NotImplementedError()
    
    @property
    def default_x(self) -> int:
        '''Represents x of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_y(self) -> int:
        '''Represents y of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_width(self) -> int:
        '''Represents width of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_height(self) -> int:
        '''Represents height of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_x_ratio_to_chart(self) -> float:
        '''Represents x of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_y_ratio_to_chart(self) -> float:
        '''Represents y of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_width_ratio_to_chart(self) -> float:
        '''Represents width of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_height_ratio_to_chart(self) -> float:
        '''Represents height of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def x_ratio_to_chart(self) -> float:
        '''Gets the x coordinate of the upper left corner in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @x_ratio_to_chart.setter
    def x_ratio_to_chart(self, value : float) -> None:
        '''Sets the x coordinate of the upper left corner in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def y_ratio_to_chart(self) -> float:
        '''Gets the y coordinate of the upper left corner in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @y_ratio_to_chart.setter
    def y_ratio_to_chart(self, value : float) -> None:
        '''Sets the y coordinate of the upper left corner in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def width_ratio_to_chart(self) -> float:
        '''Gets the width of frame in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @width_ratio_to_chart.setter
    def width_ratio_to_chart(self, value : float) -> None:
        '''Sets the width of frame in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def height_ratio_to_chart(self) -> float:
        '''Gets the height of frame in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @height_ratio_to_chart.setter
    def height_ratio_to_chart(self, value : float) -> None:
        '''Sets the height of frame in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def x_pixel(self) -> int:
        '''Gets the x coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @x_pixel.setter
    def x_pixel(self, value : int) -> None:
        '''Sets the x coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @property
    def y_pixel(self) -> int:
        '''Gets the y coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @y_pixel.setter
    def y_pixel(self, value : int) -> None:
        '''Sets the y coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @property
    def width_pixel(self) -> int:
        '''Gets the width of frame in units of Pixel.'''
        raise NotImplementedError()
    
    @width_pixel.setter
    def width_pixel(self, value : int) -> None:
        '''Sets the width of frame in units of Pixel.'''
        raise NotImplementedError()
    
    @property
    def height_pixel(self) -> int:
        '''Gets the height of frame in units of Pixel.'''
        raise NotImplementedError()
    
    @height_pixel.setter
    def height_pixel(self, value : int) -> None:
        '''Sets the height of frame in units of Pixel.'''
        raise NotImplementedError()
    
    @property
    def is_auto_text(self) -> bool:
        '''Indicates the text is auto generated.'''
        raise NotImplementedError()
    
    @is_auto_text.setter
    def is_auto_text(self, value : bool) -> None:
        '''Indicates the text is auto generated.'''
        raise NotImplementedError()
    
    @property
    def is_deleted(self) -> bool:
        '''Indicates whether this data labels is deleted.'''
        raise NotImplementedError()
    
    @is_deleted.setter
    def is_deleted(self, value : bool) -> None:
        '''Indicates whether this data labels is deleted.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text horizontal alignment.'''
        raise NotImplementedError()
    
    @text_horizontal_alignment.setter
    def text_horizontal_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text horizontal alignment.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets the text vertical alignment of text.'''
        raise NotImplementedError()
    
    @text_vertical_alignment.setter
    def text_vertical_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Sets the text vertical alignment of text.'''
        raise NotImplementedError()
    
    @property
    def rotation_angle(self) -> int:
        '''Represents text rotation angle.'''
        raise NotImplementedError()
    
    @rotation_angle.setter
    def rotation_angle(self, value : int) -> None:
        '''Represents text rotation angle.'''
        raise NotImplementedError()
    
    @property
    def is_automatic_rotation(self) -> bool:
        '''Indicates whether the text of the chart is automatically rotated.'''
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        '''Gets the text of a frame\'s title.'''
        raise NotImplementedError()
    
    @text.setter
    def text(self, value : str) -> None:
        '''Sets the text of a frame\'s title.'''
        raise NotImplementedError()
    
    @property
    def linked_source(self) -> str:
        '''Gets and sets a reference to the worksheet.'''
        raise NotImplementedError()
    
    @linked_source.setter
    def linked_source(self, value : str) -> None:
        '''Gets and sets a reference to the worksheet.'''
        raise NotImplementedError()
    
    @property
    def text_direction(self) -> aspose.cells.TextDirectionType:
        '''Represents text reading order.'''
        raise NotImplementedError()
    
    @text_direction.setter
    def text_direction(self, value : aspose.cells.TextDirectionType) -> None:
        '''Represents text reading order.'''
        raise NotImplementedError()
    
    @property
    def reading_order(self) -> aspose.cells.TextDirectionType:
        '''Represents text reading order.'''
        raise NotImplementedError()
    
    @reading_order.setter
    def reading_order(self, value : aspose.cells.TextDirectionType) -> None:
        '''Represents text reading order.'''
        raise NotImplementedError()
    
    @property
    def direction_type(self) -> aspose.cells.charts.ChartTextDirectionType:
        '''Gets and sets the direction of text.'''
        raise NotImplementedError()
    
    @direction_type.setter
    def direction_type(self, value : aspose.cells.charts.ChartTextDirectionType) -> None:
        '''Gets and sets the direction of text.'''
        raise NotImplementedError()
    
    @property
    def is_text_wrapped(self) -> bool:
        '''Gets a value indicating whether the text is wrapped.'''
        raise NotImplementedError()
    
    @is_text_wrapped.setter
    def is_text_wrapped(self, value : bool) -> None:
        '''Sets a value indicating whether the text is wrapped.'''
        raise NotImplementedError()
    
    @property
    def is_resize_shape_to_fit_text(self) -> bool:
        '''Gets whether a shape should be auto-fit to fully contain the text described within it. Auto-fitting is
        when text within a shape is scaled in order to contain all the text inside.'''
        raise NotImplementedError()
    
    @is_resize_shape_to_fit_text.setter
    def is_resize_shape_to_fit_text(self, value : bool) -> None:
        '''Sets whether a shape should be auto-fit to fully contain the text described within it. Auto-fitting is
        when text within a shape is scaled in order to contain all the text inside.'''
        raise NotImplementedError()
    

class DataLabels(ChartTextFrame):
    '''Encapsulates a collection of all the DataLabel objects for the specified Series.'''
    
    def set_position_auto(self) -> None:
        '''Set position of the frame to automatic'''
        raise NotImplementedError()
    
    def characters(self, start_index : int, length : int) -> aspose.cells.FontSetting:
        '''Returns a Characters object that represents a range of characters within the text.
        
        :param start_index: The index of the start of the character.
        :param length: The number of characters.
        :returns: Characters object.'''
        raise NotImplementedError()
    
    def apply_font(self) -> None:
        '''Apply the font of the datalabels to all child nodes.'''
        raise NotImplementedError()
    
    @property
    def is_inner_mode(self) -> bool:
        '''Indicates whether the size of the plot area size includes the tick marks, and the axis labels.
        False specifies that the size shall determine the size of the plot area, the tick marks, and the axis labels.'''
        raise NotImplementedError()
    
    @is_inner_mode.setter
    def is_inner_mode(self, value : bool) -> None:
        '''Indicates whether the size of the plot area size includes the tick marks, and the axis labels.
        False specifies that the size shall determine the size of the plot area, the tick marks, and the axis labels.'''
        raise NotImplementedError()
    
    @property
    def border(self) -> aspose.cells.drawing.Line:
        '''Gets the :py:class:`aspose.cells.drawing.Line`.'''
        raise NotImplementedError()
    
    @property
    def area(self) -> aspose.cells.drawing.Area:
        '''Gets the :py:attr:`aspose.cells.charts.DataLabels.area`.'''
        raise NotImplementedError()
    
    @property
    def text_font(self) -> aspose.cells.Font:
        '''Gets a :py:attr:`aspose.cells.charts.ChartFrame.font` object of the specified ChartFrame object.'''
        raise NotImplementedError()
    
    @property
    def text_options(self) -> aspose.cells.drawing.texts.TextOptions:
        '''Gets and sets the options of the text.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Gets the font of the DataLabels;'''
        raise NotImplementedError()
    
    @property
    def auto_scale_font(self) -> bool:
        '''True if the text in the object changes font size when the object size changes. The default value is True.'''
        raise NotImplementedError()
    
    @auto_scale_font.setter
    def auto_scale_font(self, value : bool) -> None:
        '''True if the text in the object changes font size when the object size changes. The default value is True.'''
        raise NotImplementedError()
    
    @property
    def background_mode(self) -> aspose.cells.charts.BackgroundMode:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @background_mode.setter
    def background_mode(self, value : aspose.cells.charts.BackgroundMode) -> None:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @property
    def background(self) -> aspose.cells.charts.BackgroundMode:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @background.setter
    def background(self, value : aspose.cells.charts.BackgroundMode) -> None:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @property
    def is_automatic_size(self) -> bool:
        '''Indicates whether the chart frame is automatic sized.'''
        raise NotImplementedError()
    
    @is_automatic_size.setter
    def is_automatic_size(self, value : bool) -> None:
        '''Indicates whether the chart frame is automatic sized.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets the x coordinate of the upper left corner in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Sets the x coordinate of the upper left corner in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets the y coordinate of the upper left corner in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Sets the y coordinate of the upper left corner in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Gets the height of frame in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Sets the height of frame in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Gets the width of frame in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Sets the width of frame in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def shadow(self) -> bool:
        '''True if the frame has a shadow.'''
        raise NotImplementedError()
    
    @shadow.setter
    def shadow(self, value : bool) -> None:
        '''True if the frame has a shadow.'''
        raise NotImplementedError()
    
    @property
    def shape_properties(self) -> aspose.cells.drawing.ShapePropertyCollection:
        '''Gets the :py:attr:`aspose.cells.charts.ChartFrame.shape_properties` object.'''
        raise NotImplementedError()
    
    @property
    def is_default_pos_be_set(self) -> bool:
        '''Indicates whether default position(DefaultX, DefaultY, DefaultWidth and DefaultHeight) are set.'''
        raise NotImplementedError()
    
    @property
    def default_x(self) -> int:
        '''Represents x of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_y(self) -> int:
        '''Represents y of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_width(self) -> int:
        '''Represents width of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_height(self) -> int:
        '''Represents height of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_x_ratio_to_chart(self) -> float:
        '''Represents x of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_y_ratio_to_chart(self) -> float:
        '''Represents y of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_width_ratio_to_chart(self) -> float:
        '''Represents width of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_height_ratio_to_chart(self) -> float:
        '''Represents height of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def x_ratio_to_chart(self) -> float:
        '''Gets the x coordinate of the upper left corner in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @x_ratio_to_chart.setter
    def x_ratio_to_chart(self, value : float) -> None:
        '''Sets the x coordinate of the upper left corner in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def y_ratio_to_chart(self) -> float:
        '''Gets the y coordinate of the upper left corner in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @y_ratio_to_chart.setter
    def y_ratio_to_chart(self, value : float) -> None:
        '''Sets the y coordinate of the upper left corner in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def width_ratio_to_chart(self) -> float:
        '''Gets the width of frame in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @width_ratio_to_chart.setter
    def width_ratio_to_chart(self, value : float) -> None:
        '''Sets the width of frame in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def height_ratio_to_chart(self) -> float:
        '''Gets the height of frame in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @height_ratio_to_chart.setter
    def height_ratio_to_chart(self, value : float) -> None:
        '''Sets the height of frame in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def x_pixel(self) -> int:
        '''Gets the x coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @x_pixel.setter
    def x_pixel(self, value : int) -> None:
        '''Sets the x coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @property
    def y_pixel(self) -> int:
        '''Gets the y coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @y_pixel.setter
    def y_pixel(self, value : int) -> None:
        '''Sets the y coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @property
    def width_pixel(self) -> int:
        '''Gets the width of frame in units of Pixel.'''
        raise NotImplementedError()
    
    @width_pixel.setter
    def width_pixel(self, value : int) -> None:
        '''Sets the width of frame in units of Pixel.'''
        raise NotImplementedError()
    
    @property
    def height_pixel(self) -> int:
        '''Gets the height of frame in units of Pixel.'''
        raise NotImplementedError()
    
    @height_pixel.setter
    def height_pixel(self, value : int) -> None:
        '''Sets the height of frame in units of Pixel.'''
        raise NotImplementedError()
    
    @property
    def is_auto_text(self) -> bool:
        '''Indicates the text is auto generated.'''
        raise NotImplementedError()
    
    @is_auto_text.setter
    def is_auto_text(self, value : bool) -> None:
        '''Indicates the text is auto generated.'''
        raise NotImplementedError()
    
    @property
    def is_deleted(self) -> bool:
        '''Indicates whether this data labels is deleted.'''
        raise NotImplementedError()
    
    @is_deleted.setter
    def is_deleted(self, value : bool) -> None:
        '''Indicates whether this data labels is deleted.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text horizontal alignment.'''
        raise NotImplementedError()
    
    @text_horizontal_alignment.setter
    def text_horizontal_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text horizontal alignment.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets the text vertical alignment of text.'''
        raise NotImplementedError()
    
    @text_vertical_alignment.setter
    def text_vertical_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Sets the text vertical alignment of text.'''
        raise NotImplementedError()
    
    @property
    def rotation_angle(self) -> int:
        '''Represents text rotation angle.'''
        raise NotImplementedError()
    
    @rotation_angle.setter
    def rotation_angle(self, value : int) -> None:
        '''Represents text rotation angle.'''
        raise NotImplementedError()
    
    @property
    def is_automatic_rotation(self) -> bool:
        '''Indicates whether the text of the chart is automatically rotated.'''
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        '''Gets the text of data label.'''
        raise NotImplementedError()
    
    @text.setter
    def text(self, value : str) -> None:
        '''Sets the text of data label.'''
        raise NotImplementedError()
    
    @property
    def linked_source(self) -> str:
        '''Gets and sets a reference to the worksheet.'''
        raise NotImplementedError()
    
    @linked_source.setter
    def linked_source(self, value : str) -> None:
        '''Gets and sets a reference to the worksheet.'''
        raise NotImplementedError()
    
    @property
    def text_direction(self) -> aspose.cells.TextDirectionType:
        '''Represents text reading order.'''
        raise NotImplementedError()
    
    @text_direction.setter
    def text_direction(self, value : aspose.cells.TextDirectionType) -> None:
        '''Represents text reading order.'''
        raise NotImplementedError()
    
    @property
    def reading_order(self) -> aspose.cells.TextDirectionType:
        '''Represents text reading order.'''
        raise NotImplementedError()
    
    @reading_order.setter
    def reading_order(self, value : aspose.cells.TextDirectionType) -> None:
        '''Represents text reading order.'''
        raise NotImplementedError()
    
    @property
    def direction_type(self) -> aspose.cells.charts.ChartTextDirectionType:
        '''Gets and sets the direction of text.'''
        raise NotImplementedError()
    
    @direction_type.setter
    def direction_type(self, value : aspose.cells.charts.ChartTextDirectionType) -> None:
        '''Gets and sets the direction of text.'''
        raise NotImplementedError()
    
    @property
    def is_text_wrapped(self) -> bool:
        '''Gets a value indicating whether the text is wrapped.'''
        raise NotImplementedError()
    
    @is_text_wrapped.setter
    def is_text_wrapped(self, value : bool) -> None:
        '''Sets a value indicating whether the text is wrapped.'''
        raise NotImplementedError()
    
    @property
    def is_resize_shape_to_fit_text(self) -> bool:
        '''Gets whether a shape should be auto-fit to fully contain the text described within it. Auto-fitting is
        when text within a shape is scaled in order to contain all the text inside.'''
        raise NotImplementedError()
    
    @is_resize_shape_to_fit_text.setter
    def is_resize_shape_to_fit_text(self, value : bool) -> None:
        '''Sets whether a shape should be auto-fit to fully contain the text described within it. Auto-fitting is
        when text within a shape is scaled in order to contain all the text inside.'''
        raise NotImplementedError()
    
    @property
    def show_value(self) -> bool:
        '''Represents a specified chart\'s data label values display behavior. True displays the values. False to hide.'''
        raise NotImplementedError()
    
    @show_value.setter
    def show_value(self, value : bool) -> None:
        '''Represents a specified chart\'s data label values display behavior. True displays the values. False to hide.'''
        raise NotImplementedError()
    
    @property
    def show_cell_range(self) -> bool:
        '''Indicates whether showing cell range as the data labels.'''
        raise NotImplementedError()
    
    @show_cell_range.setter
    def show_cell_range(self, value : bool) -> None:
        '''Indicates whether showing cell range as the data labels.'''
        raise NotImplementedError()
    
    @property
    def show_percentage(self) -> bool:
        '''Represents a specified chart\'s data label percentage value display behavior. True displays the percentage value. False to hide.'''
        raise NotImplementedError()
    
    @show_percentage.setter
    def show_percentage(self, value : bool) -> None:
        '''Represents a specified chart\'s data label percentage value display behavior. True displays the percentage value. False to hide.'''
        raise NotImplementedError()
    
    @property
    def show_bubble_size(self) -> bool:
        '''Represents a specified chart\'s data label percentage value display behavior. True displays the percentage value. False to hide.'''
        raise NotImplementedError()
    
    @show_bubble_size.setter
    def show_bubble_size(self, value : bool) -> None:
        '''Represents a specified chart\'s data label percentage value display behavior. True displays the percentage value. False to hide.'''
        raise NotImplementedError()
    
    @property
    def show_category_name(self) -> bool:
        '''Represents a specified chart\'s data label category name display behavior.True to display the category name for the data labels on a chart. False to hide.'''
        raise NotImplementedError()
    
    @show_category_name.setter
    def show_category_name(self, value : bool) -> None:
        '''Represents a specified chart\'s data label category name display behavior.True to display the category name for the data labels on a chart. False to hide.'''
        raise NotImplementedError()
    
    @property
    def show_series_name(self) -> bool:
        '''Indicates whether the series name displays for the data labels on a chart.
        True to show the series name. False to hide.'''
        raise NotImplementedError()
    
    @show_series_name.setter
    def show_series_name(self, value : bool) -> None:
        '''Indicates whether the series name displays for the data labels on a chart.
        True to show the series name. False to hide.'''
        raise NotImplementedError()
    
    @property
    def show_legend_key(self) -> bool:
        '''Represents a specified chart\'s data label legend key display behavior.
        True if the data label legend key is visible.'''
        raise NotImplementedError()
    
    @show_legend_key.setter
    def show_legend_key(self, value : bool) -> None:
        '''Represents a specified chart\'s data label legend key display behavior.
        True if the data label legend key is visible.'''
        raise NotImplementedError()
    
    @property
    def number_format(self) -> str:
        '''Represents the format string for the DataLabels object.'''
        raise NotImplementedError()
    
    @number_format.setter
    def number_format(self, value : str) -> None:
        '''Represents the format string for the DataLabels object.'''
        raise NotImplementedError()
    
    @property
    def number(self) -> int:
        '''Gets and sets the built-in number format.'''
        raise NotImplementedError()
    
    @number.setter
    def number(self, value : int) -> None:
        '''Gets and sets the built-in number format.'''
        raise NotImplementedError()
    
    @property
    def number_format_linked(self) -> bool:
        '''True if the number format is linked to the cells
        (so that the number format changes in the labels when it changes in the cells).'''
        raise NotImplementedError()
    
    @number_format_linked.setter
    def number_format_linked(self, value : bool) -> None:
        '''True if the number format is linked to the cells
        (so that the number format changes in the labels when it changes in the cells).'''
        raise NotImplementedError()
    
    @property
    def separator_type(self) -> aspose.cells.charts.DataLabelsSeparatorType:
        '''Gets the separator type used for the data labels on a chart.'''
        raise NotImplementedError()
    
    @separator_type.setter
    def separator_type(self, value : aspose.cells.charts.DataLabelsSeparatorType) -> None:
        '''Sets the separator type used for the data labels on a chart.'''
        raise NotImplementedError()
    
    @property
    def separator_value(self) -> str:
        '''Gets the separator value used for the data labels on a chart.'''
        raise NotImplementedError()
    
    @separator_value.setter
    def separator_value(self, value : str) -> None:
        '''Sets the separator value used for the data labels on a chart.'''
        raise NotImplementedError()
    
    @property
    def position(self) -> aspose.cells.charts.LabelPositionType:
        '''Represents the position of the data label.'''
        raise NotImplementedError()
    
    @position.setter
    def position(self, value : aspose.cells.charts.LabelPositionType) -> None:
        '''Represents the position of the data label.'''
        raise NotImplementedError()
    
    @property
    def is_never_overlap(self) -> bool:
        '''Indicates whether the datalabels display never overlap. (For Pie chart)'''
        raise NotImplementedError()
    
    @is_never_overlap.setter
    def is_never_overlap(self, value : bool) -> None:
        '''Indicates whether the datalabels display never overlap. (For Pie chart)'''
        raise NotImplementedError()
    
    @property
    def shape_type(self) -> aspose.cells.drawing.DataLabelShapeType:
        '''Gets  shape type of data label.'''
        raise NotImplementedError()
    
    @shape_type.setter
    def shape_type(self, value : aspose.cells.drawing.DataLabelShapeType) -> None:
        '''Sets  shape type of data label.'''
        raise NotImplementedError()
    

class DisplayUnitLabel(ChartTextFrame):
    '''Represents the display unit label.'''
    
    def set_position_auto(self) -> None:
        '''Set position of the frame to automatic'''
        raise NotImplementedError()
    
    def characters(self, start_index : int, length : int) -> aspose.cells.FontSetting:
        '''Returns a Characters object that represents a range of characters within the text.
        
        :param start_index: The index of the start of the character.
        :param length: The number of characters.
        :returns: Characters object.'''
        raise NotImplementedError()
    
    @property
    def is_inner_mode(self) -> bool:
        '''Indicates whether the size of the plot area size includes the tick marks, and the axis labels.
        False specifies that the size shall determine the size of the plot area, the tick marks, and the axis labels.'''
        raise NotImplementedError()
    
    @is_inner_mode.setter
    def is_inner_mode(self, value : bool) -> None:
        '''Indicates whether the size of the plot area size includes the tick marks, and the axis labels.
        False specifies that the size shall determine the size of the plot area, the tick marks, and the axis labels.'''
        raise NotImplementedError()
    
    @property
    def border(self) -> aspose.cells.drawing.Line:
        '''Gets the :py:class:`aspose.cells.drawing.Line`.'''
        raise NotImplementedError()
    
    @property
    def area(self) -> aspose.cells.drawing.Area:
        '''Gets the :py:attr:`aspose.cells.charts.ChartFrame.area`.'''
        raise NotImplementedError()
    
    @property
    def text_font(self) -> aspose.cells.Font:
        '''Gets a :py:attr:`aspose.cells.charts.ChartFrame.font` object of the specified ChartFrame object.'''
        raise NotImplementedError()
    
    @property
    def text_options(self) -> aspose.cells.drawing.texts.TextOptions:
        '''Gets and sets the options of the text.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Gets a :py:attr:`aspose.cells.charts.DisplayUnitLabel.font` object of the specified ChartFrame object.'''
        raise NotImplementedError()
    
    @property
    def auto_scale_font(self) -> bool:
        '''True if the text in the object changes font size when the object size changes. The default value is True.'''
        raise NotImplementedError()
    
    @auto_scale_font.setter
    def auto_scale_font(self, value : bool) -> None:
        '''True if the text in the object changes font size when the object size changes. The default value is True.'''
        raise NotImplementedError()
    
    @property
    def background_mode(self) -> aspose.cells.charts.BackgroundMode:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @background_mode.setter
    def background_mode(self, value : aspose.cells.charts.BackgroundMode) -> None:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @property
    def background(self) -> aspose.cells.charts.BackgroundMode:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @background.setter
    def background(self, value : aspose.cells.charts.BackgroundMode) -> None:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @property
    def is_automatic_size(self) -> bool:
        '''Indicates whether the chart frame is automatic sized.'''
        raise NotImplementedError()
    
    @is_automatic_size.setter
    def is_automatic_size(self, value : bool) -> None:
        '''Indicates whether the chart frame is automatic sized.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets the x coordinate of the upper left corner in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Sets the x coordinate of the upper left corner in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets the y coordinate of the upper left corner in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Sets the y coordinate of the upper left corner in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Gets the height of frame in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Sets the height of frame in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Gets the width of frame in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Sets the width of frame in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def shadow(self) -> bool:
        '''True if the frame has a shadow.'''
        raise NotImplementedError()
    
    @shadow.setter
    def shadow(self, value : bool) -> None:
        '''True if the frame has a shadow.'''
        raise NotImplementedError()
    
    @property
    def shape_properties(self) -> aspose.cells.drawing.ShapePropertyCollection:
        '''Gets the :py:attr:`aspose.cells.charts.ChartFrame.shape_properties` object.'''
        raise NotImplementedError()
    
    @property
    def is_default_pos_be_set(self) -> bool:
        '''Indicates whether default position(DefaultX, DefaultY, DefaultWidth and DefaultHeight) are set.'''
        raise NotImplementedError()
    
    @property
    def default_x(self) -> int:
        '''Represents x of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_y(self) -> int:
        '''Represents y of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_width(self) -> int:
        '''Represents width of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_height(self) -> int:
        '''Represents height of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_x_ratio_to_chart(self) -> float:
        '''Represents x of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_y_ratio_to_chart(self) -> float:
        '''Represents y of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_width_ratio_to_chart(self) -> float:
        '''Represents width of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_height_ratio_to_chart(self) -> float:
        '''Represents height of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def x_ratio_to_chart(self) -> float:
        '''Gets the x coordinate of the upper left corner in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @x_ratio_to_chart.setter
    def x_ratio_to_chart(self, value : float) -> None:
        '''Sets the x coordinate of the upper left corner in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def y_ratio_to_chart(self) -> float:
        '''Gets the y coordinate of the upper left corner in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @y_ratio_to_chart.setter
    def y_ratio_to_chart(self, value : float) -> None:
        '''Sets the y coordinate of the upper left corner in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def width_ratio_to_chart(self) -> float:
        '''Gets the width of frame in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @width_ratio_to_chart.setter
    def width_ratio_to_chart(self, value : float) -> None:
        '''Sets the width of frame in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def height_ratio_to_chart(self) -> float:
        '''Gets the height of frame in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @height_ratio_to_chart.setter
    def height_ratio_to_chart(self, value : float) -> None:
        '''Sets the height of frame in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def x_pixel(self) -> int:
        '''Gets the x coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @x_pixel.setter
    def x_pixel(self, value : int) -> None:
        '''Sets the x coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @property
    def y_pixel(self) -> int:
        '''Gets the y coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @y_pixel.setter
    def y_pixel(self, value : int) -> None:
        '''Sets the y coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @property
    def width_pixel(self) -> int:
        '''Gets the width of frame in units of Pixel.'''
        raise NotImplementedError()
    
    @width_pixel.setter
    def width_pixel(self, value : int) -> None:
        '''Sets the width of frame in units of Pixel.'''
        raise NotImplementedError()
    
    @property
    def height_pixel(self) -> int:
        '''Gets the height of frame in units of Pixel.'''
        raise NotImplementedError()
    
    @height_pixel.setter
    def height_pixel(self, value : int) -> None:
        '''Sets the height of frame in units of Pixel.'''
        raise NotImplementedError()
    
    @property
    def is_auto_text(self) -> bool:
        '''Indicates the text is auto generated.'''
        raise NotImplementedError()
    
    @is_auto_text.setter
    def is_auto_text(self, value : bool) -> None:
        '''Indicates the text is auto generated.'''
        raise NotImplementedError()
    
    @property
    def is_deleted(self) -> bool:
        '''Indicates whether this data labels is deleted.'''
        raise NotImplementedError()
    
    @is_deleted.setter
    def is_deleted(self, value : bool) -> None:
        '''Indicates whether this data labels is deleted.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text horizontal alignment.'''
        raise NotImplementedError()
    
    @text_horizontal_alignment.setter
    def text_horizontal_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text horizontal alignment.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets the text vertical alignment of text.'''
        raise NotImplementedError()
    
    @text_vertical_alignment.setter
    def text_vertical_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Sets the text vertical alignment of text.'''
        raise NotImplementedError()
    
    @property
    def rotation_angle(self) -> int:
        '''Represents text rotation angle.'''
        raise NotImplementedError()
    
    @rotation_angle.setter
    def rotation_angle(self, value : int) -> None:
        '''Represents text rotation angle.'''
        raise NotImplementedError()
    
    @property
    def is_automatic_rotation(self) -> bool:
        '''Indicates whether the text of the chart is automatically rotated.'''
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        '''Gets the text of display unit label.'''
        raise NotImplementedError()
    
    @text.setter
    def text(self, value : str) -> None:
        '''Sets the text of display unit label.'''
        raise NotImplementedError()
    
    @property
    def linked_source(self) -> str:
        '''Gets and sets a reference to the worksheet.'''
        raise NotImplementedError()
    
    @linked_source.setter
    def linked_source(self, value : str) -> None:
        '''Gets and sets a reference to the worksheet.'''
        raise NotImplementedError()
    
    @property
    def text_direction(self) -> aspose.cells.TextDirectionType:
        '''Represents text reading order.'''
        raise NotImplementedError()
    
    @text_direction.setter
    def text_direction(self, value : aspose.cells.TextDirectionType) -> None:
        '''Represents text reading order.'''
        raise NotImplementedError()
    
    @property
    def reading_order(self) -> aspose.cells.TextDirectionType:
        '''Represents text reading order.'''
        raise NotImplementedError()
    
    @reading_order.setter
    def reading_order(self, value : aspose.cells.TextDirectionType) -> None:
        '''Represents text reading order.'''
        raise NotImplementedError()
    
    @property
    def direction_type(self) -> aspose.cells.charts.ChartTextDirectionType:
        '''Gets and sets the direction of text.'''
        raise NotImplementedError()
    
    @direction_type.setter
    def direction_type(self, value : aspose.cells.charts.ChartTextDirectionType) -> None:
        '''Gets and sets the direction of text.'''
        raise NotImplementedError()
    
    @property
    def is_text_wrapped(self) -> bool:
        '''Gets a value indicating whether the text is wrapped.'''
        raise NotImplementedError()
    
    @is_text_wrapped.setter
    def is_text_wrapped(self, value : bool) -> None:
        '''Sets a value indicating whether the text is wrapped.'''
        raise NotImplementedError()
    
    @property
    def is_resize_shape_to_fit_text(self) -> bool:
        '''Gets whether a shape should be auto-fit to fully contain the text described within it. Auto-fitting is
        when text within a shape is scaled in order to contain all the text inside.'''
        raise NotImplementedError()
    
    @is_resize_shape_to_fit_text.setter
    def is_resize_shape_to_fit_text(self, value : bool) -> None:
        '''Sets whether a shape should be auto-fit to fully contain the text described within it. Auto-fitting is
        when text within a shape is scaled in order to contain all the text inside.'''
        raise NotImplementedError()
    

class DropBars:
    '''Represents the up/down bars in a chart.'''
    
    @property
    def border(self) -> aspose.cells.drawing.Line:
        '''Gets the border :py:class:`aspose.cells.drawing.Line`.'''
        raise NotImplementedError()
    
    @property
    def area(self) -> aspose.cells.drawing.Area:
        '''Gets the :py:attr:`aspose.cells.charts.DropBars.area`.'''
        raise NotImplementedError()
    

class ErrorBar(aspose.cells.drawing.Line):
    '''Represents error bar of data series.'''
    
    @property
    def compound_type(self) -> aspose.cells.drawing.MsoLineStyle:
        '''Specifies the compound line type'''
        raise NotImplementedError()
    
    @compound_type.setter
    def compound_type(self, value : aspose.cells.drawing.MsoLineStyle) -> None:
        '''Specifies the compound line type'''
        raise NotImplementedError()
    
    @property
    def dash_type(self) -> aspose.cells.drawing.MsoLineDashStyle:
        '''Specifies the dash line type'''
        raise NotImplementedError()
    
    @dash_type.setter
    def dash_type(self, value : aspose.cells.drawing.MsoLineDashStyle) -> None:
        '''Specifies the dash line type'''
        raise NotImplementedError()
    
    @property
    def cap_type(self) -> aspose.cells.drawing.LineCapType:
        '''Specifies the ending caps.'''
        raise NotImplementedError()
    
    @cap_type.setter
    def cap_type(self, value : aspose.cells.drawing.LineCapType) -> None:
        '''Specifies the ending caps.'''
        raise NotImplementedError()
    
    @property
    def join_type(self) -> aspose.cells.drawing.LineJoinType:
        '''Specifies the joining caps.'''
        raise NotImplementedError()
    
    @join_type.setter
    def join_type(self, value : aspose.cells.drawing.LineJoinType) -> None:
        '''Specifies the joining caps.'''
        raise NotImplementedError()
    
    @property
    def begin_type(self) -> aspose.cells.drawing.MsoArrowheadStyle:
        '''Specifies an arrowhead for the begin of a line.'''
        raise NotImplementedError()
    
    @begin_type.setter
    def begin_type(self, value : aspose.cells.drawing.MsoArrowheadStyle) -> None:
        '''Specifies an arrowhead for the begin of a line.'''
        raise NotImplementedError()
    
    @property
    def end_type(self) -> aspose.cells.drawing.MsoArrowheadStyle:
        '''Specifies an arrowhead for the end of a line.'''
        raise NotImplementedError()
    
    @end_type.setter
    def end_type(self, value : aspose.cells.drawing.MsoArrowheadStyle) -> None:
        '''Specifies an arrowhead for the end of a line.'''
        raise NotImplementedError()
    
    @property
    def begin_arrow_length(self) -> aspose.cells.drawing.MsoArrowheadLength:
        '''Specifies the length of the arrowhead for the begin of a line.'''
        raise NotImplementedError()
    
    @begin_arrow_length.setter
    def begin_arrow_length(self, value : aspose.cells.drawing.MsoArrowheadLength) -> None:
        '''Specifies the length of the arrowhead for the begin of a line.'''
        raise NotImplementedError()
    
    @property
    def end_arrow_length(self) -> aspose.cells.drawing.MsoArrowheadLength:
        '''Specifies the length of the arrowhead for the end of a line.'''
        raise NotImplementedError()
    
    @end_arrow_length.setter
    def end_arrow_length(self, value : aspose.cells.drawing.MsoArrowheadLength) -> None:
        '''Specifies the length of the arrowhead for the end of a line.'''
        raise NotImplementedError()
    
    @property
    def begin_arrow_width(self) -> aspose.cells.drawing.MsoArrowheadWidth:
        '''Specifies the width of the arrowhead for the begin of a line.'''
        raise NotImplementedError()
    
    @begin_arrow_width.setter
    def begin_arrow_width(self, value : aspose.cells.drawing.MsoArrowheadWidth) -> None:
        '''Specifies the width of the arrowhead for the begin of a line.'''
        raise NotImplementedError()
    
    @property
    def end_arrow_width(self) -> aspose.cells.drawing.MsoArrowheadWidth:
        '''Specifies the width of the arrowhead for the end of a line.'''
        raise NotImplementedError()
    
    @end_arrow_width.setter
    def end_arrow_width(self, value : aspose.cells.drawing.MsoArrowheadWidth) -> None:
        '''Specifies the width of the arrowhead for the end of a line.'''
        raise NotImplementedError()
    
    @property
    def theme_color(self) -> aspose.cells.ThemeColor:
        '''Gets and sets the theme color.'''
        raise NotImplementedError()
    
    @theme_color.setter
    def theme_color(self, value : aspose.cells.ThemeColor) -> None:
        '''Gets and sets the theme color.'''
        raise NotImplementedError()
    
    @property
    def color(self) -> aspose.pydrawing.Color:
        '''Represents the :py:class:`aspose.pydrawing.Color` of the line.'''
        raise NotImplementedError()
    
    @color.setter
    def color(self, value : aspose.pydrawing.Color) -> None:
        '''Represents the :py:class:`aspose.pydrawing.Color` of the line.'''
        raise NotImplementedError()
    
    @property
    def transparency(self) -> float:
        '''Returns the degree of transparency of the line as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    
    @transparency.setter
    def transparency(self, value : float) -> None:
        '''Returns or sets the degree of transparency of the line as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    
    @property
    def style(self) -> aspose.cells.drawing.LineType:
        '''Represents the style of the line.'''
        raise NotImplementedError()
    
    @style.setter
    def style(self, value : aspose.cells.drawing.LineType) -> None:
        '''Represents the style of the line.'''
        raise NotImplementedError()
    
    @property
    def weight(self) -> aspose.cells.drawing.WeightType:
        '''Gets the :py:class:`aspose.cells.drawing.WeightType` of the line.'''
        raise NotImplementedError()
    
    @weight.setter
    def weight(self, value : aspose.cells.drawing.WeightType) -> None:
        '''Sets the :py:class:`aspose.cells.drawing.WeightType` of the line.'''
        raise NotImplementedError()
    
    @property
    def weight_pt(self) -> float:
        '''Gets the weight of the line in unit of points.'''
        raise NotImplementedError()
    
    @weight_pt.setter
    def weight_pt(self, value : float) -> None:
        '''Sets the weight of the line in unit of points.'''
        raise NotImplementedError()
    
    @property
    def weight_px(self) -> float:
        '''Gets the weight of the line in unit of pixels.'''
        raise NotImplementedError()
    
    @weight_px.setter
    def weight_px(self, value : float) -> None:
        '''Sets the weight of the line in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def formatting_type(self) -> aspose.cells.charts.ChartLineFormattingType:
        '''Gets format type.'''
        raise NotImplementedError()
    
    @formatting_type.setter
    def formatting_type(self, value : aspose.cells.charts.ChartLineFormattingType) -> None:
        '''Sets format type.'''
        raise NotImplementedError()
    
    @property
    def is_automatic_color(self) -> bool:
        '''Indicates whether the color of line is automatic assigned.'''
        raise NotImplementedError()
    
    @property
    def is_visible(self) -> bool:
        '''Represents whether the line is visible.'''
        raise NotImplementedError()
    
    @is_visible.setter
    def is_visible(self, value : bool) -> None:
        '''Represents whether the line is visible.'''
        raise NotImplementedError()
    
    @property
    def is_auto(self) -> bool:
        '''Indicates whether this line style is auto assigned.'''
        raise NotImplementedError()
    
    @is_auto.setter
    def is_auto(self, value : bool) -> None:
        '''Indicates whether this line style is auto assigned.'''
        raise NotImplementedError()
    
    @property
    def gradient_fill(self) -> aspose.cells.drawing.GradientFill:
        '''Represents gradient fill.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.charts.ErrorBarType:
        '''Represents error bar amount type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.cells.charts.ErrorBarType) -> None:
        '''Represents error bar amount type.'''
        raise NotImplementedError()
    
    @property
    def display_type(self) -> aspose.cells.charts.ErrorBarDisplayType:
        '''Represents the display type of error bar.'''
        raise NotImplementedError()
    
    @display_type.setter
    def display_type(self, value : aspose.cells.charts.ErrorBarDisplayType) -> None:
        '''Represents the display type of error bar.'''
        raise NotImplementedError()
    
    @property
    def amount(self) -> float:
        '''Represents amount of error bar.'''
        raise NotImplementedError()
    
    @amount.setter
    def amount(self, value : float) -> None:
        '''Represents amount of error bar.'''
        raise NotImplementedError()
    
    @property
    def show_marker_t_top(self) -> bool:
        '''Indicates if formatting error bars with a T-top.'''
        raise NotImplementedError()
    
    @show_marker_t_top.setter
    def show_marker_t_top(self, value : bool) -> None:
        '''Indicates if formatting error bars with a T-top.'''
        raise NotImplementedError()
    
    @property
    def plus_value(self) -> str:
        '''Represents positive error amount when error bar type is Custom.'''
        raise NotImplementedError()
    
    @plus_value.setter
    def plus_value(self, value : str) -> None:
        '''Represents positive error amount when error bar type is Custom.'''
        raise NotImplementedError()
    
    @property
    def minus_value(self) -> str:
        '''Represents negative error amount when error bar type is Custom.'''
        raise NotImplementedError()
    
    @minus_value.setter
    def minus_value(self, value : str) -> None:
        '''Represents negative error amount when error bar type is Custom.'''
        raise NotImplementedError()
    

class Floor(aspose.cells.drawing.Area):
    '''Encapsulates the object that represents the floor of a 3-D chart.'''
    
    @property
    def background_color(self) -> aspose.pydrawing.Color:
        '''Gets the background :py:class:`aspose.pydrawing.Color` of the :py:class:`aspose.cells.drawing.Area`.'''
        raise NotImplementedError()
    
    @background_color.setter
    def background_color(self, value : aspose.pydrawing.Color) -> None:
        '''Sets the background :py:class:`aspose.pydrawing.Color` of the :py:class:`aspose.cells.drawing.Area`.'''
        raise NotImplementedError()
    
    @property
    def foreground_color(self) -> aspose.pydrawing.Color:
        '''Gets the foreground :py:class:`aspose.pydrawing.Color`.'''
        raise NotImplementedError()
    
    @foreground_color.setter
    def foreground_color(self, value : aspose.pydrawing.Color) -> None:
        '''Sets the foreground :py:class:`aspose.pydrawing.Color`.'''
        raise NotImplementedError()
    
    @property
    def formatting(self) -> aspose.cells.charts.FormattingType:
        '''Represents the formatting of the area.'''
        raise NotImplementedError()
    
    @formatting.setter
    def formatting(self, value : aspose.cells.charts.FormattingType) -> None:
        '''Represents the formatting of the area.'''
        raise NotImplementedError()
    
    @property
    def invert_if_negative(self) -> bool:
        '''If the property is true and the value of chart point is a negative number,
        the foreground color and background color will be exchanged.'''
        raise NotImplementedError()
    
    @invert_if_negative.setter
    def invert_if_negative(self, value : bool) -> None:
        '''If the property is true and the value of chart point is a negative number,
        the foreground color and background color will be exchanged.'''
        raise NotImplementedError()
    
    @property
    def fill_format(self) -> aspose.cells.drawing.FillFormat:
        '''Represents a :py:attr:`aspose.cells.drawing.Area.fill_format` object that contains fill formatting properties for the specified chart or shape.'''
        raise NotImplementedError()
    
    @property
    def transparency(self) -> float:
        '''Returns the degree of transparency of the area as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    
    @transparency.setter
    def transparency(self, value : float) -> None:
        '''Returns or sets the degree of transparency of the area as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    
    @property
    def border(self) -> aspose.cells.drawing.Line:
        '''Gets the border :py:class:`aspose.cells.drawing.Line`.'''
        raise NotImplementedError()
    
    @border.setter
    def border(self, value : aspose.cells.drawing.Line) -> None:
        '''Sets the border :py:class:`aspose.cells.drawing.Line`.'''
        raise NotImplementedError()
    

class Legend(ChartTextFrame):
    '''Encapsulates the object that represents the chart legend.'''
    
    def set_position_auto(self) -> None:
        '''Set position of the frame to automatic'''
        raise NotImplementedError()
    
    def characters(self, start_index : int, length : int) -> aspose.cells.FontSetting:
        '''Returns a Characters object that represents a range of characters within the text.
        
        :param start_index: The index of the start of the character.
        :param length: The number of characters.
        :returns: Characters object.'''
        raise NotImplementedError()
    
    def get_legend_labels(self) -> List[str]:
        '''Gets the labels of the legend entries after call Chart.Calculate() method.'''
        raise NotImplementedError()
    
    @property
    def is_inner_mode(self) -> bool:
        '''Indicates whether the size of the plot area size includes the tick marks, and the axis labels.
        False specifies that the size shall determine the size of the plot area, the tick marks, and the axis labels.'''
        raise NotImplementedError()
    
    @is_inner_mode.setter
    def is_inner_mode(self, value : bool) -> None:
        '''Indicates whether the size of the plot area size includes the tick marks, and the axis labels.
        False specifies that the size shall determine the size of the plot area, the tick marks, and the axis labels.'''
        raise NotImplementedError()
    
    @property
    def border(self) -> aspose.cells.drawing.Line:
        '''Gets the :py:class:`aspose.cells.drawing.Line`.'''
        raise NotImplementedError()
    
    @property
    def area(self) -> aspose.cells.drawing.Area:
        '''Gets the :py:attr:`aspose.cells.charts.ChartFrame.area`.'''
        raise NotImplementedError()
    
    @property
    def text_font(self) -> aspose.cells.Font:
        '''Gets a :py:attr:`aspose.cells.charts.ChartFrame.font` object of the specified ChartFrame object.'''
        raise NotImplementedError()
    
    @property
    def text_options(self) -> aspose.cells.drawing.texts.TextOptions:
        '''Gets and sets the options of the text.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Gets a :py:attr:`aspose.cells.charts.ChartFrame.font` object of the specified ChartFrame object.'''
        raise NotImplementedError()
    
    @property
    def auto_scale_font(self) -> bool:
        '''True if the text in the object changes font size when the object size changes. The default value is True.'''
        raise NotImplementedError()
    
    @auto_scale_font.setter
    def auto_scale_font(self, value : bool) -> None:
        '''True if the text in the object changes font size when the object size changes. The default value is True.'''
        raise NotImplementedError()
    
    @property
    def background_mode(self) -> aspose.cells.charts.BackgroundMode:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @background_mode.setter
    def background_mode(self, value : aspose.cells.charts.BackgroundMode) -> None:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @property
    def background(self) -> aspose.cells.charts.BackgroundMode:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @background.setter
    def background(self, value : aspose.cells.charts.BackgroundMode) -> None:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @property
    def is_automatic_size(self) -> bool:
        '''Indicates whether the chart frame is automatic sized.'''
        raise NotImplementedError()
    
    @is_automatic_size.setter
    def is_automatic_size(self, value : bool) -> None:
        '''Indicates whether the chart frame is automatic sized.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets the x coordinate of the upper left corner in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Sets the x coordinate of the upper left corner in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets the y coordinate of the upper left corner in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Sets the y coordinate of the upper left corner in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Gets the height of frame in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Sets the height of frame in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Gets the width of frame in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Sets the width of frame in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def shadow(self) -> bool:
        '''True if the frame has a shadow.'''
        raise NotImplementedError()
    
    @shadow.setter
    def shadow(self, value : bool) -> None:
        '''True if the frame has a shadow.'''
        raise NotImplementedError()
    
    @property
    def shape_properties(self) -> aspose.cells.drawing.ShapePropertyCollection:
        '''Gets the :py:attr:`aspose.cells.charts.ChartFrame.shape_properties` object.'''
        raise NotImplementedError()
    
    @property
    def is_default_pos_be_set(self) -> bool:
        '''Indicates whether default position(DefaultX, DefaultY, DefaultWidth and DefaultHeight) are set.'''
        raise NotImplementedError()
    
    @property
    def default_x(self) -> int:
        '''Represents x of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_y(self) -> int:
        '''Represents y of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_width(self) -> int:
        '''Represents width of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_height(self) -> int:
        '''Represents height of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_x_ratio_to_chart(self) -> float:
        '''Represents x of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_y_ratio_to_chart(self) -> float:
        '''Represents y of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_width_ratio_to_chart(self) -> float:
        '''Represents width of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_height_ratio_to_chart(self) -> float:
        '''Represents height of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def x_ratio_to_chart(self) -> float:
        '''Gets the x coordinate of the upper left corner in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @x_ratio_to_chart.setter
    def x_ratio_to_chart(self, value : float) -> None:
        '''Sets the x coordinate of the upper left corner in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def y_ratio_to_chart(self) -> float:
        '''Gets the y coordinate of the upper left corner in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @y_ratio_to_chart.setter
    def y_ratio_to_chart(self, value : float) -> None:
        '''Sets the y coordinate of the upper left corner in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def width_ratio_to_chart(self) -> float:
        '''Gets the width of frame in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @width_ratio_to_chart.setter
    def width_ratio_to_chart(self, value : float) -> None:
        '''Sets the width of frame in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def height_ratio_to_chart(self) -> float:
        '''Gets the height of frame in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @height_ratio_to_chart.setter
    def height_ratio_to_chart(self, value : float) -> None:
        '''Sets the height of frame in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def x_pixel(self) -> int:
        '''Gets the x coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @x_pixel.setter
    def x_pixel(self, value : int) -> None:
        '''Sets the x coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @property
    def y_pixel(self) -> int:
        '''Gets the y coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @y_pixel.setter
    def y_pixel(self, value : int) -> None:
        '''Sets the y coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @property
    def width_pixel(self) -> int:
        '''Gets the width of frame in units of Pixel.'''
        raise NotImplementedError()
    
    @width_pixel.setter
    def width_pixel(self, value : int) -> None:
        '''Sets the width of frame in units of Pixel.'''
        raise NotImplementedError()
    
    @property
    def height_pixel(self) -> int:
        '''Gets the height of frame in units of Pixel.'''
        raise NotImplementedError()
    
    @height_pixel.setter
    def height_pixel(self, value : int) -> None:
        '''Sets the height of frame in units of Pixel.'''
        raise NotImplementedError()
    
    @property
    def is_auto_text(self) -> bool:
        '''Indicates the text is auto generated.'''
        raise NotImplementedError()
    
    @is_auto_text.setter
    def is_auto_text(self, value : bool) -> None:
        '''Indicates the text is auto generated.'''
        raise NotImplementedError()
    
    @property
    def is_deleted(self) -> bool:
        '''Indicates whether this data labels is deleted.'''
        raise NotImplementedError()
    
    @is_deleted.setter
    def is_deleted(self, value : bool) -> None:
        '''Indicates whether this data labels is deleted.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text horizontal alignment.'''
        raise NotImplementedError()
    
    @text_horizontal_alignment.setter
    def text_horizontal_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text horizontal alignment.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets the text vertical alignment of text.'''
        raise NotImplementedError()
    
    @text_vertical_alignment.setter
    def text_vertical_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Sets the text vertical alignment of text.'''
        raise NotImplementedError()
    
    @property
    def rotation_angle(self) -> int:
        '''Represents text rotation angle.'''
        raise NotImplementedError()
    
    @rotation_angle.setter
    def rotation_angle(self, value : int) -> None:
        '''Represents text rotation angle.'''
        raise NotImplementedError()
    
    @property
    def is_automatic_rotation(self) -> bool:
        '''Indicates whether the text of the chart is automatically rotated.'''
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        '''Gets the text of a frame\'s title.'''
        raise NotImplementedError()
    
    @text.setter
    def text(self, value : str) -> None:
        '''Sets the text of a frame\'s title.'''
        raise NotImplementedError()
    
    @property
    def linked_source(self) -> str:
        '''Gets and sets a reference to the worksheet.'''
        raise NotImplementedError()
    
    @linked_source.setter
    def linked_source(self, value : str) -> None:
        '''Gets and sets a reference to the worksheet.'''
        raise NotImplementedError()
    
    @property
    def text_direction(self) -> aspose.cells.TextDirectionType:
        '''Represents text reading order.'''
        raise NotImplementedError()
    
    @text_direction.setter
    def text_direction(self, value : aspose.cells.TextDirectionType) -> None:
        '''Represents text reading order.'''
        raise NotImplementedError()
    
    @property
    def reading_order(self) -> aspose.cells.TextDirectionType:
        '''Represents text reading order.'''
        raise NotImplementedError()
    
    @reading_order.setter
    def reading_order(self, value : aspose.cells.TextDirectionType) -> None:
        '''Represents text reading order.'''
        raise NotImplementedError()
    
    @property
    def direction_type(self) -> aspose.cells.charts.ChartTextDirectionType:
        '''Gets and sets the direction of text.'''
        raise NotImplementedError()
    
    @direction_type.setter
    def direction_type(self, value : aspose.cells.charts.ChartTextDirectionType) -> None:
        '''Gets and sets the direction of text.'''
        raise NotImplementedError()
    
    @property
    def is_text_wrapped(self) -> bool:
        '''Gets a value indicating whether the text is wrapped.'''
        raise NotImplementedError()
    
    @is_text_wrapped.setter
    def is_text_wrapped(self, value : bool) -> None:
        '''Sets a value indicating whether the text is wrapped.'''
        raise NotImplementedError()
    
    @property
    def is_resize_shape_to_fit_text(self) -> bool:
        '''Gets whether a shape should be auto-fit to fully contain the text described within it. Auto-fitting is
        when text within a shape is scaled in order to contain all the text inside.'''
        raise NotImplementedError()
    
    @is_resize_shape_to_fit_text.setter
    def is_resize_shape_to_fit_text(self, value : bool) -> None:
        '''Sets whether a shape should be auto-fit to fully contain the text described within it. Auto-fitting is
        when text within a shape is scaled in order to contain all the text inside.'''
        raise NotImplementedError()
    
    @property
    def position(self) -> aspose.cells.charts.LegendPositionType:
        '''Gets the legend position type.'''
        raise NotImplementedError()
    
    @position.setter
    def position(self, value : aspose.cells.charts.LegendPositionType) -> None:
        '''Sets the legend position type.'''
        raise NotImplementedError()
    
    @property
    def legend_entries(self) -> aspose.cells.charts.LegendEntryCollection:
        '''Gets a collection of all the LegendEntry objects in the specified chart legend.
        Setting the legend entries of the surface chart is not supported.
        So it will return null if the chart type is surface chart type.'''
        raise NotImplementedError()
    
    @property
    def legend_entries_labels(self) -> List[Any]:
        '''Gets the labels of the legend entries after call Chart.Calculate() method.'''
        raise NotImplementedError()
    
    @property
    def is_over_lay(self) -> bool:
        '''Gets whether showing the legend without overlapping the chart.'''
        raise NotImplementedError()
    
    @is_over_lay.setter
    def is_over_lay(self, value : bool) -> None:
        '''Sets whether showing the legend without overlapping the chart.'''
        raise NotImplementedError()
    

class LegendEntry:
    '''Represents a legend entry in a chart legend.'''
    
    @property
    def is_deleted(self) -> bool:
        '''Gets and sets whether the legend entry is deleted.'''
        raise NotImplementedError()
    
    @is_deleted.setter
    def is_deleted(self, value : bool) -> None:
        '''Gets and sets whether the legend entry is deleted.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Gets a :py:attr:`aspose.cells.charts.LegendEntry.font` object of the specified ChartFrame object.'''
        raise NotImplementedError()
    
    @property
    def text_font(self) -> aspose.cells.Font:
        '''Gets a :py:attr:`aspose.cells.charts.LegendEntry.font` object of the specified LegendEntry object.'''
        raise NotImplementedError()
    
    @property
    def is_text_no_fill(self) -> bool:
        '''Gets no fill of the text.'''
        raise NotImplementedError()
    
    @is_text_no_fill.setter
    def is_text_no_fill(self, value : bool) -> None:
        '''Sets no fill of the text.'''
        raise NotImplementedError()
    
    @property
    def auto_scale_font(self) -> bool:
        '''True if the text in the object changes font size when the object size changes.
        The default value is True.'''
        raise NotImplementedError()
    
    @auto_scale_font.setter
    def auto_scale_font(self, value : bool) -> None:
        '''True if the text in the object changes font size when the object size changes.
        The default value is True.'''
        raise NotImplementedError()
    
    @property
    def background(self) -> aspose.cells.charts.BackgroundMode:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @background.setter
    def background(self, value : aspose.cells.charts.BackgroundMode) -> None:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @property
    def background_mode(self) -> aspose.cells.charts.BackgroundMode:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @background_mode.setter
    def background_mode(self, value : aspose.cells.charts.BackgroundMode) -> None:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    

class LegendEntryCollection:
    '''Represents a collection of all the :py:class:`aspose.cells.charts.LegendEntry` objects in the specified chart legend.'''
    
    @overload
    def copy_to(self, array : List[aspose.cells.charts.LegendEntry]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.charts.LegendEntry], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.charts.LegendEntry, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.charts.LegendEntry, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.charts.LegendEntry) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.charts.LegendEntry, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.charts.LegendEntry, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.charts.LegendEntry) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class Marker:
    '''Represents the marker in a line chart, scatter chart, or radar chart.'''
    
    @property
    def border(self) -> aspose.cells.drawing.Line:
        '''Gets the :py:class:`aspose.cells.drawing.Line`.'''
        raise NotImplementedError()
    
    @property
    def area(self) -> aspose.cells.drawing.Area:
        '''Gets the :py:attr:`aspose.cells.charts.Marker.area`.'''
        raise NotImplementedError()
    
    @property
    def marker_style(self) -> aspose.cells.charts.ChartMarkerType:
        '''Represents the marker style. Applies to line chart, scatter chart, or radar chart.'''
        raise NotImplementedError()
    
    @marker_style.setter
    def marker_style(self, value : aspose.cells.charts.ChartMarkerType) -> None:
        '''Represents the marker style. Applies to line chart, scatter chart, or radar chart.'''
        raise NotImplementedError()
    
    @property
    def marker_size(self) -> int:
        '''Represents the marker size in unit of points. Applies to line chart, scatter chart, or radar chart.'''
        raise NotImplementedError()
    
    @marker_size.setter
    def marker_size(self, value : int) -> None:
        '''Represents the marker size in unit of points. Applies to line chart, scatter chart, or radar chart.'''
        raise NotImplementedError()
    
    @property
    def marker_size_px(self) -> int:
        '''Represents the marker size in unit of pixels. Applies to line chart, scatter chart, or radar chart.'''
        raise NotImplementedError()
    
    @marker_size_px.setter
    def marker_size_px(self, value : int) -> None:
        '''Represents the marker size in unit of pixels. Applies to line chart, scatter chart, or radar chart.'''
        raise NotImplementedError()
    
    @property
    def foreground_color(self) -> aspose.pydrawing.Color:
        '''Represents the marker foreground color in a line chart, scatter chart, or radar chart.'''
        raise NotImplementedError()
    
    @foreground_color.setter
    def foreground_color(self, value : aspose.pydrawing.Color) -> None:
        '''Represents the marker foreground color in a line chart, scatter chart, or radar chart.'''
        raise NotImplementedError()
    
    @property
    def foreground_color_set_type(self) -> aspose.cells.charts.FormattingType:
        '''Gets the marker foreground color set type.'''
        raise NotImplementedError()
    
    @foreground_color_set_type.setter
    def foreground_color_set_type(self, value : aspose.cells.charts.FormattingType) -> None:
        '''Sets the marker foreground color set type.'''
        raise NotImplementedError()
    
    @property
    def background_color(self) -> aspose.pydrawing.Color:
        '''Represents the marker background color in a line chart, scatter chart, or radar chart.'''
        raise NotImplementedError()
    
    @background_color.setter
    def background_color(self, value : aspose.pydrawing.Color) -> None:
        '''Represents the marker background color in a line chart, scatter chart, or radar chart.'''
        raise NotImplementedError()
    
    @property
    def background_color_set_type(self) -> aspose.cells.charts.FormattingType:
        '''Gets the marker background color set type.'''
        raise NotImplementedError()
    
    @background_color_set_type.setter
    def background_color_set_type(self, value : aspose.cells.charts.FormattingType) -> None:
        '''Sets the marker background color set type.'''
        raise NotImplementedError()
    

class PivotOptions:
    '''Represents a complex type that specifies the pivot controls that appear on the chart'''
    
    @property
    def drop_zone_filter(self) -> bool:
        '''Specifies whether a control for each PivotTable field on the PivotTable page axis
        of the source PivotTable appears on the chart when dropZonesVisible is set to true.'''
        raise NotImplementedError()
    
    @drop_zone_filter.setter
    def drop_zone_filter(self, value : bool) -> None:
        '''Specifies whether a control for each PivotTable field on the PivotTable page axis
        of the source PivotTable appears on the chart when dropZonesVisible is set to true.'''
        raise NotImplementedError()
    
    @property
    def drop_zone_categories(self) -> bool:
        '''Specifies whether a control for each PivotTable field on the PivotTable row axis
        of the source PivotTable appears on the chart when dropZonesVisible is set to true.'''
        raise NotImplementedError()
    
    @drop_zone_categories.setter
    def drop_zone_categories(self, value : bool) -> None:
        '''Specifies whether a control for each PivotTable field on the PivotTable row axis
        of the source PivotTable appears on the chart when dropZonesVisible is set to true.'''
        raise NotImplementedError()
    
    @property
    def drop_zone_data(self) -> bool:
        '''Specifies whether a control for each PivotTable field on the PivotTable data axis
        of the source PivotTable appears on the chart when dropZonesVisible is set to true.'''
        raise NotImplementedError()
    
    @drop_zone_data.setter
    def drop_zone_data(self, value : bool) -> None:
        '''Specifies whether a control for each PivotTable field on the PivotTable data axis
        of the source PivotTable appears on the chart when dropZonesVisible is set to true.'''
        raise NotImplementedError()
    
    @property
    def drop_zone_series(self) -> bool:
        '''Specifies whether a control for each PivotTable field on the PivotTable column axis
        of the source PivotTable appears on the chart when dropZonesVisible is set to true.'''
        raise NotImplementedError()
    
    @drop_zone_series.setter
    def drop_zone_series(self, value : bool) -> None:
        '''Specifies whether a control for each PivotTable field on the PivotTable column axis
        of the source PivotTable appears on the chart when dropZonesVisible is set to true.'''
        raise NotImplementedError()
    
    @property
    def drop_zones_visible(self) -> bool:
        '''Specifies whether any pivot controls can appear on the pivot chart.'''
        raise NotImplementedError()
    
    @drop_zones_visible.setter
    def drop_zones_visible(self, value : bool) -> None:
        '''Specifies whether any pivot controls can appear on the pivot chart.'''
        raise NotImplementedError()
    

class PlotArea(ChartFrame):
    '''Encapsulates the object that represents the plot area in a chart.'''
    
    def set_position_auto(self) -> None:
        '''Set position of the plot area to automatic'''
        raise NotImplementedError()
    
    @property
    def is_inner_mode(self) -> bool:
        '''Indicates whether the size of the plot area size includes the tick marks, and the axis labels.
        False specifies that the size shall determine the size of the plot area, the tick marks, and the axis labels.'''
        raise NotImplementedError()
    
    @is_inner_mode.setter
    def is_inner_mode(self, value : bool) -> None:
        '''Indicates whether the size of the plot area size includes the tick marks, and the axis labels.
        False specifies that the size shall determine the size of the plot area, the tick marks, and the axis labels.'''
        raise NotImplementedError()
    
    @property
    def border(self) -> aspose.cells.drawing.Line:
        '''Gets the :py:class:`aspose.cells.drawing.Line`.'''
        raise NotImplementedError()
    
    @property
    def area(self) -> aspose.cells.drawing.Area:
        '''Gets the :py:attr:`aspose.cells.charts.ChartFrame.area`.'''
        raise NotImplementedError()
    
    @property
    def text_font(self) -> aspose.cells.Font:
        '''Gets a :py:attr:`aspose.cells.charts.ChartFrame.font` object of the specified ChartFrame object.'''
        raise NotImplementedError()
    
    @property
    def text_options(self) -> aspose.cells.drawing.texts.TextOptions:
        '''Gets and sets the options of the text.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Gets a :py:attr:`aspose.cells.charts.ChartFrame.font` object of the specified ChartFrame object.'''
        raise NotImplementedError()
    
    @property
    def auto_scale_font(self) -> bool:
        '''True if the text in the object changes font size when the object size changes. The default value is True.'''
        raise NotImplementedError()
    
    @auto_scale_font.setter
    def auto_scale_font(self, value : bool) -> None:
        '''True if the text in the object changes font size when the object size changes. The default value is True.'''
        raise NotImplementedError()
    
    @property
    def background_mode(self) -> aspose.cells.charts.BackgroundMode:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @background_mode.setter
    def background_mode(self, value : aspose.cells.charts.BackgroundMode) -> None:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @property
    def background(self) -> aspose.cells.charts.BackgroundMode:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @background.setter
    def background(self, value : aspose.cells.charts.BackgroundMode) -> None:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @property
    def is_automatic_size(self) -> bool:
        '''Indicates whether the plot area is automatic sized.'''
        raise NotImplementedError()
    
    @is_automatic_size.setter
    def is_automatic_size(self, value : bool) -> None:
        '''Indicates whether the plot area is automatic sized.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets or gets the x coordinate of the upper left corner of plot-area bounding box in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Gets or gets the x coordinate of the upper left corner of plot-area bounding box in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets or gets the y coordinate of the upper top corner  of plot-area bounding box in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Gets or gets the y coordinate of the upper top corner  of plot-area bounding box in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Gets the height of plot-area bounding box in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Sets the height of plot-area bounding box in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Gets the width of plot-area bounding box in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Sets the width of plot-area bounding box in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def shadow(self) -> bool:
        '''True if the frame has a shadow.'''
        raise NotImplementedError()
    
    @shadow.setter
    def shadow(self, value : bool) -> None:
        '''True if the frame has a shadow.'''
        raise NotImplementedError()
    
    @property
    def shape_properties(self) -> aspose.cells.drawing.ShapePropertyCollection:
        '''Gets the :py:attr:`aspose.cells.charts.ChartFrame.shape_properties` object.'''
        raise NotImplementedError()
    
    @property
    def is_default_pos_be_set(self) -> bool:
        '''Indicates whether default position(DefaultX, DefaultY, DefaultWidth and DefaultHeight) are set.'''
        raise NotImplementedError()
    
    @property
    def default_x(self) -> int:
        '''Represents x of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_y(self) -> int:
        '''Represents y of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_width(self) -> int:
        '''Represents width of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_height(self) -> int:
        '''Represents height of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_x_ratio_to_chart(self) -> float:
        '''Represents x of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_y_ratio_to_chart(self) -> float:
        '''Represents y of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_width_ratio_to_chart(self) -> float:
        '''Represents width of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_height_ratio_to_chart(self) -> float:
        '''Represents height of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def x_ratio_to_chart(self) -> float:
        '''Gets or gets the x coordinate of the upper left corner of plot-area bounding box in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @x_ratio_to_chart.setter
    def x_ratio_to_chart(self, value : float) -> None:
        '''Gets or gets the x coordinate of the upper left corner of plot-area bounding box in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def y_ratio_to_chart(self) -> float:
        '''Gets or gets the y coordinate of the upper top corner  of plot-area bounding box in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @y_ratio_to_chart.setter
    def y_ratio_to_chart(self, value : float) -> None:
        '''Gets or gets the y coordinate of the upper top corner  of plot-area bounding box in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def width_ratio_to_chart(self) -> float:
        '''Gets the width of plot-area bounding box in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @width_ratio_to_chart.setter
    def width_ratio_to_chart(self, value : float) -> None:
        '''Sets the width of plot-area bounding box in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def height_ratio_to_chart(self) -> float:
        '''Gets the height of plot-area bounding box in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @height_ratio_to_chart.setter
    def height_ratio_to_chart(self, value : float) -> None:
        '''Sets the height of plot-area bounding box in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def x_pixel(self) -> int:
        '''Gets the x coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @x_pixel.setter
    def x_pixel(self, value : int) -> None:
        '''Sets the x coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @property
    def y_pixel(self) -> int:
        '''Gets the y coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @y_pixel.setter
    def y_pixel(self, value : int) -> None:
        '''Sets the y coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @property
    def width_pixel(self) -> int:
        '''Gets the width of frame in units of Pixel.'''
        raise NotImplementedError()
    
    @width_pixel.setter
    def width_pixel(self, value : int) -> None:
        '''Sets the width of frame in units of Pixel.'''
        raise NotImplementedError()
    
    @property
    def height_pixel(self) -> int:
        '''Gets the height of frame in units of Pixel.'''
        raise NotImplementedError()
    
    @height_pixel.setter
    def height_pixel(self, value : int) -> None:
        '''Sets the height of frame in units of Pixel.'''
        raise NotImplementedError()
    
    @property
    def inner_x(self) -> int:
        '''Gets or gets the x coordinate of the upper top corner of plot area in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @inner_x.setter
    def inner_x(self, value : int) -> None:
        '''Gets or gets the x coordinate of the upper top corner of plot area in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def inner_y(self) -> int:
        '''Gets or gets the x coordinate of the upper top corner of plot area in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @inner_y.setter
    def inner_y(self, value : int) -> None:
        '''Gets or gets the x coordinate of the upper top corner of plot area in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def inner_height(self) -> int:
        '''Gets the height of plot area in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @inner_height.setter
    def inner_height(self, value : int) -> None:
        '''Sets the height of plot area in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def inner_width(self) -> int:
        '''Gets the width  of plot area in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @inner_width.setter
    def inner_width(self, value : int) -> None:
        '''Sets the width  of plot area in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def inner_x_ratio_to_chart(self) -> float:
        '''Gets or gets the x coordinate of the upper top corner of plot area in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @inner_x_ratio_to_chart.setter
    def inner_x_ratio_to_chart(self, value : float) -> None:
        '''Gets or gets the x coordinate of the upper top corner of plot area in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def inner_y_ratio_to_chart(self) -> float:
        '''Gets or gets the x coordinate of the upper top corner of plot area in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @inner_y_ratio_to_chart.setter
    def inner_y_ratio_to_chart(self, value : float) -> None:
        '''Gets or gets the x coordinate of the upper top corner of plot area in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def inner_height_ratio_to_chart(self) -> float:
        '''Gets the height of plot area in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @inner_height_ratio_to_chart.setter
    def inner_height_ratio_to_chart(self, value : float) -> None:
        '''Sets the height of plot area in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def inner_width_ratio_to_chart(self) -> float:
        '''Gets the width  of plot area in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @inner_width_ratio_to_chart.setter
    def inner_width_ratio_to_chart(self, value : float) -> None:
        '''Sets the width  of plot area in units of ratio of the chart area.'''
        raise NotImplementedError()
    

class Series:
    '''Encapsulates the object that represents a single data series in a chart.'''
    
    def move(self, count : int) -> None:
        '''Moves the series up or down.
        
        :param count: The number of moving up or down.
        Move the series up if this is less than zero;
        Move the series down if this is greater than zero.'''
        raise NotImplementedError()
    
    @property
    def is_filtered(self) -> bool:
        '''Indicates whether the series is selected or filtered.True represents this series is filtered, and it will not be displayed on the chart.'''
        raise NotImplementedError()
    
    @is_filtered.setter
    def is_filtered(self, value : bool) -> None:
        '''Indicates whether the series is selected or filtered.True represents this series is filtered, and it will not be displayed on the chart.'''
        raise NotImplementedError()
    
    @property
    def layout_properties(self) -> aspose.cells.charts.SeriesLayoutProperties:
        '''Represents the properties of layout.'''
        raise NotImplementedError()
    
    @property
    def points(self) -> aspose.cells.charts.ChartPointCollection:
        '''Gets the collection of points in a series in a chart.'''
        raise NotImplementedError()
    
    @property
    def area(self) -> aspose.cells.drawing.Area:
        '''Represents the background area of Series object.'''
        raise NotImplementedError()
    
    @property
    def border(self) -> aspose.cells.drawing.Line:
        '''Represents border of Series object.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Gets the name of the data series.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Sets the name of the data series.'''
        raise NotImplementedError()
    
    @property
    def display_name(self) -> str:
        '''Gets the series\'s name that displays on the chart graph.'''
        raise NotImplementedError()
    
    @property
    def count_of_data_values(self) -> int:
        '''Gets the number of the data values.'''
        raise NotImplementedError()
    
    @property
    def is_vertical_values(self) -> bool:
        '''Indicates whether the data source is vertical.'''
        raise NotImplementedError()
    
    @property
    def values(self) -> str:
        '''Represents the Y values of this chart series.'''
        raise NotImplementedError()
    
    @values.setter
    def values(self, value : str) -> None:
        '''Represents the Y values of this chart series.'''
        raise NotImplementedError()
    
    @property
    def values_format_code(self) -> str:
        '''Represents format code of Values\'s NumberList.'''
        raise NotImplementedError()
    
    @values_format_code.setter
    def values_format_code(self, value : str) -> None:
        '''Represents format code of Values\'s NumberList.'''
        raise NotImplementedError()
    
    @property
    def x_values_format_code(self) -> str:
        '''Represents format code of X Values\'s NumberList.'''
        raise NotImplementedError()
    
    @x_values_format_code.setter
    def x_values_format_code(self, value : str) -> None:
        '''Represents format code of X Values\'s NumberList.'''
        raise NotImplementedError()
    
    @property
    def x_values(self) -> str:
        '''Represents the x values of the chart series.'''
        raise NotImplementedError()
    
    @x_values.setter
    def x_values(self, value : str) -> None:
        '''Represents the x values of the chart series.'''
        raise NotImplementedError()
    
    @property
    def bubble_sizes(self) -> str:
        '''Gets the bubble sizes values of the chart series.'''
        raise NotImplementedError()
    
    @bubble_sizes.setter
    def bubble_sizes(self, value : str) -> None:
        '''Sets the bubble sizes values of the chart series.'''
        raise NotImplementedError()
    
    @property
    def trend_lines(self) -> aspose.cells.charts.TrendlineCollection:
        '''Returns all the trendlines of this series.'''
        raise NotImplementedError()
    
    @property
    def smooth(self) -> bool:
        '''Represents curve smoothing.
        True if curve smoothing is turned on for the line chart or scatter chart.
        Applies only to line and scatter connected by lines charts.'''
        raise NotImplementedError()
    
    @smooth.setter
    def smooth(self, value : bool) -> None:
        '''Represents curve smoothing.
        True if curve smoothing is turned on for the line chart or scatter chart.
        Applies only to line and scatter connected by lines charts.'''
        raise NotImplementedError()
    
    @property
    def shadow(self) -> bool:
        '''True if the series has a shadow.'''
        raise NotImplementedError()
    
    @shadow.setter
    def shadow(self, value : bool) -> None:
        '''True if the series has a shadow.'''
        raise NotImplementedError()
    
    @property
    def has_3d_effect(self) -> bool:
        '''True if the series has a three-dimensional appearance.
        Applies only to bubble charts.'''
        raise NotImplementedError()
    
    @has_3d_effect.setter
    def has_3d_effect(self, value : bool) -> None:
        '''True if the series has a three-dimensional appearance.
        Applies only to bubble charts.'''
        raise NotImplementedError()
    
    @property
    def bar_3d_shape_type(self) -> aspose.cells.charts.Bar3DShapeType:
        '''Gets the 3D shape type used with the 3-D bar or column chart.'''
        raise NotImplementedError()
    
    @bar_3d_shape_type.setter
    def bar_3d_shape_type(self, value : aspose.cells.charts.Bar3DShapeType) -> None:
        '''Sets the 3D shape type used with the 3-D bar or column chart.'''
        raise NotImplementedError()
    
    @property
    def data_labels(self) -> aspose.cells.charts.DataLabels:
        '''Represents the DataLabels object for the specified ASeries.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.charts.ChartType:
        '''Gets a data series\' type.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.cells.charts.ChartType) -> None:
        '''Sets a data series\' type.'''
        raise NotImplementedError()
    
    @property
    def marker(self) -> aspose.cells.charts.Marker:
        '''Gets the :py:attr:`aspose.cells.charts.Series.marker`.'''
        raise NotImplementedError()
    
    @property
    def plot_on_second_axis(self) -> bool:
        '''Indicates if this series is plotted on second value axis.'''
        raise NotImplementedError()
    
    @plot_on_second_axis.setter
    def plot_on_second_axis(self, value : bool) -> None:
        '''Indicates if this series is plotted on second value axis.'''
        raise NotImplementedError()
    
    @property
    def x_error_bar(self) -> aspose.cells.charts.ErrorBar:
        '''Represents X direction error bar of the series.'''
        raise NotImplementedError()
    
    @property
    def y_error_bar(self) -> aspose.cells.charts.ErrorBar:
        '''Represents Y direction error bar of the series.'''
        raise NotImplementedError()
    
    @property
    def has_hi_lo_lines(self) -> bool:
        '''True if the line chart has high-low lines.
        Applies only to line charts.'''
        raise NotImplementedError()
    
    @has_hi_lo_lines.setter
    def has_hi_lo_lines(self, value : bool) -> None:
        '''True if the line chart has high-low lines.
        Applies only to line charts.'''
        raise NotImplementedError()
    
    @property
    def hi_lo_lines(self) -> aspose.cells.drawing.Line:
        '''Returns a HiLoLines object that represents the high-low lines for a series on a line chart.
        Applies only to line charts.'''
        raise NotImplementedError()
    
    @property
    def has_series_lines(self) -> bool:
        '''True if a stacked column chart or bar chart has series lines or
        if a Pie of Pie chart or Bar of Pie chart has connector lines between the two sections.
        Applies only to stacked column charts, bar charts, Pie of Pie charts, or Bar of Pie charts.'''
        raise NotImplementedError()
    
    @has_series_lines.setter
    def has_series_lines(self, value : bool) -> None:
        '''True if a stacked column chart or bar chart has series lines or
        if a Pie of Pie chart or Bar of Pie chart has connector lines between the two sections.
        Applies only to stacked column charts, bar charts, Pie of Pie charts, or Bar of Pie charts.'''
        raise NotImplementedError()
    
    @property
    def series_lines(self) -> aspose.cells.drawing.Line:
        '''Returns a SeriesLines object that represents the series lines for a stacked bar chart or a stacked column chart.
        Applies only to stacked bar and stacked column charts.'''
        raise NotImplementedError()
    
    @property
    def has_drop_lines(self) -> bool:
        '''True if the chart has drop lines.
        Applies only to line chart or area charts.'''
        raise NotImplementedError()
    
    @has_drop_lines.setter
    def has_drop_lines(self, value : bool) -> None:
        '''True if the chart has drop lines.
        Applies only to line chart or area charts.'''
        raise NotImplementedError()
    
    @property
    def drop_lines(self) -> aspose.cells.drawing.Line:
        '''Returns a :py:class:`aspose.cells.drawing.Line` object that represents the drop lines for a series on the line chart or area chart.
        Applies only to line chart or area charts.'''
        raise NotImplementedError()
    
    @property
    def has_up_down_bars(self) -> bool:
        '''True if a line chart has up and down bars.
        Applies only to line charts.'''
        raise NotImplementedError()
    
    @has_up_down_bars.setter
    def has_up_down_bars(self, value : bool) -> None:
        '''True if a line chart has up and down bars.
        Applies only to line charts.'''
        raise NotImplementedError()
    
    @property
    def up_bars(self) -> aspose.cells.charts.DropBars:
        '''Returns an DropBars object that represents the up bars on a line chart.
        Applies only to line charts.'''
        raise NotImplementedError()
    
    @property
    def down_bars(self) -> aspose.cells.charts.DropBars:
        '''Returns a :py:class:`aspose.cells.charts.DropBars` object that represents the down bars on a line chart.
        Applies only to line charts.'''
        raise NotImplementedError()
    
    @property
    def is_color_varied(self) -> bool:
        '''Represents if the color of points is varied.
        The chart must contain only one series.'''
        raise NotImplementedError()
    
    @is_color_varied.setter
    def is_color_varied(self, value : bool) -> None:
        '''Represents if the color of points is varied.
        The chart must contain only one series.'''
        raise NotImplementedError()
    
    @property
    def gap_width(self) -> int:
        '''Returns the space between bar or column clusters, as a percentage of the bar or column width.
        The value of this property must be between 0 and 500.'''
        raise NotImplementedError()
    
    @gap_width.setter
    def gap_width(self, value : int) -> None:
        '''Returns or sets the space between bar or column clusters, as a percentage of the bar or column width.
        The value of this property must be between 0 and 500.'''
        raise NotImplementedError()
    
    @property
    def first_slice_angle(self) -> int:
        '''Gets the angle of the first pie-chart or doughnut-chart slice, in degrees (clockwise from vertical).
        Applies only to pie, 3-D pie, and doughnut charts, 0 to 360.'''
        raise NotImplementedError()
    
    @first_slice_angle.setter
    def first_slice_angle(self, value : int) -> None:
        '''Sets the angle of the first pie-chart or doughnut-chart slice, in degrees (clockwise from vertical).
        Applies only to pie, 3-D pie, and doughnut charts, 0 to 360.'''
        raise NotImplementedError()
    
    @property
    def overlap(self) -> int:
        '''Specifies how bars and columns are positioned.
        Can be a value between – 100 and 100.
        Applies only to 2-D bar and 2-D column charts.'''
        raise NotImplementedError()
    
    @overlap.setter
    def overlap(self, value : int) -> None:
        '''Specifies how bars and columns are positioned.
        Can be a value between – 100 and 100.
        Applies only to 2-D bar and 2-D column charts.'''
        raise NotImplementedError()
    
    @property
    def second_plot_size(self) -> int:
        '''Returns the size of the secondary section of either a pie of pie chart or a bar of pie chart,
        as a percentage of the size of the primary pie.
        Can be a value from 5 to 200.'''
        raise NotImplementedError()
    
    @second_plot_size.setter
    def second_plot_size(self, value : int) -> None:
        '''Returns or sets the size of the secondary section of either a pie of pie chart or a bar of pie chart,
        as a percentage of the size of the primary pie.
        Can be a value from 5 to 200.'''
        raise NotImplementedError()
    
    @property
    def split_type(self) -> aspose.cells.charts.ChartSplitType:
        '''Returns a value that how to determine which data points are in the second pie or bar on a pie of pie or bar of
        pie chart.'''
        raise NotImplementedError()
    
    @split_type.setter
    def split_type(self, value : aspose.cells.charts.ChartSplitType) -> None:
        '''Returns or sets a value that how to determine which data points are in the second pie or bar on a pie of pie or bar of
        pie chart.'''
        raise NotImplementedError()
    
    @property
    def split_value(self) -> float:
        '''Returns a value that shall be used to determine which data points are in the second pie or bar on
        a pie of pie or bar of pie chart.'''
        raise NotImplementedError()
    
    @split_value.setter
    def split_value(self, value : float) -> None:
        '''Returns or sets a value that shall be used to determine which data points are in the second pie or bar on
        a pie of pie or bar of pie chart.'''
        raise NotImplementedError()
    
    @property
    def is_auto_split(self) -> bool:
        '''Indicates whether the threshold value is automatic.'''
        raise NotImplementedError()
    
    @property
    def bubble_scale(self) -> int:
        '''Gets the scale factor for bubbles in the specified chart group.
        It can be an integer value from 0 (zero) to 300,
        corresponding to a percentage of the default size.
        Applies only to bubble charts.'''
        raise NotImplementedError()
    
    @bubble_scale.setter
    def bubble_scale(self, value : int) -> None:
        '''Sets the scale factor for bubbles in the specified chart group.
        It can be an integer value from 0 (zero) to 300,
        corresponding to a percentage of the default size.
        Applies only to bubble charts.'''
        raise NotImplementedError()
    
    @property
    def size_represents(self) -> aspose.cells.charts.BubbleSizeRepresents:
        '''Gets what the bubble size represents on a bubble chart.'''
        raise NotImplementedError()
    
    @size_represents.setter
    def size_represents(self, value : aspose.cells.charts.BubbleSizeRepresents) -> None:
        '''Sets what the bubble size represents on a bubble chart.'''
        raise NotImplementedError()
    
    @property
    def show_negative_bubbles(self) -> bool:
        '''True if negative bubbles are shown for the chart group. Valid only for bubble charts.'''
        raise NotImplementedError()
    
    @show_negative_bubbles.setter
    def show_negative_bubbles(self, value : bool) -> None:
        '''True if negative bubbles are shown for the chart group. Valid only for bubble charts.'''
        raise NotImplementedError()
    
    @property
    def doughnut_hole_size(self) -> int:
        '''Returns the size of the hole in a doughnut chart group.
        The hole size is expressed as a percentage of the chart size, between 10 and 90 percent.'''
        raise NotImplementedError()
    
    @doughnut_hole_size.setter
    def doughnut_hole_size(self, value : int) -> None:
        '''Returns or sets the size of the hole in a doughnut chart group.
        The hole size is expressed as a percentage of the chart size, between 10 and 90 percent.'''
        raise NotImplementedError()
    
    @property
    def explosion(self) -> int:
        '''The distance of an open pie slice from the center of the pie chart is expressed as a percentage of the pie diameter.'''
        raise NotImplementedError()
    
    @explosion.setter
    def explosion(self, value : int) -> None:
        '''The distance of an open pie slice from the center of the pie chart is expressed as a percentage of the pie diameter.'''
        raise NotImplementedError()
    
    @property
    def has_radar_axis_labels(self) -> bool:
        '''True if a radar chart has category axis labels. Applies only to radar charts.'''
        raise NotImplementedError()
    
    @has_radar_axis_labels.setter
    def has_radar_axis_labels(self, value : bool) -> None:
        '''True if a radar chart has category axis labels. Applies only to radar charts.'''
        raise NotImplementedError()
    
    @property
    def has_leader_lines(self) -> bool:
        '''True if the series has leader lines.'''
        raise NotImplementedError()
    
    @has_leader_lines.setter
    def has_leader_lines(self, value : bool) -> None:
        '''True if the series has leader lines.'''
        raise NotImplementedError()
    
    @property
    def leader_lines(self) -> aspose.cells.drawing.Line:
        '''Represents leader lines on a chart. Leader lines connect data labels to data points.
        This object isn’t a collection; there’s no object that represents a single leader line.'''
        raise NotImplementedError()
    
    @property
    def legend_entry(self) -> aspose.cells.charts.LegendEntry:
        '''Gets the legend entry according to this series.'''
        raise NotImplementedError()
    
    @property
    def shape_properties(self) -> aspose.cells.drawing.ShapePropertyCollection:
        '''Gets the :py:class:`aspose.cells.drawing.ShapePropertyCollection` object that holds the visual shape properties of the Series.'''
        raise NotImplementedError()
    

class SeriesCollection:
    '''Encapsulates a collection of :py:class:`aspose.cells.charts.Series` objects.'''
    
    @overload
    def add(self, area : str, is_vertical : bool) -> int:
        '''Adds the :py:class:`aspose.cells.charts.Series` collection to a chart.
        
        :param area: Specifies values from which to plot the data series
        :param is_vertical: Specifies whether to plot the series from a range of cell values by row or by column.
        :returns: Return the first index of the added ASeries in the NSeries.'''
        raise NotImplementedError()
    
    @overload
    def add(self, area : str, is_vertical : bool, check_labels : bool) -> int:
        '''Adds the :py:class:`aspose.cells.charts.Series` collection to a chart.
        
        :param area: Specifies values from which to plot the data series
        :param is_vertical: Specifies whether to plot the series from a range of cell values by row or by column.
        :param check_labels: Indicates whether the range contains series\'s name
        :returns: Return the first index of the added ASeries in the NSeries.'''
        raise NotImplementedError()
    
    @overload
    def copy_to(self, array : List[aspose.cells.charts.Series]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.charts.Series], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.charts.Series, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.charts.Series, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.charts.Series) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.charts.Series, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.charts.Series, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def get_series_by_order(self, order : int) -> aspose.cells.charts.Series:
        '''Gets the :py:class:`aspose.cells.charts.Series` element by order.
        
        :param order: The order of series
        :returns: The element series'''
        raise NotImplementedError()
    
    def change_series_order(self, source_index : int, dest_index : int) -> None:
        '''Directly changes the orders of the two series.
        
        :param source_index: The current index
        :param dest_index: The dest index'''
        raise NotImplementedError()
    
    def swap_series(self, source_index : int, dest_index : int) -> None:
        '''Directly changes the orders of the two series.
        
        :param source_index: The current index
        :param dest_index: The dest index'''
        raise NotImplementedError()
    
    def set_series_names(self, start_index : int, area : str, is_vertical : bool) -> None:
        '''Sets the name of all the serieses in the chart.
        
        :param start_index: The index of the first series which you want to set the name.
        :param area: Specifies the area for the series name.
        :param is_vertical: >Specifies whether to plot the series from a range of cell values by row or by column.'''
        raise NotImplementedError()
    
    def add_r1c1(self, area : str, is_vertical : bool) -> int:
        '''Adds the :py:class:`aspose.cells.charts.Series` collection to a chart.
        
        :param area: Specifies values from which to plot the data series
        :param is_vertical: Specifies whether to plot the series from a range of cell values by row or by column.
        :returns: Return the first index of the added ASeries in the NSeries.'''
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.charts.Series) -> int:
        raise NotImplementedError()
    
    @property
    def category_data(self) -> str:
        '''Gets the range of category Axis values.
        It can be a range of cells (such as, "d1:e10"),
        or a sequence of values (such as,"{2,6,8,10}").'''
        raise NotImplementedError()
    
    @category_data.setter
    def category_data(self, value : str) -> None:
        '''Sets the range of category Axis values.
        It can be a range of cells (such as, "d1:e10"),
        or a sequence of values (such as,"{2,6,8,10}").'''
        raise NotImplementedError()
    
    @property
    def second_category_data(self) -> str:
        '''Gets the range of second category Axis values.
        It can be a range of cells (such as, "d1:e10"),
        or a sequence of values (such as,"{2,6,8,10}").
        Only effects when some ASerieses plot on the second axis.'''
        raise NotImplementedError()
    
    @second_category_data.setter
    def second_category_data(self, value : str) -> None:
        '''Sets the range of second category Axis values.
        It can be a range of cells (such as, "d1:e10"),
        or a sequence of values (such as,"{2,6,8,10}").
        Only effects when some ASerieses plot on the second axis.'''
        raise NotImplementedError()
    
    @property
    def is_color_varied(self) -> bool:
        '''Represents if the color of points is varied.'''
        raise NotImplementedError()
    
    @is_color_varied.setter
    def is_color_varied(self, value : bool) -> None:
        '''Represents if the color of points is varied.'''
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class SeriesLayoutProperties:
    '''Represents the properties of series layout.'''
    
    def __init__(self) -> None:
        raise NotImplementedError()
    
    @property
    def show_connector_lines(self) -> bool:
        '''Indicates whether showing connector lines between data points.'''
        raise NotImplementedError()
    
    @show_connector_lines.setter
    def show_connector_lines(self, value : bool) -> None:
        '''Indicates whether showing connector lines between data points.'''
        raise NotImplementedError()
    
    @property
    def show_mean_line(self) -> bool:
        '''Indicates whether showing the line connecting all mean points.'''
        raise NotImplementedError()
    
    @show_mean_line.setter
    def show_mean_line(self, value : bool) -> None:
        '''Indicates whether showing the line connecting all mean points.'''
        raise NotImplementedError()
    
    @property
    def show_outlier_points(self) -> bool:
        '''Indicates whether showing outlier data points.'''
        raise NotImplementedError()
    
    @show_outlier_points.setter
    def show_outlier_points(self, value : bool) -> None:
        '''Indicates whether showing outlier data points.'''
        raise NotImplementedError()
    
    @property
    def show_mean_marker(self) -> bool:
        '''Indicates whether showing markers denoting the mean.'''
        raise NotImplementedError()
    
    @show_mean_marker.setter
    def show_mean_marker(self, value : bool) -> None:
        '''Indicates whether showing markers denoting the mean.'''
        raise NotImplementedError()
    
    @property
    def show_inner_points(self) -> bool:
        '''Indicates whether showing non-outlier data points.'''
        raise NotImplementedError()
    
    @show_inner_points.setter
    def show_inner_points(self, value : bool) -> None:
        '''Indicates whether showing non-outlier data points.'''
        raise NotImplementedError()
    
    @property
    def subtotals(self) -> List[int]:
        '''Represents the index of a subtotal data point.'''
        raise NotImplementedError()
    
    @subtotals.setter
    def subtotals(self, value : List[int]) -> None:
        '''Represents the index of a subtotal data point.'''
        raise NotImplementedError()
    
    @property
    def quartile_calculation(self) -> aspose.cells.charts.QuartileCalculationType:
        '''Represents the statistical properties for the series.'''
        raise NotImplementedError()
    
    @quartile_calculation.setter
    def quartile_calculation(self, value : aspose.cells.charts.QuartileCalculationType) -> None:
        '''Represents the statistical properties for the series.'''
        raise NotImplementedError()
    
    @property
    def map_label_layout(self) -> aspose.cells.charts.MapChartLabelLayout:
        '''Gets and sets the layout of map labels.'''
        raise NotImplementedError()
    
    @map_label_layout.setter
    def map_label_layout(self, value : aspose.cells.charts.MapChartLabelLayout) -> None:
        '''Gets and sets the layout of map labels.'''
        raise NotImplementedError()
    
    @property
    def is_interval_left_closed(self) -> bool:
        '''Indicates whether the interval is closed on the left side.'''
        raise NotImplementedError()
    
    @is_interval_left_closed.setter
    def is_interval_left_closed(self, value : bool) -> None:
        '''Indicates whether the interval is closed on the left side.'''
        raise NotImplementedError()
    
    @property
    def map_chart_region_type(self) -> aspose.cells.charts.MapChartRegionType:
        '''Gets and sets the region type of the map.'''
        raise NotImplementedError()
    
    @map_chart_region_type.setter
    def map_chart_region_type(self, value : aspose.cells.charts.MapChartRegionType) -> None:
        '''Gets and sets the region type of the map.'''
        raise NotImplementedError()
    
    @property
    def map_chart_projection_type(self) -> aspose.cells.charts.MapChartProjectionType:
        '''Gets and sets the projection type of the map.'''
        raise NotImplementedError()
    
    @map_chart_projection_type.setter
    def map_chart_projection_type(self, value : aspose.cells.charts.MapChartProjectionType) -> None:
        '''Gets and sets the projection type of the map.'''
        raise NotImplementedError()
    

class Sparkline:
    '''A sparkline represents a tiny chart or graphic in a worksheet cell that provides a visual representation of data.'''
    
    @overload
    def to_image(self, file_name : str, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Converts a sparkline to an image.
        
        :param file_name: The image file name.
        :param options: The image options'''
        raise NotImplementedError()
    
    @overload
    def to_image(self, stream : io._IOBase, options : aspose.cells.rendering.ImageOrPrintOptions) -> None:
        '''Converts a sparkline to an image.
        
        :param stream: The image stream.
        :param options: The image options.'''
        raise NotImplementedError()
    
    @property
    def data_range(self) -> str:
        '''Represents the data range of the sparkline.'''
        raise NotImplementedError()
    
    @data_range.setter
    def data_range(self, value : str) -> None:
        '''Represents the data range of the sparkline.'''
        raise NotImplementedError()
    
    @property
    def row(self) -> int:
        '''Gets the row index of the sparkline.'''
        raise NotImplementedError()
    
    @property
    def column(self) -> int:
        '''Gets the column index of the sparkline.'''
        raise NotImplementedError()
    

class SparklineCollection:
    '''Encapsulates a collection of :py:class:`aspose.cells.charts.Sparkline` objects.'''
    
    @overload
    def copy_to(self, array : List[aspose.cells.charts.Sparkline]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.charts.Sparkline], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.charts.Sparkline, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.charts.Sparkline, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.charts.Sparkline) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.charts.Sparkline, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.charts.Sparkline, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def add(self, data_range : str, row : int, column : int) -> int:
        '''Add a sparkline.
        
        :param data_range: Specifies the new data range of the sparkline.
        :param row: The row index of the location.
        :param column: The column index of the location.'''
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.charts.Sparkline) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class SparklineGroup:
    ''':py:class:`aspose.cells.charts.Sparkline` is organized into sparkline group. A SparklineGroup contains a variable number of sparkline items.
    A sparkline group specifies the type, display settings and axis settings for the sparklines.'''
    
    def reset_ranges(self, data_range : str, is_vertical : bool, location_range : aspose.cells.CellArea) -> None:
        '''Resets the data range and location range of the sparkline group.
        This method will clear original sparkline items in the group and creates new sparkline items for the new ranges.
        
        :param data_range: Specifies the new data range of the sparkline group.
        :param is_vertical: Specifies whether to plot the sparklines from the new data range by row or by column.
        :param location_range: Specifies where the sparklines to be placed.'''
        raise NotImplementedError()
    
    @property
    def preset_style(self) -> aspose.cells.charts.SparklinePresetStyleType:
        '''Gets and sets the preset style type of the sparkline group.'''
        raise NotImplementedError()
    
    @preset_style.setter
    def preset_style(self, value : aspose.cells.charts.SparklinePresetStyleType) -> None:
        '''Gets and sets the preset style type of the sparkline group.'''
        raise NotImplementedError()
    
    @property
    def sparkline_collection(self) -> aspose.cells.charts.SparklineCollection:
        '''Gets the collection of :py:class:`aspose.cells.charts.Sparkline` object.'''
        raise NotImplementedError()
    
    @property
    def sparklines(self) -> aspose.cells.charts.SparklineCollection:
        '''Gets the collection of :py:class:`aspose.cells.charts.Sparkline` object.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.charts.SparklineType:
        '''Indicates the sparkline type of the sparkline group.'''
        raise NotImplementedError()
    
    @type.setter
    def type(self, value : aspose.cells.charts.SparklineType) -> None:
        '''Indicates the sparkline type of the sparkline group.'''
        raise NotImplementedError()
    
    @property
    def plot_empty_cells_type(self) -> aspose.cells.charts.PlotEmptyCellsType:
        '''Indicates how to plot empty cells.'''
        raise NotImplementedError()
    
    @plot_empty_cells_type.setter
    def plot_empty_cells_type(self, value : aspose.cells.charts.PlotEmptyCellsType) -> None:
        '''Indicates how to plot empty cells.'''
        raise NotImplementedError()
    
    @property
    def display_hidden(self) -> bool:
        '''Indicates whether to show data in hidden rows and columns.'''
        raise NotImplementedError()
    
    @display_hidden.setter
    def display_hidden(self, value : bool) -> None:
        '''Indicates whether to show data in hidden rows and columns.'''
        raise NotImplementedError()
    
    @property
    def show_high_point(self) -> bool:
        '''Indicates whether to highlight the highest points of data in the sparkline group.'''
        raise NotImplementedError()
    
    @show_high_point.setter
    def show_high_point(self, value : bool) -> None:
        '''Indicates whether to highlight the highest points of data in the sparkline group.'''
        raise NotImplementedError()
    
    @property
    def high_point_color(self) -> aspose.cells.CellsColor:
        '''Gets and sets the color of the highest points of data in the sparkline group.'''
        raise NotImplementedError()
    
    @high_point_color.setter
    def high_point_color(self, value : aspose.cells.CellsColor) -> None:
        '''Gets and sets the color of the highest points of data in the sparkline group.'''
        raise NotImplementedError()
    
    @property
    def show_low_point(self) -> bool:
        '''Indicates whether to highlight the lowest points of data in the sparkline group.'''
        raise NotImplementedError()
    
    @show_low_point.setter
    def show_low_point(self, value : bool) -> None:
        '''Indicates whether to highlight the lowest points of data in the sparkline group.'''
        raise NotImplementedError()
    
    @property
    def low_point_color(self) -> aspose.cells.CellsColor:
        '''Gets and sets the color of the lowest points of data in the sparkline group.'''
        raise NotImplementedError()
    
    @low_point_color.setter
    def low_point_color(self, value : aspose.cells.CellsColor) -> None:
        '''Gets and sets the color of the lowest points of data in the sparkline group.'''
        raise NotImplementedError()
    
    @property
    def show_negative_points(self) -> bool:
        '''Indicates whether to highlight the negative values on the sparkline group with a different color or marker.'''
        raise NotImplementedError()
    
    @show_negative_points.setter
    def show_negative_points(self, value : bool) -> None:
        '''Indicates whether to highlight the negative values on the sparkline group with a different color or marker.'''
        raise NotImplementedError()
    
    @property
    def negative_points_color(self) -> aspose.cells.CellsColor:
        '''Gets and sets the color of the negative values on the sparkline group.'''
        raise NotImplementedError()
    
    @negative_points_color.setter
    def negative_points_color(self, value : aspose.cells.CellsColor) -> None:
        '''Gets and sets the color of the negative values on the sparkline group.'''
        raise NotImplementedError()
    
    @property
    def show_first_point(self) -> bool:
        '''Indicates whether to highlight the first point of data in the sparkline group.'''
        raise NotImplementedError()
    
    @show_first_point.setter
    def show_first_point(self, value : bool) -> None:
        '''Indicates whether to highlight the first point of data in the sparkline group.'''
        raise NotImplementedError()
    
    @property
    def first_point_color(self) -> aspose.cells.CellsColor:
        '''Gets and sets the color of the first point of data in the sparkline group.'''
        raise NotImplementedError()
    
    @first_point_color.setter
    def first_point_color(self, value : aspose.cells.CellsColor) -> None:
        '''Gets and sets the color of the first point of data in the sparkline group.'''
        raise NotImplementedError()
    
    @property
    def show_last_point(self) -> bool:
        '''Indicates whether to highlight the last point of data in the sparkline group.'''
        raise NotImplementedError()
    
    @show_last_point.setter
    def show_last_point(self, value : bool) -> None:
        '''Indicates whether to highlight the last point of data in the sparkline group.'''
        raise NotImplementedError()
    
    @property
    def last_point_color(self) -> aspose.cells.CellsColor:
        '''Gets and sets the color of the last point of data in the sparkline group.'''
        raise NotImplementedError()
    
    @last_point_color.setter
    def last_point_color(self, value : aspose.cells.CellsColor) -> None:
        '''Gets and sets the color of the last point of data in the sparkline group.'''
        raise NotImplementedError()
    
    @property
    def show_markers(self) -> bool:
        '''Indicates whether to highlight each point in each line sparkline in the sparkline group.'''
        raise NotImplementedError()
    
    @show_markers.setter
    def show_markers(self, value : bool) -> None:
        '''Indicates whether to highlight each point in each line sparkline in the sparkline group.'''
        raise NotImplementedError()
    
    @property
    def markers_color(self) -> aspose.cells.CellsColor:
        '''Gets and sets the color of points in each line sparkline in the sparkline group.'''
        raise NotImplementedError()
    
    @markers_color.setter
    def markers_color(self, value : aspose.cells.CellsColor) -> None:
        '''Gets and sets the color of points in each line sparkline in the sparkline group.'''
        raise NotImplementedError()
    
    @property
    def series_color(self) -> aspose.cells.CellsColor:
        '''Gets and sets the color of the sparklines in the sparkline group.'''
        raise NotImplementedError()
    
    @series_color.setter
    def series_color(self, value : aspose.cells.CellsColor) -> None:
        '''Gets and sets the color of the sparklines in the sparkline group.'''
        raise NotImplementedError()
    
    @property
    def plot_right_to_left(self) -> bool:
        '''Indicates whether the plot data is right to left.'''
        raise NotImplementedError()
    
    @plot_right_to_left.setter
    def plot_right_to_left(self, value : bool) -> None:
        '''Indicates whether the plot data is right to left.'''
        raise NotImplementedError()
    
    @property
    def line_weight(self) -> float:
        '''Gets and sets the line weight in each line sparkline in the sparkline group, in the unit of points.'''
        raise NotImplementedError()
    
    @line_weight.setter
    def line_weight(self, value : float) -> None:
        '''Gets and sets the line weight in each line sparkline in the sparkline group, in the unit of points.'''
        raise NotImplementedError()
    
    @property
    def horizontal_axis_color(self) -> aspose.cells.CellsColor:
        '''Gets and sets the color of the horizontal axis in the sparkline group.'''
        raise NotImplementedError()
    
    @horizontal_axis_color.setter
    def horizontal_axis_color(self, value : aspose.cells.CellsColor) -> None:
        '''Gets and sets the color of the horizontal axis in the sparkline group.'''
        raise NotImplementedError()
    
    @property
    def show_horizontal_axis(self) -> bool:
        '''Indicates whether to show the sparkline horizontal axis.
        The horizontal axis appears if the sparkline has data that crosses the zero axis.'''
        raise NotImplementedError()
    
    @show_horizontal_axis.setter
    def show_horizontal_axis(self, value : bool) -> None:
        '''Indicates whether to show the sparkline horizontal axis.
        The horizontal axis appears if the sparkline has data that crosses the zero axis.'''
        raise NotImplementedError()
    
    @property
    def horizontal_axis_date_range(self) -> str:
        '''Represents the range that contains the date values for the sparkline data.'''
        raise NotImplementedError()
    
    @horizontal_axis_date_range.setter
    def horizontal_axis_date_range(self, value : str) -> None:
        '''Represents the range that contains the date values for the sparkline data.'''
        raise NotImplementedError()
    
    @property
    def vertical_axis_max_value_type(self) -> aspose.cells.charts.SparklineAxisMinMaxType:
        '''Represents the vertical axis maximum value type.'''
        raise NotImplementedError()
    
    @vertical_axis_max_value_type.setter
    def vertical_axis_max_value_type(self, value : aspose.cells.charts.SparklineAxisMinMaxType) -> None:
        '''Represents the vertical axis maximum value type.'''
        raise NotImplementedError()
    
    @property
    def vertical_axis_max_value(self) -> float:
        '''Gets and sets the custom maximum value for the vertical axis.'''
        raise NotImplementedError()
    
    @vertical_axis_max_value.setter
    def vertical_axis_max_value(self, value : float) -> None:
        '''Gets and sets the custom maximum value for the vertical axis.'''
        raise NotImplementedError()
    
    @property
    def vertical_axis_min_value_type(self) -> aspose.cells.charts.SparklineAxisMinMaxType:
        '''Represents the vertical axis minimum value type.'''
        raise NotImplementedError()
    
    @vertical_axis_min_value_type.setter
    def vertical_axis_min_value_type(self, value : aspose.cells.charts.SparklineAxisMinMaxType) -> None:
        '''Represents the vertical axis minimum value type.'''
        raise NotImplementedError()
    
    @property
    def vertical_axis_min_value(self) -> float:
        '''Gets and sets the custom minimum value for the vertical axis.'''
        raise NotImplementedError()
    
    @vertical_axis_min_value.setter
    def vertical_axis_min_value(self, value : float) -> None:
        '''Gets and sets the custom minimum value for the vertical axis.'''
        raise NotImplementedError()
    

class SparklineGroupCollection:
    '''Encapsulates a collection of :py:class:`aspose.cells.charts.SparklineGroup` objects.'''
    
    @overload
    def add(self, type : aspose.cells.charts.SparklineType) -> int:
        '''Adds an :py:class:`aspose.cells.charts.SparklineGroup` with a :py:class:`aspose.cells.charts.Sparkline` to the collection.
        
        :param type: Specifies the type of the Sparkline group.
        :returns: :py:class:`aspose.cells.charts.SparklineGroup` object index.'''
        raise NotImplementedError()
    
    @overload
    def add(self, type : aspose.cells.charts.SparklineType, data_range : str, is_vertical : bool, location_range : aspose.cells.CellArea) -> int:
        '''Adds an :py:class:`aspose.cells.charts.SparklineGroup` with :py:class:`aspose.cells.charts.Sparkline` to the collection.
        
        :param type: Specifies the type of the Sparkline group.
        :param data_range: Specifies the data range of the sparkline group.
        :param is_vertical: Specifies whether to plot the sparklines from the data range by row or by column.
        :param location_range: Specifies where the sparklines to be placed.
        :returns: :py:class:`aspose.cells.charts.SparklineGroup` object index.'''
        raise NotImplementedError()
    
    @overload
    def copy_to(self, array : List[aspose.cells.charts.SparklineGroup]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.charts.SparklineGroup], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.charts.SparklineGroup, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.charts.SparklineGroup, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.charts.SparklineGroup) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.charts.SparklineGroup, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.charts.SparklineGroup, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def clear_sparklines(self, cell_area : aspose.cells.CellArea) -> None:
        '''Clears the sparklines that is inside an area of cells.
        
        :param cell_area: Specifies the area of cells'''
        raise NotImplementedError()
    
    def clear_sparkline_groups(self, cell_area : aspose.cells.CellArea) -> None:
        '''Clears the sparkline groups that overlaps an area of cells.
        
        :param cell_area: Specifies the area of cells'''
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.charts.SparklineGroup) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class TickLabelItem:
    '''Represents a tick label in the chart.'''
    
    @property
    def x(self) -> float:
        '''X coordinates of Ticklabel item in ratio of chart width.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> float:
        '''Y coordinates of Ticklabel item in ratio of chart height.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> float:
        '''Width of Ticklabel item in ratio of chart width.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> float:
        '''Height of Ticklabel item in ratio of chart height.'''
        raise NotImplementedError()
    

class TickLabels:
    '''Represents the tick-mark labels associated with tick marks on a chart axis.'''
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Returns a :py:attr:`aspose.cells.charts.TickLabels.font` object that represents the font of the specified TickLabels object.'''
        raise NotImplementedError()
    
    @property
    def auto_scale_font(self) -> bool:
        '''True if the text in the object changes font size when the object size changes. The default value is True.'''
        raise NotImplementedError()
    
    @auto_scale_font.setter
    def auto_scale_font(self, value : bool) -> None:
        '''True if the text in the object changes font size when the object size changes. The default value is True.'''
        raise NotImplementedError()
    
    @property
    def background_mode(self) -> aspose.cells.charts.BackgroundMode:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @background_mode.setter
    def background_mode(self, value : aspose.cells.charts.BackgroundMode) -> None:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @property
    def rotation_angle(self) -> int:
        '''Represents text rotation angle in clockwise.'''
        raise NotImplementedError()
    
    @rotation_angle.setter
    def rotation_angle(self, value : int) -> None:
        '''Represents text rotation angle in clockwise.'''
        raise NotImplementedError()
    
    @property
    def is_automatic_rotation(self) -> bool:
        '''Indicates whether the rotation angle is automatic'''
        raise NotImplementedError()
    
    @is_automatic_rotation.setter
    def is_automatic_rotation(self, value : bool) -> None:
        '''Indicates whether the rotation angle is automatic'''
        raise NotImplementedError()
    
    @property
    def number_format(self) -> str:
        '''Represents the format string for the TickLabels object.'''
        raise NotImplementedError()
    
    @number_format.setter
    def number_format(self, value : str) -> None:
        '''Represents the format string for the TickLabels object.'''
        raise NotImplementedError()
    
    @property
    def number(self) -> int:
        '''Represents the format number for the TickLabels object.'''
        raise NotImplementedError()
    
    @number.setter
    def number(self, value : int) -> None:
        '''Represents the format number for the TickLabels object.'''
        raise NotImplementedError()
    
    @property
    def number_format_linked(self) -> bool:
        '''True if the number format is linked to the cells
        (so that the number format changes in the labels when it changes in the cells).'''
        raise NotImplementedError()
    
    @number_format_linked.setter
    def number_format_linked(self, value : bool) -> None:
        '''True if the number format is linked to the cells
        (so that the number format changes in the labels when it changes in the cells).'''
        raise NotImplementedError()
    
    @property
    def display_number_format(self) -> str:
        '''Gets and sets the display number format of tick labels.'''
        raise NotImplementedError()
    
    @property
    def offset(self) -> int:
        '''Gets and sets the distance between the axis labels and the axis line.'''
        raise NotImplementedError()
    
    @offset.setter
    def offset(self, value : int) -> None:
        '''Gets and sets the distance between the axis labels and the axis line.'''
        raise NotImplementedError()
    
    @property
    def text_direction(self) -> aspose.cells.TextDirectionType:
        '''Represents text reading order.'''
        raise NotImplementedError()
    
    @text_direction.setter
    def text_direction(self, value : aspose.cells.TextDirectionType) -> None:
        '''Represents text reading order.'''
        raise NotImplementedError()
    
    @property
    def reading_order(self) -> aspose.cells.TextDirectionType:
        '''Represents text reading order.'''
        raise NotImplementedError()
    
    @reading_order.setter
    def reading_order(self, value : aspose.cells.TextDirectionType) -> None:
        '''Represents text reading order.'''
        raise NotImplementedError()
    
    @property
    def direction_type(self) -> aspose.cells.charts.ChartTextDirectionType:
        '''Gets and sets the direction of text.'''
        raise NotImplementedError()
    
    @direction_type.setter
    def direction_type(self, value : aspose.cells.charts.ChartTextDirectionType) -> None:
        '''Gets and sets the direction of text.'''
        raise NotImplementedError()
    
    @property
    def tick_label_items(self) -> List[aspose.cells.charts.TickLabelItem]:
        '''Gets the display tick labels of the axis.'''
        raise NotImplementedError()
    
    @property
    def alignment_type(self) -> aspose.cells.charts.TickLabelAlignmentType:
        '''Gets and sets the text alignment for the tick labels on the axis.'''
        raise NotImplementedError()
    
    @alignment_type.setter
    def alignment_type(self, value : aspose.cells.charts.TickLabelAlignmentType) -> None:
        '''Gets and sets the text alignment for the tick labels on the axis.'''
        raise NotImplementedError()
    

class Title(ChartTextFrame):
    '''Encapsulates the object that represents the title of chart or axis.'''
    
    @overload
    def characters(self) -> List[aspose.cells.FontSetting]:
        '''Gets rich text formatting of this Title.
        
        :returns: returns FontSetting array'''
        raise NotImplementedError()
    
    @overload
    def characters(self, start_index : int, length : int) -> aspose.cells.FontSetting:
        '''Returns a Characters object that represents a range of characters within the text.
        
        :param start_index: The index of the start of the character.
        :param length: The number of characters.
        :returns: Characters object.'''
        raise NotImplementedError()
    
    def set_position_auto(self) -> None:
        '''Set position of the frame to automatic'''
        raise NotImplementedError()
    
    @property
    def is_inner_mode(self) -> bool:
        '''Indicates whether the size of the plot area size includes the tick marks, and the axis labels.
        False specifies that the size shall determine the size of the plot area, the tick marks, and the axis labels.'''
        raise NotImplementedError()
    
    @is_inner_mode.setter
    def is_inner_mode(self, value : bool) -> None:
        '''Indicates whether the size of the plot area size includes the tick marks, and the axis labels.
        False specifies that the size shall determine the size of the plot area, the tick marks, and the axis labels.'''
        raise NotImplementedError()
    
    @property
    def border(self) -> aspose.cells.drawing.Line:
        '''Gets the :py:class:`aspose.cells.drawing.Line`.'''
        raise NotImplementedError()
    
    @property
    def area(self) -> aspose.cells.drawing.Area:
        '''Gets the :py:attr:`aspose.cells.charts.ChartFrame.area`.'''
        raise NotImplementedError()
    
    @property
    def text_font(self) -> aspose.cells.Font:
        '''Gets a :py:attr:`aspose.cells.charts.ChartFrame.font` object of the specified ChartFrame object.'''
        raise NotImplementedError()
    
    @property
    def text_options(self) -> aspose.cells.drawing.texts.TextOptions:
        '''Gets and sets the options of the text.'''
        raise NotImplementedError()
    
    @property
    def font(self) -> aspose.cells.Font:
        '''Gets a :py:attr:`aspose.cells.charts.ChartFrame.font` object of the specified ChartFrame object.'''
        raise NotImplementedError()
    
    @property
    def auto_scale_font(self) -> bool:
        '''True if the text in the object changes font size when the object size changes. The default value is True.'''
        raise NotImplementedError()
    
    @auto_scale_font.setter
    def auto_scale_font(self, value : bool) -> None:
        '''True if the text in the object changes font size when the object size changes. The default value is True.'''
        raise NotImplementedError()
    
    @property
    def background_mode(self) -> aspose.cells.charts.BackgroundMode:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @background_mode.setter
    def background_mode(self, value : aspose.cells.charts.BackgroundMode) -> None:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @property
    def background(self) -> aspose.cells.charts.BackgroundMode:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @background.setter
    def background(self, value : aspose.cells.charts.BackgroundMode) -> None:
        '''Gets and sets the display mode of the background'''
        raise NotImplementedError()
    
    @property
    def is_automatic_size(self) -> bool:
        '''Indicates whether the chart frame is automatic sized.'''
        raise NotImplementedError()
    
    @is_automatic_size.setter
    def is_automatic_size(self, value : bool) -> None:
        '''Indicates whether the chart frame is automatic sized.'''
        raise NotImplementedError()
    
    @property
    def x(self) -> int:
        '''Gets the x coordinate of the upper left corner in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @x.setter
    def x(self, value : int) -> None:
        '''Sets the x coordinate of the upper left corner in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def y(self) -> int:
        '''Gets the y coordinate of the upper left corner in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @y.setter
    def y(self, value : int) -> None:
        '''Sets the y coordinate of the upper left corner in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Gets the height of frame in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @height.setter
    def height(self, value : int) -> None:
        '''Sets the height of frame in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Gets the width of frame in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @width.setter
    def width(self, value : int) -> None:
        '''Sets the width of frame in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def shadow(self) -> bool:
        '''True if the frame has a shadow.'''
        raise NotImplementedError()
    
    @shadow.setter
    def shadow(self, value : bool) -> None:
        '''True if the frame has a shadow.'''
        raise NotImplementedError()
    
    @property
    def shape_properties(self) -> aspose.cells.drawing.ShapePropertyCollection:
        '''Gets the :py:attr:`aspose.cells.charts.ChartFrame.shape_properties` object.'''
        raise NotImplementedError()
    
    @property
    def is_default_pos_be_set(self) -> bool:
        '''Indicates whether default position(DefaultX, DefaultY, DefaultWidth and DefaultHeight) are set.'''
        raise NotImplementedError()
    
    @property
    def default_x(self) -> int:
        '''Represents x of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_y(self) -> int:
        '''Represents y of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_width(self) -> int:
        '''Represents width of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_height(self) -> int:
        '''Represents height of default position in units of 1/4000 of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_x_ratio_to_chart(self) -> float:
        '''Represents x of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_y_ratio_to_chart(self) -> float:
        '''Represents y of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_width_ratio_to_chart(self) -> float:
        '''Represents width of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def default_height_ratio_to_chart(self) -> float:
        '''Represents height of default position in units of Fraction of the chart area.'''
        raise NotImplementedError()
    
    @property
    def x_ratio_to_chart(self) -> float:
        '''Gets the x coordinate of the upper left corner in units of Fraction of the chart area.
        X In Pixels = XRatioToChart * Chart.ChartObject.Width;'''
        raise NotImplementedError()
    
    @x_ratio_to_chart.setter
    def x_ratio_to_chart(self, value : float) -> None:
        '''Sets the x coordinate of the upper left corner in units of Fraction of the chart area.
        X In Pixels = XRatioToChart * Chart.ChartObject.Width;'''
        raise NotImplementedError()
    
    @property
    def y_ratio_to_chart(self) -> float:
        '''Gets the y coordinate of the upper left corner in units of Fraction of the chart area.
        Y In Pixels = YRatioToChart * Chart.ChartObject.Width;'''
        raise NotImplementedError()
    
    @y_ratio_to_chart.setter
    def y_ratio_to_chart(self, value : float) -> None:
        '''Sets the y coordinate of the upper left corner in units of Fraction of the chart area.
        Y In Pixels = YRatioToChart * Chart.ChartObject.Width;'''
        raise NotImplementedError()
    
    @property
    def width_ratio_to_chart(self) -> float:
        '''Gets the width of frame in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @width_ratio_to_chart.setter
    def width_ratio_to_chart(self, value : float) -> None:
        '''Sets the width of frame in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def height_ratio_to_chart(self) -> float:
        '''Gets the height of frame in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @height_ratio_to_chart.setter
    def height_ratio_to_chart(self, value : float) -> None:
        '''Sets the height of frame in units of ratio of the chart area.'''
        raise NotImplementedError()
    
    @property
    def x_pixel(self) -> int:
        '''Gets the x coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @x_pixel.setter
    def x_pixel(self, value : int) -> None:
        '''Sets the x coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @property
    def y_pixel(self) -> int:
        '''Gets the y coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @y_pixel.setter
    def y_pixel(self, value : int) -> None:
        '''Sets the y coordinate of the upper left corner in units of Pixel.'''
        raise NotImplementedError()
    
    @property
    def width_pixel(self) -> int:
        '''Gets the width of frame in units of Pixel.'''
        raise NotImplementedError()
    
    @width_pixel.setter
    def width_pixel(self, value : int) -> None:
        '''Sets the width of frame in units of Pixel.'''
        raise NotImplementedError()
    
    @property
    def height_pixel(self) -> int:
        '''Gets the height of frame in units of Pixel.'''
        raise NotImplementedError()
    
    @height_pixel.setter
    def height_pixel(self, value : int) -> None:
        '''Sets the height of frame in units of Pixel.'''
        raise NotImplementedError()
    
    @property
    def is_auto_text(self) -> bool:
        '''Indicates the text is auto generated.'''
        raise NotImplementedError()
    
    @is_auto_text.setter
    def is_auto_text(self, value : bool) -> None:
        '''Indicates the text is auto generated.'''
        raise NotImplementedError()
    
    @property
    def is_deleted(self) -> bool:
        '''Indicates whether this data labels is deleted.'''
        raise NotImplementedError()
    
    @is_deleted.setter
    def is_deleted(self, value : bool) -> None:
        '''Indicates whether this data labels is deleted.'''
        raise NotImplementedError()
    
    @property
    def text_horizontal_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets and sets the text horizontal alignment.'''
        raise NotImplementedError()
    
    @text_horizontal_alignment.setter
    def text_horizontal_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Gets and sets the text horizontal alignment.'''
        raise NotImplementedError()
    
    @property
    def text_vertical_alignment(self) -> aspose.cells.TextAlignmentType:
        '''Gets the text vertical alignment of text.'''
        raise NotImplementedError()
    
    @text_vertical_alignment.setter
    def text_vertical_alignment(self, value : aspose.cells.TextAlignmentType) -> None:
        '''Sets the text vertical alignment of text.'''
        raise NotImplementedError()
    
    @property
    def rotation_angle(self) -> int:
        '''Represents text rotation angle.'''
        raise NotImplementedError()
    
    @rotation_angle.setter
    def rotation_angle(self, value : int) -> None:
        '''Represents text rotation angle.'''
        raise NotImplementedError()
    
    @property
    def is_automatic_rotation(self) -> bool:
        '''Indicates whether the text of the chart is automatically rotated.'''
        raise NotImplementedError()
    
    @property
    def text(self) -> str:
        '''Gets the text of display unit label.'''
        raise NotImplementedError()
    
    @text.setter
    def text(self, value : str) -> None:
        '''Sets the text of display unit label.'''
        raise NotImplementedError()
    
    @property
    def linked_source(self) -> str:
        '''Gets and sets a reference to the worksheet.'''
        raise NotImplementedError()
    
    @linked_source.setter
    def linked_source(self, value : str) -> None:
        '''Gets and sets a reference to the worksheet.'''
        raise NotImplementedError()
    
    @property
    def text_direction(self) -> aspose.cells.TextDirectionType:
        '''Represents text reading order.'''
        raise NotImplementedError()
    
    @text_direction.setter
    def text_direction(self, value : aspose.cells.TextDirectionType) -> None:
        '''Represents text reading order.'''
        raise NotImplementedError()
    
    @property
    def reading_order(self) -> aspose.cells.TextDirectionType:
        '''Represents text reading order.'''
        raise NotImplementedError()
    
    @reading_order.setter
    def reading_order(self, value : aspose.cells.TextDirectionType) -> None:
        '''Represents text reading order.'''
        raise NotImplementedError()
    
    @property
    def direction_type(self) -> aspose.cells.charts.ChartTextDirectionType:
        '''Gets and sets the direction of text.'''
        raise NotImplementedError()
    
    @direction_type.setter
    def direction_type(self, value : aspose.cells.charts.ChartTextDirectionType) -> None:
        '''Gets and sets the direction of text.'''
        raise NotImplementedError()
    
    @property
    def is_text_wrapped(self) -> bool:
        '''Gets a value indicating whether the text is wrapped.'''
        raise NotImplementedError()
    
    @is_text_wrapped.setter
    def is_text_wrapped(self, value : bool) -> None:
        '''Sets a value indicating whether the text is wrapped.'''
        raise NotImplementedError()
    
    @property
    def is_resize_shape_to_fit_text(self) -> bool:
        '''Gets whether a shape should be auto-fit to fully contain the text described within it. Auto-fitting is
        when text within a shape is scaled in order to contain all the text inside.'''
        raise NotImplementedError()
    
    @is_resize_shape_to_fit_text.setter
    def is_resize_shape_to_fit_text(self, value : bool) -> None:
        '''Sets whether a shape should be auto-fit to fully contain the text described within it. Auto-fitting is
        when text within a shape is scaled in order to contain all the text inside.'''
        raise NotImplementedError()
    
    @property
    def is_visible(self) -> bool:
        '''Represents whether the title is visible.'''
        raise NotImplementedError()
    
    @is_visible.setter
    def is_visible(self, value : bool) -> None:
        '''Represents whether the title is visible.'''
        raise NotImplementedError()
    
    @property
    def over_lay(self) -> bool:
        '''Represents overlay centered title on chart without resizing chart.'''
        raise NotImplementedError()
    
    @over_lay.setter
    def over_lay(self, value : bool) -> None:
        '''Represents overlay centered title on chart without resizing chart.'''
        raise NotImplementedError()
    

class Trendline(aspose.cells.drawing.Line):
    '''Represents a trendline in a chart.'''
    
    @property
    def compound_type(self) -> aspose.cells.drawing.MsoLineStyle:
        '''Specifies the compound line type'''
        raise NotImplementedError()
    
    @compound_type.setter
    def compound_type(self, value : aspose.cells.drawing.MsoLineStyle) -> None:
        '''Specifies the compound line type'''
        raise NotImplementedError()
    
    @property
    def dash_type(self) -> aspose.cells.drawing.MsoLineDashStyle:
        '''Specifies the dash line type'''
        raise NotImplementedError()
    
    @dash_type.setter
    def dash_type(self, value : aspose.cells.drawing.MsoLineDashStyle) -> None:
        '''Specifies the dash line type'''
        raise NotImplementedError()
    
    @property
    def cap_type(self) -> aspose.cells.drawing.LineCapType:
        '''Specifies the ending caps.'''
        raise NotImplementedError()
    
    @cap_type.setter
    def cap_type(self, value : aspose.cells.drawing.LineCapType) -> None:
        '''Specifies the ending caps.'''
        raise NotImplementedError()
    
    @property
    def join_type(self) -> aspose.cells.drawing.LineJoinType:
        '''Specifies the joining caps.'''
        raise NotImplementedError()
    
    @join_type.setter
    def join_type(self, value : aspose.cells.drawing.LineJoinType) -> None:
        '''Specifies the joining caps.'''
        raise NotImplementedError()
    
    @property
    def begin_type(self) -> aspose.cells.drawing.MsoArrowheadStyle:
        '''Specifies an arrowhead for the begin of a line.'''
        raise NotImplementedError()
    
    @begin_type.setter
    def begin_type(self, value : aspose.cells.drawing.MsoArrowheadStyle) -> None:
        '''Specifies an arrowhead for the begin of a line.'''
        raise NotImplementedError()
    
    @property
    def end_type(self) -> aspose.cells.drawing.MsoArrowheadStyle:
        '''Specifies an arrowhead for the end of a line.'''
        raise NotImplementedError()
    
    @end_type.setter
    def end_type(self, value : aspose.cells.drawing.MsoArrowheadStyle) -> None:
        '''Specifies an arrowhead for the end of a line.'''
        raise NotImplementedError()
    
    @property
    def begin_arrow_length(self) -> aspose.cells.drawing.MsoArrowheadLength:
        '''Specifies the length of the arrowhead for the begin of a line.'''
        raise NotImplementedError()
    
    @begin_arrow_length.setter
    def begin_arrow_length(self, value : aspose.cells.drawing.MsoArrowheadLength) -> None:
        '''Specifies the length of the arrowhead for the begin of a line.'''
        raise NotImplementedError()
    
    @property
    def end_arrow_length(self) -> aspose.cells.drawing.MsoArrowheadLength:
        '''Specifies the length of the arrowhead for the end of a line.'''
        raise NotImplementedError()
    
    @end_arrow_length.setter
    def end_arrow_length(self, value : aspose.cells.drawing.MsoArrowheadLength) -> None:
        '''Specifies the length of the arrowhead for the end of a line.'''
        raise NotImplementedError()
    
    @property
    def begin_arrow_width(self) -> aspose.cells.drawing.MsoArrowheadWidth:
        '''Specifies the width of the arrowhead for the begin of a line.'''
        raise NotImplementedError()
    
    @begin_arrow_width.setter
    def begin_arrow_width(self, value : aspose.cells.drawing.MsoArrowheadWidth) -> None:
        '''Specifies the width of the arrowhead for the begin of a line.'''
        raise NotImplementedError()
    
    @property
    def end_arrow_width(self) -> aspose.cells.drawing.MsoArrowheadWidth:
        '''Specifies the width of the arrowhead for the end of a line.'''
        raise NotImplementedError()
    
    @end_arrow_width.setter
    def end_arrow_width(self, value : aspose.cells.drawing.MsoArrowheadWidth) -> None:
        '''Specifies the width of the arrowhead for the end of a line.'''
        raise NotImplementedError()
    
    @property
    def theme_color(self) -> aspose.cells.ThemeColor:
        '''Gets and sets the theme color.'''
        raise NotImplementedError()
    
    @theme_color.setter
    def theme_color(self, value : aspose.cells.ThemeColor) -> None:
        '''Gets and sets the theme color.'''
        raise NotImplementedError()
    
    @property
    def color(self) -> aspose.pydrawing.Color:
        '''Represents the :py:class:`aspose.pydrawing.Color` of the line.'''
        raise NotImplementedError()
    
    @color.setter
    def color(self, value : aspose.pydrawing.Color) -> None:
        '''Represents the :py:class:`aspose.pydrawing.Color` of the line.'''
        raise NotImplementedError()
    
    @property
    def transparency(self) -> float:
        '''Returns the degree of transparency of the line as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    
    @transparency.setter
    def transparency(self, value : float) -> None:
        '''Returns or sets the degree of transparency of the line as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    
    @property
    def style(self) -> aspose.cells.drawing.LineType:
        '''Represents the style of the line.'''
        raise NotImplementedError()
    
    @style.setter
    def style(self, value : aspose.cells.drawing.LineType) -> None:
        '''Represents the style of the line.'''
        raise NotImplementedError()
    
    @property
    def weight(self) -> aspose.cells.drawing.WeightType:
        '''Gets the :py:class:`aspose.cells.drawing.WeightType` of the line.'''
        raise NotImplementedError()
    
    @weight.setter
    def weight(self, value : aspose.cells.drawing.WeightType) -> None:
        '''Sets the :py:class:`aspose.cells.drawing.WeightType` of the line.'''
        raise NotImplementedError()
    
    @property
    def weight_pt(self) -> float:
        '''Gets the weight of the line in unit of points.'''
        raise NotImplementedError()
    
    @weight_pt.setter
    def weight_pt(self, value : float) -> None:
        '''Sets the weight of the line in unit of points.'''
        raise NotImplementedError()
    
    @property
    def weight_px(self) -> float:
        '''Gets the weight of the line in unit of pixels.'''
        raise NotImplementedError()
    
    @weight_px.setter
    def weight_px(self, value : float) -> None:
        '''Sets the weight of the line in unit of pixels.'''
        raise NotImplementedError()
    
    @property
    def formatting_type(self) -> aspose.cells.charts.ChartLineFormattingType:
        '''Gets format type.'''
        raise NotImplementedError()
    
    @formatting_type.setter
    def formatting_type(self, value : aspose.cells.charts.ChartLineFormattingType) -> None:
        '''Sets format type.'''
        raise NotImplementedError()
    
    @property
    def is_automatic_color(self) -> bool:
        '''Indicates whether the color of line is automatic assigned.'''
        raise NotImplementedError()
    
    @property
    def is_visible(self) -> bool:
        '''Represents whether the line is visible.'''
        raise NotImplementedError()
    
    @is_visible.setter
    def is_visible(self, value : bool) -> None:
        '''Represents whether the line is visible.'''
        raise NotImplementedError()
    
    @property
    def is_auto(self) -> bool:
        '''Indicates whether this line style is auto assigned.'''
        raise NotImplementedError()
    
    @is_auto.setter
    def is_auto(self, value : bool) -> None:
        '''Indicates whether this line style is auto assigned.'''
        raise NotImplementedError()
    
    @property
    def gradient_fill(self) -> aspose.cells.drawing.GradientFill:
        '''Represents gradient fill.'''
        raise NotImplementedError()
    
    @property
    def is_name_auto(self) -> bool:
        '''Returns if Microsoft Excel automatically determines the name of the trendline.'''
        raise NotImplementedError()
    
    @is_name_auto.setter
    def is_name_auto(self, value : bool) -> None:
        '''Returns if Microsoft Excel automatically determines the name of the trendline.'''
        raise NotImplementedError()
    
    @property
    def type(self) -> aspose.cells.charts.TrendlineType:
        '''Returns the trendline type.'''
        raise NotImplementedError()
    
    @property
    def name(self) -> str:
        '''Returns the name of the trendline.'''
        raise NotImplementedError()
    
    @name.setter
    def name(self, value : str) -> None:
        '''Returns the name of the trendline.'''
        raise NotImplementedError()
    
    @property
    def order(self) -> int:
        '''Returns the trendline order (an integer greater than 1) when the trendline type is Polynomial.
        The order must be between 2 and 6.'''
        raise NotImplementedError()
    
    @order.setter
    def order(self, value : int) -> None:
        '''Returns or sets the trendline order (an integer greater than 1) when the trendline type is Polynomial.
        The order must be between 2 and 6.'''
        raise NotImplementedError()
    
    @property
    def period(self) -> int:
        '''Returns the period for the moving-average trendline.'''
        raise NotImplementedError()
    
    @period.setter
    def period(self, value : int) -> None:
        '''Returns or sets the period for the moving-average trendline.'''
        raise NotImplementedError()
    
    @property
    def forward(self) -> float:
        '''Returns the number of periods (or units on a scatter chart) that the trendline extends forward.
        The number of periods must be greater than or equal to zero.'''
        raise NotImplementedError()
    
    @forward.setter
    def forward(self, value : float) -> None:
        '''Returns or sets the number of periods (or units on a scatter chart) that the trendline extends forward.
        The number of periods must be greater than or equal to zero.'''
        raise NotImplementedError()
    
    @property
    def backward(self) -> float:
        '''Returns the number of periods (or units on a scatter chart) that the trendline extends backward.
        The number of periods must be greater than or equal to zero.
        If the chart type is column ,the number of periods must be between 0 and 0.5'''
        raise NotImplementedError()
    
    @backward.setter
    def backward(self, value : float) -> None:
        '''Returns or sets the number of periods (or units on a scatter chart) that the trendline extends backward.
        The number of periods must be greater than or equal to zero.
        If the chart type is column ,the number of periods must be between 0 and 0.5'''
        raise NotImplementedError()
    
    @property
    def display_equation(self) -> bool:
        '''Represents if the equation for the trendline is displayed on the chart (in the same data label as the R-squared value). Setting this property to True automatically turns on data labels.'''
        raise NotImplementedError()
    
    @display_equation.setter
    def display_equation(self, value : bool) -> None:
        '''Represents if the equation for the trendline is displayed on the chart (in the same data label as the R-squared value). Setting this property to True automatically turns on data labels.'''
        raise NotImplementedError()
    
    @property
    def display_r_squared(self) -> bool:
        '''Represents if the R-squared value of the trendline is displayed on the chart (in the same data label as the equation). Setting this property to True automatically turns on data labels.'''
        raise NotImplementedError()
    
    @display_r_squared.setter
    def display_r_squared(self, value : bool) -> None:
        '''Represents if the R-squared value of the trendline is displayed on the chart (in the same data label as the equation). Setting this property to True automatically turns on data labels.'''
        raise NotImplementedError()
    
    @property
    def intercept(self) -> float:
        '''Returns the point where the trendline crosses the value axis.'''
        raise NotImplementedError()
    
    @intercept.setter
    def intercept(self, value : float) -> None:
        '''Returns or sets the point where the trendline crosses the value axis.'''
        raise NotImplementedError()
    
    @property
    def data_labels(self) -> aspose.cells.charts.DataLabels:
        '''Represents the DataLabels object for the specified series.'''
        raise NotImplementedError()
    
    @property
    def legend_entry(self) -> aspose.cells.charts.LegendEntry:
        '''Gets the legend entry according to this trendline'''
        raise NotImplementedError()
    

class TrendlineCollection:
    '''Represents a collection of all the :py:class:`aspose.cells.charts.Trendline` objects for the specified data series.'''
    
    @overload
    def add(self, type : aspose.cells.charts.TrendlineType) -> int:
        '''Adds a :py:class:`aspose.cells.charts.Trendline` object to this collection with specified type.
        
        :param type: Trendline type.
        :returns: :py:class:`aspose.cells.charts.Trendline` object index.'''
        raise NotImplementedError()
    
    @overload
    def add(self, type : aspose.cells.charts.TrendlineType, name : str) -> int:
        '''Adds a :py:class:`aspose.cells.charts.Trendline` object to this collection with specified type and name.
        
        :param type: Trendline type.
        :param name: Trendline name.
        :returns: :py:class:`aspose.cells.charts.Trendline` object index.'''
        raise NotImplementedError()
    
    @overload
    def copy_to(self, array : List[aspose.cells.charts.Trendline]) -> None:
        raise NotImplementedError()
    
    @overload
    def copy_to(self, index : int, array : List[aspose.cells.charts.Trendline], array_index : int, count : int) -> None:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.charts.Trendline, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def index_of(self, item : aspose.cells.charts.Trendline, index : int, count : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.charts.Trendline) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.charts.Trendline, index : int) -> int:
        raise NotImplementedError()
    
    @overload
    def last_index_of(self, item : aspose.cells.charts.Trendline, index : int, count : int) -> int:
        raise NotImplementedError()
    
    def binary_search(self, item : aspose.cells.charts.Trendline) -> int:
        raise NotImplementedError()
    
    @property
    def capacity(self) -> int:
        raise NotImplementedError()
    
    @capacity.setter
    def capacity(self, value : int) -> None:
        raise NotImplementedError()
    

class Walls(Floor):
    '''Encapsulates the object that represents the walls of a 3-D chart.'''
    
    def get_cube_point_count(self) -> int:
        '''Gets the number of cube points after calls Chart.Calculate() method.'''
        raise NotImplementedError()
    
    def get_cube_point_x_px(self, index : int) -> float:
        '''Gets x-coordinate of the apex point of walls cube after calls Chart.Calculate() method.
        The number of apex points of walls cube is eight'''
        raise NotImplementedError()
    
    def get_cube_point_y_px(self, index : int) -> float:
        '''Gets y-coordinate of the apex point of walls cube after calls Chart.Calculate() method.
        The number of apex points of walls cube is eight.'''
        raise NotImplementedError()
    
    @property
    def background_color(self) -> aspose.pydrawing.Color:
        '''Gets the background :py:class:`aspose.pydrawing.Color` of the :py:class:`aspose.cells.drawing.Area`.'''
        raise NotImplementedError()
    
    @background_color.setter
    def background_color(self, value : aspose.pydrawing.Color) -> None:
        '''Sets the background :py:class:`aspose.pydrawing.Color` of the :py:class:`aspose.cells.drawing.Area`.'''
        raise NotImplementedError()
    
    @property
    def foreground_color(self) -> aspose.pydrawing.Color:
        '''Gets the foreground :py:class:`aspose.pydrawing.Color`.'''
        raise NotImplementedError()
    
    @foreground_color.setter
    def foreground_color(self, value : aspose.pydrawing.Color) -> None:
        '''Sets the foreground :py:class:`aspose.pydrawing.Color`.'''
        raise NotImplementedError()
    
    @property
    def formatting(self) -> aspose.cells.charts.FormattingType:
        '''Represents the formatting of the area.'''
        raise NotImplementedError()
    
    @formatting.setter
    def formatting(self, value : aspose.cells.charts.FormattingType) -> None:
        '''Represents the formatting of the area.'''
        raise NotImplementedError()
    
    @property
    def invert_if_negative(self) -> bool:
        '''If the property is true and the value of chart point is a negative number,
        the foreground color and background color will be exchanged.'''
        raise NotImplementedError()
    
    @invert_if_negative.setter
    def invert_if_negative(self, value : bool) -> None:
        '''If the property is true and the value of chart point is a negative number,
        the foreground color and background color will be exchanged.'''
        raise NotImplementedError()
    
    @property
    def fill_format(self) -> aspose.cells.drawing.FillFormat:
        '''Represents a :py:attr:`aspose.cells.drawing.Area.fill_format` object that contains fill formatting properties for the specified chart or shape.'''
        raise NotImplementedError()
    
    @property
    def transparency(self) -> float:
        '''Returns the degree of transparency of the area as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    
    @transparency.setter
    def transparency(self, value : float) -> None:
        '''Returns or sets the degree of transparency of the area as a value from 0.0 (opaque) through 1.0 (clear).'''
        raise NotImplementedError()
    
    @property
    def border(self) -> aspose.cells.drawing.Line:
        '''Gets the border :py:class:`aspose.cells.drawing.Line`.'''
        raise NotImplementedError()
    
    @border.setter
    def border(self, value : aspose.cells.drawing.Line) -> None:
        '''Sets the border :py:class:`aspose.cells.drawing.Line`.'''
        raise NotImplementedError()
    
    @property
    def center_x(self) -> int:
        '''Gets the x coordinate of the left-bottom corner of Wall center in units of 1/4000 of chart\'s width after calls Chart.Calculate() method.'''
        raise NotImplementedError()
    
    @property
    def center_y(self) -> int:
        '''Gets the y coordinate of the left-bottom corner of Wall center in units of 1/4000 of chart\'s height after calls Chart.Calculate() method.'''
        raise NotImplementedError()
    
    @property
    def width(self) -> int:
        '''Gets the width of left to right in units of 1/4000 of chart\'s width after calls Chart.Calculate() method.'''
        raise NotImplementedError()
    
    @property
    def depth(self) -> int:
        '''Gets the depth front to back in units of 1/4000 of chart\'s width after calls Chart.Calculate() method.'''
        raise NotImplementedError()
    
    @property
    def height(self) -> int:
        '''Gets the height of top to bottom in units of 1/4000 of chart\'s height after calls Chart.Calculate() method.'''
        raise NotImplementedError()
    
    @property
    def center_x_px(self) -> int:
        '''Gets the x coordinate of the left-bottom corner of Wall center in units of pixels after calls Chart.Calculate() method.'''
        raise NotImplementedError()
    
    @property
    def center_y_px(self) -> int:
        '''Gets the y coordinate of the left-bottom corner of Wall center in units of pixels after calls Chart.Calculate() method.'''
        raise NotImplementedError()
    
    @property
    def width_px(self) -> int:
        '''Gets the width of left to right in units of pixels after calls Chart.Calculate() method.'''
        raise NotImplementedError()
    
    @property
    def depth_px(self) -> int:
        '''Gets the depth front to back in units of pixels after calls Chart.Calculate() method.'''
        raise NotImplementedError()
    
    @property
    def height_px(self) -> int:
        '''Gets the height of top to bottom in units of pixels after calls Chart.Calculate() method.'''
        raise NotImplementedError()
    

class AxisType:
    '''Represents the axis type.'''
    
    CATEGORY : AxisType
    '''Category axis'''
    VALUE : AxisType
    '''Value axis'''
    SERIES : AxisType
    '''Series axis'''

class BackgroundMode:
    '''Represents the display mode of the background.'''
    
    AUTOMATIC : BackgroundMode
    '''Automatic'''
    OPAQUE : BackgroundMode
    '''Opaque'''
    TRANSPARENT : BackgroundMode
    '''Transparent'''

class Bar3DShapeType:
    '''Represents the shape used with the 3-D bar or column chart.'''
    
    BOX : Bar3DShapeType
    '''Box'''
    PYRAMID_TO_POINT : Bar3DShapeType
    '''PyramidToPoint'''
    PYRAMID_TO_MAX : Bar3DShapeType
    '''PyramidToMax'''
    CYLINDER : Bar3DShapeType
    '''Cylinder'''
    CONE_TO_POINT : Bar3DShapeType
    '''ConeToPoint'''
    CONE_TO_MAX : Bar3DShapeType
    '''ConeToMax'''

class BubbleSizeRepresents:
    '''Represents what the bubble size represents on a bubble chart.'''
    
    SIZE_IS_AREA : BubbleSizeRepresents
    '''Represents the value of :py:attr:`aspose.cells.charts.Series.bubble_sizes` is area of the bubble.'''
    SIZE_IS_WIDTH : BubbleSizeRepresents
    '''Represents the value of :py:attr:`aspose.cells.charts.Series.bubble_sizes` is width of the bubble.'''

class CategoryType:
    '''Represents the category axis type.'''
    
    AUTOMATIC_SCALE : CategoryType
    '''AutomaticScale'''
    CATEGORY_SCALE : CategoryType
    '''CategoryScale'''
    TIME_SCALE : CategoryType
    '''TimeScale'''

class ChartLineFormattingType:
    '''Represents line format type of chart line.'''
    
    AUTOMATIC : ChartLineFormattingType
    '''Represents automatic formatting type.'''
    SOLID : ChartLineFormattingType
    '''Represents solid formatting type.'''
    NONE : ChartLineFormattingType
    '''Represents none formatting type.'''
    GRADIENT : ChartLineFormattingType
    '''Gradient'''

class ChartMarkerType:
    '''Represents the marker style in a line chart, scatter chart, or radar chart.'''
    
    AUTOMATIC : ChartMarkerType
    '''Automatic markers.'''
    CIRCLE : ChartMarkerType
    '''Circular markers.'''
    DASH : ChartMarkerType
    '''Long bar markers'''
    DIAMOND : ChartMarkerType
    '''Diamond-shaped markers.'''
    DOT : ChartMarkerType
    '''Short bar markers.'''
    NONE : ChartMarkerType
    '''No markers.'''
    SQUARE_PLUS : ChartMarkerType
    '''Square markers with a plus sign.'''
    SQUARE : ChartMarkerType
    '''Square markers.'''
    SQUARE_STAR : ChartMarkerType
    '''Square markers with an asterisk.'''
    TRIANGLE : ChartMarkerType
    '''Triangular markers.'''
    SQUARE_X : ChartMarkerType
    '''Square markers with an X.'''
    PICTURE : ChartMarkerType
    '''Picture'''

class ChartSplitType:
    '''Represents the way the two sections of either a pie of pie chart or a bar of pie chart are split.'''
    
    POSITION : ChartSplitType
    '''Represents the data points shall be split between the pie
    and the second chart by putting the last Split Position
    of the data points in the second chart'''
    VALUE : ChartSplitType
    '''Represents the data points shall be split between the pie
    and the second chart by putting the data points with
    value less than Split Position in the second chart.'''
    PERCENT_VALUE : ChartSplitType
    '''Represents the data points shall be split between the pie
    and the second chart by putting the points with
    percentage less than Split Position percent in the
    second chart.'''
    CUSTOM : ChartSplitType
    '''Represents the data points shall be split between the pie
    and the second chart according to the Custom Split
    values.'''
    AUTO : ChartSplitType
    '''Represents the data points shall be split using the default
    mechanism for this chart type.'''

class ChartTextDirectionType:
    '''Represents the text direction type of the chart.'''
    
    HORIZONTAL : ChartTextDirectionType
    '''Horizontal direction type.'''
    VERTICAL : ChartTextDirectionType
    '''Vertical direction type.'''
    ROTATE90 : ChartTextDirectionType
    '''Rotate 90 angle.'''
    ROTATE270 : ChartTextDirectionType
    '''Rotate 270 angle.'''
    STACKED : ChartTextDirectionType
    '''Stacked text.'''

class ChartType:
    '''Enumerates all chart types used in Excel.'''
    
    AREA : ChartType
    '''Represents Area Chart.'''
    AREA_STACKED : ChartType
    '''Represents Stacked Area Chart.'''
    AREA_100_PERCENT_STACKED : ChartType
    '''Represents 100% Stacked Area Chart.'''
    AREA_3D : ChartType
    '''Represents 3D Area Chart.'''
    AREA_3D_STACKED : ChartType
    '''Represents 3D Stacked Area Chart.'''
    AREA_3D100_PERCENT_STACKED : ChartType
    '''Represents 3D 100% Stacked Area Chart.'''
    BAR : ChartType
    '''Represents Bar Chart: Clustered Bar Chart.'''
    BAR_STACKED : ChartType
    '''Represents Stacked Bar Chart.'''
    BAR_100_PERCENT_STACKED : ChartType
    '''Represents 100% Stacked Bar Chart.'''
    BAR_3D_CLUSTERED : ChartType
    '''Represents 3D Clustered Bar Chart.'''
    BAR_3D_STACKED : ChartType
    '''Represents 3D Stacked Bar Chart.'''
    BAR_3D100_PERCENT_STACKED : ChartType
    '''Represents 3D 100% Stacked Bar Chart.'''
    BUBBLE : ChartType
    '''Represents Bubble Chart.'''
    BUBBLE_3D : ChartType
    '''Represents 3D Bubble Chart.'''
    COLUMN : ChartType
    '''Represents Column Chart: Clustered Column Chart.'''
    COLUMN_STACKED : ChartType
    '''Represents Stacked Column Chart.'''
    COLUMN_100_PERCENT_STACKED : ChartType
    '''Represents 100% Stacked Column Chart.'''
    COLUMN_3D : ChartType
    '''Represents 3D Column Chart.'''
    COLUMN_3D_CLUSTERED : ChartType
    '''Represents 3D Clustered Column Chart.'''
    COLUMN_3D_STACKED : ChartType
    '''Represents 3D Stacked Column Chart.'''
    COLUMN_3D100_PERCENT_STACKED : ChartType
    '''Represents 3D 100% Stacked Column Chart.'''
    CONE : ChartType
    '''Represents Cone Chart.'''
    CONE_STACKED : ChartType
    '''Represents Stacked Cone Chart.'''
    CONE_100_PERCENT_STACKED : ChartType
    '''Represents 100% Stacked Cone Chart.'''
    CONICAL_BAR : ChartType
    '''Represents Conical Bar Chart.'''
    CONICAL_BAR_STACKED : ChartType
    '''Represents Stacked Conical Bar Chart.'''
    CONICAL_BAR_100_PERCENT_STACKED : ChartType
    '''Represents 100% Stacked Conical Bar Chart.'''
    CONICAL_COLUMN_3D : ChartType
    '''Represents 3D Conical Column Chart.'''
    CYLINDER : ChartType
    '''Represents Cylinder Chart.'''
    CYLINDER_STACKED : ChartType
    '''Represents Stacked Cylinder Chart.'''
    CYLINDER_100_PERCENT_STACKED : ChartType
    '''Represents 100% Stacked Cylinder Chart.'''
    CYLINDRICAL_BAR : ChartType
    '''Represents Cylindrical Bar Chart.'''
    CYLINDRICAL_BAR_STACKED : ChartType
    '''Represents Stacked Cylindrical Bar Chart.'''
    CYLINDRICAL_BAR_100_PERCENT_STACKED : ChartType
    '''Represents 100% Stacked Cylindrical Bar Chart.'''
    CYLINDRICAL_COLUMN_3D : ChartType
    '''Represents 3D Cylindrical Column Chart.'''
    DOUGHNUT : ChartType
    '''Represents Doughnut Chart.'''
    DOUGHNUT_EXPLODED : ChartType
    '''Represents Exploded Doughnut Chart.'''
    LINE : ChartType
    '''Represents Line Chart.'''
    LINE_STACKED : ChartType
    '''Represents Stacked Line Chart.'''
    LINE_100_PERCENT_STACKED : ChartType
    '''Represents 100% Stacked Line Chart.'''
    LINE_WITH_DATA_MARKERS : ChartType
    '''Represents Line Chart with data markers.'''
    LINE_STACKED_WITH_DATA_MARKERS : ChartType
    '''Represents Stacked Line Chart with data markers.'''
    LINE_100_PERCENT_STACKED_WITH_DATA_MARKERS : ChartType
    '''Represents 100% Stacked Line Chart with data markers.'''
    LINE_3D : ChartType
    '''Represents 3D Line Chart.'''
    PIE : ChartType
    '''Represents Pie Chart.'''
    PIE_3D : ChartType
    '''Represents 3D Pie Chart.'''
    PIE_PIE : ChartType
    '''Represents Pie of Pie Chart.'''
    PIE_EXPLODED : ChartType
    '''Represents Exploded Pie Chart.'''
    PIE_3D_EXPLODED : ChartType
    '''Represents 3D Exploded Pie Chart.'''
    PIE_BAR : ChartType
    '''Represents Bar of Pie Chart.'''
    PYRAMID : ChartType
    '''Represents Pyramid Chart.'''
    PYRAMID_STACKED : ChartType
    '''Represents Stacked Pyramid Chart.'''
    PYRAMID_100_PERCENT_STACKED : ChartType
    '''Represents 100% Stacked Pyramid Chart.'''
    PYRAMID_BAR : ChartType
    '''Represents Pyramid Bar Chart.'''
    PYRAMID_BAR_STACKED : ChartType
    '''Represents Stacked Pyramid Bar Chart.'''
    PYRAMID_BAR_100_PERCENT_STACKED : ChartType
    '''Represents 100% Stacked Pyramid Bar Chart.'''
    PYRAMID_COLUMN_3D : ChartType
    '''Represents 3D Pyramid Column Chart.'''
    RADAR : ChartType
    '''Represents Radar Chart.'''
    RADAR_WITH_DATA_MARKERS : ChartType
    '''Represents Radar Chart with data markers.'''
    RADAR_FILLED : ChartType
    '''Represents Filled Radar Chart.'''
    SCATTER : ChartType
    '''Represents Scatter Chart.'''
    SCATTER_CONNECTED_BY_CURVES_WITH_DATA_MARKER : ChartType
    '''Represents Scatter Chart connected by curves, with data markers.'''
    SCATTER_CONNECTED_BY_CURVES_WITHOUT_DATA_MARKER : ChartType
    '''Represents Scatter Chart connected by curves, without data markers.'''
    SCATTER_CONNECTED_BY_LINES_WITH_DATA_MARKER : ChartType
    '''Represents Scatter Chart connected by lines, with data markers.'''
    SCATTER_CONNECTED_BY_LINES_WITHOUT_DATA_MARKER : ChartType
    '''Represents Scatter Chart connected by lines, without data markers.'''
    STOCK_HIGH_LOW_CLOSE : ChartType
    '''Represents High-Low-Close Stock Chart.'''
    STOCK_OPEN_HIGH_LOW_CLOSE : ChartType
    '''Represents Open-High-Low-Close Stock Chart.'''
    STOCK_VOLUME_HIGH_LOW_CLOSE : ChartType
    '''Represents Volume-High-Low-Close Stock Chart.'''
    STOCK_VOLUME_OPEN_HIGH_LOW_CLOSE : ChartType
    '''Represents Volume-Open-High-Low-Close Stock Chart.'''
    SURFACE_3D : ChartType
    '''Represents Surface Chart: 3D Surface Chart.'''
    SURFACE_WIREFRAME_3D : ChartType
    '''Represents Wireframe 3D Surface Chart.'''
    SURFACE_CONTOUR : ChartType
    '''Represents Contour Chart.'''
    SURFACE_CONTOUR_WIREFRAME : ChartType
    '''Represents Wireframe Contour Chart.'''
    BOX_WHISKER : ChartType
    '''The series is laid out as box and whisker.'''
    FUNNEL : ChartType
    '''The series is laid out as a funnel.'''
    PARETO_LINE : ChartType
    '''The series is laid out as pareto lines.'''
    SUNBURST : ChartType
    '''The series is laid out as a sunburst.'''
    TREEMAP : ChartType
    '''The series is laid out as a treemap.'''
    WATERFALL : ChartType
    '''The series is laid out as a waterfall.'''
    HISTOGRAM : ChartType
    '''The series is laid out as a histogram.'''
    MAP : ChartType
    '''The series is laid out as a region map.'''
    RADIAL_HISTOGRAM : ChartType
    '''The series is laid out as a radial historgram. It is used only for rendering'''

class CrossType:
    '''Represents the axis cross type.'''
    
    AUTOMATIC : CrossType
    '''Microsoft Excel sets the axis crossing point.'''
    MAXIMUM : CrossType
    '''The axis crosses at the maximum value.'''
    MINIMUM : CrossType
    '''The axis crosses at the minimum value.'''
    CUSTOM : CrossType
    '''The axis crosses at the custom value.'''

class DataLabelsSeparatorType:
    '''Represents the separator type of DataLabels.'''
    
    AUTO : DataLabelsSeparatorType
    '''Represents automatic separator'''
    SPACE : DataLabelsSeparatorType
    '''Represents space(" ")'''
    COMMA : DataLabelsSeparatorType
    '''Represents comma(",")'''
    SEMICOLON : DataLabelsSeparatorType
    '''Represents semicolon(";")'''
    PERIOD : DataLabelsSeparatorType
    '''Represents period(".")'''
    NEW_LINE : DataLabelsSeparatorType
    '''Represents newline("\n")'''
    CUSTOM : DataLabelsSeparatorType
    '''Represents custom separator'''

class DisplayUnitType:
    '''Represents the type of display unit of chart\'s axis.'''
    
    NONE : DisplayUnitType
    '''Display unit is None.'''
    HUNDREDS : DisplayUnitType
    '''Specifies the values on the chart shall be divided by 100.'''
    THOUSANDS : DisplayUnitType
    '''Specifies the values on the chart shall be divided by 1,000.'''
    TEN_THOUSANDS : DisplayUnitType
    '''Specifies the values on the chart shall be divided by 10,000.'''
    HUNDRED_THOUSANDS : DisplayUnitType
    '''Specifies the values on the chart shall be divided by 100,000.'''
    MILLIONS : DisplayUnitType
    '''Specifies the values on the chart shall be divided by 1,000,000.'''
    TEN_MILLIONS : DisplayUnitType
    '''Specifies the values on the chart shall be divided by 10,000,000.'''
    HUNDRED_MILLIONS : DisplayUnitType
    '''Specifies the values on the chart shall be divided by 100,000,000.'''
    BILLIONS : DisplayUnitType
    '''Specifies the values on the chart shall be divided by 1,000,000,000.'''
    TRILLIONS : DisplayUnitType
    '''Specifies the values on the chart shall be divided by 1,000,000,000,000.'''
    PERCENTAGE : DisplayUnitType
    '''The values on the chart shall be divided by 0.01.'''
    CUST : DisplayUnitType
    '''specifies a custom value for the display unit.'''
    CUSTOM : DisplayUnitType
    '''specifies a custom value for the display unit.'''

class ErrorBarDisplayType:
    '''Represents error bar display type.'''
    
    BOTH : ErrorBarDisplayType
    '''Both'''
    MINUS : ErrorBarDisplayType
    '''Minus'''
    NONE : ErrorBarDisplayType
    '''None'''
    PLUS : ErrorBarDisplayType
    '''Plus'''

class ErrorBarType:
    '''Represents error bar amount type.'''
    
    CUSTOM : ErrorBarType
    '''InnerCustom value type.'''
    FIXED_VALUE : ErrorBarType
    '''Fixed value type.'''
    PERCENT : ErrorBarType
    '''Percentage type'''
    ST_DEV : ErrorBarType
    '''Standard deviation type.'''
    ST_ERROR : ErrorBarType
    '''Standard error type.'''

class FormattingType:
    '''Represents the type of formatting applied to an :py:class:`aspose.cells.drawing.Area` object or a :py:class:`aspose.cells.drawing.Line` object.'''
    
    AUTOMATIC : FormattingType
    '''Represents automatic formatting type.'''
    CUSTOM : FormattingType
    '''Represents custom formatting type.'''
    NONE : FormattingType
    '''Represents none formatting type.'''

class LabelPositionType:
    '''Represents data label position type.'''
    
    CENTER : LabelPositionType
    '''Applies only to bar, 2d/3d pie charts'''
    INSIDE_BASE : LabelPositionType
    '''Applies only to bar, 2d/3d pie charts'''
    INSIDE_END : LabelPositionType
    '''Applies only to bar charts'''
    OUTSIDE_END : LabelPositionType
    '''Applies only to bar, 2d/3d pie charts'''
    ABOVE : LabelPositionType
    '''Applies only to line charts'''
    BELOW : LabelPositionType
    '''Applies only to line charts'''
    LEFT : LabelPositionType
    '''Applies only to line charts'''
    RIGHT : LabelPositionType
    '''Applies only to line charts'''
    BEST_FIT : LabelPositionType
    '''Applies only to 2d/3d pie charts'''
    MOVED : LabelPositionType
    '''User moved the data labels, Only for reading chart from template file.'''

class LegendPositionType:
    '''Enumerates the legend position types.'''
    
    BOTTOM : LegendPositionType
    '''Displays the legend to the bottom of the chart\'s plot area.'''
    CORNER : LegendPositionType
    '''Displays the legend to the corner of the chart\'s plot area.'''
    LEFT : LegendPositionType
    '''Displays the legend to the left of the chart\'s plot area.'''
    NOT_DOCKED : LegendPositionType
    '''Represents that the legend is not docked.'''
    RIGHT : LegendPositionType
    '''Displays the legend to the right of the chart\'s plot area.'''
    TOP : LegendPositionType
    '''Displays the legend to the top of the chart\'s plot area.'''

class MapChartLabelLayout:
    '''Represents the layout of map chart\'s labels.'''
    
    BEST_FIT_ONLY : MapChartLabelLayout
    '''Only best fit.'''
    SHOW_ALL : MapChartLabelLayout
    '''Shows all labels.'''
    NONE : MapChartLabelLayout
    '''No labels.'''

class MapChartProjectionType:
    '''Represents projection type of the map chart.'''
    
    AUTOMATIC : MapChartProjectionType
    '''Automatic'''
    MERCATOR : MapChartProjectionType
    '''Mercator'''
    MILLER : MapChartProjectionType
    '''Miller'''
    ALBERS : MapChartProjectionType
    '''Albers'''

class MapChartRegionType:
    '''Represents the region type of the map chart.'''
    
    AUTOMATIC : MapChartRegionType
    '''Automatic'''
    DATA_ONLY : MapChartRegionType
    '''Only Data.'''
    COUNTRY_REGION_LIST : MapChartRegionType
    '''Country region list.'''
    WORLD : MapChartRegionType
    '''World.'''

class PlotDataByType:
    '''Represents the type of data plot by row or column.'''
    
    ROW : PlotDataByType
    '''By row.'''
    COLUMN : PlotDataByType
    '''By column.'''

class PlotEmptyCellsType:
    '''Represents all plot empty cells type of a chart.'''
    
    NOT_PLOTTED : PlotEmptyCellsType
    '''Not plotted(leave gap)'''
    ZERO : PlotEmptyCellsType
    '''Zero'''
    INTERPOLATED : PlotEmptyCellsType
    '''Interpolated'''

class QuartileCalculationType:
    '''Represents quartile calculation methods.'''
    
    EXCLUSIVE : QuartileCalculationType
    '''The quartile calculation includes the median when splitting the dataset into quartiles.'''
    INCLUSIVE : QuartileCalculationType
    '''The quartile calculation excludes the median when splitting the dataset into quartiles.'''

class SparklineAxisMinMaxType:
    '''Represents the minimum and maximum value types for the sparkline vertical axis.'''
    
    AUTO_INDIVIDUAL : SparklineAxisMinMaxType
    '''Automatic for each sparkline.'''
    GROUP : SparklineAxisMinMaxType
    '''Same for all sparklines in the group.'''
    CUSTOM : SparklineAxisMinMaxType
    '''Custom value for sparkline.'''

class SparklinePresetStyleType:
    '''Represents the preset style types for sparkline.'''
    
    STYLE1 : SparklinePresetStyleType
    '''Style 1'''
    STYLE2 : SparklinePresetStyleType
    '''Style 2'''
    STYLE3 : SparklinePresetStyleType
    '''Style 3'''
    STYLE4 : SparklinePresetStyleType
    '''Style 4'''
    STYLE5 : SparklinePresetStyleType
    '''Style 5'''
    STYLE6 : SparklinePresetStyleType
    '''Style 6'''
    STYLE7 : SparklinePresetStyleType
    '''Style 7'''
    STYLE8 : SparklinePresetStyleType
    '''Style 8'''
    STYLE9 : SparklinePresetStyleType
    '''Style 9'''
    STYLE10 : SparklinePresetStyleType
    '''Style 10'''
    STYLE11 : SparklinePresetStyleType
    '''Style 11'''
    STYLE12 : SparklinePresetStyleType
    '''Style 12'''
    STYLE13 : SparklinePresetStyleType
    '''Style 13'''
    STYLE14 : SparklinePresetStyleType
    '''Style 14'''
    STYLE15 : SparklinePresetStyleType
    '''Style 15'''
    STYLE16 : SparklinePresetStyleType
    '''Style 16'''
    STYLE17 : SparklinePresetStyleType
    '''Style 17'''
    STYLE18 : SparklinePresetStyleType
    '''Style 18'''
    STYLE19 : SparklinePresetStyleType
    '''Style 19'''
    STYLE20 : SparklinePresetStyleType
    '''Style 20'''
    STYLE21 : SparklinePresetStyleType
    '''Style 21'''
    STYLE22 : SparklinePresetStyleType
    '''Style 22'''
    STYLE23 : SparklinePresetStyleType
    '''Style 23'''
    STYLE24 : SparklinePresetStyleType
    '''Style 24'''
    STYLE25 : SparklinePresetStyleType
    '''Style 25'''
    STYLE26 : SparklinePresetStyleType
    '''Style 26'''
    STYLE27 : SparklinePresetStyleType
    '''Style 27'''
    STYLE28 : SparklinePresetStyleType
    '''Style 28'''
    STYLE29 : SparklinePresetStyleType
    '''Style 29'''
    STYLE30 : SparklinePresetStyleType
    '''Style 30'''
    STYLE31 : SparklinePresetStyleType
    '''Style 31'''
    STYLE32 : SparklinePresetStyleType
    '''Style 32'''
    STYLE33 : SparklinePresetStyleType
    '''Style 33'''
    STYLE34 : SparklinePresetStyleType
    '''Style 34'''
    STYLE35 : SparklinePresetStyleType
    '''Style 35'''
    STYLE36 : SparklinePresetStyleType
    '''Style 36'''
    CUSTOM : SparklinePresetStyleType
    '''No preset style.'''

class SparklineType:
    '''Represents the sparkline types.'''
    
    LINE : SparklineType
    '''Line sparkline.'''
    COLUMN : SparklineType
    '''Column sparkline.'''
    STACKED : SparklineType
    '''Win/Loss sparkline.'''

class TickLabelAlignmentType:
    '''Represents the text alignment type for the tick labels on the axis'''
    
    CENTER : TickLabelAlignmentType
    '''Represents the text shall be centered.'''
    LEFT : TickLabelAlignmentType
    '''Represents the text shall be left justified.'''
    RIGHT : TickLabelAlignmentType
    '''Represents the text shall be right justified.'''

class TickLabelPositionType:
    '''Represents the position type of tick-mark labels on the specified axis.'''
    
    HIGH : TickLabelPositionType
    '''Position type is high.'''
    LOW : TickLabelPositionType
    '''Position type is low.'''
    NEXT_TO_AXIS : TickLabelPositionType
    '''Position type is next to axis.'''
    NONE : TickLabelPositionType
    '''Position type is none.'''

class TickMarkType:
    '''Represents the tick mark type for the specified axis.'''
    
    CROSS : TickMarkType
    '''Tick mark type is Cross.'''
    INSIDE : TickMarkType
    '''Tick mark type is Inside.'''
    NONE : TickMarkType
    '''Tick mark type is None.'''
    OUTSIDE : TickMarkType
    '''Tick mark type is Outside'''

class TimeUnit:
    '''Represents the base unit for the category axis.'''
    
    DAYS : TimeUnit
    '''Days'''
    MONTHS : TimeUnit
    '''Months'''
    YEARS : TimeUnit
    '''Years'''

class TrendlineType:
    '''Represents the trendline type.'''
    
    EXPONENTIAL : TrendlineType
    '''Exponential'''
    LINEAR : TrendlineType
    '''Linear'''
    LOGARITHMIC : TrendlineType
    '''Logarithmic'''
    MOVING_AVERAGE : TrendlineType
    '''MovingAverage'''
    POLYNOMIAL : TrendlineType
    '''Polynomial'''
    POWER : TrendlineType
    '''Power'''

