/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.charting.colors;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import kg.apc.charting.ColorsDispatcher;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class CycleColors
implements ColorsDispatcher {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private List<Color> assignedColors = new ArrayList<Color>();
    private static final int LEVEL_MAX = 256;
    private int level;
    private int bits;
    private int increment;

    public CycleColors() {
        this.reset();
    }

    @Override
    public void reset() {
        this.assignedColors.clear();
        this.increment = 256;
        this.bits = 0;
        this.level = 255;
        this.assignedColors.add(new Color(255, 255, 0));
        this.assignedColors.add(new Color(127, 127, 0));
    }

    @Override
    public Color getNextColor() {
        Color c;
        Color color = null;
        this.doCycles();
        int r = 0;
        int g = 0;
        int b = 0;
        if ((this.bits & 1) == 1) {
            r = this.level;
        }
        if ((this.bits & 2) == 2) {
            b = this.level;
        }
        if ((this.bits & 4) == 4) {
            g = this.level;
        }
        if (this.assignedColors.contains(c = new Color(r, g, b))) {
            if (log.isDebugEnabled()) {
                log.debug("Existing " + r + " " + g + " " + b);
            }
            color = this.getNextColor();
        } else if ((r + g + b) / 3 < 32) {
            if (log.isDebugEnabled()) {
                log.debug("Too dark " + r + " " + g + " " + b);
            }
            color = this.getNextColor();
        } else if ((r + g + b) / 3 > 192) {
            if (log.isDebugEnabled()) {
                log.debug("Too light " + r + " " + g + " " + b);
            }
            color = this.getNextColor();
        } else {
            if (log.isDebugEnabled()) {
                log.debug("New " + r + " " + g + " " + b);
            }
            color = new Color(r, g, b);
        }
        this.assignedColors.add(color);
        return color;
    }

    private void doCycles() {
        ++this.bits;
        if (this.bits >= 8) {
            this.level -= this.increment;
            if (this.level < 0) {
                this.increment /= 2;
                if (this.increment <= 0) {
                    log.warn("Colors exceeded. Rewind colors.");
                    this.reset();
                }
                this.level = 255;
            }
            this.bits = 0;
        }
    }
}

