/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.apache.jmeter.gui.util.PowerTableModel;

public class DeleteRowAction
implements ActionListener {
    private JTable grid;
    private PowerTableModel tableModel;
    private JButton deleteRowButton;
    private final JComponent sender;

    public DeleteRowAction(JComponent aSender, JTable grid, PowerTableModel tableModel, JButton deleteRowButton) {
        this.grid = grid;
        this.tableModel = tableModel;
        this.deleteRowButton = deleteRowButton;
        this.sender = aSender;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int rowSelected;
        if (this.grid.isEditing()) {
            TableCellEditor cellEditor = this.grid.getCellEditor(this.grid.getEditingRow(), this.grid.getEditingColumn());
            cellEditor.cancelCellEditing();
        }
        if ((rowSelected = this.grid.getSelectedRow()) >= 0) {
            this.tableModel.removeRow(rowSelected);
            this.tableModel.fireTableDataChanged();
            if (this.tableModel.getRowCount() == 0) {
                this.deleteRowButton.setEnabled(false);
            } else {
                int rowToSelect = rowSelected;
                if (rowSelected >= this.tableModel.getRowCount()) {
                    rowToSelect = rowSelected - 1;
                }
                this.grid.setRowSelectionInterval(rowToSelect, rowToSelect);
            }
            this.sender.updateUI();
        }
    }
}

