"""
Number of syllables in many words based on CMU Pronouncing Dictionary from
https://cmusphinx.svn.sourceforge.net/svnroot/cmusphinx/trunk/cmudict/cmudict.0.7a
"""

SYLLABLES = {
    "a": 1,
    "a(1)": 1,
    "a's": 1,
    "a.": 1,
    "a.'s": 1,
    "a.s": 1,
    "a42128": 6,
    "aaa": 3,
    "aaberg": 2,
    "aachen": 2,
    "aachener": 3,
    "aaker": 2,
    "aalseth": 2,
    "aamodt": 2,
    "aancor": 2,
    "aardema": 3,
    "aardvark": 2,
    "aaron": 2,
    "aaron's": 2,
    "aarons": 2,
    "aaronson": 3,
    "aaronson(1)": 3,
    "aaronson's": 3,
    "aaronson's(1)": 3,
    "aarti": 2,
    "aase": 1,
    "aasen": 2,
    "ab": 1,
    "ab(1)": 2,
    "ababa": 3,
    "ababa(1)": 3,
    "abacha": 3,
    "aback": 2,
    "abaco": 3,
    "abacus": 3,
    "abad": 2,
    "abadaka": 4,
    "abadi": 3,
    "abadie": 3,
    "abair": 2,
    "abalkin": 3,
    "abalone": 4,
    "abalos": 3,
    "abandon": 3,
    "abandoned": 3,
    "abandoning": 4,
    "abandonment": 4,
    "abandonments": 4,
    "abandons": 3,
    "abanto": 3,
    "abarca": 3,
    "abare": 3,
    "abascal": 3,
    "abash": 2,
    "abashed": 2,
    "abasia": 3,
    "abate": 2,
    "abated": 3,
    "abatement": 3,
    "abatements": 3,
    "abates": 2,
    "abating": 3,
    "abba": 2,
    "abbado": 3,
    "abbas": 2,
    "abbasi": 3,
    "abbate": 2,
    "abbatiello": 5,
    "abbe": 2,
    "abbe(1)": 2,
    "abbenhaus": 3,
    "abbett": 2,
    "abbeville": 2,
    "abbey": 2,
    "abbey's": 2,
    "abbie": 2,
    "abbitt": 2,
    "abbot": 2,
    "abbotstown": 3,
    "abbott": 2,
    "abbott's": 2,
    "abbottstown": 3,
    "abboud": 2,
    "abboud(1)": 2,
    "abbreviate": 4,
    "abbreviated": 5,
    "abbreviated(1)": 5,
    "abbreviates": 4,
    "abbreviating": 5,
    "abbreviation": 5,
    "abbreviations": 5,
    "abbruzzese": 4,
    "abbs": 1,
    "abby": 2,
    "abco": 2,
    "abcotek": 3,
    "abdalla": 3,
    "abdallah": 3,
    "abdel": 2,
    "abdella": 3,
    "abdicate": 3,
    "abdicated": 4,
    "abdicates": 3,
    "abdicating": 4,
    "abdication": 4,
    "abdnor": 2,
    "abdo": 2,
    "abdollah": 3,
    "abdomen": 3,
    "abdomen(1)": 3,
    "abdominal": 4,
    "abdominal(1)": 4,
    "abduct": 2,
    "abducted": 3,
    "abducted(1)": 3,
    "abductee": 3,
    "abductees": 3,
    "abducting": 3,
    "abducting(1)": 3,
    "abduction": 3,
    "abduction(1)": 3,
    "abductions": 3,
    "abductions(1)": 3,
    "abductor": 3,
    "abductor(1)": 3,
    "abductors": 3,
    "abductors(1)": 3,
    "abducts": 2,
    "abdul": 2,
    "abdulaziz": 4,
    "abdulla": 3,
    "abdullah": 3,
    "abe": 1,
    "abed": 2,
    "abedi": 3,
    "abee": 2,
    "abel": 2,
    "abela": 3,
    "abelard": 3,
    "abele": 2,
    "abeles": 2,
    "abeles(1)": 3,
    "abell": 2,
    "abella": 3,
    "abeln": 2,
    "abelow": 3,
    "abels": 2,
    "abelson": 3,
    "abend": 2,
    "abend(1)": 2,
    "abendroth": 3,
    "aber": 2,
    "abercrombie": 4,
    "aberdeen": 3,
    "aberford": 3,
    "aberg": 2,
    "aberle": 3,
    "aberle(1)": 2,
    "abermin": 3,
    "abernathy": 4,
    "abernethy": 4,
    "aberrant": 3,
    "aberration": 4,
    "aberrational": 5,
    "aberrations": 4,
    "abert": 2,
    "abet": 2,
    "abetted": 3,
    "abetting": 3,
    "abex": 2,
    "abeyance": 3,
    "abeyta": 3,
    "abhor": 2,
    "abhorred": 2,
    "abhorrence": 3,
    "abhorrent": 3,
    "abhors": 2,
    "abiam": 3,
    "abiam's": 3,
    "abid": 2,
    "abide": 2,
    "abided": 3,
    "abides": 2,
    "abiding": 3,
    "abidjan": 3,
    "abie": 2,
    "abigail": 3,
    "abila": 3,
    "abilene": 3,
    "abilities": 4,
    "ability": 4,
    "abimael": 3,
    "abimaels": 3,
    "abingdon": 3,
    "abington": 3,
    "abio": 3,
    "abiola": 4,
    "abiola's": 4,
    "abiomed": 4,
    "abiquiu": 3,
    "abitibi": 4,
    "abitz": 2,
    "abject": 2,
    "abkhazia": 3,
    "abkhazia(1)": 3,
    "abkhazian": 4,
    "abkhazian(1)": 4,
    "abkhazian(2)": 3,
    "abkhazian(3)": 3,
    "abkhazians": 4,
    "abkhazians(1)": 4,
    "ablaze": 2,
    "able": 2,
    "able-bodied": 4,
    "abled": 2,
    "abler": 3,
    "abler(1)": 2,
    "ables": 2,
    "ablest": 2,
    "ablest(1)": 2,
    "abloom": 2,
    "ably": 2,
    "abner": 2,
    "abney": 2,
    "abnormal": 3,
    "abnormalities": 5,
    "abnormality": 5,
    "abnormally": 4,
    "abo": 2,
    "abo's": 2,
    "aboard": 2,
    "abode": 2,
    "abohalima": 5,
    "abolish": 3,
    "abolished": 3,
    "abolishes": 4,
    "abolishing": 4,
    "abolition": 4,
    "abolitionism": 6,
    "abolitionist": 5,
    "abolitionists": 5,
    "abolitionists(1)": 5,
    "abominable": 5,
    "abomination": 5,
    "abood": 2,
    "aboodi": 3,
    "abor": 2,
    "aboriginal": 5,
    "aborigine": 5,
    "aborigines": 5,
    "aborn": 2,
    "abort": 2,
    "aborted": 3,
    "abortifacient": 5,
    "abortifacients": 5,
    "aborting": 3,
    "abortion": 3,
    "abortionist": 4,
    "abortionists": 4,
    "abortionists(1)": 4,
    "abortions": 3,
    "abortive": 3,
    "aborts": 2,
    "abott": 2,
    "abou": 2,
    "aboud": 2,
    "abouhalima": 5,
    "abouhalima's": 5,
    "abound": 2,
    "abounded": 3,
    "abounding": 3,
    "abounds": 2,
    "about": 2,
    "about's": 2,
    "above": 2,
    "above's": 2,
    "aboveboard": 3,
    "abplanalp": 3,
    "abra": 2,
    "abracadabra": 5,
    "abraham": 3,
    "abrahamian": 5,
    "abrahams": 3,
    "abrahamsen": 4,
    "abrahamson": 4,
    "abram": 2,
    "abram's": 2,
    "abramczyk": 3,
    "abramo": 3,
    "abramovitz": 4,
    "abramowicz": 4,
    "abramowitz": 4,
    "abrams": 2,
    "abrams's": 3,
    "abramson": 3,
    "abrasion": 3,
    "abrasions": 3,
    "abrasive": 3,
    "abrasives": 3,
    "abraxa": 3,
    "abraxa's": 3,
    "abraxas": 3,
    "abreast": 2,
    "abrego": 3,
    "abreu": 2,
    "abridge": 2,
    "abridged": 2,
    "abridgement": 3,
    "abridges": 3,
    "abridging": 3,
    "abril": 2,
    "abroad": 2,
    "abrogate": 3,
    "abrogated": 4,
    "abrogating": 4,
    "abrogation": 4,
    "abrol": 2,
    "abron": 2,
    "abrupt": 2,
    "abruptly": 3,
    "abruptness": 3,
    "abrutyn": 3,
    "abruzzese": 4,
    "abruzzo": 3,
    "abs": 3,
    "abs(1)": 1,
    "absalom": 3,
    "absaraka": 4,
    "abscam": 2,
    "abscess": 2,
    "abscond": 2,
    "absconded": 3,
    "absconding": 3,
    "absconds": 2,
    "absecon": 3,
    "absence": 2,
    "absences": 3,
    "absent": 2,
    "absentee": 3,
    "absenteeism": 5,
    "absentees": 3,
    "absentia": 3,
    "absher": 2,
    "abshier": 3,
    "abshire": 2,
    "absinthe": 2,
    "abso": 2,
    "absolom": 3,
    "absolut": 3,
    "absolut's": 3,
    "absolute": 3,
    "absolutely": 4,
    "absoluteness": 4,
    "absolutes": 3,
    "absolution": 4,
    "absolutism": 5,
    "absolutist": 4,
    "absolve": 2,
    "absolve(1)": 2,
    "absolved": 2,
    "absolved(1)": 2,
    "absolves": 2,
    "absolves(1)": 2,
    "absolving": 3,
    "absolving(1)": 3,
    "absorb": 2,
    "absorbed": 2,
    "absorbency": 4,
    "absorbent": 3,
    "absorber": 3,
    "absorbers": 3,
    "absorbing": 3,
    "absorbs": 2,
    "absorption": 3,
    "absorption(1)": 3,
    "abstain": 2,
    "abstain(1)": 2,
    "abstained": 2,
    "abstained(1)": 2,
    "abstaining": 3,
    "abstaining(1)": 3,
    "abstention": 3,
    "abstention(1)": 3,
    "abstentions": 3,
    "abstentions(1)": 3,
    "abstinence": 3,
    "abstinent": 3,
    "abston": 2,
    "abstract": 2,
    "abstract(1)": 2,
    "abstracted": 3,
    "abstraction": 3,
    "abstractions": 3,
    "abstracts": 2,
    "abstruse": 2,
    "absurd": 2,
    "absurdist": 3,
    "absurdities": 4,
    "absurdity": 4,
    "absurdly": 3,
    "abt": 1,
    "abt(1)": 3,
    "abts": 1,
    "abts(1)": 3,
    "abts(2)": 4,
    "abu": 2,
    "abudrahm": 3,
    "abuellah": 3,
    "abuellah's": 3,
    "abuladze": 4,
    "abundance": 3,
    "abundant": 3,
    "abundantly": 4,
    "aburto": 3,
    "aburto's": 3,
    "abuse": 2,
    "abuse(1)": 2,
    "abused": 2,
    "abuser": 3,
    "abusers": 3,
    "abuses": 3,
    "abuses(1)": 3,
    "abusing": 3,
    "abusive": 3,
    "abut": 2,
    "abuts": 2,
    "abutted": 3,
    "abutting": 3,
    "abuzz": 2,
    "abysmal": 3,
    "abysmally": 4,
    "abyss": 2,
    "abyssinia": 4,
    "abyssinian": 4,
    "abzug": 2,
    "abzug(1)": 2,
    "ac": 2,
    "aca": 2,
    "acacia": 3,
    "academe": 3,
    "academia": 5,
    "academic": 4,
    "academically": 5,
    "academician": 5,
    "academicians": 5,
    "academicians(1)": 5,
    "academics": 4,
    "academies": 4,
    "academy": 4,
    "academy's": 4,
    "acadia": 4,
    "acampo": 3,
    "acampora": 4,
    "acampsia": 3,
    "acantha": 3,
    "acapulco": 4,
    "acary": 3,
    "accardi": 3,
    "accardo": 3,
    "accede": 2,
    "acceded": 3,
    "accedes": 2,
    "acceding": 3,
    "accel": 2,
    "accelerant": 4,
    "accelerants": 4,
    "accelerate": 4,
    "accelerated": 5,
    "accelerates": 4,
    "accelerating": 5,
    "acceleration": 5,
    "accelerator": 5,
    "accelerators": 5,
    "accelerometer": 6,
    "accelerometers": 6,
    "accent": 2,
    "accent(1)": 2,
    "accented": 3,
    "accenting": 3,
    "accents": 2,
    "accentuate": 4,
    "accentuated": 5,
    "accentuates": 4,
    "accentuating": 5,
    "accept": 2,
    "accept(1)": 2,
    "acceptability": 6,
    "acceptable": 4,
    "acceptable(1)": 4,
    "acceptably": 4,
    "acceptably(1)": 4,
    "acceptance": 3,
    "acceptance(1)": 3,
    "acceptances": 4,
    "accepted": 3,
    "accepted(1)": 3,
    "accepting": 3,
    "accepting(1)": 3,
    "accepts": 2,
    "access": 2,
    "accessed": 2,
    "accessibility": 6,
    "accessible": 4,
    "accessing": 3,
    "accession": 3,
    "accessories": 4,
    "accessorize": 4,
    "accessorized": 4,
    "accessory": 4,
    "accetta": 3,
    "accident": 3,
    "accident's": 3,
    "accidental": 4,
    "accidental(1)": 4,
    "accidentally": 5,
    "accidentally(1)": 5,
    "accidently": 4,
    "accidents": 3,
    "accion": 3,
    "accival": 3,
    "acclaim": 2,
    "acclaim's": 2,
    "acclaimed": 2,
    "acclaiming": 3,
    "acclaims": 2,
    "acclamation": 4,
    "acclimate": 3,
    "acclimated": 4,
    "acclimation": 4,
    "acco": 2,
    "accokeek": 3,
    "accola": 3,
    "accolade": 3,
    "accolades": 3,
    "accomando": 4,
    "accommodate": 4,
    "accommodated": 5,
    "accommodates": 4,
    "accommodating": 5,
    "accommodation": 5,
    "accommodations": 5,
    "accommodative": 5,
    "accompanied": 4,
    "accompanies": 4,
    "accompaniment": 4,
    "accompaniment(1)": 4,
    "accompaniments": 4,
    "accompaniments(1)": 4,
    "accompanist": 4,
    "accompany": 4,
    "accompanying": 5,
    "accompli": 3,
    "accompli(1)": 3,
    "accomplice": 3,
    "accomplices": 4,
    "accomplish": 3,
    "accomplished": 3,
    "accomplishes": 4,
    "accomplishing": 4,
    "accomplishment": 4,
    "accomplishments": 4,
    "accor": 2,
    "accor's": 2,
    "accord": 2,
    "accord's": 2,
    "accordance": 3,
    "accorded": 3,
    "according": 3,
    "accordingly": 4,
    "accordion": 4,
    "accordions": 4,
    "accords": 2,
    "accost": 2,
    "accosted": 3,
    "accosting": 3,
    "account": 2,
    "account's": 2,
    "accountability": 6,
    "accountability(1)": 6,
    "accountable": 4,
    "accountable(1)": 4,
    "accountancy": 4,
    "accountant": 3,
    "accountant's": 3,
    "accountants": 3,
    "accountants'": 3,
    "accounted": 3,
    "accounted(1)": 3,
    "accountemp": 3,
    "accountemps": 3,
    "accounting": 3,
    "accounting(1)": 3,
    "accounts": 2,
    "accouterment": 4,
    "accouterments": 4,
    "accoutrement": 4,
    "accoutrements": 4,
    "accredit": 3,
    "accreditation": 5,
    "accreditations": 5,
    "accredited": 4,
    "accrediting": 4,
    "accreted": 3,
    "accretion": 3,
    "accrual": 3,
    "accruals": 3,
    "accrue": 2,
    "accrued": 2,
    "accrues": 2,
    "accruing": 3,
    "accu": 2,
    "accuhealth": 3,
    "accumulate": 4,
    "accumulated": 5,
    "accumulates": 4,
    "accumulating": 5,
    "accumulation": 5,
    "accumulations": 5,
    "accumulative": 5,
    "accumulatively": 6,
    "accumulatively(1)": 6,
    "accumulator": 5,
    "accumulators": 5,
    "accuracies": 4,
    "accuracy": 4,
    "accurate": 3,
    "accurately": 4,
    "accuray": 3,
    "accuray's": 3,
    "accuride": 3,
    "accurso": 3,
    "accusation": 4,
    "accusation(1)": 4,
    "accusations": 4,
    "accusations(1)": 4,
    "accusative": 4,
    "accusatory": 5,
    "accuse": 2,
    "accused": 2,
    "accuser": 3,
    "accusers": 3,
    "accuses": 3,
    "accusing": 3,
    "accusingly": 4,
    "accustom": 3,
    "accustomed": 3,
    "accutane": 3,
    "ace": 1,
    "acecomm": 2,
    "aced": 1,
    "acer": 2,
    "acerbic": 3,
    "acero": 3,
    "acero(1)": 3,
    "acero(2)": 3,
    "acerra": 3,
    "aces": 2,
    "acetaminophen": 6,
    "acetate": 3,
    "acetic": 3,
    "acetic(1)": 3,
    "aceto": 3,
    "acetochlor": 4,
    "acetone": 3,
    "acetosyringone": 6,
    "acetylcholine": 5,
    "acetylcholine(1)": 5,
    "acetylene": 4,
    "acevedo": 4,
    "aceves": 3,
    "acey": 2,
    "achaean": 3,
    "achatz": 2,
    "ache": 1,
    "achebe": 3,
    "ached": 1,
    "achee": 2,
    "achenbach": 3,
    "achenbaum": 3,
    "aches": 1,
    "acheson": 3,
    "acheson's": 3,
    "achesons": 3,
    "achey": 2,
    "achieva": 3,
    "achievable": 4,
    "achieve": 2,
    "achieved": 2,
    "achievement": 3,
    "achievements": 3,
    "achiever": 3,
    "achievers": 3,
    "achieves": 2,
    "achieving": 3,
    "achille": 3,
    "achilles": 3,
    "achilles'": 3,
    "aching": 2,
    "achingly": 3,
    "achmed": 2,
    "achoa": 3,
    "achoa's": 3,
    "achor": 2,
    "achord": 2,
    "achorn": 2,
    "achtenberg": 3,
    "achterberg": 3,
    "achy": 2,
    "acid": 2,
    "acidic": 3,
    "acidification": 6,
    "acidified": 4,
    "acidifies": 4,
    "acidify": 4,
    "acidity": 4,
    "acidly": 3,
    "acidosis": 4,
    "acids": 2,
    "aciduria": 5,
    "acierno": 3,
    "ack": 1,
    "acker": 2,
    "acker's": 2,
    "ackerley": 3,
    "ackerly": 3,
    "ackerman": 3,
    "ackermann": 3,
    "ackermanville": 4,
    "ackerson": 3,
    "ackert": 2,
    "ackhouse": 2,
    "ackland": 2,
    "ackles": 2,
    "ackley": 2,
    "acklin": 2,
    "ackman": 2,
    "acknowledge": 3,
    "acknowledge(1)": 3,
    "acknowledgeable": 5,
    "acknowledgeable(1)": 5,
    "acknowledged": 3,
    "acknowledged(1)": 3,
    "acknowledgement": 4,
    "acknowledgement(1)": 4,
    "acknowledgements": 4,
    "acknowledgements(1)": 4,
    "acknowledges": 4,
    "acknowledges(1)": 4,
    "acknowledging": 4,
    "acknowledging(1)": 4,
    "acknowledgment": 4,
    "acknowledgment(1)": 4,
    "ackroyd": 2,
    "ackroyd's": 2,
    "acmat": 2,
    "acmat's": 2,
    "acme": 2,
    "acme's": 2,
    "acne": 2,
    "acocella": 4,
    "acoff": 2,
    "acog": 2,
    "acolyte": 3,
    "acolytes": 3,
    "acord": 2,
    "acordia": 4,
    "acorn": 2,
    "acorn's": 2,
    "acorns": 2,
    "acosta": 3,
    "acott": 2,
    "acoustic": 3,
    "acoustical": 4,
    "acoustically": 4,
    "acoustics": 3,
    "acquaint": 2,
    "acquaintance": 3,
    "acquaintances": 4,
    "acquaintanceship": 4,
    "acquainted": 3,
    "acquainted(1)": 3,
    "acquaviva": 4,
    "acquiesce": 3,
    "acquiesced": 3,
    "acquiescence": 4,
    "acquiescing": 4,
    "acquire": 3,
    "acquired": 3,
    "acquirer": 4,
    "acquirer's": 4,
    "acquirers": 4,
    "acquires": 3,
    "acquiring": 3,
    "acquiring(1)": 4,
    "acquisition": 4,
    "acquisition's": 4,
    "acquisitions": 4,
    "acquisitive": 4,
    "acquit": 2,
    "acquitaine": 3,
    "acquits": 2,
    "acquittal": 3,
    "acquittals": 3,
    "acquitted": 3,
    "acquitted(1)": 3,
    "acquitting": 3,
    "acre": 2,
    "acreage": 3,
    "acreage(1)": 2,
    "acree": 2,
    "acres": 2,
    "acrey": 2,
    "acri": 2,
    "acrid": 2,
    "acrimonious": 5,
    "acrimony": 4,
    "acro": 2,
    "acrobat": 3,
    "acrobatic": 4,
    "acrobatics": 4,
    "acrobats": 3,
    "acrolein": 3,
    "acronym": 3,
    "acronyms": 3,
    "acropolis": 4,
    "across": 2,
    "acrylic": 3,
    "acrylics": 3,
    "act": 1,
    "act's": 1,
    "actava": 3,
    "actava's": 3,
    "actavas": 3,
    "acted": 2,
    "acted(1)": 2,
    "actel": 2,
    "actigall": 3,
    "actin": 2,
    "acting": 2,
    "actinide": 3,
    "actinidia": 5,
    "actinomycosis": 6,
    "action": 2,
    "action's": 2,
    "actionable": 4,
    "actions": 2,
    "activase": 3,
    "activate": 3,
    "activated": 4,
    "activated(1)": 4,
    "activates": 3,
    "activating": 4,
    "activation": 4,
    "activator": 4,
    "active": 2,
    "active's": 2,
    "actively": 3,
    "actives": 2,
    "activision": 4,
    "activism": 4,
    "activist": 3,
    "activist(1)": 3,
    "activists": 3,
    "activists(1)": 3,
    "activists(2)": 3,
    "activists(3)": 3,
    "activists'": 3,
    "activists'(1)": 3,
    "activities": 4,
    "activities(1)": 4,
    "activity": 4,
    "activity(1)": 4,
    "actmedia": 4,
    "actodine": 3,
    "acton": 2,
    "actor": 2,
    "actor's": 2,
    "actors": 2,
    "actors'": 2,
    "actress": 2,
    "actress's": 3,
    "actresses": 3,
    "acts": 1,
    "acts(1)": 1,
    "actual": 3,
    "actual(1)": 2,
    "actuality": 5,
    "actualize": 4,
    "actually": 4,
    "actually(1)": 2,
    "actually(2)": 3,
    "actuarial": 5,
    "actuaries": 4,
    "actuary": 4,
    "actuate": 3,
    "actuator": 4,
    "actuator(1)": 4,
    "actuators": 4,
    "actuators(1)": 4,
    "actus": 2,
    "acuff": 2,
    "acuity": 4,
    "acumen": 3,
    "acuna": 3,
    "acupuncture": 4,
    "acura": 3,
    "acura's": 3,
    "acuras": 3,
    "acuson": 3,
    "acustar": 3,
    "acusyst": 3,
    "acute": 2,
    "acutely": 3,
    "acuteness": 3,
    "acyclovir": 4,
    "ad": 1,
    "ad's": 1,
    "ad-hoc": 2,
    "ad-lib": 2,
    "ad-nauseum": 4,
    "ada": 2,
    "ada's": 2,
    "adabel": 3,
    "adabelle": 3,
    "adachi": 3,
    "adage": 2,
    "adage(1)": 2,
    "adagio": 4,
    "adah": 2,
    "adair": 2,
    "adaire": 2,
    "adak": 2,
    "adalah": 3,
    "adalia": 4,
    "adam": 2,
    "adam's": 2,
    "adamant": 3,
    "adamantly": 4,
    "adamcik": 3,
    "adamczak": 3,
    "adamczyk": 3,
    "adame": 3,
    "adamec": 3,
    "adamek": 3,
    "adames": 2,
    "adami": 3,
    "adamik": 3,
    "adamina": 4,
    "adamkus": 3,
    "adamo": 3,
    "adamowicz": 4,
    "adams": 2,
    "adams'": 2,
    "adams's": 3,
    "adamski": 3,
    "adamson": 3,
    "adamstown": 3,
    "adan": 2,
    "adapso": 3,
    "adapt": 2,
    "adaptability": 6,
    "adaptable": 4,
    "adaptaplex": 4,
    "adaptation": 4,
    "adaptations": 4,
    "adaptations(1)": 4,
    "adaptec": 3,
    "adaptec's": 3,
    "adapted": 3,
    "adapted(1)": 3,
    "adapter": 3,
    "adapters": 3,
    "adapting": 3,
    "adaptive": 3,
    "adaptor": 3,
    "adaptors": 3,
    "adapts": 2,
    "adar": 2,
    "adarand": 3,
    "adas": 2,
    "aday": 2,
    "adaza": 3,
    "adcock": 2,
    "adcox": 2,
    "add": 1,
    "addair": 2,
    "addams": 2,
    "added": 2,
    "added(1)": 2,
    "addendum": 3,
    "addendums": 3,
    "addeo": 3,
    "adder": 2,
    "adderley": 3,
    "addicks": 2,
    "addict": 2,
    "addict(1)": 2,
    "addicted": 3,
    "addicted(1)": 3,
    "addicting": 3,
    "addiction": 3,
    "addictions": 3,
    "addictive": 3,
    "addicts": 2,
    "addicts(1)": 2,
    "addidas": 3,
    "addidas'": 3,
    "addidas's": 4,
    "addidases": 4,
    "addie": 2,
    "adding": 2,
    "addington": 3,
    "addis": 2,
    "addis-ababa": 5,
    "addis-ababa(1)": 5,
    "addison": 3,
    "addison(1)": 3,
    "addison's": 3,
    "addition": 3,
    "additional": 4,
    "additional(1)": 3,
    "additionally": 5,
    "additionally(1)": 4,
    "additions": 3,
    "additive": 3,
    "additive(1)": 3,
    "additives": 3,
    "additives(1)": 3,
    "addle": 2,
    "addled": 2,
    "addleman": 3,
    "address": 2,
    "address(1)": 2,
    "addressable": 4,
    "addressed": 2,
    "addressee": 3,
    "addresses": 3,
    "addresses(1)": 3,
    "addressing": 3,
    "adds": 1,
    "adduci": 3,
    "adduct": 2,
    "addwest": 2,
    "addy": 2,
    "addyston": 3,
    "ade": 1,
    "adee": 2,
    "adel": 2,
    "adela": 3,
    "adelaar": 3,
    "adelaide": 3,
    "adelanto": 4,
    "adelbert": 3,
    "adele": 2,
    "adele's": 2,
    "adeline": 3,
    "adelizzi": 4,
    "adell": 2,
    "adell's": 2,
    "adelle": 2,
    "adelman": 3,
    "adelman(1)": 3,
    "adelmann": 3,
    "adelpha": 3,
    "adelphi": 3,
    "adelphia": 4,
    "adelphia's": 4,
    "adelsberger": 4,
    "adelson": 3,
    "adelstein": 3,
    "adelstein(1)": 3,
    "aden": 2,
    "adena": 3,
    "adenauer": 3,
    "adenauer(1)": 3,
    "adenine": 3,
    "adenoid": 3,
    "adenoids": 3,
    "adenoscan": 4,
    "adenosine": 4,
    "adenovirus": 5,
    "adept": 2,
    "adequacy": 4,
    "adequate": 3,
    "adequate(1)": 3,
    "adequately": 4,
    "adequately(1)": 4,
    "ader": 2,
    "aderhold": 3,
    "aderholt": 3,
    "aderman": 3,
    "ades": 1,
    "adey": 2,
    "adger": 2,
    "adham": 2,
    "adhere": 2,
    "adhered": 2,
    "adherence": 3,
    "adherent": 3,
    "adherents": 3,
    "adheres": 2,
    "adhering": 3,
    "adhesion": 3,
    "adhesive": 3,
    "adhesive(1)": 3,
    "adhesives": 3,
    "adhesives(1)": 3,
    "adia": 3,
    "adid": 2,
    "adidas": 3,
    "adidas's": 4,
    "adieu": 2,
    "adin": 2,
    "adina": 3,
    "adine": 3,
    "adinolfi": 4,
    "adios": 3,
    "adipose": 3,
    "adirondack": 4,
    "adisq": 2,
    "adisq(1)": 2,
    "adjacent": 3,
    "adjani": 3,
    "adjective": 3,
    "adjectives": 3,
    "adjoin": 2,
    "adjoining": 3,
    "adjoins": 2,
    "adjourn": 2,
    "adjourned": 2,
    "adjourning": 3,
    "adjournment": 3,
    "adjourns": 2,
    "adjudge": 2,
    "adjudged": 2,
    "adjudicate": 4,
    "adjudicated": 5,
    "adjudicating": 5,
    "adjudication": 5,
    "adjunct": 2,
    "adjuncts": 2,
    "adjust": 2,
    "adjustable": 4,
    "adjustables": 4,
    "adjusted": 3,
    "adjusted(1)": 3,
    "adjuster": 3,
    "adjusters": 3,
    "adjusting": 3,
    "adjustment": 3,
    "adjustments": 3,
    "adjusts": 2,
    "adjusts(1)": 2,
    "adjutant": 3,
    "adkins": 2,
    "adkinson": 3,
    "adkison": 3,
    "adkisson": 3,
    "adl-tabataba": 6,
    "adl-tabatabai": 6,
    "adlai": 3,
    "adler": 2,
    "adler's": 2,
    "adlers": 2,
    "adley": 2,
    "adlon": 2,
    "adlong": 2,
    "adman": 2,
    "admen": 2,
    "administer": 4,
    "administered": 4,
    "administering": 5,
    "administers": 4,
    "administrate": 4,
    "administrating": 5,
    "administration": 5,
    "administration's": 5,
    "administrations": 5,
    "administrations'": 5,
    "administrative": 5,
    "administratively": 6,
    "administrator": 5,
    "administrator's": 5,
    "administrators": 5,
    "administrators'": 5,
    "admira": 3,
    "admira's": 3,
    "admirable": 4,
    "admirable(1)": 3,
    "admirably": 4,
    "admiral": 3,
    "admiral's": 3,
    "admirals": 3,
    "admiralty": 4,
    "admiration": 4,
    "admirations": 4,
    "admire": 2,
    "admired": 3,
    "admirer": 3,
    "admirers": 3,
    "admires": 2,
    "admiring": 3,
    "admiringly": 4,
    "admissibility": 6,
    "admissible": 4,
    "admission": 3,
    "admission(1)": 3,
    "admissions": 3,
    "admissions(1)": 3,
    "admit": 2,
    "admits": 2,
    "admittance": 3,
    "admitted": 3,
    "admittedly": 4,
    "admitting": 3,
    "admitting(1)": 3,
    "admonish": 3,
    "admonished": 3,
    "admonishes": 4,
    "admonishing": 4,
    "admonishment": 4,
    "admonition": 4,
    "admonitions": 4,
    "adnan": 2,
    "adney": 2,
    "ado": 2,
    "adobe": 3,
    "adobe's": 3,
    "adolescence": 4,
    "adolescence(1)": 4,
    "adolescent": 4,
    "adolescent(1)": 4,
    "adolescents": 4,
    "adolescents(1)": 4,
    "adolf": 2,
    "adolf's": 2,
    "adolfo": 3,
    "adolph": 2,
    "adolpha": 3,
    "adolphson": 3,
    "adolphus": 3,
    "adon": 2,
    "adonia": 4,
    "adonis": 3,
    "adopt": 2,
    "adoptable": 4,
    "adopted": 3,
    "adoptee": 3,
    "adoptees": 3,
    "adopter": 3,
    "adopters": 3,
    "adopting": 3,
    "adoption": 3,
    "adoptions": 3,
    "adoptive": 3,
    "adopts": 2,
    "ador": 2,
    "adora": 3,
    "adorabelle": 4,
    "adorable": 4,
    "adoration": 4,
    "adore": 2,
    "adored": 2,
    "adoree": 3,
    "adorees": 3,
    "adores": 2,
    "adoring": 3,
    "adorn": 2,
    "adorna": 3,
    "adorned": 2,
    "adorning": 3,
    "adornment": 3,
    "adorno": 3,
    "adorns": 2,
    "adra": 2,
    "adragna": 3,
    "adrda": 3,
    "adrea": 3,
    "adrenal": 3,
    "adrenalin": 4,
    "adrenaline": 4,
    "adria": 3,
    "adrian": 3,
    "adriana": 4,
    "adriance": 3,
    "adriano": 4,
    "adriatic": 4,
    "adriel": 2,
    "adrienne": 3,
    "adrift": 2,
    "adroit": 2,
    "adroitly": 3,
    "ads": 1,
    "ads'": 1,
    "adsit": 2,
    "adss": 1,
    "adss(1)": 4,
    "adstar": 2,
    "adsteam": 2,
    "adtec": 2,
    "adulate": 3,
    "adulation": 4,
    "aduliadae": 5,
    "adult": 2,
    "adult(1)": 2,
    "adulterate": 4,
    "adulterated": 5,
    "adulterates": 4,
    "adulteration": 5,
    "adulterer": 4,
    "adulterers": 4,
    "adulterous": 4,
    "adultery": 4,
    "adulthood": 3,
    "adults": 2,
    "adults(1)": 2,
    "adults'": 2,
    "adults'(1)": 2,
    "adusdur": 3,
    "advacare": 3,
    "advalue": 3,
    "advance": 2,
    "advance's": 3,
    "advance's(1)": 3,
    "advanced": 2,
    "advancement": 3,
    "advancements": 3,
    "advancer": 3,
    "advancers": 3,
    "advances": 3,
    "advances(1)": 3,
    "advancing": 3,
    "advani": 3,
    "advanta": 3,
    "advanta(1)": 3,
    "advanta's": 3,
    "advanta's(1)": 3,
    "advantage": 3,
    "advantage(1)": 3,
    "advantage(2)": 3,
    "advantage(3)": 3,
    "advantaged": 3,
    "advantaged(1)": 3,
    "advantaged(2)": 3,
    "advantaged(3)": 3,
    "advantageous": 4,
    "advantages": 4,
    "advantages(1)": 4,
    "advantages(2)": 4,
    "advantages(3)": 4,
    "advantest": 3,
    "advantest(1)": 3,
    "advection": 3,
    "advent": 2,
    "adventist": 3,
    "adventists": 3,
    "adventists(1)": 3,
    "adventure": 3,
    "adventure(1)": 3,
    "adventurer": 4,
    "adventurer(1)": 4,
    "adventurers": 4,
    "adventurers(1)": 4,
    "adventures": 3,
    "adventures(1)": 3,
    "adventuresome": 4,
    "adventuresome(1)": 4,
    "adventurism": 5,
    "adventurism(1)": 5,
    "adventurous": 4,
    "adventurous(1)": 4,
    "adverb": 2,
    "adverbial": 4,
    "adverbs": 2,
    "adversarial": 5,
    "adversaries": 4,
    "adversary": 4,
    "adverse": 2,
    "adverse(1)": 2,
    "adverse(2)": 2,
    "adversely": 3,
    "adversity": 4,
    "adversity(1)": 4,
    "advertise": 3,
    "advertised": 3,
    "advertised(1)": 3,
    "advertisement": 4,
    "advertisement(1)": 4,
    "advertisements": 4,
    "advertiser": 4,
    "advertiser's": 4,
    "advertisers": 4,
    "advertisers'": 4,
    "advertises": 4,
    "advertising": 4,
    "advertising's": 4,
    "advertorial": 5,
    "advertorials": 5,
    "advest": 2,
    "advice": 2,
    "advice(1)": 2,
    "advil": 2,
    "advil's": 2,
    "advisability": 6,
    "advisable": 4,
    "advise": 2,
    "advise(1)": 2,
    "advised": 2,
    "advised(1)": 2,
    "advisedly": 4,
    "advisedly(1)": 4,
    "advisement": 3,
    "adviser": 3,
    "adviser's": 3,
    "advisers": 3,
    "advisers'": 3,
    "advises": 3,
    "advising": 3,
    "advisor": 3,
    "advisor(1)": 3,
    "advisories": 4,
    "advisors": 3,
    "advisors(1)": 3,
    "advisory": 4,
    "advisory(1)": 4,
    "advo": 2,
    "advocacy": 4,
    "advocate": 3,
    "advocate(1)": 3,
    "advocate's": 3,
    "advocated": 4,
    "advocated(1)": 4,
    "advocates": 3,
    "advocates(1)": 3,
    "advocating": 4,
    "advocation": 4,
    "adweek": 2,
    "adwell": 2,
    "ady": 2,
    "adz": 1,
    "ae": 1,
    "aegean": 3,
    "aegerter": 3,
    "aegis": 2,
    "aegon": 2,
    "aeltus": 2,
    "aeneas": 3,
    "aeneid": 3,
    "aequitron": 3,
    "aer": 1,
    "aer(1)": 3,
    "aerial": 3,
    "aerials": 3,
    "aerie": 2,
    "aerien": 3,
    "aeriens": 3,
    "aeritalia": 4,
    "aero": 2,
    "aerobatic": 4,
    "aerobatics": 4,
    "aerobic": 3,
    "aerobically": 4,
    "aerobics": 3,
    "aerodrome": 3,
    "aerodromes": 3,
    "aerodynamic": 5,
    "aerodynamically": 6,
    "aerodynamicist": 6,
    "aerodynamicists": 6,
    "aerodynamicists(1)": 6,
    "aerodynamics": 5,
    "aerodyne": 3,
    "aerodyne's": 3,
    "aeroflot": 3,
    "aeroflot's": 3,
    "aerogenosa": 5,
    "aerojet": 3,
    "aerojets": 3,
    "aerolift": 3,
    "aerolifts": 3,
    "aerolineas": 5,
    "aeromar": 3,
    "aeromar(1)": 3,
    "aeromexico": 5,
    "aeromexico's": 5,
    "aeronautic": 4,
    "aeronautical": 5,
    "aeronautical(1)": 5,
    "aeronauticas": 5,
    "aeronautics": 4,
    "aeroperu": 4,
    "aeroperu's": 4,
    "aeroquip": 3,
    "aerosmith": 3,
    "aerosmith's": 3,
    "aerosol": 3,
    "aerosols": 3,
    "aerospace": 3,
    "aerospace's": 4,
    "aerospatiale": 5,
    "aerospatiale's": 5,
    "aerostar": 3,
    "aerostar's": 3,
    "aerostars": 3,
    "aerostat": 3,
    "aerostat's": 3,
    "aerostats": 3,
    "aerotech": 3,
    "aerovias": 4,
    "aerts": 1,
    "aeschelus": 3,
    "aeschliman": 3,
    "aesop": 2,
    "aesop's": 2,
    "aesthenopia": 4,
    "aesthete": 2,
    "aesthete's": 2,
    "aesthetes": 2,
    "aesthetic": 3,
    "aesthetically": 4,
    "aesthetics": 3,
    "aetna": 2,
    "aetna's": 2,
    "afanasyev": 5,
    "afar": 2,
    "affable": 3,
    "affably": 3,
    "affair": 2,
    "affair's": 2,
    "affairs": 2,
    "affect": 2,
    "affectation": 4,
    "affected": 3,
    "affected(1)": 3,
    "affecting": 3,
    "affection": 3,
    "affectionate": 4,
    "affectionate(1)": 4,
    "affectionately": 5,
    "affections": 3,
    "affective": 3,
    "affectively": 4,
    "affects": 2,
    "affeldt": 2,
    "afferent": 3,
    "affiant": 3,
    "affidavit": 4,
    "affidavits": 4,
    "affiliate": 4,
    "affiliate(1)": 4,
    "affiliate's": 4,
    "affiliated": 5,
    "affiliated(1)": 5,
    "affiliated's": 5,
    "affiliates": 4,
    "affiliates(1)": 4,
    "affiliates'": 4,
    "affiliating": 5,
    "affiliation": 5,
    "affiliations": 5,
    "affine": 2,
    "affined": 2,
    "affines": 2,
    "affining": 3,
    "affinities": 4,
    "affinity": 4,
    "affinity(1)": 4,
    "affirm": 2,
    "affirmation": 4,
    "affirmations": 4,
    "affirmative": 4,
    "affirmatively": 5,
    "affirmed": 2,
    "affirming": 3,
    "affirms": 2,
    "affix": 2,
    "affix(1)": 2,
    "affixed": 2,
    "affixes": 3,
    "affixes(1)": 3,
    "affixing": 3,
    "affleck": 2,
    "afflerbach": 3,
    "afflict": 2,
    "afflicted": 3,
    "afflicted(1)": 3,
    "afflicting": 3,
    "affliction": 3,
    "afflictions": 3,
    "afflicts": 2,
    "afflik": 2,
    "affluence": 3,
    "affluent": 3,
    "affolter": 3,
    "afford": 2,
    "affordability": 6,
    "affordable": 4,
    "affordably": 4,
    "afforded": 3,
    "affording": 3,
    "affords": 2,
    "affricate": 3,
    "affricates": 3,
    "affrication": 4,
    "affront": 2,
    "affronted": 3,
    "affronting": 3,
    "affronts": 2,
    "affymax": 3,
    "afghan": 2,
    "afghani": 3,
    "afghani's": 3,
    "afghanis": 3,
    "afghanistan": 4,
    "afghanistan's": 4,
    "afghanistans": 4,
    "afghans": 2,
    "afheldt": 2,
    "aficionado": 5,
    "aficionados": 5,
    "afield": 2,
    "afire": 2,
    "aflame": 2,
    "aflatoxin": 4,
    "afloat": 2,
    "aflutter": 3,
    "afmed": 2,
    "afonso": 3,
    "afoot": 2,
    "aforementioned": 4,
    "aforesaid": 3,
    "aforethought": 3,
    "afoul": 2,
    "afraid": 2,
    "afresh": 2,
    "africa": 3,
    "africa(1)": 3,
    "africa(2)": 3,
    "africa's": 3,
    "africa's(1)": 3,
    "african": 3,
    "african(1)": 3,
    "africanist": 4,
    "africanize": 4,
    "africanized": 4,
    "africans": 3,
    "africans(1)": 3,
    "afridi": 3,
    "afrikaans": 3,
    "afrikaner": 4,
    "afrikanerdom": 5,
    "afrikaners": 4,
    "afro": 2,
    "afroamerican": 6,
    "afroamericans": 6,
    "afrocentric": 4,
    "afsane": 3,
    "afsane's": 3,
    "afshar": 2,
    "afshar's": 2,
    "aft": 1,
    "after": 2,
    "afterall": 3,
    "afterburner": 4,
    "afterburners": 4,
    "aftereffect": 4,
    "aftereffects": 4,
    "afterglow": 3,
    "afterglows": 3,
    "afterhours": 4,
    "afterimage": 4,
    "afterimages": 5,
    "afterlife": 3,
    "afterlives": 3,
    "aftermarket": 4,
    "aftermarkets": 4,
    "aftermath": 3,
    "aftermaths": 3,
    "afternoon": 3,
    "afternoon's": 3,
    "afternoons": 3,
    "aftershave": 3,
    "aftershaves": 3,
    "aftershock": 3,
    "aftershocks": 3,
    "aftertaste": 3,
    "aftertastes": 3,
    "aftertastes(1)": 3,
    "aftertax": 3,
    "afterthought": 3,
    "afterthought(1)": 3,
    "afterthoughts": 3,
    "afterthoughts(1)": 3,
    "afterward": 3,
    "afterwards": 3,
    "afula": 3,
    "afula's": 3,
    "ag": 1,
    "ag(1)": 2,
    "ag's": 1,
    "aga": 2,
    "agache": 2,
    "agache's": 3,
    "agaches": 3,
    "again": 2,
    "again(1)": 2,
    "against": 2,
    "against(1)": 2,
    "agamemnon": 4,
    "agamemnon's": 4,
    "agan": 2,
    "agana": 3,
    "aganbegyan": 4,
    "agans": 2,
    "agape": 2,
    "agar": 2,
    "agard": 2,
    "agarwal": 3,
    "agasp": 2,
    "agassi": 3,
    "agassiz": 3,
    "agate": 2,
    "agates": 2,
    "agatha": 3,
    "agawam": 3,
    "agco": 2,
    "age": 1,
    "age's": 2,
    "aged": 1,
    "aged(1)": 2,
    "agee": 2,
    "agee's": 2,
    "ageless": 2,
    "agematsu": 4,
    "agence": 2,
    "agencies": 3,
    "agencies'": 3,
    "agency": 3,
    "agency's": 3,
    "agenda": 3,
    "agendas": 3,
    "agent": 2,
    "agent's": 2,
    "agents": 2,
    "agents'": 2,
    "ager": 2,
    "ageratum": 4,
    "ageratums": 4,
    "agers": 2,
    "agers'": 2,
    "agerton": 3,
    "ages": 2,
    "ages(1)": 2,
    "agfa": 2,
    "aggarwal": 3,
    "aggie": 2,
    "aggies": 2,
    "agglomerate": 4,
    "agglomeration": 5,
    "agglutinate": 4,
    "aggrandize": 3,
    "aggrandizement": 4,
    "aggrandizement(1)": 4,
    "aggrandizing": 4,
    "aggrandizing(1)": 4,
    "aggravate": 3,
    "aggravated": 4,
    "aggravated(1)": 4,
    "aggravates": 3,
    "aggravating": 4,
    "aggravation": 4,
    "aggregate": 3,
    "aggregate(1)": 3,
    "aggregate(2)": 3,
    "aggregated": 4,
    "aggregates": 3,
    "aggregates(1)": 3,
    "aggress": 2,
    "aggression": 3,
    "aggressions": 3,
    "aggressive": 3,
    "aggressively": 4,
    "aggressiveness": 4,
    "aggressivity": 5,
    "aggressor": 3,
    "aggressors": 3,
    "aggrey": 2,
    "aggrieve": 2,
    "aggrieved": 2,
    "aggy": 2,
    "aghast": 2,
    "aghazadeh": 4,
    "agie": 2,
    "agildo": 3,
    "agile": 2,
    "agilis": 3,
    "agility": 4,
    "agin": 2,
    "agincourt": 3,
    "aging": 2,
    "agins": 2,
    "agip": 2,
    "agitate": 3,
    "agitated": 4,
    "agitating": 4,
    "agitation": 4,
    "agitator": 4,
    "agitators": 4,
    "agitprop": 3,
    "agius": 3,
    "agleam": 2,
    "agler": 2,
    "aglitter": 3,
    "aglo": 2,
    "aglow": 2,
    "agna": 2,
    "agne": 2,
    "agnella": 3,
    "agnelli": 3,
    "agnelli's": 3,
    "agnellis": 3,
    "agnello": 3,
    "agner": 2,
    "agnes": 2,
    "agneta": 3,
    "agnew": 2,
    "agnew(1)": 2,
    "agnico": 3,
    "agnor": 2,
    "agnos": 2,
    "agnosio": 4,
    "agnostic": 3,
    "agnostics": 3,
    "ago": 2,
    "agog": 2,
    "agoglia": 4,
    "agonies": 3,
    "agonist": 3,
    "agonists": 3,
    "agonists(1)": 3,
    "agonize": 3,
    "agonized": 3,
    "agonizes": 4,
    "agonizing": 4,
    "agonizingly": 5,
    "agony": 3,
    "agora": 3,
    "agoraphobia": 6,
    "agosta": 3,
    "agostinelli": 5,
    "agostini": 4,
    "agostino": 4,
    "agosto": 3,
    "agoura": 3,
    "agouron": 3,
    "agra": 2,
    "agrarian": 4,
    "agrarianism": 6,
    "agrawal": 3,
    "agree": 2,
    "agreeable": 4,
    "agreed": 2,
    "agreeing": 3,
    "agreement": 3,
    "agreement's": 3,
    "agreements": 3,
    "agrees": 2,
    "agregable": 4,
    "agregious": 4,
    "agresource": 3,
    "agresource(1)": 3,
    "agresta": 3,
    "agresti": 3,
    "agrexco": 3,
    "agri": 2,
    "agribank": 3,
    "agribusiness": 4,
    "agrico": 3,
    "agricola": 4,
    "agricole": 3,
    "agricultural": 5,
    "agricultural(1)": 5,
    "agriculturalist": 6,
    "agriculturally": 6,
    "agriculturally(1)": 5,
    "agriculture": 4,
    "agriculture's": 4,
    "agrifuel": 3,
    "agrifuels": 3,
    "agrigenetics": 5,
    "agrippa": 3,
    "agrivisor": 4,
    "agro": 2,
    "agrochemical": 5,
    "agrochemicals": 5,
    "agroindustrial": 6,
    "agrokomerc": 4,
    "agronomist": 4,
    "agronomists": 4,
    "agronomists(1)": 4,
    "agrosiand": 4,
    "aground": 2,
    "agrusa": 3,
    "agua": 2,
    "aguacate": 3,
    "aguadilla": 4,
    "aguado": 3,
    "aguanga": 3,
    "aguascalientes": 5,
    "aguayo": 3,
    "agudelo": 4,
    "aguero": 3,
    "aguiar": 3,
    "aguila": 3,
    "aguilar": 3,
    "aguilera": 4,
    "aguillar": 3,
    "aguillard": 3,
    "aguillon": 3,
    "aguilo": 3,
    "aguinaga": 5,
    "aguirra": 3,
    "aguirra's": 3,
    "aguirre": 3,
    "aguirre(1)": 3,
    "aguirre's": 3,
    "aguirre's(1)": 3,
    "agustin": 3,
    "ah": 1,
    "aha": 2,
    "ahab": 2,
    "ahah": 2,
    "aharon": 3,
    "ahart": 2,
    "ahasuerus": 5,
    "ahaulsie": 3,
    "ahead": 2,
    "ahearn": 2,
    "aherin": 3,
    "ahern": 2,
    "aherne": 2,
    "ahh": 1,
    "ahl": 1,
    "ahlberg": 2,
    "ahlborn": 2,
    "ahlen": 2,
    "ahlen(1)": 2,
    "ahlers": 2,
    "ahles": 2,
    "ahlf": 1,
    "ahlgren": 2,
    "ahlgrim": 2,
    "ahlin": 2,
    "ahlman": 2,
    "ahlquist": 2,
    "ahlquist's": 2,
    "ahlquists": 2,
    "ahlstrand": 2,
    "ahlstrom": 2,
    "ahluwalia": 4,
    "ahmad": 2,
    "ahmadi": 3,
    "ahmann": 2,
    "ahmanson": 3,
    "ahmanson's": 3,
    "ahmansons": 3,
    "ahmed": 2,
    "ahmed(1)": 2,
    "ahmeek": 2,
    "ahmoudi": 3,
    "ahn": 1,
    "ahnell": 2,
    "ahner": 2,
    "aho": 2,
    "ahola": 3,
    "ahold": 2,
    "ahold's": 2,
    "aholds": 2,
    "ahonen": 3,
    "ahoskie": 3,
    "ahoy": 2,
    "ahr": 1,
    "ahranat": 3,
    "ahren": 2,
    "ahrendt": 2,
    "ahrens": 2,
    "ahs": 1,
    "ahsahka": 3,
    "ahuja": 3,
    "ahumada": 4,
    "ahwahnee": 3,
    "ai": 1,
    "ai(1)": 2,
    "aichele": 2,
    "aicher": 2,
    "aichi": 3,
    "aickin": 2,
    "aid": 1,
    "aid's": 1,
    "aida": 3,
    "aidan": 2,
    "aide": 1,
    "aide's": 1,
    "aided": 2,
    "aided(1)": 2,
    "aides": 1,
    "aides'": 1,
    "aidid": 2,
    "aidid's": 2,
    "aiding": 2,
    "aids": 1,
    "aiello": 3,
    "aiesha": 2,
    "aigner": 2,
    "aigner(1)": 2,
    "aigner(2)": 2,
    "aiguebelle": 3,
    "aiken": 2,
    "aikens": 2,
    "aikey": 2,
    "aikin": 2,
    "aikins": 2,
    "aikman": 2,
    "aikoff": 2,
    "ail": 1,
    "ailee": 2,
    "aileen": 2,
    "aileron": 3,
    "ailerons": 3,
    "ailes": 1,
    "ailes(1)": 1,
    "ailey": 2,
    "ailing": 2,
    "ailment": 2,
    "ailments": 2,
    "ailor": 2,
    "ails": 1,
    "ailsa": 2,
    "ailurophile": 4,
    "ailurophile(1)": 5,
    "aim": 1,
    "aim's": 1,
    "aimal": 2,
    "aiman": 2,
    "aime": 1,
    "aimed": 1,
    "aimee": 2,
    "aimetti": 3,
    "aiming": 2,
    "aimless": 2,
    "aimlessly": 3,
    "aimone": 2,
    "aims": 1,
    "ain't": 1,
    "aine": 1,
    "ainge": 1,
    "ainge(1)": 1,
    "ainley": 2,
    "ainsberg": 2,
    "ainsley": 2,
    "ainslie": 2,
    "ainsworth": 2,
    "ainsworth's": 2,
    "aipac": 2,
    "aipac's": 2,
    "air": 1,
    "air's": 1,
    "airbag": 2,
    "airbags": 2,
    "airbase": 2,
    "airbases": 3,
    "airboat": 2,
    "airboats": 2,
    "airborne": 2,
    "airborne's": 2,
    "airbus": 2,
    "airbus's": 3,
    "aircal": 2,
    "aircal's": 2,
    "airco": 2,
    "aircoa": 3,
    "aircondition": 4,
    "airconditioned": 4,
    "airconditioner": 5,
    "airconditioning": 5,
    "airconditions": 4,
    "aircraft": 2,
    "aircraft's": 2,
    "aircraft's(1)": 2,
    "aircrafts": 2,
    "aircrafts(1)": 2,
    "aircrew": 2,
    "aird": 1,
    "airdrop": 2,
    "airdrops": 2,
    "aired": 1,
    "airedale": 2,
    "airedales": 2,
    "aires": 2,
    "airey": 2,
    "airfare": 2,
    "airfares": 2,
    "airfield": 2,
    "airfields": 2,
    "airflow": 2,
    "airflows": 2,
    "airfoil": 2,
    "airfoils": 2,
    "airfone": 2,
    "airfones": 2,
    "airforce": 2,
    "airforces": 3,
    "airframe": 2,
    "airframes": 2,
    "airfreight": 2,
    "airgas": 2,
    "airglow": 2,
    "airhart": 2,
    "airhead": 2,
    "airheadz": 2,
    "airing": 2,
    "airington": 3,
    "airless": 2,
    "airlia": 3,
    "airlie": 2,
    "airlift": 2,
    "airlifted": 3,
    "airlifter": 3,
    "airlifters": 3,
    "airlifting": 3,
    "airlifts": 2,
    "airline": 2,
    "airline's": 2,
    "airliner": 3,
    "airliner's": 3,
    "airliners": 3,
    "airlines": 2,
    "airlines'": 2,
    "airlink": 2,
    "airlinks": 2,
    "airlock": 2,
    "airlocks": 2,
    "airmail": 2,
    "airman": 2,
    "airman's": 2,
    "airmen": 2,
    "airmotive": 3,
    "airplane": 2,
    "airplane's": 2,
    "airplanes": 2,
    "airport": 2,
    "airport's": 2,
    "airporter": 3,
    "airporters": 3,
    "airports": 2,
    "airpower": 3,
    "airs": 1,
    "airshare": 2,
    "airship": 2,
    "airships": 2,
    "airspace": 2,
    "airspaces": 3,
    "airspeed": 2,
    "airstrike": 2,
    "airstrikes": 2,
    "airstrip": 2,
    "airstrips": 2,
    "airtight": 2,
    "airtime": 2,
    "airtouch": 2,
    "airtran": 2,
    "airwave": 2,
    "airwaves": 2,
    "airway": 2,
    "airway's": 2,
    "airways": 2,
    "airways'": 2,
    "airways's": 3,
    "airwing": 2,
    "airwings": 2,
    "airworthiness": 4,
    "airworthy": 3,
    "airy": 2,
    "air_force": 2,
    "ais": 1,
    "aisa": 3,
    "aisle": 1,
    "aisle(1)": 2,
    "aisles": 1,
    "aisles(1)": 2,
    "aisling": 2,
    "aislinn": 2,
    "aist": 1,
    "aitchison": 3,
    "aithne": 1,
    "aitken": 2,
    "aiton": 3,
    "aiwa": 2,
    "aix": 1,
    "aix(1)": 1,
    "aix-en-provence": 4,
    "aix-en-provence(1)": 4,
    "aix-la-chapelle": 4,
    "aix-la-chapelle(1)": 4,
    "aja": 2,
    "ajaj": 2,
    "ajaj's": 3,
    "ajami": 3,
    "ajar": 2,
    "ajax": 2,
    "ajax's": 3,
    "ajax's(1)": 3,
    "ajay": 2,
    "ajinomoto": 5,
    "ajito": 3,
    "ajito(1)": 3,
    "aka": 2,
    "aka(1)": 3,
    "akai": 2,
    "akaka": 3,
    "akali": 3,
    "akamine": 3,
    "akana": 3,
    "akao": 3,
    "akao(1)": 2,
    "akard": 2,
    "akashi": 3,
    "akashi's": 3,
    "akbar": 2,
    "akbar(1)": 2,
    "akbash": 2,
    "akc": 1,
    "ake": 1,
    "akebono": 4,
    "akel": 2,
    "akella": 3,
    "aken": 2,
    "akens": 2,
    "aker": 2,
    "aker(1)": 2,
    "akerley": 3,
    "akerman": 3,
    "akers": 2,
    "akers's": 3,
    "akerson": 3,
    "akey": 2,
    "akhtar": 2,
    "aki": 2,
    "akiba": 3,
    "akihito": 4,
    "akiko": 3,
    "akimbo": 3,
    "akin": 2,
    "akin(1)": 2,
    "akins": 2,
    "akins(1)": 2,
    "akio": 3,
    "akira": 3,
    "akita": 3,
    "akita's": 3,
    "akiva": 3,
    "akiyama": 4,
    "akkadian": 4,
    "akkerman": 3,
    "akre": 2,
    "akridge": 2,
    "akron": 2,
    "aksamit": 3,
    "aksler": 2,
    "akst": 1,
    "akyanama": 4,
    "akzo": 2,
    "akzo's": 2,
    "akzos": 2,
    "al": 1,
    "al's": 1,
    "al.": 1,
    "al.(1)": 4,
    "ala": 2,
    "alabama": 4,
    "alabama's": 4,
    "alabaman": 4,
    "alabamans": 4,
    "alabaster": 4,
    "alachlor": 3,
    "alachua": 4,
    "alacrity": 4,
    "aladdin": 3,
    "alafi": 3,
    "alagappan": 4,
    "alagem": 3,
    "alagna": 3,
    "alagoas": 3,
    "alai": 2,
    "alaimo": 3,
    "alain": 2,
    "alaine": 2,
    "alair": 2,
    "alam": 2,
    "alamance": 3,
    "alamco": 3,
    "alameda": 4,
    "alamein": 3,
    "alamillo": 4,
    "alamito": 4,
    "alamitos": 4,
    "alamo": 3,
    "alamodome": 4,
    "alamos": 3,
    "alamosa": 4,
    "alamoud": 3,
    "alamoudi": 4,
    "alamoudi(1)": 4,
    "alan": 2,
    "alan's": 2,
    "alana": 3,
    "alanco": 3,
    "aland": 2,
    "alane": 2,
    "alanis": 3,
    "alaniz": 3,
    "alann": 2,
    "alanna": 3,
    "alar": 2,
    "alarcon": 3,
    "alard": 2,
    "alaric": 3,
    "alarica": 4,
    "alarice": 3,
    "alarid": 3,
    "alarie": 3,
    "alarm": 2,
    "alarm's": 2,
    "alarmed": 2,
    "alarming": 3,
    "alarmingly": 4,
    "alarmist": 3,
    "alarmist(1)": 3,
    "alarmists": 3,
    "alarmists(1)": 3,
    "alarms": 2,
    "alaron": 3,
    "alas": 2,
    "alaska": 3,
    "alaska's": 3,
    "alaskamen": 4,
    "alaskan": 3,
    "alaskans": 3,
    "alastair": 3,
    "alaster": 3,
    "alatas": 3,
    "alatorre": 4,
    "alayne": 2,
    "alba": 2,
    "albach": 2,
    "albacore": 3,
    "alban": 2,
    "albanese": 4,
    "albani": 3,
    "albani's": 3,
    "albania": 4,
    "albania's": 4,
    "albanian": 4,
    "albanians": 4,
    "albank": 2,
    "albano": 3,
    "albans": 2,
    "albany": 3,
    "albany's": 3,
    "albarado": 4,
    "albarran": 3,
    "albashaun": 3,
    "albatross": 3,
    "albatrosses": 4,
    "albaugh": 2,
    "albea": 3,
    "albee": 2,
    "albeit": 3,
    "albemarle": 3,
    "alben": 2,
    "albendazole": 5,
    "alber": 2,
    "alberding": 3,
    "alberg": 2,
    "albergo": 3,
    "alberico": 4,
    "albern": 2,
    "albers": 2,
    "alberson": 3,
    "albert": 2,
    "albert's": 2,
    "alberta": 3,
    "alberthal": 3,
    "alberti": 3,
    "albertina": 4,
    "albertine": 3,
    "albertini": 4,
    "alberto": 3,
    "alberts": 2,
    "albertsen": 3,
    "albertson": 3,
    "albertson's": 3,
    "albertus": 3,
    "albertville": 3,
    "alberty": 3,
    "albie": 2,
    "albin": 2,
    "albina": 3,
    "albini": 3,
    "albinia": 4,
    "albino": 3,
    "albion": 3,
    "albiric": 3,
    "albo": 2,
    "albrecht": 2,
    "albright": 2,
    "albright's": 2,
    "albrightsville": 3,
    "albritton": 3,
    "albro": 2,
    "albukhari": 4,
    "album": 2,
    "album's": 2,
    "albumin": 3,
    "albums": 2,
    "albunex": 3,
    "albuquerque": 4,
    "albury": 3,
    "albus": 2,
    "albuterol": 4,
    "alcala": 3,
    "alcan": 2,
    "alcan's": 2,
    "alcantar": 3,
    "alcantara": 4,
    "alcaraz": 3,
    "alcasa": 3,
    "alcatel": 3,
    "alcatel's": 3,
    "alcatraz": 3,
    "alcatraz(1)": 3,
    "alcazar": 3,
    "alcee": 2,
    "alcester": 3,
    "alchemically": 4,
    "alchemist": 3,
    "alchemist(1)": 3,
    "alchemy": 3,
    "alcide": 2,
    "alcids": 2,
    "alcina": 3,
    "alco": 2,
    "alco's": 2,
    "alcoa": 3,
    "alcoa's": 3,
    "alcocer": 3,
    "alcock": 2,
    "alcohol": 3,
    "alcoholic": 4,
    "alcoholics": 4,
    "alcoholism": 5,
    "alcon": 2,
    "alcorn": 2,
    "alcorta": 3,
    "alcott": 2,
    "alcove": 2,
    "alcoves": 2,
    "alda": 2,
    "aldaco": 3,
    "aldama": 3,
    "aldana": 3,
    "aldape": 3,
    "alday": 2,
    "aldebaran": 4,
    "alden": 2,
    "aldenville": 3,
    "alder": 2,
    "aldercy": 3,
    "alderete": 3,
    "alderfer": 3,
    "alderidge": 3,
    "alderidge(1)": 2,
    "alderman": 3,
    "alderman(1)": 3,
    "aldermen": 3,
    "alderson": 3,
    "alderson(1)": 3,
    "alderton": 3,
    "aldi": 2,
    "aldicarb": 3,
    "aldila": 3,
    "aldin": 2,
    "aldinger": 3,
    "aldis": 2,
    "aldo": 2,
    "aldora": 3,
    "aldous": 2,
    "aldred": 2,
    "aldred(1)": 2,
    "aldredge": 2,
    "aldrete": 2,
    "aldric": 2,
    "aldric(1)": 2,
    "aldrich": 2,
    "aldrich's": 3,
    "aldridge": 2,
    "aldrin": 2,
    "aldrin's": 2,
    "aldus": 2,
    "aldus's": 3,
    "aldwin": 2,
    "aldwyn": 2,
    "aldys": 2,
    "ale": 1,
    "aleatory": 5,
    "alec": 2,
    "aleda": 3,
    "aledo": 3,
    "aleen": 2,
    "alegre": 3,
    "alegrett": 3,
    "alegria": 4,
    "alehouse": 2,
    "aleichem": 3,
    "aleichem(1)": 3,
    "alejandre": 4,
    "alejandro": 4,
    "alejandro(1)": 4,
    "alejo": 3,
    "alejos": 3,
    "aleksander": 4,
    "aleksandr": 4,
    "alem": 2,
    "aleman": 2,
    "alena": 3,
    "alendrin": 3,
    "alene": 2,
    "alenia": 4,
    "aleo": 3,
    "aleph": 2,
    "aleria": 4,
    "aleron": 3,
    "alert": 2,
    "alerted": 3,
    "alerting": 3,
    "alertly": 3,
    "alertness": 3,
    "alerts": 2,
    "ales": 1,
    "aleshire": 4,
    "alesi": 3,
    "alessandra": 4,
    "alessandra's": 4,
    "alessandrini": 5,
    "alessandro": 4,
    "alessandro(1)": 4,
    "alessi": 3,
    "alessi(1)": 3,
    "alessio": 4,
    "aleta": 3,
    "aletha": 3,
    "alethea": 4,
    "aletti": 3,
    "aleutian": 3,
    "aleutians": 3,
    "aleve": 2,
    "alewife": 2,
    "alewine": 2,
    "alewives": 2,
    "alex": 2,
    "alex's": 3,
    "alexa": 3,
    "alexander": 4,
    "alexander(1)": 4,
    "alexander's": 4,
    "alexander's(1)": 4,
    "alexanders": 4,
    "alexandra": 4,
    "alexandra(1)": 4,
    "alexandre": 4,
    "alexandria": 5,
    "alexandrine": 4,
    "alexandrines": 4,
    "alexandrov": 4,
    "alexandrov(1)": 4,
    "alexei": 3,
    "alexi": 3,
    "alexi's": 3,
    "alexia": 4,
    "alexine": 3,
    "alexis": 3,
    "alexopoulos": 5,
    "alexs": 2,
    "alexy": 3,
    "aley": 2,
    "alf": 1,
    "alfa": 2,
    "alfa's": 2,
    "alfalfa": 3,
    "alfano": 3,
    "alfareda": 4,
    "alfaro": 3,
    "alfavilli": 4,
    "alfie": 2,
    "alfieri": 3,
    "alfiero": 4,
    "alfin": 2,
    "alfin's": 2,
    "alfono": 3,
    "alfons": 2,
    "alfonse": 2,
    "alfonse(1)": 2,
    "alfonsin": 3,
    "alfonsin's": 3,
    "alfonsine": 4,
    "alfonso": 3,
    "alfonzo": 3,
    "alford": 2,
    "alfre": 2,
    "alfre(1)": 2,
    "alfred": 2,
    "alfred(1)": 2,
    "alfredo": 3,
    "alfredson": 3,
    "alfredsson": 3,
    "alfrey": 2,
    "algae": 2,
    "algal": 2,
    "algamaa": 3,
    "algar": 2,
    "algarin": 3,
    "algata": 3,
    "algebra": 3,
    "algebraic": 4,
    "algebraically": 5,
    "algemene": 3,
    "algeo": 3,
    "alger": 2,
    "algeria": 4,
    "algeria's": 4,
    "algerian": 4,
    "algerians": 4,
    "algernon": 3,
    "algie": 2,
    "algiers": 2,
    "algodones": 4,
    "algol": 2,
    "algom": 2,
    "algoma": 3,
    "algonquian": 4,
    "algonquin": 3,
    "algorithm": 4,
    "algorithms": 4,
    "alguire": 3,
    "algy": 2,
    "alhadeff": 3,
    "alhambra": 3,
    "alhausie": 3,
    "ali": 2,
    "ali's": 2,
    "ali-reza": 4,
    "aliano": 4,
    "alianza": 4,
    "alias": 3,
    "aliases": 4,
    "aliberti": 4,
    "alibi": 3,
    "alibis": 3,
    "alibrandi": 4,
    "alice": 2,
    "alice(1)": 2,
    "alice's": 3,
    "alicea": 4,
    "alices": 3,
    "alicia": 3,
    "alicia's": 3,
    "alida": 3,
    "alie": 2,
    "alien": 3,
    "alienate": 3,
    "alienated": 5,
    "alienated(1)": 5,
    "alienates": 4,
    "alienating": 5,
    "alienation": 5,
    "aliens": 3,
    "aliff": 2,
    "alig": 2,
    "alight": 2,
    "align": 2,
    "aligned": 2,
    "aligning": 3,
    "alignment": 3,
    "alignments": 3,
    "aligns": 2,
    "alihan": 3,
    "alija": 3,
    "alija's": 3,
    "alike": 2,
    "alikes": 2,
    "alima": 3,
    "alimenies": 4,
    "alimentary": 5,
    "alimony": 4,
    "alina": 3,
    "aline": 2,
    "alines": 2,
    "alioto": 4,
    "aliquippa": 4,
    "aliquippa's": 4,
    "aliquippas": 4,
    "alire": 3,
    "alirio": 4,
    "alisa": 3,
    "alisha": 3,
    "alisky": 3,
    "alislamiyya": 5,
    "alison": 3,
    "alissa": 3,
    "alistair": 3,
    "alister": 3,
    "alita": 3,
    "alitalia": 5,
    "alitalia(1)": 5,
    "alitalia's": 5,
    "alitalia's(1)": 5,
    "alithia": 4,
    "alito": 3,
    "alive": 2,
    "alix": 2,
    "aliyah": 3,
    "alizac": 3,
    "alka": 2,
    "alkahest": 3,
    "alkali": 3,
    "alkalies": 3,
    "alkaline": 3,
    "alkalinity": 5,
    "alkaloid": 3,
    "alkaloidal": 4,
    "alkaloids": 3,
    "alkanes": 2,
    "alkema": 3,
    "alkene": 2,
    "alkenes": 2,
    "alkermes": 3,
    "alkire": 2,
    "all": 1,
    "all's": 1,
    "all-out": 2,
    "all-purpose": 3,
    "alla": 2,
    "allah": 2,
    "allain": 2,
    "allaire": 2,
    "allais": 2,
    "allais(1)": 3,
    "allamuchy": 4,
    "allan": 2,
    "allante": 3,
    "allar": 2,
    "allard": 2,
    "allardt": 2,
    "allay": 2,
    "allayed": 2,
    "allaying": 3,
    "allays": 2,
    "allbaugh": 2,
    "allbee": 2,
    "allbright": 2,
    "allbritten": 3,
    "allbritton": 3,
    "allcock": 2,
    "allcorn": 2,
    "allday": 2,
    "allderdice": 3,
    "allderdice(1)": 3,
    "alldredge": 2,
    "allebach": 3,
    "allebach(1)": 2,
    "alleco": 3,
    "allee": 2,
    "allegation": 4,
    "allegations": 4,
    "allege": 2,
    "alleged": 2,
    "allegedly": 4,
    "alleges": 3,
    "alleges(1)": 3,
    "alleghany": 4,
    "alleghenies": 4,
    "alleghenies(1)": 4,
    "allegheny": 4,
    "allegheny(1)": 4,
    "allegheny's": 4,
    "allegheny's(1)": 4,
    "allegiance": 3,
    "allegiances": 5,
    "allegiances(1)": 4,
    "alleging": 3,
    "allegis": 3,
    "allegis'": 3,
    "allegis's": 4,
    "allegorical": 5,
    "allegories": 4,
    "allegory": 4,
    "allegra": 3,
    "allegretti": 4,
    "allegro": 3,
    "allele": 3,
    "alleles": 3,
    "allelic": 3,
    "alleman": 2,
    "allemand": 3,
    "allen": 2,
    "allen's": 2,
    "allenbaugh": 3,
    "allendale": 3,
    "allende": 3,
    "allender": 4,
    "allender(1)": 3,
    "allendorf": 3,
    "allene": 2,
    "allenhurst": 3,
    "allens": 2,
    "allensbach": 3,
    "allensworth": 3,
    "allenton": 3,
    "allentown": 3,
    "allenwood": 3,
    "aller": 2,
    "allergan": 3,
    "allergen": 3,
    "allergens": 3,
    "allergic": 3,
    "allergies": 3,
    "allergist": 3,
    "allergist's": 3,
    "allergist's(1)": 3,
    "allergists": 3,
    "allergists(1)": 3,
    "allergy": 3,
    "allers": 2,
    "allert": 2,
    "allerton": 3,
    "alles": 1,
    "alleva": 3,
    "alleviate": 4,
    "alleviated": 5,
    "alleviated(1)": 5,
    "alleviates": 4,
    "alleviating": 5,
    "alleviation": 5,
    "alley": 2,
    "alley's": 2,
    "alleyne": 2,
    "alleyoop": 3,
    "alleys": 2,
    "alleyway": 3,
    "alleyways": 3,
    "allgaier": 3,
    "allgeier": 3,
    "allgemeine": 3,
    "allgemeines": 3,
    "allgeyer": 3,
    "allgood": 2,
    "alli": 2,
    "alliance": 3,
    "alliance's": 4,
    "alliances": 4,
    "alliances(1)": 4,
    "alliant": 3,
    "alliant's": 3,
    "allianz": 3,
    "allianz's": 4,
    "allick": 2,
    "allie": 2,
    "allied": 2,
    "allied(1)": 2,
    "allied's": 2,
    "alliedsignal": 4,
    "alliedsignal's": 4,
    "allies": 2,
    "allies(1)": 2,
    "allies'": 2,
    "alligator": 4,
    "alligators": 4,
    "alligood": 3,
    "allin": 2,
    "allinder": 3,
    "alling": 2,
    "allinger": 3,
    "allingham": 3,
    "allington": 3,
    "allinson": 3,
    "allis": 2,
    "allison": 3,
    "allison(1)": 3,
    "allison's": 3,
    "allister": 3,
    "allister(1)": 3,
    "alliston": 3,
    "alliteration": 5,
    "alliterative": 5,
    "alliterative(1)": 5,
    "allman": 2,
    "allmendinger": 4,
    "allmon": 2,
    "allmond": 2,
    "allnet": 2,
    "allnutt": 2,
    "allocate": 3,
    "allocated": 4,
    "allocates": 3,
    "allocating": 4,
    "allocation": 4,
    "allocations": 4,
    "allocator": 4,
    "allocators": 4,
    "allocca": 3,
    "allocco": 3,
    "allograph": 3,
    "allographs": 3,
    "allomorph": 3,
    "allomorphs": 3,
    "allophone": 3,
    "allophones": 3,
    "allophonic": 4,
    "allor": 2,
    "allot": 2,
    "alloted": 3,
    "allotment": 3,
    "allotments": 3,
    "allotrope": 3,
    "allotropes": 3,
    "allots": 2,
    "allotted": 3,
    "allotting": 3,
    "allow": 2,
    "allowable": 4,
    "allowance": 3,
    "allowances": 4,
    "alloway": 3,
    "allowed": 2,
    "allowing": 3,
    "allows": 2,
    "alloy": 2,
    "alloys": 2,
    "allphin": 2,
    "allport": 2,
    "allred": 2,
    "allright": 2,
    "alls": 1,
    "allsbrook": 2,
    "allsbrook(1)": 2,
    "allset": 2,
    "allshouse": 2,
    "allshouse(1)": 2,
    "allsop": 2,
    "allsopp": 2,
    "allspice": 2,
    "allstate": 2,
    "allstate's": 2,
    "allston": 2,
    "allsup": 2,
    "alltel": 2,
    "alltime": 2,
    "allton": 2,
    "alltop": 2,
    "allude": 2,
    "alluded": 3,
    "alludes": 2,
    "alluding": 3,
    "allum": 2,
    "allums": 2,
    "allure": 2,
    "allured": 2,
    "alluring": 3,
    "allusion": 3,
    "allusions": 3,
    "allusive": 3,
    "alluvial": 4,
    "alluvium": 4,
    "allwaste": 2,
    "allweiss": 2,
    "allweiss's": 3,
    "ally": 2,
    "ally(1)": 2,
    "ally's": 2,
    "allying": 3,
    "allying(1)": 3,
    "allyn": 2,
    "allys": 2,
    "allyson": 3,
    "alm": 1,
    "alma": 2,
    "almada": 3,
    "almadani": 4,
    "almaden": 3,
    "almaguer": 3,
    "almal": 2,
    "alman": 2,
    "almanac": 3,
    "almand": 2,
    "almanza": 3,
    "almanzar": 3,
    "almaraz": 3,
    "almas": 2,
    "almasy": 3,
    "almay": 2,
    "almazan": 3,
    "almeda": 3,
    "almeida": 3,
    "almelund": 3,
    "almendarez": 4,
    "almer": 2,
    "almeria": 4,
    "almgren": 2,
    "almighty": 3,
    "almira": 3,
    "almo": 2,
    "almodovar": 4,
    "almon": 2,
    "almond": 2,
    "almonds": 2,
    "almoner": 3,
    "almonte": 3,
    "almos": 2,
    "almost": 2,
    "almquist": 2,
    "alms": 1,
    "alms(1)": 1,
    "almy": 2,
    "almys": 2,
    "alodie": 3,
    "aloe": 2,
    "aloft": 2,
    "aloha": 3,
    "aloi": 2,
    "aloia": 3,
    "alois": 2,
    "aloisa": 3,
    "aloisi": 3,
    "aloisia": 4,
    "aloisio": 4,
    "aloka": 3,
    "alomar": 3,
    "alon": 2,
    "alone": 2,
    "along": 2,
    "alonge": 2,
    "alongi": 3,
    "alongs": 2,
    "alongside": 3,
    "aloni": 3,
    "alonso": 3,
    "alonza": 3,
    "alonzo": 3,
    "aloof": 2,
    "aloofness": 3,
    "alot": 2,
    "aloud": 2,
    "aloys": 2,
    "aloyse": 2,
    "aloysia": 4,
    "aloysius": 4,
    "alpa": 2,
    "alpaca": 3,
    "alpaugh": 2,
    "alper": 2,
    "alperin": 3,
    "alpern": 2,
    "alpers": 2,
    "alpert": 2,
    "alpex": 2,
    "alpha": 2,
    "alpha's": 2,
    "alphabet": 3,
    "alphabetic": 4,
    "alphabetical": 5,
    "alphabetically": 5,
    "alphabetization": 6,
    "alphabetize": 4,
    "alphabetized": 4,
    "alphabetizes": 5,
    "alphabetizing": 5,
    "alphagraphics": 4,
    "alphametric": 4,
    "alphametrics": 4,
    "alphandery": 4,
    "alphanumeric": 5,
    "alphaphotographic": 6,
    "alpharel": 3,
    "alpharetta": 4,
    "alphin": 2,
    "alphonse": 2,
    "alphonsine": 3,
    "alphonso": 3,
    "alpin": 2,
    "alpine": 2,
    "alpirez": 3,
    "alpo": 2,
    "alps": 1,
    "alquist": 2,
    "alread": 2,
    "already": 3,
    "already(1)": 3,
    "alred": 2,
    "alright": 2,
    "alrosa": 3,
    "alrosa(1)": 3,
    "alroy": 2,
    "als": 1,
    "alsace": 2,
    "alsace(1)": 2,
    "alsatian": 3,
    "alsbrook": 2,
    "alsbrook's": 2,
    "alsbrooks": 2,
    "alsbrooks'": 2,
    "alsbury": 3,
    "alsbury(1)": 3,
    "alsdorf": 2,
    "alsdorf(1)": 2,
    "alsgaard": 2,
    "alshelhah": 3,
    "alsip": 2,
    "also": 2,
    "alsobrook": 3,
    "alsobrooks": 3,
    "alsop": 2,
    "alspach": 2,
    "alspaugh": 2,
    "alsthom": 2,
    "alston": 2,
    "alsup": 2,
    "alt": 1,
    "alta": 2,
    "altadena": 4,
    "altai": 2,
    "altaic": 3,
    "altair": 2,
    "altamira": 4,
    "altamirano": 5,
    "altamont": 3,
    "altamuro": 4,
    "altar": 2,
    "altarpiece": 3,
    "altars": 2,
    "altavista": 4,
    "altay": 2,
    "altemose": 3,
    "altemus": 3,
    "altenburg": 3,
    "altenhofen": 4,
    "alteon": 3,
    "alter": 2,
    "altera": 3,
    "alteration": 4,
    "alterations": 4,
    "altercation": 4,
    "altercations": 4,
    "altered": 2,
    "altergott": 3,
    "altering": 3,
    "alterman": 3,
    "alternacare": 4,
    "alternate": 3,
    "alternate(1)": 3,
    "alternated": 4,
    "alternately": 4,
    "alternates": 3,
    "alternating": 4,
    "alternation": 4,
    "alternative": 4,
    "alternatively": 5,
    "alternatives": 4,
    "alternator": 4,
    "alters": 2,
    "altfest": 2,
    "althaus": 2,
    "althaver": 3,
    "althea": 3,
    "altherr": 2,
    "althoff": 2,
    "althorp": 2,
    "althorp(1)": 2,
    "although": 2,
    "althouse": 2,
    "altice": 2,
    "altier": 3,
    "altieri": 3,
    "altima": 3,
    "altima's": 3,
    "altimeter": 4,
    "altimetry": 4,
    "altimorano": 5,
    "altiplano": 4,
    "altitude": 3,
    "altitudes": 3,
    "altizer": 3,
    "altland": 2,
    "altman": 2,
    "altman's": 2,
    "altmann": 2,
    "altmeyer": 3,
    "altmeyer(1)": 3,
    "alto": 2,
    "altobelli": 4,
    "altogether": 4,
    "altoid": 2,
    "altom": 2,
    "altomare": 4,
    "alton": 2,
    "altoona": 3,
    "altos": 2,
    "altos(1)": 2,
    "altra": 2,
    "altron": 2,
    "altruism": 4,
    "altruistic": 4,
    "altschiller": 3,
    "altschul": 2,
    "altschuler": 3,
    "altschuler(1)": 3,
    "altshuler": 3,
    "altshuler(1)": 3,
    "altucher": 3,
    "alturas": 3,
    "altus": 2,
    "altvater": 3,
    "altzheimer": 3,
    "altzheimer's": 3,
    "alu": 2,
    "alum": 2,
    "alum(1)": 2,
    "alumax": 3,
    "alumbaugh": 3,
    "alumina": 4,
    "aluminio": 5,
    "aluminium": 4,
    "aluminium(1)": 4,
    "aluminize": 4,
    "aluminized": 4,
    "aluminosilicate": 7,
    "aluminum": 4,
    "aluminum's": 4,
    "alumna": 3,
    "alumnae": 3,
    "alumni": 3,
    "alumnus": 3,
    "alums": 2,
    "alun": 2,
    "alura": 3,
    "alusuisse": 3,
    "alva": 2,
    "alvah": 2,
    "alvan": 2,
    "alvarado": 4,
    "alvardo": 3,
    "alvare": 2,
    "alvare(1)": 2,
    "alvarenga": 4,
    "alvares": 3,
    "alvarez": 3,
    "alvarez's": 4,
    "alvaro": 3,
    "alvear": 2,
    "alveolar": 4,
    "alveoli": 4,
    "alverez": 3,
    "alvero": 3,
    "alverson": 3,
    "alverton": 3,
    "alves": 2,
    "alvey": 2,
    "alvidrez": 3,
    "alvin": 2,
    "alvina": 3,
    "alvino": 3,
    "alvis": 2,
    "alvita": 3,
    "alvite": 2,
    "alvord": 2,
    "alwaleed": 3,
    "alwaleed(1)": 3,
    "alward": 2,
    "always": 2,
    "always(1)": 2,
    "alwin": 2,
    "alwine": 2,
    "alwood": 2,
    "alwyn": 2,
    "aly": 2,
    "alyce": 2,
    "alyea": 3,
    "alyeska": 4,
    "alyeska's": 3,
    "alys": 2,
    "alysheba": 4,
    "alysia": 4,
    "alyssa": 3,
    "alza": 2,
    "alza's": 2,
    "alzado": 3,
    "alzado(1)": 3,
    "alzena": 3,
    "alzene": 2,
    "alzheimer": 3,
    "alzheimer(1)": 3,
    "alzheimer's": 3,
    "alzheimer's(1)": 3,
    "alzona": 3,
    "am": 1,
    "am(1)": 2,
    "am's": 1,
    "am's(1)": 2,
    "amabel": 3,
    "amabelle": 3,
    "amabile": 3,
    "amacher": 3,
    "amacker": 3,
    "amadea": 4,
    "amadeo": 4,
    "amadeus": 4,
    "amado": 3,
    "amadon": 3,
    "amador": 3,
    "amadou": 3,
    "amagansett": 4,
    "amaker": 3,
    "amakudari": 5,
    "amal": 2,
    "amal's": 2,
    "amalea": 4,
    "amalfitano": 5,
    "amalgam": 3,
    "amalgamate": 4,
    "amalgamated": 5,
    "amalgamated's": 5,
    "amalgamates": 4,
    "amalgamating": 5,
    "amalgamation": 5,
    "amalgams": 3,
    "amalia": 3,
    "amalie": 3,
    "amalya": 3,
    "aman": 2,
    "amana": 3,
    "amanda": 3,
    "amanda's": 3,
    "amandas": 3,
    "amandime": 3,
    "amann": 2,
    "amano": 3,
    "amanpour": 3,
    "amanpour's": 3,
    "amante": 3,
    "amar": 2,
    "amar's": 2,
    "amara": 3,
    "amaral": 3,
    "amarante": 4,
    "amaranth": 3,
    "amaretto": 4,
    "amargosa": 4,
    "amari": 3,
    "amarilla": 4,
    "amarillo": 4,
    "amarillo's": 4,
    "amarillos": 4,
    "amarin": 3,
    "amaris": 3,
    "amaro": 3,
    "amaryllis": 4,
    "amaryllis(1)": 4,
    "amaryllises": 5,
    "amasa": 3,
    "amason": 3,
    "amass": 2,
    "amassed": 2,
    "amasses": 3,
    "amassing": 3,
    "amateur": 3,
    "amateur(1)": 3,
    "amateurish": 4,
    "amateurism": 5,
    "amateurs": 3,
    "amateurs(1)": 3,
    "amati": 3,
    "amatil": 3,
    "amato": 3,
    "amato's": 3,
    "amauligak": 4,
    "amax": 2,
    "amax's": 3,
    "amaya": 3,
    "amaze": 2,
    "amazed": 2,
    "amazement": 3,
    "amazes": 3,
    "amazing": 3,
    "amazingly": 4,
    "amazon": 3,
    "amazon's": 3,
    "amazonia": 5,
    "amazonian": 5,
    "amazonians": 5,
    "amazons": 3,
    "ambac": 2,
    "ambase": 2,
    "ambassador": 4,
    "ambassador's": 4,
    "ambassadorial": 6,
    "ambassadors": 4,
    "ambassadorship": 5,
    "ambassadorships": 5,
    "ambassadress": 4,
    "amber": 2,
    "amber's": 2,
    "amberg": 2,
    "amberger": 3,
    "ambergris": 3,
    "ambers": 2,
    "amberson": 3,
    "ambery": 3,
    "ambiance": 3,
    "ambidextrous": 4,
    "ambidextrous(1)": 4,
    "ambience": 3,
    "ambient": 3,
    "ambiguities": 5,
    "ambiguity": 5,
    "ambiguous": 4,
    "ambisone": 3,
    "ambition": 3,
    "ambitions": 3,
    "ambitious": 3,
    "ambitiously": 4,
    "ambivalence": 4,
    "ambivalent": 4,
    "amble": 2,
    "ambled": 2,
    "ambler": 2,
    "ambles": 2,
    "amblin": 2,
    "ambling": 3,
    "ambling(1)": 2,
    "amborn": 2,
    "amboy": 2,
    "ambra": 2,
    "ambriano": 4,
    "ambrit": 2,
    "ambriz": 2,
    "ambrogio": 4,
    "ambrose": 2,
    "ambrosia": 3,
    "ambrosial": 3,
    "ambrosian": 3,
    "ambrosiano": 5,
    "ambrosine": 4,
    "ambrosini": 4,
    "ambrosino": 4,
    "ambrosio": 4,
    "ambrosius": 4,
    "ambs": 1,
    "ambuehl": 2,
    "ambulance": 3,
    "ambulances": 4,
    "ambulances(1)": 4,
    "ambulatory": 5,
    "amburgey": 3,
    "amburn": 2,
    "ambush": 2,
    "ambushed": 2,
    "ambushes": 3,
    "ambushing": 3,
    "amc": 3,
    "amca": 2,
    "amcast": 2,
    "amcole": 2,
    "amcor": 2,
    "amcore": 2,
    "amdahl": 2,
    "amdahl's": 2,
    "amdec": 2,
    "amdek": 2,
    "amdur": 2,
    "amdura": 3,
    "ame": 1,
    "ameche": 3,
    "amedco": 3,
    "amedee": 3,
    "ameen": 2,
    "amelia": 3,
    "amelinda": 4,
    "ameline": 4,
    "amelio": 4,
    "ameliorate": 4,
    "ameliorated": 6,
    "ameliorated(1)": 5,
    "amelioration": 5,
    "amelita": 4,
    "amell": 2,
    "amen": 2,
    "amen(1)": 2,
    "amenable": 4,
    "amenable(1)": 4,
    "amenaces": 4,
    "amend": 2,
    "amendable": 4,
    "amended": 3,
    "amended(1)": 3,
    "amending": 3,
    "amendment": 3,
    "amendment's": 3,
    "amendments": 3,
    "amendola": 4,
    "amends": 2,
    "amenities": 4,
    "amenities(1)": 4,
    "amenity": 4,
    "ament": 2,
    "amenta": 3,
    "amer": 2,
    "amerada": 4,
    "amerada(1)": 4,
    "amerco": 3,
    "amerford": 3,
    "ameri": 3,
    "ameribanc": 4,
    "america": 4,
    "america(1)": 4,
    "america's": 4,
    "america's(1)": 4,
    "american": 4,
    "american(1)": 4,
    "american's": 4,
    "americana": 5,
    "americana's": 5,
    "americanas": 5,
    "americanism": 6,
    "americanization": 7,
    "americanize": 5,
    "americanized": 5,
    "americano": 5,
    "americanos": 5,
    "americans": 4,
    "americans(1)": 4,
    "americans'": 4,
    "americar": 4,
    "americare": 4,
    "americares": 4,
    "americas": 4,
    "americas(1)": 4,
    "americas'": 4,
    "americo": 4,
    "americold": 4,
    "americorp": 4,
    "americorp(1)": 4,
    "americorps": 4,
    "americus": 4,
    "ameridata": 5,
    "amerifirst": 4,
    "amerifirst's": 4,
    "amerigas": 4,
    "amerigo": 4,
    "amerihost": 4,
    "amerika": 4,
    "amerindian": 5,
    "amerine": 4,
    "ameritech": 4,
    "ameritech's": 4,
    "ameritrust": 4,
    "amerman": 3,
    "amero": 3,
    "ameron": 3,
    "ameron's": 3,
    "amerongen": 4,
    "amersham": 3,
    "amerson": 3,
    "amery": 3,
    "ames": 1,
    "ames'": 1,
    "ames's": 2,
    "amesville": 2,
    "ametek": 3,
    "ametek's": 3,
    "amethyst": 3,
    "amev": 2,
    "amex": 2,
    "amex's": 3,
    "amexco": 3,
    "amexco's": 3,
    "amey": 2,
    "amezcua": 4,
    "amezquita": 4,
    "amfac": 2,
    "amfesco": 3,
    "amgen": 2,
    "amgen's": 2,
    "amherst": 2,
    "amherstdale": 3,
    "amhoist": 2,
    "ami": 2,
    "amiability": 6,
    "amiable": 4,
    "amiably": 4,
    "amicable": 4,
    "amicably": 4,
    "amick": 2,
    "amico": 3,
    "amicone": 3,
    "amicus": 3,
    "amid": 2,
    "amidi": 3,
    "amidon": 3,
    "amidships": 3,
    "amidst": 2,
    "amie": 2,
    "amiga": 3,
    "amigo": 3,
    "amigos": 3,
    "amilia": 4,
    "amin": 2,
    "amino": 3,
    "aminta": 3,
    "amiot": 3,
    "amiprilose": 4,
    "amir": 2,
    "amir(1)": 2,
    "amir's": 2,
    "amir's(1)": 2,
    "amiram": 3,
    "amiran": 3,
    "amirault": 3,
    "amirav": 3,
    "amiri": 3,
    "amis": 2,
    "amish": 2,
    "amish(1)": 2,
    "amison": 3,
    "amiss": 2,
    "amistad": 3,
    "amit": 2,
    "amitai": 3,
    "amity": 3,
    "amityville": 4,
    "amman": 2,
    "amman(1)": 2,
    "ammann": 2,
    "ammeen": 2,
    "ammerman": 3,
    "ammeter": 3,
    "ammeters": 3,
    "ammirati": 4,
    "ammo": 2,
    "ammon": 2,
    "ammonia": 3,
    "ammonite": 3,
    "ammonites": 3,
    "ammonium": 4,
    "ammons": 2,
    "ammunition": 4,
    "ammunitions": 4,
    "amnesia": 3,
    "amnesiac": 4,
    "amnesties": 3,
    "amnesty": 3,
    "amnio": 3,
    "amniocentesis": 6,
    "amniotic": 4,
    "amo": 2,
    "amoco": 3,
    "amoco's": 3,
    "amoeba": 3,
    "amoebas": 3,
    "amoebic": 3,
    "amok": 2,
    "amon": 2,
    "among": 2,
    "amongst": 2,
    "amoolya": 3,
    "amor": 2,
    "amoral": 3,
    "amore": 2,
    "amorette": 3,
    "amorist": 3,
    "amorita": 4,
    "amorosi": 4,
    "amoroso": 4,
    "amorous": 3,
    "amorphous": 3,
    "amortization": 5,
    "amortize": 3,
    "amortized": 3,
    "amortizing": 4,
    "amoruso": 4,
    "amory": 3,
    "amos": 2,
    "amos's": 3,
    "amoskeag": 3,
    "amoskeag's": 3,
    "amoss": 2,
    "amount": 2,
    "amounted": 3,
    "amounted(1)": 3,
    "amounting": 3,
    "amounting(1)": 3,
    "amounts": 2,
    "amoxicillin": 5,
    "amp": 1,
    "ampad": 2,
    "ampal": 2,
    "amparan": 3,
    "ampato": 3,
    "ampco": 2,
    "amperage": 3,
    "ampersand": 3,
    "ampex": 2,
    "amphenol": 3,
    "amphetamine": 4,
    "amphetamines": 4,
    "amphibian": 4,
    "amphibians": 4,
    "amphibious": 4,
    "amphibole": 3,
    "amphibole(1)": 3,
    "amphitheater": 5,
    "amphitheaters": 5,
    "amphitheatre": 5,
    "amphophilic": 4,
    "amphora": 3,
    "amphorae": 3,
    "ample": 2,
    "amplicons": 3,
    "amplification": 5,
    "amplifications": 5,
    "amplified": 3,
    "amplifier": 4,
    "amplifiers": 4,
    "amplifies": 3,
    "amplify": 3,
    "amplifying": 4,
    "ampligen": 3,
    "amplitude": 3,
    "amplocore": 3,
    "amply": 2,
    "ampol": 2,
    "amputate": 3,
    "amputated": 4,
    "amputation": 4,
    "amputations": 4,
    "amputee": 3,
    "amputees": 3,
    "amr": 2,
    "amraam": 2,
    "amre": 2,
    "amrein": 2,
    "amrep": 2,
    "amrhein": 3,
    "amrine": 2,
    "amritsar": 3,
    "amritsar(1)": 3,
    "amro": 2,
    "ams": 1,
    "amsbaugh": 2,
    "amsco": 2,
    "amsden": 2,
    "amsler": 2,
    "amsouth": 2,
    "amspacher": 3,
    "amstar": 2,
    "amster": 2,
    "amsterdam": 3,
    "amsterdam's": 3,
    "amstrad": 2,
    "amstutz": 2,
    "amtech": 2,
    "amtrack": 2,
    "amtrak": 2,
    "amtrak's": 2,
    "amuck": 2,
    "amulet": 3,
    "amulets": 3,
    "amundsen": 3,
    "amundsen(1)": 3,
    "amundson": 3,
    "amuse": 2,
    "amused": 2,
    "amusement": 3,
    "amusements": 3,
    "amusements'": 3,
    "amuses": 3,
    "amusing": 3,
    "amusingly": 4,
    "amvest": 2,
    "amvestor": 3,
    "amvestors": 3,
    "amway": 2,
    "amy": 2,
    "amy's": 2,
    "amygdala": 4,
    "amylin": 3,
    "amyloid": 3,
    "amyotrophic": 5,
    "amyotrophic(1)": 5,
    "amyx": 2,
    "an": 1,
    "an(1)": 1,
    "ana": 2,
    "ana(1)": 2,
    "anabaptist": 4,
    "anable": 3,
    "anabolic": 4,
    "anac": 2,
    "anachronism": 5,
    "anachronisms": 5,
    "anachronistic": 5,
    "anacin": 3,
    "anacker": 3,
    "anacomp": 3,
    "anaconda": 4,
    "anacortes": 4,
    "anacostia": 5,
    "anacostia's": 5,
    "anadarko": 4,
    "anadarko's": 4,
    "anaerobe": 3,
    "anaerobes": 3,
    "anaerobic": 4,
    "anaesthesia": 4,
    "anafranil": 4,
    "anagnos": 3,
    "anagram": 3,
    "anaheim": 3,
    "anal": 2,
    "analgesic": 4,
    "analgesics": 4,
    "analog": 3,
    "analogic": 4,
    "analogies": 4,
    "analogous": 4,
    "analogue": 3,
    "analogy": 4,
    "analyses": 4,
    "analysis": 4,
    "analysis(1)": 4,
    "analyst": 3,
    "analyst(1)": 3,
    "analyst's": 3,
    "analyst's(1)": 3,
    "analysts": 3,
    "analysts(1)": 3,
    "analysts(2)": 3,
    "analysts(3)": 3,
    "analysts'": 3,
    "analysts'(1)": 3,
    "analytic": 4,
    "analytical": 5,
    "analytically": 5,
    "analyticity": 6,
    "analytics": 4,
    "analyzable": 5,
    "analyze": 3,
    "analyzed": 3,
    "analyzer": 4,
    "analyzers": 4,
    "analyzes": 4,
    "analyzing": 4,
    "anamaria": 5,
    "anand": 2,
    "anandale": 3,
    "anandeep": 3,
    "anania": 4,
    "anantha": 3,
    "anaphora": 4,
    "anaphylaxis": 5,
    "anaplasia": 4,
    "anaplastic": 4,
    "anarchic": 3,
    "anarchical": 4,
    "anarchist": 3,
    "anarchists": 3,
    "anarchy": 3,
    "anaren": 3,
    "anas": 2,
    "anasazi": 4,
    "anasazi(1)": 4,
    "anasquan": 3,
    "anast": 2,
    "anastas": 3,
    "anastasi": 4,
    "anastasia": 4,
    "anastasio": 5,
    "anastasio(1)": 5,
    "anastos": 3,
    "anathema": 4,
    "anatola": 4,
    "anatole": 3,
    "anatoli": 4,
    "anatolia": 5,
    "anatolian": 5,
    "anatoly": 4,
    "anatomical": 5,
    "anatomical(1)": 5,
    "anatomically": 5,
    "anatomist": 4,
    "anatomist(1)": 4,
    "anatomy": 4,
    "anawalt": 3,
    "anaya": 3,
    "anbari": 3,
    "ancel": 2,
    "ancell": 2,
    "ancestor": 3,
    "ancestor's": 3,
    "ancestors": 3,
    "ancestors'": 3,
    "ancestral": 3,
    "ancestry": 3,
    "ancheta": 3,
    "ancho": 2,
    "anchondo": 3,
    "anchor": 2,
    "anchor's": 2,
    "anchorage": 3,
    "anchorage(1)": 2,
    "anchored": 2,
    "anchoring": 3,
    "anchorman": 3,
    "anchorman(1)": 3,
    "anchormen": 3,
    "anchors": 2,
    "anchovies": 3,
    "anchovies(1)": 3,
    "anchovy": 3,
    "anchovy(1)": 3,
    "ancient": 2,
    "ancient(1)": 2,
    "ancients": 2,
    "ancients(1)": 2,
    "ancillary": 4,
    "ancira": 3,
    "ancona": 3,
    "ancrum": 2,
    "anctil": 2,
    "and": 1,
    "and(1)": 1,
    "andal": 2,
    "andalusia": 4,
    "andalusian": 4,
    "andante": 3,
    "andantino": 4,
    "andean": 3,
    "andel": 2,
    "ander": 2,
    "andera": 3,
    "anderberg": 3,
    "anderegg": 3,
    "anderle": 3,
    "anderlini": 4,
    "anderman": 3,
    "anders": 2,
    "andersen": 3,
    "andersen's": 3,
    "anderson": 3,
    "anderson's": 3,
    "andersons": 3,
    "andersonville": 4,
    "andersson": 3,
    "andert": 2,
    "anderton": 3,
    "andes": 2,
    "andesite": 3,
    "andie": 2,
    "anding": 2,
    "andino": 3,
    "andiron": 3,
    "andis": 2,
    "andler": 2,
    "ando": 2,
    "andolina": 4,
    "andonian": 4,
    "andoras": 3,
    "andorra": 3,
    "andover": 3,
    "andrada": 3,
    "andrade": 2,
    "andrae": 2,
    "andraki": 3,
    "andras": 2,
    "andre": 2,
    "andrea": 3,
    "andrea(1)": 3,
    "andrea's": 3,
    "andrea's(1)": 3,
    "andreae": 3,
    "andreana": 3,
    "andreana(1)": 4,
    "andreani": 3,
    "andreani(1)": 4,
    "andreano": 3,
    "andreano(1)": 4,
    "andreas": 3,
    "andreasen": 3,
    "andreason": 3,
    "andreassen": 3,
    "andree": 2,
    "andreen": 2,
    "andrei": 2,
    "andreini": 4,
    "andrej": 2,
    "andren": 3,
    "andreoli": 4,
    "andreoni": 4,
    "andreotti": 4,
    "andreotti(1)": 4,
    "andreozzi": 4,
    "andrepont": 3,
    "andres": 2,
    "andres(1)": 2,
    "andresen": 3,
    "andreski": 3,
    "andress": 2,
    "andretti": 3,
    "andretti's": 3,
    "andreu": 2,
    "andrew": 2,
    "andrew's": 2,
    "andrews": 2,
    "andrews'": 2,
    "andrey": 2,
    "andrezak": 3,
    "andria": 3,
    "andriana": 4,
    "andriano": 4,
    "andric": 2,
    "andrich": 2,
    "andrick": 2,
    "andries": 2,
    "andriessen": 3,
    "andringa": 3,
    "andriola": 4,
    "andrist": 2,
    "androgynous": 4,
    "androgyny": 4,
    "android": 2,
    "androids": 2,
    "andromeda": 4,
    "andropov": 3,
    "andros": 2,
    "andrus": 2,
    "andruskevich": 4,
    "andry": 2,
    "andrzej": 2,
    "andrzejewski": 4,
    "ands": 1,
    "andujar": 3,
    "andy": 2,
    "andy's": 2,
    "ane": 1,
    "ane(1)": 1,
    "anecdotal": 4,
    "anecdotal(1)": 4,
    "anecdotally": 5,
    "anecdotally(1)": 5,
    "anecdote": 3,
    "anecdotes": 3,
    "anecdotes(1)": 3,
    "anello": 3,
    "anemia": 4,
    "anemias": 4,
    "anemic": 3,
    "anemometer": 5,
    "anemone": 3,
    "anemone(1)": 4,
    "anencephalic": 5,
    "anencephalic(1)": 5,
    "anencephaly": 5,
    "anestachio": 5,
    "anesthesia": 4,
    "anesthesiologist": 7,
    "anesthesiologists": 7,
    "anesthesiologists(1)": 7,
    "anesthesiology": 7,
    "anesthetic": 4,
    "anesthetics": 4,
    "anesthetist": 4,
    "anette": 2,
    "aneurism": 4,
    "aneurism(1)": 3,
    "anew": 2,
    "anew(1)": 2,
    "anfal": 5,
    "anfal(1)": 2,
    "anfinson": 3,
    "ang": 1,
    "ange": 1,
    "angel": 2,
    "angela": 3,
    "angela's": 3,
    "angeleno": 4,
    "angeleno(1)": 4,
    "angelenos": 4,
    "angelenos(1)": 4,
    "angeles": 3,
    "angeles'": 3,
    "angeles's": 4,
    "angeletti": 4,
    "angelfish": 3,
    "angeli": 3,
    "angelic": 3,
    "angelica": 4,
    "angelica(1)": 4,
    "angelically": 4,
    "angelicas": 4,
    "angelico": 4,
    "angelika": 4,
    "angelillo": 4,
    "angelina": 4,
    "angeline": 3,
    "angeline(1)": 3,
    "angelini": 4,
    "angelino": 4,
    "angelino(1)": 4,
    "angelino's": 4,
    "angelino's(1)": 4,
    "angelinos": 4,
    "angelinos(1)": 4,
    "angelita": 4,
    "angell": 2,
    "angelle": 2,
    "angello": 3,
    "angelo": 3,
    "angelo's": 3,
    "angeloff": 3,
    "angeloff(1)": 3,
    "angelone": 4,
    "angeloni": 4,
    "angelos": 3,
    "angelou": 3,
    "angeloz": 3,
    "angels": 2,
    "angels'": 2,
    "angelucci": 4,
    "anger": 2,
    "angered": 2,
    "angerer": 3,
    "angering": 3,
    "angerman": 3,
    "angermeier": 4,
    "angers": 2,
    "angert": 2,
    "angevine": 3,
    "angi": 2,
    "angie": 2,
    "angier": 3,
    "angina": 3,
    "angio": 3,
    "angiogram": 4,
    "angiomedic": 5,
    "angiomedics": 5,
    "angioplasty": 5,
    "angiotensin": 5,
    "angle": 2,
    "angled": 2,
    "anglemyer": 4,
    "anglen": 3,
    "angler": 2,
    "anglers": 2,
    "angles": 2,
    "angleton": 3,
    "angley": 2,
    "anglia": 3,
    "anglican": 3,
    "anglicize": 3,
    "anglicized": 3,
    "anglim": 2,
    "anglin": 2,
    "angling": 2,
    "anglo": 2,
    "anglo-catholicism": 7,
    "anglophile": 3,
    "anglos": 2,
    "anglos(1)": 2,
    "angola": 3,
    "angola's": 3,
    "angolan": 3,
    "angolans": 3,
    "angora": 3,
    "angoras": 3,
    "angotti": 3,
    "angove": 3,
    "angrier": 3,
    "angriest": 3,
    "angrily": 3,
    "angry": 2,
    "angst": 1,
    "angstadt": 2,
    "angstadt(1)": 2,
    "angstrom": 2,
    "angstroms": 2,
    "anguiano": 4,
    "anguilla": 3,
    "anguish": 2,
    "anguished": 2,
    "anguishing": 3,
    "angular": 3,
    "angulate": 3,
    "angulated": 4,
    "angulo": 3,
    "angus": 2,
    "angy": 2,
    "anhalt": 2,
    "anheuser": 3,
    "anheuser's": 3,
    "anhydride": 3,
    "aniak": 3,
    "anibal": 3,
    "anikst": 2,
    "aniline": 3,
    "animal": 3,
    "animal's": 3,
    "animals": 3,
    "animals'": 3,
    "animate": 3,
    "animate(1)": 3,
    "animated": 4,
    "animated(1)": 4,
    "animates": 3,
    "animates(1)": 3,
    "animation": 4,
    "animations": 4,
    "animator": 4,
    "animators": 4,
    "animism": 4,
    "animist": 3,
    "animists": 3,
    "animists(1)": 3,
    "animosities": 5,
    "animosity": 5,
    "animous": 3,
    "animus": 3,
    "aninat": 3,
    "anise": 2,
    "aniseed": 3,
    "anisette": 3,
    "anita": 3,
    "anitec": 3,
    "anitole": 3,
    "anixter": 3,
    "anja": 2,
    "anjelica": 4,
    "ankara": 3,
    "ankara's": 3,
    "ankeney": 3,
    "ankeny": 3,
    "anker": 2,
    "ankerium": 4,
    "ankh": 1,
    "anklam": 2,
    "ankle": 2,
    "anklebone": 3,
    "ankles": 2,
    "anklet": 2,
    "anklets": 2,
    "ankney": 2,
    "ankrom": 2,
    "ankrum": 2,
    "ann": 1,
    "ann's": 1,
    "anna": 2,
    "anna's": 2,
    "annabel": 3,
    "annabella": 4,
    "annabelle": 3,
    "annable": 3,
    "annal": 2,
    "annals": 2,
    "annamese": 3,
    "annan": 2,
    "annandale": 3,
    "annapolis": 4,
    "annapolis's": 5,
    "annas": 2,
    "annaud": 2,
    "anne": 1,
    "anne's": 1,
    "anneal": 2,
    "annealing": 3,
    "annelid": 3,
    "annelids": 3,
    "annen": 2,
    "annenberg": 3,
    "annese": 3,
    "annett": 2,
    "annette": 2,
    "annex": 2,
    "annex(1)": 2,
    "annexation": 4,
    "annexed": 2,
    "annexed(1)": 2,
    "annexes": 3,
    "annexing": 3,
    "annick": 2,
    "annie": 2,
    "annie's": 2,
    "annihilate": 4,
    "annihilated": 5,
    "annihilating": 5,
    "annihilation": 5,
    "annis": 2,
    "anniston": 3,
    "anniston(1)": 3,
    "anniversaries": 5,
    "anniversary": 5,
    "anno": 2,
    "annotate": 3,
    "annotated": 4,
    "annotated(1)": 4,
    "annotates": 3,
    "annotates(1)": 3,
    "annotating": 4,
    "annotating(1)": 4,
    "annotation": 4,
    "annotations": 4,
    "announce": 2,
    "announced": 2,
    "announcement": 3,
    "announcement(1)": 3,
    "announcements": 3,
    "announcer": 3,
    "announcers": 3,
    "announces": 3,
    "announcing": 3,
    "announcment": 3,
    "annoy": 2,
    "annoyance": 3,
    "annoyances": 4,
    "annoyed": 2,
    "annoying": 3,
    "annoys": 2,
    "annual": 3,
    "annualize": 4,
    "annualized": 4,
    "annually": 4,
    "annuals": 3,
    "annuit": 3,
    "annuities": 4,
    "annuity": 4,
    "annuity(1)": 4,
    "annuity(2)": 4,
    "annul": 2,
    "annular": 3,
    "annulled": 2,
    "annulment": 3,
    "annum": 2,
    "annunciata": 4,
    "annunziata": 5,
    "annunziato": 5,
    "annunzio": 4,
    "annunzio(1)": 4,
    "anny": 2,
    "ano": 2,
    "ano(1)": 2,
    "anode": 2,
    "anodes": 2,
    "anoint": 2,
    "anointed": 3,
    "anointed(1)": 3,
    "anointed(2)": 3,
    "anointed(3)": 3,
    "anomalies": 4,
    "anomalous": 4,
    "anomaly": 4,
    "anomie": 3,
    "anona": 3,
    "anonymity": 5,
    "anonymous": 4,
    "anonymously": 5,
    "anora": 3,
    "anorak": 3,
    "anorexia": 5,
    "anorexic": 4,
    "anorexics": 4,
    "anorthite": 3,
    "another": 3,
    "another's": 3,
    "anreder": 3,
    "anrig": 2,
    "ansa": 2,
    "ansa's": 2,
    "ansaid": 2,
    "ansaldo": 3,
    "ansang": 2,
    "ansari": 3,
    "ansbacher": 3,
    "anschel": 2,
    "anschluss": 2,
    "anschluss(1)": 2,
    "anschutz": 2,
    "anscom": 2,
    "anscomb": 2,
    "anse": 1,
    "ansel": 2,
    "ansell": 2,
    "anselm": 2,
    "anselma": 3,
    "anselmi": 3,
    "anselmo": 3,
    "ansett": 2,
    "ansgar": 2,
    "ansgar's": 2,
    "anshan": 2,
    "ansin": 2,
    "ansley": 2,
    "ansohn": 2,
    "anson": 2,
    "ansonia": 4,
    "anspach": 2,
    "anspaugh": 2,
    "anstead": 2,
    "anstett": 2,
    "anstey": 2,
    "anstice": 2,
    "anstine": 3,
    "anstiss": 2,
    "answer": 2,
    "answer's": 2,
    "answerable": 4,
    "answered": 2,
    "answering": 3,
    "answers": 2,
    "ant": 1,
    "antacid": 3,
    "antacids": 3,
    "antagonism": 5,
    "antagonisms": 5,
    "antagonist": 4,
    "antagonistic": 5,
    "antagonists": 4,
    "antagonists(1)": 4,
    "antagonize": 4,
    "antagonized": 4,
    "antagonizing": 5,
    "antal": 2,
    "antar": 2,
    "antar's": 2,
    "antarctic": 3,
    "antarctic(1)": 3,
    "antarctica": 4,
    "antarctica(1)": 4,
    "antarctica's": 4,
    "antares": 3,
    "antaya": 3,
    "antczak": 2,
    "ante": 2,
    "anteater": 3,
    "anteaters": 3,
    "antebellum": 4,
    "antec": 2,
    "antecedent": 4,
    "antecedent(1)": 4,
    "antecedents": 4,
    "antecedents(1)": 4,
    "anted": 2,
    "anted(1)": 2,
    "antell": 2,
    "antelope": 3,
    "antemeridian": 6,
    "antemortem": 4,
    "antenna": 3,
    "antenna's": 3,
    "antennae": 3,
    "antennas": 3,
    "antenne": 2,
    "antenucci": 4,
    "anterior": 4,
    "anteriormost": 5,
    "antes": 2,
    "anthea": 3,
    "anthem": 2,
    "anthems": 2,
    "anthes": 2,
    "anthiel": 3,
    "anthill": 2,
    "anthills": 2,
    "anthis": 2,
    "anthologies": 4,
    "anthology": 4,
    "anthon": 2,
    "anthony": 3,
    "anthony's": 3,
    "anthracite": 3,
    "anthrax": 2,
    "anthrobot": 3,
    "anthropocentric": 5,
    "anthropogenic": 5,
    "anthropological": 6,
    "anthropologist": 5,
    "anthropologist(1)": 5,
    "anthropologists": 5,
    "anthropologists(1)": 5,
    "anthropology": 5,
    "anthropomorphic": 5,
    "anthropomorphism": 6,
    "anti": 2,
    "anti(1)": 2,
    "anti-catholicism": 7,
    "anti-catholicism(1)": 7,
    "anti-federalist": 5,
    "anti-federalists": 5,
    "anti-infective": 5,
    "antiabortion": 5,
    "antiabortion(1)": 5,
    "antiaircraft": 4,
    "antibacterial": 6,
    "antiballistic": 5,
    "antibiotic": 5,
    "antibiotic(1)": 5,
    "antibioticos": 6,
    "antibiotics": 5,
    "antibiotics(1)": 5,
    "antibodies": 4,
    "antibodies(1)": 4,
    "antibodies(2)": 4,
    "antibody": 4,
    "antibody(1)": 4,
    "antic": 2,
    "anticancer": 4,
    "anticancer(1)": 4,
    "anticipate": 4,
    "anticipated": 5,
    "anticipated(1)": 5,
    "anticipates": 4,
    "anticipating": 5,
    "anticipation": 5,
    "anticipation(1)": 5,
    "anticipations": 5,
    "anticipations(1)": 5,
    "anticipatory": 6,
    "anticlimactic": 5,
    "anticline": 3,
    "antico": 3,
    "anticommunist": 5,
    "anticompetitive": 6,
    "anticorruption": 5,
    "anticorruption(1)": 5,
    "anticrime": 3,
    "anticrime(1)": 3,
    "antics": 2,
    "antidepressant": 5,
    "antidepressants": 5,
    "antidepressants(1)": 5,
    "antidiscrimination": 7,
    "antidiscrimination(1)": 7,
    "antidisestablishmentarianism": 12,
    "antidote": 3,
    "antidote(1)": 3,
    "antidrug": 3,
    "antidumping": 4,
    "antidumping(1)": 4,
    "antifraud": 3,
    "antifraud(1)": 3,
    "antifreeze": 3,
    "antifungal": 4,
    "antifungal(1)": 4,
    "antigay": 3,
    "antigay(1)": 3,
    "antigen": 3,
    "antigens": 3,
    "antigone": 4,
    "antigone's": 4,
    "antigones": 4,
    "antigovernment": 5,
    "antigovernment(1)": 5,
    "antigua": 3,
    "antihistamine": 5,
    "antihistamines": 5,
    "antiknock": 3,
    "antill": 2,
    "antilla": 3,
    "antilles": 3,
    "antilock": 3,
    "antilock(1)": 3,
    "antimatter": 4,
    "antimissile": 4,
    "antioch": 3,
    "antiochus": 4,
    "antioxidant": 5,
    "antioxidants": 5,
    "antipathies": 4,
    "antipathy": 4,
    "antipersonell": 5,
    "antiphon": 3,
    "antiphon(1)": 3,
    "antiphons": 3,
    "antiphons(1)": 3,
    "antipodal": 4,
    "antipoverty": 5,
    "antipoverty(1)": 5,
    "antiquate": 3,
    "antiquated": 4,
    "antiquated(1)": 4,
    "antique": 2,
    "antiques": 2,
    "antiquities": 4,
    "antiquity": 4,
    "antireformer": 5,
    "antireformer(1)": 5,
    "antireformers": 5,
    "antireformers(1)": 5,
    "antis": 2,
    "antisense": 3,
    "antisense(1)": 3,
    "antiseptic": 4,
    "antismoking": 4,
    "antismoking(1)": 4,
    "antisocial": 4,
    "antisocial(1)": 4,
    "antisubmarine": 5,
    "antisubmarine(1)": 5,
    "antitakeover": 5,
    "antitank": 3,
    "antitax": 3,
    "antitax(1)": 3,
    "antitheft": 3,
    "antitheft(1)": 3,
    "antithesis": 4,
    "antithetical": 5,
    "antitoxin": 4,
    "antitoxins": 4,
    "antitrust": 3,
    "antiviral": 4,
    "antiwar": 3,
    "antiwar(1)": 3,
    "antkowiak": 4,
    "antle": 2,
    "antler": 2,
    "antlered": 2,
    "antlers": 2,
    "antley": 2,
    "antoine": 2,
    "antoinette": 3,
    "antol": 2,
    "antolik": 3,
    "antolini": 4,
    "anton": 2,
    "antonacci": 4,
    "antone": 3,
    "antonelli": 4,
    "antonellis": 4,
    "antonetti": 4,
    "antoni": 3,
    "antonia": 4,
    "antonin": 3,
    "antonini": 4,
    "antonini's": 4,
    "antonio": 4,
    "antonio's": 4,
    "antonios": 4,
    "antoniou": 4,
    "antoniu": 4,
    "antoniu's": 4,
    "antonius": 4,
    "antonopoulos": 5,
    "antonovich": 4,
    "antonsen": 3,
    "antonson": 3,
    "antonucci": 4,
    "antony": 3,
    "antoon": 2,
    "antos": 2,
    "antosh": 2,
    "antril": 2,
    "antrim": 2,
    "antrobus": 3,
    "antroscope": 3,
    "ants": 1,
    "antsy": 2,
    "anttila": 3,
    "antuna": 3,
    "antunes": 3,
    "antunez": 3,
    "antwerp": 2,
    "antwine": 2,
    "anus": 2,
    "anvil": 2,
    "anwar": 2,
    "anwar(1)": 2,
    "anway": 2,
    "anwell": 2,
    "anwyl": 2,
    "anwyll": 2,
    "anxieties": 4,
    "anxiety": 4,
    "anxious": 2,
    "anxious(1)": 2,
    "anxiously": 3,
    "any": 2,
    "anybody": 4,
    "anybody's": 4,
    "anyhow": 3,
    "anymore": 3,
    "anyon": 3,
    "anyone": 3,
    "anyone(1)": 3,
    "anyone'll": 4,
    "anyone's": 3,
    "anyplace": 3,
    "anything": 3,
    "anything's": 3,
    "anytime": 3,
    "anytime'll": 4,
    "anytime's": 3,
    "anyway": 3,
    "anyways": 3,
    "anywhere": 3,
    "anywhere(1)": 3,
    "anza": 2,
    "anzaldua": 4,
    "anzalone": 3,
    "anzelmo": 3,
    "anzio": 3,
    "anzus": 2,
    "aoi": 2,
    "aoki": 3,
    "aol": 3,
    "aol(1)": 6,
    "aon": 2,
    "aorta": 3,
    "aortic": 3,
    "aoshima": 3,
    "aoshima(1)": 4,
    "aoun": 2,
    "aoun(1)": 2,
    "aoun's": 2,
    "aoun's(1)": 2,
    "aouzou": 3,
    "aoyama": 3,
    "aoyama(1)": 4,
    "apace": 2,
    "apache": 3,
    "apache's": 3,
    "apaches": 3,
    "apacs": 2,
    "apalachicola": 6,
    "apalachicola's": 6,
    "aparicio": 5,
    "apart": 2,
    "apartheid": 3,
    "apartheid(1)": 3,
    "apartheid's": 3,
    "apartheid's(1)": 3,
    "apartment": 3,
    "apartments": 3,
    "apathetic": 4,
    "apathy": 3,
    "apatite": 3,
    "apatites": 3,
    "apc": 3,
    "apc's": 3,
    "apcar": 2,
    "apcar(1)": 2,
    "ape": 1,
    "apec": 2,
    "apec's": 2,
    "apel": 2,
    "apelike": 2,
    "apennine": 3,
    "aperitif": 4,
    "aperture": 3,
    "apes": 1,
    "apex": 2,
    "apex's": 3,
    "apfel": 2,
    "apfelbaum": 3,
    "apgar": 2,
    "aphasia": 3,
    "aphid": 2,
    "aphid(1)": 2,
    "aphids": 2,
    "aphids(1)": 2,
    "aphorism": 4,
    "aphorisms": 4,
    "aphrodisiac": 5,
    "aphrodite": 4,
    "aphrodite's": 4,
    "aphrodites": 4,
    "apicella": 4,
    "apiece": 2,
    "aping": 2,
    "aplenty": 3,
    "aplin": 2,
    "aplomb": 2,
    "apnea": 3,
    "apocalypse": 4,
    "apocalyptic": 5,
    "apocryphal": 4,
    "apodaca": 4,
    "apogee": 3,
    "apolitical": 5,
    "apolline": 3,
    "apollinian": 5,
    "apollo": 3,
    "apollo's": 3,
    "apollonian": 5,
    "apologetic": 5,
    "apologetically": 6,
    "apologies": 4,
    "apologist": 4,
    "apologists": 4,
    "apologize": 4,
    "apologized": 4,
    "apologizes": 5,
    "apologizing": 5,
    "apology": 4,
    "aponte": 3,
    "apopa": 3,
    "apopka": 3,
    "apoplectic": 4,
    "apoplexy": 4,
    "apoptosis": 4,
    "apostate": 3,
    "apostle": 3,
    "apostles": 3,
    "apostol": 3,
    "apostolopoul": 5,
    "apostrophe": 4,
    "apothecary": 5,
    "apotheosis": 5,
    "app": 1,
    "appalachia": 5,
    "appalachian": 4,
    "appalachian(1)": 4,
    "appalachian(2)": 4,
    "appalachians": 4,
    "appalachians(1)": 4,
    "appalachians(2)": 4,
    "appall": 2,
    "appalled": 2,
    "appalling": 3,
    "appallingly": 4,
    "appalls": 2,
    "apparatchik": 4,
    "apparatchiks": 4,
    "apparatus": 4,
    "apparatuses": 5,
    "apparel": 3,
    "apparel(1)": 3,
    "apparent": 3,
    "apparently": 4,
    "apparition": 4,
    "apparitions": 4,
    "appeal": 2,
    "appealable": 4,
    "appealed": 2,
    "appealing": 3,
    "appealingly": 4,
    "appeals": 2,
    "appear": 2,
    "appearance": 3,
    "appearances": 4,
    "appeared": 2,
    "appearing": 3,
    "appears": 2,
    "appease": 2,
    "appeased": 2,
    "appeasement": 3,
    "appeasing": 3,
    "appel": 2,
    "appelbaum": 3,
    "appelhans": 3,
    "appell": 2,
    "appellate": 3,
    "appellate(1)": 3,
    "appellation": 4,
    "appellations": 4,
    "appelman": 3,
    "appelt": 2,
    "append": 2,
    "appendage": 3,
    "appendages": 4,
    "appendectomies": 5,
    "appendectomy": 5,
    "appended": 3,
    "appendicitis": 5,
    "appendix": 3,
    "appendixes": 4,
    "appenzeller": 4,
    "apperson": 3,
    "appert": 2,
    "appetite": 3,
    "appetites": 3,
    "appetito": 4,
    "appetizer": 4,
    "appetizers": 4,
    "appetizing": 4,
    "appia": 3,
    "appian": 3,
    "applaud": 2,
    "applauded": 3,
    "applauded(1)": 3,
    "applauding": 3,
    "applauds": 2,
    "applause": 2,
    "apple": 2,
    "apple's": 2,
    "appleans": 2,
    "applebaum": 3,
    "applebee": 3,
    "applebee's": 3,
    "appleberry": 4,
    "appleby": 3,
    "applegarth": 3,
    "applegate": 3,
    "appleman": 3,
    "applequist": 3,
    "apples": 2,
    "applesauce": 3,
    "appleseed": 3,
    "appleshare": 3,
    "applet": 2,
    "appleton": 3,
    "applewhite": 3,
    "appleyard": 3,
    "appliance": 3,
    "appliances": 4,
    "appliances(1)": 4,
    "applicability": 6,
    "applicable": 4,
    "applicant": 3,
    "applicant's": 3,
    "applicants": 3,
    "applicants'": 3,
    "application": 4,
    "applications": 4,
    "applicator": 4,
    "applicators": 4,
    "applied": 2,
    "applies": 2,
    "applin": 2,
    "appling": 3,
    "appling(1)": 2,
    "apply": 2,
    "applying": 3,
    "appoint": 2,
    "appointed": 3,
    "appointed(1)": 3,
    "appointee": 3,
    "appointee(1)": 3,
    "appointees": 3,
    "appointees(1)": 3,
    "appointing": 3,
    "appointive": 3,
    "appointment": 3,
    "appointments": 3,
    "appoints": 2,
    "apportion": 3,
    "apportioned": 3,
    "apportioning": 4,
    "apportionment": 4,
    "appraisal": 3,
    "appraisals": 3,
    "appraise": 2,
    "appraised": 2,
    "appraiser": 3,
    "appraisers": 3,
    "appraises": 3,
    "appraising": 3,
    "appreciable": 4,
    "appreciably": 4,
    "appreciate": 4,
    "appreciated": 5,
    "appreciates": 4,
    "appreciating": 5,
    "appreciation": 5,
    "appreciative": 5,
    "appreciative(1)": 4,
    "appreciatively": 6,
    "appreciatively(1)": 5,
    "apprehend": 3,
    "apprehended": 4,
    "apprehending": 4,
    "apprehension": 4,
    "apprehensions": 4,
    "apprehensive": 4,
    "apprehensive(1)": 4,
    "apprentice": 3,
    "apprentice(1)": 3,
    "apprenticed": 3,
    "apprentices": 4,
    "apprenticeship": 4,
    "apprenticeships": 4,
    "apprise": 2,
    "apprised": 2,
    "appro": 2,
    "approach": 2,
    "approachable": 4,
    "approached": 2,
    "approaches": 3,
    "approaches(1)": 3,
    "approaching": 3,
    "approbation": 4,
    "appropriate": 4,
    "appropriate(1)": 4,
    "appropriated": 5,
    "appropriately": 5,
    "appropriateness": 5,
    "appropriates": 4,
    "appropriating": 5,
    "appropriation": 5,
    "appropriations": 5,
    "appropriator": 5,
    "appropriators": 5,
    "approvable": 4,
    "approval": 3,
    "approvals": 3,
    "approve": 2,
    "approved": 2,
    "approves": 2,
    "approving": 3,
    "approvingly": 4,
    "approximate": 4,
    "approximate(1)": 4,
    "approximated": 5,
    "approximately": 5,
    "approximates": 4,
    "approximates(1)": 4,
    "approximating": 5,
    "approximation": 5,
    "approximations": 5,
    "apps": 1,
    "apra": 2,
    "aprea": 3,
    "apricot": 3,
    "apricots": 3,
    "april": 2,
    "april's": 2,
    "aprile": 2,
    "apriori": 4,
    "aprodiva": 4,
    "apron": 2,
    "aprons": 2,
    "apropos": 3,
    "apsell": 2,
    "apsey": 2,
    "apso": 2,
    "apstar": 2,
    "apt": 1,
    "apter": 2,
    "aptitude": 3,
    "aptitudes": 3,
    "aptiva": 3,
    "aptly": 2,
    "apuzzo": 3,
    "aqaba": 3,
    "aqazadeh": 4,
    "aqua": 2,
    "aqua(1)": 2,
    "aquaculture": 4,
    "aqualung": 3,
    "aquamarine": 4,
    "aquanaut": 3,
    "aquanauts": 3,
    "aquarist": 3,
    "aquarists": 3,
    "aquarium": 4,
    "aquariums": 4,
    "aquarius": 4,
    "aquatic": 3,
    "aquatic(1)": 3,
    "aqueduct": 3,
    "aqueducts": 3,
    "aqueous": 3,
    "aquifer": 3,
    "aquifers": 3,
    "aquila": 3,
    "aquilar": 3,
    "aquilina": 4,
    "aquilino": 4,
    "aquinas": 3,
    "aquino": 3,
    "aquino's": 3,
    "aquirre": 2,
    "aquitaine": 3,
    "ar": 1,
    "ara": 2,
    "arab": 2,
    "arab(1)": 2,
    "arabe": 3,
    "arabella": 4,
    "arabia": 4,
    "arabia's": 4,
    "arabian": 4,
    "arabians": 4,
    "arabic": 3,
    "arabic(1)": 3,
    "arabica": 4,
    "arabichon": 4,
    "arabichon's": 4,
    "arabicon": 4,
    "arabie": 3,
    "arable": 3,
    "arabs": 2,
    "arabs(1)": 2,
    "arabs'": 2,
    "arachnid": 3,
    "arachnid(1)": 3,
    "arachnids": 3,
    "arachnids(1)": 3,
    "arafat": 3,
    "arafat's": 3,
    "arafat's(1)": 3,
    "aragon": 3,
    "aragona": 4,
    "arai": 3,
    "araiza": 3,
    "arakaki": 4,
    "arakawa": 4,
    "arakelian": 4,
    "araki": 3,
    "aral": 2,
    "arambula": 4,
    "aramco": 3,
    "aramid": 3,
    "araminta": 4,
    "aramis": 3,
    "aramony": 4,
    "aramony(1)": 4,
    "aran": 2,
    "arana": 3,
    "aranda": 3,
    "arango": 3,
    "aransas": 3,
    "arant": 2,
    "arantza": 3,
    "aranyos": 3,
    "arapaho": 4,
    "arapahoe": 4,
    "ararat": 3,
    "araskog": 3,
    "araskog(1)": 3,
    "arata": 3,
    "arau": 2,
    "araujo": 3,
    "aravind": 2,
    "araya": 3,
    "arb": 1,
    "arba": 2,
    "arbat": 2,
    "arbaugh": 2,
    "arbed": 2,
    "arbeiter": 3,
    "arbel": 2,
    "arbella": 3,
    "arbenz": 2,
    "arbiter": 3,
    "arbiters": 3,
    "arbitrage": 3,
    "arbitrager": 4,
    "arbitragers": 4,
    "arbitragers'": 4,
    "arbitrageur": 4,
    "arbitrageurs": 4,
    "arbitraging": 4,
    "arbitrarily": 5,
    "arbitrariness": 5,
    "arbitrary": 4,
    "arbitrary(1)": 4,
    "arbitrate": 3,
    "arbitrated": 4,
    "arbitrates": 3,
    "arbitrating": 4,
    "arbitration": 4,
    "arbitrations": 4,
    "arbitrator": 4,
    "arbitrator's": 4,
    "arbitrators": 4,
    "arbitrators'": 4,
    "arbitron": 3,
    "arbitron(1)": 3,
    "arbo": 2,
    "arbogast": 3,
    "arboleda": 4,
    "arbor": 2,
    "arboreal": 4,
    "arboretum": 4,
    "arborville": 3,
    "arbothnott": 3,
    "arbour": 2,
    "arbs": 1,
    "arbuckle": 3,
    "arbuckles": 3,
    "arbuthnot": 3,
    "arby": 2,
    "arby's": 2,
    "arc": 1,
    "arcade": 2,
    "arcades": 2,
    "arcadia": 4,
    "arcadian": 4,
    "arcadians": 4,
    "arcana": 3,
    "arcand": 2,
    "arcane": 2,
    "arcanum": 3,
    "arcanum's": 3,
    "arcaro": 3,
    "arcata": 3,
    "arce": 1,
    "arcement": 3,
    "arceneaux": 3,
    "arceo": 3,
    "arch": 1,
    "archaeological": 6,
    "archaeologist": 5,
    "archaeologists": 5,
    "archaeology": 5,
    "archaic": 3,
    "archambault": 3,
    "archambeau": 3,
    "archambeault": 3,
    "archangel": 3,
    "archangels": 3,
    "archard": 2,
    "archbishop": 3,
    "archbold": 2,
    "archdiocese": 4,
    "archdiocese(1)": 4,
    "archduke": 2,
    "arched": 1,
    "archenemy": 4,
    "archeological": 6,
    "archeology": 5,
    "archer": 2,
    "archer's": 2,
    "archerd": 2,
    "archery": 3,
    "arches": 2,
    "arches(1)": 2,
    "archetypal": 3,
    "archetype": 3,
    "archetypes": 3,
    "archey": 2,
    "archibald": 3,
    "archibeque": 3,
    "archie": 2,
    "archimedes": 4,
    "arching": 2,
    "archipelago": 5,
    "archipelago(1)": 5,
    "architect": 3,
    "architect's": 3,
    "architects": 3,
    "architectural": 5,
    "architecturally": 6,
    "architecturally(1)": 5,
    "architecture": 4,
    "architecture's": 4,
    "architectures": 4,
    "architrave": 3,
    "architraves": 3,
    "archival": 3,
    "archive": 2,
    "archives": 2,
    "archivist": 3,
    "archivist(1)": 3,
    "archivists": 3,
    "archivists(1)": 3,
    "archly": 2,
    "archrival": 3,
    "archrivals": 3,
    "archuleta": 4,
    "archuletta": 4,
    "archway": 2,
    "arcidiacono": 6,
    "arcieri": 3,
    "arciniega": 4,
    "arco": 2,
    "arco's": 2,
    "arcola": 3,
    "arcos": 2,
    "arcosanti": 4,
    "arcs": 1,
    "arctic": 2,
    "arctic(1)": 2,
    "arcturus": 3,
    "arcturus(1)": 3,
    "arcuri": 3,
    "ard": 1,
    "arda": 2,
    "ardath": 2,
    "ardeen": 2,
    "ardelia": 4,
    "ardella": 3,
    "ardelle": 2,
    "arden": 2,
    "arden's": 2,
    "ardene": 2,
    "ardent": 2,
    "ardently": 3,
    "ardin": 2,
    "ardine": 3,
    "ardis": 2,
    "ardith": 2,
    "ardito": 3,
    "ardley": 2,
    "ardmore": 2,
    "ardoin": 2,
    "ardolino": 4,
    "ardolph": 2,
    "ardor": 2,
    "ardoyne": 2,
    "ardra": 2,
    "ardrey": 2,
    "ardshiel": 2,
    "ardsley": 2,
    "arduini": 4,
    "arduous": 3,
    "are": 1,
    "are(1)": 1,
    "area": 3,
    "area's": 3,
    "areas": 3,
    "arebalo": 4,
    "arechiga": 4,
    "arehart": 3,
    "arel": 2,
    "arellanes": 3,
    "arellano": 4,
    "aren": 2,
    "aren't": 2,
    "aren't(1)": 1,
    "arena": 3,
    "arena's": 3,
    "arenaball": 4,
    "arenas": 3,
    "arencibia": 5,
    "arend": 2,
    "arends": 2,
    "arendsee": 3,
    "arendt": 2,
    "arenella": 4,
    "arenella's": 4,
    "arens": 2,
    "arens(1)": 2,
    "arenson": 3,
    "arent": 2,
    "arentz": 2,
    "arenz": 2,
    "ares": 1,
    "areta": 3,
    "aretha": 3,
    "aretina": 4,
    "aretsky": 3,
    "aretta": 3,
    "arevalo": 4,
    "arey": 2,
    "argabright": 3,
    "argall": 2,
    "arganbright": 3,
    "argenbright": 3,
    "argent": 2,
    "argenta": 3,
    "argentieri": 4,
    "argentina": 4,
    "argentina's": 4,
    "argentinas": 4,
    "argentine": 3,
    "argentines": 3,
    "argentinian": 5,
    "argentinians": 5,
    "argento": 3,
    "argiro": 3,
    "argo": 2,
    "argo's": 2,
    "argon": 2,
    "argonaut": 3,
    "argonaut's": 3,
    "argonauts": 3,
    "argonne": 2,
    "argonne(1)": 2,
    "argosy": 3,
    "argosystem": 4,
    "argosystems": 4,
    "argot": 2,
    "arguable": 4,
    "arguably": 4,
    "argue": 2,
    "argued": 2,
    "arguelles": 3,
    "arguello": 3,
    "argues": 2,
    "argueta": 3,
    "arguijo": 3,
    "arguing": 3,
    "argument": 3,
    "argument's": 3,
    "argumentation": 5,
    "argumentative": 5,
    "arguments": 3,
    "argus": 2,
    "argyle": 2,
    "argyll": 2,
    "argyropoulos": 5,
    "ari": 2,
    "aria": 3,
    "ariadne": 4,
    "arian": 3,
    "ariana": 4,
    "ariane": 3,
    "arianespace": 4,
    "arianism": 5,
    "arianna": 4,
    "arianna's": 4,
    "arias": 3,
    "arias's": 4,
    "aric": 2,
    "arico": 3,
    "arid": 2,
    "arid(1)": 2,
    "arida": 3,
    "arie": 2,
    "ariel": 3,
    "ariella": 4,
    "aries": 2,
    "arington": 3,
    "ariola": 4,
    "aris": 2,
    "arise": 2,
    "arisen": 3,
    "arises": 3,
    "arises(1)": 3,
    "arising": 3,
    "arison": 3,
    "arispe": 3,
    "arista": 3,
    "aristech": 3,
    "aristede": 3,
    "aristede's": 3,
    "aristide": 3,
    "aristide's": 3,
    "aristocracy": 5,
    "aristocrat": 4,
    "aristocratic": 5,
    "aristocrats": 4,
    "aristophanes": 5,
    "aristotelian": 6,
    "aristotle": 4,
    "aristotle's": 4,
    "arithmetic": 4,
    "arithmetic(1)": 4,
    "ariza": 3,
    "arizmendi": 4,
    "arizona": 4,
    "arizona's": 4,
    "arizonan": 4,
    "arizonan(1)": 4,
    "arizonans": 4,
    "arizonans(1)": 4,
    "arjo": 2,
    "arjo(1)": 2,
    "ark": 1,
    "arkadelphia": 5,
    "arkadi": 3,
    "arkady": 3,
    "arkansan": 3,
    "arkansans": 3,
    "arkansas": 3,
    "arkansas'": 3,
    "arkansas's": 3,
    "arkarow": 3,
    "arkin": 2,
    "arkin's": 2,
    "arkla": 2,
    "arkla's": 2,
    "arko": 2,
    "arkose": 2,
    "arkwright": 2,
    "arlana": 3,
    "arlauskas": 3,
    "arledge": 2,
    "arleen": 2,
    "arlen": 2,
    "arlena": 3,
    "arlene": 2,
    "arlene's": 2,
    "arleta": 3,
    "arlette": 2,
    "arley": 2,
    "arlie": 2,
    "arlin": 2,
    "arlinda": 3,
    "arline": 2,
    "arlington": 3,
    "arlington's": 3,
    "arlt": 1,
    "arlyne": 2,
    "arm": 1,
    "arm's": 1,
    "armacost": 3,
    "armacost's": 3,
    "armada": 3,
    "armadillo": 4,
    "armadillos": 4,
    "armageddon": 4,
    "armagost": 3,
    "armament": 3,
    "armaments": 3,
    "arman": 2,
    "armand": 2,
    "armand(1)": 2,
    "armando": 3,
    "armandt": 2,
    "armani": 3,
    "armantrout": 3,
    "armaro": 3,
    "armas": 2,
    "armato": 3,
    "armband": 2,
    "armbands": 2,
    "armbrister": 4,
    "armbrister(1)": 3,
    "armbrust": 2,
    "armbruster": 3,
    "armbruster(1)": 3,
    "armchair": 2,
    "armchairs": 2,
    "armco": 2,
    "armco's": 2,
    "armed": 1,
    "armel": 2,
    "armellino": 4,
    "armen": 2,
    "armendarez": 4,
    "armendariz": 4,
    "armenia": 4,
    "armenia's": 4,
    "armenian": 4,
    "armenians": 4,
    "arment": 2,
    "armenta": 3,
    "armentor": 3,
    "armentrout": 3,
    "armer": 2,
    "armes": 1,
    "armested": 3,
    "armetta": 3,
    "armey": 2,
    "armey's": 2,
    "armfield": 2,
    "armida": 3,
    "armies": 2,
    "armiger": 3,
    "armijo": 3,
    "armilla": 3,
    "armin": 2,
    "armina": 3,
    "armine": 3,
    "arming": 2,
    "armington": 3,
    "arminie": 3,
    "armistead": 3,
    "armistice": 3,
    "armitage": 3,
    "armoire": 2,
    "armoires": 2,
    "armold": 2,
    "armon": 2,
    "armond": 2,
    "armonk": 2,
    "armor": 2,
    "armored": 2,
    "armories": 3,
    "armory": 3,
    "armour": 2,
    "armpit": 2,
    "armpits": 2,
    "armrest": 2,
    "armrests": 2,
    "arms": 1,
    "armstead": 2,
    "armstrad": 2,
    "armstrong": 2,
    "armstrong(1)": 2,
    "armstrong's": 2,
    "armtec": 2,
    "armtek": 2,
    "armtek's": 2,
    "armwood": 2,
    "army": 2,
    "army's": 2,
    "arn": 1,
    "arnal": 2,
    "arnalda": 3,
    "arnaldo": 3,
    "arnall": 2,
    "arnatt": 2,
    "arnaud": 2,
    "arnault": 2,
    "arnaz": 2,
    "arndt": 1,
    "arne": 1,
    "arnell": 2,
    "arnelle": 2,
    "arnelle's": 2,
    "arner": 2,
    "arnesen": 3,
    "arneson": 3,
    "arnett": 2,
    "arnette": 2,
    "arney": 2,
    "arnhold": 2,
    "arnholt": 2,
    "arnie": 2,
    "arnn": 1,
    "arno": 2,
    "arnold": 2,
    "arnold's": 2,
    "arnoldi": 3,
    "arnolds": 2,
    "arnoldy": 3,
    "arnolphe": 3,
    "arnone": 3,
    "arnot": 2,
    "arnott": 2,
    "arnotts": 2,
    "arnow": 2,
    "arnox": 2,
    "arns": 1,
    "arnst": 1,
    "arnstein": 2,
    "arnstein(1)": 2,
    "arntson": 2,
    "arntz": 1,
    "arntzen": 2,
    "arnulfo": 3,
    "arnwine": 2,
    "arnzen": 2,
    "aro": 2,
    "arocha": 3,
    "arocho": 3,
    "aroma": 3,
    "aromas": 3,
    "aromatherapy": 6,
    "aromatic": 4,
    "aron": 2,
    "arone": 2,
    "aronhalt": 3,
    "aronoff": 3,
    "aronow": 3,
    "aronowitz": 4,
    "arons": 2,
    "aronson": 3,
    "aronstein": 3,
    "aronstein(1)": 3,
    "arora": 3,
    "aros": 2,
    "arose": 2,
    "around": 2,
    "around(1)": 2,
    "arousal": 3,
    "arouse": 2,
    "aroused": 2,
    "arouses": 3,
    "arousing": 3,
    "arp": 1,
    "arpa": 2,
    "arpanet": 3,
    "arpin": 2,
    "arpino": 3,
    "arps": 1,
    "arquette": 2,
    "arquilla": 3,
    "arraign": 2,
    "arraigned": 2,
    "arraignment": 3,
    "arraignments": 3,
    "arrange": 2,
    "arranged": 2,
    "arrangement": 3,
    "arrangements": 3,
    "arranger": 3,
    "arranges": 3,
    "arranging": 3,
    "arrant": 2,
    "arrants": 2,
    "arrasmith": 3,
    "array": 2,
    "arrayed": 2,
    "arraying": 3,
    "arrays": 2,
    "arrearage": 3,
    "arrearages": 4,
    "arrears": 2,
    "arredondo": 4,
    "arreguin": 3,
    "arrendondo": 4,
    "arreola": 4,
    "arrest": 2,
    "arrested": 3,
    "arrested(1)": 3,
    "arresting": 3,
    "arrests": 2,
    "arrhythmia": 4,
    "arrhythmias": 4,
    "arriaga": 4,
    "arrick": 2,
    "arrieta": 3,
    "arrigo": 3,
    "arrigoni": 4,
    "arrington": 3,
    "arriola": 4,
    "arriortua": 5,
    "arris": 2,
    "arrival": 3,
    "arrivals": 3,
    "arrive": 2,
    "arrived": 2,
    "arrives": 2,
    "arriving": 3,
    "arrogance": 3,
    "arrogant": 3,
    "arrogantly": 4,
    "arrogate": 3,
    "arrow": 2,
    "arrow(1)": 2,
    "arrow's": 2,
    "arrow's(1)": 2,
    "arrowhead": 3,
    "arrowhead(1)": 3,
    "arrowheads": 3,
    "arrowheads(1)": 3,
    "arrowood": 3,
    "arrowroot": 3,
    "arrows": 2,
    "arrows(1)": 2,
    "arrowsmith": 3,
    "arrowsmith(1)": 3,
    "arrowsmith's": 3,
    "arrowsmith's(1)": 3,
    "arroyo": 3,
    "arroyo's": 3,
    "arruda": 3,
    "arrupe": 2,
    "arsdale": 2,
    "arsenal": 3,
    "arsenals": 3,
    "arsenault": 3,
    "arseneau": 3,
    "arseneault": 3,
    "arsenic": 3,
    "arsenide": 3,
    "arsenio": 4,
    "arslanian": 4,
    "arson": 2,
    "arsonist": 3,
    "arsonist(1)": 3,
    "arsonists": 3,
    "arsonists(1)": 3,
    "arsons": 2,
    "arsov": 2,
    "art": 1,
    "art's": 1,
    "artale": 3,
    "artcarve": 2,
    "artcarved": 2,
    "arteaga": 3,
    "artemas": 3,
    "artemus": 3,
    "arter": 2,
    "arterberry": 4,
    "arterburn": 3,
    "arterial": 4,
    "arteries": 3,
    "arteriosclerosis": 7,
    "artery": 3,
    "artes": 2,
    "artesian": 3,
    "artful": 2,
    "artfully": 3,
    "arth": 1,
    "arthotec": 3,
    "arthritic": 3,
    "arthritis": 3,
    "arthritis(1)": 3,
    "arthropod": 3,
    "arthropods": 3,
    "arthur": 2,
    "arthur's": 2,
    "arthurian": 4,
    "arthurs": 2,
    "artichoke": 3,
    "artichoke(1)": 3,
    "artichokes": 3,
    "article": 3,
    "article(1)": 3,
    "article's": 3,
    "articles": 3,
    "articles(1)": 3,
    "articulate": 4,
    "articulate(1)": 4,
    "articulated": 5,
    "articulates": 4,
    "articulating": 5,
    "articulation": 5,
    "articulatory": 6,
    "artie": 2,
    "artifact": 3,
    "artifacts": 3,
    "artifice": 3,
    "artificial": 4,
    "artificially": 5,
    "artillery": 4,
    "artino": 3,
    "artiodactyl": 5,
    "artiodactyls": 5,
    "artis": 2,
    "artisan": 3,
    "artisans": 3,
    "artist": 2,
    "artist(1)": 2,
    "artist's": 2,
    "artist's(1)": 2,
    "artistic": 3,
    "artistically": 4,
    "artistry": 3,
    "artists": 2,
    "artists'": 2,
    "artley": 2,
    "artman": 2,
    "artois": 2,
    "arton": 2,
    "artra": 2,
    "artra's": 2,
    "artrip": 2,
    "arts": 1,
    "artsy": 2,
    "artur": 2,
    "arturo": 3,
    "artus": 2,
    "artwork": 2,
    "artworks": 2,
    "arty": 2,
    "arty's": 2,
    "artz": 1,
    "artzt": 1,
    "aruba": 3,
    "arum": 2,
    "arunachalam": 5,
    "arundel": 3,
    "arup": 2,
    "arva": 2,
    "arvad": 2,
    "arval": 2,
    "arvanitis": 4,
    "arvay": 2,
    "arve": 1,
    "arvel": 2,
    "arvey": 2,
    "arvid": 2,
    "arvida": 3,
    "arvida's": 3,
    "arvidson": 3,
    "arvin": 2,
    "arvin's": 2,
    "arvind": 2,
    "arvizu": 3,
    "arwen": 2,
    "arwood": 2,
    "arx": 1,
    "ary": 2,
    "aryan": 3,
    "arzama": 3,
    "arzamas": 3,
    "arzate": 2,
    "arzola": 3,
    "arzt": 1,
    "as": 1,
    "as(1)": 1,
    "asa": 2,
    "asaf": 2,
    "asahan": 3,
    "asahara": 4,
    "asahi": 3,
    "asamera": 4,
    "asap": 4,
    "asap(1)": 2,
    "asarco": 3,
    "asarco's": 3,
    "asaro": 3,
    "asat": 2,
    "asato": 3,
    "asay": 2,
    "asbell": 2,
    "asberry": 3,
    "asbestec": 3,
    "asbestos": 3,
    "asbestosis": 4,
    "asbestosis(1)": 4,
    "asbill": 2,
    "asbridge": 2,
    "asbury": 3,
    "asby": 2,
    "ascap": 2,
    "ascencio": 4,
    "ascend": 2,
    "ascendance": 3,
    "ascendancy": 4,
    "ascendant": 3,
    "ascended": 3,
    "ascendency": 4,
    "ascending": 3,
    "ascends": 2,
    "ascension": 3,
    "ascent": 2,
    "ascertain": 3,
    "ascertained": 3,
    "ascertaining": 4,
    "ascetic": 3,
    "asch": 1,
    "asche": 1,
    "aschenbach": 3,
    "aschenbrenner": 4,
    "ascher": 2,
    "aschoff": 2,
    "ascii": 2,
    "asclad": 2,
    "ascorbic": 3,
    "ascot": 2,
    "ascott": 2,
    "ascribe": 2,
    "ascribed": 2,
    "ascribes": 2,
    "asda": 2,
    "asea": 3,
    "asea(1)": 4,
    "asean": 3,
    "asean(1)": 5,
    "asean(2)": 3,
    "aselma": 3,
    "aseltine": 4,
    "asencio": 4,
    "aseritis": 4,
    "asexual": 4,
    "ash": 1,
    "asha": 2,
    "ashaji": 3,
    "ashaji's": 3,
    "ashame": 2,
    "ashamed": 2,
    "ashare": 2,
    "ashbaugh": 2,
    "ashbaugh(1)": 2,
    "ashbrook": 2,
    "ashburn": 2,
    "ashbury": 3,
    "ashby": 2,
    "ashcraft": 2,
    "ashcreek": 2,
    "ashcroft": 2,
    "ashdown": 2,
    "ashe": 1,
    "asheboro": 3,
    "ashen": 2,
    "ashenberg": 3,
    "ashenfelter": 4,
    "asher": 2,
    "ashes": 2,
    "ashes(1)": 2,
    "asheville": 2,
    "ashey": 2,
    "ashford": 2,
    "ashis": 2,
    "ashish": 2,
    "ashkenazi": 4,
    "ashkenazis": 4,
    "ashland": 2,
    "ashland's": 2,
    "ashley": 2,
    "ashley's": 2,
    "ashlin": 2,
    "ashline": 2,
    "ashlock": 2,
    "ashman": 2,
    "ashmead": 2,
    "ashmore": 2,
    "ashok": 2,
    "ashore": 2,
    "ashrawi": 3,
    "ashtec": 2,
    "ashtec's": 2,
    "ashton": 2,
    "ashton's": 2,
    "ashtray": 2,
    "ashtrays": 2,
    "ashur": 2,
    "ashurst": 2,
    "ashville": 2,
    "ashwell": 2,
    "ashwood": 2,
    "ashworth": 2,
    "ashy": 2,
    "asia": 2,
    "asia's": 2,
    "asiain": 3,
    "asiamerica": 6,
    "asian": 2,
    "asians": 2,
    "asiatic": 4,
    "asiaweek": 3,
    "asic": 2,
    "asics": 2,
    "aside": 2,
    "asides": 2,
    "asiel": 3,
    "asimov": 3,
    "asimov(1)": 3,
    "asimov's": 3,
    "asimov's(1)": 3,
    "asimow": 3,
    "asinine": 3,
    "ask": 1,
    "aska": 2,
    "askance": 2,
    "asked": 1,
    "asked(1)": 1,
    "asker": 2,
    "asker's": 2,
    "askers": 2,
    "askers'": 2,
    "askers's": 3,
    "askew": 2,
    "askey": 2,
    "askin": 2,
    "askin's": 2,
    "asking": 2,
    "askington": 3,
    "askins": 2,
    "asko": 2,
    "askoldov": 3,
    "askoldov's": 3,
    "askren": 3,
    "asks": 1,
    "aslanian": 4,
    "asleep": 2,
    "asleson": 3,
    "asleson(1)": 3,
    "aslin": 2,
    "asman": 2,
    "asmara": 3,
    "asmaras": 3,
    "asmodeus": 4,
    "asmus": 2,
    "asmussen": 3,
    "asner": 2,
    "asp": 1,
    "asparagus": 4,
    "aspartame": 3,
    "aspect": 2,
    "aspects": 2,
    "aspen": 2,
    "aspen's": 2,
    "aspens": 2,
    "asper": 2,
    "asperity": 4,
    "aspersion": 3,
    "aspersions": 3,
    "asphalt": 2,
    "asphyxiate": 4,
    "asphyxiated": 5,
    "asphyxiates": 4,
    "asphyxiating": 5,
    "aspin": 2,
    "aspin's": 2,
    "aspinall": 3,
    "aspinwall": 3,
    "aspirant": 3,
    "aspirant(1)": 3,
    "aspirants": 3,
    "aspirants(1)": 3,
    "aspirants(2)": 3,
    "aspirants(3)": 3,
    "aspirate": 3,
    "aspirated": 4,
    "aspirates": 3,
    "aspiration": 4,
    "aspirations": 4,
    "aspire": 2,
    "aspired": 2,
    "aspires": 3,
    "aspirin": 2,
    "aspirin's": 2,
    "aspiring": 3,
    "asplund": 2,
    "aspnes": 2,
    "asquith": 2,
    "ass": 1,
    "assad": 2,
    "assad's": 2,
    "assaf": 2,
    "assail": 2,
    "assailant": 3,
    "assailant's": 3,
    "assailants": 3,
    "assailed": 2,
    "assailing": 3,
    "assails": 2,
    "assante": 3,
    "assassin": 3,
    "assassin's": 3,
    "assassinate": 4,
    "assassinated": 5,
    "assassinating": 5,
    "assassination": 5,
    "assassinations": 5,
    "assassins": 3,
    "assault": 2,
    "assaulted": 3,
    "assaulting": 3,
    "assaultive": 3,
    "assaults": 2,
    "assay": 2,
    "assayer": 3,
    "assed": 1,
    "asselin": 3,
    "asselstine": 3,
    "assemblage": 3,
    "assemblage(1)": 3,
    "assemble": 3,
    "assembled": 3,
    "assembler": 3,
    "assemblers": 3,
    "assembles": 3,
    "assemblies": 3,
    "assembling": 4,
    "assembling(1)": 3,
    "assembly": 3,
    "assembly's": 3,
    "assemblyman": 4,
    "assemblyman(1)": 4,
    "assemblymen": 4,
    "assemblywoman": 5,
    "assent": 2,
    "assert": 2,
    "asserted": 3,
    "assertedly": 4,
    "asserting": 3,
    "assertion": 3,
    "assertions": 3,
    "assertive": 3,
    "assertively": 4,
    "assertiveness": 4,
    "asserts": 2,
    "asses": 2,
    "assess": 2,
    "assessed": 2,
    "assesses": 3,
    "assessing": 3,
    "assessment": 3,
    "assessments": 3,
    "assessor": 3,
    "assessors": 3,
    "asset": 2,
    "assets": 2,
    "assets'": 2,
    "asshole": 2,
    "assicurazioni": 7,
    "assiduous": 3,
    "assiduously": 4,
    "assign": 2,
    "assigned": 2,
    "assigning": 3,
    "assignment": 3,
    "assignment's": 3,
    "assignments": 3,
    "assigns": 2,
    "assimilate": 4,
    "assimilated": 5,
    "assimilating": 5,
    "assimilation": 5,
    "assira": 3,
    "assisi": 3,
    "assisi's": 3,
    "assist": 2,
    "assistance": 3,
    "assistant": 3,
    "assistants": 3,
    "assisted": 3,
    "assisted(1)": 3,
    "assisting": 3,
    "assists": 2,
    "assocation": 4,
    "associate": 4,
    "associate(1)": 4,
    "associate(2)": 4,
    "associate(3)": 4,
    "associate's": 4,
    "associate's(1)": 4,
    "associated": 5,
    "associated(1)": 5,
    "associates": 4,
    "associates(1)": 4,
    "associates(2)": 4,
    "associates(3)": 4,
    "associates'": 4,
    "associates'(1)": 4,
    "associating": 5,
    "association": 5,
    "association(1)": 5,
    "association's": 5,
    "associations": 5,
    "associations(1)": 5,
    "associes": 3,
    "assort": 2,
    "assorted": 3,
    "assortment": 3,
    "assuage": 2,
    "assuaged": 2,
    "assubel": 3,
    "assume": 2,
    "assumed": 2,
    "assumes": 2,
    "assuming": 3,
    "assumption": 3,
    "assumptions": 3,
    "assurance": 3,
    "assurances": 4,
    "assurances(1)": 4,
    "assuras": 3,
    "assure": 2,
    "assured": 2,
    "assuredly": 4,
    "assures": 2,
    "assuring": 3,
    "assyria": 4,
    "assyrian": 4,
    "assyrians": 4,
    "ast": 1,
    "asta": 2,
    "astaire": 2,
    "aster": 2,
    "asterisk": 3,
    "asteroid": 3,
    "asteroid's": 3,
    "asteroids": 3,
    "asters": 2,
    "asthma": 2,
    "asthmatic": 3,
    "asthmatics": 3,
    "astigmatism": 5,
    "astin": 2,
    "astle": 2,
    "astley": 2,
    "aston": 2,
    "astonish": 3,
    "astonished": 3,
    "astonishing": 4,
    "astonishingly": 5,
    "astonishment": 4,
    "astor": 2,
    "astor's": 2,
    "astore": 2,
    "astore(1)": 3,
    "astorga": 3,
    "astoria": 4,
    "astorino": 4,
    "astound": 2,
    "astounded": 3,
    "astounding": 3,
    "astoundingly": 4,
    "astounds": 2,
    "astra": 2,
    "astra's": 2,
    "astraddle": 3,
    "astrakhan": 3,
    "astral": 2,
    "astray": 2,
    "astred": 2,
    "astrid": 2,
    "astride": 2,
    "astringent": 3,
    "astringents": 3,
    "astro": 2,
    "astrodome": 3,
    "astrogeology": 6,
    "astrologer": 4,
    "astrologers": 4,
    "astrological": 5,
    "astrology": 4,
    "astronaut": 3,
    "astronaut's": 3,
    "astronautic": 4,
    "astronautical": 5,
    "astronautics": 4,
    "astronauts": 3,
    "astronauts'": 3,
    "astronomer": 4,
    "astronomers": 4,
    "astronomical": 5,
    "astronomically": 5,
    "astronomy": 4,
    "astrophotography": 6,
    "astrophysicist": 5,
    "astrophysics": 4,
    "astros": 2,
    "astrotech": 3,
    "astroturf": 3,
    "astute": 2,
    "astutely": 3,
    "astuteness": 3,
    "asuncion": 3,
    "asunder": 3,
    "aswin": 2,
    "asylum": 3,
    "asymmetrical": 5,
    "asymmetries": 4,
    "asymmetry": 4,
    "asymptomatic": 5,
    "asymptote": 3,
    "asymptote(1)": 3,
    "asymptotes": 3,
    "asymptotes(1)": 3,
    "asynchronous": 4,
    "at": 1,
    "at-bat": 2,
    "at-bats": 2,
    "ata": 2,
    "atalanta": 4,
    "atalaya": 4,
    "atalia": 4,
    "atalie": 3,
    "atamian": 4,
    "atari": 3,
    "atari's": 3,
    "ataturk": 3,
    "ataturk's": 3,
    "atavism": 4,
    "atavistic": 4,
    "ataxia": 4,
    "ataxia's": 4,
    "atcheson": 3,
    "atchinson": 3,
    "atchison": 3,
    "atchley": 2,
    "atco": 2,
    "atcor": 2,
    "ate": 1,
    "atek": 2,
    "aten": 2,
    "atencio": 4,
    "ater": 2,
    "ates": 1,
    "atha": 2,
    "athalia": 4,
    "athanas": 3,
    "athanassiou": 5,
    "athans": 2,
    "athas": 2,
    "athearn": 2,
    "atheism": 3,
    "atheism(1)": 4,
    "atheist": 3,
    "atheistic": 4,
    "atheists": 3,
    "athena": 3,
    "athenaeum": 4,
    "athenaios": 4,
    "atheneum": 3,
    "athenian": 4,
    "athenians": 4,
    "athens": 2,
    "atherosclerosis": 6,
    "atherton": 3,
    "athey": 2,
    "athie": 2,
    "athlete": 2,
    "athlete's": 2,
    "athletes": 2,
    "athletes'": 2,
    "athletic": 3,
    "athletically": 4,
    "athleticism": 4,
    "athletics": 3,
    "athlone": 2,
    "athwart": 2,
    "atico": 3,
    "atienza": 3,
    "atilano": 4,
    "atither": 3,
    "atkerson": 3,
    "atkin": 2,
    "atkins": 2,
    "atkins's": 3,
    "atkinson": 3,
    "atkinson(1)": 3,
    "atkinson's": 3,
    "atkinson's(1)": 3,
    "atkison": 3,
    "atkisson": 3,
    "atla": 2,
    "atlan": 2,
    "atlanta": 3,
    "atlanta(1)": 3,
    "atlanta(2)": 3,
    "atlanta(3)": 3,
    "atlanta's": 3,
    "atlanta's(1)": 3,
    "atlantan": 3,
    "atlantan(1)": 3,
    "atlantans": 3,
    "atlantans(1)": 3,
    "atlantic": 3,
    "atlantic(1)": 3,
    "atlantic's": 3,
    "atlantic's(1)": 3,
    "atlantica": 4,
    "atlantico": 4,
    "atlantis": 3,
    "atlantis(1)": 3,
    "atlantis'": 3,
    "atlantis'(1)": 4,
    "atlantis's": 4,
    "atlas": 2,
    "atlas's": 3,
    "atlases": 3,
    "atlases(1)": 3,
    "atler": 2,
    "atley": 2,
    "atmel": 2,
    "atmosphere": 3,
    "atmospheric": 4,
    "atmospherics": 4,
    "atnip": 2,
    "atocha": 3,
    "atoll": 2,
    "atoll(1)": 2,
    "atoll(2)": 2,
    "atom": 2,
    "atomic": 3,
    "atomizer": 4,
    "atoms": 2,
    "aton": 2,
    "atonal": 3,
    "atone": 2,
    "atonement": 3,
    "atop": 2,
    "ator": 2,
    "atorino": 4,
    "atp": 3,
    "atra": 2,
    "atria": 3,
    "atrium": 3,
    "atriums": 3,
    "atrocious": 3,
    "atrocities": 4,
    "atrocity": 4,
    "atrophied": 3,
    "atrophies": 3,
    "atrophy": 3,
    "atsushi": 3,
    "atsushi(1)": 3,
    "atta": 2,
    "attaboy": 3,
    "attaboys": 3,
    "attach": 2,
    "attache": 3,
    "attached": 2,
    "attaches": 3,
    "attaching": 3,
    "attachment": 3,
    "attachments": 3,
    "attack": 2,
    "attacked": 2,
    "attacker": 3,
    "attackers": 3,
    "attacking": 3,
    "attacks": 2,
    "attain": 2,
    "attainable": 4,
    "attainder": 3,
    "attained": 2,
    "attaining": 3,
    "attainment": 3,
    "attains": 2,
    "attali": 3,
    "attalla": 3,
    "attanasio": 5,
    "attar": 2,
    "attard": 2,
    "attardo": 3,
    "attaway": 3,
    "atteberry": 3,
    "attebery": 4,
    "attebury": 3,
    "attempt": 2,
    "attempted": 3,
    "attempting": 3,
    "attempts": 2,
    "attempts(1)": 2,
    "attenborough": 4,
    "attend": 2,
    "attendance": 3,
    "attendant": 3,
    "attendant's": 3,
    "attendants": 3,
    "attendants'": 3,
    "attended": 3,
    "attendee": 3,
    "attendees": 3,
    "attending": 3,
    "attends": 2,
    "attention": 3,
    "attentions": 3,
    "attentive": 3,
    "attentively": 4,
    "attentiveness": 4,
    "attenuate": 4,
    "attenuated": 5,
    "attenuates": 4,
    "atterberry": 4,
    "atterbury": 4,
    "attermann": 3,
    "attest": 2,
    "attested": 3,
    "attesting": 3,
    "attests": 2,
    "attests(1)": 2,
    "attic": 2,
    "attica": 3,
    "attics": 2,
    "atticus": 3,
    "attie": 2,
    "attila": 3,
    "attila's": 3,
    "attire": 3,
    "attired": 2,
    "attitude": 3,
    "attitudes": 3,
    "attitudinal": 5,
    "attkisson": 3,
    "attleboro": 4,
    "attlee": 2,
    "attorney": 3,
    "attorney's": 3,
    "attorneys": 3,
    "attorneys'": 3,
    "attract": 2,
    "attracted": 3,
    "attracting": 3,
    "attraction": 3,
    "attractions": 3,
    "attractive": 3,
    "attractively": 4,
    "attractiveness": 4,
    "attracts": 2,
    "attributable": 5,
    "attribute": 3,
    "attribute(1)": 3,
    "attributed": 4,
    "attributes": 3,
    "attributes(1)": 3,
    "attributing": 4,
    "attribution": 4,
    "attridge": 2,
    "attrition": 3,
    "attune": 2,
    "attuned": 2,
    "attwood": 2,
    "attwoods": 2,
    "atwater": 3,
    "atwell": 2,
    "atwood": 2,
    "atworth": 2,
    "atx": 3,
    "atypia": 4,
    "atypic": 3,
    "atypical": 4,
    "atz": 1,
    "au": 1,
    "aube": 1,
    "aubel": 2,
    "auber": 2,
    "auberry": 3,
    "aubert": 2,
    "aubin": 2,
    "auble": 2,
    "aubrey": 2,
    "aubry": 2,
    "aubuchon": 3,
    "auburn": 2,
    "auch": 1,
    "auchter": 2,
    "auckland": 2,
    "auclair": 2,
    "aucoin": 2,
    "aucott": 2,
    "auction": 2,
    "auction(1)": 2,
    "auction's": 2,
    "auctioned": 2,
    "auctioneer": 3,
    "auctioneering": 4,
    "auctioneers": 3,
    "auctioning": 3,
    "auctions": 2,
    "auctions(1)": 2,
    "aud": 1,
    "audacious": 3,
    "audacity": 4,
    "audas": 2,
    "auden": 2,
    "auderburn": 3,
    "audet": 2,
    "audette": 2,
    "audi": 2,
    "audi(1)": 2,
    "audi's": 2,
    "audi's(1)": 2,
    "audia": 3,
    "audible": 3,
    "audibles": 3,
    "audibly": 3,
    "audience": 3,
    "audience(1)": 3,
    "audience's": 4,
    "audience's(1)": 4,
    "audiences": 4,
    "audiences(1)": 4,
    "audino": 3,
    "audio": 3,
    "audiophile": 4,
    "audiophiles": 4,
    "audiotape": 4,
    "audiotapes": 4,
    "audiotex": 4,
    "audiotronic": 5,
    "audiotronics": 5,
    "audiovisual": 6,
    "audiovox": 4,
    "audis": 2,
    "audis(1)": 2,
    "audit": 2,
    "audited": 3,
    "auditing": 3,
    "audition": 3,
    "auditioned": 3,
    "auditioning": 4,
    "auditions": 3,
    "auditor": 3,
    "auditor's": 3,
    "auditorium": 5,
    "auditoriums": 5,
    "auditors": 3,
    "auditors'": 3,
    "auditory": 4,
    "audits": 2,
    "audran": 2,
    "audrey": 2,
    "audric": 2,
    "audrie": 3,
    "audris": 2,
    "audry": 2,
    "audubon": 3,
    "audwin": 2,
    "aue": 1,
    "auel": 2,
    "auen": 2,
    "auer": 2,
    "auerbach": 3,
    "auerback": 2,
    "aufderheide": 3,
    "aufhauser": 3,
    "aufiero": 3,
    "aug": 2,
    "augat": 2,
    "auge": 1,
    "augello": 3,
    "augenstein": 3,
    "augenstein(1)": 3,
    "auger": 2,
    "augers": 2,
    "aughenbaugh": 3,
    "augment": 2,
    "augmentable": 4,
    "augmentation": 4,
    "augmented": 3,
    "augmenting": 3,
    "augsburg": 2,
    "augsburger": 3,
    "augsburger(1)": 3,
    "augspurger": 3,
    "augspurger(1)": 3,
    "augur": 2,
    "auguring": 3,
    "augurs": 2,
    "august": 2,
    "august(1)": 2,
    "august's": 2,
    "augusta": 3,
    "augusta's": 3,
    "auguste": 2,
    "augustin": 3,
    "augustine": 3,
    "augustine(1)": 3,
    "augustinian": 5,
    "augustinians": 5,
    "augusto": 3,
    "augustson": 3,
    "augustson(1)": 3,
    "augustus": 3,
    "augustus(1)": 3,
    "augustyn": 3,
    "augustyniak": 5,
    "aujourd'hui": 3,
    "aujourd'hui's": 3,
    "auker": 2,
    "aukerman": 3,
    "aul": 1,
    "aulana": 3,
    "aulander": 3,
    "auld": 1,
    "aulds": 1,
    "auletta": 3,
    "aull": 1,
    "ault": 1,
    "aultman": 2,
    "auman": 2,
    "aumann": 2,
    "aument": 2,
    "aumiller": 3,
    "aune": 1,
    "aung": 1,
    "aungst": 1,
    "aunt": 1,
    "aunt(1)": 1,
    "aunt's": 1,
    "aunt's(1)": 1,
    "auntie": 2,
    "auntie(1)": 2,
    "aunts": 1,
    "aunts(1)": 1,
    "aunts'": 1,
    "aunts'(1)": 1,
    "aupperle": 3,
    "aura": 2,
    "aural": 2,
    "aurand": 2,
    "aurea": 3,
    "aurelio": 4,
    "aureole": 3,
    "auria": 3,
    "aurich": 2,
    "auriemma": 3,
    "aurora": 3,
    "auroral": 3,
    "aurum": 2,
    "aus": 1,
    "ausbrooks": 2,
    "ausburn": 2,
    "auschwitz": 2,
    "auschwitz(1)": 2,
    "ausherman": 3,
    "ausimont": 3,
    "auslander": 3,
    "ausley": 2,
    "ausman": 2,
    "ausmus": 2,
    "auspey": 2,
    "auspice": 2,
    "auspices": 3,
    "auspicious": 3,
    "aussie": 2,
    "aust": 1,
    "austad": 2,
    "austat": 2,
    "austell": 2,
    "austen": 2,
    "austen's": 2,
    "auster": 2,
    "austere": 2,
    "austerely": 3,
    "austerity": 4,
    "austill": 2,
    "austin": 2,
    "austin's": 2,
    "austine": 2,
    "auston": 2,
    "austral": 2,
    "australasia": 4,
    "australia": 3,
    "australia's": 3,
    "australian": 3,
    "australians": 3,
    "australopithecine": 6,
    "australopithecus": 6,
    "australs": 2,
    "austrasia": 3,
    "austria": 3,
    "austria's": 3,
    "austrian": 3,
    "austrians": 3,
    "austro": 2,
    "austroasiatic": 6,
    "austron": 2,
    "auten": 2,
    "autenrieth": 4,
    "autenrieth(1)": 3,
    "autery": 3,
    "auth": 1,
    "authement": 2,
    "authentic": 3,
    "authentic(1)": 3,
    "authentic(2)": 3,
    "authentic(3)": 3,
    "authentically": 4,
    "authentically(1)": 4,
    "authenticate": 4,
    "authenticated": 5,
    "authenticating": 5,
    "authentication": 5,
    "authentications": 5,
    "authenticity": 5,
    "auther": 2,
    "authier": 3,
    "author": 2,
    "author's": 2,
    "authored": 2,
    "authoring": 3,
    "authoritarian": 6,
    "authoritarianism": 8,
    "authoritative": 5,
    "authoritatively": 6,
    "authorities": 4,
    "authorities'": 4,
    "authority": 4,
    "authority's": 4,
    "authorization": 5,
    "authorizations": 5,
    "authorize": 3,
    "authorized": 3,
    "authorizes": 4,
    "authorizing": 4,
    "authors": 2,
    "authors'": 2,
    "authorship": 3,
    "autism": 3,
    "autistic": 3,
    "auto": 2,
    "auto's": 2,
    "autobahn": 3,
    "autobiographer": 6,
    "autobiographical": 7,
    "autobiographies": 6,
    "autobiography": 6,
    "autobon": 3,
    "autoclave": 3,
    "autocracy": 4,
    "autocrat": 3,
    "autocratic": 4,
    "autodesk": 3,
    "autodie": 3,
    "autoeurope": 4,
    "autofact": 3,
    "autofacts": 3,
    "autograph": 3,
    "autographed": 3,
    "autographs": 3,
    "autoimmune": 3,
    "autolatina": 5,
    "automaker": 4,
    "automaker's": 4,
    "automakers": 4,
    "automakers'": 4,
    "automap": 3,
    "automata": 4,
    "automate": 3,
    "automated": 4,
    "automates": 3,
    "automatic": 4,
    "automatic(1)": 4,
    "automatically": 5,
    "automatically(1)": 5,
    "automatics": 4,
    "automating": 4,
    "automation": 4,
    "automatix": 4,
    "automaton": 4,
    "automobile": 4,
    "automobile(1)": 4,
    "automobiles": 4,
    "automobiles(1)": 4,
    "automobili": 5,
    "automotive": 4,
    "automotive's": 4,
    "automoviles": 5,
    "auton": 2,
    "autonomic": 4,
    "autonomous": 4,
    "autonomously": 5,
    "autonomy": 4,
    "autonomy(1)": 4,
    "autopacific": 5,
    "autopart": 3,
    "autoparts": 3,
    "autopilot": 4,
    "autopsied": 3,
    "autopsies": 3,
    "autopsy": 3,
    "autorad": 3,
    "autoradiograph": 6,
    "autorads": 3,
    "autos": 2,
    "autospa": 3,
    "autotote": 3,
    "autotrophic": 4,
    "autoworker": 4,
    "autoworkers": 4,
    "autrey": 2,
    "autry": 2,
    "autumn": 2,
    "autumn's": 2,
    "autumnal": 3,
    "auvil": 2,
    "aux": 1,
    "auxier": 3,
    "auxiliary": 4,
    "auxiliary(1)": 5,
    "auxton": 2,
    "auyeung": 2,
    "auzenne": 2,
    "ava": 2,
    "avail": 2,
    "availabilities": 6,
    "availability": 6,
    "availability(1)": 6,
    "available": 4,
    "availed": 2,
    "avakian": 4,
    "avalanche": 3,
    "avalanches": 4,
    "avallone": 3,
    "avalon": 3,
    "avalon's": 3,
    "avalos": 3,
    "avana": 3,
    "avana's": 3,
    "avanex": 3,
    "avant": 2,
    "avant-garde": 3,
    "avant-garde(1)": 3,
    "avantek": 3,
    "avanti": 3,
    "avants": 2,
    "avarice": 3,
    "avasso": 3,
    "avatar": 3,
    "avatars": 3,
    "avco": 2,
    "avdel": 2,
    "ave": 3,
    "ave(1)": 2,
    "avedisian": 4,
    "avedon": 3,
    "avelar": 3,
    "aveline": 4,
    "avella": 3,
    "avellino": 4,
    "avellino's": 4,
    "avemco": 3,
    "avemco's": 3,
    "aven": 2,
    "avena": 3,
    "avenall": 3,
    "avendano": 4,
    "avenel": 3,
    "avenell": 3,
    "avenge": 2,
    "avenged": 2,
    "avenger": 3,
    "avenging": 3,
    "aveni": 3,
    "avent": 2,
    "aventura": 4,
    "aventura(1)": 4,
    "avenue": 3,
    "avenue's": 3,
    "avenues": 3,
    "aver": 2,
    "avera": 3,
    "average": 3,
    "average(1)": 2,
    "average(2)": 2,
    "average's": 3,
    "averaged": 2,
    "averaged(1)": 2,
    "averages": 3,
    "averaging": 3,
    "averbeck": 3,
    "averell": 3,
    "averett": 3,
    "averette": 3,
    "averil": 3,
    "averil(1)": 2,
    "averill": 3,
    "averitt": 3,
    "averof": 3,
    "avers": 2,
    "aversa": 3,
    "aversano": 4,
    "averse": 2,
    "aversion": 3,
    "aversions": 3,
    "aversive": 3,
    "avert": 2,
    "averted": 3,
    "averting": 3,
    "averts": 2,
    "avery": 3,
    "avery's": 3,
    "averyl": 3,
    "avey": 2,
    "avi": 2,
    "avi(1)": 2,
    "avia": 3,
    "aviacion": 4,
    "aviall": 3,
    "avian": 3,
    "aviano": 4,
    "aviano's": 4,
    "aviaries": 4,
    "aviary": 4,
    "aviation": 4,
    "aviation's": 4,
    "aviator": 4,
    "aviators": 4,
    "aviazione": 6,
    "avice": 2,
    "avid": 2,
    "avid(1)": 2,
    "avidly": 3,
    "avignon": 3,
    "avila": 3,
    "aviles": 3,
    "avilez": 3,
    "avilla": 3,
    "avina": 3,
    "avinger": 3,
    "avionic": 4,
    "avionics": 4,
    "avions": 3,
    "avis": 2,
    "avitabile": 4,
    "avital": 3,
    "avitia": 3,
    "aviv": 2,
    "aviv's": 2,
    "avmark": 2,
    "avner": 2,
    "avnet": 2,
    "avocado": 4,
    "avocados": 4,
    "avocation": 4,
    "avocet": 3,
    "avodon": 3,
    "avoid": 2,
    "avoidable": 4,
    "avoidance": 3,
    "avoided": 3,
    "avoided(1)": 3,
    "avoiding": 3,
    "avoids": 2,
    "avolio": 4,
    "avon": 2,
    "avon's": 2,
    "avondale": 3,
    "avow": 2,
    "avowed": 2,
    "avowedly": 4,
    "avraham": 3,
    "avraham(1)": 3,
    "avram": 2,
    "avrett": 2,
    "avril": 2,
    "avril(1)": 2,
    "avrim": 2,
    "avtex": 2,
    "avtex's": 3,
    "avtovaz": 3,
    "avuncular": 4,
    "aw": 1,
    "awacs": 2,
    "awad": 2,
    "await": 2,
    "awaited": 3,
    "awaited(1)": 3,
    "awaiting": 3,
    "awaits": 2,
    "awake": 2,
    "awaken": 3,
    "awakened": 3,
    "awakening": 4,
    "awakens": 3,
    "awalt": 2,
    "awan": 2,
    "award": 2,
    "awarded": 3,
    "awarded(1)": 3,
    "awarding": 3,
    "awards": 2,
    "aware": 2,
    "awareness": 3,
    "awash": 2,
    "away": 2,
    "aways": 2,
    "awb": 1,
    "awb(1)": 5,
    "awb(2)": 5,
    "awbrey": 2,
    "awe": 1,
    "awe(1)": 1,
    "awed": 1,
    "aweida": 3,
    "aweida(1)": 3,
    "awesome": 2,
    "awesome(1)": 2,
    "awesomely": 3,
    "awesomely(1)": 3,
    "awestruck": 2,
    "awful": 2,
    "awful(1)": 2,
    "awfully": 2,
    "awfully(1)": 3,
    "awfulness": 3,
    "awhile": 2,
    "awkward": 2,
    "awkward(1)": 2,
    "awkwardly": 3,
    "awkwardness": 3,
    "awning": 2,
    "awoke": 2,
    "awry": 2,
    "awtrey": 2,
    "ax": 1,
    "axa": 2,
    "axa's": 2,
    "axe": 1,
    "axed": 1,
    "axel": 2,
    "axelrad": 3,
    "axelrod": 3,
    "axelsen": 3,
    "axelson": 3,
    "axes": 2,
    "axes(1)": 2,
    "axford": 2,
    "axial": 3,
    "axid": 2,
    "axilrod": 3,
    "axiom": 3,
    "axiomatic": 5,
    "axioms": 3,
    "axis": 2,
    "axle": 2,
    "axles": 2,
    "axley": 2,
    "axline": 2,
    "axlon": 2,
    "axon": 2,
    "axons": 2,
    "axsom": 2,
    "axt": 1,
    "axtell": 2,
    "axtman": 2,
    "axton": 2,
    "ay": 1,
    "ay(1)": 1,
    "ayacucho": 4,
    "ayako": 3,
    "ayala": 3,
    "ayars": 2,
    "ayatollah": 4,
    "ayatollah's": 4,
    "ayatollahs": 4,
    "aybar": 2,
    "aycock": 2,
    "aydar": 2,
    "aydar(1)": 2,
    "aydelott": 3,
    "aydelotte": 3,
    "aydin": 2,
    "aydt": 1,
    "aye": 1,
    "ayende": 3,
    "ayende(1)": 3,
    "ayer": 2,
    "ayer(1)": 2,
    "ayer's": 1,
    "ayer's(1)": 1,
    "ayers": 2,
    "ayers(1)": 2,
    "ayerst": 2,
    "ayerst(1)": 2,
    "ayes": 1,
    "aygen": 2,
    "aygen(1)": 2,
    "aykroyd": 2,
    "aykroyd(1)": 2,
    "ayler": 2,
    "ayles": 1,
    "aylesworth": 2,
    "aylesworth(1)": 3,
    "ayling": 2,
    "aylmer": 2,
    "aylor": 2,
    "aylsworth": 2,
    "aylward": 2,
    "aylwin": 2,
    "aylwin(1)": 2,
    "aylworth": 2,
    "aymond": 2,
    "ayn": 1,
    "aynes": 1,
    "ayo": 2,
    "ayodhya": 3,
    "ayon": 2,
    "ayotte": 2,
    "ayoub": 2,
    "ayr": 1,
    "ayre": 1,
    "ayres": 1,
    "ayscue": 2,
    "aytes": 1,
    "ayuso": 3,
    "ayyad": 2,
    "ayyad(1)": 2,
    "ayyad's": 2,
    "ayyad's(1)": 2,
    "ayyash": 2,
    "azactam": 3,
    "azalea": 3,
    "azaleas": 3,
    "azalia": 4,
    "azar": 2,
    "azarow": 3,
    "azbell": 2,
    "azbill": 2,
    "azcarraga": 4,
    "azcona": 3,
    "azcuenaga": 4,
    "azelia": 4,
    "azerbaijan": 4,
    "azerbaijan(1)": 4,
    "azerbaijan's": 4,
    "azerbaijan's(1)": 4,
    "azerbaijani": 5,
    "azerbaijani(1)": 5,
    "azerbaijanis": 5,
    "azerbaijanis(1)": 5,
    "azeri": 3,
    "azevedo": 4,
    "azhar": 2,
    "azhar's": 2,
    "azides": 2,
    "azidothymidine": 6,
    "azidothymidine(1)": 6,
    "azidothymidine(2)": 6,
    "azidothymidine(3)": 6,
    "azinger": 3,
    "aziz": 2,
    "azmeer": 2,
    "azoff": 2,
    "azores": 2,
    "azpurua": 4,
    "aztar": 2,
    "aztec": 2,
    "azteca": 3,
    "aztecs": 2,
    "azuka": 3,
    "azura": 3,
    "azure": 2,
    "azzara": 3,
    "azzarello": 4,
    "azzaro": 3,
    "azzato": 3,
    "azzopardi": 4,
    "b": 1,
    "b'gosh": 2,
    "b'nai": 2,
    "b'rith": 1,
    "b's": 1,
    "b-j": 2,
    "b-j's": 2,
    "b.": 1,
    "b.'s": 1,
    "b.s": 1,
    "ba'ath": 1,
    "ba'ath(1)": 2,
    "baab": 1,
    "baack": 1,
    "baade": 1,
    "baalbek": 2,
    "baalbeq": 2,
    "baar": 1,
    "baars": 1,
    "baas": 1,
    "baasch": 1,
    "baatz": 1,
    "bab": 1,
    "baba": 2,
    "baba(1)": 2,
    "baba's": 2,
    "baba's(1)": 2,
    "babangida": 4,
    "babangida(1)": 4,
    "babar": 2,
    "babar's": 2,
    "babb": 1,
    "babbage": 2,
    "babbage's": 3,
    "babbington": 3,
    "babbio": 3,
    "babbit": 2,
    "babbit's": 2,
    "babbitt": 2,
    "babbitt's": 2,
    "babbitts": 2,
    "babble": 2,
    "babbled": 2,
    "babbler": 2,
    "babblers": 2,
    "babbling": 3,
    "babbling(1)": 2,
    "babbs": 1,
    "babcock": 2,
    "babe": 1,
    "babel": 2,
    "baber": 2,
    "babers": 2,
    "babes": 1,
    "babette": 2,
    "babiak": 3,
    "babiarz": 3,
    "babic": 2,
    "babich": 2,
    "babies": 2,
    "babies'": 2,
    "babik": 2,
    "babin": 2,
    "babineau": 3,
    "babineaux": 3,
    "babington": 3,
    "babino": 3,
    "babinski": 3,
    "babish": 2,
    "babita": 3,
    "babka": 2,
    "babler": 3,
    "baboon": 2,
    "baboon's": 2,
    "baboon's(1)": 2,
    "baboons": 2,
    "baboons(1)": 2,
    "babs": 1,
    "babson": 2,
    "babu": 2,
    "babula": 3,
    "babushka": 3,
    "babushkas": 3,
    "baby": 2,
    "baby's": 2,
    "babyak": 3,
    "babyhood": 3,
    "babyish": 3,
    "babylon": 3,
    "babylonian": 5,
    "babylonians": 5,
    "babysat": 3,
    "babysit": 3,
    "babysitter": 4,
    "babysitters": 4,
    "babysitting": 4,
    "baca": 2,
    "bacall": 2,
    "bacardi": 3,
    "baccalaureate": 5,
    "baccarat": 3,
    "baccari": 3,
    "bacchanal": 3,
    "bacchanal(1)": 3,
    "bacchanalia": 4,
    "bacchi": 2,
    "bacchus": 2,
    "bacci": 2,
    "baccus": 2,
    "bach": 1,
    "bacha": 2,
    "bachailian": 4,
    "bachand": 2,
    "bachar": 2,
    "bacharach": 3,
    "bache": 1,
    "bache(1)": 1,
    "bache's": 2,
    "bache's(1)": 2,
    "bachelder": 3,
    "bacheller": 3,
    "bachelor": 3,
    "bachelor(1)": 2,
    "bachelor's": 3,
    "bachelor's(1)": 2,
    "bachelors": 2,
    "bacher": 2,
    "bachera": 3,
    "bachert": 2,
    "bachler": 2,
    "bachman": 2,
    "bachmann": 2,
    "bachmeier": 3,
    "bachner": 2,
    "bachrach": 2,
    "bachtel": 2,
    "bachtell": 2,
    "bachus": 2,
    "bacigalupi": 5,
    "bacigalupo": 5,
    "bacik": 2,
    "bacillus": 3,
    "bacino": 3,
    "back": 1,
    "backache": 2,
    "backaches": 2,
    "backbite": 2,
    "backbiting": 3,
    "backboard": 2,
    "backboards": 2,
    "backbone": 2,
    "backbones": 2,
    "backdate": 2,
    "backdated": 3,
    "backdates": 2,
    "backdating": 3,
    "backdoor": 2,
    "backdoors": 2,
    "backdrop": 2,
    "backdrops": 2,
    "backe": 1,
    "backed": 1,
    "backend": 2,
    "backends": 2,
    "backer": 2,
    "backer's": 2,
    "backers": 2,
    "backes": 1,
    "backfield": 2,
    "backfields": 2,
    "backfire": 2,
    "backfired": 3,
    "backfires": 3,
    "backfiring": 4,
    "backgammon": 3,
    "background": 2,
    "backgrounds": 2,
    "backhand": 2,
    "backhanded": 3,
    "backhanded(1)": 3,
    "backhaus": 2,
    "backhoe": 2,
    "backhoes": 2,
    "backing": 2,
    "backlash": 2,
    "backlashes": 3,
    "backless": 2,
    "backlight": 2,
    "backlights": 2,
    "backlist": 2,
    "backlisted": 3,
    "backlog": 2,
    "backlog(1)": 2,
    "backlogged": 2,
    "backlogs": 2,
    "backlund": 2,
    "backman": 2,
    "backpack": 2,
    "backpacker": 3,
    "backpacking": 3,
    "backpacks": 2,
    "backpedal": 3,
    "backpedaled": 3,
    "backpedaling": 4,
    "backpedaling(1)": 3,
    "backpedals": 3,
    "backrest": 2,
    "backrests": 2,
    "backroom": 2,
    "backrooms": 2,
    "backs": 1,
    "backsaw": 2,
    "backsaw(1)": 2,
    "backsaws": 2,
    "backsaws(1)": 2,
    "backseat": 2,
    "backseats": 2,
    "backset": 2,
    "backside": 2,
    "backsides": 2,
    "backslap": 2,
    "backslapping": 3,
    "backslash": 2,
    "backslashes": 3,
    "backslide": 2,
    "backsliding": 3,
    "backspin": 2,
    "backstage": 2,
    "backstairs": 2,
    "backstitch": 2,
    "backstitches": 3,
    "backstop": 2,
    "backstroke": 2,
    "backstrom": 2,
    "backtrack": 2,
    "backtracked": 2,
    "backtracking": 3,
    "backtracks": 2,
    "backup": 2,
    "backups": 2,
    "backus": 2,
    "backward": 2,
    "backwardation": 4,
    "backwardness": 3,
    "backwards": 2,
    "backwash": 2,
    "backwater": 3,
    "backwaters": 3,
    "backwoods": 2,
    "backwoodsman": 3,
    "backyard": 2,
    "backyards": 2,
    "bacon": 2,
    "bacon's": 2,
    "bacorn": 2,
    "bacot": 2,
    "bacot(1)": 2,
    "bacote": 2,
    "bacteria": 4,
    "bacteria's": 4,
    "bacterial": 4,
    "bacteriology": 6,
    "bacterium": 4,
    "bacus": 2,
    "bad": 1,
    "bada": 2,
    "badal": 2,
    "badalamenti": 5,
    "badami": 3,
    "badavatz": 3,
    "badders": 2,
    "bade": 1,
    "badeah": 3,
    "badeau": 2,
    "badeaux": 2,
    "badelain": 3,
    "baden": 2,
    "baden's": 2,
    "bader": 2,
    "bader(1)": 2,
    "badertscher": 3,
    "badge": 1,
    "badger": 2,
    "badger's": 2,
    "badgered": 2,
    "badgering": 3,
    "badgers": 2,
    "badges": 2,
    "badgett": 2,
    "badgley": 2,
    "badia": 3,
    "badillo": 3,
    "badland": 2,
    "badlands": 2,
    "badley": 2,
    "badly": 2,
    "badman": 2,
    "badminton": 3,
    "badmintons": 3,
    "badness": 2,
    "badolato": 4,
    "badour": 2,
    "badu": 2,
    "badura": 3,
    "bady": 2,
    "bae": 1,
    "baechle": 2,
    "baecker": 2,
    "baedeker": 3,
    "baedeker's": 3,
    "baehr": 1,
    "baehr(1)": 1,
    "baek": 1,
    "baek(1)": 1,
    "baer": 1,
    "baerwald": 2,
    "baeten": 2,
    "baetjer": 2,
    "baetz": 1,
    "baez": 2,
    "baeza": 2,
    "baffa": 2,
    "baffle": 2,
    "baffled": 2,
    "baffles": 2,
    "baffling": 3,
    "baffling(1)": 2,
    "bafokeng": 3,
    "bag": 1,
    "bagan": 2,
    "bagby": 2,
    "bagdad": 2,
    "bagdasarian": 5,
    "bagdikian": 4,
    "bagdon": 2,
    "bagdonas": 3,
    "bagel": 2,
    "bageland": 3,
    "bagels": 2,
    "bagent": 2,
    "bagful": 2,
    "bagg": 1,
    "baggage": 2,
    "baggage(1)": 2,
    "bagge": 1,
    "bagged": 1,
    "baggerly": 3,
    "baggett": 2,
    "baggie": 2,
    "bagginess": 3,
    "bagging": 2,
    "baggio": 3,
    "baggio's": 3,
    "baggott": 2,
    "baggs": 1,
    "baggy": 2,
    "baghdad": 2,
    "baghdad's": 2,
    "baghli": 2,
    "baginski": 3,
    "bagley": 2,
    "baglio": 3,
    "bagman": 2,
    "bagnall": 2,
    "bagnato": 3,
    "bagnell": 2,
    "bagpipe": 2,
    "bagpiper": 3,
    "bagpipes": 2,
    "bags": 1,
    "bagsby": 2,
    "bagshaw": 2,
    "baguette": 2,
    "bagwell": 2,
    "bah": 1,
    "baha'is": 3,
    "baham": 2,
    "bahama": 3,
    "bahamas": 3,
    "bahamian": 4,
    "bahan": 2,
    "bahe": 1,
    "bahena": 3,
    "bahia": 3,
    "bahir": 2,
    "bahl": 1,
    "bahler": 2,
    "bahls": 1,
    "bahm": 1,
    "bahman": 2,
    "bahn": 1,
    "bahner": 2,
    "bahnsen": 2,
    "bahr": 1,
    "bahr(1)": 1,
    "bahrain": 2,
    "bahrain(1)": 2,
    "bahrain's": 2,
    "bahrain's(1)": 2,
    "bahraini": 3,
    "bahraini(1)": 3,
    "bahraini(2)": 3,
    "bahrainian": 4,
    "bahrainian(1)": 4,
    "bahrainian(2)": 4,
    "bahrainis": 3,
    "bahre": 1,
    "bahrenburg": 3,
    "baht": 1,
    "baidoa": 3,
    "baidoa's": 3,
    "baidoan": 3,
    "baidoan's": 3,
    "baidoans": 3,
    "baidoas": 3,
    "baie": 2,
    "baier": 2,
    "baig": 1,
    "baikonur": 3,
    "bail": 1,
    "baila": 2,
    "bailard": 2,
    "bailby": 2,
    "baile": 1,
    "bailed": 1,
    "bailer": 2,
    "bailes": 1,
    "bailey": 2,
    "bailey's": 2,
    "baileys": 2,
    "bailie": 2,
    "bailiff": 2,
    "bailiff(1)": 2,
    "bailiffs": 2,
    "bailin": 2,
    "bailing": 2,
    "bailiwick": 3,
    "baillargeon": 3,
    "baillie": 2,
    "bailly": 2,
    "bailon": 2,
    "bailor": 2,
    "bailout": 2,
    "bailouts": 2,
    "bails": 1,
    "baily": 2,
    "bailyn": 2,
    "baim": 1,
    "bain": 1,
    "bain's": 1,
    "bainbridge": 2,
    "bainbridge's": 3,
    "baine": 1,
    "bainerd": 2,
    "baines": 1,
    "bains": 1,
    "bainter": 2,
    "bainton": 2,
    "baio": 3,
    "bair": 1,
    "baird": 1,
    "baird's": 1,
    "bairnco": 2,
    "baisch": 1,
    "baisden": 2,
    "baise": 1,
    "baisley": 2,
    "bait": 1,
    "baited": 2,
    "baiting": 2,
    "baits": 1,
    "baity": 2,
    "baiul": 2,
    "baiul's": 2,
    "baize": 1,
    "baja": 2,
    "bajarin": 3,
    "bajema": 3,
    "bajorek": 3,
    "bak": 1,
    "baka": 2,
    "bakalar": 3,
    "bake": 1,
    "bake-off": 2,
    "bake-offs": 2,
    "baked": 1,
    "bakelman": 3,
    "bakeman": 2,
    "baker": 2,
    "baker's": 2,
    "bakeries": 3,
    "bakers": 2,
    "bakersfield": 3,
    "bakery": 3,
    "bakes": 1,
    "bakeware": 2,
    "bakewell": 2,
    "bakey": 2,
    "bakey's": 2,
    "baking": 2,
    "bakke": 1,
    "bakken": 2,
    "bakker": 2,
    "bakker(1)": 2,
    "bakker's": 2,
    "bakker's(1)": 2,
    "bakkers": 2,
    "bakkers(1)": 2,
    "bakley": 2,
    "bakos": 2,
    "bakowski": 3,
    "bakrewali": 4,
    "bakrie": 2,
    "bakshi": 2,
    "bakst": 1,
    "baku": 2,
    "bakula": 3,
    "bal": 1,
    "bala": 2,
    "balaban": 3,
    "balaguer": 3,
    "balakumar": 4,
    "balan": 2,
    "balance": 2,
    "balanced": 2,
    "balancer": 3,
    "balances": 3,
    "balances(1)": 3,
    "balanchine": 3,
    "balanchine's": 3,
    "balancing": 3,
    "balart": 2,
    "balas": 2,
    "balash": 2,
    "balata": 3,
    "balazs": 2,
    "balbach": 2,
    "balbi": 2,
    "balbina": 3,
    "balbo": 2,
    "balboa": 3,
    "balboni": 3,
    "balbriggan": 3,
    "balbriggans": 3,
    "balcer": 2,
    "balcerowicz": 4,
    "balcerzak": 3,
    "balch": 1,
    "balchunas": 3,
    "balcom": 2,
    "balconies": 3,
    "balcony": 3,
    "balcor": 2,
    "bald": 1,
    "baldassare": 4,
    "baldassari": 4,
    "baldassarre": 4,
    "baldauf": 2,
    "baldelli": 3,
    "baldemar": 3,
    "balder": 2,
    "balderas": 3,
    "balderdash": 3,
    "balderrama": 4,
    "balderson": 3,
    "balderston": 3,
    "baldev": 2,
    "baldez": 2,
    "baldi": 2,
    "balding": 2,
    "baldinger": 3,
    "baldini": 3,
    "baldini's": 3,
    "baldino": 3,
    "baldly": 2,
    "baldner": 2,
    "baldness": 2,
    "baldo": 2,
    "baldock": 2,
    "baldonado": 4,
    "baldoni": 3,
    "baldor": 2,
    "baldree": 2,
    "baldric": 2,
    "baldridge": 2,
    "baldrige": 2,
    "baldry": 2,
    "balducci": 3,
    "baldur": 2,
    "baldus": 2,
    "baldwin": 2,
    "baldwin(1)": 2,
    "baldwin's": 2,
    "baldyga": 3,
    "bale": 1,
    "baleen": 2,
    "baleful": 2,
    "balentine": 4,
    "baler": 2,
    "bales": 1,
    "balestra": 3,
    "balestrieri": 4,
    "baley": 2,
    "balfanz": 2,
    "balfe": 1,
    "balfour": 2,
    "bali": 2,
    "balian": 3,
    "balicki": 3,
    "balik": 2,
    "balilan": 3,
    "baliles": 3,
    "balin": 2,
    "balinese": 3,
    "baling": 2,
    "balinski": 3,
    "balint": 2,
    "balis": 2,
    "balistreri": 4,
    "balk": 1,
    "balk(1)": 1,
    "balkan": 2,
    "balkanization": 5,
    "balkanize": 3,
    "balkanized": 3,
    "balkans": 2,
    "balkcom": 2,
    "balke": 1,
    "balked": 1,
    "balkin": 2,
    "balking": 2,
    "balko": 2,
    "balks": 1,
    "balky": 2,
    "ball": 1,
    "ball's": 1,
    "balla": 2,
    "ballad": 2,
    "ballade": 2,
    "ballads": 2,
    "balladur": 3,
    "balladur's": 3,
    "ballance": 2,
    "ballantine": 3,
    "ballantrae": 3,
    "ballantyne": 3,
    "ballard": 2,
    "ballard's": 2,
    "ballas": 2,
    "ballast": 2,
    "ballasts": 2,
    "ballasts(1)": 2,
    "ballclub": 2,
    "ballcock": 2,
    "ballcocks": 2,
    "balle": 1,
    "balled": 1,
    "ballengee": 3,
    "ballenger": 3,
    "ballentine": 4,
    "baller": 2,
    "ballerina": 4,
    "ballerinas": 4,
    "balles": 1,
    "ballester": 3,
    "ballesteros": 4,
    "ballesteros(1)": 4,
    "ballet": 2,
    "ballet's": 2,
    "ballets": 2,
    "balletto": 3,
    "ballew": 2,
    "ballgame": 2,
    "balli": 2,
    "balliet": 3,
    "balliett": 2,
    "ballin": 2,
    "balling": 2,
    "ballinger": 3,
    "ballistic": 3,
    "ballistics": 3,
    "balliwick": 3,
    "ballman": 2,
    "ballmer": 2,
    "ballo": 2,
    "ballon": 2,
    "balloon": 2,
    "ballooned": 2,
    "ballooning": 3,
    "balloonist": 3,
    "balloonists": 3,
    "balloons": 2,
    "ballor": 2,
    "ballot": 2,
    "balloting": 3,
    "ballots": 2,
    "ballou": 2,
    "ballow": 2,
    "ballowe": 2,
    "ballpark": 2,
    "ballparks": 2,
    "ballplayer": 3,
    "ballplayers": 3,
    "ballpoint": 2,
    "ballpoints": 2,
    "ballroom": 2,
    "ballrooms": 2,
    "balls": 1,
    "ballweg": 2,
    "ballwig": 2,
    "ballwig's": 2,
    "bally": 2,
    "bally(1)": 2,
    "bally's": 2,
    "bally's(1)": 2,
    "ballyhoo": 3,
    "ballyhooed": 3,
    "balm": 1,
    "balm(1)": 1,
    "balmer": 2,
    "balmes": 2,
    "balmoral": 3,
    "balmorals": 3,
    "balms": 1,
    "balms(1)": 1,
    "balmy": 2,
    "balodia": 4,
    "balog": 2,
    "baloga": 3,
    "balogh": 2,
    "balon": 2,
    "baloney": 3,
    "balow": 2,
    "balsa": 2,
    "balsam": 2,
    "balsamo": 3,
    "balsbaugh": 2,
    "balser": 2,
    "balsiger": 3,
    "balsley": 2,
    "balster": 2,
    "balt's": 1,
    "baltazar": 3,
    "balter": 2,
    "baltes": 1,
    "balthasar": 3,
    "balthaser": 3,
    "balthazar": 3,
    "balthazor": 3,
    "balthrop": 2,
    "baltic": 2,
    "baltica": 3,
    "baltics": 2,
    "baltierra": 3,
    "baltimore": 3,
    "baltimore's": 3,
    "balto": 2,
    "baltodano": 4,
    "baltsa": 2,
    "baltz": 1,
    "baltzell": 2,
    "baltzer": 2,
    "baluchi": 3,
    "baluja": 3,
    "balukas": 3,
    "balyeat": 3,
    "balz": 1,
    "balzano": 3,
    "balzarini": 4,
    "balzer": 2,
    "bam": 1,
    "bamako": 3,
    "bamba": 2,
    "bambach": 2,
    "bambenek": 3,
    "bamber": 2,
    "bamberg": 2,
    "bamberger": 3,
    "bambi": 2,
    "bambino": 3,
    "bambinos": 3,
    "bamboo": 2,
    "bambrick": 2,
    "bamburg": 2,
    "bame": 1,
    "bamford": 2,
    "bamut": 2,
    "ban": 1,
    "ban's": 1,
    "banacci": 3,
    "banach": 2,
    "banal": 2,
    "banalities": 4,
    "banality": 4,
    "banamex": 3,
    "banana": 3,
    "bananas": 3,
    "banas": 2,
    "banasiak": 4,
    "banaszak": 3,
    "banbury": 3,
    "banc": 1,
    "banca": 2,
    "banca(1)": 2,
    "bancaire": 2,
    "bancario": 4,
    "banco": 2,
    "bancoklahoma": 5,
    "bancomer": 3,
    "bancor": 2,
    "bancorp": 2,
    "bancorp(1)": 2,
    "bancorp's": 2,
    "bancorp's(1)": 2,
    "bancorporation": 5,
    "bancroft": 2,
    "bancroft's": 2,
    "bancserve": 2,
    "bancshares": 2,
    "bancshares'": 2,
    "banctec": 2,
    "banctexas": 3,
    "band": 1,
    "band's": 1,
    "banda": 2,
    "bandag": 2,
    "bandage": 2,
    "bandaged": 2,
    "bandages": 3,
    "bandages(1)": 3,
    "bandai": 2,
    "bandaid": 2,
    "bandana": 3,
    "bandanas": 3,
    "bandar": 2,
    "banded": 2,
    "bandel": 2,
    "bandemer": 3,
    "bander": 2,
    "banderas": 3,
    "banderas(1)": 3,
    "bandicoot": 3,
    "bandicoot(1)": 3,
    "bandicoots": 3,
    "bandicoots(1)": 3,
    "bandied": 2,
    "banding": 2,
    "bandit": 2,
    "banditry": 3,
    "bandits": 2,
    "bandleader": 3,
    "bandleaders": 3,
    "bandolier": 3,
    "bandoliers": 3,
    "bandow": 2,
    "bandow's": 2,
    "bands": 1,
    "bandshell": 2,
    "bandstand": 2,
    "bandt": 1,
    "banducci": 3,
    "bandwagon": 3,
    "bandwidth": 2,
    "bandy": 2,
    "bane": 1,
    "banegas": 3,
    "banerjee": 3,
    "banes": 1,
    "banesto": 3,
    "banesto's": 3,
    "banet": 2,
    "baney": 2,
    "banff": 1,
    "banfield": 2,
    "banford": 2,
    "bang": 1,
    "bangala": 3,
    "bangalor": 3,
    "bangalore": 3,
    "bangalore's": 3,
    "bange": 1,
    "banged": 1,
    "bangee": 2,
    "bangemann": 3,
    "banger": 2,
    "bangers": 2,
    "bangert": 2,
    "bangerter": 3,
    "banghart": 2,
    "banging": 2,
    "bangish": 2,
    "bangkok": 2,
    "bangkok(1)": 2,
    "bangkok's": 2,
    "bangladesh": 3,
    "bangladesh's": 4,
    "bangladeshi": 4,
    "bangladeshi's": 4,
    "bangladeshis": 4,
    "bangle": 2,
    "bangles": 2,
    "bango": 2,
    "bangor": 2,
    "bangor(1)": 2,
    "bangs": 1,
    "banh": 1,
    "bania": 3,
    "banick": 2,
    "banik": 2,
    "banis": 2,
    "banish": 2,
    "banished": 2,
    "banishing": 3,
    "banishment": 3,
    "banister": 3,
    "banja": 2,
    "banjo": 2,
    "bank": 1,
    "bank's": 1,
    "bankable": 3,
    "bankamerica": 5,
    "bankamerica's": 5,
    "bankatlantic": 4,
    "bankbook": 2,
    "bankcard": 2,
    "bankcards": 2,
    "bankcorp": 2,
    "banke": 1,
    "bankeast": 2,
    "banked": 1,
    "banken": 2,
    "banker": 2,
    "banker's": 2,
    "bankers": 2,
    "bankers'": 2,
    "bankert": 2,
    "bankes": 1,
    "bankey": 2,
    "bankhead": 2,
    "bankholding": 3,
    "banking": 2,
    "banking's": 2,
    "banknote": 2,
    "banknotes": 2,
    "banko": 2,
    "bankowski": 3,
    "bankroll": 2,
    "bankrolled": 2,
    "bankrolling": 3,
    "bankrolls": 2,
    "bankrupcty": 3,
    "bankrupt": 2,
    "bankruptcies": 3,
    "bankruptcy": 3,
    "bankruptcy(1)": 3,
    "bankruptcy's": 3,
    "bankrupted": 3,
    "bankrupting": 3,
    "banks": 1,
    "banks'": 1,
    "banks's": 2,
    "bankshare": 2,
    "bankshares": 2,
    "bankson": 2,
    "bankston": 2,
    "bankverein": 3,
    "bankvermont": 3,
    "bankworcester": 4,
    "bankworcester(1)": 3,
    "bann": 1,
    "bannan": 2,
    "banned": 1,
    "banner": 2,
    "banner's": 2,
    "bannerman": 3,
    "banners": 2,
    "bannick": 2,
    "banning": 2,
    "bannings": 2,
    "bannister": 3,
    "bannister(1)": 3,
    "bannon": 2,
    "banos": 2,
    "banoun": 2,
    "banpais": 2,
    "banponce": 2,
    "banque": 1,
    "banquet": 2,
    "banquets": 2,
    "banquo's": 2,
    "bans": 1,
    "bansal": 2,
    "banshee": 2,
    "banshee(1)": 2,
    "banta": 2,
    "bantam": 2,
    "bantam's": 2,
    "bantams": 2,
    "banter": 2,
    "bantered": 2,
    "bantering": 3,
    "bantle": 2,
    "banton": 2,
    "bantu": 2,
    "bantz": 1,
    "banuelos": 3,
    "banville": 2,
    "banwart": 2,
    "banxquote": 2,
    "banya": 2,
    "banya(1)": 2,
    "banyaluca": 4,
    "banyan": 2,
    "banyas": 2,
    "banyas(1)": 2,
    "banyu": 2,
    "banzhaf": 2,
    "bao": 1,
    "baoguang": 3,
    "bapley": 2,
    "bapna": 2,
    "baptism": 3,
    "baptismal": 3,
    "baptisms": 3,
    "baptist": 2,
    "baptist(1)": 2,
    "baptista": 3,
    "baptiste": 2,
    "baptistery": 3,
    "baptists": 2,
    "baptists(1)": 2,
    "baptize": 2,
    "baptized": 2,
    "baptized(1)": 2,
    "bar": 1,
    "bar's": 1,
    "bar-mitzvah": 3,
    "bara": 2,
    "barabar": 3,
    "barach": 2,
    "barach(1)": 2,
    "baraff": 2,
    "baragi": 3,
    "barahona": 4,
    "barajas": 3,
    "barak": 2,
    "barakat": 3,
    "baram": 2,
    "baran": 2,
    "baranek": 3,
    "baranoski": 4,
    "baranowski": 4,
    "baranski": 3,
    "barany": 3,
    "barasch": 2,
    "barash": 2,
    "barath": 2,
    "baratta": 3,
    "barb": 1,
    "barb's": 1,
    "barba": 2,
    "barbados": 3,
    "barbagallo": 4,
    "barbakow": 3,
    "barbanel": 3,
    "barbano": 3,
    "barbara": 3,
    "barbara(1)": 2,
    "barbara's": 3,
    "barbaree": 3,
    "barbarian": 4,
    "barbarians": 4,
    "barbaric": 3,
    "barbaric(1)": 3,
    "barbarino": 4,
    "barbarism": 4,
    "barbarity": 4,
    "barbarity(1)": 4,
    "barbaro": 3,
    "barbarous": 3,
    "barbary": 3,
    "barbash": 2,
    "barbato": 3,
    "barbe": 1,
    "barbeau": 2,
    "barbecue": 3,
    "barbecue's": 3,
    "barbecued": 3,
    "barbecueing": 4,
    "barbecues": 3,
    "barbed": 1,
    "barbed-wire": 2,
    "barbee": 2,
    "barbell": 2,
    "barbella": 3,
    "barbells": 2,
    "barbels": 2,
    "barbeque": 3,
    "barbequed": 3,
    "barbequeing": 4,
    "barbeques": 3,
    "barber": 2,
    "barber's": 2,
    "barbera": 3,
    "barberi": 3,
    "barberio": 4,
    "barberis": 3,
    "barbero": 3,
    "barbers": 2,
    "barbershop": 3,
    "barbette": 2,
    "barbian": 3,
    "barbie": 2,
    "barbie's": 2,
    "barbier": 3,
    "barbieri": 3,
    "barbieri's": 3,
    "barbies": 2,
    "barbin": 2,
    "barbiturate": 4,
    "barbiturates": 4,
    "barbo": 2,
    "barbone": 2,
    "barbosa": 3,
    "barbour": 2,
    "barbour's": 2,
    "barboursville": 3,
    "barboza": 3,
    "barbra": 2,
    "barbre": 2,
    "barbs": 1,
    "barbuda": 3,
    "barby": 2,
    "barca": 2,
    "barcella": 3,
    "barcellos": 3,
    "barcelo": 3,
    "barcelona": 4,
    "barcenas": 3,
    "barch": 1,
    "barchefsky": 3,
    "barcia": 2,
    "barclay": 2,
    "barclay(1)": 2,
    "barclay's": 2,
    "barclay's(1)": 2,
    "barclays": 2,
    "barclays(1)": 2,
    "barclays'": 2,
    "barclays'(1)": 2,
    "barclays's": 3,
    "barclays's(1)": 3,
    "barclift": 2,
    "barco": 2,
    "barco's": 2,
    "barcomb": 2,
    "barcroft": 2,
    "barcus": 2,
    "barczak": 2,
    "bard": 1,
    "bard's": 1,
    "bardell": 2,
    "barden": 2,
    "bardera": 3,
    "bardin": 2,
    "bardo": 2,
    "bardolf": 2,
    "bardolph": 2,
    "bardon": 2,
    "bardrick": 2,
    "bardsley": 2,
    "bardulf": 2,
    "bardulph": 2,
    "bardwell": 2,
    "bare": 1,
    "bared": 1,
    "barefield": 3,
    "barefield(1)": 2,
    "barefoot": 2,
    "bareis": 2,
    "barela": 3,
    "barely": 2,
    "barenboim": 3,
    "barenboim's": 3,
    "barens": 2,
    "barentine": 4,
    "barentine(1)": 3,
    "barentine(2)": 3,
    "barents": 2,
    "bares": 1,
    "barest": 2,
    "barey": 2,
    "barfield": 2,
    "barfknecht": 2,
    "barfknecht(1)": 2,
    "barfoot": 2,
    "barfuss": 2,
    "barg": 1,
    "barga": 2,
    "bargain": 2,
    "bargain(1)": 2,
    "bargained": 2,
    "bargainer": 3,
    "bargainers": 3,
    "bargaining": 3,
    "bargains": 2,
    "bargains(1)": 2,
    "barganier": 4,
    "bargar": 2,
    "bargas": 2,
    "barge": 1,
    "barged": 1,
    "barger": 2,
    "bargeron": 3,
    "barges": 2,
    "barges(1)": 2,
    "barging": 2,
    "bargman": 2,
    "bargmann": 2,
    "bargo": 2,
    "barham": 2,
    "barhorst": 2,
    "bari": 2,
    "bari's": 2,
    "baribeau": 3,
    "barich": 2,
    "baril": 2,
    "barile": 2,
    "barillari": 4,
    "barillari's": 4,
    "barillo": 3,
    "barinco": 3,
    "baring": 2,
    "baring's": 2,
    "baringer": 3,
    "barings": 2,
    "barings'": 2,
    "baris": 2,
    "barish": 2,
    "barite": 2,
    "barites": 2,
    "baritone": 3,
    "baritones": 3,
    "barium": 3,
    "bark": 1,
    "barkai": 2,
    "barkalow": 3,
    "barkan": 2,
    "barkdoll": 2,
    "barkdull": 2,
    "barke": 1,
    "barked": 1,
    "barkeley": 2,
    "barker": 2,
    "barkers": 2,
    "barkes": 1,
    "barkett": 2,
    "barkey": 2,
    "barkhurst": 2,
    "barkin": 2,
    "barking": 2,
    "barkley": 2,
    "barklow": 2,
    "barkman": 2,
    "barko": 2,
    "barkocy": 3,
    "barkow": 2,
    "barks": 1,
    "barksdale": 2,
    "barkshire": 2,
    "barkus": 2,
    "barlage": 2,
    "barlett": 2,
    "barletta": 3,
    "barlettesville": 3,
    "barley": 2,
    "barloon": 2,
    "barlow": 2,
    "barlowe": 2,
    "barman": 2,
    "barmore": 2,
    "barn": 1,
    "barna": 2,
    "barnabas": 3,
    "barnaby": 3,
    "barnaby's": 3,
    "barnacle": 3,
    "barnacles": 3,
    "barnard": 2,
    "barnard(1)": 2,
    "barnard(2)": 2,
    "barnard's": 2,
    "barnards": 2,
    "barnas": 2,
    "barndt": 1,
    "barnell": 2,
    "barner": 2,
    "barnes": 1,
    "barnet": 2,
    "barnett": 2,
    "barnett's": 2,
    "barnette": 2,
    "barnevik": 3,
    "barney": 2,
    "barney's": 2,
    "barneys": 2,
    "barnfield": 2,
    "barnhard": 2,
    "barnhardt": 2,
    "barnhart": 2,
    "barnhill": 2,
    "barnhouse": 2,
    "barnick": 2,
    "barnicle": 3,
    "barnish": 2,
    "barno": 2,
    "barnowski": 3,
    "barns": 1,
    "barnstorm": 2,
    "barnstorming": 3,
    "barnum": 2,
    "barnwell": 2,
    "barny": 2,
    "barnyard": 2,
    "baro": 2,
    "baroid": 2,
    "barometer": 4,
    "barometers": 4,
    "barometric": 4,
    "baron": 2,
    "baron(1)": 2,
    "baron's": 2,
    "baron's(1)": 2,
    "barone": 2,
    "barone's": 2,
    "baroness": 3,
    "baronet": 3,
    "baronet(1)": 3,
    "baronets": 3,
    "baronets(1)": 3,
    "baroni": 3,
    "barons": 2,
    "barons(1)": 2,
    "baroody": 3,
    "baroque": 2,
    "baros": 2,
    "barovic": 3,
    "barovsky": 3,
    "barr": 1,
    "barr's": 1,
    "barra": 2,
    "barrack": 2,
    "barrack(1)": 2,
    "barracks": 2,
    "barracks(1)": 2,
    "barraclough": 3,
    "barraco": 3,
    "barracuda": 4,
    "barradino": 4,
    "barragan": 3,
    "barrage": 2,
    "barraged": 2,
    "barrages": 3,
    "barranco": 3,
    "barras": 2,
    "barrasso": 3,
    "barratt": 2,
    "barraza": 3,
    "barre": 2,
    "barre(1)": 1,
    "barreca": 3,
    "barred": 1,
    "barreda": 3,
    "barreiro": 3,
    "barrel": 2,
    "barrel(1)": 2,
    "barreled": 2,
    "barreled(1)": 2,
    "barreling": 3,
    "barreling(1)": 3,
    "barrell": 2,
    "barrels": 2,
    "barrels(1)": 2,
    "barren": 2,
    "barren(1)": 2,
    "barrens": 2,
    "barrentine": 3,
    "barrera": 3,
    "barreras": 3,
    "barres": 1,
    "barresi": 3,
    "barret": 2,
    "barreto": 3,
    "barrett": 2,
    "barrett(1)": 2,
    "barretta": 3,
    "barrette": 2,
    "barretto": 3,
    "barricada": 4,
    "barricade": 3,
    "barricade(1)": 3,
    "barricaded": 4,
    "barricaded(1)": 4,
    "barricades": 3,
    "barricades(1)": 3,
    "barrick": 2,
    "barrick(1)": 2,
    "barrick's": 2,
    "barrick's(1)": 2,
    "barricklow": 3,
    "barrickman": 3,
    "barrie": 2,
    "barrie(1)": 2,
    "barrientes": 2,
    "barrientez": 3,
    "barrientos": 3,
    "barrier": 3,
    "barrier(1)": 3,
    "barriere": 3,
    "barriers": 3,
    "barriers(1)": 3,
    "barriga": 3,
    "barriger": 3,
    "barrilleaux": 3,
    "barrineau": 3,
    "barring": 2,
    "barringer": 3,
    "barrings": 2,
    "barrington": 3,
    "barrington(1)": 3,
    "barrio": 3,
    "barrios": 3,
    "barrios(1)": 3,
    "barris": 2,
    "barris(1)": 2,
    "barrish": 2,
    "barrister": 3,
    "barrister(1)": 3,
    "barristers": 3,
    "barristers(1)": 3,
    "barritt": 2,
    "barro": 2,
    "barron": 2,
    "barron(1)": 2,
    "barron's": 2,
    "barron's(1)": 2,
    "barrone": 2,
    "barroom": 2,
    "barros": 2,
    "barroso": 3,
    "barrow": 2,
    "barrow(1)": 2,
    "barrowman": 3,
    "barrowman(1)": 3,
    "barrows": 2,
    "barrows(1)": 2,
    "barrs": 1,
    "barrus": 2,
    "barry": 2,
    "barry(1)": 2,
    "barry's": 2,
    "barry's(1)": 2,
    "barrymore": 3,
    "barrymore(1)": 3,
    "bars": 1,
    "barsamian": 4,
    "barsanti": 3,
    "barsch": 1,
    "barschel": 2,
    "barsh": 1,
    "barshefsky": 3,
    "barsky": 2,
    "barsness": 2,
    "barson": 2,
    "barsotti": 3,
    "barstad": 2,
    "barstow": 2,
    "barszcz": 1,
    "bart": 1,
    "bart's": 1,
    "barta": 2,
    "bartak": 2,
    "bartee": 2,
    "bartek": 2,
    "bartel": 2,
    "bartell": 2,
    "bartels": 2,
    "bartelson": 3,
    "bartelt": 2,
    "barten": 2,
    "bartender": 3,
    "bartenders": 3,
    "barter": 2,
    "bartered": 2,
    "bartering": 3,
    "barth": 1,
    "bartha": 2,
    "barthel": 2,
    "barthelemy": 4,
    "barthelme": 2,
    "barthelme's": 2,
    "barthes": 1,
    "barthold": 2,
    "bartholdy": 3,
    "bartholomay": 4,
    "bartholomew": 4,
    "bartholow": 3,
    "barthram": 2,
    "bartko": 2,
    "bartkowiak": 4,
    "bartkowski": 3,
    "bartkus": 2,
    "bartl": 2,
    "bartle": 2,
    "bartlebaugh": 3,
    "bartles": 2,
    "bartleson": 3,
    "bartlestein": 3,
    "bartlestein(1)": 3,
    "bartlesville": 3,
    "bartlett": 2,
    "bartlett's": 2,
    "bartley": 2,
    "bartling": 2,
    "bartlow": 2,
    "bartman": 2,
    "bartmess": 2,
    "bartnick": 2,
    "bartnicki": 3,
    "bartnik": 2,
    "barto": 2,
    "bartok": 2,
    "bartol": 2,
    "bartoletti": 4,
    "bartoli": 3,
    "bartolini": 4,
    "bartolo": 3,
    "bartolomei": 5,
    "bartolomeo": 5,
    "bartolucci": 4,
    "barton": 2,
    "barton's": 2,
    "bartone": 3,
    "bartoo": 2,
    "bartos": 2,
    "bartosch": 2,
    "bartosh": 2,
    "bartosiewicz": 4,
    "bartosik": 3,
    "bartoszek": 3,
    "bartow": 2,
    "bartram": 2,
    "barts": 1,
    "bartsch": 1,
    "bartunek": 3,
    "bartus": 2,
    "bartz": 1,
    "baruch": 2,
    "barwick": 2,
    "baryshnikov": 4,
    "baryshnikov's": 4,
    "barz": 1,
    "bas-relief": 3,
    "bas-relief(1)": 3,
    "bas-reliefs": 3,
    "bas-reliefs(1)": 3,
    "basa": 2,
    "basal": 2,
    "basaldua": 4,
    "basalt": 2,
    "basalts": 2,
    "basam": 2,
    "basara": 3,
    "basara's": 3,
    "basayev": 3,
    "basayev(1)": 3,
    "bascay": 2,
    "basch": 1,
    "basco": 2,
    "bascom": 2,
    "basden": 2,
    "base": 1,
    "base's": 2,
    "baseball": 2,
    "baseball's": 2,
    "baseballs": 2,
    "baseboard": 2,
    "baseboards": 2,
    "based": 1,
    "basehore": 3,
    "basehore(1)": 2,
    "basel": 2,
    "baseless": 2,
    "baseline": 2,
    "baselines": 2,
    "baseman": 2,
    "basement": 2,
    "basements": 2,
    "basenji": 3,
    "baser": 2,
    "bases": 2,
    "bases(1)": 2,
    "bases(2)": 2,
    "basey": 2,
    "basford": 2,
    "basgall": 2,
    "bash": 1,
    "basha": 2,
    "basham": 2,
    "bashar": 2,
    "bashaw": 2,
    "bashed": 1,
    "basher": 2,
    "bashers": 2,
    "bashes": 2,
    "bashford": 2,
    "bashful": 2,
    "bashing": 2,
    "bashir": 2,
    "bashor": 2,
    "bashore": 2,
    "basi": 2,
    "basi(1)": 2,
    "basic": 2,
    "basic's": 2,
    "basically": 3,
    "basich": 2,
    "basics": 2,
    "basie": 2,
    "basil": 2,
    "basile": 2,
    "basilia": 4,
    "basilica": 4,
    "basilica(1)": 4,
    "basilio": 4,
    "basim": 2,
    "basim's": 2,
    "basin": 2,
    "basing": 2,
    "basinger": 3,
    "basins": 2,
    "basinski": 3,
    "basis": 2,
    "basis(1)": 2,
    "basista": 3,
    "basix": 2,
    "bask": 1,
    "basked": 1,
    "baskerville": 3,
    "basket": 2,
    "basketball": 3,
    "basketball's": 3,
    "basketballs": 3,
    "basketmaker": 4,
    "basketmaking": 4,
    "basketry": 3,
    "baskets": 2,
    "baskett": 2,
    "baskette": 2,
    "baskin": 2,
    "basking": 2,
    "baskins": 2,
    "basks": 1,
    "basle": 2,
    "basler": 3,
    "basner": 2,
    "basnett": 2,
    "basnight": 2,
    "bason": 2,
    "basophilia": 5,
    "basophilic": 4,
    "basore": 3,
    "basque": 1,
    "basques": 1,
    "basquez": 2,
    "basra": 2,
    "bass": 1,
    "bass(1)": 1,
    "bass's": 2,
    "bass's(1)": 2,
    "bassa": 2,
    "bassam": 2,
    "basse": 1,
    "basses": 2,
    "basses(1)": 2,
    "basset": 2,
    "bassett": 2,
    "bassette": 2,
    "bassetti": 3,
    "bassford": 2,
    "bassham": 2,
    "bassi": 2,
    "bassin": 2,
    "bassinger": 3,
    "bassir": 2,
    "bassir's": 2,
    "bassist": 2,
    "bassists": 2,
    "bassler": 2,
    "bassman": 2,
    "basso": 2,
    "bassoon": 2,
    "bast": 1,
    "basta": 2,
    "bastarache": 3,
    "bastard": 2,
    "bastards": 2,
    "baste": 1,
    "basted": 2,
    "bastedo": 3,
    "basten": 2,
    "bastian": 2,
    "bastien": 2,
    "bastille": 2,
    "bastille(1)": 2,
    "bastin": 2,
    "basting": 2,
    "bastion": 2,
    "bastions": 2,
    "bastogne": 2,
    "bastogne's": 2,
    "baston": 2,
    "bastone": 2,
    "bastow": 2,
    "bastyr": 2,
    "basu": 2,
    "basulto": 3,
    "basurto": 3,
    "baswell": 2,
    "basye": 2,
    "bat": 1,
    "bataan": 2,
    "batan": 2,
    "batat": 2,
    "batavia": 4,
    "batavia(1)": 4,
    "batboy": 2,
    "batboys": 2,
    "batch": 1,
    "batchelder": 3,
    "batcheller": 3,
    "batchelor": 3,
    "batches": 2,
    "batches(1)": 2,
    "batdorf": 2,
    "bate": 1,
    "bated": 2,
    "bateman": 2,
    "bates": 1,
    "bates'": 1,
    "bateson": 3,
    "bateson(1)": 2,
    "bateson(2)": 2,
    "batesville": 2,
    "batey": 2,
    "bath": 1,
    "bathe": 1,
    "bathed": 1,
    "bather": 2,
    "bather(1)": 2,
    "bathers": 2,
    "bathers(1)": 2,
    "bathes": 1,
    "bathgate": 2,
    "bathing": 2,
    "bathke": 1,
    "batholith": 3,
    "batholiths": 3,
    "bathrick": 2,
    "bathrobe": 2,
    "bathrobes": 2,
    "bathroom": 2,
    "bathrooms": 2,
    "bathrooms(1)": 2,
    "baths": 1,
    "bathsheba": 3,
    "bathtub": 2,
    "bathtubs": 2,
    "bathurst": 2,
    "bathurst's": 2,
    "batibot": 3,
    "batie": 2,
    "batignolles": 4,
    "batik": 2,
    "batiks": 2,
    "batiks(1)": 2,
    "batista": 3,
    "batista's": 3,
    "batiste": 3,
    "batley": 2,
    "batman": 2,
    "batogowski": 4,
    "baton": 2,
    "baton(1)": 2,
    "baton(2)": 2,
    "baton-rouge": 3,
    "baton-rouge's": 4,
    "batons": 2,
    "bator": 2,
    "batra": 2,
    "batres": 2,
    "bats": 1,
    "batson": 2,
    "batson's": 2,
    "batt": 1,
    "battaglia": 4,
    "battaglini": 4,
    "battalion": 3,
    "battalions": 3,
    "batte": 1,
    "batted": 2,
    "battelle": 2,
    "battelle's": 2,
    "batten": 2,
    "battenberg": 3,
    "battenfield": 3,
    "battening": 3,
    "batter": 2,
    "battered": 2,
    "batterer": 3,
    "batterers": 3,
    "batteries": 3,
    "battering": 3,
    "batterman": 3,
    "batters": 2,
    "battersby": 3,
    "batterson": 3,
    "battery": 3,
    "batterymarch": 4,
    "battey": 2,
    "battiato": 4,
    "batticaloa": 5,
    "battin": 2,
    "batting": 2,
    "battipaglia": 5,
    "battis": 2,
    "battison": 3,
    "battista": 3,
    "battiste": 3,
    "battisti": 3,
    "battistoni": 4,
    "battle": 2,
    "battle's": 2,
    "battled": 2,
    "battlefield": 3,
    "battlefields": 3,
    "battlefront": 3,
    "battleground": 3,
    "battlegrounds": 3,
    "battlement": 3,
    "battlement(1)": 3,
    "battlements": 3,
    "battles": 2,
    "battleship": 3,
    "battleships": 3,
    "battling": 3,
    "battling(1)": 2,
    "batton": 2,
    "batts": 1,
    "batty": 2,
    "batuigas": 4,
    "batus": 2,
    "batus(1)": 2,
    "baty": 2,
    "batz": 1,
    "batzel": 2,
    "batzer": 2,
    "bauble": 2,
    "baubles": 2,
    "baublitz": 2,
    "bauch": 1,
    "baucom": 2,
    "baucum": 2,
    "baucus": 2,
    "baucus(1)": 2,
    "baud": 1,
    "baudendistel": 4,
    "bauder": 2,
    "baudoin": 2,
    "baudouin": 3,
    "bauer": 2,
    "bauerle": 3,
    "bauerlein": 3,
    "bauermeister": 4,
    "bauernfeind": 3,
    "bauers": 2,
    "baugh": 1,
    "baughan": 2,
    "baugher": 2,
    "baughman": 2,
    "baughn": 1,
    "bauguess": 2,
    "baugus": 2,
    "bauknecht": 2,
    "bauknight": 2,
    "baum": 1,
    "baum(1)": 1,
    "bauman": 2,
    "baumann": 2,
    "baumbach": 2,
    "baumberger": 3,
    "baumberger(1)": 3,
    "baumeister": 3,
    "baumel": 2,
    "baumer": 2,
    "baumert": 2,
    "baumgard": 2,
    "baumgard(1)": 2,
    "baumgardner": 3,
    "baumgardner(1)": 3,
    "baumgardt": 2,
    "baumgardt(1)": 2,
    "baumgarner": 3,
    "baumgarner(1)": 3,
    "baumgart": 2,
    "baumgart(1)": 2,
    "baumgarten": 3,
    "baumgarten(1)": 3,
    "baumgartner": 3,
    "baumgartner(1)": 3,
    "baumhardt": 2,
    "baumhardt(1)": 2,
    "baumhauer": 3,
    "baumhauer(1)": 3,
    "baumholder": 3,
    "baumholder(1)": 3,
    "baumler": 3,
    "baumler(1)": 3,
    "baumler(2)": 2,
    "baumstark": 2,
    "baumstark(1)": 2,
    "baun": 1,
    "baur": 1,
    "baur(1)": 2,
    "baus": 1,
    "bausch": 1,
    "bauserman": 3,
    "bausman": 2,
    "bautch": 1,
    "bautista": 3,
    "bautz": 1,
    "bautzer": 2,
    "bauwens": 2,
    "bauxite": 2,
    "bauza": 2,
    "bava": 2,
    "bavadra": 3,
    "bavaria": 4,
    "bavaria's": 4,
    "bavarian": 4,
    "bavaro": 3,
    "baver": 2,
    "bavis": 2,
    "bawd": 1,
    "bawden": 2,
    "bawdy": 2,
    "bawer": 2,
    "bawl": 1,
    "bawled": 1,
    "bax": 1,
    "baxa": 2,
    "baxendale": 3,
    "baxley": 2,
    "baxt": 1,
    "baxter": 2,
    "baxter's": 2,
    "bay": 1,
    "bay's": 1,
    "bay-area": 4,
    "bayanjou": 3,
    "bayar": 2,
    "bayard": 2,
    "baybank": 2,
    "baybank's": 2,
    "baybanks": 2,
    "baydhabo": 3,
    "baye": 1,
    "bayed": 1,
    "bayer": 2,
    "bayer's": 2,
    "bayerische": 3,
    "bayers": 2,
    "bayes": 1,
    "bayh": 1,
    "baying": 2,
    "bayle": 1,
    "baylee": 2,
    "baylen": 2,
    "bayles": 1,
    "bayless": 2,
    "bayley": 2,
    "bayliff": 2,
    "bayliner": 3,
    "baylis": 2,
    "bayliss": 2,
    "baylon": 2,
    "baylor": 2,
    "bayly": 2,
    "bayman": 2,
    "baynard": 2,
    "bayne": 1,
    "baynes": 1,
    "baynham": 2,
    "bayog": 2,
    "bayonet": 3,
    "bayonets": 3,
    "bayonne": 2,
    "bayou": 2,
    "bayous": 2,
    "bayouth": 2,
    "bayreuth": 2,
    "bays": 1,
    "bayse": 1,
    "bayside": 2,
    "baysinger": 3,
    "baytown": 2,
    "baytree": 2,
    "baytree's": 2,
    "bayuk": 2,
    "bayul": 2,
    "bayus": 2,
    "baywatch": 2,
    "baz": 1,
    "bazaar": 2,
    "bazaars": 2,
    "bazan": 2,
    "bazar": 2,
    "baze": 1,
    "bazemore": 2,
    "bazhan": 2,
    "bazile": 2,
    "bazile(1)": 2,
    "bazinet": 3,
    "bazooka": 3,
    "bazookas": 3,
    "bazzano": 3,
    "bazzell": 2,
    "bazzle": 2,
    "bbc": 3,
    "bbc's": 3,
    "bbq": 3,
    "bbq(1)": 3,
    "be": 1,
    "be(1)": 1,
    "bea": 1,
    "beaber": 2,
    "beabout": 2,
    "beach": 1,
    "beach's": 2,
    "beacham": 2,
    "beacham(1)": 2,
    "beachball": 2,
    "beachballs": 2,
    "beachcomber": 3,
    "beachcombers": 3,
    "beached": 1,
    "beachem": 2,
    "beacher": 2,
    "beaches": 2,
    "beaches(1)": 2,
    "beachfront": 2,
    "beachfronts": 2,
    "beachhead": 2,
    "beachheads": 2,
    "beaching": 2,
    "beachler": 3,
    "beachler(1)": 2,
    "beachside": 2,
    "beachum": 2,
    "beachy": 2,
    "beacom": 2,
    "beacon": 2,
    "beacons": 2,
    "bead": 1,
    "beaded": 2,
    "beadle": 2,
    "beadles": 2,
    "beadling": 2,
    "beads": 1,
    "beadwork": 2,
    "beady": 2,
    "beagan": 2,
    "beagen": 2,
    "beagle": 2,
    "beagle's": 2,
    "beagles": 2,
    "beagley": 2,
    "beahan": 2,
    "beahm": 1,
    "beaird": 1,
    "beak": 1,
    "beaker": 2,
    "beakley": 2,
    "beaklike": 2,
    "beakman": 2,
    "beakman's": 2,
    "beal": 1,
    "beale": 1,
    "bealer": 2,
    "beales": 1,
    "bealeton": 2,
    "beall": 1,
    "beals": 1,
    "beam": 1,
    "beam's": 1,
    "beaman": 2,
    "beamed": 1,
    "beamer": 2,
    "beaming": 2,
    "beamish": 2,
    "beamon": 2,
    "beams": 1,
    "bean": 1,
    "bean's": 1,
    "beanblossom": 3,
    "beane": 1,
    "beans": 1,
    "beantown": 2,
    "bear": 1,
    "bear's": 1,
    "beara": 2,
    "bearable": 3,
    "bearably": 3,
    "bearce": 1,
    "beard": 1,
    "bearded": 2,
    "bearden": 2,
    "beardmore": 2,
    "beards": 1,
    "beardslee": 2,
    "beardsley": 2,
    "beardstown": 2,
    "beare": 1,
    "bearer": 2,
    "bearers": 2,
    "bearfield": 2,
    "bearing": 2,
    "bearings": 2,
    "bearish": 2,
    "bearishly": 3,
    "bearishness": 3,
    "bearman": 2,
    "bears": 1,
    "bears'": 1,
    "bearse": 1,
    "bearss": 1,
    "bearup": 2,
    "beary": 2,
    "beas": 1,
    "beasley": 2,
    "beason": 2,
    "beast": 1,
    "beastie": 2,
    "beastly": 2,
    "beaston": 2,
    "beasts": 1,
    "beat": 1,
    "beata": 3,
    "beaten": 2,
    "beater": 2,
    "beaters": 2,
    "beatie": 2,
    "beatified": 4,
    "beatify": 4,
    "beating": 2,
    "beatings": 2,
    "beatle": 2,
    "beatles": 2,
    "beatles'": 2,
    "beatnik": 2,
    "beatniks": 2,
    "beato": 3,
    "beaton": 2,
    "beatrice": 3,
    "beatrice(1)": 3,
    "beatrice(2)": 2,
    "beatrice(3)": 2,
    "beatrice's": 4,
    "beatrice's(1)": 3,
    "beatrix": 2,
    "beatrix(1)": 3,
    "beats": 1,
    "beatson": 2,
    "beattie": 2,
    "beatty": 2,
    "beatty(1)": 2,
    "beaty": 2,
    "beau": 1,
    "beaubien": 2,
    "beaucage": 2,
    "beauce": 1,
    "beauchaine": 2,
    "beauchamp": 2,
    "beauchemin": 3,
    "beauchene": 2,
    "beauchesne": 2,
    "beaudet": 2,
    "beaudette": 2,
    "beaudin": 2,
    "beaudoin": 2,
    "beaudreau": 2,
    "beaudry": 2,
    "beauford": 2,
    "beaufort": 2,
    "beaufrere": 2,
    "beaujolais": 3,
    "beaulac": 2,
    "beaulieu": 2,
    "beaumier": 3,
    "beaumont": 2,
    "beaupre": 2,
    "beauregard": 3,
    "beauregard(1)": 3,
    "beausoleil": 3,
    "beautician": 3,
    "beauties": 2,
    "beautiful": 3,
    "beautifullest": 4,
    "beautifullest(1)": 3,
    "beautifully": 3,
    "beautify": 3,
    "beauty": 2,
    "beauvais": 2,
    "beaux": 1,
    "beavan": 2,
    "beaven": 2,
    "beaver": 2,
    "beavers": 2,
    "beaverson": 3,
    "beaverton": 3,
    "beavin": 2,
    "beavis": 2,
    "beazer": 2,
    "beazley": 2,
    "bebb": 1,
    "bebber": 2,
    "bebbits": 2,
    "bebe": 2,
    "bebe's": 2,
    "bebear": 2,
    "bebeau": 2,
    "bebee": 2,
    "beber": 2,
    "bebitch": 2,
    "bebop": 2,
    "bebout": 2,
    "bec": 1,
    "becalm": 2,
    "becalmed": 2,
    "became": 2,
    "became(1)": 2,
    "because": 2,
    "because(1)": 2,
    "because(2)": 2,
    "because(3)": 2,
    "becca": 2,
    "becerra": 3,
    "becerril": 3,
    "bechard": 2,
    "becher": 2,
    "becherer": 3,
    "bechler": 2,
    "becht": 1,
    "bechtel": 2,
    "bechtelsville": 3,
    "bechthold": 2,
    "bechtle": 2,
    "bechtol": 2,
    "bechtold": 2,
    "beck": 1,
    "beck's": 1,
    "becka": 2,
    "beckel": 2,
    "becker": 2,
    "becker's": 2,
    "beckerman": 3,
    "beckers": 2,
    "beckert": 2,
    "becket": 2,
    "beckett": 2,
    "beckford": 2,
    "beckham": 2,
    "becki": 2,
    "beckie": 2,
    "beckius": 3,
    "beckler": 2,
    "beckles": 2,
    "beckley": 2,
    "becklund": 2,
    "beckman": 2,
    "beckmann": 2,
    "beckmeyer": 3,
    "becknell": 2,
    "beckner": 2,
    "beckom": 2,
    "beckon": 2,
    "beckoned": 2,
    "beckoning": 3,
    "beckons": 2,
    "becks": 1,
    "beckstead": 2,
    "beckstrand": 2,
    "beckstrom": 2,
    "beckum": 2,
    "beckwith": 2,
    "beckwith's": 2,
    "beckwitt": 2,
    "beckworth": 2,
    "beckworth's": 2,
    "becky": 2,
    "becnel": 2,
    "beco": 2,
    "become": 2,
    "becomes": 2,
    "becoming": 3,
    "becor": 2,
    "becor's": 2,
    "becraft": 2,
    "becton": 2,
    "becvar": 2,
    "bed": 1,
    "beda": 2,
    "bedard": 2,
    "bedbug": 2,
    "bedbugs": 2,
    "bedchamber": 3,
    "bedded": 2,
    "bedding": 2,
    "beddingfield": 3,
    "beddoe": 2,
    "beddors": 2,
    "beddow": 2,
    "bede": 1,
    "bedeck": 2,
    "bedecked": 2,
    "bedel": 2,
    "bedell": 2,
    "bedenbaugh": 3,
    "bedevil": 3,
    "bedeviled": 3,
    "bedfellow": 3,
    "bedfellows": 3,
    "bedford": 2,
    "bedgood": 2,
    "bedient": 2,
    "bedinger": 3,
    "bedingfield": 3,
    "bedke": 2,
    "bedlam": 2,
    "bedlington": 3,
    "bedminster": 3,
    "bednar": 2,
    "bednarczyk": 3,
    "bednarek": 3,
    "bednarik": 3,
    "bednarski": 3,
    "bednarz": 2,
    "bedner": 2,
    "bednorz": 2,
    "bedolla": 3,
    "bedore": 2,
    "bedouin": 3,
    "bedouin(1)": 3,
    "bedouin(2)": 3,
    "bedouins": 3,
    "bedouins(1)": 3,
    "bedouins(2)": 3,
    "bedoya": 3,
    "bedpan": 2,
    "bedpans": 2,
    "bedraggle": 3,
    "bedraggled": 3,
    "bedridden": 3,
    "bedrock": 2,
    "bedroom": 2,
    "bedrooms": 2,
    "bedrosian": 3,
    "bedrosian(1)": 4,
    "beds": 1,
    "bedsaul": 2,
    "bedside": 2,
    "bedsole": 2,
    "bedspread": 2,
    "bedstraw": 2,
    "bedtime": 2,
    "bedwell": 2,
    "bee": 1,
    "bee's": 1,
    "beeba's": 2,
    "beebe": 2,
    "beebe's": 2,
    "beebes": 2,
    "beebower": 3,
    "beebower(1)": 3,
    "beeby": 2,
    "beech": 1,
    "beecham": 2,
    "beecham's": 2,
    "beechcraft": 2,
    "beecher": 2,
    "beechler": 2,
    "beechwood": 2,
    "beechy": 2,
    "beeck": 1,
    "beecroft": 2,
    "beede": 1,
    "beedie": 2,
    "beedle": 2,
    "beedy": 2,
    "beef": 1,
    "beefeater": 3,
    "beefed": 1,
    "beeferman": 3,
    "beefing": 2,
    "beefs": 1,
    "beefsteak": 2,
    "beefy": 2,
    "beeghly": 2,
    "beegle": 2,
    "beehive": 2,
    "beehler": 2,
    "beek": 1,
    "beekeeper": 3,
    "beekeepers": 3,
    "beekeeping": 3,
    "beeker": 2,
    "beekman": 2,
    "beeks": 1,
    "beel": 1,
    "beeler": 2,
    "beem": 1,
    "beeman": 2,
    "beemer": 2,
    "been": 1,
    "been(1)": 1,
    "been(2)": 1,
    "beene": 1,
    "beeney": 2,
    "beenken": 2,
    "beens": 1,
    "beep": 1,
    "beeped": 1,
    "beeper": 2,
    "beepers": 2,
    "beeping": 2,
    "beeps": 1,
    "beer": 1,
    "beer's": 1,
    "beerbower": 3,
    "beerman": 2,
    "beers": 1,
    "beers'": 1,
    "beers's": 2,
    "beery": 2,
    "bees": 1,
    "beese": 1,
    "beesley": 2,
    "beeson": 2,
    "beet": 1,
    "beethoven": 3,
    "beethoven's": 3,
    "beethovenian": 5,
    "beetle": 2,
    "beetlejuice": 3,
    "beetles": 2,
    "beeton": 2,
    "beets": 1,
    "beever": 2,
    "beevers": 2,
    "beezley": 2,
    "befall": 2,
    "befallen": 3,
    "befalls": 2,
    "befalto": 3,
    "befell": 2,
    "beffa": 2,
    "befit": 2,
    "befits": 2,
    "befitting": 3,
    "before": 2,
    "before(1)": 2,
    "beforehand": 3,
    "befort": 2,
    "befriend": 2,
    "befriended": 3,
    "befriending": 3,
    "befriends": 2,
    "befuddle": 3,
    "befuddled": 3,
    "befuddles": 3,
    "beg": 1,
    "begajah": 3,
    "begala": 3,
    "begala's": 3,
    "began": 2,
    "began(1)": 2,
    "begat": 2,
    "begay": 2,
    "begel": 2,
    "begelman": 3,
    "begeman": 2,
    "beger": 2,
    "beget": 2,
    "begets": 2,
    "begetting": 3,
    "begg": 1,
    "beggar": 2,
    "beggars": 2,
    "begged": 1,
    "begging": 2,
    "beggs": 1,
    "beghin": 2,
    "begin": 2,
    "begin's": 2,
    "beginner": 3,
    "beginner's": 3,
    "beginners": 3,
    "beginning": 3,
    "beginnings": 3,
    "begins": 2,
    "begleiter": 3,
    "begleiter's": 3,
    "begley": 2,
    "begnaud": 2,
    "begnoche": 3,
    "begonia": 3,
    "begonias": 3,
    "begot": 2,
    "begotten": 3,
    "begrudge": 2,
    "begs": 1,
    "begue": 1,
    "beguelin": 3,
    "beguile": 2,
    "beguiled": 2,
    "beguiling": 3,
    "begun": 2,
    "begun(1)": 2,
    "behalf": 2,
    "behan": 2,
    "behar": 2,
    "behave": 2,
    "behaved": 2,
    "behaves": 2,
    "behaving": 3,
    "behavior": 3,
    "behavioral": 4,
    "behavioral(1)": 4,
    "behaviorally": 5,
    "behaviorist": 4,
    "behaviorists": 4,
    "behaviors": 3,
    "behead": 2,
    "behead(1)": 2,
    "beheaded": 3,
    "beheading": 3,
    "beheadings": 3,
    "beheler": 3,
    "behemoth": 3,
    "behemoth(1)": 3,
    "behemoths": 3,
    "behest": 2,
    "behind": 2,
    "behinds": 2,
    "behl": 1,
    "behle": 2,
    "behler": 2,
    "behling": 2,
    "behlke": 1,
    "behm": 1,
    "behmer": 2,
    "behn": 1,
    "behne": 1,
    "behner": 2,
    "behney": 2,
    "behning": 2,
    "behnke": 1,
    "behnken": 2,
    "behof": 2,
    "behoff": 2,
    "behold": 2,
    "beholden": 3,
    "beholder": 3,
    "beholding": 3,
    "behoove": 2,
    "behooves": 2,
    "behr": 1,
    "behrend": 2,
    "behrends": 2,
    "behrendt": 2,
    "behrens": 2,
    "behring": 2,
    "behringer": 3,
    "behringwerke": 3,
    "behrle": 2,
    "behrman": 2,
    "behrmann": 2,
    "behrns": 1,
    "behunin": 3,
    "behymer": 3,
    "beidaihe": 3,
    "beidleman": 3,
    "beidler": 3,
    "beidler(1)": 2,
    "beier": 2,
    "beierle": 3,
    "beiersdorf": 2,
    "beige": 1,
    "beige's": 2,
    "beigel": 2,
    "beiges": 2,
    "beighley": 2,
    "beightol": 2,
    "beijer": 1,
    "beijing": 2,
    "beijing's": 2,
    "beil": 1,
    "beilenson": 3,
    "beiler": 2,
    "beilfuss": 2,
    "beilin": 2,
    "beilin(1)": 2,
    "beilke": 1,
    "beilman": 2,
    "beim": 1,
    "bein": 1,
    "bein'": 2,
    "beine": 1,
    "being": 2,
    "being's": 2,
    "beings": 2,
    "beiny": 2,
    "beira": 2,
    "beirne": 1,
    "beirut": 2,
    "beirut's": 2,
    "beisel": 2,
    "beiser": 2,
    "beisner": 2,
    "beissel": 2,
    "beiswenger": 3,
    "beit": 1,
    "beit(1)": 1,
    "beitel": 2,
    "beiter": 2,
    "beitler": 3,
    "beitler(1)": 2,
    "beitz": 1,
    "beitzel": 2,
    "bejar": 2,
    "bejarano": 4,
    "bekaa": 2,
    "bekaa(1)": 2,
    "bekaert": 2,
    "beker": 2,
    "beker's": 2,
    "bekins": 2,
    "bekker": 2,
    "bekki": 2,
    "bel": 1,
    "bel'c": 1,
    "bela": 2,
    "belabor": 3,
    "belabored": 3,
    "belabores": 3,
    "belaboring": 4,
    "belabors": 3,
    "beladur": 3,
    "beladur's": 3,
    "belafonte": 4,
    "belair": 2,
    "belair(1)": 2,
    "belaire": 2,
    "belak": 2,
    "beland": 2,
    "belanger": 3,
    "belanoff": 3,
    "belarus": 3,
    "belasco": 3,
    "belate": 2,
    "belated": 3,
    "belatedly": 4,
    "belcastro": 3,
    "belch": 1,
    "belched": 1,
    "belcher": 2,
    "belching": 2,
    "belcourt": 2,
    "belden": 2,
    "beldin": 2,
    "belding": 2,
    "beldock": 2,
    "beldon": 2,
    "beleaguer": 3,
    "beleaguered": 3,
    "beleaguering": 4,
    "belefiville": 4,
    "belen": 2,
    "belet": 2,
    "belew": 2,
    "belfast": 2,
    "belfer": 2,
    "belfield": 2,
    "belfiore": 4,
    "belflower": 3,
    "belford": 2,
    "belfry": 2,
    "belgacom": 3,
    "belgacom(1)": 3,
    "belgard": 2,
    "belgarde": 3,
    "belge": 2,
    "belger": 2,
    "belgian": 2,
    "belgians": 2,
    "belgique": 2,
    "belgique's": 2,
    "belgium": 2,
    "belgium's": 2,
    "belgo": 2,
    "belgrade": 2,
    "belgrade(1)": 2,
    "belgrade's": 2,
    "belgrade's(1)": 2,
    "belgrave": 2,
    "beli": 2,
    "belich": 2,
    "belie": 2,
    "belied": 2,
    "belief": 2,
    "beliefs": 2,
    "belier": 2,
    "belies": 2,
    "believability": 6,
    "believable": 4,
    "believe": 2,
    "believed": 2,
    "believer": 3,
    "believers": 3,
    "believes": 2,
    "believing": 3,
    "beligerence": 4,
    "beligerent": 4,
    "belin": 2,
    "belinda": 3,
    "belinsky": 3,
    "belisle": 3,
    "belittle": 3,
    "belittled": 3,
    "belittles": 3,
    "belittling": 4,
    "belittling(1)": 3,
    "belitz": 2,
    "beliveau": 3,
    "belize": 2,
    "belk": 1,
    "belka": 2,
    "belkacem": 3,
    "belke": 1,
    "belkin": 2,
    "belknap": 2,
    "belko": 2,
    "bell": 1,
    "bell's": 1,
    "bella": 2,
    "bellah": 2,
    "bellamy": 3,
    "bellanca": 3,
    "belland": 2,
    "bellanger": 3,
    "bellante": 3,
    "bellantoni": 4,
    "bellar": 2,
    "bellard": 2,
    "bellas": 2,
    "bellavance": 3,
    "bellavia": 4,
    "bellavista": 4,
    "bellboy": 2,
    "bellcore": 2,
    "bellcore's": 2,
    "belle": 1,
    "belleau": 2,
    "bellefeuille": 4,
    "bellemare": 3,
    "beller": 2,
    "bellerose": 3,
    "belles": 1,
    "belleville": 2,
    "bellevue": 2,
    "bellew": 2,
    "bellflower": 3,
    "bellflowers": 3,
    "bellhop": 2,
    "bellhops": 2,
    "belli": 2,
    "bellicose": 3,
    "bellied": 2,
    "bellies": 2,
    "belligerence": 4,
    "belligerent": 4,
    "belligerents": 4,
    "bellin": 2,
    "bellina": 3,
    "belling": 2,
    "bellinger": 3,
    "bellingham": 3,
    "bellinghausen": 4,
    "bellini": 3,
    "bellini's": 3,
    "bellino": 3,
    "bellis": 2,
    "bellissimo": 4,
    "belliveau": 3,
    "bellizzi": 3,
    "bellm": 1,
    "bellman": 2,
    "bellmon": 2,
    "bellmore": 2,
    "bello": 2,
    "bellomo": 3,
    "bellomy": 3,
    "bellon": 2,
    "bellone": 3,
    "bellotti": 3,
    "bellow": 2,
    "bellow's": 2,
    "bellowed": 2,
    "bellowing": 3,
    "bellows": 2,
    "bellrose": 2,
    "bells": 1,
    "bells'": 1,
    "bellsouth": 2,
    "bellsouth's": 2,
    "bellucci": 3,
    "bellum": 2,
    "belluomini": 4,
    "bellville": 2,
    "bellwether": 3,
    "bellwethers": 3,
    "bellwood": 2,
    "belly": 2,
    "bellyache": 3,
    "bellyaching": 4,
    "belman": 2,
    "belmont": 2,
    "belmonte": 3,
    "belmore": 2,
    "belnap": 2,
    "belnick": 2,
    "belo": 2,
    "beloff": 2,
    "beloit": 2,
    "belong": 2,
    "belonged": 2,
    "belongia": 3,
    "belonging": 3,
    "belongings": 3,
    "belongs": 2,
    "belote": 3,
    "belous": 2,
    "belov": 2,
    "belove": 2,
    "beloved": 2,
    "beloved(1)": 3,
    "below": 2,
    "below(1)": 2,
    "bels": 1,
    "belser": 2,
    "belshaw": 2,
    "belshe": 1,
    "belsito": 3,
    "belsky": 2,
    "belson": 2,
    "belt": 1,
    "belt's": 1,
    "belted": 2,
    "belted(1)": 2,
    "belter": 2,
    "belth": 1,
    "belting": 2,
    "belton": 2,
    "beltram": 2,
    "beltran": 2,
    "belts": 1,
    "beltsville": 2,
    "beltway": 2,
    "beltz": 1,
    "belue": 2,
    "beluga": 3,
    "belushi": 3,
    "belva": 2,
    "belveal": 2,
    "belvedere": 3,
    "belvedere(1)": 3,
    "belvia": 3,
    "belvidere": 3,
    "belville": 2,
    "belvin": 2,
    "belvoir": 2,
    "bely": 2,
    "belyea": 3,
    "belyeu": 3,
    "belying": 3,
    "belz": 1,
    "belzberg": 2,
    "belzbergs": 2,
    "belzbergs'": 2,
    "belzer": 2,
    "bem": 1,
    "beman": 2,
    "bembenek": 3,
    "bembry": 2,
    "bement": 2,
    "bemidji": 3,
    "bemis": 2,
    "bemiss": 2,
    "bemoan": 2,
    "bemoaned": 2,
    "bemoaning": 3,
    "bemoans": 2,
    "bemuse": 2,
    "bemused": 2,
    "bemusement": 3,
    "ben": 1,
    "ben's": 1,
    "bena": 2,
    "benackova": 4,
    "benak": 2,
    "benami": 3,
    "benanty": 3,
    "benard": 2,
    "benassi": 3,
    "benasuli": 4,
    "benatar": 3,
    "benavente": 4,
    "benavides": 4,
    "benavidez": 4,
    "benazir": 3,
    "benbow": 2,
    "benbrook": 2,
    "bence": 1,
    "bench": 1,
    "bencher": 2,
    "benchers": 2,
    "benches": 2,
    "benchley": 2,
    "benchmark": 2,
    "benchmark's": 2,
    "benchmarks": 2,
    "bencivenga": 4,
    "bencomo": 3,
    "bencsik": 2,
    "bend": 1,
    "benda": 2,
    "bendall": 2,
    "bendectin": 3,
    "bended": 2,
    "bendel": 2,
    "bendel(1)": 2,
    "bendele": 2,
    "bender": 2,
    "bender's": 2,
    "benders": 2,
    "bendick": 2,
    "bendickson": 3,
    "bendig": 2,
    "bending": 2,
    "bendix": 2,
    "bendixen": 3,
    "bendler": 2,
    "bendorf": 2,
    "bends": 1,
    "bendt": 1,
    "bendure": 3,
    "bene": 2,
    "beneath": 2,
    "benecke": 2,
    "benedek": 3,
    "benedetti": 4,
    "benedetti's": 4,
    "benedetto": 4,
    "benedick": 3,
    "benedict": 3,
    "benedicta": 4,
    "benedictine": 4,
    "benedictine's": 4,
    "benedictines": 4,
    "benediction": 4,
    "benedikt": 3,
    "benedix": 3,
    "benefactor": 4,
    "benefactor's": 4,
    "benefactors": 4,
    "beneficence": 4,
    "beneficent": 4,
    "beneficial": 4,
    "beneficial's": 4,
    "beneficially": 5,
    "beneficiaries": 6,
    "beneficiary": 6,
    "beneficiary's": 6,
    "benefiel": 3,
    "benefield": 3,
    "benefit": 3,
    "benefited": 4,
    "benefiting": 4,
    "benefits": 3,
    "benefitted": 4,
    "benefitting": 4,
    "beneke": 2,
    "benel": 2,
    "benelux": 3,
    "benenati": 4,
    "benequity": 4,
    "benes": 2,
    "benesch": 2,
    "benesh": 2,
    "benet": 2,
    "benet(1)": 2,
    "benet's": 2,
    "benet's(1)": 2,
    "benetti": 3,
    "benetton": 3,
    "benetton(1)": 3,
    "benetton's": 3,
    "benetton's(1)": 3,
    "benevento": 4,
    "benevides": 4,
    "benevolence": 4,
    "benevolences": 5,
    "benevolent": 4,
    "benezra": 3,
    "benfer": 2,
    "benfield": 2,
    "benford": 2,
    "bengal": 2,
    "bengali": 3,
    "bengalis": 3,
    "bengals": 2,
    "benge": 1,
    "bengel": 2,
    "bengoechea": 5,
    "bengoechea(1)": 4,
    "bengston": 2,
    "bengt": 1,
    "bengtson": 2,
    "benguet": 2,
    "benham": 2,
    "benhamou": 3,
    "beni": 2,
    "benight": 2,
    "benighted": 3,
    "benighting": 3,
    "benights": 2,
    "benign": 2,
    "benigna": 3,
    "benignly": 3,
    "benigno": 3,
    "benigno(1)": 3,
    "benihana": 4,
    "benihana(1)": 4,
    "benin": 2,
    "beninati": 4,
    "benincasa": 4,
    "bening": 2,
    "benish": 2,
    "benita": 3,
    "benites": 2,
    "benitez": 3,
    "benito": 3,
    "benito(1)": 3,
    "benito(2)": 3,
    "benja": 2,
    "benjamin": 3,
    "benjamin's": 3,
    "benjimen": 3,
    "benjy": 2,
    "benke": 1,
    "benker": 2,
    "benkert": 2,
    "benko": 2,
    "benlate": 2,
    "benlox": 2,
    "benn": 1,
    "bennardo": 3,
    "benne": 1,
    "bennefield": 3,
    "benner": 2,
    "bennet": 2,
    "bennett": 2,
    "bennett(1)": 2,
    "bennett's": 2,
    "bennette": 2,
    "bennetts": 2,
    "benney": 2,
    "bennick": 2,
    "bennie": 2,
    "bennigan": 3,
    "bennigan's": 3,
    "benning": 2,
    "benninger": 3,
    "benningfield": 3,
    "benninghoff": 3,
    "bennington": 3,
    "bennink": 2,
    "bennion": 2,
    "bennis": 2,
    "bennison": 3,
    "bennitt": 2,
    "benno": 2,
    "benny": 2,
    "beno": 2,
    "benoist": 2,
    "benoit": 2,
    "benoni": 3,
    "benotti": 3,
    "benowitz": 3,
    "benoy": 2,
    "bens": 1,
    "bensalem": 3,
    "bensch": 1,
    "benscoter": 3,
    "bensel": 2,
    "bensen": 2,
    "bensenyore": 3,
    "bensenyore(1)": 4,
    "benshoof": 2,
    "bensing": 2,
    "bensinger": 3,
    "benskin": 2,
    "bensley": 2,
    "bensman": 2,
    "benson": 2,
    "benson's": 2,
    "bensonhurst": 3,
    "benstock": 2,
    "bent": 1,
    "bente": 1,
    "benten": 2,
    "benter": 2,
    "benthall": 2,
    "bentivegna": 4,
    "bentler": 2,
    "bentley": 2,
    "bentley's": 2,
    "bently": 2,
    "bento": 2,
    "benton": 2,
    "bentonite": 3,
    "bentonville": 3,
    "bentsen": 2,
    "bentsen's": 2,
    "bentson": 2,
    "bentz": 1,
    "bentzel": 2,
    "bentzen": 2,
    "benveniste": 4,
    "benvenuti": 4,
    "benvenuto": 4,
    "benware": 2,
    "benway": 2,
    "benyamin": 3,
    "benyo": 2,
    "benz": 1,
    "benz(1)": 1,
    "benz's": 2,
    "benzel": 2,
    "benzene": 2,
    "benzene(1)": 2,
    "benzes": 2,
    "benzie": 2,
    "benziger": 3,
    "benzine": 2,
    "benzing": 2,
    "benzinger": 3,
    "benzodiazepine": 6,
    "beougher": 2,
    "beowulf": 3,
    "bequeath": 2,
    "bequeathed": 2,
    "bequest": 2,
    "bequests": 2,
    "bequette": 2,
    "bera": 2,
    "beran": 2,
    "beranek": 3,
    "berard": 2,
    "berardi": 3,
    "berardinelli": 5,
    "berardino": 4,
    "berardo": 3,
    "berarducci": 4,
    "berate": 2,
    "berated": 3,
    "berating": 3,
    "berber": 2,
    "berberian": 4,
    "berberich": 3,
    "berbick": 2,
    "bercaw": 2,
    "berch": 1,
    "berchenall": 3,
    "berchtesgaden": 4,
    "berchtold": 2,
    "bercier": 3,
    "bercor": 2,
    "berdahl": 2,
    "berdan": 2,
    "berdine": 3,
    "bere": 1,
    "berea": 3,
    "bereave": 2,
    "bereaved": 2,
    "bereavement": 3,
    "bereft": 2,
    "beregovoy": 4,
    "beregovoy(1)": 4,
    "beregovoy(2)": 4,
    "berend": 2,
    "berends": 2,
    "berendt": 2,
    "berendzen": 3,
    "berens": 2,
    "berenson": 3,
    "berent": 2,
    "beres": 1,
    "beresford": 2,
    "beret": 2,
    "beret(1)": 2,
    "berets": 2,
    "berets(1)": 2,
    "beretta": 3,
    "berettas": 3,
    "berezine": 3,
    "berezine(1)": 3,
    "berg": 1,
    "berg's": 1,
    "bergamini": 4,
    "bergamo": 3,
    "bergan": 2,
    "bergdahl": 2,
    "bergdoll": 2,
    "bergdorf": 2,
    "berge": 1,
    "bergeman": 2,
    "bergemann": 2,
    "bergen": 2,
    "bergendahl": 3,
    "bergenfield": 3,
    "bergenthal": 3,
    "berger": 2,
    "berger's": 2,
    "bergerman": 3,
    "bergeron": 3,
    "bergerson": 3,
    "berges": 2,
    "bergeson": 3,
    "berget": 2,
    "bergevin": 3,
    "bergey": 2,
    "bergfeld": 2,
    "berggren": 2,
    "bergh": 1,
    "berghof": 2,
    "berghoff": 2,
    "berghuis": 3,
    "bergin": 2,
    "bergland": 2,
    "bergling": 2,
    "berglund": 2,
    "bergman": 2,
    "bergmann": 2,
    "bergner": 2,
    "bergquist": 2,
    "bergren": 2,
    "bergs": 1,
    "bergschneider": 3,
    "bergsma": 2,
    "bergstedt": 2,
    "bergstein": 2,
    "bergstein(1)": 2,
    "bergsten": 2,
    "bergstrand": 2,
    "bergstrausser": 3,
    "bergstrausser's": 3,
    "bergstresser": 3,
    "bergstrom": 2,
    "bergthold": 2,
    "bergum": 2,
    "berhow": 2,
    "beria": 3,
    "bering": 2,
    "beringer": 3,
    "berisford": 3,
    "berish": 2,
    "berjaya": 3,
    "berk": 1,
    "berka": 2,
    "berke": 1,
    "berkebile": 3,
    "berkel": 2,
    "berkeley": 2,
    "berkeley's": 2,
    "berkelman": 3,
    "berkemeier": 4,
    "berken": 2,
    "berkery": 3,
    "berkes": 1,
    "berkey": 2,
    "berkheimer": 3,
    "berkland": 2,
    "berklee": 2,
    "berkley": 2,
    "berkline": 2,
    "berkman": 2,
    "berko": 2,
    "berkoff": 2,
    "berkovitz": 3,
    "berkowitz": 3,
    "berkshire": 2,
    "berkshire(1)": 2,
    "berkshires": 2,
    "berkshires(1)": 2,
    "berkson": 2,
    "berkstresser": 3,
    "berlack": 2,
    "berland": 2,
    "berlanga": 3,
    "berlascone": 4,
    "berlascone's": 4,
    "berle": 1,
    "berle's": 1,
    "berles": 1,
    "berles'": 1,
    "berlet": 2,
    "berlet's": 2,
    "berlex": 2,
    "berlin": 2,
    "berlin's": 2,
    "berliner": 3,
    "berliner(1)": 3,
    "berliner's": 3,
    "berliner's(1)": 3,
    "berliners": 3,
    "berliners(1)": 3,
    "berling": 2,
    "berlinger": 3,
    "berlioz": 3,
    "berlitz": 2,
    "berlottes": 2,
    "berls": 1,
    "berlusconi": 4,
    "berlusconi's": 4,
    "berm": 1,
    "berman": 2,
    "berman's": 2,
    "bermans": 2,
    "bermea": 3,
    "bermel": 2,
    "berms": 1,
    "bermuda": 3,
    "bermudas": 3,
    "bermudes": 2,
    "bermudez": 3,
    "bermudez(1)": 3,
    "bern": 1,
    "berna": 2,
    "bernabe": 2,
    "bernabei": 3,
    "bernacki": 3,
    "bernadene": 3,
    "bernadette": 3,
    "bernadin": 3,
    "bernadine": 3,
    "bernadino": 4,
    "bernal": 2,
    "bernama": 3,
    "bernard": 2,
    "bernard(1)": 2,
    "bernard's": 2,
    "bernardi": 3,
    "bernardin": 3,
    "bernardini": 4,
    "bernardino": 4,
    "bernardino(1)": 4,
    "bernardo": 3,
    "bernardo's": 3,
    "bernards": 2,
    "bernardy": 3,
    "bernas": 2,
    "bernasconi": 4,
    "bernat": 2,
    "bernath": 2,
    "bernauer": 3,
    "bernay": 2,
    "bernbach": 2,
    "bernd": 1,
    "berndt": 1,
    "berne": 1,
    "berneice": 2,
    "berner": 2,
    "bernet": 2,
    "bernett": 2,
    "berney": 2,
    "bernhagen": 3,
    "bernhard": 2,
    "bernhardt": 2,
    "bernhart": 2,
    "bernheim": 2,
    "bernheimer": 3,
    "berni": 2,
    "bernia": 3,
    "bernice": 2,
    "bernick": 2,
    "bernie": 2,
    "bernie's": 2,
    "bernier": 3,
    "berning": 2,
    "berninger": 3,
    "bernita": 3,
    "bernoulli": 3,
    "berns": 1,
    "bernsen": 2,
    "bernson": 2,
    "bernstein": 2,
    "bernstein(1)": 2,
    "bernstein's": 2,
    "bernstein's(1)": 2,
    "bernsteins": 2,
    "bernsteins(1)": 2,
    "bernt": 1,
    "berntsen": 2,
    "berntson": 2,
    "berny": 2,
    "bero": 2,
    "beron": 2,
    "berquist": 2,
    "berra": 2,
    "berra's": 2,
    "berrard": 2,
    "berrard(1)": 2,
    "berres": 1,
    "berreth": 2,
    "berrett": 2,
    "berrey": 2,
    "berri": 2,
    "berrian": 3,
    "berridge": 2,
    "berrie": 2,
    "berrien": 3,
    "berrier": 3,
    "berries": 2,
    "berrigan": 3,
    "berrill": 2,
    "berringer": 3,
    "berrios": 3,
    "berris": 2,
    "berrong": 2,
    "berry": 2,
    "berry's": 2,
    "berryhill": 3,
    "berrylike": 3,
    "berryman": 3,
    "bersch": 1,
    "berserk": 2,
    "bershad": 2,
    "berson": 2,
    "berst": 1,
    "berstein": 2,
    "berstein(1)": 2,
    "bert": 1,
    "berta": 2,
    "bertch": 1,
    "berte": 1,
    "bertelli": 3,
    "bertels": 2,
    "bertelsen": 3,
    "bertelsmann": 3,
    "bertelsmann's": 3,
    "bertelson": 3,
    "berth": 1,
    "bertha": 2,
    "berthelot": 3,
    "berthelsen": 3,
    "berthiaume": 4,
    "berthold": 2,
    "bertholf": 2,
    "berths": 1,
    "berths(1)": 1,
    "berti": 2,
    "bertie": 2,
    "bertil": 2,
    "bertilde": 2,
    "bertin": 2,
    "bertini": 3,
    "bertino": 3,
    "bertinotti": 4,
    "bertke": 2,
    "bertling": 3,
    "bertling(1)": 2,
    "bertold": 2,
    "bertoldi": 3,
    "bertoli": 3,
    "bertolini": 4,
    "bertolino": 4,
    "bertolotti": 4,
    "bertolucci": 4,
    "berton": 2,
    "bertone": 3,
    "bertoni": 3,
    "bertrade": 2,
    "bertram": 2,
    "bertran": 2,
    "bertrand": 2,
    "bertsch": 1,
    "bertsche": 1,
    "bertucci": 3,
    "bertucci's": 3,
    "berty": 2,
    "bertz": 1,
    "berube": 2,
    "berudi": 3,
    "berumen": 3,
    "berwald": 2,
    "berwanger": 3,
    "berwick": 2,
    "berwyn": 2,
    "beryl": 2,
    "beryllium": 4,
    "berzin": 2,
    "berzins": 2,
    "bes": 1,
    "besancon": 3,
    "besant": 2,
    "besaw": 2,
    "besch": 1,
    "beschloss": 2,
    "beschloss'": 2,
    "beschloss's": 3,
    "besecker": 3,
    "beseech": 2,
    "beseeched": 2,
    "beseeching": 3,
    "beseiged": 2,
    "besemer": 3,
    "beset": 2,
    "besetting": 3,
    "beshara": 3,
    "besharov": 3,
    "beshears": 2,
    "beshloss": 2,
    "beshore": 2,
    "beside": 2,
    "beside(1)": 2,
    "besides": 2,
    "besides(1)": 2,
    "besiege": 2,
    "besieged": 2,
    "besieging": 3,
    "beske": 1,
    "besler": 3,
    "besler(1)": 2,
    "besner": 2,
    "besner's": 2,
    "bespeak": 2,
    "bespeaks": 2,
    "bespectacle": 4,
    "bespectacled": 4,
    "bess": 1,
    "besse": 1,
    "bessemer": 3,
    "bessent": 2,
    "besser": 2,
    "bessert": 2,
    "bessette": 2,
    "bessey": 2,
    "bessie": 2,
    "bessinger": 3,
    "bessire": 3,
    "bessler": 2,
    "besso": 2,
    "besson": 2,
    "bessy": 2,
    "best": 1,
    "best's": 1,
    "best-western": 3,
    "beste": 1,
    "bested": 2,
    "bester": 2,
    "bestial": 2,
    "bestiality": 4,
    "besting": 2,
    "bestow": 2,
    "bestowed": 2,
    "bestowing": 3,
    "bestows": 2,
    "bestrode": 2,
    "bestseller": 3,
    "bestseller(1)": 3,
    "bestsellers": 3,
    "bestsellers(1)": 3,
    "bestselling": 3,
    "bestselling(1)": 3,
    "bestul": 2,
    "bestwick": 2,
    "beswick": 2,
    "bet": 1,
    "bet's": 1,
    "beta": 2,
    "betabia": 4,
    "betabia(1)": 4,
    "betake": 2,
    "betakeren": 4,
    "betamax": 3,
    "betancourt": 3,
    "betancur": 3,
    "betar": 2,
    "betas": 2,
    "betaseron": 4,
    "betavon": 3,
    "betcha": 2,
    "betcher": 2,
    "betel": 2,
    "betelgeuse": 3,
    "beteta": 3,
    "beth": 1,
    "bethany": 3,
    "bethard": 2,
    "bethards": 2,
    "bethea": 3,
    "bethel": 2,
    "bethel(1)": 2,
    "bethell": 2,
    "bethesda": 3,
    "bethke": 1,
    "bethlehem": 3,
    "bethlehem's": 3,
    "bethpage": 2,
    "bethune": 2,
    "betide": 2,
    "betke": 2,
    "betker": 2,
    "betley": 2,
    "betray": 2,
    "betrayal": 3,
    "betrayals": 3,
    "betrayed": 2,
    "betraying": 3,
    "betrays": 2,
    "bets": 1,
    "betsch": 1,
    "betschart": 2,
    "betschart(1)": 2,
    "betsey": 2,
    "betsill": 2,
    "betsy": 2,
    "betsy's": 2,
    "bett": 1,
    "betta": 2,
    "bettcher": 2,
    "bette": 2,
    "betten": 2,
    "bettenberg": 3,
    "bettencourt": 3,
    "bettendorf": 3,
    "bettenhausen": 4,
    "better": 2,
    "bettered": 2,
    "betteridge": 3,
    "bettering": 3,
    "betterment": 3,
    "betters": 2,
    "betterton": 3,
    "bettes": 2,
    "betti": 2,
    "bettin": 2,
    "bettina": 3,
    "betting": 2,
    "bettinger": 3,
    "bettini": 3,
    "bettino": 3,
    "bettis": 2,
    "bettman": 2,
    "bettman's": 2,
    "bettner": 2,
    "betton": 2,
    "bettor": 2,
    "bettors": 2,
    "betts": 1,
    "betty": 2,
    "betty's": 2,
    "between": 2,
    "between(1)": 2,
    "betweens": 2,
    "betweens(1)": 2,
    "betwixt": 2,
    "betz": 1,
    "betzer": 2,
    "betzler": 2,
    "betzold": 2,
    "beu": 1,
    "beucler": 3,
    "beucler(1)": 2,
    "beukema": 3,
    "beula": 2,
    "beulah": 2,
    "beumer": 3,
    "beury": 2,
    "beury's": 2,
    "beutel": 2,
    "beuthin": 2,
    "beutler": 3,
    "beutler(1)": 2,
    "beuys": 2,
    "bev": 1,
    "bevacqua": 3,
    "bevalaqua": 4,
    "bevan": 2,
    "bevans": 2,
    "bevaqua": 3,
    "bevard": 2,
    "bevel": 2,
    "bevelled": 2,
    "beven": 2,
    "bevens": 2,
    "bever": 2,
    "beverage": 3,
    "beverage(1)": 2,
    "beverages": 3,
    "beveridge": 3,
    "beverley": 3,
    "beverlin": 3,
    "beverly": 3,
    "beverly's": 3,
    "bevers": 2,
    "bevier": 3,
    "bevil": 2,
    "bevilacqua": 4,
    "bevill": 2,
    "beville": 2,
    "bevin": 2,
    "bevington": 3,
    "bevins": 2,
    "bevis": 2,
    "bevmark": 2,
    "bevy": 2,
    "beware": 2,
    "bewilder": 3,
    "bewildered": 3,
    "bewildering": 4,
    "bewilderment": 4,
    "bewilders": 3,
    "bewitch": 2,
    "bewitched": 2,
    "bewley": 2,
    "bexley": 2,
    "bey": 1,
    "beyer": 2,
    "beyerle": 2,
    "beyerlein": 2,
    "beyers": 2,
    "beyersdorf": 2,
    "beyl": 1,
    "beymer": 2,
    "beynon": 2,
    "beyonce": 3,
    "beyond": 2,
    "beyond(1)": 2,
    "beyond(2)": 2,
    "beytout": 2,
    "bezaire": 2,
    "bezanson": 3,
    "bezdek": 2,
    "bezek": 2,
    "bezner": 2,
    "bezold": 2,
    "bhagwan": 2,
    "bhakta": 2,
    "bhangra": 2,
    "bharata": 3,
    "bhatia": 2,
    "bhatia(1)": 2,
    "bhatt": 1,
    "bhatt(1)": 1,
    "bhattacharjy": 4,
    "bhatti": 2,
    "bhatti(1)": 2,
    "bhiksha": 2,
    "bhiksha(1)": 2,
    "bhirud": 2,
    "bhopal": 2,
    "bhosle": 2,
    "bhutan": 2,
    "bhutan(1)": 2,
    "bhutto": 2,
    "bhutto's": 2,
    "bi": 1,
    "bi-daily": 3,
    "bi-polar": 3,
    "biaggi": 3,
    "biaggini": 4,
    "biagi": 3,
    "biagini": 4,
    "biagioni": 5,
    "bialas": 3,
    "bialecki": 4,
    "bialek": 3,
    "bialik": 3,
    "bialkin": 3,
    "bialkowski": 4,
    "bialy": 3,
    "biamby": 3,
    "biamby's": 3,
    "biamonte": 4,
    "biana": 3,
    "bianca": 3,
    "bianchi": 3,
    "bianchini": 4,
    "bianco": 3,
    "bianconi": 4,
    "bianculli": 4,
    "biannual": 4,
    "bias": 2,
    "biased": 2,
    "biases": 3,
    "biasi": 3,
    "biaxial": 4,
    "biaz": 2,
    "bib": 1,
    "biba": 2,
    "bibb": 1,
    "bibbee": 2,
    "bibbins": 2,
    "bibbo": 2,
    "bibbs": 1,
    "bibby": 2,
    "bibeau": 2,
    "bibeault": 2,
    "bibee": 2,
    "biber": 2,
    "bibi": 2,
    "bibi(1)": 2,
    "bibi's": 2,
    "bibi's(1)": 2,
    "bible": 2,
    "bible's": 2,
    "bibler": 3,
    "bibler(1)": 2,
    "bibles": 2,
    "biblical": 3,
    "biblical(1)": 3,
    "bibliographies": 5,
    "bibliography": 5,
    "bibs": 1,
    "biby": 2,
    "bic": 1,
    "bicarbonate": 4,
    "bice": 1,
    "bicentenary": 5,
    "bicentennial": 5,
    "biceps": 2,
    "bichler": 3,
    "bichler(1)": 2,
    "bichsel": 2,
    "bick": 1,
    "bickel": 2,
    "bickell": 2,
    "bicker": 2,
    "bickered": 2,
    "bickering": 3,
    "bickers": 2,
    "bickerstaff": 3,
    "bickert": 2,
    "bickerton": 3,
    "bickett": 2,
    "bickford": 2,
    "bickham": 2,
    "bickhart": 2,
    "bicking": 2,
    "bickle": 2,
    "bickler": 2,
    "bickley": 2,
    "bickmore": 2,
    "bicknell": 2,
    "bickner": 2,
    "bicksler": 2,
    "bickwit": 2,
    "bicoastal": 3,
    "bicuspid": 3,
    "bicuspids": 3,
    "bicycle": 3,
    "bicycled": 3,
    "bicycles": 3,
    "bicycling": 4,
    "bicycling(1)": 3,
    "bicyclist": 3,
    "bicyclists": 3,
    "bicyclists(1)": 3,
    "bid": 1,
    "bid's": 1,
    "bidco": 2,
    "bidcos": 2,
    "biddable": 3,
    "bidden": 2,
    "bidder": 2,
    "bidder's": 2,
    "bidders": 2,
    "biddie": 2,
    "bidding": 2,
    "biddinger": 3,
    "biddison": 3,
    "biddix": 2,
    "biddle": 2,
    "biddle's": 2,
    "biddy": 2,
    "bide": 1,
    "biden": 2,
    "biderman": 3,
    "bidgood": 2,
    "biding": 2,
    "bidinger": 3,
    "bidlack": 2,
    "bidlo": 2,
    "bidlo's": 2,
    "bids": 1,
    "bidwell": 2,
    "bidwill": 2,
    "biebel": 2,
    "bieber": 2,
    "bieda": 2,
    "biederman": 3,
    "biedermann": 3,
    "biedermeier": 3,
    "biedrzycki": 3,
    "biegel": 2,
    "biegler": 3,
    "biegler(1)": 2,
    "biehl": 1,
    "biehle": 2,
    "biehler": 2,
    "biehn": 1,
    "bieker": 2,
    "biel": 1,
    "biela": 2,
    "bielak": 2,
    "bielanski": 3,
    "bielat": 2,
    "bielawski": 3,
    "bielby": 2,
    "bielecki": 3,
    "bielecki(1)": 3,
    "bielefeld": 3,
    "bielefeldt": 3,
    "bielen": 2,
    "bielenberg": 3,
    "bieler": 2,
    "bielicki": 3,
    "bielinski": 3,
    "bielke": 1,
    "bielski": 2,
    "bien": 1,
    "bieniek": 3,
    "bienkowski": 3,
    "biennale": 3,
    "biennial": 4,
    "bienstock": 2,
    "bienvenu": 3,
    "bienvenue": 3,
    "bier": 1,
    "bierbarror": 3,
    "bierbauer": 3,
    "bierbauer's": 3,
    "bierbaum": 2,
    "bierbusse": 2,
    "bierce": 1,
    "bierer": 2,
    "bieri": 2,
    "bierlein": 2,
    "bierley": 2,
    "bierly": 2,
    "bierma": 2,
    "bierman": 2,
    "biermann": 2,
    "biernacki": 3,
    "biernat": 2,
    "biers": 1,
    "bierwirth": 2,
    "biery": 2,
    "bies": 1,
    "biesecker": 3,
    "bieser": 2,
    "bietz": 1,
    "biev": 1,
    "biev's": 1,
    "biever": 2,
    "bifano": 3,
    "biff": 1,
    "biffle": 2,
    "bifida": 3,
    "bifocal": 3,
    "bifocals": 3,
    "bifulco": 3,
    "bifurcate": 3,
    "bifurcate(1)": 3,
    "bifurcated": 4,
    "bifurcated(1)": 4,
    "bifurcation": 4,
    "bifurcation(1)": 4,
    "big": 1,
    "bigan": 2,
    "bigbee": 2,
    "bigbie": 2,
    "bigby": 2,
    "bigelow": 3,
    "bigelow's": 3,
    "bigeyes": 2,
    "bigfoot": 2,
    "bigford": 2,
    "biggar": 2,
    "bigger": 2,
    "biggers": 2,
    "biggerstaff": 3,
    "biggest": 2,
    "biggie": 2,
    "biggies": 2,
    "biggins": 2,
    "biggio": 3,
    "biggs": 1,
    "bigham": 2,
    "bighearted": 3,
    "bighorn": 2,
    "bighorns": 2,
    "bight": 1,
    "bigler": 3,
    "bigler(1)": 2,
    "bigler(2)": 2,
    "bigley": 2,
    "biglin": 2,
    "biglow": 2,
    "bignell": 2,
    "bigness": 2,
    "bigos": 2,
    "bigot": 2,
    "bigoted": 3,
    "bigotry": 3,
    "bigots": 2,
    "bigram": 2,
    "bigs": 1,
    "bigsby": 2,
    "bigtime": 2,
    "bigwig": 2,
    "bigwigs": 2,
    "bigwood": 2,
    "bihac": 2,
    "bihac's": 3,
    "bihari": 3,
    "bihari(1)": 3,
    "bihl": 1,
    "bihm": 1,
    "bihn": 1,
    "bijac": 2,
    "bijac(1)": 2,
    "bijan": 2,
    "bijeljina": 4,
    "bijur": 2,
    "bike": 1,
    "biked": 1,
    "biker": 2,
    "bikers": 2,
    "bikes": 1,
    "bikin": 2,
    "biking": 2,
    "bikini": 3,
    "bikinis": 3,
    "biko": 2,
    "biko's": 2,
    "bil": 1,
    "bila": 2,
    "bilateral": 4,
    "bilaterally": 5,
    "bilbao": 2,
    "bilbao's": 2,
    "bilbaoan": 3,
    "bilbaoans": 3,
    "bilbo": 2,
    "bilbrey": 2,
    "bilbro": 2,
    "bilby": 2,
    "bild": 1,
    "bilderback": 3,
    "bildner": 2,
    "bildt": 1,
    "bildt's": 1,
    "bile": 1,
    "bilek": 2,
    "bilello": 3,
    "biles": 1,
    "bilger": 2,
    "bilicki": 3,
    "bilings": 2,
    "bilingual": 3,
    "bilingualism": 5,
    "bilinski": 3,
    "bilious": 3,
    "bilirakis": 4,
    "bilk": 1,
    "bilka": 2,
    "bilked": 1,
    "bilking": 2,
    "bilko": 2,
    "bill": 1,
    "bill's": 1,
    "billable": 3,
    "billancourt": 3,
    "billard": 2,
    "billboard": 2,
    "billboard's": 2,
    "billboards": 2,
    "bille": 1,
    "billed": 1,
    "biller": 2,
    "billerica": 4,
    "billes": 1,
    "billet": 2,
    "billet(1)": 2,
    "billeter": 3,
    "billets": 2,
    "billett": 2,
    "billfold": 2,
    "billiad": 3,
    "billiard": 2,
    "billiards": 2,
    "billick": 2,
    "billie": 2,
    "billig": 2,
    "billing": 2,
    "billinger": 3,
    "billingham": 3,
    "billings": 2,
    "billingslea": 3,
    "billingsley": 3,
    "billingsly": 3,
    "billington": 3,
    "billion": 2,
    "billionaire": 3,
    "billionaires": 3,
    "billions": 2,
    "billionth": 2,
    "billionths": 2,
    "billiot": 3,
    "billips": 2,
    "billiter": 3,
    "billiton": 3,
    "billman": 2,
    "billmeyer": 3,
    "billon": 2,
    "billow": 2,
    "billowed": 2,
    "billowing": 3,
    "billows": 2,
    "bills": 1,
    "bills'": 1,
    "billup": 2,
    "billups": 2,
    "billy": 2,
    "billy's": 2,
    "bilodeau": 3,
    "bilotta": 3,
    "bilotti": 3,
    "bilow": 2,
    "biloxi": 3,
    "biloxi's": 3,
    "bilski": 2,
    "bilsky": 2,
    "bilson": 2,
    "biltmore": 2,
    "bilton": 2,
    "biltz": 1,
    "bily": 2,
    "bilyeu": 3,
    "bilyk": 2,
    "bilzerian": 4,
    "bilzerian's": 4,
    "bima": 2,
    "bimbo": 2,
    "bimbos": 2,
    "bimini": 3,
    "bimini(1)": 3,
    "bimiodal": 3,
    "bimonthly": 3,
    "bin": 1,
    "bina": 2,
    "binary": 3,
    "binational": 4,
    "binchy": 2,
    "bind": 1,
    "bindel": 2,
    "binder": 2,
    "binders": 2,
    "binding": 2,
    "bindle": 2,
    "bindles": 2,
    "bindley": 2,
    "binds": 1,
    "binegar": 3,
    "bines": 1,
    "binette": 2,
    "binetti": 3,
    "binfield": 2,
    "binford": 2,
    "bing": 1,
    "binga": 2,
    "bingaman": 3,
    "binge": 1,
    "binged": 1,
    "bingel": 2,
    "bingenheimer": 4,
    "binger": 2,
    "binges": 2,
    "bingham": 2,
    "binghamton": 3,
    "binging": 2,
    "bingle": 2,
    "bingley": 2,
    "bingman": 2,
    "bingo": 2,
    "binion": 2,
    "bink": 1,
    "binkley": 2,
    "binkowski": 3,
    "binn": 1,
    "binner": 2,
    "binney": 2,
    "binnie": 2,
    "binning": 2,
    "binns": 1,
    "binocular": 4,
    "binoculars": 4,
    "binomial": 4,
    "bins": 1,
    "binstock": 2,
    "bintz": 1,
    "binz": 1,
    "bio": 2,
    "bio's": 2,
    "biochem": 3,
    "biochemical": 5,
    "biochemical(1)": 5,
    "biochemist": 4,
    "biochemistry": 5,
    "biocine": 3,
    "biocontrol": 4,
    "biocraft": 3,
    "biodegradable": 6,
    "biodiverse": 4,
    "biodiversity": 6,
    "bioengineer": 5,
    "bioengineered": 5,
    "bioengineering": 6,
    "bioethics": 4,
    "biofeedback": 4,
    "bioflavonoid": 5,
    "bioflavonoids": 5,
    "biogen": 3,
    "biogen's": 3,
    "biographer": 4,
    "biographers": 4,
    "biographical": 5,
    "biographies": 4,
    "biography": 4,
    "biohazard": 4,
    "biohazards": 4,
    "biologic": 4,
    "biological": 5,
    "biologically": 5,
    "biologicals": 5,
    "biologics": 4,
    "biologist": 4,
    "biologists": 4,
    "biology": 4,
    "biology's": 4,
    "biomass": 3,
    "biomaterial": 6,
    "biomaterials": 6,
    "biome": 2,
    "biomed": 3,
    "biomed's": 3,
    "biomedical": 5,
    "biomedicals": 5,
    "biomes": 2,
    "biomet": 3,
    "biometric": 4,
    "biondi": 3,
    "biondo": 3,
    "biondolillo": 5,
    "bionetic": 4,
    "bionetics": 4,
    "biopharm": 3,
    "biopharmaceutical": 7,
    "biopharmacy": 5,
    "biophysics": 4,
    "biopsies": 3,
    "biopsy": 3,
    "bios": 2,
    "biosafety": 4,
    "bioscience": 4,
    "biosciences": 5,
    "biosensor": 4,
    "biosensors": 4,
    "biosis": 3,
    "biosis(1)": 3,
    "biosphere": 3,
    "biosphere's": 3,
    "biospheres": 3,
    "biospherian": 5,
    "biospherians": 5,
    "biosys": 3,
    "biosystem": 4,
    "biosystems": 4,
    "biotech": 3,
    "biotechnica": 5,
    "biotechnica's": 5,
    "biotechnological": 7,
    "biotechnologies": 6,
    "biotechnology": 6,
    "biotechnology's": 6,
    "biotechs": 3,
    "biotherapeutic": 6,
    "biotherapeutics": 6,
    "biotin": 3,
    "biotite": 3,
    "biovest": 3,
    "bip": 1,
    "bipartisan": 4,
    "bipartisan(1)": 4,
    "bipartisanship": 5,
    "bipartisanship(1)": 5,
    "biphenyl": 3,
    "biphenyls": 3,
    "biplane": 2,
    "bipolar": 3,
    "bippus": 2,
    "bir": 1,
    "biracial": 3,
    "birch": 1,
    "birch's": 2,
    "birchall": 2,
    "birchard": 2,
    "bircher": 2,
    "birchett": 2,
    "birchfield": 2,
    "birchler": 3,
    "birchler(1)": 2,
    "birchmeier": 3,
    "birckhead": 2,
    "bird": 1,
    "bird's": 1,
    "birdbrain": 2,
    "birdcage": 2,
    "birddog": 2,
    "birddog(1)": 2,
    "birden": 2,
    "birder": 2,
    "birders": 2,
    "birdfeather": 3,
    "birdfeather's": 3,
    "birdfeathers": 3,
    "birdfeeder": 3,
    "birdfeeder's": 3,
    "birdfeeders": 3,
    "birdfinder": 3,
    "birdhouse": 2,
    "birdhouses": 3,
    "birdie": 2,
    "birdied": 2,
    "birdies": 2,
    "birdlife": 2,
    "birdlike": 2,
    "birdman": 2,
    "birds": 1,
    "birds'": 1,
    "birdsall": 2,
    "birdseed": 2,
    "birdsell": 2,
    "birdseye": 2,
    "birdsong": 2,
    "birdwatcher": 3,
    "birdwatchers": 3,
    "birdwatching": 3,
    "birdwell": 2,
    "birdy": 2,
    "bireme": 2,
    "biremes": 2,
    "birenbaum": 3,
    "bires": 1,
    "birge": 1,
    "birinyi": 3,
    "birk": 1,
    "birkedal": 3,
    "birkel": 2,
    "birkeland": 2,
    "birkenau": 3,
    "birkes": 1,
    "birkett": 2,
    "birkey": 2,
    "birkhead": 2,
    "birkhimer": 3,
    "birkholz": 2,
    "birkland": 2,
    "birkner": 2,
    "birks": 1,
    "birky": 2,
    "birle": 1,
    "birley": 2,
    "birman": 2,
    "birmid": 2,
    "birmid's": 2,
    "birmingham": 3,
    "birnbaum": 2,
    "birney": 2,
    "birnie": 2,
    "biro": 2,
    "biron": 2,
    "biros": 2,
    "birr": 1,
    "birren": 2,
    "birt": 1,
    "birtcher": 2,
    "birth": 1,
    "birthday": 2,
    "birthdays": 2,
    "birthing": 2,
    "birthmark": 2,
    "birthmarks": 2,
    "birthplace": 2,
    "birthplaces": 3,
    "birthrate": 2,
    "birthrates": 2,
    "birthright": 2,
    "birthrights": 2,
    "births": 1,
    "birtle": 2,
    "birtley": 2,
    "birtley's": 2,
    "bis": 1,
    "bisaillon": 3,
    "bisbee": 2,
    "bisbing": 2,
    "biscardi": 3,
    "biscayne": 2,
    "bisceglia": 4,
    "bisch": 1,
    "bischel": 2,
    "bischof": 2,
    "bischofberger": 4,
    "bischoff": 2,
    "biscoe": 2,
    "biscotti": 3,
    "biscuit": 2,
    "biscuits": 2,
    "bise": 1,
    "bisek": 2,
    "bisel": 2,
    "biser": 2,
    "bisesi": 3,
    "bisexual": 4,
    "bisexuality": 6,
    "bisexuals": 4,
    "bish": 1,
    "bisher": 2,
    "bishoff": 2,
    "bishop": 2,
    "bishop's": 2,
    "bishoprics": 3,
    "bishops": 2,
    "bishops'": 2,
    "bishopsgate": 3,
    "bisiani": 4,
    "bisig": 2,
    "bisignano": 4,
    "biskup": 2,
    "bismarck": 2,
    "bismarck's": 2,
    "bismark": 2,
    "bismuth": 2,
    "bison": 2,
    "bisping": 2,
    "bisque": 1,
    "biss": 1,
    "bissell": 2,
    "bissen": 2,
    "bisset": 2,
    "bissett": 2,
    "bissette": 2,
    "bissey": 2,
    "bissinger": 3,
    "bisso": 2,
    "bisson": 2,
    "bissonette": 3,
    "bissonnette": 3,
    "bistline": 2,
    "bistodeau": 3,
    "bistro": 2,
    "bisuteki": 4,
    "bisuteki's": 4,
    "bit": 1,
    "bitar": 2,
    "bitch": 1,
    "bitches": 2,
    "bitchiness": 3,
    "bitchy": 2,
    "bite": 1,
    "biter": 2,
    "bites": 1,
    "bitesize": 2,
    "bither": 2,
    "biting": 2,
    "bitler": 3,
    "bitler(1)": 2,
    "bitner": 2,
    "bitney": 2,
    "bits": 1,
    "bitsy": 2,
    "bittel": 2,
    "bitten": 2,
    "bittenbender": 4,
    "bitter": 2,
    "bitterest": 3,
    "bitterly": 3,
    "bitterman": 3,
    "bitterman's": 3,
    "bittermann": 3,
    "bittermann's": 3,
    "bitterness": 3,
    "bitterroot": 3,
    "bitters": 2,
    "bittersweet": 3,
    "bittick": 2,
    "bitting": 2,
    "bittinger": 3,
    "bittle": 2,
    "bittman": 2,
    "bittner": 2,
    "bitton": 2,
    "bitty": 2,
    "bitumen": 3,
    "bitumen(1)": 3,
    "bituminous": 4,
    "bitz": 1,
    "bitzer": 2,
    "bivalve": 2,
    "bivalves": 2,
    "biven": 2,
    "bivens": 2,
    "biviano": 4,
    "bivin": 2,
    "bivins": 2,
    "bivona": 3,
    "bivouac": 2,
    "biweekly": 3,
    "bix": 1,
    "bixby": 2,
    "bixel": 2,
    "bixler": 2,
    "biz": 1,
    "bizango": 3,
    "bizarre": 2,
    "bizarre(1)": 2,
    "bizet": 2,
    "bizmart": 2,
    "bizub": 2,
    "bizzaro": 3,
    "bizzell": 2,
    "bizzy": 2,
    "bjelasnica": 4,
    "bjelland": 2,
    "bjerke": 1,
    "bjoern": 1,
    "bjorge": 1,
    "bjork": 1,
    "bjorklund": 2,
    "bjorkman": 2,
    "bjorn": 1,
    "bjornstad": 2,
    "blachly": 2,
    "blachly(1)": 2,
    "black": 1,
    "black's": 1,
    "blackard": 2,
    "blackball": 2,
    "blackberries": 3,
    "blackberry": 3,
    "blackbird": 2,
    "blackbirds": 2,
    "blackboard": 2,
    "blackboards": 2,
    "blackburn": 2,
    "blacked": 1,
    "blacken": 2,
    "blackened": 2,
    "blackening": 3,
    "blackening(1)": 2,
    "blackens": 2,
    "blacker": 2,
    "blackerby": 3,
    "blackest": 2,
    "blacketer": 3,
    "blackett": 2,
    "blackfoot": 2,
    "blackford": 2,
    "blackham": 2,
    "blackhawk": 2,
    "blackhawk's": 2,
    "blackhawks": 2,
    "blackheath": 2,
    "blackhurst": 2,
    "blackie": 2,
    "blackjack": 2,
    "blackledge": 2,
    "blackley": 2,
    "blacklist": 2,
    "blacklisted": 3,
    "blacklisting": 3,
    "blacklock": 2,
    "blackmail": 2,
    "blackmailed": 2,
    "blackmailing": 3,
    "blackman": 2,
    "blackmer": 2,
    "blackmon": 2,
    "blackmore": 2,
    "blackmun": 2,
    "blackmun's": 2,
    "blackness": 2,
    "blackout": 2,
    "blackouts": 2,
    "blackpool": 2,
    "blackrock": 2,
    "blacks": 1,
    "blacks'": 1,
    "blacksburg": 2,
    "blackshear": 2,
    "blacksher": 2,
    "blackshire": 2,
    "blacksmith": 2,
    "blackson": 2,
    "blackstock": 2,
    "blackston": 2,
    "blackstone": 2,
    "blackstone's": 2,
    "blacktop": 2,
    "blackwelder": 3,
    "blackwell": 2,
    "blackwood": 2,
    "bladder": 2,
    "bladders": 2,
    "blade": 1,
    "bladed": 2,
    "bladen": 2,
    "blades": 1,
    "blading": 2,
    "bladow": 2,
    "blaese": 1,
    "blaesing": 2,
    "blagden": 2,
    "blagg": 1,
    "blah": 1,
    "blaha": 2,
    "blahnik": 2,
    "blahut": 2,
    "blaich": 1,
    "blaikie": 2,
    "blain": 1,
    "blaine": 1,
    "blair": 1,
    "blair's": 1,
    "blais": 1,
    "blaisdell": 2,
    "blaise": 1,
    "blaiser": 2,
    "blaize": 1,
    "blake": 1,
    "blake's": 1,
    "blakeley": 2,
    "blakeley's": 2,
    "blakely": 2,
    "blakely's": 2,
    "blakeman": 2,
    "blakemore": 2,
    "blakeney": 2,
    "blakeney's": 2,
    "blakenham": 3,
    "blakenship": 3,
    "blaker": 2,
    "blakes": 1,
    "blakeslee": 2,
    "blakesley": 2,
    "blakey": 2,
    "blakley": 2,
    "blakney": 2,
    "blalack": 2,
    "blalock": 2,
    "blame": 1,
    "blamed": 1,
    "blameless": 2,
    "blames": 1,
    "blaming": 2,
    "blampied": 2,
    "blan": 1,
    "blanc": 1,
    "blanca": 2,
    "blancett": 2,
    "blanch": 1,
    "blanchard": 2,
    "blanchard's": 2,
    "blanchards": 2,
    "blanche": 1,
    "blanchet": 2,
    "blanchett": 2,
    "blanchette": 2,
    "blanchfield": 2,
    "blanck": 1,
    "blanco": 2,
    "bland": 1,
    "blanda": 2,
    "blander": 2,
    "blandford": 2,
    "blandin": 2,
    "blanding": 2,
    "blandino": 3,
    "blandishment": 3,
    "blandishments": 3,
    "blandly": 2,
    "blandness": 2,
    "blando": 2,
    "blandon": 2,
    "blane": 1,
    "blaney": 2,
    "blanford": 2,
    "blank": 1,
    "blanke": 1,
    "blanked": 1,
    "blanken": 2,
    "blankenbaker": 4,
    "blankenbeckler": 4,
    "blankenburg": 3,
    "blankenhorn": 3,
    "blankenship": 3,
    "blanket": 2,
    "blanket(1)": 2,
    "blanketed": 3,
    "blanketing": 3,
    "blankets": 2,
    "blanking": 2,
    "blankinship": 3,
    "blankley": 2,
    "blankly": 2,
    "blankly's": 2,
    "blanks": 1,
    "blann": 1,
    "blanquita": 3,
    "blansett": 2,
    "blanton": 2,
    "blare": 1,
    "blared": 1,
    "blares": 1,
    "blaring": 2,
    "blas": 1,
    "blaschke": 1,
    "blasco": 2,
    "blasdel": 2,
    "blasdell": 2,
    "blase": 1,
    "blaser": 2,
    "blasi": 2,
    "blasia": 3,
    "blasier": 3,
    "blasier(1)": 2,
    "blasier's": 3,
    "blasier's(1)": 2,
    "blasing": 2,
    "blasingame": 4,
    "blasini": 3,
    "blasius": 3,
    "blaske": 1,
    "blasko": 2,
    "blasphemous": 3,
    "blasphemy": 3,
    "blass": 1,
    "blassie": 2,
    "blassie's": 2,
    "blassingame": 4,
    "blast": 1,
    "blastdown": 2,
    "blasted": 2,
    "blasted(1)": 2,
    "blaster": 2,
    "blastfurnace": 3,
    "blasting": 2,
    "blastoderm": 3,
    "blastoff": 2,
    "blastoma": 3,
    "blasts": 1,
    "blaszak": 2,
    "blaszczyk": 2,
    "blatant": 2,
    "blatantly": 3,
    "blatchford": 2,
    "blatchley": 2,
    "blather": 2,
    "blatnik": 2,
    "blatt": 1,
    "blatter": 2,
    "blattner": 2,
    "blatz": 1,
    "blau": 1,
    "blauch": 1,
    "blauer": 1,
    "blaum": 1,
    "blauser": 2,
    "blaustein": 2,
    "blaustein(1)": 2,
    "blauvelt": 2,
    "blay": 1,
    "blaydes": 1,
    "blaydon": 2,
    "blaylock": 2,
    "blayne": 1,
    "blayney": 2,
    "blayze": 1,
    "blaze": 1,
    "blazed": 1,
    "blazejewski": 4,
    "blazek": 2,
    "blazer": 2,
    "blazers": 2,
    "blazes": 2,
    "blazier": 3,
    "blazina": 3,
    "blazing": 2,
    "blea": 1,
    "bleach": 1,
    "bleached": 1,
    "bleacher": 2,
    "bleachers": 2,
    "bleaching": 2,
    "bleak": 1,
    "bleaker": 2,
    "bleakest": 2,
    "bleakley": 2,
    "bleakness": 2,
    "bleakney": 2,
    "bleam": 1,
    "bleary": 2,
    "bleau": 1,
    "blech": 1,
    "blech's": 1,
    "blecha": 2,
    "blecher": 2,
    "blechley": 2,
    "blechman": 2,
    "bleck": 1,
    "blecker": 2,
    "bled": 1,
    "bledsoe": 2,
    "bleecker": 2,
    "bleed": 1,
    "bleeding": 2,
    "bleeds": 1,
    "bleeker": 2,
    "bleep": 1,
    "bleeping": 2,
    "blegen": 2,
    "blehm": 1,
    "bleich": 1,
    "bleicher": 2,
    "bleier": 2,
    "bleil": 1,
    "bleiler": 2,
    "bleilers": 2,
    "blelloch": 2,
    "blemish": 2,
    "blemished": 2,
    "blemishes": 3,
    "blend": 1,
    "blenda": 2,
    "blendax": 2,
    "blended": 2,
    "blended(1)": 2,
    "blender": 2,
    "blenders": 2,
    "blending": 2,
    "blends": 1,
    "blenheim": 2,
    "blepharisma": 4,
    "bleser": 2,
    "bless": 1,
    "blessed": 1,
    "blessedly": 3,
    "blessedness": 3,
    "blesses": 2,
    "blessing": 2,
    "blessinger": 3,
    "blessings": 2,
    "blessington": 3,
    "blest": 1,
    "blethen": 2,
    "bleu": 1,
    "blevens": 2,
    "blevins": 2,
    "blew": 1,
    "blewett": 2,
    "blewitt": 2,
    "bley": 1,
    "blick": 1,
    "blickenstaff": 3,
    "blida": 2,
    "bligh": 1,
    "blight": 1,
    "blighted": 2,
    "bliley": 2,
    "blimp": 1,
    "blimps": 1,
    "blincoe": 2,
    "blind": 1,
    "blinded": 2,
    "blinder": 2,
    "blinder's": 2,
    "blinders": 2,
    "blindfold": 2,
    "blindfolded": 3,
    "blinding": 2,
    "blindly": 2,
    "blindness": 2,
    "blinds": 1,
    "blindside": 2,
    "blindsided": 3,
    "blink": 1,
    "blinked": 1,
    "blinking": 2,
    "blinks": 1,
    "blinn": 1,
    "blip": 1,
    "blips": 1,
    "bliscoll": 2,
    "blish": 1,
    "bliss": 1,
    "bliss'": 1,
    "blissett": 2,
    "blissful": 2,
    "blissfully": 3,
    "blister": 2,
    "blistered": 2,
    "blistering": 3,
    "blisters": 2,
    "blitch": 1,
    "blithe": 1,
    "blithely": 2,
    "blitstein": 2,
    "blitstein(1)": 2,
    "blitz": 1,
    "blitzed": 1,
    "blitzen": 2,
    "blitzer": 2,
    "blitzer's": 2,
    "blitzes": 2,
    "blitzkrieg": 2,
    "bliven": 2,
    "blixt": 1,
    "blizard": 2,
    "blizzard": 2,
    "blizzards": 2,
    "bloat": 1,
    "bloated": 2,
    "bloatedness": 3,
    "bloating": 2,
    "bloats": 1,
    "blob": 1,
    "blobby": 2,
    "blobs": 1,
    "bloc": 1,
    "bloc's": 1,
    "bloch": 1,
    "bloch's": 1,
    "blocher": 2,
    "block": 1,
    "block's": 1,
    "blockade": 2,
    "blockaded": 3,
    "blockader": 3,
    "blockaders": 3,
    "blockades": 2,
    "blockading": 3,
    "blockage": 2,
    "blockages": 3,
    "blockbuster": 3,
    "blockbuster's": 3,
    "blockbusters": 3,
    "blocked": 1,
    "blocker": 2,
    "blockers": 2,
    "blockhead": 2,
    "blockheads": 2,
    "blockhouse": 2,
    "blockhouses": 3,
    "blocking": 2,
    "blocks": 1,
    "blocs": 1,
    "blodgett": 2,
    "bloedel": 2,
    "bloedorn": 2,
    "bloem": 1,
    "bloemer": 2,
    "bloemker": 2,
    "blog": 1,
    "blogger": 2,
    "blogging": 2,
    "blogosphere": 3,
    "blohm": 1,
    "blok": 1,
    "bloke": 1,
    "blokes": 1,
    "blom": 1,
    "blomberg": 2,
    "blome": 1,
    "blomgren": 2,
    "blomquist": 2,
    "blomstrom": 2,
    "blond": 1,
    "blonde": 1,
    "blonde's": 1,
    "blondell": 2,
    "blonder": 2,
    "blondes": 1,
    "blondest": 2,
    "blondie": 2,
    "blondin": 2,
    "blonds": 1,
    "blood": 1,
    "blood's": 1,
    "bloodbath": 2,
    "blooded": 2,
    "bloodgood": 2,
    "bloodhound": 2,
    "bloodhounds": 2,
    "bloodhounds(1)": 2,
    "bloodied": 2,
    "bloodier": 3,
    "bloodiest": 3,
    "bloodless": 2,
    "bloodletting": 3,
    "bloodline": 2,
    "bloodlines": 2,
    "bloods": 1,
    "bloodshed": 2,
    "bloodstain": 2,
    "bloodstained": 2,
    "bloodstains": 2,
    "bloodstone": 2,
    "bloodstream": 2,
    "bloodsucker": 3,
    "bloodsuckers": 3,
    "bloodsucking": 3,
    "bloodsworth": 2,
    "bloodthirsty": 3,
    "bloodworth": 2,
    "bloody": 2,
    "bloom": 1,
    "bloom's": 1,
    "bloomberg": 2,
    "bloomberg's": 2,
    "bloomed": 1,
    "bloomer": 2,
    "bloomers": 2,
    "bloomfield": 2,
    "blooming": 2,
    "bloomingdale": 3,
    "bloomingdale's": 3,
    "bloomingdales": 3,
    "bloomington": 3,
    "bloomquist": 2,
    "blooms": 1,
    "blooper": 2,
    "bloopers": 2,
    "bloor": 1,
    "blose": 1,
    "bloss": 1,
    "blosser": 2,
    "blossom": 2,
    "blossomed": 2,
    "blossoming": 3,
    "blossoms": 2,
    "blot": 1,
    "blotch": 1,
    "blotched": 1,
    "blotches": 2,
    "blotchier": 3,
    "blotchiest": 3,
    "blotching": 2,
    "blotchy": 2,
    "blotnick": 2,
    "blots": 1,
    "blotted": 2,
    "blotter": 2,
    "blotting": 2,
    "blouch": 1,
    "blough": 1,
    "blouin": 1,
    "blount": 1,
    "blouse": 1,
    "blouses": 2,
    "blouses(1)": 2,
    "blow": 1,
    "blowdried": 2,
    "blowdries": 2,
    "blowdry": 2,
    "blowdryer": 3,
    "blowdryers": 3,
    "blowdrying": 3,
    "blowe": 1,
    "blowed": 1,
    "blower": 2,
    "blowers": 2,
    "blowfish": 2,
    "blowgun": 2,
    "blowguns": 2,
    "blowhard": 2,
    "blowhards": 2,
    "blowhole": 2,
    "blowholes": 2,
    "blowier": 3,
    "blowiest": 3,
    "blowing": 2,
    "blown": 1,
    "blowout": 2,
    "blowouts": 2,
    "blowpipe": 2,
    "blowpipes": 2,
    "blows": 1,
    "blowtorch": 2,
    "blowtorches": 3,
    "blowup": 2,
    "blowy": 2,
    "bloxham": 2,
    "bloxom": 2,
    "bloxsom": 2,
    "bloyd": 1,
    "bloyer": 2,
    "blubaugh": 2,
    "blubber": 2,
    "bludgeon": 2,
    "bludgeoned": 2,
    "bludgeoning": 3,
    "blue": 1,
    "blue's": 1,
    "bluebeard": 2,
    "bluebell": 2,
    "bluebells": 2,
    "blueberries": 3,
    "blueberry": 3,
    "bluebird": 2,
    "bluebirds": 2,
    "blueblood": 2,
    "blueblooded": 3,
    "bluebloods": 2,
    "bluebonnet": 3,
    "bluebonnets": 3,
    "bluebottle": 3,
    "bluebottles": 3,
    "bluechip": 2,
    "bluecollar": 3,
    "blued": 1,
    "blueeyed": 2,
    "bluefield": 2,
    "bluegrass": 2,
    "blueing": 2,
    "blueish": 2,
    "bluejay": 2,
    "bluejeans": 2,
    "bluelaw": 2,
    "bluemel": 2,
    "blueness": 2,
    "bluepencil": 3,
    "bluepencilled": 3,
    "bluepencilling": 4,
    "bluepencils": 3,
    "blueprint": 2,
    "blueprints": 2,
    "bluer": 2,
    "blues": 1,
    "blues'": 1,
    "bluest": 2,
    "bluestein": 2,
    "bluestein(1)": 2,
    "bluestine": 2,
    "bluestone": 2,
    "bluesy": 2,
    "bluesy(1)": 3,
    "bluetooth": 2,
    "bluett": 1,
    "bluey": 2,
    "bluff": 1,
    "bluffed": 1,
    "bluffer": 2,
    "bluffing": 2,
    "bluffs": 1,
    "bluford": 2,
    "bluhdorn": 2,
    "bluhm": 1,
    "bluing": 2,
    "bluish": 2,
    "bluitt": 1,
    "blum": 1,
    "blumberg": 2,
    "blume": 1,
    "blumenberg": 3,
    "blumenfeld": 3,
    "blumenschein": 3,
    "blumenshine": 3,
    "blumenstein": 3,
    "blumenstein(1)": 3,
    "blumenstock": 3,
    "blumenthal": 3,
    "blumer": 2,
    "blumquist": 2,
    "blumstein": 2,
    "blumstein(1)": 2,
    "blunck": 1,
    "blundall": 2,
    "blundell": 2,
    "blunder": 2,
    "blundered": 2,
    "blundering": 3,
    "blunders": 2,
    "blunk": 1,
    "blunt": 1,
    "blunted": 2,
    "blunted(1)": 2,
    "blunter": 2,
    "bluntest": 2,
    "blunting": 2,
    "bluntly": 2,
    "bluntness": 2,
    "blunts": 1,
    "blur": 1,
    "blurb": 1,
    "blurbs": 1,
    "blurred": 1,
    "blurring": 2,
    "blurry": 2,
    "blurs": 1,
    "blurt": 1,
    "blurted": 2,
    "blurton": 2,
    "blurts": 1,
    "blush": 1,
    "blushed": 1,
    "blushes": 2,
    "blushes(1)": 2,
    "blushing": 2,
    "blust": 1,
    "bluster": 2,
    "blustering": 3,
    "blustery": 3,
    "bluth": 1,
    "blvd": 3,
    "bly": 1,
    "blye": 1,
    "blyler": 2,
    "blystone": 2,
    "blyth": 1,
    "blythe": 1,
    "bo": 1,
    "bo-shek": 2,
    "boa": 2,
    "boak": 1,
    "boake": 1,
    "boal": 1,
    "boals": 1,
    "boan": 1,
    "boar": 1,
    "board": 1,
    "board's": 1,
    "boarda": 2,
    "boardbent": 2,
    "boarded": 2,
    "boarded(1)": 2,
    "boarder": 2,
    "boarders": 2,
    "boardgame": 2,
    "boardgames": 2,
    "boarding": 2,
    "boardinghouse": 3,
    "boardinghouses": 4,
    "boardingpass": 3,
    "boardingpasses": 4,
    "boardings": 2,
    "boardman": 2,
    "boardroom": 2,
    "boardrooms": 2,
    "boards": 1,
    "boardwalk": 2,
    "boardwalks": 2,
    "boarman": 2,
    "boart": 1,
    "boas": 2,
    "boase": 1,
    "boast": 1,
    "boasted": 2,
    "boasted(1)": 2,
    "boastful": 2,
    "boasting": 2,
    "boasts": 1,
    "boat": 1,
    "boat's": 1,
    "boated": 2,
    "boaters": 2,
    "boathouse": 2,
    "boating": 2,
    "boatlift": 2,
    "boatlift's": 2,
    "boatlifts": 2,
    "boatload": 2,
    "boatloads": 2,
    "boatman": 2,
    "boatmen's": 2,
    "boatner": 2,
    "boatright": 2,
    "boats": 1,
    "boatswain": 2,
    "boatwright": 2,
    "boatyard": 2,
    "boaz": 2,
    "bob": 1,
    "bob's": 1,
    "boback": 2,
    "bobadilla": 4,
    "bobak": 2,
    "bobb": 1,
    "bobber": 2,
    "bobbett": 2,
    "bobbette": 2,
    "bobbi": 2,
    "bobbie": 2,
    "bobbin": 2,
    "bobbing": 2,
    "bobbinger": 3,
    "bobbinger's": 3,
    "bobbitt": 2,
    "bobbitt's": 2,
    "bobbitts": 2,
    "bobble": 2,
    "bobbled": 2,
    "bobbles": 2,
    "bobbling": 2,
    "bobbo": 2,
    "bobby": 2,
    "bobby's": 2,
    "bobcat": 2,
    "bobcats": 2,
    "bobe": 1,
    "bobeck": 2,
    "bobek": 2,
    "bober": 2,
    "boberg": 2,
    "bobick": 2,
    "bobier": 3,
    "bobinski": 3,
    "boblitt": 2,
    "bobo": 2,
    "bobolas": 3,
    "bobrow": 2,
    "bobrowski": 3,
    "bobsled": 2,
    "bobst": 1,
    "bobzien": 2,
    "boca": 2,
    "bocanegra": 4,
    "bocce": 2,
    "bocce(1)": 2,
    "bocchino": 3,
    "boccia": 2,
    "boccio": 3,
    "boccuzzi": 3,
    "bocek": 2,
    "boch": 1,
    "bocharov": 3,
    "bochco": 2,
    "boche": 1,
    "bochenek": 3,
    "boches": 2,
    "bochicchio": 4,
    "bochner": 2,
    "bochram": 2,
    "bocian": 2,
    "bock": 1,
    "bockelman": 3,
    "bockius": 3,
    "bockman": 2,
    "bockus": 2,
    "bocock": 2,
    "bocook": 2,
    "bocuse": 2,
    "boda": 2,
    "bodamer": 3,
    "bodanis": 3,
    "bodden": 2,
    "boddie": 2,
    "boddington": 3,
    "boddy": 2,
    "bode": 1,
    "bodega": 3,
    "bodegas": 3,
    "bodeguita": 4,
    "bodeguita(1)": 4,
    "bodell": 2,
    "boden": 2,
    "bodenhamer": 4,
    "bodenhamer(1)": 4,
    "bodenheimer": 4,
    "bodenstein": 3,
    "bodenstein(1)": 3,
    "bodensteiner": 4,
    "bodes": 1,
    "bodey": 2,
    "bodhisattvas": 4,
    "bodi": 2,
    "bodice": 2,
    "bodices": 3,
    "bodie": 2,
    "bodied": 2,
    "bodies": 2,
    "bodikova": 4,
    "bodily": 3,
    "bodin": 2,
    "bodine": 3,
    "bodkin": 2,
    "bodkins": 2,
    "bodle": 2,
    "bodley": 2,
    "bodman": 2,
    "bodmer": 2,
    "bodnar": 2,
    "bodner": 2,
    "bodo": 2,
    "bodwell": 2,
    "body": 2,
    "body's": 2,
    "bodyguard": 3,
    "bodyguards": 3,
    "bodziak": 3,
    "bodziak's": 3,
    "boe": 1,
    "boeck": 1,
    "boeckel": 2,
    "boecker": 2,
    "boeckman": 2,
    "boeckmann": 2,
    "boedecker": 3,
    "boedeker": 3,
    "boeder": 2,
    "boeding": 2,
    "boege": 1,
    "boeger": 2,
    "boeh": 1,
    "boehl": 1,
    "boehle": 2,
    "boehler": 2,
    "boehlert": 2,
    "boehlke": 1,
    "boehm": 1,
    "boehm(1)": 1,
    "boehme": 1,
    "boehme(1)": 1,
    "boehmer": 2,
    "boehmke": 2,
    "boehne": 1,
    "boehner": 2,
    "boehning": 2,
    "boehnke": 1,
    "boehnlein": 2,
    "boehringer": 3,
    "boeing": 2,
    "boeing's": 2,
    "boeke": 1,
    "boeker": 2,
    "boelens": 2,
    "boelkow": 2,
    "boelman": 2,
    "boelter": 2,
    "boen": 1,
    "boenig": 2,
    "boening": 3,
    "boepple": 2,
    "boer": 1,
    "boerger": 2,
    "boerman": 2,
    "boerner": 2,
    "boers": 1,
    "boersma": 2,
    "boes": 1,
    "boesak": 2,
    "boesch": 1,
    "boeschenstein": 3,
    "boeschenstein(1)": 3,
    "boese": 1,
    "boesel": 2,
    "boesen": 2,
    "boesky": 2,
    "boesky's": 2,
    "boeskys": 2,
    "boetcher": 2,
    "boettcher": 2,
    "boettger": 2,
    "boettner": 2,
    "boeve": 1,
    "boff": 1,
    "boffa": 2,
    "boffo": 2,
    "bofors": 2,
    "bofors's": 3,
    "bog": 1,
    "bog(1)": 1,
    "bogacki": 3,
    "bogacz": 2,
    "bogan": 2,
    "bogar": 2,
    "bogard": 2,
    "bogardus": 3,
    "bogart": 2,
    "bogdan": 2,
    "bogdanoff": 3,
    "bogdanowicz": 4,
    "bogdanski": 3,
    "bogden": 2,
    "bogdon": 2,
    "boge": 1,
    "bogelsong": 3,
    "bogen": 2,
    "bogenschutz": 3,
    "boger": 2,
    "bogert": 2,
    "bogey": 2,
    "bogeyed": 2,
    "bogeyman": 3,
    "bogeyman(1)": 3,
    "bogeymen": 3,
    "bogeymen(1)": 3,
    "boggan": 2,
    "bogged": 1,
    "bogged(1)": 1,
    "boggess": 2,
    "bogging": 2,
    "boggio": 3,
    "boggle": 2,
    "boggled": 2,
    "boggles": 2,
    "boggling": 3,
    "boggling(1)": 2,
    "boggs": 1,
    "boggus": 2,
    "boghosian": 3,
    "bogie": 2,
    "bogin": 2,
    "bogle": 2,
    "bognar": 2,
    "bogner": 2,
    "bogor": 2,
    "bogosian": 3,
    "bogota": 3,
    "bogs": 1,
    "bogs(1)": 1,
    "bogucki": 3,
    "bogue": 1,
    "bogus": 2,
    "boguslavskaya": 5,
    "bogusz": 2,
    "bohac": 2,
    "bohall": 2,
    "bohan": 2,
    "bohanan": 3,
    "bohannan": 3,
    "bohannon": 3,
    "bohanon": 3,
    "bohart": 2,
    "boheme": 3,
    "bohemia": 4,
    "bohemian": 4,
    "bohen": 2,
    "bohl": 1,
    "bohland": 2,
    "bohlander": 3,
    "bohle": 2,
    "bohlen": 2,
    "bohler": 2,
    "bohlin": 2,
    "bohling": 2,
    "bohlinger": 3,
    "bohlke": 1,
    "bohlke(1)": 1,
    "bohlken": 2,
    "bohlman": 2,
    "bohlmann": 2,
    "bohm": 1,
    "bohman": 2,
    "bohmer": 2,
    "bohn": 1,
    "bohne": 1,
    "bohnen": 2,
    "bohnenkamp": 3,
    "bohner": 2,
    "bohnert": 2,
    "bohnet": 2,
    "bohnhoff": 2,
    "bohning": 2,
    "bohnsack": 2,
    "bohon": 2,
    "bohr": 1,
    "bohren": 2,
    "bohrer": 2,
    "boice": 1,
    "boies": 1,
    "boik": 1,
    "boike": 1,
    "boil": 1,
    "boilard": 2,
    "boileau": 2,
    "boiled": 1,
    "boiler": 2,
    "boilermaker": 4,
    "boilerplate": 3,
    "boilerplates": 3,
    "boilers": 2,
    "boiling": 2,
    "boils": 1,
    "boink": 1,
    "boipatong": 3,
    "bois": 1,
    "boisclair": 2,
    "boise": 2,
    "boise(1)": 2,
    "boise's": 2,
    "boise's(1)": 2,
    "boisen": 2,
    "boisi": 2,
    "boisjoly": 3,
    "boisseau": 2,
    "boissonneault": 3,
    "boisterous": 3,
    "boisterous(1)": 2,
    "boisvert": 2,
    "boitano": 3,
    "boitnott": 2,
    "boivin": 2,
    "bojangles'": 3,
    "bojanowski": 4,
    "bojarski": 3,
    "bojenka": 3,
    "bojorquez": 3,
    "bok": 1,
    "bokassa": 3,
    "boker": 2,
    "bokor": 2,
    "boksen": 2,
    "bol": 1,
    "bola": 2,
    "bolam": 2,
    "bolan": 2,
    "bolancik": 3,
    "boland": 2,
    "bolander": 3,
    "bolanger": 3,
    "bolanos": 3,
    "bolar": 2,
    "bolar's": 2,
    "bolch": 1,
    "bolcom": 2,
    "bold": 1,
    "bolda": 2,
    "bolden": 2,
    "bolder": 2,
    "boldest": 2,
    "boldface": 2,
    "boldin": 2,
    "bolding": 2,
    "boldly": 2,
    "boldman": 2,
    "boldness": 2,
    "boldon": 2,
    "bolds": 1,
    "boldt": 1,
    "bolduc": 2,
    "bolduc's": 2,
    "bole": 1,
    "bolek": 2,
    "bolen": 2,
    "bolenbaugh": 3,
    "bolender": 3,
    "boler": 2,
    "bolerjack": 3,
    "bolero": 3,
    "boles": 1,
    "boleware": 2,
    "boley": 2,
    "boleyn": 2,
    "bolf": 1,
    "bolger": 2,
    "bolger's": 2,
    "bolich": 2,
    "bolick": 2,
    "boliden": 3,
    "bolin": 2,
    "boline": 2,
    "boling": 2,
    "bolinger": 3,
    "bolio": 3,
    "bolitho": 3,
    "bolivar": 3,
    "bolivars": 3,
    "bolivia": 4,
    "bolivia(1)": 4,
    "bolivia's": 4,
    "bolivian": 4,
    "bolivian(1)": 4,
    "bolivians": 4,
    "bolivians(1)": 4,
    "bolker": 2,
    "bolkow": 2,
    "boll": 1,
    "bolla": 2,
    "bolland": 2,
    "bollapragada": 5,
    "bollard": 2,
    "bolle": 1,
    "bollen": 2,
    "bollenbach": 3,
    "bollenbacher": 4,
    "boller": 2,
    "bolles": 1,
    "bollettieri": 5,
    "bollier": 3,
    "bollig": 2,
    "bolliger": 3,
    "bollin": 2,
    "bolling": 2,
    "bollinger": 3,
    "bollman": 2,
    "bollmann": 2,
    "bollore": 2,
    "bolls": 1,
    "bollywood": 3,
    "bologna": 3,
    "bolognese": 4,
    "bolognesi": 4,
    "bolon": 2,
    "bolotin": 3,
    "bolsa": 2,
    "bolsa's": 2,
    "bolser": 2,
    "bolshevik": 3,
    "bolsheviks": 3,
    "bolshevism": 4,
    "bolshevist": 3,
    "bolshoi": 2,
    "bolshoi's": 2,
    "bolson": 2,
    "bolstad": 2,
    "bolster": 2,
    "bolstered": 2,
    "bolstering": 3,
    "bolsters": 2,
    "bolt": 1,
    "bolte": 1,
    "bolted": 2,
    "bolted(1)": 2,
    "bolten": 2,
    "bolter": 2,
    "bolthouse": 2,
    "bolting": 2,
    "bolton": 2,
    "bolts": 1,
    "boltz": 1,
    "boltzmann's": 2,
    "boltzmanns": 2,
    "bolus": 2,
    "bolyard": 2,
    "bolz": 1,
    "bom": 1,
    "bomag": 2,
    "boman": 2,
    "bomar": 2,
    "bomb": 1,
    "bomb(1)": 1,
    "bomb's": 1,
    "bomba": 2,
    "bombard": 2,
    "bombarded": 3,
    "bombardier": 3,
    "bombardiers": 3,
    "bombarding": 3,
    "bombardment": 3,
    "bombardments": 3,
    "bombast": 2,
    "bombastic": 3,
    "bombay": 2,
    "bombay's": 2,
    "bombeck": 2,
    "bombed": 1,
    "bomber": 2,
    "bomber's": 2,
    "bomberg": 2,
    "bomberger": 3,
    "bombers": 2,
    "bombing": 2,
    "bombings": 2,
    "bombmaker": 3,
    "bombmaking": 3,
    "bombs": 1,
    "bombshell": 2,
    "bombshells": 2,
    "bomer": 2,
    "bomgardner": 3,
    "bommarito": 4,
    "bommer": 2,
    "bon": 1,
    "bona": 2,
    "bonacci": 3,
    "bonadio": 4,
    "bonadonna": 4,
    "bonaduce": 4,
    "bonaduce(1)": 3,
    "bonafide": 3,
    "bonafide(1)": 3,
    "bonanni": 3,
    "bonanno": 3,
    "bonanza": 3,
    "bonaparte": 3,
    "bonaparte's": 3,
    "bonar": 2,
    "bonasera": 4,
    "bonaventura": 5,
    "bonaventure": 4,
    "bonavia": 4,
    "bonavita": 4,
    "bonawitz": 3,
    "bonczek": 2,
    "bond": 1,
    "bond's": 1,
    "bondage": 2,
    "bondar": 2,
    "bonde": 1,
    "bonded": 2,
    "bonded(1)": 2,
    "bonderman": 3,
    "bondholder": 3,
    "bondholders": 3,
    "bondholders'": 3,
    "bondi": 2,
    "bonding": 2,
    "bondra": 2,
    "bonds": 1,
    "bonds'": 1,
    "bondt": 1,
    "bondurant": 3,
    "bondy": 2,
    "bone": 1,
    "bonebrake": 2,
    "bonecrusher": 3,
    "bonecutter": 3,
    "boned": 1,
    "boneless": 2,
    "bonelli": 3,
    "bonello": 3,
    "bonenberger": 4,
    "bonenfant": 2,
    "boner": 2,
    "bones": 1,
    "bonesteel": 2,
    "bonet": 1,
    "bonetti": 3,
    "boney": 2,
    "bonfanti": 3,
    "bonfield": 2,
    "bonfiglio": 4,
    "bonfire": 3,
    "bonfires": 3,
    "bong": 1,
    "bongard": 2,
    "bongarten": 3,
    "bongers": 2,
    "bongiorno": 3,
    "bongiovanni": 4,
    "bongjin": 2,
    "bongo": 2,
    "bongos": 2,
    "bonham": 2,
    "boni": 2,
    "bonica": 3,
    "bonier": 2,
    "bonifacio": 5,
    "bonifas": 3,
    "bonifay": 3,
    "bonifield": 3,
    "bonilla": 3,
    "bonin": 2,
    "bonine": 3,
    "boning": 2,
    "bonini": 3,
    "bonino": 3,
    "bonior": 3,
    "bonior(1)": 2,
    "bonita": 3,
    "bonito": 3,
    "bonjour": 2,
    "bonk": 1,
    "bonker": 2,
    "bonkers": 2,
    "bonkowski": 3,
    "bonn": 1,
    "bonn's": 1,
    "bonne": 1,
    "bonneau": 2,
    "bonnell": 2,
    "bonnema": 3,
    "bonner": 2,
    "bonnes": 1,
    "bonnet": 2,
    "bonnett": 2,
    "bonnette": 2,
    "bonneville": 3,
    "bonnevilles": 3,
    "bonney": 2,
    "bonnibel": 3,
    "bonnibelle": 3,
    "bonnie": 2,
    "bonnie's": 2,
    "bonnin": 2,
    "bonnor": 2,
    "bonny": 2,
    "bono": 2,
    "bono's": 2,
    "bonobo": 3,
    "bonobo(1)": 3,
    "bonobos": 3,
    "bonobos(1)": 3,
    "bonomo": 3,
    "bonsai": 2,
    "bonsall": 2,
    "bonser": 2,
    "bonsignore": 4,
    "bonta": 2,
    "bonte": 1,
    "bontempo": 3,
    "bontrager": 3,
    "bonum": 2,
    "bonura": 3,
    "bonus": 2,
    "bonuses": 3,
    "bonvillain": 3,
    "bonville": 2,
    "bonwell": 2,
    "bonwit": 2,
    "bonwit's": 2,
    "bony": 2,
    "bonzo": 2,
    "boo": 1,
    "boob": 1,
    "boobs": 1,
    "booby": 2,
    "boock": 1,
    "boodle": 2,
    "boodles": 2,
    "boody": 2,
    "booe": 2,
    "booed": 1,
    "booee": 2,
    "boogie": 2,
    "boogie(1)": 2,
    "boogie-woogie": 4,
    "boogie-woogie(1)": 4,
    "booher": 2,
    "booing": 2,
    "book": 1,
    "book's": 1,
    "bookbinder": 3,
    "bookbinders": 3,
    "bookcase": 2,
    "bookcases": 3,
    "bookcellar": 3,
    "bookcellars": 3,
    "booked": 1,
    "bookend": 2,
    "bookends": 2,
    "booker": 2,
    "booker's": 2,
    "bookers": 2,
    "bookie": 2,
    "bookies": 2,
    "bookin": 2,
    "booking": 2,
    "bookings": 2,
    "bookish": 2,
    "bookkeeper": 3,
    "bookkeepers": 3,
    "bookkeeping": 3,
    "booklet": 2,
    "booklets": 2,
    "bookmaker": 3,
    "bookmakers": 3,
    "bookmaking": 3,
    "bookman": 2,
    "bookmark": 2,
    "bookmarks": 2,
    "bookmobile": 3,
    "bookmobiles": 3,
    "booknote": 2,
    "booknotes": 2,
    "bookout": 2,
    "books": 1,
    "books'": 1,
    "bookseller": 3,
    "booksellers": 3,
    "bookshelf": 2,
    "bookshelves": 2,
    "bookshop": 2,
    "bookshops": 2,
    "booksmith": 2,
    "bookstand": 2,
    "bookstands": 2,
    "bookstop": 2,
    "bookstops": 2,
    "bookstore": 2,
    "bookstores": 2,
    "bookwalter": 3,
    "bookworm": 2,
    "boole": 1,
    "boolean": 3,
    "boom": 1,
    "boom's": 1,
    "boombox": 2,
    "boomboxes": 3,
    "boomed": 1,
    "boomer": 2,
    "boomerang": 3,
    "boomeranged": 3,
    "boomers": 2,
    "boomers'": 2,
    "boomershine": 3,
    "boomhower": 3,
    "booming": 2,
    "boomlet": 2,
    "booms": 1,
    "boomsma": 2,
    "boomtown": 2,
    "boon": 1,
    "boondocks": 2,
    "boondoggle": 3,
    "boondoggles": 3,
    "boone": 1,
    "boons": 1,
    "boonstra": 2,
    "boonton": 2,
    "boonville": 2,
    "boop": 1,
    "boor": 1,
    "booras": 2,
    "boord": 1,
    "boorda": 2,
    "boorda's": 2,
    "boorish": 2,
    "boorishness": 3,
    "boorman": 2,
    "boors": 1,
    "boorstin": 2,
    "boortz": 1,
    "boos": 1,
    "boose": 1,
    "boost": 1,
    "boosted": 2,
    "booster": 2,
    "booster's": 2,
    "boosterism": 4,
    "boosters": 2,
    "boosting": 2,
    "boosts": 1,
    "boot": 1,
    "boote": 1,
    "booted": 2,
    "booten": 2,
    "booth": 1,
    "boothby": 2,
    "boothe": 1,
    "boothman": 2,
    "boothroyd": 2,
    "booths": 1,
    "bootie": 2,
    "booties": 2,
    "booting": 2,
    "bootleg": 2,
    "bootlegger": 3,
    "bootleggers": 3,
    "bootlegging": 3,
    "bootlegs": 2,
    "booton": 2,
    "boots": 1,
    "bootstrap": 2,
    "bootstraps": 2,
    "booty": 2,
    "bootz": 1,
    "booz": 1,
    "booze": 1,
    "boozer": 2,
    "boozier": 3,
    "boozing": 2,
    "boozy": 2,
    "bop": 1,
    "bopeep": 2,
    "bopera": 3,
    "bopha": 2,
    "bophuthatswana": 5,
    "bopp": 1,
    "bopper": 2,
    "boppers": 2,
    "boquist": 2,
    "bora": 2,
    "borah": 2,
    "borak": 2,
    "boral": 2,
    "borawski": 3,
    "borax": 2,
    "borba": 2,
    "borchard": 2,
    "borchardt": 2,
    "borchelt": 2,
    "borcherding": 3,
    "borchers": 2,
    "borchert": 2,
    "borck": 1,
    "borda": 2,
    "borda's": 2,
    "bordallo": 3,
    "bordas": 2,
    "bordeau": 2,
    "bordeaux": 2,
    "bordello": 3,
    "bordelon": 3,
    "borden": 2,
    "borden's": 2,
    "bordenave": 3,
    "bordenave(1)": 3,
    "border": 2,
    "border's": 2,
    "bordered": 2,
    "bordering": 3,
    "borderline": 3,
    "borders": 2,
    "bordes": 1,
    "bordman": 2,
    "bordner": 2,
    "bordonaro": 4,
    "bordwell": 2,
    "bore": 1,
    "borealis": 4,
    "bored": 1,
    "boredom": 2,
    "borek": 2,
    "borel": 2,
    "borell": 2,
    "borella": 3,
    "borelli": 3,
    "borello": 3,
    "boren": 2,
    "boren's": 2,
    "borenstein": 3,
    "borenstein(1)": 3,
    "borer": 2,
    "bores": 1,
    "borg": 1,
    "borge": 1,
    "borgelt": 2,
    "borgen": 2,
    "borger": 2,
    "borgerding": 3,
    "borgert": 2,
    "borges": 2,
    "borgeson": 3,
    "borgess": 2,
    "borghi": 2,
    "borgia": 2,
    "borgman": 2,
    "borgmann": 2,
    "borgmeyer": 3,
    "borgstrom": 2,
    "borgwardt": 2,
    "boric": 2,
    "borin": 2,
    "boring": 2,
    "boris": 2,
    "boris'": 2,
    "boris's": 3,
    "borja": 2,
    "borjas": 2,
    "bork": 1,
    "bork's": 1,
    "borkenhagen": 4,
    "borkenhagen(1)": 4,
    "borkowski": 3,
    "borland": 2,
    "borland's": 2,
    "borman": 2,
    "borman's": 2,
    "bormann": 2,
    "born": 1,
    "born's": 1,
    "borne": 1,
    "borneman": 2,
    "bornemann": 2,
    "borneo": 3,
    "borner": 2,
    "bornholdt": 2,
    "bornhorst": 2,
    "bornman": 2,
    "borns": 1,
    "bornstein": 2,
    "bornstein(1)": 2,
    "borntrager": 3,
    "boro": 2,
    "borocce": 3,
    "boroff": 2,
    "boroian": 3,
    "boron": 2,
    "boros": 2,
    "borosage": 3,
    "boroski": 3,
    "borough": 2,
    "borough's": 2,
    "boroughs": 2,
    "borowiak": 4,
    "borowicz": 3,
    "borowiec": 3,
    "borowski": 3,
    "borowsky": 3,
    "borowy": 3,
    "borquez": 2,
    "borras": 2,
    "borre": 1,
    "borrego": 3,
    "borrell": 2,
    "borrelli": 3,
    "borrello": 3,
    "borrero": 3,
    "borris": 2,
    "borroff": 2,
    "borror": 2,
    "borrow": 2,
    "borrowed": 2,
    "borrower": 3,
    "borrower's": 3,
    "borrowers": 3,
    "borrowers'": 3,
    "borrowing": 3,
    "borrowings": 3,
    "borrowman": 3,
    "borrows": 2,
    "borruso": 3,
    "bors": 1,
    "borsch": 1,
    "borscht": 1,
    "borse": 1,
    "borseth": 2,
    "borski": 2,
    "borst": 1,
    "borsuk": 2,
    "bort": 1,
    "bortel": 2,
    "borten": 2,
    "borth": 1,
    "borthwick": 2,
    "bortle": 2,
    "bortner": 2,
    "bortnick": 2,
    "borton": 2,
    "bortz": 1,
    "boruch": 2,
    "borucki": 3,
    "boruff": 2,
    "borum": 2,
    "borunda": 3,
    "borup": 2,
    "borys": 2,
    "bos": 1,
    "bosak": 2,
    "bosarge": 2,
    "boscarino": 4,
    "bosch": 1,
    "boschee": 2,
    "boschen": 2,
    "boschert": 2,
    "boschwitz": 2,
    "boscia": 2,
    "bosco": 2,
    "bose": 1,
    "boseman": 2,
    "bosendorfer": 4,
    "boser": 2,
    "bosh": 1,
    "boshart": 2,
    "boshears": 2,
    "boshell": 2,
    "bosher": 2,
    "boshers": 2,
    "boskin": 2,
    "bosko": 2,
    "boskovich": 3,
    "boslego": 3,
    "bosler": 3,
    "bosler(1)": 2,
    "bosley": 2,
    "bosma": 2,
    "bosman": 2,
    "bosnia": 3,
    "bosnia's": 3,
    "bosnian": 3,
    "bosnian's": 3,
    "bosnians": 3,
    "bosnias": 3,
    "boso": 2,
    "bosom": 2,
    "bosqi": 2,
    "bosquez": 2,
    "boss": 1,
    "boss(1)": 1,
    "boss'": 1,
    "boss's": 2,
    "bossard": 2,
    "bossart": 2,
    "bosse": 1,
    "bossed": 1,
    "bossen": 2,
    "bosserman": 3,
    "bossert": 2,
    "bosses": 2,
    "bosses'": 2,
    "bosshardt": 2,
    "bosshart": 2,
    "bossi": 2,
    "bossidy": 3,
    "bossie": 2,
    "bossier": 3,
    "bossler": 3,
    "bossler(1)": 2,
    "bossman": 2,
    "bosso": 2,
    "bossy": 2,
    "bost": 1,
    "bostelman": 3,
    "boster": 2,
    "bostian": 2,
    "bostic": 2,
    "bostick": 2,
    "bostock": 2,
    "boston": 2,
    "boston(1)": 2,
    "boston's": 2,
    "bostonian": 4,
    "bostonians": 4,
    "bostra": 2,
    "bostrom": 2,
    "bostwick": 2,
    "boswell": 2,
    "bosworth": 2,
    "botanic": 3,
    "botanical": 4,
    "botanically": 5,
    "botanically(1)": 4,
    "botanist": 3,
    "botanists": 3,
    "botany": 3,
    "botch": 1,
    "botched": 1,
    "boteler": 3,
    "botelho": 3,
    "botello": 3,
    "botero": 3,
    "botfly": 2,
    "both": 1,
    "botha": 2,
    "botha(1)": 2,
    "botha(2)": 2,
    "botha's": 2,
    "botha's(1)": 2,
    "botha's(2)": 2,
    "botham": 2,
    "botham's": 2,
    "bothe": 1,
    "bothell": 2,
    "bother": 2,
    "bothered": 2,
    "bothering": 3,
    "bothers": 2,
    "bothersome": 3,
    "bothun": 2,
    "bothwell": 2,
    "botin": 2,
    "botkin": 2,
    "botkins": 2,
    "botner": 2,
    "botolf": 2,
    "boton": 2,
    "botos": 2,
    "botox": 2,
    "botrytis": 3,
    "botsford": 2,
    "botshabelo": 4,
    "botswana": 3,
    "bott": 1,
    "botta": 2,
    "bottari": 3,
    "bottcher": 2,
    "bottecelli": 4,
    "bottel": 2,
    "botten": 2,
    "bottenfield": 3,
    "bottger": 2,
    "botting": 2,
    "bottini": 3,
    "bottino": 3,
    "bottle": 2,
    "bottled": 2,
    "bottleneck": 3,
    "bottlenecks": 3,
    "bottler": 2,
    "bottlers": 2,
    "bottlers'": 2,
    "bottles": 2,
    "bottling": 3,
    "bottling(1)": 2,
    "bottom": 2,
    "bottom's": 2,
    "bottomed": 2,
    "bottomfish": 3,
    "bottoming": 3,
    "bottomless": 3,
    "bottomley": 3,
    "bottoms": 2,
    "bottone": 3,
    "bottorf": 2,
    "bottorff": 2,
    "bottrell": 2,
    "botts": 1,
    "botulism": 4,
    "botz": 1,
    "bouch": 1,
    "bouchard": 2,
    "bouche": 1,
    "boucher": 2,
    "boucher(1)": 2,
    "boucher(2)": 2,
    "bouchey": 2,
    "bouchie": 2,
    "bouchillon": 3,
    "bouck": 1,
    "boudin": 2,
    "boudoin": 2,
    "boudoir": 2,
    "boudreau": 2,
    "boudreaux": 2,
    "bouffard": 2,
    "bougainville": 3,
    "bougainvillea": 5,
    "bough": 1,
    "boughan": 2,
    "bougher": 2,
    "boughman": 2,
    "boughner": 2,
    "boughs": 1,
    "bought": 1,
    "bought(1)": 1,
    "boughten": 2,
    "boughter": 2,
    "boughton": 2,
    "bougie": 2,
    "bouie": 2,
    "bouillabaise": 3,
    "bouillon": 3,
    "bouknight": 2,
    "boulais": 2,
    "boulalas": 3,
    "boulanger": 3,
    "boulangerie": 4,
    "boulay": 2,
    "boulden": 2,
    "boulder": 2,
    "boulders": 2,
    "boule": 1,
    "bouler": 2,
    "boulet": 2,
    "boulette": 2,
    "boulevard": 3,
    "boulevards": 3,
    "bouley": 2,
    "boulez": 2,
    "boulier": 3,
    "boullion": 2,
    "boulos": 2,
    "boulter": 2,
    "boultinghouse": 3,
    "boulton": 2,
    "boulware": 2,
    "bouma": 2,
    "bouman": 2,
    "bounce": 1,
    "bounced": 1,
    "bouncer": 2,
    "bouncers": 2,
    "bounces": 2,
    "bounciness": 3,
    "bouncing": 2,
    "bouncy": 2,
    "bound": 1,
    "boundaries": 3,
    "boundaries(1)": 2,
    "boundary": 3,
    "boundary(1)": 2,
    "bounded": 2,
    "bounded(1)": 2,
    "bounder": 2,
    "bounding": 2,
    "boundless": 2,
    "bounds": 1,
    "boundy": 2,
    "bounties": 2,
    "bountiful": 3,
    "bountiful(1)": 3,
    "bounty": 2,
    "bouquet": 2,
    "bouquets": 2,
    "bouquets(1)": 2,
    "bour": 1,
    "bourassa": 3,
    "bourbeau": 2,
    "bourbon": 2,
    "bourbons": 2,
    "bourcier": 3,
    "bourdeau": 2,
    "bourg": 1,
    "bourgault": 2,
    "bourgeois": 2,
    "bourgeois(1)": 2,
    "bourgeoisie": 3,
    "bourget": 2,
    "bourgoin": 2,
    "bourguiba": 3,
    "bourguignon": 3,
    "bourke": 1,
    "bourland": 2,
    "bourn": 1,
    "bourne": 1,
    "bournewood": 2,
    "bournias": 3,
    "bournonville": 3,
    "bourque": 1,
    "bourquin": 2,
    "bourret": 2,
    "bourse": 1,
    "bourse's": 2,
    "bourses": 2,
    "boursicot": 3,
    "boursicot(1)": 3,
    "bouse": 1,
    "bouska": 2,
    "bousman": 2,
    "bousquet": 2,
    "boussac": 2,
    "boustany": 3,
    "bout": 1,
    "boutell": 2,
    "boutelle": 2,
    "bouthillier": 4,
    "boutilier": 4,
    "boutin": 2,
    "boutique": 2,
    "boutiques": 2,
    "bouton": 2,
    "boutros": 2,
    "bouts": 1,
    "boutte": 1,
    "boutwell": 2,
    "bouvier": 3,
    "bouwens": 2,
    "bouwkamp": 2,
    "bouwman": 2,
    "bouwsma": 2,
    "bouyer": 2,
    "bouygues": 2,
    "bouygues(1)": 2,
    "bouza": 2,
    "bova": 2,
    "bovard": 2,
    "bove": 1,
    "bovee": 2,
    "boven": 2,
    "bovenzi": 3,
    "boveri": 3,
    "bovespa": 2,
    "bovey": 2,
    "bovik": 2,
    "bovin": 2,
    "bovina": 3,
    "bovine": 2,
    "bovino": 3,
    "bow": 1,
    "bow(1)": 1,
    "bowar": 2,
    "boward": 2,
    "bowater": 3,
    "bowater(1)": 3,
    "bowater(2)": 3,
    "bowcan": 2,
    "bowden": 2,
    "bowden(1)": 2,
    "bowdish": 2,
    "bowditch": 2,
    "bowdle": 2,
    "bowdoin": 2,
    "bowe": 1,
    "bowed": 1,
    "bowed(1)": 1,
    "bowel": 2,
    "bowell": 2,
    "bowels": 2,
    "bowels(1)": 1,
    "bowen": 2,
    "bowens": 2,
    "bower": 2,
    "bowerman": 3,
    "bowermaster": 4,
    "bowers": 2,
    "bowersock": 3,
    "bowersox": 3,
    "bowery": 3,
    "bowery's": 3,
    "bowes": 1,
    "bowick": 2,
    "bowie": 2,
    "bowing": 2,
    "bowing(1)": 2,
    "bowker": 2,
    "bowl": 1,
    "bowland": 2,
    "bowlby": 2,
    "bowlds": 1,
    "bowled": 1,
    "bowlen": 2,
    "bowler": 2,
    "bowlers": 2,
    "bowles": 1,
    "bowley": 2,
    "bowlin": 2,
    "bowline": 2,
    "bowling": 2,
    "bowling's": 2,
    "bowls": 1,
    "bowlus": 2,
    "bowman": 2,
    "bowman's": 2,
    "bowmen": 2,
    "bowmer": 2,
    "bown": 1,
    "bownds": 1,
    "bowne": 1,
    "bowring": 2,
    "bowron": 2,
    "bowron(1)": 2,
    "bows": 1,
    "bows(1)": 1,
    "bowse": 1,
    "bowsed": 1,
    "bowser": 2,
    "bowses": 2,
    "bowsher": 2,
    "bowsing": 2,
    "bowyer": 2,
    "box": 1,
    "boxberger": 3,
    "boxcar": 2,
    "boxcars": 2,
    "boxed": 1,
    "boxell": 2,
    "boxer": 2,
    "boxer's": 2,
    "boxers": 2,
    "boxes": 2,
    "boxes(1)": 2,
    "boxing": 2,
    "boxing's": 2,
    "boxley": 2,
    "boxwell": 2,
    "boxwood": 2,
    "boxx": 1,
    "boxy": 2,
    "boy": 1,
    "boy's": 1,
    "boy-ar-dee": 3,
    "boy-scout": 2,
    "boyack": 2,
    "boyajian": 4,
    "boyan": 2,
    "boyar": 2,
    "boyce": 1,
    "boycott": 2,
    "boycotted": 3,
    "boycotting": 3,
    "boycotts": 2,
    "boyd": 1,
    "boyd's": 1,
    "boyde": 1,
    "boyden": 2,
    "boydston": 2,
    "boydstun": 2,
    "boye": 1,
    "boyea": 3,
    "boyer": 2,
    "boyers": 2,
    "boyertown": 3,
    "boyes": 1,
    "boyett": 2,
    "boyette": 2,
    "boyfriend": 2,
    "boyfriends": 2,
    "boyfriends(1)": 2,
    "boyhood": 2,
    "boyington": 3,
    "boyish": 2,
    "boykin": 2,
    "boykins": 2,
    "boyko": 2,
    "boylan": 2,
    "boyland": 2,
    "boyle": 1,
    "boylen": 2,
    "boyles": 1,
    "boyleston": 2,
    "boyleston's": 2,
    "boylls": 1,
    "boylston": 2,
    "boylston's": 2,
    "boyne": 1,
    "boynton": 2,
    "boys": 1,
    "boys'": 1,
    "boysel": 2,
    "boysen": 2,
    "boyson": 2,
    "boyt": 1,
    "boyte": 1,
    "boyter": 2,
    "boyum": 2,
    "boyz": 1,
    "boza": 2,
    "bozard": 2,
    "bozarth": 2,
    "boze": 1,
    "bozek": 2,
    "bozell": 2,
    "bozell's": 2,
    "bozeman": 2,
    "bozian": 3,
    "bozic": 2,
    "bozich": 2,
    "bozman": 2,
    "bozo": 2,
    "bozos": 2,
    "boztepe": 2,
    "boztepe(1)": 2,
    "boztepe(2)": 3,
    "boztepe(3)": 3,
    "bozza": 2,
    "bozzi": 2,
    "bozzo": 2,
    "bra": 1,
    "braaksma": 2,
    "braasch": 1,
    "braaten": 3,
    "braatz": 1,
    "brabant": 2,
    "brabec": 2,
    "brabender": 3,
    "brabham": 2,
    "brabson": 2,
    "brac": 1,
    "bracamonte": 4,
    "bracamonte's": 4,
    "bracamontes": 4,
    "bracci": 2,
    "bracco": 2,
    "brace": 1,
    "brace's": 2,
    "braced": 1,
    "bracelet": 2,
    "bracelets": 2,
    "bracer": 2,
    "bracero": 3,
    "braces": 2,
    "braces(1)": 2,
    "bracewell": 2,
    "bracey": 2,
    "brach": 1,
    "bracher": 2,
    "bracher's": 2,
    "brachfeld": 2,
    "brachia": 3,
    "brachia(1)": 3,
    "brachii": 3,
    "brachii(1)": 3,
    "brachiopod": 4,
    "brachiopods": 4,
    "bracht": 1,
    "bracing": 2,
    "bracingly": 3,
    "brack": 1,
    "brackbill": 2,
    "brackeen": 2,
    "bracken": 2,
    "brackenbury": 4,
    "brackens": 2,
    "bracker": 2,
    "bracket": 2,
    "brackets": 2,
    "brackets(1)": 2,
    "brackett": 2,
    "brackin": 2,
    "brackins": 2,
    "brackish": 2,
    "brackman": 2,
    "bracknell": 2,
    "brackney": 2,
    "bracy": 2,
    "brad": 1,
    "brad's": 1,
    "bradberry": 3,
    "bradburn": 2,
    "bradbury": 3,
    "bradco": 2,
    "braddock": 2,
    "braddy": 2,
    "bradeen": 2,
    "brademas": 3,
    "braden": 2,
    "bradenton": 3,
    "brader": 2,
    "bradfield": 2,
    "bradford": 2,
    "bradford's": 2,
    "bradfords": 2,
    "bradham": 2,
    "bradish": 2,
    "bradlee": 2,
    "bradlees": 2,
    "bradley": 2,
    "bradley's": 2,
    "bradleys": 2,
    "bradner": 2,
    "bradney": 2,
    "bradshaw": 2,
    "bradsher": 2,
    "bradstreet": 2,
    "bradstreet's": 2,
    "bradt": 1,
    "bradtke": 2,
    "bradtmiller": 3,
    "bradway": 2,
    "bradwell": 2,
    "brady": 2,
    "brady's": 2,
    "bradycardia": 5,
    "bradycardia(1)": 5,
    "bradykinin": 4,
    "bradys": 2,
    "brae": 1,
    "braendstroem": 2,
    "braer": 1,
    "braff": 1,
    "brafford": 2,
    "brag": 1,
    "braga": 2,
    "bragan": 2,
    "braganza": 3,
    "braganza(1)": 3,
    "bragdon": 2,
    "brager": 2,
    "bragg": 1,
    "braggadocio": 5,
    "bragged": 1,
    "bragger": 2,
    "braggers": 2,
    "bragging": 2,
    "braggiotti": 4,
    "braggs": 1,
    "brags": 1,
    "braham": 2,
    "brahm": 1,
    "brahmin": 2,
    "brahms": 1,
    "brahms's": 2,
    "braid": 1,
    "braided": 2,
    "braiding": 2,
    "braids": 1,
    "braidwood": 2,
    "brailey": 2,
    "braille": 1,
    "brailles": 1,
    "brailsford": 2,
    "brain": 1,
    "brain's": 1,
    "brainard": 2,
    "brainchild": 2,
    "braindead": 2,
    "brained": 1,
    "brainer": 2,
    "brainerd": 2,
    "brainless": 2,
    "brainpower": 3,
    "brains": 1,
    "brainstorm": 2,
    "brainstormed": 2,
    "brainstorming": 3,
    "brainstorms": 2,
    "braintree": 2,
    "brainwash": 2,
    "brainwashed": 2,
    "brainwashes": 3,
    "brainwashing": 3,
    "brainy": 2,
    "braise": 1,
    "braised": 1,
    "braithwaite": 2,
    "brajdas": 2,
    "brajovic": 3,
    "brake": 1,
    "brakebill": 2,
    "braked": 1,
    "brakefield": 2,
    "brakeman": 2,
    "brakemen": 2,
    "braker": 2,
    "brakes": 1,
    "braking": 2,
    "brakke": 1,
    "braley": 2,
    "bralley": 2,
    "brallier": 3,
    "bralorne": 2,
    "braly": 2,
    "bram": 1,
    "bramah": 2,
    "bramalea": 4,
    "bramalea's": 3,
    "braman": 2,
    "brambila": 3,
    "bramble": 2,
    "brambles": 2,
    "bramblett": 2,
    "brame": 1,
    "bramel": 2,
    "bramer": 2,
    "bramhall": 2,
    "bramlage": 2,
    "bramlet": 2,
    "bramlett": 2,
    "bramlette": 2,
    "bramley": 2,
    "brammeier": 3,
    "brammer": 2,
    "brampton": 2,
    "brams": 1,
    "bramson": 2,
    "bramwell": 2,
    "bran": 1,
    "branagan": 3,
    "branagh": 2,
    "branam": 2,
    "branaman": 3,
    "branan": 2,
    "branca": 2,
    "brancaccio": 4,
    "brancato": 3,
    "branch": 1,
    "branch's": 2,
    "branche": 1,
    "brancheau": 2,
    "branched": 1,
    "branches": 2,
    "branches(1)": 2,
    "branching": 2,
    "branchlet": 2,
    "branchlets": 2,
    "branco": 2,
    "brand": 1,
    "brand's": 1,
    "branda": 2,
    "brandau": 2,
    "brande": 1,
    "brandeberry": 3,
    "branded": 2,
    "brandeis": 2,
    "brandel": 2,
    "branden": 2,
    "brandenberg": 3,
    "brandenberger": 4,
    "brandenburg": 3,
    "brandenburger": 4,
    "brandenstein": 3,
    "brandenstein(1)": 3,
    "brander": 2,
    "brandes": 1,
    "brandford": 2,
    "brandhorst": 2,
    "brandi": 2,
    "branding": 2,
    "brandis": 2,
    "brandish": 2,
    "brandished": 2,
    "brandishes": 3,
    "brandishing": 3,
    "brandl": 2,
    "brandle": 2,
    "brandname": 2,
    "brandner": 2,
    "brando": 2,
    "brando's": 2,
    "brandon": 2,
    "brandon's": 2,
    "brandow": 2,
    "brands": 1,
    "brands'": 1,
    "brands's": 2,
    "brandstetter": 3,
    "brandt": 1,
    "brandtner": 2,
    "brandvold": 2,
    "brandwein": 2,
    "brandy": 2,
    "brandywine": 3,
    "braner": 2,
    "branford": 2,
    "branham": 2,
    "brani": 2,
    "braniff": 2,
    "braniff's": 2,
    "branigan": 3,
    "branillo": 3,
    "branin": 2,
    "branislov": 3,
    "branitzky": 3,
    "brank": 1,
    "brank's": 1,
    "branki": 2,
    "branko": 2,
    "branks": 1,
    "brann": 1,
    "branna": 2,
    "brannam": 2,
    "brannan": 2,
    "brannen": 2,
    "branner": 2,
    "brannick": 2,
    "brannigan": 3,
    "branning": 2,
    "brannock": 2,
    "brannon": 2,
    "brannum": 2,
    "branon": 2,
    "branscom": 2,
    "branscomb": 2,
    "branscome": 2,
    "branscum": 2,
    "bransfield": 2,
    "bransford": 2,
    "bransom": 2,
    "branson": 2,
    "branson's": 2,
    "branstad": 2,
    "branstetter": 3,
    "brant": 1,
    "brantley": 2,
    "brantly": 2,
    "brantner": 2,
    "branton": 2,
    "branum": 2,
    "branyon": 2,
    "branz": 1,
    "braque": 1,
    "bras": 1,
    "bras(1)": 1,
    "brascade": 2,
    "brascan": 2,
    "brasch": 1,
    "brasco": 2,
    "brase": 1,
    "brasel": 2,
    "braselton": 3,
    "brasfield": 2,
    "brash": 1,
    "brashear": 2,
    "brashears": 2,
    "brasher": 2,
    "brashers": 2,
    "brashier": 3,
    "brashness": 2,
    "brasil": 2,
    "brasil(1)": 2,
    "brasilia": 3,
    "brasilia(1)": 3,
    "brasington": 3,
    "brasow": 2,
    "brasow(1)": 2,
    "brass": 1,
    "brassard": 2,
    "brasseaux": 2,
    "brassell": 2,
    "brasserie": 3,
    "brasses": 2,
    "brasseur": 2,
    "brassfield": 2,
    "brasso": 2,
    "brasso's": 2,
    "brassy": 2,
    "braswell": 2,
    "brat": 1,
    "bratcher": 2,
    "braton": 2,
    "brats": 1,
    "bratsch": 1,
    "bratt": 1,
    "brattain": 2,
    "brattaslava": 4,
    "brattaslava's": 4,
    "bratten": 2,
    "brattin": 2,
    "brattle": 2,
    "bratton": 2,
    "bratwurst": 2,
    "bratz": 1,
    "brau": 1,
    "brauch": 1,
    "braucher": 2,
    "brauchli": 2,
    "braud": 1,
    "braude": 1,
    "brauer": 2,
    "braughton": 2,
    "brauhau": 2,
    "brault": 1,
    "braun": 1,
    "braun's": 1,
    "braund": 1,
    "braune": 1,
    "brauner": 2,
    "brauns": 1,
    "braunschweig": 2,
    "braunstein": 2,
    "braunstein(1)": 2,
    "braunwald": 2,
    "brause": 1,
    "brautigam": 3,
    "brautigams": 3,
    "bravado": 3,
    "brave": 1,
    "braved": 1,
    "braveheart": 2,
    "bravely": 2,
    "braver": 2,
    "braverman": 3,
    "bravery": 3,
    "braves": 1,
    "braves'": 1,
    "bravest": 2,
    "braving": 2,
    "bravo": 2,
    "bravura": 3,
    "brawer": 2,
    "brawl": 1,
    "brawley": 2,
    "brawling": 2,
    "brawls": 1,
    "brawn": 1,
    "brawner": 2,
    "brawny": 2,
    "braxton": 2,
    "bray": 1,
    "brayboy": 2,
    "brayer": 2,
    "brayfield": 2,
    "brayman": 2,
    "brayton": 2,
    "braz": 1,
    "brazda": 2,
    "brazeal": 2,
    "brazeau": 2,
    "brazee": 2,
    "brazel": 2,
    "brazell": 2,
    "brazelton": 3,
    "brazen": 2,
    "brazenly": 3,
    "brazenness": 3,
    "braziel": 2,
    "brazier": 3,
    "braziers": 2,
    "brazil": 2,
    "brazil's": 2,
    "brazile": 2,
    "brazilian": 3,
    "brazilians": 3,
    "brazill": 2,
    "brazos": 2,
    "brazzaville": 3,
    "brazzaville's": 3,
    "brazzel": 2,
    "brazzell": 2,
    "brca": 2,
    "brcko": 2,
    "brcko's": 2,
    "brea": 1,
    "breach": 1,
    "breached": 1,
    "breaches": 2,
    "breaching": 2,
    "bread": 1,
    "breadbasket": 3,
    "breadbox": 2,
    "breaded": 2,
    "breadfruit": 2,
    "breading": 2,
    "breads": 1,
    "breadth": 1,
    "breadwinner": 3,
    "breadwinners": 3,
    "bready": 2,
    "break": 1,
    "breakable": 3,
    "breakage": 2,
    "breakaway": 3,
    "breakdown": 2,
    "breakdowns": 2,
    "breaker": 2,
    "breakers": 2,
    "breakeven": 3,
    "breakey": 2,
    "breakfast": 2,
    "breakfasts": 2,
    "breakfield": 2,
    "breaking": 2,
    "breakmate": 2,
    "breakneck": 2,
    "breakout": 2,
    "breakouts": 2,
    "breaks": 1,
    "breakthrough": 2,
    "breakthroughs": 2,
    "breakup": 2,
    "breakups": 2,
    "breakwater": 3,
    "breaky": 2,
    "bream": 1,
    "brean": 1,
    "brearley": 2,
    "breast": 1,
    "breasted": 2,
    "breasted(1)": 2,
    "breastfed": 2,
    "breastfeed": 2,
    "breastfeeding": 3,
    "breastfeeding's": 3,
    "breastfeeds": 2,
    "breasting": 2,
    "breastplate": 2,
    "breasts": 1,
    "breath": 1,
    "breathe": 1,
    "breathed": 1,
    "breather": 2,
    "breathes": 1,
    "breathing": 2,
    "breathless": 2,
    "breathlessly": 3,
    "breaths": 1,
    "breathtaking": 3,
    "breathtakingly": 4,
    "breathy": 2,
    "breau": 1,
    "breault": 1,
    "breaux": 1,
    "breaux(1)": 1,
    "breazeale": 2,
    "brebach": 2,
    "brechbill": 2,
    "brecheen": 2,
    "brecheisen": 3,
    "brecher": 2,
    "brecht": 1,
    "brechtel": 2,
    "breck": 1,
    "breckenridge": 3,
    "brecker": 2,
    "breco": 2,
    "bred": 1,
    "breda": 2,
    "brede": 1,
    "breden": 2,
    "bredeson": 3,
    "bree": 1,
    "breece": 1,
    "breech": 1,
    "breeching": 2,
    "breed": 1,
    "breed's": 1,
    "breeden": 2,
    "breeden's": 2,
    "breeder": 2,
    "breeders": 2,
    "breeders'": 2,
    "breeding": 2,
    "breedlove": 2,
    "breeds": 1,
    "breeland": 2,
    "breen": 1,
    "brees": 1,
    "breese": 1,
    "breeze": 1,
    "breezed": 1,
    "breezes": 2,
    "breezeway": 2,
    "breezy": 2,
    "brege": 1,
    "breger": 2,
    "breglio": 3,
    "bregman": 2,
    "breguet": 2,
    "brehm": 1,
    "brehmer": 2,
    "breidenbach": 3,
    "breidenstein": 3,
    "breidenstein(1)": 3,
    "breier": 2,
    "breighner": 2,
    "breighton": 2,
    "breiner": 2,
    "breining": 2,
    "breininger": 3,
    "breisch": 1,
    "breit": 1,
    "breitbach": 2,
    "breitbarth": 2,
    "breitenbach": 3,
    "breitenstein": 3,
    "breitenstein(1)": 3,
    "breithaupt": 2,
    "breitkreutz": 2,
    "breitling": 3,
    "breitling(1)": 2,
    "breitman": 2,
    "breitschwerdt": 2,
    "breitweiser": 3,
    "breitzman": 2,
    "brekke": 1,
    "breland": 2,
    "brelsford": 2,
    "brem": 1,
    "bremen": 2,
    "bremer": 2,
    "bremmer": 2,
    "bremner": 2,
    "brems": 1,
    "bren": 1,
    "brenda": 2,
    "brenda's": 2,
    "brendan": 2,
    "brendel": 2,
    "brenden": 2,
    "brender": 2,
    "brendle": 2,
    "brendlinger": 4,
    "brendlinger(1)": 3,
    "brendon": 2,
    "brendor": 2,
    "brendsel": 2,
    "breneman": 2,
    "brener": 2,
    "brenes": 1,
    "brengle": 2,
    "brenizer": 3,
    "brenn": 1,
    "brenna": 2,
    "brennan": 2,
    "brennan's": 2,
    "brennans": 2,
    "brennecke": 2,
    "brenneke": 3,
    "brenneman": 2,
    "brennen": 2,
    "brenner": 2,
    "brenning": 2,
    "brensinger": 3,
    "brent": 1,
    "brentano": 3,
    "brentanos": 3,
    "brentlinger": 4,
    "brentlinger(1)": 3,
    "brenton": 2,
    "brents": 1,
    "brentwood": 2,
    "breon": 2,
    "bresca": 2,
    "brescia": 2,
    "bresee": 2,
    "bresette": 2,
    "breshears": 2,
    "breslaw": 2,
    "bresler": 2,
    "breslin": 2,
    "breslow": 2,
    "bresnahan": 3,
    "bresnan": 2,
    "bresnick": 2,
    "bress": 1,
    "bresse": 1,
    "bresseau": 2,
    "bresser": 2,
    "bresser's": 2,
    "bressette": 2,
    "bressler": 2,
    "bressman": 2,
    "bresson": 2,
    "brest": 1,
    "brester": 2,
    "bret": 1,
    "breth": 1,
    "brethauer": 3,
    "brethen": 2,
    "brethren": 2,
    "breton": 2,
    "bretschneider": 3,
    "brett": 1,
    "bretthauer": 3,
    "bretton": 2,
    "bretts": 1,
    "brettschneider": 3,
    "brettschneider(1)": 3,
    "bretz": 1,
    "breuer": 2,
    "breunig": 2,
    "breuninger": 3,
    "brevard": 2,
    "brevets": 2,
    "brevig": 2,
    "brevik": 2,
    "brevity": 3,
    "brew": 1,
    "brewbaker": 3,
    "brewed": 1,
    "brewer": 2,
    "brewer's": 2,
    "breweries": 3,
    "breweries(1)": 2,
    "brewers": 2,
    "brewers'": 2,
    "brewery": 3,
    "brewing": 2,
    "brewington": 3,
    "brewry": 2,
    "brews": 1,
    "brewster": 2,
    "brewton": 2,
    "brey": 1,
    "breyer": 2,
    "breyer's": 2,
    "breyfogle": 3,
    "breza": 2,
    "brezhnev": 2,
    "brezhnev(1)": 2,
    "brezhnev's": 2,
    "brezhnev's(1)": 2,
    "brezina": 3,
    "brezinski": 3,
    "bria": 2,
    "brian": 2,
    "brian's": 2,
    "briana": 3,
    "briana(1)": 3,
    "briana's": 3,
    "briana's(1)": 3,
    "briancon": 3,
    "briand": 2,
    "brianna": 3,
    "brianna's": 3,
    "briant": 2,
    "briar": 2,
    "briarcliff": 2,
    "bribe": 1,
    "bribed": 1,
    "bribery": 3,
    "bribes": 1,
    "bribing": 2,
    "bric": 1,
    "briccetti": 3,
    "bricco": 2,
    "brice": 1,
    "briceno": 3,
    "brick": 1,
    "brickbat": 2,
    "brickbats": 2,
    "brickel": 2,
    "brickell": 2,
    "bricker": 2,
    "brickey": 2,
    "brickhouse": 2,
    "bricklayer": 3,
    "bricklayers": 3,
    "brickle": 2,
    "brickler": 2,
    "brickley": 2,
    "bricklin": 2,
    "bricklin's": 2,
    "brickman": 2,
    "brickner": 2,
    "bricks": 1,
    "brickyard": 2,
    "bricom": 2,
    "bridal": 2,
    "bride": 1,
    "bride's": 1,
    "brideau": 2,
    "bridegroom": 2,
    "bridegroom's": 2,
    "briden": 2,
    "bridenbaugh": 3,
    "bridenstine": 3,
    "brides": 1,
    "bridesburg": 2,
    "bridesmaid": 2,
    "bridesmaid's": 2,
    "bridesmaids": 2,
    "bridesmaids'": 2,
    "bridge": 1,
    "bridge's": 2,
    "bridged": 1,
    "bridgeford": 2,
    "bridgeforth": 2,
    "bridgehead": 2,
    "bridgeman": 2,
    "bridgeport": 2,
    "bridger": 2,
    "bridgers": 2,
    "bridges": 2,
    "bridges(1)": 2,
    "bridgestone": 2,
    "bridgestone's": 2,
    "bridget": 2,
    "bridget(1)": 2,
    "bridget's": 2,
    "bridgeton": 2,
    "bridgetown": 2,
    "bridgett": 2,
    "bridgette": 2,
    "bridgette(1)": 2,
    "bridgewater": 3,
    "bridgham": 2,
    "bridging": 2,
    "bridgman": 2,
    "bridie": 2,
    "bridle": 2,
    "bridled": 2,
    "bridwell": 2,
    "brie": 1,
    "brieant": 2,
    "brief": 1,
    "briefcase": 2,
    "briefcases": 3,
    "briefed": 1,
    "briefer": 2,
    "briefers": 2,
    "briefest": 2,
    "briefing": 2,
    "briefings": 2,
    "briefly": 2,
    "briefs": 1,
    "briegel": 2,
    "brieger": 2,
    "briel": 1,
    "brien": 2,
    "brienza": 2,
    "brier": 2,
    "briere": 1,
    "brierley": 3,
    "brierly": 3,
    "briese": 1,
    "brietzke": 2,
    "brig": 1,
    "brigade": 2,
    "brigade(1)": 2,
    "brigadeer": 3,
    "brigades": 2,
    "brigadier": 3,
    "brigance": 2,
    "brigandi": 3,
    "brigante": 3,
    "briganti": 3,
    "briggs": 1,
    "briggstone": 2,
    "brigham": 2,
    "brigham's": 2,
    "brighams": 2,
    "bright": 1,
    "bright's": 1,
    "brightbill": 2,
    "brighten": 2,
    "brightened": 2,
    "brightening": 3,
    "brightening(1)": 2,
    "brightens": 2,
    "brighter": 2,
    "brightest": 2,
    "brightly": 2,
    "brightman": 2,
    "brightness": 2,
    "brighton": 2,
    "brightwell": 2,
    "brigitte": 2,
    "brigman": 2,
    "brignac": 2,
    "brigner": 2,
    "brigode": 3,
    "briguglio": 4,
    "briles": 1,
    "briley": 2,
    "brill": 1,
    "brill's": 1,
    "brillhart": 2,
    "brilliance": 2,
    "brilliant": 2,
    "brilliantly": 3,
    "brillstein": 2,
    "brillstein(1)": 2,
    "brim": 1,
    "brimberry": 3,
    "brimelow": 3,
    "brimer": 2,
    "brimhall": 2,
    "brimm": 1,
    "brimmed": 1,
    "brimmer": 2,
    "brimming": 2,
    "brimstone": 2,
    "brin": 1,
    "brindel": 2,
    "brindle": 2,
    "brindley": 2,
    "brine": 1,
    "brinegar": 3,
    "briner": 2,
    "brines": 1,
    "briney": 2,
    "bring": 1,
    "bringhurst": 2,
    "bringing": 2,
    "bringle": 2,
    "bringman": 2,
    "brings": 1,
    "brington": 2,
    "brining": 2,
    "brink": 1,
    "brink's": 1,
    "brinker": 2,
    "brinkerhoff": 3,
    "brinkley": 2,
    "brinkley's": 2,
    "brinkly": 2,
    "brinkman": 2,
    "brinkmann": 2,
    "brinkmann's": 2,
    "brinkmanship": 3,
    "brinkmeier": 3,
    "brinkmeyer": 3,
    "brinks": 1,
    "brinksmanship": 3,
    "brinlee": 2,
    "brinley": 2,
    "brinn": 1,
    "brinner": 2,
    "brinser": 2,
    "brinsfield": 2,
    "brinson": 2,
    "brintec": 2,
    "brinton": 2,
    "brio": 2,
    "brioche": 2,
    "brioche(1)": 2,
    "briody": 3,
    "brion": 2,
    "briones": 3,
    "briquemont": 2,
    "brisbane": 2,
    "brisbin": 2,
    "brisbois": 2,
    "brisbois(1)": 2,
    "brisbon": 2,
    "brisburg": 2,
    "brisco": 2,
    "briscoe": 2,
    "brisendine": 3,
    "briseno": 3,
    "briseno's": 3,
    "brisk": 1,
    "brisker": 2,
    "brisket": 2,
    "briskey": 2,
    "briski": 2,
    "briskin": 2,
    "briskly": 2,
    "brisky": 2,
    "brislin": 2,
    "brison": 2,
    "brissette": 2,
    "brissey": 2,
    "brisson": 2,
    "brister": 2,
    "bristle": 2,
    "bristled": 2,
    "bristles": 2,
    "bristling": 3,
    "bristling(1)": 2,
    "bristol": 2,
    "bristol's": 2,
    "bristow": 2,
    "brit": 1,
    "brita": 2,
    "britain": 2,
    "britain's": 2,
    "britains": 2,
    "britannia": 4,
    "britannica": 4,
    "britcher": 2,
    "britches": 2,
    "brite": 1,
    "britian": 2,
    "british": 2,
    "britnell": 2,
    "brito": 2,
    "britoil": 2,
    "briton": 2,
    "britons": 2,
    "britons'": 2,
    "brits": 1,
    "britsch": 1,
    "britt": 1,
    "brittain": 2,
    "brittan": 2,
    "brittania": 4,
    "brittania(1)": 3,
    "brittany": 3,
    "britten": 2,
    "brittenham": 3,
    "brittian": 3,
    "brittin": 2,
    "brittingham": 3,
    "brittle": 2,
    "brittler": 2,
    "brittlest": 2,
    "britton": 2,
    "britts": 1,
    "britz": 1,
    "brix": 1,
    "brixey": 2,
    "brixius": 3,
    "brizendine": 4,
    "brizill": 2,
    "brizola": 3,
    "brizzi": 2,
    "brizzolara": 4,
    "bro": 1,
    "bro's": 1,
    "broach": 1,
    "broached": 1,
    "broaches": 2,
    "broaching": 2,
    "broad": 1,
    "broad's": 1,
    "broadacre": 3,
    "broadaway": 3,
    "broadband": 2,
    "broadbase": 2,
    "broadbased": 2,
    "broadbeach": 2,
    "broadbent": 2,
    "broadcast": 2,
    "broadcaster": 3,
    "broadcaster's": 3,
    "broadcasters": 3,
    "broadcasters'": 3,
    "broadcasting": 3,
    "broadcasting's": 3,
    "broadcasts": 2,
    "broaddus": 2,
    "broaden": 2,
    "broadened": 2,
    "broadening": 3,
    "broadening(1)": 2,
    "broadens": 2,
    "broader": 2,
    "broadest": 2,
    "broadhead": 2,
    "broadhurst": 2,
    "broadie": 2,
    "broadley": 2,
    "broadly": 2,
    "broadnax": 2,
    "broadpfoot": 2,
    "broadrick": 2,
    "broadside": 2,
    "broadsided": 3,
    "broadstreet": 2,
    "broadsword": 2,
    "broadus": 2,
    "broadview": 2,
    "broadway": 2,
    "broadway's": 2,
    "broadwell": 2,
    "broady": 2,
    "brobdingnagian": 5,
    "brobdingnagians": 5,
    "brobeck": 2,
    "broberg": 2,
    "brobst": 1,
    "broc": 1,
    "brocade": 2,
    "brocades": 2,
    "brocato": 3,
    "brocco": 2,
    "broccoli": 3,
    "broccoli(1)": 2,
    "broce": 1,
    "brochu": 2,
    "brochure": 2,
    "brochures": 2,
    "brocious": 2,
    "brock": 1,
    "brock's": 1,
    "brockbank": 2,
    "brockel": 2,
    "brocker": 2,
    "brockert": 2,
    "brockett": 2,
    "brockhaus": 2,
    "brockhoff": 2,
    "brockhouse": 2,
    "brockie": 2,
    "brockington": 3,
    "brocklehurst": 3,
    "brockley": 2,
    "brocklin": 2,
    "brocklin's": 2,
    "brockman": 2,
    "brockmann": 2,
    "brockmeier": 3,
    "brockmeyer": 3,
    "brockner": 2,
    "brocksmith": 2,
    "brockton": 2,
    "brockway": 2,
    "brockway's": 2,
    "brockwell": 2,
    "brod": 1,
    "broda": 2,
    "brodbeck": 2,
    "brode": 1,
    "broden": 2,
    "broder": 2,
    "broder's": 2,
    "broderbund": 3,
    "broderick": 3,
    "broderick(1)": 2,
    "broderick's": 3,
    "broderick's(1)": 2,
    "brodersen": 3,
    "brodersohn": 3,
    "broderson": 3,
    "brodeur": 2,
    "brodhead": 2,
    "brodie": 2,
    "brodin": 2,
    "brodkin": 2,
    "brodman": 2,
    "brodnax": 2,
    "brodowski": 3,
    "brodrick": 2,
    "brodry": 2,
    "brodsky": 2,
    "brodt": 1,
    "brody": 2,
    "brody's": 2,
    "brodzinski": 3,
    "broe": 1,
    "broecker": 2,
    "broeker": 2,
    "broer": 2,
    "broerman": 3,
    "broers": 2,
    "brogan": 2,
    "brogden": 2,
    "brogdon": 2,
    "brogna": 2,
    "broich": 1,
    "broil": 1,
    "broiled": 1,
    "broiler": 2,
    "broilers": 2,
    "broiling": 2,
    "broin": 1,
    "brok": 1,
    "brokaw": 2,
    "broke": 1,
    "broken": 2,
    "broken-wind": 3,
    "broken-winded": 4,
    "broker": 2,
    "broker's": 2,
    "brokerage": 3,
    "brokerage(1)": 2,
    "brokerage's": 4,
    "brokerage's(1)": 3,
    "brokerages": 4,
    "brokerages(1)": 3,
    "brokerages'": 4,
    "brokerages'(1)": 3,
    "brokered": 2,
    "brokering": 3,
    "brokers": 2,
    "brokers'": 2,
    "broking": 2,
    "brokini": 3,
    "brolin": 2,
    "brolly": 2,
    "brom": 1,
    "broman": 2,
    "bromberg": 2,
    "bromfield": 2,
    "bromfield's": 2,
    "bromide": 2,
    "bromides": 2,
    "bromine": 2,
    "bromley": 2,
    "bromm": 1,
    "brommer": 2,
    "bromont": 2,
    "brompheril": 3,
    "bromwell": 2,
    "bromwich": 2,
    "bronaugh": 2,
    "bronc": 1,
    "bronchial": 3,
    "bronchitis": 3,
    "bronchoscope": 3,
    "bronco": 2,
    "broncos": 2,
    "bronder": 2,
    "broner": 2,
    "bronfman": 2,
    "bronfman's": 2,
    "bronfmans": 2,
    "bronk": 1,
    "bronkema": 3,
    "bronn": 1,
    "bronner": 2,
    "brons": 1,
    "bronson": 2,
    "bronstein": 2,
    "bronstein(1)": 2,
    "bronston": 2,
    "bronte": 2,
    "bronte's": 2,
    "brontosaurus": 4,
    "brontosaurus(1)": 4,
    "bronwen": 2,
    "bronwyn": 2,
    "bronx": 1,
    "bronze": 1,
    "bronzed": 1,
    "bronzen": 2,
    "bronzes": 2,
    "bronzes(1)": 2,
    "brooch": 1,
    "brooch(1)": 1,
    "brood": 1,
    "brooded": 2,
    "brooding": 2,
    "broody": 2,
    "brook": 1,
    "brook's": 1,
    "brookbank": 2,
    "brooke": 1,
    "brooke's": 1,
    "brookehill": 2,
    "brooken": 2,
    "brookens": 2,
    "brooker": 2,
    "brookes": 1,
    "brookfield": 2,
    "brookhart": 2,
    "brookhaven": 3,
    "brookhurst": 2,
    "brooking": 2,
    "brookings": 2,
    "brookins": 2,
    "brookline": 2,
    "brooklyn": 2,
    "brooklyn(1)": 2,
    "brooklyn's": 2,
    "brooklyn's(1)": 2,
    "brookman": 2,
    "brookner": 2,
    "brookner's": 2,
    "brookover": 3,
    "brooks": 1,
    "brooks'": 1,
    "brooks's": 2,
    "brooks's(1)": 1,
    "brookshier": 3,
    "brookshire": 2,
    "brookside": 2,
    "brookstone": 2,
    "brooksville": 2,
    "brooksville's": 2,
    "broom": 1,
    "broomall": 2,
    "broome": 1,
    "broomfield": 2,
    "brooms": 1,
    "broomstick": 2,
    "broomsticks": 2,
    "brophy": 2,
    "brosch": 1,
    "brose": 1,
    "brosh": 1,
    "broshears": 2,
    "brosious": 3,
    "brosius": 3,
    "broski": 2,
    "brosky": 2,
    "brosnahan": 3,
    "brosnan": 2,
    "bross": 1,
    "brossard": 2,
    "brossart": 2,
    "brosseau": 2,
    "brosser": 2,
    "brossette": 2,
    "brossman": 2,
    "brost": 1,
    "brostrom": 2,
    "brosz": 1,
    "broten": 2,
    "broth": 1,
    "brothel": 2,
    "brothels": 2,
    "brother": 2,
    "brother's": 2,
    "brotherhood": 3,
    "brotherly": 3,
    "brothers": 2,
    "brothers'": 2,
    "brothers's": 3,
    "brotherson": 3,
    "brotherton": 3,
    "broths": 1,
    "brotman": 2,
    "brott": 1,
    "brotzman": 2,
    "broucek": 2,
    "broudy": 2,
    "brough": 1,
    "brougham": 2,
    "brougher": 2,
    "broughman": 2,
    "brought": 1,
    "broughton": 2,
    "brouhaha": 3,
    "brouhard": 3,
    "brouillard": 2,
    "brouillet": 2,
    "brouillette": 2,
    "broun": 1,
    "brountas": 2,
    "brouse": 1,
    "broussard": 2,
    "brousseau": 2,
    "brousset": 2,
    "brouwer": 2,
    "brow": 1,
    "broward": 2,
    "browbeat": 2,
    "browder": 2,
    "browe": 1,
    "browed": 1,
    "brower": 2,
    "brown": 1,
    "brown's": 1,
    "brownback": 2,
    "browne": 1,
    "browned": 1,
    "brownell": 2,
    "browner": 2,
    "brownest": 2,
    "brownfield": 2,
    "brownfields": 2,
    "brownie": 2,
    "brownies": 2,
    "browning": 2,
    "browning's": 2,
    "brownish": 2,
    "brownlee": 2,
    "brownley": 2,
    "brownlie": 2,
    "brownlow": 2,
    "brownmiller": 3,
    "brownout": 2,
    "brownouts": 2,
    "brownrigg": 2,
    "browns": 1,
    "browns'": 1,
    "brownson": 2,
    "brownstein": 2,
    "brownstein(1)": 2,
    "brownstone": 2,
    "brownsville": 2,
    "brows": 1,
    "browse": 1,
    "browsed": 1,
    "browser": 2,
    "browsers": 2,
    "browsing": 2,
    "brox": 1,
    "broxson": 2,
    "broxterman": 3,
    "broxton": 2,
    "broy": 1,
    "broyard": 2,
    "broyhill": 2,
    "broyles": 1,
    "broz": 1,
    "brozek": 2,
    "brozman": 2,
    "brozovich": 3,
    "brozowski": 3,
    "brubaker": 3,
    "brubeck": 2,
    "brucato": 3,
    "bruce": 1,
    "bruce's": 2,
    "bruch": 1,
    "bruchhausen": 3,
    "brucie": 2,
    "brucite": 2,
    "bruck": 1,
    "bruck's": 1,
    "brucker": 2,
    "bruckheimer": 3,
    "bruckman": 2,
    "bruckner": 2,
    "brucks": 1,
    "bruder": 2,
    "brue": 1,
    "bruecher": 2,
    "brueck": 1,
    "brueckner": 2,
    "bruegge": 2,
    "brueggeman": 2,
    "brueggemann": 2,
    "brueggen": 2,
    "bruegger": 2,
    "bruegger's": 2,
    "bruehl": 1,
    "bruella": 3,
    "bruemmer": 2,
    "bruen": 1,
    "bruening": 2,
    "bruer": 2,
    "bruff": 1,
    "bruford": 2,
    "bruges": 2,
    "bruges(1)": 1,
    "bruggeman": 2,
    "brugger": 2,
    "brugh": 1,
    "brugman": 2,
    "bruha": 2,
    "bruhl": 1,
    "bruhn": 1,
    "bruin": 2,
    "bruin's": 2,
    "bruington": 3,
    "bruins": 2,
    "bruinsma": 3,
    "bruise": 1,
    "bruised": 1,
    "bruises": 2,
    "bruises(1)": 2,
    "bruising": 2,
    "brule": 1,
    "bruley": 2,
    "brum": 1,
    "brumbach": 2,
    "brumback": 2,
    "brumbaugh": 2,
    "brumbelow": 3,
    "brumer": 2,
    "brumett": 2,
    "brumfield": 2,
    "brumit": 2,
    "brumitt": 2,
    "brumley": 2,
    "brumlow": 2,
    "brumm": 1,
    "brummel": 2,
    "brummell": 2,
    "brummer": 2,
    "brummet": 2,
    "brummett": 2,
    "brummitt": 2,
    "brummond": 2,
    "brun": 1,
    "bruna": 2,
    "brunch": 1,
    "brunches": 2,
    "bruncor": 2,
    "brundage": 2,
    "brundidge": 2,
    "brundige": 2,
    "brundtland": 2,
    "brune": 1,
    "bruneau": 2,
    "brunei": 2,
    "brunell": 2,
    "brunella": 3,
    "brunelle": 2,
    "brunelli": 3,
    "bruner": 2,
    "brunet": 2,
    "brunett": 2,
    "brunetta": 3,
    "brunette": 2,
    "brunettes": 2,
    "brunetti": 3,
    "brunetto": 3,
    "bruney": 2,
    "brungard": 2,
    "brungardt": 2,
    "brunger": 2,
    "brunhilda": 3,
    "bruni": 2,
    "brunick": 2,
    "bruning": 2,
    "brunjes": 2,
    "brunk": 1,
    "brunke": 1,
    "brunken": 2,
    "brunker": 2,
    "brunkhorst": 2,
    "brunkow": 2,
    "brunn": 1,
    "brunner": 2,
    "brunnhilde": 2,
    "bruno": 2,
    "bruno's": 2,
    "bruns": 1,
    "brunskill": 2,
    "brunsman": 2,
    "brunson": 2,
    "brunsvold": 2,
    "brunswick": 2,
    "brunswick's": 2,
    "brunswig": 2,
    "brunswig's": 2,
    "brunt": 1,
    "bruntjen": 2,
    "brunton": 2,
    "brunty": 2,
    "bruntz": 1,
    "brus": 1,
    "brusca": 2,
    "bruschi": 2,
    "brusco": 2,
    "bruse": 1,
    "brusett": 2,
    "brusett(1)": 2,
    "brusette": 2,
    "brush": 1,
    "brushaber": 3,
    "brushed": 1,
    "brushes": 2,
    "brushfire": 2,
    "brushfires": 2,
    "brushing": 2,
    "brushwork": 2,
    "brushy": 2,
    "bruske": 1,
    "bruski": 2,
    "brusky": 2,
    "bruso": 2,
    "brusque": 1,
    "brusquely": 2,
    "bruss": 1,
    "brusseau": 2,
    "brussel": 2,
    "brusselmans": 3,
    "brussels": 2,
    "brust": 1,
    "bruster": 2,
    "brustoloni": 4,
    "brut": 1,
    "brutal": 2,
    "brutalities": 4,
    "brutality": 4,
    "brutality(1)": 4,
    "brutalization": 5,
    "brutalize": 3,
    "brutalized": 3,
    "brutalizes": 4,
    "brutalizing": 4,
    "brutally": 3,
    "brute": 1,
    "bruting": 2,
    "brutish": 2,
    "bruton": 2,
    "brutsche": 2,
    "brutus": 2,
    "bruun": 1,
    "bruxelles": 3,
    "bruyette": 2,
    "bruynes": 2,
    "bruzzese": 3,
    "bryan": 2,
    "bryan's": 2,
    "bryans": 2,
    "bryans'": 2,
    "bryant": 2,
    "bryars": 2,
    "bryce": 1,
    "bryden": 2,
    "brydges": 2,
    "brydie": 2,
    "brydon": 2,
    "brye": 1,
    "bryen": 2,
    "bryer": 2,
    "bryk": 1,
    "brymer": 2,
    "bryn": 1,
    "bryna": 2,
    "bryne": 1,
    "bryner": 2,
    "bryngelson": 3,
    "bryon": 2,
    "brys": 1,
    "bryson": 2,
    "brzezinski": 3,
    "brzoska": 2,
    "brzozowski": 3,
    "brzycki": 2,
    "bt": 2,
    "bta": 3,
    "bua": 2,
    "bua(1)": 3,
    "bub": 1,
    "bubar": 2,
    "bubb": 1,
    "bubba": 2,
    "bubble": 2,
    "bubbled": 2,
    "bubbles": 2,
    "bubbling": 3,
    "bubbling(1)": 2,
    "bubbly": 2,
    "bubbly(1)": 3,
    "bubeck": 2,
    "bubel": 2,
    "bubier": 3,
    "bubinga": 3,
    "bubka": 2,
    "bublitz": 2,
    "buboltz": 2,
    "bubolz": 2,
    "bubonic": 3,
    "buc": 1,
    "bucaro": 3,
    "bucase": 2,
    "buccal": 2,
    "buccaneer": 3,
    "buccaneers": 3,
    "buccellato": 4,
    "buccheri": 3,
    "bucci": 2,
    "bucciarelli": 4,
    "buccieri": 3,
    "buccino": 3,
    "bucco": 2,
    "buccola": 3,
    "bucek": 2,
    "bucey": 2,
    "buch": 1,
    "buchalter": 3,
    "buchan": 2,
    "buchanan": 3,
    "buchanan's": 3,
    "buchananism": 5,
    "buchanans": 3,
    "buchannan": 3,
    "buchanon": 3,
    "bucharest": 3,
    "bucharest(1)": 3,
    "buchberger": 3,
    "buchbinder": 3,
    "buchbinder(1)": 3,
    "buche": 1,
    "buchen": 2,
    "buchenwald": 3,
    "bucher": 2,
    "buchert": 2,
    "buchheit": 2,
    "buchholtz": 2,
    "buchholz": 2,
    "buchi": 2,
    "buchi(1)": 2,
    "buchi's": 2,
    "buchi's(1)": 2,
    "buchinger": 3,
    "buchko": 2,
    "buchler": 3,
    "buchler(1)": 2,
    "buchman": 2,
    "buchmann": 2,
    "buchmiller": 3,
    "buchmiller(1)": 3,
    "buchner": 2,
    "bucholtz": 2,
    "bucholtz(1)": 2,
    "bucholz": 2,
    "buchs": 1,
    "buchsbaum": 2,
    "buchta": 2,
    "buchter": 2,
    "buchwald": 2,
    "buck": 1,
    "buck's": 1,
    "buckalew": 3,
    "buckbee": 2,
    "bucked": 1,
    "buckel": 2,
    "buckelew": 3,
    "buckels": 2,
    "bucket": 2,
    "bucket(1)": 2,
    "buckets": 2,
    "buckey": 2,
    "buckeye": 2,
    "buckeyes": 2,
    "buckhantz": 2,
    "buckholtz": 2,
    "buckholz": 2,
    "buckhorn": 2,
    "bucking": 2,
    "buckingham": 3,
    "buckland": 2,
    "buckle": 2,
    "buckled": 2,
    "buckler": 3,
    "buckler(1)": 2,
    "buckles": 2,
    "bucklew": 2,
    "buckley": 2,
    "bucklin": 2,
    "buckling": 2,
    "buckman": 2,
    "buckmaster": 3,
    "buckminster": 3,
    "bucknam": 2,
    "bucknell": 2,
    "buckner": 2,
    "bucko": 2,
    "bucks": 1,
    "buckshot": 2,
    "buckskin": 2,
    "buckskins": 2,
    "buckstein": 2,
    "buckthorn": 2,
    "buckwalter": 3,
    "buckwheat": 2,
    "bucky": 2,
    "bucoba": 3,
    "bucolic": 3,
    "bucs": 1,
    "bucs'": 1,
    "bucy": 2,
    "buczek": 2,
    "buczkowski": 3,
    "buczynski": 3,
    "bud": 1,
    "bud's": 1,
    "bud-test": 2,
    "budai": 3,
    "budapest": 3,
    "budapest(1)": 3,
    "budapest's": 3,
    "budapest's(1)": 3,
    "buday": 2,
    "budd": 1,
    "budde": 1,
    "budden": 2,
    "buddenbrooks": 3,
    "buddenhagen": 4,
    "buddha": 2,
    "buddha's": 2,
    "buddhism": 3,
    "buddhist": 2,
    "buddhists": 2,
    "buddie": 2,
    "buddier": 3,
    "buddiers": 3,
    "buddies": 2,
    "buddin": 2,
    "budding": 2,
    "buddy": 2,
    "buddy's": 2,
    "buder": 2,
    "budge": 1,
    "budged": 1,
    "budget": 2,
    "budget's": 2,
    "budgetary": 4,
    "budgeted": 3,
    "budgeted(1)": 3,
    "budgeteer": 3,
    "budgeteers": 3,
    "budgeting": 3,
    "budgets": 2,
    "budging": 2,
    "budick": 2,
    "budick's": 2,
    "budiman": 3,
    "budiman(1)": 3,
    "budin": 2,
    "budinger": 3,
    "budka": 2,
    "budke": 2,
    "budlong": 2,
    "budner": 2,
    "budney": 2,
    "budnick": 2,
    "budnik": 2,
    "budny": 2,
    "budreau": 2,
    "budrow": 2,
    "buds": 1,
    "budson": 2,
    "budvar": 2,
    "budvar(1)": 2,
    "budweiser": 3,
    "budyonnovsk": 3,
    "budz": 1,
    "budzinski": 3,
    "budzyn": 2,
    "budzynski": 3,
    "bue": 1,
    "bueche": 1,
    "buechel": 2,
    "buechele": 2,
    "buechler": 3,
    "buechler(1)": 2,
    "buechner": 2,
    "buege": 1,
    "buegler": 2,
    "buehl": 1,
    "buehler": 2,
    "buehner": 2,
    "buehrer": 2,
    "buehrer(1)": 2,
    "buehring": 2,
    "buehrle": 2,
    "bueker": 2,
    "buel": 1,
    "buell": 2,
    "buelow": 2,
    "buena": 2,
    "buendia": 3,
    "buenger": 2,
    "buening": 2,
    "bueno": 2,
    "buenos": 2,
    "buenos(1)": 2,
    "buenos-aires": 4,
    "buenos-aires(1)": 4,
    "buenos-aires(2)": 3,
    "buenos-aires(3)": 3,
    "buenrostro": 3,
    "buentello": 3,
    "buer": 2,
    "buerge": 1,
    "buerger": 2,
    "buerkle": 2,
    "buerry": 2,
    "buescher": 2,
    "buesing": 2,
    "bueter": 2,
    "buetow": 2,
    "buettner": 2,
    "bufano": 3,
    "bufe": 1,
    "bufete": 2,
    "buff": 1,
    "buff's": 1,
    "buffa": 2,
    "buffalo": 3,
    "buffalo's": 3,
    "buffalos": 3,
    "buffer": 2,
    "buffered": 2,
    "bufferin": 3,
    "buffering": 3,
    "buffers": 2,
    "buffet": 2,
    "buffet(1)": 2,
    "buffeted": 2,
    "buffeted(1)": 3,
    "buffeting": 3,
    "buffeting(1)": 3,
    "buffets": 2,
    "buffets(1)": 2,
    "buffett": 2,
    "buffett's": 2,
    "buffin": 2,
    "buffington": 3,
    "buffkin": 2,
    "buffo": 2,
    "buffone": 3,
    "buffoon": 2,
    "bufford": 2,
    "buffs": 1,
    "buffton": 2,
    "buffum": 2,
    "buffy": 2,
    "bufkin": 2,
    "buford": 2,
    "bug": 1,
    "buga": 2,
    "buga(1)": 4,
    "bugaboo": 3,
    "bugai": 2,
    "bugai's": 2,
    "bugaj": 2,
    "bugarin": 3,
    "bugatti": 3,
    "bugay": 2,
    "bugbee": 2,
    "bugeye": 2,
    "bugeyed": 2,
    "bugg": 1,
    "bugge": 1,
    "bugged": 1,
    "bugger": 2,
    "buggers": 2,
    "buggies": 2,
    "bugging": 2,
    "buggs": 1,
    "buggy": 2,
    "bugh": 1,
    "bugher": 2,
    "bugle": 2,
    "bugles": 2,
    "bugling": 3,
    "bugling(1)": 2,
    "bugliosi": 4,
    "bugliosi's": 4,
    "bugojno": 3,
    "bugs": 1,
    "bugsy": 2,
    "buhl": 1,
    "buhler": 2,
    "buhman": 2,
    "buhr": 1,
    "buhrman": 2,
    "buhrow": 2,
    "bui": 1,
    "bui(1)": 1,
    "buice": 1,
    "buice(1)": 1,
    "buick": 2,
    "buick's": 2,
    "buicks": 2,
    "buie": 2,
    "buie(1)": 1,
    "buikema": 3,
    "buikema(1)": 3,
    "buil": 2,
    "build": 1,
    "buildable": 3,
    "builder": 2,
    "builder's": 2,
    "builders": 2,
    "builders'": 2,
    "building": 2,
    "building's": 2,
    "buildings": 2,
    "builds": 1,
    "buildup": 2,
    "buildups": 2,
    "built": 1,
    "buis": 1,
    "buisson": 2,
    "buist": 2,
    "buitoni": 3,
    "buitrago": 3,
    "buitron": 2,
    "bujak": 2,
    "bujumbura": 4,
    "bukar": 2,
    "bukavu": 3,
    "bukavu's": 3,
    "buker": 2,
    "bukharin": 3,
    "bukovina": 4,
    "bukovsky": 3,
    "bukowski": 3,
    "bula": 2,
    "bulat": 2,
    "bulb": 1,
    "bulbous": 2,
    "bulbs": 1,
    "bulemia": 4,
    "bulemic": 3,
    "bulen": 2,
    "bulent": 2,
    "buley": 2,
    "bulfinch": 2,
    "bulfinch's": 3,
    "bulgaria": 4,
    "bulgaria's": 4,
    "bulgarian": 4,
    "bulgarians": 4,
    "bulge": 1,
    "bulged": 1,
    "bulger": 2,
    "bulges": 2,
    "bulging": 2,
    "bulgrin": 2,
    "bulimia": 4,
    "bulimic": 3,
    "bulimic(1)": 3,
    "bulin": 2,
    "bulk": 1,
    "bulkeley": 3,
    "bulkhead": 2,
    "bulkheads": 2,
    "bulkier": 3,
    "bulkley": 2,
    "bulky": 2,
    "bull": 1,
    "bull's": 1,
    "bulla": 2,
    "bullard": 2,
    "bulldog": 2,
    "bulldogs": 2,
    "bulldoze": 2,
    "bulldozed": 2,
    "bulldozer": 3,
    "bulldozers": 3,
    "bulldozes": 3,
    "bulldozing": 3,
    "bullen": 2,
    "buller": 2,
    "bullet": 2,
    "bulletin": 3,
    "bulletins": 3,
    "bulletproof": 3,
    "bullets": 2,
    "bullfight": 2,
    "bullfighter": 3,
    "bullfighting": 3,
    "bullfights": 2,
    "bullfrog": 2,
    "bullfrogs": 2,
    "bullhead": 2,
    "bullheads": 2,
    "bullhorn": 2,
    "bullhorns": 2,
    "bullied": 2,
    "bullies": 2,
    "bullinger": 3,
    "bullington": 3,
    "bullins": 2,
    "bullion": 2,
    "bullis": 2,
    "bullish": 2,
    "bullishly": 3,
    "bullishness": 3,
    "bullitt": 2,
    "bullman": 2,
    "bulloch": 2,
    "bullock": 2,
    "bullock's": 2,
    "bullocks": 2,
    "bullpen": 2,
    "bulls": 1,
    "bulls'": 1,
    "bullseye": 2,
    "bullshit": 2,
    "bulluck": 2,
    "bullwinkle": 3,
    "bully": 2,
    "bullying": 3,
    "bulman": 2,
    "bulmer": 2,
    "bulova": 3,
    "bulow": 2,
    "bulrush": 2,
    "bulson": 2,
    "bult": 1,
    "bultema": 3,
    "bulthuis": 3,
    "bultman": 2,
    "bulwark": 2,
    "bulwinkle": 3,
    "bum": 1,
    "bumann": 2,
    "bumbalough": 3,
    "bumbarger": 3,
    "bumbaugh": 2,
    "bumble": 2,
    "bumbling": 3,
    "bumbling(1)": 2,
    "bumbly": 2,
    "bumgardner": 3,
    "bumgarner": 3,
    "bumiputra": 4,
    "bummed": 1,
    "bummer": 2,
    "bump": 1,
    "bumpas": 2,
    "bumpass": 2,
    "bumped": 1,
    "bumper": 2,
    "bumpers": 2,
    "bumpersticker": 4,
    "bumperstickers": 4,
    "bumping": 2,
    "bumpings": 2,
    "bumpkin": 2,
    "bumps": 1,
    "bumpus": 2,
    "bumpy": 2,
    "bums": 1,
    "bumstead": 2,
    "bun": 1,
    "bunce": 1,
    "bunch": 1,
    "bunche": 1,
    "bunched": 1,
    "bunches": 2,
    "bunches(1)": 2,
    "bunching": 2,
    "bunchy": 2,
    "bund": 1,
    "bunda": 2,
    "bunde": 1,
    "bundesbank": 3,
    "bundesbank(1)": 3,
    "bundesbank(2)": 3,
    "bundesbank's": 3,
    "bundespost": 3,
    "bundespost's": 3,
    "bundesrat": 3,
    "bundestag": 3,
    "bundeswehr": 3,
    "bundick": 2,
    "bundle": 2,
    "bundled": 2,
    "bundles": 2,
    "bundling": 3,
    "bundling(1)": 2,
    "bundren": 3,
    "bundrick": 2,
    "bunds": 1,
    "bundschuh": 2,
    "bundy": 2,
    "bundy's": 2,
    "bundys": 2,
    "bung": 1,
    "bungalow": 3,
    "bungalows": 3,
    "bungard": 2,
    "bunge": 1,
    "bungee": 2,
    "bunger": 2,
    "bungert": 2,
    "bungey": 2,
    "bungled": 2,
    "bungler": 2,
    "bunglers": 2,
    "bungling": 3,
    "bungling(1)": 2,
    "bunk": 1,
    "bunke": 1,
    "bunker": 2,
    "bunkers": 2,
    "bunkley": 2,
    "bunks": 1,
    "bunn": 1,
    "bunnell": 2,
    "bunner": 2,
    "bunney": 2,
    "bunni": 2,
    "bunnie": 2,
    "bunnies": 2,
    "bunning": 2,
    "bunny": 2,
    "bunol": 2,
    "bunowski": 3,
    "buns": 1,
    "bunt": 1,
    "bunt's": 1,
    "buntain": 2,
    "bunte": 1,
    "bunten": 2,
    "buntin": 2,
    "bunting": 2,
    "bunton": 2,
    "buntrock": 2,
    "buntstrock": 2,
    "buntyn": 2,
    "buntz": 1,
    "bunyan": 2,
    "bunyard": 2,
    "bunzl": 2,
    "buol": 1,
    "buonanno": 3,
    "buonicontis": 4,
    "buono": 2,
    "buonocore": 4,
    "buonomo": 3,
    "buoy": 2,
    "buoyancy": 3,
    "buoyant": 2,
    "buoyed": 2,
    "buoying": 2,
    "buoys": 2,
    "bupkus": 2,
    "bupp": 1,
    "buprenorphine": 4,
    "bur": 1,
    "burack": 2,
    "burak": 2,
    "buran": 2,
    "burandt": 2,
    "buras": 2,
    "burba": 2,
    "burbach": 2,
    "burback": 2,
    "burbage": 2,
    "burbank": 2,
    "burbank's": 2,
    "burbidge": 2,
    "burble": 2,
    "burbled": 2,
    "burbles": 2,
    "burbling": 2,
    "burbridge": 2,
    "burby": 2,
    "burch": 1,
    "burcham": 2,
    "burchard": 2,
    "burchell": 2,
    "burcher": 2,
    "burchett": 2,
    "burchette": 2,
    "burchfield": 2,
    "burchill": 2,
    "burciaga": 4,
    "burck": 1,
    "burckhard": 2,
    "burckhardt": 2,
    "burd": 1,
    "burda": 2,
    "burdell": 2,
    "burden": 2,
    "burdened": 2,
    "burdening": 3,
    "burdens": 2,
    "burdensome": 3,
    "burdett": 2,
    "burdette": 2,
    "burdge": 1,
    "burdi": 2,
    "burdick": 2,
    "burdin": 2,
    "burdine": 2,
    "burdine(1)": 2,
    "burdine's": 2,
    "burdine's(1)": 2,
    "burdines": 2,
    "burdines(1)": 2,
    "burditt": 2,
    "burdo": 2,
    "burdon": 2,
    "burdsall": 2,
    "bureau": 2,
    "bureau's": 2,
    "bureaucracies": 4,
    "bureaucracy": 4,
    "bureaucracy's": 4,
    "bureaucrat": 3,
    "bureaucrat(1)": 3,
    "bureaucratese": 4,
    "bureaucratic": 4,
    "bureaucrats": 3,
    "bureaucrats(1)": 3,
    "bureaus": 2,
    "burek": 2,
    "burel": 2,
    "burell": 2,
    "buren": 2,
    "bures": 1,
    "bures(1)": 2,
    "buresh": 2,
    "burfeind": 2,
    "burfield": 2,
    "burford": 2,
    "burg": 1,
    "burgamy": 3,
    "burgan": 2,
    "burgard": 2,
    "burgdorf": 2,
    "burge": 1,
    "burgee": 2,
    "burgener": 3,
    "burgeon": 2,
    "burgeoned": 2,
    "burgeoning": 3,
    "burger": 2,
    "burger's": 2,
    "burgers": 2,
    "burgert": 2,
    "burges": 1,
    "burgeson": 3,
    "burgess": 2,
    "burget": 2,
    "burgett": 2,
    "burggraf": 2,
    "burghardt": 2,
    "burghart": 2,
    "burgher": 2,
    "burghley": 2,
    "burgin": 2,
    "burgio": 3,
    "burglar": 2,
    "burglaries": 3,
    "burglarize": 3,
    "burglarized": 3,
    "burglars": 2,
    "burglary": 3,
    "burgling": 2,
    "burgman": 2,
    "burgmaster": 3,
    "burgner": 2,
    "burgo": 2,
    "burgomaster": 4,
    "burgomaster's": 4,
    "burgomasters": 4,
    "burgoon": 2,
    "burgos": 2,
    "burgoyne": 2,
    "burgoyne's": 2,
    "burgundian": 4,
    "burgundians": 4,
    "burgundies": 3,
    "burgundy": 3,
    "burgundy's": 3,
    "burgy": 2,
    "burham": 2,
    "burhans": 2,
    "buri": 2,
    "burial": 3,
    "burials": 3,
    "burian": 3,
    "burich": 2,
    "buried": 2,
    "buries": 2,
    "burk": 1,
    "burkard": 2,
    "burkart": 2,
    "burke": 1,
    "burke's": 1,
    "burkeen": 2,
    "burkel": 2,
    "burkemper": 3,
    "burkert": 2,
    "burkes": 1,
    "burket": 2,
    "burkett": 2,
    "burkey": 2,
    "burkhalter": 3,
    "burkhammer": 3,
    "burkhard": 2,
    "burkhardt": 2,
    "burkhart": 2,
    "burkhead": 2,
    "burkholder": 3,
    "burkina": 3,
    "burkina's": 3,
    "burkina-faso": 5,
    "burkina-faso's": 5,
    "burkins": 2,
    "burkitt": 2,
    "burkland": 2,
    "burkle": 2,
    "burkley": 2,
    "burklow": 2,
    "burklund": 2,
    "burkman": 2,
    "burks": 1,
    "burkus": 2,
    "burl": 1,
    "burland": 2,
    "burlap": 2,
    "burlapped": 2,
    "burlatsky": 3,
    "burleigh": 2,
    "burleson": 3,
    "burleson(1)": 2,
    "burlesque": 2,
    "burlew": 2,
    "burley": 2,
    "burling": 2,
    "burlingame": 3,
    "burlingham": 3,
    "burlington": 3,
    "burlington's": 3,
    "burlison": 3,
    "burly": 2,
    "burma": 2,
    "burma's": 2,
    "burmah": 2,
    "burman": 2,
    "burmans": 2,
    "burmaster": 3,
    "burmeister": 3,
    "burmese": 2,
    "burmester": 3,
    "burn": 1,
    "burnable": 3,
    "burnaby": 3,
    "burnam": 2,
    "burnap": 2,
    "burnard": 2,
    "burndy": 2,
    "burne": 1,
    "burned": 1,
    "burnell": 2,
    "burner": 2,
    "burners": 2,
    "burnes": 1,
    "burness": 2,
    "burnet": 2,
    "burnett": 2,
    "burnett's": 2,
    "burnette": 2,
    "burney": 2,
    "burnham": 2,
    "burnham(1)": 2,
    "burnham's": 2,
    "burnham's(1)": 2,
    "burning": 2,
    "burningham": 3,
    "burnings": 2,
    "burnish": 2,
    "burnished": 2,
    "burnley": 2,
    "burnley's": 2,
    "burnout": 2,
    "burns": 1,
    "burns'": 1,
    "burns's": 2,
    "burnsed": 1,
    "burnside": 2,
    "burnside's": 2,
    "burnstein": 2,
    "burnstein(1)": 2,
    "burnsworth": 2,
    "burnt": 1,
    "burnup": 2,
    "burnworth": 2,
    "buroker": 3,
    "burow": 2,
    "burp": 1,
    "burpee": 2,
    "burpees": 2,
    "burping": 2,
    "burpo": 2,
    "burr": 1,
    "burrage": 2,
    "burrell": 2,
    "burrell's": 2,
    "burrer": 2,
    "burres": 1,
    "burress": 2,
    "burri": 2,
    "burridge": 2,
    "burrier": 3,
    "burright": 2,
    "burrill": 2,
    "burrington": 3,
    "burris": 2,
    "burriss": 3,
    "burrito": 3,
    "burritos": 3,
    "burritt": 2,
    "burro": 2,
    "burrola": 3,
    "burros": 2,
    "burrough": 2,
    "burroughs": 2,
    "burroughs(1)": 2,
    "burrous": 2,
    "burrow": 2,
    "burrower": 3,
    "burrowers": 3,
    "burrowes": 2,
    "burrowing": 3,
    "burrows": 2,
    "burrus": 2,
    "burruss": 2,
    "burry": 2,
    "bursch": 1,
    "burse": 1,
    "bursey": 2,
    "bursley": 2,
    "burson": 2,
    "burst": 1,
    "burstein": 2,
    "burstein(1)": 2,
    "bursting": 2,
    "burston": 2,
    "bursts": 1,
    "burt": 1,
    "burtch": 1,
    "burtis": 2,
    "burtner": 2,
    "burtness": 2,
    "burtnett": 2,
    "burton": 2,
    "burton's": 2,
    "burts": 1,
    "burtt": 1,
    "burundi": 3,
    "burundi's": 3,
    "burwell": 2,
    "burwick": 2,
    "bury": 2,
    "bury's": 2,
    "burying": 3,
    "burzynski": 3,
    "bus": 1,
    "busa": 2,
    "busalacchi": 4,
    "busam": 2,
    "busbee": 2,
    "busbey": 2,
    "busbin": 2,
    "busboom": 2,
    "busboy": 2,
    "busboys": 2,
    "busby": 2,
    "buscaglia": 4,
    "buscemi": 3,
    "busch": 1,
    "busch's": 2,
    "buschbaum": 2,
    "busche": 1,
    "buscher": 2,
    "buschman": 2,
    "buschmann": 2,
    "buse": 1,
    "bused": 1,
    "buseman": 2,
    "busenbark": 3,
    "buser": 2,
    "buses": 2,
    "busey": 2,
    "busey(1)": 2,
    "bush": 1,
    "bush's": 2,
    "busha": 2,
    "bushard": 2,
    "bushart": 2,
    "bushaw": 2,
    "bushby": 2,
    "bushee": 2,
    "bushel": 2,
    "bushell": 2,
    "bushels": 2,
    "busher": 2,
    "bushes": 2,
    "bushey": 2,
    "bushings": 2,
    "bushkin": 2,
    "bushman": 2,
    "bushmen": 2,
    "bushnell": 2,
    "bushong": 2,
    "bushway": 2,
    "bushwhack": 2,
    "bushwhacked": 2,
    "bushwhacking": 3,
    "bushwhacks": 2,
    "bushy": 2,
    "busic": 2,
    "busick": 2,
    "busied": 2,
    "busier": 3,
    "busiest": 3,
    "busily": 3,
    "business": 2,
    "business(1)": 2,
    "business'": 2,
    "business'(1)": 2,
    "business's": 3,
    "businesses": 3,
    "businesses(1)": 3,
    "businesses'": 3,
    "businessland": 3,
    "businesslike": 3,
    "businessman": 3,
    "businessman(1)": 3,
    "businessman's": 3,
    "businessmen": 3,
    "businesspeople": 4,
    "businessperson": 4,
    "businessphone": 3,
    "businessphones": 3,
    "businesswoman": 4,
    "businesswomen": 4,
    "busing": 2,
    "busk": 1,
    "buske": 1,
    "busker": 2,
    "busker's": 2,
    "buskey": 2,
    "buskirk": 2,
    "buslease": 2,
    "busler": 3,
    "busler(1)": 2,
    "busload": 2,
    "busloads": 2,
    "buspar": 2,
    "buss": 1,
    "bussa": 2,
    "bussard": 2,
    "busse": 1,
    "bussed": 1,
    "bussell": 2,
    "bussen": 2,
    "busser": 2,
    "bussert": 2,
    "busses": 2,
    "bussey": 2,
    "bussi": 2,
    "bussi(1)": 2,
    "bussie": 2,
    "bussie(1)": 2,
    "bussiere": 3,
    "bussing": 2,
    "bussinger": 3,
    "bussman": 2,
    "bust": 1,
    "busta": 2,
    "bustamante": 4,
    "bustard": 2,
    "busted": 2,
    "buster": 2,
    "busters": 2,
    "busti": 2,
    "bustier": 2,
    "bustillo": 3,
    "bustillos": 3,
    "bustin": 2,
    "busting": 2,
    "bustle": 2,
    "bustling": 3,
    "bustling(1)": 2,
    "busto": 2,
    "bustos": 2,
    "busts": 1,
    "busty": 2,
    "busulaki": 4,
    "buswell": 2,
    "busy": 2,
    "but": 1,
    "but's": 1,
    "butala": 3,
    "butane": 2,
    "butane(1)": 2,
    "butare": 3,
    "butare(1)": 3,
    "butare's": 3,
    "butare's(1)": 3,
    "butch": 1,
    "butchart": 2,
    "butcher": 2,
    "butcher's": 2,
    "butchered": 2,
    "butchering": 3,
    "butchers": 2,
    "butchery": 3,
    "butchko": 2,
    "butchko(1)": 2,
    "bute": 1,
    "buteau": 2,
    "buteco": 3,
    "butenhoff": 3,
    "butera": 3,
    "buterbaugh": 3,
    "buth": 1,
    "buthelezi": 4,
    "buthelezi's": 4,
    "butka": 2,
    "butkiewicz": 3,
    "butkovich": 3,
    "butkus": 2,
    "butler": 2,
    "butler's": 2,
    "butlers": 2,
    "butman": 2,
    "butner": 2,
    "butorac": 3,
    "butrick": 2,
    "butros": 2,
    "butros(1)": 2,
    "buts": 1,
    "butsch": 1,
    "butson": 2,
    "butt": 1,
    "buttacavoli": 5,
    "buttafuoco": 4,
    "buttafuoco's": 4,
    "buttars": 2,
    "butte": 1,
    "butter": 2,
    "butterball": 3,
    "butterballs": 3,
    "butterbaugh": 3,
    "buttercup": 3,
    "buttercups": 3,
    "buttered": 2,
    "butterfat": 3,
    "butterfield": 3,
    "butterfields": 3,
    "butterflies": 3,
    "butterfly": 3,
    "butterfly's": 3,
    "butterick": 3,
    "butterick's": 3,
    "buttering": 3,
    "buttermilk": 3,
    "buttermore": 3,
    "butters": 2,
    "butterscotch": 3,
    "butterworth": 3,
    "buttery": 3,
    "butthead": 2,
    "butting": 2,
    "buttitta": 3,
    "buttke": 2,
    "buttler": 2,
    "buttner": 2,
    "buttock": 2,
    "buttocks": 2,
    "button": 2,
    "buttoned": 2,
    "buttonhole": 3,
    "buttonholed": 3,
    "buttonholes": 3,
    "buttons": 2,
    "buttonville": 3,
    "buttram": 2,
    "buttress": 2,
    "buttressed": 2,
    "buttresses": 3,
    "buttresses(1)": 3,
    "buttressing": 3,
    "buttrey": 2,
    "buttrick": 2,
    "buttrum": 2,
    "buttry": 2,
    "butts": 1,
    "butulesi": 4,
    "butulesi's": 4,
    "butyl": 2,
    "butz": 1,
    "butzberger": 3,
    "butzen": 2,
    "butzer": 2,
    "butzin": 2,
    "buus": 1,
    "buxbaum": 2,
    "buxom": 2,
    "buxton": 2,
    "buy": 1,
    "buy's": 1,
    "buyback": 2,
    "buybacks": 2,
    "buyer": 2,
    "buyer's": 2,
    "buyers": 2,
    "buyers'": 2,
    "buying": 2,
    "buyout": 2,
    "buyouts": 2,
    "buys": 1,
    "buysse": 1,
    "buza": 2,
    "buzan": 2,
    "buzard": 2,
    "buzbee": 2,
    "buzby": 2,
    "buzek": 2,
    "buzz": 1,
    "buzzard": 2,
    "buzzard's": 2,
    "buzzards": 2,
    "buzze": 1,
    "buzze(1)": 2,
    "buzzed": 1,
    "buzzell": 2,
    "buzzelli": 3,
    "buzzer": 2,
    "buzzes": 2,
    "buzzetta": 3,
    "buzzing": 2,
    "buzzword": 2,
    "buzzwords": 2,
    "buzzy": 2,
    "buzzy's": 2,
    "by": 1,
    "byam": 2,
    "byard": 1,
    "byard(1)": 2,
    "byars": 2,
    "byas": 2,
    "byassee": 3,
    "bybee": 2,
    "bye": 1,
    "bye-bye": 2,
    "byelorussia": 5,
    "byelorussia(1)": 4,
    "byelorussia(2)": 5,
    "byer": 2,
    "byerlein": 2,
    "byerley": 3,
    "byerly": 3,
    "byers": 2,
    "byers'": 2,
    "byfield": 2,
    "byford": 2,
    "bygone": 2,
    "bygones": 2,
    "byham": 2,
    "byington": 3,
    "byker": 2,
    "bykowski": 3,
    "byland": 2,
    "bylaw": 2,
    "bylaws": 2,
    "byler": 2,
    "byles": 1,
    "byline": 2,
    "bylines": 2,
    "bylsma": 2,
    "bylund": 2,
    "byner": 2,
    "bynes": 1,
    "bynoe": 2,
    "bynum": 2,
    "bypass": 2,
    "bypassed": 2,
    "bypasses": 3,
    "bypassing": 3,
    "byproduct": 3,
    "byproducts": 3,
    "byram": 2,
    "byrd": 1,
    "byrd's": 1,
    "byrer": 2,
    "byrge": 1,
    "byrle": 2,
    "byrn": 1,
    "byrne": 1,
    "byrne's": 1,
    "byrnes": 1,
    "byrns": 1,
    "byrom": 2,
    "byron": 2,
    "byron's": 2,
    "byrum": 2,
    "bystander": 3,
    "bystanders": 3,
    "bystrom": 2,
    "byte": 1,
    "bytes": 1,
    "byu": 3,
    "byun": 1,
    "byus": 2,
    "bywater": 3,
    "byway": 2,
    "byways": 2,
    "byword": 2,
    "byzantine": 3,
    "byzantine(1)": 3,
    "byzantium": 4,
    "c": 1,
    "c'est": 1,
    "c'est(1)": 1,
    "c'mon": 2,
    "c's": 1,
    "c-code": 2,
    "c-codes": 2,
    "c-span": 2,
    "c-span's": 2,
    "c.": 1,
    "c.'s": 1,
    "c.d.s": 2,
    "c.o.d.": 3,
    "c.s": 1,
    "c1": 2,
    "c2": 2,
    "c3": 2,
    "c4": 2,
    "c5": 2,
    "ca": 1,
    "ca(1)": 2,
    "ca(2)": 1,
    "caan": 1,
    "cab": 1,
    "cab's": 1,
    "caba": 2,
    "cabal": 2,
    "caballero": 4,
    "caban": 2,
    "cabana": 3,
    "cabanas": 3,
    "cabaniss": 3,
    "cabaret": 3,
    "cabarets": 3,
    "cabbage": 2,
    "cabbage(1)": 2,
    "cabbages": 3,
    "cabbie": 2,
    "cabbies": 2,
    "cabby": 2,
    "cabdriver": 3,
    "cabdrivers": 3,
    "cabe": 1,
    "cabell": 2,
    "cabello": 3,
    "cabernet": 3,
    "cabernets": 3,
    "cabernets(1)": 3,
    "cabey": 2,
    "cabezas": 3,
    "cabin": 2,
    "cabinda": 3,
    "cabiness": 3,
    "cabinet": 3,
    "cabinet(1)": 2,
    "cabinet's": 2,
    "cabinetry": 3,
    "cabinets": 3,
    "cabinets(1)": 2,
    "cabins": 2,
    "cable": 2,
    "cable's": 2,
    "cablec": 2,
    "cablec(1)": 3,
    "cablec(2)": 2,
    "cablecomm": 3,
    "cablecomms": 3,
    "cabled": 2,
    "cablegram": 3,
    "cableone": 3,
    "cabler": 3,
    "cabler(1)": 2,
    "cables": 2,
    "cablesystem": 4,
    "cablesystems": 4,
    "cabletron": 3,
    "cabletron's": 3,
    "cablevision": 4,
    "cablevision's": 4,
    "cabo": 2,
    "cabo(1)": 4,
    "cabok": 2,
    "caboodle": 3,
    "caboose": 2,
    "cabooses": 3,
    "cabot": 2,
    "cabot's": 2,
    "cabotage": 3,
    "cabral": 2,
    "cabrales": 3,
    "cabrall": 2,
    "cabrall's": 2,
    "cabranes": 2,
    "cabrera": 3,
    "cabrini": 3,
    "cabrini's": 3,
    "cabriolet": 4,
    "cabriolet(1)": 4,
    "cabs": 1,
    "cac": 1,
    "cac(1)": 3,
    "cac's": 1,
    "cacace": 2,
    "cacaci": 3,
    "cacao": 3,
    "caccamise": 3,
    "caccamo": 3,
    "caccavale": 4,
    "caccia": 2,
    "cacciatore": 4,
    "cacciola": 3,
    "caceres": 3,
    "cache": 1,
    "cache(1)": 2,
    "cached": 1,
    "caches": 2,
    "caches(1)": 2,
    "cachet": 2,
    "caching": 2,
    "cacho": 2,
    "cacioppo": 3,
    "cacique": 2,
    "cackle": 2,
    "cackling": 3,
    "cackling(1)": 2,
    "cacld": 2,
    "cacld(1)": 5,
    "cacophony": 4,
    "cacti": 2,
    "cacti(1)": 2,
    "cactus": 2,
    "cad": 1,
    "cada": 2,
    "cadam": 2,
    "cadaver": 3,
    "cadavers": 3,
    "cadbury": 3,
    "cadbury's": 3,
    "cadby": 2,
    "caddell": 2,
    "cadden": 2,
    "caddick": 2,
    "caddies": 2,
    "caddock": 2,
    "caddy": 2,
    "caddyshack": 3,
    "cade": 1,
    "cadell": 2,
    "cadena": 3,
    "cadence": 2,
    "cadences": 3,
    "cadenhead": 3,
    "cadet": 2,
    "cadets": 2,
    "cadiddlehopper": 5,
    "cadieux": 3,
    "cadillac": 3,
    "cadillac's": 3,
    "cadillacs": 3,
    "cadiz": 2,
    "cadle": 2,
    "cadman": 2,
    "cadmium": 3,
    "cadmus": 2,
    "cadnetix": 3,
    "cadogan": 3,
    "cadorette": 3,
    "cadotte": 2,
    "cadre": 2,
    "cadres": 2,
    "cadrone": 2,
    "cadrone(1)": 3,
    "cads": 1,
    "cadwalader": 4,
    "cadwalader's": 4,
    "cadwallader": 4,
    "cadwell": 2,
    "cady": 2,
    "caen": 1,
    "caen(1)": 1,
    "caen's": 1,
    "caen's(1)": 1,
    "caesar": 2,
    "caesar's": 2,
    "caesarea": 4,
    "caesarean": 3,
    "caesareans": 3,
    "caesars": 2,
    "caesars'": 2,
    "caetano": 3,
    "cafarella": 4,
    "cafarelli": 4,
    "cafaro": 3,
    "cafe": 2,
    "cafe(1)": 2,
    "cafes": 2,
    "cafeteria": 5,
    "cafeterias": 5,
    "cafetizer": 4,
    "caffee": 2,
    "caffeinate": 3,
    "caffeinated": 4,
    "caffeine": 2,
    "cafferty": 3,
    "caffery": 3,
    "caffey": 2,
    "caffrey": 2,
    "cafiero": 4,
    "caftan": 2,
    "caftans": 2,
    "cagan": 2,
    "cage": 1,
    "cage's": 2,
    "caged": 1,
    "cages": 2,
    "cagey": 2,
    "caggiano": 4,
    "cagle": 2,
    "cagley": 2,
    "cagliari": 4,
    "cagney": 2,
    "caguas": 2,
    "cahalan": 3,
    "cahall": 2,
    "cahan": 2,
    "cahasa": 3,
    "cahill": 2,
    "cahn": 1,
    "cahners": 2,
    "cahoon": 2,
    "cahoot": 2,
    "cahoots": 2,
    "cahora": 3,
    "cahouet": 2,
    "cai": 1,
    "caiazzo": 3,
    "caicedo": 3,
    "cail": 1,
    "caillebotte": 2,
    "caillier": 3,
    "caillouet": 2,
    "cain": 1,
    "cain's": 1,
    "caine": 1,
    "caines": 1,
    "caiola": 3,
    "caire": 1,
    "cairn": 1,
    "cairnes": 1,
    "cairns": 1,
    "cairo": 2,
    "cairo's": 2,
    "caison": 2,
    "caisse": 1,
    "caissie": 2,
    "caisson": 2,
    "caisson(1)": 2,
    "caissons": 2,
    "caissons(1)": 2,
    "caitlin": 2,
    "caito": 2,
    "cajole": 2,
    "cajoled": 2,
    "cajoling": 3,
    "cajun": 2,
    "cajuns": 2,
    "cake": 1,
    "cake's": 1,
    "caked": 1,
    "cakes": 1,
    "cal": 1,
    "cala": 2,
    "calabasas": 4,
    "calabrese": 4,
    "calabria": 4,
    "calabro": 3,
    "caladiums": 4,
    "calaf": 2,
    "calahan": 3,
    "calais": 2,
    "calamander": 4,
    "calamari": 4,
    "calame": 3,
    "calamia": 4,
    "calamine": 3,
    "calamine's": 3,
    "calamities": 4,
    "calamitous": 4,
    "calamity": 4,
    "calamity(1)": 4,
    "calan": 2,
    "calandra": 3,
    "calandro": 3,
    "calantha": 3,
    "calarco": 3,
    "calaveras": 4,
    "calaway": 3,
    "calbert": 2,
    "calbos": 2,
    "calcagni": 3,
    "calcagno": 3,
    "calcaterra": 4,
    "calcified": 3,
    "calcify": 3,
    "calcite": 2,
    "calcium": 3,
    "calcomp": 2,
    "calcote": 3,
    "calculate": 3,
    "calculated": 4,
    "calculated(1)": 4,
    "calculates": 3,
    "calculating": 4,
    "calculation": 4,
    "calculations": 4,
    "calculator": 4,
    "calculators": 4,
    "calculus": 3,
    "calcutt": 2,
    "calcutta": 3,
    "caldeira": 3,
    "calder": 2,
    "caldera": 3,
    "caldera(1)": 3,
    "calderaro": 4,
    "calderon": 3,
    "calderon(1)": 3,
    "calderone": 4,
    "calderwood": 3,
    "caldor": 2,
    "caldrello": 3,
    "caldwell": 2,
    "caldwell's": 2,
    "cale": 1,
    "caleb": 2,
    "calebs": 2,
    "caleca": 3,
    "caledonia": 5,
    "caledonian": 5,
    "caledonian's": 5,
    "calef": 2,
    "calemburg": 3,
    "calendar": 3,
    "calendars": 3,
    "calendula": 4,
    "caler": 2,
    "calero": 3,
    "cales": 1,
    "caley": 2,
    "calf": 1,
    "calf's": 1,
    "calfed": 1,
    "calfed(1)": 2,
    "calfed's": 2,
    "calfee": 2,
    "calgary": 3,
    "calgene": 2,
    "calgene's": 2,
    "calgon": 2,
    "calgroup": 2,
    "calhoon": 2,
    "calhoun": 2,
    "cali": 2,
    "cali(1)": 2,
    "calia": 3,
    "caliber": 3,
    "calibrate": 3,
    "calibrated": 4,
    "calibration": 4,
    "calico": 3,
    "calida": 3,
    "caliendo": 4,
    "calif": 2,
    "califano": 4,
    "califf": 2,
    "california": 4,
    "california's": 4,
    "californian": 4,
    "californian's": 4,
    "californians": 4,
    "caligiuri": 4,
    "calill": 2,
    "calills": 2,
    "caliper": 3,
    "calipers": 3,
    "caliph": 2,
    "caliri": 3,
    "calise": 2,
    "calista": 3,
    "calisthenic": 4,
    "calisthenics": 4,
    "calite": 2,
    "calite(1)": 2,
    "calix": 2,
    "calix(1)": 2,
    "calk": 1,
    "calkin": 2,
    "calkins": 2,
    "call": 1,
    "call's": 1,
    "call's(1)": 1,
    "calla": 2,
    "callable": 3,
    "callace": 2,
    "callaghan": 3,
    "callaham": 3,
    "callahan": 3,
    "callahan's": 3,
    "callais": 2,
    "callan": 2,
    "callanan": 3,
    "calland": 2,
    "callander": 3,
    "callari": 3,
    "callas": 2,
    "callaway": 3,
    "callaway's": 3,
    "calle": 1,
    "callebs": 2,
    "called": 1,
    "callegari": 4,
    "calleja": 3,
    "callejas": 3,
    "callen": 2,
    "callender": 3,
    "callens": 2,
    "caller": 2,
    "caller's": 2,
    "callers": 2,
    "callery": 3,
    "calles": 1,
    "calley": 2,
    "callicoat": 3,
    "callicott": 3,
    "callicutt": 3,
    "callie": 2,
    "callier": 3,
    "callies": 2,
    "calligan": 3,
    "calligrapher": 4,
    "calligraphic": 4,
    "calligraphy": 4,
    "callihan": 3,
    "callinan": 3,
    "calling": 2,
    "calliope": 4,
    "calliopes": 4,
    "callis": 2,
    "callison": 3,
    "callister": 3,
    "callous": 2,
    "calloused": 2,
    "callously": 3,
    "callousness": 3,
    "callow": 2,
    "calloway": 3,
    "calls": 1,
    "callula": 3,
    "callum": 2,
    "callus": 2,
    "cally": 2,
    "calm": 1,
    "calm(1)": 1,
    "calma": 2,
    "calmaquip": 3,
    "calmar": 2,
    "calmark": 2,
    "calmart": 2,
    "calmart(1)": 2,
    "calmart's": 2,
    "calmart's(1)": 2,
    "calmat": 2,
    "calmat's": 2,
    "calmed": 1,
    "calmed(1)": 1,
    "calmer": 2,
    "calmer(1)": 2,
    "calmes": 2,
    "calmest": 2,
    "calmest(1)": 2,
    "calming": 2,
    "calming(1)": 2,
    "calmly": 2,
    "calmly(1)": 2,
    "calmness": 2,
    "calmness(1)": 2,
    "calms": 1,
    "calms(1)": 1,
    "calnan": 2,
    "calny": 2,
    "calo": 2,
    "calogero": 4,
    "calor": 2,
    "caloric": 3,
    "calorie": 3,
    "calories": 3,
    "caloway": 3,
    "calpers": 2,
    "calpers's": 3,
    "calpis": 2,
    "caltabiano": 5,
    "caltagirone": 5,
    "caltex": 2,
    "caltha": 2,
    "calton": 2,
    "caltrans": 2,
    "calumet": 3,
    "calumny": 3,
    "calutzi": 3,
    "caluzu": 3,
    "caluzzi": 3,
    "calvani": 3,
    "calvano": 3,
    "calvaries": 3,
    "calvary": 3,
    "calveras": 3,
    "calverley": 3,
    "calvert": 2,
    "calvery": 3,
    "calves": 1,
    "calvet": 2,
    "calvey": 2,
    "calvi": 2,
    "calvillo": 3,
    "calvin": 2,
    "calvin(1)": 2,
    "calvin's": 2,
    "calvin's(1)": 2,
    "calvina": 3,
    "calving": 2,
    "calvinist": 3,
    "calvinist(1)": 3,
    "calvino": 3,
    "calvo": 2,
    "calypso": 3,
    "calypsos": 3,
    "calyx": 2,
    "calzada": 3,
    "cam": 1,
    "cam's": 1,
    "cama": 2,
    "cama(1)": 4,
    "camacho": 3,
    "camaguey": 3,
    "camaguey(1)": 3,
    "caman": 2,
    "camara": 3,
    "camaraderie": 5,
    "camarata": 4,
    "camarena": 4,
    "camarena(1)": 4,
    "camargo": 3,
    "camarillo": 4,
    "camaro": 3,
    "camaros": 3,
    "cambell": 2,
    "camber": 2,
    "cambex": 2,
    "cambior": 3,
    "cambodia": 4,
    "cambodia's": 4,
    "cambodian": 4,
    "cambodians": 4,
    "cambra": 2,
    "cambre": 2,
    "cambria": 3,
    "cambrian": 3,
    "cambrian's": 3,
    "cambridge": 2,
    "cambridgeport": 3,
    "cambridgeside": 3,
    "cambron": 2,
    "camburn": 2,
    "camby": 2,
    "camby's": 2,
    "camco": 2,
    "camcorder": 3,
    "camcorders": 3,
    "camden": 2,
    "camden's": 2,
    "camdessus": 3,
    "came": 1,
    "cameco": 3,
    "camejo": 3,
    "camel": 2,
    "camel's": 2,
    "camelot": 3,
    "camels": 2,
    "cameo": 3,
    "cameos": 3,
    "camera": 3,
    "camera(1)": 2,
    "camera's": 2,
    "cameraman": 4,
    "cameramen": 4,
    "cameras": 3,
    "cameras(1)": 2,
    "camerer": 3,
    "camero": 3,
    "cameron": 3,
    "cameron's": 3,
    "camerons": 3,
    "cameroon": 3,
    "camfield": 2,
    "camhi": 2,
    "camilla": 3,
    "camille": 2,
    "camilleri": 4,
    "camilli": 3,
    "camillo": 3,
    "caminiti": 4,
    "camino": 3,
    "camire": 3,
    "camm": 1,
    "cammack": 2,
    "cammarano": 4,
    "cammarata": 4,
    "cammarota": 4,
    "cammer": 2,
    "cammermeyer": 4,
    "cammie": 2,
    "cammisa": 3,
    "cammon": 2,
    "cammy": 2,
    "camorra": 3,
    "camouflage": 3,
    "camouflaged": 3,
    "camouflaging": 4,
    "camp": 1,
    "camp's": 1,
    "campa": 2,
    "campaign": 2,
    "campaign's": 2,
    "campaigned": 2,
    "campaigner": 3,
    "campaigners": 3,
    "campaigning": 3,
    "campaigns": 2,
    "campana": 3,
    "campanale": 4,
    "campanaro": 4,
    "campanella": 4,
    "campanelli": 4,
    "campanis": 3,
    "campau": 2,
    "campbell": 2,
    "campbell's": 2,
    "campbells": 2,
    "campeau": 2,
    "campeau's": 2,
    "camped": 1,
    "campen": 2,
    "camper": 2,
    "campers": 2,
    "campesinos": 4,
    "campfield": 2,
    "campfire": 3,
    "campfires": 3,
    "campground": 2,
    "campgrounds": 2,
    "campi": 2,
    "camping": 2,
    "campion": 3,
    "campione": 4,
    "campise": 2,
    "campisi": 3,
    "campo": 2,
    "campobasso": 4,
    "campofrio": 4,
    "campoli": 3,
    "campopiano": 5,
    "campos": 2,
    "camps": 1,
    "camps'": 1,
    "campsite": 2,
    "campsites": 2,
    "campton": 2,
    "campus": 2,
    "campuses": 3,
    "campuses(1)": 3,
    "campuzano": 4,
    "campy": 2,
    "camro": 2,
    "camry": 2,
    "camrys": 2,
    "camshaft": 2,
    "camshafts": 2,
    "camus": 2,
    "camuso": 3,
    "can": 1,
    "can(1)": 1,
    "can's": 1,
    "can't": 1,
    "cana": 2,
    "canaan": 2,
    "canaanite": 3,
    "canace": 3,
    "canada": 3,
    "canada's": 3,
    "canadair": 3,
    "canaday": 3,
    "canadian": 4,
    "canadian's": 4,
    "canadians": 4,
    "canadians'": 4,
    "canadienne": 4,
    "canady": 3,
    "canal": 2,
    "canal's": 2,
    "canale": 3,
    "canales": 2,
    "canals": 2,
    "canam": 2,
    "canan": 2,
    "canandaigua": 4,
    "cananea": 4,
    "canard": 2,
    "canariensis": 5,
    "canaries": 3,
    "canary": 3,
    "canas": 2,
    "canasta": 3,
    "canavan": 3,
    "canaveral": 4,
    "canaveral(1)": 3,
    "canberra": 3,
    "canby": 2,
    "cancan": 2,
    "cancel": 2,
    "canceled": 2,
    "canceling": 3,
    "canceling(1)": 2,
    "cancellation": 4,
    "cancellations": 4,
    "cancelled": 2,
    "cancelling": 3,
    "cancelling(1)": 2,
    "cancels": 2,
    "cancer": 2,
    "cancer's": 2,
    "cancerous": 3,
    "cancerphobia": 5,
    "cancers": 2,
    "canchola": 3,
    "cancienne": 3,
    "cancilla": 3,
    "cancino": 3,
    "cancio": 3,
    "cancom": 2,
    "cancro": 2,
    "cancun": 2,
    "cancun(1)": 2,
    "candace": 2,
    "candee": 2,
    "candela": 3,
    "candelabra": 4,
    "candelaria": 5,
    "candelario": 5,
    "candella": 3,
    "candellin": 3,
    "candia": 3,
    "candice": 2,
    "candice's": 3,
    "candid": 2,
    "candid(1)": 2,
    "candida": 3,
    "candidacies": 4,
    "candidacy": 4,
    "candidate": 3,
    "candidate(1)": 3,
    "candidate's": 3,
    "candidates": 3,
    "candidates(1)": 3,
    "candidates'": 3,
    "candidly": 3,
    "candido": 3,
    "candie": 2,
    "candied": 2,
    "candies": 2,
    "candilin": 3,
    "candiotti": 4,
    "candiotti's": 4,
    "candle": 2,
    "candlelight": 3,
    "candlemaker": 4,
    "candler": 3,
    "candler(1)": 2,
    "candles": 2,
    "candlestick": 3,
    "candlesticks": 3,
    "candlish": 2,
    "candor": 2,
    "candy": 2,
    "candy's": 2,
    "candyman": 3,
    "cane": 1,
    "caned": 1,
    "canedo": 3,
    "canedy": 3,
    "canelo": 3,
    "canepa": 3,
    "canes": 1,
    "canevari": 4,
    "canez": 2,
    "canfield": 2,
    "canfor": 2,
    "canfor's": 2,
    "cangelosi": 4,
    "cangemi": 3,
    "cangialosi": 4,
    "cangiano": 4,
    "canham": 2,
    "canida": 3,
    "caniglia": 4,
    "canilles": 3,
    "canin": 2,
    "canine": 2,
    "canines": 2,
    "caning": 2,
    "canings": 2,
    "canino": 3,
    "canion": 2,
    "canipe": 3,
    "canister": 3,
    "canister(1)": 3,
    "canisters": 3,
    "canisters(1)": 3,
    "canker": 2,
    "cankers": 2,
    "cann": 1,
    "cannabis": 3,
    "cannaday": 3,
    "cannady": 3,
    "cannan": 2,
    "cannata": 3,
    "cannavino": 4,
    "cannavo": 3,
    "canned": 1,
    "cannedy": 3,
    "cannell": 2,
    "cannella": 3,
    "cannelton": 3,
    "canner": 2,
    "canneries": 3,
    "cannery": 3,
    "cannes": 1,
    "cannes(1)": 1,
    "canney": 2,
    "cannibal": 3,
    "cannibalism": 5,
    "cannibalization": 6,
    "cannibalize": 4,
    "cannibalizing": 5,
    "cannibals": 3,
    "canniff": 2,
    "canning": 2,
    "cannister": 3,
    "cannisters": 3,
    "cannistraro": 4,
    "cannizzaro": 4,
    "cannizzo": 3,
    "cannon": 2,
    "cannon's": 2,
    "cannonball": 3,
    "cannondale": 3,
    "cannone": 3,
    "cannons": 2,
    "cannonsburg": 3,
    "cannot": 2,
    "cannot(1)": 2,
    "canny": 2,
    "cano": 2,
    "canoe": 2,
    "canoed": 2,
    "canoeing": 3,
    "canoeist": 3,
    "canoes": 2,
    "canoga": 3,
    "canola": 3,
    "canon": 2,
    "canon's": 2,
    "canonic": 3,
    "canonical": 4,
    "canonico": 4,
    "canonie": 3,
    "canonization": 5,
    "canonize": 3,
    "canonized": 3,
    "canons": 2,
    "canopy": 3,
    "canosa": 3,
    "canova": 3,
    "canoy": 2,
    "canrad": 2,
    "canron": 2,
    "cans": 1,
    "canseco": 3,
    "cansler": 3,
    "cansler(1)": 2,
    "canso": 2,
    "canson": 2,
    "canstar": 2,
    "cant": 1,
    "cantaloupe": 3,
    "cantaloupes": 3,
    "cantalupo": 4,
    "cantankerous": 4,
    "cantara": 3,
    "cantata": 3,
    "canteen": 2,
    "canteens": 2,
    "cantel": 2,
    "canter": 2,
    "canterbury": 4,
    "canterbury's": 4,
    "canterbury's(1)": 4,
    "cantero": 3,
    "canterra": 3,
    "cantey": 2,
    "cantin": 2,
    "cantina": 3,
    "cantle": 2,
    "cantley": 2,
    "cantlin": 2,
    "cantlon": 2,
    "canto": 2,
    "canton": 2,
    "cantonal": 3,
    "cantone": 3,
    "cantonese": 3,
    "cantons": 2,
    "cantor": 2,
    "cantor's": 2,
    "cantore": 2,
    "cantors": 2,
    "cantrall": 2,
    "cantrell": 2,
    "cantrelle": 2,
    "cantu": 2,
    "cantv": 3,
    "cantwell": 2,
    "canty": 2,
    "canuck": 2,
    "canuck(1)": 2,
    "canucks": 2,
    "canucks(1)": 2,
    "canup": 2,
    "canupp": 2,
    "canvas": 2,
    "canvases": 3,
    "canvass": 2,
    "canvassed": 2,
    "canvassers": 3,
    "canvasses": 3,
    "canvassing": 3,
    "canwest": 2,
    "canyon": 2,
    "canyon's": 2,
    "canyons": 2,
    "canzano": 3,
    "canzoneri": 4,
    "cao": 1,
    "caouette": 2,
    "cap": 1,
    "cap's": 1,
    "capabilities": 5,
    "capability": 5,
    "capable": 3,
    "capacious": 3,
    "capacitance": 4,
    "capacities": 4,
    "capacities(1)": 4,
    "capacitor": 4,
    "capacitors": 4,
    "capacitors(1)": 4,
    "capacity": 4,
    "capacity(1)": 4,
    "capalbo": 3,
    "capaldi": 3,
    "capaldo": 3,
    "capano": 3,
    "capasso": 3,
    "capcha": 2,
    "capcom": 2,
    "cape": 1,
    "cape-town": 2,
    "capece": 2,
    "capeci": 3,
    "capeci(1)": 3,
    "caped": 1,
    "capehart": 2,
    "capek": 2,
    "capel": 2,
    "capel's": 2,
    "capell": 2,
    "capella": 3,
    "capelle": 2,
    "capelli": 3,
    "capello": 3,
    "capen": 2,
    "caper": 2,
    "capernaum": 4,
    "capers": 2,
    "caperton": 3,
    "capes": 1,
    "capetillo": 4,
    "capetown": 2,
    "capillaries": 4,
    "capillary": 4,
    "capistrano": 4,
    "capita": 3,
    "capital": 3,
    "capital(1)": 3,
    "capital's": 3,
    "capitalism": 5,
    "capitalism's": 5,
    "capitalist": 4,
    "capitalistic": 5,
    "capitalists": 4,
    "capitalization": 6,
    "capitalizations": 6,
    "capitalize": 4,
    "capitalized": 4,
    "capitalizes": 5,
    "capitalizing": 5,
    "capitals": 3,
    "capitals(1)": 3,
    "capitan": 3,
    "capitano": 4,
    "capito": 3,
    "capitol": 3,
    "capitol's": 3,
    "capitoline": 4,
    "capitols": 3,
    "capitulate": 4,
    "capitulate(1)": 4,
    "capitulated": 5,
    "capitulation": 5,
    "capizzi": 3,
    "caplan": 2,
    "caple": 2,
    "caples": 2,
    "capley": 2,
    "caplin": 2,
    "caplinger": 4,
    "caplinger(1)": 3,
    "caplinger(2)": 3,
    "capo": 2,
    "capobianco": 5,
    "capon": 2,
    "capone": 2,
    "caponi": 3,
    "caponigro": 4,
    "caporale": 4,
    "caporaso": 4,
    "capote": 2,
    "capote's": 2,
    "capoten": 3,
    "capozzi": 3,
    "capozzoli": 4,
    "capp": 1,
    "cappa": 2,
    "cappadona": 4,
    "capparelli": 4,
    "capped": 1,
    "cappel": 2,
    "cappella": 3,
    "cappelletti": 4,
    "cappelli": 3,
    "cappello": 3,
    "capper": 2,
    "cappetta": 3,
    "cappiello": 4,
    "capping": 2,
    "cappo": 2,
    "capps": 1,
    "cappuccino": 4,
    "cappuccio": 4,
    "cappy": 2,
    "cappy's": 2,
    "capra": 2,
    "capraro": 3,
    "capri": 2,
    "capri(1)": 2,
    "capri's": 2,
    "capri's(1)": 2,
    "capriati": 4,
    "capriati's": 4,
    "caprice": 2,
    "caprices": 3,
    "capricious": 3,
    "capriciously": 4,
    "capricorn": 3,
    "caprio": 3,
    "capriotti": 4,
    "capron": 2,
    "caps": 1,
    "capsaicin": 3,
    "capshaw": 2,
    "capsize": 2,
    "capsized": 2,
    "capstan": 2,
    "capstick": 2,
    "capstone": 2,
    "capsule": 2,
    "capsules": 2,
    "captain": 2,
    "captain's": 2,
    "captaining": 3,
    "captains": 2,
    "caption": 2,
    "captioned": 2,
    "captioning": 3,
    "captions": 2,
    "captivate": 3,
    "captivated": 4,
    "captivates": 3,
    "captivating": 4,
    "captive": 2,
    "captives": 2,
    "captivity": 4,
    "captor": 2,
    "captors": 2,
    "capture": 2,
    "captured": 2,
    "captures": 2,
    "capturing": 3,
    "capua": 3,
    "capuano": 4,
    "caput": 2,
    "caputi": 3,
    "caputo": 3,
    "capwell": 2,
    "caq": 1,
    "caq's": 1,
    "car": 1,
    "car's": 1,
    "cara": 2,
    "cara's": 2,
    "cara'veras": 4,
    "carabajal": 4,
    "caraballo": 4,
    "carabello": 4,
    "caracara": 4,
    "caracas": 3,
    "caracci": 3,
    "caracciolo": 4,
    "caradine": 4,
    "caradonna": 4,
    "carafate": 3,
    "carafe": 2,
    "caraher": 3,
    "caraker": 3,
    "caramandi": 4,
    "caramel": 3,
    "caramelize": 4,
    "caramelized": 4,
    "carangelo": 4,
    "carano": 3,
    "caras": 2,
    "carat": 2,
    "carats": 2,
    "carava": 3,
    "caravan": 3,
    "caravan(1)": 3,
    "caravans": 3,
    "caravans(1)": 3,
    "caravel": 3,
    "caravella": 4,
    "caravelle": 3,
    "caravello": 4,
    "caraveo": 4,
    "carawan": 3,
    "caraway": 3,
    "caraway(1)": 3,
    "carbajal": 3,
    "carballo": 3,
    "carbary": 3,
    "carbaugh": 2,
    "carberry": 3,
    "carberry's": 3,
    "carbide": 2,
    "carbide's": 2,
    "carbin": 2,
    "carbine": 2,
    "carbo": 2,
    "carbohydrate": 4,
    "carbohydrate(1)": 4,
    "carbohydrates": 4,
    "carbon": 2,
    "carbonara": 4,
    "carbonaro": 4,
    "carbonate": 3,
    "carbonated": 4,
    "carbonated(1)": 4,
    "carbonates": 3,
    "carbondale": 3,
    "carbone": 2,
    "carbonell": 3,
    "carbonetto": 4,
    "carboni": 3,
    "carboniferous": 5,
    "carbonize": 3,
    "carbonized": 3,
    "carbonneau": 3,
    "carbons": 2,
    "carborundum": 4,
    "carboxylic": 4,
    "carboy": 2,
    "carburete": 3,
    "carbureted": 4,
    "carburetion": 4,
    "carburetor": 4,
    "carburetors": 4,
    "carby": 2,
    "carcass": 2,
    "carcasses": 3,
    "carcinogen": 4,
    "carcinogenic": 5,
    "carcinogens": 4,
    "carcinoma": 4,
    "carcione": 3,
    "card": 1,
    "card's": 1,
    "carda": 2,
    "cardarelli": 4,
    "cardboard": 2,
    "cardboards": 2,
    "carded": 2,
    "carded(1)": 2,
    "cardell": 2,
    "cardella": 3,
    "cardello": 3,
    "carden": 2,
    "cardenas": 3,
    "cardenas's": 4,
    "carder": 2,
    "cardholder": 3,
    "cardholders": 3,
    "cardia": 3,
    "cardiac": 3,
    "cardiel": 2,
    "cardiff": 2,
    "cardigan": 3,
    "cardigans": 3,
    "cardiges": 3,
    "cardillo": 3,
    "cardin": 2,
    "cardinal": 3,
    "cardinal(1)": 3,
    "cardinal's": 3,
    "cardinale": 4,
    "cardinali": 4,
    "cardinals": 3,
    "cardinals'": 3,
    "cardio": 3,
    "cardiologist": 5,
    "cardiologists": 5,
    "cardiology": 5,
    "cardiopulmonary": 7,
    "cardiovascular": 6,
    "cardis": 2,
    "cardiss": 2,
    "cardizem": 3,
    "cardoen": 3,
    "cardon": 2,
    "cardona": 3,
    "cardone": 3,
    "cardoni": 3,
    "cardoon": 2,
    "cardosa": 3,
    "cardosi": 3,
    "cardoso": 3,
    "cardoso's": 3,
    "cardoza": 3,
    "cardozo": 3,
    "cards": 1,
    "cards'": 1,
    "carducci": 3,
    "cardwell": 2,
    "cardy": 2,
    "care": 1,
    "care's": 1,
    "cared": 1,
    "careen": 2,
    "careened": 2,
    "careening": 3,
    "careens": 2,
    "career": 2,
    "careercom": 3,
    "careering": 3,
    "careerism": 4,
    "careerist": 3,
    "careerists": 3,
    "careers": 2,
    "carefree": 2,
    "careful": 2,
    "carefully": 3,
    "caregiver": 3,
    "caregivers": 3,
    "caregiving": 3,
    "carel": 2,
    "careless": 2,
    "carelessly": 3,
    "carelessness": 3,
    "carella": 3,
    "carelli": 3,
    "carello": 3,
    "carelock": 3,
    "carelock(1)": 2,
    "caremark": 2,
    "caremark's": 2,
    "carena": 3,
    "careplus": 2,
    "carer": 2,
    "cares": 1,
    "caress": 2,
    "caresse": 2,
    "caressed": 2,
    "caresses": 3,
    "caressing": 3,
    "caretaker": 3,
    "caretakers": 3,
    "careunit": 3,
    "careunits": 3,
    "carew": 2,
    "carey": 2,
    "carey's": 2,
    "carfagno": 3,
    "carfora": 3,
    "cargal": 2,
    "cargile": 2,
    "cargill": 2,
    "cargo": 2,
    "cargo's": 2,
    "cargoes": 2,
    "cargonoff": 3,
    "cargos": 2,
    "carhart": 2,
    "caribbean": 4,
    "caribbean(1)": 4,
    "caribe": 2,
    "caribou": 3,
    "caricature": 4,
    "caricatured": 4,
    "caricatures": 4,
    "caricaturist": 5,
    "carico": 3,
    "caricom": 3,
    "caricom's": 3,
    "caridad": 3,
    "caridi": 3,
    "carie": 2,
    "cariello": 4,
    "carignan": 3,
    "cariker": 3,
    "carilla": 3,
    "carillo": 3,
    "carillon": 3,
    "carilou": 3,
    "carin": 2,
    "carine": 3,
    "caring": 2,
    "carini": 3,
    "carinii": 3,
    "carino": 3,
    "carioca": 4,
    "caris": 2,
    "carisbrook": 3,
    "carissa": 3,
    "carita": 3,
    "carithers": 3,
    "carjack": 2,
    "carjacked": 2,
    "carjacker": 3,
    "carjacker's": 3,
    "carjackers": 3,
    "carjacking": 3,
    "carjackings": 3,
    "carjacks": 2,
    "carkhuff": 2,
    "carl": 1,
    "carl's": 1,
    "carla": 2,
    "carla's": 2,
    "carlan": 2,
    "carland": 2,
    "carlberg": 2,
    "carle": 2,
    "carleen": 2,
    "carlen": 2,
    "carlene": 2,
    "carles": 1,
    "carleton": 2,
    "carley": 2,
    "carli": 2,
    "carlile": 2,
    "carlin": 2,
    "carlin's": 2,
    "carliner": 3,
    "carling": 2,
    "carling's": 2,
    "carlini": 3,
    "carlino": 3,
    "carlisi": 3,
    "carlisle": 2,
    "carlita": 3,
    "carlito": 3,
    "carlito's": 3,
    "carll": 1,
    "carlo": 2,
    "carload": 2,
    "carloading": 3,
    "carloadings": 3,
    "carloads": 2,
    "carlock": 2,
    "carlon": 2,
    "carlone": 3,
    "carloni": 3,
    "carlos": 2,
    "carlotta": 3,
    "carlough": 2,
    "carlow": 2,
    "carls": 1,
    "carlsbad": 2,
    "carlsberg": 2,
    "carlsen": 2,
    "carlson": 2,
    "carlson's": 2,
    "carlsson": 2,
    "carlstadt": 2,
    "carlston": 2,
    "carlstrom": 2,
    "carlton": 2,
    "carlton's": 2,
    "carlucci": 3,
    "carly": 2,
    "carlyle": 2,
    "carlyle's": 2,
    "carlyon": 3,
    "carlzon": 2,
    "carma": 2,
    "carmack": 2,
    "carmaker": 3,
    "carmaker's": 3,
    "carmakers": 3,
    "carmakers'": 3,
    "carman": 2,
    "carmany": 3,
    "carmean": 3,
    "carmel": 2,
    "carmel(1)": 2,
    "carmela": 3,
    "carmelita": 4,
    "carmelite": 3,
    "carmelo": 3,
    "carmen": 2,
    "carmer": 2,
    "carmical": 3,
    "carmichael": 3,
    "carmickle": 3,
    "carmie": 2,
    "carmike": 2,
    "carmine": 2,
    "carmita": 3,
    "carmody": 3,
    "carmon": 2,
    "carmona": 3,
    "carmony": 3,
    "carmouche": 2,
    "carmoy": 2,
    "carmy": 2,
    "carn": 1,
    "carnage": 2,
    "carnahan": 3,
    "carnahan's": 3,
    "carnal": 2,
    "carnathan": 3,
    "carnation": 3,
    "carnations": 3,
    "carnauba": 3,
    "carnaud": 2,
    "carne": 1,
    "carneal": 2,
    "carnegie": 3,
    "carnegie(1)": 3,
    "carnegie's": 3,
    "carnegie's(1)": 3,
    "carnegie-mellon": 5,
    "carnegie-mellon(1)": 5,
    "carnegies": 3,
    "carnegies(1)": 3,
    "carneiro": 3,
    "carnell": 2,
    "carner": 2,
    "carnes": 1,
    "carnett": 2,
    "carnevale": 4,
    "carney": 2,
    "carnicero": 4,
    "carnine": 3,
    "carnival": 3,
    "carnival's": 3,
    "carnivals": 3,
    "carnivore": 3,
    "carnivores": 3,
    "carnivorous": 4,
    "carnley": 2,
    "carns": 1,
    "caro": 2,
    "carob": 2,
    "caroche": 2,
    "carol": 2,
    "carol(1)": 2,
    "carol's": 2,
    "carol's(1)": 2,
    "carolan": 3,
    "carolco": 3,
    "carolco's": 3,
    "carolco's(1)": 3,
    "carole": 2,
    "carole(1)": 2,
    "carolina": 4,
    "carolina's": 4,
    "carolinas": 4,
    "caroline": 3,
    "caroline's": 3,
    "carolingian": 5,
    "carolinian": 5,
    "carolinian(1)": 5,
    "carolinians": 5,
    "carollan": 3,
    "carollo": 3,
    "carols": 2,
    "carolus": 3,
    "carolyn": 3,
    "carolyne": 3,
    "carolyne(1)": 3,
    "caron": 2,
    "carone": 2,
    "caronna": 3,
    "carosella": 4,
    "caroselli": 4,
    "carosi": 3,
    "carota": 3,
    "carotene": 3,
    "carotenes": 3,
    "carotenuto": 5,
    "carothers": 3,
    "carotid": 3,
    "carouse": 2,
    "carousel": 3,
    "carousing": 3,
    "carow": 2,
    "carozza": 3,
    "carp": 1,
    "carpal": 2,
    "carpe-diem": 4,
    "carpencic": 3,
    "carpencic's": 3,
    "carpenito": 4,
    "carpenter": 3,
    "carpenter's": 3,
    "carpenters": 3,
    "carpentier": 4,
    "carpentieri": 4,
    "carpentry": 3,
    "carper": 2,
    "carpet": 2,
    "carpetbagger": 4,
    "carpetbaggers": 4,
    "carpeted": 3,
    "carpeting": 3,
    "carpets": 2,
    "carpinelli": 4,
    "carping": 2,
    "carpino": 3,
    "carpio": 3,
    "carpool": 2,
    "carport": 2,
    "carports": 2,
    "carr": 1,
    "carr's": 1,
    "carra": 2,
    "carragher": 3,
    "carraher": 3,
    "carranco": 3,
    "carrano": 3,
    "carranza": 3,
    "carrara": 3,
    "carras": 2,
    "carrasco": 3,
    "carrasquel": 3,
    "carrasquillo": 4,
    "carraway": 3,
    "carrawell": 3,
    "carre": 1,
    "carre(1)": 2,
    "carreira": 3,
    "carreiro": 3,
    "carreker": 3,
    "carrel": 2,
    "carrell": 2,
    "carreno": 3,
    "carreon": 3,
    "carrera": 3,
    "carreras": 3,
    "carrere": 3,
    "carrero": 3,
    "carretta": 3,
    "carrey": 2,
    "carrey's": 2,
    "carriage": 2,
    "carriage(1)": 2,
    "carriages": 3,
    "carriages(1)": 3,
    "carrian": 3,
    "carrian's": 3,
    "carrick": 2,
    "carrico": 3,
    "carrie": 2,
    "carried": 2,
    "carried(1)": 2,
    "carrier": 3,
    "carrier(1)": 3,
    "carrier's": 3,
    "carrier's(1)": 3,
    "carriere": 3,
    "carriero": 3,
    "carriers": 3,
    "carriers(1)": 3,
    "carriers'": 3,
    "carriers's": 4,
    "carries": 2,
    "carries(1)": 2,
    "carrig": 2,
    "carrigan": 3,
    "carriger": 3,
    "carrigg": 2,
    "carriker": 3,
    "carrillo": 3,
    "carringer": 3,
    "carrington": 3,
    "carrington's": 3,
    "carrino": 3,
    "carrion": 3,
    "carris": 2,
    "carrisyn": 3,
    "carrithers": 3,
    "carriveau": 3,
    "carrizales": 4,
    "carro": 2,
    "carrol": 2,
    "carroll": 2,
    "carroll(1)": 2,
    "carroll's": 2,
    "carroll's(1)": 2,
    "carrollton": 3,
    "carron": 2,
    "carrot": 2,
    "carrot(1)": 2,
    "carrothers": 3,
    "carrots": 2,
    "carrots(1)": 2,
    "carrousel": 3,
    "carrow": 2,
    "carrozza": 3,
    "carrubba": 3,
    "carruth": 2,
    "carruthers": 3,
    "carry": 2,
    "carry(1)": 2,
    "carryanne": 3,
    "carryforward": 4,
    "carryforwards": 4,
    "carrying": 3,
    "carrying(1)": 3,
    "carryover": 3,
    "cars": 1,
    "cars(1)": 1,
    "cars'": 1,
    "carse": 1,
    "carsey": 2,
    "carsick": 2,
    "carson": 2,
    "carson(1)": 2,
    "carson's": 2,
    "carstarphen": 3,
    "carsten": 2,
    "carstens": 2,
    "carstensen": 3,
    "carswell": 2,
    "cart": 1,
    "carta": 2,
    "cartagena": 4,
    "cartaya": 3,
    "carte": 1,
    "carted": 2,
    "cartee": 2,
    "cartel": 2,
    "cartel's": 2,
    "cartels": 2,
    "carter": 2,
    "carter's": 2,
    "cartera": 3,
    "carteret": 3,
    "carteret's": 3,
    "carters": 2,
    "cartersville": 3,
    "cartesian": 3,
    "carthage": 2,
    "carthage(1)": 2,
    "carthaginian": 5,
    "cartier": 3,
    "cartilage": 3,
    "cartilage(1)": 3,
    "carting": 2,
    "cartland": 2,
    "cartledge": 2,
    "cartlidge": 2,
    "cartmell": 2,
    "cartmill": 2,
    "cartner": 2,
    "carton": 2,
    "cartoneros": 4,
    "cartons": 2,
    "cartoon": 2,
    "cartooning": 3,
    "cartoonist": 3,
    "cartoonists": 3,
    "cartoons": 2,
    "cartrette": 2,
    "cartridge": 2,
    "cartridge(1)": 2,
    "cartridges": 3,
    "carts": 1,
    "cartusciello": 5,
    "cartwheel": 2,
    "cartwheels": 2,
    "cartwright": 2,
    "carty": 2,
    "caruana": 4,
    "carucci": 3,
    "caruso": 3,
    "carusone": 4,
    "caruth": 2,
    "caruthers": 3,
    "carvajal": 3,
    "carvalho": 3,
    "carve": 1,
    "carved": 1,
    "carvel": 2,
    "carvell": 2,
    "carvell(1)": 2,
    "carver": 2,
    "carver's": 2,
    "carvers": 2,
    "carves": 1,
    "carvey": 2,
    "carville": 2,
    "carville's": 2,
    "carvin": 2,
    "carving": 2,
    "carvings": 2,
    "carwell": 2,
    "carwile": 2,
    "cary": 2,
    "caryl": 2,
    "caryn": 2,
    "cas": 1,
    "casa": 2,
    "casablanca": 4,
    "casad": 2,
    "casada": 3,
    "casado": 3,
    "casados": 3,
    "casady": 3,
    "casagrande": 4,
    "casal": 2,
    "casale": 3,
    "casali": 3,
    "casalino": 4,
    "casals": 2,
    "casals(1)": 2,
    "casamento": 4,
    "casanova": 4,
    "casares": 3,
    "casarez": 3,
    "casas": 2,
    "casassa": 3,
    "casaus": 2,
    "casavant": 3,
    "casazza": 3,
    "casbah": 2,
    "cascade": 2,
    "cascade's": 2,
    "cascaded": 3,
    "cascades": 2,
    "cascades'": 2,
    "cascading": 3,
    "casciano": 4,
    "casciato": 3,
    "cascio": 3,
    "casco": 2,
    "cascone": 3,
    "casdorph": 2,
    "case": 1,
    "case's": 2,
    "casebeer": 3,
    "casebeer(1)": 2,
    "casebier": 4,
    "casebolt": 2,
    "casein": 2,
    "casella": 3,
    "caselli": 3,
    "caseload": 2,
    "caseloads": 3,
    "casera": 3,
    "caserta": 3,
    "cases": 2,
    "cases(1)": 2,
    "casesa": 3,
    "casework": 2,
    "caseworker": 3,
    "caseworkers": 3,
    "casey": 2,
    "casey's": 2,
    "caseze": 3,
    "caseze's": 3,
    "casgrain": 2,
    "cash": 1,
    "cashatt": 2,
    "cashdollar": 3,
    "cashed": 1,
    "cashen": 2,
    "casher": 2,
    "cashes": 2,
    "cashew": 2,
    "cashews": 2,
    "cashflow": 2,
    "cashflows": 2,
    "cashier": 2,
    "cashier's": 2,
    "cashiered": 2,
    "cashiers": 2,
    "cashin": 2,
    "cashing": 2,
    "cashion": 2,
    "cashless": 2,
    "cashman": 2,
    "cashmere": 2,
    "cashmeres": 2,
    "cashmore": 2,
    "cashon": 2,
    "cashway": 2,
    "cashways": 2,
    "cashwell": 2,
    "casiano": 4,
    "casias": 3,
    "casillas": 3,
    "casillo": 3,
    "casimir": 3,
    "casimiro": 4,
    "casing": 2,
    "casings": 2,
    "casino": 3,
    "casino's": 3,
    "casinos": 3,
    "casio": 3,
    "cask": 1,
    "casket": 2,
    "caskets": 2,
    "caskey": 2,
    "casks": 1,
    "casler": 3,
    "casler(1)": 2,
    "caslin": 2,
    "casner": 2,
    "caso": 2,
    "casola": 3,
    "cason": 2,
    "caspar": 2,
    "caspar(1)": 2,
    "casper": 2,
    "caspers": 2,
    "caspersen": 3,
    "casperson": 3,
    "caspian": 3,
    "cass": 1,
    "cassada": 3,
    "cassaday": 3,
    "cassady": 3,
    "cassandra": 3,
    "cassandras": 3,
    "cassani": 3,
    "cassano": 3,
    "cassar": 2,
    "cassara": 3,
    "cassarino": 4,
    "cassaro": 3,
    "cassata": 3,
    "cassatt": 2,
    "cassavetes": 4,
    "casseb": 2,
    "cassedy": 3,
    "cassel": 2,
    "casselberry": 4,
    "cassell": 2,
    "cassella": 3,
    "cassells": 2,
    "casselman": 3,
    "cassels": 2,
    "cassens": 2,
    "casserly": 3,
    "casserole": 3,
    "cassese": 3,
    "cassetta": 3,
    "cassette": 2,
    "cassettes": 2,
    "cassetty": 3,
    "cassia": 3,
    "cassiday": 3,
    "cassidy": 3,
    "cassidy's": 3,
    "cassie": 2,
    "cassin": 2,
    "cassinelli": 4,
    "cassini": 3,
    "cassini's": 3,
    "cassino": 3,
    "cassis": 2,
    "cassity": 3,
    "casso": 2,
    "cassock": 2,
    "casson": 2,
    "cassone": 3,
    "cassoni": 3,
    "cassoni's": 3,
    "cassowary": 4,
    "casstevens": 3,
    "cast": 1,
    "casta": 2,
    "castagna": 3,
    "castagno": 3,
    "castagnola": 4,
    "castaldi": 3,
    "castaldo": 3,
    "castaneda": 4,
    "castano": 3,
    "castanon": 3,
    "castaway": 3,
    "castaways": 3,
    "caste": 1,
    "casteel": 2,
    "casteen": 2,
    "castel": 2,
    "castell": 2,
    "castellana": 4,
    "castellani": 4,
    "castellano": 4,
    "castellanos": 4,
    "castellaw": 3,
    "castelli": 3,
    "castello": 3,
    "castellon": 3,
    "castellucci": 4,
    "castelluccio": 5,
    "castellvi": 3,
    "castelo": 3,
    "casten": 2,
    "caster": 2,
    "casterline": 3,
    "casters": 2,
    "castes": 1,
    "castigate": 3,
    "castigated": 4,
    "castigates": 3,
    "castigating": 4,
    "castiglia": 4,
    "castiglione": 5,
    "castilla": 3,
    "castille": 2,
    "castilleja": 4,
    "castillo": 3,
    "castillo(1)": 3,
    "castillon": 3,
    "castine": 3,
    "casting": 2,
    "castings": 2,
    "castio": 3,
    "castio(1)": 2,
    "castle": 2,
    "castle's": 2,
    "castleberry": 4,
    "castleman": 3,
    "castles": 2,
    "castner": 2,
    "casto": 2,
    "castoff": 2,
    "castoffs": 2,
    "caston": 2,
    "castonguay": 3,
    "castor": 2,
    "castorena": 3,
    "castoro": 3,
    "castpart": 2,
    "castparts": 2,
    "castrate": 2,
    "castrated": 3,
    "castrates": 2,
    "castrating": 3,
    "castration": 3,
    "castrations": 3,
    "castrejon": 3,
    "castrillon": 3,
    "castro": 2,
    "castro's": 2,
    "castrol": 2,
    "castronova": 4,
    "castronovo": 4,
    "castrucci": 3,
    "castruita": 3,
    "casts": 1,
    "casual": 3,
    "casual(1)": 2,
    "casually": 4,
    "casually(1)": 3,
    "casualness": 4,
    "casualness(1)": 3,
    "casuals": 3,
    "casualties": 4,
    "casualties(1)": 3,
    "casualties(2)": 3,
    "casualty": 4,
    "casualty(1)": 3,
    "casualty(2)": 3,
    "caswell": 2,
    "cat": 1,
    "cat's": 1,
    "cat-2": 2,
    "cat-3": 2,
    "cat-4": 2,
    "cat-o-nine-tails": 4,
    "cataclysm": 4,
    "cataclysmic": 4,
    "catacomb": 3,
    "catacombs": 3,
    "catacosinos": 5,
    "catacosinos's": 6,
    "catain": 2,
    "catain(1)": 2,
    "catalan": 3,
    "catalano": 4,
    "catalanotto": 5,
    "cataldi": 3,
    "cataldo": 3,
    "catalfamo": 4,
    "catalina": 4,
    "catalog": 3,
    "cataloged": 3,
    "cataloger": 4,
    "catalogers": 4,
    "cataloging": 4,
    "catalogs": 3,
    "catalogs(1)": 3,
    "catalogue": 3,
    "catalogued": 3,
    "catalogues": 3,
    "cataloguing": 4,
    "catalonia": 4,
    "catalonian": 4,
    "catalyst": 3,
    "catalyst(1)": 3,
    "catalyst's": 3,
    "catalysts": 3,
    "catalysts(1)": 3,
    "catalytic": 4,
    "catalyze": 3,
    "catalyzed": 3,
    "catamaran": 4,
    "catamarans": 4,
    "catamount": 3,
    "catanese": 4,
    "catania": 3,
    "catano": 3,
    "catanzarite": 4,
    "catanzaro": 4,
    "catapano": 4,
    "catapult": 3,
    "catapulted": 4,
    "catapulting": 4,
    "catapults": 3,
    "cataract": 3,
    "cataracts": 3,
    "catastrophe": 4,
    "catastrophes": 4,
    "catastrophic": 4,
    "catatonic": 4,
    "catawba": 3,
    "catbird": 2,
    "catcall": 2,
    "catcalls": 2,
    "catch": 1,
    "catchacan": 3,
    "catchall": 2,
    "catcher": 2,
    "catcher's": 2,
    "catchers": 2,
    "catches": 2,
    "catches(1)": 2,
    "catching": 2,
    "catchings": 2,
    "catchment": 2,
    "catchup": 2,
    "catchword": 2,
    "catchy": 2,
    "cate": 1,
    "catechism": 4,
    "categorical": 5,
    "categorical(1)": 5,
    "categorically": 5,
    "categorically(1)": 5,
    "categories": 4,
    "categorization": 6,
    "categorize": 4,
    "categorized": 4,
    "categorizes": 5,
    "categorizing": 5,
    "category": 4,
    "catelli": 3,
    "catena": 3,
    "cater": 2,
    "catered": 2,
    "caterer": 3,
    "caterers": 3,
    "catering": 3,
    "caterino": 4,
    "caterpillar": 4,
    "caterpillar(1)": 4,
    "caterpillar's": 4,
    "caterpillars": 4,
    "caterpiller": 4,
    "caterpiller(1)": 4,
    "caterpiller's": 4,
    "caterpiller's(1)": 4,
    "caters": 2,
    "caterwaul": 3,
    "cates": 1,
    "catfish": 2,
    "catharine": 2,
    "catharines": 2,
    "catharines(1)": 3,
    "catharsis": 3,
    "cathartic": 3,
    "cathay": 2,
    "cathcart": 2,
    "cathedral": 3,
    "cathedrals": 3,
    "cathell": 2,
    "cather": 2,
    "cather's": 2,
    "catherina": 4,
    "catherine": 3,
    "catherine(1)": 3,
    "catherine(2)": 2,
    "catherine's": 2,
    "catherines": 2,
    "catherman": 3,
    "cathers": 2,
    "catherwood": 3,
    "catheter": 3,
    "catheters": 3,
    "cathey": 2,
    "cathie": 2,
    "cathleen": 2,
    "cathmor": 3,
    "cathode": 2,
    "cathodes": 2,
    "catholic": 2,
    "catholicism": 5,
    "catholics": 2,
    "cathy": 2,
    "cathy's": 2,
    "catija": 3,
    "catino": 3,
    "catkins": 2,
    "catledge": 2,
    "catlett": 2,
    "catlike": 2,
    "catlin": 2,
    "catnap": 2,
    "catnip": 2,
    "cato": 2,
    "catoe": 2,
    "catolica": 4,
    "caton": 2,
    "catone": 2,
    "catrambone": 3,
    "catrett": 2,
    "catron": 2,
    "cats": 1,
    "catskill": 2,
    "catskills": 2,
    "catsup": 2,
    "catt": 1,
    "cattanach": 3,
    "cattaneo": 4,
    "cattani": 3,
    "cattell": 2,
    "catterall": 3,
    "catterson": 3,
    "catterton": 3,
    "cattle": 2,
    "cattlemen": 3,
    "cattlemen(1)": 3,
    "cattlemen's": 3,
    "catto": 2,
    "cattolica": 4,
    "catton": 2,
    "catty": 2,
    "catwalk": 2,
    "catwalk(1)": 2,
    "catwoman": 3,
    "cau": 1,
    "cau(1)": 1,
    "cauble": 2,
    "caucasian": 3,
    "caucasians": 3,
    "caucasus": 3,
    "caucus": 2,
    "caucus(1)": 2,
    "caucus's": 3,
    "caucuses": 3,
    "caudal": 2,
    "caudal(1)": 2,
    "caudell": 2,
    "caudill": 2,
    "caudillo": 3,
    "caudle": 2,
    "cauffman": 2,
    "caufield": 2,
    "caughey": 2,
    "caughlin": 2,
    "caughman": 2,
    "caughron": 2,
    "caught": 1,
    "caught(1)": 1,
    "caul": 1,
    "caul(1)": 1,
    "caulder": 2,
    "cauldron": 2,
    "cauldron(1)": 2,
    "cauley": 2,
    "caulfield": 2,
    "cauliflower": 4,
    "caulk": 1,
    "caulk(1)": 1,
    "caulking": 2,
    "caulkins": 2,
    "causal": 2,
    "causalities": 4,
    "causality": 4,
    "causation": 3,
    "causative": 3,
    "causative(1)": 3,
    "causby": 2,
    "cause": 1,
    "cause(1)": 1,
    "caused": 1,
    "caused(1)": 1,
    "causer": 2,
    "causes": 2,
    "causes(1)": 2,
    "causeway": 2,
    "causeway(1)": 2,
    "causeways": 2,
    "causey": 2,
    "causing": 2,
    "causing(1)": 2,
    "caustic": 2,
    "caustic(1)": 2,
    "cauterization": 5,
    "cauterize": 3,
    "cauterized": 3,
    "cauterizes": 4,
    "cauterizing": 4,
    "cauthen": 2,
    "cauthon": 2,
    "cauthorn": 2,
    "caution": 2,
    "caution(1)": 2,
    "cautionary": 4,
    "cautioned": 2,
    "cautioned(1)": 2,
    "cautioning": 3,
    "cautions": 2,
    "cautious": 2,
    "cautiously": 3,
    "cautiousness": 3,
    "cava": 2,
    "cavaco": 3,
    "cavaco(1)": 3,
    "cavagnaro": 4,
    "cavalcade": 3,
    "cavalier": 3,
    "cavalier(1)": 3,
    "cavaliere": 4,
    "cavalieri": 4,
    "cavalierly": 4,
    "cavaliers": 3,
    "cavallaro": 4,
    "cavallero": 4,
    "cavalli": 3,
    "cavalli-sfor": 4,
    "cavallo": 3,
    "cavalry": 3,
    "cavan": 2,
    "cavanagh": 3,
    "cavanagh(1)": 3,
    "cavanah": 3,
    "cavanaugh": 3,
    "cavaness": 3,
    "cavataio": 5,
    "cavazos": 3,
    "cavazos(1)": 3,
    "cave": 1,
    "cave's": 1,
    "caveat": 3,
    "caveats": 3,
    "caved": 1,
    "cavell": 2,
    "caveman": 2,
    "caven": 2,
    "cavenaugh": 3,
    "cavender": 3,
    "cavendish": 3,
    "caver": 2,
    "caverly": 3,
    "cavern": 2,
    "cavernous": 3,
    "caverns": 2,
    "cavers": 2,
    "caves": 1,
    "cavett": 2,
    "cavey": 2,
    "caviar": 3,
    "cavin": 2,
    "caviness": 3,
    "caving": 2,
    "cavins": 2,
    "cavities": 3,
    "cavitt": 2,
    "cavity": 3,
    "cavness": 2,
    "cavort": 2,
    "cavorting": 3,
    "caw": 1,
    "cawley": 2,
    "cawood": 2,
    "cawsl": 2,
    "cawthon": 2,
    "cawthorn": 2,
    "cawthorne": 2,
    "caxton": 2,
    "cay": 1,
    "caya": 2,
    "cayce": 1,
    "cayenne": 2,
    "cayenne(1)": 2,
    "cayer": 2,
    "cayes": 1,
    "caylin": 2,
    "caylor": 2,
    "cayman": 2,
    "caymans": 2,
    "cayne": 1,
    "cayson": 2,
    "cayton": 2,
    "cayuses": 3,
    "caywood": 2,
    "cazares": 3,
    "cazenove": 3,
    "cazier": 3,
    "cbs": 3,
    "cc": 2,
    "ccs": 3,
    "ccs(1)": 2,
    "cd": 2,
    "cdc": 3,
    "cdebaca": 4,
    "cdrom": 3,
    "cdroms": 3,
    "cds": 2,
    "cea": 3,
    "cea(1)": 2,
    "ceara": 2,
    "cearley": 2,
    "ceasar": 2,
    "cease": 1,
    "cease-fire": 3,
    "ceased": 1,
    "ceasefire": 3,
    "ceasefires": 3,
    "ceaseless": 2,
    "ceaselessly": 3,
    "ceaser": 2,
    "ceases": 2,
    "ceasing": 2,
    "ceaucescu": 3,
    "ceausescu": 3,
    "ceausescu's": 3,
    "ceballos": 3,
    "cebu": 2,
    "cebu's": 2,
    "cebula": 3,
    "cebulski": 3,
    "cecala": 3,
    "ceccarelli": 4,
    "cecchi": 2,
    "cecchini": 3,
    "cecconi": 3,
    "cece": 1,
    "cecelia": 3,
    "cecere": 3,
    "cech": 1,
    "ceci": 2,
    "cecil": 2,
    "cecil's": 2,
    "cecile": 2,
    "cecilia": 3,
    "cecin": 2,
    "ceco": 2,
    "cecola": 3,
    "cecos": 2,
    "cedar": 2,
    "cedar-rapids": 4,
    "cedar-rapids(1)": 4,
    "cedars": 2,
    "cede": 1,
    "ceded": 2,
    "ceded(1)": 2,
    "cedeno": 3,
    "ceder": 2,
    "cederberg": 3,
    "cedergren": 3,
    "cederholm": 3,
    "cederquist": 3,
    "cederquist(1)": 3,
    "cedes": 1,
    "cedillo": 3,
    "ceding": 2,
    "cedras": 2,
    "cedras(1)": 2,
    "cedras'": 2,
    "cedras'(1)": 2,
    "cedras's": 3,
    "cedras's(1)": 3,
    "cedric": 2,
    "cedric(1)": 2,
    "cedrone": 3,
    "cees": 1,
    "cefalo": 3,
    "cefalu": 3,
    "cegielski": 3,
    "ceiling": 2,
    "ceilings": 2,
    "ceja": 2,
    "cejka": 2,
    "cel": 1,
    "cel(1)": 3,
    "cela": 2,
    "celadon": 3,
    "celandine": 3,
    "celanese": 3,
    "celani": 3,
    "celano": 3,
    "celaya": 3,
    "cele": 1,
    "celeb": 2,
    "celebate": 3,
    "celebrant": 3,
    "celebrants": 3,
    "celebrate": 3,
    "celebrated": 4,
    "celebrated(1)": 4,
    "celebrates": 3,
    "celebrating": 4,
    "celebration": 4,
    "celebrations": 4,
    "celebratory": 5,
    "celebre": 3,
    "celebrities": 4,
    "celebrity": 4,
    "celebrity's": 4,
    "celebs": 2,
    "celena": 3,
    "celene": 2,
    "celentano": 4,
    "celerity": 4,
    "celeron": 3,
    "celery": 3,
    "celesta": 3,
    "celeste": 2,
    "celestial": 3,
    "celestin": 3,
    "celestina": 4,
    "celestine": 4,
    "celestino": 4,
    "celestory": 4,
    "celia": 2,
    "celibacy": 4,
    "celibate": 3,
    "celica": 3,
    "celie": 2,
    "celimene": 3,
    "celina": 3,
    "celinda": 3,
    "celine": 2,
    "celio": 3,
    "celis": 2,
    "cell": 1,
    "cell's": 1,
    "cella": 2,
    "cellar": 2,
    "cellars": 2,
    "celled": 1,
    "celli": 2,
    "cellini": 3,
    "cellio": 3,
    "cellist": 2,
    "cellmark": 2,
    "cellmark's": 2,
    "cellnet": 2,
    "cello": 2,
    "cellophane": 3,
    "cellphone": 2,
    "cellpro": 2,
    "cells": 1,
    "cells'": 1,
    "cellstar": 2,
    "cellucci": 3,
    "cellular": 3,
    "cellular's": 3,
    "celluloid": 3,
    "cellulosa": 4,
    "cellulose": 3,
    "celmer": 2,
    "celnik": 2,
    "celo": 2,
    "celo(1)": 2,
    "celo(2)": 4,
    "celona": 3,
    "celosia": 4,
    "cels": 1,
    "celsius": 3,
    "celso": 2,
    "celt": 1,
    "celt(1)": 1,
    "celtic": 2,
    "celtic(1)": 2,
    "celtics": 2,
    "celtics'": 2,
    "celts": 1,
    "celts(1)": 1,
    "cement": 2,
    "cement(1)": 2,
    "cemented": 3,
    "cemented(1)": 3,
    "cementing": 3,
    "cementos": 3,
    "cemeteries": 4,
    "cemetery": 4,
    "cemetery(1)": 4,
    "cemex": 2,
    "cemp": 1,
    "cencall": 2,
    "cenci": 2,
    "cencor": 2,
    "cendejas": 3,
    "cenergy": 3,
    "ceniceros": 4,
    "cenith": 2,
    "cenith's": 2,
    "cenozoic": 4,
    "censer": 2,
    "censor": 2,
    "censored": 2,
    "censoring": 3,
    "censors": 2,
    "censorship": 3,
    "censure": 2,
    "censured": 2,
    "census": 2,
    "censuses": 3,
    "cent": 1,
    "centanni": 3,
    "centanni(1)": 3,
    "centaur": 2,
    "centaur's": 2,
    "centauri": 3,
    "centaurs": 2,
    "centavos": 3,
    "centel": 2,
    "centel's": 2,
    "centenarian": 5,
    "centenarians": 5,
    "centenary": 4,
    "centennial": 4,
    "centennial's": 4,
    "centeno": 3,
    "centeno(1)": 3,
    "center": 2,
    "center(1)": 2,
    "center's": 2,
    "center's(1)": 2,
    "centerbanc": 3,
    "centerbank": 3,
    "centered": 2,
    "centerfielder": 4,
    "centerfold": 3,
    "centering": 3,
    "centerior": 4,
    "centerpiece": 3,
    "centerre": 2,
    "centerre's": 2,
    "centers": 2,
    "centers(1)": 2,
    "centers'": 2,
    "centers'(1)": 2,
    "centerville": 3,
    "centex": 2,
    "centigrade": 3,
    "centigram": 3,
    "centime": 2,
    "centimes": 2,
    "centimeter": 4,
    "centimeters": 4,
    "centimetre": 4,
    "centimetres": 4,
    "centipede": 3,
    "centner": 2,
    "centocor": 3,
    "centocor's": 3,
    "centofanti": 4,
    "centola": 3,
    "centoxin": 3,
    "central": 2,
    "central's": 2,
    "centrale": 2,
    "centralia": 4,
    "centralism": 4,
    "centralists": 3,
    "centrality": 4,
    "centralization": 5,
    "centralize": 3,
    "centralized": 3,
    "centralizing": 4,
    "centrally": 3,
    "centram": 2,
    "centre": 2,
    "centrella": 3,
    "centres": 2,
    "centrex": 2,
    "centrifugal": 4,
    "centrifuge": 3,
    "centrifuges": 4,
    "centrist": 2,
    "centrists": 2,
    "centro": 2,
    "centromin": 3,
    "centronics": 3,
    "centrust": 2,
    "centrust's": 2,
    "cents": 1,
    "cents(1)": 1,
    "centum": 2,
    "centuri": 3,
    "centuries": 3,
    "centurion": 4,
    "century": 3,
    "century's": 3,
    "cenvill": 2,
    "cep": 1,
    "cepeda": 3,
    "cepero": 3,
    "cephalon": 3,
    "cephalopod": 4,
    "cephalosporin": 5,
    "cephas": 2,
    "cephus": 2,
    "cera": 2,
    "ceraceous": 3,
    "ceradyne": 3,
    "cerami": 3,
    "ceramic": 3,
    "ceramics": 3,
    "cerankosky": 4,
    "cerasoli": 4,
    "ceravolo": 4,
    "cerbone": 2,
    "cercone": 3,
    "cerda": 2,
    "cereal": 3,
    "cereals": 3,
    "cerebral": 3,
    "cerebral(1)": 3,
    "cerebrally": 4,
    "ceredase": 3,
    "cereghino": 4,
    "cerelia": 4,
    "ceremonial": 5,
    "ceremonies": 4,
    "ceremony": 4,
    "cereno": 3,
    "ceres": 2,
    "cerezo": 3,
    "cerezo(1)": 3,
    "cerf": 1,
    "ceridian": 4,
    "cerino": 3,
    "cerio": 3,
    "cerise": 2,
    "cermak": 2,
    "cern": 1,
    "cerna": 2,
    "cerney": 2,
    "cerniglia": 4,
    "cernuda": 3,
    "cernuda's": 3,
    "cerny": 2,
    "cerone": 3,
    "cerra": 2,
    "cerrato": 3,
    "cerreta": 3,
    "cerrito": 3,
    "cerritos": 3,
    "cerro": 2,
    "cerrone": 3,
    "cerruti": 3,
    "cerruti(1)": 3,
    "cerska": 2,
    "cerska(1)": 2,
    "certain": 2,
    "certainly": 3,
    "certainteed": 3,
    "certainties": 3,
    "certainty": 3,
    "certificate": 4,
    "certificates": 4,
    "certification": 5,
    "certifications": 5,
    "certified": 3,
    "certified's": 3,
    "certifies": 3,
    "certify": 3,
    "certifying": 4,
    "certitude": 3,
    "certo": 2,
    "certron": 2,
    "cerulli": 3,
    "cerullo": 3,
    "cerus": 2,
    "cerutti": 3,
    "cervantes": 3,
    "cervantez": 3,
    "cerveceria": 5,
    "cervenka": 3,
    "cerveny": 3,
    "cervera": 3,
    "cervesato": 4,
    "cerveza": 3,
    "cerveza(1)": 3,
    "cervi": 2,
    "cervical": 3,
    "cervical(1)": 3,
    "cervini": 3,
    "cervix": 2,
    "cervone": 3,
    "ceryl": 2,
    "cesar": 2,
    "cesare": 3,
    "cesario": 4,
    "cesaro": 3,
    "cesarz": 2,
    "cesena": 3,
    "cesium": 3,
    "cespedes": 3,
    "cessation": 3,
    "cessna": 2,
    "cessna(1)": 2,
    "cessna's": 2,
    "cessna's(1)": 2,
    "cesspool": 2,
    "cestaro": 3,
    "ceta": 2,
    "ceta(1)": 4,
    "cetacean": 3,
    "cetacean(1)": 3,
    "cetec": 2,
    "cetera": 3,
    "cetus": 2,
    "cetus's": 3,
    "cevallos": 3,
    "cevaxs": 3,
    "ceylon": 2,
    "ceylon(1)": 2,
    "cezanne": 2,
    "cezanne's": 2,
    "cha": 1,
    "cha-chas": 2,
    "chablis": 2,
    "chabon": 2,
    "chabot": 2,
    "chacabuco": 4,
    "chace": 1,
    "chachere": 2,
    "chachi": 2,
    "chacin": 2,
    "chacko": 2,
    "chacon": 2,
    "chad": 1,
    "chad's": 1,
    "chadbourne": 2,
    "chadd": 1,
    "chadderdon": 3,
    "chaddock": 2,
    "chadel": 2,
    "chadian": 3,
    "chadick": 2,
    "chadli": 2,
    "chadron": 2,
    "chadwell": 2,
    "chadwick": 2,
    "chadwick's": 2,
    "chae": 1,
    "chaebol": 2,
    "chafe": 1,
    "chafed": 1,
    "chafee": 2,
    "chafee(1)": 2,
    "chafee's": 2,
    "chafee's(1)": 2,
    "chafes": 1,
    "chafete": 2,
    "chaff": 1,
    "chaffee": 2,
    "chaffin": 2,
    "chaffins": 2,
    "chaffy": 2,
    "chafin": 2,
    "chafing": 2,
    "chagall": 2,
    "chagall(1)": 2,
    "chagnon": 2,
    "chagrin": 2,
    "chagrined": 2,
    "chai": 1,
    "chaidez": 3,
    "chaiken": 2,
    "chaikin": 2,
    "chaim": 2,
    "chain": 1,
    "chain's": 1,
    "chained": 1,
    "chaining": 2,
    "chains": 1,
    "chains'": 1,
    "chainsaw": 2,
    "chainsaws": 2,
    "chair": 1,
    "chaired": 1,
    "chaires": 1,
    "chairez": 3,
    "chairing": 2,
    "chairman": 2,
    "chairman's": 2,
    "chairmanship": 3,
    "chairmanships": 3,
    "chairmen": 2,
    "chairpeople": 3,
    "chairperson": 3,
    "chairs": 1,
    "chairwoman": 3,
    "chairwomen": 3,
    "chaise": 1,
    "chaisson": 2,
    "chait": 1,
    "chajet": 2,
    "chalabi": 3,
    "chalasani": 4,
    "chalcedony": 4,
    "chalet": 2,
    "chalet(1)": 2,
    "chalets": 2,
    "chalets(1)": 2,
    "chalfant": 2,
    "chalfant(1)": 2,
    "chalfin": 2,
    "chalice": 2,
    "chalifoux": 3,
    "chalk": 1,
    "chalk(1)": 1,
    "chalked": 1,
    "chalker": 2,
    "chalking": 2,
    "chalkley": 2,
    "chalks": 1,
    "challender": 3,
    "challenge": 2,
    "challenged": 2,
    "challenger": 3,
    "challenger(1)": 3,
    "challenger's": 3,
    "challengers": 3,
    "challengery": 4,
    "challenges": 3,
    "challenging": 3,
    "challis": 2,
    "chalmers": 2,
    "chalmette": 2,
    "chaloupka": 3,
    "chaloux": 2,
    "chalsty": 2,
    "chalupa": 3,
    "cham": 1,
    "chamber": 2,
    "chamber's": 2,
    "chambered": 2,
    "chamberlain": 3,
    "chamberlain(1)": 3,
    "chamberlain's": 3,
    "chamberland": 3,
    "chamberlayne": 3,
    "chamberlin": 3,
    "chambers": 2,
    "chambers'": 2,
    "chambers's": 3,
    "chamblee": 2,
    "chambless": 2,
    "chamblin": 2,
    "chambliss": 2,
    "chambon": 2,
    "chameleon": 4,
    "chameleon(1)": 4,
    "chamlee": 2,
    "chamlong": 2,
    "chamness": 2,
    "chamonix": 3,
    "chamonix(1)": 3,
    "chamorro": 3,
    "chamorro(1)": 3,
    "chamorro's": 3,
    "champ": 1,
    "champa": 2,
    "champagne": 2,
    "champagnes": 2,
    "champaign": 2,
    "champaign-urbana": 5,
    "champeau": 2,
    "champine": 2,
    "champion": 3,
    "champion's": 3,
    "championed": 3,
    "championing": 4,
    "champions": 3,
    "championship": 4,
    "championships": 4,
    "champlain": 2,
    "champlin": 2,
    "champney": 2,
    "champoux": 2,
    "champs": 1,
    "chan": 1,
    "chan's": 1,
    "chana": 2,
    "chance": 1,
    "chancellor": 3,
    "chancellor(1)": 2,
    "chancellor's": 3,
    "chancellors": 3,
    "chancery": 3,
    "chances": 2,
    "chances(1)": 2,
    "chancey": 2,
    "chancy": 2,
    "chand": 1,
    "chanda": 2,
    "chandelier": 3,
    "chandeliers": 3,
    "chandler": 2,
    "chandler's": 2,
    "chandley": 2,
    "chandon": 2,
    "chandon(1)": 2,
    "chandra": 2,
    "chandrika": 3,
    "chandrika(1)": 3,
    "chandross": 2,
    "chanel": 2,
    "chaney": 2,
    "chang": 1,
    "chang-hsin": 2,
    "chang-ming": 2,
    "chang-ming(1)": 2,
    "changchun": 2,
    "change": 1,
    "changeable": 3,
    "changed": 1,
    "changeover": 3,
    "changeovers": 3,
    "changer": 2,
    "changers": 2,
    "changes": 2,
    "changes(1)": 2,
    "changing": 2,
    "changsho": 2,
    "chanin": 2,
    "chanishiva": 4,
    "chanley": 2,
    "channel": 2,
    "channel's": 2,
    "channeled": 2,
    "channeling": 3,
    "channeling(1)": 2,
    "channell": 2,
    "channell's": 2,
    "channels": 2,
    "channing": 2,
    "channon": 2,
    "chanos": 2,
    "chant": 1,
    "chantal": 2,
    "chanted": 2,
    "chantilly": 3,
    "chanting": 2,
    "chants": 1,
    "chanukah": 3,
    "chany": 2,
    "chao": 1,
    "chaos": 2,
    "chaotic": 3,
    "chap": 1,
    "chapa": 2,
    "chaparral": 3,
    "chaparro": 3,
    "chapas": 2,
    "chapdelaine": 3,
    "chapek": 2,
    "chapel": 2,
    "chapel's": 2,
    "chapell": 2,
    "chapelle": 2,
    "chaperone": 3,
    "chaperones": 3,
    "chaperoning": 4,
    "chapin": 2,
    "chaplain": 2,
    "chaplains": 2,
    "chaplan": 2,
    "chaplin": 2,
    "chaplin(1)": 2,
    "chaplin's": 2,
    "chapman": 2,
    "chapman's": 2,
    "chapnick": 2,
    "chapoton": 3,
    "chapp": 1,
    "chappaquiddick": 4,
    "chappel": 2,
    "chappelear": 3,
    "chappell": 2,
    "chappelle": 2,
    "chappie": 2,
    "chapple": 2,
    "chappuis": 3,
    "chaps": 1,
    "chapter": 2,
    "chapters": 2,
    "chaput": 2,
    "char": 1,
    "chara": 2,
    "character": 3,
    "character's": 3,
    "characteristic": 5,
    "characteristically": 6,
    "characteristics": 5,
    "characterization": 6,
    "characterizations": 6,
    "characterize": 4,
    "characterized": 4,
    "characterizes": 5,
    "characterizing": 5,
    "characters": 3,
    "characters(1)": 3,
    "characters'": 3,
    "charade": 2,
    "charades": 2,
    "charalambos": 4,
    "charasse": 2,
    "charboneau": 3,
    "charbonneau": 3,
    "charbonnet": 3,
    "charbonnet(1)": 3,
    "charcoal": 2,
    "charcoals": 2,
    "chard": 1,
    "chardonnay": 3,
    "chardonnays": 3,
    "charen": 2,
    "charen's": 2,
    "charest": 2,
    "charette": 2,
    "charge": 1,
    "chargeable": 3,
    "charged": 1,
    "charger": 2,
    "chargers": 2,
    "charges": 2,
    "charges(1)": 2,
    "chargeurs": 2,
    "charging": 2,
    "chargit": 2,
    "chargois": 2,
    "chariot": 3,
    "chariots": 3,
    "charisma": 3,
    "charismatic": 4,
    "charismatics": 4,
    "charissa": 3,
    "charita": 3,
    "charitable": 4,
    "charitable(1)": 4,
    "charitably": 4,
    "charities": 3,
    "charities(1)": 3,
    "charities'": 3,
    "charity": 3,
    "charity's": 3,
    "charla": 2,
    "charland": 2,
    "charlatan": 3,
    "charlatans": 3,
    "charlayne": 2,
    "charle": 1,
    "charlebois": 3,
    "charleen": 2,
    "charlemagne": 3,
    "charlene": 2,
    "charles": 1,
    "charles(1)": 2,
    "charles'": 1,
    "charles'(1)": 2,
    "charles's": 2,
    "charleston": 2,
    "charleston(1)": 3,
    "charleston's": 2,
    "charleston's(1)": 3,
    "charlestown": 2,
    "charlestown(1)": 3,
    "charlesworth": 3,
    "charlesworth(1)": 3,
    "charlet": 2,
    "charlevoix": 3,
    "charley": 2,
    "charley's": 2,
    "charlie": 2,
    "charlie's": 2,
    "charlier": 3,
    "charline": 2,
    "charlot": 2,
    "charlotte": 2,
    "charlotte's": 2,
    "charlottesville": 3,
    "charlottetown": 3,
    "charlotteville": 3,
    "charls": 1,
    "charlson": 2,
    "charlton": 2,
    "charm": 1,
    "charmain": 2,
    "charmaine": 2,
    "charmed": 1,
    "charmer": 2,
    "charmers": 2,
    "charmian": 3,
    "charming": 2,
    "charmingly": 3,
    "charmion": 3,
    "charms": 1,
    "charney": 2,
    "charnley": 2,
    "charnock": 2,
    "charon": 2,
    "charpentier": 3,
    "charpie": 2,
    "charred": 1,
    "charren": 2,
    "charrette": 2,
    "charrier": 3,
    "charring": 2,
    "charron": 2,
    "charron(1)": 2,
    "charry": 2,
    "chart": 1,
    "charted": 2,
    "charted(1)": 2,
    "charter": 2,
    "charter's": 2,
    "chartered": 2,
    "charterhouse": 3,
    "chartering": 3,
    "charters": 2,
    "chartier": 3,
    "charting": 2,
    "chartist": 2,
    "chartists": 2,
    "chartrand": 2,
    "chartres": 2,
    "chartreuse": 2,
    "chartreuse(1)": 2,
    "charts": 1,
    "chartwell": 2,
    "charvat": 2,
    "charwoman": 3,
    "charwomen": 3,
    "chary": 2,
    "charyl": 2,
    "chas": 1,
    "chase": 1,
    "chase's": 2,
    "chased": 1,
    "chasen": 2,
    "chaser": 2,
    "chasers": 2,
    "chases": 2,
    "chases(1)": 2,
    "chasin": 2,
    "chasing": 2,
    "chaska": 2,
    "chasm": 2,
    "chason": 2,
    "chasse": 1,
    "chassis": 2,
    "chastain": 2,
    "chaste": 1,
    "chasteen": 2,
    "chasten": 2,
    "chastened": 2,
    "chastise": 2,
    "chastised": 2,
    "chastises": 3,
    "chastising": 3,
    "chastity": 3,
    "chat": 1,
    "chataqua": 3,
    "chateau": 2,
    "chateaux": 2,
    "chatfield": 2,
    "chatham": 2,
    "chatichai": 3,
    "chatichai's": 3,
    "chatichai's(1)": 3,
    "chatihachi": 4,
    "chatihachi's": 4,
    "chatman": 2,
    "chatmon": 2,
    "chato": 2,
    "chats": 1,
    "chatswood": 2,
    "chatsworth": 2,
    "chattahoochee": 4,
    "chattahoochee's": 4,
    "chattanooga": 4,
    "chattanooga's": 4,
    "chattanuga": 4,
    "chatted": 2,
    "chatted(1)": 2,
    "chattel": 2,
    "chatter": 2,
    "chattering": 3,
    "chatterjee": 3,
    "chatterton": 3,
    "chatterton's": 3,
    "chattin": 2,
    "chatting": 2,
    "chatty": 2,
    "chatwal": 2,
    "chatwin": 2,
    "chatz": 1,
    "chatz'": 1,
    "chatz's": 2,
    "chau": 1,
    "chaucer": 2,
    "chaucer's": 2,
    "chaudhry": 2,
    "chaudoin": 2,
    "chauffeur": 2,
    "chauffeur(1)": 2,
    "chauffeur's": 2,
    "chauffeur's(1)": 2,
    "chauffeured": 2,
    "chauffeured(1)": 2,
    "chauffeurs": 2,
    "chauffeurs(1)": 2,
    "chaumet": 2,
    "chaunce": 1,
    "chauncey": 2,
    "chauncy": 2,
    "chaus": 1,
    "chausse": 1,
    "chaussee": 2,
    "chautauqua": 3,
    "chautauquan": 3,
    "chautauquans": 3,
    "chauvin": 2,
    "chauvinism": 4,
    "chauvinist": 3,
    "chauvinistic": 4,
    "chauvinists": 3,
    "chavalit": 3,
    "chavarria": 4,
    "chavers": 2,
    "chaves": 1,
    "chavez": 2,
    "chavez(1)": 2,
    "chavez(2)": 2,
    "chavin": 2,
    "chavira": 3,
    "chavis": 2,
    "chavis(1)": 2,
    "chavis'": 2,
    "chavis'(1)": 2,
    "chavitz": 2,
    "chavous": 2,
    "chaw": 1,
    "chawla": 2,
    "chayon": 2,
    "chaz": 1,
    "chazanoff": 3,
    "chazen": 2,
    "chazov": 2,
    "chazz": 1,
    "chazz(1)": 1,
    "che": 1,
    "che's": 1,
    "chea": 1,
    "cheadle": 2,
    "cheane": 1,
    "cheane's": 1,
    "cheaney": 2,
    "cheap": 1,
    "cheapen": 2,
    "cheapened": 2,
    "cheapening": 3,
    "cheapens": 2,
    "cheaper": 2,
    "cheapest": 2,
    "cheaply": 2,
    "cheapness": 2,
    "cheapo": 2,
    "cheapskate": 2,
    "cheat": 1,
    "cheated": 2,
    "cheated(1)": 2,
    "cheater": 2,
    "cheaters": 2,
    "cheatham": 2,
    "cheating": 2,
    "cheats": 1,
    "cheatum": 2,
    "cheatwood": 2,
    "chebrikov": 3,
    "checchi": 2,
    "chechen": 2,
    "chechen's": 2,
    "chechens": 2,
    "chechnya": 3,
    "chechnya's": 3,
    "chechnyan": 3,
    "chechnyan's": 3,
    "chechnyans": 3,
    "check": 1,
    "checkbook": 2,
    "checkbooks": 2,
    "checked": 1,
    "checker": 2,
    "checkerboard": 3,
    "checkerboarding": 4,
    "checkerboards": 3,
    "checkered": 2,
    "checkers": 2,
    "checkerspot": 3,
    "checketts": 2,
    "checking": 2,
    "checklist": 2,
    "checklists": 2,
    "checkmate": 2,
    "checkmates": 2,
    "checkoff": 2,
    "checkout": 2,
    "checkouts": 2,
    "checkpoint": 2,
    "checkpoints": 2,
    "checks": 1,
    "checkup": 2,
    "checkups": 2,
    "cheddar": 2,
    "cheddars": 2,
    "chedester": 3,
    "chee": 1,
    "cheech": 1,
    "cheek": 1,
    "cheekbone": 2,
    "cheekbones": 2,
    "cheeked": 1,
    "cheeks": 1,
    "cheektowaga": 4,
    "cheeky": 2,
    "cheely": 2,
    "cheer": 1,
    "cheered": 1,
    "cheerful": 2,
    "cheerfully": 3,
    "cheerfully(1)": 2,
    "cheerier": 3,
    "cheeriest": 3,
    "cheering": 2,
    "cheerio": 3,
    "cheerios": 3,
    "cheerleader": 3,
    "cheerleaders": 3,
    "cheerleading": 3,
    "cheers": 1,
    "cheery": 2,
    "cheese": 1,
    "cheeseburger": 3,
    "cheeseburgers": 3,
    "cheesecake": 2,
    "cheeseman": 2,
    "cheeser": 2,
    "cheeses": 2,
    "cheesier": 3,
    "cheesiest": 3,
    "cheesman": 2,
    "cheesy": 2,
    "cheetah": 2,
    "cheetahs": 2,
    "cheetal": 2,
    "cheetan": 2,
    "cheetham": 2,
    "cheever": 2,
    "chef": 1,
    "chef's": 1,
    "chefitz": 2,
    "chefs": 1,
    "cheil": 1,
    "cheimi": 2,
    "chek": 1,
    "chekhov": 2,
    "chekhov's": 2,
    "chelan": 2,
    "chelette": 2,
    "chelf": 1,
    "chell": 1,
    "chellis": 2,
    "chelmsford": 2,
    "chelsea": 2,
    "chelsea's": 2,
    "chelyabinsk": 3,
    "chem": 1,
    "chema": 2,
    "chemania": 3,
    "chemclear": 2,
    "chemdesign": 3,
    "chemed": 2,
    "chemed(1)": 1,
    "chemel": 2,
    "chemerinsky": 4,
    "chemetron": 3,
    "chemfix": 2,
    "chemical": 3,
    "chemical(1)": 3,
    "chemical's": 3,
    "chemically": 3,
    "chemicals": 3,
    "chemicals'": 3,
    "chemie": 2,
    "chemins": 2,
    "chemins(1)": 2,
    "chemise": 2,
    "chemist": 2,
    "chemistry": 3,
    "chemistry(1)": 3,
    "chemists": 2,
    "chemists(1)": 2,
    "chemlawn": 2,
    "chemlawn's": 2,
    "chemo": 2,
    "chemotherapy": 5,
    "chemyr": 2,
    "chen": 1,
    "chen's": 1,
    "chenard": 2,
    "chenault": 2,
    "chenette": 2,
    "chenevert": 3,
    "cheney": 2,
    "cheney's": 2,
    "cheng": 1,
    "cheng-chung": 2,
    "cheng-hua": 2,
    "chengdu": 2,
    "chengxiang": 2,
    "chenier": 2,
    "chennai": 2,
    "chennault": 2,
    "chenoweth": 3,
    "chenowitz": 3,
    "chenxiang": 2,
    "cheong": 2,
    "cher": 1,
    "cheramie": 3,
    "cherbourg": 2,
    "cheri": 2,
    "cherico": 3,
    "cherico(1)": 3,
    "cherie": 2,
    "cherish": 2,
    "cherished": 2,
    "cherishes": 3,
    "cherishing": 3,
    "chermak": 2,
    "chern": 1,
    "cherne": 1,
    "chernenko": 3,
    "cherney": 2,
    "chernick": 2,
    "chernin": 2,
    "chernobyl": 3,
    "chernobyl's": 3,
    "chernoff": 2,
    "chernomyrdin": 4,
    "chernomyrdin's": 4,
    "chernow": 2,
    "cherny": 2,
    "cherokee": 3,
    "cherokee's": 3,
    "cherokees": 3,
    "cherrapunji": 4,
    "cherrier": 3,
    "cherries": 2,
    "cherrington": 3,
    "cherry": 2,
    "cherry's": 2,
    "cherrystone": 3,
    "cherrystones": 3,
    "chert": 1,
    "chertkow": 2,
    "chertoff": 2,
    "cherts": 1,
    "cherub": 2,
    "cherubic": 3,
    "cherubini": 4,
    "cherubs": 2,
    "cherumirdan": 4,
    "cherumirdan's": 4,
    "chervenak": 3,
    "chery": 2,
    "cheryl": 2,
    "ches": 1,
    "chesapeake": 3,
    "chesbro": 2,
    "chesebro": 3,
    "chesebrough": 3,
    "chesher": 2,
    "cheshier": 3,
    "cheshire": 2,
    "chesler": 3,
    "chesler(1)": 2,
    "chesley": 2,
    "cheslock": 2,
    "chesney": 2,
    "chesnut": 2,
    "chesnutt": 2,
    "chesnutt(1)": 2,
    "chess": 1,
    "chessboard": 2,
    "chessboards": 2,
    "chesser": 2,
    "chessher": 2,
    "chesshir": 2,
    "chessman": 2,
    "chesson": 2,
    "chest": 1,
    "chestang": 2,
    "chested": 2,
    "chested(1)": 2,
    "chester": 2,
    "chesterfield": 3,
    "chesterman": 3,
    "chesters": 2,
    "chesterson": 3,
    "chesterton": 3,
    "chestman": 2,
    "chestnut": 2,
    "chestnut(1)": 2,
    "chestnuts": 2,
    "chestnutt": 2,
    "cheston": 2,
    "chests": 1,
    "chet": 1,
    "chetniks": 2,
    "chetwin": 2,
    "cheung": 1,
    "cheuse": 1,
    "cheuvront": 2,
    "chevalier": 3,
    "cheverly": 3,
    "cheves": 1,
    "chevette": 2,
    "chevies": 2,
    "chevik": 2,
    "cheviot": 3,
    "cheviots": 3,
    "chevis": 2,
    "chevrette": 2,
    "chevrier": 4,
    "chevrolet": 3,
    "chevrolet(1)": 3,
    "chevrolet's": 3,
    "chevrolet's(1)": 3,
    "chevrolets": 3,
    "chevrolets(1)": 3,
    "chevron": 2,
    "chevron(1)": 2,
    "chevron's": 2,
    "chevron's(1)": 2,
    "chevy": 2,
    "chevy(1)": 2,
    "chevy's": 2,
    "chevy's(1)": 2,
    "chevys": 2,
    "chevys(1)": 2,
    "chew": 1,
    "chewed": 1,
    "chewer": 2,
    "chewers": 2,
    "chewing": 2,
    "chewning": 2,
    "chews": 1,
    "chewy": 2,
    "cheyenne": 2,
    "cheyenne's": 2,
    "cheyennes": 2,
    "cheyne": 1,
    "cheyney": 2,
    "chez": 1,
    "chez(1)": 1,
    "chi": 1,
    "chi's": 1,
    "chia": 2,
    "chianese": 4,
    "chiang": 1,
    "chiang's": 1,
    "chianti": 3,
    "chiapas": 3,
    "chiapas'": 3,
    "chiapparone": 4,
    "chiappetta": 4,
    "chiappone": 4,
    "chiara": 2,
    "chiaramonte": 5,
    "chiarella": 4,
    "chiarelli": 4,
    "chiarello": 4,
    "chiarenza": 4,
    "chiarnim": 3,
    "chiaro": 3,
    "chiasso": 3,
    "chiasson": 3,
    "chiat": 2,
    "chiavetta": 4,
    "chiba": 2,
    "chic": 1,
    "chicago": 3,
    "chicago's": 3,
    "chicagoan": 3,
    "chicagoans": 4,
    "chicanery": 4,
    "chicano": 3,
    "chicanos": 3,
    "chichauha": 3,
    "chichauha's": 3,
    "chichester": 3,
    "chichi": 2,
    "chick": 1,
    "chickasaw": 3,
    "chickasaws": 3,
    "chicked": 1,
    "chicken": 2,
    "chicken's": 2,
    "chickened": 2,
    "chickening": 3,
    "chickens": 2,
    "chickens'": 2,
    "chickering": 3,
    "chicks": 1,
    "chico": 2,
    "chico's": 2,
    "chicoine": 2,
    "chicots": 2,
    "chide": 1,
    "chided": 2,
    "chides": 1,
    "chidester": 3,
    "chideya": 3,
    "chideya(1)": 3,
    "chiding": 2,
    "chidsey": 2,
    "chief": 1,
    "chief's": 1,
    "chiefdom": 2,
    "chieffo": 2,
    "chiefly": 2,
    "chiefs": 1,
    "chiefs'": 1,
    "chieftain": 2,
    "chieftain's": 2,
    "chieftains": 2,
    "chien": 1,
    "chiengmai": 2,
    "chiesa": 2,
    "chiffon": 2,
    "chiggers": 2,
    "chigney": 2,
    "chihuahua": 3,
    "chihuahua(1)": 3,
    "chikane": 3,
    "chikatilo": 4,
    "chikos": 2,
    "chilblain": 2,
    "chilblains": 2,
    "chilcoat": 2,
    "chilcote": 2,
    "chilcott": 2,
    "chilcutt": 2,
    "child": 1,
    "child's": 1,
    "childbearing": 3,
    "childbirth": 2,
    "childcare": 2,
    "childcraft": 2,
    "childe": 1,
    "childener": 2,
    "childener(1)": 3,
    "childener's": 2,
    "childener's(1)": 3,
    "childers": 2,
    "childhood": 2,
    "childhoods": 2,
    "childish": 2,
    "childless": 2,
    "childlike": 2,
    "childraising": 3,
    "childree": 2,
    "children": 2,
    "children's": 2,
    "childrens": 2,
    "childrens'": 2,
    "childres": 2,
    "childress": 2,
    "childrey": 2,
    "childs": 1,
    "chile": 2,
    "chile's": 2,
    "chilean": 3,
    "chileans": 3,
    "chiles": 1,
    "chiles(1)": 2,
    "chiles's": 3,
    "chili": 2,
    "chili's": 2,
    "chilies": 2,
    "chilis": 2,
    "chill": 1,
    "chilled": 1,
    "chillemi": 3,
    "chiller": 2,
    "chillicothe": 3,
    "chillier": 3,
    "chillies": 2,
    "chilliest": 3,
    "chilling": 2,
    "chillingly": 3,
    "chills": 1,
    "chilly": 2,
    "chilmark": 2,
    "chilson": 2,
    "chilton": 2,
    "chimayo": 3,
    "chime": 1,
    "chimed": 1,
    "chimenti": 3,
    "chimento": 3,
    "chimera": 3,
    "chimerical": 4,
    "chimerine": 3,
    "chimes": 1,
    "chimicles": 3,
    "chimie": 2,
    "chimney": 2,
    "chimneys": 2,
    "chimp": 1,
    "chimpanzee": 3,
    "chimpanzees": 3,
    "chimps": 1,
    "chimurenga": 4,
    "chin": 1,
    "china": 2,
    "china's": 2,
    "chinatown": 3,
    "chinchilla": 3,
    "chinen": 2,
    "chinese": 2,
    "ching": 1,
    "chinh": 1,
    "chink": 1,
    "chinks": 1,
    "chinn": 1,
    "chinn's": 1,
    "chinnici": 3,
    "chinnock": 2,
    "chino": 2,
    "chinook": 2,
    "chinook(1)": 2,
    "chinooks": 2,
    "chinooks(1)": 2,
    "chinoy": 2,
    "chintung": 2,
    "chintzy": 2,
    "chiodo": 3,
    "chip": 1,
    "chip's": 1,
    "chipboard": 2,
    "chipcom": 2,
    "chipcom's": 2,
    "chipello": 3,
    "chipetas": 3,
    "chipita": 3,
    "chipley": 2,
    "chipmaker": 3,
    "chipmakers": 3,
    "chipman": 2,
    "chipote": 2,
    "chipped": 1,
    "chipper": 2,
    "chippewa": 3,
    "chipping": 2,
    "chipps": 1,
    "chippy": 2,
    "chips": 1,
    "chipsoft": 2,
    "chiquita": 3,
    "chiquita(1)": 3,
    "chiquita(2)": 3,
    "chirac": 2,
    "chirac's": 2,
    "chirco": 2,
    "chirico": 3,
    "chiron": 2,
    "chiron's": 2,
    "chiropractic": 4,
    "chiropractor": 4,
    "chiropractor's": 4,
    "chiropractors": 4,
    "chirp": 1,
    "chirping": 2,
    "chirps": 1,
    "chirpy": 2,
    "chisam": 2,
    "chisel": 2,
    "chiseled": 2,
    "chiseling": 3,
    "chiseling(1)": 2,
    "chisels": 2,
    "chisenhall": 3,
    "chisholm": 2,
    "chisler": 3,
    "chisler(1)": 2,
    "chisler(2)": 2,
    "chism": 2,
    "chisman": 2,
    "chismar": 2,
    "chisolm": 2,
    "chisom": 2,
    "chissano": 3,
    "chisum": 2,
    "chiswick": 2,
    "chit": 1,
    "chita": 2,
    "chitchat": 2,
    "chitinous": 3,
    "chitlin": 2,
    "chitlins": 2,
    "chitra": 2,
    "chitra's": 2,
    "chitrao": 2,
    "chits": 1,
    "chittenden": 3,
    "chitter": 2,
    "chitterchatter": 4,
    "chitterlings": 3,
    "chittick": 2,
    "chittum": 2,
    "chitty": 2,
    "chitwood": 2,
    "chiu": 1,
    "chiusano": 4,
    "chivalry": 3,
    "chivas": 2,
    "chivas(1)": 2,
    "chivers": 2,
    "chives": 1,
    "chiyoda": 3,
    "chizek": 2,
    "chizmar": 2,
    "chlamydia": 4,
    "chlamydia(1)": 4,
    "chlebowski": 3,
    "chlebowski(1)": 3,
    "chloe": 2,
    "chlorate": 2,
    "chlordane": 2,
    "chloride": 2,
    "chlorinate": 3,
    "chlorinated": 4,
    "chlorinating": 4,
    "chlorine": 2,
    "chloris": 2,
    "chlorofluorocarbon": 6,
    "chlorofluorocarbons": 6,
    "chloroform": 3,
    "chlorophyll": 3,
    "chloroplast": 3,
    "chloroplasts": 3,
    "chloroprene": 3,
    "chmiel": 2,
    "chmielewski": 4,
    "chmielewski(1)": 4,
    "chmura": 3,
    "cho": 1,
    "choat": 1,
    "choate": 1,
    "chock": 1,
    "chocolat": 2,
    "chocolate": 2,
    "chocolates": 2,
    "chocolatology": 5,
    "chodorow": 3,
    "choe": 1,
    "choi": 1,
    "choice": 1,
    "choicer": 2,
    "choicers": 2,
    "choices": 2,
    "choices(1)": 2,
    "choicest": 2,
    "choiniere": 3,
    "choinski": 2,
    "choir": 2,
    "choirs": 1,
    "chojnacki": 3,
    "chojnowski": 3,
    "chok": 1,
    "choke": 1,
    "choked": 1,
    "chokehold": 2,
    "chokes": 1,
    "choking": 2,
    "cholera": 3,
    "choleric": 3,
    "cholesterol": 4,
    "cholesterol(1)": 4,
    "cholestyramine": 5,
    "cholet": 2,
    "cholewa": 3,
    "cholla": 2,
    "choma": 2,
    "chombiono": 4,
    "chomp": 1,
    "chomping": 2,
    "chon": 1,
    "chong": 1,
    "chongqing": 2,
    "chonko": 2,
    "chontales": 2,
    "choo": 1,
    "chook": 1,
    "chook(1)": 1,
    "choon": 1,
    "choong": 1,
    "choose": 1,
    "chooses": 2,
    "chooses(1)": 2,
    "choosing": 2,
    "choosy": 2,
    "chop": 1,
    "chop-suey": 3,
    "choper": 2,
    "chopin": 2,
    "choplin": 2,
    "chopp": 1,
    "chopped": 1,
    "chopper": 2,
    "chopper's": 2,
    "choppers": 2,
    "chopping": 2,
    "choppy": 2,
    "chopra": 2,
    "chops": 1,
    "chopstick": 2,
    "chopsticks": 2,
    "chopsuey": 3,
    "choquette": 2,
    "choral": 2,
    "chorale": 2,
    "chorals": 2,
    "chorba": 2,
    "chord": 1,
    "chordates": 2,
    "chords": 1,
    "chore": 1,
    "choreograph": 4,
    "choreographed": 4,
    "choreographer": 5,
    "choreographer's": 5,
    "choreographers": 5,
    "choreographic": 5,
    "choreographing": 5,
    "choreographing(1)": 5,
    "choreography": 5,
    "chores": 1,
    "choric": 2,
    "chorney": 2,
    "chortle": 2,
    "chortled": 2,
    "chortles": 2,
    "chortling": 3,
    "chortling(1)": 2,
    "chorus": 2,
    "choruses": 3,
    "chose": 1,
    "chosen": 2,
    "chosun": 2,
    "chotilla": 3,
    "chou": 1,
    "chouinard": 2,
    "chovan": 2,
    "chovanec": 3,
    "chow": 1,
    "chowder": 2,
    "chowdhury": 3,
    "chowning": 2,
    "chows": 1,
    "choy": 1,
    "choyce": 1,
    "chrest": 1,
    "chrestman": 2,
    "chretien": 2,
    "chriboniko": 4,
    "chriboniko(1)": 4,
    "chriboniko's": 4,
    "chriboniko's(1)": 4,
    "chriptosporidium": 6,
    "chris": 1,
    "chris'": 1,
    "chrisco": 2,
    "chriscoe": 2,
    "chrisman": 2,
    "chrismer": 4,
    "chrismer(1)": 2,
    "chrismon": 2,
    "chrisp": 1,
    "chriss": 1,
    "chrissie": 2,
    "chrissy": 2,
    "christ": 1,
    "christ's": 1,
    "christa": 2,
    "christabelle": 3,
    "christakos": 3,
    "christal": 2,
    "christchurch": 2,
    "christel": 2,
    "christen": 2,
    "christenberry": 4,
    "christenbury": 4,
    "christendom": 3,
    "christened": 2,
    "christening": 3,
    "christening(1)": 2,
    "christensen": 3,
    "christenson": 3,
    "christeson": 3,
    "christi": 2,
    "christiaan": 3,
    "christian": 2,
    "christian(1)": 2,
    "christiana": 4,
    "christiane": 3,
    "christianity": 5,
    "christianity's": 5,
    "christianization": 5,
    "christianize": 3,
    "christianized": 3,
    "christianna": 4,
    "christianne": 3,
    "christiano": 4,
    "christians": 2,
    "christians(1)": 2,
    "christiansen": 3,
    "christianson": 3,
    "christiansted": 3,
    "christic": 2,
    "christie": 2,
    "christie's": 2,
    "christies": 2,
    "christina": 3,
    "christine": 2,
    "christine's": 2,
    "christison": 3,
    "christlieb": 2,
    "christman": 2,
    "christman's": 2,
    "christmann": 2,
    "christmas": 2,
    "christmas'": 2,
    "christmases": 3,
    "christmastime": 3,
    "christner": 2,
    "christo": 2,
    "christoff": 2,
    "christoffel": 3,
    "christoffersen": 4,
    "christoffersen(1)": 4,
    "christofferson": 4,
    "christon": 2,
    "christoph": 2,
    "christophe": 2,
    "christophel": 3,
    "christopher": 3,
    "christopher's": 3,
    "christophersen": 4,
    "christopherson": 4,
    "christopoulos": 4,
    "christy": 2,
    "christy's": 2,
    "chriswell": 2,
    "chrobak": 2,
    "chromakalim": 4,
    "chromalloy": 3,
    "chromatogram": 4,
    "chromatograms": 4,
    "chromatography": 5,
    "chrome": 1,
    "chrominance": 3,
    "chromium": 3,
    "chromosome": 3,
    "chromosome(1)": 3,
    "chromosomes": 3,
    "chromosomes(1)": 3,
    "chronar": 2,
    "chronic": 2,
    "chronically": 4,
    "chronically(1)": 3,
    "chronicle": 3,
    "chronicle's": 3,
    "chronicled": 3,
    "chronicler": 3,
    "chroniclers": 3,
    "chronicles": 3,
    "chronicling": 3,
    "chronis": 2,
    "chronister": 3,
    "chronological": 5,
    "chronologically": 5,
    "chronologies": 4,
    "chronology": 4,
    "chronowitz": 3,
    "chrostowski": 3,
    "chrusciel": 2,
    "chrysalis": 3,
    "chrysanthemum": 4,
    "chrysanthemums": 4,
    "chryseis": 2,
    "chrysler": 2,
    "chrysler's": 2,
    "chryslers": 2,
    "chryst": 1,
    "chrystal": 2,
    "chrzan": 2,
    "chrzanowski": 4,
    "chseing": 1,
    "chu": 1,
    "chua": 2,
    "chua(1)": 1,
    "chuah": 2,
    "chuan": 2,
    "chuang": 1,
    "chuang(1)": 1,
    "chuba": 2,
    "chubais": 2,
    "chubb": 1,
    "chubb's": 1,
    "chubbuck": 2,
    "chubby": 2,
    "chubu": 2,
    "chuck": 1,
    "chuck's": 1,
    "chuck-a-luck": 3,
    "chucked": 1,
    "chuckie": 2,
    "chucking": 2,
    "chuckle": 2,
    "chuckled": 2,
    "chuckles": 2,
    "chuckling": 2,
    "chudler": 2,
    "chudy": 2,
    "chudzik": 2,
    "chudzinski": 3,
    "chug": 1,
    "chugai": 2,
    "chugged": 1,
    "chugging": 2,
    "chugoku": 3,
    "chui": 2,
    "chujitsuya": 4,
    "chukchi": 2,
    "chul": 1,
    "chula": 2,
    "chum": 1,
    "chumbley": 2,
    "chumley": 2,
    "chummy": 2,
    "chumney": 2,
    "chump": 1,
    "chums": 1,
    "chun": 1,
    "chun's": 1,
    "chung": 1,
    "chung's": 1,
    "chunk": 1,
    "chunks": 1,
    "chunky": 2,
    "chunn": 1,
    "chunnel": 2,
    "chupp": 1,
    "chura": 2,
    "church": 1,
    "church's": 2,
    "churches": 2,
    "churches(1)": 2,
    "churches'": 2,
    "churchgoer": 3,
    "churchgoers": 3,
    "churchgoing": 3,
    "churchhouse": 2,
    "churchill": 2,
    "churchill(1)": 2,
    "churchill's": 2,
    "churchill's(1)": 2,
    "churchman": 2,
    "churchmen": 2,
    "churchwell": 2,
    "churchyard": 2,
    "churilla": 3,
    "churkin": 2,
    "churkin's": 2,
    "churlish": 2,
    "churn": 1,
    "churned": 1,
    "churning": 2,
    "churns": 1,
    "churry": 2,
    "chuse": 1,
    "chuse(1)": 1,
    "chusmir": 2,
    "chustz": 1,
    "chute": 1,
    "chutes": 1,
    "chutney": 2,
    "chutzpah": 2,
    "chutzpah(1)": 2,
    "chykatka": 3,
    "chynoweth": 3,
    "chyron": 2,
    "chyron's": 2,
    "cia": 3,
    "ciaccia": 4,
    "ciaccia(1)": 4,
    "ciaccio": 3,
    "ciampa": 2,
    "ciampi": 2,
    "cian": 1,
    "cianci": 2,
    "ciancio": 3,
    "cianciola": 3,
    "cianciolo": 3,
    "cianciulli": 3,
    "ciani": 2,
    "ciano": 3,
    "ciao": 1,
    "ciaobella": 3,
    "ciaramella": 4,
    "ciaramitaro": 5,
    "ciaravino": 4,
    "ciardi": 2,
    "ciarlo": 2,
    "ciavarella": 4,
    "ciba": 2,
    "ciba(1)": 2,
    "ciba's": 2,
    "ciba's(1)": 2,
    "ciborowski": 4,
    "cibro": 2,
    "cibula": 3,
    "cicada": 3,
    "cicadas": 3,
    "cicala": 3,
    "cicalese": 4,
    "ciccarelli": 4,
    "ciccarello": 4,
    "ciccarone": 3,
    "cicco": 2,
    "ciccone": 3,
    "cicely": 3,
    "cicero": 3,
    "cicerone": 3,
    "cichocki": 3,
    "cichon": 2,
    "cichowski": 3,
    "cichy": 2,
    "cicily": 3,
    "cicio": 3,
    "cicippio": 4,
    "cid": 1,
    "cider": 2,
    "cie": 1,
    "cie(1)": 3,
    "ciel": 1,
    "ciera": 2,
    "cieri": 2,
    "ciesielski": 3,
    "ciesla": 2,
    "cieslak": 2,
    "cieslewicz": 3,
    "cieslik": 2,
    "cieslinski": 3,
    "cifelli": 3,
    "cifra": 2,
    "cifuentes": 3,
    "ciga": 2,
    "cigar": 2,
    "cigarette": 3,
    "cigarette's": 3,
    "cigarettes": 3,
    "cigars": 2,
    "cigna": 2,
    "cigna's": 2,
    "cihak": 2,
    "cihlar": 2,
    "cilag": 2,
    "cilantro": 3,
    "cilcorp": 2,
    "cilento": 3,
    "ciliates": 3,
    "ciliberto": 4,
    "cilicia": 3,
    "ciller": 2,
    "cilley": 2,
    "cillo": 2,
    "cilluffo": 3,
    "cilva": 2,
    "cima": 2,
    "cimaglia": 4,
    "cimarron": 3,
    "ciments": 2,
    "ciminero": 4,
    "cimini": 3,
    "cimino": 3,
    "cimmino": 3,
    "cimo": 2,
    "cimorelli": 4,
    "cina": 2,
    "cinch": 1,
    "cinched": 1,
    "cincinnati": 4,
    "cincinnati's": 4,
    "cinco": 2,
    "cincotta": 3,
    "cinder": 2,
    "cinderella": 4,
    "cinders": 2,
    "cindie": 2,
    "cindric": 2,
    "cindy": 2,
    "cindy's": 2,
    "cinelli": 3,
    "cinema": 3,
    "cinema's": 3,
    "cinemark": 3,
    "cinemas": 3,
    "cinematic": 4,
    "cinematographer": 6,
    "cinematography": 6,
    "cinemax": 3,
    "cineplex": 3,
    "cineplex's": 4,
    "cinergy": 3,
    "cini": 2,
    "cinnabar": 3,
    "cinnabon": 3,
    "cinnaminson": 4,
    "cinnamon": 3,
    "cinnamonson": 4,
    "cino": 2,
    "cinq": 1,
    "cinque": 1,
    "cinquemani": 4,
    "cinram": 2,
    "cinthie": 2,
    "cintron": 2,
    "ciocca": 2,
    "cioffi": 3,
    "ciolek": 3,
    "ciolino": 3,
    "ciotti": 2,
    "cipher": 2,
    "cipolla": 3,
    "cipollone": 3,
    "cipollone(1)": 4,
    "cipri": 2,
    "cipriani": 4,
    "cipriano": 4,
    "cira": 2,
    "ciraulo": 3,
    "circa": 2,
    "circadian": 4,
    "circle": 2,
    "circle's": 2,
    "circled": 2,
    "circles": 2,
    "circling": 3,
    "circling(1)": 2,
    "circon": 2,
    "circuit": 2,
    "circuit's": 2,
    "circuited": 3,
    "circuitous": 4,
    "circuitry": 3,
    "circuits": 2,
    "circular": 3,
    "circularize": 4,
    "circularizing": 5,
    "circularly": 4,
    "circulars": 3,
    "circulate": 3,
    "circulated": 4,
    "circulated(1)": 4,
    "circulates": 3,
    "circulating": 4,
    "circulation": 4,
    "circulations": 4,
    "circulatory": 5,
    "circumcise": 3,
    "circumcised": 3,
    "circumcision": 4,
    "circumference": 3,
    "circumnavigate": 5,
    "circumscribe": 3,
    "circumscribed": 3,
    "circumspect": 3,
    "circumspection": 4,
    "circumstance": 3,
    "circumstances": 4,
    "circumstances(1)": 4,
    "circumstantial": 4,
    "circumstantial(1)": 4,
    "circumstantially": 5,
    "circumstantially(1)": 5,
    "circumvene": 3,
    "circumvent": 3,
    "circumvented": 4,
    "circumventing": 4,
    "circumvention": 4,
    "circumvents": 3,
    "circus": 2,
    "circus's": 3,
    "circuses": 3,
    "cirelli": 3,
    "ciresi": 3,
    "ciriaco": 4,
    "ciriello": 4,
    "cirigliano": 5,
    "cirillo": 3,
    "cirincione": 4,
    "cirino": 3,
    "cirkin": 2,
    "cirone": 2,
    "ciros": 2,
    "cirque": 1,
    "cirrhosis": 3,
    "cirrincione": 4,
    "cirrus": 2,
    "cisar": 2,
    "cisco": 2,
    "cisco's": 2,
    "cisek": 2,
    "cisewski": 3,
    "ciskei": 2,
    "cisler": 3,
    "cisler(1)": 2,
    "cislo": 2,
    "cisneros": 3,
    "cisney": 2,
    "cissell": 2,
    "cissie": 2,
    "cissna": 2,
    "cist": 1,
    "cistercian": 3,
    "cistern": 2,
    "cisterns": 2,
    "ciszek": 2,
    "ciszewski": 3,
    "citadel": 3,
    "citadel's": 3,
    "citation": 3,
    "citations": 3,
    "cite": 1,
    "cited": 2,
    "cited(1)": 2,
    "cites": 1,
    "citgo": 2,
    "citi": 2,
    "citibank": 3,
    "citibank's": 3,
    "citic": 2,
    "citicorp": 3,
    "citicorp's": 3,
    "citicorps": 3,
    "citicorps'": 3,
    "cities": 2,
    "cities'": 2,
    "citing": 2,
    "citisteel": 3,
    "citizen": 3,
    "citizen(1)": 3,
    "citizen's": 3,
    "citizenry": 4,
    "citizenry's": 4,
    "citizens": 3,
    "citizens(1)": 3,
    "citizens'": 3,
    "citizenship": 4,
    "citrano": 3,
    "citric": 2,
    "citrin": 2,
    "citrine": 2,
    "citro": 2,
    "citroen": 2,
    "citron": 2,
    "citron(1)": 2,
    "citron's": 2,
    "citron's(1)": 2,
    "citronella": 4,
    "citrosuco": 4,
    "citrucel": 3,
    "citrucel's": 3,
    "citrus": 2,
    "citrus's": 3,
    "citrus's(1)": 3,
    "cittadino": 4,
    "city": 2,
    "city's": 2,
    "cityfed": 3,
    "cityplace": 3,
    "cityside": 3,
    "citytrust": 3,
    "citywide": 3,
    "ciucci": 2,
    "ciudad": 3,
    "ciulla": 2,
    "ciullo": 2,
    "civet": 2,
    "civic": 2,
    "civics": 2,
    "civil": 2,
    "civiletti": 4,
    "civilian": 3,
    "civilians": 3,
    "civility": 4,
    "civilization": 5,
    "civilizations": 5,
    "civilize": 3,
    "civilized": 3,
    "civilly": 3,
    "civitello": 4,
    "cizek": 2,
    "cizik": 2,
    "cizneros": 3,
    "claar": 1,
    "claassen": 2,
    "clabaugh": 2,
    "clabir": 2,
    "clabo": 2,
    "claborn": 2,
    "clabough": 2,
    "clack": 1,
    "clackamas": 3,
    "clad": 1,
    "claddagh": 2,
    "cladification": 5,
    "claes": 1,
    "claeys": 1,
    "claffey": 2,
    "claflin": 2,
    "clagett": 2,
    "clagg": 1,
    "claggett": 2,
    "clague": 1,
    "claiborn": 2,
    "claiborne": 2,
    "claiborne's": 2,
    "claiborne's(1)": 2,
    "claim": 1,
    "claimant": 2,
    "claimants": 2,
    "claimants'": 2,
    "claimed": 1,
    "claiming": 2,
    "claims": 1,
    "clair": 1,
    "claire": 1,
    "claire's": 1,
    "clairmont": 2,
    "clairol": 2,
    "clairson": 2,
    "clairvoyance": 3,
    "clairvoyant": 3,
    "clam": 1,
    "clamber": 2,
    "clambered": 2,
    "clamen": 2,
    "clammed": 1,
    "clammy": 2,
    "clamor": 2,
    "clamored": 2,
    "clamoring": 3,
    "clamp": 1,
    "clampdown": 2,
    "clamped": 1,
    "clampett": 2,
    "clamping": 2,
    "clampitt": 2,
    "clamps": 1,
    "clams": 1,
    "clamshell": 2,
    "clan": 1,
    "clancey": 2,
    "clancy": 2,
    "clancy's": 2,
    "clandestine": 3,
    "clandestinely": 4,
    "clang": 1,
    "clanging": 2,
    "clanin": 2,
    "clank": 1,
    "clanking": 2,
    "clannish": 2,
    "clans": 1,
    "clanton": 2,
    "clap": 1,
    "clapboard": 2,
    "clapboards": 2,
    "clapham": 2,
    "clapman": 2,
    "clapp": 1,
    "clapped": 1,
    "clapper": 2,
    "clapping": 2,
    "claps": 1,
    "clapsaddle": 3,
    "clapton": 2,
    "clapton's": 2,
    "clar": 1,
    "clara": 2,
    "clara(1)": 2,
    "clara's": 2,
    "clara's(1)": 2,
    "clarabelle": 3,
    "clarabelle(1)": 3,
    "claramae": 3,
    "claran": 2,
    "clarcor": 2,
    "clardy": 2,
    "clare": 1,
    "claremont": 2,
    "claren": 2,
    "clarence": 2,
    "clarendon": 3,
    "claresta": 3,
    "clarette": 2,
    "clarey": 2,
    "claribel": 3,
    "clarice": 2,
    "clarida": 3,
    "claridge": 2,
    "claridges": 3,
    "claridon": 3,
    "clarification": 5,
    "clarifications": 5,
    "clarified": 3,
    "clarifies": 3,
    "clarify": 3,
    "clarifying": 4,
    "clarimond": 3,
    "clarinda": 3,
    "clarine": 2,
    "clarinet": 3,
    "clarinetist": 4,
    "clarinetists": 4,
    "clarins": 2,
    "clarion": 3,
    "claris": 2,
    "clarissa": 3,
    "clarisse": 2,
    "clarisse(1)": 2,
    "clarita": 3,
    "claritin": 3,
    "clarity": 3,
    "clarity(1)": 3,
    "clark": 1,
    "clark's": 1,
    "clarke": 1,
    "clarke's": 1,
    "clarken": 2,
    "clarkin": 2,
    "clarks": 1,
    "clarksburg": 2,
    "clarkson": 2,
    "clarkston": 2,
    "clarksville": 2,
    "claro": 2,
    "clarostat": 3,
    "clarridge": 2,
    "clarrisse": 2,
    "clary": 2,
    "clasby": 2,
    "clasen": 2,
    "clash": 1,
    "clashed": 1,
    "clashes": 2,
    "clashing": 2,
    "clason": 2,
    "clasp": 1,
    "clasped": 1,
    "class": 1,
    "class's": 2,
    "classaction": 3,
    "classactions": 3,
    "classed": 1,
    "classen": 2,
    "classes": 2,
    "classes(1)": 2,
    "classic": 2,
    "classical": 3,
    "classically": 3,
    "classicism": 4,
    "classicist": 3,
    "classics": 2,
    "classier": 3,
    "classifiable": 5,
    "classification": 5,
    "classifications": 5,
    "classified": 3,
    "classifies": 3,
    "classify": 3,
    "classifying": 4,
    "classing": 2,
    "classless": 2,
    "classman": 2,
    "classmate": 2,
    "classmates": 2,
    "classmen": 2,
    "classon": 2,
    "classroom": 2,
    "classrooms": 2,
    "classy": 2,
    "clatter": 2,
    "clattering": 3,
    "claud": 1,
    "claude": 1,
    "claudet": 2,
    "claudette": 2,
    "claudia": 3,
    "claudian": 3,
    "claudie": 2,
    "claudina": 3,
    "claudina(1)": 3,
    "claudine": 2,
    "claudio": 3,
    "claudius": 3,
    "claudson": 2,
    "claunch": 1,
    "claus": 1,
    "claus'": 1,
    "clause": 1,
    "clausell": 2,
    "clausen": 2,
    "clauser": 2,
    "clauses": 2,
    "clauses(1)": 2,
    "clausing": 2,
    "clauson": 2,
    "clauss": 1,
    "claussen": 2,
    "claustrophobia": 5,
    "claustrophobic": 4,
    "clavette": 2,
    "clavichord": 3,
    "clavicle": 3,
    "clavicle(1)": 3,
    "clavin": 2,
    "claw": 1,
    "clawed": 1,
    "clawing": 2,
    "claws": 1,
    "clawson": 2,
    "claxon": 2,
    "claxton": 2,
    "clay": 1,
    "claybaugh": 2,
    "clayborn": 2,
    "clayborne": 2,
    "claybourne": 2,
    "claybrook": 2,
    "claybrooks": 2,
    "clayburn": 2,
    "claycomb": 2,
    "clayey": 2,
    "clayman": 2,
    "claymation": 3,
    "claymont": 2,
    "claymore": 2,
    "claypool": 2,
    "claypoole": 2,
    "clays": 1,
    "clayson": 2,
    "clayton": 2,
    "clayton's": 2,
    "claytor": 2,
    "claywell": 2,
    "cleah": 2,
    "clean": 1,
    "cleaned": 1,
    "cleaner": 2,
    "cleaners": 2,
    "cleanest": 2,
    "cleaning": 2,
    "cleanliness": 3,
    "cleanly": 2,
    "cleanness": 2,
    "cleans": 1,
    "cleanse": 1,
    "cleansed": 1,
    "cleanser": 2,
    "cleansers": 2,
    "cleansing": 2,
    "cleantha": 2,
    "cleanup": 2,
    "cleanups": 2,
    "clear": 1,
    "clearance": 2,
    "clearances": 3,
    "clearcut": 2,
    "clearcuts": 2,
    "clearcutting": 3,
    "cleared": 1,
    "clearer": 2,
    "clearest": 2,
    "clearing": 2,
    "clearinghouse": 3,
    "clearinghouses": 4,
    "clearly": 2,
    "clearman": 2,
    "clears": 1,
    "clearwater": 3,
    "cleary": 2,
    "cleat": 1,
    "cleats": 1,
    "cleavage": 2,
    "cleavage(1)": 2,
    "cleave": 1,
    "cleaveland": 2,
    "cleavenger": 3,
    "cleaver": 2,
    "cleaves": 1,
    "cleckler": 2,
    "cleckley": 2,
    "cleckner": 2,
    "cleek": 1,
    "cleere": 1,
    "cleese": 1,
    "cleeton": 2,
    "clef": 1,
    "cleft": 1,
    "clegg": 1,
    "cleghorn": 2,
    "cleland": 2,
    "clell": 1,
    "clelland": 2,
    "clem": 1,
    "clemans": 2,
    "clematis": 3,
    "clematis(1)": 3,
    "clemen": 2,
    "clemence": 2,
    "clemency": 3,
    "clemens": 2,
    "clemensen": 3,
    "clemenson": 3,
    "clement": 2,
    "clemente": 3,
    "clemente(1)": 3,
    "clemente's": 3,
    "clemente's(1)": 3,
    "clementes": 3,
    "clementes(1)": 3,
    "clementi": 3,
    "clementia": 3,
    "clementine": 3,
    "clementine(1)": 3,
    "clements": 2,
    "clementson": 3,
    "clementz": 2,
    "clemmer": 2,
    "clemmie": 2,
    "clemmons": 2,
    "clemmy": 2,
    "clemo": 2,
    "clemons": 2,
    "clemson": 2,
    "clench": 1,
    "clenched": 1,
    "clencher": 2,
    "clenches": 2,
    "clendaniel": 3,
    "clendenen": 3,
    "clendenin": 3,
    "clendening": 3,
    "clendenning": 3,
    "clenney": 2,
    "clenwar": 2,
    "cleo": 2,
    "cleopatra": 4,
    "cleopatra's": 4,
    "clephane": 2,
    "clepper": 2,
    "clerc": 1,
    "clercq": 1,
    "clergy": 2,
    "clergyman": 3,
    "clergyman(1)": 3,
    "clergymen": 3,
    "clergymen(1)": 3,
    "cleric": 2,
    "clerical": 3,
    "clerical(1)": 3,
    "clerics": 2,
    "clerissa": 3,
    "clerk": 1,
    "clerk's": 1,
    "clerkin": 2,
    "clerks": 1,
    "clerks'": 1,
    "clermont": 2,
    "cleva": 2,
    "cleve": 1,
    "cleveland": 2,
    "cleveland's": 2,
    "clevelander": 3,
    "clevelanders": 3,
    "cleven": 2,
    "clevenger": 3,
    "clever": 2,
    "cleverly": 3,
    "cleverness": 3,
    "clevetrust": 2,
    "clevie": 2,
    "clevinger": 3,
    "clevite": 2,
    "clevite's": 2,
    "clewell": 2,
    "clewis": 2,
    "clewiston": 3,
    "clews": 1,
    "cliantha": 3,
    "cliburn": 2,
    "cliche": 2,
    "cliched": 2,
    "cliches": 2,
    "click": 1,
    "clicked": 1,
    "clicker": 2,
    "clicking": 2,
    "clickner": 2,
    "clicks": 1,
    "client": 2,
    "client's": 2,
    "clientele": 3,
    "clients": 2,
    "clients'": 2,
    "cliett": 1,
    "clif": 1,
    "cliff": 1,
    "cliff's": 1,
    "cliffe": 1,
    "cliffhanger": 3,
    "cliffhangers": 3,
    "clifford": 2,
    "clifford's": 2,
    "cliffs": 1,
    "cliffs'": 1,
    "clift": 1,
    "clifton": 2,
    "cliggott": 2,
    "clim": 1,
    "climaco": 3,
    "climactic": 3,
    "climate": 2,
    "climate(1)": 2,
    "climates": 2,
    "climates(1)": 2,
    "climatic": 3,
    "climatologist": 5,
    "climatologist(1)": 5,
    "climatologists": 5,
    "climatologists(1)": 5,
    "climatologists(2)": 5,
    "climatologists(3)": 5,
    "climax": 2,
    "climaxed": 2,
    "climaxes": 3,
    "climaxes(1)": 3,
    "climb": 1,
    "climbed": 1,
    "climber": 2,
    "climbers": 2,
    "climbers'": 2,
    "climbing": 2,
    "climbs": 1,
    "climer": 2,
    "climes": 1,
    "clinard": 2,
    "clinch": 1,
    "clinched": 1,
    "clincher": 2,
    "clinches": 2,
    "clinches(1)": 2,
    "clinching": 2,
    "cline": 1,
    "clines": 1,
    "clines's": 2,
    "cling": 1,
    "clingan": 2,
    "clingenpeel": 3,
    "clinger": 2,
    "clingerman": 3,
    "clinging": 2,
    "clingman": 2,
    "clings": 1,
    "clini": 2,
    "clinic": 2,
    "clinic's": 2,
    "clinical": 3,
    "clinical(1)": 3,
    "clinical's": 3,
    "clinically": 4,
    "clinically(1)": 3,
    "clinician": 3,
    "clinicians": 3,
    "clinics": 2,
    "clinique": 2,
    "clink": 1,
    "clinkenbeard": 3,
    "clinkscale": 2,
    "clinkscales": 2,
    "clint": 1,
    "clinton": 2,
    "clinton's": 2,
    "clintonite": 3,
    "clintonites": 3,
    "clintonomics": 4,
    "clintons": 2,
    "clintons'": 2,
    "clio": 2,
    "clip": 1,
    "clipboard": 2,
    "clippard": 2,
    "clipped": 1,
    "clipper": 2,
    "clippers": 2,
    "clipping": 2,
    "clippinger": 3,
    "clippings": 2,
    "clips": 1,
    "clique": 1,
    "cliques": 1,
    "clites": 1,
    "clitoris": 3,
    "clive": 1,
    "cliver": 2,
    "cloak": 1,
    "cloaked": 1,
    "cloaking": 2,
    "cloakroom": 2,
    "clobber": 2,
    "clobbered": 2,
    "clobbering": 3,
    "clock": 1,
    "clock's": 1,
    "clocked": 1,
    "clocker": 2,
    "clockers": 2,
    "clocking": 2,
    "clocks": 1,
    "clockwise": 2,
    "clockwork": 2,
    "clodfelter": 3,
    "clodoveo": 4,
    "cloe": 1,
    "cloer": 2,
    "cloey": 2,
    "clog": 1,
    "clogged": 1,
    "clogging": 2,
    "clogging(1)": 2,
    "clogs": 1,
    "clogston": 2,
    "cloherty": 3,
    "clohessy": 3,
    "cloister": 2,
    "cloistered": 2,
    "cloisters": 2,
    "cloke": 1,
    "clomipramine": 4,
    "clonch": 1,
    "clone": 1,
    "cloned": 1,
    "clones": 1,
    "clones'": 1,
    "clonidine": 3,
    "cloning": 2,
    "cloninger": 3,
    "clonts": 1,
    "clontz": 1,
    "cloonan": 2,
    "clooney": 2,
    "clootie": 2,
    "clopper": 2,
    "clopton": 2,
    "clore": 1,
    "clore's": 1,
    "clorinda": 3,
    "clorox": 2,
    "clos": 1,
    "close": 1,
    "close(1)": 1,
    "close-up": 2,
    "closed": 1,
    "closedown": 2,
    "closedowns": 2,
    "closely": 2,
    "closeness": 2,
    "closer": 2,
    "closer(1)": 2,
    "closes": 2,
    "closest": 2,
    "closet": 2,
    "closeted": 3,
    "closets": 2,
    "closeup": 2,
    "closeups": 2,
    "closing": 2,
    "closings": 2,
    "closs": 1,
    "closser": 2,
    "closson": 2,
    "closure": 2,
    "closures": 2,
    "clot": 1,
    "clotfelter": 3,
    "cloth": 1,
    "clothe": 1,
    "clothed": 1,
    "clothes": 1,
    "clothes(1)": 1,
    "clotheshorse": 2,
    "clothestime": 2,
    "clothier": 2,
    "clothiers": 2,
    "clothilda": 3,
    "clothilde": 2,
    "clothing": 2,
    "cloths": 1,
    "clotilda": 3,
    "clots": 1,
    "clott": 1,
    "clotted": 2,
    "clotted(1)": 2,
    "clotting": 2,
    "cloture": 2,
    "clouatre": 2,
    "cloud": 1,
    "cloudburst": 2,
    "clouded": 2,
    "cloudiness": 3,
    "clouding": 2,
    "cloudless": 2,
    "clouds": 1,
    "cloudy": 2,
    "clough": 1,
    "clougherty": 3,
    "clouse": 1,
    "clouser": 2,
    "clout": 1,
    "clouthier": 3,
    "clouthier(1)": 3,
    "clouthier(2)": 3,
    "cloutier": 3,
    "clover": 2,
    "cloverleaf": 3,
    "cloves": 1,
    "clovis": 2,
    "clow": 1,
    "cloward": 2,
    "clowdus": 2,
    "clower": 2,
    "clowers": 2,
    "clowes": 1,
    "clown": 1,
    "clowney": 2,
    "clowning": 2,
    "clowns": 1,
    "cloy": 1,
    "cloyd": 1,
    "cloying": 2,
    "clozapine": 3,
    "club": 1,
    "club's": 1,
    "clubb": 1,
    "clubbed": 1,
    "clubbing": 2,
    "clubby": 2,
    "clubhouse": 2,
    "clubhouses": 3,
    "clubs": 1,
    "clucas": 2,
    "cluck": 1,
    "cluckey": 2,
    "clucking": 2,
    "clucks": 1,
    "clue": 1,
    "clued": 1,
    "clueless": 2,
    "clues": 1,
    "cluett": 2,
    "cluff": 1,
    "clugston": 2,
    "cluj": 1,
    "cluj(1)": 4,
    "clukey": 2,
    "clum": 1,
    "clump": 1,
    "clumping": 2,
    "clumps": 1,
    "clumpy": 2,
    "clumsily": 3,
    "clumsiness": 3,
    "clumsy": 2,
    "clune": 1,
    "clung": 1,
    "clunk": 1,
    "clunker": 2,
    "clunkers": 2,
    "clunks": 1,
    "clunky": 2,
    "cluny": 2,
    "cluster": 2,
    "clustered": 2,
    "clustering": 3,
    "clusters": 2,
    "clutch": 1,
    "clutched": 1,
    "clutches": 2,
    "clutches(1)": 2,
    "clutching": 2,
    "clute": 1,
    "clutter": 2,
    "cluttered": 2,
    "cluttering": 3,
    "clutts": 1,
    "clyatt": 2,
    "clyburn": 2,
    "clyde": 1,
    "clydesdale": 2,
    "clymene": 2,
    "clymer": 2,
    "clyne": 1,
    "clyte": 1,
    "clytie": 2,
    "clyve": 1,
    "cmos": 2,
    "cmos(1)": 4,
    "cmu": 3,
    "cmx": 2,
    "cnn": 3,
    "cnn's": 3,
    "cnn.com": 5,
    "cnnfn": 5,
    "co": 1,
    "co-op": 2,
    "co-operative": 5,
    "co-operative(1)": 4,
    "co-opt": 2,
    "co-opted": 3,
    "co-wife": 2,
    "co.": 1,
    "co.(1)": 3,
    "coach": 1,
    "coach's": 2,
    "coached": 1,
    "coaches": 2,
    "coaching": 2,
    "coachman": 2,
    "coad": 1,
    "coady": 2,
    "coagulate": 4,
    "coagulating": 5,
    "coagulation": 5,
    "coakley": 2,
    "coal": 1,
    "coal's": 1,
    "coale": 1,
    "coalesce": 3,
    "coalesced": 3,
    "coalescence": 4,
    "coalesces": 4,
    "coalescing": 4,
    "coalition": 4,
    "coalition's": 4,
    "coalitions": 4,
    "coals": 1,
    "coalson": 2,
    "coan": 1,
    "coar": 1,
    "coarse": 1,
    "coarsening": 3,
    "coarser": 2,
    "coarticulate": 5,
    "coarticulated": 6,
    "coarticulates": 5,
    "coarticulating": 6,
    "coarticulation": 6,
    "coast": 1,
    "coast's": 1,
    "coastal": 2,
    "coastal's": 2,
    "coastamerica": 5,
    "coastamerica's": 5,
    "coasted": 2,
    "coaster": 2,
    "coasters": 2,
    "coasting": 2,
    "coastline": 2,
    "coastlines": 2,
    "coasts": 1,
    "coat": 1,
    "coat's": 1,
    "coate": 2,
    "coated": 2,
    "coated(1)": 2,
    "coates": 2,
    "coatesville": 2,
    "coating": 2,
    "coatings": 2,
    "coatney": 2,
    "coats": 1,
    "coattail": 2,
    "coattails": 2,
    "coauthor": 3,
    "coauthored": 3,
    "coauthoring": 4,
    "coauthors": 3,
    "coax": 1,
    "coaxed": 1,
    "coaxes": 2,
    "coaxial": 4,
    "coaxing": 2,
    "coaxum": 2,
    "cob": 1,
    "cobain": 2,
    "cobain's": 2,
    "cobaine": 2,
    "cobalt": 2,
    "cobaugh": 2,
    "cobb": 1,
    "cobbett": 2,
    "cobbins": 2,
    "cobble": 2,
    "cobbled": 2,
    "cobbler": 2,
    "cobbler's": 2,
    "cobblers": 2,
    "cobblestone": 3,
    "cobblestones": 3,
    "cobbs": 1,
    "cobe": 1,
    "coben": 2,
    "cobepa": 3,
    "coberly": 3,
    "cobern": 2,
    "cobert": 2,
    "cobey": 2,
    "cobia": 3,
    "cobian": 3,
    "cobin": 2,
    "coble": 2,
    "cobleigh": 2,
    "coblentz": 2,
    "cobler": 3,
    "cobler(1)": 2,
    "cobliner": 3,
    "cobo": 2,
    "cobol": 2,
    "cobos": 2,
    "cobra": 2,
    "cobras": 2,
    "cobre": 2,
    "cobrin": 2,
    "cobs": 1,
    "coburn": 2,
    "cobweb": 2,
    "cobwebs": 2,
    "coby": 2,
    "coca": 2,
    "cocaine": 2,
    "cocanino": 4,
    "cocanougher": 4,
    "cocca": 2,
    "coccaro": 3,
    "cocchi": 2,
    "coccia": 2,
    "cocco": 2,
    "coccus": 2,
    "cochairman": 3,
    "cochenour": 3,
    "cochin": 2,
    "cochlea": 3,
    "cochlear": 3,
    "cochles": 2,
    "cochran": 2,
    "cochran's": 2,
    "cochrane": 2,
    "cochranton": 3,
    "cock": 1,
    "cockamamie": 4,
    "cockatoo": 3,
    "cockatoos": 3,
    "cockburn": 2,
    "cockburn's": 2,
    "cockburn's(1)": 2,
    "cocke": 1,
    "cocked": 1,
    "cocked(1)": 1,
    "cocker": 2,
    "cockerell": 3,
    "cockerham": 3,
    "cockerill": 3,
    "cockey": 2,
    "cockeyed": 2,
    "cockfield": 2,
    "cockiness": 3,
    "cocking": 2,
    "cockle": 2,
    "cockles": 2,
    "cocklin": 2,
    "cockman": 2,
    "cockney": 2,
    "cockpit": 2,
    "cockpits": 2,
    "cockran": 2,
    "cockrell": 2,
    "cockrill": 2,
    "cockroach": 2,
    "cockroaches": 3,
    "cockroft": 2,
    "cockrum": 2,
    "cocks": 1,
    "cocktail": 2,
    "cocktails": 2,
    "cockwell": 2,
    "cockwell's": 2,
    "cocky": 2,
    "coco": 2,
    "cocoa": 2,
    "cocoanuts": 3,
    "cocom": 2,
    "coconino": 4,
    "coconut": 3,
    "coconuts": 3,
    "cocoon": 2,
    "cocooning": 3,
    "cocoons": 2,
    "cocos": 2,
    "cocozza": 3,
    "cocuzza": 3,
    "cod": 1,
    "cod(1)": 3,
    "coda": 2,
    "codag": 2,
    "coday": 2,
    "codd": 1,
    "codding": 2,
    "coddington": 3,
    "coddle": 2,
    "coddled": 2,
    "coddling": 3,
    "coddling(1)": 2,
    "code": 1,
    "code's": 1,
    "codebreaker": 3,
    "codebreakers": 3,
    "coded": 2,
    "codelco": 3,
    "coder": 2,
    "coderre": 2,
    "codes": 1,
    "codesa": 3,
    "codification": 5,
    "codified": 3,
    "codifies": 3,
    "codify": 3,
    "codifying": 4,
    "coding": 2,
    "codispoti": 4,
    "codlin": 2,
    "codner": 2,
    "codrescu": 3,
    "codrescu's": 3,
    "cody": 2,
    "coe": 1,
    "coeburn": 2,
    "coed": 2,
    "coed(1)": 1,
    "coeds": 2,
    "coeducational": 6,
    "coefficient": 4,
    "coefficients": 4,
    "coehlo": 2,
    "coelacanth": 3,
    "coelho": 3,
    "coello": 3,
    "coen": 2,
    "coenen": 3,
    "coenzyme": 3,
    "coequal": 3,
    "coerce": 2,
    "coerced": 2,
    "coercing": 3,
    "coercion": 3,
    "coercive": 3,
    "coeur": 1,
    "coexist": 3,
    "coexisted": 4,
    "coexistence": 4,
    "coexisting": 4,
    "coey": 2,
    "cofer": 2,
    "coffaro": 3,
    "coffee": 2,
    "coffee(1)": 2,
    "coffee's": 2,
    "coffee's(1)": 2,
    "coffeehouse": 3,
    "coffeehouses": 4,
    "coffeen": 2,
    "coffees": 2,
    "coffel": 2,
    "coffelt": 2,
    "coffer": 2,
    "coffers": 2,
    "coffers(1)": 2,
    "coffey": 2,
    "coffield": 2,
    "coffin": 2,
    "coffing": 2,
    "coffins": 2,
    "cofflin": 2,
    "coffman": 2,
    "cofide": 2,
    "cofield": 2,
    "cofounder": 3,
    "cog": 1,
    "cogan": 2,
    "cogar": 2,
    "cogbill": 2,
    "cogburn": 2,
    "cogdell": 2,
    "cogdill": 2,
    "cogeco": 3,
    "cogema": 2,
    "cogency": 3,
    "cogenerate": 4,
    "cogenerated": 5,
    "cogeneration": 5,
    "cogenerator": 5,
    "cogenerators": 5,
    "cogent": 2,
    "coger": 2,
    "coggeshall": 3,
    "coggin": 2,
    "coggins": 2,
    "coghill": 2,
    "coghlan": 2,
    "cogitate": 3,
    "cogitation": 4,
    "cogley": 2,
    "coglianese": 5,
    "cogliano": 4,
    "cognac": 2,
    "cognac(1)": 2,
    "cognetics": 3,
    "cognex": 2,
    "cognition": 3,
    "cognitive": 3,
    "cognizance": 3,
    "cognizant": 3,
    "cognoscenti": 4,
    "cogswell": 2,
    "cohabit": 3,
    "cohabitation": 5,
    "cohabiting": 4,
    "cohan": 2,
    "cohasset": 3,
    "cohea": 3,
    "cohee": 2,
    "cohen": 2,
    "cohen's": 2,
    "cohenour": 3,
    "cohentannoudji": 5,
    "cohere": 2,
    "cohered": 2,
    "coherence": 3,
    "coherent": 3,
    "coherently": 4,
    "coheres": 2,
    "cohesion": 3,
    "cohesive": 3,
    "cohesively": 4,
    "cohesiveness": 4,
    "cohiba": 3,
    "cohick": 2,
    "cohill": 2,
    "cohn": 1,
    "coho": 2,
    "cohoon": 2,
    "cohort": 2,
    "cohorts": 2,
    "cohost": 2,
    "cohosts": 2,
    "cohr": 1,
    "cohron": 2,
    "cohrs": 1,
    "coia": 2,
    "coiffe": 1,
    "coiffed": 1,
    "coil": 1,
    "coile": 1,
    "coiled": 1,
    "coils": 1,
    "coin": 1,
    "coin's": 1,
    "coinage": 2,
    "coincide": 3,
    "coincided": 4,
    "coincidence": 4,
    "coincidences": 5,
    "coincident": 4,
    "coincidental": 5,
    "coincidentally": 6,
    "coincidentally(1)": 6,
    "coincides": 3,
    "coinciding": 4,
    "coined": 1,
    "coiner": 2,
    "coining": 2,
    "coins": 1,
    "coinsurance": 4,
    "cointreau": 2,
    "coipa": 2,
    "coiro": 2,
    "coit": 1,
    "coitsville": 2,
    "coitus": 2,
    "cojimar": 3,
    "cojimar's": 3,
    "cojuangco": 3,
    "cojuangco(1)": 3,
    "coke": 1,
    "coke's": 1,
    "coker": 2,
    "cokes": 1,
    "cokie": 2,
    "cokie's": 2,
    "coking": 2,
    "cokley": 2,
    "cola": 2,
    "cola's": 2,
    "colab": 2,
    "colabella": 4,
    "colaianni": 4,
    "colaizzi": 3,
    "colaluca": 4,
    "colan": 2,
    "colander": 3,
    "colanders": 3,
    "colangelo": 4,
    "colantonio": 5,
    "colantuono": 4,
    "colao": 2,
    "colarusso": 4,
    "colas": 2,
    "colasanti": 4,
    "colasurdo": 4,
    "colavito": 4,
    "colaw": 2,
    "colbath": 2,
    "colbaugh": 2,
    "colbeck": 2,
    "colberg": 2,
    "colbern": 2,
    "colbert": 2,
    "colborn": 2,
    "colborne": 2,
    "colburn": 2,
    "colby": 2,
    "colby's": 2,
    "colbys": 2,
    "colchicine": 3,
    "colclasure": 3,
    "colclough": 2,
    "colcord": 2,
    "cold": 1,
    "cold-bay": 2,
    "cold-blood": 2,
    "cold-blooded": 3,
    "colden": 2,
    "colder": 2,
    "coldest": 2,
    "coldiron": 3,
    "coldly": 2,
    "coldness": 2,
    "coldren": 3,
    "colds": 1,
    "coldwater": 3,
    "coldwell": 2,
    "cole": 1,
    "cole's": 1,
    "colebank": 2,
    "colebreath": 2,
    "colebrook": 2,
    "coleco": 3,
    "coleco's": 3,
    "colee": 2,
    "coleen": 2,
    "colegrove": 2,
    "colella": 3,
    "colello": 3,
    "coleman": 2,
    "coleman's": 2,
    "colen": 2,
    "coler": 2,
    "coleridge": 2,
    "coles": 1,
    "coleslaw": 2,
    "coleson": 3,
    "coleson(1)": 2,
    "colestipol": 3,
    "colestock": 2,
    "coletta": 3,
    "colette": 2,
    "coletti": 3,
    "coleus": 3,
    "coleville": 2,
    "coley": 2,
    "colfer": 2,
    "colford": 2,
    "colgan": 2,
    "colgate": 2,
    "colgate's": 2,
    "colgin": 2,
    "colglazier": 4,
    "colgrove": 2,
    "coli": 2,
    "colicchio": 4,
    "colier": 3,
    "coliform": 3,
    "coliform(1)": 3,
    "coliforms": 3,
    "coliforms(1)": 3,
    "colin": 2,
    "colina": 3,
    "colinas": 3,
    "coline": 3,
    "colino": 3,
    "colis": 2,
    "coliseum": 4,
    "coll": 1,
    "colla": 2,
    "collaborate": 4,
    "collaborated": 5,
    "collaborated(1)": 5,
    "collaborating": 5,
    "collaboration": 5,
    "collaborationist": 6,
    "collaborations": 5,
    "collaborative": 5,
    "collaborative(1)": 4,
    "collaborator": 5,
    "collaborators": 5,
    "collado": 3,
    "collage": 2,
    "collagen": 3,
    "collages": 3,
    "collamore": 3,
    "collapse": 2,
    "collapsed": 2,
    "collapses": 3,
    "collapsible": 4,
    "collapsing": 3,
    "collar": 2,
    "collarbone": 3,
    "collard": 2,
    "collards": 2,
    "collared": 2,
    "collars": 2,
    "collate": 2,
    "collateral": 4,
    "collateralize": 5,
    "collateralized": 5,
    "collazo": 3,
    "colle": 1,
    "colleague": 2,
    "colleague's": 2,
    "colleagues": 2,
    "colleagues'": 2,
    "collect": 2,
    "collected": 3,
    "collectibility": 6,
    "collectible": 4,
    "collectibles": 4,
    "collecting": 3,
    "collection": 3,
    "collections": 3,
    "collective": 3,
    "collectively": 4,
    "collectives": 3,
    "collectivism": 5,
    "collectivist": 4,
    "collectivization": 6,
    "collectivize": 4,
    "collectivized": 4,
    "collector": 3,
    "collector(1)": 2,
    "collector's": 3,
    "collector's(1)": 2,
    "collectors": 3,
    "collectors(1)": 2,
    "collectors'": 3,
    "collectors'(1)": 2,
    "collects": 2,
    "colledge": 2,
    "colleen": 2,
    "college": 2,
    "college's": 3,
    "colleges": 3,
    "colleges'": 3,
    "collegeville": 3,
    "collegial": 4,
    "collegiality": 6,
    "collegian": 3,
    "collegians": 3,
    "collegiate": 3,
    "collen": 2,
    "collender": 3,
    "coller": 2,
    "colleran": 3,
    "collet": 2,
    "collett": 2,
    "colletta": 3,
    "collette": 2,
    "colletti": 3,
    "colleville": 2,
    "colleville's": 2,
    "colley": 2,
    "colli": 2,
    "collick": 2,
    "collide": 2,
    "collided": 3,
    "collider": 3,
    "collides": 2,
    "colliding": 3,
    "collie": 2,
    "collier": 2,
    "collier's": 2,
    "colliers": 2,
    "collies": 2,
    "colligan": 3,
    "collignon": 3,
    "collin": 2,
    "colling": 2,
    "collinge": 2,
    "collings": 2,
    "collingsworth": 3,
    "collingwood": 3,
    "collins": 2,
    "collins'": 2,
    "collins's": 3,
    "collins's(1)": 2,
    "collinson": 3,
    "collinsworth": 3,
    "collis": 2,
    "collision": 3,
    "collisional": 4,
    "collisions": 3,
    "collison": 3,
    "collister": 3,
    "colliver": 3,
    "collman": 2,
    "collocation": 4,
    "collodion": 4,
    "colloid": 2,
    "colloidal": 3,
    "collom": 2,
    "collomb": 2,
    "collopy": 3,
    "colloquial": 4,
    "colloquium": 4,
    "colloquy": 3,
    "collor": 2,
    "collor(1)": 2,
    "collor's": 2,
    "collosio": 4,
    "collosio's": 4,
    "collude": 2,
    "colluded": 3,
    "colluding": 3,
    "collum": 2,
    "collums": 2,
    "collura": 3,
    "collusion": 3,
    "collusive": 3,
    "collver": 2,
    "colly": 2,
    "collyer": 3,
    "colm": 1,
    "colman": 2,
    "colmenero": 4,
    "colmer": 2,
    "colo": 2,
    "colodny": 3,
    "cologne": 2,
    "coloma": 3,
    "colomb": 2,
    "colombari": 4,
    "colombe": 3,
    "colombia": 4,
    "colombia's": 4,
    "colombian": 4,
    "colombians": 4,
    "colombo": 3,
    "colombo's": 3,
    "colon": 2,
    "colonel": 2,
    "colonel's": 2,
    "colonels": 2,
    "colonia": 4,
    "colonial": 4,
    "colonial's": 4,
    "colonialism": 6,
    "colonialist": 5,
    "colonialists": 5,
    "colonials": 4,
    "colonies": 3,
    "colonist": 3,
    "colonists": 3,
    "colonization": 5,
    "colonize": 3,
    "colonized": 3,
    "colonizer": 4,
    "colonizers": 4,
    "colonna": 3,
    "colonnade": 3,
    "colonus": 3,
    "colony": 3,
    "colony's": 3,
    "colopy": 3,
    "color": 2,
    "color(1)": 2,
    "coloradan": 4,
    "coloradans": 4,
    "colorado": 4,
    "colorado(1)": 4,
    "colorado's": 4,
    "colorado's(1)": 4,
    "coloration": 4,
    "coloratura": 5,
    "colorblind": 3,
    "colorcraft": 3,
    "colorectal": 4,
    "colored": 2,
    "coloreds": 3,
    "colorfast": 3,
    "colorful": 3,
    "colorfully": 3,
    "coloring": 3,
    "coloristic": 4,
    "colorization": 5,
    "colorize": 3,
    "colorized": 3,
    "colorizing": 4,
    "colorless": 3,
    "colorocs": 3,
    "coloroll": 3,
    "colors": 2,
    "colorwatch": 3,
    "colosi": 3,
    "colosimo": 4,
    "colosio": 4,
    "colosio's": 4,
    "colossal": 3,
    "colossally": 4,
    "colosseum": 4,
    "colossus": 3,
    "coloured": 2,
    "colpepper": 3,
    "colpitts": 2,
    "colquitt": 2,
    "colson": 2,
    "colston": 2,
    "colstrip": 2,
    "colt": 1,
    "colt's": 1,
    "coltec": 2,
    "colter": 2,
    "coltharp": 2,
    "coltie": 2,
    "colton": 2,
    "coltrain": 2,
    "coltrane": 2,
    "coltrane(1)": 2,
    "coltrane's": 2,
    "coltrane's(1)": 2,
    "coltrin": 2,
    "colts": 1,
    "coltsfoot": 2,
    "colucci": 3,
    "coluccio": 4,
    "columba": 3,
    "columbia": 4,
    "columbia's": 4,
    "columbian": 4,
    "columbians": 4,
    "columbine": 3,
    "columbines": 3,
    "columbo": 3,
    "columbus": 3,
    "columbus'": 3,
    "columbus's": 4,
    "column": 2,
    "columned": 2,
    "columnist": 3,
    "columnists": 3,
    "columns": 2,
    "colunga": 3,
    "colussy": 3,
    "colvard": 2,
    "colver": 2,
    "colvert": 2,
    "colville": 2,
    "colvin": 2,
    "colwell": 2,
    "colyer": 3,
    "com": 1,
    "com's": 1,
    "coma": 2,
    "comair": 2,
    "coman": 2,
    "comanche": 3,
    "comanches": 3,
    "comandante": 4,
    "comandantes": 4,
    "comandeer": 3,
    "comandeered": 3,
    "comandeers": 3,
    "comarco": 3,
    "comas": 2,
    "comatose": 3,
    "comb": 1,
    "combat": 2,
    "combat(1)": 2,
    "combatant": 3,
    "combatants": 3,
    "combating": 3,
    "combative": 3,
    "combative(1)": 3,
    "combativeness": 4,
    "combats": 2,
    "combatting": 3,
    "combe": 1,
    "combed": 1,
    "combee": 2,
    "comber": 2,
    "combes": 1,
    "combest": 2,
    "combinability": 6,
    "combinability(1)": 6,
    "combinable": 4,
    "combination": 4,
    "combinations": 4,
    "combine": 2,
    "combine(1)": 2,
    "combined": 2,
    "combines": 2,
    "combing": 2,
    "combining": 3,
    "combo": 2,
    "combs": 1,
    "combust": 2,
    "combustable": 4,
    "combustion": 3,
    "comby": 2,
    "comcast": 2,
    "comcast's": 2,
    "comdata": 3,
    "comdata(1)": 3,
    "comden": 2,
    "comdex": 2,
    "comdisco": 3,
    "come": 1,
    "come-on": 2,
    "come-ons": 2,
    "comeau": 2,
    "comeaux": 2,
    "comeback": 2,
    "comebacks": 2,
    "comecon": 3,
    "comedian": 4,
    "comedian's": 4,
    "comedians": 4,
    "comedic": 3,
    "comedienne": 4,
    "comedies": 3,
    "comedown": 2,
    "comedy": 3,
    "comedy's": 3,
    "comegys": 3,
    "comella": 3,
    "comely": 2,
    "comer": 2,
    "comerford": 3,
    "comerica": 4,
    "comers": 2,
    "comes": 1,
    "comet": 2,
    "comet's": 2,
    "cometary": 4,
    "cometh": 2,
    "cometra": 3,
    "comets": 2,
    "comeuppance": 3,
    "comex": 2,
    "comex's": 3,
    "comfed": 2,
    "comfinance": 3,
    "comfort": 2,
    "comfortable": 4,
    "comfortably": 4,
    "comforted": 3,
    "comforter": 3,
    "comforters": 3,
    "comforting": 3,
    "comforts": 2,
    "comfrey": 2,
    "comfy": 2,
    "comic": 2,
    "comical": 3,
    "comically": 4,
    "comically(1)": 3,
    "comicopia": 5,
    "comics": 2,
    "comin'": 2,
    "cominco": 3,
    "coming": 2,
    "comings": 2,
    "comino": 3,
    "comins": 2,
    "cominsky": 3,
    "comiskey": 3,
    "comitatus": 4,
    "comito": 3,
    "comity": 3,
    "comley": 2,
    "comly": 2,
    "comma": 2,
    "commack": 2,
    "command": 2,
    "command's": 2,
    "commandant": 3,
    "commanded": 3,
    "commanded(1)": 3,
    "commandeer": 3,
    "commandeered": 3,
    "commander": 3,
    "commander's": 3,
    "commanders": 3,
    "commanding": 3,
    "commandment": 3,
    "commandments": 3,
    "commando": 3,
    "commandos": 3,
    "commands": 2,
    "commas": 2,
    "commemorate": 4,
    "commemorated": 5,
    "commemorates": 4,
    "commemorating": 5,
    "commemoration": 5,
    "commemorations": 5,
    "commemorative": 4,
    "commemorative(1)": 5,
    "commence": 2,
    "commenced": 2,
    "commencement": 3,
    "commences": 3,
    "commencing": 3,
    "commend": 2,
    "commendable": 4,
    "commendation": 4,
    "commended": 3,
    "commending": 3,
    "commends": 2,
    "commensurate": 4,
    "commensurate(1)": 4,
    "commensurately": 5,
    "commensurately(1)": 5,
    "comment": 2,
    "commentariat": 5,
    "commentaries": 4,
    "commentary": 4,
    "commentator": 4,
    "commentator's": 4,
    "commentators": 4,
    "commented": 3,
    "commenter": 3,
    "commenters": 3,
    "commenting": 3,
    "comments": 2,
    "commerce": 2,
    "commerce's": 3,
    "commercebancorp": 4,
    "commercial": 3,
    "commercial's": 3,
    "commerciale": 4,
    "commerciale's": 4,
    "commerciale's(1)": 5,
    "commercialism": 5,
    "commercialization": 6,
    "commercialize": 4,
    "commercialized": 4,
    "commercializing": 5,
    "commercially": 4,
    "commercials": 3,
    "commerford": 3,
    "commerical": 3,
    "commerzbank": 3,
    "commerzbank's": 3,
    "commie": 2,
    "commies": 2,
    "commingle": 3,
    "commingle(1)": 3,
    "commingled": 3,
    "commingled(1)": 3,
    "commingling": 4,
    "commingling(1)": 3,
    "commins": 2,
    "commiserate": 4,
    "commish": 2,
    "commision": 3,
    "commision(1)": 3,
    "commissar": 3,
    "commissaries": 4,
    "commissars": 3,
    "commissary": 4,
    "commission": 3,
    "commission's": 3,
    "commissioned": 3,
    "commissioner": 4,
    "commissioner's": 4,
    "commissioners": 4,
    "commissioning": 4,
    "commissions": 3,
    "commisso": 3,
    "commit": 2,
    "commitee": 3,
    "commitee(1)": 3,
    "commitment": 3,
    "commitments": 3,
    "commits": 2,
    "committal": 3,
    "committed": 3,
    "committee": 3,
    "committee's": 3,
    "committeeman": 4,
    "committees": 3,
    "committees'": 3,
    "committing": 3,
    "commode": 2,
    "commodious": 4,
    "commodities": 4,
    "commodity": 4,
    "commodity's": 4,
    "commodore": 3,
    "commodore's": 3,
    "common": 2,
    "commonalities": 5,
    "commonality": 5,
    "commoner": 3,
    "commoners": 3,
    "commonly": 3,
    "commonplace": 3,
    "commons": 2,
    "commonsense": 3,
    "commonsensical": 5,
    "commonwealth": 3,
    "commonwealth's": 3,
    "commotion": 3,
    "communal": 3,
    "commune": 2,
    "commune(1)": 2,
    "communes": 2,
    "communes(1)": 2,
    "communicable": 5,
    "communicate": 4,
    "communicated": 5,
    "communicates": 4,
    "communicating": 5,
    "communication": 5,
    "communication's": 5,
    "communications": 5,
    "communications'": 5,
    "communicative": 5,
    "communicator": 5,
    "communicators": 5,
    "communing": 3,
    "communion": 3,
    "communique": 4,
    "communique(1)": 4,
    "communiques": 4,
    "communism": 4,
    "communism's": 4,
    "communist": 3,
    "communist's": 3,
    "communists": 3,
    "communists'": 3,
    "communities": 4,
    "communities(1)": 4,
    "community": 4,
    "community(1)": 4,
    "community's": 4,
    "communitywide": 5,
    "communization": 5,
    "communize": 3,
    "commutate": 3,
    "commutation": 4,
    "commute": 2,
    "commuted": 3,
    "commuter": 3,
    "commuters": 3,
    "commutes": 2,
    "commuting": 3,
    "como": 2,
    "comoros": 3,
    "comp": 1,
    "compact": 2,
    "compact(1)": 2,
    "compacted": 3,
    "compactness": 3,
    "compactor": 3,
    "compacts": 2,
    "compacts(1)": 2,
    "compagnie": 3,
    "companero": 4,
    "companhia": 4,
    "compania": 4,
    "companies": 3,
    "companies'": 3,
    "companies's": 4,
    "companion": 3,
    "companions": 3,
    "companionship": 4,
    "companionway": 4,
    "company": 3,
    "company'll": 4,
    "company's": 3,
    "companywide": 4,
    "compaore": 4,
    "compaq": 2,
    "compaq's": 2,
    "comparability": 6,
    "comparable": 4,
    "comparable(1)": 4,
    "comparable(2)": 3,
    "comparably": 4,
    "comparably(1)": 3,
    "comparative": 4,
    "comparatively": 5,
    "comparator": 4,
    "compare": 2,
    "compared": 2,
    "compares": 2,
    "comparing": 3,
    "comparison": 4,
    "comparisons": 4,
    "compartment": 3,
    "compartmental": 4,
    "compartmentalize": 5,
    "compartmentalized": 5,
    "compartments": 3,
    "compas": 2,
    "compass": 2,
    "compassion": 3,
    "compassionate": 4,
    "compassionately": 5,
    "compatibility": 6,
    "compatible": 4,
    "compatibles": 4,
    "compatriot": 4,
    "compatriots": 4,
    "compean": 2,
    "compeau": 2,
    "compel": 2,
    "compelled": 2,
    "compelling": 3,
    "compellingly": 4,
    "compels": 2,
    "compendium": 4,
    "compensable": 4,
    "compensate": 3,
    "compensated": 4,
    "compensates": 3,
    "compensating": 4,
    "compensation": 4,
    "compensations": 4,
    "compensatory": 5,
    "compete": 2,
    "competed": 3,
    "competence": 3,
    "competencies": 4,
    "competency": 4,
    "competent": 3,
    "competently": 4,
    "competes": 2,
    "competing": 3,
    "competition": 4,
    "competition's": 4,
    "competitions": 4,
    "competitive": 4,
    "competitive(1)": 4,
    "competitively": 5,
    "competitiveness": 5,
    "competitor": 4,
    "competitor(1)": 4,
    "competitor's": 4,
    "competitors": 4,
    "competitors(1)": 4,
    "competitors'": 4,
    "compher": 2,
    "compilation": 4,
    "compilations": 4,
    "compile": 2,
    "compiled": 2,
    "compiler": 3,
    "compilers": 3,
    "compiles": 2,
    "compiling": 3,
    "complacency": 4,
    "complacent": 3,
    "complacently": 4,
    "complain": 2,
    "complainant": 3,
    "complainant's": 3,
    "complainants": 3,
    "complained": 2,
    "complainer": 3,
    "complainers": 3,
    "complaining": 3,
    "complains": 2,
    "complaint": 2,
    "complaints": 2,
    "complaisant": 3,
    "complement": 3,
    "complementary": 4,
    "complementary(1)": 4,
    "complemented": 4,
    "complementing": 4,
    "complements": 3,
    "complete": 2,
    "completed": 3,
    "completed(1)": 3,
    "completely": 3,
    "completeness": 3,
    "completes": 2,
    "completing": 3,
    "completion": 3,
    "completions": 3,
    "complex": 2,
    "complex(1)": 2,
    "complexes": 3,
    "complexion": 3,
    "complexions": 3,
    "complexities": 4,
    "complexity": 4,
    "complexity(1)": 4,
    "compliance": 3,
    "compliant": 3,
    "complicate": 3,
    "complicated": 4,
    "complicates": 3,
    "complicating": 4,
    "complication": 4,
    "complications": 4,
    "complicit": 3,
    "complicities": 4,
    "complicity": 4,
    "complicity(1)": 4,
    "complied": 2,
    "complies": 2,
    "compliment": 3,
    "complimentary": 5,
    "complimented": 4,
    "complimenting": 4,
    "compliments": 3,
    "comply": 2,
    "complying": 3,
    "compo": 2,
    "component": 3,
    "components": 3,
    "comport": 2,
    "comported": 3,
    "comportment": 3,
    "compose": 2,
    "composed": 2,
    "composer": 3,
    "composer's": 3,
    "composers": 3,
    "composes": 3,
    "composing": 3,
    "composite": 3,
    "composite(1)": 3,
    "composite's": 3,
    "composite's(1)": 3,
    "composites": 3,
    "composites(1)": 3,
    "composition": 4,
    "compositional": 5,
    "compositions": 4,
    "compost": 2,
    "composting": 3,
    "composure": 3,
    "compote": 2,
    "compound": 2,
    "compound(1)": 2,
    "compounded": 3,
    "compounded(1)": 3,
    "compounding": 3,
    "compounds": 2,
    "compounds(1)": 2,
    "comprehend": 3,
    "comprehended": 4,
    "comprehending": 4,
    "comprehends": 3,
    "comprehensibility": 7,
    "comprehensible": 5,
    "comprehension": 4,
    "comprehensive": 4,
    "comprehensively": 5,
    "compress": 2,
    "compress(1)": 2,
    "compressed": 2,
    "compresses": 3,
    "compresses(1)": 3,
    "compresses(2)": 3,
    "compressing": 3,
    "compression": 3,
    "compressor": 3,
    "compressors": 3,
    "comprint": 2,
    "comprise": 2,
    "comprised": 2,
    "comprises": 3,
    "comprises(1)": 3,
    "comprising": 3,
    "compromise": 3,
    "compromised": 3,
    "compromiser": 4,
    "compromises": 4,
    "compromising": 4,
    "compston": 2,
    "comptek": 2,
    "compton": 2,
    "compton's": 2,
    "comptroller": 3,
    "comptroller(1)": 3,
    "comptroller's": 3,
    "comptroller's(1)": 3,
    "comptronix": 3,
    "compu": 2,
    "compuadd": 3,
    "compuchem": 3,
    "compudyne": 3,
    "compufund": 3,
    "compugraphic": 4,
    "compulsion": 3,
    "compulsions": 3,
    "compulsive": 3,
    "compulsively": 4,
    "compulsory": 4,
    "compumat": 3,
    "compunction": 3,
    "compus": 2,
    "compusa": 4,
    "compusa's": 4,
    "compuserve": 3,
    "compuserve's": 3,
    "computalog": 4,
    "computation": 4,
    "computational": 5,
    "computations": 4,
    "compute": 2,
    "computed": 3,
    "computed(1)": 3,
    "computer": 3,
    "computer's": 3,
    "computercraft": 4,
    "computerization": 6,
    "computerize": 4,
    "computerized": 4,
    "computerizing": 5,
    "computerland": 4,
    "computerland's": 4,
    "computerlike": 4,
    "computers": 3,
    "computers'": 3,
    "computervision": 5,
    "computerworld": 4,
    "computes": 2,
    "computing": 3,
    "computrac": 3,
    "compuware": 3,
    "comrade": 2,
    "comrades": 2,
    "comrie": 3,
    "coms": 1,
    "comsat": 2,
    "comsat's": 2,
    "comstock": 2,
    "comtois": 2,
    "comtrex": 2,
    "comunale": 4,
    "con": 1,
    "cona": 2,
    "conable": 3,
    "conable's": 3,
    "conagra": 3,
    "conagra's": 3,
    "conahan": 3,
    "conair": 2,
    "conal": 2,
    "conan": 2,
    "conant": 2,
    "conant-pablos": 4,
    "conard": 2,
    "conasupo": 4,
    "conatser": 3,
    "conaty": 3,
    "conaway": 3,
    "conboy": 2,
    "conca": 2,
    "concannon": 3,
    "concatenate": 4,
    "concatenated": 5,
    "concatenates": 4,
    "concatenating": 5,
    "concatenation": 5,
    "concave": 2,
    "concave(1)": 2,
    "conceal": 2,
    "concealed": 2,
    "concealing": 3,
    "concealment": 3,
    "conceals": 2,
    "concede": 2,
    "conceded": 3,
    "concedes": 2,
    "conceding": 3,
    "conceit": 2,
    "conceited": 3,
    "conceivable": 4,
    "conceivably": 4,
    "conceive": 2,
    "conceived": 2,
    "conceiving": 3,
    "concentrate": 3,
    "concentrated": 4,
    "concentrated(1)": 4,
    "concentrates": 3,
    "concentrating": 4,
    "concentration": 4,
    "concentrations": 4,
    "concentric": 3,
    "concepcion": 4,
    "concept": 2,
    "conception": 3,
    "conceptions": 3,
    "concepts": 2,
    "concepts(1)": 2,
    "conceptual": 4,
    "conceptualization": 6,
    "conceptually": 5,
    "concern": 2,
    "concern's": 2,
    "concerned": 2,
    "concerning": 3,
    "concerns": 2,
    "concerns'": 2,
    "concert": 2,
    "concert(1)": 2,
    "concerted": 3,
    "concerted(1)": 3,
    "concerti": 3,
    "concertina": 4,
    "concertmaster": 4,
    "concerto": 3,
    "concertos": 3,
    "concerts": 2,
    "concerts(1)": 2,
    "concession": 3,
    "concessionaire": 4,
    "concessional": 4,
    "concessionary": 5,
    "concessions": 3,
    "conch": 1,
    "conch(1)": 1,
    "concha": 2,
    "conchemco": 3,
    "conchita": 3,
    "conchoid": 2,
    "concierge": 3,
    "conciliation": 5,
    "conciliator": 5,
    "conciliator's": 5,
    "conciliatory": 6,
    "conciliatory(1)": 5,
    "concise": 2,
    "concisely": 3,
    "conclave": 2,
    "conclude": 2,
    "concluded": 3,
    "concluded(1)": 3,
    "concludes": 2,
    "concluding": 3,
    "conclusion": 3,
    "conclusions": 3,
    "conclusive": 3,
    "conclusively": 4,
    "concoct": 2,
    "concocted": 3,
    "concocting": 3,
    "concoction": 3,
    "concoctions": 3,
    "concomitant": 4,
    "concomitant(1)": 4,
    "concomitantly": 5,
    "concomitantly(1)": 5,
    "concord": 2,
    "concord(1)": 2,
    "concord's": 2,
    "concord's(1)": 2,
    "concorde": 2,
    "concourse": 2,
    "concourses": 3,
    "concrete": 2,
    "concrete(1)": 2,
    "concretely": 3,
    "concubinage": 4,
    "concubine": 3,
    "concubines": 3,
    "concur": 2,
    "concurred": 2,
    "concurrence": 3,
    "concurrent": 3,
    "concurrently": 4,
    "concurring": 3,
    "concurs": 2,
    "concussion": 3,
    "concussions": 3,
    "conde": 1,
    "condello": 3,
    "condemn": 2,
    "condemnation": 4,
    "condemnations": 4,
    "condemned": 2,
    "condemning": 3,
    "condemns": 2,
    "condensate": 3,
    "condensates": 3,
    "condensation": 4,
    "condense": 2,
    "condensed": 2,
    "condenser": 3,
    "condensing": 3,
    "conder": 2,
    "condescend": 3,
    "condescending": 4,
    "condescension": 4,
    "condie": 2,
    "condiment": 3,
    "condiments": 3,
    "condit": 2,
    "condition": 3,
    "conditional": 4,
    "conditionality": 6,
    "conditionally": 5,
    "conditionally(1)": 4,
    "conditioned": 3,
    "conditioner": 4,
    "conditioners": 4,
    "conditioning": 4,
    "conditions": 3,
    "conditt": 2,
    "condo": 2,
    "condolence": 3,
    "condolences": 4,
    "condom": 2,
    "condominium": 5,
    "condominiums": 5,
    "condoms": 2,
    "condon": 2,
    "condone": 2,
    "condoned": 2,
    "condones": 2,
    "condoning": 3,
    "condor": 2,
    "condors": 2,
    "condos": 2,
    "condra": 2,
    "condracky": 3,
    "condracky's": 3,
    "condray": 2,
    "condren": 3,
    "condrey": 2,
    "condron": 2,
    "condry": 3,
    "conducive": 3,
    "conduct": 2,
    "conduct(1)": 2,
    "conducted": 3,
    "conducting": 3,
    "conduction": 3,
    "conductive": 3,
    "conductivity": 5,
    "conductor": 3,
    "conductors": 3,
    "conducts": 2,
    "conduit": 3,
    "conduit(1)": 3,
    "conduit(2)": 2,
    "conduits": 3,
    "conduits(1)": 2,
    "cone": 1,
    "cone's": 1,
    "coneflower": 3,
    "conehead": 2,
    "coneheads": 2,
    "conely": 2,
    "conerly": 3,
    "conery": 3,
    "cones": 1,
    "conestoga": 4,
    "coney": 2,
    "confabulation": 5,
    "confair": 2,
    "confect": 2,
    "confection": 3,
    "confectionaries": 5,
    "confectionary": 5,
    "confectioner": 4,
    "confectioners": 4,
    "confectionery": 5,
    "confections": 3,
    "confederacy": 5,
    "confederacy(1)": 4,
    "confederacy's": 5,
    "confederacy's(1)": 4,
    "confederate": 4,
    "confederate(1)": 4,
    "confederation": 5,
    "confer": 2,
    "conferee": 3,
    "conferees": 3,
    "conference": 3,
    "conference(1)": 2,
    "conference's": 4,
    "conference's(1)": 3,
    "conferences": 4,
    "conferences(1)": 3,
    "conferencing": 3,
    "conferred": 2,
    "conferring": 3,
    "confers": 2,
    "confess": 2,
    "confessed": 2,
    "confesses": 3,
    "confessing": 3,
    "confession": 3,
    "confessional": 4,
    "confessionals": 4,
    "confessions": 3,
    "confetti": 3,
    "confidant": 3,
    "confidante": 3,
    "confidants": 3,
    "confide": 2,
    "confided": 3,
    "confided(1)": 3,
    "confidence": 3,
    "confidence's": 4,
    "confidences": 4,
    "confident": 3,
    "confidential": 4,
    "confidential(1)": 4,
    "confidentiality": 7,
    "confidentiality(1)": 7,
    "confidentially": 5,
    "confidentially(1)": 5,
    "confidently": 4,
    "confides": 2,
    "confiding": 3,
    "configuration": 5,
    "configurations": 5,
    "configure": 3,
    "configured": 3,
    "configuring": 4,
    "confindustria": 5,
    "confine": 2,
    "confined": 2,
    "confinement": 3,
    "confines": 2,
    "confines(1)": 2,
    "confining": 3,
    "confirm": 2,
    "confirmable": 4,
    "confirmation": 4,
    "confirmations": 4,
    "confirmatory": 5,
    "confirmed": 2,
    "confirming": 3,
    "confirms": 2,
    "confiscate": 3,
    "confiscated": 4,
    "confiscating": 4,
    "confiscation": 4,
    "confiscatory": 5,
    "confiterias": 5,
    "conflagration": 4,
    "conflate": 2,
    "conflates": 2,
    "conflation": 3,
    "conflict": 2,
    "conflict(1)": 2,
    "conflicted": 3,
    "conflicting": 3,
    "conflicts": 2,
    "conflicts(1)": 2,
    "conflicts(2)": 2,
    "conflicts(3)": 2,
    "confluence": 3,
    "confluent": 3,
    "conform": 2,
    "conformance": 3,
    "conformational": 5,
    "conformed": 2,
    "conforming": 3,
    "conformist": 3,
    "conformists": 3,
    "conformity": 4,
    "conforms": 2,
    "conforti": 3,
    "confound": 2,
    "confound(1)": 2,
    "confound(2)": 2,
    "confounded": 3,
    "confounding": 3,
    "confounds": 2,
    "confrere": 2,
    "confreres": 2,
    "confront": 2,
    "confrontation": 4,
    "confrontational": 5,
    "confrontations": 4,
    "confronted": 3,
    "confronted(1)": 3,
    "confronting": 3,
    "confronts": 2,
    "confucian": 3,
    "confucianism": 5,
    "confucius": 3,
    "confuse": 2,
    "confused": 2,
    "confuses": 3,
    "confusing": 3,
    "confusingly": 4,
    "confusion": 3,
    "confusions": 3,
    "cong": 1,
    "conga": 2,
    "congdon": 2,
    "congeal": 2,
    "congealed": 2,
    "congenial": 3,
    "congeniality": 6,
    "congenital": 4,
    "conger": 2,
    "congest": 2,
    "congested": 3,
    "congested(1)": 3,
    "congestion": 3,
    "congestive": 3,
    "congleton": 3,
    "conglomerate": 4,
    "conglomerate's": 4,
    "conglomerates": 4,
    "conglomeration": 5,
    "congo": 2,
    "congo's": 2,
    "congolese": 3,
    "congratulate": 4,
    "congratulated": 5,
    "congratulating": 5,
    "congratulation": 5,
    "congratulations": 5,
    "congratulatory": 6,
    "congregant": 3,
    "congregants": 3,
    "congregate": 3,
    "congregated": 4,
    "congregation": 4,
    "congregation's": 4,
    "congregational": 5,
    "congregations": 4,
    "congress": 2,
    "congress'": 3,
    "congress'(1)": 2,
    "congress's": 3,
    "congresses": 3,
    "congressional": 4,
    "congressionally": 5,
    "congressionally(1)": 4,
    "congressman": 3,
    "congressman's": 3,
    "congressmen": 3,
    "congresspeople": 4,
    "congressperson": 4,
    "congresspersons": 4,
    "congresswoman": 4,
    "congresswoman's": 4,
    "congresswomen": 4,
    "congrove": 2,
    "congruence": 3,
    "congruity": 4,
    "conic": 2,
    "conic(1)": 2,
    "conical": 3,
    "conical(1)": 3,
    "conics": 2,
    "conics(1)": 2,
    "conifer": 3,
    "conifer's": 3,
    "coniferous": 4,
    "conifers": 3,
    "conigliaro": 5,
    "coniglio": 4,
    "coniston": 3,
    "conjecture": 3,
    "conjecture(1)": 3,
    "conjectures": 3,
    "conjectures(1)": 3,
    "conjoin": 2,
    "conjoined": 2,
    "conjugal": 3,
    "conjugate": 3,
    "conjugate(1)": 3,
    "conjugated": 4,
    "conjugated(1)": 4,
    "conjugates": 3,
    "conjugates(1)": 3,
    "conjugation": 4,
    "conjugations": 4,
    "conjul": 2,
    "conjunction": 3,
    "conjunctions": 3,
    "conjunctiva": 4,
    "conjure": 2,
    "conjured": 2,
    "conjures": 2,
    "conjuring": 3,
    "conjuror": 3,
    "conk": 1,
    "conkel": 2,
    "conkey": 2,
    "conkin": 2,
    "conkle": 2,
    "conklin": 2,
    "conkling": 2,
    "conkright": 2,
    "conlan": 2,
    "conlee": 2,
    "conley": 2,
    "conlin": 2,
    "conlon": 2,
    "conlow": 2,
    "conly": 2,
    "conn": 1,
    "conn.": 1,
    "conn.(1)": 4,
    "connally": 3,
    "connally's": 3,
    "connan": 2,
    "connaught": 2,
    "connaught's": 2,
    "connaughton": 3,
    "connaway": 3,
    "connect": 2,
    "connected": 3,
    "connected(1)": 3,
    "connecter": 3,
    "connecticut": 4,
    "connecticut's": 4,
    "connecting": 3,
    "connection": 3,
    "connections": 3,
    "connective": 3,
    "connectivity": 5,
    "connector": 3,
    "connectors": 3,
    "connects": 2,
    "conned": 1,
    "conneely": 3,
    "connell": 2,
    "connelley": 3,
    "connelly": 3,
    "connelly's": 3,
    "connely": 2,
    "conner": 2,
    "conner's": 2,
    "connerly": 3,
    "conners": 2,
    "connery": 3,
    "connery's": 3,
    "connett": 2,
    "connick": 2,
    "connie": 2,
    "connie's": 2,
    "conniff": 2,
    "conning": 2,
    "conniption": 3,
    "connivance": 3,
    "connive": 2,
    "conniving": 3,
    "connoisseur": 3,
    "connoisseurs": 3,
    "connole": 2,
    "connolly": 3,
    "connon": 2,
    "connor": 2,
    "connors": 2,
    "connotation": 4,
    "connotational": 5,
    "connotations": 4,
    "connote": 2,
    "connotes": 2,
    "conny": 2,
    "conoco": 3,
    "conoco(1)": 3,
    "conoco's": 3,
    "conolly": 3,
    "conoly": 3,
    "conover": 3,
    "conquer": 2,
    "conquered": 2,
    "conquering": 3,
    "conqueror": 3,
    "conqueror's": 3,
    "conquerors": 3,
    "conquers": 2,
    "conquest": 2,
    "conquest's": 2,
    "conquests": 2,
    "conrac": 2,
    "conrad": 2,
    "conrad's": 2,
    "conrades": 2,
    "conradi": 3,
    "conradine": 3,
    "conrads": 2,
    "conradt": 2,
    "conrady": 3,
    "conrail": 2,
    "conrail's": 2,
    "conran": 2,
    "conrath": 2,
    "conrey": 2,
    "conroe": 2,
    "conrow": 2,
    "conroy": 2,
    "conry": 2,
    "cons": 1,
    "consalvo": 3,
    "conscience": 2,
    "consciences": 3,
    "conscientious": 4,
    "conscientiously": 5,
    "conscious": 2,
    "consciously": 3,
    "consciousness": 3,
    "conscript": 2,
    "conscript(1)": 2,
    "conscripted": 3,
    "conscription": 3,
    "conscripts": 2,
    "conseco": 3,
    "conseco(1)": 3,
    "conseco's": 3,
    "conseco's(1)": 3,
    "consecrate": 3,
    "consecrated": 4,
    "consecrated(1)": 4,
    "consecration": 4,
    "consecrations": 4,
    "consecutive": 4,
    "consecutively": 5,
    "consensual": 4,
    "consensual(1)": 4,
    "consensus": 3,
    "consent": 2,
    "consented": 3,
    "consented(1)": 3,
    "consenting": 3,
    "consenting(1)": 3,
    "consentino": 4,
    "consents": 2,
    "consequence": 3,
    "consequences": 4,
    "consequent": 3,
    "consequential": 4,
    "consequently": 4,
    "consequently(1)": 4,
    "conser": 2,
    "conservancy": 4,
    "conservancy's": 4,
    "conservation": 4,
    "conservationist": 5,
    "conservationists": 5,
    "conservatism": 5,
    "conservative": 4,
    "conservatively": 5,
    "conservatives": 4,
    "conservatives'": 4,
    "conservativism": 6,
    "conservator": 4,
    "conservatories": 5,
    "conservators": 4,
    "conservatorship": 5,
    "conservatory": 5,
    "conserve": 2,
    "conserved": 2,
    "conserving": 3,
    "conshohocken": 4,
    "consider": 3,
    "considerable": 5,
    "considerably": 5,
    "considerate": 4,
    "consideration": 5,
    "considerations": 5,
    "considered": 3,
    "considering": 4,
    "considers": 3,
    "considine": 3,
    "consiglio": 4,
    "consign": 2,
    "consigned": 2,
    "consignment": 3,
    "consis": 2,
    "consist": 2,
    "consisted": 3,
    "consisted(1)": 3,
    "consistence": 3,
    "consistency": 4,
    "consistent": 3,
    "consistently": 4,
    "consisting": 3,
    "consists": 2,
    "consob": 2,
    "consol": 2,
    "consol's": 2,
    "consolable": 4,
    "consolably": 4,
    "consolata": 4,
    "consolation": 4,
    "consolations": 4,
    "console": 2,
    "console(1)": 2,
    "consoled": 2,
    "consoles": 2,
    "consoli": 3,
    "consolidate": 4,
    "consolidated": 5,
    "consolidated's": 5,
    "consolidates": 4,
    "consolidating": 5,
    "consolidation": 5,
    "consolidations": 5,
    "consolidator": 5,
    "consolidators": 5,
    "consoling": 3,
    "consolo": 3,
    "consonant": 3,
    "consonantal": 4,
    "consonantal(1)": 4,
    "consonants": 3,
    "consort": 2,
    "consortia": 3,
    "consorting": 3,
    "consortium": 4,
    "consortium(1)": 3,
    "consortium's": 4,
    "consortium's(1)": 3,
    "consortiums": 3,
    "consortiums(1)": 3,
    "conspicuous": 4,
    "conspicuously": 5,
    "conspiracies": 4,
    "conspiracy": 4,
    "conspirator": 4,
    "conspiratorial": 6,
    "conspiratorially": 7,
    "conspiratorially(1)": 6,
    "conspirators": 4,
    "conspire": 3,
    "conspired": 3,
    "conspiring": 3,
    "constable": 3,
    "constables": 3,
    "constabulary": 5,
    "constance": 2,
    "constancy": 3,
    "constant": 2,
    "constant's": 2,
    "constanta": 3,
    "constantin": 3,
    "constantina": 4,
    "constantine": 3,
    "constantine(1)": 3,
    "constantinides": 5,
    "constantinides(1)": 5,
    "constantino": 4,
    "constantinople": 5,
    "constantinos": 4,
    "constantly": 3,
    "constants": 2,
    "constar": 2,
    "constellation": 4,
    "constellation's": 4,
    "constellations": 4,
    "consternation": 4,
    "constipate": 3,
    "constipated": 4,
    "constipates": 3,
    "constipation": 4,
    "constituencies": 5,
    "constituency": 5,
    "constituent": 4,
    "constituents": 4,
    "constituents'": 4,
    "constitute": 3,
    "constituted": 4,
    "constitutes": 3,
    "constituting": 4,
    "constitution": 4,
    "constitution's": 4,
    "constitutional": 5,
    "constitutionality": 7,
    "constitutionally": 6,
    "constitutionist": 5,
    "constitutionists": 5,
    "constitutions": 4,
    "constrain": 2,
    "constrained": 2,
    "constraining": 3,
    "constrains": 2,
    "constraint": 2,
    "constraints": 2,
    "constrict": 2,
    "constricted": 3,
    "constricting": 3,
    "constriction": 3,
    "constrictions": 3,
    "constrictor": 3,
    "constrictors": 3,
    "construcciones": 5,
    "construct": 2,
    "construct(1)": 2,
    "constructed": 3,
    "constructed(1)": 3,
    "constructing": 3,
    "construction": 3,
    "constructionist": 4,
    "constructions": 3,
    "constructive": 3,
    "constructively": 4,
    "constructor": 3,
    "constructors": 3,
    "constructs": 2,
    "constructs(1)": 2,
    "construe": 2,
    "construed": 2,
    "consuela": 3,
    "consul": 2,
    "consular": 3,
    "consulate": 3,
    "consulates": 3,
    "consulship": 3,
    "consult": 2,
    "consultancy": 4,
    "consultant": 3,
    "consultant's": 3,
    "consultants": 3,
    "consultants'": 3,
    "consultation": 4,
    "consultations": 4,
    "consultative": 4,
    "consulted": 3,
    "consulted(1)": 3,
    "consulting": 3,
    "consults": 2,
    "consumable": 4,
    "consume": 2,
    "consumed": 2,
    "consumer": 3,
    "consumer's": 3,
    "consumerism": 5,
    "consumerist": 4,
    "consumerists": 4,
    "consumers": 3,
    "consumers'": 3,
    "consumes": 2,
    "consuming": 3,
    "consummate": 3,
    "consummate(1)": 3,
    "consummated": 4,
    "consummates": 3,
    "consummating": 4,
    "consummation": 4,
    "consumption": 3,
    "consumption(1)": 3,
    "contac": 2,
    "contact": 2,
    "contacted": 3,
    "contacting": 3,
    "contacts": 2,
    "contacts(1)": 2,
    "contadora": 4,
    "contagion": 3,
    "contagious": 3,
    "contagiousness": 4,
    "contain": 2,
    "contained": 2,
    "container": 3,
    "container's": 3,
    "containerboard": 4,
    "containerize": 4,
    "containerized": 4,
    "containers": 3,
    "containers'": 3,
    "containing": 3,
    "containment": 3,
    "contains": 2,
    "contaminant": 4,
    "contaminants": 4,
    "contaminate": 4,
    "contaminated": 5,
    "contaminated(1)": 5,
    "contaminates": 4,
    "contaminating": 5,
    "contamination": 5,
    "contant": 2,
    "conte": 1,
    "conte(1)": 2,
    "contel": 2,
    "contemplate": 3,
    "contemplated": 4,
    "contemplates": 3,
    "contemplating": 4,
    "contemplation": 4,
    "contemplative": 4,
    "contempo": 3,
    "contemporaneous": 6,
    "contemporaneously": 7,
    "contemporaries": 5,
    "contemporary": 5,
    "contempt": 2,
    "contemptible": 4,
    "contemptuous": 4,
    "contemptuously": 4,
    "contend": 2,
    "contended": 3,
    "contender": 3,
    "contenders": 3,
    "contending": 3,
    "contends": 2,
    "contends(1)": 2,
    "content": 2,
    "content(1)": 2,
    "contented": 3,
    "contented(1)": 3,
    "contentedly": 4,
    "contention": 3,
    "contentioned": 3,
    "contentions": 3,
    "contentious": 3,
    "contentiousness": 4,
    "contentment": 3,
    "contento": 3,
    "contents": 2,
    "contents(1)": 2,
    "contest": 2,
    "contest(1)": 2,
    "contest's": 2,
    "contestable": 4,
    "contestant": 3,
    "contestants": 3,
    "contested": 3,
    "contesting": 3,
    "contests": 2,
    "contests(1)": 2,
    "contests(2)": 2,
    "contests(3)": 2,
    "context": 2,
    "contexts": 2,
    "conti": 2,
    "contibel": 3,
    "conticommodity": 6,
    "contiguous": 4,
    "continent": 3,
    "continent's": 3,
    "continental": 4,
    "continental(1)": 4,
    "continental's": 4,
    "continentally": 5,
    "continentally(1)": 5,
    "continentals": 4,
    "continentals(1)": 4,
    "continents": 3,
    "contingencies": 4,
    "contingency": 4,
    "contingent": 3,
    "contingents": 3,
    "contini": 3,
    "contino": 3,
    "continual": 4,
    "continually": 5,
    "continually(1)": 4,
    "continuance": 4,
    "continuances": 5,
    "continuation": 5,
    "continue": 3,
    "continued": 3,
    "continues": 3,
    "continuing": 4,
    "continuity": 5,
    "continuous": 4,
    "continuously": 5,
    "continuum": 4,
    "contois": 2,
    "contort": 2,
    "contorted": 3,
    "contortion": 3,
    "contortionist": 4,
    "contortions": 3,
    "contorts": 2,
    "contos": 2,
    "contour": 2,
    "contoured": 2,
    "contours": 2,
    "contra": 2,
    "contraband": 3,
    "contrabassoon": 4,
    "contraception": 4,
    "contraceptive": 4,
    "contraceptives": 4,
    "contract": 2,
    "contract(1)": 2,
    "contract's": 2,
    "contracted": 3,
    "contracting": 3,
    "contraction": 3,
    "contractionary": 5,
    "contractions": 3,
    "contractor": 3,
    "contractor's": 3,
    "contractors": 3,
    "contractors'": 3,
    "contracts": 2,
    "contracts(1)": 2,
    "contractual": 4,
    "contractually": 5,
    "contradict": 3,
    "contradicted": 4,
    "contradicting": 4,
    "contradiction": 4,
    "contradictions": 4,
    "contradictorily": 6,
    "contradictory": 5,
    "contradicts": 3,
    "contran": 2,
    "contraption": 3,
    "contraptions": 3,
    "contrarian": 4,
    "contrarians": 4,
    "contrariness": 4,
    "contrary": 3,
    "contrary(1)": 3,
    "contras": 2,
    "contras(1)": 2,
    "contras'": 2,
    "contrast": 2,
    "contrast(1)": 2,
    "contrasted": 3,
    "contrasting": 3,
    "contrasts": 2,
    "contrasts(1)": 2,
    "contrasts(2)": 2,
    "contrasts(3)": 2,
    "contravene": 3,
    "contravention": 4,
    "contreras": 3,
    "contretemps": 3,
    "contribute": 3,
    "contributed": 4,
    "contributes": 3,
    "contributing": 4,
    "contribution": 4,
    "contributions": 4,
    "contributor": 4,
    "contributors": 4,
    "contributory": 5,
    "contrite": 2,
    "contrition": 3,
    "contrivance": 3,
    "contrivances": 4,
    "contrive": 2,
    "contrived": 2,
    "control": 2,
    "control's": 2,
    "controladora": 5,
    "controllable": 4,
    "controlled": 2,
    "controller": 3,
    "controller's": 3,
    "controllers": 3,
    "controllers'": 3,
    "controlling": 3,
    "controls": 2,
    "controls'": 2,
    "controversial": 4,
    "controversies": 4,
    "controversy": 4,
    "contura": 3,
    "contusion": 3,
    "contusions": 3,
    "conundrum": 3,
    "conus": 2,
    "convair": 2,
    "convalesce": 3,
    "convalescence": 4,
    "convalescent": 4,
    "convection": 3,
    "convective": 3,
    "convene": 2,
    "convened": 2,
    "convenes": 2,
    "convenience": 3,
    "conveniences": 4,
    "convenient": 3,
    "conveniently": 4,
    "convening": 3,
    "convent": 2,
    "convent(1)": 2,
    "convention": 3,
    "convention's": 3,
    "conventional": 4,
    "conventionally": 5,
    "conventioneer": 4,
    "conventioneers": 4,
    "conventions": 3,
    "convents": 2,
    "convents(1)": 2,
    "converge": 2,
    "converged": 2,
    "convergence": 3,
    "convergent": 3,
    "converging": 3,
    "conversant": 3,
    "conversation": 4,
    "conversational": 5,
    "conversationalist": 6,
    "conversations": 4,
    "converse": 2,
    "converse(1)": 2,
    "conversed": 2,
    "conversely": 3,
    "converses": 3,
    "converses(1)": 3,
    "conversing": 3,
    "conversion": 3,
    "conversion's": 3,
    "conversions": 3,
    "convert": 2,
    "convert(1)": 2,
    "converted": 3,
    "converter": 3,
    "converters": 3,
    "convertibility": 6,
    "convertible": 4,
    "convertibles": 4,
    "converting": 3,
    "converts": 2,
    "converts(1)": 2,
    "convery": 3,
    "convex": 2,
    "convex(1)": 2,
    "convey": 2,
    "conveyance": 3,
    "conveyed": 2,
    "conveyer": 3,
    "conveying": 3,
    "conveyor": 3,
    "conveys": 2,
    "convict": 2,
    "convict(1)": 2,
    "convicted": 3,
    "convicting": 3,
    "conviction": 3,
    "convictions": 3,
    "convicts": 2,
    "convicts(1)": 2,
    "conville": 2,
    "convince": 2,
    "convinced": 2,
    "convinces": 3,
    "convincing": 3,
    "convincingly": 4,
    "convivial": 4,
    "convocation": 4,
    "convolute": 3,
    "convoluted": 4,
    "convolution": 4,
    "convoy": 2,
    "convoys": 2,
    "convulsant": 3,
    "convulsants": 3,
    "convulsion": 3,
    "convulsions": 3,
    "convulsive": 3,
    "conway": 2,
    "conwell": 2,
    "conyer": 2,
    "conyers": 2,
    "coo": 1,
    "coochie": 2,
    "coody": 2,
    "coogan": 2,
    "coogle": 2,
    "coogler": 3,
    "coogler(1)": 2,
    "cooing": 2,
    "cook": 1,
    "cook's": 1,
    "cookbook": 2,
    "cookbook's": 2,
    "cookbooks": 2,
    "cooke": 1,
    "cooked": 1,
    "cooker": 2,
    "cookers": 2,
    "cookie": 2,
    "cookies": 2,
    "cookin'": 2,
    "cooking": 2,
    "cookingham": 3,
    "cookman": 2,
    "cookout": 2,
    "cookouts": 2,
    "cooks": 1,
    "cooksey": 2,
    "cookson": 2,
    "cookston": 2,
    "cookware": 2,
    "cool": 1,
    "coolant": 2,
    "coolants": 2,
    "coolbaugh": 2,
    "coole": 1,
    "cooled": 1,
    "cooler": 2,
    "coolers": 2,
    "coolest": 2,
    "cooley": 2,
    "cooley's": 2,
    "coolidge": 2,
    "coolidge's": 3,
    "cooling": 2,
    "coolio": 3,
    "coolio(1)": 2,
    "coolly": 2,
    "coolman": 2,
    "coolness": 2,
    "cools": 1,
    "coombe": 1,
    "coombe(1)": 1,
    "coombes": 1,
    "coombes(1)": 1,
    "coombs": 1,
    "coomer": 2,
    "coomes": 1,
    "coon": 1,
    "coonan": 2,
    "coonce": 1,
    "coone": 1,
    "cooner": 2,
    "coones": 1,
    "cooney": 2,
    "coonradt": 2,
    "coonrod": 2,
    "coons": 1,
    "coontz": 1,
    "coop": 1,
    "cooped": 1,
    "cooper": 2,
    "cooper's": 2,
    "cooperage": 3,
    "cooperate": 4,
    "cooperate(1)": 3,
    "cooperated": 5,
    "cooperated(1)": 4,
    "cooperates": 4,
    "cooperating": 5,
    "cooperation": 5,
    "cooperation(1)": 4,
    "cooperation(2)": 4,
    "cooperations": 5,
    "cooperations(1)": 4,
    "cooperative": 5,
    "cooperatively": 5,
    "cooperatives": 4,
    "cooperider": 4,
    "cooperman": 3,
    "cooperrider": 4,
    "coopers": 2,
    "coopersmith": 3,
    "cooperstein": 3,
    "cooperstein(1)": 3,
    "cooperstown": 3,
    "coopervision": 4,
    "coopman": 2,
    "cooprider": 3,
    "coordinate": 4,
    "coordinate(1)": 4,
    "coordinated": 5,
    "coordinates": 4,
    "coordinates(1)": 4,
    "coordinating": 5,
    "coordination": 5,
    "coordinator": 5,
    "coordinators": 5,
    "coors": 1,
    "coors's": 2,
    "coos": 1,
    "coosa": 2,
    "coot": 1,
    "coote": 1,
    "cooter": 2,
    "coots": 1,
    "coover": 2,
    "coovick": 2,
    "cop": 1,
    "copa": 2,
    "copacabana": 5,
    "copartner": 3,
    "copartners": 3,
    "copas": 2,
    "copayment": 3,
    "copayments": 3,
    "copco": 2,
    "cope": 1,
    "coped": 1,
    "copelan": 3,
    "copeland": 2,
    "copeland's": 2,
    "copelco": 3,
    "copelin": 3,
    "copeman": 2,
    "copen": 2,
    "copenhagen": 4,
    "copenhagen(1)": 4,
    "copenhagen's": 4,
    "copenhagen's(1)": 4,
    "copenhaver": 4,
    "copernican": 4,
    "copernicus": 4,
    "copes": 1,
    "copetas": 3,
    "copetas(1)": 3,
    "copher": 2,
    "copiague": 3,
    "copied": 2,
    "copier": 3,
    "copiers": 3,
    "copies": 2,
    "copilot": 3,
    "copilots": 3,
    "coping": 2,
    "copious": 3,
    "copiously": 3,
    "coplan": 2,
    "copland": 2,
    "coplen": 3,
    "copley": 2,
    "copley's": 2,
    "copleys": 2,
    "coplin": 2,
    "copolla": 3,
    "copolla's": 3,
    "copp": 1,
    "coppa": 2,
    "coppage": 2,
    "copped": 1,
    "coppedge": 2,
    "coppee": 2,
    "coppel": 2,
    "coppens": 2,
    "copper": 2,
    "copper's": 2,
    "copperfield": 3,
    "copperfield's": 3,
    "copperfields": 3,
    "copperfields'": 3,
    "copperhead": 3,
    "copperheads": 3,
    "copperman": 3,
    "coppernoll": 3,
    "coppers": 2,
    "coppersmith": 3,
    "copperweld": 3,
    "coppery": 3,
    "coppess": 2,
    "coppin": 2,
    "copping": 2,
    "coppinger": 3,
    "coppins": 2,
    "copple": 2,
    "coppock": 2,
    "coppola": 3,
    "coppola's": 3,
    "coppolino": 4,
    "copps": 1,
    "copra": 2,
    "coprocessor": 4,
    "coprocessors": 4,
    "cops": 1,
    "copsey": 2,
    "coptic": 2,
    "copulate": 3,
    "copus": 2,
    "copy": 2,
    "copycat": 3,
    "copycats": 3,
    "copycatting": 4,
    "copycode": 3,
    "copycodes": 3,
    "copying": 3,
    "copyreader": 4,
    "copyreaders": 4,
    "copyright": 3,
    "copyrightable": 5,
    "copyrighted": 4,
    "copyrights": 3,
    "copytele": 4,
    "copywrite": 3,
    "copywrited": 4,
    "copywriter": 4,
    "copywriters": 4,
    "cor": 1,
    "cora": 2,
    "cora's": 2,
    "corabelle": 3,
    "corabelle(1)": 3,
    "coracle": 3,
    "coral": 2,
    "coralie": 3,
    "coraline": 3,
    "corallo": 3,
    "corals": 2,
    "coram": 2,
    "corath": 2,
    "corazon": 3,
    "corban": 2,
    "corbeil": 2,
    "corbel": 2,
    "corbell": 2,
    "corbelled": 2,
    "corbello": 3,
    "corbet": 2,
    "corbett": 2,
    "corbin": 2,
    "corbit": 2,
    "corbitt": 2,
    "corbo": 2,
    "corbridge": 2,
    "corbu": 2,
    "corbusier": 3,
    "corby": 2,
    "corcap": 2,
    "corcoran": 3,
    "cord": 1,
    "corda": 2,
    "cordage": 2,
    "cordaro": 3,
    "cordasco": 3,
    "corday": 2,
    "corded": 2,
    "cordeiro": 3,
    "cordell": 2,
    "corder": 2,
    "cordero": 3,
    "cordes": 1,
    "cordesman": 3,
    "cordial": 2,
    "cordially": 3,
    "cordials": 2,
    "cordiant": 3,
    "cordiant's": 3,
    "cordie": 2,
    "cordier": 3,
    "cordill": 2,
    "cording": 2,
    "cordis": 2,
    "cordle": 2,
    "cordless": 2,
    "cordner": 2,
    "cordoba": 3,
    "cordoba's": 3,
    "cordobas": 3,
    "cordon": 2,
    "cordone": 2,
    "cordoned": 2,
    "cordova": 3,
    "cordover": 3,
    "cordovez": 3,
    "cordray": 2,
    "cordrey": 2,
    "cordry": 3,
    "cords": 1,
    "cordts": 1,
    "corduroy": 3,
    "cordy": 2,
    "core": 1,
    "corea": 3,
    "corel": 2,
    "corell": 2,
    "corella": 3,
    "coren": 2,
    "cores": 1,
    "corespondent": 4,
    "corestate": 2,
    "corestates": 2,
    "corestates'": 3,
    "coretech": 2,
    "coretta": 3,
    "corette": 2,
    "corexit": 3,
    "corey": 2,
    "corgi": 2,
    "coria": 3,
    "coriander": 4,
    "coriell": 2,
    "corier": 3,
    "corigliano": 5,
    "corina": 3,
    "corinn": 2,
    "corinn's": 2,
    "corinna": 3,
    "corinne": 2,
    "corinth": 2,
    "corinthian": 4,
    "corinto": 3,
    "corio": 3,
    "corisa": 3,
    "corissa": 3,
    "cork": 1,
    "corken": 2,
    "corker": 2,
    "corkern": 2,
    "corkery": 3,
    "corkill": 2,
    "corking": 2,
    "corkins": 2,
    "corkran": 2,
    "corks": 1,
    "corkscrew": 2,
    "corkum": 2,
    "corkwood": 2,
    "corky": 2,
    "corl": 1,
    "corle": 2,
    "corleone": 3,
    "corleone(1)": 4,
    "corless": 2,
    "corlett": 2,
    "corlew": 2,
    "corley": 2,
    "corliss": 2,
    "cormac": 2,
    "cormack": 2,
    "corman": 2,
    "cormany": 3,
    "cormen": 2,
    "cormen(1)": 2,
    "cormican": 3,
    "cormick": 2,
    "cormier": 3,
    "cormorant": 3,
    "cormorants": 3,
    "corn": 1,
    "corna": 2,
    "cornacchia": 4,
    "cornall": 2,
    "cornblume": 2,
    "cornbread": 2,
    "corncob": 2,
    "corncrib": 2,
    "corne": 1,
    "cornea": 3,
    "corneal": 2,
    "corneas": 3,
    "cornejo": 3,
    "cornel": 2,
    "cornela": 3,
    "cornelia": 3,
    "cornelio": 4,
    "cornelious": 4,
    "cornelious(1)": 3,
    "cornelison": 4,
    "cornelius": 3,
    "corneliuson": 5,
    "cornell": 2,
    "cornell's": 2,
    "cornelle": 2,
    "corner": 2,
    "cornerback": 3,
    "cornered": 2,
    "cornering": 3,
    "corners": 2,
    "cornerstone": 3,
    "cornerstones": 3,
    "cornet": 2,
    "cornett": 2,
    "cornette": 2,
    "cornettist": 3,
    "corney": 2,
    "cornfeld": 2,
    "cornfield": 2,
    "cornfields": 2,
    "cornflower": 3,
    "cornflowers": 3,
    "cornforth": 2,
    "cornhusk": 2,
    "cornhusking": 3,
    "cornhusks": 2,
    "cornia": 3,
    "corniche": 2,
    "cornick": 2,
    "cornie": 2,
    "corniel": 2,
    "corniel's": 2,
    "corning": 2,
    "corning's": 2,
    "cornish": 2,
    "cornman": 2,
    "cornmeal": 2,
    "corns": 1,
    "cornstalk": 2,
    "cornstalks": 2,
    "cornstarch": 2,
    "cornucopia": 5,
    "cornwall": 2,
    "cornwall's": 2,
    "cornwallis": 3,
    "cornwell": 2,
    "corny": 2,
    "corolla": 3,
    "corollaries": 4,
    "corollary": 4,
    "corologis": 4,
    "corona": 3,
    "corona's": 3,
    "coronado": 4,
    "coronary": 4,
    "coronation": 4,
    "coroner": 3,
    "coroner's": 3,
    "coroners": 3,
    "coronet": 3,
    "coronets": 3,
    "corp": 1,
    "corp(1)": 4,
    "corp's": 1,
    "corp's(1)": 4,
    "corp.": 1,
    "corp.(1)": 4,
    "corp.'s": 1,
    "corp.'s(1)": 4,
    "corpening": 3,
    "corpora": 3,
    "corporacion": 5,
    "corporal": 3,
    "corporal(1)": 2,
    "corporate": 3,
    "corporate(1)": 2,
    "corporates": 3,
    "corporatewatch": 3,
    "corporatewide": 4,
    "corporation": 4,
    "corporation's": 4,
    "corporations": 4,
    "corporations'": 4,
    "corporatism": 5,
    "corporatist": 4,
    "corps": 1,
    "corps(1)": 1,
    "corps'": 1,
    "corpse": 1,
    "corpses": 2,
    "corpses(1)": 2,
    "corpsman": 2,
    "corpulant": 3,
    "corpus": 2,
    "corpus-christi": 4,
    "corpuz": 2,
    "corr": 1,
    "corradi": 3,
    "corradino": 4,
    "corrado": 3,
    "corral": 2,
    "corrales": 3,
    "corralled": 2,
    "corralling": 3,
    "corrao": 2,
    "correa": 3,
    "correale": 3,
    "correct": 2,
    "corrected": 3,
    "corrected(1)": 3,
    "correcting": 3,
    "correction": 3,
    "correctional": 4,
    "corrections": 3,
    "corrective": 3,
    "correctly": 3,
    "correctness": 3,
    "corrects": 2,
    "corregidor": 4,
    "correia": 4,
    "correira": 3,
    "correlate": 3,
    "correlate(1)": 3,
    "correlated": 4,
    "correlates": 3,
    "correlates(1)": 3,
    "correlating": 4,
    "correlation": 4,
    "correlations": 4,
    "correll": 2,
    "correne": 2,
    "corrente": 3,
    "correnti": 3,
    "correspond": 3,
    "corresponded": 4,
    "correspondence": 4,
    "correspondent": 4,
    "correspondents": 4,
    "correspondents'": 4,
    "corresponding": 4,
    "correspondingly": 5,
    "corresponds": 3,
    "corrib": 2,
    "corrick": 2,
    "corridor": 3,
    "corridor(1)": 3,
    "corridors": 3,
    "corridors(1)": 3,
    "corrie": 2,
    "corriere": 2,
    "corrigan": 3,
    "corrigan's": 3,
    "corrigible": 4,
    "corriher": 3,
    "corrin": 2,
    "corrina": 3,
    "corrington": 3,
    "corriveau": 3,
    "corroborate": 4,
    "corroborated": 5,
    "corroborates": 4,
    "corroborating": 5,
    "corroboration": 5,
    "corroborative": 5,
    "corroborative(1)": 4,
    "corrode": 2,
    "corroded": 3,
    "corrodes": 2,
    "corron": 2,
    "corroon": 2,
    "corrosion": 3,
    "corrosive": 3,
    "corrow": 2,
    "corrugate": 3,
    "corrugated": 4,
    "corrugated(1)": 4,
    "corrupt": 2,
    "corrupted": 3,
    "corruptible": 4,
    "corrupting": 3,
    "corruption": 3,
    "corruptions": 3,
    "corruptive": 3,
    "corruptly": 3,
    "corrupts": 2,
    "corry": 2,
    "corsa": 2,
    "corsage": 2,
    "corsair": 2,
    "corsaro": 3,
    "corse": 1,
    "corsello": 3,
    "corsentino": 4,
    "corser": 2,
    "corset": 2,
    "corsetti": 3,
    "corsi": 2,
    "corsica": 3,
    "corsican": 3,
    "corsicas": 3,
    "corsiglia": 4,
    "corsini": 3,
    "corso": 2,
    "corson": 2,
    "cort": 1,
    "corte": 1,
    "cortege": 2,
    "corteland": 2,
    "cortelyou": 3,
    "corten": 2,
    "cortens": 2,
    "cortens'": 2,
    "corter": 2,
    "cortes": 1,
    "cortese": 3,
    "cortesi": 3,
    "cortex": 2,
    "cortez": 2,
    "corteze": 2,
    "corti": 2,
    "cortical": 3,
    "corticosteroid": 5,
    "corticosteroids": 5,
    "cortin": 2,
    "cortina": 3,
    "cortinas": 3,
    "cortine": 2,
    "cortines": 2,
    "cortisol": 3,
    "cortisone": 3,
    "cortland": 2,
    "cortner": 2,
    "cortopassi": 4,
    "cortright": 2,
    "corum": 2,
    "corundum": 3,
    "corva": 2,
    "corvallis": 3,
    "corvette": 2,
    "corvettes": 2,
    "corvin": 2,
    "corvino": 3,
    "corvo": 2,
    "corvus": 2,
    "corwin": 2,
    "cory": 2,
    "corzine": 3,
    "corzo": 2,
    "cos": 1,
    "cosa": 2,
    "cosatu": 3,
    "cosatu's": 3,
    "cosby": 2,
    "cosby's": 2,
    "coscia": 2,
    "cose": 1,
    "cosell": 2,
    "cosens": 2,
    "cosentino": 4,
    "cosenza": 3,
    "coseratz": 3,
    "cosette": 2,
    "cosey": 2,
    "cosgriff": 2,
    "cosgrove": 2,
    "cosi": 2,
    "cosic": 2,
    "cosic(1)": 2,
    "cosic(2)": 2,
    "cosima": 3,
    "cosio": 3,
    "coslett": 2,
    "cosma": 2,
    "cosmair": 2,
    "cosman": 2,
    "cosme": 1,
    "cosmetic": 3,
    "cosmetically": 4,
    "cosmetics": 3,
    "cosmetology": 5,
    "cosmic": 2,
    "cosmo": 2,
    "cosmo's": 2,
    "cosmodrome": 3,
    "cosmology": 4,
    "cosmonaut": 3,
    "cosmonauts": 3,
    "cosmonauts'": 3,
    "cosmopolitan": 5,
    "cosmopulos": 4,
    "cosmos": 2,
    "cosner": 2,
    "cosper": 2,
    "cosponsor": 3,
    "cosponsors": 3,
    "coss": 1,
    "cossa": 2,
    "cossack": 2,
    "cossacks": 2,
    "cossairt": 2,
    "cossat": 2,
    "cosset": 2,
    "cossette": 2,
    "cossey": 2,
    "cossiga": 3,
    "cossin": 2,
    "cossman": 2,
    "cost": 1,
    "cost(1)": 1,
    "costa": 2,
    "costabile": 3,
    "costain": 2,
    "costales": 2,
    "costano": 3,
    "costantini": 4,
    "costantino": 4,
    "costanza": 3,
    "costanzo": 3,
    "costar": 2,
    "costars": 2,
    "costas": 2,
    "costa_rica": 4,
    "costco": 2,
    "costcutting": 3,
    "coste": 1,
    "costed": 2,
    "costeira": 4,
    "costella": 3,
    "costello": 3,
    "costello's": 3,
    "costen": 2,
    "coster": 2,
    "costigan": 3,
    "costilla": 3,
    "costilow": 3,
    "costin": 2,
    "costing": 2,
    "costley": 2,
    "costlier": 3,
    "costliest": 3,
    "costlow": 2,
    "costly": 2,
    "costly(1)": 2,
    "costner": 2,
    "costner's": 2,
    "coston": 2,
    "costra": 2,
    "costs": 1,
    "costs(1)": 1,
    "costume": 2,
    "costume(1)": 2,
    "costumed": 2,
    "costumer": 3,
    "costumers": 3,
    "costumes": 2,
    "costumes(1)": 2,
    "cosurtuh": 3,
    "cosy": 2,
    "cot": 1,
    "cota": 2,
    "cote": 1,
    "cotelle": 2,
    "coterie": 3,
    "cotes": 1,
    "cotham": 2,
    "cothern": 2,
    "cothran": 2,
    "cothren": 3,
    "cothron": 2,
    "cotija": 3,
    "cotilla": 3,
    "cotler": 3,
    "cotler(1)": 2,
    "cotman": 2,
    "cotner": 2,
    "cotney": 2,
    "cotnoir": 2,
    "coto": 2,
    "cotret": 2,
    "cotrone": 3,
    "cotroneo": 4,
    "cots": 1,
    "cott": 1,
    "cotta": 2,
    "cottage": 2,
    "cottage(1)": 2,
    "cottages": 3,
    "cottam": 2,
    "cottee": 2,
    "cotten": 2,
    "cotter": 2,
    "cotterill": 3,
    "cotterman": 3,
    "cottier": 3,
    "cottingham": 3,
    "cottle": 2,
    "cottman": 2,
    "cotto": 2,
    "cottom": 2,
    "cotton": 2,
    "cotton(1)": 2,
    "cotton's": 2,
    "cottone": 3,
    "cottoned": 2,
    "cottongin": 3,
    "cottonmouth": 3,
    "cottons": 2,
    "cottonseed": 3,
    "cottonwood": 3,
    "cottonwoods": 3,
    "cottrell": 2,
    "cottrill": 2,
    "cotty": 2,
    "cotugno": 3,
    "coty": 2,
    "cou": 1,
    "couch": 1,
    "couched": 1,
    "couches": 2,
    "couchette": 2,
    "couchettes": 2,
    "couching": 2,
    "couchman": 2,
    "coudersport": 3,
    "coudert": 2,
    "couey": 2,
    "coufal": 2,
    "cougar": 2,
    "cougars": 2,
    "cough": 1,
    "cough(1)": 1,
    "coughed": 1,
    "coughenour": 3,
    "coughing": 2,
    "coughing(1)": 2,
    "coughlan": 2,
    "coughlin": 2,
    "coughran": 2,
    "coughs": 1,
    "couillard": 2,
    "could": 1,
    "could've": 2,
    "couldn't": 2,
    "couldn't(1)": 2,
    "coulee": 2,
    "coull": 1,
    "coulombe": 3,
    "coulon": 2,
    "coulson": 2,
    "coulston": 2,
    "coultas": 2,
    "coulter": 2,
    "coulthard": 2,
    "counce": 1,
    "council": 2,
    "council's": 2,
    "councilman": 3,
    "councilmen": 3,
    "councilor": 3,
    "councilor(1)": 2,
    "councilors": 3,
    "councilors(1)": 2,
    "councils": 2,
    "councilwoman": 4,
    "councilwomen": 4,
    "counihan": 3,
    "counsel": 2,
    "counsel's": 2,
    "counseled": 2,
    "counseling": 3,
    "counseling(1)": 2,
    "counsell": 2,
    "counsellor": 3,
    "counsellor(1)": 2,
    "counsellors": 3,
    "counsellors(1)": 2,
    "counselman": 3,
    "counselor": 3,
    "counselors": 3,
    "counsels": 2,
    "count": 1,
    "countable": 3,
    "countdown": 2,
    "countdowns": 2,
    "counted": 2,
    "counted(1)": 2,
    "counted(2)": 2,
    "counted(3)": 2,
    "countenance": 3,
    "countenanced": 3,
    "countenances": 4,
    "counter": 2,
    "counteract": 3,
    "counteracted": 4,
    "counteracting": 4,
    "counterattack": 4,
    "counterattack(1)": 4,
    "counterattacked": 4,
    "counterattacked(1)": 4,
    "counterattacking": 5,
    "counterattacking(1)": 5,
    "counterattacks": 4,
    "counterattacks(1)": 4,
    "counterbalance": 4,
    "counterbalance(1)": 4,
    "counterbalanced": 4,
    "counterbalanced(1)": 4,
    "counterbalances": 5,
    "counterbalances(1)": 5,
    "counterbalancing": 5,
    "counterbalancing(1)": 5,
    "counterbid": 3,
    "counterbids": 3,
    "counterchallenge": 4,
    "counterchallenge(1)": 4,
    "counterchallenges": 5,
    "counterchallenges(1)": 5,
    "countercharge": 3,
    "countercharge(1)": 3,
    "countercharges": 4,
    "countercharges(1)": 4,
    "counterclaim": 3,
    "counterclaims": 3,
    "counterclockwise": 4,
    "counterclockwise(1)": 4,
    "countercultural": 5,
    "countercultural(1)": 5,
    "counterculture": 4,
    "counterculture(1)": 4,
    "countered": 2,
    "countered(1)": 2,
    "counterespionage": 6,
    "counterespionage(1)": 6,
    "counterfeit": 3,
    "counterfeit(1)": 3,
    "counterfeited": 4,
    "counterfeited(1)": 4,
    "counterfeiter": 4,
    "counterfeiter(1)": 4,
    "counterfeiters": 4,
    "counterfeiters(1)": 4,
    "counterfeiting": 4,
    "counterfeiting(1)": 4,
    "counterfeits": 3,
    "counterfeits(1)": 3,
    "counterforce": 3,
    "counterforces": 4,
    "countering": 3,
    "countering(1)": 3,
    "counterinsurgencies": 6,
    "counterinsurgencies(1)": 6,
    "counterinsurgency": 6,
    "counterinsurgency(1)": 6,
    "counterintelligence": 6,
    "counterintelligence(1)": 6,
    "counterlife": 3,
    "counterman": 3,
    "countermeasure": 4,
    "countermeasure(1)": 4,
    "countermeasures": 4,
    "countermeasures(1)": 4,
    "countermove": 3,
    "countermoves": 3,
    "counteroffensive": 5,
    "counteroffensive(1)": 5,
    "counteroffensives": 5,
    "counteroffensives(1)": 5,
    "counteroffer": 4,
    "counteroffer(1)": 4,
    "counteroffers": 4,
    "counteroffers(1)": 4,
    "counterpart": 3,
    "counterpart(1)": 3,
    "counterparts": 3,
    "counterparts(1)": 3,
    "counterparty": 4,
    "counterpoint": 3,
    "counterpoint(1)": 3,
    "counterpoints": 3,
    "counterpoints(1)": 3,
    "counterproductive": 5,
    "counterproductive(1)": 5,
    "counterproposal": 5,
    "counterproposal(1)": 5,
    "counterproposals": 5,
    "counterproposals(1)": 5,
    "counterpunch": 3,
    "counterrevolt": 4,
    "counterrevolt(1)": 4,
    "counterrevolution": 6,
    "counterrevolution(1)": 6,
    "counterrevolutionary": 8,
    "counterrevolutionary(1)": 8,
    "counters": 2,
    "countersue": 3,
    "countersue(1)": 3,
    "countersued": 3,
    "countersued(1)": 3,
    "countersuing": 4,
    "countersuing(1)": 4,
    "countersuit": 3,
    "countersuit(1)": 3,
    "countertenor": 4,
    "counterterrorism": 6,
    "counterterrorism(1)": 6,
    "counterterrorist": 5,
    "counterterrorist(1)": 5,
    "counterterrorists": 5,
    "counterterrorists(1)": 5,
    "countertop": 3,
    "countertop(1)": 3,
    "countertops": 3,
    "countertops(1)": 3,
    "countertrade": 3,
    "countervail": 3,
    "countervailing": 4,
    "counterweight": 3,
    "counterweights": 3,
    "countess": 2,
    "countesses": 3,
    "counties": 2,
    "counties(1)": 2,
    "counting": 2,
    "counting(1)": 2,
    "countless": 2,
    "countries": 2,
    "countries'": 2,
    "country": 2,
    "country's": 2,
    "countryfolk": 3,
    "countryman": 3,
    "countrymen": 3,
    "countryside": 3,
    "countrywide": 3,
    "counts": 1,
    "county": 2,
    "county(1)": 2,
    "county's": 2,
    "county's(1)": 2,
    "coup": 1,
    "coupe": 1,
    "couper": 2,
    "coupes": 1,
    "coupland": 2,
    "couple": 2,
    "couple's": 2,
    "coupled": 2,
    "coupler": 2,
    "couplers": 2,
    "couples": 2,
    "coupley": 2,
    "coupling": 2,
    "couplings": 2,
    "coupon": 2,
    "coupon(1)": 2,
    "couponing": 3,
    "couponing(1)": 3,
    "couponite": 3,
    "couponite(1)": 3,
    "couponites": 3,
    "couponites(1)": 3,
    "coupons": 2,
    "coupons(1)": 2,
    "coups": 1,
    "coups(1)": 1,
    "cour": 1,
    "courage": 2,
    "courage(1)": 2,
    "courageous": 3,
    "courageously": 4,
    "courant": 2,
    "courchaine": 2,
    "courchesne": 2,
    "couric": 2,
    "courier": 3,
    "courier's": 3,
    "couriers": 3,
    "courington": 3,
    "cournoyer": 3,
    "course": 1,
    "course's": 2,
    "coursen": 2,
    "courser": 2,
    "courses": 2,
    "courses(1)": 2,
    "coursey": 2,
    "coursing": 2,
    "courson": 2,
    "court": 1,
    "court's": 1,
    "courtade": 2,
    "courtaulds": 2,
    "courteau": 2,
    "courted": 2,
    "courtemanche": 2,
    "courtemanche(1)": 2,
    "courtenay": 3,
    "courtenay(1)": 2,
    "courteous": 3,
    "courter": 2,
    "courter's": 2,
    "courtesies": 3,
    "courtesy": 3,
    "courthouse": 2,
    "courthouses": 3,
    "courtier": 3,
    "courtiers": 3,
    "courting": 2,
    "courtis": 2,
    "courtland": 2,
    "courtly": 2,
    "courtney": 2,
    "courtois": 2,
    "courtright": 2,
    "courtroom": 2,
    "courtrooms": 2,
    "courts": 1,
    "courts'": 1,
    "courtship": 2,
    "courtwright": 2,
    "courtyard": 2,
    "courtyards": 2,
    "courville": 2,
    "coury": 2,
    "cousar": 2,
    "couse": 1,
    "cousens": 2,
    "cousens(1)": 2,
    "couser": 2,
    "cousin": 2,
    "cousin's": 2,
    "cousineau": 3,
    "cousino": 3,
    "cousins": 2,
    "cousteau": 2,
    "cousteau's": 2,
    "cousy": 2,
    "coutant": 2,
    "coutee": 2,
    "couto": 2,
    "couts": 1,
    "coutts": 1,
    "coutu": 2,
    "couture": 2,
    "couturier": 4,
    "couvillion": 3,
    "couvillon": 3,
    "couzens": 2,
    "coval": 2,
    "covalt": 2,
    "covarrubias": 5,
    "covas": 2,
    "covatta": 3,
    "covault": 2,
    "cove": 1,
    "covel": 2,
    "covell": 2,
    "covelli": 3,
    "covello": 3,
    "coven": 2,
    "coven(1)": 2,
    "covenant": 3,
    "covenanter": 4,
    "covenanters": 4,
    "covenants": 3,
    "coveney": 3,
    "covent": 2,
    "coventry": 3,
    "cover": 2,
    "coverage": 3,
    "coverage(1)": 3,
    "coverage(2)": 2,
    "coverages": 4,
    "coverages(1)": 4,
    "coverages(2)": 3,
    "coverall": 3,
    "coveralls": 3,
    "coverdale": 3,
    "coverdell": 3,
    "covered": 2,
    "covering": 3,
    "covering(1)": 2,
    "coverings": 3,
    "covers": 2,
    "coverstone": 3,
    "covert": 2,
    "covertly": 3,
    "coverup": 3,
    "coverups": 3,
    "coves": 1,
    "covet": 2,
    "coveted": 3,
    "covets": 2,
    "covey": 2,
    "covia": 3,
    "coviello": 4,
    "covill": 2,
    "coville": 2,
    "covin": 2,
    "covina": 3,
    "covington": 3,
    "covino": 3,
    "covitz": 2,
    "covy": 2,
    "cow": 1,
    "cow's": 1,
    "cowabunga": 4,
    "cowan": 2,
    "cowans": 2,
    "coward": 2,
    "coward's": 2,
    "cowardice": 3,
    "cowardly": 3,
    "cowards": 2,
    "cowart": 2,
    "cowbell": 2,
    "cowbells": 2,
    "cowboy": 2,
    "cowboy's": 2,
    "cowboys": 2,
    "cowboys'": 2,
    "cowden": 2,
    "cowdery": 3,
    "cowdrey": 2,
    "cowed": 1,
    "coweda": 3,
    "cowell": 2,
    "cowen": 2,
    "cowen(1)": 2,
    "cowens": 2,
    "cowens(1)": 2,
    "cower": 2,
    "cowering": 3,
    "cowger": 2,
    "cowgill": 2,
    "cowgirl": 2,
    "cowgirls": 2,
    "cowher": 2,
    "cowherd": 2,
    "cowie": 2,
    "cowin": 2,
    "cowing": 2,
    "cowl": 1,
    "cowles": 2,
    "cowley": 2,
    "cowlick": 2,
    "cowlicks": 2,
    "cowling": 2,
    "cowling's": 2,
    "cowlings": 2,
    "cowlings'": 2,
    "cowlings's": 3,
    "cowman": 2,
    "coworker": 3,
    "coworkers": 3,
    "cowper": 2,
    "cowper(1)": 2,
    "cowperthwaite": 3,
    "cowries": 2,
    "cows": 1,
    "cowser": 2,
    "cowsert": 2,
    "cowslip": 2,
    "cox": 1,
    "cox's": 2,
    "coxe": 1,
    "coxen": 2,
    "coxon": 2,
    "coxwell": 2,
    "coy": 1,
    "coye": 1,
    "coyer": 2,
    "coykendall": 3,
    "coyle": 1,
    "coyly": 2,
    "coym": 1,
    "coyne": 1,
    "coyner": 2,
    "coyote": 3,
    "coyote(1)": 2,
    "coyotes": 3,
    "coyotes(1)": 2,
    "coz": 1,
    "cozad": 2,
    "cozart": 2,
    "cozby": 2,
    "cozier": 3,
    "cozine": 3,
    "coziness": 3,
    "cozman": 2,
    "cozy": 2,
    "cozying": 3,
    "cozza": 2,
    "cozzens": 2,
    "cozzi": 2,
    "cozzolino": 4,
    "crab": 1,
    "crabb": 1,
    "crabbe": 1,
    "crabbed": 1,
    "crabbs": 1,
    "crabby": 2,
    "crabeater": 3,
    "crabill": 2,
    "crable": 2,
    "crabmeat": 2,
    "crabs": 1,
    "crabtree": 2,
    "cracchiolo": 4,
    "crace": 1,
    "crack": 1,
    "crackdown": 2,
    "crackdowns": 2,
    "cracked": 1,
    "crackel": 2,
    "cracker": 2,
    "crackerjack": 3,
    "crackers": 2,
    "cracking": 2,
    "crackle": 2,
    "crackled": 2,
    "crackles": 2,
    "crackling": 2,
    "crackpot": 2,
    "crackpots": 2,
    "cracks": 1,
    "cracraft": 2,
    "craddock": 2,
    "crader": 2,
    "cradic": 2,
    "cradle": 2,
    "cradles": 2,
    "cradling": 3,
    "cradling(1)": 2,
    "cradock": 2,
    "crady": 2,
    "craft": 1,
    "craft's": 1,
    "crafted": 2,
    "crafting": 2,
    "crafton": 2,
    "crafts": 1,
    "crafts(1)": 1,
    "craftsman": 2,
    "craftsman(1)": 2,
    "craftsmanship": 3,
    "craftsmanship(1)": 3,
    "craftsmen": 2,
    "craftsmen(1)": 2,
    "craftspeople": 3,
    "craftspeople(1)": 3,
    "crafty": 2,
    "crager": 2,
    "cragg": 1,
    "craggs": 1,
    "craggy": 2,
    "craghead": 2,
    "cragin": 2,
    "cragle": 2,
    "crago": 2,
    "cragun": 2,
    "craib": 1,
    "craig": 1,
    "craig's": 1,
    "craighead": 2,
    "craigie": 2,
    "craigo": 2,
    "crail": 1,
    "crain": 1,
    "crain's": 1,
    "craine": 1,
    "craker": 2,
    "crall": 1,
    "cram": 1,
    "cramblit": 2,
    "cramer": 2,
    "cramer's": 2,
    "crames": 1,
    "crammed": 1,
    "crammer": 2,
    "cramming": 2,
    "cramp": 1,
    "cramped": 1,
    "cramping": 2,
    "crampon": 2,
    "crampons": 2,
    "cramps": 1,
    "crampton": 2,
    "crams": 1,
    "cramton": 2,
    "cranberries": 3,
    "cranberry": 3,
    "crance": 1,
    "crandall": 2,
    "crandall's": 2,
    "crandell": 2,
    "crane": 1,
    "crane's": 1,
    "craned": 1,
    "craner": 2,
    "cranes": 1,
    "cranesbill": 2,
    "cranesbills": 2,
    "craney": 2,
    "cranfield": 2,
    "cranfill": 2,
    "cranford": 2,
    "cranial": 2,
    "cranium": 3,
    "crank": 1,
    "cranked": 1,
    "cranking": 2,
    "cranks": 1,
    "crankshaft": 2,
    "crankshafts": 2,
    "cranky": 2,
    "cranley": 2,
    "cranmer": 2,
    "cranmore": 2,
    "crannell": 2,
    "cranney": 2,
    "crannies": 2,
    "cranny": 2,
    "cranor": 2,
    "crans": 1,
    "cranshaw": 2,
    "cranston": 2,
    "cranston's": 2,
    "crap": 1,
    "crapo": 2,
    "crappie": 2,
    "crapps": 1,
    "crappy": 2,
    "craps": 1,
    "crapser": 2,
    "crapshoot": 2,
    "crary": 3,
    "crase": 1,
    "crash": 1,
    "crash's": 2,
    "crashed": 1,
    "crashes": 2,
    "crashing": 2,
    "crasner": 2,
    "crasnianski": 4,
    "crass": 1,
    "crassweller": 3,
    "crassweller's": 3,
    "crate": 1,
    "crater": 2,
    "cratered": 2,
    "craters": 2,
    "crates": 1,
    "cratia": 2,
    "crating": 2,
    "craton": 2,
    "cratty": 2,
    "craugh": 1,
    "craun": 1,
    "cravath": 2,
    "crave": 1,
    "craved": 1,
    "craven": 2,
    "craven's": 2,
    "cravens": 2,
    "craver": 2,
    "craves": 1,
    "cravey": 2,
    "cravin": 2,
    "craving": 2,
    "cravings": 2,
    "craw": 1,
    "crawfish": 2,
    "crawford": 2,
    "crawford's": 2,
    "crawfordsville": 3,
    "crawl": 1,
    "crawled": 1,
    "crawley": 2,
    "crawling": 2,
    "crawls": 1,
    "crawly": 2,
    "crawmer": 2,
    "crawshaw": 2,
    "craxi": 2,
    "cray": 1,
    "cray's": 1,
    "craycraft": 2,
    "crayfish": 2,
    "crayne": 1,
    "crayon": 2,
    "crayons": 2,
    "crays": 1,
    "crayton": 2,
    "craze": 1,
    "crazed": 1,
    "crazier": 3,
    "crazies": 2,
    "craziest": 3,
    "crazily": 3,
    "craziness": 3,
    "crazy": 2,
    "crea": 1,
    "creach": 1,
    "creager": 3,
    "creagh": 1,
    "creak": 1,
    "creaked": 1,
    "creaking": 2,
    "creaky": 2,
    "creal": 1,
    "cream": 1,
    "creamed": 1,
    "creamer": 2,
    "creamery": 3,
    "creamier": 3,
    "creamiest": 3,
    "creams": 1,
    "creamy": 2,
    "crean": 1,
    "crear": 1,
    "crease": 1,
    "creases": 2,
    "creasey": 2,
    "creasman": 2,
    "creason": 2,
    "creasy": 2,
    "create": 2,
    "create-a-book": 4,
    "created": 3,
    "created(1)": 3,
    "creates": 2,
    "creath": 1,
    "creating": 3,
    "creation": 3,
    "creationism": 5,
    "creations": 3,
    "creative": 3,
    "creatively": 4,
    "creativeness": 4,
    "creativity": 5,
    "creatologist": 5,
    "creatologists": 5,
    "creator": 3,
    "creators": 3,
    "creature": 2,
    "creatures": 2,
    "crecelius": 4,
    "creche": 1,
    "creches": 2,
    "credence": 2,
    "credential": 3,
    "credential(1)": 3,
    "credentialed": 3,
    "credentialed(1)": 3,
    "credentials": 3,
    "credentials(1)": 3,
    "credenza": 3,
    "credeur": 2,
    "credibility": 5,
    "credible": 3,
    "credibly": 3,
    "credit": 2,
    "credit(1)": 2,
    "credit's": 2,
    "creditable": 4,
    "creditably": 4,
    "creditanstalt": 4,
    "creditbank": 3,
    "credited": 3,
    "credited(1)": 3,
    "credithrift": 3,
    "crediting": 3,
    "credito": 3,
    "creditor": 3,
    "creditor(1)": 3,
    "creditors": 3,
    "creditors'": 3,
    "credits": 2,
    "creditwatch": 3,
    "creditworthiness": 5,
    "creditworthy": 4,
    "credle": 2,
    "credo": 2,
    "credo(1)": 2,
    "credulity": 4,
    "credulous": 3,
    "cree": 1,
    "creech": 1,
    "creecy": 2,
    "creed": 1,
    "creeden": 2,
    "creedon": 2,
    "creeds": 1,
    "creegan": 2,
    "creek": 1,
    "creek's": 1,
    "creekmore": 2,
    "creekmur": 2,
    "creeks": 1,
    "creel": 1,
    "creelman": 2,
    "creely": 2,
    "creep": 1,
    "creepiness": 3,
    "creeping": 2,
    "creeps": 1,
    "creepy": 2,
    "creer": 1,
    "crees": 1,
    "cref": 1,
    "cref's": 1,
    "cregan": 2,
    "cregar": 2,
    "creger": 2,
    "cregg": 1,
    "cregger": 2,
    "crego": 2,
    "crehan": 2,
    "creighton": 2,
    "creko": 2,
    "crellin": 2,
    "cremate": 2,
    "cremated": 3,
    "cremation": 3,
    "crematoria": 5,
    "crematorium": 5,
    "creme": 1,
    "cremeans": 2,
    "cremeens": 2,
    "cremer": 2,
    "cremin": 2,
    "crenelate": 3,
    "crenelated": 4,
    "crenshaw": 2,
    "crenwelge": 2,
    "creole": 2,
    "creoles": 2,
    "creolize": 3,
    "creolized": 3,
    "creosote": 3,
    "crepe": 1,
    "crepeau": 2,
    "crepes": 1,
    "creps": 1,
    "crept": 1,
    "creque": 1,
    "cresap": 2,
    "cresap(1)": 2,
    "crescendo": 3,
    "crescent": 2,
    "crescents": 2,
    "crescenzi": 3,
    "crescenzo": 3,
    "cresci": 2,
    "crescott": 2,
    "creson": 2,
    "crespi": 2,
    "crespin": 2,
    "crespo": 2,
    "cress": 1,
    "cresses": 2,
    "cresses(1)": 2,
    "cressey": 2,
    "cressler": 2,
    "cressman": 2,
    "cresson": 2,
    "cresswell": 2,
    "cressy": 2,
    "crest": 1,
    "crestar": 2,
    "crested": 2,
    "crestfallen": 3,
    "cresting": 2,
    "crestmont": 2,
    "crests": 1,
    "creswell": 2,
    "cretaceous": 3,
    "cretchen": 2,
    "crete": 1,
    "cretella": 3,
    "cretien": 2,
    "cretin": 2,
    "cretsinger": 3,
    "creutzfeldt": 2,
    "creutzfeldt(1)": 2,
    "creveling": 3,
    "creveling(1)": 2,
    "crevice": 2,
    "crevices": 3,
    "crevier": 3,
    "creviston": 3,
    "crew": 1,
    "crew's": 1,
    "crewe": 1,
    "crewel": 2,
    "crewes": 1,
    "crewman": 2,
    "crewmen": 2,
    "crews": 1,
    "crib": 1,
    "cribari": 3,
    "cribb": 1,
    "cribbage": 2,
    "cribbing": 2,
    "cribbs": 1,
    "cribs": 1,
    "crichlow": 2,
    "crichton": 2,
    "crick": 1,
    "cricket": 2,
    "cricket(1)": 2,
    "cricket's": 2,
    "crickets": 2,
    "criddle": 2,
    "crider": 2,
    "cried": 1,
    "crier": 2,
    "cries": 1,
    "criger": 2,
    "crigger": 2,
    "crigler": 2,
    "crihfield": 2,
    "crill": 1,
    "crilley": 2,
    "crilly": 2,
    "crim": 1,
    "crime": 1,
    "crime's": 1,
    "crimea": 3,
    "crimean": 2,
    "crimean(1)": 3,
    "crimes": 1,
    "crimi": 2,
    "criminal": 3,
    "criminal's": 3,
    "criminalist": 4,
    "criminalist's": 4,
    "criminalistics": 5,
    "criminalists": 4,
    "criminality": 5,
    "criminalization": 6,
    "criminalize": 4,
    "criminalized": 4,
    "criminalizing": 5,
    "criminally": 4,
    "criminals": 3,
    "criminals'": 3,
    "criminologist": 5,
    "criminologists": 5,
    "criminology": 5,
    "crimm": 1,
    "crimmins": 2,
    "crimp": 1,
    "crimped": 1,
    "crimping": 2,
    "crimps": 1,
    "crimson": 2,
    "criner": 2,
    "cringe": 1,
    "cringed": 1,
    "cringes": 2,
    "cringing": 2,
    "crip": 1,
    "cripe": 1,
    "crippen": 2,
    "cripple": 2,
    "crippled": 2,
    "cripples": 2,
    "crippling": 3,
    "crippling(1)": 2,
    "cripps": 1,
    "crips": 1,
    "cris": 1,
    "crisafi": 3,
    "crisafulli": 4,
    "crisanti": 3,
    "crisci": 2,
    "criscione": 3,
    "crisco": 2,
    "criscuolo": 3,
    "crise": 1,
    "crises": 2,
    "crishman": 2,
    "crishman's": 2,
    "crisis": 2,
    "crisler": 3,
    "crisler(1)": 2,
    "crislip": 2,
    "crisman": 2,
    "crismon": 2,
    "crisostomo": 4,
    "crisp": 1,
    "crispell": 2,
    "crispen": 2,
    "crisper": 2,
    "crispin": 2,
    "crispina": 3,
    "crispino": 3,
    "crisply": 2,
    "crispness": 2,
    "crispo": 2,
    "crispy": 2,
    "criss": 1,
    "criss-cross": 2,
    "criss-crossed": 2,
    "crisscross": 2,
    "crisscrossed": 2,
    "crisscrossing": 3,
    "crissey": 2,
    "crissinger": 3,
    "crisslow": 2,
    "crissman": 2,
    "crist": 1,
    "crista": 2,
    "cristabel": 3,
    "cristal": 2,
    "cristiani": 4,
    "cristiani(1)": 4,
    "cristiani's": 4,
    "cristiani's(1)": 4,
    "cristiano": 4,
    "cristina": 3,
    "cristo": 2,
    "cristo's": 2,
    "cristobal": 3,
    "cristobel": 3,
    "cristobel's": 3,
    "criswell": 2,
    "critcher": 2,
    "critchfield": 2,
    "critchley": 2,
    "critchlow": 2,
    "critelli": 3,
    "criteria": 4,
    "criterion": 4,
    "crites": 1,
    "critic": 2,
    "critic's": 2,
    "critical": 3,
    "criticality": 5,
    "critically": 4,
    "critically(1)": 3,
    "criticism": 4,
    "criticisms": 4,
    "criticize": 3,
    "criticized": 3,
    "criticizes": 4,
    "criticizing": 4,
    "critics": 2,
    "critics'": 2,
    "critique": 2,
    "critique(1)": 2,
    "critiqued": 2,
    "critiques": 2,
    "critiquing": 3,
    "criton": 2,
    "critser": 2,
    "crittenden": 3,
    "crittendon": 3,
    "critter": 2,
    "critters": 2,
    "critz": 1,
    "critzer": 2,
    "crivaro": 3,
    "crivelli": 3,
    "crivello": 3,
    "criven": 2,
    "crnkovich": 3,
    "cro": 1,
    "croak": 1,
    "croaker": 2,
    "croaking": 2,
    "croat": 2,
    "croat's": 2,
    "croatia": 3,
    "croatia's": 3,
    "croatian": 3,
    "croatian's": 3,
    "croatians": 3,
    "croatians'": 3,
    "croats": 2,
    "croc": 1,
    "crocco": 2,
    "croce": 2,
    "crochet": 2,
    "crocheted": 2,
    "crochetiere": 3,
    "crocheting": 3,
    "crock": 1,
    "crocker": 2,
    "crocker's": 2,
    "crockery": 3,
    "crockett": 2,
    "crockford": 2,
    "crocodile": 3,
    "crocodiles": 3,
    "crocodilian": 4,
    "crocus": 2,
    "crocuses": 3,
    "croff": 1,
    "crofford": 2,
    "crofoot": 2,
    "croft": 1,
    "crofton": 2,
    "crofts": 1,
    "crogan": 2,
    "croghan": 2,
    "croissant": 2,
    "croissant(1)": 2,
    "croissants": 2,
    "croissants(1)": 2,
    "croitzer": 2,
    "croix": 1,
    "croix's": 1,
    "croke": 1,
    "croker": 2,
    "croley": 2,
    "croll": 1,
    "crom": 1,
    "cromartie": 3,
    "crombie": 2,
    "cromer": 2,
    "cromer's": 2,
    "cromie": 2,
    "cromley": 2,
    "crompton": 2,
    "cromwell": 2,
    "cromwell's": 2,
    "cron": 1,
    "cronan": 2,
    "cronauer": 2,
    "cronce": 1,
    "crone": 1,
    "cronen": 2,
    "croner": 2,
    "croney": 2,
    "cronies": 2,
    "cronin": 2,
    "cronk": 1,
    "cronkhite": 2,
    "cronkite": 2,
    "cronkright": 2,
    "cronquist": 2,
    "cronus": 2,
    "crony": 2,
    "cronyism": 4,
    "crook": 1,
    "crooke": 1,
    "crooked": 2,
    "crookedness": 3,
    "crooker": 2,
    "crooklyn": 2,
    "crooklyn's": 2,
    "crooks": 1,
    "crookshank": 2,
    "crookshanks": 2,
    "crookston": 2,
    "croom": 1,
    "crooms": 1,
    "croon": 1,
    "crooner": 2,
    "crooning": 2,
    "croons": 1,
    "crop": 1,
    "crop's": 1,
    "cropland": 2,
    "cropley": 2,
    "cropp": 1,
    "cropped": 1,
    "cropper": 2,
    "cropping": 2,
    "crops": 1,
    "cropsey": 2,
    "croquet": 2,
    "cros": 1,
    "crosbey": 2,
    "crosbie": 2,
    "crosby": 2,
    "crosby's": 2,
    "crose": 1,
    "croshaw": 2,
    "croskey": 2,
    "crosland": 2,
    "crosley": 2,
    "croslin": 2,
    "croson": 2,
    "cross": 1,
    "cross's": 2,
    "cross-pollinate": 4,
    "crossan": 2,
    "crossbill": 2,
    "crossbills": 2,
    "crossbones": 2,
    "crossborder": 3,
    "crossbow": 2,
    "crossbows": 2,
    "crosscurrent": 3,
    "crosscurrents": 3,
    "crosse": 1,
    "crossed": 1,
    "crossen": 2,
    "crosser": 2,
    "crosses": 2,
    "crossett": 2,
    "crossfield": 2,
    "crossfire": 2,
    "crossfire(1)": 2,
    "crossfire's": 2,
    "crossin": 2,
    "crossing": 2,
    "crossings": 2,
    "crossland": 2,
    "crossley": 2,
    "crosslin": 2,
    "crossman": 2,
    "crossnine": 2,
    "crossno": 2,
    "crosson": 2,
    "crossover": 3,
    "crosspiece": 2,
    "crosspieces": 3,
    "crosspieces(1)": 3,
    "crossroad": 2,
    "crossroads": 2,
    "crosstalk": 2,
    "crosstown": 2,
    "crossville": 2,
    "crosswalk": 2,
    "crosswalks": 2,
    "crosswhite": 2,
    "crosswise": 2,
    "crossword": 2,
    "crosswords": 2,
    "crosthwait": 2,
    "crosthwaite": 2,
    "croston": 2,
    "croswell": 2,
    "crotch": 1,
    "crotchety": 3,
    "croteau": 2,
    "crothers": 2,
    "crotonville": 3,
    "crotteau": 2,
    "crotts": 1,
    "crotty": 2,
    "crotwell": 2,
    "crotzer": 2,
    "crouch": 1,
    "crouched": 1,
    "croucher": 2,
    "crouching": 2,
    "crough": 1,
    "crounse": 1,
    "croup": 1,
    "crouse": 1,
    "crouser": 2,
    "crout": 1,
    "crouthamel": 3,
    "crovitz": 2,
    "crovitz's": 3,
    "crovl": 2,
    "crovls": 2,
    "crow": 1,
    "crow's": 1,
    "crowbar": 2,
    "crowborough": 3,
    "crowd": 1,
    "crowd's": 1,
    "crowded": 2,
    "crowded(1)": 2,
    "crowden": 2,
    "crowder": 2,
    "crowding": 2,
    "crowds": 1,
    "crowe": 1,
    "crowed": 1,
    "crowell": 2,
    "crowing": 2,
    "crowkeeper": 3,
    "crowkeepers": 3,
    "crowl": 1,
    "crowle": 1,
    "crowley": 2,
    "crowley's": 2,
    "crown": 1,
    "crown's": 1,
    "crowne": 1,
    "crowned": 1,
    "crowner": 2,
    "crowning": 2,
    "crownlike": 2,
    "crownover": 3,
    "crowns": 1,
    "crownx": 2,
    "crows": 1,
    "crowson": 2,
    "crowther": 2,
    "crowther's": 2,
    "crowthers": 2,
    "croxton": 2,
    "croy": 1,
    "croyle": 1,
    "crozier": 2,
    "cruce": 1,
    "cruces": 2,
    "crucial": 2,
    "crucially": 3,
    "crucible": 3,
    "crucified": 3,
    "crucifix": 3,
    "crucifixes": 4,
    "crucifixion": 4,
    "crucify": 3,
    "crud": 1,
    "cruddy": 2,
    "crude": 1,
    "crude's": 1,
    "crudele": 2,
    "crudely": 2,
    "crudes": 1,
    "crudup": 2,
    "cruea": 3,
    "cruel": 2,
    "cruel(1)": 1,
    "cruelest": 2,
    "cruelly": 2,
    "cruelties": 2,
    "cruelties(1)": 3,
    "cruelty": 2,
    "cruelty(1)": 3,
    "cruey": 2,
    "cruger": 2,
    "cruickshank": 2,
    "cruikshank": 3,
    "cruise": 1,
    "cruised": 1,
    "cruiser": 2,
    "cruiser's": 2,
    "cruisers": 2,
    "cruises": 2,
    "cruising": 2,
    "crull": 1,
    "crum": 1,
    "crumb": 1,
    "crumbaugh": 2,
    "crumble": 2,
    "crumbled": 2,
    "crumbles": 2,
    "crumbley": 2,
    "crumbling": 3,
    "crumbling(1)": 2,
    "crumbs": 1,
    "crumby": 2,
    "crume": 1,
    "crumitie": 3,
    "crumley": 2,
    "crumly": 2,
    "crumm": 1,
    "crummett": 2,
    "crummey": 2,
    "crummy": 2,
    "crump": 1,
    "crumpacker": 3,
    "crumple": 2,
    "crumpled": 2,
    "crumpler": 3,
    "crumpler(1)": 2,
    "crumpton": 2,
    "crumrine": 2,
    "crunch": 1,
    "crunched": 1,
    "cruncher": 2,
    "crunchers": 2,
    "crunches": 2,
    "crunching": 2,
    "crunchy": 2,
    "crunk": 1,
    "crunkleton": 3,
    "crupi": 2,
    "crusade": 2,
    "crusader": 3,
    "crusaders": 3,
    "crusades": 2,
    "crusading": 3,
    "crusan": 2,
    "cruse": 1,
    "cruser": 2,
    "crush": 1,
    "crushed": 1,
    "crusher": 2,
    "crushers": 2,
    "crushes": 2,
    "crushing": 2,
    "crusoe": 2,
    "crust": 1,
    "crustacean": 3,
    "crustaceans": 3,
    "crustaceous": 3,
    "crustal": 2,
    "crusted": 2,
    "crusts": 1,
    "crusty": 2,
    "crutch": 1,
    "crutcher": 2,
    "crutches": 2,
    "crutchfield": 2,
    "crutchfield's": 2,
    "crutchley": 2,
    "crute": 1,
    "cruthirds": 2,
    "crux": 1,
    "cruz": 1,
    "cruz's": 2,
    "cruzado": 3,
    "cruzados": 3,
    "cruzan": 2,
    "cruzan(1)": 2,
    "cruze": 1,
    "cruzen": 2,
    "cry": 1,
    "cryan": 2,
    "crybaby": 3,
    "cryder": 2,
    "cryderman": 3,
    "crye": 1,
    "cryer": 2,
    "crying": 2,
    "crymes": 1,
    "cryogenic": 4,
    "cryogenics": 4,
    "cryolite": 3,
    "crypt": 1,
    "cryptic": 2,
    "crypto": 2,
    "cryptoclearance": 4,
    "cryptosporidium": 6,
    "crypts": 1,
    "crysler": 3,
    "crysler(1)": 2,
    "crystal": 2,
    "crystal's": 2,
    "crystalline": 3,
    "crystallize": 3,
    "crystallized": 3,
    "crystallizes": 4,
    "crystallizing": 4,
    "crystallographer": 5,
    "crystallography": 5,
    "crystals": 2,
    "cryster": 2,
    "crytzer": 2,
    "csar": 1,
    "csaszar": 2,
    "cspan": 2,
    "cspi": 4,
    "ct": 1,
    "cuadra": 3,
    "cuadrado": 4,
    "cuajone": 3,
    "cuauhtemoc": 4,
    "cub": 1,
    "cuba": 2,
    "cuba's": 2,
    "cuban": 2,
    "cubans": 2,
    "cubbage": 2,
    "cubbies": 2,
    "cubbison": 3,
    "cubbyhole": 3,
    "cube": 1,
    "cubed": 1,
    "cubes": 1,
    "cubic": 2,
    "cubic's": 2,
    "cubicle": 3,
    "cubicles": 3,
    "cubism": 3,
    "cubist": 2,
    "cubit": 2,
    "cubs": 1,
    "cubs'": 1,
    "cuccaro": 3,
    "cucchi": 2,
    "cucchiara": 4,
    "cucci": 2,
    "cuccia": 2,
    "cuccio": 3,
    "cuckoo": 2,
    "cuckoo(1)": 2,
    "cuckoo's": 2,
    "cuckoos": 2,
    "cuco": 2,
    "cucumber": 3,
    "cucumbers": 3,
    "cudahy": 3,
    "cudd": 1,
    "cuddeback": 2,
    "cuddihy": 3,
    "cuddle": 2,
    "cuddled": 2,
    "cuddling": 2,
    "cuddly": 2,
    "cuddy": 2,
    "cude": 1,
    "cudgel": 2,
    "cudgels": 2,
    "cudmore": 2,
    "cudney": 2,
    "cudworth": 2,
    "cue": 1,
    "cued": 1,
    "cuellar": 2,
    "cuello": 3,
    "cuenca": 2,
    "cuero": 2,
    "cuervo": 2,
    "cues": 1,
    "cuesta": 2,
    "cueto": 2,
    "cueva": 2,
    "cuevas": 2,
    "cuff": 1,
    "cuffe": 1,
    "cuffed": 1,
    "cuffee": 2,
    "cuffs": 1,
    "cugini": 3,
    "cuhney": 2,
    "cuidado": 3,
    "cuing": 2,
    "cuisinart": 3,
    "cuisinart(1)": 3,
    "cuisinarts": 3,
    "cuisine": 2,
    "cuisines": 2,
    "cul": 1,
    "culberson": 3,
    "culbert": 2,
    "culbertson": 3,
    "culbreath": 2,
    "culbreth": 2,
    "culbro": 2,
    "culex": 2,
    "culhane": 2,
    "culinary": 4,
    "culinova": 4,
    "culkin": 2,
    "cull": 1,
    "cullan": 2,
    "culled": 1,
    "cullen": 2,
    "cullens": 2,
    "culler": 2,
    "culler's": 2,
    "cullers": 2,
    "cullerton": 3,
    "cullerton's": 3,
    "cullet": 2,
    "culleton": 3,
    "culley": 2,
    "cullifer": 3,
    "culligan": 3,
    "cullimore": 3,
    "cullin": 2,
    "cullinan": 3,
    "cullinane": 3,
    "cullinet": 3,
    "culling": 2,
    "cullins": 2,
    "cullipher": 3,
    "cullison": 3,
    "cullman": 2,
    "cullom": 2,
    "cullop": 2,
    "cullud": 2,
    "cullum": 2,
    "cullum's": 2,
    "cully": 2,
    "culmer": 2,
    "culminate": 3,
    "culminated": 4,
    "culminated(1)": 4,
    "culminates": 3,
    "culminating": 4,
    "culmination": 4,
    "culp": 1,
    "culpa": 2,
    "culpability": 5,
    "culpable": 3,
    "culpepper": 3,
    "culprit": 2,
    "culprits": 2,
    "cult": 1,
    "cult's": 1,
    "cultic": 2,
    "cultist": 2,
    "cultist(1)": 2,
    "cultists": 2,
    "cultivate": 3,
    "cultivated": 4,
    "cultivates": 3,
    "cultivating": 4,
    "cultivation": 4,
    "culton": 2,
    "cults": 1,
    "cultural": 3,
    "culturalism": 5,
    "culturally": 4,
    "culture": 2,
    "culture's": 2,
    "cultured": 2,
    "cultures": 2,
    "culturing": 3,
    "culvahouse": 3,
    "culver": 2,
    "culver's": 2,
    "culverhouse": 3,
    "culverhouse's": 4,
    "culvert": 2,
    "culwell": 2,
    "cul_de_sac": 3,
    "cum": 1,
    "cumbee": 2,
    "cumber": 2,
    "cumberbatch": 3,
    "cumberland": 3,
    "cumberledge": 3,
    "cumbersome": 3,
    "cumbia": 3,
    "cumbias": 3,
    "cumbie": 2,
    "cumbo": 2,
    "cumby": 2,
    "cumin": 2,
    "cumings": 2,
    "cumming": 2,
    "cummings": 2,
    "cummington": 3,
    "cummins": 2,
    "cummins's": 3,
    "cummiskey": 3,
    "cumpston": 2,
    "cumpton": 2,
    "cumulative": 4,
    "cumulatively": 5,
    "cunanan": 3,
    "cunanan's": 3,
    "cunard": 2,
    "cundall": 2,
    "cundari": 3,
    "cundiff": 2,
    "cundill": 2,
    "cundy": 2,
    "cuneiform": 4,
    "cuneo": 3,
    "cunha": 2,
    "cunliffe": 2,
    "cunnane": 2,
    "cunneen": 2,
    "cunniff": 2,
    "cunnilingus": 4,
    "cunning": 2,
    "cunningham": 3,
    "cunningham's": 3,
    "cunnington": 3,
    "cunt": 1,
    "cuny": 2,
    "cuoco": 2,
    "cuomo": 2,
    "cuomo's": 2,
    "cuong": 1,
    "cuozzo": 2,
    "cup": 1,
    "cupboard": 2,
    "cupboards": 2,
    "cupcake": 2,
    "cupcakes": 2,
    "cuperose": 3,
    "cupertino": 4,
    "cupid": 2,
    "cupidity": 4,
    "cupids": 2,
    "cupit": 2,
    "cupo": 2,
    "cupola": 3,
    "cupp": 1,
    "cuppett": 2,
    "cupples": 2,
    "cupps": 1,
    "cuppy": 2,
    "cups": 1,
    "cur": 1,
    "curable": 3,
    "curacao": 3,
    "curare": 3,
    "curari": 3,
    "curate": 2,
    "curative": 3,
    "curatolo": 4,
    "curator": 3,
    "curator(1)": 3,
    "curator's": 3,
    "curator's(1)": 3,
    "curatorial": 5,
    "curators": 3,
    "curators(1)": 3,
    "curb": 1,
    "curbed": 1,
    "curbelo": 3,
    "curbing": 2,
    "curbow": 2,
    "curbs": 1,
    "curbside": 2,
    "curbstone": 2,
    "curby": 2,
    "curci": 2,
    "curcio": 3,
    "curcuru": 3,
    "curd": 1,
    "cure": 1,
    "cured": 1,
    "cures": 1,
    "cureton": 2,
    "curfew": 2,
    "curfews": 2,
    "curfman": 2,
    "curiale": 4,
    "curie": 2,
    "curie(1)": 2,
    "curiel": 2,
    "curing": 2,
    "curington": 3,
    "curio": 3,
    "curios": 3,
    "curiosities": 5,
    "curiosity": 5,
    "curious": 3,
    "curiouser": 4,
    "curiously": 4,
    "curitiba": 4,
    "curl": 1,
    "curle": 2,
    "curled": 1,
    "curlee": 2,
    "curler": 2,
    "curlers": 2,
    "curless": 2,
    "curlett": 2,
    "curley": 2,
    "curlin": 2,
    "curling": 2,
    "curls": 1,
    "curly": 2,
    "curmudgeon": 3,
    "curmudgeons": 3,
    "curnow": 2,
    "curnutt": 2,
    "curnutte": 2,
    "curragh": 2,
    "curragh(1)": 2,
    "curran": 2,
    "curren": 2,
    "currence": 2,
    "currencies": 3,
    "currencies'": 3,
    "currency": 3,
    "currency's": 3,
    "currencywatch": 4,
    "currens": 2,
    "current": 2,
    "current(1)": 1,
    "current(2)": 2,
    "current's": 2,
    "currently": 3,
    "currents": 2,
    "curreri": 3,
    "currey": 2,
    "curricula": 4,
    "curricular": 4,
    "curriculum": 4,
    "curriculums": 4,
    "currie": 2,
    "curried": 2,
    "currier": 3,
    "curries": 2,
    "currin": 2,
    "currington": 3,
    "curro": 2,
    "curry": 2,
    "curry(1)": 2,
    "curry's": 2,
    "curry's(1)": 2,
    "currying": 3,
    "currys": 2,
    "currys(1)": 2,
    "curse": 1,
    "cursed": 1,
    "curses": 2,
    "cursing": 2,
    "cursor": 2,
    "cursory": 3,
    "curt": 1,
    "curt's": 1,
    "curtail": 2,
    "curtailed": 2,
    "curtailing": 3,
    "curtailment": 3,
    "curtailments": 3,
    "curtails": 2,
    "curtain": 2,
    "curtains": 2,
    "curti": 2,
    "curtice": 2,
    "curtin": 2,
    "curtis": 2,
    "curtis(1)": 2,
    "curtis'": 2,
    "curtiss": 2,
    "curtly": 2,
    "curtner": 2,
    "curto": 2,
    "curtright": 2,
    "curts": 1,
    "curtsinger": 3,
    "curtsy": 2,
    "curvature": 3,
    "curve": 1,
    "curved": 1,
    "curves": 1,
    "curvin": 2,
    "curving": 2,
    "curvy": 2,
    "curzio": 3,
    "cus": 1,
    "cus(1)": 3,
    "cusack": 2,
    "cusano": 3,
    "cush": 1,
    "cush(1)": 1,
    "cushey": 2,
    "cushing": 2,
    "cushion": 2,
    "cushioned": 2,
    "cushioning": 3,
    "cushioning(1)": 2,
    "cushions": 2,
    "cushitic": 3,
    "cushman": 2,
    "cushy": 2,
    "cusiana": 4,
    "cusic": 2,
    "cusick": 2,
    "cusimano": 4,
    "cusip": 2,
    "cusip(1)": 2,
    "cusk": 1,
    "cusmano": 3,
    "cuso": 2,
    "cuso(1)": 2,
    "cuso's": 2,
    "cuso's(1)": 2,
    "cusp": 1,
    "cuss": 1,
    "cussed": 1,
    "cussing": 2,
    "cusson": 2,
    "custard": 2,
    "custer": 2,
    "custer's": 2,
    "custis": 2,
    "custodial": 4,
    "custodian": 4,
    "custodians": 4,
    "custodio": 4,
    "custody": 3,
    "custom": 2,
    "customarily": 5,
    "customary": 4,
    "customer": 3,
    "customer's": 3,
    "customers": 3,
    "customers'": 3,
    "customize": 3,
    "customized": 3,
    "customizes": 4,
    "customizing": 4,
    "customs": 2,
    "cusumano": 4,
    "cut": 1,
    "cutaia": 3,
    "cutaway": 3,
    "cutback": 2,
    "cutbacks": 2,
    "cutbirth": 2,
    "cutchall": 2,
    "cutcher": 2,
    "cutchin": 2,
    "cutchins": 2,
    "cute": 1,
    "cuteness": 2,
    "cuter": 2,
    "cutesiness": 3,
    "cutest": 2,
    "cutesy": 2,
    "cuthbert": 2,
    "cuthbertson": 3,
    "cuthrell": 2,
    "cuticle": 3,
    "cuticle(1)": 3,
    "cutillo": 3,
    "cutlass": 2,
    "cutler": 2,
    "cutler's": 2,
    "cutlery": 3,
    "cutlip": 2,
    "cutoff": 2,
    "cutoffs": 2,
    "cutout": 2,
    "cutouts": 2,
    "cutrale": 2,
    "cutrell": 2,
    "cutrer": 2,
    "cutright": 2,
    "cutrona": 3,
    "cutrone": 3,
    "cuts": 1,
    "cutsforth": 2,
    "cutshall": 2,
    "cutshaw": 2,
    "cutsinger": 3,
    "cutter": 2,
    "cutters": 2,
    "cutthroat": 2,
    "cutting": 2,
    "cuttings": 2,
    "cuttino": 3,
    "cuttlefish": 3,
    "cutts": 1,
    "cutty": 2,
    "cutugno": 3,
    "cutworm": 2,
    "cutworms": 2,
    "cuvelier": 3,
    "cuyahoga": 4,
    "cuyler": 2,
    "cuzzort": 2,
    "cwiertnia": 3,
    "cwik": 1,
    "cwikla": 2,
    "cwiklinski": 3,
    "cwynar": 2,
    "cxc": 3,
    "cxc(1)": 3,
    "cy": 1,
    "cyacq": 2,
    "cyan": 2,
    "cyanamid": 4,
    "cyanamid's": 4,
    "cyanazine": 4,
    "cyanide": 3,
    "cyanide(1)": 2,
    "cyanuric": 4,
    "cyb": 1,
    "cyb(1)": 3,
    "cyber": 2,
    "cybercash": 3,
    "cyberporn": 3,
    "cybersex": 3,
    "cyberspace": 3,
    "cyberspace's": 4,
    "cybertrend": 3,
    "cybertrends": 3,
    "cybill": 2,
    "cyborg": 2,
    "cybulski": 3,
    "cycads": 2,
    "cycare": 2,
    "cyclades": 3,
    "cyclades(1)": 2,
    "cycle": 2,
    "cycled": 2,
    "cycles": 2,
    "cyclic": 2,
    "cyclical": 3,
    "cyclical(1)": 3,
    "cyclicality": 5,
    "cyclicals": 3,
    "cycling": 3,
    "cycling(1)": 2,
    "cyclist": 3,
    "cyclist(1)": 2,
    "cyclists": 3,
    "cyclists(1)": 2,
    "cyclists(2)": 3,
    "cyclists(3)": 2,
    "cyclohexane": 4,
    "cyclone": 2,
    "cyclones": 2,
    "cyclopean": 4,
    "cyclops": 2,
    "cyclops's": 3,
    "cyclosporine": 4,
    "cyclostome": 3,
    "cyclostomes": 3,
    "cyclotron": 3,
    "cycolor": 3,
    "cyd": 1,
    "cydonia": 4,
    "cydrome": 2,
    "cyert": 2,
    "cygan": 2,
    "cygne": 2,
    "cygnus": 2,
    "cyhexatin": 4,
    "cylinder": 3,
    "cylinder(1)": 3,
    "cylinders": 3,
    "cylindrical": 4,
    "cylindrical(1)": 4,
    "cymbal": 2,
    "cymbals": 2,
    "cymrot": 2,
    "cynara": 3,
    "cyndi": 2,
    "cynic": 2,
    "cynical": 3,
    "cynically": 4,
    "cynically(1)": 3,
    "cynicism": 4,
    "cynics": 2,
    "cynric": 2,
    "cynth": 1,
    "cynthia": 3,
    "cynthia's": 3,
    "cynthie": 2,
    "cynwyd": 2,
    "cypert": 2,
    "cypher": 2,
    "cyphers": 2,
    "cyphert": 2,
    "cypress": 2,
    "cypress(1)": 2,
    "cypress's": 3,
    "cyprian": 3,
    "cypriot": 3,
    "cypriot(1)": 3,
    "cypriots": 3,
    "cypriots(1)": 3,
    "cypris": 2,
    "cyprus": 2,
    "cyr": 1,
    "cyran": 2,
    "cyrano": 3,
    "cyrano(1)": 3,
    "cyrena": 3,
    "cyrenius": 4,
    "cyril": 2,
    "cyrilla": 3,
    "cyrillic": 3,
    "cyrix": 2,
    "cyrix(1)": 2,
    "cyrix's": 3,
    "cyrix's(1)": 3,
    "cyrofin": 3,
    "cyrus": 2,
    "cyst": 1,
    "cystic": 2,
    "cysts": 1,
    "cytherea": 4,
    "cytogen": 3,
    "cytology": 4,
    "cytomegalovirus": 7,
    "cytoplasm": 4,
    "cytoplasmic": 4,
    "cytotech": 3,
    "cytotechs": 3,
    "cywinski": 3,
    "czaja": 2,
    "czajka": 2,
    "czajkowski": 3,
    "czapla": 2,
    "czaplewski": 3,
    "czaplicki": 3,
    "czar": 1,
    "czar's": 1,
    "czarist": 2,
    "czarnecki": 3,
    "czarnik": 2,
    "czarny": 2,
    "czars": 1,
    "czartoryski": 4,
    "czech": 1,
    "czechoslovak": 4,
    "czechoslovakia": 6,
    "czechoslovakia's": 6,
    "czechoslovakian": 6,
    "czechoslovaks": 4,
    "czechowski": 3,
    "czechs": 1,
    "czekajewski": 4,
    "czepiel": 2,
    "czerniak": 3,
    "czerny": 2,
    "czerwinski": 3,
    "czerwonka": 3,
    "czeslaw": 2,
    "czyz": 1,
    "czyzewski": 3,
    "d": 1,
    "d'affaires": 2,
    "d'agostino": 4,
    "d'agostino's": 4,
    "d'alene": 2,
    "d'alene's": 2,
    "d'alessandra": 4,
    "d'alessandrini": 5,
    "d'alessandro": 4,
    "d'alessandro(1)": 4,
    "d'alessandro's": 4,
    "d'alessi": 3,
    "d'alessi(1)": 3,
    "d'allest": 2,
    "d'amato": 3,
    "d'amato's": 3,
    "d'america": 4,
    "d'amico": 3,
    "d'amore": 4,
    "d'amore's": 4,
    "d'andrea": 3,
    "d'angelo": 4,
    "d'angelo's": 4,
    "d'arcy": 2,
    "d'aubuisson": 3,
    "d'aviation": 4,
    "d'electricite": 5,
    "d'electricite(1)": 5,
    "d'escoto": 3,
    "d'estaing": 2,
    "d'etat": 2,
    "d'etat(1)": 2,
    "d'etats": 2,
    "d'etre": 2,
    "d'etude": 2,
    "d'genetta": 4,
    "d'ivoire": 2,
    "d'oeuvre": 1,
    "d'oeuvres": 1,
    "d'or": 1,
    "d'orsay": 2,
    "d's": 1,
    "d'souza": 3,
    "d'souza(1)": 3,
    "d.": 1,
    "d.'s": 1,
    "d.s": 1,
    "da": 1,
    "da(1)": 2,
    "da's": 2,
    "daane": 1,
    "daarmstadt": 2,
    "daas": 1,
    "dab": 1,
    "dabah": 2,
    "dabah(1)": 2,
    "dabbing": 2,
    "dabble": 2,
    "dabbled": 2,
    "dabbles": 2,
    "dabbling": 3,
    "dabbling(1)": 2,
    "dabbs": 1,
    "dabchick": 2,
    "dabhol": 2,
    "dabkowski": 3,
    "dabney": 2,
    "dabrowski": 3,
    "dac": 1,
    "dace": 1,
    "dacey": 2,
    "dacha": 2,
    "dachau": 2,
    "dachshund": 2,
    "dachshunds": 2,
    "dacia": 3,
    "dack": 1,
    "dacosta": 3,
    "dacquisto": 3,
    "dacron": 2,
    "dacruz": 2,
    "dacs": 1,
    "dactyl": 2,
    "dacunha": 3,
    "dacus": 2,
    "dacy": 2,
    "dad": 1,
    "dad's": 1,
    "dada": 2,
    "dadamo": 3,
    "daddario": 4,
    "daddies": 2,
    "daddona": 3,
    "daddy": 2,
    "daddy's": 2,
    "daddy-o": 3,
    "daddy-o's": 3,
    "dade": 1,
    "dadeland": 2,
    "dadfar": 2,
    "dadisman": 3,
    "dado": 2,
    "dads": 1,
    "dady": 2,
    "dae": 1,
    "daedalus": 3,
    "daedalus(1)": 3,
    "daelim": 2,
    "daemon": 2,
    "daemon(1)": 2,
    "daenzer": 2,
    "daewoo": 2,
    "daffern": 2,
    "daffin": 2,
    "daffodil": 3,
    "daffodils": 3,
    "daffron": 2,
    "daffy": 2,
    "daffynition": 4,
    "dafna": 2,
    "dafoe": 2,
    "dafsa": 2,
    "daft": 1,
    "dag": 1,
    "dagan": 2,
    "dagata": 3,
    "dagen": 2,
    "dagenais": 3,
    "dagenham": 3,
    "dagenhart": 3,
    "dager": 2,
    "dagestan": 3,
    "dagg": 1,
    "dagger": 2,
    "daggers": 2,
    "daggett": 2,
    "daggs": 1,
    "daggy": 2,
    "dagle": 2,
    "dagley": 2,
    "dagmar": 2,
    "dagon": 2,
    "dagostino": 4,
    "dague": 1,
    "dagwood": 2,
    "dah": 1,
    "daher": 2,
    "dahill": 2,
    "dahl": 1,
    "dahl's": 1,
    "dahlberg": 2,
    "dahle": 2,
    "dahlem": 2,
    "dahlen": 2,
    "dahler": 2,
    "dahlgren": 2,
    "dahlheimer": 3,
    "dahlia": 2,
    "dahlin": 2,
    "dahlke": 1,
    "dahlman": 2,
    "dahlquist": 2,
    "dahlstrom": 2,
    "dahm": 1,
    "dahman": 2,
    "dahmen": 2,
    "dahmer": 2,
    "dahmer's": 2,
    "dahms": 1,
    "dahn": 1,
    "dahn(1)": 1,
    "dahnke": 1,
    "dahrain": 2,
    "dai": 1,
    "daido": 2,
    "daidone": 2,
    "daiei": 2,
    "daigle": 2,
    "daigler": 2,
    "daignault": 2,
    "daigneault": 2,
    "daigre": 2,
    "daigrepont": 3,
    "daihatsu": 3,
    "daiichi": 3,
    "daikin": 2,
    "dail": 1,
    "daile": 1,
    "dailey": 2,
    "dailies": 2,
    "daily": 2,
    "daimler": 2,
    "daimler(1)": 2,
    "daimler's": 2,
    "daimones": 2,
    "dain": 1,
    "daines": 1,
    "daini": 2,
    "dainippon": 3,
    "dains": 1,
    "dainty": 2,
    "daiquiri": 3,
    "dairies": 2,
    "dairy": 2,
    "dairying": 3,
    "dairymen": 3,
    "dais": 1,
    "daise": 1,
    "daisey": 2,
    "daishowa": 3,
    "daisies": 2,
    "daisy": 2,
    "daisy's": 2,
    "daiwa": 2,
    "daiwa's": 2,
    "dajun": 2,
    "dak": 1,
    "dak(1)": 3,
    "dakar": 2,
    "dake": 1,
    "dakin": 2,
    "dakota": 3,
    "dakota's": 3,
    "dakotan": 3,
    "dakotans": 3,
    "dakotas": 3,
    "dal": 1,
    "dalafield": 3,
    "dalai": 2,
    "dalai(1)": 2,
    "dalai(2)": 2,
    "dalal": 2,
    "dalbar": 2,
    "dalbec": 2,
    "dalbert": 2,
    "dalbey": 2,
    "dalby": 2,
    "dale": 1,
    "dale's": 1,
    "daleiden": 3,
    "dalen": 2,
    "daleo": 3,
    "dales": 1,
    "dalesandro": 4,
    "dalesio": 4,
    "dalessandro": 4,
    "dalessio": 4,
    "daleth": 2,
    "daley": 2,
    "daley's": 2,
    "dalfen": 2,
    "dalfonso": 3,
    "dalfort": 2,
    "dalgety": 3,
    "dalgleish": 3,
    "dalgleish(1)": 2,
    "dalhouse": 2,
    "dali": 2,
    "dalia": 2,
    "dalian": 3,
    "daliberti": 4,
    "dalila": 3,
    "dalis": 2,
    "dalke": 1,
    "dalkon": 2,
    "dall": 1,
    "dalla": 2,
    "dallaire": 2,
    "dallara": 3,
    "dallas": 2,
    "dallas'": 2,
    "dallas's": 3,
    "dalley": 2,
    "dallhold": 2,
    "dalliance": 3,
    "dallied": 2,
    "dallman": 2,
    "dallmann": 2,
    "dally": 2,
    "dalma": 2,
    "dalman": 2,
    "dalmatian": 3,
    "dalmatians": 3,
    "dalmo": 2,
    "dalo": 2,
    "daloia": 3,
    "daloisio": 4,
    "dalonzo": 3,
    "dalpe": 1,
    "dalpiaz": 3,
    "dalporto": 3,
    "dalrymple": 3,
    "dalto": 2,
    "dalton": 2,
    "dalton's": 2,
    "daltons": 2,
    "daly": 2,
    "dalzell": 2,
    "dalziel": 2,
    "dam": 1,
    "dam's": 1,
    "dama": 2,
    "damaclean": 3,
    "damage": 2,
    "damage(1)": 2,
    "damaged": 2,
    "damaged(1)": 2,
    "damages": 3,
    "damages(1)": 3,
    "damaging": 3,
    "daman": 2,
    "damaris": 3,
    "damas": 2,
    "damascus": 3,
    "damascus's": 4,
    "damask": 2,
    "damasks": 2,
    "damato": 3,
    "dambach": 2,
    "dambacher": 3,
    "dambra": 2,
    "dambrosia": 4,
    "dambrosio": 4,
    "dame": 1,
    "dame's": 1,
    "damelio": 4,
    "damer": 2,
    "damerlin": 3,
    "damerlin(1)": 3,
    "dameron": 3,
    "dames": 1,
    "damewood": 2,
    "damgard": 2,
    "damian": 3,
    "damiani": 4,
    "damiano": 4,
    "damianos": 4,
    "damico": 3,
    "damien": 3,
    "damien's": 3,
    "damietta": 4,
    "daminozide": 4,
    "damita": 3,
    "damitz": 2,
    "damm": 1,
    "dammam": 2,
    "damman": 2,
    "dammann": 2,
    "damme": 1,
    "damme(1)": 1,
    "dammed": 1,
    "dammen": 2,
    "dammer": 2,
    "dammerman": 3,
    "damming": 2,
    "dammit": 2,
    "damn": 1,
    "damnation": 3,
    "damned": 1,
    "damning": 2,
    "damns": 1,
    "damocles": 3,
    "damon": 2,
    "damon's": 2,
    "damone": 2,
    "damons": 2,
    "damoose": 2,
    "damore": 2,
    "damour": 2,
    "damp": 1,
    "damped": 1,
    "dampen": 2,
    "dampened": 2,
    "dampening": 3,
    "dampening(1)": 2,
    "damper": 2,
    "dampers": 2,
    "dampier": 3,
    "damping": 2,
    "dampness": 2,
    "damps": 1,
    "damron": 2,
    "damrow": 2,
    "dams": 1,
    "damsel": 2,
    "damson": 2,
    "damuth": 2,
    "dan": 1,
    "dan's": 1,
    "dana": 2,
    "dana's": 2,
    "danaher": 3,
    "danahy": 3,
    "danbury": 3,
    "danby": 2,
    "danca": 2,
    "dancanet": 3,
    "dance": 1,
    "danced": 1,
    "dancer": 2,
    "dancer's": 2,
    "dancers": 2,
    "dancers'": 2,
    "dances": 2,
    "dances(1)": 2,
    "dancey": 2,
    "dancin'": 2,
    "dancing": 2,
    "dancsak": 2,
    "dancy": 2,
    "dandelion": 4,
    "dandelions": 4,
    "dandeneau": 3,
    "dando": 2,
    "dandrea": 3,
    "dandridge": 2,
    "dandruff": 2,
    "dandurand": 3,
    "dandy": 2,
    "dandyism": 4,
    "dane": 1,
    "dane's": 1,
    "daneel": 2,
    "danek": 2,
    "danell": 2,
    "danella": 3,
    "danelle": 2,
    "daner": 2,
    "danes": 1,
    "danese": 3,
    "daney": 2,
    "danford": 2,
    "danforth": 2,
    "dang": 1,
    "dangel": 2,
    "dangelo": 3,
    "danger": 2,
    "dangerfield": 3,
    "dangerous": 3,
    "dangerously": 4,
    "dangerousness": 4,
    "dangers": 2,
    "dangews": 2,
    "dangle": 2,
    "dangled": 2,
    "dangler": 3,
    "dangler(1)": 2,
    "dangles": 2,
    "dangling": 3,
    "dangling(1)": 2,
    "dango": 2,
    "dani": 2,
    "dania": 2,
    "danica": 3,
    "daniel": 2,
    "daniel's": 2,
    "daniela": 3,
    "daniele": 2,
    "daniell": 2,
    "daniella": 3,
    "danielle": 3,
    "danielle(1)": 2,
    "daniello": 4,
    "daniels": 2,
    "daniels's": 3,
    "daniels's(1)": 3,
    "danielsen": 3,
    "danielski": 3,
    "danielson": 3,
    "daniloff": 3,
    "danis": 2,
    "danish": 2,
    "danju": 2,
    "danju's": 2,
    "danjub": 2,
    "danjub's": 2,
    "danjube": 2,
    "danjube's": 2,
    "danjus": 2,
    "danjus(1)": 2,
    "dank": 1,
    "danker": 2,
    "dankert": 2,
    "dankner": 2,
    "danko": 2,
    "danks": 1,
    "danley": 2,
    "danly": 2,
    "dann": 1,
    "danna": 2,
    "dannelly": 3,
    "dannels": 2,
    "dannemeyer": 3,
    "dannemeyer(1)": 2,
    "dannemiller": 4,
    "dannemiller(1)": 3,
    "dannen": 2,
    "dannenberg": 3,
    "danner": 2,
    "danners": 2,
    "dannie": 2,
    "dannunzio": 4,
    "danny": 2,
    "danny's": 2,
    "dano": 2,
    "danos": 2,
    "danowski": 3,
    "dansby": 2,
    "danser": 2,
    "dansereau": 3,
    "dansforth": 2,
    "dansforth's": 2,
    "dansie": 2,
    "danske": 1,
    "danskin": 2,
    "dansky": 2,
    "danso": 2,
    "danson": 2,
    "danstett": 2,
    "dansville": 2,
    "dansville's": 2,
    "dant": 1,
    "dante": 2,
    "dante's": 2,
    "dantin": 2,
    "danton": 2,
    "dantoni": 3,
    "dantonio": 4,
    "dantrell": 2,
    "dantuono": 3,
    "dantzler": 2,
    "danube": 2,
    "danvers": 2,
    "danville": 2,
    "danvy": 2,
    "danylyszyn": 4,
    "danz": 1,
    "danza": 2,
    "danzer": 2,
    "danzig": 2,
    "danziger": 3,
    "danzy": 2,
    "dao": 1,
    "daoud": 1,
    "daoust": 1,
    "daphne": 2,
    "daphne's": 2,
    "daphnis": 2,
    "dapice": 2,
    "dapolito": 4,
    "daponte": 3,
    "dapozzo": 3,
    "dapp": 1,
    "dapper": 2,
    "dapuzzo": 3,
    "daquila": 3,
    "dar": 1,
    "dara": 2,
    "darak": 2,
    "darblay": 2,
    "darbonne": 2,
    "darby": 2,
    "darby's": 2,
    "darbyshire": 3,
    "darcangelo": 4,
    "darcey": 2,
    "darcie": 2,
    "darco": 2,
    "darcy": 2,
    "dardar": 2,
    "darden": 2,
    "darden's": 2,
    "dardis": 2,
    "dare": 1,
    "dared": 1,
    "daredevil": 3,
    "daredevils": 3,
    "daremblum": 3,
    "daren": 2,
    "darensbourg": 3,
    "darensbourg(1)": 3,
    "dares": 1,
    "daresay": 2,
    "darfur": 2,
    "darga": 2,
    "dargan": 2,
    "dargis": 2,
    "daria": 3,
    "darice": 2,
    "darien": 3,
    "darienzo": 3,
    "darin": 2,
    "daring": 2,
    "dario": 3,
    "darity": 3,
    "darius": 3,
    "darjeeling": 3,
    "darjeeling(1)": 3,
    "dark": 1,
    "darke": 1,
    "darken": 2,
    "darkened": 2,
    "darkening": 3,
    "darkening(1)": 2,
    "darker": 2,
    "darkest": 2,
    "darkie": 2,
    "darkly": 2,
    "darkness": 2,
    "darkroom": 2,
    "darla": 2,
    "darland": 2,
    "darleen": 2,
    "darlene": 2,
    "darley": 2,
    "darlin": 2,
    "darline": 2,
    "darling": 2,
    "darlings": 2,
    "darlington": 3,
    "darman": 2,
    "darman's": 2,
    "darmon": 2,
    "darmstadt": 2,
    "darn": 1,
    "darnall": 2,
    "darned": 1,
    "darnedest": 2,
    "darnedest(1)": 2,
    "darnel": 2,
    "darnell": 2,
    "darner": 2,
    "darnold": 2,
    "darns": 1,
    "darocha": 3,
    "darosa": 3,
    "darpa": 2,
    "darpino": 3,
    "darr": 1,
    "darr(1)": 1,
    "darragh": 2,
    "darrah": 2,
    "darrel": 2,
    "darrell": 2,
    "darrelle": 2,
    "darren": 2,
    "darrick": 2,
    "darrigo": 3,
    "darrin": 2,
    "darrington": 3,
    "darroch": 2,
    "darrough": 2,
    "darrow": 2,
    "darrow's": 2,
    "darryl": 2,
    "darsey": 2,
    "darst": 1,
    "darsy": 2,
    "dart": 1,
    "dart's": 1,
    "dartboard": 2,
    "darted": 2,
    "darter": 2,
    "dartez": 2,
    "darth": 1,
    "darting": 2,
    "dartmouth": 2,
    "dartmouth's": 2,
    "darton": 2,
    "darts": 1,
    "dartt": 1,
    "darty": 2,
    "darty's": 2,
    "darville": 2,
    "darwin": 2,
    "darwinian": 4,
    "darwinism": 4,
    "darwish": 2,
    "daryl": 2,
    "das": 1,
    "das(1)": 1,
    "dasa": 2,
    "dasa(1)": 2,
    "dasaro": 3,
    "dasburg": 2,
    "dascenzo": 3,
    "dasch": 1,
    "daschle": 2,
    "dascoli": 3,
    "dase": 1,
    "daseke": 3,
    "dash": 1,
    "dashboard": 2,
    "dashboards": 2,
    "dashed": 1,
    "dashel": 2,
    "dashell": 2,
    "dasher": 2,
    "dashes": 2,
    "dashiell": 2,
    "dashiki": 3,
    "dashing": 2,
    "dashnaw": 2,
    "dashner": 2,
    "dashville": 2,
    "dashwood": 2,
    "dasilva": 3,
    "daspin": 2,
    "daspit": 2,
    "dass": 1,
    "dassault": 2,
    "dassault's": 2,
    "dassler": 2,
    "dassow": 2,
    "dastardly": 3,
    "dat": 1,
    "data": 2,
    "data(1)": 2,
    "data's": 2,
    "data's(1)": 2,
    "database": 3,
    "database(1)": 3,
    "databases": 4,
    "databases(1)": 4,
    "datacard": 3,
    "datacard(1)": 3,
    "datacards": 3,
    "datacards(1)": 3,
    "datacomm": 3,
    "datacomm(1)": 3,
    "datacomp": 3,
    "datacomp(1)": 3,
    "datacopy": 4,
    "datacopy(1)": 4,
    "datagraphix": 4,
    "datametrics": 4,
    "datametrics(1)": 4,
    "datapoint": 3,
    "datapoint(1)": 3,
    "datapoint's": 3,
    "datapoint's(1)": 3,
    "datapoints": 3,
    "datapoints(1)": 3,
    "datapower": 3,
    "datapower(1)": 3,
    "dataproducts": 4,
    "dataproducts'": 4,
    "dataproducts'(1)": 4,
    "dataquest": 3,
    "dataquest(1)": 3,
    "dataquest's": 3,
    "dataquest's(1)": 3,
    "dataram": 3,
    "dataram(1)": 3,
    "datarex": 3,
    "datarex(1)": 3,
    "datas": 2,
    "datas(1)": 2,
    "date": 1,
    "date's": 1,
    "dated": 2,
    "datek": 2,
    "dateline": 2,
    "dateline's": 2,
    "datelines": 2,
    "dates": 1,
    "datext": 2,
    "dating": 2,
    "dato": 2,
    "datron": 2,
    "dats": 1,
    "datsun": 2,
    "datsun(1)": 2,
    "datsun's": 2,
    "datsun's(1)": 2,
    "dattilio": 4,
    "dattilo": 3,
    "datuk": 2,
    "datum": 2,
    "datum(1)": 2,
    "datura": 3,
    "datz": 1,
    "dau": 1,
    "daub": 1,
    "daube": 1,
    "daubed": 1,
    "daubenspeck": 3,
    "dauber": 2,
    "daubert": 2,
    "dauch": 1,
    "daudelin": 3,
    "dauenhauer": 4,
    "dauer": 2,
    "daufuskie": 3,
    "daughdrill": 2,
    "daughenbaugh": 3,
    "daugherty": 3,
    "daughety": 3,
    "daughney": 2,
    "daughter": 2,
    "daughter's": 2,
    "daughters": 2,
    "daughters'": 2,
    "daughtery": 3,
    "daughton": 2,
    "daughtrey": 2,
    "daughtridge": 2,
    "daughtry": 2,
    "daul": 1,
    "dault": 1,
    "daulton": 2,
    "daum": 1,
    "daun": 1,
    "daunt": 1,
    "daunted": 2,
    "daunting": 2,
    "dauphin": 2,
    "dauphinais": 3,
    "dauphinee": 3,
    "dauria": 3,
    "daus": 1,
    "dauster": 2,
    "dauterive": 3,
    "dauzat": 2,
    "davalos": 3,
    "davanzo": 3,
    "davao": 2,
    "davao(1)": 2,
    "davault": 2,
    "davco": 2,
    "dave": 1,
    "dave's": 1,
    "davee": 2,
    "davenport": 3,
    "davenport's": 3,
    "davern": 2,
    "daversa": 3,
    "daves": 1,
    "davey": 2,
    "davi": 2,
    "davia": 3,
    "david": 2,
    "david's": 2,
    "davida": 3,
    "davide": 3,
    "davidge": 2,
    "davidian": 4,
    "davidian's": 4,
    "davidians": 4,
    "davidoff": 3,
    "davidow": 3,
    "davids": 2,
    "davidson": 3,
    "davidson's": 3,
    "davie": 2,
    "davies": 2,
    "davignon": 3,
    "davila": 3,
    "davilla": 3,
    "davin": 2,
    "davina": 3,
    "davinci": 3,
    "davino": 3,
    "davio's": 3,
    "davir": 2,
    "davis": 2,
    "davis(1)": 2,
    "davis'": 2,
    "davis'(1)": 3,
    "davis's": 3,
    "davis's(1)": 3,
    "davison": 3,
    "davisson": 3,
    "davitt": 2,
    "davlin": 2,
    "davoli": 3,
    "davos": 2,
    "davox": 2,
    "davy": 2,
    "davydov": 3,
    "daw": 1,
    "dawdle": 2,
    "dawdling": 2,
    "dawdy": 2,
    "dawe": 1,
    "dawes": 1,
    "dawit": 2,
    "dawkins": 2,
    "dawley": 2,
    "dawn": 1,
    "dawn's": 1,
    "dawned": 1,
    "dawning": 2,
    "dawns": 1,
    "daws": 1,
    "dawsey": 2,
    "dawson": 2,
    "dawson's": 2,
    "dax": 1,
    "dax'": 1,
    "dax's": 2,
    "daxor": 2,
    "day": 1,
    "day's": 1,
    "daya": 2,
    "daya's": 2,
    "dayan": 2,
    "daybreak": 2,
    "daycare": 2,
    "daycares": 2,
    "dayco": 2,
    "daydream": 2,
    "daydreamed": 2,
    "daydreaming": 3,
    "daydreams": 2,
    "daye": 1,
    "dayhoff": 2,
    "dayhuff": 2,
    "dayle": 1,
    "dayley": 2,
    "daylight": 2,
    "daylights": 2,
    "daylong": 2,
    "daynard": 2,
    "dayne": 1,
    "days": 1,
    "days'": 1,
    "daytime": 2,
    "daytimes": 2,
    "dayton": 2,
    "dayton's": 2,
    "daytona": 3,
    "daytop": 2,
    "daywalt": 2,
    "daze": 1,
    "dazed": 1,
    "dazey": 2,
    "dazs": 1,
    "dazzle": 2,
    "dazzled": 2,
    "dazzling": 3,
    "dazzling(1)": 2,
    "dazzo": 2,
    "dbase": 2,
    "ddt": 3,
    "de": 1,
    "de(1)": 1,
    "de(2)": 1,
    "de-excite": 3,
    "de-excites": 3,
    "dea": 1,
    "deacon": 2,
    "deaconess": 3,
    "deacons": 2,
    "deactivate": 4,
    "deactivated": 5,
    "dead": 1,
    "deadbeat": 2,
    "deadbeats": 2,
    "deadbolt": 2,
    "deaden": 2,
    "deadening": 3,
    "deadening(1)": 2,
    "deader": 2,
    "deadhead": 2,
    "deadheads": 2,
    "deadhorse": 2,
    "deadlier": 3,
    "deadliest": 3,
    "deadline": 2,
    "deadlines": 2,
    "deadliness": 3,
    "deadlock": 2,
    "deadlocked": 2,
    "deadlocks": 2,
    "deadly": 2,
    "deadpan": 2,
    "deadweight": 2,
    "deadwood": 2,
    "deadwyler": 3,
    "deady": 2,
    "deaf": 1,
    "deafen": 2,
    "deafening": 3,
    "deafening(1)": 2,
    "deafness": 2,
    "deahl": 1,
    "deak": 1,
    "deak's": 1,
    "deakin": 2,
    "deakins": 2,
    "deal": 1,
    "deal's": 1,
    "dealba": 3,
    "deale": 1,
    "dealer": 2,
    "dealer's": 2,
    "dealerline": 3,
    "dealers": 2,
    "dealers'": 2,
    "dealership": 3,
    "dealership's": 3,
    "dealerships": 3,
    "dealey": 2,
    "dealfish": 2,
    "dealing": 2,
    "dealings": 2,
    "dealmaker": 3,
    "dealmakers": 3,
    "dealmaking": 3,
    "dealmeida": 3,
    "deals": 1,
    "dealt": 1,
    "dealy": 2,
    "deam": 1,
    "deamer": 2,
    "dean": 1,
    "dean's": 1,
    "deana": 3,
    "deanda": 3,
    "deandrade": 3,
    "deandrea": 3,
    "deandrea(1)": 4,
    "deandrea's": 3,
    "deandrea's(1)": 4,
    "deane": 1,
    "deaner": 2,
    "deangelis": 4,
    "deangelo": 3,
    "deanna": 3,
    "deans": 1,
    "dear": 1,
    "dearborn": 2,
    "dearden": 2,
    "deardorff": 2,
    "deardourff": 2,
    "dearer": 2,
    "dearest": 2,
    "dearing": 2,
    "dearinger": 3,
    "dearly": 2,
    "dearman": 2,
    "dearmas": 2,
    "dearment": 2,
    "dearmon": 2,
    "dearmond": 2,
    "dearth": 1,
    "deary": 2,
    "deas": 1,
    "dease": 1,
    "deason": 2,
    "deasy": 2,
    "deater": 2,
    "death": 1,
    "death's": 1,
    "deathbed": 2,
    "deatherage": 3,
    "deatherage(1)": 2,
    "deathly": 2,
    "deaths": 1,
    "deathshot": 2,
    "deathwatch": 2,
    "deatley": 2,
    "deaton": 2,
    "deatrick": 2,
    "deats": 1,
    "deaver": 2,
    "deaver's": 2,
    "deavers": 2,
    "deavila": 3,
    "deb": 1,
    "debacker": 3,
    "debacle": 3,
    "debacles": 3,
    "debakey": 3,
    "debarment": 3,
    "debarr": 2,
    "debarros": 3,
    "debartolo": 4,
    "debartolo(1)": 4,
    "debartolos": 4,
    "debartolos(1)": 4,
    "debase": 2,
    "debased": 2,
    "debasement": 3,
    "debasing": 3,
    "debatable": 4,
    "debate": 2,
    "debate's": 2,
    "debated": 3,
    "debater": 3,
    "debaters": 3,
    "debates": 2,
    "debating": 3,
    "debator": 3,
    "debator's": 3,
    "debauche": 2,
    "debauchery": 4,
    "debaun": 2,
    "debbie": 2,
    "debbie's": 2,
    "debby": 2,
    "debeer": 2,
    "debeers": 2,
    "debelak": 3,
    "debell": 2,
    "debella": 3,
    "debellis": 3,
    "debello": 3,
    "debenedetto": 5,
    "debenedictis": 5,
    "debenture": 3,
    "debentures": 3,
    "debentures'": 3,
    "debernardi": 4,
    "deberry": 3,
    "debes": 1,
    "debevoise": 3,
    "debi": 2,
    "debiase": 4,
    "debilitate": 4,
    "debilitated": 5,
    "debilitating": 5,
    "debility": 4,
    "debit": 2,
    "deblanc": 2,
    "deblasio": 4,
    "deblock": 2,
    "deblois": 2,
    "deblum": 2,
    "deblum(1)": 2,
    "debnam": 2,
    "debo": 2,
    "deboard": 2,
    "deboe": 2,
    "deboer": 3,
    "deboers": 3,
    "debold": 2,
    "debolt": 2,
    "debona": 3,
    "debonair": 3,
    "debonis": 3,
    "debono": 3,
    "debor": 2,
    "debora": 2,
    "deborah": 3,
    "deborah(1)": 2,
    "deborah's": 3,
    "deborah's(1)": 2,
    "debord": 2,
    "deborde": 2,
    "debose": 2,
    "debow": 2,
    "deboy": 2,
    "debra": 2,
    "debraudwick": 3,
    "debrecen": 3,
    "debrief": 2,
    "debriefed": 2,
    "debriefing": 3,
    "debriefs": 2,
    "debris": 2,
    "debrosse": 2,
    "debruhl": 2,
    "debruin": 3,
    "debruler": 3,
    "debruyn": 2,
    "debruyne": 2,
    "debs": 1,
    "debt": 1,
    "debt's": 1,
    "debtholder": 3,
    "debtholders": 3,
    "debtor": 2,
    "debtor's": 2,
    "debtors": 2,
    "debtors'": 2,
    "debts": 1,
    "debug": 2,
    "debugging": 3,
    "debuhr": 2,
    "debunk": 2,
    "debunked": 2,
    "debunking": 3,
    "debunks": 2,
    "debus": 2,
    "debusk": 2,
    "debussy": 3,
    "debussy(1)": 3,
    "debussy's": 3,
    "debussy's(1)": 3,
    "debut": 2,
    "debut(1)": 2,
    "debutante": 3,
    "debutantes": 3,
    "debuted": 2,
    "debuted(1)": 2,
    "debuting": 3,
    "debuts": 2,
    "dec": 1,
    "dec's": 1,
    "decade": 2,
    "decade(1)": 2,
    "decade's": 2,
    "decadence": 3,
    "decadent": 3,
    "decadents": 3,
    "decades": 2,
    "decades(1)": 2,
    "decaf": 2,
    "decaffeinate": 4,
    "decaffeinated": 5,
    "decaffeinating": 5,
    "decaffeination": 5,
    "decaire": 2,
    "decals": 2,
    "decamillo": 4,
    "decamillo's": 4,
    "decamp": 2,
    "decamped": 2,
    "decandia": 4,
    "decant": 2,
    "decanting": 3,
    "decapitate": 4,
    "decapitated": 5,
    "decapitation": 5,
    "decapitations": 5,
    "decaprio": 4,
    "decapua": 4,
    "decarava": 4,
    "decarava's": 4,
    "decarli": 3,
    "decarlo": 3,
    "decaro": 3,
    "decarolis": 4,
    "decarolis(1)": 4,
    "decastro": 3,
    "decathlete": 3,
    "decathlon": 3,
    "decato": 3,
    "decatur": 3,
    "decay": 2,
    "decay(1)": 2,
    "decayed": 2,
    "decaying": 3,
    "decaying(1)": 3,
    "decays": 2,
    "decca": 2,
    "decease": 2,
    "deceased": 2,
    "dececco": 3,
    "decedent": 3,
    "decedent's": 3,
    "decedents": 3,
    "deceit": 2,
    "deceit(1)": 2,
    "deceitful": 3,
    "deceitful(1)": 3,
    "deceits": 2,
    "deceive": 2,
    "deceived": 2,
    "deceiving": 3,
    "decelerate": 4,
    "decelerated": 5,
    "decelerating": 5,
    "deceleration": 5,
    "decelle": 2,
    "decelles": 2,
    "december": 3,
    "december's": 3,
    "decency": 3,
    "decennial": 4,
    "decent": 2,
    "decently": 3,
    "decentralization": 6,
    "decentralize": 4,
    "decentralized": 4,
    "decentralizing": 5,
    "deception": 3,
    "deceptions": 3,
    "deceptive": 3,
    "deceptively": 4,
    "decertification": 6,
    "decertified": 4,
    "decertify": 4,
    "decesare": 4,
    "decesaris": 4,
    "dech": 1,
    "dechant": 2,
    "dechellis": 3,
    "dechene": 2,
    "decherd": 2,
    "dechert": 2,
    "dechine": 2,
    "dechine(1)": 2,
    "dechristopher": 4,
    "decibel": 3,
    "decibels": 3,
    "decicco": 3,
    "decide": 2,
    "decided": 3,
    "decidedly": 4,
    "decider": 3,
    "decides": 2,
    "deciding": 3,
    "deciduous": 4,
    "deciliter": 4,
    "decima": 3,
    "decimal": 3,
    "decimals": 3,
    "decimate": 3,
    "decimated": 4,
    "decimating": 4,
    "decimation": 4,
    "decipher": 3,
    "deciphered": 3,
    "deciphering": 4,
    "decision": 3,
    "decision's": 3,
    "decisionmaker": 5,
    "decisionmaking": 5,
    "decisions": 3,
    "decisive": 3,
    "decisively": 4,
    "decisiveness": 4,
    "deck": 1,
    "deckard": 2,
    "decked": 1,
    "decker": 2,
    "decker's": 2,
    "deckert": 2,
    "decking": 2,
    "deckman": 2,
    "decks": 1,
    "declaim": 2,
    "declaimed": 2,
    "declarant": 3,
    "declaration": 4,
    "declarations": 4,
    "declaratory": 5,
    "declare": 2,
    "declared": 2,
    "declares": 2,
    "declaring": 3,
    "declassified": 4,
    "declassify": 4,
    "declerck": 2,
    "declerck's": 2,
    "declercq": 2,
    "declercq's": 2,
    "declerk": 2,
    "declerk's": 2,
    "declerque": 2,
    "declerque's": 2,
    "decline": 2,
    "declined": 2,
    "decliner": 3,
    "decliners": 3,
    "declines": 2,
    "declining": 3,
    "declue": 2,
    "deco": 2,
    "decode": 2,
    "decoded": 3,
    "decoder": 3,
    "decoders": 3,
    "decodes": 2,
    "decoding": 3,
    "decola": 3,
    "decom": 2,
    "decommission": 4,
    "decommissioned": 4,
    "decommissioning": 5,
    "decompose": 3,
    "decomposed": 3,
    "decomposes": 4,
    "decomposing": 4,
    "decomposition": 5,
    "decomposition(1)": 5,
    "decompression": 4,
    "deconcini": 4,
    "decongestant": 4,
    "decongestant(1)": 4,
    "decongestants": 4,
    "decongestants(1)": 4,
    "deconstruct": 3,
    "deconstruction": 4,
    "decontaminate": 5,
    "decontaminated": 6,
    "decontamination": 6,
    "decontrol": 3,
    "decontrolled": 3,
    "decook": 2,
    "decor": 2,
    "decor(1)": 2,
    "decorate": 3,
    "decorated": 4,
    "decorated(1)": 4,
    "decorating": 4,
    "decoration": 4,
    "decorations": 4,
    "decorative": 3,
    "decorator": 4,
    "decorators": 4,
    "decordova": 4,
    "decorous": 3,
    "decorte": 3,
    "decorum": 3,
    "decosta": 3,
    "decoste": 3,
    "decoster": 3,
    "decoteau": 3,
    "decou": 2,
    "decouple": 3,
    "decoupling": 3,
    "decourcy": 3,
    "decoursey": 3,
    "decoy": 2,
    "decoys": 2,
    "decrane": 2,
    "decrease": 2,
    "decrease(1)": 2,
    "decreased": 2,
    "decreased(1)": 2,
    "decreases": 3,
    "decreases(1)": 3,
    "decreases(2)": 3,
    "decreasing": 3,
    "decreasing(1)": 3,
    "decree": 2,
    "decreed": 2,
    "decrees": 2,
    "decrepit": 3,
    "decrepitly": 4,
    "decrescenzo": 4,
    "decried": 2,
    "decries": 2,
    "decriminalization": 7,
    "decriminalize": 5,
    "decriminalizing": 6,
    "decristofaro": 5,
    "decry": 2,
    "decrying": 3,
    "decter": 2,
    "decuir": 2,
    "decurtis": 3,
    "decworld": 2,
    "dede": 1,
    "dedeaux": 2,
    "dedecker": 3,
    "dederichs": 2,
    "dederick": 3,
    "dedeurwaerder": 4,
    "dedham": 2,
    "dedic": 2,
    "dedicate": 3,
    "dedicated": 4,
    "dedicates": 3,
    "dedicating": 4,
    "dedication": 4,
    "dedios": 3,
    "dedman": 2,
    "dedmon": 2,
    "dedo": 2,
    "dedominicis": 5,
    "dedrick": 2,
    "deduce": 2,
    "deduced": 2,
    "deduct": 2,
    "deducted": 3,
    "deductibility": 6,
    "deductible": 4,
    "deductibles": 4,
    "deducting": 3,
    "deduction": 3,
    "deductions": 3,
    "deductive": 3,
    "deductively": 4,
    "deducts": 2,
    "dee": 1,
    "dee's": 1,
    "deeb": 1,
    "deed": 1,
    "deeded": 2,
    "deeded(1)": 2,
    "deedee": 2,
    "deedrick": 2,
    "deedrick's": 2,
    "deeds": 1,
    "deedy": 2,
    "deeg": 1,
    "deegan": 2,
    "deehan": 2,
    "deehan(1)": 2,
    "deel": 1,
    "deeley": 2,
    "deely": 2,
    "deem": 1,
    "deemed": 1,
    "deemer": 2,
    "deemphasize": 4,
    "deemphasizing": 5,
    "deems": 1,
    "deen": 1,
    "deener": 2,
    "deeney": 2,
    "deep": 1,
    "deepak": 2,
    "deepen": 2,
    "deepened": 2,
    "deepening": 3,
    "deepening(1)": 2,
    "deepens": 2,
    "deeper": 2,
    "deepest": 2,
    "deeply": 2,
    "deepwater": 3,
    "deer": 1,
    "deerborne": 2,
    "deere": 1,
    "deere's": 1,
    "deerfield": 2,
    "deering": 2,
    "deerman": 2,
    "deerskin": 2,
    "deery": 2,
    "dees": 1,
    "deese": 1,
    "deet": 1,
    "deeter": 2,
    "deets": 1,
    "deetz": 1,
    "defabio": 4,
    "deface": 2,
    "defaced": 2,
    "defacing": 3,
    "defalco": 3,
    "defamation": 4,
    "defamatory": 5,
    "defame": 2,
    "defamed": 2,
    "defarges": 3,
    "default": 2,
    "defaulted": 3,
    "defaulter": 3,
    "defaulters": 3,
    "defaulting": 3,
    "defaults": 2,
    "defazio": 4,
    "defazio(1)": 4,
    "defeasance": 3,
    "defeat": 2,
    "defeated": 3,
    "defeated(1)": 3,
    "defeating": 3,
    "defeatism": 4,
    "defeatist": 3,
    "defeats": 2,
    "defect": 2,
    "defect(1)": 2,
    "defected": 3,
    "defecting": 3,
    "defection": 3,
    "defections": 3,
    "defective": 3,
    "defector": 3,
    "defectors": 3,
    "defects": 2,
    "defects(1)": 2,
    "defee": 2,
    "defelice": 3,
    "defenbaugh": 3,
    "defence": 2,
    "defend": 2,
    "defendant": 3,
    "defendant's": 3,
    "defendants": 3,
    "defendants'": 3,
    "defended": 3,
    "defended(1)": 3,
    "defender": 3,
    "defender's": 3,
    "defenders": 3,
    "defending": 3,
    "defends": 2,
    "defense": 2,
    "defense's": 3,
    "defenseless": 3,
    "defenses": 3,
    "defenses(1)": 3,
    "defensible": 4,
    "defensive": 3,
    "defensively": 4,
    "defensiveness": 4,
    "defeo": 3,
    "defer": 2,
    "deference": 3,
    "deference(1)": 2,
    "deferential": 4,
    "deferential(1)": 4,
    "deferment": 3,
    "deferments": 3,
    "deferral": 3,
    "deferrals": 3,
    "deferred": 2,
    "deferring": 3,
    "defers": 2,
    "defex": 2,
    "deffenbaugh": 3,
    "deffeyes": 2,
    "defiance": 3,
    "defiant": 3,
    "defiantly": 4,
    "defibaugh": 3,
    "defibrillator": 5,
    "defibrillators": 5,
    "deficiencies": 4,
    "deficiency": 4,
    "deficient": 3,
    "deficit": 3,
    "deficit's": 3,
    "deficits": 3,
    "defied": 2,
    "defies": 2,
    "defilippis": 4,
    "defilippis(1)": 4,
    "defilippo": 4,
    "defina": 3,
    "definable": 4,
    "define": 2,
    "defined": 2,
    "defines": 2,
    "defining": 3,
    "definite": 3,
    "definitely": 4,
    "definition": 4,
    "definitions": 4,
    "definitive": 4,
    "definitively": 5,
    "defino": 3,
    "defiore": 4,
    "deflate": 2,
    "deflated": 3,
    "deflating": 3,
    "deflation": 3,
    "deflationary": 5,
    "deflator": 3,
    "deflect": 2,
    "deflected": 3,
    "deflecting": 3,
    "deflects": 2,
    "defleur": 2,
    "defoe": 2,
    "defoe's": 2,
    "defoliant": 4,
    "defoliants": 4,
    "defollet": 3,
    "defollets": 3,
    "defoor": 2,
    "deford": 2,
    "deford's": 2,
    "defore": 2,
    "deforest": 3,
    "deforestation": 5,
    "deforge": 2,
    "deform": 2,
    "deformation": 4,
    "deformed": 2,
    "deformities": 4,
    "deformity": 4,
    "deforrest": 3,
    "deforrest(1)": 3,
    "defrain": 2,
    "defrance": 2,
    "defrancesco": 4,
    "defrancisco": 4,
    "defranco": 3,
    "defrank": 2,
    "defrates": 3,
    "defraud": 2,
    "defrauded": 3,
    "defrauding": 3,
    "defray": 2,
    "defrays": 2,
    "defrees": 2,
    "defreese": 2,
    "defreitas": 3,
    "defries": 2,
    "defrost": 2,
    "defrosting": 3,
    "deft": 1,
    "defterios": 4,
    "deftly": 2,
    "defunct": 2,
    "defund": 2,
    "defunding": 3,
    "defusco": 3,
    "defuse": 2,
    "defused": 2,
    "defused(1)": 2,
    "defusing": 3,
    "defy": 2,
    "defying": 3,
    "degaetano": 5,
    "degan": 2,
    "degarmo": 3,
    "degas": 2,
    "degas(1)": 2,
    "degaulle": 2,
    "degaulle's": 2,
    "degen": 2,
    "degener": 3,
    "degeneracy": 5,
    "degenerate": 4,
    "degenerate(1)": 4,
    "degenerated": 5,
    "degenerates": 4,
    "degenerating": 5,
    "degeneration": 5,
    "degenerative": 5,
    "degeneres": 4,
    "degeneres(1)": 4,
    "degenhardt": 3,
    "degenhart": 3,
    "degennaro": 4,
    "degeorge": 3,
    "deger": 2,
    "degiacomo": 4,
    "degidio": 4,
    "degirolamo": 5,
    "degler": 2,
    "degnan": 2,
    "degner": 2,
    "degood": 2,
    "degraaf": 2,
    "degrace": 3,
    "degrace(1)": 2,
    "degradable": 4,
    "degradation": 4,
    "degradations": 4,
    "degrade": 2,
    "degraded": 3,
    "degraded(1)": 3,
    "degrades": 2,
    "degrading": 3,
    "degraff": 2,
    "degraffenreid": 4,
    "degrand": 2,
    "degrange": 2,
    "degrasse": 3,
    "degrave": 3,
    "degraw": 2,
    "degray": 2,
    "degrazia": 4,
    "degree": 2,
    "degreed": 2,
    "degrees": 2,
    "degregorio": 5,
    "degregory": 4,
    "degroat": 2,
    "degroff": 2,
    "degroot": 2,
    "degroote": 2,
    "deguerin": 3,
    "deguire": 3,
    "degussa": 3,
    "degutare": 4,
    "degutare's": 4,
    "deguzman": 3,
    "dehaan": 2,
    "dehaas": 2,
    "deharbe": 3,
    "dehart": 2,
    "dehaven": 3,
    "dehecq": 2,
    "dehere": 3,
    "deherrera": 4,
    "dehler": 2,
    "dehm": 1,
    "dehmer": 2,
    "dehn": 1,
    "dehne": 1,
    "dehner": 2,
    "dehnert": 2,
    "dehoff": 2,
    "dehoyos": 3,
    "dehumanization": 6,
    "dehumanize": 4,
    "dehumanized": 4,
    "dehumanizing": 5,
    "dehumidified": 5,
    "dehumidifier": 6,
    "dehumidifies": 5,
    "dehumidify": 5,
    "dehydrate": 3,
    "dehydrated": 4,
    "dehydration": 4,
    "deibel": 2,
    "deibert": 2,
    "deibler": 3,
    "deibler(1)": 2,
    "deichert": 2,
    "deidre": 2,
    "deidre's": 2,
    "deification": 5,
    "deified": 3,
    "deify": 3,
    "deighan": 2,
    "deighton": 2,
    "deign": 1,
    "deignan": 2,
    "deigned": 1,
    "deigning": 2,
    "deigns": 1,
    "deihl": 1,
    "deike": 1,
    "deikel": 2,
    "deily": 2,
    "deines": 1,
    "deininger": 3,
    "deinstitutionalization": 9,
    "deinstitutionalize": 7,
    "deion": 2,
    "deion(1)": 2,
    "deirdre": 2,
    "deis": 1,
    "deis(1)": 2,
    "deisher": 3,
    "deism": 3,
    "deiss": 1,
    "deist": 2,
    "deitch": 1,
    "deiter": 2,
    "deiters": 2,
    "deities": 3,
    "deitrich": 2,
    "deitrick": 2,
    "deitsch": 1,
    "deity": 3,
    "deitz": 1,
    "deja": 2,
    "deja(1)": 2,
    "dejager": 3,
    "dejarnett": 3,
    "dejarnette": 3,
    "dejean": 2,
    "deject": 2,
    "dejected": 3,
    "dejesus": 3,
    "dejohn": 2,
    "dejong": 2,
    "dejonge": 2,
    "dejongh": 2,
    "dejoseph": 3,
    "dejoy": 2,
    "dejulio": 4,
    "dekalb": 2,
    "dekay": 2,
    "dekeyser": 3,
    "dekker": 2,
    "dekle": 2,
    "deklerk": 2,
    "deklerk's": 2,
    "dekom": 2,
    "dekoning": 3,
    "dekroon": 2,
    "dekuyper": 3,
    "del": 1,
    "del-campos": 3,
    "dela": 2,
    "delacerda": 4,
    "delacroix": 3,
    "delacroix(1)": 3,
    "delacruz": 3,
    "delacy": 3,
    "delafield": 3,
    "delafuente": 4,
    "delagarza": 4,
    "delage": 2,
    "delagrange": 3,
    "delahanty": 4,
    "delahoussaye": 4,
    "delahunt": 3,
    "delahunty": 4,
    "delaine": 2,
    "delair": 2,
    "delamar": 3,
    "delamater": 4,
    "delancey": 3,
    "delancy": 3,
    "deland": 2,
    "delane": 2,
    "delaney": 3,
    "delange": 2,
    "delano": 3,
    "delano(1)": 3,
    "delanoy": 3,
    "delany": 3,
    "delao": 2,
    "delap": 2,
    "delapaz": 3,
    "delapena": 4,
    "delapp": 2,
    "delara": 3,
    "delariva": 4,
    "delarosa": 4,
    "delashmit": 3,
    "delashmutt": 3,
    "delaski": 3,
    "delatorre": 4,
    "delatte": 2,
    "delauder": 3,
    "delaughter": 3,
    "delaune": 2,
    "delaura": 3,
    "delaurel": 3,
    "delaurentiis": 4,
    "delaurentis": 4,
    "delauter": 3,
    "delaval": 3,
    "delavan": 3,
    "delavega": 4,
    "delaware": 3,
    "delaware's": 3,
    "delawarian": 5,
    "delawarians": 5,
    "delawder": 3,
    "delay": 2,
    "delayed": 2,
    "delaying": 3,
    "delays": 2,
    "delbarco": 3,
    "delbarco's": 3,
    "delbene": 3,
    "delbert": 2,
    "delbianco": 4,
    "delbosque": 2,
    "delbridge": 2,
    "delbuono": 3,
    "delcambre": 3,
    "delcamp": 2,
    "delcampo": 3,
    "delcarlo": 3,
    "delcastillo": 4,
    "delchamps": 2,
    "delcine": 3,
    "delco": 2,
    "delconte": 3,
    "delcor": 2,
    "delduca": 3,
    "delebarre": 3,
    "delectable": 4,
    "delee": 2,
    "deleeuw": 3,
    "delegate": 3,
    "delegate(1)": 3,
    "delegate's": 3,
    "delegated": 4,
    "delegates": 3,
    "delegates(1)": 3,
    "delegates'": 3,
    "delegating": 4,
    "delegation": 4,
    "delegation's": 4,
    "delegations": 4,
    "delehanty": 4,
    "delellis": 3,
    "delellis(1)": 3,
    "deleo": 3,
    "deleon": 3,
    "deleonardis": 5,
    "delete": 2,
    "deleted": 3,
    "deleterious": 5,
    "deletes": 2,
    "deleting": 3,
    "deletion": 3,
    "deletions": 3,
    "delfavero": 4,
    "delfin": 2,
    "delfina": 3,
    "delfine": 3,
    "delfino": 3,
    "delfosse": 2,
    "delfs": 1,
    "delft": 1,
    "delftware": 2,
    "delgadillo": 4,
    "delgadio": 3,
    "delgadio(1)": 3,
    "delgado": 3,
    "delgaudio": 4,
    "delgiorno": 3,
    "delgiudice": 3,
    "delgrande": 3,
    "delgreco": 3,
    "delgrosso": 3,
    "delguercio": 4,
    "delguidice": 3,
    "delhaize": 2,
    "delhi": 2,
    "delhi's": 2,
    "deli": 2,
    "delia": 2,
    "delial": 3,
    "delial(1)": 3,
    "deliberate": 4,
    "deliberate(1)": 4,
    "deliberate(2)": 3,
    "deliberated": 5,
    "deliberately": 5,
    "deliberately(1)": 4,
    "deliberates": 4,
    "deliberates(1)": 3,
    "deliberating": 5,
    "deliberation": 5,
    "deliberations": 5,
    "deliberative": 5,
    "deliberative(1)": 4,
    "delicacies": 4,
    "delicacy": 4,
    "delicacy(1)": 4,
    "delicate": 3,
    "delicately": 4,
    "delicatessen": 5,
    "delicatessens": 5,
    "delich": 2,
    "delicia": 3,
    "delicious": 3,
    "deliciously": 4,
    "delight": 2,
    "delighted": 3,
    "delighted(1)": 3,
    "delightful": 3,
    "delightfully": 4,
    "delighting": 3,
    "delights": 2,
    "delila": 3,
    "delilah": 3,
    "delilah(1)": 3,
    "delillo": 3,
    "delima": 3,
    "deline": 3,
    "delineate": 4,
    "delineated": 5,
    "delineates": 4,
    "delineating": 5,
    "delineation": 5,
    "delinquencies": 4,
    "delinquency": 4,
    "delinquent": 3,
    "delinquents": 3,
    "delio": 3,
    "delirious": 4,
    "delirium": 4,
    "delisa": 3,
    "delise": 2,
    "delisi": 3,
    "delisio": 4,
    "delisle": 2,
    "delist": 2,
    "delisted": 3,
    "delisting": 3,
    "deliver": 3,
    "deliverable": 5,
    "deliverable(1)": 4,
    "deliverance": 4,
    "deliverance(1)": 3,
    "delivered": 3,
    "deliverer": 4,
    "deliverers": 4,
    "deliveries": 4,
    "deliveries(1)": 3,
    "delivering": 4,
    "delivers": 3,
    "delivery": 4,
    "delk": 1,
    "delker": 2,
    "dell": 1,
    "dell'aquila": 4,
    "dell's": 1,
    "della": 2,
    "dellaert": 2,
    "dellaert(1)": 2,
    "dellapenna": 4,
    "dellaquila": 4,
    "dellarocco": 4,
    "dellavalle": 4,
    "dellavecchia": 5,
    "delle": 1,
    "deller": 2,
    "delleri": 3,
    "delligatti": 4,
    "delling": 2,
    "dellinger": 3,
    "dellis": 2,
    "dellolio": 4,
    "dellums": 2,
    "delma": 2,
    "delman": 2,
    "delmar": 2,
    "delmarva": 3,
    "delmas": 2,
    "delmastro": 3,
    "delmed": 2,
    "delmed's": 2,
    "delmer": 2,
    "delmonaco": 4,
    "delmonico": 4,
    "delmont": 2,
    "delmonte": 3,
    "delmore": 2,
    "delnegro": 3,
    "delnero": 3,
    "delo": 2,
    "deloach": 2,
    "deloatch": 2,
    "deloitte": 2,
    "deloney": 3,
    "delong": 2,
    "delora": 3,
    "delore": 2,
    "delore(1)": 3,
    "delore's": 2,
    "delore's(1)": 3,
    "delorean": 4,
    "delorenzo": 4,
    "delorenzo(1)": 4,
    "delores": 3,
    "delorey": 3,
    "deloria": 4,
    "deloris": 3,
    "delorme": 3,
    "delors": 2,
    "delosh": 2,
    "delosreyes": 4,
    "delosreyes(1)": 3,
    "delosreyes(2)": 4,
    "delossantos": 4,
    "delouis": 3,
    "delouse": 2,
    "deloused": 2,
    "delozier": 4,
    "delp": 1,
    "delph": 1,
    "delphax": 2,
    "delphi": 2,
    "delphia": 3,
    "delphian": 2,
    "delphic": 2,
    "delphina": 3,
    "delphine": 3,
    "delpino": 3,
    "delpizzo": 3,
    "delponte": 3,
    "delpozo": 3,
    "delprete": 2,
    "delpriore": 4,
    "delray": 2,
    "delre": 1,
    "delreal": 2,
    "delrina": 3,
    "delrina's": 3,
    "delrio": 3,
    "delrosario": 5,
    "delrossi": 3,
    "delrosso": 3,
    "delsanto": 3,
    "delsignore": 4,
    "delta": 2,
    "delta's": 2,
    "deltacorp": 3,
    "deltadromeus": 4,
    "deltaic": 3,
    "deltak": 2,
    "deltas": 2,
    "deltec": 2,
    "deltona": 3,
    "deltona's": 3,
    "deltoro": 3,
    "deluca": 3,
    "delucas": 3,
    "delucca": 3,
    "delucchi": 3,
    "deluccia": 3,
    "delucia": 3,
    "delude": 2,
    "deluded": 3,
    "deludes": 2,
    "deluding": 3,
    "deluge": 2,
    "deluged": 2,
    "deluise": 3,
    "deluna": 3,
    "delusion": 3,
    "delusional": 4,
    "delusions": 3,
    "deluxe": 2,
    "delvalle": 3,
    "delvalle's": 3,
    "delve": 1,
    "delvecchio": 4,
    "delved": 1,
    "delves": 1,
    "delvin": 2,
    "delving": 2,
    "delwin": 2,
    "delwip": 2,
    "delwyn": 2,
    "delzell": 2,
    "delzer": 2,
    "demaggio": 4,
    "demagogic": 4,
    "demagogue": 3,
    "demagoguery": 5,
    "demagogues": 3,
    "demagoguing": 4,
    "demagogy": 4,
    "demain": 2,
    "demaio": 4,
    "demaio(1)": 3,
    "deman": 2,
    "demand": 2,
    "demanded": 3,
    "demanded(1)": 3,
    "demanding": 3,
    "demandingly": 4,
    "demands": 2,
    "demar": 2,
    "demarais": 3,
    "demaray": 3,
    "demarcation": 4,
    "demarcations": 4,
    "demarche": 2,
    "demarche(1)": 2,
    "demarchi": 3,
    "demarco": 3,
    "demarcus": 3,
    "demaree": 3,
    "demarest": 3,
    "demaria": 4,
    "demarinis": 4,
    "demarino": 4,
    "demario": 4,
    "demaris": 3,
    "demark": 2,
    "demars": 2,
    "demarsh": 2,
    "demartin": 3,
    "demartini": 4,
    "demartino": 4,
    "demary": 3,
    "demarzo": 3,
    "demas": 2,
    "demasi": 3,
    "demasters": 3,
    "dematteis": 3,
    "dematteo": 4,
    "demattia": 3,
    "demauro": 3,
    "demay": 2,
    "demayo": 3,
    "dembeck": 2,
    "dembinski": 3,
    "dembowski": 3,
    "dembski": 2,
    "demby": 2,
    "demchak": 2,
    "demean": 2,
    "demeaned": 2,
    "demeaning": 3,
    "demeanor": 3,
    "demeanors": 3,
    "demeans": 2,
    "demel": 2,
    "demello": 3,
    "demelo": 3,
    "dement": 2,
    "demented": 3,
    "dementia": 4,
    "demeo": 3,
    "demeree": 3,
    "demerger": 3,
    "demerist": 3,
    "demerist(1)": 3,
    "demerist's": 3,
    "demerit": 3,
    "demerits": 3,
    "demeritt": 3,
    "demers": 2,
    "demerse": 2,
    "demery": 3,
    "demeter": 3,
    "demetre": 3,
    "demetria": 4,
    "demetrio": 4,
    "demetriou": 4,
    "demetrius": 4,
    "demeyer": 3,
    "demi": 2,
    "demi's": 2,
    "demicco": 3,
    "demichael": 3,
    "demichele": 3,
    "demick": 2,
    "demilio": 4,
    "demilitarization": 7,
    "demilitarize": 5,
    "demilitarized": 5,
    "demilitarizes": 6,
    "demilitarizing": 6,
    "demille": 3,
    "demille(1)": 2,
    "demilo": 3,
    "demilo(1)": 3,
    "deming": 2,
    "demint": 2,
    "demirag": 3,
    "demirel": 3,
    "demirjian": 4,
    "demisch": 2,
    "demise": 2,
    "demish": 2,
    "demjanjuk": 3,
    "demjanjuk(1)": 3,
    "demjanjuk's": 3,
    "demjanjuk's(1)": 3,
    "demko": 2,
    "demler": 2,
    "demma": 2,
    "demme": 1,
    "demmer": 2,
    "demming": 2,
    "demmon": 2,
    "demmons": 2,
    "demo": 2,
    "demobilization": 6,
    "demobilization(1)": 6,
    "demobilize": 4,
    "demobilized": 4,
    "demobilizes": 5,
    "demobilizing": 5,
    "democracies": 4,
    "democracy": 4,
    "democracy's": 4,
    "democrat": 3,
    "democrat's": 3,
    "democratic": 4,
    "democratic's": 4,
    "democratica": 5,
    "democratically": 5,
    "democratics": 4,
    "democratization": 6,
    "democratize": 4,
    "democratized": 4,
    "democratizes": 5,
    "democratizing": 5,
    "democrats": 3,
    "democrats'": 3,
    "demodulate": 4,
    "demodulated": 5,
    "demodulates": 4,
    "demodulation": 5,
    "demographer": 4,
    "demographers": 4,
    "demographic": 4,
    "demographically": 5,
    "demographics": 4,
    "demography": 4,
    "demolish": 3,
    "demolished": 3,
    "demolishes": 4,
    "demolishing": 4,
    "demolition": 4,
    "demon": 2,
    "demond": 2,
    "demonic": 3,
    "demonization": 5,
    "demonize": 3,
    "demonized": 3,
    "demonizer": 4,
    "demonizez": 4,
    "demonizing": 4,
    "demons": 2,
    "demonstrable": 4,
    "demonstrably": 4,
    "demonstrate": 3,
    "demonstrated": 4,
    "demonstrated(1)": 4,
    "demonstrates": 3,
    "demonstrating": 4,
    "demonstration": 4,
    "demonstrations": 4,
    "demonstrative": 4,
    "demonstrator": 4,
    "demonstrators": 4,
    "demont": 2,
    "demonte": 3,
    "demopoulos": 4,
    "demoralization": 6,
    "demoralize": 4,
    "demoralized": 4,
    "demoralizing": 5,
    "demore": 2,
    "demorest": 3,
    "demory": 3,
    "demory's": 3,
    "demos": 2,
    "demoss": 2,
    "demote": 2,
    "demoted": 3,
    "demotion": 3,
    "demotions": 3,
    "demott": 2,
    "demoulin": 3,
    "demov": 2,
    "dempewolf": 3,
    "demps": 1,
    "dempsey": 2,
    "dempster": 2,
    "demski": 2,
    "demsky": 2,
    "demur": 2,
    "demure": 2,
    "demurely": 3,
    "demuro": 3,
    "demurred": 2,
    "demurring": 3,
    "demurs": 2,
    "demus": 2,
    "demuth": 2,
    "demyan": 2,
    "demystify": 4,
    "den": 1,
    "dena": 2,
    "denapoli": 4,
    "denard": 2,
    "denardo": 3,
    "denarii": 3,
    "denarius": 4,
    "denaro": 3,
    "denatale": 4,
    "denationalization": 7,
    "denationalizations": 7,
    "denationalize": 5,
    "denationalized": 5,
    "denationalizing": 6,
    "denature": 3,
    "denatured": 3,
    "denault": 2,
    "denbo": 2,
    "denboer": 3,
    "denbow": 2,
    "denby": 2,
    "denden": 2,
    "dendinger": 3,
    "dendritic": 3,
    "dendrochronology": 6,
    "dendy": 2,
    "deneau": 2,
    "deneault": 2,
    "deneen": 2,
    "deneke": 2,
    "deneke(1)": 3,
    "denenberg": 3,
    "denes": 1,
    "deneuve": 2,
    "deneuve(1)": 2,
    "deneve": 2,
    "deng": 1,
    "deng's": 1,
    "dengel": 2,
    "dengler": 3,
    "dengler(1)": 2,
    "dengue": 1,
    "denham": 2,
    "denhart": 2,
    "denhartog": 3,
    "denherder": 3,
    "denholm": 2,
    "deniability": 6,
    "denial": 3,
    "denials": 3,
    "denice": 2,
    "denicola": 4,
    "denied": 2,
    "denies": 2,
    "denigrate": 3,
    "denigrated": 4,
    "denigrating": 4,
    "denigris": 3,
    "denike": 2,
    "denim": 2,
    "denio": 3,
    "deniro": 3,
    "deniro's": 3,
    "denis": 2,
    "denise": 2,
    "denison": 3,
    "denison's": 3,
    "deniston": 3,
    "deniz": 2,
    "denizen": 3,
    "denizens": 3,
    "denk": 1,
    "denker": 2,
    "denki": 2,
    "denkins": 2,
    "denko": 2,
    "denktas": 2,
    "denlea": 2,
    "denley": 2,
    "denlinger": 4,
    "denlinger(1)": 3,
    "denlinger(2)": 3,
    "denman": 2,
    "denmark": 2,
    "denmark's": 2,
    "denmon": 2,
    "denn": 1,
    "dennard": 2,
    "denne": 1,
    "dennehy": 3,
    "dennen": 2,
    "denner": 2,
    "dennett": 2,
    "denney": 2,
    "dennie": 2,
    "dennin": 2,
    "denning": 2,
    "denninger": 3,
    "dennington": 3,
    "dennis": 2,
    "dennison": 3,
    "denniston": 3,
    "denno": 2,
    "denny": 2,
    "denny's": 2,
    "deno": 2,
    "denoble": 3,
    "denominate": 4,
    "denominated": 5,
    "denomination": 5,
    "denomination's": 5,
    "denominational": 6,
    "denominations": 5,
    "denominator": 5,
    "denomme": 2,
    "denosse": 2,
    "denosse(1)": 3,
    "denote": 2,
    "denoted": 3,
    "denotes": 2,
    "denoting": 3,
    "denouement": 3,
    "denounce": 2,
    "denounced": 2,
    "denounces": 3,
    "denouncing": 3,
    "denoyer": 3,
    "dens": 1,
    "densch": 1,
    "dense": 1,
    "densely": 2,
    "denser": 2,
    "densest": 2,
    "denshin": 2,
    "densities": 3,
    "densitometer": 5,
    "density": 3,
    "density(1)": 3,
    "densley": 2,
    "denslow": 2,
    "densmore": 2,
    "densmore(1)": 2,
    "denson": 2,
    "dent": 1,
    "dental": 2,
    "dental(1)": 2,
    "dentals": 2,
    "dentals(1)": 2,
    "dente": 1,
    "dented": 2,
    "dentin": 2,
    "dentine": 2,
    "denting": 2,
    "dentino": 3,
    "dentist": 2,
    "dentist(1)": 2,
    "dentist(2)": 2,
    "dentist's": 2,
    "dentistry": 3,
    "dentistry(1)": 3,
    "dentists": 2,
    "dentists(1)": 2,
    "dentists'": 2,
    "dentists'(1)": 2,
    "dentition": 3,
    "dentler": 2,
    "denton": 2,
    "dentremont": 3,
    "dents": 1,
    "dentsu": 2,
    "dentton": 2,
    "denture": 2,
    "dentures": 2,
    "dentzer": 2,
    "denucci": 3,
    "denuclearization": 7,
    "denuclearized": 5,
    "denuclearized(1)": 5,
    "denude": 2,
    "denuded": 3,
    "denuding": 3,
    "denunciation": 5,
    "denunciations": 5,
    "denunzio": 4,
    "denver": 2,
    "denver's": 2,
    "denwa": 2,
    "deny": 2,
    "denying": 3,
    "denys": 2,
    "denyse": 2,
    "denz": 1,
    "denzel": 2,
    "denzer": 2,
    "denzil": 2,
    "denzler": 2,
    "deo": 2,
    "deodorant": 4,
    "deodorants": 4,
    "deoliveira": 5,
    "deon": 2,
    "deontological": 6,
    "deontology": 5,
    "deorbit": 3,
    "deoxyribonucleic": 8,
    "dep": 1,
    "depace": 3,
    "depalma": 3,
    "depalma's": 3,
    "depalo": 3,
    "depaola": 3,
    "depaoli": 3,
    "depaolis": 3,
    "depaolo": 3,
    "depardieu": 3,
    "depardieu(1)": 3,
    "depart": 2,
    "departed": 3,
    "departed(1)": 3,
    "departing": 3,
    "department": 3,
    "department's": 3,
    "departmental": 4,
    "departmental(1)": 4,
    "departmentalize": 5,
    "departmentalize(1)": 5,
    "departmentalized": 5,
    "departmentalized(1)": 5,
    "departmentalizes": 6,
    "departmentalizing": 6,
    "departments": 3,
    "departs": 2,
    "departure": 3,
    "departures": 3,
    "depascale": 4,
    "depasquale": 4,
    "depass": 2,
    "depaul": 2,
    "depaula": 3,
    "depaulo": 3,
    "depauw": 2,
    "depaz": 2,
    "depend": 2,
    "dependability": 6,
    "dependable": 4,
    "depended": 3,
    "depended(1)": 3,
    "dependence": 3,
    "dependencies": 4,
    "dependency": 4,
    "dependent": 3,
    "dependents": 3,
    "depending": 3,
    "depends": 2,
    "depersonalize": 5,
    "depersonalize(1)": 4,
    "depetro": 3,
    "depew": 2,
    "dephillips": 3,
    "dephillips(1)": 3,
    "depict": 2,
    "depicted": 3,
    "depicted(1)": 3,
    "depicting": 3,
    "depiction": 3,
    "depictions": 3,
    "depicts": 2,
    "depicts(1)": 2,
    "depietro": 3,
    "depilatory": 5,
    "depina": 3,
    "depinto": 3,
    "deplete": 2,
    "depleted": 3,
    "depleter": 3,
    "depleters": 3,
    "depletes": 2,
    "depleting": 3,
    "depletion": 3,
    "deplorable": 4,
    "deplore": 2,
    "deplored": 2,
    "deplores": 2,
    "deploring": 3,
    "deploy": 2,
    "deployable": 4,
    "deployed": 2,
    "deploying": 3,
    "deployment": 3,
    "deployments": 3,
    "deploys": 2,
    "depner": 2,
    "depo": 2,
    "depo(1)": 2,
    "depolo": 3,
    "deponte": 3,
    "depopulate": 4,
    "depopulation": 5,
    "depopulation(1)": 5,
    "deport": 2,
    "deportation": 4,
    "deportations": 4,
    "deported": 3,
    "deportee": 3,
    "deportees": 3,
    "deporting": 3,
    "deportment": 3,
    "depose": 2,
    "deposed": 2,
    "deposi": 3,
    "deposit": 3,
    "deposit(1)": 3,
    "depositary": 5,
    "depositary(1)": 5,
    "deposited": 4,
    "deposited(1)": 4,
    "depositing": 4,
    "deposition": 4,
    "depositional": 5,
    "depositions": 4,
    "depositor": 4,
    "depositor's": 4,
    "depositors": 4,
    "depositors'": 4,
    "depository": 5,
    "deposits": 3,
    "deposits(1)": 3,
    "depot": 2,
    "depot's": 2,
    "depots": 2,
    "depoy": 2,
    "depp": 1,
    "deppe": 1,
    "deppen": 2,
    "depravation": 4,
    "deprave": 2,
    "depraved": 2,
    "depravity": 4,
    "deprecate": 3,
    "deprecated": 4,
    "deprecates": 3,
    "deprecating": 4,
    "depreciable": 4,
    "depreciate": 4,
    "depreciated": 5,
    "depreciates": 4,
    "depreciating": 5,
    "depreciation": 5,
    "depreciations": 5,
    "depredation": 4,
    "depredations": 4,
    "depree": 2,
    "deprenyl": 3,
    "depress": 2,
    "depressant": 3,
    "depressants": 3,
    "depressed": 2,
    "depresses": 3,
    "depresses(1)": 3,
    "depressing": 3,
    "depressingly": 4,
    "depression": 3,
    "depressions": 3,
    "depressive": 3,
    "depressurize": 4,
    "depressurized": 4,
    "depressurizes": 5,
    "depressurizing": 5,
    "deprey": 2,
    "deprez": 2,
    "depriest": 4,
    "depriest(1)": 2,
    "deprivation": 4,
    "deprivations": 4,
    "deprive": 2,
    "deprived": 2,
    "deprives": 2,
    "depriving": 3,
    "deprogram": 3,
    "deprogramming": 4,
    "depth": 1,
    "depths": 1,
    "deptula": 3,
    "depue": 2,
    "deputies": 3,
    "deputies(1)": 3,
    "deputize": 3,
    "deputized": 3,
    "deputy": 3,
    "deputy(1)": 3,
    "depuy": 2,
    "dequeker": 3,
    "der": 1,
    "derail": 2,
    "derailed": 2,
    "derailing": 3,
    "derailment": 3,
    "derailments": 3,
    "derails": 2,
    "deramo": 3,
    "deramus": 3,
    "derange": 2,
    "deranged": 2,
    "derasmo": 3,
    "derby": 2,
    "derbyshire": 3,
    "derchin": 2,
    "dercole": 3,
    "derden": 2,
    "derderian": 4,
    "derecktor": 3,
    "deregt": 2,
    "deregulate": 4,
    "deregulated": 5,
    "deregulating": 5,
    "deregulation": 5,
    "deregulator": 5,
    "deregulators": 5,
    "deregulatory": 6,
    "derek": 2,
    "derelict": 3,
    "dereliction": 4,
    "derelicts": 3,
    "derelicts(1)": 3,
    "deremer": 3,
    "deren": 2,
    "derenzo": 3,
    "derflinger": 4,
    "derflinger(1)": 3,
    "derham": 2,
    "derhammer": 3,
    "derick": 2,
    "derickson": 3,
    "derida": 3,
    "deridder": 3,
    "deride": 2,
    "derided": 3,
    "derides": 2,
    "deriding": 3,
    "derienzo": 3,
    "derik": 2,
    "dering": 2,
    "deringer": 3,
    "derington": 3,
    "derise": 2,
    "derision": 3,
    "derisive": 3,
    "derisive(1)": 3,
    "derisively": 4,
    "derisively(1)": 4,
    "deriso": 3,
    "derivation": 4,
    "derivative": 4,
    "derivative(1)": 4,
    "derivatives": 4,
    "derive": 2,
    "derived": 2,
    "derives": 2,
    "derives(1)": 2,
    "deriving": 3,
    "derk": 1,
    "derks": 1,
    "derksen": 2,
    "derleth": 2,
    "derma": 2,
    "dermagraph": 3,
    "dermal": 2,
    "derman": 2,
    "dermatological": 6,
    "dermatologist": 5,
    "dermatologists": 5,
    "dermatology": 5,
    "dermer": 2,
    "dermis": 2,
    "dermody": 3,
    "dermot": 2,
    "dermott": 2,
    "dern": 1,
    "derner": 2,
    "derobertis": 4,
    "derocco": 3,
    "deroche": 2,
    "derocher": 3,
    "derogatory": 5,
    "deroo": 2,
    "deroos": 2,
    "derosa": 3,
    "derose": 2,
    "derosia": 4,
    "derosier": 4,
    "derossett": 3,
    "derouen": 2,
    "derouin": 2,
    "derousse": 2,
    "deroy": 2,
    "derr": 1,
    "derrick": 2,
    "derrickson": 3,
    "derrico": 3,
    "derrig": 2,
    "derring": 2,
    "derringer": 3,
    "derrington": 3,
    "derrow": 2,
    "derry": 2,
    "derryberry": 4,
    "dersch": 1,
    "dershem": 2,
    "dershowitz": 3,
    "dershowitz's": 4,
    "derstine": 2,
    "derthick": 2,
    "derubeis": 3,
    "deruiter": 3,
    "deruko": 3,
    "derus": 2,
    "derusha": 3,
    "deruyter": 3,
    "dervin": 2,
    "dervish": 2,
    "dervishich": 3,
    "derward": 2,
    "derwin": 2,
    "derwinski": 3,
    "dery": 2,
    "deryck": 2,
    "deryle": 2,
    "des": 1,
    "des(1)": 1,
    "desai": 3,
    "desalination": 5,
    "desalinization": 6,
    "desalvo": 3,
    "desanctis": 3,
    "desanti": 3,
    "desantiago": 5,
    "desantis": 3,
    "desanto": 3,
    "desantos": 3,
    "desaulniers": 4,
    "desautel": 3,
    "desautels": 3,
    "descarpentries": 4,
    "descartes": 2,
    "descartes's": 2,
    "descend": 2,
    "descendant": 3,
    "descendants": 3,
    "descendants(1)": 3,
    "descended": 3,
    "descended(1)": 3,
    "descendent": 3,
    "descendents": 3,
    "descending": 3,
    "descends": 2,
    "descent": 2,
    "descents": 2,
    "descenza": 3,
    "desch": 1,
    "deschaine": 2,
    "deschamps": 2,
    "deschene": 2,
    "deschenes": 2,
    "deschepper": 3,
    "deschler": 3,
    "deschler(1)": 2,
    "deschner": 2,
    "descoteaux": 3,
    "describable": 4,
    "describe": 2,
    "described": 2,
    "describes": 2,
    "describing": 3,
    "description": 3,
    "descriptions": 3,
    "descriptive": 3,
    "desecrate": 3,
    "desecrate(1)": 3,
    "desecrated": 4,
    "desecrated(1)": 4,
    "desecrates": 3,
    "desecrates(1)": 3,
    "desecration": 4,
    "desecration(1)": 4,
    "desecrations": 4,
    "desecrations(1)": 4,
    "desegregate": 4,
    "desegregated": 5,
    "desegregation": 5,
    "desegregation(1)": 5,
    "desena": 3,
    "desensitize": 4,
    "desensitized": 4,
    "desensitizing": 5,
    "deseret": 3,
    "deseret(1)": 3,
    "desert": 2,
    "desert(1)": 2,
    "deserted": 3,
    "deserter": 3,
    "deserters": 3,
    "deserting": 3,
    "desertion": 3,
    "desertions": 3,
    "deserts": 2,
    "deserts(1)": 2,
    "deserve": 2,
    "deserved": 2,
    "deservedly": 4,
    "deserves": 2,
    "deserving": 3,
    "desha": 2,
    "deshaies": 2,
    "deshane": 2,
    "deshaw": 2,
    "deshazer": 3,
    "deshazo": 3,
    "deshields": 2,
    "deshler": 2,
    "deshon": 2,
    "deshong": 2,
    "deshotel": 3,
    "deshotels": 3,
    "desi": 2,
    "desiccate": 3,
    "desiccated": 4,
    "desiccates": 3,
    "desiccation": 4,
    "desiderata": 5,
    "desiderio": 5,
    "design": 2,
    "designate": 3,
    "designate(1)": 3,
    "designated": 4,
    "designates": 3,
    "designating": 4,
    "designation": 4,
    "designation(1)": 4,
    "designations": 4,
    "designcraft": 3,
    "designed": 2,
    "designee": 3,
    "designees": 3,
    "designer": 3,
    "designer's": 3,
    "designers": 3,
    "designers'": 3,
    "designing": 3,
    "designor": 3,
    "designs": 2,
    "desilets": 3,
    "desillers": 3,
    "desilva": 3,
    "desimone": 4,
    "desio": 3,
    "desir": 2,
    "desirability": 6,
    "desirable": 4,
    "desirable(1)": 5,
    "desire": 3,
    "desired": 3,
    "desiree": 3,
    "desires": 3,
    "desiring": 4,
    "desirous": 3,
    "desist": 2,
    "desist(1)": 2,
    "desisto": 3,
    "desjardin": 3,
    "desjardins": 3,
    "desjarlais": 3,
    "desk": 1,
    "deskin": 2,
    "deskins": 2,
    "deskjet": 2,
    "deskpro": 2,
    "desks": 1,
    "desktop": 2,
    "desktops": 2,
    "deslatte": 2,
    "deslauriers": 4,
    "desma": 2,
    "desma(1)": 2,
    "desman": 2,
    "desmarais": 3,
    "desmet": 2,
    "desmids": 2,
    "desmith": 2,
    "desmona": 3,
    "desmond": 2,
    "desmoplasia": 5,
    "desmoplastic": 4,
    "desnoyers": 3,
    "desolate": 3,
    "desolate(1)": 3,
    "desolate(2)": 3,
    "desolation": 4,
    "desormeaux": 3,
    "desoto": 3,
    "desousa": 3,
    "desousa(1)": 3,
    "desouza": 3,
    "despain": 2,
    "despair": 2,
    "despaired": 2,
    "despairing": 3,
    "despairs": 2,
    "desper": 2,
    "desperado": 4,
    "desperadoes": 4,
    "desperate": 2,
    "desperate(1)": 3,
    "desperately": 4,
    "desperately(1)": 3,
    "desperation": 4,
    "desperation(1)": 4,
    "despicable": 4,
    "despina's": 3,
    "despise": 2,
    "despised": 2,
    "despises": 3,
    "despising": 3,
    "despite": 2,
    "despondency": 4,
    "despondent": 3,
    "desposito": 4,
    "despot": 2,
    "despotic": 3,
    "despotism": 4,
    "despres": 2,
    "desrochers": 3,
    "desroches": 3,
    "desrosier": 4,
    "desrosiers": 4,
    "desrosiers(1)": 3,
    "dessauer": 2,
    "dessauer(1)": 2,
    "desselle": 2,
    "dessent": 2,
    "dessert": 2,
    "desserts": 2,
    "dest": 1,
    "destabilization": 6,
    "destabilize": 4,
    "destabilized": 4,
    "destabilizing": 5,
    "destec": 2,
    "destefanis": 4,
    "destefano": 4,
    "destin": 2,
    "destination": 4,
    "destination(1)": 4,
    "destinations": 4,
    "destined": 2,
    "destinies": 3,
    "destiny": 3,
    "destitute": 3,
    "destitution": 4,
    "destroy": 2,
    "destroyed": 2,
    "destroyer": 3,
    "destroyers": 3,
    "destroying": 3,
    "destroys": 2,
    "destruct": 2,
    "destructable": 4,
    "destructed": 3,
    "destructing": 3,
    "destruction": 3,
    "destructive": 3,
    "destructiveness": 4,
    "destructs": 2,
    "desultory": 4,
    "des_moines": 2,
    "des_moines(1)": 2,
    "detach": 2,
    "detach(1)": 2,
    "detachable": 4,
    "detachable(1)": 4,
    "detached": 2,
    "detached(1)": 2,
    "detaches": 3,
    "detaches(1)": 3,
    "detachment": 3,
    "detachment(1)": 3,
    "detail": 2,
    "detail(1)": 2,
    "detailed": 2,
    "detailee": 3,
    "detailer": 3,
    "detailing": 3,
    "details": 2,
    "details(1)": 2,
    "detain": 2,
    "detained": 2,
    "detainee": 3,
    "detainees": 3,
    "detaining": 3,
    "detamore": 3,
    "detar": 2,
    "detar(1)": 2,
    "detect": 2,
    "detectable": 4,
    "detected": 3,
    "detected(1)": 3,
    "detecting": 3,
    "detection": 3,
    "detective": 3,
    "detective's": 3,
    "detectives": 3,
    "detector": 3,
    "detectors": 3,
    "detects": 2,
    "detemple": 3,
    "detente": 2,
    "detention": 3,
    "detentions": 3,
    "deter": 2,
    "deterding": 3,
    "detergent": 3,
    "detergents": 3,
    "deteriorate": 5,
    "deteriorated": 6,
    "deteriorates": 5,
    "deteriorating": 6,
    "deterioration": 6,
    "determan": 3,
    "determent": 3,
    "determinable": 5,
    "determinant": 4,
    "determinants": 4,
    "determinate": 4,
    "determination": 5,
    "determination's": 5,
    "determinations": 5,
    "determinative": 5,
    "determine": 3,
    "determine(1)": 3,
    "determined": 3,
    "determinedly": 5,
    "determinedly(1)": 4,
    "determines": 3,
    "determines(1)": 3,
    "determining": 4,
    "determinism": 5,
    "determinist": 4,
    "deterministic": 5,
    "deterred": 2,
    "deterrence": 3,
    "deterrent": 3,
    "deterrents": 3,
    "deterring": 3,
    "deters": 2,
    "detert": 2,
    "detest": 2,
    "detest(1)": 2,
    "detested": 3,
    "detested(1)": 3,
    "detherage": 3,
    "dethlefs": 2,
    "dethlefsen": 3,
    "dethloff": 2,
    "dethomas": 3,
    "dethomas(1)": 3,
    "dethrone": 2,
    "dethrone(1)": 2,
    "dethroned": 2,
    "dethroned(1)": 2,
    "detienne": 3,
    "detjen": 2,
    "detlefsen": 3,
    "detloff": 2,
    "detmer": 2,
    "detonate": 3,
    "detonated": 4,
    "detonating": 4,
    "detonation": 4,
    "detonations": 4,
    "detonator": 4,
    "detonators": 4,
    "detore": 3,
    "detour": 2,
    "detour(1)": 2,
    "detoured": 2,
    "detours": 2,
    "detours(1)": 2,
    "detox": 2,
    "detoxication": 5,
    "detoxification": 6,
    "detoxify": 4,
    "detract": 2,
    "detracted": 3,
    "detracting": 3,
    "detractor": 3,
    "detractors": 3,
    "detractors(1)": 3,
    "detracts": 2,
    "detrich": 2,
    "detrick": 2,
    "detriment": 3,
    "detrimental": 4,
    "detrimental(1)": 4,
    "detritus": 3,
    "detritus(1)": 3,
    "detro": 2,
    "detroit": 2,
    "detroit(1)": 2,
    "detroit's": 2,
    "detroit's(1)": 2,
    "detroiters": 3,
    "detroiters(1)": 3,
    "detter": 2,
    "dettinger": 3,
    "dettling": 2,
    "dettloff": 2,
    "dettman": 2,
    "dettmann": 2,
    "dettmer": 2,
    "dettore": 3,
    "detty": 2,
    "deturk": 2,
    "detweiler": 3,
    "detwiler": 3,
    "detzel": 2,
    "deubel": 2,
    "deubler": 3,
    "deubler(1)": 2,
    "deuce": 1,
    "deuel": 2,
    "deukmejian": 4,
    "deukmejian's": 4,
    "deupree": 2,
    "deuschle": 2,
    "deuser": 2,
    "deuss": 1,
    "deutch": 1,
    "deuterium": 4,
    "deuterons": 3,
    "deutsch": 1,
    "deutsche": 1,
    "deutschemark": 2,
    "deutschemark's": 2,
    "deutschemarks": 2,
    "deutscher": 2,
    "deutschland": 2,
    "deutschman": 2,
    "deutz": 1,
    "deux": 1,
    "dev": 1,
    "deva": 2,
    "deval": 2,
    "deval's": 2,
    "devall": 2,
    "devalle": 2,
    "devalle(1)": 3,
    "devaluate": 4,
    "devaluated": 5,
    "devaluation": 5,
    "devaluation(1)": 5,
    "devaluations": 5,
    "devalue": 3,
    "devalued": 3,
    "devalued(1)": 3,
    "devaluing": 4,
    "devan": 2,
    "devane": 2,
    "devaney": 3,
    "devany": 3,
    "devastate": 3,
    "devastated": 4,
    "devastated(1)": 4,
    "devastating": 4,
    "devastatingly": 5,
    "devastation": 4,
    "devaughn": 2,
    "devaul": 2,
    "devault": 2,
    "devaux": 2,
    "deveau": 2,
    "deveaux": 2,
    "develcon": 3,
    "develle": 2,
    "develop": 3,
    "developable": 5,
    "developed": 3,
    "developer": 4,
    "developer's": 4,
    "developers": 4,
    "developers'": 4,
    "developing": 4,
    "development": 4,
    "development's": 4,
    "developmental": 5,
    "developmental(1)": 5,
    "developmentally": 6,
    "developmentally(1)": 6,
    "developments": 4,
    "develops": 3,
    "devendorf": 3,
    "deveney": 3,
    "devenney": 3,
    "devenny": 3,
    "devenport": 3,
    "devens": 2,
    "deveny": 3,
    "dever": 2,
    "devera": 3,
    "deveraux": 3,
    "devere": 3,
    "devereaux": 3,
    "deverell": 3,
    "devereux": 3,
    "deveroy": 3,
    "devers": 2,
    "devey": 2,
    "deviance": 3,
    "deviancy": 4,
    "deviancy(1)": 3,
    "deviant": 3,
    "deviants": 3,
    "deviate": 3,
    "deviated": 4,
    "deviates": 3,
    "deviating": 4,
    "deviation": 4,
    "deviations": 4,
    "device": 2,
    "device's": 3,
    "devices": 3,
    "devices(1)": 3,
    "devil": 2,
    "devil's": 2,
    "devilbiss": 3,
    "devilbiss(1)": 3,
    "devilish": 2,
    "devilishly": 4,
    "devilishly(1)": 3,
    "deville": 2,
    "deville's": 2,
    "devillier": 3,
    "devillier's": 3,
    "devils": 2,
    "devils'": 2,
    "devilwood": 3,
    "devin": 2,
    "devincent": 3,
    "devincentis": 4,
    "devincenzi": 4,
    "devincenzo": 4,
    "devinci": 3,
    "devinci's": 3,
    "devine": 2,
    "deviney": 3,
    "devinney": 3,
    "devino": 3,
    "devins": 2,
    "devious": 3,
    "devise": 2,
    "devise(1)": 2,
    "devised": 2,
    "devises": 3,
    "devising": 3,
    "devita": 3,
    "devito": 3,
    "devitt": 2,
    "devivo": 3,
    "devlin": 2,
    "devoe": 2,
    "devoid": 2,
    "devol": 2,
    "devolder": 3,
    "devoll": 2,
    "devolution": 4,
    "devolve": 2,
    "devolved": 2,
    "devon": 2,
    "devona": 3,
    "devonian": 4,
    "devonshire": 3,
    "devor": 2,
    "devore": 2,
    "devos": 2,
    "devoss": 2,
    "devote": 2,
    "devoted": 3,
    "devoted(1)": 3,
    "devotee": 3,
    "devotees": 3,
    "devotes": 2,
    "devoting": 3,
    "devotion": 3,
    "devotional": 4,
    "devoto": 3,
    "devour": 3,
    "devoured": 3,
    "devouring": 4,
    "devours": 3,
    "devout": 2,
    "devoutly": 3,
    "devoy": 2,
    "devries": 2,
    "devry": 2,
    "dew": 1,
    "dewaard": 2,
    "dewaele": 2,
    "dewald": 2,
    "dewall": 2,
    "dewalt": 2,
    "dewan": 2,
    "dewar": 2,
    "dewar's": 2,
    "deware": 2,
    "dewarr": 2,
    "dewart": 2,
    "dewayne": 2,
    "dewayne(1)": 2,
    "dewberry": 3,
    "dewbre": 2,
    "dewclaw": 2,
    "deweerd": 2,
    "dewees": 2,
    "deweese": 2,
    "deweiss": 2,
    "dewell": 2,
    "dewey": 2,
    "dewey's": 2,
    "dewhirst": 2,
    "dewhurst": 2,
    "dewilde": 2,
    "dewine": 2,
    "dewing": 2,
    "dewinter": 3,
    "dewinter(1)": 3,
    "dewire": 2,
    "dewit": 2,
    "dewitt": 2,
    "dewitte": 2,
    "dewitz": 2,
    "dewolf": 2,
    "dewolfe": 2,
    "dewoody": 3,
    "dews": 1,
    "dewulf": 2,
    "dewy": 2,
    "dex": 1,
    "dexfenfluramine": 5,
    "dexheimer": 3,
    "dexter": 2,
    "dexter's": 2,
    "dexterity": 4,
    "dexterity(1)": 4,
    "dextra": 2,
    "dextran": 2,
    "dextrathoraphan": 5,
    "dextrin": 2,
    "dextro": 2,
    "dextrose": 2,
    "dextrous": 2,
    "dey": 1,
    "deyo": 2,
    "deyoe": 2,
    "deyoung": 2,
    "deyton": 2,
    "deyton(1)": 2,
    "dezarn": 2,
    "dezeeuw": 3,
    "dezern": 2,
    "deziel": 2,
    "dfw": 5,
    "dfw(1)": 5,
    "dhabi": 2,
    "dhaharan": 2,
    "dhahran": 2,
    "dhaka": 2,
    "dhaka(1)": 2,
    "dhaka(2)": 2,
    "dhali": 2,
    "dhananjay": 3,
    "dharma": 2,
    "dhein": 1,
    "dhia": 2,
    "dhillon": 2,
    "dhiraj": 2,
    "dhlakama": 4,
    "dhole": 1,
    "dhondt": 1,
    "dhows": 1,
    "di": 1,
    "di(1)": 1,
    "di's": 1,
    "dia": 2,
    "diab": 2,
    "diabase": 3,
    "diabasic": 4,
    "diabetes": 4,
    "diabetic": 4,
    "diabetics": 4,
    "diablo": 3,
    "diablo(1)": 3,
    "diabolical": 5,
    "diaconate": 4,
    "diacritic": 4,
    "diacritical": 5,
    "diadem": 3,
    "diagnose": 3,
    "diagnosed": 3,
    "diagnoses": 4,
    "diagnosing": 4,
    "diagnosis": 4,
    "diagnostek": 4,
    "diagnostic": 4,
    "diagnostics": 4,
    "diagonal": 4,
    "diagonally": 5,
    "diagonals": 4,
    "diagram": 3,
    "diagraming": 4,
    "diagrammatic": 5,
    "diagrammed": 3,
    "diagrams": 3,
    "diahann": 2,
    "dial": 2,
    "dial(1)": 1,
    "dial's": 2,
    "dial's(1)": 1,
    "dialect": 3,
    "dialectic": 4,
    "dialectical": 5,
    "dialects": 3,
    "dialed": 2,
    "dialing": 3,
    "dialing(1)": 2,
    "dialog": 3,
    "dialogue": 3,
    "dialogues": 3,
    "dials": 2,
    "dials(1)": 1,
    "dialtone": 3,
    "dialtone(1)": 2,
    "dialysis": 4,
    "dialysis(1)": 4,
    "diamagnetic": 5,
    "diamagnetism": 6,
    "diamandis": 4,
    "diamandis(1)": 4,
    "diamant": 3,
    "diamanta": 4,
    "diamante": 4,
    "diameter": 4,
    "diametrically": 6,
    "diametrically(1)": 5,
    "diamond": 2,
    "diamond's": 2,
    "diamonds": 2,
    "diamono": 4,
    "dian": 2,
    "diana": 3,
    "diana's": 3,
    "diane": 2,
    "diane's": 2,
    "dianetics": 4,
    "diangelo": 4,
    "dianna": 3,
    "dianne": 2,
    "diantha": 3,
    "dianthe": 3,
    "dianthia": 4,
    "diantonio": 5,
    "diaper": 2,
    "diapering": 3,
    "diapers": 3,
    "diapers(1)": 2,
    "diaphanous": 4,
    "diaphonia": 5,
    "diaphragm": 3,
    "diapsid": 3,
    "diaries": 3,
    "diaries(1)": 2,
    "diario": 4,
    "diarrhea": 4,
    "diarrheas": 4,
    "diarrhoea": 4,
    "diary": 3,
    "diary(1)": 2,
    "dias": 2,
    "diasa": 3,
    "diasa's": 3,
    "diasonic": 4,
    "diasonics": 4,
    "diaspora": 4,
    "diastase": 3,
    "diastole": 4,
    "diastolic": 4,
    "diastrophism": 5,
    "diathermy": 4,
    "diatomic": 4,
    "diatoms": 3,
    "diatonic": 4,
    "diatribe": 3,
    "diatribes": 3,
    "diaz": 2,
    "diaz(1)": 2,
    "diaz-calderon": 5,
    "diazo": 3,
    "dibacco": 3,
    "dibari": 3,
    "dibartolo": 4,
    "dibartolomeo": 6,
    "dibattista": 4,
    "dibb": 1,
    "dibbern": 2,
    "dibble": 2,
    "dibbled": 2,
    "dibella": 3,
    "dibello": 3,
    "dibenedetto": 5,
    "dibernardo": 4,
    "dibert": 2,
    "dibiase": 4,
    "dibiasio": 5,
    "diblasi": 3,
    "diblasio": 4,
    "dible": 2,
    "diboll": 2,
    "dibona": 3,
    "dibrell": 2,
    "dibs": 1,
    "dibuono": 3,
    "dic": 1,
    "dicamba": 3,
    "dicamillo": 4,
    "dicaprio": 4,
    "dicarlo": 3,
    "dice": 1,
    "dicecco": 3,
    "diced": 1,
    "dicello": 3,
    "dicenso": 3,
    "dicenzo": 3,
    "diceon": 3,
    "dicesare": 4,
    "dicey": 2,
    "dichiara": 4,
    "dichotomy": 4,
    "dichroic": 3,
    "dichromate": 3,
    "dichromate(1)": 3,
    "dichter": 2,
    "dicicco": 3,
    "dicier": 3,
    "dicing": 2,
    "dicioccio": 4,
    "dick": 1,
    "dick's": 1,
    "dickard": 2,
    "dickason": 3,
    "dicke": 1,
    "dickel": 2,
    "dicken": 2,
    "dickens": 2,
    "dickens'": 2,
    "dickens's": 3,
    "dickensheets": 3,
    "dickensian": 4,
    "dickenson": 3,
    "dicker": 2,
    "dickered": 2,
    "dickering": 3,
    "dickerman": 3,
    "dickerson": 3,
    "dickert": 2,
    "dickes": 1,
    "dickeson": 3,
    "dickey": 2,
    "dickey's": 2,
    "dickhaut": 2,
    "dickie": 2,
    "dickinson": 3,
    "dickison": 3,
    "dickler": 2,
    "dickman": 2,
    "dickmann": 2,
    "dickmeyer": 3,
    "dicks": 1,
    "dickson": 2,
    "dickstein": 2,
    "dickstein(1)": 2,
    "dickstein's": 2,
    "dickstein's(1)": 2,
    "dicky": 2,
    "diclemente": 4,
    "dicocco": 3,
    "dicola": 3,
    "dicomed": 3,
    "dicomed(1)": 2,
    "dicostanzo": 4,
    "dicots": 2,
    "dicta": 2,
    "dictaphone": 3,
    "dictate": 2,
    "dictate(1)": 2,
    "dictated": 3,
    "dictated(1)": 3,
    "dictated(2)": 3,
    "dictates": 2,
    "dictates(1)": 2,
    "dictating": 3,
    "dictation": 3,
    "dictator": 3,
    "dictator(1)": 3,
    "dictatorial": 5,
    "dictators": 3,
    "dictators(1)": 3,
    "dictatorship": 4,
    "dictatorships": 4,
    "diction": 2,
    "dictionaries": 4,
    "dictionary": 4,
    "dictum": 2,
    "dicus": 2,
    "did": 1,
    "did(1)": 1,
    "didactic": 3,
    "diddley": 2,
    "diddy": 2,
    "didemeyer": 4,
    "didemeyer's": 4,
    "dideoxycytidine": 7,
    "didi": 2,
    "didier": 3,
    "didinium": 4,
    "didion": 3,
    "didion's": 3,
    "didn't": 2,
    "didn't(1)": 1,
    "didn't(2)": 2,
    "didn't(3)": 1,
    "dido": 2,
    "didomenico": 5,
    "didonato": 4,
    "didonna": 3,
    "die": 1,
    "diebel": 2,
    "diebold": 2,
    "dieck": 1,
    "dieckman": 2,
    "dieckmann": 2,
    "died": 1,
    "diede": 1,
    "diederich": 3,
    "diedre": 2,
    "diedrich": 2,
    "diedrick": 2,
    "diefenbach": 3,
    "diefenderfer": 4,
    "diefendorf": 3,
    "dieffenbach": 3,
    "diegans": 2,
    "diegel": 2,
    "diego": 3,
    "diego's": 3,
    "diego-garcia": 6,
    "dieguez": 2,
    "diehard": 2,
    "diehards": 2,
    "diehl": 1,
    "diehm": 1,
    "diekman": 2,
    "diekmann": 2,
    "diel": 1,
    "diem": 1,
    "diemer": 2,
    "diemert": 2,
    "diener": 2,
    "dienes": 2,
    "dienst": 1,
    "diep": 1,
    "dier": 2,
    "diercks": 1,
    "dieringer": 3,
    "dierker": 2,
    "dierkes": 1,
    "dierking": 3,
    "dierks": 1,
    "dierolf": 2,
    "diers": 2,
    "diery": 2,
    "dies": 1,
    "diesel": 2,
    "diesel(1)": 2,
    "diesels": 2,
    "dieses": 2,
    "diesing": 2,
    "diet": 2,
    "diet's": 2,
    "dietary": 4,
    "dietel": 2,
    "dieter": 2,
    "dieterich": 3,
    "dieterle": 3,
    "dieters": 3,
    "dietetic": 4,
    "dietician": 4,
    "dieting": 3,
    "dietitian": 4,
    "dietitian's": 4,
    "dietitians": 4,
    "dietl": 2,
    "dietrich": 2,
    "dietrick": 2,
    "diets": 2,
    "dietsch": 1,
    "dietsche": 1,
    "dietz": 1,
    "dietze": 2,
    "dietzel": 2,
    "dietzen": 2,
    "dietzler": 2,
    "dietzman": 2,
    "dievler": 2,
    "diez": 2,
    "dif": 1,
    "difabio": 4,
    "difabio(1)": 4,
    "difalco": 3,
    "difazio": 4,
    "difelice": 3,
    "difelice(1)": 3,
    "difelice(2)": 4,
    "diff": 1,
    "diffee": 2,
    "diffenderfer": 4,
    "differ": 2,
    "differed": 2,
    "difference": 3,
    "difference(1)": 2,
    "differences": 4,
    "differences(1)": 3,
    "different": 3,
    "different(1)": 2,
    "differential": 4,
    "differential(1)": 4,
    "differentials": 4,
    "differentials(1)": 4,
    "differentiate": 5,
    "differentiate(1)": 5,
    "differentiated": 6,
    "differentiated(1)": 6,
    "differentiates": 5,
    "differentiates(1)": 5,
    "differentiating": 6,
    "differentiating(1)": 6,
    "differentiation": 6,
    "differentiation(1)": 6,
    "differently": 3,
    "differently(1)": 4,
    "differing": 3,
    "differing(1)": 2,
    "differs": 2,
    "difficult": 3,
    "difficulties": 4,
    "difficulties(1)": 4,
    "difficultly": 4,
    "difficulty": 4,
    "difficulty(1)": 4,
    "diffid": 2,
    "diffin": 2,
    "diffley": 2,
    "diffract": 2,
    "diffraction": 3,
    "diffuse": 2,
    "diffuse(1)": 2,
    "diffused": 2,
    "diffuses": 3,
    "diffusing": 3,
    "diffusion": 3,
    "difilippo": 4,
    "difiore": 4,
    "difiore(1)": 3,
    "difm": 1,
    "difm(1)": 4,
    "difonzo": 3,
    "difrancesco": 4,
    "difranco": 3,
    "dig": 1,
    "digaetano": 4,
    "digalakis": 4,
    "digangi": 3,
    "digate": 2,
    "digby": 2,
    "digennaro": 4,
    "digenova": 4,
    "digeronimo": 5,
    "digest": 2,
    "digest(1)": 2,
    "digest's": 2,
    "digested": 3,
    "digester": 3,
    "digestible": 4,
    "digesting": 3,
    "digesting(1)": 3,
    "digestion": 3,
    "digestive": 3,
    "digests": 2,
    "digests(1)": 2,
    "digests(2)": 2,
    "digests(3)": 2,
    "digga": 2,
    "digger": 2,
    "diggers": 2,
    "digges": 1,
    "digging": 2,
    "diggins": 2,
    "diggle": 2,
    "diggs": 1,
    "digiacomo": 4,
    "digicon": 3,
    "digidyne": 3,
    "digilio": 4,
    "digioia": 3,
    "digiorgio": 4,
    "digiovanna": 4,
    "digiovanni": 4,
    "digirolamo": 5,
    "digit": 2,
    "digit(1)": 2,
    "digital": 3,
    "digital(1)": 3,
    "digital's": 3,
    "digital's(1)": 3,
    "digitalis": 4,
    "digitally": 4,
    "digitech": 3,
    "digiti": 3,
    "digiti(1)": 3,
    "digitize": 3,
    "digitized": 3,
    "digitizing": 4,
    "digits": 2,
    "digits(1)": 2,
    "digiulio": 4,
    "digiuseppe": 4,
    "digman": 2,
    "dignan": 2,
    "dignified": 3,
    "dignify": 3,
    "dignitaries": 4,
    "dignitary": 4,
    "dignity": 3,
    "digrazia": 4,
    "digregorio": 5,
    "digress": 2,
    "digressed": 2,
    "digresses": 3,
    "digressing": 3,
    "digression": 3,
    "digressions": 3,
    "digs": 1,
    "diguglielmo": 5,
    "diianni": 3,
    "diiorio": 4,
    "dijker": 2,
    "dijon": 2,
    "dijon(1)": 2,
    "dike": 1,
    "dikeman": 2,
    "dikes": 1,
    "dilapidate": 4,
    "dilapidated": 5,
    "dilatation": 4,
    "dilate": 2,
    "dilated": 3,
    "dilation": 3,
    "dilatory": 4,
    "dilaura": 3,
    "dilauro": 3,
    "dilbeck": 2,
    "dilbert": 2,
    "dilday": 2,
    "dildine": 3,
    "dildy": 2,
    "dilella": 3,
    "dilello": 3,
    "dilemma": 3,
    "dilemmas": 3,
    "dilenschneider": 4,
    "dileo": 3,
    "dileonardo": 5,
    "diles": 1,
    "dilford": 2,
    "dilford's": 2,
    "dilg": 1,
    "dilger": 2,
    "diliberto": 4,
    "diligence": 3,
    "diligence(1)": 3,
    "diligent": 3,
    "diligently": 4,
    "dilip": 2,
    "dilithium": 4,
    "dilks": 1,
    "dill": 1,
    "dillahunt": 3,
    "dillahunty": 4,
    "dillan": 2,
    "dillard": 2,
    "dillard(1)": 2,
    "dillard(2)": 2,
    "dillard's": 2,
    "dillard's(1)": 2,
    "dillard's(2)": 2,
    "dille": 1,
    "dillehay": 3,
    "dillen": 2,
    "dillenbeck": 3,
    "dillenburg": 3,
    "diller": 2,
    "diller's": 2,
    "dilletante": 3,
    "dilletantes": 3,
    "dilley": 2,
    "dillie": 2,
    "dillin": 2,
    "dilling": 2,
    "dillinger": 3,
    "dillingham": 3,
    "dillion": 2,
    "dillman": 2,
    "dillmore": 2,
    "dillon": 2,
    "dillon's": 2,
    "dillow": 2,
    "dills": 1,
    "dillworth": 2,
    "dilly": 2,
    "dillydally": 4,
    "dilmore": 2,
    "dilophosaurus": 5,
    "dilorenzo": 4,
    "diloreto": 4,
    "dilorio": 4,
    "dils": 1,
    "dilsaver": 3,
    "dilson": 2,
    "diltiazem": 4,
    "dilts": 1,
    "diltz": 1,
    "dilullo": 3,
    "dilute": 2,
    "dilute(1)": 2,
    "diluted": 3,
    "diluted(1)": 3,
    "dilutes": 2,
    "dilutes(1)": 2,
    "diluting": 3,
    "diluting(1)": 3,
    "dilution": 3,
    "dilution(1)": 3,
    "dilutive": 3,
    "dilutive(1)": 3,
    "diluzio": 4,
    "dilworth": 2,
    "dim": 1,
    "dimaggio": 4,
    "dimaio": 4,
    "dimambro": 3,
    "dimarco": 3,
    "dimare": 3,
    "dimaria": 4,
    "dimarino": 4,
    "dimario": 4,
    "dimartino": 4,
    "dimarzio": 4,
    "dimarzo": 3,
    "dimas": 2,
    "dimascio": 4,
    "dimasi": 3,
    "dimatteo": 4,
    "dimauro": 3,
    "dime": 1,
    "dime's": 1,
    "dimeglio": 4,
    "dimenaci": 4,
    "dimension": 3,
    "dimensional": 4,
    "dimensionality": 6,
    "dimensioned": 3,
    "dimensions": 3,
    "dimeo": 3,
    "dimer": 2,
    "dimercurio": 5,
    "dimes": 1,
    "dimetapp": 3,
    "dimiceli": 4,
    "dimichele": 4,
    "dimick": 2,
    "dimick's": 2,
    "diming": 2,
    "diminish": 3,
    "diminished": 3,
    "diminishes": 4,
    "diminishing": 4,
    "diminishment": 4,
    "dimino": 3,
    "diminution": 4,
    "diminutive": 4,
    "dimitri": 3,
    "dimitrios": 4,
    "dimitrius": 4,
    "dimitrius'": 4,
    "dimitrius's": 5,
    "dimitroff": 3,
    "dimitruk": 3,
    "dimly": 2,
    "dimmed": 1,
    "dimmer": 2,
    "dimmers": 2,
    "dimmick": 2,
    "dimming": 2,
    "dimmitt": 2,
    "dimock": 2,
    "dimon": 2,
    "dimona": 3,
    "dimond": 2,
    "dimorphic": 3,
    "dimorphism": 4,
    "dimperio": 4,
    "dimple": 2,
    "dimpled": 2,
    "dimples": 2,
    "dimry": 2,
    "dims": 1,
    "dimsdale": 2,
    "dimunition": 4,
    "dimuro": 3,
    "dimuzio": 4,
    "din": 1,
    "dina": 2,
    "dinah": 2,
    "dinan": 2,
    "dinapoli": 4,
    "dinar": 2,
    "dinardo": 3,
    "dinars": 2,
    "dinars(1)": 2,
    "dinatale": 4,
    "dinatale(1)": 4,
    "dinda": 2,
    "dine": 1,
    "dined": 1,
    "dineen": 2,
    "dinehart": 2,
    "diner": 2,
    "diners": 2,
    "dines": 1,
    "dinesh": 2,
    "ding": 1,
    "dingee": 2,
    "dingel": 2,
    "dingell": 2,
    "dingell's": 2,
    "dinger": 2,
    "dinges": 2,
    "dingess": 2,
    "dingham": 2,
    "dinghy": 2,
    "dingle": 2,
    "dingledine": 3,
    "dingler": 3,
    "dingler(1)": 2,
    "dingley": 2,
    "dingman": 2,
    "dingo": 2,
    "dings": 1,
    "dingus": 2,
    "dingwall": 2,
    "dingy": 2,
    "dinh": 1,
    "dini": 2,
    "dinicola": 4,
    "dining": 2,
    "dinino": 3,
    "dinius": 3,
    "dink": 1,
    "dinkel": 2,
    "dinkins": 2,
    "dinkins'": 2,
    "dinky": 2,
    "dinmukhamed": 4,
    "dinneen": 2,
    "dinner": 2,
    "dinners": 2,
    "dinnertime": 3,
    "dinnerware": 3,
    "dinning": 2,
    "dino": 2,
    "dinosaur": 3,
    "dinosaurs": 3,
    "dinoseb": 3,
    "dinoto": 3,
    "dinotopia": 5,
    "dinovo": 3,
    "dinsa": 2,
    "dinsdale": 2,
    "dinse": 1,
    "dinsmore": 2,
    "dint": 1,
    "dinunzio": 4,
    "dinwiddie": 3,
    "diocesan": 4,
    "diocese": 3,
    "diocese(1)": 3,
    "dioceses": 3,
    "dioceses(1)": 4,
    "diodati": 4,
    "diodato": 4,
    "diode": 2,
    "diodes": 2,
    "dioguardi": 4,
    "dion": 2,
    "dion(1)": 2,
    "diona": 3,
    "dione": 2,
    "dionisio": 5,
    "dionne": 2,
    "dionysian": 5,
    "dionysius": 5,
    "dior": 2,
    "diorio": 4,
    "diorite": 3,
    "dios": 2,
    "dios'": 2,
    "dios's": 3,
    "dioxide": 3,
    "dioxides": 3,
    "dioxin": 3,
    "dioxins": 3,
    "dip": 1,
    "dipalma": 3,
    "dipanjan": 3,
    "dipaola": 4,
    "dipaolo": 4,
    "dipasquale": 4,
    "dipasquale(1)": 4,
    "diperna": 3,
    "diphtheria": 4,
    "diphthong": 2,
    "dipiazza": 4,
    "dipiazza(1)": 4,
    "dipiero": 3,
    "dipierro": 3,
    "dipietro": 3,
    "dipinto": 3,
    "dipirro": 3,
    "diploma": 3,
    "diplomacy": 4,
    "diplomas": 3,
    "diplomat": 3,
    "diplomat's": 3,
    "diplomatic": 4,
    "diplomatically": 5,
    "diplomats": 3,
    "diplomats'": 3,
    "dipole": 2,
    "dipped": 1,
    "dippel": 2,
    "dipper": 2,
    "dippers": 2,
    "dipping": 2,
    "dipple": 2,
    "dippold": 2,
    "dippolito": 4,
    "dippy": 2,
    "diprima": 3,
    "dips": 1,
    "dipstick": 2,
    "dircks": 1,
    "dire": 1,
    "dire(1)": 2,
    "direct": 2,
    "direct(1)": 2,
    "direct(2)": 2,
    "directed": 3,
    "directed(1)": 3,
    "directed(2)": 3,
    "directed(3)": 3,
    "directing": 3,
    "directing(1)": 3,
    "directing(2)": 3,
    "directing(3)": 3,
    "direction": 3,
    "direction(1)": 3,
    "direction(2)": 3,
    "direction(3)": 3,
    "directional": 4,
    "directional(1)": 4,
    "directional(2)": 4,
    "directional(3)": 4,
    "directionless": 4,
    "directionless(1)": 4,
    "directionless(2)": 4,
    "directionless(3)": 4,
    "directions": 3,
    "directions(1)": 3,
    "directions(2)": 3,
    "directions(3)": 3,
    "directive": 3,
    "directive(1)": 3,
    "directive(2)": 3,
    "directive(3)": 3,
    "directives": 3,
    "directives(1)": 3,
    "directives(2)": 3,
    "directives(3)": 3,
    "directly": 3,
    "directly(1)": 3,
    "directly(2)": 3,
    "directly(3)": 3,
    "directness": 3,
    "directness(1)": 3,
    "directness(2)": 3,
    "directness(3)": 3,
    "director": 3,
    "director(1)": 3,
    "director(2)": 3,
    "director(3)": 3,
    "director's": 3,
    "director's(1)": 3,
    "director's(2)": 3,
    "director's(3)": 3,
    "directoral": 4,
    "directorate": 4,
    "directorate(1)": 4,
    "directorate(2)": 4,
    "directorate(3)": 4,
    "directorial": 5,
    "directorial(1)": 5,
    "directorial(2)": 5,
    "directorial(3)": 5,
    "directories": 4,
    "directories(1)": 4,
    "directories(2)": 4,
    "directories(3)": 4,
    "directors": 3,
    "directors(1)": 3,
    "directors(2)": 3,
    "directors(3)": 3,
    "directors'": 3,
    "directors'(1)": 3,
    "directors'(2)": 3,
    "directorship": 4,
    "directorship(1)": 4,
    "directorship(2)": 4,
    "directorship(3)": 4,
    "directorships": 4,
    "directorships(1)": 4,
    "directorships(2)": 4,
    "directorships(3)": 4,
    "directory": 4,
    "directory(1)": 4,
    "directory(2)": 4,
    "directory(3)": 4,
    "directs": 2,
    "directs(1)": 2,
    "directs(2)": 2,
    "directs(3)": 2,
    "directv": 4,
    "directv(1)": 4,
    "directv(2)": 4,
    "directv(3)": 4,
    "direnzo": 3,
    "direst": 2,
    "dirge": 1,
    "dirhams": 2,
    "dirickson": 3,
    "dirienzo": 3,
    "dirk": 1,
    "dirkes": 1,
    "dirks": 1,
    "dirkse": 1,
    "dirksen": 2,
    "dirlam": 2,
    "dirocco": 3,
    "dirosa": 3,
    "dirr": 1,
    "dirt": 1,
    "dirt's": 1,
    "dirtier": 3,
    "dirtiest": 3,
    "dirty": 2,
    "dirusso": 3,
    "dis": 1,
    "disa": 2,
    "disabatino": 5,
    "disabato": 4,
    "disabilities": 5,
    "disabilities(1)": 5,
    "disability": 5,
    "disability(1)": 5,
    "disable": 3,
    "disabled": 3,
    "disables": 3,
    "disabling": 4,
    "disabling(1)": 3,
    "disabuse": 3,
    "disabuse(1)": 3,
    "disabused": 3,
    "disabuses": 4,
    "disadvantage": 4,
    "disadvantage(1)": 4,
    "disadvantaged": 4,
    "disadvantaged(1)": 4,
    "disadvantageous": 5,
    "disadvantages": 5,
    "disadvantages(1)": 4,
    "disaffect": 3,
    "disaffected": 4,
    "disaffection": 4,
    "disagree": 3,
    "disagreeable": 5,
    "disagreed": 3,
    "disagreeing": 4,
    "disagreement": 4,
    "disagreements": 4,
    "disagrees": 3,
    "disallow": 3,
    "disallowance": 4,
    "disallowances": 5,
    "disallowed": 3,
    "disallowing": 4,
    "disalvo": 3,
    "disano": 3,
    "disanti": 3,
    "disantis": 3,
    "disanto": 3,
    "disappear": 3,
    "disappear(1)": 3,
    "disappearance": 4,
    "disappearance(1)": 4,
    "disappearances": 5,
    "disappearances(1)": 5,
    "disappeared": 3,
    "disappeared(1)": 3,
    "disappearing": 4,
    "disappearing(1)": 4,
    "disappears": 3,
    "disappears(1)": 3,
    "disappoint": 3,
    "disappointed": 4,
    "disappointed(1)": 4,
    "disappointing": 4,
    "disappointing(1)": 4,
    "disappointingly": 5,
    "disappointingly(1)": 5,
    "disappointment": 4,
    "disappointments": 4,
    "disappoints": 3,
    "disapproval": 4,
    "disapprove": 3,
    "disapproved": 3,
    "disapproves": 3,
    "disapproving": 4,
    "disarm": 2,
    "disarmament": 4,
    "disarmed": 2,
    "disarming": 3,
    "disarmingly": 4,
    "disarray": 3,
    "disarray(1)": 3,
    "disassemble": 4,
    "disassembled": 4,
    "disassociate": 5,
    "disassociate(1)": 5,
    "disassociated": 6,
    "disassociated(1)": 6,
    "disaster": 3,
    "disasters": 3,
    "disastrous": 3,
    "disastrously": 4,
    "disavow": 3,
    "disavowed": 3,
    "disavowing": 4,
    "disband": 2,
    "disbanded": 3,
    "disbanding": 3,
    "disbar": 2,
    "disbarment": 3,
    "disbarred": 2,
    "disbelief": 3,
    "disbelieve": 3,
    "disbelieving": 4,
    "disbro": 2,
    "disbrow": 2,
    "disburse": 2,
    "disbursed": 2,
    "disbursement": 3,
    "disbursements": 3,
    "disbursing": 3,
    "disc": 1,
    "discard": 2,
    "discarded": 3,
    "discarding": 3,
    "discards": 2,
    "discenza": 3,
    "discern": 2,
    "discernably": 4,
    "discerned": 2,
    "discernible": 4,
    "discerning": 3,
    "discernment": 3,
    "discerns": 2,
    "disch": 1,
    "discharge": 2,
    "discharge(1)": 2,
    "discharged": 2,
    "discharged(1)": 2,
    "discharges": 3,
    "discharges(1)": 3,
    "discharging": 3,
    "discharging(1)": 3,
    "discher": 2,
    "dischinger": 3,
    "disciple": 3,
    "disciples": 3,
    "disciplinarian": 6,
    "disciplinarians": 6,
    "disciplinary": 5,
    "discipline": 3,
    "disciplined": 3,
    "disciplines": 3,
    "disciplining": 4,
    "disclaim": 2,
    "disclaimed": 2,
    "disclaimer": 3,
    "disclaimers": 3,
    "disclaiming": 3,
    "disclaims": 2,
    "discland": 2,
    "disclose": 2,
    "disclosed": 2,
    "discloses": 3,
    "disclosing": 3,
    "disclosure": 3,
    "disclosures": 3,
    "disco": 2,
    "discography": 4,
    "discolor": 3,
    "discoloration": 5,
    "discolorations": 5,
    "discolored": 3,
    "discolors": 3,
    "discombobulate": 5,
    "discombobulated": 6,
    "discombobulates": 5,
    "discombobulating": 6,
    "discomfort": 3,
    "disconcert": 3,
    "disconcerting": 4,
    "disconnect": 3,
    "disconnected": 4,
    "disconnecting": 4,
    "disconnection": 4,
    "disconnects": 3,
    "discontent": 3,
    "discontented": 4,
    "discontentedly": 5,
    "discontentedness": 5,
    "discontents": 3,
    "discontinuance": 5,
    "discontinuation": 6,
    "discontinue": 4,
    "discontinued": 4,
    "discontinuing": 5,
    "discontinuity": 6,
    "discord": 2,
    "discordant": 3,
    "discos": 2,
    "discotheque": 3,
    "discotheques": 3,
    "discount": 2,
    "discount(1)": 2,
    "discountable": 4,
    "discounted": 3,
    "discounted(1)": 3,
    "discounter": 3,
    "discounters": 3,
    "discounters(1)": 3,
    "discounting": 3,
    "discounting(1)": 3,
    "discounts": 2,
    "discounts(1)": 2,
    "discourage": 3,
    "discouraged": 3,
    "discouraged(1)": 3,
    "discouragement": 4,
    "discourages": 4,
    "discouraging": 4,
    "discouraging(1)": 4,
    "discourse": 2,
    "discourses": 3,
    "discourses(1)": 3,
    "discover": 3,
    "discoverable": 5,
    "discoverable(1)": 4,
    "discovered": 3,
    "discoveries": 4,
    "discovering": 4,
    "discovers": 3,
    "discovery": 4,
    "discovery(1)": 3,
    "discovery(2)": 3,
    "discovery's": 4,
    "discovery's(1)": 3,
    "discredit": 3,
    "discredited": 4,
    "discrediting": 4,
    "discredits": 3,
    "discreet": 2,
    "discreetly": 3,
    "discrepancies": 4,
    "discrepancy": 4,
    "discrete": 2,
    "discretion": 3,
    "discretionary": 5,
    "discretions": 3,
    "discriminate": 4,
    "discriminated": 5,
    "discriminated(1)": 5,
    "discriminates": 4,
    "discriminating": 5,
    "discrimination": 5,
    "discriminative": 5,
    "discriminatory": 6,
    "discs": 1,
    "discursive": 3,
    "discus": 2,
    "discuss": 2,
    "discussed": 2,
    "discusses": 3,
    "discusses(1)": 3,
    "discussing": 3,
    "discussion": 3,
    "discussions": 3,
    "disdain": 2,
    "disdained": 2,
    "disdainful": 3,
    "disdaining": 3,
    "disdains": 2,
    "dise": 1,
    "dise(1)": 1,
    "disease": 2,
    "disease's": 3,
    "diseased": 2,
    "diseases": 3,
    "diseases(1)": 3,
    "disembark": 3,
    "disembarkation": 5,
    "disembodied": 4,
    "disembody": 4,
    "disenchanted": 4,
    "disenchanted(1)": 4,
    "disenchantment": 4,
    "disenfranchise": 4,
    "disenfranchised": 4,
    "disenfranchisement": 5,
    "disengage": 3,
    "disengaged": 3,
    "disengagement": 4,
    "disengaging": 4,
    "disentangle": 4,
    "disequilibrium": 6,
    "disestablishment": 5,
    "disfavor": 3,
    "disfavoring": 4,
    "disfigure": 3,
    "disfigured": 3,
    "disfigurement": 4,
    "disfiguring": 4,
    "disgorge": 2,
    "disgorged": 2,
    "disgorgement": 3,
    "disgrace": 2,
    "disgraced": 2,
    "disgraceful": 3,
    "disgruntled": 3,
    "disgruntled(1)": 3,
    "disgruntlement": 4,
    "disgruntling": 4,
    "disgruntling(1)": 3,
    "disguise": 2,
    "disguised": 2,
    "disguises": 3,
    "disguising": 3,
    "disgust": 2,
    "disgusted": 3,
    "disgusted(1)": 3,
    "disgusting": 3,
    "disgusts": 2,
    "dish": 1,
    "disharmony": 4,
    "disharoon": 3,
    "dishaw": 2,
    "disheartened": 3,
    "disheartening": 4,
    "disheartening(1)": 3,
    "dished": 1,
    "disher": 2,
    "dishes": 2,
    "dishes(1)": 2,
    "dishevel": 3,
    "disheveled": 3,
    "dishing": 2,
    "dishman": 2,
    "dishner": 2,
    "dishon": 2,
    "dishonest": 3,
    "dishonestly": 4,
    "dishonesty": 4,
    "dishong": 2,
    "dishonor": 3,
    "dishonorable": 5,
    "dishonored": 3,
    "dishwasher": 3,
    "dishwashers": 3,
    "dishwashing": 3,
    "disillusion": 4,
    "disillusioned": 4,
    "disillusioning": 5,
    "disillusionment": 5,
    "disilvestro": 4,
    "disimone": 4,
    "disincentive": 4,
    "disincentives": 4,
    "disinclination": 5,
    "disincline": 3,
    "disinclined": 3,
    "disinfect": 3,
    "disinfectant": 4,
    "disinfectants": 4,
    "disinfection": 4,
    "disinflate": 3,
    "disinflation": 4,
    "disinflationary": 6,
    "disinform": 3,
    "disinformation": 5,
    "disingenuous": 5,
    "disingenuousness": 6,
    "disintegrate": 4,
    "disintegrated": 5,
    "disintegrates": 4,
    "disintegrating": 5,
    "disintegration": 5,
    "disintegration(1)": 5,
    "disinterest": 4,
    "disinterested": 4,
    "disinterested(1)": 4,
    "disinvestment": 4,
    "disinvestment(1)": 4,
    "disinvite": 3,
    "disinvited": 4,
    "disjoint": 2,
    "disjointed": 3,
    "disk": 1,
    "diskette": 2,
    "diskettes": 2,
    "diskin": 2,
    "diskless": 2,
    "disks": 1,
    "dislike": 2,
    "disliked": 2,
    "dislikes": 2,
    "disliking": 3,
    "dislocate": 3,
    "dislocated": 4,
    "dislocation": 4,
    "dislocations": 4,
    "dislodge": 2,
    "dislodged": 2,
    "dislodging": 3,
    "disloyal": 3,
    "disloyalty": 4,
    "dismal": 2,
    "dismally": 3,
    "dismantle": 3,
    "dismantle(1)": 3,
    "dismantled": 3,
    "dismantled(1)": 3,
    "dismantlement": 4,
    "dismantles": 3,
    "dismantling": 4,
    "dismantling(1)": 4,
    "dismantling(2)": 3,
    "dismay": 2,
    "dismayed": 2,
    "dismaying": 3,
    "dismays": 2,
    "dismember": 3,
    "dismembered": 3,
    "dismembering": 4,
    "dismemberment": 4,
    "dismiss": 2,
    "dismissal": 3,
    "dismissals": 3,
    "dismissed": 2,
    "dismisses": 3,
    "dismissing": 3,
    "dismissive": 3,
    "dismore": 2,
    "dismuke": 2,
    "dismukes": 2,
    "dismutase": 3,
    "disney": 2,
    "disney's": 2,
    "disneyland": 3,
    "disneyworld": 3,
    "disobedience": 5,
    "disobedience(1)": 5,
    "disobedient": 5,
    "disobedient(1)": 5,
    "disobey": 3,
    "disobeyed": 3,
    "disobeying": 4,
    "dison": 2,
    "disorder": 3,
    "disordered": 3,
    "disorderly": 4,
    "disorders": 3,
    "disorganization": 6,
    "disorganize": 4,
    "disorganized": 4,
    "disorient": 4,
    "disorientation": 6,
    "disoriented": 5,
    "disorienting": 5,
    "disown": 2,
    "disowned": 2,
    "dispair": 2,
    "disparage": 3,
    "disparaged": 3,
    "disparages": 4,
    "disparaging": 4,
    "disparagingly": 5,
    "disparate": 3,
    "disparate(1)": 3,
    "disparities": 4,
    "disparity": 4,
    "dispassionate": 4,
    "dispassionately": 5,
    "dispatch": 2,
    "dispatched": 2,
    "dispatcher": 3,
    "dispatcher(1)": 3,
    "dispatcher's": 3,
    "dispatcher's(1)": 3,
    "dispatchers": 3,
    "dispatches": 3,
    "dispatching": 3,
    "dispel": 2,
    "dispell": 2,
    "dispelled": 2,
    "dispelling": 3,
    "dispels": 2,
    "dispensable": 4,
    "dispensary": 4,
    "dispensary(1)": 4,
    "dispensation": 4,
    "dispense": 2,
    "dispensed": 2,
    "dispenser": 3,
    "dispensers": 3,
    "dispenses": 3,
    "dispensing": 3,
    "dispenza": 3,
    "dispersal": 3,
    "dispersant": 3,
    "dispersants": 3,
    "disperse": 2,
    "dispersed": 2,
    "dispersing": 3,
    "dispersion": 3,
    "dispersive": 3,
    "dispirited": 4,
    "dispiriting": 4,
    "displace": 2,
    "displaced": 2,
    "displacement": 3,
    "displacements": 3,
    "displaces": 3,
    "displacing": 3,
    "display": 2,
    "displayed": 2,
    "displaying": 3,
    "displays": 2,
    "displaywrite": 3,
    "displease": 2,
    "displeased": 2,
    "displeasure": 3,
    "disposable": 4,
    "disposables": 4,
    "disposal": 3,
    "disposals": 3,
    "dispose": 2,
    "disposed": 2,
    "disposer": 3,
    "disposes": 3,
    "disposing": 3,
    "disposition": 4,
    "dispositions": 4,
    "dispositive": 4,
    "dispossess": 3,
    "dispossessed": 3,
    "disproportionate": 5,
    "disproportionately": 6,
    "disprove": 2,
    "disproved": 2,
    "disproven": 3,
    "disproves": 2,
    "disputable": 4,
    "disputation": 4,
    "dispute": 2,
    "disputed": 3,
    "disputed(1)": 3,
    "disputes": 2,
    "disputing": 3,
    "disqualification": 6,
    "disqualified": 4,
    "disqualifies": 4,
    "disqualify": 4,
    "disqualifying": 5,
    "disque": 1,
    "disquiet": 3,
    "disquieting": 4,
    "disraeli": 3,
    "disregard": 3,
    "disregarded": 4,
    "disregarding": 4,
    "disregards": 3,
    "disrepair": 3,
    "disreputable": 5,
    "disrepute": 3,
    "disrespect": 3,
    "disrespected": 4,
    "disrespectful": 4,
    "disrespecting": 4,
    "disrespects": 3,
    "disrupt": 2,
    "disrupted": 3,
    "disrupting": 3,
    "disruption": 3,
    "disruptions": 3,
    "disruptive": 3,
    "disrupts": 2,
    "diss": 1,
    "dissatisfaction": 5,
    "dissatisfied": 4,
    "dissatisfy": 4,
    "dissect": 2,
    "dissected": 3,
    "dissecting": 3,
    "dissection": 3,
    "dissection(1)": 3,
    "dissections": 3,
    "dissections(1)": 3,
    "dissects": 2,
    "dissects(1)": 2,
    "dissemble": 3,
    "dissembling": 3,
    "disseminate": 4,
    "disseminated": 5,
    "disseminates": 4,
    "disseminating": 5,
    "dissemination": 5,
    "dissension": 3,
    "dissent": 2,
    "dissented": 3,
    "dissented(1)": 3,
    "dissenter": 3,
    "dissenters": 3,
    "dissenters(1)": 3,
    "dissenting": 3,
    "dissenting(1)": 3,
    "dissents": 2,
    "dissertation": 4,
    "disservice": 3,
    "dissidence": 3,
    "dissident": 3,
    "dissidents": 3,
    "dissidents'": 3,
    "dissimilar": 4,
    "dissimilarity": 6,
    "dissing": 2,
    "dissinger": 3,
    "dissipate": 3,
    "dissipated": 4,
    "dissipates": 3,
    "dissipating": 4,
    "dissipation": 4,
    "dissipative": 4,
    "dissociate": 4,
    "dissociation": 5,
    "dissolution": 4,
    "dissolve": 2,
    "dissolved": 2,
    "dissolver": 3,
    "dissolvers": 3,
    "dissolves": 2,
    "dissolving": 3,
    "dissonance": 3,
    "dissonant": 3,
    "dissuade": 2,
    "dissuaded": 3,
    "dissymmetric": 4,
    "dissymmetry": 4,
    "distad": 2,
    "distal": 2,
    "distance": 2,
    "distanced": 2,
    "distances": 3,
    "distances(1)": 3,
    "distancing": 3,
    "distant": 2,
    "distasi": 3,
    "distasio": 4,
    "distaste": 2,
    "distasteful": 3,
    "distefano": 4,
    "distel": 2,
    "distemper": 3,
    "distend": 2,
    "distended": 3,
    "distil": 2,
    "distill": 2,
    "distillate": 3,
    "distillate(1)": 3,
    "distillates": 3,
    "distillation": 4,
    "distilled": 2,
    "distiller": 3,
    "distiller's": 3,
    "distilleries": 4,
    "distillers": 3,
    "distillers'": 3,
    "distillers's": 4,
    "distillery": 4,
    "distilling": 3,
    "distills": 2,
    "distinct": 2,
    "distinction": 3,
    "distinctions": 3,
    "distinctive": 3,
    "distinctively": 4,
    "distinctiveness": 4,
    "distinctly": 3,
    "distinguish": 3,
    "distinguishable": 5,
    "distinguished": 3,
    "distinguishes": 4,
    "distinguishing": 4,
    "distler": 2,
    "distort": 2,
    "distorted": 3,
    "distorted(1)": 3,
    "distorting": 3,
    "distortion": 3,
    "distortions": 3,
    "distorts": 2,
    "distract": 2,
    "distracted": 3,
    "distracted(1)": 3,
    "distracting": 3,
    "distraction": 3,
    "distractions": 3,
    "distracts": 2,
    "distraught": 2,
    "distress": 2,
    "distressed": 2,
    "distresses": 3,
    "distressing": 3,
    "distressingly": 4,
    "distribute": 3,
    "distributed": 4,
    "distributes": 3,
    "distributing": 4,
    "distribution": 4,
    "distributions": 4,
    "distributive": 4,
    "distributor": 4,
    "distributor's": 4,
    "distributors": 4,
    "distributors'": 4,
    "distributorship": 5,
    "distributorships": 5,
    "district": 2,
    "district's": 2,
    "districting": 3,
    "districts": 2,
    "distrigas": 3,
    "distron": 2,
    "distrust": 2,
    "distrusted": 3,
    "distrusted(1)": 3,
    "distrustful": 3,
    "distrusts": 2,
    "disturb": 2,
    "disturbance": 3,
    "disturbances": 4,
    "disturbances(1)": 4,
    "disturbed": 2,
    "disturbing": 3,
    "disturbingly": 4,
    "disturbs": 2,
    "disunion": 3,
    "disunity": 4,
    "disuse": 2,
    "ditch": 1,
    "ditched": 1,
    "ditches": 2,
    "ditches(1)": 2,
    "ditching": 2,
    "dith": 1,
    "dither": 2,
    "dithering": 3,
    "dithers": 2,
    "dithyramb": 3,
    "ditka": 2,
    "ditka's": 2,
    "ditlow": 2,
    "ditmars": 2,
    "ditmer": 2,
    "ditmore": 2,
    "ditomasso": 4,
    "ditommaso": 4,
    "ditsy": 2,
    "dittberner": 3,
    "dittemore": 3,
    "ditter": 2,
    "ditties": 2,
    "dittman": 2,
    "dittmann": 2,
    "dittmar": 2,
    "dittmer": 2,
    "ditto": 2,
    "dittohead": 3,
    "ditton": 2,
    "dittrich": 2,
    "dittus": 2,
    "ditty": 2,
    "ditullio": 4,
    "ditzel": 2,
    "ditzler": 2,
    "diuretic": 4,
    "diuretics": 4,
    "diurnal": 3,
    "diurnally": 4,
    "diva": 2,
    "divad": 2,
    "divalent": 3,
    "divall": 2,
    "divan": 2,
    "divas": 2,
    "dive": 1,
    "dived": 1,
    "divelbiss": 3,
    "diveley": 3,
    "dively": 2,
    "diven": 2,
    "divens": 2,
    "diver": 2,
    "diver's": 2,
    "diverge": 2,
    "diverged": 2,
    "divergence": 3,
    "divergence(1)": 3,
    "divergences": 4,
    "divergent": 3,
    "divergent(1)": 3,
    "diverges": 3,
    "diverging": 3,
    "divers": 2,
    "diverse": 2,
    "diverse(1)": 2,
    "diversicare": 4,
    "diversification": 6,
    "diversification(1)": 6,
    "diversifications": 6,
    "diversifications(1)": 6,
    "diversified": 4,
    "diversified(1)": 4,
    "diversify": 4,
    "diversify(1)": 4,
    "diversifying": 5,
    "diversifying(1)": 5,
    "diversion": 3,
    "diversion(1)": 3,
    "diversionary": 5,
    "diversionary(1)": 5,
    "diversions": 3,
    "diversions(1)": 3,
    "diversity": 4,
    "diversity(1)": 4,
    "diversity(2)": 4,
    "diversity(3)": 4,
    "divert": 2,
    "divert(1)": 2,
    "diverted": 3,
    "diverted(1)": 3,
    "diverticula": 5,
    "diverticulum": 5,
    "divertimento": 5,
    "diverting": 3,
    "diverting(1)": 3,
    "diverts": 2,
    "diverts(1)": 2,
    "dives": 1,
    "divest": 2,
    "divest(1)": 2,
    "divested": 3,
    "divesting": 3,
    "divestiture": 4,
    "divestiture(1)": 4,
    "divestitures": 4,
    "divestitures(1)": 4,
    "divestment": 3,
    "divestment(1)": 3,
    "divestment(2)": 3,
    "divestments": 3,
    "divestments(1)": 3,
    "divestments(2)": 3,
    "divests": 2,
    "divi": 2,
    "divide": 2,
    "divided": 3,
    "dividend": 3,
    "dividend's": 3,
    "dividends": 3,
    "divider": 3,
    "divides": 2,
    "dividing": 3,
    "divination": 4,
    "divincenzo": 4,
    "divine": 2,
    "divinely": 3,
    "diviney": 3,
    "diving": 2,
    "divining": 3,
    "divinitas": 4,
    "divinities": 4,
    "divinity": 4,
    "divirgilio": 5,
    "divis": 2,
    "divisible": 4,
    "division": 3,
    "division's": 3,
    "divisional": 4,
    "divisions": 3,
    "divisions'": 3,
    "divisive": 3,
    "divisiveness": 4,
    "divison": 3,
    "divison(1)": 3,
    "divisor": 3,
    "divita": 3,
    "divito": 3,
    "divorce": 2,
    "divorced": 2,
    "divorcee": 3,
    "divorcee(1)": 3,
    "divorces": 3,
    "divorcing": 3,
    "divulge": 2,
    "divulge(1)": 2,
    "divulged": 2,
    "divulged(1)": 2,
    "divulging": 3,
    "divulging(1)": 3,
    "divvied": 2,
    "divvy": 2,
    "diwa": 2,
    "diwali": 3,
    "dix": 1,
    "dixie": 2,
    "dixieland": 3,
    "dixon": 2,
    "dixon's": 2,
    "dixons": 2,
    "dixson": 2,
    "dixville": 2,
    "dixy": 2,
    "dizon": 2,
    "dizziness": 3,
    "dizzy": 2,
    "dizzying": 3,
    "djakarta": 3,
    "djakarta's": 3,
    "djibouti": 3,
    "djukanovic": 4,
    "djukanovic(1)": 4,
    "djurdjevic": 3,
    "dk": 2,
    "dlouhy": 3,
    "dlugos": 3,
    "dlugosz": 3,
    "dlugosz(1)": 3,
    "dmitri": 3,
    "dmitri(1)": 2,
    "dmz": 3,
    "dna": 3,
    "dnase": 3,
    "dnase(1)": 3,
    "dnc": 3,
    "dniester": 2,
    "do": 1,
    "do's": 1,
    "doable": 3,
    "doak": 1,
    "doan": 1,
    "doan's": 1,
    "doane": 1,
    "doanh": 1,
    "doanna": 2,
    "doar": 1,
    "dob": 1,
    "dobb": 1,
    "dobberstein": 3,
    "dobberstein(1)": 3,
    "dobbie": 2,
    "dobbin": 2,
    "dobbins": 2,
    "dobbs": 1,
    "dobek": 2,
    "dober": 2,
    "doberman": 3,
    "doberstein": 3,
    "doberstein(1)": 3,
    "dobesh": 2,
    "dobey": 2,
    "dobias": 3,
    "dobie": 2,
    "dobies": 2,
    "dobis": 2,
    "dobkin": 2,
    "dobkins": 2,
    "doble": 2,
    "dobler": 3,
    "dobler(1)": 2,
    "dobmeier": 3,
    "doboj": 2,
    "dobos": 2,
    "dobosz": 2,
    "dobransky": 3,
    "dobratz": 2,
    "dobrimir": 3,
    "dobrin": 2,
    "dobrinja": 3,
    "dobrinja(1)": 3,
    "dobrins": 2,
    "dobrinski": 3,
    "dobrowolski": 4,
    "dobrowski": 3,
    "dobry": 2,
    "dobrynin": 3,
    "dobrynin(1)": 3,
    "dobrzynski": 4,
    "dobson": 2,
    "dobson's": 2,
    "dobsons": 2,
    "doby": 2,
    "dobyns": 2,
    "doc": 1,
    "docent": 2,
    "docents": 2,
    "docherty": 3,
    "dochow": 2,
    "dochterman": 3,
    "docie": 2,
    "docila": 3,
    "docile": 2,
    "docility": 4,
    "dock": 1,
    "dock's": 1,
    "docked": 1,
    "docken": 2,
    "dockendorf": 3,
    "docker": 2,
    "dockers": 2,
    "dockery": 3,
    "docket": 2,
    "dockets": 2,
    "dockham": 2,
    "dockiers": 2,
    "docking": 2,
    "dockings": 2,
    "dockins": 2,
    "dockland": 2,
    "docklands": 2,
    "docks": 1,
    "dockside": 2,
    "dockson": 2,
    "dockstader": 3,
    "dockter": 2,
    "dockworker": 3,
    "dockworkers": 3,
    "dockyard": 2,
    "doctor": 2,
    "doctor(1)": 2,
    "doctor's": 2,
    "doctoral": 3,
    "doctorate": 3,
    "doctorates": 3,
    "doctored": 2,
    "doctoring": 3,
    "doctors": 2,
    "doctors'": 2,
    "doctrinaire": 3,
    "doctrinal": 3,
    "doctrine": 2,
    "doctrine(1)": 3,
    "doctrine's": 2,
    "doctrines": 2,
    "docudrama": 4,
    "document": 3,
    "document(1)": 3,
    "documenta": 4,
    "documentaries": 5,
    "documentaries(1)": 5,
    "documentaries(2)": 5,
    "documentaries(3)": 5,
    "documentary": 5,
    "documentary(1)": 5,
    "documentary(2)": 5,
    "documentary(3)": 5,
    "documentation": 5,
    "documentation(1)": 5,
    "documented": 4,
    "documented(1)": 4,
    "documented(2)": 4,
    "documented(3)": 4,
    "documenting": 4,
    "documenting(1)": 4,
    "documenting(2)": 4,
    "documenting(3)": 4,
    "documents": 3,
    "documents(1)": 3,
    "dodaro": 3,
    "dodd": 1,
    "dodd's": 1,
    "doddering": 3,
    "doddington": 3,
    "doddington(1)": 3,
    "doddridge": 2,
    "dodds": 1,
    "dodge": 1,
    "dodge's": 2,
    "dodged": 1,
    "dodgen": 2,
    "dodger": 2,
    "dodger's": 2,
    "dodgers": 2,
    "dodgers'": 2,
    "dodges": 2,
    "dodging": 2,
    "dodi": 2,
    "dodi's": 2,
    "dodo": 2,
    "dodo's": 2,
    "dodos": 2,
    "dodrill": 2,
    "dodson": 2,
    "dodsworth": 2,
    "doe": 1,
    "doe's": 1,
    "doebler": 3,
    "doebler(1)": 2,
    "doeden": 2,
    "doege": 1,
    "doehring": 2,
    "doell": 1,
    "doenges": 2,
    "doepke": 1,
    "doepker": 2,
    "doer": 1,
    "doerfler": 3,
    "doerfler(1)": 2,
    "doerflinger": 4,
    "doerflinger(1)": 3,
    "doering": 3,
    "doernberg": 2,
    "doerner": 2,
    "doerr": 1,
    "doers": 2,
    "doersam": 2,
    "does": 1,
    "does(1)": 1,
    "doescher": 2,
    "doesn't": 2,
    "doesn't(1)": 2,
    "doetsch": 1,
    "dofasco": 3,
    "doff": 1,
    "doffing": 2,
    "doffs": 1,
    "dog": 1,
    "dog's": 1,
    "dogan": 2,
    "dogbane": 2,
    "dogberry": 3,
    "doge": 1,
    "dogear": 2,
    "dogeared": 2,
    "dogearing": 3,
    "dogears": 2,
    "dogfight": 2,
    "dogfights": 2,
    "dogfish": 2,
    "dogged": 1,
    "doggedly": 3,
    "doggerel": 3,
    "doggett": 2,
    "doggie": 2,
    "doggies": 2,
    "dogging": 2,
    "doggone": 2,
    "doggy": 2,
    "doggy's": 2,
    "doghouse": 2,
    "doghouses": 3,
    "dogle": 2,
    "dogle(1)": 2,
    "doglike": 2,
    "dogma": 2,
    "dogmatic": 3,
    "dogmatic(1)": 3,
    "dogmatically": 4,
    "dogmatism": 4,
    "dogs": 1,
    "dogs(1)": 1,
    "dogs'": 1,
    "dogwood": 2,
    "dogwoods": 2,
    "doh": 1,
    "doha": 2,
    "doheny": 3,
    "doherty": 3,
    "doherty(1)": 2,
    "doherty(2)": 3,
    "dohm": 1,
    "dohman": 2,
    "dohme": 1,
    "dohmen": 2,
    "dohn": 1,
    "dohnanyi": 3,
    "dohner": 2,
    "dohr": 1,
    "dohrman": 2,
    "dohrmann": 2,
    "dohse": 1,
    "doi": 1,
    "doidge": 1,
    "doig": 1,
    "doilies": 2,
    "doily": 2,
    "doin'": 2,
    "doing": 2,
    "doings": 2,
    "doiron": 2,
    "doiron(1)": 2,
    "doke": 1,
    "dokely": 2,
    "dokey": 2,
    "dokken": 2,
    "doktor": 2,
    "dol": 1,
    "dolak": 2,
    "dolan": 2,
    "doland": 2,
    "dolata": 3,
    "dolbow": 2,
    "dolby": 2,
    "dolce": 2,
    "dolch": 1,
    "dold": 1,
    "dolder": 2,
    "doldrum": 2,
    "doldrums": 2,
    "dole": 1,
    "dole's": 1,
    "dolecki": 3,
    "doled": 1,
    "doleful": 2,
    "dolen": 2,
    "dolence": 2,
    "doles": 1,
    "doles's": 2,
    "doley": 2,
    "dolezal": 3,
    "dolf": 1,
    "dolfi": 2,
    "dolgen": 2,
    "dolgin": 2,
    "dolin": 2,
    "dolinar": 3,
    "doling": 2,
    "dolinger": 3,
    "dolinski": 3,
    "dolinsky": 3,
    "doll": 1,
    "doll's": 1,
    "dollan": 2,
    "dollar": 2,
    "dollar(1)": 2,
    "dollar's": 2,
    "dollar's(1)": 2,
    "dollar's(2)": 2,
    "dollard": 2,
    "dollarhide": 3,
    "dollars": 2,
    "dollars(1)": 2,
    "dollars'": 2,
    "dolle": 1,
    "dolled": 1,
    "dollens": 2,
    "dolley": 2,
    "dollhouse": 2,
    "dollhouses": 3,
    "dollie": 2,
    "dollinger": 3,
    "dollins": 2,
    "dollison": 3,
    "dolliver": 3,
    "dolloff": 2,
    "dollop": 2,
    "dolls": 1,
    "dolly": 2,
    "dolly's": 2,
    "dolman": 2,
    "dolney": 2,
    "dolomite": 3,
    "dolomite's": 3,
    "dolomites": 3,
    "dolores": 3,
    "dolorita": 4,
    "dolorosa": 4,
    "dolph": 1,
    "dolphin": 2,
    "dolphins": 2,
    "dolphins'": 2,
    "dols": 1,
    "dolson": 2,
    "dolton": 2,
    "dom": 1,
    "domagala": 4,
    "domagalski": 4,
    "domain": 2,
    "domaine": 2,
    "domains": 2,
    "doman": 2,
    "domangue": 2,
    "domanico": 4,
    "domanski": 3,
    "domas": 2,
    "dombeck": 2,
    "dombek": 2,
    "dombkowski": 3,
    "dombroski": 3,
    "dombrosky": 3,
    "dombrowski": 3,
    "dome": 1,
    "dome's": 1,
    "domecq": 2,
    "domed": 1,
    "domeier": 3,
    "domek": 2,
    "domenech": 3,
    "domenici": 4,
    "domenici(1)": 4,
    "domenici(2)": 4,
    "domenici's": 4,
    "domenici's(1)": 4,
    "domenici's(2)": 4,
    "domenick": 3,
    "domenico": 4,
    "domeniconi": 5,
    "domer": 2,
    "domes": 1,
    "domestic": 3,
    "domestically": 4,
    "domesticate": 4,
    "domesticated": 5,
    "domesticates": 4,
    "domesticating": 5,
    "domestication": 5,
    "domesticity": 5,
    "domestics": 3,
    "domical": 3,
    "domico": 3,
    "domin": 2,
    "domina": 3,
    "dominance": 3,
    "dominant": 3,
    "dominate": 3,
    "dominated": 4,
    "dominates": 3,
    "dominating": 4,
    "domination": 4,
    "domine": 3,
    "dominee": 3,
    "domineer": 3,
    "domineering": 4,
    "dominelli": 4,
    "dominelli(1)": 4,
    "dominelli's": 4,
    "dominelli's(1)": 4,
    "dominey": 3,
    "domingo": 3,
    "domingo(1)": 3,
    "domingos": 3,
    "domingue": 2,
    "domingues": 3,
    "dominguez": 3,
    "domini": 3,
    "dominiak": 4,
    "dominic": 3,
    "dominic's": 3,
    "dominica": 4,
    "dominican": 4,
    "dominicana": 5,
    "dominicana(1)": 5,
    "dominicans": 4,
    "dominici": 4,
    "dominick": 3,
    "dominik": 3,
    "dominion": 3,
    "dominion's": 3,
    "dominique": 3,
    "domino": 3,
    "domino(1)": 3,
    "domino's": 3,
    "dominoes": 3,
    "dominos": 3,
    "dominquez": 3,
    "dominski": 3,
    "dominus": 3,
    "dominy": 3,
    "domke": 1,
    "dommer": 2,
    "dommie": 2,
    "domoling": 3,
    "domtar": 2,
    "domtar's": 2,
    "domzalski": 3,
    "don": 1,
    "don's": 1,
    "don't": 1,
    "don't(1)": 1,
    "don'ts": 1,
    "don'ts(1)": 1,
    "dona": 2,
    "donadio": 4,
    "donaghey": 3,
    "donaghue": 3,
    "donaghy": 3,
    "donahey": 3,
    "donaho": 3,
    "donahoe": 3,
    "donahoo": 3,
    "donahue": 3,
    "donahue(1)": 3,
    "donais": 2,
    "donald": 2,
    "donald's": 2,
    "donalda": 3,
    "donaldo": 3,
    "donaldo's": 3,
    "donaldson": 3,
    "donaldson's": 3,
    "donaldsons": 3,
    "donalson": 3,
    "donapria": 4,
    "donar": 2,
    "donat": 2,
    "donata": 3,
    "donate": 2,
    "donated": 3,
    "donated(1)": 3,
    "donatelli": 4,
    "donates": 2,
    "donath": 2,
    "donathan": 3,
    "donati": 3,
    "donating": 3,
    "donation": 3,
    "donations": 3,
    "donatists": 3,
    "donato": 3,
    "donavan": 3,
    "donaway": 3,
    "donde": 1,
    "donder": 2,
    "dondero": 3,
    "dondlinger": 4,
    "dondlinger(1)": 3,
    "done": 1,
    "donegan": 3,
    "donehoo": 3,
    "donelan": 3,
    "donella": 3,
    "donelson": 3,
    "doner": 2,
    "dones": 1,
    "doney": 2,
    "dong": 1,
    "dong(1)": 1,
    "dongen": 2,
    "dongmei": 2,
    "donham": 2,
    "donia": 3,
    "donica": 3,
    "donigan": 3,
    "doniger": 3,
    "donilon": 3,
    "donis": 2,
    "donizetti": 4,
    "donizetti's": 4,
    "donkey": 2,
    "donkey(1)": 2,
    "donkeys": 2,
    "donlan": 2,
    "donley": 2,
    "donlin": 2,
    "donlon": 2,
    "donmoyer": 3,
    "donn": 1,
    "donna": 2,
    "donna's": 2,
    "donnan": 2,
    "donnas": 2,
    "donnay": 2,
    "donne": 1,
    "donned": 1,
    "donnell": 2,
    "donnellan": 3,
    "donnelley": 3,
    "donnelley(1)": 3,
    "donnelley's": 3,
    "donnelley's(1)": 3,
    "donnelly": 3,
    "donnelly(1)": 3,
    "donnelly's": 3,
    "donnelly's(1)": 3,
    "donner": 2,
    "donnie": 2,
    "donning": 2,
    "donny": 2,
    "donnybrook": 3,
    "donofrio": 4,
    "donoghue": 3,
    "donoghue(1)": 3,
    "donoghue's": 3,
    "donoghue's(1)": 3,
    "donoho": 3,
    "donohoe": 3,
    "donohoo": 3,
    "donohue": 3,
    "donohue(1)": 3,
    "donohue's": 3,
    "donohue's(1)": 3,
    "donor": 2,
    "donor's": 2,
    "donors": 2,
    "donors'": 2,
    "donovan": 3,
    "donovan's": 3,
    "dons": 1,
    "donsbach": 2,
    "donut": 2,
    "donuts": 2,
    "donuts'": 2,
    "donvan": 2,
    "donvan's": 2,
    "donze": 1,
    "doo": 1,
    "doodad": 2,
    "doodads": 2,
    "doodle": 2,
    "doodles": 2,
    "doody": 2,
    "doogie": 2,
    "doolan": 2,
    "doolen": 2,
    "dooley": 2,
    "doolin": 2,
    "dooling": 2,
    "doolittle": 3,
    "doom": 1,
    "doomed": 1,
    "dooming": 2,
    "dooms": 1,
    "doomsayer": 3,
    "doomsayers": 3,
    "doomsaying": 3,
    "doomsday": 2,
    "doonan": 2,
    "dooner": 2,
    "doonesbury": 3,
    "door": 1,
    "door's": 1,
    "doorbell": 2,
    "doordarshan": 3,
    "doorenbos": 3,
    "doorkeeper": 3,
    "doorknob": 2,
    "doorknobs": 2,
    "doorman": 2,
    "doormat": 2,
    "doormats": 2,
    "doorn": 1,
    "doornail": 2,
    "doornbos": 2,
    "doors": 1,
    "doorsill": 2,
    "doorstep": 2,
    "doorsteps": 2,
    "doorway": 2,
    "doorways": 2,
    "doose": 1,
    "doozy": 2,
    "dopa": 2,
    "dopamine": 3,
    "dope": 1,
    "doped": 1,
    "dopey": 2,
    "dopp": 1,
    "doppler": 2,
    "dopson": 2,
    "dora": 2,
    "dorado": 3,
    "dorais": 2,
    "doral": 2,
    "doralin": 3,
    "doralynne": 3,
    "doran": 2,
    "doraville": 3,
    "dorazio": 4,
    "dorazio(1)": 4,
    "dorcas": 2,
    "dorch": 1,
    "dorchester": 3,
    "dordies": 2,
    "dore": 1,
    "dorea": 3,
    "doreen": 2,
    "dorelia": 4,
    "doremus": 3,
    "doren": 2,
    "dorena": 3,
    "dorene": 2,
    "dorer": 2,
    "dorette": 2,
    "doretti": 3,
    "dorey": 2,
    "dorf": 1,
    "dorff": 1,
    "dorfman": 2,
    "dorgan": 2,
    "dorgan's": 2,
    "dori": 2,
    "doria": 3,
    "dorian": 3,
    "dorians": 3,
    "doric": 2,
    "dorice": 2,
    "dorie": 2,
    "dorin": 2,
    "dorinda": 3,
    "dorine": 3,
    "doring": 2,
    "dorio": 3,
    "dorion": 3,
    "doris": 2,
    "doris(1)": 2,
    "doris(2)": 2,
    "doris(3)": 2,
    "dorise": 2,
    "doritos": 3,
    "dority": 3,
    "dorko": 2,
    "dorland": 2,
    "dorm": 1,
    "dorman": 2,
    "dormancy": 3,
    "dormant": 2,
    "dormer": 2,
    "dorminey": 3,
    "dormitories": 4,
    "dormitory": 4,
    "dormouse": 2,
    "dorms": 1,
    "dorn": 1,
    "dornak": 2,
    "dornam": 2,
    "dornan": 2,
    "dornan's": 2,
    "dornbusch": 2,
    "dornbush": 2,
    "dorner": 2,
    "dorney": 2,
    "dornfeld": 2,
    "dornhens": 2,
    "dornier": 2,
    "dornin": 2,
    "doro": 2,
    "doron": 2,
    "dorotea": 3,
    "dorotea(1)": 4,
    "dorothea": 4,
    "dorothy": 3,
    "dorothy(1)": 2,
    "dorothy's": 3,
    "dorothy's(1)": 2,
    "dorough": 2,
    "dorow": 2,
    "dorr": 1,
    "dorrance": 2,
    "dorrell": 2,
    "dorrie": 2,
    "dorries": 2,
    "dorris": 2,
    "dorroh": 2,
    "dorrough": 2,
    "dorsa": 2,
    "dorsal": 2,
    "dorsally": 3,
    "dorsch": 1,
    "dorset": 2,
    "dorsett": 2,
    "dorsey": 2,
    "dorsi": 2,
    "dorst": 1,
    "dort": 1,
    "dorta": 2,
    "dortch": 1,
    "dorthea": 3,
    "dorthy": 2,
    "dortmund": 2,
    "dorton": 2,
    "dorval": 2,
    "dorward": 2,
    "dorwart": 2,
    "dory": 2,
    "dos": 1,
    "dos(1)": 1,
    "dosage": 2,
    "dosage(1)": 2,
    "dosages": 3,
    "dosch": 1,
    "doscher": 2,
    "dose": 1,
    "doser": 2,
    "doses": 2,
    "doses(1)": 2,
    "dosh": 1,
    "dosher": 2,
    "doshi": 2,
    "doshier": 3,
    "dosia": 3,
    "dosie": 2,
    "dosier": 3,
    "dosimeters": 4,
    "dosing": 2,
    "doskocil": 3,
    "dospasos": 3,
    "dospasos'": 3,
    "doss": 1,
    "dossantos": 3,
    "dossett": 2,
    "dossey": 2,
    "dossier": 2,
    "dossier(1)": 3,
    "dossiers": 2,
    "dossiers(1)": 3,
    "dost": 1,
    "dostal": 2,
    "doster": 2,
    "dostie": 2,
    "dostoevski": 3,
    "dostoevsky": 3,
    "dostoevsky(1)": 4,
    "dostoevsky(2)": 4,
    "doswell": 2,
    "dot": 1,
    "dotan": 2,
    "dote": 1,
    "doten": 2,
    "doth": 1,
    "dothan": 2,
    "doting": 2,
    "doto": 2,
    "dots": 1,
    "dotson": 2,
    "dott": 1,
    "dottavio": 4,
    "dotted": 2,
    "dotted(1)": 2,
    "dotter": 2,
    "dotterer": 3,
    "dottie": 2,
    "dotting": 2,
    "dotts": 1,
    "dotty": 2,
    "doty": 2,
    "dotzler": 2,
    "doub": 1,
    "doubek": 2,
    "doubet": 2,
    "double": 2,
    "double-entendre": 5,
    "doubled": 2,
    "doubleday": 3,
    "doubledecker": 4,
    "doubles": 2,
    "doublespeak": 3,
    "doublethink": 3,
    "doubletree": 3,
    "doubling": 3,
    "doubling(1)": 2,
    "doubly": 2,
    "doubrava": 3,
    "doubt": 1,
    "doubted": 2,
    "doubter": 2,
    "doubters": 2,
    "doubtfire": 3,
    "doubtfire's": 3,
    "doubtfires": 3,
    "doubtful": 2,
    "doubting": 2,
    "doubtless": 2,
    "doubts": 1,
    "doucet": 2,
    "doucette": 2,
    "douche": 1,
    "doud": 1,
    "doudna": 2,
    "douds": 1,
    "doug": 1,
    "doug's": 1,
    "dougal": 2,
    "dougall": 2,
    "dougall(1)": 2,
    "dougan": 2,
    "dougan(1)": 2,
    "dougans": 2,
    "dougans(1)": 2,
    "dougens": 2,
    "dougens(1)": 2,
    "douggins": 2,
    "dough": 1,
    "doughboy": 2,
    "dougher": 2,
    "dougherty": 3,
    "dougherty(1)": 3,
    "doughman": 2,
    "doughnut": 2,
    "doughnuts": 2,
    "doughten": 2,
    "doughtie": 2,
    "doughty": 2,
    "doughy": 2,
    "dougie": 2,
    "dougie's": 2,
    "dougl": 2,
    "douglas": 2,
    "douglas'": 2,
    "douglas's": 3,
    "douglass": 2,
    "doukas": 2,
    "doulton": 2,
    "douma": 2,
    "doupe": 1,
    "dour": 2,
    "dour(1)": 1,
    "douse": 1,
    "doused": 1,
    "dousing": 2,
    "douthat": 2,
    "douthett": 2,
    "douthit": 2,
    "douthitt": 2,
    "doutt": 1,
    "douty": 2,
    "douville": 2,
    "douwe": 1,
    "dov": 1,
    "dove": 1,
    "dove(1)": 1,
    "dovel": 2,
    "dover": 2,
    "dover's": 2,
    "doverspike": 3,
    "doves": 1,
    "dovetail": 2,
    "dovetailed": 2,
    "dovetails": 2,
    "dovey": 2,
    "dovidio": 4,
    "dovish": 2,
    "dovish(1)": 2,
    "dow": 1,
    "dow's": 1,
    "dowager": 3,
    "dowd": 1,
    "dowda": 2,
    "dowdall": 2,
    "dowdell": 2,
    "dowden": 2,
    "dowding": 2,
    "dowdle": 2,
    "dowds": 1,
    "dowdy": 2,
    "dowe": 1,
    "dowel": 2,
    "dowell": 2,
    "dowels": 2,
    "dowen": 2,
    "dower": 1,
    "dowers": 1,
    "dowie": 2,
    "dowis": 2,
    "dowland": 2,
    "dowlen": 2,
    "dowler": 2,
    "dowless": 2,
    "dowling": 2,
    "down": 1,
    "down's": 1,
    "downard": 2,
    "downbeat": 2,
    "downcast": 2,
    "downdraft": 2,
    "downe": 1,
    "downed": 1,
    "downen": 2,
    "downer": 2,
    "downers": 2,
    "downes": 1,
    "downes's": 2,
    "downey": 2,
    "downey's": 2,
    "downfall": 2,
    "downgrade": 2,
    "downgraded": 3,
    "downgrades": 2,
    "downgrading": 3,
    "downgradings": 3,
    "downham": 2,
    "downhill": 2,
    "downie": 2,
    "downing": 2,
    "downingtown": 3,
    "download": 2,
    "downloaded": 3,
    "downloading": 3,
    "downloads": 2,
    "downpayment": 3,
    "downpayments": 3,
    "downplay": 2,
    "downplayed": 2,
    "downplaying": 3,
    "downplays": 2,
    "downpour": 2,
    "downpours": 2,
    "downrange": 2,
    "downright": 2,
    "downriver": 3,
    "downs": 1,
    "downscale": 2,
    "downside": 2,
    "downsides": 2,
    "downsize": 2,
    "downsized": 2,
    "downsizes": 3,
    "downsizing": 3,
    "downsizings": 3,
    "downstage": 2,
    "downstairs": 2,
    "downstate": 2,
    "downstream": 2,
    "downswing": 2,
    "downtime": 2,
    "downtown": 2,
    "downtown's": 2,
    "downtowns": 2,
    "downtrend": 2,
    "downtrodden": 3,
    "downturn": 2,
    "downturns": 2,
    "downum": 2,
    "downward": 2,
    "downwardly": 3,
    "downwards": 2,
    "downwind": 2,
    "downy": 2,
    "dowry": 2,
    "dowse": 1,
    "dowsing": 2,
    "dowsman": 2,
    "dowty": 2,
    "doxey": 2,
    "doxie": 2,
    "doxologies": 4,
    "doxology": 4,
    "doxtater": 3,
    "doxy": 2,
    "doyal": 2,
    "doyel": 2,
    "doyen": 2,
    "doyle": 1,
    "doyle's": 1,
    "doyon": 2,
    "doze": 1,
    "dozed": 1,
    "dozen": 2,
    "dozens": 2,
    "dozes": 2,
    "dozier": 3,
    "dozing": 2,
    "dqalpha": 4,
    "dr": 1,
    "dr(1)": 2,
    "dr.": 1,
    "dr.(1)": 2,
    "drab": 1,
    "drabbed": 1,
    "drabble": 2,
    "drabek": 2,
    "drabenstott": 3,
    "drabik": 2,
    "drabinsky": 3,
    "drabkin": 2,
    "drabs": 1,
    "drace": 1,
    "drach": 1,
    "drachenberg": 3,
    "drachma": 2,
    "drachmas": 2,
    "drackett": 2,
    "draco": 2,
    "draco(1)": 2,
    "draconian": 4,
    "draconian(1)": 4,
    "dracula": 3,
    "draeger": 2,
    "draffen": 2,
    "draft": 1,
    "draft's": 1,
    "drafted": 2,
    "draftee": 2,
    "draftees": 2,
    "drafter": 2,
    "drafters": 2,
    "drafting": 2,
    "drafts": 1,
    "draftsman": 2,
    "draftsmanship": 3,
    "draftsmen": 2,
    "drafty": 2,
    "drag": 1,
    "dragan": 2,
    "drage": 1,
    "drager": 2,
    "dragged": 1,
    "dragging": 2,
    "draggy": 2,
    "dragline": 2,
    "dragnet": 2,
    "dragnets": 2,
    "drago": 2,
    "dragon": 2,
    "dragon's": 2,
    "dragonair": 3,
    "dragone": 2,
    "dragonhead": 3,
    "dragonheart": 3,
    "dragons": 2,
    "dragoo": 2,
    "dragovich": 3,
    "drags": 1,
    "draheim": 2,
    "drahos": 2,
    "drahuschak": 3,
    "drahuschak(1)": 3,
    "drain": 1,
    "drainage": 2,
    "drainage(1)": 2,
    "draine": 1,
    "drained": 1,
    "drainer": 2,
    "drainers": 2,
    "draining": 2,
    "drains": 1,
    "drake": 1,
    "drakeford": 2,
    "drakes": 1,
    "drakos": 2,
    "dralle": 1,
    "dram": 1,
    "dram(1)": 2,
    "drama": 2,
    "dramamine": 3,
    "dramas": 2,
    "dramatic": 3,
    "dramatically": 4,
    "dramatically(1)": 5,
    "dramatics": 3,
    "dramatist": 3,
    "dramatization": 5,
    "dramatizations": 5,
    "dramatize": 3,
    "dramatize(1)": 3,
    "dramatized": 3,
    "dramatizes": 4,
    "dramatizing": 4,
    "dramaturgy": 4,
    "drams": 1,
    "drams(1)": 2,
    "drane": 1,
    "draney": 2,
    "drang": 1,
    "drank": 1,
    "dransfield": 2,
    "drape": 1,
    "drapeau": 2,
    "draped": 1,
    "draper": 2,
    "draperies": 3,
    "drapery": 3,
    "drapes": 1,
    "draping": 2,
    "drapkin": 2,
    "drasner": 2,
    "drastic": 2,
    "drastically": 3,
    "draughn": 1,
    "draughon": 2,
    "draught": 1,
    "draughts": 1,
    "draus": 1,
    "dravecky": 3,
    "draves": 1,
    "dravis": 2,
    "dravo": 2,
    "dravo's": 2,
    "draw": 1,
    "drawback": 2,
    "drawbacks": 2,
    "drawbaugh": 2,
    "drawbridge": 2,
    "drawdown": 2,
    "drawdowns": 2,
    "drawdy": 2,
    "drawer": 1,
    "drawers": 1,
    "drawing": 2,
    "drawings": 2,
    "drawl": 1,
    "drawled": 1,
    "drawls": 1,
    "drawn": 1,
    "draws": 1,
    "dray": 1,
    "drayer": 2,
    "drayton": 2,
    "drayton's": 2,
    "dread": 1,
    "dreaded": 2,
    "dreadful": 2,
    "dreadfully": 3,
    "dreading": 2,
    "dreadnought": 2,
    "dreads": 1,
    "dream": 1,
    "dreamed": 1,
    "dreamer": 2,
    "dreamers": 2,
    "dreaming": 2,
    "dreamland": 2,
    "dreamlike": 2,
    "dreams": 1,
    "dreamt": 1,
    "dreamworks": 2,
    "dreamworks'": 2,
    "dreamworld": 2,
    "dreamy": 2,
    "dreariness": 3,
    "dreary": 2,
    "drebsky": 2,
    "drechsel": 2,
    "drechsler": 3,
    "drechsler(1)": 2,
    "dred": 1,
    "dredd": 1,
    "dredge": 1,
    "dredged": 1,
    "dredges": 2,
    "dredges(1)": 2,
    "dredging": 2,
    "drees": 1,
    "dreese": 1,
    "dreessen": 2,
    "dreger": 2,
    "dregs": 1,
    "dreher": 1,
    "dreibelbis": 3,
    "dreier": 2,
    "dreighton": 2,
    "dreiling": 2,
    "dreis": 1,
    "dreisbach": 2,
    "dreman": 2,
    "drench": 1,
    "drenched": 1,
    "drenches": 2,
    "drenching": 2,
    "drennan": 2,
    "drennen": 2,
    "drenning": 2,
    "drennon": 2,
    "drenth": 1,
    "drepung": 2,
    "drepung(1)": 2,
    "dresbach": 2,
    "dresch": 1,
    "drescher": 2,
    "dresden": 2,
    "dresdner": 2,
    "dresdner's": 2,
    "dresen": 2,
    "dresher": 2,
    "dresner": 2,
    "dress": 1,
    "dressage": 2,
    "dressed": 1,
    "dressel": 2,
    "dressen": 2,
    "dresser": 2,
    "dresser's": 2,
    "dressers": 2,
    "dresses": 2,
    "dresses(1)": 2,
    "dressier": 3,
    "dressing": 2,
    "dressings": 2,
    "dressler": 2,
    "dressmaker": 3,
    "dressmakers": 3,
    "dressmaking": 3,
    "dressy": 2,
    "drew": 1,
    "drewery": 3,
    "drewes": 1,
    "drewett": 2,
    "drewry": 2,
    "drews": 1,
    "drexel": 2,
    "drexel's": 2,
    "drexler": 2,
    "drey": 1,
    "dreyer": 2,
    "dreyfus": 2,
    "dreyfus(1)": 2,
    "dreyfus's": 3,
    "dreyfuss": 2,
    "dribbed": 1,
    "dribble": 2,
    "dribbled": 2,
    "dribbles": 2,
    "dribbling": 3,
    "dribbling(1)": 2,
    "dribs": 1,
    "dried": 1,
    "driehaus": 2,
    "drier": 2,
    "dries": 1,
    "driessen": 2,
    "driest": 2,
    "driever": 2,
    "drift": 1,
    "drifta": 2,
    "drifted": 2,
    "drifted(1)": 2,
    "drifter": 2,
    "drifters": 2,
    "drifting": 2,
    "driftnet": 2,
    "drifts": 1,
    "driftwood": 2,
    "driggers": 2,
    "driggs": 1,
    "drill": 1,
    "drillbit": 2,
    "drilled": 1,
    "driller": 2,
    "drillers": 2,
    "drilling": 2,
    "drilling's": 2,
    "drills": 1,
    "drina": 2,
    "drina's": 2,
    "drinas": 2,
    "dring": 1,
    "drink": 1,
    "drinkable": 3,
    "drinkard": 2,
    "drinker": 2,
    "drinker's": 2,
    "drinkers": 2,
    "drinking": 2,
    "drinks": 1,
    "drinkwater": 3,
    "drinkwine": 2,
    "drinnon": 2,
    "drip": 1,
    "drip-dry": 2,
    "dripped": 1,
    "dripping": 2,
    "dripps": 1,
    "drips": 1,
    "driscoll": 2,
    "driskell": 2,
    "driskill": 2,
    "drivable": 3,
    "drive": 1,
    "drive's": 1,
    "drive-by": 2,
    "drive-thru": 2,
    "drive-thrus": 2,
    "drivel": 2,
    "driven": 2,
    "driver": 2,
    "driver's": 2,
    "driverless": 3,
    "drivers": 2,
    "drivers'": 2,
    "drives": 1,
    "driveway": 2,
    "driveways": 2,
    "driving": 2,
    "drizzle": 2,
    "drizzling": 3,
    "drizzling(1)": 2,
    "drizzly": 2,
    "drobkov": 2,
    "drobkov(1)": 2,
    "drobny": 2,
    "droddy": 2,
    "droege": 1,
    "droessler": 3,
    "droessler(1)": 2,
    "droge": 1,
    "drogoul": 2,
    "drogoul's": 2,
    "drogue": 1,
    "drohan": 2,
    "droke": 1,
    "drolet": 2,
    "droll": 1,
    "drollinger": 3,
    "dromedary": 4,
    "dromer": 2,
    "dromey": 2,
    "dromgoole": 2,
    "dromgooles": 2,
    "dromi": 2,
    "dromomania": 5,
    "dromomania(1)": 4,
    "dromon": 2,
    "drone": 1,
    "droned": 1,
    "drones": 1,
    "dronet": 2,
    "droney": 2,
    "droning": 2,
    "drool": 1,
    "drooling": 2,
    "droop": 1,
    "drooped": 1,
    "drooping": 2,
    "droopy": 2,
    "drop": 1,
    "drop(1)": 1,
    "drop-off": 2,
    "drop-offs": 2,
    "dropkin": 2,
    "droplet": 2,
    "droplets": 2,
    "dropoff": 2,
    "dropoffs": 2,
    "dropout": 2,
    "dropouts": 2,
    "dropped": 1,
    "dropper": 2,
    "droppers": 2,
    "dropping": 2,
    "droppings": 2,
    "drops": 1,
    "dropsy": 2,
    "droser": 2,
    "dross": 1,
    "drost": 1,
    "droste": 1,
    "droste(1)": 1,
    "droste(2)": 2,
    "drotar": 2,
    "drought": 1,
    "drought's": 1,
    "droughts": 1,
    "drouillard": 2,
    "drouin": 1,
    "drove": 1,
    "drover": 2,
    "droves": 1,
    "drown": 1,
    "drowned": 1,
    "drowning": 2,
    "drownings": 2,
    "drowns": 1,
    "drowsiness": 3,
    "drowsy": 2,
    "droz": 1,
    "drozd": 1,
    "drozda": 2,
    "drozdowski": 3,
    "dru": 1,
    "drub": 1,
    "drubbed": 1,
    "drubbing": 2,
    "druce": 1,
    "drucie": 2,
    "druck": 1,
    "druckenmiller": 4,
    "drucker": 2,
    "druckman": 2,
    "drudge": 1,
    "drudgery": 3,
    "druella": 3,
    "drug": 1,
    "drug's": 1,
    "drugan": 2,
    "drugged": 1,
    "drugging": 2,
    "druggist": 2,
    "druggist's": 2,
    "druggist's(1)": 2,
    "druggists": 2,
    "druggists(1)": 2,
    "drugmaker": 3,
    "drugmakers": 3,
    "drugs": 1,
    "drugs'": 1,
    "drugstore": 2,
    "drugstores": 2,
    "druid": 2,
    "druidism": 4,
    "druids": 2,
    "druisilla": 3,
    "drum": 1,
    "drumbeat": 2,
    "drumhead": 2,
    "drumheller": 3,
    "drumlin's": 2,
    "drumm": 1,
    "drummed": 1,
    "drummer": 2,
    "drummers": 2,
    "drummey": 2,
    "drumming": 2,
    "drummond": 2,
    "drummonds": 2,
    "drumright": 2,
    "drums": 1,
    "drumstick": 2,
    "drumwright": 2,
    "drunk": 1,
    "drunkard": 2,
    "drunkards": 2,
    "drunken": 2,
    "drunkenness": 3,
    "drunks": 1,
    "drupe": 1,
    "drupes": 1,
    "drury": 2,
    "drusa": 2,
    "druse": 1,
    "drusie": 2,
    "drusilla": 3,
    "druthers": 2,
    "druze": 1,
    "dry": 1,
    "dryclean": 2,
    "drycleaner": 3,
    "drycleaning": 3,
    "dryden": 2,
    "drye": 1,
    "dryer": 2,
    "dryers": 2,
    "drying": 2,
    "dryly": 2,
    "dryness": 2,
    "drypers": 2,
    "drypoint": 2,
    "drysdale": 2,
    "dryser": 2,
    "drywall": 2,
    "drzewiecki": 3,
    "dsouza": 3,
    "dss": 3,
    "dsv": 3,
    "du": 1,
    "du(1)": 1,
    "du-bois": 2,
    "dual": 2,
    "dual(1)": 1,
    "dualism": 4,
    "dualisms": 4,
    "dualist": 3,
    "dualistic": 4,
    "duality": 4,
    "duals": 2,
    "duan": 1,
    "duan(1)": 1,
    "duana": 3,
    "duane": 1,
    "duarte": 2,
    "duarte's": 2,
    "dub": 1,
    "duba": 2,
    "dubach": 2,
    "dubai": 2,
    "dubarry": 3,
    "dubas": 2,
    "dubay": 2,
    "dubbed": 1,
    "dubberly": 3,
    "dubbing": 2,
    "dubbs": 1,
    "dubcek": 2,
    "dubcek(1)": 2,
    "dube": 1,
    "dubeau": 2,
    "duberstein": 3,
    "duberstein(1)": 3,
    "duberstein's": 3,
    "duberstein's(1)": 3,
    "dubey": 2,
    "dubhi": 2,
    "dubicki": 3,
    "dubie": 2,
    "dubiel": 2,
    "dubilier": 3,
    "dubilier(1)": 4,
    "dubin": 2,
    "dubinin": 3,
    "dubinsky": 3,
    "dubious": 3,
    "dubis": 2,
    "dublin": 2,
    "dublin's": 2,
    "duboff": 2,
    "dubois": 2,
    "dubois(1)": 2,
    "duboise": 2,
    "duboise(1)": 2,
    "dubord": 2,
    "dubose": 2,
    "dubow": 2,
    "dubrawski": 3,
    "dubray": 2,
    "dubree": 2,
    "dubreuil": 2,
    "dubroc": 2,
    "dubroff": 2,
    "dubrovnik": 3,
    "dubrovnik's": 3,
    "dubrovniks": 3,
    "dubrovsky": 3,
    "dubrovsky(1)": 3,
    "dubrow": 2,
    "dubs": 1,
    "dubuc": 2,
    "dubuisson": 3,
    "dubuque": 2,
    "dubuque's": 2,
    "duby": 2,
    "duc": 1,
    "duca": 2,
    "ducal": 2,
    "duce": 1,
    "ducey": 2,
    "duch": 1,
    "duchaine": 2,
    "duchamp": 2,
    "duchamp's": 2,
    "ducharme": 2,
    "duchemin": 3,
    "duchene": 2,
    "duchenne": 2,
    "duchesneau": 3,
    "duchess": 2,
    "duchin": 2,
    "duchon": 2,
    "duchossois": 3,
    "duchow": 2,
    "duchy": 2,
    "duck": 1,
    "duck's": 1,
    "ducked": 1,
    "ducker": 2,
    "duckett": 2,
    "ducking": 2,
    "duckling": 2,
    "ducklings": 2,
    "ducks": 1,
    "ducks'": 1,
    "ducksworth": 2,
    "duckwall": 2,
    "duckweed": 2,
    "duckworth": 2,
    "duclos": 2,
    "ducommun": 3,
    "ducommun(1)": 3,
    "ducote": 2,
    "duct": 1,
    "ductile": 2,
    "ductility": 4,
    "ductless": 2,
    "ducts": 1,
    "dud": 1,
    "duda": 2,
    "dudack": 2,
    "dudar": 2,
    "dudas": 2,
    "dudash": 2,
    "dudayev": 3,
    "dudayev's": 3,
    "dudd": 1,
    "dudding": 2,
    "duddy": 2,
    "dude": 1,
    "dudeck": 2,
    "dudeck's": 2,
    "dudek": 2,
    "duden": 2,
    "dudenhoeffer": 4,
    "dudes": 1,
    "dudgeon": 2,
    "dudik": 2,
    "dudley": 2,
    "dudman": 2,
    "dudney": 2,
    "duds": 1,
    "dudziak": 3,
    "dudzik": 2,
    "dudzinski": 3,
    "due": 1,
    "due(1)": 1,
    "duecker": 2,
    "dueitt": 2,
    "dueker": 2,
    "duel": 2,
    "dueled": 2,
    "dueling": 2,
    "duelist": 3,
    "duell": 1,
    "duell(1)": 1,
    "duels": 2,
    "duena": 3,
    "duena(1)": 2,
    "duenas": 3,
    "duenas(1)": 2,
    "duenez": 2,
    "duenow": 2,
    "duensing": 2,
    "duer": 2,
    "duerksen": 2,
    "duerr": 1,
    "duerson": 2,
    "duerst": 1,
    "dues": 1,
    "duesberg": 2,
    "duesing": 2,
    "duesler": 3,
    "duesler(1)": 2,
    "duesseldorf": 3,
    "duet": 2,
    "duet(1)": 2,
    "duets": 2,
    "duets(1)": 2,
    "duey": 2,
    "duey(1)": 2,
    "dufault": 2,
    "dufek": 2,
    "duff": 1,
    "duffala": 3,
    "duffee": 2,
    "duffek": 2,
    "duffel": 2,
    "duffell": 2,
    "duffer": 2,
    "duffett": 2,
    "duffey": 2,
    "duffie": 2,
    "duffield": 2,
    "duffin": 2,
    "duffner": 2,
    "dufford": 2,
    "duffour": 2,
    "duffus": 2,
    "duffy": 2,
    "duffy's": 2,
    "dufner": 2,
    "duford": 2,
    "dufort": 2,
    "dufour": 2,
    "dufrane": 2,
    "dufrene": 2,
    "dufresne": 2,
    "dufur": 2,
    "dug": 1,
    "dugal": 2,
    "dugald": 2,
    "dugan": 2,
    "dugar": 2,
    "dugas": 2,
    "dugdale": 2,
    "duggan": 2,
    "duggar": 2,
    "dugger": 2,
    "duggin": 2,
    "duggins": 2,
    "dugo": 2,
    "dugout": 2,
    "dugouts": 2,
    "duguay": 2,
    "duguid": 2,
    "duh": 1,
    "duhaime": 2,
    "duhamel": 3,
    "duhart": 2,
    "duhe": 1,
    "duhon": 2,
    "duhr": 1,
    "dui": 3,
    "duignan": 2,
    "duis": 2,
    "duis(1)": 3,
    "duisburg": 2,
    "duitsman": 2,
    "duk": 1,
    "dukakis": 3,
    "dukakis'": 3,
    "dukakis'(1)": 4,
    "dukakis's": 4,
    "dukakises": 4,
    "dukart": 2,
    "duke": 1,
    "duke's": 1,
    "duked": 1,
    "dukedom": 2,
    "dukeman": 2,
    "duker": 2,
    "dukes": 1,
    "duking": 2,
    "dula": 2,
    "dulac": 2,
    "dulak": 2,
    "dulaney": 3,
    "dulany": 3,
    "dulay": 2,
    "dulce": 1,
    "dulcea": 3,
    "dulcet": 2,
    "dulciana": 3,
    "dulcibelle": 3,
    "dulcie": 2,
    "dulcimer": 3,
    "dulcine": 2,
    "dulcinea": 4,
    "dule": 1,
    "duley": 2,
    "dulin": 2,
    "duling": 2,
    "dull": 1,
    "dulle": 1,
    "dullea": 3,
    "dulled": 1,
    "duller": 2,
    "dulles": 2,
    "dullest": 2,
    "dulling": 2,
    "dullness": 2,
    "dulmage": 2,
    "dulong": 2,
    "dulski": 2,
    "dulude": 2,
    "duluth": 2,
    "dulwich": 2,
    "dulworth": 2,
    "duly": 2,
    "dum": 1,
    "duma": 2,
    "duma's": 2,
    "dumaine": 2,
    "dumais": 2,
    "duman": 2,
    "dumas": 2,
    "dumas(1)": 2,
    "dumb": 1,
    "dumbbell": 2,
    "dumbbells": 2,
    "dumber": 2,
    "dumbest": 2,
    "dumbfound": 2,
    "dumbfounded": 3,
    "dumbfounding": 3,
    "dumbfounds": 2,
    "dumbing": 2,
    "dumbo": 2,
    "dumbstruck": 2,
    "dumenil": 3,
    "dumez": 2,
    "dumford": 2,
    "dumire": 3,
    "dumke": 2,
    "dumlao": 2,
    "dumler": 2,
    "dumm": 1,
    "dummer": 2,
    "dummies": 2,
    "dummitt": 2,
    "dummy": 2,
    "dumond": 2,
    "dumont": 2,
    "dumoulin": 3,
    "dump": 1,
    "dumped": 1,
    "dumper": 2,
    "dumping": 2,
    "dumpling": 2,
    "dumplings": 2,
    "dumps": 1,
    "dumpster": 2,
    "dumpsters": 2,
    "dumptruck": 2,
    "dumptrucks": 2,
    "dumpty": 2,
    "dumpy": 2,
    "dun": 1,
    "dun's": 1,
    "duna": 2,
    "dunagan": 3,
    "dunahoo": 3,
    "dunaj": 2,
    "dunavan": 3,
    "dunavant": 3,
    "dunaway": 3,
    "dunay": 2,
    "dunbar": 2,
    "dunblane": 2,
    "dunc": 1,
    "duncan": 2,
    "duncanson": 3,
    "dunckel": 2,
    "duncombe": 2,
    "dundas": 2,
    "dundee": 2,
    "dundon": 2,
    "dundore": 2,
    "dune": 1,
    "dunedin": 3,
    "dunegan": 3,
    "dunes": 1,
    "dunfee": 2,
    "dunford": 2,
    "dung": 1,
    "dungan": 2,
    "dungeon": 2,
    "dungeons": 2,
    "dungey": 2,
    "dunham": 2,
    "dunhill": 2,
    "dunigan": 3,
    "dunite": 2,
    "dunivan": 3,
    "dunja": 2,
    "dunja(1)": 2,
    "dunk": 1,
    "dunked": 1,
    "dunkel": 2,
    "dunkelberg": 3,
    "dunkelberger": 4,
    "dunker": 2,
    "dunkerley": 3,
    "dunkin": 2,
    "dunkin'": 2,
    "dunkirk": 2,
    "dunkle": 2,
    "dunkleberger": 4,
    "dunklee": 2,
    "dunkley": 2,
    "dunklin": 2,
    "dunks": 1,
    "dunlaevy": 3,
    "dunlap": 2,
    "dunlavey": 3,
    "dunlavy": 3,
    "dunlay": 2,
    "dunleavy": 3,
    "dunlevy": 3,
    "dunley": 2,
    "dunlop": 2,
    "dunman": 2,
    "dunmire": 3,
    "dunn": 1,
    "dunnagan": 3,
    "dunnam": 2,
    "dunnavant": 3,
    "dunnaway": 3,
    "dunne": 1,
    "dunned": 1,
    "dunnell": 2,
    "dunnett": 2,
    "dunnigan": 3,
    "dunning": 2,
    "dunnington": 3,
    "dunno": 2,
    "dunphy": 2,
    "duns": 1,
    "dunshee": 2,
    "dunsmoor": 2,
    "dunsmore": 2,
    "dunson": 2,
    "dunst": 1,
    "dunstan": 2,
    "dunster": 2,
    "dunston": 2,
    "dunsworth": 2,
    "dunton": 2,
    "dunwoody": 3,
    "dunworth": 2,
    "duo": 2,
    "duodenal": 4,
    "duodenal(1)": 4,
    "duodenum": 4,
    "duong": 2,
    "duopoly": 4,
    "duopoly(1)": 4,
    "dupay": 2,
    "dupe": 1,
    "duped": 1,
    "dupee": 2,
    "duper": 2,
    "dupes": 1,
    "dupin": 2,
    "duplantis": 3,
    "duplechain": 3,
    "duplechin": 3,
    "dupler": 3,
    "dupler(1)": 2,
    "duplessis": 3,
    "duplex": 2,
    "duplicate": 3,
    "duplicate(1)": 3,
    "duplicated": 4,
    "duplicated(1)": 4,
    "duplicates": 3,
    "duplicating": 4,
    "duplication": 4,
    "duplications": 4,
    "duplicative": 4,
    "duplicitous": 4,
    "duplicity": 4,
    "dupont": 2,
    "dupont's": 2,
    "dupras": 2,
    "dupre": 2,
    "dupree": 2,
    "duprey": 2,
    "dupriest": 4,
    "dupriest(1)": 2,
    "dupuis": 2,
    "dupuy": 2,
    "duque": 1,
    "duquesne": 2,
    "duquesne's": 2,
    "duquette": 2,
    "dura": 2,
    "durability": 5,
    "durable": 3,
    "durables": 3,
    "duracell": 3,
    "durakon": 3,
    "durall": 2,
    "duramed": 3,
    "duran": 2,
    "duran's": 2,
    "durand": 2,
    "durando": 3,
    "durang": 2,
    "durango": 3,
    "durant": 2,
    "durant's": 2,
    "durante": 3,
    "duration": 3,
    "durations": 3,
    "duray": 2,
    "durazo": 3,
    "durban": 2,
    "durben": 2,
    "durbin": 2,
    "durch": 1,
    "durchholz": 2,
    "durden": 2,
    "durdin": 2,
    "duree": 2,
    "durell": 2,
    "duren": 2,
    "durenberger": 4,
    "durene": 2,
    "durer": 2,
    "duress": 2,
    "durette": 2,
    "durfee": 2,
    "durfey": 2,
    "durflinger": 4,
    "durflinger(1)": 3,
    "durgan": 2,
    "durgin": 2,
    "durham": 2,
    "durham(1)": 2,
    "durham(2)": 2,
    "duri": 2,
    "durick": 2,
    "durie": 2,
    "during": 2,
    "during(1)": 2,
    "during(2)": 2,
    "durio": 3,
    "duriron": 3,
    "duris": 2,
    "durkee": 2,
    "durkheim": 2,
    "durkheim's": 2,
    "durkin": 2,
    "durland": 2,
    "durley": 2,
    "durling": 2,
    "durn": 1,
    "durnell": 2,
    "durney": 2,
    "durnil": 2,
    "durnin": 2,
    "durning": 2,
    "duro": 2,
    "durocher": 3,
    "duron": 2,
    "duross": 2,
    "durr": 1,
    "durrah": 2,
    "durrance": 2,
    "durrant": 2,
    "durrell": 2,
    "durrence": 2,
    "durrett": 2,
    "durso": 2,
    "durst": 1,
    "durum": 2,
    "durward": 2,
    "durwin": 2,
    "dury": 2,
    "duryea": 3,
    "duryee": 2,
    "dusch": 1,
    "dusch(1)": 1,
    "dusek": 2,
    "dusenberry": 4,
    "dusenbery": 4,
    "dusenbury": 4,
    "dusett": 2,
    "dush": 1,
    "dush(1)": 1,
    "dushane": 2,
    "dushyanth": 3,
    "dusing": 2,
    "dusk": 1,
    "duskin": 2,
    "dussault": 2,
    "dusseau": 2,
    "dusseault": 2,
    "dusseldorf": 3,
    "dust": 1,
    "dustbin": 2,
    "dusted": 2,
    "duster": 2,
    "dusters": 2,
    "dustin": 2,
    "dusting": 2,
    "dustman": 2,
    "duston": 2,
    "dusts": 1,
    "dusty": 2,
    "dusza": 2,
    "duszynski": 3,
    "dutch": 1,
    "dutcher": 2,
    "dutchman": 2,
    "duthie": 2,
    "duties": 2,
    "dutiful": 3,
    "dutifully": 4,
    "dutil": 2,
    "dutka": 2,
    "dutkiewicz": 3,
    "dutko": 2,
    "dutoit": 2,
    "dutra": 2,
    "dutro": 2,
    "dutrow": 2,
    "dutson": 2,
    "dutt": 1,
    "dutter": 2,
    "dutton": 2,
    "duty": 2,
    "duty(1)": 2,
    "duva": 2,
    "duval": 2,
    "duvalier": 3,
    "duvaliers": 3,
    "duvall": 2,
    "duve": 1,
    "duvernay": 3,
    "duvrees": 2,
    "duwayne": 2,
    "duwe": 1,
    "dux": 1,
    "duzan": 2,
    "dvd": 3,
    "dvoracek": 3,
    "dvorak": 2,
    "dvorsky": 2,
    "dwan": 1,
    "dwana": 2,
    "dwarf": 1,
    "dwarfed": 1,
    "dwarfing": 2,
    "dwarfism": 3,
    "dwarfs": 1,
    "dwarves": 1,
    "dwayne": 1,
    "dweck": 1,
    "dweeb": 1,
    "dwell": 1,
    "dwelle": 1,
    "dwelled": 1,
    "dweller": 2,
    "dwellers": 2,
    "dwelley": 2,
    "dwelling": 2,
    "dwellings": 2,
    "dwells": 1,
    "dwelt": 1,
    "dwi": 5,
    "dwi(1)": 5,
    "dwiggins": 2,
    "dwight": 1,
    "dwindle": 2,
    "dwindled": 2,
    "dwindles": 2,
    "dwindling": 3,
    "dwindling(1)": 2,
    "dwinell": 2,
    "dwire": 1,
    "dwivedi": 3,
    "dworak": 2,
    "dworin": 2,
    "dworkin": 2,
    "dworsky": 2,
    "dwyer": 2,
    "dyad": 2,
    "dyal": 2,
    "dyan": 2,
    "dyana": 3,
    "dyane": 2,
    "dyansen": 3,
    "dyar": 2,
    "dyas": 2,
    "dyatron": 3,
    "dyazide": 3,
    "dybas": 2,
    "dyce": 1,
    "dyche": 1,
    "dyches": 2,
    "dyck": 1,
    "dyckman": 2,
    "dyco": 2,
    "dycus": 2,
    "dye": 1,
    "dyed": 1,
    "dyeing": 2,
    "dyer": 2,
    "dyes": 1,
    "dyess": 2,
    "dyestuff": 2,
    "dyestuffs": 2,
    "dygert": 2,
    "dying": 2,
    "dyk": 1,
    "dykas": 2,
    "dyke": 1,
    "dykeman": 2,
    "dykes": 1,
    "dykhouse": 2,
    "dykman": 2,
    "dykstra": 2,
    "dylan": 2,
    "dylan's": 2,
    "dylans": 2,
    "dylewski": 3,
    "dylex": 2,
    "dyloptisaurus": 5,
    "dymally": 3,
    "dymek": 2,
    "dyment": 2,
    "dymond": 2,
    "dynafac": 3,
    "dynalectric": 4,
    "dynalectron": 4,
    "dynamic": 3,
    "dynamics": 3,
    "dynamics'": 3,
    "dynamics'(1)": 3,
    "dynamics's": 4,
    "dynamism": 4,
    "dynamite": 3,
    "dynamo": 3,
    "dynamometer": 5,
    "dynapac": 3,
    "dynascan": 3,
    "dynastic": 3,
    "dynasties": 3,
    "dynasty": 3,
    "dynatech": 3,
    "dyncorp": 2,
    "dyncorp(1)": 2,
    "dyneer": 2,
    "dyneer(1)": 2,
    "dynes": 1,
    "dysan": 2,
    "dysart": 2,
    "dysentery": 4,
    "dysert": 2,
    "dysfunction": 3,
    "dysfunctional": 4,
    "dysfunctions": 3,
    "dysinger": 3,
    "dyslexia": 4,
    "dyslexic": 3,
    "dyson": 2,
    "dyspeptic": 3,
    "dysphoric": 3,
    "dysplasia": 3,
    "dyspnea": 3,
    "dystrophin": 3,
    "dystrophy": 3,
    "dzerzhinsk": 2,
    "dzhambul": 2,
    "dzhirkvelov": 3,
    "dzhokhar": 2,
    "dzhokhar's": 2,
    "dziak": 2,
    "dzialo": 3,
    "dziedzic": 2,
    "dziekan": 2,
    "dzik": 1,
    "dzikowski": 3,
    "dziuba": 3,
    "dziuk": 2,
    "dzokhar": 2,
    "e": 1,
    "e's": 1,
    "e.": 1,
    "e.'s": 1,
    "e.s": 1,
    "each": 1,
    "eachan": 2,
    "eachus": 2,
    "eaddy": 2,
    "eade": 1,
    "eader": 2,
    "eades": 1,
    "eadie": 2,
    "eads": 1,
    "eads'": 1,
    "eady": 2,
    "eagan": 2,
    "eagar": 2,
    "eagen": 2,
    "eager": 2,
    "eagerly": 3,
    "eagerness": 3,
    "eagle": 2,
    "eagle's": 2,
    "eagleburger": 4,
    "eagles": 2,
    "eagleson": 3,
    "eagleton": 3,
    "eagleye": 3,
    "eaglin": 2,
    "eagon": 2,
    "eaken": 2,
    "eaker": 2,
    "eakes": 1,
    "eakin": 2,
    "eakins": 2,
    "eakle": 2,
    "eales": 1,
    "ealey": 2,
    "ealing": 2,
    "ealy": 2,
    "eamer": 2,
    "eames": 1,
    "eamon": 2,
    "eanes": 1,
    "eap": 3,
    "eap(1)": 1,
    "eappen": 2,
    "ear": 1,
    "ear(1)": 1,
    "eardley": 2,
    "eardley(1)": 2,
    "eared": 1,
    "earfull": 2,
    "eargle": 2,
    "earhart": 2,
    "earhart(1)": 2,
    "earl": 1,
    "earl's": 1,
    "earldom": 2,
    "earle": 1,
    "earlene": 2,
    "earles": 1,
    "earless": 2,
    "earless(1)": 2,
    "earley": 2,
    "earlie": 2,
    "earlier": 3,
    "earlier's": 3,
    "earliest": 3,
    "earline": 2,
    "earll": 1,
    "earls": 1,
    "early": 2,
    "earlywine": 3,
    "earmark": 2,
    "earmark(1)": 2,
    "earmarked": 2,
    "earmarked(1)": 2,
    "earmarking": 3,
    "earmarking(1)": 3,
    "earmarks": 2,
    "earmarks(1)": 2,
    "earmuff": 2,
    "earmuff(1)": 2,
    "earmuffs": 2,
    "earmuffs(1)": 2,
    "earn": 1,
    "earned": 1,
    "earner": 2,
    "earners": 2,
    "earnest": 2,
    "earnestly": 3,
    "earnestness": 3,
    "earney": 2,
    "earnhardt": 2,
    "earnhart": 2,
    "earnheart": 2,
    "earning": 2,
    "earnings": 2,
    "earnings'": 2,
    "earns": 1,
    "earnshaw": 2,
    "earp": 1,
    "earphone": 2,
    "earphone(1)": 2,
    "earphones": 2,
    "earphones(1)": 2,
    "earpiece": 2,
    "earpiece(1)": 2,
    "earpieces": 3,
    "earpieces(1)": 3,
    "earplug": 2,
    "earplug(1)": 2,
    "earplugs": 2,
    "earplugs(1)": 2,
    "earring": 2,
    "earring(1)": 2,
    "earrings": 2,
    "earrings(1)": 2,
    "ears": 1,
    "ears(1)": 1,
    "earshot": 2,
    "earshot(1)": 2,
    "earth": 1,
    "earth's": 1,
    "eartha": 2,
    "earthbound": 2,
    "earthen": 2,
    "earthenware": 3,
    "earthling": 2,
    "earthlings": 2,
    "earthly": 2,
    "earthmoving": 3,
    "earthquake": 2,
    "earthquake's": 2,
    "earthquakes": 2,
    "earths": 1,
    "earthshaking": 3,
    "earthshine": 2,
    "earthstar": 2,
    "earthwork": 2,
    "earthworm": 2,
    "earthworms": 2,
    "earthy": 2,
    "earvin": 2,
    "earwax": 2,
    "earwax(1)": 2,
    "earwood": 2,
    "earwood(1)": 2,
    "eary": 2,
    "easco": 2,
    "ease": 1,
    "eased": 1,
    "easel": 2,
    "easement": 2,
    "eases": 2,
    "eash": 1,
    "easib": 2,
    "easier": 3,
    "easiest": 3,
    "easily": 3,
    "easing": 2,
    "easler": 2,
    "easley": 2,
    "easom": 2,
    "eason": 2,
    "east": 1,
    "east's": 1,
    "eastbound": 2,
    "eastburn": 2,
    "eastdil": 2,
    "eastend": 2,
    "eastender": 3,
    "eastenders": 3,
    "eastep": 2,
    "easter": 2,
    "easterbrook": 3,
    "easterday": 3,
    "easterlin": 3,
    "easterlin(1)": 3,
    "easterling": 3,
    "easterly": 3,
    "eastern": 2,
    "eastern's": 2,
    "eastern-west": 3,
    "easterner": 3,
    "easterners": 3,
    "easterwood": 3,
    "eastes": 1,
    "eastgroup": 2,
    "eastham": 2,
    "eastin": 2,
    "eastland": 2,
    "eastland(1)": 2,
    "eastland(2)": 2,
    "eastland(3)": 2,
    "eastland's": 2,
    "eastland's(1)": 2,
    "eastland's(2)": 2,
    "eastland's(3)": 2,
    "eastlick": 2,
    "eastman": 2,
    "eastmet": 2,
    "eastmet's": 2,
    "easton": 2,
    "eastover": 3,
    "eastpac": 2,
    "eastpac's": 2,
    "eastridge": 2,
    "eastward": 2,
    "eastwick": 2,
    "eastwind": 2,
    "eastwood": 2,
    "eastwood's": 2,
    "easudes": 3,
    "easy": 2,
    "easy's": 2,
    "easygoing": 4,
    "eat": 1,
    "eatable": 3,
    "eaten": 2,
    "eater": 2,
    "eateries": 3,
    "eaters": 2,
    "eatery": 3,
    "eatherly": 3,
    "eatherton": 3,
    "eatherton(1)": 3,
    "eating": 2,
    "eatman": 2,
    "eatmon": 2,
    "eaton": 2,
    "eaton's": 2,
    "eats": 1,
    "eau": 1,
    "eau-claire": 2,
    "eaux": 1,
    "eaux(1)": 1,
    "eave": 1,
    "eavenson": 3,
    "eaves": 1,
    "eavesdrop": 2,
    "eavesdropping": 3,
    "eb": 1,
    "eba": 2,
    "eban": 2,
    "eban(1)": 2,
    "ebanks": 2,
    "ebano": 3,
    "ebano(1)": 3,
    "ebarb": 2,
    "ebasco": 3,
    "ebaugh": 2,
    "ebb": 1,
    "ebba": 2,
    "ebbed": 2,
    "ebben": 2,
    "ebbers": 2,
    "ebbert": 2,
    "ebbing": 2,
    "ebbs": 1,
    "ebby": 2,
    "ebel": 2,
    "ebeling": 3,
    "eben": 2,
    "ebeneezer": 4,
    "ebenezer": 4,
    "eber": 2,
    "eberhard": 3,
    "eberhardt": 3,
    "eberhart": 3,
    "eberl": 2,
    "eberle": 3,
    "eberlein": 3,
    "eberlin": 3,
    "eberling": 3,
    "eberly": 3,
    "ebers": 2,
    "ebersol": 3,
    "ebersold": 3,
    "ebersole": 3,
    "eberstadt": 3,
    "ebert": 2,
    "eberts": 2,
    "eberwein": 3,
    "ebey": 2,
    "ebinger": 3,
    "eble": 2,
    "eblen": 3,
    "eblin": 2,
    "ebling": 3,
    "ebling(1)": 2,
    "ebner": 2,
    "ebola": 3,
    "ebonic": 3,
    "ebonics": 3,
    "ebony": 3,
    "ebright": 2,
    "ebro": 2,
    "ebron": 2,
    "ebullience": 3,
    "ebullient": 3,
    "eby": 2,
    "ecad": 2,
    "eccentric": 3,
    "eccentric(1)": 3,
    "eccentricities": 5,
    "eccentricity": 5,
    "eccentrics": 3,
    "eccentrics(1)": 3,
    "eccles": 2,
    "ecclesiastic": 5,
    "ecclesiastical": 6,
    "eccleston": 3,
    "ecevit": 3,
    "echard": 2,
    "echavarria": 5,
    "echelon": 3,
    "echelons": 3,
    "echemende": 3,
    "echenberg": 3,
    "echevarria": 5,
    "echeverria": 5,
    "echidna": 3,
    "echinacea": 5,
    "echlin": 2,
    "echlin's": 2,
    "echo": 2,
    "echo's": 2,
    "echoed": 2,
    "echoes": 2,
    "echograph": 3,
    "echography": 4,
    "echohawk": 3,
    "echohawk's": 3,
    "echoing": 3,
    "echolocation": 5,
    "echols": 2,
    "echos": 2,
    "eck": 1,
    "eckard": 2,
    "eckard(1)": 2,
    "eckardt": 2,
    "eckardt(1)": 2,
    "eckardt's": 2,
    "eckardt's(1)": 2,
    "eckart": 2,
    "eckberg": 2,
    "eckel": 2,
    "eckelberry": 4,
    "eckels": 2,
    "eckenfelder": 4,
    "eckenrod": 3,
    "eckenrode": 3,
    "eckenroth": 3,
    "ecker": 2,
    "eckerd": 2,
    "eckerle": 3,
    "eckerman": 3,
    "eckersley": 3,
    "eckerson": 3,
    "eckert": 2,
    "eckert's": 2,
    "eckes": 1,
    "eckford": 2,
    "eckhard": 2,
    "eckhardt": 2,
    "eckhart": 2,
    "eckhoff": 2,
    "eckl": 2,
    "eckland": 2,
    "eckler": 2,
    "eckles": 2,
    "eckley": 2,
    "ecklund": 2,
    "eckman": 2,
    "eckmann": 2,
    "eckrich": 2,
    "eckrote": 2,
    "eckroth": 2,
    "eckstein": 2,
    "eckstein(1)": 2,
    "eckstrom": 2,
    "eclectic": 3,
    "eclipse": 2,
    "eclipse(1)": 2,
    "eclipse(2)": 2,
    "eclipsed": 2,
    "eclipsed(1)": 2,
    "eclipsed(2)": 2,
    "eclipses": 3,
    "eclipses(1)": 3,
    "eclipsing": 3,
    "eclipsing(1)": 3,
    "eclipsing(2)": 3,
    "ecliptic": 3,
    "eco": 2,
    "eco(1)": 2,
    "ecogen": 3,
    "ecolab": 3,
    "ecolab(1)": 3,
    "ecolaire": 3,
    "ecole": 2,
    "ecological": 5,
    "ecological(1)": 5,
    "ecologically": 5,
    "ecologically(1)": 5,
    "ecologist": 4,
    "ecologist(1)": 4,
    "ecologists": 4,
    "ecologists(1)": 4,
    "ecologists(2)": 4,
    "ecologists(3)": 4,
    "ecology": 4,
    "ecology(1)": 4,
    "econ": 2,
    "econocom": 4,
    "econoline": 4,
    "econometric": 5,
    "econometrics": 5,
    "economic": 4,
    "economic(1)": 4,
    "economical": 5,
    "economical(1)": 5,
    "economically": 5,
    "economically(1)": 5,
    "economico": 5,
    "economics": 4,
    "economics(1)": 4,
    "economies": 4,
    "economies(1)": 4,
    "economist": 4,
    "economist(1)": 4,
    "economist's": 4,
    "economist's(1)": 4,
    "economist's(2)": 4,
    "economist's(3)": 4,
    "economists": 4,
    "economists(1)": 4,
    "economists(2)": 4,
    "economists'": 4,
    "economists'(1)": 4,
    "economize": 4,
    "economize(1)": 4,
    "economizes": 5,
    "economizes(1)": 5,
    "economizing": 5,
    "economizing(1)": 5,
    "economos": 4,
    "economou": 4,
    "economy": 4,
    "economy(1)": 4,
    "economy's": 4,
    "economy's(1)": 4,
    "econships": 3,
    "ecosystem": 4,
    "ecosystems": 4,
    "ecru": 2,
    "ecstasy": 3,
    "ecstatic": 3,
    "ecstatically": 4,
    "ecton": 2,
    "ector": 2,
    "ecuador": 3,
    "ecuador's": 3,
    "ecuadoran": 4,
    "ecuadorean": 5,
    "ecuadorian": 5,
    "ecumena": 4,
    "ecumenical": 5,
    "eczema": 3,
    "ed": 1,
    "ed's": 1,
    "eda": 2,
    "edam": 2,
    "edan": 2,
    "edana": 3,
    "edberg": 2,
    "edbert": 2,
    "eddie": 2,
    "eddie's": 2,
    "eddies": 2,
    "eddinger": 3,
    "eddings": 2,
    "eddington": 3,
    "eddins": 2,
    "eddleman": 3,
    "eddlemon": 3,
    "edds": 1,
    "eddy": 2,
    "ede": 1,
    "edel": 2,
    "edelen": 3,
    "edeline": 3,
    "edell": 2,
    "edelman": 3,
    "edelman(1)": 3,
    "edelman's": 3,
    "edelman's(1)": 3,
    "edelmann": 3,
    "edelmar": 3,
    "edelson": 3,
    "edelstein": 3,
    "edelstein(1)": 3,
    "edelweiss": 3,
    "edema": 3,
    "eden": 2,
    "edenfield": 3,
    "edens": 2,
    "edenton": 3,
    "eder": 2,
    "ederer": 3,
    "edes": 1,
    "edgar": 2,
    "edgar's": 2,
    "edgcomb": 2,
    "edge": 1,
    "edgecomb": 2,
    "edgecombe": 2,
    "edged": 1,
    "edgell": 2,
    "edgemon": 2,
    "edger": 2,
    "edgerly": 3,
    "edgerton": 3,
    "edges": 2,
    "edges(1)": 2,
    "edgett": 2,
    "edgeway": 2,
    "edgeways": 2,
    "edgewise": 2,
    "edgewood": 2,
    "edgeworth": 2,
    "edgin": 2,
    "edginess": 3,
    "edging": 2,
    "edgington": 3,
    "edgington's": 3,
    "edgley": 2,
    "edgmon": 2,
    "edgren": 2,
    "edgy": 2,
    "edi": 2,
    "edible": 3,
    "edibles": 3,
    "edick": 2,
    "edict": 2,
    "edicts": 2,
    "edie": 2,
    "edification": 5,
    "edifice": 3,
    "edify": 3,
    "edifying": 4,
    "ediger": 3,
    "edin": 2,
    "edina": 3,
    "edinboro": 4,
    "edinburgh": 4,
    "edinger": 3,
    "edington": 3,
    "edison": 3,
    "edison's": 3,
    "edisons": 3,
    "edisto": 3,
    "edit": 2,
    "edited": 3,
    "edited(1)": 3,
    "edith": 2,
    "editha": 3,
    "edithe": 2,
    "editing": 3,
    "editing(1)": 3,
    "edition": 3,
    "edition(1)": 3,
    "edition's": 3,
    "editions": 3,
    "editor": 3,
    "editor(1)": 3,
    "editor's": 3,
    "editorial": 5,
    "editorial's": 5,
    "editorialist": 6,
    "editorialists": 6,
    "editorialize": 6,
    "editorialized": 6,
    "editorializing": 7,
    "editorially": 6,
    "editorials": 5,
    "editors": 3,
    "editors'": 3,
    "editorship": 4,
    "edits": 2,
    "ediva": 3,
    "edival": 3,
    "edival(1)": 3,
    "edizione": 5,
    "edleman": 3,
    "edler": 2,
    "edley": 2,
    "edlin": 2,
    "edling": 2,
    "edlund": 2,
    "edlyn": 2,
    "edman": 2,
    "edmands": 2,
    "edmar": 2,
    "edmark": 2,
    "edminster": 3,
    "edmison": 3,
    "edmisten": 3,
    "edmister": 3,
    "edmiston": 3,
    "edmond": 2,
    "edmonda": 3,
    "edmonds": 2,
    "edmondson": 3,
    "edmonson": 3,
    "edmonston": 3,
    "edmonton": 3,
    "edmund": 2,
    "edmunda": 3,
    "edmundo": 3,
    "edmunds": 2,
    "edmundson": 3,
    "edna": 2,
    "edney": 2,
    "edo": 2,
    "edoardo": 3,
    "edolf": 2,
    "edouard": 3,
    "edper": 2,
    "edquist": 2,
    "edra": 2,
    "edrea": 3,
    "edric": 2,
    "edrington": 4,
    "edris": 2,
    "edsall": 2,
    "edsel": 2,
    "edson": 2,
    "edstrom": 2,
    "edu": 2,
    "edu(1)": 3,
    "eduard": 2,
    "eduardo": 3,
    "educate": 3,
    "educate(1)": 3,
    "educated": 4,
    "educated(1)": 4,
    "educates": 3,
    "educates(1)": 3,
    "educates(2)": 3,
    "educates(3)": 3,
    "educating": 4,
    "educating(1)": 4,
    "education": 4,
    "education(1)": 4,
    "education's": 4,
    "education's(1)": 4,
    "educational": 5,
    "educational(1)": 5,
    "educationally": 6,
    "educationally(1)": 5,
    "educationally(2)": 6,
    "educationally(3)": 5,
    "educations": 4,
    "educations(1)": 4,
    "educator": 4,
    "educator(1)": 4,
    "educators": 4,
    "educators(1)": 4,
    "edwald": 2,
    "edward": 2,
    "edward's": 2,
    "edwardian": 4,
    "edwardine": 3,
    "edwards": 2,
    "edwards'": 2,
    "edwards's": 3,
    "edwardson": 3,
    "edwin": 2,
    "edwin(1)": 2,
    "edwina": 3,
    "edye": 2,
    "edye(1)": 2,
    "edyth": 2,
    "edythe": 2,
    "edzard": 2,
    "ee": 1,
    "eeg": 1,
    "eel": 1,
    "eelam": 2,
    "eelgrass": 2,
    "eellike": 2,
    "eelpout": 2,
    "eelpouts": 2,
    "eels": 1,
    "eeo": 3,
    "eerie": 2,
    "eerily": 3,
    "efaw": 2,
    "efecto": 3,
    "efface": 2,
    "effacing": 3,
    "effect": 2,
    "effect(1)": 2,
    "effect(2)": 2,
    "effected": 3,
    "effected(1)": 3,
    "effected(2)": 3,
    "effected(3)": 3,
    "effecting": 3,
    "effecting(1)": 3,
    "effective": 3,
    "effective(1)": 3,
    "effectively": 4,
    "effectively(1)": 4,
    "effectiveness": 4,
    "effectiveness(1)": 4,
    "effects": 2,
    "effects(1)": 2,
    "effects(2)": 2,
    "effects(3)": 2,
    "effectuate": 4,
    "effeminate": 4,
    "efferent": 3,
    "efferson": 3,
    "effertz": 2,
    "effervescent": 4,
    "effete": 2,
    "efficacious": 4,
    "efficacy": 4,
    "efficiencies": 4,
    "efficiency": 4,
    "efficient": 3,
    "efficiently": 4,
    "effie": 2,
    "effigy": 3,
    "effinger": 3,
    "effingham": 3,
    "effingham(1)": 3,
    "effler": 2,
    "effluence": 3,
    "effluent": 3,
    "efflux": 2,
    "effort": 2,
    "effortless": 3,
    "effortlessly": 4,
    "efforts": 2,
    "effron": 2,
    "effrontery": 4,
    "effusive": 3,
    "effusively": 4,
    "effy": 2,
    "efird": 2,
    "efron": 2,
    "efta": 2,
    "egaldey": 3,
    "egalitarian": 6,
    "egalitarianism": 8,
    "egan": 2,
    "egbert": 2,
    "egberta": 3,
    "egbertina": 4,
    "egbertine": 3,
    "egberts": 2,
    "ege": 1,
    "egeland": 3,
    "egeler": 3,
    "egelhoff": 3,
    "egelston": 3,
    "egelton": 3,
    "eger": 2,
    "egerer": 3,
    "egert": 2,
    "egerton": 3,
    "egg": 1,
    "eggcup": 2,
    "eggcups": 2,
    "egge": 1,
    "eggebrecht": 3,
    "egged": 1,
    "eggemeyer": 4,
    "eggen": 2,
    "eggenberger": 4,
    "egger": 2,
    "eggers": 2,
    "eggert": 2,
    "egghead": 2,
    "egghead's": 2,
    "eggheads": 2,
    "egging": 2,
    "eggleston": 3,
    "eggleton": 3,
    "eggnog": 2,
    "eggnogs": 2,
    "eggplant": 2,
    "eggplants": 2,
    "eggs": 1,
    "eggshape": 2,
    "eggshaped": 2,
    "eggshell": 2,
    "eggshells": 2,
    "eggum": 2,
    "egland": 2,
    "eglantine": 3,
    "egle": 2,
    "egler": 2,
    "egleston": 3,
    "egley": 2,
    "egli": 2,
    "eglin": 2,
    "eglise": 2,
    "egloff": 2,
    "egly": 2,
    "egner": 2,
    "egnew": 2,
    "egnor": 2,
    "ego": 2,
    "egocentric": 4,
    "egoism": 4,
    "egolf": 2,
    "egomaniac": 5,
    "egon": 2,
    "egon(1)": 2,
    "egos": 2,
    "egotism": 4,
    "egotist": 3,
    "egotistical": 5,
    "egregious": 3,
    "egregiously": 4,
    "egress": 2,
    "egret": 2,
    "egypt": 2,
    "egypt(1)": 2,
    "egypt's": 2,
    "egypt's(1)": 2,
    "egyptair": 3,
    "egyptian": 3,
    "egyptians": 3,
    "egyptology": 5,
    "eh": 1,
    "ehinger": 3,
    "ehle": 1,
    "ehlen": 2,
    "ehler": 2,
    "ehlers": 2,
    "ehlert": 2,
    "ehlinger": 3,
    "ehlke": 1,
    "ehlmann": 2,
    "ehly": 2,
    "ehman": 2,
    "ehmann": 2,
    "ehmen": 2,
    "ehmke": 2,
    "ehren": 2,
    "ehrenberg": 3,
    "ehrenfeld": 3,
    "ehrenhalt": 3,
    "ehrenkrantz": 3,
    "ehrenreich": 3,
    "ehrenreich(1)": 3,
    "ehresman": 3,
    "ehret": 2,
    "ehrhard": 2,
    "ehrhardt": 2,
    "ehrhart": 2,
    "ehrich": 2,
    "ehrig": 2,
    "ehrke": 1,
    "ehrler": 2,
    "ehrlich": 2,
    "ehrlich's": 2,
    "ehrlichman": 3,
    "ehrman": 2,
    "ehrmann": 2,
    "ehrsam": 2,
    "ehud": 2,
    "eiben": 2,
    "eich": 1,
    "eichberg": 2,
    "eichel": 2,
    "eichelberger": 4,
    "eichen": 2,
    "eichenbaum": 3,
    "eichenberg": 3,
    "eichenberger": 4,
    "eichenlaub": 3,
    "eicher": 2,
    "eichholz": 2,
    "eichhorn": 2,
    "eichhorst": 2,
    "eichinger": 3,
    "eichler": 3,
    "eichler(1)": 2,
    "eichman": 2,
    "eichmann": 2,
    "eichner": 2,
    "eicholtz": 2,
    "eichorn": 2,
    "eichorst": 2,
    "eichstadt": 2,
    "eichstaedt": 2,
    "eick": 1,
    "eickhoff": 2,
    "eickholt": 2,
    "eickmeyer": 3,
    "eid": 1,
    "eide": 1,
    "eidem": 2,
    "eiden": 2,
    "eidson": 2,
    "eiermann": 2,
    "eifert": 2,
    "eiffel": 2,
    "eifler": 3,
    "eifler(1)": 2,
    "eigen": 2,
    "eigenvalue": 4,
    "eigenvalues": 4,
    "eighmey": 2,
    "eighmy": 2,
    "eight": 1,
    "eight's": 1,
    "eighteen": 2,
    "eighteen(1)": 2,
    "eighteen's": 2,
    "eighteens": 2,
    "eighteenth": 2,
    "eighteenth(1)": 2,
    "eightfold": 2,
    "eighth": 1,
    "eighth(1)": 1,
    "eighths": 1,
    "eighties": 2,
    "eightieth": 3,
    "eights": 1,
    "eighty": 2,
    "eighty's": 2,
    "eigner": 2,
    "eiichi": 3,
    "eiji": 2,
    "eike": 1,
    "eikenberry": 4,
    "eilan": 2,
    "eiland": 2,
    "eileen": 2,
    "eiler": 2,
    "eilerman": 3,
    "eilers": 2,
    "eilert": 2,
    "eiley": 2,
    "eilts": 1,
    "eimer": 2,
    "eimers": 2,
    "ein": 1,
    "einar": 2,
    "einbender": 3,
    "eindhoven": 3,
    "einhorn": 2,
    "einon": 2,
    "einon's": 2,
    "einspahr": 2,
    "einstein": 2,
    "einstein's": 2,
    "eir": 1,
    "eirena": 3,
    "eirich": 2,
    "eis": 1,
    "eisa": 2,
    "eisai": 2,
    "eisaman": 3,
    "eischeid": 2,
    "eischen": 2,
    "eischens": 2,
    "eisel": 2,
    "eisele": 2,
    "eiseman": 2,
    "eisemann": 2,
    "eisen": 2,
    "eisenach": 3,
    "eisenbach": 3,
    "eisenbarth": 3,
    "eisenbeis": 3,
    "eisenberg": 3,
    "eisenberger": 4,
    "eisenbraun": 3,
    "eisenhardt": 3,
    "eisenhart": 3,
    "eisenhauer": 4,
    "eisenhour": 3,
    "eisenhower": 4,
    "eisenhower's": 4,
    "eisenhowers": 4,
    "eisenhut": 3,
    "eisenhuth": 3,
    "eisenman": 3,
    "eisenmann": 3,
    "eisenmenger": 4,
    "eisenstadt": 3,
    "eisenstein": 3,
    "eisenstein(1)": 3,
    "eiserman": 3,
    "eisert": 2,
    "eishi": 2,
    "eisin": 2,
    "eisinger": 3,
    "eisler": 2,
    "eisman": 2,
    "eisner": 2,
    "eisner's": 2,
    "eison": 2,
    "eissler": 3,
    "eissler(1)": 2,
    "eiszner": 2,
    "eitel": 2,
    "either": 2,
    "either(1)": 2,
    "eitzen": 2,
    "eizenstat": 3,
    "ejaculate": 4,
    "ejaculation": 5,
    "eject": 2,
    "ejected": 3,
    "ejecting": 3,
    "ejection": 3,
    "ejects": 2,
    "ejects(1)": 2,
    "ejup": 2,
    "ejup(1)": 2,
    "ejup's": 2,
    "ejup's(1)": 2,
    "ek": 1,
    "ek(1)": 2,
    "eka": 2,
    "ekaterina": 5,
    "ekberg": 2,
    "ekblad": 2,
    "ekco": 2,
    "ekdahl": 2,
    "eke": 1,
    "eked": 1,
    "ekern": 2,
    "ekeus": 2,
    "ekholm": 2,
    "eking": 2,
    "ekins": 2,
    "ekk": 3,
    "ekkehard": 2,
    "eklund": 2,
    "ekman": 2,
    "eko": 2,
    "ekofisk": 3,
    "eksportfinans": 4,
    "ekstrand": 2,
    "ekstrom": 2,
    "el": 1,
    "el-al": 2,
    "el-greco": 3,
    "el-nino": 3,
    "el-paso": 3,
    "el-salvador": 4,
    "ela": 2,
    "elaborate": 3,
    "elaborate(1)": 4,
    "elaborated": 5,
    "elaborately": 4,
    "elaborates": 4,
    "elaborating": 5,
    "elaboration": 5,
    "elaina": 3,
    "elaine": 2,
    "elaine(1)": 2,
    "elaine(2)": 2,
    "elaine's": 2,
    "elaine's(1)": 2,
    "elaine's(2)": 2,
    "elaire": 2,
    "elam": 2,
    "elamin": 3,
    "elan": 2,
    "eland": 2,
    "elane": 2,
    "elapse": 2,
    "elapsed": 2,
    "elardo": 3,
    "elastic": 3,
    "elasticity": 5,
    "elastomer": 4,
    "elastomers": 4,
    "elat": 2,
    "elata": 3,
    "elate": 2,
    "elated": 3,
    "elated(1)": 3,
    "elater": 3,
    "elater(1)": 3,
    "elaters": 3,
    "elaters(1)": 3,
    "elates": 2,
    "elating": 3,
    "elation": 3,
    "elayne": 2,
    "elbaum": 2,
    "elbe": 1,
    "elber": 2,
    "elberson": 3,
    "elbert": 2,
    "elberta": 3,
    "elbertine": 3,
    "elbow": 2,
    "elbowed": 2,
    "elbowing": 3,
    "elbowroom": 3,
    "elbows": 2,
    "elbrick": 2,
    "elbrick's": 2,
    "elbrus": 2,
    "elchibey": 3,
    "elco": 2,
    "elcock": 2,
    "elcor": 2,
    "elcotel": 3,
    "eldar": 2,
    "elden": 2,
    "elder": 2,
    "elderkin": 3,
    "elderly": 3,
    "elderly's": 3,
    "elders": 2,
    "elders'": 2,
    "elders's": 3,
    "eldest": 2,
    "eldin": 2,
    "eldon": 2,
    "eldora": 3,
    "eldorado": 4,
    "eldorado's": 4,
    "eldred": 2,
    "eldredge": 2,
    "eldreth": 2,
    "eldric": 2,
    "eldrida": 3,
    "eldridge": 2,
    "eldritch": 2,
    "eldwin": 2,
    "eleanor": 3,
    "eleanor(1)": 3,
    "eleanor's": 3,
    "eleanor's(1)": 3,
    "eleanora": 4,
    "eleanore": 3,
    "eleazer": 3,
    "elect": 2,
    "elect's": 2,
    "electability": 6,
    "electable": 4,
    "elected": 3,
    "elected(1)": 3,
    "electing": 3,
    "election": 3,
    "election's": 3,
    "electioneer": 4,
    "electioneering": 5,
    "electioneers": 4,
    "elections": 3,
    "elective": 3,
    "electives": 3,
    "electoral": 4,
    "electorate": 4,
    "electorate(1)": 3,
    "electorate's": 4,
    "electorates": 4,
    "electors": 3,
    "electra": 3,
    "electric": 3,
    "electric's": 3,
    "electrical": 4,
    "electrically": 5,
    "electrically(1)": 4,
    "electricals": 4,
    "electricar": 4,
    "electrician": 4,
    "electricians": 4,
    "electricians'": 4,
    "electricite": 5,
    "electricity": 5,
    "electrics": 3,
    "electrification": 6,
    "electrified": 4,
    "electrifies": 4,
    "electrify": 4,
    "electrifying": 5,
    "electrique": 3,
    "electro": 3,
    "electrobiology": 7,
    "electrobiology's": 7,
    "electrocardiogram": 7,
    "electrocardiograms": 7,
    "electrochemical": 6,
    "electrocom": 4,
    "electrocute": 4,
    "electrocuted": 5,
    "electrocution": 5,
    "electrocutions": 5,
    "electrode": 3,
    "electrodes": 3,
    "electrodynamic": 6,
    "electrodynamics": 6,
    "electrolux": 4,
    "electrolysis": 5,
    "electrolytic": 5,
    "electromagnet": 5,
    "electromagnetic": 6,
    "electromagnetism": 7,
    "electromagnets": 5,
    "electromechanical": 7,
    "electromedics": 5,
    "electron": 3,
    "electronic": 4,
    "electronically": 6,
    "electronically(1)": 5,
    "electronics": 4,
    "electronics'": 4,
    "electrons": 3,
    "electrophoresis": 6,
    "electrophoresis(1)": 6,
    "electrophoretogram": 7,
    "electroplate": 4,
    "electroplating": 5,
    "electroshock": 4,
    "electrosound": 4,
    "electrospace": 4,
    "electrospray": 4,
    "electrostatic": 5,
    "elects": 2,
    "eledge": 2,
    "eleen": 2,
    "elefante": 4,
    "elegance": 3,
    "elegant": 3,
    "elegantly": 4,
    "elegy": 3,
    "elek": 2,
    "elektra": 3,
    "elektrisk": 3,
    "elektrizitaetswerk": 6,
    "elektron": 3,
    "element": 3,
    "elemental": 4,
    "elemental(1)": 4,
    "elementary": 4,
    "elementary(1)": 5,
    "elementary(2)": 4,
    "elements": 3,
    "elena": 3,
    "elena(1)": 3,
    "elenbaas": 3,
    "elene": 2,
    "elenore": 3,
    "eleonore": 5,
    "elephant": 3,
    "elephant's": 3,
    "elephantiasis": 6,
    "elephantine": 4,
    "elephants": 3,
    "elephants'": 3,
    "eletr": 3,
    "eleuthera": 4,
    "elevate": 3,
    "elevated": 4,
    "elevates": 3,
    "elevating": 4,
    "elevation": 4,
    "elevations": 4,
    "elevator": 4,
    "elevators": 4,
    "eleven": 3,
    "eleven(1)": 3,
    "eleven's": 3,
    "eleven's(1)": 3,
    "elevens": 3,
    "elevens(1)": 3,
    "eleventh": 3,
    "eleventh(1)": 3,
    "elexis": 3,
    "eley": 2,
    "elf": 1,
    "elf's": 1,
    "elfers": 2,
    "elfie": 2,
    "elfin": 2,
    "elfish": 2,
    "elfman": 2,
    "elford": 2,
    "elfreda": 3,
    "elfrida": 3,
    "elfrieda": 3,
    "elfrink": 2,
    "elfstrom": 2,
    "elg": 1,
    "elga": 2,
    "elgabrowny": 4,
    "elgar": 2,
    "elgar's": 2,
    "elgart": 2,
    "elger": 2,
    "elgersma": 3,
    "elgie": 2,
    "elgin": 2,
    "eli": 2,
    "elia": 3,
    "eliades": 3,
    "elias": 3,
    "eliason": 4,
    "eliassen": 4,
    "elich": 2,
    "elicit": 3,
    "elicited": 4,
    "eliciting": 4,
    "elicits": 3,
    "elick": 2,
    "elicker": 3,
    "elie": 2,
    "eligaya": 4,
    "eligibility": 6,
    "eligible": 4,
    "eligible(1)": 4,
    "elihu": 3,
    "elijah": 3,
    "elijah(1)": 3,
    "eliminate": 4,
    "eliminated": 5,
    "eliminated(1)": 5,
    "eliminates": 4,
    "eliminating": 5,
    "elimination": 5,
    "eliminations": 5,
    "eline": 2,
    "elinor": 3,
    "elinore": 4,
    "elio": 3,
    "eliopoulos": 5,
    "eliot": 3,
    "eliot's": 3,
    "eliott": 3,
    "elisa": 3,
    "elisa(1)": 3,
    "elisa's": 3,
    "elisa's(1)": 3,
    "elisabeth": 4,
    "elise": 2,
    "elish": 2,
    "elisha": 3,
    "elison": 3,
    "elissa": 3,
    "elite": 2,
    "elite(1)": 2,
    "elites": 2,
    "elites(1)": 2,
    "elitism": 4,
    "elitism(1)": 4,
    "elitist": 3,
    "elitist(1)": 3,
    "elitists": 3,
    "elitists(1)": 3,
    "elixir": 3,
    "eliza": 3,
    "elizabeth": 4,
    "elizabeth(1)": 4,
    "elizabeth's": 4,
    "elizabethan": 5,
    "elizabethtown": 5,
    "elizalde": 4,
    "elizondo": 4,
    "eljer": 2,
    "elk": 1,
    "elkes": 1,
    "elkhart": 2,
    "elkhorn": 2,
    "elkin": 2,
    "elkind": 2,
    "elkind(1)": 2,
    "elkington": 3,
    "elkins": 2,
    "elko": 2,
    "elks": 1,
    "elkton": 2,
    "ell": 1,
    "ella": 2,
    "ella's": 2,
    "ellamay": 3,
    "ellan": 2,
    "ellan's": 2,
    "ellard": 2,
    "elle": 1,
    "elledge": 2,
    "ellefson": 3,
    "ellegood": 3,
    "ellemann": 3,
    "ellen": 2,
    "ellen's": 2,
    "ellena": 3,
    "ellenbecker": 4,
    "ellenberg": 3,
    "ellenberger": 4,
    "ellenbogen": 4,
    "ellenburg": 3,
    "ellender": 3,
    "ellene": 2,
    "ellenpore": 3,
    "ellenson": 3,
    "ellenwood": 3,
    "eller": 2,
    "ellerbe": 2,
    "ellerbee": 3,
    "ellerbrock": 3,
    "ellerby": 3,
    "ellerey": 3,
    "ellerman": 3,
    "ellers": 2,
    "ellert": 2,
    "ellertson": 3,
    "ellery": 3,
    "ellesmere": 2,
    "ellesse": 2,
    "ellestad": 3,
    "ellett": 2,
    "ellette": 2,
    "elley": 2,
    "ellice": 2,
    "ellicott": 3,
    "ellie": 2,
    "elliff": 2,
    "ellijay": 3,
    "elliman": 3,
    "elling": 2,
    "ellinger": 3,
    "ellingsen": 3,
    "ellingson": 3,
    "ellingsworth": 3,
    "ellington": 3,
    "ellington's": 3,
    "ellingwood": 3,
    "ellinwood": 3,
    "ellios": 2,
    "elliot": 3,
    "elliott": 3,
    "elliott's": 3,
    "ellipse": 2,
    "ellipsoid": 3,
    "ellipsoids": 3,
    "elliptical": 4,
    "ellis": 2,
    "ellis's": 3,
    "ellison": 3,
    "ellisor": 3,
    "elliston": 3,
    "ellithorpe": 3,
    "ellman": 2,
    "ellmann": 2,
    "ellner": 2,
    "ellroy": 2,
    "ells": 1,
    "ellsberg": 2,
    "ellsberg's": 2,
    "ellsburg": 2,
    "ellsworth": 2,
    "ellwanger": 3,
    "ellwood": 2,
    "ellwood's": 2,
    "elly": 2,
    "ellyn": 2,
    "ellyson": 3,
    "ellzey": 2,
    "elm": 1,
    "elma": 2,
    "elman": 2,
    "elmendorf": 3,
    "elmer": 2,
    "elmes": 1,
    "elmhurst": 2,
    "elmira": 3,
    "elmo": 2,
    "elmootazbell": 4,
    "elmootazbellah": 5,
    "elmore": 2,
    "elmquist": 2,
    "elms": 1,
    "elmsford": 2,
    "elmwood": 2,
    "elna": 2,
    "elnora": 3,
    "elnore": 2,
    "elnozahy": 4,
    "elocution": 4,
    "elocutions": 4,
    "eloisa": 3,
    "eloise": 2,
    "eloise(1)": 3,
    "elommal": 3,
    "elongate": 3,
    "elongated": 4,
    "elongation": 4,
    "elope": 2,
    "elopes": 2,
    "eloquence": 3,
    "eloquent": 3,
    "eloquently": 4,
    "elouise": 3,
    "eloy": 2,
    "elpers": 2,
    "elrica": 3,
    "elrich": 2,
    "elrick": 2,
    "elrod": 2,
    "elron": 2,
    "elroy": 2,
    "els": 1,
    "elsa": 2,
    "elsas": 2,
    "elsasser": 3,
    "elsberry": 3,
    "elsbury": 3,
    "elsdon": 2,
    "else": 1,
    "else's": 2,
    "elsea": 3,
    "elsen": 2,
    "elser": 2,
    "elses": 2,
    "elsesser": 3,
    "elsevier": 3,
    "elsevier(1)": 3,
    "elsevier's": 3,
    "elsevier's(1)": 3,
    "elsewhere": 2,
    "elsey": 2,
    "elsie": 2,
    "elsie's": 2,
    "elsinore": 3,
    "elsner": 2,
    "elson": 2,
    "elstad": 2,
    "elster": 2,
    "elston": 2,
    "elswick": 2,
    "elsworth": 2,
    "elting": 2,
    "elton": 2,
    "eltringham": 3,
    "eltzroth": 2,
    "elucidate": 4,
    "elucidated": 5,
    "elucidative": 5,
    "elude": 2,
    "eluded": 3,
    "eludes": 2,
    "eluding": 3,
    "elusive": 3,
    "elusiveness": 4,
    "elva": 2,
    "elvera": 3,
    "elvers": 2,
    "elves": 1,
    "elvgren": 2,
    "elvia": 3,
    "elvie": 2,
    "elvin": 2,
    "elvina": 3,
    "elving": 2,
    "elvington": 3,
    "elvira": 3,
    "elvire": 2,
    "elvis": 2,
    "elvis'": 2,
    "elvis's": 3,
    "elvy": 2,
    "elway": 2,
    "elway's": 2,
    "elwell": 2,
    "elwin": 2,
    "elwood": 2,
    "elxsi": 2,
    "ely": 2,
    "elyn": 2,
    "elyria": 4,
    "elyse": 2,
    "elysee": 3,
    "elysee(1)": 3,
    "elysees": 3,
    "elysees(1)": 3,
    "elysia": 4,
    "elysia(1)": 3,
    "elysium": 4,
    "elza": 2,
    "elzey": 2,
    "elzinga": 3,
    "elzy": 2,
    "em": 1,
    "ema": 2,
    "emaciate": 4,
    "emaciated": 5,
    "emaciates": 4,
    "emaciating": 5,
    "emad": 2,
    "email": 2,
    "emailed": 2,
    "emailing": 3,
    "emails": 2,
    "emanate": 3,
    "emanated": 4,
    "emanates": 3,
    "emanating": 4,
    "emanation": 4,
    "emanations": 4,
    "emancipate": 4,
    "emancipated": 5,
    "emancipates": 4,
    "emancipating": 5,
    "emancipation": 5,
    "emancipations": 5,
    "emanuel": 4,
    "emanuele": 5,
    "emanuelson": 4,
    "emard": 2,
    "emasculate": 4,
    "emasculate(1)": 4,
    "emasculated": 5,
    "embalm": 2,
    "embalmed": 2,
    "embalming": 3,
    "embankment": 3,
    "embankments": 3,
    "embarcadero": 5,
    "embargo": 3,
    "embargoed": 3,
    "embargoes": 3,
    "embark": 2,
    "embark(1)": 2,
    "embarkation": 4,
    "embarked": 2,
    "embarking": 3,
    "embarks": 2,
    "embarrass": 3,
    "embarrassed": 3,
    "embarrasses": 4,
    "embarrassing": 4,
    "embarrassingly": 5,
    "embarrassment": 4,
    "embarrassments": 4,
    "embassies": 3,
    "embassy": 3,
    "embassy's": 3,
    "embattle": 3,
    "embattled": 3,
    "embayment": 3,
    "embed": 2,
    "embedded": 3,
    "embellish": 3,
    "embellished": 3,
    "embellishes": 4,
    "embellishing": 4,
    "embellishment": 4,
    "ember": 2,
    "embers": 2,
    "emberson": 3,
    "emberton": 3,
    "emberton(1)": 3,
    "embezzle": 3,
    "embezzled": 3,
    "embezzlement": 4,
    "embezzler": 4,
    "embezzler(1)": 3,
    "embezzlers": 4,
    "embezzlers(1)": 3,
    "embezzles": 3,
    "embezzling": 4,
    "embezzling(1)": 3,
    "embezzling(2)": 3,
    "embezzling(3)": 4,
    "embitter": 3,
    "embittered": 3,
    "emblazon": 3,
    "emblazoned": 3,
    "emblem": 2,
    "emblematic": 4,
    "emblems": 2,
    "embler": 2,
    "embleton": 3,
    "embleton(1)": 3,
    "embodied": 3,
    "embodies": 3,
    "embodiment": 4,
    "embody": 3,
    "embodying": 4,
    "embolden": 3,
    "emboldened": 3,
    "embolism": 4,
    "embolisms": 4,
    "emboss": 2,
    "embossed": 2,
    "embrace": 2,
    "embrace(1)": 2,
    "embraceable": 4,
    "embraced": 2,
    "embraces": 3,
    "embracing": 3,
    "embree": 2,
    "embrey": 2,
    "embroider": 3,
    "embroidered": 3,
    "embroiderer": 4,
    "embroiderers": 4,
    "embroideries": 4,
    "embroidering": 4,
    "embroidery": 4,
    "embroil": 2,
    "embroiled": 2,
    "embrose": 2,
    "embry": 2,
    "embryo": 3,
    "embryology": 5,
    "embryonic": 4,
    "embryos": 3,
    "embury": 3,
    "emcee": 2,
    "emch": 1,
    "emco": 2,
    "emde": 1,
    "emdr": 4,
    "emel": 2,
    "emelda": 3,
    "emelie": 3,
    "emelina": 4,
    "emeline": 3,
    "emelita": 4,
    "emelyne": 3,
    "emens": 2,
    "emera": 3,
    "emerald": 2,
    "emerald(1)": 3,
    "emeralds": 2,
    "emeralds(1)": 3,
    "emerant": 3,
    "emeraude": 3,
    "emerge": 2,
    "emerge(1)": 2,
    "emerged": 2,
    "emerged(1)": 2,
    "emergence": 3,
    "emergence(1)": 3,
    "emergencies": 4,
    "emergencies(1)": 4,
    "emergency": 4,
    "emergency(1)": 4,
    "emergent": 3,
    "emergent(1)": 3,
    "emerges": 3,
    "emerges(1)": 3,
    "emerging": 3,
    "emerging(1)": 3,
    "emerich": 3,
    "emerick": 3,
    "emerine": 3,
    "emeritus": 4,
    "emerse": 2,
    "emersed": 2,
    "emerson": 3,
    "emerson's": 3,
    "emert": 2,
    "emerton": 3,
    "emerton(1)": 3,
    "emery": 3,
    "emery's": 3,
    "emeryville": 4,
    "emetic": 3,
    "emfinger": 3,
    "emge": 1,
    "emhart": 2,
    "emick": 2,
    "emig": 2,
    "emigh": 2,
    "emigrant": 3,
    "emigrants": 3,
    "emigrate": 3,
    "emigrated": 4,
    "emigrates": 3,
    "emigrating": 4,
    "emigration": 4,
    "emigrations": 4,
    "emigre": 3,
    "emigres": 3,
    "emil": 2,
    "emile": 2,
    "emilia": 4,
    "emilie": 3,
    "emilio": 4,
    "emilo": 3,
    "emilo's": 3,
    "emily": 3,
    "emily's": 3,
    "emina": 3,
    "eminase": 4,
    "eminence": 3,
    "eminences": 4,
    "eminent": 3,
    "eminently": 4,
    "emir": 2,
    "emir(1)": 2,
    "emirate": 3,
    "emirate(1)": 3,
    "emirates": 3,
    "emirates(1)": 3,
    "emirates'": 3,
    "emirates'(1)": 3,
    "emison": 3,
    "emissaries": 4,
    "emissary": 4,
    "emission": 3,
    "emissions": 3,
    "emit": 2,
    "emits": 2,
    "emitted": 3,
    "emitted(1)": 3,
    "emitter": 3,
    "emitting": 3,
    "emler": 2,
    "emley": 2,
    "emling": 2,
    "emlyn": 2,
    "emlynne": 2,
    "emma": 2,
    "emmaline": 4,
    "emmanuel": 4,
    "emmaus": 2,
    "emme": 1,
    "emmel": 2,
    "emmeline": 3,
    "emmendorfer": 4,
    "emmer": 2,
    "emmerich": 3,
    "emmerling": 3,
    "emmerson": 3,
    "emmert": 2,
    "emmery": 3,
    "emmet": 2,
    "emmett": 2,
    "emmi": 2,
    "emmick": 2,
    "emmie": 2,
    "emminger": 3,
    "emmis": 2,
    "emmit": 2,
    "emmitt": 2,
    "emmons": 2,
    "emmott": 2,
    "emmy": 2,
    "emmy's": 2,
    "emmys": 2,
    "emo": 2,
    "emogene": 3,
    "emond": 2,
    "emory": 3,
    "emory's": 3,
    "emoticon": 4,
    "emotion": 3,
    "emotion(1)": 3,
    "emotional": 4,
    "emotional(1)": 4,
    "emotionalism": 6,
    "emotionalism(1)": 6,
    "emotionally": 4,
    "emotionally(1)": 4,
    "emotions": 3,
    "emotions(1)": 3,
    "emotive": 3,
    "emotive(1)": 3,
    "empanel": 3,
    "empaneled": 3,
    "empaneling": 4,
    "empaneling(1)": 3,
    "empath": 2,
    "empathetic": 4,
    "empathize": 3,
    "empathy": 3,
    "emperor": 3,
    "emperor's": 3,
    "emperors": 3,
    "empey": 2,
    "emphases": 3,
    "emphasis": 3,
    "emphasis(1)": 3,
    "emphasize": 3,
    "emphasized": 3,
    "emphasizes": 4,
    "emphasizes(1)": 4,
    "emphasizing": 4,
    "emphatic": 3,
    "emphatically": 4,
    "emphatically(1)": 5,
    "emphysema": 4,
    "empie": 2,
    "empire": 3,
    "empire's": 3,
    "empires": 3,
    "empirical": 4,
    "empirically": 5,
    "empirically(1)": 4,
    "empiricism": 5,
    "empiricist": 4,
    "emplacement": 3,
    "emplacements": 3,
    "employ": 2,
    "employ(1)": 2,
    "employable": 4,
    "employed": 2,
    "employed(1)": 2,
    "employee": 3,
    "employee(1)": 3,
    "employee's": 3,
    "employee's(1)": 3,
    "employees": 3,
    "employees(1)": 3,
    "employees'": 3,
    "employer": 3,
    "employer(1)": 3,
    "employer's": 3,
    "employer's(1)": 3,
    "employers": 3,
    "employers(1)": 3,
    "employers'": 3,
    "employers'(1)": 3,
    "employing": 3,
    "employing(1)": 3,
    "employment": 3,
    "employment(1)": 3,
    "employments": 3,
    "employments(1)": 3,
    "employs": 2,
    "employs(1)": 2,
    "emporia": 4,
    "emporium": 4,
    "empower": 3,
    "empowered": 3,
    "empowering": 4,
    "empowerment": 4,
    "empowers": 3,
    "empresa": 3,
    "empresas": 3,
    "empress": 2,
    "emprise": 2,
    "empson": 2,
    "empt": 1,
    "empt(1)": 1,
    "empted": 2,
    "empted(1)": 2,
    "emptied": 2,
    "emptied(1)": 2,
    "emptier": 3,
    "emptier(1)": 3,
    "empties": 2,
    "empties(1)": 2,
    "emptiness": 3,
    "emptiness(1)": 3,
    "empting": 2,
    "empting(1)": 2,
    "emption": 2,
    "emptive": 2,
    "emptor": 2,
    "empts": 1,
    "empty": 2,
    "empty(1)": 2,
    "emptying": 3,
    "emptying(1)": 3,
    "emrich": 2,
    "emrick": 2,
    "emry": 2,
    "emslie": 3,
    "emswiler": 3,
    "emu": 2,
    "emuil": 3,
    "emuil's": 3,
    "emulate": 3,
    "emulated": 4,
    "emulates": 3,
    "emulating": 4,
    "emulation": 4,
    "emulex": 3,
    "emulsifier": 5,
    "emulsion": 3,
    "en": 1,
    "ena": 2,
    "enable": 3,
    "enable(1)": 3,
    "enabled": 3,
    "enabled(1)": 3,
    "enabler": 4,
    "enabler(1)": 3,
    "enabler(2)": 3,
    "enabler(3)": 4,
    "enables": 3,
    "enables(1)": 3,
    "enabling": 4,
    "enabling(1)": 4,
    "enabling(2)": 3,
    "enact": 2,
    "enacted": 3,
    "enacting": 3,
    "enactment": 3,
    "enactment(1)": 3,
    "enactments": 3,
    "enactments(1)": 3,
    "enactments(2)": 3,
    "enacts": 2,
    "enamel": 3,
    "enameled": 3,
    "enamels": 3,
    "enamor": 3,
    "enamored": 3,
    "enamoring": 4,
    "enamors": 3,
    "enasa": 3,
    "enberg": 2,
    "encamp": 2,
    "encamped": 2,
    "encampment": 3,
    "encampments": 3,
    "encapsulate": 4,
    "encapsulated": 5,
    "encapsulating": 5,
    "encarnacion": 5,
    "encarta": 3,
    "encarta(1)": 3,
    "encase": 2,
    "encased": 2,
    "encata": 3,
    "encata(1)": 3,
    "encata's": 3,
    "encata's(1)": 3,
    "encephalitis": 5,
    "encephalopathy": 6,
    "enchant": 2,
    "enchanted": 3,
    "enchanted(1)": 3,
    "enchanter": 3,
    "enchanter's": 3,
    "enchanter's(1)": 3,
    "enchanter's(2)": 3,
    "enchanter's(3)": 3,
    "enchanters": 3,
    "enchanters(1)": 3,
    "enchanters(2)": 3,
    "enchanters(3)": 3,
    "enchanting": 3,
    "enchanting(1)": 3,
    "enchantment": 3,
    "enchilada": 4,
    "encinas": 3,
    "encinias": 4,
    "encino": 3,
    "encircle": 3,
    "encircled": 3,
    "encirclement": 4,
    "encircling": 4,
    "encircling(1)": 3,
    "enciso": 3,
    "enck": 1,
    "enclave": 2,
    "enclave(1)": 2,
    "enclaves": 2,
    "enclaves(1)": 2,
    "enclose": 2,
    "enclosed": 2,
    "enclosed(1)": 2,
    "enclosing": 3,
    "enclosure": 3,
    "enclosure(1)": 3,
    "enclosures": 3,
    "encode": 2,
    "encoded": 3,
    "encoding": 3,
    "encompass": 3,
    "encompassed": 3,
    "encompasses": 4,
    "encompassing": 4,
    "encor": 2,
    "encor's": 2,
    "encore": 2,
    "encores": 2,
    "encounter": 3,
    "encounter(1)": 3,
    "encountered": 3,
    "encountered(1)": 3,
    "encountering": 4,
    "encountering(1)": 4,
    "encounters": 3,
    "encounters(1)": 3,
    "encourage": 3,
    "encourage(1)": 3,
    "encouraged": 3,
    "encouraged(1)": 3,
    "encouragement": 4,
    "encourages": 4,
    "encourages(1)": 4,
    "encouraging": 4,
    "encouraging(1)": 4,
    "encroach": 2,
    "encroached": 2,
    "encroaches": 3,
    "encroaching": 3,
    "encroachment": 3,
    "encroachments": 3,
    "encrust": 2,
    "encrusted": 3,
    "encrusting": 3,
    "encrypt": 2,
    "encrypt(1)": 2,
    "encrypted": 3,
    "encrypted(1)": 3,
    "encryption": 3,
    "encumber": 3,
    "encumbered": 3,
    "encyclical": 4,
    "encyclicals": 4,
    "encyclopaedia": 6,
    "encyclopaedia(1)": 6,
    "encyclopedia": 6,
    "encyclopedia(1)": 6,
    "encyclopedias": 6,
    "encyclopedias(1)": 6,
    "encyclopedic": 5,
    "encyclopedic(1)": 5,
    "encyclopedist": 5,
    "encyclopedist(1)": 5,
    "end": 1,
    "endaka": 3,
    "endanger": 3,
    "endangered": 3,
    "endangered(1)": 3,
    "endangering": 4,
    "endangerment": 4,
    "endangers": 3,
    "endara": 3,
    "ende": 1,
    "endear": 2,
    "endeared": 2,
    "endearing": 3,
    "endearment": 3,
    "endeavor": 3,
    "endeavor's": 3,
    "endeavored": 3,
    "endeavoring": 4,
    "endeavoring(1)": 3,
    "endeavors": 3,
    "endeavour": 3,
    "endeavour's": 3,
    "ended": 2,
    "ended(1)": 2,
    "endelman": 3,
    "endemic": 3,
    "ender": 2,
    "enderby": 3,
    "enderle": 3,
    "enderlin": 3,
    "enders": 2,
    "enderson": 3,
    "endevco": 3,
    "endgame": 2,
    "endgames": 2,
    "endicott": 3,
    "ending": 2,
    "endings": 2,
    "endive": 2,
    "endler": 2,
    "endless": 2,
    "endlessly": 3,
    "endlich": 2,
    "endo": 2,
    "endocrine": 3,
    "endocrinologist": 6,
    "endocrinologist's": 6,
    "endocrinologists": 6,
    "endocrinology": 6,
    "endodermal": 4,
    "endometrial": 5,
    "endometriosis": 6,
    "endorphin": 3,
    "endorphins": 3,
    "endorse": 2,
    "endorsed": 2,
    "endorsement": 3,
    "endorsements": 3,
    "endorser": 3,
    "endorsers": 3,
    "endorses": 3,
    "endorsing": 3,
    "endoscope": 3,
    "endoscopic": 4,
    "endoscopy": 4,
    "endosperm": 3,
    "endothelial": 5,
    "endothermic": 4,
    "endotronics": 4,
    "endotronics'": 4,
    "endotronics's": 5,
    "endow": 2,
    "endowed": 2,
    "endowing": 3,
    "endowment": 3,
    "endowment's": 3,
    "endowments": 3,
    "endows": 2,
    "endpoint": 2,
    "endpoints": 2,
    "endproduct": 3,
    "endproducts": 3,
    "endres": 2,
    "endress": 2,
    "endrizzi": 3,
    "ends": 1,
    "endsley": 2,
    "endtimer": 3,
    "endtimers": 3,
    "endued": 2,
    "endurance": 3,
    "endure": 2,
    "endure(1)": 2,
    "endured": 2,
    "endured(1)": 2,
    "endures": 2,
    "endures(1)": 2,
    "enduring": 3,
    "enduring(1)": 3,
    "enduser": 3,
    "endusers": 3,
    "endy": 2,
    "enea": 3,
    "enema": 3,
    "enemas": 3,
    "enemies": 3,
    "enemies'": 3,
    "enemy": 3,
    "enemy's": 3,
    "energas": 3,
    "energen": 3,
    "energetic": 4,
    "energetically": 5,
    "energies": 3,
    "energize": 3,
    "energized": 3,
    "energizer": 4,
    "energizes": 4,
    "energizing": 4,
    "energy": 3,
    "energy's": 3,
    "enerson": 3,
    "enex": 2,
    "enfant": 2,
    "enfant(1)": 2,
    "enfeeble": 3,
    "enfeebled": 3,
    "enfield": 2,
    "enfield's": 2,
    "enfinger": 3,
    "enfold": 2,
    "enfor": 2,
    "enforce": 2,
    "enforceability": 6,
    "enforceable": 4,
    "enforced": 2,
    "enforcement": 3,
    "enforcement's": 3,
    "enforcements": 3,
    "enforcer": 3,
    "enforcers": 3,
    "enforces": 3,
    "enforcing": 3,
    "enfranchise": 3,
    "enfranchised": 3,
    "enfranchises": 4,
    "eng": 1,
    "engage": 2,
    "engaged": 2,
    "engagement": 3,
    "engagements": 3,
    "engages": 3,
    "engaging": 3,
    "engberg": 2,
    "engdahl": 2,
    "enge": 1,
    "engebretsen": 4,
    "engebretson": 4,
    "engel": 2,
    "engelberg": 3,
    "engelbert": 3,
    "engelberta": 4,
    "engelbrecht": 3,
    "engeleiter": 4,
    "engelhard": 3,
    "engelhardt": 3,
    "engelhart": 3,
    "engelke": 2,
    "engelken": 3,
    "engelking": 3,
    "engelman": 3,
    "engelmann": 3,
    "engels": 2,
    "engelson": 3,
    "engelstad": 3,
    "engeman": 2,
    "engen": 2,
    "engender": 3,
    "engender(1)": 3,
    "engendered": 3,
    "engenders": 3,
    "enger": 2,
    "engert": 2,
    "engesser": 3,
    "engh": 1,
    "engholm": 2,
    "engine": 2,
    "engine(1)": 2,
    "engine's": 2,
    "engined": 2,
    "engineer": 3,
    "engineer's": 3,
    "engineered": 3,
    "engineering": 4,
    "engineers": 3,
    "engineers'": 3,
    "engines": 2,
    "engines'": 2,
    "england": 2,
    "england's": 2,
    "englander": 3,
    "englanders": 3,
    "englands": 2,
    "englbred": 3,
    "engle": 2,
    "englebert": 3,
    "englehardt": 3,
    "englehart": 3,
    "engleman": 3,
    "engler": 3,
    "engler(1)": 2,
    "engler's": 3,
    "engler's(1)": 2,
    "englert": 2,
    "englerth": 2,
    "engles": 2,
    "englewood": 3,
    "english": 2,
    "english(1)": 2,
    "englishman": 3,
    "englishmen": 3,
    "englishwoman": 4,
    "englund": 2,
    "engman": 2,
    "engquist": 2,
    "engram": 2,
    "engrave": 2,
    "engraved": 2,
    "engraver": 3,
    "engraving": 3,
    "engravings": 3,
    "engross": 2,
    "engrossed": 2,
    "engrossing": 3,
    "engrossment": 3,
    "engstrand": 2,
    "engstrom": 2,
    "engulf": 2,
    "engulfed": 2,
    "engulfing": 3,
    "engwall": 2,
    "enhance": 2,
    "enhanced": 2,
    "enhanced(1)": 2,
    "enhancement": 3,
    "enhancements": 3,
    "enhancer": 3,
    "enhances": 3,
    "enhancing": 3,
    "enholm": 2,
    "enholme": 2,
    "eniac": 3,
    "enichem": 3,
    "enid": 2,
    "enigma": 3,
    "enigmatic": 4,
    "enimont": 3,
    "enis": 2,
    "enitt": 2,
    "enix": 2,
    "enjoin": 2,
    "enjoin(1)": 2,
    "enjoined": 2,
    "enjoining": 3,
    "enjoy": 2,
    "enjoy(1)": 2,
    "enjoyable": 4,
    "enjoyably": 4,
    "enjoyed": 2,
    "enjoyed(1)": 2,
    "enjoying": 3,
    "enjoying(1)": 3,
    "enjoyment": 3,
    "enjoyment(1)": 3,
    "enjoyments": 3,
    "enjoys": 2,
    "enjoys(1)": 2,
    "enke": 1,
    "enlarge": 2,
    "enlarge(1)": 2,
    "enlarged": 2,
    "enlarged(1)": 2,
    "enlargement": 3,
    "enlargements": 3,
    "enlarger": 3,
    "enlarges": 3,
    "enlarging": 3,
    "enlighten": 3,
    "enlightened": 3,
    "enlightening": 4,
    "enlightening(1)": 3,
    "enlightenment": 4,
    "enlightens": 3,
    "enlist": 2,
    "enlisted": 3,
    "enlisted(1)": 3,
    "enlistee": 3,
    "enlistees": 3,
    "enlisting": 3,
    "enlisting(1)": 3,
    "enlistment": 3,
    "enlists": 2,
    "enliven": 3,
    "enlivened": 3,
    "enlivening": 4,
    "enlivens": 3,
    "enlo": 2,
    "enloe": 2,
    "enlow": 2,
    "enman": 2,
    "enmesh": 2,
    "enmeshed": 2,
    "enmeshes": 3,
    "enmeshing": 3,
    "enmities": 3,
    "enmities(1)": 3,
    "enmity": 3,
    "enmity(1)": 3,
    "ennea": 3,
    "enneking": 3,
    "ennen": 2,
    "ennes": 1,
    "ennes(1)": 2,
    "ennis": 2,
    "ennoble": 3,
    "ennobled": 3,
    "ennobles": 3,
    "ennobling": 3,
    "ennosuke": 3,
    "enns": 1,
    "ennui": 3,
    "eno": 2,
    "enoch": 2,
    "enochs": 2,
    "enojada": 4,
    "enola": 3,
    "enomoto": 4,
    "enormity": 4,
    "enormity(1)": 4,
    "enormous": 3,
    "enormous(1)": 3,
    "enormous(2)": 3,
    "enormous(3)": 3,
    "enormously": 4,
    "enormously(1)": 4,
    "enos": 2,
    "enough": 2,
    "enough(1)": 2,
    "enough's": 2,
    "enough's(1)": 2,
    "enqueso": 3,
    "enquire": 3,
    "enquirer": 3,
    "enquist": 2,
    "enrage": 2,
    "enraged": 2,
    "enraged(1)": 2,
    "enrages": 3,
    "enraging": 3,
    "enrapture": 3,
    "enraptured": 3,
    "enrica": 3,
    "enrich": 2,
    "enrich(1)": 2,
    "enriched": 2,
    "enriches": 3,
    "enriching": 3,
    "enriching(1)": 3,
    "enrichment": 3,
    "enrichment(1)": 3,
    "enrico": 3,
    "enright": 2,
    "enrile": 2,
    "enrile(1)": 3,
    "enrique": 3,
    "enriquez": 3,
    "enro": 2,
    "enroll": 2,
    "enroll(1)": 2,
    "enrolled": 2,
    "enrollee": 3,
    "enrollees": 3,
    "enrolling": 3,
    "enrollment": 3,
    "enrollments": 3,
    "enrolls": 2,
    "enron": 2,
    "enron's": 2,
    "enroute": 2,
    "ensco": 2,
    "ensco's": 2,
    "ensconce": 2,
    "ensconced": 2,
    "enseco": 3,
    "ensemble": 3,
    "ensembles": 3,
    "enserch": 2,
    "ensey": 2,
    "enshrine": 2,
    "enshrined": 2,
    "enshroud": 2,
    "enshrouded": 3,
    "ensign": 2,
    "ensing": 2,
    "ensinger": 3,
    "enskilda": 3,
    "enslave": 2,
    "enslaved": 2,
    "enslavement": 3,
    "enslen": 3,
    "ensley": 2,
    "enslin": 2,
    "enslow": 2,
    "ensminger": 4,
    "ensnare": 2,
    "ensnared": 2,
    "ensnares": 2,
    "ensnarl": 2,
    "ensnarled": 2,
    "ensor": 2,
    "ensource": 2,
    "ensrud": 2,
    "enstrom": 2,
    "ensue": 2,
    "ensued": 2,
    "ensues": 2,
    "ensuing": 3,
    "ensure": 2,
    "ensure(1)": 2,
    "ensured": 2,
    "ensured(1)": 2,
    "ensures": 2,
    "ensures(1)": 2,
    "ensuring": 3,
    "ensuring(1)": 3,
    "ensz": 1,
    "ent": 1,
    "entail": 2,
    "entailed": 2,
    "entailing": 3,
    "entails": 2,
    "entangle": 3,
    "entangled": 3,
    "entanglement": 4,
    "entanglement(1)": 4,
    "entanglements": 4,
    "entanglements(1)": 4,
    "entangling": 3,
    "entangling(1)": 3,
    "ente": 2,
    "entebbe": 3,
    "entebbe's": 3,
    "entendre": 3,
    "entenmann": 3,
    "entenmann's": 3,
    "enter": 2,
    "enter(1)": 2,
    "entered": 2,
    "entered(1)": 2,
    "entergy": 3,
    "entering": 3,
    "entering(1)": 3,
    "enteritidis": 5,
    "enterividous": 5,
    "enterline": 3,
    "enterline's": 3,
    "enterococcus": 5,
    "enterology": 5,
    "enterprise": 3,
    "enterprise(1)": 3,
    "enterprise's": 4,
    "enterprise's(1)": 4,
    "enterprise's(2)": 4,
    "enterprise's(3)": 4,
    "enterprises": 4,
    "enterprises(1)": 4,
    "enterprises'": 4,
    "enterprises'(1)": 4,
    "enterprising": 4,
    "enterprising(1)": 4,
    "enterra": 3,
    "enters": 2,
    "enters(1)": 2,
    "entertain": 3,
    "entertain(1)": 3,
    "entertained": 3,
    "entertained(1)": 3,
    "entertainer": 4,
    "entertainer(1)": 4,
    "entertainer's": 4,
    "entertainer's(1)": 4,
    "entertainers": 4,
    "entertainers(1)": 4,
    "entertaining": 4,
    "entertaining(1)": 4,
    "entertainment": 4,
    "entertainment(1)": 4,
    "entertainment's": 4,
    "entertainment's(1)": 4,
    "entertainments": 4,
    "entertainments(1)": 4,
    "entertains": 3,
    "entertains(1)": 3,
    "entex": 2,
    "enthral": 2,
    "enthralled": 2,
    "enthuse": 2,
    "enthused": 2,
    "enthusiasm": 5,
    "enthusiasms": 5,
    "enthusiast": 4,
    "enthusiastic": 5,
    "enthusiastically": 6,
    "enthusiasts": 4,
    "entice": 2,
    "enticed": 2,
    "enticement": 3,
    "enticements": 3,
    "enticing": 3,
    "entin": 2,
    "entire": 3,
    "entirely": 4,
    "entirety": 4,
    "entities": 3,
    "entities'": 3,
    "entitle": 3,
    "entitle(1)": 3,
    "entitled": 3,
    "entitlement": 4,
    "entitlements": 4,
    "entitles": 3,
    "entitling": 4,
    "entitling(1)": 3,
    "entity": 3,
    "entity(1)": 3,
    "entity's": 3,
    "entler": 2,
    "entoffen": 3,
    "entoffen's": 3,
    "entomb": 2,
    "entombed": 2,
    "entombment": 3,
    "entomologist": 5,
    "entomologists": 5,
    "entomology": 5,
    "entourage": 3,
    "entourage(1)": 3,
    "entourages": 4,
    "entourages(1)": 4,
    "entrail": 2,
    "entrails": 2,
    "entrance": 2,
    "entranced": 2,
    "entrances": 3,
    "entrant": 2,
    "entrants": 2,
    "entrap": 2,
    "entrapment": 3,
    "entrapped": 2,
    "entre": 2,
    "entre(1)": 2,
    "entreaties": 3,
    "entreaty": 3,
    "entree": 2,
    "entrees": 2,
    "entregrowth": 3,
    "entrekin": 3,
    "entrench": 2,
    "entrenched": 2,
    "entrenched(1)": 2,
    "entrenches": 3,
    "entrenching": 3,
    "entrenchment": 3,
    "entrepreneur": 4,
    "entrepreneur(1)": 4,
    "entrepreneur's": 4,
    "entrepreneurial": 6,
    "entrepreneurialism": 8,
    "entrepreneurs": 4,
    "entrepreneurship": 5,
    "entries": 2,
    "entrikin": 3,
    "entringer": 4,
    "entropy": 3,
    "entrust": 2,
    "entrusted": 3,
    "entrusting": 3,
    "entry": 2,
    "entryway": 3,
    "entsminger": 4,
    "entwine": 2,
    "entwined": 2,
    "entwisle": 3,
    "entwistle": 3,
    "entz": 1,
    "entzminger": 3,
    "enumerate": 4,
    "enumerated": 5,
    "enumerates": 4,
    "enumeration": 5,
    "enunciate": 4,
    "enunciate(1)": 4,
    "enunciated": 5,
    "enunciating": 5,
    "envelop": 3,
    "envelope": 3,
    "enveloped": 3,
    "envelopes": 3,
    "enveloping": 4,
    "envelops": 3,
    "enviable": 4,
    "envied": 2,
    "envious": 3,
    "enviously": 4,
    "enviro": 3,
    "envirodyne": 4,
    "environic": 4,
    "environics": 4,
    "environment": 4,
    "environment's": 4,
    "environmental": 5,
    "environmental(1)": 5,
    "environmentalism": 7,
    "environmentalism(1)": 7,
    "environmentalist": 6,
    "environmentalist(1)": 6,
    "environmentalists": 6,
    "environmentalists(1)": 6,
    "environmentalists(2)": 6,
    "environmentalists(3)": 6,
    "environmentalists'": 6,
    "environmentalists'(1)": 6,
    "environmentally": 6,
    "environmentally(1)": 6,
    "environments": 4,
    "environs": 3,
    "enviropact": 4,
    "envirosafe": 4,
    "envirotest": 4,
    "envisage": 3,
    "envisaged": 3,
    "envisages": 4,
    "envision": 3,
    "envisioned": 3,
    "envisioning": 4,
    "envisions": 3,
    "envos": 2,
    "envoy": 2,
    "envoy(1)": 2,
    "envoys": 2,
    "envoys(1)": 2,
    "envy": 2,
    "enwright": 2,
    "enyart": 2,
    "enyeart": 2,
    "enz": 1,
    "enzo": 2,
    "enzon": 2,
    "enzor": 2,
    "enzymatic": 4,
    "enzyme": 2,
    "enzymes": 2,
    "eocene": 3,
    "eoff": 2,
    "eohippus": 4,
    "eolande": 4,
    "eon": 2,
    "eon(1)": 2,
    "eons": 2,
    "eos": 2,
    "eos's": 3,
    "eosinophilia": 6,
    "eosinophilic": 6,
    "epcot": 2,
    "epeda": 3,
    "epeda's": 3,
    "epes": 1,
    "ephedrine": 3,
    "ephemeral": 4,
    "ephlin": 2,
    "ephraim": 2,
    "ephron": 2,
    "epic": 2,
    "epic's": 2,
    "epicenter": 4,
    "epics": 2,
    "epicure": 3,
    "epicurean": 5,
    "epicurean(1)": 5,
    "epidemic": 4,
    "epidemic(1)": 4,
    "epidemics": 4,
    "epidemiological": 8,
    "epidemiologically": 8,
    "epidemiologist": 7,
    "epidemiologists": 7,
    "epidemiology": 7,
    "epidermal": 4,
    "epidermis": 4,
    "epidural": 4,
    "epigenetic": 5,
    "epigram": 3,
    "epigrammatic": 5,
    "epigraphic": 4,
    "epilepsies": 4,
    "epilepsy": 4,
    "epileptic": 4,
    "epileptics": 4,
    "epilogue": 3,
    "epiphany": 4,
    "episcopal": 4,
    "episcopalian": 6,
    "episcopalian(1)": 5,
    "episcopalians": 6,
    "episcopalians(1)": 5,
    "episcopo": 4,
    "episode": 3,
    "episode(1)": 3,
    "episodes": 3,
    "episodes(1)": 3,
    "episodic": 4,
    "episteme": 3,
    "epistemology": 6,
    "epistle": 3,
    "epistolary": 5,
    "epitaph": 3,
    "epitaphs": 3,
    "epithelial": 4,
    "epithet": 3,
    "epithets": 3,
    "epitome": 4,
    "epitomize": 4,
    "epitomized": 4,
    "epitomizes": 5,
    "epitope": 3,
    "epler": 2,
    "epley": 2,
    "eplin": 2,
    "epling": 2,
    "epoch": 2,
    "epoch(1)": 2,
    "epochal": 3,
    "epochs": 2,
    "epochs(1)": 2,
    "epogen": 3,
    "epoxy": 3,
    "epp": 1,
    "eppard": 2,
    "eppel": 2,
    "epperly": 3,
    "eppers": 2,
    "epperson": 3,
    "eppes": 1,
    "eppich": 2,
    "epping": 2,
    "eppinger": 3,
    "epple": 2,
    "eppler": 2,
    "eppley": 2,
    "eppner": 2,
    "eppolito": 4,
    "epps": 1,
    "eprom": 2,
    "eproms": 2,
    "epsco": 2,
    "epsilon": 3,
    "epsom": 2,
    "epsomite": 3,
    "epson": 2,
    "epstein": 2,
    "epstein(1)": 2,
    "epting": 2,
    "equable": 3,
    "equal": 2,
    "equaled": 2,
    "equaling": 3,
    "equality": 4,
    "equalization": 5,
    "equalize": 3,
    "equalized": 3,
    "equalizer": 4,
    "equalizes": 4,
    "equalizing": 4,
    "equally": 3,
    "equals": 2,
    "equanimity": 5,
    "equate": 2,
    "equated": 3,
    "equates": 2,
    "equating": 3,
    "equation": 3,
    "equations": 3,
    "equator": 3,
    "equatorial": 5,
    "equators": 3,
    "equestrian": 4,
    "equiangular": 5,
    "equibank": 3,
    "equicor": 3,
    "equifax": 3,
    "equilibria": 5,
    "equilibrium": 5,
    "equilink": 3,
    "equimark": 3,
    "equine": 2,
    "equinox": 3,
    "equion": 3,
    "equip": 2,
    "equipment": 3,
    "equipment's": 3,
    "equipments": 3,
    "equipped": 2,
    "equipping": 3,
    "equips": 2,
    "equitable": 4,
    "equitable(1)": 4,
    "equitable's": 4,
    "equitably": 4,
    "equitas": 3,
    "equitation": 4,
    "equitec": 3,
    "equitex": 3,
    "equiticorp": 4,
    "equities": 3,
    "equities'": 3,
    "equity": 3,
    "equity's": 3,
    "equivalence": 4,
    "equivalency": 5,
    "equivalent": 4,
    "equivalents": 4,
    "equivocal": 4,
    "equivocate": 4,
    "equivocating": 5,
    "equivocation": 5,
    "er": 1,
    "era": 2,
    "era(1)": 2,
    "era's": 2,
    "era's(1)": 2,
    "eradicable": 5,
    "eradicate": 4,
    "eradicated": 5,
    "eradicating": 5,
    "eradication": 5,
    "erakat": 3,
    "eralp": 2,
    "eramo": 3,
    "eranthe": 2,
    "erany": 3,
    "eras": 2,
    "erasable": 4,
    "erasable(1)": 4,
    "erase": 2,
    "erase(1)": 2,
    "erased": 2,
    "erased(1)": 2,
    "eraser": 3,
    "eraser(1)": 3,
    "erasers": 3,
    "erasers(1)": 3,
    "erases": 3,
    "erases(1)": 3,
    "erasing": 3,
    "erasing(1)": 3,
    "erasmus": 3,
    "erastus": 3,
    "erawan": 3,
    "erazo": 3,
    "erb": 1,
    "erbacher": 3,
    "erbamont": 3,
    "erbamont's": 3,
    "erbe": 1,
    "erber": 2,
    "erbes": 1,
    "erburu": 3,
    "erby": 2,
    "erceg": 2,
    "erck": 1,
    "ercole": 3,
    "ercros": 2,
    "erda": 2,
    "erdahl": 2,
    "erdman": 2,
    "erdmann": 2,
    "erdos": 2,
    "erdrich": 2,
    "ere": 1,
    "erect": 2,
    "erected": 3,
    "erected(1)": 3,
    "erecting": 3,
    "erection": 3,
    "erections": 3,
    "erector": 3,
    "erects": 2,
    "erena": 3,
    "erensel": 3,
    "ergle": 2,
    "ergo": 2,
    "ergonomic": 4,
    "ergonomically": 5,
    "ergonomics": 4,
    "ergot": 2,
    "ergot's": 2,
    "ergotism": 4,
    "ergots": 2,
    "erhard": 2,
    "erhardt": 2,
    "erhart": 2,
    "eric": 2,
    "eric's": 2,
    "erica": 3,
    "erich": 2,
    "erichsen": 3,
    "erick": 2,
    "ericka": 3,
    "ericksen": 3,
    "erickson": 3,
    "ericson": 3,
    "ericsson": 3,
    "ericsson's": 3,
    "eridania": 5,
    "erie": 2,
    "erik": 2,
    "erik's": 2,
    "erika": 3,
    "eriksen": 3,
    "erikson": 3,
    "erikson's": 3,
    "eriksson": 3,
    "erin": 2,
    "erina": 3,
    "erion": 3,
    "erisa": 3,
    "erisman": 3,
    "eritrea": 4,
    "eritrea(1)": 4,
    "eritrean": 4,
    "eritrean(1)": 4,
    "eritreans": 3,
    "eritreans(1)": 4,
    "erk": 1,
    "erker": 2,
    "erkkila": 3,
    "erl": 1,
    "erlach": 2,
    "erland": 2,
    "erlandson": 3,
    "erlangen": 3,
    "erlanger": 3,
    "erlanger(1)": 3,
    "erle": 2,
    "erlene": 2,
    "erler": 2,
    "erlich": 2,
    "erlichman": 3,
    "erlichman(1)": 3,
    "erlick": 2,
    "erlick(1)": 2,
    "erline": 2,
    "erling": 2,
    "erly": 2,
    "erma": 2,
    "erma's": 2,
    "erman": 2,
    "ermer": 2,
    "ermin": 2,
    "ermina": 3,
    "ermine": 2,
    "erminia": 4,
    "erminie": 3,
    "ermis": 2,
    "erna": 2,
    "ernaline": 3,
    "erne": 1,
    "ernest": 2,
    "ernest(1)": 2,
    "ernest's": 2,
    "ernestine": 3,
    "ernesto": 3,
    "ernests": 2,
    "erney": 2,
    "ernie": 2,
    "erno": 2,
    "ernsberger": 3,
    "ernst": 1,
    "ernster": 2,
    "erny": 2,
    "ero": 2,
    "erode": 2,
    "erode(1)": 2,
    "eroded": 3,
    "eroded(1)": 3,
    "erodes": 2,
    "erodible": 4,
    "eroding": 3,
    "eroding(1)": 3,
    "eroh": 2,
    "eroica": 3,
    "erol": 2,
    "erol's": 2,
    "eron": 2,
    "eros": 2,
    "erosion": 3,
    "erosional": 4,
    "erosive": 3,
    "erotic": 3,
    "erotica": 4,
    "eroticism": 5,
    "erpelding": 3,
    "erps": 1,
    "err": 1,
    "err(1)": 1,
    "erra": 2,
    "errand": 2,
    "errands": 2,
    "errant": 2,
    "erratic": 3,
    "erratically": 4,
    "erred": 1,
    "errett": 2,
    "erria": 3,
    "errickson": 3,
    "errico": 3,
    "erring": 2,
    "errington": 3,
    "errol": 2,
    "errol's": 2,
    "erroneous": 4,
    "erroneous(1)": 4,
    "erroneously": 5,
    "error": 2,
    "errorful": 3,
    "errors": 2,
    "errs": 1,
    "ers": 1,
    "ers(1)": 3,
    "ersatz": 2,
    "ersatz(1)": 2,
    "ershad": 2,
    "ershad(1)": 2,
    "erskin": 2,
    "erskine": 2,
    "erstwhile": 2,
    "erte": 1,
    "erte(1)": 2,
    "ertel": 2,
    "ertha": 2,
    "ertl": 2,
    "ertle": 2,
    "ertman": 2,
    "ertz": 1,
    "erudite": 3,
    "erudition": 4,
    "erupt": 2,
    "erupt(1)": 2,
    "erupted": 3,
    "erupted(1)": 3,
    "erupting": 3,
    "erupting(1)": 3,
    "eruption": 3,
    "eruption(1)": 3,
    "eruptions": 3,
    "eruptions(1)": 3,
    "eruptive": 3,
    "eruptive(1)": 3,
    "erupts": 2,
    "erupts(1)": 2,
    "erven": 2,
    "ervin": 2,
    "erving": 2,
    "erway": 2,
    "erwin": 2,
    "erwina": 3,
    "erxleben": 3,
    "erykah": 3,
    "erythropoietin": 5,
    "erzurum": 3,
    "es": 1,
    "esarey": 3,
    "esau": 2,
    "esbenshade": 3,
    "esbenshade(1)": 3,
    "esber": 2,
    "escada": 3,
    "escalade": 3,
    "escalante": 4,
    "escalate": 3,
    "escalated": 4,
    "escalates": 3,
    "escalating": 4,
    "escalation": 4,
    "escalator": 4,
    "escalators": 4,
    "escalera": 4,
    "escalona": 4,
    "escambia": 4,
    "escamez": 3,
    "escamilla": 4,
    "escanaba": 4,
    "escandon": 3,
    "escapade": 3,
    "escapades": 3,
    "escape": 2,
    "escaped": 2,
    "escapee": 3,
    "escapees": 3,
    "escapement": 3,
    "escapes": 2,
    "escaping": 3,
    "escapism": 4,
    "escarcega": 4,
    "escareno": 4,
    "escarpment": 3,
    "escarpments": 3,
    "esch": 1,
    "eschatological": 6,
    "eschbach": 2,
    "esche": 1,
    "eschen": 2,
    "eschenbach": 3,
    "eschenburg": 3,
    "escher": 2,
    "eschete": 2,
    "eschew": 2,
    "eschewed": 2,
    "eschewed(1)": 2,
    "eschewing": 3,
    "eschewing(1)": 3,
    "eschews": 2,
    "eschmann": 2,
    "esco": 2,
    "escobar": 3,
    "escobar(1)": 3,
    "escobar's": 3,
    "escobar's(1)": 3,
    "escobedo": 4,
    "escoe": 2,
    "escondido": 4,
    "escora": 3,
    "escort": 2,
    "escort(1)": 2,
    "escorted": 3,
    "escorting": 3,
    "escorts": 2,
    "escoto": 3,
    "escott": 2,
    "escrow": 2,
    "escrow(1)": 2,
    "escrowed": 2,
    "escuchando": 4,
    "escudero": 4,
    "escudo": 3,
    "escudos": 3,
    "escue": 2,
    "esculent": 3,
    "esh": 1,
    "esham": 2,
    "eshbach": 2,
    "eshbaugh": 2,
    "eshelman": 3,
    "eshleman": 3,
    "eskandarian": 5,
    "eskelson": 3,
    "eskenazi": 4,
    "eskenazi(1)": 4,
    "esker": 2,
    "eskew": 2,
    "eskey": 2,
    "eskimo": 3,
    "eskimos": 3,
    "eskin": 2,
    "eskridge": 2,
    "esler": 3,
    "esler(1)": 2,
    "eslick": 2,
    "eslinger": 4,
    "eslinger(1)": 3,
    "esmark": 2,
    "esme": 1,
    "esmerelda": 4,
    "esmine": 2,
    "esmond": 2,
    "esophagus": 4,
    "esoteric": 4,
    "esoteric(1)": 4,
    "espada": 3,
    "espalier": 3,
    "espana": 3,
    "espanol": 3,
    "espanola": 4,
    "esparza": 3,
    "espe": 1,
    "especial": 3,
    "especially": 3,
    "especially(1)": 4,
    "espectador": 4,
    "espejo": 3,
    "espeland": 3,
    "espenschied": 3,
    "espenshade": 3,
    "espenshade(1)": 3,
    "esper": 2,
    "esperanto": 4,
    "esperanto's": 4,
    "espeseth": 3,
    "espey": 2,
    "espinal": 3,
    "espino": 3,
    "espinola": 4,
    "espinosa": 4,
    "espinoza": 4,
    "espionage": 4,
    "espirito": 4,
    "espirito(1)": 4,
    "espiritu": 4,
    "espitia": 3,
    "esplanade": 3,
    "esplin": 2,
    "esposito": 4,
    "espouse": 2,
    "espouse(1)": 2,
    "espoused": 2,
    "espoused(1)": 2,
    "espouses": 3,
    "espouses(1)": 3,
    "espousing": 3,
    "espousing(1)": 3,
    "espresso": 3,
    "espresso(1)": 3,
    "espressos": 3,
    "espressos(1)": 3,
    "esprit": 2,
    "esprit's": 2,
    "espy": 2,
    "espy's": 2,
    "esque": 1,
    "esqueda": 3,
    "esquer": 2,
    "esquibel": 3,
    "esquire": 2,
    "esquire's": 2,
    "esquivel": 3,
    "esrey": 2,
    "ess": 1,
    "essa": 2,
    "essary": 3,
    "essay": 2,
    "essay(1)": 2,
    "essayist": 3,
    "essays": 2,
    "essays(1)": 2,
    "esse": 1,
    "esselman": 3,
    "esselte": 3,
    "essen": 2,
    "essenburg": 3,
    "essence": 2,
    "essential": 3,
    "essential(1)": 3,
    "essential(2)": 3,
    "essential(3)": 3,
    "essentially": 4,
    "essentially(1)": 4,
    "essentials": 3,
    "essentials(1)": 3,
    "essentials(2)": 3,
    "essentials(3)": 3,
    "esser": 2,
    "esses": 2,
    "esses(1)": 2,
    "essex": 2,
    "essex's": 3,
    "essick": 2,
    "essie": 2,
    "essig": 2,
    "esslinger": 4,
    "esslinger(1)": 3,
    "essman": 2,
    "essner": 2,
    "esso": 2,
    "esson": 2,
    "est": 2,
    "esta": 2,
    "establish": 3,
    "establish(1)": 3,
    "established": 3,
    "established(1)": 3,
    "establishes": 4,
    "establishes(1)": 4,
    "establishing": 4,
    "establishing(1)": 4,
    "establishment": 4,
    "establishment(1)": 4,
    "establishment's": 4,
    "establishment's(1)": 4,
    "establishments": 4,
    "establishments(1)": 4,
    "estabrook": 3,
    "estabrooks": 3,
    "estai": 2,
    "estan": 2,
    "estate": 2,
    "estate's": 2,
    "estatehood": 3,
    "estates": 2,
    "este": 1,
    "esteban": 3,
    "estedat": 3,
    "estee": 2,
    "esteem": 2,
    "esteem's": 2,
    "esteemed": 2,
    "estefan": 3,
    "estefan(1)": 3,
    "estel": 2,
    "estell": 2,
    "estella": 3,
    "estelle": 2,
    "estenson": 3,
    "estep": 2,
    "estepp": 2,
    "ester": 2,
    "esterline": 3,
    "esterline's": 3,
    "esterly": 3,
    "esters": 2,
    "estes": 2,
    "esteve": 2,
    "esteves": 3,
    "estevez": 3,
    "estey": 2,
    "esther": 2,
    "esthetic": 3,
    "esthetically": 4,
    "esthetics": 3,
    "estill": 2,
    "estimable": 4,
    "estimate": 3,
    "estimate(1)": 3,
    "estimated": 4,
    "estimated(1)": 4,
    "estimates": 3,
    "estimates(1)": 3,
    "estimating": 4,
    "estimation": 4,
    "estimations": 4,
    "estimator": 4,
    "estimator(1)": 4,
    "estimators": 4,
    "estimators(1)": 4,
    "estis": 2,
    "estle": 2,
    "estock": 2,
    "estok": 2,
    "estonia": 4,
    "estonian": 4,
    "estonians": 4,
    "estrada": 3,
    "estrange": 2,
    "estranged": 2,
    "estrangement": 3,
    "estrella": 3,
    "estrich": 2,
    "estridge": 2,
    "estrin": 2,
    "estrogen": 3,
    "estrogens": 3,
    "estrous": 2,
    "estrus": 2,
    "estruth": 2,
    "estuaries": 4,
    "estuary": 4,
    "esty": 2,
    "esworthy": 3,
    "eszterhas": 3,
    "et": 1,
    "etablissements": 5,
    "etc": 4,
    "etcetera": 4,
    "etch": 1,
    "etched": 1,
    "etches": 2,
    "etcheverry": 4,
    "etching": 2,
    "etchings": 2,
    "etchison": 3,
    "eternal": 3,
    "eternal(1)": 3,
    "eternally": 4,
    "eternally(1)": 4,
    "eternit": 3,
    "eternity": 4,
    "eternity(1)": 4,
    "etess": 2,
    "ethan": 2,
    "ethane": 2,
    "ethanol": 3,
    "ethel": 2,
    "ethelbert": 3,
    "ethelda": 3,
    "ethelinda": 4,
    "etheline": 3,
    "etheljean": 3,
    "etheljean(1)": 3,
    "ethelson": 3,
    "ethelyn": 3,
    "ethene": 2,
    "ether": 2,
    "ethereal": 4,
    "etheredge": 3,
    "etheridge": 3,
    "etherington": 4,
    "ethernet": 3,
    "ethers": 2,
    "etherton": 3,
    "etherton(1)": 3,
    "ethic": 2,
    "ethical": 3,
    "ethical(1)": 3,
    "ethically": 4,
    "ethically(1)": 3,
    "ethicist": 3,
    "ethicists": 3,
    "ethicon": 3,
    "ethics": 2,
    "ethier": 3,
    "ethington": 3,
    "ethiopia": 5,
    "ethiopia's": 5,
    "ethiopian": 5,
    "ethiopians": 5,
    "ethnic": 2,
    "ethnical": 3,
    "ethnically": 3,
    "ethnicity": 4,
    "ethnics": 2,
    "ethnocentric": 4,
    "ethnocentrism": 5,
    "ethnographic": 4,
    "ethnology": 4,
    "ethnomusicologist": 7,
    "ethnos": 2,
    "ethnos's": 3,
    "ethology": 4,
    "ethos": 2,
    "ethridge": 2,
    "ethyl": 2,
    "ethylene": 3,
    "ethyol": 3,
    "etienne": 3,
    "etiologies": 5,
    "etiology": 5,
    "etiology(1)": 5,
    "etiquette": 3,
    "etling": 2,
    "etna": 2,
    "eton": 2,
    "etops": 2,
    "etruscan": 3,
    "etruscans": 3,
    "etsty": 2,
    "etsu": 2,
    "etta": 2,
    "etter": 2,
    "etters": 2,
    "ettie": 2,
    "ettinger": 3,
    "ettinger's": 3,
    "ettlinger": 3,
    "etty": 2,
    "etudes": 2,
    "etymological": 6,
    "etymology": 5,
    "etymology(1)": 5,
    "etzel": 2,
    "etzel's": 2,
    "etzioni": 4,
    "etzkorn": 2,
    "etzler": 2,
    "euan": 2,
    "eubank": 2,
    "eubanks": 2,
    "eucalypti": 4,
    "eucalypti(1)": 4,
    "eucalyptus": 4,
    "eucharist": 3,
    "euchre": 2,
    "euchred": 2,
    "euclea": 3,
    "euclid": 2,
    "eudocia": 3,
    "eudora": 3,
    "eudosia": 4,
    "eudoxia": 4,
    "eudy": 2,
    "eugene": 2,
    "eugene(1)": 2,
    "eugenia": 4,
    "eugenia's": 4,
    "eugenic": 3,
    "eugenics": 3,
    "eugenie": 3,
    "eugenio": 4,
    "eugenio's": 4,
    "eula": 2,
    "euler": 2,
    "eulich": 2,
    "eulogies": 3,
    "eulogize": 3,
    "eulogized": 3,
    "eulogy": 3,
    "eulogy's": 3,
    "eunice": 2,
    "eunice(1)": 2,
    "eunuch": 2,
    "euphemia": 4,
    "euphemism": 4,
    "euphemisms": 4,
    "euphemistic": 4,
    "euphemistically": 5,
    "euphony": 3,
    "euphoria": 4,
    "euphoric": 3,
    "euphory": 3,
    "euphrates": 3,
    "eurailpass": 3,
    "eurasia": 3,
    "eurasian": 3,
    "eure": 1,
    "eureca": 3,
    "eureka": 3,
    "eurest": 2,
    "eurich": 2,
    "euro": 2,
    "euro(1)": 2,
    "euro(2)": 2,
    "eurobond": 3,
    "eurobonds": 3,
    "eurocheck": 3,
    "eurochecks": 3,
    "eurocom": 3,
    "eurocom(1)": 3,
    "eurocommercial": 5,
    "eurocopter": 4,
    "eurocopters": 4,
    "eurocrat": 3,
    "eurocrats": 3,
    "eurodebenture": 5,
    "eurodebentures": 5,
    "eurodebt": 3,
    "eurodeposit": 5,
    "eurodeposits": 5,
    "eurodisney": 4,
    "eurodisney(1)": 4,
    "eurodollar": 4,
    "eurodollar(1)": 4,
    "eurodollars": 4,
    "eurofighter": 4,
    "eurofighters": 4,
    "eurofima": 4,
    "euromark": 3,
    "euromarket": 4,
    "euromarkets": 4,
    "euromissile": 4,
    "euromissiles": 4,
    "euromobiliare": 5,
    "euromobiliare's": 5,
    "euromoney": 4,
    "euronote": 3,
    "euronotes": 3,
    "europa": 3,
    "europe": 2,
    "europe's": 2,
    "european": 4,
    "europeans": 4,
    "europeans'": 4,
    "europeenne": 3,
    "europewide": 3,
    "europhile": 3,
    "europhiles": 3,
    "europium": 4,
    "euros": 2,
    "eurosid": 3,
    "eurostar": 3,
    "eurostat": 3,
    "eurosterling": 4,
    "eurotunnel": 4,
    "eurotunnel's": 4,
    "euroyen": 3,
    "eury": 2,
    "eusebio": 4,
    "eustace": 2,
    "eustachian": 4,
    "eustacia": 3,
    "eustice": 2,
    "eustis": 2,
    "euthanasia": 4,
    "euthanasia(1)": 4,
    "euthanasia's": 4,
    "euthanize": 3,
    "eutsey": 2,
    "eutsler": 2,
    "ev": 1,
    "eva": 2,
    "eva(1)": 2,
    "eva's": 2,
    "eva's(1)": 2,
    "evacuate": 4,
    "evacuate(1)": 4,
    "evacuated": 5,
    "evacuated(1)": 5,
    "evacuating": 5,
    "evacuating(1)": 5,
    "evacuation": 5,
    "evacuation(1)": 5,
    "evacuations": 5,
    "evacuations(1)": 5,
    "evacuee": 4,
    "evacuee(1)": 4,
    "evacuees": 4,
    "evacuees(1)": 4,
    "evade": 2,
    "evade(1)": 2,
    "evaded": 3,
    "evaded(1)": 3,
    "evader": 3,
    "evader(1)": 3,
    "evaders": 3,
    "evaders(1)": 3,
    "evades": 2,
    "evades(1)": 2,
    "evading": 3,
    "evading(1)": 3,
    "evadne": 3,
    "evald": 2,
    "evald(1)": 2,
    "evaleen": 3,
    "evaluate": 4,
    "evaluate(1)": 4,
    "evaluated": 5,
    "evaluated(1)": 5,
    "evaluates": 4,
    "evaluates(1)": 4,
    "evaluating": 5,
    "evaluating(1)": 5,
    "evaluation": 5,
    "evaluation(1)": 5,
    "evaluations": 5,
    "evaluations(1)": 5,
    "evan": 2,
    "evancho": 3,
    "evander": 3,
    "evandro": 3,
    "evandro(1)": 3,
    "evanescence": 4,
    "evanescent": 4,
    "evangelical": 5,
    "evangelicals": 5,
    "evangeline": 4,
    "evangelism": 5,
    "evangelism(1)": 5,
    "evangelist": 4,
    "evangelist(1)": 4,
    "evangelista": 5,
    "evangelistic": 5,
    "evangelists": 4,
    "evangelists(1)": 4,
    "evangelists(2)": 4,
    "evangelists(3)": 4,
    "evangelize": 4,
    "evangelize(1)": 4,
    "evangi": 3,
    "evanko": 3,
    "evanoff": 3,
    "evanov": 3,
    "evans": 2,
    "evans'": 2,
    "evans's": 3,
    "evanson": 3,
    "evanston": 3,
    "evansville": 3,
    "evaporate": 4,
    "evaporated": 5,
    "evaporated(1)": 5,
    "evaporated(2)": 5,
    "evaporated(3)": 5,
    "evaporates": 4,
    "evaporates(1)": 4,
    "evaporating": 5,
    "evaporating(1)": 5,
    "evaporation": 5,
    "evaporation(1)": 5,
    "evaporator": 5,
    "evaporator(1)": 5,
    "evarts": 2,
    "evasion": 3,
    "evasion(1)": 3,
    "evasions": 3,
    "evasions(1)": 3,
    "evasive": 3,
    "evasive(1)": 3,
    "evatt": 2,
    "eve": 1,
    "evel": 2,
    "eveland": 2,
    "eveleth": 3,
    "evelina": 4,
    "eveline": 3,
    "evelyn": 3,
    "evelyn(1)": 3,
    "even": 2,
    "evendale": 3,
    "evened": 2,
    "evenhanded": 4,
    "evenhandedly": 5,
    "evening": 2,
    "evening's": 2,
    "evenings": 2,
    "evenly": 3,
    "evenness": 3,
    "evens": 2,
    "evensen": 3,
    "evensky": 3,
    "evenson": 3,
    "event": 2,
    "event(1)": 2,
    "event's": 2,
    "event's(1)": 2,
    "eventful": 3,
    "eventful(1)": 3,
    "events": 2,
    "events(1)": 2,
    "eventual": 4,
    "eventual(1)": 4,
    "eventuality": 6,
    "eventuality(1)": 6,
    "eventually": 5,
    "eventually(1)": 4,
    "eventually(2)": 5,
    "eventually(3)": 4,
    "ever": 2,
    "everage": 3,
    "everard": 3,
    "everbach": 3,
    "everding": 3,
    "eveready": 4,
    "evered": 2,
    "everest": 3,
    "everest(1)": 2,
    "everest's": 3,
    "everest's(1)": 2,
    "everett": 3,
    "everett(1)": 2,
    "everette": 3,
    "everetts": 3,
    "everetts(1)": 2,
    "everex": 3,
    "everglades": 3,
    "everglades'": 3,
    "evergood": 3,
    "evergreen": 3,
    "evergreens": 3,
    "everhardt": 3,
    "everhart": 3,
    "everidge": 3,
    "everingham": 4,
    "everington": 4,
    "everitt": 3,
    "everlast": 3,
    "everlasting": 4,
    "everlastings": 4,
    "everley": 3,
    "everling": 3,
    "everly": 3,
    "everman": 3,
    "evermore": 3,
    "evers": 2,
    "evers'": 2,
    "eversman": 3,
    "eversole": 3,
    "everson": 3,
    "evert": 2,
    "everton": 3,
    "everts": 2,
    "every": 3,
    "every(1)": 2,
    "everybody": 4,
    "everybody'd": 4,
    "everybody's": 4,
    "everyday": 3,
    "everyman": 3,
    "everyman's": 3,
    "everyone": 3,
    "everyone's": 3,
    "everyplace": 3,
    "everything": 3,
    "everything's": 3,
    "everythings": 3,
    "everytime": 3,
    "everywhere": 3,
    "everywhere(1)": 3,
    "eves": 1,
    "evett": 2,
    "evetts": 2,
    "evian": 3,
    "evict": 2,
    "evicted": 3,
    "evicting": 3,
    "eviction": 3,
    "evictions": 3,
    "evidence": 3,
    "evidenced": 3,
    "evidences": 4,
    "evident": 3,
    "evidentiary": 6,
    "evidentiary(1)": 6,
    "evidently": 4,
    "evil": 2,
    "evildoer": 4,
    "evildoers": 4,
    "evils": 2,
    "evilsizer": 4,
    "evilsizor": 4,
    "evin": 2,
    "evince": 2,
    "evinced": 2,
    "evinger": 3,
    "evins": 2,
    "eviscerate": 4,
    "eviscerated": 5,
    "evita": 3,
    "evitt": 2,
    "evitts": 2,
    "evjen": 2,
    "evlyn": 2,
    "evocation": 4,
    "evocative": 4,
    "evoke": 2,
    "evoke(1)": 2,
    "evoked": 2,
    "evoked(1)": 2,
    "evokes": 2,
    "evokes(1)": 2,
    "evoking": 3,
    "evoking(1)": 3,
    "evola": 3,
    "evolution": 4,
    "evolution(1)": 4,
    "evolution(2)": 4,
    "evolution(3)": 4,
    "evolutionary": 6,
    "evolutionary(1)": 6,
    "evolutionary(2)": 6,
    "evolutionary(3)": 6,
    "evolve": 2,
    "evolve(1)": 2,
    "evolved": 2,
    "evolved(1)": 2,
    "evolves": 2,
    "evolves(1)": 2,
    "evolving": 3,
    "evolving(1)": 3,
    "evon": 2,
    "evonne": 2,
    "evrard": 2,
    "evren": 2,
    "ewald": 2,
    "ewalt": 2,
    "ewan": 2,
    "ewart": 2,
    "ewbal": 2,
    "ewbank": 2,
    "ewe": 1,
    "ewell": 2,
    "ewen": 2,
    "ewer": 2,
    "ewers": 2,
    "ewert": 2,
    "ewes": 1,
    "ewig": 2,
    "ewing": 2,
    "ewing's": 2,
    "ewings": 2,
    "ewoldt": 2,
    "ewong": 2,
    "eworld": 2,
    "ewton": 2,
    "ewy": 2,
    "ex": 1,
    "ex-fighter": 3,
    "ex-voto": 3,
    "exabyte": 3,
    "exacerbate": 4,
    "exacerbated": 5,
    "exacerbated(1)": 5,
    "exacerbates": 4,
    "exacerbating": 5,
    "exacerbation": 5,
    "exacerbations": 5,
    "exact": 2,
    "exacted": 3,
    "exacting": 3,
    "exaction": 3,
    "exactions": 3,
    "exactitude": 4,
    "exactly": 3,
    "exactly's": 3,
    "exacts": 2,
    "exaggerate": 4,
    "exaggerated": 5,
    "exaggerated(1)": 5,
    "exaggerates": 4,
    "exaggerating": 5,
    "exaggeration": 5,
    "exaggerations": 5,
    "exalt": 2,
    "exalted": 3,
    "exalting": 3,
    "exalts": 2,
    "exam": 2,
    "examination": 5,
    "examinations": 5,
    "examine": 3,
    "examined": 3,
    "examiner": 4,
    "examiner's": 4,
    "examiners": 4,
    "examiners'": 4,
    "examines": 3,
    "examining": 4,
    "example": 3,
    "examples": 3,
    "exams": 2,
    "exar": 2,
    "exasperate": 4,
    "exasperated": 5,
    "exasperating": 5,
    "exasperation": 5,
    "exboyfriend": 3,
    "exbroker": 3,
    "exbroker's": 3,
    "exbrokers": 3,
    "excalibur": 4,
    "excavate": 3,
    "excavated": 4,
    "excavating": 4,
    "excavation": 4,
    "excavations": 4,
    "excavator": 4,
    "excavators": 4,
    "excedrin": 3,
    "exceed": 2,
    "exceeded": 3,
    "exceeded(1)": 3,
    "exceeding": 3,
    "exceedingly": 4,
    "exceeds": 2,
    "excel": 2,
    "excel's": 2,
    "excelan": 3,
    "excelled": 2,
    "excellence": 3,
    "excellencies": 3,
    "excellency": 3,
    "excellent": 3,
    "excellently": 4,
    "excelling": 3,
    "excels": 2,
    "excelsior": 4,
    "except": 2,
    "excepted": 3,
    "excepting": 3,
    "exception": 3,
    "exceptional": 4,
    "exceptionally": 5,
    "exceptionally(1)": 4,
    "exceptions": 3,
    "excerpt": 2,
    "excerpt(1)": 2,
    "excerpted": 3,
    "excerpts": 2,
    "excerpts(1)": 2,
    "excess": 2,
    "excess(1)": 2,
    "excesses": 3,
    "excesses(1)": 3,
    "excessive": 3,
    "excessively": 4,
    "exchange": 2,
    "exchange's": 3,
    "exchangeable": 4,
    "exchanged": 2,
    "exchanger": 3,
    "exchangers": 3,
    "exchanges": 3,
    "exchanges(1)": 3,
    "exchanges'": 3,
    "exchanging": 3,
    "exchequer": 3,
    "excimer": 3,
    "excise": 2,
    "excise(1)": 2,
    "excised": 2,
    "excises": 3,
    "excision": 3,
    "excitable": 4,
    "excitation": 4,
    "excite": 2,
    "excited": 3,
    "excited(1)": 3,
    "excitedly": 4,
    "excitement": 3,
    "excites": 2,
    "exciting": 3,
    "exclaim": 2,
    "exclaimed": 2,
    "exclaiming": 3,
    "exclaims": 2,
    "exclamation": 4,
    "exclamation-point": 5,
    "exclamations": 4,
    "excludable": 4,
    "exclude": 2,
    "excluded": 3,
    "excluded(1)": 3,
    "excludes": 2,
    "excluding": 3,
    "exclusion": 3,
    "exclusionary": 5,
    "exclusions": 3,
    "exclusive": 3,
    "exclusively": 4,
    "exclusives": 3,
    "exclusivity": 5,
    "exco": 2,
    "excoa": 3,
    "excommunicate": 5,
    "excommunicated": 6,
    "excommunication": 6,
    "excoriate": 4,
    "excoriated": 5,
    "excoriating": 5,
    "excoriation": 5,
    "excrement": 3,
    "excrete": 2,
    "excretion": 3,
    "excretory": 4,
    "excruciating": 5,
    "excruciatingly": 6,
    "exculpate": 3,
    "exculpatory": 5,
    "excursion": 3,
    "excursions": 3,
    "excusable": 4,
    "excuse": 2,
    "excuse(1)": 2,
    "excused": 2,
    "excuses": 3,
    "excuses(1)": 3,
    "excusing": 3,
    "exec": 2,
    "execrable": 4,
    "execs": 2,
    "execute": 3,
    "executed": 4,
    "executed(1)": 4,
    "executes": 3,
    "executing": 4,
    "execution": 4,
    "executioner": 5,
    "executioner's": 5,
    "executioners": 5,
    "executions": 4,
    "executive": 4,
    "executive's": 4,
    "executives": 4,
    "executives'": 4,
    "executone": 4,
    "executor": 4,
    "executors": 4,
    "exel": 2,
    "exemplar": 3,
    "exemplars": 3,
    "exemplary": 4,
    "exemplified": 4,
    "exemplifies": 4,
    "exemplify": 4,
    "exemplifying": 5,
    "exemplum": 3,
    "exempt": 2,
    "exempted": 3,
    "exempting": 3,
    "exemption": 3,
    "exemption(1)": 3,
    "exemptions": 3,
    "exemptions(1)": 3,
    "exempts": 2,
    "exercisable": 5,
    "exercise": 3,
    "exercised": 3,
    "exerciser": 4,
    "exercisers": 4,
    "exercises": 4,
    "exercises(1)": 4,
    "exercising": 4,
    "exert": 2,
    "exerted": 3,
    "exerting": 3,
    "exertion": 3,
    "exertions": 3,
    "exerts": 2,
    "exes": 2,
    "exeter": 3,
    "exfoliate": 4,
    "exfoliation": 5,
    "exhalation": 4,
    "exhale": 2,
    "exhaled": 2,
    "exhaust": 2,
    "exhausted": 3,
    "exhausted(1)": 3,
    "exhausting": 3,
    "exhaustion": 3,
    "exhaustive": 3,
    "exhaustively": 4,
    "exhausts": 2,
    "exhibit": 3,
    "exhibit's": 3,
    "exhibited": 4,
    "exhibiting": 4,
    "exhibition": 4,
    "exhibitionist": 5,
    "exhibitionists": 5,
    "exhibitions": 4,
    "exhibitor": 4,
    "exhibitors": 4,
    "exhibits": 3,
    "exhilarate": 4,
    "exhilarated": 5,
    "exhilarating": 5,
    "exhilaration": 5,
    "exhort": 2,
    "exhortation": 4,
    "exhortations": 4,
    "exhorted": 3,
    "exhorting": 3,
    "exhorts": 2,
    "exhumation": 4,
    "exhume": 2,
    "exhumed": 2,
    "exhumes": 2,
    "exide": 2,
    "exigencies": 4,
    "exigency": 4,
    "exigent": 3,
    "exigents": 3,
    "exile": 2,
    "exile(1)": 2,
    "exiled": 2,
    "exiled(1)": 2,
    "exiles": 2,
    "exiles(1)": 2,
    "exim": 2,
    "exim's": 2,
    "exist": 2,
    "existed": 3,
    "existence": 3,
    "existence(1)": 3,
    "existent": 3,
    "existential": 4,
    "existential(1)": 4,
    "existing": 3,
    "exists": 2,
    "exit": 2,
    "exit(1)": 2,
    "exited": 3,
    "exiting": 3,
    "exits": 2,
    "exits(1)": 2,
    "exler": 2,
    "exley": 2,
    "exline": 2,
    "exner": 2,
    "exocet": 3,
    "exodus": 3,
    "exogenous": 4,
    "exon": 2,
    "exonerate": 4,
    "exonerated": 5,
    "exonerates": 4,
    "exonerating": 5,
    "exoneration": 5,
    "exorbitant": 4,
    "exorcist": 3,
    "exoskeleton": 5,
    "exothermic": 4,
    "exotic": 3,
    "exotics": 3,
    "exovir": 3,
    "expand": 2,
    "expandable": 4,
    "expanded": 3,
    "expanded(1)": 3,
    "expanding": 3,
    "expands": 2,
    "expanse": 2,
    "expanses": 3,
    "expansion": 3,
    "expansion(1)": 3,
    "expansion's": 3,
    "expansion's(1)": 3,
    "expansionary": 5,
    "expansionary(1)": 5,
    "expansionism": 5,
    "expansionism(1)": 5,
    "expansionist": 4,
    "expansionist(1)": 4,
    "expansions": 3,
    "expansions(1)": 3,
    "expansive": 3,
    "expatriate": 4,
    "expatriate(1)": 4,
    "expatriates": 4,
    "expatriates(1)": 4,
    "expatriation": 5,
    "expect": 2,
    "expectancies": 4,
    "expectancy": 4,
    "expectant": 3,
    "expectation": 4,
    "expectations": 4,
    "expected": 3,
    "expected(1)": 3,
    "expecting": 3,
    "expectorant": 4,
    "expects": 2,
    "expects(1)": 2,
    "expedia": 4,
    "expedience": 4,
    "expediency": 5,
    "expedient": 4,
    "expedite": 3,
    "expedited": 4,
    "expediting": 4,
    "expedition": 4,
    "expeditionary": 6,
    "expeditions": 4,
    "expeditious": 4,
    "expeditiously": 5,
    "expel": 2,
    "expelled": 2,
    "expelling": 3,
    "expend": 2,
    "expendable": 4,
    "expended": 3,
    "expending": 3,
    "expenditure": 4,
    "expenditure(1)": 4,
    "expenditures": 4,
    "expenditures(1)": 4,
    "expense": 2,
    "expenses": 3,
    "expenses(1)": 3,
    "expensing": 3,
    "expensive": 3,
    "expensively": 4,
    "experience": 4,
    "experienced": 4,
    "experiences": 5,
    "experiencing": 5,
    "experiential": 5,
    "experiment": 4,
    "experiment's": 4,
    "experimental": 5,
    "experimental(1)": 4,
    "experimental(2)": 5,
    "experimental(3)": 4,
    "experimentalist": 6,
    "experimentalist(1)": 6,
    "experimentally": 6,
    "experimentally(1)": 6,
    "experimentation": 6,
    "experimented": 5,
    "experimenter": 5,
    "experimenters": 5,
    "experimenting": 5,
    "experimenting(1)": 5,
    "experiments": 4,
    "expert": 2,
    "expert's": 2,
    "expertise": 3,
    "expertly": 3,
    "experts": 2,
    "experts'": 2,
    "expiate": 3,
    "expiration": 4,
    "expirations": 4,
    "expiratory": 5,
    "expire": 2,
    "expired": 2,
    "expires": 3,
    "expiring": 3,
    "expiry": 3,
    "explain": 2,
    "explainable": 4,
    "explained": 2,
    "explaining": 3,
    "explains": 2,
    "explanation": 4,
    "explanations": 4,
    "explanatory": 5,
    "expletive": 3,
    "expletives": 3,
    "explicable": 4,
    "explicate": 3,
    "explication": 4,
    "explicit": 3,
    "explicite": 3,
    "explicitly": 4,
    "explode": 2,
    "exploded": 3,
    "exploded(1)": 3,
    "explodes": 2,
    "exploding": 3,
    "exploit": 2,
    "exploit(1)": 2,
    "exploitation": 4,
    "exploitative": 4,
    "exploited": 3,
    "exploited(1)": 3,
    "exploiting": 3,
    "exploiting(1)": 3,
    "exploitive": 3,
    "exploitive(1)": 3,
    "exploits": 2,
    "exploration": 4,
    "exploration(1)": 4,
    "exploration's": 4,
    "exploration's(1)": 4,
    "explorations": 4,
    "explorations(1)": 4,
    "exploratory": 5,
    "exploravision": 5,
    "explore": 2,
    "explored": 2,
    "explorer": 3,
    "explorers": 3,
    "explores": 2,
    "exploring": 3,
    "explosion": 3,
    "explosions": 3,
    "explosive": 3,
    "explosively": 4,
    "explosives": 3,
    "explosivos": 4,
    "expo": 2,
    "exponent": 3,
    "exponential": 4,
    "exponential(1)": 4,
    "exponentially": 5,
    "exponentially(1)": 5,
    "exponents": 3,
    "export": 2,
    "exportable": 4,
    "exported": 3,
    "exporter": 3,
    "exporters": 3,
    "exporters'": 3,
    "exporting": 3,
    "exports": 2,
    "expos": 2,
    "expose": 2,
    "exposed": 2,
    "exposes": 3,
    "exposing": 3,
    "exposition": 4,
    "expositions": 4,
    "exposito": 4,
    "exposito(1)": 4,
    "exposure": 3,
    "exposures": 3,
    "expound": 2,
    "expounded": 3,
    "expounding": 3,
    "expounds": 2,
    "express": 2,
    "express'": 2,
    "express's": 3,
    "expressed": 2,
    "expresses": 3,
    "expresses(1)": 3,
    "expressing": 3,
    "expression": 3,
    "expressionism": 5,
    "expressionist": 4,
    "expressionistic": 5,
    "expressionless": 4,
    "expressions": 3,
    "expressive": 3,
    "expressivity": 5,
    "expressly": 3,
    "expresso": 3,
    "expresso(1)": 3,
    "expressway": 3,
    "expropriate": 4,
    "expropriated": 5,
    "expropriation": 5,
    "expropriations": 5,
    "expulsion": 3,
    "expulsions": 3,
    "expunge": 2,
    "expunged": 2,
    "exquisite": 3,
    "exquisitely": 4,
    "extant": 2,
    "extel": 2,
    "extend": 2,
    "extendable": 4,
    "extended": 3,
    "extended(1)": 3,
    "extender": 3,
    "extenders": 3,
    "extendible": 4,
    "extending": 3,
    "extends": 2,
    "extension": 3,
    "extensions": 3,
    "extensive": 3,
    "extensively": 4,
    "extent": 2,
    "extenuate": 4,
    "extenuating": 5,
    "exterior": 4,
    "exteriors": 4,
    "exterminate": 4,
    "exterminated": 5,
    "exterminates": 4,
    "exterminating": 5,
    "extermination": 5,
    "exterminator": 5,
    "exterminators": 5,
    "external": 3,
    "externally": 4,
    "extinct": 2,
    "extinction": 3,
    "extinction(1)": 3,
    "extinctions": 3,
    "extinctions(1)": 3,
    "extinguish": 3,
    "extinguished": 3,
    "extinguisher": 4,
    "extinguishers": 4,
    "extinguishing": 4,
    "extinguishment": 4,
    "extirpate": 3,
    "extirpated": 4,
    "extirpates": 3,
    "extirpating": 4,
    "extol": 2,
    "extolled": 2,
    "extolling": 3,
    "extols": 2,
    "exton": 2,
    "extort": 2,
    "extorted": 3,
    "extorting": 3,
    "extortion": 3,
    "extortionate": 4,
    "extortionate(1)": 4,
    "extortionist": 4,
    "extortionists": 4,
    "extorts": 2,
    "extra": 2,
    "extracellularly": 6,
    "extract": 2,
    "extract(1)": 2,
    "extracted": 3,
    "extracting": 3,
    "extraction": 3,
    "extractions": 3,
    "extracts": 2,
    "extracts(1)": 2,
    "extracurricular": 6,
    "extradite": 3,
    "extradited": 4,
    "extradites": 3,
    "extraditing": 4,
    "extradition": 4,
    "extragalactic": 5,
    "extralegal": 4,
    "extramarital": 5,
    "extraneous": 4,
    "extraneously": 5,
    "extraordinaire": 5,
    "extraordinarily": 6,
    "extraordinary": 6,
    "extraordinary(1)": 5,
    "extrapolate": 4,
    "extrapolated": 5,
    "extrapolates": 4,
    "extrapolating": 5,
    "extrapolation": 5,
    "extras": 2,
    "extrasensory": 5,
    "extraterrestrial": 6,
    "extraterrestrials": 6,
    "extraterritorial": 7,
    "extraterritoriality": 9,
    "extravagance": 4,
    "extravagant": 4,
    "extravagantly": 5,
    "extravaganza": 5,
    "extravaganzas": 5,
    "extravesated": 5,
    "extreme": 2,
    "extremely": 3,
    "extremes": 2,
    "extremism": 4,
    "extremism(1)": 4,
    "extremist": 3,
    "extremists": 3,
    "extremists(1)": 3,
    "extremities": 4,
    "extremity": 4,
    "extricable": 4,
    "extricate": 3,
    "extricated": 4,
    "extricates": 3,
    "extricating": 4,
    "extrication": 4,
    "extrinsic": 3,
    "extrovert": 3,
    "extroverted": 4,
    "extrude": 2,
    "extruded": 3,
    "extrudes": 2,
    "extruding": 3,
    "extrusion": 3,
    "exuberance": 4,
    "exuberant": 4,
    "exude": 2,
    "exuded": 3,
    "exudes": 2,
    "exuding": 3,
    "exult": 2,
    "exultant": 3,
    "exultantly": 4,
    "exulted": 3,
    "exulting": 3,
    "exults": 2,
    "exum": 2,
    "exxon": 2,
    "exxon's": 2,
    "eyde": 1,
    "eydie": 2,
    "eye": 1,
    "eye's": 1,
    "eyeball": 2,
    "eyeballs": 2,
    "eyebrow": 2,
    "eyebrows": 2,
    "eyecare": 2,
    "eyed": 1,
    "eyedrop": 2,
    "eyedropper": 3,
    "eyedrops": 2,
    "eyeglass": 2,
    "eyeglasses": 3,
    "eyeglasses(1)": 3,
    "eyeing": 2,
    "eyelab": 2,
    "eyelash": 2,
    "eyelashes": 3,
    "eyeless": 2,
    "eyelet": 2,
    "eyelets": 2,
    "eyelid": 2,
    "eyelids": 2,
    "eyelike": 2,
    "eyeliner": 3,
    "eyepiece": 2,
    "eyer": 2,
    "eyerly": 3,
    "eyerman": 3,
    "eyes": 1,
    "eyes'": 1,
    "eyeshade": 2,
    "eyesight": 2,
    "eyesore": 2,
    "eyespot": 2,
    "eyestone": 2,
    "eyestrain": 2,
    "eyetech": 2,
    "eyetech's": 2,
    "eyewear": 2,
    "eyewitness": 3,
    "eyewitnesses": 4,
    "eyler": 2,
    "eyman": 2,
    "eynon": 2,
    "eyre": 1,
    "eyrich": 2,
    "eyrie": 2,
    "eyring": 2,
    "eyster": 2,
    "eyton": 2,
    "ezekiel": 3,
    "ezell": 2,
    "ezell's": 2,
    "ezelle": 2,
    "ezer": 2,
    "ezoe": 2,
    "ezola": 3,
    "ezra": 2,
    "ezzell": 2,
    "ezzo": 2,
    "f": 1,
    "f'd": 1,
    "f's": 1,
    "f.": 1,
    "f.'s": 1,
    "faal": 1,
    "faal's": 1,
    "faas": 1,
    "fab": 1,
    "fabbri": 2,
    "fabel": 2,
    "fabela": 3,
    "faber": 2,
    "faberge": 2,
    "faberge(1)": 3,
    "faberman": 3,
    "fabia": 3,
    "fabian": 3,
    "fabiani": 4,
    "fabiano": 4,
    "fabien": 2,
    "fabio": 3,
    "fable": 2,
    "fabled": 2,
    "fables": 2,
    "fabre": 2,
    "fabri": 2,
    "fabric": 2,
    "fabricant": 3,
    "fabricate": 3,
    "fabricated": 4,
    "fabricated(1)": 4,
    "fabricates": 3,
    "fabricating": 4,
    "fabrication": 4,
    "fabrications": 4,
    "fabricator": 4,
    "fabricators": 4,
    "fabrics": 2,
    "fabris": 2,
    "fabrizi": 3,
    "fabrizio": 4,
    "fabrizius": 4,
    "fabron": 2,
    "fabry": 2,
    "fabulous": 3,
    "fabulously": 4,
    "fac": 1,
    "facade": 2,
    "facades": 2,
    "facchini": 3,
    "facciola": 4,
    "face": 1,
    "faced": 1,
    "facedown": 2,
    "faceless": 2,
    "facelift": 2,
    "facemire": 4,
    "facer": 2,
    "faces": 2,
    "faces(1)": 2,
    "facet": 2,
    "facet's": 2,
    "faceted": 3,
    "facetious": 3,
    "facetiously": 4,
    "facets": 2,
    "facey": 2,
    "fachet": 2,
    "facial": 2,
    "facials": 2,
    "faciane": 4,
    "facie": 2,
    "facile": 2,
    "facilitate": 4,
    "facilitated": 5,
    "facilitates": 4,
    "facilitating": 5,
    "facilitation": 5,
    "facilitator": 5,
    "facilitator's": 5,
    "facilitators": 5,
    "facilities": 4,
    "facilities(1)": 4,
    "facility": 4,
    "facility's": 4,
    "facing": 2,
    "facings": 2,
    "fackler": 2,
    "fackrell": 2,
    "facsimile": 4,
    "facsimiles": 4,
    "fact": 1,
    "facteau": 2,
    "faction": 2,
    "factional": 3,
    "factionalism": 5,
    "factions": 2,
    "factitious": 3,
    "factly": 2,
    "facto": 2,
    "factor": 2,
    "factored": 2,
    "factories": 3,
    "factoring": 3,
    "factors": 2,
    "factors'": 2,
    "factory": 3,
    "factory's": 3,
    "facts": 1,
    "facts(1)": 1,
    "factual": 3,
    "factually": 4,
    "facultative": 4,
    "faculties": 3,
    "faculty": 3,
    "fad": 1,
    "fadden": 2,
    "faddis": 2,
    "faddish": 2,
    "fade": 1,
    "faded": 2,
    "faded(1)": 2,
    "fadel": 2,
    "fadeley": 3,
    "fadely": 2,
    "faden": 2,
    "fader": 2,
    "fades": 1,
    "fadiman": 3,
    "fading": 2,
    "fadlallah": 3,
    "fadness": 2,
    "fads": 1,
    "fae": 1,
    "faerber": 2,
    "faeth": 1,
    "fag": 1,
    "fagan": 2,
    "fagen": 2,
    "fager": 2,
    "fagerberg": 3,
    "fagerstrom": 3,
    "fagg": 1,
    "faggart": 2,
    "faggot": 2,
    "fagin": 2,
    "fagley": 2,
    "fagnant": 2,
    "fagoth": 2,
    "fags": 1,
    "fagundes": 2,
    "fahd": 1,
    "faherty": 3,
    "fahey": 2,
    "fahl": 1,
    "fahlman": 2,
    "fahmy": 2,
    "fahnestock": 2,
    "fahr": 1,
    "fahrenheit": 3,
    "fahrenheit's": 3,
    "fahrenkopf": 3,
    "fahrer": 2,
    "fahringer": 3,
    "fahrner": 2,
    "fahrney": 2,
    "fahs": 1,
    "fahy": 2,
    "faidley": 2,
    "faiella": 3,
    "fail": 1,
    "faile": 1,
    "failed": 1,
    "failing": 2,
    "failings": 2,
    "failla": 2,
    "failor": 2,
    "fails": 1,
    "failsafe": 2,
    "failure": 2,
    "failures": 2,
    "fain": 1,
    "faint": 1,
    "fainted": 2,
    "fainter": 2,
    "faintest": 2,
    "fainthearted": 3,
    "fainting": 2,
    "faintly": 2,
    "faintness": 2,
    "faiola": 3,
    "fair": 1,
    "fair's": 1,
    "fair-lawn": 2,
    "fairall": 2,
    "fairbairn": 2,
    "fairbank": 2,
    "fairbanks": 2,
    "fairbrother": 3,
    "fairburn": 2,
    "fairchild": 2,
    "fairchild's": 2,
    "faircloth": 2,
    "fairclough": 2,
    "faire": 1,
    "fairer": 2,
    "faires": 1,
    "fairest": 2,
    "fairey": 2,
    "fairfax": 2,
    "fairfield": 2,
    "fairground": 2,
    "fairgrounds": 2,
    "fairhaven": 3,
    "fairhurst": 2,
    "fairies": 2,
    "fairlawn": 2,
    "fairleigh": 2,
    "fairless": 2,
    "fairley": 2,
    "fairlie": 2,
    "fairlow": 2,
    "fairly": 2,
    "fairman": 2,
    "fairmont": 2,
    "fairness": 2,
    "fairs": 1,
    "fairview": 2,
    "fairway": 2,
    "fairways": 2,
    "fairweather": 3,
    "fairy": 2,
    "fairyland": 3,
    "fairytale": 3,
    "fairytales": 3,
    "faisal": 2,
    "faison": 2,
    "faist": 2,
    "fait": 1,
    "faith": 1,
    "faithful": 2,
    "faithfully": 3,
    "faithfuls": 2,
    "faiths": 1,
    "faivre": 2,
    "fajardo": 3,
    "fajita": 3,
    "fajita(1)": 3,
    "fajitas": 3,
    "fajitas(1)": 3,
    "fake": 1,
    "faked": 1,
    "faker": 2,
    "fakers": 2,
    "fakes": 1,
    "faking": 2,
    "falafel": 3,
    "falanga": 3,
    "falani": 3,
    "falani(1)": 3,
    "falardeau": 3,
    "falasco": 3,
    "falb": 1,
    "falbo": 2,
    "falcigno": 3,
    "falcigno(1)": 3,
    "falck": 1,
    "falco": 2,
    "falcoff": 2,
    "falcon": 2,
    "falconbridge": 3,
    "falconbridge's": 4,
    "falcone": 3,
    "falconer": 3,
    "falconers": 3,
    "falconet": 3,
    "falconets": 3,
    "falconi": 3,
    "falconry": 3,
    "falcons": 2,
    "faldo": 2,
    "faler": 2,
    "fales": 1,
    "faley": 2,
    "falgoust": 2,
    "falgout": 2,
    "falik": 2,
    "falin": 2,
    "falise": 2,
    "falk": 1,
    "falke": 1,
    "falkenberg": 3,
    "falkenstein": 3,
    "falkenstein(1)": 3,
    "falkland": 2,
    "falklands": 2,
    "falkner": 2,
    "falkowski": 3,
    "fall": 1,
    "fall(1)": 1,
    "fall's": 1,
    "falla": 2,
    "fallacies": 3,
    "fallacious": 3,
    "fallaciously": 4,
    "fallacy": 3,
    "fallaw": 2,
    "fallback": 2,
    "fallen": 2,
    "faller": 2,
    "fallert": 2,
    "fallibility": 5,
    "fallible": 3,
    "fallin": 2,
    "falling": 2,
    "fallis": 2,
    "fallish": 2,
    "falloff": 2,
    "fallon": 2,
    "fallopian": 4,
    "fallout": 2,
    "fallouts": 2,
    "fallow": 2,
    "fallows": 2,
    "falls": 1,
    "falmouth": 2,
    "falor": 2,
    "falotico": 4,
    "false": 1,
    "falsehood": 2,
    "falsehoods": 2,
    "falsely": 2,
    "falsetto": 3,
    "falsettos": 3,
    "falsification": 5,
    "falsified": 3,
    "falsify": 3,
    "falsifying": 4,
    "falsity": 3,
    "falsone": 2,
    "falstaff": 2,
    "falstaff's": 2,
    "falter": 2,
    "faltered": 2,
    "faltering": 3,
    "falters": 2,
    "falvey": 2,
    "falvo": 2,
    "falwell": 2,
    "falwell's": 2,
    "falynn": 2,
    "falzarano": 4,
    "falzon": 2,
    "falzone": 3,
    "fama": 2,
    "fambro": 2,
    "fambrough": 2,
    "fame": 1,
    "famed": 1,
    "famer": 2,
    "famers": 2,
    "famiglietti": 5,
    "familial": 3,
    "familiar": 3,
    "familiarity": 5,
    "familiarize": 4,
    "familiarized": 4,
    "families": 3,
    "families(1)": 2,
    "families'": 3,
    "family": 3,
    "family(1)": 2,
    "family's": 3,
    "family's(1)": 2,
    "famine": 2,
    "famines": 2,
    "famished": 2,
    "famous": 2,
    "famously": 3,
    "famularo": 4,
    "fan": 1,
    "fan's": 1,
    "fanara": 3,
    "fanatic": 3,
    "fanatical": 4,
    "fanatically": 5,
    "fanatically(1)": 4,
    "fanaticism": 5,
    "fanatics": 3,
    "fancher": 2,
    "fanchon": 2,
    "fancied": 2,
    "fancier": 3,
    "fanciers": 3,
    "fancies": 2,
    "fanciest": 3,
    "fanciful": 3,
    "fancy": 2,
    "fandango": 3,
    "fandel": 2,
    "fandrich": 2,
    "fane": 1,
    "fanech": 2,
    "fanech's": 2,
    "fanelli": 3,
    "faneuil": 3,
    "fanfare": 2,
    "fang": 1,
    "fanger": 2,
    "fangle": 2,
    "fangled": 2,
    "fangman": 2,
    "fangs": 1,
    "fanguy": 2,
    "fankhauser": 3,
    "fanlike": 2,
    "fann": 1,
    "fanned": 1,
    "fannie": 2,
    "fannin": 2,
    "fanning": 2,
    "fanning's": 2,
    "fannon": 2,
    "fanny": 2,
    "fans": 1,
    "fans'": 1,
    "fansler": 3,
    "fansler(1)": 2,
    "fant": 1,
    "fanta": 2,
    "fantail": 2,
    "fantasia": 3,
    "fantasies": 3,
    "fantasies(1)": 3,
    "fantasize": 3,
    "fantasize(1)": 3,
    "fantasized": 3,
    "fantasized(1)": 3,
    "fantasizes": 4,
    "fantasizes(1)": 4,
    "fantasizing": 4,
    "fantasizing(1)": 4,
    "fantastic": 3,
    "fantastically": 4,
    "fantastik": 3,
    "fantasy": 3,
    "fantasy(1)": 3,
    "fantasyland": 4,
    "fantasyland(1)": 4,
    "fantini": 3,
    "fantle": 2,
    "fanton": 2,
    "fantozzi": 3,
    "fantroy": 2,
    "fanuc": 2,
    "fanucchi": 3,
    "fanueil": 2,
    "fao": 1,
    "far": 1,
    "far's": 1,
    "farabaugh": 3,
    "farabee": 3,
    "farabundo": 4,
    "farace": 3,
    "faraci": 3,
    "faraday": 3,
    "faraday's": 3,
    "faragher": 3,
    "farago": 3,
    "farah": 2,
    "faraha": 3,
    "farahkan": 3,
    "farai": 2,
    "farai(1)": 2,
    "farai(2)": 2,
    "faranda": 3,
    "faraone": 4,
    "faraway": 3,
    "farb": 1,
    "farben": 2,
    "farber": 2,
    "farberware": 3,
    "farbman": 2,
    "farce": 1,
    "farcical": 3,
    "farcical(1)": 3,
    "fare": 1,
    "fared": 1,
    "fares": 1,
    "farese": 3,
    "faretlow": 3,
    "farewell": 2,
    "farewells": 2,
    "farfen": 2,
    "farfetched": 2,
    "farge": 1,
    "fargnoli": 3,
    "fargo": 2,
    "fargo's": 2,
    "farha": 2,
    "farhat": 2,
    "faria": 3,
    "farias": 3,
    "faribault": 3,
    "farica": 3,
    "faridoun": 3,
    "fariello": 4,
    "faries": 2,
    "farina": 3,
    "farinacci": 4,
    "farinas": 3,
    "farinella": 4,
    "faring": 2,
    "farino": 3,
    "faris": 2,
    "farish": 2,
    "fariss": 2,
    "farkas": 2,
    "farland": 2,
    "farlee": 2,
    "farler": 2,
    "farless": 2,
    "farley": 2,
    "farling": 2,
    "farlow": 2,
    "farly": 2,
    "farm": 1,
    "farm's": 1,
    "farman": 2,
    "farmboy": 2,
    "farmed": 1,
    "farmer": 2,
    "farmer's": 2,
    "farmers": 2,
    "farmers'": 2,
    "farmers's": 3,
    "farmhand": 2,
    "farmhands": 2,
    "farmhouse": 2,
    "farmhouses": 3,
    "farmhouses(1)": 3,
    "farming": 2,
    "farming's": 2,
    "farmingdale": 3,
    "farmington": 3,
    "farmland": 2,
    "farmlands": 2,
    "farms": 1,
    "farms'": 1,
    "farmstead": 2,
    "farmworker": 3,
    "farmworkers": 3,
    "farmyard": 2,
    "farnall": 2,
    "farnam": 2,
    "farnan": 2,
    "farnborough": 3,
    "farnell": 2,
    "farner": 2,
    "farnes": 1,
    "farney": 2,
    "farnham": 2,
    "farnley": 2,
    "farnsworth": 2,
    "farnum": 2,
    "farnworth": 2,
    "faro": 2,
    "farold": 2,
    "faron": 2,
    "farone": 2,
    "farouk": 2,
    "farquar": 2,
    "farquhar": 2,
    "farquharson": 4,
    "farr": 1,
    "farra": 2,
    "farragut": 3,
    "farrah": 2,
    "farrakhan": 3,
    "farrakhan's": 3,
    "farran": 2,
    "farrand": 2,
    "farrant": 2,
    "farrar": 2,
    "farrel": 2,
    "farrell": 2,
    "farrell's": 2,
    "farrelly": 3,
    "farren": 2,
    "farrens": 2,
    "farrer": 2,
    "farrey": 2,
    "farrier": 3,
    "farrington": 3,
    "farrior": 3,
    "farris": 2,
    "farrish": 2,
    "farro": 2,
    "farron": 2,
    "farrow": 2,
    "farrow's": 2,
    "farrowing": 3,
    "farruggia": 3,
    "farrugia": 3,
    "farry": 2,
    "farsi": 2,
    "farsighted": 3,
    "farsighted(1)": 3,
    "farsightedness": 4,
    "farson": 2,
    "fart": 1,
    "farther": 2,
    "farthest": 2,
    "farthing": 2,
    "farthingale": 3,
    "farting": 2,
    "farve": 1,
    "farver": 2,
    "farwell": 2,
    "farwest": 2,
    "fasano": 3,
    "fasbender": 3,
    "fascell": 2,
    "fasching": 2,
    "fasciano": 4,
    "fascinate": 3,
    "fascinated": 4,
    "fascinated(1)": 4,
    "fascinates": 3,
    "fascinating": 4,
    "fascination": 4,
    "fascism": 3,
    "fascist": 2,
    "fascists": 2,
    "fashion": 2,
    "fashion's": 2,
    "fashionable": 4,
    "fashionable(1)": 3,
    "fashionably": 4,
    "fashioned": 2,
    "fashioning": 3,
    "fashions": 2,
    "fasick": 2,
    "fasig": 2,
    "fasnacht": 2,
    "faso": 2,
    "faso's": 2,
    "fason": 2,
    "fasone": 3,
    "fass": 1,
    "fassbender": 3,
    "fassett": 2,
    "fassler": 2,
    "fassnacht": 2,
    "fassulo": 3,
    "fast": 1,
    "fastball": 2,
    "fastballs": 2,
    "fasted": 2,
    "fasten": 2,
    "fastened": 2,
    "fastener": 3,
    "fastener(1)": 2,
    "fasteners": 3,
    "fasteners(1)": 2,
    "fastening": 3,
    "fastening(1)": 2,
    "fastenings": 3,
    "fastenings(1)": 2,
    "faster": 2,
    "fastest": 2,
    "fastfood": 2,
    "fastidious": 4,
    "fasting": 2,
    "fastness": 2,
    "fasts": 1,
    "fasulo": 3,
    "fat": 1,
    "fata": 2,
    "fatah": 2,
    "fatah(1)": 2,
    "fatal": 2,
    "fatalism": 4,
    "fatalist": 3,
    "fatalistic": 4,
    "fatalists": 3,
    "fatalities": 4,
    "fatality": 4,
    "fatally": 3,
    "fate": 1,
    "fated": 2,
    "fateful": 2,
    "fateh": 2,
    "fates": 1,
    "fath": 1,
    "father": 2,
    "father's": 2,
    "fathered": 2,
    "fatheree": 3,
    "fatherhood": 3,
    "fathering": 3,
    "fatherland": 3,
    "fatherless": 3,
    "fatherly": 3,
    "fathers": 2,
    "fathers'": 2,
    "fathi": 2,
    "fathom": 2,
    "fathomable": 4,
    "fathoms": 2,
    "fatigue": 2,
    "fatigued": 2,
    "fatigues": 2,
    "fatiguing": 3,
    "fatima": 3,
    "fatima(1)": 3,
    "fatimah": 3,
    "fats": 1,
    "fatten": 2,
    "fattened": 2,
    "fattening": 3,
    "fattening(1)": 2,
    "fatter": 2,
    "fattest": 2,
    "fatties": 2,
    "fatty": 2,
    "fatula": 3,
    "fatuous": 3,
    "fatwa": 2,
    "fatzinger": 3,
    "faubel": 2,
    "fauber": 2,
    "faubert": 2,
    "faubion": 3,
    "fauble": 2,
    "faubus": 2,
    "faucet": 2,
    "faucets": 2,
    "faucett": 2,
    "faucette": 2,
    "faucher": 2,
    "faucheux": 2,
    "fauci": 2,
    "faughn": 1,
    "faughnan": 2,
    "faught": 1,
    "faught's": 1,
    "faul": 1,
    "faulcon": 2,
    "faulconer": 3,
    "faulding": 2,
    "faulds": 1,
    "faulhaber": 3,
    "faulk": 1,
    "faulkenberry": 4,
    "faulkner": 2,
    "faulkner's": 2,
    "faulks": 1,
    "faull": 1,
    "faulstich": 2,
    "fault": 1,
    "faulted": 2,
    "faulting": 2,
    "faults": 1,
    "faulty": 2,
    "fauna": 2,
    "faunal": 2,
    "faunal(1)": 2,
    "faunce": 1,
    "fauntleroy": 3,
    "fauntroy": 2,
    "faupel": 2,
    "faure": 1,
    "faurot": 2,
    "fauroux": 2,
    "faus": 1,
    "fauser": 2,
    "fausett": 2,
    "fausey": 2,
    "fausnaugh": 2,
    "fauss": 1,
    "faust": 1,
    "fausta": 2,
    "faustian": 2,
    "faustina": 3,
    "faustine": 2,
    "faustino": 3,
    "fausto": 2,
    "faustus": 2,
    "fauteux": 2,
    "fauth": 1,
    "fauver": 2,
    "faux": 1,
    "fava": 2,
    "favale": 3,
    "favaloro": 4,
    "favaro": 3,
    "favata": 3,
    "favazza": 3,
    "fave": 1,
    "favela": 3,
    "faver": 2,
    "favero": 3,
    "favia": 3,
    "favinger": 3,
    "favor": 2,
    "favorability": 6,
    "favorable": 4,
    "favorable(1)": 3,
    "favorably": 4,
    "favorably(1)": 3,
    "favored": 2,
    "favoring": 3,
    "favorite": 3,
    "favorite(1)": 2,
    "favorites": 3,
    "favorites(1)": 2,
    "favoritism": 5,
    "favors": 2,
    "favre": 2,
    "favreau": 2,
    "favro": 2,
    "faw": 1,
    "fawbush": 2,
    "fawcett": 2,
    "fawkes": 1,
    "fawley": 2,
    "fawn": 1,
    "fawning": 2,
    "fawver": 2,
    "fax": 1,
    "faxed": 1,
    "faxer": 2,
    "faxes": 2,
    "faxing": 2,
    "faxon": 2,
    "fay": 1,
    "fay's": 1,
    "fayanjuu": 3,
    "fayanne": 2,
    "fayanne(1)": 2,
    "fayard": 2,
    "faye": 1,
    "faye's": 1,
    "fayed": 1,
    "fayed's": 1,
    "fayette": 2,
    "fayetteville": 3,
    "fayez": 2,
    "fayme": 1,
    "faymonville": 3,
    "fayne": 1,
    "fayrouz": 2,
    "faz": 1,
    "faze": 1,
    "fazed": 1,
    "fazekas": 3,
    "fazenbaker": 4,
    "fazio": 3,
    "fazio(1)": 3,
    "fazzino": 3,
    "fazzio": 3,
    "fe": 1,
    "fe's": 1,
    "feagan": 2,
    "feagans": 2,
    "feagin": 2,
    "feagins": 2,
    "feagle": 2,
    "fealty": 3,
    "fealty(1)": 2,
    "fear": 1,
    "feared": 1,
    "fearful": 2,
    "fearing": 2,
    "fearless": 2,
    "fearn": 1,
    "fearnow": 2,
    "fearon": 2,
    "fears": 1,
    "fearsome": 2,
    "feasel": 2,
    "feasibility": 5,
    "feasible": 3,
    "feasibly": 3,
    "feast": 1,
    "feasted": 2,
    "feaster": 2,
    "feasting": 2,
    "feasts": 1,
    "feat": 1,
    "feather": 2,
    "featherbed": 3,
    "featherbedding": 4,
    "feathered": 2,
    "feathering": 3,
    "feathering(1)": 2,
    "featherless": 3,
    "featherly": 3,
    "feathers": 2,
    "featherston": 3,
    "featherstone": 3,
    "featherweight": 3,
    "feathery": 3,
    "feathery(1)": 2,
    "feats": 1,
    "feature": 2,
    "featured": 2,
    "featureless": 3,
    "features": 2,
    "featuring": 3,
    "feazel": 2,
    "feazell": 2,
    "feb": 4,
    "febles": 2,
    "febres": 2,
    "february": 4,
    "february(1)": 4,
    "february's": 4,
    "february's(1)": 4,
    "fecal": 2,
    "feces": 2,
    "fecher": 2,
    "fechner": 2,
    "fecht": 1,
    "fechter": 2,
    "feck": 1,
    "feckless": 2,
    "fecteau": 2,
    "fecundity": 4,
    "fed": 1,
    "fed's": 1,
    "fedak": 2,
    "fedder": 2,
    "fedders": 2,
    "fedders's": 3,
    "feddersen": 3,
    "fede": 1,
    "fedeccredito": 5,
    "fedele": 2,
    "fedeli": 3,
    "feder": 2,
    "federal": 3,
    "federal(1)": 2,
    "federal's": 3,
    "federal's(1)": 2,
    "federalism": 5,
    "federalism(1)": 4,
    "federalist": 4,
    "federalist(1)": 3,
    "federalists": 4,
    "federalists(1)": 4,
    "federalists(2)": 3,
    "federalists(3)": 3,
    "federalize": 4,
    "federalize(1)": 3,
    "federalized": 4,
    "federalized(1)": 3,
    "federalizing": 5,
    "federalizing(1)": 4,
    "federally": 4,
    "federally(1)": 3,
    "federals": 3,
    "federals(1)": 2,
    "federate": 3,
    "federated": 4,
    "federated's": 4,
    "federation": 4,
    "federation's": 4,
    "federations": 4,
    "federative": 4,
    "federative(1)": 3,
    "federbush": 3,
    "federer": 3,
    "federica": 4,
    "federici": 4,
    "federico": 4,
    "federle": 3,
    "federman": 3,
    "federoff": 3,
    "federov": 3,
    "federspiel": 3,
    "fedewa": 3,
    "fedex": 2,
    "fediay": 3,
    "fedler": 2,
    "fedor": 2,
    "fedora": 3,
    "fedorchak": 3,
    "fedorko": 3,
    "fedrick": 2,
    "feds": 1,
    "fee": 1,
    "feeback": 2,
    "feebis": 2,
    "feeble": 2,
    "feebly": 2,
    "feed": 1,
    "feedback": 2,
    "feeder": 2,
    "feeders": 2,
    "feeding": 2,
    "feedings": 2,
    "feedlot": 2,
    "feedlots": 2,
    "feeds": 1,
    "feedstock": 2,
    "feedstocks": 2,
    "feehan": 2,
    "feel": 1,
    "feeler": 2,
    "feelers": 2,
    "feeley": 2,
    "feelin'": 2,
    "feeling": 2,
    "feelings": 2,
    "feels": 1,
    "feely": 2,
    "feemster": 2,
    "feeney": 2,
    "feenstra": 2,
    "feeny": 2,
    "fees": 1,
    "feese": 1,
    "feeser": 2,
    "feet": 1,
    "feezor": 2,
    "feffer": 2,
    "fegan": 2,
    "feger": 2,
    "fegley": 2,
    "feher": 2,
    "fehl": 1,
    "fehling": 2,
    "fehlman": 2,
    "fehn": 1,
    "fehnel": 2,
    "fehr": 1,
    "fehrenbach": 3,
    "fehrenbacher": 4,
    "fehring": 2,
    "fehringer": 3,
    "fehrman": 2,
    "feick": 1,
    "feickert": 2,
    "feig": 1,
    "feige": 1,
    "feigel": 2,
    "feigen": 2,
    "feigenbaum": 3,
    "feiger": 2,
    "feighan": 2,
    "feighner": 2,
    "feight": 1,
    "feigin": 2,
    "feign": 1,
    "feigned": 1,
    "feigning": 2,
    "feil": 1,
    "feild": 1,
    "feiler": 2,
    "feimster": 2,
    "fein": 1,
    "fein(1)": 1,
    "fein's": 1,
    "fein's(1)": 1,
    "feinauer": 3,
    "feinberg": 2,
    "feiner": 2,
    "feinerman": 3,
    "feingold": 2,
    "feinman": 2,
    "feinstein": 2,
    "feinstein(1)": 2,
    "feinstein's": 2,
    "feinstein's(1)": 2,
    "feint": 1,
    "feis": 1,
    "feist": 1,
    "feister": 2,
    "feisty": 2,
    "feit": 1,
    "feith": 1,
    "feith's": 1,
    "feitz": 1,
    "fejes": 2,
    "fekete": 2,
    "fel": 1,
    "fela": 2,
    "felan": 2,
    "felbatol": 3,
    "felber": 2,
    "felch": 1,
    "feld": 1,
    "felda": 2,
    "feldberg": 2,
    "feldblum": 2,
    "feldblum(1)": 2,
    "felde": 1,
    "feldene": 2,
    "felder": 2,
    "felderman": 3,
    "feldhaus": 2,
    "feldkamp": 2,
    "feldman": 2,
    "feldman's": 2,
    "feldmann": 2,
    "feldmeier": 3,
    "feldmuehle": 3,
    "feldner": 2,
    "feldpausch": 2,
    "feldspar": 2,
    "feldspars": 2,
    "feldstein": 2,
    "feldstein(1)": 2,
    "feldstein's": 2,
    "feldstein's(1)": 2,
    "feldt": 1,
    "felgenhauer": 4,
    "felger": 2,
    "felice": 2,
    "felicetti": 4,
    "felicia": 3,
    "felicia's": 3,
    "feliciano": 5,
    "feliciano(1)": 5,
    "feliciano's": 5,
    "feliciano's(1)": 5,
    "felicitate": 4,
    "felicite": 3,
    "felicite(1)": 4,
    "felicitous": 4,
    "felicity": 4,
    "felim": 2,
    "feline": 2,
    "felines": 2,
    "felipe": 2,
    "felis": 2,
    "felix": 2,
    "felix's": 3,
    "feliz": 2,
    "felkel": 2,
    "felker": 2,
    "felker's": 2,
    "felkins": 2,
    "felkner": 2,
    "fell": 1,
    "fella": 2,
    "felland": 2,
    "fellas": 2,
    "fellatio": 4,
    "felled": 1,
    "felleisen": 3,
    "fellenz": 2,
    "feller": 2,
    "fellers": 2,
    "fellheimer": 3,
    "fellin": 2,
    "felling": 2,
    "fellinger": 3,
    "fellini": 3,
    "fellman": 2,
    "fellmeth": 2,
    "fellner": 2,
    "fellow": 2,
    "fellow's": 2,
    "fellowes": 2,
    "fellows": 2,
    "fellowship": 3,
    "fellowships": 3,
    "fells": 1,
    "fellsway": 2,
    "felman": 2,
    "felmlee": 2,
    "felon": 2,
    "felonies": 3,
    "felonious": 4,
    "felons": 2,
    "felony": 3,
    "felps": 1,
    "felrice": 2,
    "fels": 1,
    "felsenthal": 3,
    "felske": 1,
    "felt": 1,
    "felten": 2,
    "felter": 2,
    "feltes": 1,
    "feltler": 2,
    "feltman": 2,
    "feltner": 2,
    "felton": 2,
    "feltrax": 2,
    "felts": 1,
    "feltsman": 2,
    "feltus": 2,
    "felty": 2,
    "feltz": 1,
    "felucca": 3,
    "felver": 2,
    "fema": 2,
    "female": 2,
    "female's": 2,
    "females": 2,
    "femia": 3,
    "femina": 3,
    "feminine": 3,
    "femininity": 5,
    "feminism": 4,
    "feminist": 3,
    "feminists": 3,
    "femme": 1,
    "femoral": 3,
    "femrite": 2,
    "femsa": 2,
    "femur": 2,
    "fen": 1,
    "fenagle": 3,
    "fence": 1,
    "fenced": 1,
    "fenceless": 2,
    "fences": 2,
    "fences(1)": 2,
    "fencing": 2,
    "fencl": 2,
    "fend": 1,
    "fended": 2,
    "fender": 2,
    "fenders": 2,
    "fenderson": 3,
    "fendi": 2,
    "fending": 2,
    "fendler": 2,
    "fendley": 2,
    "fendrick": 2,
    "fends": 1,
    "fendt": 1,
    "fenech": 2,
    "fenella": 3,
    "fenelon": 3,
    "fenfluramine": 4,
    "feng": 1,
    "fenger": 2,
    "fenian": 3,
    "fenichell": 3,
    "fenimore": 3,
    "fenjves": 3,
    "fenjves(1)": 2,
    "fenley": 2,
    "fenlon": 2,
    "fenn": 1,
    "fennel": 2,
    "fennell": 2,
    "fennelly": 3,
    "fennema": 3,
    "fenner": 2,
    "fennessey": 3,
    "fennessy": 3,
    "fennewald": 3,
    "fenney": 2,
    "fennimore": 3,
    "fenno": 2,
    "fenoglio": 4,
    "fenphen": 2,
    "fenske": 1,
    "fenster": 2,
    "fenstermacher": 4,
    "fenstermaker": 4,
    "fensterstock": 3,
    "fent": 1,
    "fenter": 2,
    "fenton": 2,
    "fentress": 2,
    "fenugreek": 3,
    "fenway": 2,
    "fenwick": 2,
    "fenwood": 2,
    "fenyvessy": 4,
    "fenzel": 2,
    "feodor": 3,
    "feodora": 4,
    "feodorovich": 5,
    "feola": 3,
    "fer": 1,
    "fer(1)": 1,
    "fera": 2,
    "feral": 2,
    "feraluzi": 4,
    "ferarro": 3,
    "ferber": 2,
    "ferch": 1,
    "ferd": 1,
    "ferderer": 3,
    "ferdie": 2,
    "ferdig": 2,
    "ferdinand": 3,
    "ferdinand(1)": 3,
    "ferdinanda": 4,
    "ferdlow": 2,
    "ferdon": 2,
    "ferebee": 3,
    "ferenc": 2,
    "ference": 2,
    "ferencz": 2,
    "feretlow": 3,
    "feretlow(1)": 2,
    "ferg": 1,
    "fergason": 3,
    "ferger": 2,
    "fergerson": 3,
    "fergeson": 3,
    "fergie": 2,
    "fergus": 2,
    "ferguson": 3,
    "ferguson's": 3,
    "fergusson": 3,
    "feria": 3,
    "ferko": 2,
    "ferland": 2,
    "ferm": 1,
    "ferman": 2,
    "fermata": 3,
    "ferment": 2,
    "ferment(1)": 2,
    "fermenta": 3,
    "fermenta(1)": 3,
    "fermenta's": 3,
    "fermenta's(1)": 3,
    "fermentation": 4,
    "fermented": 3,
    "fermenting": 3,
    "ferments": 2,
    "fermi": 2,
    "fermilab": 3,
    "fermin": 2,
    "fermium": 3,
    "fermoyle": 2,
    "fern": 1,
    "fernald": 2,
    "fernald(1)": 2,
    "fernand": 2,
    "fernand(1)": 2,
    "fernand(2)": 2,
    "fernanda": 3,
    "fernanda(1)": 3,
    "fernandes": 3,
    "fernandes(1)": 3,
    "fernandez": 3,
    "fernandez(1)": 3,
    "fernandez(2)": 3,
    "fernandez(3)": 3,
    "fernandina": 4,
    "fernando": 3,
    "fernando(1)": 3,
    "fernando's": 3,
    "fernando's(1)": 3,
    "fernao": 2,
    "fernau": 2,
    "fernbank": 2,
    "fernberg": 2,
    "ferndale": 2,
    "ferner": 2,
    "fernery": 3,
    "fernholz": 2,
    "fernicola": 4,
    "fernlike": 2,
    "ferns": 1,
    "fernstrom": 2,
    "fero": 2,
    "ferocious": 3,
    "ferociously": 4,
    "ferocity": 4,
    "ferol": 2,
    "ferra": 2,
    "ferraioli": 4,
    "ferrall": 2,
    "ferran": 2,
    "ferrand": 2,
    "ferrandino": 4,
    "ferrando": 3,
    "ferrant": 2,
    "ferrante": 3,
    "ferranti": 3,
    "ferranti(1)": 3,
    "ferrar": 2,
    "ferrara": 3,
    "ferrari": 3,
    "ferrario": 4,
    "ferraris": 3,
    "ferraro": 3,
    "ferraro's": 3,
    "ferre": 1,
    "ferrebee": 3,
    "ferree": 2,
    "ferreira": 3,
    "ferreiro": 3,
    "ferrel": 2,
    "ferrell": 2,
    "ferrelli": 3,
    "ferren": 2,
    "ferrency": 3,
    "ferrentino": 4,
    "ferrer": 2,
    "ferrera": 3,
    "ferreri": 3,
    "ferrero": 3,
    "ferret": 2,
    "ferreted": 3,
    "ferreted(1)": 3,
    "ferreting": 3,
    "ferrets": 2,
    "ferretti": 3,
    "ferri": 2,
    "ferrick": 2,
    "ferrie": 2,
    "ferried": 2,
    "ferrier": 3,
    "ferriera": 3,
    "ferriers": 3,
    "ferries": 2,
    "ferrigno": 3,
    "ferrill": 2,
    "ferrin": 2,
    "ferrington": 3,
    "ferrini": 3,
    "ferris": 2,
    "ferriss": 2,
    "ferrite": 2,
    "ferriter": 3,
    "ferriz": 2,
    "ferro": 2,
    "ferrochrome": 3,
    "ferrofluidic": 5,
    "ferrofluidics": 5,
    "ferromagnet": 4,
    "ferromagnetic": 5,
    "ferromagnetism": 6,
    "ferron": 2,
    "ferrone": 3,
    "ferronickel": 4,
    "ferrotype": 3,
    "ferrous": 2,
    "ferrucci": 3,
    "ferruzzi": 3,
    "ferruzzi's": 3,
    "ferry": 2,
    "ferry's": 2,
    "ferryboat": 3,
    "ferryboats": 3,
    "ferrying": 3,
    "ferryman": 3,
    "fertig": 2,
    "fertile": 2,
    "fertile(1)": 2,
    "fertility": 4,
    "fertility(1)": 4,
    "fertilization": 5,
    "fertilize": 3,
    "fertilized": 3,
    "fertilizer": 4,
    "fertilizers": 4,
    "fertilizes": 4,
    "fertilizing": 4,
    "fertitta": 3,
    "fertlow": 2,
    "ferullo": 3,
    "fervent": 2,
    "fervently": 3,
    "fervid": 2,
    "fervor": 2,
    "fery": 2,
    "feschbach": 2,
    "fescue": 2,
    "feser": 2,
    "feshbach": 2,
    "fesler": 3,
    "fesler(1)": 2,
    "fesmire": 2,
    "fesperman": 3,
    "fess": 1,
    "fessed": 1,
    "fessel": 2,
    "fessenden": 3,
    "fessler": 2,
    "fest": 1,
    "festa": 2,
    "fester": 2,
    "festered": 2,
    "festering": 3,
    "festiva": 3,
    "festival": 3,
    "festival(1)": 3,
    "festival's": 3,
    "festivals": 3,
    "festivals(1)": 3,
    "festive": 2,
    "festivities": 4,
    "festivity": 4,
    "festoon": 2,
    "festooned": 2,
    "fests": 1,
    "festspielhaus": 3,
    "festus": 2,
    "fetal": 2,
    "fetch": 1,
    "fetched": 1,
    "fetches": 2,
    "fetching": 2,
    "fete": 1,
    "feted": 2,
    "fetherolf": 3,
    "fetherston": 3,
    "fetid": 2,
    "fetish": 2,
    "fetishism": 4,
    "fetishist": 3,
    "fetishist(1)": 3,
    "fetishists": 3,
    "fetishists(1)": 3,
    "fetner": 2,
    "fetrow": 2,
    "fetsch": 1,
    "fetsko": 2,
    "fett": 1,
    "fette": 1,
    "fetter": 2,
    "fettered": 2,
    "fetterhoff": 3,
    "fetterly": 3,
    "fetterman": 3,
    "fetterolf": 3,
    "fetters": 2,
    "fettes": 1,
    "fettig": 2,
    "fetting": 2,
    "fettuccine": 4,
    "fetty": 2,
    "fetus": 2,
    "fetuses": 3,
    "fetz": 1,
    "fetzer": 2,
    "feucht": 1,
    "feud": 1,
    "feudal": 2,
    "feudalism": 4,
    "feudalistic": 4,
    "feuded": 2,
    "feuding": 2,
    "feuds": 1,
    "feuer": 2,
    "feuerborn": 3,
    "feuerman": 3,
    "feuerstein": 3,
    "feuerstein(1)": 3,
    "feulner": 2,
    "feur": 1,
    "feustel": 2,
    "feutz": 1,
    "fever": 2,
    "fevered": 2,
    "feverfew": 3,
    "feverfews": 3,
    "feverish": 3,
    "feverishly": 4,
    "fevers": 2,
    "few": 1,
    "fewell": 2,
    "fewer": 2,
    "fewest": 2,
    "fey": 1,
    "feyen": 1,
    "feynman": 2,
    "fez": 1,
    "fi": 1,
    "fi(1)": 1,
    "fiacco": 3,
    "fiala": 3,
    "fialkowski": 4,
    "fiance": 3,
    "fiance(1)": 3,
    "fiancee": 3,
    "fianna": 3,
    "fiasco": 3,
    "fiascos": 3,
    "fiat": 2,
    "fiat's": 2,
    "fiato": 3,
    "fiato(1)": 2,
    "fiber": 2,
    "fiber's": 2,
    "fiberboard": 3,
    "fiberglas": 3,
    "fiberglass": 3,
    "fiberoptic": 4,
    "fibers": 2,
    "fiberweb": 3,
    "fibonacci": 4,
    "fibre": 2,
    "fibreboard": 3,
    "fibrile": 2,
    "fibriles": 2,
    "fibrillation": 4,
    "fibrin": 2,
    "fibroid": 2,
    "fibroids": 2,
    "fibronic": 3,
    "fibronics": 3,
    "fibrosis": 3,
    "fibrous": 2,
    "fibula": 3,
    "fica": 2,
    "ficarra": 3,
    "ficarra(1)": 3,
    "ficco": 2,
    "ficek": 2,
    "fichera": 3,
    "fichtel": 2,
    "fichter": 2,
    "fichtner": 2,
    "fichus": 2,
    "ficials": 2,
    "fick": 1,
    "ficke": 1,
    "fickel": 2,
    "ficken": 2,
    "ficker": 2,
    "fickes": 1,
    "fickett": 2,
    "fickle": 2,
    "fickleness": 3,
    "ficklin": 2,
    "fickling": 2,
    "fico": 2,
    "ficom": 2,
    "ficorca": 3,
    "fiction": 2,
    "fictional": 3,
    "fictionalize": 4,
    "fictionalized": 4,
    "fictions": 2,
    "fictitious": 3,
    "fidalgo": 3,
    "fidata": 3,
    "fidder": 2,
    "fiddle": 2,
    "fiddled": 2,
    "fiddler": 3,
    "fiddler(1)": 2,
    "fiddler's": 3,
    "fiddler's(1)": 2,
    "fiddlers": 3,
    "fiddlers(1)": 2,
    "fiddles": 2,
    "fiddling": 2,
    "fide": 1,
    "fidel": 2,
    "fidel's": 2,
    "fidelco": 3,
    "fidelcor": 3,
    "fidelia": 3,
    "fidelities": 4,
    "fidelity": 4,
    "fidelity(1)": 4,
    "fidelity's": 4,
    "fidenas": 3,
    "fides": 1,
    "fidget": 2,
    "fidgeting": 3,
    "fidler": 3,
    "fidler(1)": 2,
    "fido": 2,
    "fidora": 3,
    "fidora's": 3,
    "fiduciares": 4,
    "fiduciares(1)": 5,
    "fiduciaries": 5,
    "fiduciary": 5,
    "fiebelkorn": 3,
    "fieber": 2,
    "fiebig": 2,
    "fiebiger": 3,
    "fiechter": 2,
    "fiedler": 2,
    "fiedler's": 2,
    "fief": 1,
    "fiefdom": 2,
    "fiefdoms": 2,
    "fiefs": 1,
    "fiegel": 2,
    "fieger": 2,
    "fieger's": 2,
    "fiel": 1,
    "field": 1,
    "field's": 1,
    "fieldcrest": 2,
    "fielded": 2,
    "fielden": 2,
    "fielder": 2,
    "fielder's": 2,
    "fielders": 2,
    "fieldhouse": 2,
    "fielding": 2,
    "fields": 1,
    "fields'": 1,
    "fieldwork": 2,
    "fiend": 1,
    "fiendish": 2,
    "fiends": 1,
    "fiene": 1,
    "fiennes": 3,
    "fiennes(1)": 2,
    "fier": 1,
    "fierce": 1,
    "fiercely": 2,
    "fiercer": 2,
    "fiercest": 2,
    "fierman": 2,
    "fiero": 2,
    "fieros": 3,
    "fierro": 2,
    "fierros": 2,
    "fiers": 1,
    "fierst": 1,
    "fierstein": 2,
    "fierstein(1)": 2,
    "fiery": 3,
    "fieser": 2,
    "fiest": 2,
    "fiesta": 3,
    "fife": 1,
    "fifer": 2,
    "fifi": 2,
    "fifield": 2,
    "fiftee": 2,
    "fifteen": 2,
    "fifteen(1)": 2,
    "fifteens": 2,
    "fifteenth": 2,
    "fifth": 1,
    "fifth(1)": 1,
    "fifths": 1,
    "fifths(1)": 1,
    "fifties": 2,
    "fiftieth": 3,
    "fifty": 2,
    "fifty's": 2,
    "fig": 1,
    "figallo": 3,
    "figaro": 3,
    "figaroa": 4,
    "figaroa's": 4,
    "figel": 2,
    "figg": 1,
    "figge": 1,
    "figgie": 2,
    "figgie's": 2,
    "figgins": 2,
    "figgs": 1,
    "fight": 1,
    "fight's": 1,
    "fighter": 2,
    "fighter's": 2,
    "fighters": 2,
    "fighters'": 2,
    "fightin'": 2,
    "fighting": 2,
    "fighting's": 2,
    "fightings": 2,
    "fightmaster": 3,
    "fights": 1,
    "figler": 3,
    "figler(1)": 2,
    "figley": 2,
    "figment": 2,
    "figments": 2,
    "figone": 2,
    "figs": 1,
    "figueira": 3,
    "figueiredo": 4,
    "figueras": 3,
    "figueredo": 4,
    "figueroa": 4,
    "figura": 3,
    "figuration": 4,
    "figurative": 4,
    "figuratively": 5,
    "figure": 2,
    "figure's": 2,
    "figured": 2,
    "figurehead": 3,
    "figures": 2,
    "figurine": 3,
    "figurines": 3,
    "figuring": 3,
    "figurski": 3,
    "fiji": 2,
    "fiji's": 2,
    "fijian": 3,
    "fijians": 3,
    "fike": 1,
    "fikes": 1,
    "fil": 1,
    "fila": 2,
    "filament": 3,
    "filaments": 3,
    "filbert": 2,
    "filbert's": 2,
    "filberts": 2,
    "filbrick": 2,
    "filby": 2,
    "filch": 1,
    "filched": 1,
    "fildes": 1,
    "file": 1,
    "filed": 1,
    "filegate": 2,
    "filene": 2,
    "filene's": 2,
    "filenet": 2,
    "filer": 2,
    "filers": 2,
    "files": 1,
    "filet": 2,
    "filets": 2,
    "filial": 3,
    "filibuster": 4,
    "filibustered": 4,
    "filibustering": 5,
    "filibusters": 4,
    "filice": 2,
    "filigree": 3,
    "filigrees": 3,
    "filing": 2,
    "filings": 2,
    "filinski": 3,
    "filion": 2,
    "filip": 2,
    "filipa": 3,
    "filipek": 3,
    "filipiak": 4,
    "filipino": 4,
    "filipinos": 4,
    "filipkowski": 4,
    "filipovic": 4,
    "filipowicz": 4,
    "filippelli": 4,
    "filippello": 4,
    "filippi": 3,
    "filippini": 4,
    "filippo": 3,
    "filippone": 3,
    "filipski": 3,
    "filkins": 2,
    "fill": 1,
    "fill-a-buster": 4,
    "filla": 2,
    "fillauer": 3,
    "filled": 1,
    "filler": 2,
    "fillers": 2,
    "fillet": 2,
    "filleted": 3,
    "filleted(1)": 2,
    "fillets": 2,
    "filley": 2,
    "fillibuster": 4,
    "fillibusters": 4,
    "fillies": 2,
    "filling": 2,
    "fillingame": 4,
    "fillinger": 3,
    "fillingham": 3,
    "fillingim": 3,
    "fillings": 2,
    "fillion": 2,
    "fillip": 2,
    "fillman": 2,
    "fillmore": 2,
    "fills": 1,
    "filly": 2,
    "film": 1,
    "film's": 1,
    "filma": 2,
    "filmed": 1,
    "filmer": 2,
    "filming": 2,
    "filmless": 2,
    "filmmaker": 3,
    "filmmaker's": 3,
    "filmmakers": 3,
    "filmmaking": 3,
    "filmore": 2,
    "films": 1,
    "filo": 2,
    "filofax": 3,
    "filofax(1)": 3,
    "filomena": 4,
    "filosa": 3,
    "filsinger": 3,
    "filson": 2,
    "filter": 2,
    "filtered": 2,
    "filtering": 3,
    "filters": 2,
    "filtertek": 3,
    "filth": 1,
    "filthy": 2,
    "filtration": 3,
    "filtrenelli": 4,
    "filtrol": 2,
    "filyaw": 3,
    "filyaw(1)": 2,
    "fima": 2,
    "fimbres": 2,
    "fin": 1,
    "fina": 2,
    "finagle": 3,
    "finagle(1)": 3,
    "finagler": 3,
    "final": 2,
    "finalco": 3,
    "finale": 3,
    "finalist": 3,
    "finalists": 3,
    "finality": 4,
    "finalize": 3,
    "finalized": 3,
    "finalizes": 4,
    "finalizing": 4,
    "finally": 3,
    "finals": 2,
    "finamore": 3,
    "finan": 2,
    "finance": 2,
    "finance(1)": 2,
    "finance(2)": 2,
    "financed": 2,
    "financed(1)": 2,
    "financement": 3,
    "financement(1)": 3,
    "financer": 3,
    "financer(1)": 3,
    "finances": 3,
    "finances(1)": 3,
    "financial": 3,
    "financial(1)": 3,
    "financial(2)": 3,
    "financial's": 3,
    "financial's(1)": 3,
    "financially": 4,
    "financially(1)": 4,
    "financially(2)": 4,
    "financials": 3,
    "financials(1)": 3,
    "financials(2)": 3,
    "financier": 3,
    "financier(1)": 3,
    "financiera": 5,
    "financiere": 3,
    "financiero": 5,
    "financiers": 3,
    "financing": 3,
    "financing(1)": 3,
    "financing(2)": 3,
    "financings": 3,
    "financings(1)": 3,
    "financings(2)": 3,
    "financo": 3,
    "finanz": 2,
    "finanza": 3,
    "finanziaria": 6,
    "finanziario": 6,
    "finarte": 2,
    "finazzo": 3,
    "finbar": 2,
    "finbar's": 2,
    "finberg": 2,
    "fincannon": 3,
    "fincannon(1)": 3,
    "finch": 1,
    "fincham": 2,
    "fincher": 2,
    "finches": 2,
    "finchum": 2,
    "finck": 1,
    "fincke": 1,
    "finckle": 2,
    "find": 1,
    "finder": 2,
    "finder's": 2,
    "finders": 2,
    "finding": 2,
    "findings": 2,
    "findlay": 2,
    "findler": 2,
    "findley": 2,
    "findling": 3,
    "findling(1)": 2,
    "finds": 1,
    "fine": 1,
    "fineberg": 2,
    "fined": 1,
    "finefrock": 2,
    "finegan": 3,
    "finegold": 2,
    "finella": 3,
    "finelli": 3,
    "finely": 2,
    "fineman": 2,
    "finer": 2,
    "fineran": 3,
    "finerty": 3,
    "finery": 3,
    "fines": 1,
    "finesse": 2,
    "finessed": 2,
    "finest": 2,
    "finestone": 2,
    "finevest": 2,
    "finex": 2,
    "finfrock": 2,
    "finger": 2,
    "fingerboard": 3,
    "fingered": 2,
    "fingerhut": 3,
    "fingering": 3,
    "fingernail": 3,
    "fingernails": 3,
    "fingerpaint": 3,
    "fingerpainted": 4,
    "fingerpainted(1)": 4,
    "fingerpointing": 4,
    "fingerprint": 3,
    "fingerprinted": 4,
    "fingerprinting": 4,
    "fingerprints": 3,
    "fingers": 2,
    "fingertip": 3,
    "fingertips": 3,
    "fini": 2,
    "finian": 3,
    "finian's": 3,
    "finicky": 3,
    "finigan": 3,
    "fining": 2,
    "fininvest": 3,
    "fininvest's": 3,
    "finish": 2,
    "finished": 2,
    "finisher": 3,
    "finishers": 3,
    "finishes": 3,
    "finishing": 3,
    "finite": 2,
    "fink": 1,
    "fink's": 1,
    "finkbeiner": 3,
    "finkbiner": 3,
    "finke": 1,
    "finkel": 2,
    "finkelman": 3,
    "finkelson": 3,
    "finkelstein": 3,
    "finkelstein(1)": 3,
    "finkelstein's": 3,
    "finkelstein's(1)": 3,
    "finken": 2,
    "finkenbinder": 4,
    "finkielstain": 3,
    "finkielstain(1)": 3,
    "finkle": 2,
    "finklea": 3,
    "finkler": 2,
    "finkley": 2,
    "finks": 1,
    "finland": 2,
    "finland(1)": 2,
    "finland's": 2,
    "finlandization": 5,
    "finlay": 2,
    "finlayson": 3,
    "finlets": 2,
    "finley": 2,
    "finley's": 2,
    "finmeccanica": 5,
    "finn": 1,
    "finn's": 1,
    "finnair": 2,
    "finnan": 2,
    "finne": 1,
    "finnegan": 3,
    "finnell": 2,
    "finneran": 3,
    "finnerty": 3,
    "finney": 2,
    "finnick": 2,
    "finnicum": 3,
    "finnie": 2,
    "finnigan": 3,
    "finning": 2,
    "finnish": 2,
    "finns": 1,
    "fino": 2,
    "finocchiaro": 5,
    "finocchio": 4,
    "fins": 1,
    "finscher": 2,
    "finsider": 3,
    "finsider's": 3,
    "finstad": 2,
    "finster": 2,
    "finstrom": 2,
    "finton": 2,
    "finucane": 3,
    "finunc": 2,
    "finzel": 2,
    "fiola": 3,
    "fiona": 3,
    "fioravanti": 5,
    "fiore": 3,
    "fiorella": 4,
    "fiorelli": 4,
    "fiorello": 4,
    "fiorentino": 5,
    "fiorenza": 4,
    "fioretti": 4,
    "fiori": 3,
    "fiorillo": 4,
    "fiorina": 4,
    "fiorini": 4,
    "fiorino": 4,
    "fiorito": 4,
    "fiorucci": 4,
    "fipple": 2,
    "fipps": 1,
    "fir": 1,
    "fire": 2,
    "fire(1)": 1,
    "fire's": 2,
    "firearm": 3,
    "firearm(1)": 2,
    "firearms": 3,
    "firearms(1)": 2,
    "fireball": 3,
    "fireball(1)": 2,
    "fireballs": 3,
    "fireballs(1)": 2,
    "firebaugh": 2,
    "firebird": 3,
    "firebirds": 3,
    "firebomb": 3,
    "firebomb(1)": 2,
    "firebombed": 2,
    "firebombing": 4,
    "firebombs": 2,
    "firebrand": 3,
    "firebrands": 3,
    "firebrick": 3,
    "firebug": 3,
    "firebush": 3,
    "firebush's": 3,
    "firecracker": 4,
    "firecrackers": 4,
    "fired": 2,
    "firedamp": 3,
    "firefight": 2,
    "firefighter": 3,
    "firefighters": 4,
    "firefighting": 3,
    "firefights": 2,
    "fireflies": 3,
    "firefly": 3,
    "firehouse": 3,
    "firehouses": 4,
    "fireman": 2,
    "fireman's": 2,
    "firemen": 2,
    "firenza": 3,
    "firenzas": 3,
    "fireplace": 3,
    "fireplaces": 4,
    "fireplaces(1)": 3,
    "firepower": 3,
    "fireproof": 3,
    "fireproofing": 4,
    "fires": 2,
    "fires(1)": 1,
    "fireside": 3,
    "firesign": 3,
    "firesign's": 3,
    "firestine": 3,
    "firestone": 2,
    "firestone's": 2,
    "firestorm": 2,
    "firewall": 2,
    "fireweed": 3,
    "firewood": 3,
    "firewood(1)": 2,
    "firework": 2,
    "fireworks": 2,
    "firfer": 2,
    "firing": 2,
    "firing(1)": 3,
    "firings": 2,
    "firings(1)": 3,
    "firino": 3,
    "firkins": 2,
    "firkus": 2,
    "firm": 1,
    "firm's": 1,
    "firma": 2,
    "firman": 2,
    "firmans": 2,
    "firmed": 1,
    "firmer": 2,
    "firmest": 2,
    "firmin": 2,
    "firming": 2,
    "firmly": 2,
    "firmness": 2,
    "firms": 1,
    "firms'": 1,
    "firpo": 2,
    "firs": 1,
    "first": 1,
    "first's": 1,
    "firstar": 2,
    "firstborn": 2,
    "firstfed": 2,
    "firsthand": 2,
    "firsthand(1)": 2,
    "firsthand(2)": 2,
    "firsthand(3)": 2,
    "firstier": 2,
    "firstier(1)": 3,
    "firstly": 2,
    "firsts": 1,
    "firstsouth": 2,
    "firth": 1,
    "firzite": 2,
    "fis": 1,
    "fisc": 1,
    "fiscal": 2,
    "fiscally": 3,
    "fisch": 1,
    "fischbach": 2,
    "fischbach's": 2,
    "fischbein": 2,
    "fischel": 2,
    "fischer": 2,
    "fischer's": 2,
    "fischetti": 3,
    "fischl": 2,
    "fischler": 3,
    "fischler(1)": 2,
    "fischman": 2,
    "fiscus": 2,
    "fiser": 2,
    "fiserv": 2,
    "fisette": 2,
    "fish": 1,
    "fish's": 2,
    "fishbach": 2,
    "fishback": 2,
    "fishbaine": 2,
    "fishbaugh": 2,
    "fishbeck": 2,
    "fishbein": 2,
    "fishbowl": 2,
    "fishburn": 2,
    "fishburne": 2,
    "fisheater": 3,
    "fisheaters": 3,
    "fished": 1,
    "fishel": 2,
    "fishell": 2,
    "fisher": 2,
    "fisher's": 2,
    "fisheries": 3,
    "fisherman": 3,
    "fisherman(1)": 3,
    "fisherman's": 3,
    "fishermen": 3,
    "fishers": 2,
    "fishery": 3,
    "fishes": 2,
    "fishes(1)": 2,
    "fishing": 2,
    "fishkill": 2,
    "fishkin": 2,
    "fishlow": 2,
    "fishman": 2,
    "fishman(1)": 2,
    "fishmonger": 3,
    "fishy": 2,
    "fisk": 1,
    "fisk's": 1,
    "fiske": 1,
    "fiske's": 1,
    "fisler": 3,
    "fisler(1)": 2,
    "fisons": 2,
    "fiss": 1,
    "fissel": 2,
    "fissell": 2,
    "fissile": 2,
    "fission": 2,
    "fissionable": 4,
    "fissure": 2,
    "fissured": 2,
    "fissures": 2,
    "fist": 1,
    "fisted": 2,
    "fister": 2,
    "fistful": 2,
    "fisticuff": 3,
    "fisticuffs": 3,
    "fists": 1,
    "fit": 1,
    "fitak": 2,
    "fitch": 1,
    "fitchburg": 2,
    "fitchett": 2,
    "fite": 1,
    "fites": 1,
    "fitful": 2,
    "fitfully": 3,
    "fithe": 1,
    "fithian": 3,
    "fitness": 2,
    "fits": 1,
    "fitswater": 3,
    "fitt": 1,
    "fitted": 2,
    "fitted(1)": 2,
    "fitter": 2,
    "fitterer": 3,
    "fittest": 2,
    "fitting": 2,
    "fittingly": 3,
    "fittings": 2,
    "fittipaldi": 4,
    "fitton": 2,
    "fittro": 2,
    "fitts": 1,
    "fitz": 1,
    "fitzco": 2,
    "fitzer": 2,
    "fitzgerald": 3,
    "fitzgerald's": 3,
    "fitzgibbon": 3,
    "fitzgibbons": 3,
    "fitzharris": 3,
    "fitzhenry": 4,
    "fitzhenry(1)": 3,
    "fitzhugh": 2,
    "fitzmaurice": 3,
    "fitzmorris": 3,
    "fitzner": 2,
    "fitzpatrick": 3,
    "fitzroy": 2,
    "fitzsimmons": 3,
    "fitzsimons": 3,
    "fitzwater": 3,
    "fitzwater's": 3,
    "fitzwilliam": 3,
    "fiumara": 4,
    "five": 1,
    "five's": 1,
    "fiveash": 2,
    "fivecoat": 2,
    "fivefold": 2,
    "fives": 1,
    "fix": 1,
    "fixable": 3,
    "fixate": 2,
    "fixated": 3,
    "fixates": 2,
    "fixation": 3,
    "fixative": 3,
    "fixatives": 3,
    "fixed": 1,
    "fixer": 2,
    "fixes": 2,
    "fixing": 2,
    "fixings": 2,
    "fixler": 2,
    "fixmer": 2,
    "fixture": 2,
    "fixtures": 2,
    "fizer": 2,
    "fizz": 1,
    "fizzle": 2,
    "fizzled": 2,
    "fizzles": 2,
    "fizzling": 3,
    "fizzling(1)": 2,
    "fjeld": 1,
    "fjelstad": 2,
    "fjord": 1,
    "fjords": 1,
    "flab": 1,
    "flabbergast": 3,
    "flabbergasted": 4,
    "flabby": 2,
    "flaccid": 2,
    "flaccid(1)": 2,
    "flach": 1,
    "flack": 1,
    "flad": 1,
    "flag": 1,
    "flagday": 2,
    "flagella": 3,
    "flagellate": 3,
    "flagellated": 4,
    "flagellum": 3,
    "flageolet": 3,
    "flagg": 1,
    "flagged": 1,
    "flagging": 2,
    "flagler": 2,
    "flagman": 2,
    "flagmen": 2,
    "flagofficer": 4,
    "flagofficers": 4,
    "flagpole": 2,
    "flagpoles": 2,
    "flagrant": 2,
    "flagrantly": 3,
    "flags": 1,
    "flagship": 2,
    "flagships": 2,
    "flagstaff": 2,
    "flagstaffs": 2,
    "flagstar": 2,
    "flagstone": 2,
    "flagstones": 2,
    "flaharty": 2,
    "flaherty": 2,
    "flahive": 2,
    "flaig": 1,
    "flail": 1,
    "flailing": 2,
    "flaim": 1,
    "flair": 1,
    "flak": 1,
    "flake": 1,
    "flakes": 1,
    "flaking": 2,
    "flaky": 2,
    "flam": 1,
    "flamboyance": 3,
    "flamboyant": 3,
    "flamboyantly": 4,
    "flame": 1,
    "flamed": 1,
    "flamemaster": 3,
    "flamenco": 3,
    "flamer": 2,
    "flames": 1,
    "flaming": 2,
    "flamingo": 3,
    "flamingos": 3,
    "flaminian": 4,
    "flamm": 1,
    "flammability": 5,
    "flammable": 3,
    "flammang": 2,
    "flammer": 2,
    "flammia": 3,
    "flamson": 2,
    "flan": 1,
    "flanagan": 3,
    "flanagin": 3,
    "flanary": 3,
    "flanders": 2,
    "flanery": 3,
    "flange": 1,
    "flanges": 2,
    "flanigan": 3,
    "flanigan's": 3,
    "flank": 1,
    "flanked": 1,
    "flanking": 2,
    "flanks": 1,
    "flann": 1,
    "flanna": 2,
    "flannagan": 3,
    "flannel": 2,
    "flanneled": 2,
    "flannels": 2,
    "flannery": 3,
    "flannigan": 3,
    "flansburg": 2,
    "flap": 1,
    "flapdoodle": 3,
    "flapjack": 2,
    "flapjacks": 2,
    "flaplike": 2,
    "flapped": 1,
    "flapper": 2,
    "flappers": 2,
    "flapping": 2,
    "flaps": 1,
    "flare": 1,
    "flared": 1,
    "flares": 1,
    "flaring": 2,
    "flaringly": 3,
    "flasch": 1,
    "flash": 1,
    "flash's": 2,
    "flashback": 2,
    "flashbacks": 2,
    "flashbulb": 2,
    "flashbulbs": 2,
    "flashcard": 2,
    "flashcards": 2,
    "flashdance": 2,
    "flashdances": 3,
    "flashed": 1,
    "flasher": 2,
    "flasher's": 2,
    "flashers": 2,
    "flashes": 2,
    "flashgun": 2,
    "flashguns": 2,
    "flashier": 3,
    "flashiest": 3,
    "flashing": 2,
    "flashlight": 2,
    "flashlights": 2,
    "flashpoint": 2,
    "flashpoints": 2,
    "flashy": 2,
    "flask": 1,
    "flasks": 1,
    "flat": 1,
    "flatau": 2,
    "flatbed": 2,
    "flatboat": 2,
    "flatbush": 2,
    "flaten": 2,
    "flater": 2,
    "flatfish": 2,
    "flatfishes": 3,
    "flath": 1,
    "flathead": 2,
    "flatheads": 2,
    "flathers": 2,
    "flatland": 2,
    "flatlands": 2,
    "flatley": 2,
    "flatly": 2,
    "flatness": 2,
    "flato": 2,
    "flats": 1,
    "flatt": 1,
    "flatten": 2,
    "flattened": 2,
    "flattening": 3,
    "flattening(1)": 2,
    "flatter": 2,
    "flattered": 2,
    "flattering": 3,
    "flattery": 3,
    "flattish": 2,
    "flatulent": 3,
    "flatware": 2,
    "flatworm": 2,
    "flaubert": 2,
    "flaugh": 1,
    "flaugher": 2,
    "flaum": 1,
    "flaunt": 1,
    "flaunted": 2,
    "flaunting": 2,
    "flaunts": 1,
    "flavell": 2,
    "flavia": 3,
    "flavier": 2,
    "flavier(1)": 2,
    "flavin": 2,
    "flavio": 3,
    "flavius": 3,
    "flavor": 2,
    "flavored": 2,
    "flavorful": 3,
    "flavoring": 3,
    "flavorings": 3,
    "flavorist": 3,
    "flavorists": 3,
    "flavorists(1)": 3,
    "flavorists(2)": 3,
    "flavorless": 3,
    "flavors": 2,
    "flaw": 1,
    "flawed": 1,
    "flawless": 2,
    "flawlessly": 3,
    "flawn": 1,
    "flaws": 1,
    "flax": 1,
    "flaxman": 2,
    "flaxseed": 2,
    "flay": 1,
    "flayed": 1,
    "flea": 1,
    "fleagle": 2,
    "fleas": 1,
    "fleck": 1,
    "fleckenstein": 3,
    "fleckenstein(1)": 3,
    "flecks": 1,
    "fled": 1,
    "fledermaus": 3,
    "fledge": 1,
    "fledged": 1,
    "fledging": 2,
    "fledgling": 2,
    "flee": 1,
    "fleece": 1,
    "fleeced": 1,
    "fleeces": 2,
    "fleecing": 2,
    "fleecy": 2,
    "fleeger": 2,
    "fleeing": 2,
    "fleek": 1,
    "fleeman": 2,
    "fleener": 2,
    "fleenor": 2,
    "fleer": 1,
    "flees": 1,
    "fleet": 1,
    "fleet's": 1,
    "fleeting": 2,
    "fleetingly": 3,
    "fleets": 1,
    "fleetwood": 2,
    "flegal": 2,
    "flegel": 2,
    "fleharty": 3,
    "fleig": 1,
    "fleisch": 1,
    "fleischauer": 3,
    "fleischer": 2,
    "fleischhacker": 3,
    "fleischman": 2,
    "fleischmann": 2,
    "fleisher": 2,
    "fleishman": 2,
    "fleiss": 1,
    "fleiss(1)": 1,
    "fleiss'": 1,
    "fleiss'(1)": 1,
    "fleiss's": 2,
    "fleiss's(1)": 2,
    "fleissner": 2,
    "fleitas": 2,
    "fleming": 2,
    "fleming's": 2,
    "flemings": 2,
    "flemington": 3,
    "flemish": 2,
    "flemister": 3,
    "flemmer": 2,
    "flemming": 2,
    "flemons": 2,
    "flener": 2,
    "flenner": 2,
    "flenniken": 3,
    "flerfu": 2,
    "flesch": 1,
    "flesh": 1,
    "fleshed": 1,
    "flesher": 2,
    "fleshman": 2,
    "fleshy": 2,
    "flesner": 2,
    "flessner": 2,
    "fleta": 2,
    "fletchall": 2,
    "fletcher": 2,
    "flett": 1,
    "fleur": 1,
    "fleurette": 2,
    "fleuri": 2,
    "fleuri(1)": 2,
    "fleury": 2,
    "flew": 1,
    "flewellen": 3,
    "flewelling": 3,
    "flex": 1,
    "flexed": 1,
    "flexer": 2,
    "flexes": 2,
    "flexi": 2,
    "flexibility": 5,
    "flexible": 3,
    "flexibly": 3,
    "flexing": 2,
    "flexion": 2,
    "flexnor": 2,
    "flextime": 2,
    "flextronic": 3,
    "flextronics": 3,
    "flicek": 2,
    "flick": 1,
    "flicker": 2,
    "flickered": 2,
    "flickering": 3,
    "flickers": 2,
    "flicking": 2,
    "flickinger": 3,
    "flicks": 1,
    "flied": 1,
    "fliegel": 2,
    "flier": 2,
    "fliers": 2,
    "flies": 1,
    "flight": 1,
    "flight's": 1,
    "flightier": 3,
    "flightiest": 3,
    "flightless": 2,
    "flights": 1,
    "flightsafety": 3,
    "flighty": 2,
    "flim": 1,
    "flimflam": 2,
    "flimsiest": 3,
    "flimsy": 2,
    "flinch": 1,
    "flinchbaugh": 2,
    "flinched": 1,
    "flinching": 2,
    "flinchum": 2,
    "flinders": 2,
    "fling": 1,
    "flinging": 2,
    "flings": 1,
    "flink": 1,
    "flinn": 1,
    "flinner": 2,
    "flint": 1,
    "flint's": 1,
    "flintlock": 2,
    "flintlocks": 2,
    "flintoff": 2,
    "flints": 1,
    "flintstone": 2,
    "flintstones": 2,
    "flinty": 2,
    "flip": 1,
    "flippant": 2,
    "flipped": 1,
    "flippen": 2,
    "flipper": 2,
    "flippers": 2,
    "flippin": 2,
    "flipping": 2,
    "flippo": 2,
    "flips": 1,
    "flirt": 1,
    "flirtation": 3,
    "flirtations": 3,
    "flirtatious": 3,
    "flirted": 2,
    "flirting": 2,
    "flirts": 1,
    "flis": 1,
    "fliss": 1,
    "flit": 1,
    "flitting": 2,
    "flo": 1,
    "float": 1,
    "floated": 2,
    "floated(1)": 2,
    "floater": 2,
    "floaters": 2,
    "floating": 2,
    "floats": 1,
    "floc": 1,
    "flock": 1,
    "flocked": 1,
    "flockhart": 2,
    "flocking": 2,
    "flocks": 1,
    "flodin": 2,
    "floe": 1,
    "floersheim": 2,
    "flog": 1,
    "flogging": 2,
    "flohr": 1,
    "floirenda": 3,
    "flom": 1,
    "flonorial": 4,
    "flood": 1,
    "flooded": 2,
    "flooded(1)": 2,
    "floodgate": 2,
    "floodgates": 2,
    "flooding": 2,
    "floodlight": 2,
    "floodlights": 2,
    "floodplain": 2,
    "floods": 1,
    "floodwater": 3,
    "floodwaters": 3,
    "flook": 1,
    "floor": 1,
    "floorboard": 2,
    "floorboards": 2,
    "floored": 1,
    "flooring": 2,
    "floors": 1,
    "flop": 1,
    "flopped": 1,
    "flopping": 2,
    "floppy": 2,
    "flops": 1,
    "floptical": 3,
    "flor": 1,
    "flora": 2,
    "florafax": 3,
    "floral": 2,
    "florally": 3,
    "florals": 2,
    "florance": 2,
    "flore": 1,
    "florea": 3,
    "florek": 2,
    "floren": 2,
    "florence": 2,
    "florence's": 3,
    "florentina": 4,
    "florentine": 3,
    "florentino": 4,
    "florer": 2,
    "flores": 2,
    "florescue": 3,
    "floresheim": 2,
    "florey": 2,
    "florez": 2,
    "flori": 2,
    "floria": 3,
    "florian": 3,
    "florid": 2,
    "florida": 3,
    "florida(1)": 3,
    "florida(2)": 3,
    "florida(3)": 3,
    "florida's": 3,
    "florida's(1)": 3,
    "florida's(2)": 3,
    "floridabanc": 4,
    "floridian": 4,
    "floridians": 4,
    "florin": 2,
    "florinda": 3,
    "florine": 3,
    "florio": 3,
    "florio's": 3,
    "floris": 2,
    "florist": 2,
    "florist(1)": 2,
    "florists": 2,
    "floro": 2,
    "florrie": 2,
    "florry": 2,
    "florsheim": 2,
    "flory": 2,
    "floss": 1,
    "flossie": 2,
    "flotation": 3,
    "flotilla": 3,
    "flotow": 2,
    "flotsam": 2,
    "flott": 1,
    "flotta": 2,
    "flounce": 1,
    "flounces": 2,
    "flounder": 2,
    "floundered": 2,
    "floundering": 3,
    "flounders": 2,
    "flour": 2,
    "flour(1)": 1,
    "flourish": 2,
    "flourished": 2,
    "flourishes": 3,
    "flourishes(1)": 3,
    "flourishing": 3,
    "flournoy": 2,
    "flours": 2,
    "flout": 1,
    "flouted": 2,
    "flouting": 2,
    "flouts": 1,
    "flow": 1,
    "flowchart": 2,
    "flowcharts": 2,
    "flowe": 1,
    "flowed": 1,
    "flower": 2,
    "flowered": 2,
    "flowering": 3,
    "flowerpot": 3,
    "flowers": 2,
    "flowers'": 2,
    "flowery": 3,
    "flowing": 2,
    "flown": 1,
    "flows": 1,
    "flowton": 2,
    "floy": 1,
    "floyd": 1,
    "flu": 1,
    "flubs": 1,
    "fluck": 1,
    "fluctuate": 3,
    "fluctuated": 4,
    "fluctuates": 3,
    "fluctuating": 4,
    "fluctuation": 4,
    "fluctuations": 4,
    "flud": 1,
    "fludd": 1,
    "flue": 1,
    "fluegel": 2,
    "fluegge": 1,
    "fluency": 3,
    "fluent": 2,
    "fluently": 3,
    "fluet": 1,
    "fluff": 1,
    "fluffed": 1,
    "fluffier": 3,
    "fluffiest": 3,
    "fluffs": 1,
    "fluffy": 2,
    "fluharty": 3,
    "fluhr": 1,
    "fluhr(1)": 1,
    "fluid": 2,
    "fluid(1)": 2,
    "fluidity": 4,
    "fluids": 2,
    "fluids(1)": 2,
    "fluitt": 2,
    "fluke": 1,
    "fluker": 2,
    "flukes": 1,
    "flulike": 2,
    "flume": 1,
    "flumenbaum": 3,
    "flumes": 1,
    "flummox": 2,
    "flummoxed": 2,
    "flung": 1,
    "flunk": 1,
    "flunked": 1,
    "flunking": 2,
    "flunks": 1,
    "fluor": 2,
    "fluor's": 2,
    "fluoresce": 2,
    "fluoresce(1)": 2,
    "fluorescent": 3,
    "fluorescent(1)": 3,
    "fluorescently": 4,
    "fluorescently(1)": 4,
    "fluorescents": 3,
    "fluorescents(1)": 3,
    "fluoridation": 4,
    "fluoridation(1)": 4,
    "fluoride": 2,
    "fluoride(1)": 2,
    "fluorides": 2,
    "fluorides(1)": 2,
    "fluorine": 2,
    "fluorine(1)": 2,
    "fluorite": 2,
    "fluorite(1)": 2,
    "fluorocarbon": 4,
    "fluorocarbon(1)": 4,
    "fluorocarbons": 4,
    "fluorocarbons(1)": 4,
    "fluorometer": 4,
    "fluorometer(1)": 4,
    "fluoroscopy": 4,
    "fluoroscopy(1)": 4,
    "fluorspar": 2,
    "fluorspar(1)": 2,
    "flurried": 2,
    "flurries": 2,
    "flurry": 2,
    "flury": 2,
    "flury(1)": 2,
    "flus": 1,
    "flush": 1,
    "flushed": 1,
    "flushes": 2,
    "flushing": 2,
    "fluster": 2,
    "flustered": 2,
    "flustering": 3,
    "flusters": 2,
    "flute": 1,
    "flutes": 1,
    "flutist": 2,
    "flutist(1)": 2,
    "flutter": 2,
    "fluttered": 2,
    "fluttering": 3,
    "flutters": 2,
    "fluty": 2,
    "fluvial": 3,
    "flux": 1,
    "fluxional": 3,
    "fly": 1,
    "flyby": 2,
    "flycatcher": 3,
    "flye": 1,
    "flyer": 2,
    "flyers": 2,
    "flying": 2,
    "flynn": 1,
    "flynt": 1,
    "flypaper": 3,
    "flythe": 1,
    "flytrap": 2,
    "flyway": 2,
    "flywheel": 2,
    "fm": 2,
    "foal": 1,
    "foale": 1,
    "foale's": 1,
    "foaling": 2,
    "foam": 1,
    "foaming": 2,
    "foams": 1,
    "foamy": 2,
    "foard": 1,
    "fob": 1,
    "fobbs": 1,
    "fobel": 2,
    "fobel's": 2,
    "fobes": 1,
    "focaccia": 4,
    "focal": 2,
    "focht": 1,
    "fochtman": 2,
    "fockler": 2,
    "focus": 2,
    "focus(1)": 2,
    "focused": 2,
    "focused(1)": 2,
    "focuses": 3,
    "focuses(1)": 3,
    "focusing": 3,
    "focusing(1)": 3,
    "focussed": 2,
    "focussed(1)": 2,
    "fodder": 2,
    "fodera": 3,
    "fodor": 2,
    "foe": 1,
    "foehlich": 2,
    "foell": 1,
    "foeller": 2,
    "foerster": 2,
    "foertsch": 1,
    "foes": 1,
    "fog": 1,
    "fog(1)": 1,
    "fogal": 2,
    "fogarty": 3,
    "fogarty(1)": 3,
    "fogel": 2,
    "fogelberg": 3,
    "fogelberg's": 3,
    "fogelman": 3,
    "fogelman's": 3,
    "fogelson": 3,
    "fogelson's": 3,
    "fogerty": 3,
    "fogerty's": 3,
    "fogg": 1,
    "fogg's": 1,
    "foggiest": 3,
    "foggy": 2,
    "fogle": 2,
    "fogleman": 3,
    "fogler": 3,
    "fogler(1)": 2,
    "foglesong": 3,
    "foglia": 3,
    "foglio": 3,
    "fogs": 1,
    "fogt": 1,
    "fogy": 2,
    "fohl": 1,
    "foia": 2,
    "foia(1)": 4,
    "foible": 2,
    "foibles": 2,
    "foie": 1,
    "foil": 1,
    "foiled": 1,
    "foiles": 2,
    "foiling": 2,
    "foils": 1,
    "foist": 1,
    "foisted": 2,
    "foister": 2,
    "foisy": 2,
    "fojtik": 2,
    "fokker": 2,
    "fokkers": 2,
    "folan": 2,
    "foland": 2,
    "folck": 1,
    "fold": 1,
    "folded": 2,
    "folded(1)": 2,
    "folden": 2,
    "folder": 2,
    "folders": 2,
    "folding": 2,
    "folds": 1,
    "foley": 2,
    "foley's": 2,
    "folger": 2,
    "folger's": 2,
    "folgers": 2,
    "folha": 2,
    "foliage": 2,
    "foliage(1)": 3,
    "foliate": 3,
    "foliation": 4,
    "folic": 2,
    "folino": 3,
    "folk": 1,
    "folker": 2,
    "folkers": 2,
    "folkert": 2,
    "folkerts": 2,
    "folkes": 1,
    "folkish": 2,
    "folklore": 2,
    "folkman": 2,
    "folkrock": 2,
    "folks": 1,
    "folks'": 1,
    "folkstone": 2,
    "folkstone's": 2,
    "folksy": 2,
    "folktale": 2,
    "folkway": 2,
    "folkways": 2,
    "folland": 2,
    "follett": 2,
    "follette": 2,
    "folley": 2,
    "folliard": 2,
    "follicle": 3,
    "follicle(1)": 3,
    "follicles": 3,
    "follies": 2,
    "follin": 2,
    "follis": 2,
    "follman": 2,
    "follmer": 2,
    "follow": 2,
    "followed": 2,
    "followell": 3,
    "follower": 3,
    "followers": 3,
    "following": 3,
    "followings": 3,
    "follows": 2,
    "followup": 3,
    "folly": 2,
    "folmar": 2,
    "folmer": 2,
    "folse": 1,
    "folsom": 2,
    "folson": 2,
    "folta": 2,
    "foltene": 2,
    "folts": 1,
    "foltz": 1,
    "folwell": 2,
    "folz": 1,
    "fomby": 2,
    "foment": 2,
    "fomented": 3,
    "fomenting": 3,
    "fomento": 3,
    "fomon": 2,
    "fomon's": 2,
    "fonar": 2,
    "foncier": 2,
    "fond": 1,
    "fonda": 2,
    "fonda's": 2,
    "fonder": 2,
    "fondest": 2,
    "fondiaria": 5,
    "fondkommission": 4,
    "fondle": 2,
    "fondled": 2,
    "fondling": 3,
    "fondling(1)": 2,
    "fondly": 2,
    "fondness": 2,
    "fondren": 3,
    "fondue": 2,
    "fondue(1)": 2,
    "fondues": 2,
    "fone": 1,
    "foner": 2,
    "fones": 1,
    "fong": 1,
    "fonger": 2,
    "fonner": 2,
    "fons": 1,
    "fonseca": 3,
    "font": 1,
    "fontaine": 2,
    "fontainebleau": 3,
    "fontainebleau(1)": 3,
    "fontana": 3,
    "fontanella": 4,
    "fontanez": 3,
    "fontanilla": 4,
    "fonte": 1,
    "fontenette": 3,
    "fontenot": 3,
    "fontes": 2,
    "fonts": 1,
    "fonville": 2,
    "fonz": 1,
    "fonzie": 2,
    "foo": 1,
    "foobar": 2,
    "food": 1,
    "food's": 1,
    "foodarama": 4,
    "foodie": 2,
    "foodmaker": 3,
    "foodmaker's": 3,
    "foodmakers": 3,
    "foods": 1,
    "foods'": 1,
    "foodservice": 3,
    "foodstuff": 2,
    "foodstuffs": 2,
    "foodtown": 2,
    "foodway": 2,
    "foodways": 2,
    "fooks": 1,
    "fool": 1,
    "fool's": 1,
    "fooled": 1,
    "foolery": 3,
    "foolhardy": 3,
    "fooling": 2,
    "foolish": 2,
    "foolishly": 3,
    "foolishness": 3,
    "foolproof": 2,
    "fools": 1,
    "foong": 1,
    "foor": 1,
    "foos": 1,
    "foose": 1,
    "fooshee": 2,
    "foot": 1,
    "footage": 2,
    "football": 2,
    "football's": 2,
    "footballs": 2,
    "foote": 1,
    "foote's": 1,
    "footed": 2,
    "footer": 2,
    "footfall": 2,
    "foothill": 2,
    "foothills": 2,
    "foothold": 2,
    "footholds": 2,
    "footing": 2,
    "footings": 2,
    "footlight": 2,
    "footlights": 2,
    "footloose": 2,
    "footman": 2,
    "footnote": 2,
    "footnoted": 3,
    "footnotes": 2,
    "footnoting": 3,
    "footpath": 2,
    "footprint": 2,
    "footprints": 2,
    "footrace": 2,
    "footstep": 2,
    "footsteps": 2,
    "footwall": 2,
    "footware": 2,
    "footwear": 2,
    "footwork": 2,
    "fop": 1,
    "fop(1)": 3,
    "foppiano": 4,
    "for": 1,
    "for(1)": 1,
    "for(2)": 1,
    "fora": 2,
    "forage": 2,
    "forages": 3,
    "foraging": 3,
    "foraker": 3,
    "foramen": 3,
    "foran": 2,
    "forand": 2,
    "foray": 2,
    "forayed": 2,
    "foraying": 3,
    "forays": 2,
    "forbad": 2,
    "forbade": 2,
    "forbearance": 3,
    "forbes": 1,
    "forbes'": 1,
    "forbes's": 2,
    "forbeses": 2,
    "forbess": 2,
    "forbid": 2,
    "forbid(1)": 2,
    "forbidden": 3,
    "forbidden(1)": 3,
    "forbidding": 3,
    "forbidding(1)": 3,
    "forbids": 2,
    "forbids(1)": 2,
    "forbis": 2,
    "forbus": 2,
    "forbush": 2,
    "force": 1,
    "force's": 2,
    "forced": 1,
    "forceful": 2,
    "forcefully": 3,
    "forcefulness": 3,
    "forceps": 2,
    "forces": 2,
    "forces'": 2,
    "forcible": 3,
    "forcibly": 3,
    "forcier": 3,
    "forcing": 2,
    "forcum": 2,
    "ford": 1,
    "ford's": 1,
    "forde": 1,
    "fordham": 2,
    "fordice": 2,
    "fordice(1)": 2,
    "fords": 1,
    "fordyce": 2,
    "fore": 1,
    "forearm": 2,
    "forearm(1)": 2,
    "forearms": 2,
    "forearms(1)": 2,
    "forebear": 2,
    "forebearance": 3,
    "forebears": 2,
    "forebode": 2,
    "foreboding": 3,
    "forebrain": 2,
    "forecast": 2,
    "forecasted": 3,
    "forecaster": 3,
    "forecasters": 3,
    "forecasting": 3,
    "forecasts": 2,
    "forecasts(1)": 2,
    "forecasts(2)": 2,
    "forecasts(3)": 2,
    "foreclose": 2,
    "foreclosed": 2,
    "forecloses": 3,
    "foreclosing": 3,
    "foreclosure": 3,
    "foreclosures": 3,
    "foree": 2,
    "forefather": 3,
    "forefathers": 3,
    "forefinger": 3,
    "forefingers": 3,
    "forefoot": 2,
    "forefront": 2,
    "forego": 2,
    "foregoing": 3,
    "foregone": 2,
    "foreground": 2,
    "forehand": 2,
    "forehands": 2,
    "forehead": 2,
    "foreheads": 2,
    "foreign": 2,
    "foreign(1)": 2,
    "foreigner": 3,
    "foreigner(1)": 3,
    "foreigner(2)": 2,
    "foreigner(3)": 2,
    "foreigners": 3,
    "foreigners(1)": 3,
    "foreigners(2)": 2,
    "foreigners(3)": 2,
    "foreigners'": 3,
    "foreigners'(1)": 3,
    "foreigners'(2)": 2,
    "foreigners'(3)": 2,
    "forelimb": 2,
    "forelimbs": 2,
    "foreman": 2,
    "foremen": 2,
    "foremost": 2,
    "forensic": 3,
    "forensic(1)": 3,
    "forensically": 4,
    "forensically(1)": 5,
    "forensics": 3,
    "forensics(1)": 3,
    "foreperson": 3,
    "foreplay": 2,
    "forero": 2,
    "forerunner": 3,
    "forerunners": 3,
    "foresaw": 2,
    "foresee": 2,
    "foreseeable": 4,
    "foreseeing": 3,
    "foreseen": 2,
    "foresees": 2,
    "foreshadow": 3,
    "foreshadowed": 3,
    "foreshadowing": 4,
    "foreshadows": 3,
    "foresight": 2,
    "foreskin": 2,
    "foresman": 2,
    "forest": 2,
    "forest(1)": 2,
    "forest's": 2,
    "foresta": 2,
    "forestall": 2,
    "forestalled": 2,
    "forestalling": 3,
    "forestalls": 2,
    "forested": 3,
    "forester": 3,
    "foresters": 3,
    "forestry": 3,
    "forests": 2,
    "forestville": 3,
    "foret": 1,
    "foret(1)": 2,
    "foretaste": 2,
    "foretaste(1)": 2,
    "foretastes": 2,
    "foretastes(1)": 2,
    "foretell": 2,
    "foretelling": 3,
    "forethought": 2,
    "foretold": 2,
    "forever": 3,
    "forewarn": 2,
    "forewarned": 2,
    "forewarning": 3,
    "forewarns": 2,
    "forewing": 2,
    "forewings": 2,
    "forewoman": 3,
    "forewomen": 3,
    "foreword": 2,
    "forex": 2,
    "forfeit": 2,
    "forfeitable": 4,
    "forfeited": 3,
    "forfeiting": 3,
    "forfeits": 2,
    "forfeiture": 3,
    "forfeitures": 3,
    "forgave": 2,
    "forge": 1,
    "forged": 1,
    "forger": 2,
    "forgeries": 3,
    "forgers": 2,
    "forgery": 3,
    "forges": 2,
    "forget": 2,
    "forget(1)": 2,
    "forgetful": 3,
    "forgetful(1)": 3,
    "forgets": 2,
    "forgets(1)": 2,
    "forgettable": 4,
    "forgettable(1)": 4,
    "forgette": 2,
    "forgetting": 3,
    "forgetting(1)": 3,
    "forgey": 2,
    "forgie": 2,
    "forging": 2,
    "forgings": 2,
    "forgione": 3,
    "forgivable": 4,
    "forgivable(1)": 4,
    "forgive": 2,
    "forgive(1)": 2,
    "forgiven": 3,
    "forgiven(1)": 3,
    "forgiveness": 3,
    "forgiveness(1)": 3,
    "forgives": 2,
    "forgives(1)": 2,
    "forgiving": 3,
    "forgiving(1)": 3,
    "forgo": 2,
    "forgoes": 2,
    "forgoing": 3,
    "forgone": 2,
    "forgot": 2,
    "forgot(1)": 2,
    "forgotten": 3,
    "forgotten(1)": 3,
    "forgue": 1,
    "forgy": 2,
    "forhan": 2,
    "forie": 2,
    "forin": 2,
    "forinash": 3,
    "forint": 2,
    "forints": 2,
    "forister": 3,
    "fork": 1,
    "fork-lift": 2,
    "forked": 1,
    "forker": 2,
    "forkey": 2,
    "forking": 2,
    "forklift": 2,
    "forklifts": 2,
    "forkner": 2,
    "forks": 1,
    "forlenza": 3,
    "forlorn": 2,
    "form": 1,
    "form's": 1,
    "forma": 2,
    "formal": 2,
    "formaldehyde": 4,
    "formaldehyde(1)": 4,
    "formalism": 4,
    "formalist": 3,
    "formalities": 4,
    "formality": 4,
    "formalization": 5,
    "formalize": 3,
    "formalized": 3,
    "formalizes": 4,
    "formalizing": 4,
    "formally": 3,
    "forman": 2,
    "formanek": 3,
    "formant": 2,
    "formants": 2,
    "format": 2,
    "formation": 3,
    "formations": 3,
    "formative": 3,
    "formato": 3,
    "formats": 2,
    "formbey": 2,
    "formby": 2,
    "formed": 1,
    "former": 2,
    "formerly": 3,
    "formic": 2,
    "formica": 3,
    "formica(1)": 3,
    "formica's": 3,
    "formica's(1)": 3,
    "formidable": 4,
    "formidable(1)": 4,
    "formidably": 4,
    "forming": 2,
    "formosa": 3,
    "formoso": 3,
    "forms": 1,
    "formula": 3,
    "formulaic": 4,
    "formulary": 4,
    "formulas": 3,
    "formulate": 3,
    "formulated": 4,
    "formulated(1)": 4,
    "formulates": 3,
    "formulating": 4,
    "formulation": 4,
    "formulation(1)": 4,
    "formulations": 4,
    "formylin": 3,
    "fornal": 2,
    "forner": 2,
    "fornes": 1,
    "forness": 2,
    "forney": 2,
    "forni": 2,
    "fornoff": 2,
    "fornwalt": 2,
    "forquer": 2,
    "forr": 1,
    "forrer": 2,
    "forrest": 2,
    "forrestal": 3,
    "forrester": 3,
    "forrey": 2,
    "forry": 2,
    "fors": 1,
    "forsake": 2,
    "forsaken": 3,
    "forsaking": 3,
    "forsberg": 2,
    "forsburg": 2,
    "forsburg's": 2,
    "forschner": 2,
    "forse": 1,
    "forsee": 2,
    "forseeable": 4,
    "forseeable(1)": 4,
    "forsell": 2,
    "forseth": 2,
    "forsgren": 2,
    "forshan": 2,
    "forshee": 2,
    "forshey": 2,
    "forslund": 2,
    "forsman": 2,
    "forson": 2,
    "forsook": 2,
    "forst": 1,
    "forster": 2,
    "forstmann": 2,
    "forstner": 2,
    "forstrom": 2,
    "forswear": 2,
    "forsworn": 2,
    "forsyth": 2,
    "forsythe": 2,
    "forsythia": 4,
    "forsythia(1)": 4,
    "forsythias": 4,
    "forsythias(1)": 4,
    "fort": 1,
    "fortas": 2,
    "fortas's": 3,
    "forte": 2,
    "forte(1)": 1,
    "fortenberry": 4,
    "fortes": 2,
    "fortes(1)": 1,
    "forth": 1,
    "forthcoming": 3,
    "forthright": 2,
    "forthrightly": 3,
    "forthrightness": 3,
    "forthwith": 2,
    "forti": 2,
    "fortier": 3,
    "fortier(1)": 2,
    "fortier's": 3,
    "fortier's(1)": 2,
    "forties": 2,
    "fortieth": 3,
    "fortification": 5,
    "fortifications": 5,
    "fortified": 3,
    "fortifier": 4,
    "fortifiers": 4,
    "fortify": 3,
    "fortifying": 4,
    "fortin": 2,
    "fortini": 3,
    "fortino": 3,
    "fortis": 2,
    "fortitude": 3,
    "fortman": 2,
    "fortna": 2,
    "fortner": 2,
    "fortney": 2,
    "fortnight": 2,
    "fortnightly": 3,
    "fortnights": 2,
    "forton": 2,
    "fortress": 2,
    "fortresses": 3,
    "forts": 1,
    "fortson": 2,
    "fortuitous": 4,
    "fortuna": 3,
    "fortunate": 3,
    "fortunate(1)": 3,
    "fortunately": 4,
    "fortunately(1)": 4,
    "fortunato": 4,
    "fortunato(1)": 4,
    "fortune": 2,
    "fortune(1)": 2,
    "fortune's": 2,
    "fortune's(1)": 2,
    "fortunes": 2,
    "fortunes(1)": 2,
    "fortuny": 3,
    "forty": 2,
    "forty's": 2,
    "forum": 2,
    "forum's": 2,
    "forums": 2,
    "forward": 2,
    "forwarded": 3,
    "forwarder": 3,
    "forwarders": 3,
    "forwarding": 3,
    "forwards": 2,
    "forwood": 2,
    "forys": 2,
    "forza": 2,
    "fosamax": 3,
    "fosback": 2,
    "fosberg": 2,
    "fosco": 2,
    "fosdick": 2,
    "foshee": 2,
    "fosia": 2,
    "foskett": 2,
    "foskey": 2,
    "fosler": 3,
    "fosler(1)": 2,
    "fosnaugh": 2,
    "foss": 1,
    "fosse": 1,
    "fossel": 2,
    "fossen": 2,
    "fossett": 2,
    "fossett's": 2,
    "fossey": 2,
    "fossey's": 2,
    "fossil": 2,
    "fossiliferous": 5,
    "fossilize": 3,
    "fossilized": 3,
    "fossils": 2,
    "fossum": 2,
    "foster": 2,
    "foster's": 2,
    "fostered": 2,
    "fostering": 3,
    "fosters": 2,
    "foth": 1,
    "fothergill": 3,
    "fotheringham": 4,
    "foti": 2,
    "fotis": 2,
    "fotopoulos": 4,
    "fouad": 2,
    "fouch": 1,
    "fouche": 1,
    "foucher": 2,
    "fougere": 2,
    "fought": 1,
    "fouhy": 2,
    "fouhy(1)": 2,
    "foul": 1,
    "foulds": 1,
    "fouled": 1,
    "fouling": 2,
    "foulk": 1,
    "foulke": 1,
    "foulkes": 1,
    "foulks": 1,
    "foulness": 2,
    "fouls": 1,
    "found": 1,
    "foundation": 3,
    "foundation's": 3,
    "foundational": 4,
    "foundations": 3,
    "founded": 2,
    "founded(1)": 2,
    "founder": 2,
    "founder's": 2,
    "foundered": 2,
    "foundering": 3,
    "founders": 2,
    "founders'": 2,
    "founding": 2,
    "foundling": 2,
    "foundries": 2,
    "foundry": 2,
    "fountain": 2,
    "fountaine": 2,
    "fountains": 2,
    "four": 1,
    "four's": 1,
    "fourfold": 2,
    "fourier": 3,
    "fourman": 2,
    "fournet": 2,
    "fournier": 3,
    "fours": 1,
    "foursome": 2,
    "foursquare": 2,
    "fourteen": 2,
    "fourteen(1)": 2,
    "fourteens": 2,
    "fourteenth": 2,
    "fourteenth(1)": 2,
    "fourth": 1,
    "fourth's": 1,
    "fourthly": 2,
    "fourthquarter": 3,
    "fourthquarter(1)": 3,
    "fourths": 1,
    "fourths(1)": 1,
    "fourtou": 2,
    "fouse": 1,
    "fousek": 2,
    "foushee": 2,
    "foust": 1,
    "fout": 1,
    "foutch": 1,
    "fouts": 1,
    "fouty": 2,
    "foutz": 1,
    "fowble": 2,
    "fowers": 2,
    "fowkes": 1,
    "fowl": 1,
    "fowle": 2,
    "fowler": 2,
    "fowler's": 2,
    "fowles": 2,
    "fowlkes": 1,
    "fox": 1,
    "fox's": 2,
    "foxboro": 3,
    "foxborough": 3,
    "foxes": 2,
    "foxfire": 2,
    "foxfire(1)": 3,
    "foxglove": 2,
    "foxhole": 2,
    "foxholes": 2,
    "foxhound": 2,
    "foxman": 2,
    "foxman's": 2,
    "foxmeyer": 2,
    "foxtail": 2,
    "foxtrot": 2,
    "foxwell": 2,
    "foxwood": 2,
    "foxwoods": 2,
    "foxworth": 2,
    "foxworthy": 3,
    "foxworthy's": 3,
    "foxx": 1,
    "foxy": 2,
    "foy": 1,
    "foye": 1,
    "foyer": 2,
    "foyle": 1,
    "foyt": 1,
    "fraas": 1,
    "frable": 2,
    "fracas": 2,
    "frace": 1,
    "fractal": 2,
    "fraction": 2,
    "fractional": 3,
    "fractionally": 4,
    "fractionally(1)": 3,
    "fractions": 2,
    "fractious": 2,
    "fractiousness": 3,
    "fracture": 2,
    "fracture(1)": 2,
    "fractured": 2,
    "fractures": 2,
    "fractures(1)": 2,
    "fracturing": 3,
    "fradette": 2,
    "fradkin": 2,
    "frady": 2,
    "fraga": 2,
    "fragale": 3,
    "frager": 2,
    "fragile": 2,
    "fragility": 4,
    "fragment": 2,
    "fragmentary": 4,
    "fragmentation": 4,
    "fragmented": 3,
    "fragmented(1)": 3,
    "fragmenting": 3,
    "fragmenting(1)": 3,
    "fragments": 2,
    "frago": 2,
    "fragonard": 3,
    "fragonard(1)": 3,
    "fragoso": 3,
    "fragrance": 2,
    "fragrances": 3,
    "fragrances(1)": 3,
    "fragrant": 2,
    "fraher": 2,
    "frahm": 1,
    "frail": 1,
    "frailey": 2,
    "frailties": 2,
    "frailty": 2,
    "fraim": 1,
    "frain": 1,
    "fraine": 1,
    "fraioli": 3,
    "fraire": 1,
    "fraiser": 2,
    "fraizer": 2,
    "fraker": 2,
    "frakes": 1,
    "fraleigh": 2,
    "fraley": 2,
    "fralick": 2,
    "fralin": 2,
    "fralix": 2,
    "fram": 1,
    "framatome": 3,
    "frame": 1,
    "framed": 1,
    "framer": 2,
    "framers": 2,
    "framers'": 2,
    "frames": 1,
    "framework": 2,
    "framing": 2,
    "framingham": 3,
    "frampton": 2,
    "fran": 1,
    "frana": 2,
    "franc": 1,
    "franc's": 1,
    "franca": 2,
    "francais": 2,
    "francaise": 2,
    "francaises": 2,
    "francavilla": 4,
    "france": 1,
    "france's": 2,
    "francek": 2,
    "frances": 2,
    "francesca": 3,
    "franceschi": 3,
    "franceschini": 4,
    "francesco": 3,
    "francesco's": 3,
    "francesconi": 4,
    "francese": 3,
    "francesmary": 4,
    "franchi": 2,
    "franchik": 2,
    "franchini": 3,
    "franchino": 3,
    "franchise": 2,
    "franchise's": 3,
    "franchised": 2,
    "franchisee": 3,
    "franchisees": 3,
    "franchisees'": 3,
    "franchiser": 3,
    "franchisers": 3,
    "franchises": 3,
    "franchising": 3,
    "franchot": 2,
    "francia": 2,
    "francie": 2,
    "francies": 2,
    "francine": 2,
    "francine's": 2,
    "francines": 2,
    "francis": 2,
    "francis(1)": 2,
    "francis'": 2,
    "francis'(1)": 2,
    "franciscan": 3,
    "franciscans": 3,
    "francisco": 3,
    "francisco's": 3,
    "franciso": 3,
    "francisville": 3,
    "franck": 1,
    "francke": 1,
    "francklin": 2,
    "francklyn": 2,
    "franckowiak": 4,
    "franco": 2,
    "franco's": 2,
    "francoeur": 2,
    "francois": 2,
    "francoise": 2,
    "francoise(1)": 2,
    "francom": 2,
    "francophile": 3,
    "francophone": 3,
    "francorp": 2,
    "francs": 1,
    "francy": 2,
    "francyne": 2,
    "franczak": 2,
    "frandsen": 2,
    "frane": 1,
    "franek": 2,
    "franey": 2,
    "frangos": 2,
    "franjo": 2,
    "frank": 1,
    "frank's": 1,
    "franke": 1,
    "franke(1)": 2,
    "franked": 1,
    "frankel": 2,
    "franken": 2,
    "frankenberg": 3,
    "frankenberger": 4,
    "frankenberry": 4,
    "frankenfield": 3,
    "frankenfood": 3,
    "frankenheimer": 4,
    "frankenstein": 3,
    "frankenstein(1)": 3,
    "frankenstein's": 3,
    "frankenstein's(1)": 3,
    "frankfort": 2,
    "frankfort's": 2,
    "frankfurt": 2,
    "frankfurt's": 2,
    "frankfurter": 3,
    "frankfurters": 3,
    "frankhouser": 3,
    "frankie": 2,
    "frankiewicz": 3,
    "frankincense": 3,
    "franking": 2,
    "frankino": 3,
    "frankish": 2,
    "frankl": 2,
    "frankland": 2,
    "franklin": 2,
    "franklin's": 2,
    "franklinite": 3,
    "franklinville": 3,
    "frankly": 2,
    "franklyn": 2,
    "frankness": 2,
    "franko": 2,
    "frankovich": 3,
    "frankowski": 3,
    "franks": 1,
    "frankson": 2,
    "frankum": 2,
    "frannie": 2,
    "franny": 2,
    "frano": 2,
    "frans": 1,
    "fransen": 2,
    "franson": 2,
    "franssen": 2,
    "franta": 2,
    "frantic": 2,
    "frantically": 4,
    "frantically(1)": 3,
    "frantically(2)": 4,
    "frantically(3)": 3,
    "frantom": 2,
    "frantz": 1,
    "frantzen": 2,
    "franyo": 2,
    "franz": 1,
    "franze": 1,
    "franzel": 2,
    "franzen": 2,
    "franzese": 3,
    "franzone": 3,
    "franzoni": 3,
    "frap": 1,
    "fraph": 1,
    "fraph's": 1,
    "frappier": 3,
    "frary": 2,
    "frasca": 2,
    "frascella": 3,
    "frasch": 1,
    "frasco": 2,
    "frase": 1,
    "fraser": 2,
    "fraser's": 2,
    "frasher": 2,
    "frashier": 2,
    "frasier": 2,
    "frasier's": 2,
    "frasure": 2,
    "fratangelo": 4,
    "frate": 1,
    "frater": 2,
    "fraternal": 3,
    "fraternities": 4,
    "fraternity": 4,
    "fraternity(1)": 4,
    "fraternize": 3,
    "fraternizing": 4,
    "frates": 1,
    "fratricide": 3,
    "fratricides": 3,
    "fratus": 2,
    "fratzke": 1,
    "fratzke(1)": 2,
    "frau": 1,
    "fraud": 1,
    "frauds": 1,
    "fraudster": 2,
    "fraudster's": 2,
    "fraudsters": 2,
    "fraudulent": 3,
    "fraudulently": 4,
    "fraught": 1,
    "fraum": 1,
    "fraum(1)": 1,
    "frausto": 2,
    "fravel": 2,
    "frawley": 2,
    "fray": 1,
    "frayed": 1,
    "frayer": 2,
    "fraying": 2,
    "frayn": 1,
    "frayne": 1,
    "fraze": 1,
    "frazee": 2,
    "frazer": 2,
    "frazier": 2,
    "frazzano": 3,
    "frazzini": 3,
    "frazzle": 2,
    "frazzled": 2,
    "fread": 1,
    "freak": 1,
    "freaked": 1,
    "freaking": 2,
    "freaks": 1,
    "freakshow": 2,
    "freaky": 2,
    "frean": 1,
    "frear": 1,
    "frears": 1,
    "freas": 1,
    "frease": 1,
    "freberg": 2,
    "frech": 1,
    "frechette": 2,
    "freck": 1,
    "freckle": 2,
    "freckled": 2,
    "freckles": 2,
    "fred": 1,
    "fred's": 1,
    "freda": 1,
    "freddie": 2,
    "freddy": 2,
    "freddy's": 2,
    "freddye": 2,
    "frede": 1,
    "fredell": 2,
    "fredella": 3,
    "fredenburg": 3,
    "frederic": 2,
    "frederica": 4,
    "frederick": 2,
    "frederick(1)": 3,
    "frederick's": 2,
    "frederick's(1)": 3,
    "fredericka": 4,
    "fredericks": 2,
    "fredericksburg": 3,
    "fredericksburg(1)": 4,
    "fredericksen": 4,
    "fredericksen(1)": 3,
    "frederickson": 4,
    "frederickson(1)": 3,
    "frederico": 4,
    "frederika": 4,
    "frederiksen": 4,
    "frederking": 3,
    "frederking(1)": 3,
    "fredette": 2,
    "frediani": 4,
    "fredin": 2,
    "fredkin": 2,
    "fredlund": 2,
    "fredman": 2,
    "fredo": 2,
    "fredric": 2,
    "fredrich": 2,
    "fredrick": 2,
    "fredricks": 2,
    "fredricksen": 3,
    "fredrickson": 3,
    "fredriksen": 3,
    "fredrikson": 3,
    "free": 1,
    "freeberg": 2,
    "freeberg's": 2,
    "freebie": 2,
    "freebies": 2,
    "freeborn": 2,
    "freeburg": 2,
    "freeburn": 2,
    "freed": 1,
    "freed's": 1,
    "freedenberg": 3,
    "freedenberg's": 3,
    "freedland": 2,
    "freedle": 2,
    "freedman": 2,
    "freedman's": 2,
    "freedom": 2,
    "freedom's": 2,
    "freedoms": 2,
    "freefall": 2,
    "freeform": 2,
    "freeh": 1,
    "freeh's": 1,
    "freehand": 2,
    "freehling": 2,
    "freehoff": 2,
    "freehoff's": 2,
    "freehold": 2,
    "freeholder": 3,
    "freeholders": 3,
    "freeing": 2,
    "freel": 1,
    "freelance": 2,
    "freelancer": 3,
    "freelancers": 3,
    "freelancing": 3,
    "freeland": 2,
    "freeloader": 3,
    "freeloaders": 3,
    "freelove": 2,
    "freels": 1,
    "freely": 2,
    "freeman": 2,
    "freeman's": 2,
    "freemans": 2,
    "freemason": 3,
    "freemasonry": 4,
    "freemen": 2,
    "freemen's": 2,
    "freemon": 2,
    "freemont": 2,
    "freemyer": 3,
    "freen": 1,
    "freeney": 2,
    "freeny": 2,
    "freeport": 2,
    "freeport's": 2,
    "freer": 2,
    "frees": 1,
    "freese": 1,
    "freest": 2,
    "freestanding": 3,
    "freestone": 2,
    "freestyle": 2,
    "freet": 1,
    "freethinker": 3,
    "freethinkers": 3,
    "freetown": 2,
    "freeware": 2,
    "freeway": 2,
    "freeways": 2,
    "freewheeling": 3,
    "freewheeling(1)": 3,
    "freewing": 2,
    "freeze": 1,
    "freezer": 2,
    "freezers": 2,
    "freezes": 2,
    "freezing": 2,
    "fregeau": 2,
    "fregia": 3,
    "fregoso": 3,
    "frei": 1,
    "freia": 2,
    "freiberg": 2,
    "freiberger": 3,
    "freiburger": 3,
    "freid": 1,
    "freidan": 2,
    "freidel": 2,
    "freidman": 2,
    "freidman(1)": 2,
    "freidy": 2,
    "freidy(1)": 2,
    "freidy's": 2,
    "freidy's(1)": 2,
    "freier": 2,
    "freiermuth": 3,
    "freight": 1,
    "freighter": 2,
    "freighters": 2,
    "freightliner": 3,
    "freightway": 2,
    "freightways": 2,
    "freiheit": 2,
    "freije": 1,
    "freilich": 2,
    "freiman": 2,
    "freiman(1)": 2,
    "freimark": 2,
    "freimuth": 2,
    "frein": 1,
    "freind": 1,
    "freire": 1,
    "freis": 1,
    "freise": 1,
    "freitag": 2,
    "freitas": 2,
    "freiwald": 2,
    "frel": 1,
    "frelimo": 3,
    "frels": 1,
    "fremd": 1,
    "fremd's": 1,
    "fremiet": 2,
    "fremin": 2,
    "fremitus": 3,
    "fremont": 2,
    "french": 1,
    "french's": 2,
    "french-polynesia": 5,
    "frenchman": 2,
    "frenchmen": 2,
    "frenetic": 3,
    "frenette": 2,
    "freni": 2,
    "frenkel": 2,
    "frentz": 1,
    "frenulum": 3,
    "frenz": 1,
    "frenzel": 2,
    "frenzel(1)": 2,
    "frenzied": 2,
    "frenzies": 2,
    "frenzy": 2,
    "freon": 2,
    "freons": 2,
    "frequencies": 3,
    "frequency": 3,
    "frequent": 2,
    "frequent(1)": 2,
    "frequented": 3,
    "frequenting": 3,
    "frequenting(1)": 3,
    "frequently": 3,
    "frequently(1)": 3,
    "frequents": 2,
    "frequents(1)": 2,
    "frere": 1,
    "frere(1)": 1,
    "freres": 1,
    "freres(1)": 1,
    "frerichs": 2,
    "frericks": 2,
    "frerika": 3,
    "frerking": 2,
    "fresco": 2,
    "fresco's": 2,
    "frescoed": 2,
    "frescoes": 2,
    "frese": 1,
    "fresenius": 4,
    "fresh": 1,
    "freshbake": 2,
    "freshbake's": 2,
    "freshen": 2,
    "freshened": 2,
    "freshener": 3,
    "freshener(1)": 2,
    "fresheners": 3,
    "fresheners(1)": 2,
    "freshening": 3,
    "freshening(1)": 2,
    "freshens": 2,
    "fresher": 2,
    "freshest": 2,
    "freshkill": 2,
    "freshkills": 2,
    "freshley": 2,
    "freshly": 2,
    "freshman": 2,
    "freshmen": 2,
    "freshness": 2,
    "freshour": 2,
    "freshwater": 3,
    "fresno": 2,
    "fresno's": 2,
    "fresquez": 2,
    "freston": 2,
    "fret": 1,
    "fretful": 2,
    "frets": 1,
    "frett": 1,
    "fretted": 2,
    "fretter": 2,
    "fretting": 2,
    "fretwell": 2,
    "fretz": 1,
    "freud": 1,
    "freud's": 1,
    "freudenberg": 3,
    "freudenthal": 3,
    "freudian": 3,
    "freund": 1,
    "freundlich": 2,
    "frevert": 2,
    "frew": 1,
    "frewen": 2,
    "frewin": 2,
    "frey": 1,
    "frey's": 1,
    "freya": 2,
    "freyer": 2,
    "freyermuth": 3,
    "freyman": 2,
    "freymiller": 3,
    "freyne": 1,
    "freyre": 1,
    "freytag": 2,
    "frezza": 2,
    "friar": 2,
    "friars": 2,
    "friary": 3,
    "frias": 2,
    "friberg": 2,
    "fribourg": 2,
    "fricano": 3,
    "frick": 1,
    "fricke": 1,
    "fricker": 2,
    "frickey": 2,
    "fricks": 1,
    "friction": 2,
    "frictionless": 3,
    "frictions": 2,
    "frida": 2,
    "friday": 2,
    "friday(1)": 2,
    "friday's": 2,
    "friday's(1)": 2,
    "fridays": 2,
    "fridays(1)": 2,
    "friddle": 2,
    "fridge": 1,
    "fridges": 2,
    "fridley": 2,
    "fridman": 2,
    "fridolf": 2,
    "fridovich": 3,
    "fridrich": 2,
    "fridson": 2,
    "frie": 2,
    "friebel": 2,
    "fried": 1,
    "fried(1)": 1,
    "frieda": 2,
    "friedan": 2,
    "friedberg": 2,
    "friede": 1,
    "friedel": 2,
    "frieden": 2,
    "friedenberg": 3,
    "frieder": 2,
    "friederich": 3,
    "friederike": 3,
    "friedhelm": 2,
    "friedhoff": 2,
    "friedl": 2,
    "friedland": 2,
    "friedlander": 3,
    "friedley": 2,
    "friedli": 2,
    "friedline": 2,
    "friedly": 2,
    "friedman": 2,
    "friedman's": 2,
    "friedmann": 2,
    "friedrich": 2,
    "friedrichs": 2,
    "friedrichsen": 3,
    "friedrick": 2,
    "friedsam": 2,
    "friedson": 2,
    "friedt": 1,
    "friel": 1,
    "frieling": 2,
    "frieman": 2,
    "friend": 1,
    "friend's": 1,
    "friend's(1)": 1,
    "friendlier": 3,
    "friendlier(1)": 3,
    "friendliest": 3,
    "friendliest(1)": 3,
    "friendliness": 3,
    "friendliness(1)": 3,
    "friendly": 2,
    "friendly(1)": 2,
    "friendly's": 2,
    "friendly's(1)": 2,
    "friends": 1,
    "friends(1)": 1,
    "friends'": 1,
    "friends'(1)": 1,
    "friendship": 2,
    "friendship(1)": 2,
    "friendships": 2,
    "friendships(1)": 2,
    "frier": 2,
    "frierson": 2,
    "fries": 1,
    "friese": 1,
    "friesen": 2,
    "friesenhahn": 3,
    "friesner": 2,
    "frieson": 2,
    "friess": 1,
    "friesz": 1,
    "frieze": 1,
    "friezes": 2,
    "frigate": 2,
    "frigate's": 2,
    "frigates": 2,
    "fright": 1,
    "frighten": 2,
    "frightened": 2,
    "frightening": 3,
    "frightening(1)": 2,
    "frighteningly": 4,
    "frightens": 2,
    "frightful": 2,
    "frightfully": 3,
    "frigid": 2,
    "frigo": 2,
    "frigon": 2,
    "friis": 1,
    "frikkie": 2,
    "fril": 1,
    "friley": 2,
    "frill": 1,
    "frills": 1,
    "frilly": 2,
    "fringe": 1,
    "fringer": 2,
    "fringes": 2,
    "frink": 1,
    "friona": 3,
    "frisa": 2,
    "frisbee": 2,
    "frisbie": 2,
    "frisby": 2,
    "frisch": 1,
    "friscia": 2,
    "frisco": 2,
    "frisella": 3,
    "frishman": 2,
    "frisina": 3,
    "frisinger": 3,
    "frisk": 1,
    "friske": 1,
    "frisked": 1,
    "friskin": 2,
    "frisky": 2,
    "frison": 2,
    "frist": 1,
    "fristoe": 2,
    "fritch": 1,
    "fritcher": 2,
    "fritchman": 2,
    "frith": 1,
    "frito": 2,
    "fritos": 2,
    "frits": 1,
    "fritsch": 1,
    "fritsche": 1,
    "fritter": 2,
    "frittered": 2,
    "frittering": 3,
    "fritts": 1,
    "fritz": 1,
    "fritze": 1,
    "fritzen": 2,
    "fritzi": 2,
    "fritzie": 2,
    "fritzinger": 3,
    "fritzler": 2,
    "fritzsche": 1,
    "fritzsche(1)": 1,
    "fritzsche(2)": 1,
    "frivolity": 4,
    "frivolous": 3,
    "frivolously": 4,
    "frix": 1,
    "frizell": 2,
    "frizzell": 2,
    "fro": 1,
    "froberg": 2,
    "frock": 1,
    "frocks": 1,
    "froder": 2,
    "froedge": 1,
    "froehlich": 2,
    "froelich": 2,
    "froemming": 2,
    "froese": 1,
    "frog": 1,
    "frog's": 1,
    "frogg": 1,
    "frogge": 1,
    "frogman": 2,
    "frogmen": 2,
    "frogmouth": 2,
    "frogmouths": 2,
    "frogmouths(1)": 2,
    "frogs": 1,
    "froh": 1,
    "frohlich": 2,
    "frohman": 2,
    "frohn": 1,
    "frohnmayer": 3,
    "froio": 3,
    "frolic": 2,
    "frolicking": 3,
    "frolo": 2,
    "from": 1,
    "from(1)": 1,
    "froman": 2,
    "frombuger": 3,
    "frombuger's": 3,
    "frome": 1,
    "fromer": 2,
    "fromm": 1,
    "fromme": 1,
    "frommelt": 2,
    "frommer": 2,
    "fromstein": 2,
    "fromstein(1)": 2,
    "fronczak": 2,
    "frond": 1,
    "fronde": 1,
    "fronds": 1,
    "fronek": 2,
    "froning": 2,
    "fronk": 1,
    "front": 1,
    "front's": 1,
    "frontage": 2,
    "frontal": 2,
    "fronted": 2,
    "frontera": 3,
    "fronterhouse": 3,
    "frontier": 2,
    "frontier's": 2,
    "frontiere": 2,
    "frontieres": 2,
    "frontiers": 2,
    "fronting": 2,
    "frontline": 2,
    "frontline's": 2,
    "frontrunner": 3,
    "frontrunners": 3,
    "fronts": 1,
    "frontz": 1,
    "frosch": 1,
    "fross": 1,
    "frost": 1,
    "frostban": 2,
    "frostbite": 2,
    "frostbitten": 3,
    "frosted": 2,
    "frosted(1)": 2,
    "frosting": 2,
    "frostings": 2,
    "frosts": 1,
    "frosty": 2,
    "froth": 1,
    "frothiness": 3,
    "frothingham": 3,
    "froths": 1,
    "frothy": 2,
    "frown": 1,
    "frowned": 1,
    "frownfelter": 3,
    "frowning": 2,
    "frowningly": 3,
    "frowns": 1,
    "froylan": 2,
    "froze": 1,
    "frozen": 2,
    "frucher": 2,
    "fruchey": 2,
    "fruchter": 2,
    "fruchtman": 2,
    "fructose": 2,
    "frueh": 1,
    "fruehauf": 2,
    "fruehling": 2,
    "frugal": 2,
    "frugality": 4,
    "frugally": 3,
    "fruge": 1,
    "fruin": 2,
    "fruit": 1,
    "fruitcake": 2,
    "fruitcakes": 2,
    "fruitful": 2,
    "fruiting": 2,
    "fruition": 3,
    "fruitless": 2,
    "fruitlessly": 3,
    "fruitopia": 4,
    "fruits": 1,
    "fruity": 2,
    "frum": 1,
    "frumkin": 2,
    "frump": 1,
    "frumpy": 2,
    "frunze": 1,
    "frusen": 2,
    "frush": 1,
    "frustrate": 2,
    "frustrated": 3,
    "frustrates": 2,
    "frustrating": 3,
    "frustratingly": 4,
    "frustration": 3,
    "frustrations": 3,
    "frutchey": 2,
    "fruth": 1,
    "frutiger": 3,
    "fry": 1,
    "fry's": 1,
    "fryar": 2,
    "fryberger": 3,
    "frye": 1,
    "fryer": 2,
    "fryers": 2,
    "frying": 2,
    "fryling": 2,
    "fryman": 2,
    "frymire": 2,
    "frymire(1)": 2,
    "fryrear": 2,
    "frysinger": 3,
    "fs": 0,
    "fs(1)": 2,
    "fsi": 1,
    "fthenakis": 3,
    "fu": 1,
    "fua": 2,
    "fucci": 2,
    "fuchs": 1,
    "fuchsias": 2,
    "fuck": 1,
    "fucked": 1,
    "fucker": 2,
    "fuckers": 2,
    "fucking": 2,
    "fucks": 1,
    "fudala": 3,
    "fuddrucker": 3,
    "fuddruckers": 3,
    "fuddy": 2,
    "fudge": 1,
    "fudged": 1,
    "fudging": 2,
    "fudgy": 2,
    "fudo": 2,
    "fudosan": 3,
    "fuel": 2,
    "fuel(1)": 1,
    "fuel's": 2,
    "fueled": 2,
    "fueling": 2,
    "fuelled": 2,
    "fuelling": 2,
    "fuels": 2,
    "fuente": 2,
    "fuentes": 2,
    "fuentez": 2,
    "fuer": 1,
    "fuerst": 1,
    "fuerstenberg": 3,
    "fuerth": 1,
    "fugard": 2,
    "fugate": 2,
    "fugazy": 3,
    "fuge": 1,
    "fugere": 2,
    "fugett": 2,
    "fugitive": 3,
    "fugitive(1)": 3,
    "fugitives": 3,
    "fugitt": 2,
    "fugotsten": 3,
    "fugue": 1,
    "fugues": 1,
    "fuhr": 1,
    "fuhrer": 2,
    "fuhrman": 2,
    "fuhrman's": 2,
    "fuhrmann": 2,
    "fuhrmann's": 2,
    "fuhrmans": 2,
    "fuhs": 1,
    "fuji": 2,
    "fuji's": 2,
    "fujian": 3,
    "fujii": 3,
    "fujikawa": 4,
    "fujikura": 4,
    "fujimori": 4,
    "fujimori's": 4,
    "fujimoto": 4,
    "fujio": 3,
    "fujioka": 4,
    "fujis": 2,
    "fujisankei": 4,
    "fujisawa": 4,
    "fujita": 3,
    "fujitsu": 3,
    "fujitsu's": 3,
    "fujiwara": 4,
    "fujiya": 3,
    "fujiyama": 4,
    "fuke": 1,
    "fuklah": 2,
    "fuklah's": 2,
    "fukowoka": 4,
    "fukuda": 3,
    "fukui": 3,
    "fukumoto": 4,
    "fukunaga": 4,
    "fukuoka": 4,
    "fukushima": 4,
    "fukuyama": 4,
    "fulani": 3,
    "fulbright": 2,
    "fulcher": 2,
    "fulco": 2,
    "fulcrum": 2,
    "fuld": 1,
    "fulenwider": 4,
    "fulfer": 2,
    "fulfill": 2,
    "fulfilled": 2,
    "fulfilling": 3,
    "fulfillment": 3,
    "fulfills": 2,
    "fulford": 2,
    "fulgencio": 4,
    "fulgham": 2,
    "fulghum": 2,
    "fulginiti": 4,
    "fulk": 1,
    "fulkerson": 3,
    "fulks": 1,
    "full": 1,
    "full's": 1,
    "full-size": 2,
    "full-sized": 2,
    "fullam": 2,
    "fullard": 2,
    "fullback": 2,
    "fullbacks": 2,
    "fullbright": 2,
    "fullen": 2,
    "fullenkamp": 3,
    "fullenwider": 4,
    "fuller": 2,
    "fuller's": 2,
    "fullerton": 3,
    "fullest": 2,
    "fullfare": 2,
    "fullilove": 4,
    "fullington": 3,
    "fullman": 2,
    "fullmer": 2,
    "fullness": 2,
    "fulltime": 2,
    "fullwood": 2,
    "fully": 2,
    "fulmer": 2,
    "fulminate": 3,
    "fulmore": 2,
    "fulop": 2,
    "fulp": 1,
    "fulsome": 2,
    "fulton": 2,
    "fulton's": 2,
    "fults": 1,
    "fultz": 1,
    "fulvia": 3,
    "fulwider": 3,
    "fulwiler": 3,
    "fulwood": 2,
    "fumaroles": 3,
    "fumble": 2,
    "fumbled": 2,
    "fumbles": 2,
    "fumbling": 3,
    "fumbling(1)": 2,
    "fume": 1,
    "fumed": 1,
    "fumes": 1,
    "fumi": 2,
    "fumi(1)": 2,
    "fumidor": 3,
    "fumidors": 3,
    "fumigate": 3,
    "fumigating": 4,
    "fumigation": 4,
    "fuming": 2,
    "fumio": 3,
    "fun": 1,
    "funari": 3,
    "funaro": 3,
    "funaro's": 3,
    "funches": 2,
    "funchess": 2,
    "funck": 1,
    "function": 2,
    "functional": 3,
    "functionality": 5,
    "functionally": 4,
    "functionally(1)": 3,
    "functionaries": 4,
    "functionary": 4,
    "functioned": 2,
    "functioning": 3,
    "functions": 2,
    "fund": 1,
    "fund's": 1,
    "fundacion": 3,
    "fundacion(1)": 3,
    "fundamental": 4,
    "fundamental(1)": 4,
    "fundamentalism": 6,
    "fundamentalism(1)": 6,
    "fundamentalist": 5,
    "fundamentalist(1)": 5,
    "fundamentalists": 5,
    "fundamentalists(1)": 5,
    "fundamentalists(2)": 5,
    "fundamentalists(3)": 5,
    "fundamentally": 5,
    "fundamentally(1)": 5,
    "fundamentals": 4,
    "fundamentals(1)": 4,
    "funded": 2,
    "funded(1)": 2,
    "funder": 2,
    "funderburg": 3,
    "funderburk": 3,
    "funderburke": 3,
    "funders": 2,
    "funding": 2,
    "fundora": 3,
    "fundraiser": 3,
    "fundraiser's": 3,
    "fundraisers": 3,
    "fundraising": 3,
    "funds": 1,
    "funds'": 1,
    "funeral": 3,
    "funerals": 3,
    "funerary": 4,
    "funes": 1,
    "fung": 1,
    "fung's": 1,
    "fungal": 2,
    "fungi": 2,
    "fungible": 3,
    "fungicide": 3,
    "fungicides": 3,
    "fungus": 2,
    "funicello": 4,
    "funk": 1,
    "funke": 1,
    "funkhouser": 3,
    "funks": 1,
    "funky": 2,
    "funnel": 2,
    "funneled": 2,
    "funneling": 3,
    "funneling(1)": 2,
    "funnell": 2,
    "funnels": 2,
    "funnest": 2,
    "funnier": 3,
    "funniest": 3,
    "funniness": 3,
    "funny": 2,
    "funs": 1,
    "funston": 2,
    "funtime": 2,
    "fuoco": 3,
    "fuoss": 1,
    "fuqua": 2,
    "fuquay": 2,
    "fur": 1,
    "furash": 2,
    "furbee": 2,
    "furber": 2,
    "furbish": 2,
    "furbished": 2,
    "furbishes": 3,
    "furbishing": 3,
    "furbush": 2,
    "furby": 2,
    "furches": 2,
    "furer": 2,
    "furey": 2,
    "furfaro": 3,
    "furgason": 3,
    "furgerson": 3,
    "furgeson": 3,
    "furia": 3,
    "furini": 3,
    "furini's": 3,
    "furino": 3,
    "furious": 3,
    "furiouser": 4,
    "furiously": 4,
    "furlan": 2,
    "furlaud": 2,
    "furlett": 2,
    "furlett(1)": 2,
    "furlong": 2,
    "furlough": 2,
    "furloughed": 2,
    "furloughs": 2,
    "furlow": 2,
    "furman": 2,
    "furmark": 2,
    "furnace": 2,
    "furnace's": 3,
    "furnaces": 3,
    "furnari": 3,
    "furnas": 2,
    "furner": 2,
    "furness": 2,
    "furney": 2,
    "furnish": 2,
    "furnished": 2,
    "furnishes": 3,
    "furnishing": 3,
    "furnishings": 3,
    "furniss": 2,
    "furniture": 3,
    "furniture's": 3,
    "furno": 2,
    "furor": 2,
    "furr": 1,
    "furr's": 1,
    "furrer": 2,
    "furrh": 1,
    "furrier": 3,
    "furriers": 3,
    "furrow": 2,
    "furrowed": 2,
    "furry": 2,
    "furs": 1,
    "furse": 1,
    "furst": 1,
    "furstenberg": 3,
    "furtado": 3,
    "furtak": 2,
    "furtaw": 2,
    "furth": 1,
    "further": 2,
    "furtherance": 3,
    "furthered": 2,
    "furthering": 3,
    "furthermore": 3,
    "furthers": 2,
    "furthest": 2,
    "furtick": 2,
    "furtive": 2,
    "furtively": 3,
    "furukawa": 4,
    "furuta": 3,
    "furuya": 3,
    "fury": 2,
    "fusaro": 3,
    "fusco": 2,
    "fuse": 1,
    "fused": 1,
    "fuselage": 3,
    "fuselage(1)": 3,
    "fuselages": 4,
    "fuselages(1)": 4,
    "fuselier": 3,
    "fuses": 2,
    "fuses(1)": 2,
    "fusible": 3,
    "fusillade": 3,
    "fusilli": 3,
    "fusing": 2,
    "fusion": 2,
    "fusner": 2,
    "fuson": 2,
    "fuss": 1,
    "fussed": 1,
    "fussell": 2,
    "fusselman": 3,
    "fusses": 2,
    "fussing": 2,
    "fussner": 2,
    "fussy": 2,
    "fust": 1,
    "fustat": 2,
    "fustok": 2,
    "fuston": 2,
    "futch": 1,
    "futher": 2,
    "futile": 2,
    "futility": 4,
    "futon": 2,
    "futons": 2,
    "futral": 2,
    "futrell": 2,
    "futterman": 3,
    "future": 2,
    "future's": 2,
    "futures": 2,
    "futures'": 2,
    "futurism": 4,
    "futurist": 3,
    "futuristic": 4,
    "futurists": 3,
    "fuzes": 2,
    "fuzz": 1,
    "fuzzier": 3,
    "fuzzy": 2,
    "fye": 1,
    "fyfe": 1,
    "fyffe": 1,
    "fyffes": 1,
    "fyffes(1)": 1,
    "fyke": 1,
    "fyock": 1,
    "fyodor": 2,
    "fyodor's": 2,
    "fyodorov": 3,
    "fyodorov's": 3,
    "g": 1,
    "g's": 1,
    "g'vanni's": 4,
    "g.": 1,
    "g.'s": 1,
    "g.s": 1,
    "ga": 1,
    "ga(1)": 2,
    "ga(2)": 2,
    "gaal": 1,
    "gaar": 1,
    "gaarder": 2,
    "gab": 1,
    "gaba": 2,
    "gabaldon": 3,
    "gabardine": 3,
    "gabardines": 3,
    "gabay": 2,
    "gabbard": 2,
    "gabbert": 2,
    "gabbing": 2,
    "gabbro": 2,
    "gabbroic": 3,
    "gabby": 2,
    "gabe": 1,
    "gabehart": 2,
    "gabeira": 3,
    "gabel": 2,
    "gabele": 3,
    "gabelli": 3,
    "gaber": 2,
    "gabert": 2,
    "gabhart": 2,
    "gabie": 2,
    "gable": 2,
    "gabled": 2,
    "gabler": 3,
    "gabler(1)": 2,
    "gables": 2,
    "gabon": 2,
    "gabor": 2,
    "gaboriault": 4,
    "gaboury": 3,
    "gabrall": 2,
    "gabrall's": 2,
    "gabriel": 3,
    "gabriel's": 3,
    "gabriela": 4,
    "gabriele": 3,
    "gabriella": 4,
    "gabrielle": 3,
    "gabrielli": 4,
    "gabrielsen": 3,
    "gabrielsen(1)": 4,
    "gabrielson": 3,
    "gabrielson(1)": 4,
    "gabrowny": 3,
    "gabrys": 3,
    "gaby": 2,
    "gaccione": 3,
    "gacek": 2,
    "gach": 1,
    "gacy": 2,
    "gacy's": 2,
    "gad": 1,
    "gadberry": 3,
    "gadbois": 2,
    "gadd": 1,
    "gaddie": 2,
    "gadding": 2,
    "gaddis": 2,
    "gaddum": 2,
    "gaddy": 2,
    "gade": 1,
    "gadflies": 2,
    "gadfly": 2,
    "gadget": 2,
    "gadget's": 2,
    "gadgetry": 3,
    "gadgets": 2,
    "gadhafi": 3,
    "gadhafi(1)": 3,
    "gadhafi's": 3,
    "gadhafi's(1)": 3,
    "gadomski": 3,
    "gadoury": 3,
    "gads": 1,
    "gadsby": 2,
    "gadsden": 2,
    "gadson": 2,
    "gadway": 2,
    "gadzinski": 3,
    "gae": 1,
    "gaea": 2,
    "gaebel": 2,
    "gaede": 1,
    "gael": 1,
    "gaelic": 2,
    "gaertner": 2,
    "gaeta": 2,
    "gaetano": 3,
    "gaeth": 1,
    "gaetz": 1,
    "gaf": 1,
    "gaff": 1,
    "gaffe": 1,
    "gaffes": 1,
    "gaffey": 2,
    "gaffin": 2,
    "gaffney": 2,
    "gafford": 2,
    "gag": 1,
    "gagan": 2,
    "gagarin": 3,
    "gage": 1,
    "gagel": 2,
    "gagen": 2,
    "gager": 2,
    "gagged": 1,
    "gaggle": 2,
    "gagliano": 4,
    "gagliano(1)": 4,
    "gagliardi": 4,
    "gagliardi(1)": 4,
    "gagliardo": 4,
    "gagliardo(1)": 4,
    "gaglio": 3,
    "gaglione": 4,
    "gaglione(1)": 4,
    "gagne": 2,
    "gagne(1)": 2,
    "gagner": 2,
    "gagnier": 3,
    "gagnon": 2,
    "gags": 1,
    "gahagan": 3,
    "gahan": 2,
    "gahli": 2,
    "gahm": 1,
    "gahn": 1,
    "gahr": 1,
    "gai": 1,
    "gaia": 2,
    "gaidar": 2,
    "gaidar's": 2,
    "gaier": 2,
    "gaige": 1,
    "gail": 1,
    "gail's": 1,
    "gaile": 1,
    "gailey": 2,
    "gaillard": 2,
    "gaily": 2,
    "gain": 1,
    "gained": 1,
    "gainer": 2,
    "gainers": 2,
    "gaines": 1,
    "gainesville": 2,
    "gainey": 2,
    "gainful": 2,
    "gainfully": 3,
    "gaining": 2,
    "gainor": 2,
    "gainous": 2,
    "gains": 1,
    "gainsay": 2,
    "gainsboro": 3,
    "gainsco": 2,
    "gair": 1,
    "gaiser": 2,
    "gait": 1,
    "gaitan": 2,
    "gaiter": 2,
    "gaither": 2,
    "gaithersburg": 3,
    "gaitskill": 2,
    "gajda": 2,
    "gajewski": 3,
    "gal": 1,
    "gala": 2,
    "gala(1)": 2,
    "galactic": 3,
    "galactose": 3,
    "galahad": 3,
    "galambos": 3,
    "galan": 2,
    "galane": 2,
    "galang": 2,
    "galanis": 3,
    "galanos": 3,
    "galant": 2,
    "galante": 3,
    "galanter": 3,
    "galanti": 3,
    "galapagos": 4,
    "galarneau": 3,
    "galarza": 3,
    "galas": 2,
    "galasie": 3,
    "galassi": 3,
    "galasso": 3,
    "galatas": 3,
    "galatea": 4,
    "galati": 3,
    "galaviz": 3,
    "galax": 2,
    "galaxies": 3,
    "galaxy": 3,
    "galaxy's": 3,
    "galban": 2,
    "galbo": 2,
    "galbraith": 2,
    "galbreath": 2,
    "gale": 1,
    "gale's": 1,
    "galea": 3,
    "galeano": 3,
    "galeb": 2,
    "galeb(1)": 2,
    "galebs": 2,
    "galebs(1)": 2,
    "galef": 2,
    "galen": 2,
    "galen's": 2,
    "galena": 3,
    "galenical": 4,
    "galentine": 4,
    "galer": 2,
    "galeria": 4,
    "galerias": 4,
    "galeries": 3,
    "galernter": 3,
    "gales": 1,
    "galesburg": 2,
    "galesi": 3,
    "galey": 2,
    "galford": 2,
    "galgano": 3,
    "gali": 2,
    "gali's": 2,
    "galiano": 4,
    "galicia": 4,
    "galie": 2,
    "galiena": 3,
    "galik": 2,
    "galilean": 4,
    "galilee": 3,
    "galileo": 4,
    "galileo(1)": 4,
    "galileo's": 4,
    "galileo's(1)": 4,
    "galin": 2,
    "galina": 3,
    "galindo": 3,
    "galinski": 3,
    "galinsky": 3,
    "galioto": 4,
    "galipault": 3,
    "galipault(1)": 3,
    "galipeau": 3,
    "galitsin": 3,
    "galka": 2,
    "gall": 1,
    "galla": 2,
    "gallacher": 3,
    "gallager": 3,
    "gallagher": 3,
    "gallahan": 3,
    "gallaher": 3,
    "gallamore": 3,
    "galland": 2,
    "gallant": 2,
    "gallantly": 3,
    "gallantry": 3,
    "gallard": 2,
    "gallardo": 3,
    "gallas": 2,
    "gallatin": 3,
    "gallaudet": 3,
    "gallaway": 3,
    "gallbladder": 3,
    "galle": 1,
    "galle(1)": 2,
    "gallego": 3,
    "gallegos": 3,
    "gallemore": 3,
    "gallen": 2,
    "gallentine": 4,
    "galleon": 3,
    "galleons": 3,
    "galler": 2,
    "gallerani": 4,
    "galleria": 4,
    "galleries": 3,
    "gallery": 3,
    "gallery's": 3,
    "galles": 1,
    "gallet": 2,
    "galletti": 3,
    "galley": 2,
    "galleys": 2,
    "galli": 2,
    "gallia": 2,
    "galliano": 4,
    "gallic": 2,
    "gallick": 2,
    "gallien": 2,
    "gallier": 3,
    "galligan": 3,
    "galliher": 3,
    "gallik": 2,
    "gallimard": 3,
    "gallimore": 3,
    "gallina": 3,
    "galling": 2,
    "gallinger": 3,
    "gallinsky": 3,
    "gallion": 2,
    "gallium": 3,
    "gallivan": 3,
    "gallman": 2,
    "gallo": 2,
    "gallo's": 2,
    "gallogly": 3,
    "gallon": 2,
    "gallons": 2,
    "galloon": 2,
    "gallop": 2,
    "galloped": 2,
    "galloping": 3,
    "gallos": 2,
    "gallow": 2,
    "galloway": 3,
    "galloways": 3,
    "gallows": 2,
    "galls": 1,
    "gallstone": 2,
    "gallstones": 2,
    "gallstones(1)": 2,
    "gallucci": 3,
    "galluccio": 4,
    "gallup": 2,
    "gallus": 2,
    "galluzzo": 3,
    "gallway": 2,
    "galoob": 2,
    "galoob's": 2,
    "galore": 2,
    "galosh": 2,
    "galoshes": 3,
    "galoshes(1)": 3,
    "galotti": 3,
    "galpin": 2,
    "gals": 1,
    "galster": 2,
    "galsworthy": 3,
    "galt": 1,
    "galton": 2,
    "galudet": 3,
    "galus": 2,
    "galusha": 3,
    "galuska": 3,
    "galvan": 2,
    "galvanic": 3,
    "galvanize": 3,
    "galvanized": 3,
    "galvanizes": 4,
    "galvanizing": 4,
    "galven": 2,
    "galveston": 3,
    "galvez": 2,
    "galvin": 2,
    "galvin's": 2,
    "galway": 2,
    "galyean": 3,
    "galyen": 3,
    "galyon": 3,
    "gama": 2,
    "gamache": 2,
    "gamage": 2,
    "gamal": 2,
    "gamba": 2,
    "gambale": 3,
    "gambardella": 4,
    "gamber": 2,
    "gambia": 3,
    "gambill": 2,
    "gambino": 3,
    "gambit": 2,
    "gambits": 2,
    "gamble": 2,
    "gamble's": 2,
    "gambled": 2,
    "gambler": 2,
    "gambler's": 2,
    "gamblers": 2,
    "gambles": 2,
    "gamblin": 2,
    "gambling": 3,
    "gambling(1)": 2,
    "gambling's": 2,
    "gamboa": 3,
    "gambone": 2,
    "gambrel": 2,
    "gambrell": 2,
    "gambrill": 2,
    "gambro": 2,
    "gamco": 2,
    "game": 1,
    "game's": 1,
    "gamecock": 2,
    "gamecocks": 2,
    "gamekeeper": 3,
    "gamekeepers": 3,
    "gamel": 2,
    "gamelin": 3,
    "gamelin(1)": 2,
    "gamello": 3,
    "gamely": 2,
    "gamer": 2,
    "gamers": 2,
    "games": 1,
    "games'": 1,
    "gameshow": 2,
    "gameshows": 2,
    "gamesman": 2,
    "gamesmanship": 3,
    "gamest": 2,
    "gamet": 2,
    "gametangia": 5,
    "gamete": 2,
    "gamete(1)": 2,
    "gametophyte": 4,
    "gamez": 2,
    "gaming": 2,
    "gaming's": 2,
    "gamino": 3,
    "gamm": 1,
    "gamma": 2,
    "gammage": 2,
    "gammal": 2,
    "gammel": 2,
    "gammell": 2,
    "gammill": 2,
    "gammon": 2,
    "gammons": 2,
    "gamons": 2,
    "gamp": 1,
    "gamper": 2,
    "gamsakhurdia": 5,
    "gamsakhurdia(1)": 4,
    "gamunde": 2,
    "gamunde's": 2,
    "gamut": 2,
    "gan": 1,
    "gananoque": 3,
    "ganas": 2,
    "ganatieuganauf": 5,
    "ganaway": 3,
    "gancarz": 2,
    "ganci": 2,
    "ganda": 2,
    "gandalf": 2,
    "gandalf's": 2,
    "gandara": 3,
    "gandee": 2,
    "gander": 2,
    "ganders": 2,
    "gandhi": 2,
    "gandhi's": 2,
    "gandolfi": 3,
    "gandolfo": 3,
    "gandy": 2,
    "ganem": 2,
    "ganes": 1,
    "ganey": 2,
    "gang": 1,
    "gang's": 1,
    "gangbanger": 3,
    "gangbangers": 3,
    "gangbuster": 3,
    "gangbusters": 3,
    "gange": 1,
    "gangemi": 3,
    "ganger": 2,
    "ganges": 2,
    "gangi": 2,
    "ganging": 2,
    "gangl": 2,
    "ganglia": 3,
    "ganglionic": 4,
    "gangloff": 2,
    "gangly": 2,
    "gangplank": 2,
    "gangrene": 2,
    "gangs": 1,
    "gangsta": 2,
    "gangster": 2,
    "gangsters": 2,
    "gangwer": 2,
    "ganic": 2,
    "ganim": 2,
    "ganis": 2,
    "ganley": 2,
    "gann": 1,
    "gannaway": 3,
    "gannett": 2,
    "gannett's": 2,
    "gannon": 2,
    "gano": 2,
    "ganoe": 2,
    "ganong": 2,
    "gans": 1,
    "gansen": 2,
    "ganser": 2,
    "ganske": 1,
    "ganson": 2,
    "ganster": 2,
    "gant": 1,
    "gantenbein": 3,
    "ganter": 2,
    "gantlet": 2,
    "gantner": 2,
    "gantos": 2,
    "gantry": 2,
    "gantt": 1,
    "gantz": 1,
    "ganus": 2,
    "ganymede": 3,
    "ganz": 1,
    "ganzel": 2,
    "ganzer": 2,
    "gaona": 3,
    "gap": 1,
    "gap's": 1,
    "gape": 1,
    "gaping": 2,
    "gapinski": 3,
    "gapp": 1,
    "gappa": 2,
    "gaps": 1,
    "gar": 1,
    "gara": 2,
    "garabedian": 5,
    "garafalo": 4,
    "garafola": 4,
    "garage": 2,
    "garages": 3,
    "garagiola": 5,
    "garagiola(1)": 5,
    "garajda": 3,
    "garajda(1)": 3,
    "garajda's": 3,
    "garajda's(1)": 3,
    "garamendi": 4,
    "garamendi's": 4,
    "garand": 2,
    "garant": 2,
    "garard": 2,
    "garavaglia": 5,
    "garay": 2,
    "garb": 1,
    "garbacz": 2,
    "garbage": 2,
    "garbarini": 4,
    "garbarino": 4,
    "garbe": 1,
    "garbed": 1,
    "garber": 2,
    "garbers": 2,
    "garbett": 2,
    "garble": 2,
    "garbled": 2,
    "garbles": 2,
    "garbling": 2,
    "garbo": 2,
    "garbutt": 2,
    "garceau": 2,
    "garces": 2,
    "garcetti": 3,
    "garcetti's": 3,
    "garcia": 3,
    "garcia's": 3,
    "garcias": 3,
    "garczynski": 3,
    "gard": 1,
    "garda": 2,
    "garde": 1,
    "gardea": 3,
    "gardella": 3,
    "garden": 2,
    "garden's": 2,
    "gardena": 3,
    "gardenamerica": 6,
    "gardened": 2,
    "gardener": 3,
    "gardener's": 3,
    "gardeners": 3,
    "gardeners(1)": 2,
    "gardenhire": 3,
    "gardenia": 3,
    "gardenias": 3,
    "gardening": 3,
    "gardening(1)": 2,
    "gardens": 2,
    "gardin": 2,
    "gardiner": 2,
    "gardini": 3,
    "gardini's": 3,
    "gardinier": 4,
    "gardinier(1)": 3,
    "gardner": 2,
    "gardner's": 2,
    "gardolin": 3,
    "gardolin's": 3,
    "garduno": 3,
    "gardyne": 2,
    "gare": 1,
    "gareau": 2,
    "gared": 2,
    "garelick": 3,
    "gareth": 2,
    "garett": 2,
    "garey": 2,
    "garfield": 2,
    "garfinkel": 3,
    "garfinkle": 3,
    "garfunkel": 3,
    "garg": 1,
    "gargan": 2,
    "gargano": 3,
    "gargantuan": 4,
    "garger": 2,
    "garges": 2,
    "gargill": 2,
    "gargis": 2,
    "gargiulo": 3,
    "gargoyle": 2,
    "gargoyles": 2,
    "garguilo": 3,
    "gargus": 2,
    "gari": 2,
    "garibaldi": 4,
    "garibay": 3,
    "gariepy": 3,
    "garin": 2,
    "garing": 2,
    "garinger": 3,
    "garis": 2,
    "garish": 2,
    "garissa": 3,
    "garity": 3,
    "garl": 1,
    "garlan": 2,
    "garland": 2,
    "garlic": 2,
    "garlick": 2,
    "garlicky": 3,
    "garling": 2,
    "garlinger": 3,
    "garlinghouse": 3,
    "garlington": 3,
    "garlitz": 2,
    "garlock": 2,
    "garlow": 2,
    "garman": 2,
    "garmany": 3,
    "garment": 2,
    "garments": 2,
    "garmon": 2,
    "garmond": 2,
    "garms": 1,
    "garmund": 2,
    "garn": 1,
    "garneau": 2,
    "garnell": 2,
    "garner": 2,
    "garnered": 2,
    "garnering": 3,
    "garners": 2,
    "garnes": 1,
    "garnet": 2,
    "garnett": 2,
    "garnette": 2,
    "garney": 2,
    "garnica": 3,
    "garnier": 3,
    "garnish": 2,
    "garnished": 2,
    "garnishes": 3,
    "garnishment": 3,
    "garno": 2,
    "garnock": 2,
    "garnsey": 2,
    "garo": 2,
    "garofalo": 4,
    "garofano": 4,
    "garofolo": 4,
    "garols": 2,
    "garon": 2,
    "garone": 2,
    "garonzik": 3,
    "garoutte": 2,
    "garp": 1,
    "garp's": 1,
    "garps": 1,
    "garr": 1,
    "garrabrant": 3,
    "garrahan": 3,
    "garramone": 3,
    "garrard": 2,
    "garratt": 2,
    "garraway": 3,
    "garrell": 2,
    "garrels": 2,
    "garrelts": 2,
    "garren": 2,
    "garret": 2,
    "garret's": 2,
    "garrets": 2,
    "garretson": 3,
    "garrett": 2,
    "garrett(1)": 2,
    "garrett's": 2,
    "garrett's(1)": 2,
    "garrette": 2,
    "garrey": 2,
    "garrick": 2,
    "garrido": 3,
    "garrido-luna": 5,
    "garriga": 3,
    "garrigan": 3,
    "garrigues": 3,
    "garrigus": 3,
    "garringer": 3,
    "garriott": 3,
    "garris": 2,
    "garrison": 3,
    "garrisoned": 3,
    "garritano": 4,
    "garritt": 2,
    "garrity": 3,
    "garro": 2,
    "garrod": 2,
    "garrol": 2,
    "garrols": 2,
    "garron": 2,
    "garron's": 2,
    "garros": 2,
    "garrott": 2,
    "garrow": 2,
    "garroway": 3,
    "garroz": 2,
    "garrulous": 3,
    "garry": 2,
    "garry(1)": 2,
    "gars": 1,
    "garside": 2,
    "garske": 1,
    "garson": 2,
    "garst": 1,
    "garsten": 2,
    "garsten's": 2,
    "garstin": 2,
    "garstka": 2,
    "garston": 2,
    "garten": 2,
    "gartenberg": 3,
    "garter": 2,
    "garters": 2,
    "garth": 1,
    "garthwaite": 2,
    "gartin": 2,
    "gartland": 2,
    "gartley": 2,
    "gartman": 2,
    "gartmore": 2,
    "gartner": 2,
    "garton": 2,
    "gartrell": 2,
    "gartside": 2,
    "gartzke": 1,
    "gartzke(1)": 2,
    "garuda": 3,
    "garuda's": 3,
    "garver": 2,
    "garver's": 2,
    "garverick": 3,
    "garvey": 2,
    "garvie": 2,
    "garvin": 2,
    "garwin": 2,
    "garwood": 2,
    "gary": 2,
    "gary(1)": 2,
    "gary's": 2,
    "gary's(1)": 2,
    "garza": 2,
    "garzarelli": 4,
    "garzon": 2,
    "gas": 1,
    "gas's": 2,
    "gasaway": 3,
    "gasbarro": 3,
    "gasca": 2,
    "gascon": 2,
    "gascons": 2,
    "gase": 1,
    "gaseous": 3,
    "gases": 2,
    "gases(1)": 2,
    "gash": 1,
    "gashed": 1,
    "gashes": 2,
    "gasich": 2,
    "gasification": 5,
    "gasify": 3,
    "gasior": 3,
    "gasiorowski": 5,
    "gaska": 2,
    "gaskamp": 2,
    "gaskell": 2,
    "gasket": 2,
    "gaskets": 2,
    "gaskey": 2,
    "gaskill": 2,
    "gaskin": 2,
    "gaskins": 2,
    "gaslight": 2,
    "gasner": 2,
    "gasohol": 3,
    "gasoline": 3,
    "gasolines": 3,
    "gasp": 1,
    "gaspar": 2,
    "gaspara": 3,
    "gaspard": 2,
    "gaspari": 3,
    "gasparini": 4,
    "gasparro": 3,
    "gaspe": 2,
    "gasped": 1,
    "gasper": 2,
    "gasperini": 4,
    "gasping": 2,
    "gasps": 1,
    "gasque": 1,
    "gass": 1,
    "gassaway": 3,
    "gassed": 1,
    "gassee": 2,
    "gassen": 2,
    "gasser": 2,
    "gassert": 2,
    "gasses": 2,
    "gassett": 2,
    "gassing": 2,
    "gassman": 2,
    "gassmann": 2,
    "gassner": 2,
    "gast": 1,
    "gastelli": 3,
    "gaster": 2,
    "gastilum": 3,
    "gastineau": 3,
    "gaston": 2,
    "gaston's": 2,
    "gastonia": 4,
    "gastric": 2,
    "gastritis": 3,
    "gastro": 2,
    "gastrointestinal": 6,
    "gastronomic": 4,
    "gastronomy": 4,
    "gastroscope": 3,
    "gastrovascular": 5,
    "gastrulate": 3,
    "gastrulation": 4,
    "gat": 1,
    "gatch": 1,
    "gatchel": 2,
    "gatchell": 2,
    "gate": 1,
    "gateau": 2,
    "gated": 2,
    "gatekeeper": 3,
    "gatekeepers": 3,
    "gateley": 3,
    "gateley(1)": 2,
    "gately": 2,
    "gates": 1,
    "gates'": 1,
    "gates's": 2,
    "gates's(1)": 1,
    "gateway": 2,
    "gateway's": 2,
    "gateways": 2,
    "gatewood": 2,
    "gath": 1,
    "gather": 2,
    "gathered": 2,
    "gatherer": 3,
    "gatherers": 3,
    "gathering": 3,
    "gatherings": 3,
    "gathers": 2,
    "gathings": 2,
    "gathman": 2,
    "gathright": 2,
    "gatien": 2,
    "gating": 2,
    "gatley": 2,
    "gatliff": 2,
    "gatlin": 2,
    "gatling": 2,
    "gatling's": 2,
    "gatoil": 2,
    "gator": 2,
    "gatorade": 3,
    "gators": 2,
    "gatos": 2,
    "gatos(1)": 2,
    "gatos(2)": 2,
    "gatos(3)": 2,
    "gatrell": 2,
    "gatsby": 2,
    "gatson": 2,
    "gatt": 1,
    "gatten": 2,
    "gatti": 2,
    "gatting": 2,
    "gattis": 2,
    "gattis(1)": 2,
    "gatton": 2,
    "gattuso": 3,
    "gatty": 2,
    "gatward": 2,
    "gatwick": 2,
    "gatwick(1)": 2,
    "gatx": 2,
    "gatz": 1,
    "gatza": 2,
    "gatzke": 1,
    "gatzke(1)": 2,
    "gau": 1,
    "gaub": 1,
    "gaubatz": 2,
    "gaubert": 2,
    "gaubert(1)": 2,
    "gaubert's": 2,
    "gaubert's(1)": 2,
    "gauch": 1,
    "gauche": 1,
    "gaucher": 2,
    "gaucho": 2,
    "gauchos": 2,
    "gaudet": 2,
    "gaudette": 2,
    "gaudin": 2,
    "gaudino": 3,
    "gaudio": 3,
    "gaudioso": 4,
    "gaudreau": 2,
    "gaudy": 2,
    "gauer": 2,
    "gauerke": 2,
    "gaufman": 2,
    "gaufman's": 2,
    "gauge": 1,
    "gauged": 1,
    "gauger": 2,
    "gauges": 2,
    "gauges(1)": 2,
    "gaugh": 1,
    "gaughan": 2,
    "gaughman": 2,
    "gaughran": 2,
    "gauging": 2,
    "gaugler": 2,
    "gauguin": 2,
    "gauguin(1)": 2,
    "gaul": 1,
    "gaulan": 2,
    "gaulden": 2,
    "gaulding": 2,
    "gaulin": 2,
    "gaulke": 1,
    "gaulle": 1,
    "gaullist": 2,
    "gauls": 1,
    "gault": 1,
    "gaultier": 2,
    "gaultier(1)": 2,
    "gaultney": 2,
    "gaumer": 2,
    "gaumond": 2,
    "gauna": 2,
    "gaunce": 1,
    "gaunt": 1,
    "gauntlet": 2,
    "gauntness": 2,
    "gauntt": 1,
    "gaus": 1,
    "gause": 1,
    "gausman": 2,
    "gauss": 1,
    "gaussian": 3,
    "gaustad": 2,
    "gaut": 1,
    "gauthier": 3,
    "gauthreaux": 2,
    "gautier": 3,
    "gautney": 2,
    "gautreau": 2,
    "gautreaux": 2,
    "gauvain": 2,
    "gauvin": 2,
    "gauvreau": 2,
    "gauze": 1,
    "gavalda": 3,
    "gavan": 2,
    "gave": 1,
    "gavel": 2,
    "gaven": 2,
    "gaver": 2,
    "gavigan": 3,
    "gavin": 2,
    "gaviotas": 4,
    "gaviotas(1)": 3,
    "gaviria": 4,
    "gavitt": 2,
    "gavlak": 2,
    "gavras": 2,
    "gavras's": 3,
    "gaw": 1,
    "gawain": 2,
    "gawel": 2,
    "gawen": 2,
    "gawk": 1,
    "gawker": 2,
    "gawkers": 2,
    "gawking": 2,
    "gawky": 2,
    "gawlik": 2,
    "gawne": 1,
    "gawron": 2,
    "gawronski": 3,
    "gawthrop": 2,
    "gaxiola": 4,
    "gay": 1,
    "gayda": 2,
    "gaydar": 2,
    "gayden": 2,
    "gaydos": 2,
    "gaydosh": 2,
    "gaye": 1,
    "gayer": 2,
    "gayhart": 2,
    "gayheart": 2,
    "gayle": 1,
    "gayler": 2,
    "gayles": 1,
    "gaylor": 2,
    "gaylord": 2,
    "gayman": 2,
    "gaymon": 2,
    "gaynatie": 3,
    "gayner": 2,
    "gayness": 2,
    "gaynor": 2,
    "gays": 1,
    "gayshill": 2,
    "gayshill(1)": 2,
    "gaytan": 2,
    "gayton": 2,
    "gaz": 1,
    "gaz(1)": 1,
    "gaza": 2,
    "gaza's": 2,
    "gazans": 2,
    "gazaway": 3,
    "gazda": 2,
    "gazdik": 2,
    "gaze": 1,
    "gazed": 1,
    "gazella": 3,
    "gazelle": 2,
    "gazelles": 2,
    "gazes": 2,
    "gazes(1)": 2,
    "gazeta": 3,
    "gazeta(1)": 3,
    "gazette": 2,
    "gazing": 2,
    "gazonsky": 3,
    "gazonsky's": 3,
    "gazprom": 2,
    "gazzola": 3,
    "gdansk": 1,
    "geac": 1,
    "geac(1)": 4,
    "geagea": 4,
    "gean": 1,
    "gear": 1,
    "gear's": 1,
    "gearan": 2,
    "gearan's": 2,
    "gearbox": 2,
    "gearboxes": 3,
    "geared": 1,
    "gearey": 2,
    "gearhart": 2,
    "gearhart(1)": 2,
    "gearheart": 2,
    "gearheart(1)": 2,
    "gearin": 2,
    "gearing": 2,
    "gears": 1,
    "geary": 2,
    "gebauer": 3,
    "gebbia": 3,
    "gebbie": 2,
    "gebbie's": 2,
    "gebel": 2,
    "gebert": 2,
    "gebhard": 2,
    "gebhardt": 2,
    "gebhart": 2,
    "gebler": 3,
    "gebler(1)": 2,
    "gebo": 2,
    "gechem": 2,
    "geck": 1,
    "gecko": 2,
    "geckos": 2,
    "ged": 1,
    "ged(1)": 3,
    "geddes": 2,
    "geddes(1)": 2,
    "geddie": 2,
    "geddings": 2,
    "geddis": 2,
    "gedeon": 3,
    "gedney": 2,
    "geduld": 2,
    "gee": 1,
    "gee's": 1,
    "geeing": 2,
    "geek": 1,
    "geeks": 1,
    "geeky": 2,
    "geena": 2,
    "geenen": 2,
    "geer": 1,
    "geerdes": 1,
    "geers": 2,
    "geerts": 1,
    "gees": 1,
    "geesaman": 3,
    "geese": 1,
    "geesey": 2,
    "geeslin": 2,
    "geeting": 2,
    "geez": 1,
    "geeze": 1,
    "geffen": 2,
    "geffert": 2,
    "geffner": 2,
    "geffre": 2,
    "gefinor": 3,
    "gegenheimer": 4,
    "gegg": 1,
    "gehl": 1,
    "gehle": 2,
    "gehlhausen": 3,
    "gehling": 2,
    "gehm": 1,
    "gehman": 2,
    "gehr": 1,
    "gehres": 1,
    "gehret": 2,
    "gehrig": 2,
    "gehrig's": 2,
    "gehring": 2,
    "gehringer": 3,
    "gehris": 2,
    "gehrke": 1,
    "gehrman": 2,
    "gehrmann": 2,
    "gehrt": 1,
    "gehry": 2,
    "geib": 1,
    "geibel": 2,
    "geico": 2,
    "geico's": 2,
    "geidar": 2,
    "geidel": 2,
    "geier": 2,
    "geiger": 2,
    "geigle": 2,
    "geigy": 2,
    "geigy's": 2,
    "geiken": 2,
    "geil": 1,
    "geiler": 2,
    "geiman": 2,
    "geimer": 2,
    "geis": 1,
    "geise": 1,
    "geisel": 2,
    "geiselman": 3,
    "geisen": 2,
    "geiser": 2,
    "geisert": 2,
    "geisha": 2,
    "geisinger": 3,
    "geisler": 2,
    "geiss": 1,
    "geissinger": 3,
    "geissler": 2,
    "geist": 1,
    "geister": 2,
    "geiszler": 2,
    "geitner": 2,
    "geitz": 1,
    "gejdenson": 3,
    "gekas": 2,
    "gekko": 2,
    "gel": 1,
    "gelardi": 3,
    "gelardin": 3,
    "gelasia": 4,
    "gelatin": 3,
    "gelatine": 3,
    "gelatinous": 4,
    "gelb": 1,
    "gelbard": 2,
    "gelbart": 2,
    "gelber": 2,
    "gelco": 2,
    "gelder": 2,
    "geldermann": 3,
    "gelernter": 3,
    "gelertner": 3,
    "gelett": 2,
    "gelette": 2,
    "gelfand": 2,
    "gelinas": 3,
    "gelineau": 3,
    "gell": 1,
    "gellatly": 3,
    "geller": 2,
    "gellerman": 3,
    "gellert": 2,
    "gelles": 1,
    "gelli": 2,
    "gellis": 2,
    "gellman": 2,
    "gellner": 2,
    "gelman": 2,
    "gelpi": 2,
    "gels": 1,
    "gelsinger": 3,
    "geltz": 1,
    "gelvin": 2,
    "gem": 1,
    "gem's": 1,
    "gemayel": 3,
    "gemayel(1)": 3,
    "gemayel(2)": 3,
    "gemayel's": 3,
    "gemayel's(1)": 3,
    "gemayel's(2)": 3,
    "gemberling": 3,
    "gemco": 2,
    "gemcraft": 2,
    "gemcraft's": 2,
    "gemex": 2,
    "gemfibrozil": 4,
    "gemfibrozil(1)": 4,
    "gemignani": 4,
    "gemina": 3,
    "geminate": 3,
    "geminate(1)": 3,
    "gemini": 3,
    "gemini(1)": 3,
    "gemma": 2,
    "gemme": 1,
    "gemmell": 2,
    "gemmer": 2,
    "gemmill": 2,
    "gems": 1,
    "gemsbok": 2,
    "gemstone": 2,
    "gemstones": 2,
    "gen": 1,
    "gena": 2,
    "genady": 3,
    "gencarelli": 4,
    "genco": 2,
    "gencor": 2,
    "gencorp": 2,
    "gencorp(1)": 2,
    "gencorp's": 2,
    "gencorp's(1)": 2,
    "gendarme": 2,
    "gender": 2,
    "genders": 2,
    "gendler": 2,
    "gendreau": 2,
    "gendrisek": 3,
    "gendrisek's": 3,
    "gendron": 2,
    "gene": 1,
    "gene's": 1,
    "genealogy": 5,
    "geneen": 2,
    "genego": 3,
    "genego(1)": 3,
    "genego(2)": 6,
    "genelab": 3,
    "genelabs": 3,
    "genemedicine": 5,
    "genencor": 3,
    "genentech": 3,
    "genentech's": 3,
    "genera": 3,
    "general": 3,
    "general(1)": 2,
    "general's": 3,
    "general's(1)": 2,
    "generale": 3,
    "generales": 4,
    "generali": 4,
    "generalissimo": 6,
    "generalist": 4,
    "generalists": 4,
    "generalities": 5,
    "generality": 5,
    "generalization": 6,
    "generalization(1)": 5,
    "generalizations": 6,
    "generalizations(1)": 5,
    "generalize": 4,
    "generalized": 4,
    "generalized(1)": 3,
    "generalizing": 5,
    "generalizing(1)": 4,
    "generally": 4,
    "generally(1)": 3,
    "generals": 3,
    "generals(1)": 2,
    "generalship": 4,
    "generate": 3,
    "generated": 4,
    "generated(1)": 4,
    "generates": 3,
    "generating": 4,
    "generation": 4,
    "generation's": 4,
    "generational": 5,
    "generationally": 6,
    "generations": 4,
    "generative": 4,
    "generator": 4,
    "generator's": 4,
    "generators": 4,
    "genereux": 3,
    "generic": 3,
    "generically": 4,
    "generics": 3,
    "genero": 3,
    "generosity": 5,
    "generous": 3,
    "generously": 4,
    "genes": 1,
    "genesco": 3,
    "genesee": 3,
    "genesis": 3,
    "genet": 2,
    "genetic": 3,
    "genetically": 4,
    "geneticist": 4,
    "geneticists": 4,
    "genetics": 3,
    "genetization": 5,
    "geneva": 3,
    "geneve": 2,
    "genevieve": 3,
    "genex": 2,
    "genex's": 3,
    "geng": 1,
    "gengenbach": 3,
    "gengenbach(1)": 3,
    "genger": 2,
    "genghis": 2,
    "gengler": 2,
    "gengler(1)": 2,
    "genial": 2,
    "geniality": 5,
    "genicom": 3,
    "genie": 2,
    "geniere": 2,
    "genis": 2,
    "genisco": 3,
    "genital": 3,
    "genitalia": 4,
    "genitals": 3,
    "genius": 2,
    "geniuses": 3,
    "genk": 1,
    "genlyte": 2,
    "genmar": 2,
    "genna": 2,
    "gennadi": 3,
    "gennady": 3,
    "gennaro": 3,
    "gennett": 2,
    "gennifer": 3,
    "geno": 2,
    "genoa": 3,
    "genocidal": 4,
    "genocide": 3,
    "genocides": 3,
    "genoese": 2,
    "genome": 2,
    "genossenschaftsbank": 5,
    "genotype": 3,
    "genotypes": 3,
    "genova": 3,
    "genovese": 3,
    "genovesi": 4,
    "genovise": 3,
    "genpharm": 2,
    "genrad": 2,
    "genre": 2,
    "genres": 2,
    "genrich": 2,
    "gens": 1,
    "genscher": 2,
    "gensel": 2,
    "gensia": 3,
    "genske": 1,
    "gensler": 3,
    "gensler(1)": 2,
    "genson": 2,
    "genstar": 2,
    "gent": 1,
    "gent's": 1,
    "genteel": 2,
    "genter": 2,
    "genther": 2,
    "genthner": 2,
    "gentian": 2,
    "gentile": 2,
    "gentile's": 2,
    "gentiles": 2,
    "gentility": 4,
    "gentle": 2,
    "gentle(1)": 2,
    "gentleladies": 4,
    "gentlelady": 4,
    "gentleman": 3,
    "gentleman(1)": 3,
    "gentleman's": 3,
    "gentleman's(1)": 3,
    "gentlemanly": 4,
    "gentlemanly(1)": 4,
    "gentlemen": 3,
    "gentlemen(1)": 3,
    "gentlemen's": 3,
    "gentlemen's(1)": 3,
    "gentleness": 3,
    "gentleness(1)": 3,
    "gentler": 2,
    "gentles": 2,
    "gentles(1)": 2,
    "gentlest": 3,
    "gentlewoman": 4,
    "gentlewoman(1)": 4,
    "gentlewoman's": 4,
    "gentlewoman's(1)": 4,
    "gentlewomen": 4,
    "gentlewomen(1)": 4,
    "gentlewomen's": 4,
    "gentlewomen's(1)": 4,
    "gently": 2,
    "gentner": 2,
    "gentrification": 5,
    "gentrified": 3,
    "gentrify": 3,
    "gentrifying": 4,
    "gentry": 2,
    "gentz": 1,
    "gentzler": 2,
    "genuine": 3,
    "genuine(1)": 3,
    "genuinely": 4,
    "genuinely(1)": 4,
    "genuineness": 4,
    "genung": 2,
    "genus": 2,
    "genz": 1,
    "genzyme": 2,
    "geo": 2,
    "geocentric": 4,
    "geochemistry": 5,
    "geodesic": 4,
    "geodesy": 4,
    "geodyne": 3,
    "geoff": 1,
    "geoffrey": 2,
    "geoffrey's": 2,
    "geoffrion": 4,
    "geoffroy": 3,
    "geoghegan": 3,
    "geographer": 4,
    "geographic": 4,
    "geographic's": 4,
    "geographical": 5,
    "geographically": 6,
    "geographically(1)": 5,
    "geography": 4,
    "geoid": 2,
    "geologic": 4,
    "geological": 5,
    "geologist": 4,
    "geologists": 4,
    "geology": 4,
    "geomagnetic": 5,
    "geometric": 4,
    "geometrical": 5,
    "geometrically": 5,
    "geometrics": 4,
    "geometries": 4,
    "geometry": 4,
    "geomorphology": 6,
    "geon": 2,
    "geophysical": 5,
    "geopolitic": 5,
    "geopolitical": 6,
    "geopolitically": 6,
    "geopolitics": 5,
    "geordie": 3,
    "georg": 2,
    "georgakis": 3,
    "georgann": 2,
    "george": 1,
    "george's": 2,
    "george's(1)": 2,
    "georgene": 2,
    "georges": 2,
    "georges(1)": 2,
    "georgeson": 3,
    "georgeson(1)": 2,
    "georgetown": 2,
    "georgette": 2,
    "georgi": 3,
    "georgia": 2,
    "georgia's": 2,
    "georgiades": 4,
    "georgiadis": 4,
    "georgian": 2,
    "georgiana": 4,
    "georgians": 2,
    "georgie": 2,
    "georgienne": 3,
    "georgina": 3,
    "georgine": 2,
    "georgio": 3,
    "georgiou": 2,
    "georgopoulos": 4,
    "georgy": 2,
    "geostrophic": 4,
    "geosyncline": 4,
    "geotaxis": 4,
    "geotek": 3,
    "geothermal": 4,
    "geotropic": 4,
    "geotropism": 5,
    "geoworks": 3,
    "gephardt": 2,
    "gephardt's": 2,
    "gephart": 2,
    "geppert": 2,
    "gera": 2,
    "gerace": 3,
    "geraci": 3,
    "geraghty": 3,
    "gerais": 2,
    "gerald": 2,
    "geraldi": 3,
    "geraldi(1)": 3,
    "geraldina": 4,
    "geraldine": 3,
    "geraldo": 3,
    "geraldo(1)": 3,
    "geralds": 2,
    "geran": 2,
    "geranium": 4,
    "geraniums": 4,
    "gerard": 2,
    "gerardi": 3,
    "gerardo": 3,
    "gerashchenko": 4,
    "gerasimov": 4,
    "gerasimov(1)": 4,
    "gerbasi": 3,
    "gerber": 2,
    "gerber's": 2,
    "gerberding": 3,
    "gerbert": 2,
    "gerbig": 2,
    "gerbino": 3,
    "gerbrandt": 2,
    "gerchas": 2,
    "gerchas(1)": 2,
    "gerd": 1,
    "gerda": 2,
    "gerdeman": 2,
    "gerdes": 1,
    "gerdes'": 1,
    "gerding": 2,
    "gerdts": 1,
    "gerdts(1)": 1,
    "gere": 1,
    "gere(1)": 1,
    "geremia": 4,
    "geren": 2,
    "gerena": 3,
    "gerety": 3,
    "gergel": 2,
    "gergely": 2,
    "gergen": 2,
    "gergen's": 2,
    "gerger": 2,
    "gergrude": 2,
    "gerhard": 2,
    "gerhardt": 2,
    "gerhart": 2,
    "gerhold": 2,
    "geri": 2,
    "geriatric": 4,
    "geriatrician": 5,
    "geriatricians": 5,
    "geriatrics": 4,
    "gerich": 2,
    "gericke": 2,
    "gerig": 2,
    "gering": 2,
    "geringer": 3,
    "gerk": 1,
    "gerke": 1,
    "gerken": 2,
    "gerkin": 2,
    "gerlach": 2,
    "gerleman": 2,
    "gerlich": 2,
    "gerling": 2,
    "gerlock": 2,
    "gerloff": 2,
    "germ": 1,
    "germain": 2,
    "germain's": 2,
    "germaine": 2,
    "german": 2,
    "german's": 2,
    "germane": 2,
    "germani": 3,
    "germania": 4,
    "germanic": 3,
    "germann": 2,
    "germano": 3,
    "germans": 2,
    "germans'": 2,
    "germantown": 3,
    "germany": 3,
    "germany's": 3,
    "germanys": 3,
    "germe": 1,
    "germer": 2,
    "germicide": 3,
    "germinate": 3,
    "germinated": 4,
    "germination": 4,
    "germiston": 3,
    "germiston's": 3,
    "germond": 2,
    "germs": 1,
    "gerner": 2,
    "gernert": 2,
    "gero": 2,
    "gerold": 2,
    "gerome": 2,
    "geron": 2,
    "geronimo": 4,
    "gerontologist": 5,
    "gerontology": 5,
    "geroux": 2,
    "gerow": 2,
    "gerrald": 2,
    "gerri": 2,
    "gerrick": 2,
    "gerrie": 2,
    "gerringer": 3,
    "gerrish": 2,
    "gerrit": 2,
    "gerrits": 2,
    "gerritsen": 3,
    "gerrity": 3,
    "gerry": 2,
    "gerry's": 2,
    "gerrymander": 4,
    "gerrymandered": 4,
    "gerrymandering": 5,
    "gerrymanders": 4,
    "gersch": 1,
    "gersh": 1,
    "gershman": 2,
    "gershon": 2,
    "gershowitz": 3,
    "gershwin": 2,
    "gershwin's": 2,
    "gerski": 2,
    "gerson": 2,
    "gerson(1)": 2,
    "gerst": 1,
    "gerstein": 2,
    "gerstein(1)": 2,
    "gerstel": 2,
    "gersten": 2,
    "gerstenberger": 4,
    "gerstenhaber": 4,
    "gerster": 2,
    "gerstman": 2,
    "gerstner": 2,
    "gerstner's": 2,
    "gerszewski": 3,
    "gert": 1,
    "gerth": 1,
    "gertie": 2,
    "gertler": 3,
    "gertler(1)": 2,
    "gertner": 2,
    "gertrud": 2,
    "gertrude": 2,
    "gertsch": 1,
    "gerty": 2,
    "gertz": 1,
    "gervais": 2,
    "gervase": 2,
    "gervasi": 3,
    "gervasio": 4,
    "gerwig": 2,
    "gerwin": 2,
    "gery": 2,
    "gesamtmetall": 4,
    "geschke": 1,
    "gesco": 2,
    "gesell": 2,
    "gesell's": 2,
    "gesellschaft": 3,
    "geserum": 3,
    "geske": 1,
    "gesner": 2,
    "gess": 1,
    "gessel": 2,
    "gessert": 2,
    "gessler": 3,
    "gessler(1)": 2,
    "gessner": 2,
    "gest": 1,
    "gestal": 2,
    "gestapo": 3,
    "gestate": 2,
    "gestation": 3,
    "gestetner": 3,
    "gesture": 2,
    "gestured": 2,
    "gestures": 2,
    "gesturing": 3,
    "gesualdi": 4,
    "gesundheit": 3,
    "get": 1,
    "get(1)": 1,
    "get-together": 4,
    "get-together(1)": 4,
    "get-togethers": 4,
    "get-togethers(1)": 4,
    "get-well": 2,
    "get-well(1)": 2,
    "getaway": 3,
    "getaways": 3,
    "getchell": 2,
    "geter": 2,
    "gethers": 2,
    "getman": 2,
    "gets": 1,
    "gets(1)": 1,
    "getsinger": 3,
    "gettel": 2,
    "getter": 2,
    "getters": 2,
    "gettin'": 2,
    "getting": 2,
    "getting(1)": 2,
    "gettinger": 3,
    "gettinger(1)": 3,
    "gettings": 2,
    "gettis": 2,
    "gettle": 2,
    "gettler": 3,
    "gettler(1)": 2,
    "gettman": 2,
    "getts": 1,
    "getty": 2,
    "getty's": 2,
    "gettys": 2,
    "gettysburg": 3,
    "gettysburg's": 3,
    "getulio": 4,
    "getz": 1,
    "geurin": 2,
    "geurts": 1,
    "geva": 2,
    "gevaert": 2,
    "geving": 2,
    "gewgaw": 2,
    "gewirtz": 2,
    "geyelin": 3,
    "geyer": 2,
    "geyser": 2,
    "geysers": 2,
    "gfeller": 3,
    "ghada": 2,
    "ghadafi": 3,
    "ghadafi(1)": 3,
    "ghadafi(2)": 3,
    "ghadafithe": 3,
    "ghadafito": 4,
    "ghafar": 2,
    "ghafar(1)": 2,
    "ghali": 2,
    "ghali's": 2,
    "ghana": 2,
    "ghana's": 2,
    "ghanaian": 3,
    "ghanaians": 3,
    "ghandi": 2,
    "gharbonifar": 4,
    "ghastliness": 3,
    "ghastly": 2,
    "ghattas": 2,
    "ghaznavi": 3,
    "ghee": 1,
    "gheen": 1,
    "ghent": 1,
    "gherardi": 3,
    "gherig": 2,
    "gherig's": 2,
    "gherman": 2,
    "ghetto": 2,
    "ghettoize": 3,
    "ghettos": 2,
    "ghez": 1,
    "ghezzi": 2,
    "ghidella": 3,
    "ghio": 2,
    "ghitis": 2,
    "ghitis(1)": 2,
    "gholamreza": 4,
    "gholson": 2,
    "gholston": 2,
    "ghorbanifar": 4,
    "ghorbanifar(1)": 4,
    "ghorbanifar(2)": 4,
    "ghorbanifar(3)": 4,
    "ghormley": 2,
    "ghose": 1,
    "ghosh": 1,
    "ghost": 1,
    "ghostbuster": 3,
    "ghostbusters": 3,
    "ghostlike": 2,
    "ghostly": 2,
    "ghosts": 1,
    "ghoul": 1,
    "ghoulish": 2,
    "ghoulishly": 3,
    "ghouls": 1,
    "ghrist": 1,
    "ghulam": 2,
    "ghuloum": 2,
    "gia's": 2,
    "giacalone": 4,
    "giacco": 2,
    "giacinta": 3,
    "giacobbe": 3,
    "giacomelli": 4,
    "giacometti": 4,
    "giacomini": 4,
    "giacomo": 3,
    "giaconda": 4,
    "giaconda's": 4,
    "giacone": 4,
    "giaimo": 2,
    "gialanella": 4,
    "giamatti": 4,
    "giambalvo": 3,
    "giambra": 2,
    "giambrone": 3,
    "giammalva": 4,
    "giammarco": 3,
    "giammarino": 4,
    "giampa": 2,
    "giampaolo": 3,
    "giampapa": 3,
    "giampietro": 3,
    "gian": 2,
    "giancana": 4,
    "giancarlo": 4,
    "giancola": 3,
    "gianelli": 3,
    "gianfrancesco": 4,
    "gianfranco": 3,
    "gianfranco(1)": 4,
    "giang": 2,
    "giang(1)": 1,
    "giangrande": 3,
    "gianini": 3,
    "gianino": 3,
    "giannattasio": 5,
    "giannelli": 3,
    "giannetti": 3,
    "giannetto": 3,
    "gianni": 2,
    "gianni(1)": 3,
    "gianni(2)": 2,
    "giannini": 3,
    "giannino": 4,
    "giannola": 3,
    "giannone": 3,
    "giannotti": 3,
    "gianotti": 3,
    "giant": 2,
    "giant's": 2,
    "giants": 2,
    "giants'": 2,
    "giap": 2,
    "giap(1)": 1,
    "giaquinto": 3,
    "giard": 2,
    "giard(1)": 1,
    "giardi": 3,
    "giardina": 3,
    "giardini": 3,
    "giardino": 3,
    "giarratano": 4,
    "giarrusso": 3,
    "gib": 1,
    "gibas": 2,
    "gibb": 1,
    "gibb's": 1,
    "gibbard": 2,
    "gibbens": 2,
    "gibberish": 3,
    "gibbins": 2,
    "gibble": 2,
    "gibbon": 2,
    "gibboney": 3,
    "gibbons": 2,
    "gibbs": 1,
    "gibbs's": 2,
    "gibby": 2,
    "gibe": 1,
    "gibeau": 2,
    "gibeault": 2,
    "giberson": 3,
    "gibert": 2,
    "gibes": 1,
    "gibian": 3,
    "gibian's": 3,
    "giblen": 2,
    "gibler": 3,
    "gibler(1)": 2,
    "giblet": 2,
    "giblin": 2,
    "gibney": 2,
    "giboney": 3,
    "gibraltar": 3,
    "gibran": 2,
    "gibson": 2,
    "gibson's": 2,
    "gibsons": 2,
    "gick": 1,
    "gidcumb": 2,
    "giddens": 2,
    "giddings": 2,
    "giddy": 2,
    "gidel": 2,
    "gideon": 3,
    "gidget": 2,
    "gidley": 2,
    "gidney": 2,
    "gidwitz": 2,
    "giebel": 2,
    "giebler": 3,
    "giebler(1)": 2,
    "gieck": 1,
    "giefer": 2,
    "gieger": 2,
    "giegerich": 3,
    "giel": 1,
    "gielgud": 2,
    "gielow": 2,
    "gienger": 2,
    "gienow": 2,
    "gier": 1,
    "giere": 1,
    "gierhart": 2,
    "gierke": 1,
    "gierman": 2,
    "giersch": 1,
    "gies": 1,
    "giesbrecht": 2,
    "giese": 1,
    "giesecke": 2,
    "gieseke": 2,
    "gieseler": 3,
    "gieselman": 3,
    "giesen": 2,
    "gieser": 2,
    "giesey": 2,
    "gieske": 1,
    "giesler": 3,
    "giesler(1)": 2,
    "giessen": 2,
    "gietzen": 2,
    "giff": 1,
    "giffard": 2,
    "giffen": 2,
    "gifferd": 2,
    "giffin": 2,
    "gifford": 2,
    "gifford's": 2,
    "giffords": 2,
    "giffy": 2,
    "gift": 1,
    "gift-horse": 2,
    "gifted": 2,
    "gifted(1)": 2,
    "gifting": 2,
    "giftrust": 2,
    "gifts": 1,
    "gifts(1)": 1,
    "giftware": 2,
    "gig": 1,
    "gigabyte": 3,
    "gigabytes": 3,
    "gigaflop": 3,
    "gigaflops": 3,
    "gigante": 3,
    "gigantic": 3,
    "gigantic(1)": 3,
    "giger": 2,
    "gigging": 2,
    "giggle": 2,
    "giggled": 2,
    "giggles": 2,
    "giggling": 3,
    "giggling(1)": 2,
    "giggly": 3,
    "gigi": 2,
    "giglia": 3,
    "giglio": 3,
    "gigliotti": 4,
    "gignac": 2,
    "gignoux": 2,
    "gigolo": 3,
    "gigot": 2,
    "gigot's": 2,
    "gigs": 1,
    "giguere": 3,
    "gikas": 2,
    "gil": 1,
    "gila": 2,
    "gilardi": 3,
    "gilb": 1,
    "gilberg": 2,
    "gilbert": 2,
    "gilbert's": 2,
    "gilberta": 3,
    "gilberte": 2,
    "gilberti": 3,
    "gilbertina": 4,
    "gilbertine": 4,
    "gilberto": 3,
    "gilberto(1)": 3,
    "gilbertson": 3,
    "gilbey": 2,
    "gilbo": 2,
    "gilboy": 2,
    "gilbreath": 2,
    "gilbreth": 2,
    "gilbride": 2,
    "gilby": 2,
    "gilchrest": 3,
    "gilchrist": 2,
    "gilcrease": 2,
    "gilcrest": 3,
    "gilcrest(1)": 2,
    "gild": 1,
    "gilda": 2,
    "gilday": 2,
    "gildea": 3,
    "gilded": 2,
    "gilden": 2,
    "gilder": 2,
    "gilder's": 2,
    "gildersleeve": 3,
    "gilding": 2,
    "gildner": 2,
    "gildon": 2,
    "gile": 1,
    "gilead": 2,
    "giles": 1,
    "gilfillan": 3,
    "gilford": 2,
    "gilger": 2,
    "gilgit": 2,
    "gilgore": 2,
    "gilham": 2,
    "gilhooly": 3,
    "gilkerson": 3,
    "gilkes": 1,
    "gilkeson": 3,
    "gilkey": 2,
    "gilkison": 3,
    "gilkisons": 3,
    "gill": 1,
    "gill's": 1,
    "gillam": 2,
    "gillan": 2,
    "gilland": 2,
    "gillard": 2,
    "gillaspie": 3,
    "gillaspy": 3,
    "gille": 1,
    "gillean": 2,
    "gilleland": 3,
    "gillem": 2,
    "gillen": 2,
    "gillen's": 2,
    "gillentine": 3,
    "giller": 2,
    "gilleran": 3,
    "gillers": 2,
    "gilles": 1,
    "gillespie": 3,
    "gillet": 2,
    "gillett": 2,
    "gillette": 2,
    "gillette's": 2,
    "gilley": 2,
    "gillham": 2,
    "gilliam": 3,
    "gillian": 3,
    "gilliand": 3,
    "gilliard": 3,
    "gilliardi": 3,
    "gilliatt": 3,
    "gillick": 2,
    "gillie": 2,
    "gillies": 2,
    "gillig": 2,
    "gilligan": 3,
    "gilligan's": 3,
    "gillihan": 3,
    "gillikin": 3,
    "gillilan": 3,
    "gilliland": 3,
    "gillin": 2,
    "gillingham": 3,
    "gillings": 2,
    "gillinov": 3,
    "gillins": 2,
    "gillis": 2,
    "gillison": 3,
    "gillispie": 3,
    "gillman": 2,
    "gillmore": 2,
    "gillock": 2,
    "gillogly": 3,
    "gillon": 2,
    "gillooly": 3,
    "gillooly's": 3,
    "gillott": 2,
    "gillotti": 3,
    "gills": 1,
    "gillson": 2,
    "gillum": 2,
    "gilly": 2,
    "gilman": 2,
    "gilmartin": 3,
    "gilmer": 2,
    "gilmore": 2,
    "gilmour": 2,
    "gilpatrick": 3,
    "gilpatrick(1)": 3,
    "gilpin": 2,
    "gilreath": 2,
    "gilroy": 2,
    "gilsdorf": 2,
    "gilson": 2,
    "gilstrap": 2,
    "gilt": 1,
    "giltner": 2,
    "gilts": 1,
    "gilvin": 2,
    "gilyard": 2,
    "gimbel": 2,
    "gimenez": 3,
    "gimlet": 2,
    "gimli": 2,
    "gimlin": 2,
    "gimme": 2,
    "gimmick": 2,
    "gimmickry": 3,
    "gimmicks": 2,
    "gimmicky": 3,
    "gimpel": 2,
    "gin": 1,
    "gina": 2,
    "gina's": 2,
    "ginandjar": 3,
    "ginas": 2,
    "ginder": 2,
    "gindin": 2,
    "gindlesperger": 4,
    "gines": 1,
    "ginevra": 3,
    "ging": 1,
    "gingell": 2,
    "ginger": 2,
    "gingerbread": 3,
    "gingerich": 3,
    "gingerly": 3,
    "gingery": 3,
    "gingham": 2,
    "ginghams": 2,
    "gingko": 2,
    "gingles": 2,
    "gingold": 2,
    "gingold(1)": 2,
    "gingras": 2,
    "gingrich": 2,
    "gingrich's": 3,
    "gingriches": 3,
    "ginley": 2,
    "ginn": 1,
    "ginned": 1,
    "ginnell": 2,
    "ginnie": 2,
    "ginning": 2,
    "ginny": 2,
    "gino": 2,
    "ginocchio": 4,
    "ginsberg": 2,
    "ginsburg": 2,
    "ginsburg's": 2,
    "ginseng": 2,
    "ginsu": 2,
    "ginsu's": 2,
    "gintel": 2,
    "ginter": 2,
    "ginther": 2,
    "ginting": 2,
    "ginty": 2,
    "gintz": 1,
    "ginyard": 2,
    "ginza": 2,
    "ginzberg": 2,
    "gioia": 2,
    "gionet": 3,
    "gionfriddo": 3,
    "giordani": 3,
    "giordano": 3,
    "giorgi": 2,
    "giorgia": 2,
    "giorgio": 3,
    "giovanelli": 4,
    "giovanetti": 4,
    "giovannetti": 4,
    "giovanni": 4,
    "giovanni(1)": 3,
    "giovanni's": 4,
    "giovanni's(1)": 3,
    "giovanniello": 5,
    "giovannini": 4,
    "giovannoni": 4,
    "giovenco": 3,
    "giovinazzo": 4,
    "gipe": 1,
    "gipp": 1,
    "gipper": 2,
    "gipple": 2,
    "gipson": 2,
    "giraffe": 2,
    "giraffes": 2,
    "giraldo": 3,
    "girard": 2,
    "girardi": 3,
    "girardin": 3,
    "girardot": 3,
    "giraud": 2,
    "gird": 1,
    "girder": 2,
    "girders": 2,
    "girding": 2,
    "girdle": 2,
    "girdler": 3,
    "girdler(1)": 2,
    "girdley": 2,
    "girdner": 2,
    "girds": 1,
    "gire": 1,
    "giren": 2,
    "giren(1)": 2,
    "girgenti": 3,
    "girgis": 2,
    "girija": 3,
    "girl": 1,
    "girl's": 1,
    "girlfriend": 2,
    "girlfriend's": 2,
    "girlfriends": 2,
    "girlhood": 2,
    "girlie": 2,
    "girlish": 2,
    "girlishly": 3,
    "girls": 1,
    "girls'": 1,
    "girobank": 3,
    "girod": 2,
    "giroir": 2,
    "girolamo": 4,
    "giroldi": 3,
    "giroldi's": 3,
    "giron": 2,
    "gironde": 2,
    "girouard": 3,
    "giroux": 2,
    "girozentrale": 4,
    "girsky": 2,
    "girt": 1,
    "girten": 2,
    "girth": 1,
    "girtman": 2,
    "girton": 2,
    "girvan": 2,
    "girven": 2,
    "girvin": 2,
    "gisbert": 2,
    "gisbert(1)": 2,
    "giscard": 2,
    "giscard(1)": 2,
    "gisclair": 2,
    "gisela": 3,
    "gisella": 3,
    "giselle": 2,
    "gisenyi": 3,
    "gisenyi(1)": 3,
    "gish": 1,
    "gish(1)": 1,
    "gisi": 2,
    "gisler": 3,
    "gisler(1)": 2,
    "gismondi": 3,
    "gissendanner": 4,
    "gissi": 2,
    "gist": 1,
    "gisu": 2,
    "gitana": 3,
    "gitano": 3,
    "gitano's": 3,
    "gitchell": 2,
    "githa": 2,
    "githens": 2,
    "gitlin": 2,
    "gittelman": 3,
    "gittens": 2,
    "gitter": 2,
    "gittings": 2,
    "gittins": 2,
    "gittis": 2,
    "gittis(1)": 2,
    "gittleman": 3,
    "gittleman's": 3,
    "gittler": 2,
    "gitto": 2,
    "giudice": 3,
    "giudici": 3,
    "giuffre": 2,
    "giuffre's": 2,
    "giuffrida": 3,
    "giuliani": 4,
    "giuliani's": 4,
    "giuliano": 4,
    "giulio": 3,
    "giunta": 2,
    "giurescu": 3,
    "giuseppe": 3,
    "giusti": 2,
    "giusto": 2,
    "givan": 2,
    "give": 1,
    "giveaway": 3,
    "giveaways": 3,
    "giveback": 2,
    "givebacks": 2,
    "given": 2,
    "given(1)": 2,
    "givenchy": 3,
    "givenness": 3,
    "givens": 2,
    "givens's": 3,
    "giver": 2,
    "givers": 2,
    "gives": 1,
    "giveth": 2,
    "givhan": 2,
    "givin'": 2,
    "giving": 2,
    "givins": 2,
    "givler": 2,
    "giza": 2,
    "giza(1)": 2,
    "gizbert": 2,
    "gizbert's": 2,
    "gizmo": 2,
    "gizmos": 2,
    "gizzard": 2,
    "gizzi": 2,
    "gjelten": 2,
    "gjelten's": 2,
    "gjerde": 1,
    "glaab": 1,
    "glab": 1,
    "glace": 1,
    "glacial": 2,
    "glaciate": 3,
    "glaciate(1)": 3,
    "glaciated": 4,
    "glaciated(1)": 4,
    "glaciation": 4,
    "glacier": 2,
    "glacier's": 2,
    "glaciers": 2,
    "glacis": 2,
    "glacken": 2,
    "glackin": 2,
    "glad": 1,
    "gladd": 1,
    "gladden": 2,
    "gladding": 2,
    "gladdock": 2,
    "glade": 1,
    "glades": 1,
    "gladfelter": 3,
    "gladhill": 2,
    "gladiator": 4,
    "gladiators": 4,
    "gladieux": 3,
    "gladiolus": 4,
    "gladis": 2,
    "gladish": 2,
    "gladje": 2,
    "gladly": 2,
    "gladman": 2,
    "gladney": 2,
    "gladson": 2,
    "gladstein": 2,
    "gladstein(1)": 2,
    "gladstone": 2,
    "gladstones": 2,
    "gladu": 2,
    "gladwell": 2,
    "gladwin": 2,
    "gladys": 2,
    "gladys'": 2,
    "glaeser": 2,
    "glahn": 1,
    "glamor": 2,
    "glamorize": 3,
    "glamorized": 3,
    "glamorizing": 4,
    "glamorous": 3,
    "glamour": 2,
    "glance": 1,
    "glanced": 1,
    "glances": 2,
    "glancing": 2,
    "glancy": 2,
    "gland": 1,
    "glander": 2,
    "glandon": 2,
    "glands": 1,
    "glandular": 3,
    "glanton": 2,
    "glantz": 1,
    "glanville": 2,
    "glanz": 1,
    "glanzer": 2,
    "glanzman": 2,
    "glare": 1,
    "glared": 1,
    "glares": 1,
    "glaring": 2,
    "glaris": 2,
    "glas": 1,
    "glasby": 2,
    "glasco": 2,
    "glascock": 2,
    "glascoe": 2,
    "glaser": 2,
    "glasgow": 2,
    "glasgow(1)": 2,
    "glasheen": 2,
    "glashow": 2,
    "glasner": 2,
    "glasnost": 2,
    "glasnost(1)": 2,
    "glasnost(2)": 2,
    "glasow": 2,
    "glasper": 2,
    "glaspie": 2,
    "glaspy": 2,
    "glass": 1,
    "glass's": 2,
    "glassberg": 2,
    "glassblower": 3,
    "glassblowers": 3,
    "glassblowing": 3,
    "glassburn": 2,
    "glassco": 2,
    "glasscock": 2,
    "glassed": 1,
    "glasser": 2,
    "glasses": 2,
    "glasses(1)": 2,
    "glassey": 2,
    "glassford": 2,
    "glasslike": 2,
    "glassmaker": 3,
    "glassmaking": 3,
    "glassman": 2,
    "glassman(1)": 2,
    "glassmeyer": 3,
    "glassner": 2,
    "glasson": 2,
    "glassware": 2,
    "glassy": 2,
    "glastetter": 3,
    "glatfelter": 3,
    "glatt": 1,
    "glatz": 1,
    "glatzer": 2,
    "glaub": 1,
    "glauber": 2,
    "glaucoma": 3,
    "glaude": 1,
    "glaus": 1,
    "glauser": 2,
    "glavan": 2,
    "glavin": 2,
    "glavine": 2,
    "glavine(1)": 2,
    "glawe": 1,
    "glaxo": 2,
    "glaxo's": 2,
    "glaza": 2,
    "glaze": 1,
    "glazebrook": 2,
    "glazed": 1,
    "glazener": 3,
    "glazer": 2,
    "glazes": 2,
    "glazes(1)": 2,
    "glazier": 3,
    "glazing": 2,
    "glazner": 2,
    "glazunov": 3,
    "gleacher": 2,
    "gleam": 1,
    "gleamed": 1,
    "gleaming": 2,
    "gleams": 1,
    "glean": 1,
    "gleaned": 1,
    "gleason": 2,
    "gleason's": 2,
    "gleaton": 2,
    "gleave": 1,
    "gleaves": 1,
    "gleba": 2,
    "gleckler": 2,
    "gleda": 2,
    "gledhill": 2,
    "glee": 1,
    "gleeful": 2,
    "gleefully": 3,
    "gleeson": 2,
    "gleghorn": 2,
    "gleich": 1,
    "gleichauf": 2,
    "gleim": 1,
    "gleisner": 2,
    "glemp": 1,
    "glen": 1,
    "glenayre": 2,
    "glenayre(1)": 2,
    "glenbrook": 2,
    "glenda": 2,
    "glendale": 2,
    "glendening": 3,
    "glendenning": 3,
    "glendinning": 3,
    "glendon": 2,
    "glenfed": 2,
    "glenfed's": 2,
    "glengarry": 3,
    "glenham": 2,
    "glenham(1)": 2,
    "glenmore": 2,
    "glenn": 1,
    "glenn's": 1,
    "glenna": 2,
    "glennie": 2,
    "glennon": 2,
    "glenny": 2,
    "glenora": 3,
    "glens": 1,
    "glenview": 2,
    "glenville": 2,
    "glenwood": 2,
    "glenwood's": 2,
    "gless": 1,
    "glessner": 2,
    "glew": 1,
    "glib": 1,
    "glibly": 2,
    "glick": 1,
    "glickenhaus": 3,
    "glickman": 2,
    "glickman's": 2,
    "glicksman": 2,
    "glickstein": 2,
    "glickstein(1)": 2,
    "glidden": 2,
    "glide": 1,
    "glided": 2,
    "glider": 2,
    "gliders": 2,
    "glides": 1,
    "glidewell": 2,
    "gliding": 2,
    "glimcher": 2,
    "glimmer": 2,
    "glimmering": 3,
    "glimmers": 2,
    "glimpse": 1,
    "glimpsed": 1,
    "glimpses": 2,
    "glines": 1,
    "glinka": 2,
    "glinski": 2,
    "glint": 1,
    "glinting": 2,
    "glissandi": 3,
    "glisson": 2,
    "glisten": 2,
    "glistened": 2,
    "glistening": 3,
    "glistening(1)": 2,
    "glitch": 1,
    "glitches": 2,
    "glitter": 2,
    "glittered": 2,
    "glittering": 3,
    "glitters": 2,
    "glittery": 3,
    "glitz": 1,
    "glitzy": 2,
    "glo": 1,
    "gloam": 1,
    "gloaming": 2,
    "gloat": 1,
    "gloated": 2,
    "gloating": 2,
    "gloats": 1,
    "glob": 1,
    "global": 2,
    "global's": 2,
    "globalization": 5,
    "globalize": 3,
    "globalized": 3,
    "globally": 3,
    "globalstar": 3,
    "globcom": 2,
    "globe": 1,
    "globe's": 1,
    "globes": 1,
    "globetrotter": 3,
    "globetrotters": 3,
    "globex": 2,
    "globo": 2,
    "globs": 1,
    "globular": 3,
    "globulin": 3,
    "globulins": 3,
    "globus": 2,
    "glocester": 2,
    "glock": 1,
    "glockenspiel": 3,
    "glockner": 2,
    "glod": 1,
    "glodowski": 3,
    "gloe": 1,
    "gloeckner": 2,
    "gloede": 1,
    "glogowski": 3,
    "glomar": 2,
    "glomb": 1,
    "glomski": 2,
    "glonass": 2,
    "gloom": 1,
    "gloomier": 3,
    "gloomily": 3,
    "gloomy": 2,
    "gloor": 1,
    "glop": 1,
    "gloppy": 2,
    "glor": 1,
    "glore": 1,
    "glori": 2,
    "gloria": 3,
    "gloriana": 4,
    "gloriane": 3,
    "glories": 2,
    "glorification": 5,
    "glorification(1)": 5,
    "glorified": 3,
    "glorifies": 3,
    "glorify": 3,
    "glorifying": 4,
    "glorioso": 4,
    "glorious": 3,
    "gloriously": 4,
    "glory": 2,
    "gloss": 1,
    "glossary": 3,
    "glossed": 1,
    "glosser": 2,
    "glosses": 2,
    "glossier": 3,
    "glossman": 2,
    "glosson": 2,
    "glossy": 2,
    "gloster": 2,
    "glotfelty": 3,
    "glottal": 2,
    "glottis": 2,
    "glotzbach": 2,
    "gloucester": 2,
    "glove": 1,
    "gloved": 1,
    "glover": 2,
    "gloves": 1,
    "glow": 1,
    "glowacki": 3,
    "glowed": 1,
    "glower": 2,
    "glowered": 2,
    "glowering": 3,
    "glowing": 2,
    "glowingly": 3,
    "glows": 1,
    "gloyd": 1,
    "gluck": 1,
    "gluck's": 1,
    "gluckman": 2,
    "glucksman": 2,
    "glucosamate": 4,
    "glucosamine": 4,
    "glucose": 2,
    "glucoside": 3,
    "glucosides": 3,
    "glue": 1,
    "glueck": 1,
    "glued": 1,
    "glues": 1,
    "glum": 1,
    "glumly": 2,
    "glummer": 2,
    "glunt": 1,
    "gluntz": 1,
    "glunz": 1,
    "gluskin": 2,
    "glut": 1,
    "glutamate": 3,
    "glutamic": 3,
    "glutaric": 3,
    "gluten": 2,
    "gluth": 1,
    "gluts": 1,
    "glutted": 2,
    "gluttonous": 3,
    "gluttons": 2,
    "gluttony": 3,
    "glycel": 2,
    "glycemic": 3,
    "glycerol": 3,
    "glycine": 2,
    "glycine(1)": 2,
    "glycogen": 3,
    "glycol": 2,
    "glycol(1)": 2,
    "glycolic": 3,
    "glycomed": 2,
    "glycomed(1)": 3,
    "glycoside": 3,
    "glymph": 1,
    "glyn": 1,
    "glyndebourne": 2,
    "glynis": 2,
    "glynn": 1,
    "glynnie": 2,
    "glynnis": 2,
    "gmbh": 1,
    "gmbh(1)": 4,
    "gnagey": 2,
    "gnaizda": 2,
    "gnann": 1,
    "gnarl": 1,
    "gnarle": 1,
    "gnarled": 1,
    "gnarling": 2,
    "gnarls": 1,
    "gnarly": 2,
    "gnash": 1,
    "gnashing": 2,
    "gnat": 1,
    "gnatcatcher": 3,
    "gnatcatchers": 3,
    "gnats": 1,
    "gnau": 1,
    "gnaw": 1,
    "gnawed": 1,
    "gnawing": 2,
    "gnaws": 1,
    "gnc": 3,
    "gneiss": 1,
    "gnocchi": 2,
    "gnome": 1,
    "gnomes": 1,
    "gnomic": 2,
    "gnomonic": 3,
    "gnosticism": 4,
    "gnu": 1,
    "go": 1,
    "go-cart": 2,
    "goa": 2,
    "goad": 1,
    "goaded": 2,
    "goading": 2,
    "goal": 1,
    "goalie": 2,
    "goalkeeper": 3,
    "goalpost": 2,
    "goals": 1,
    "goan": 1,
    "goans": 1,
    "goar": 1,
    "goard": 1,
    "goat": 1,
    "goat's": 1,
    "goatee": 2,
    "goates": 2,
    "goatley": 2,
    "goats": 1,
    "gob": 1,
    "gobain": 2,
    "gobble": 2,
    "gobbled": 2,
    "gobbledygook": 4,
    "gobbler": 3,
    "gobbler(1)": 2,
    "gobblers": 3,
    "gobblers(1)": 2,
    "gobbles": 2,
    "gobbling": 3,
    "gobbling(1)": 2,
    "gobel": 2,
    "goben": 2,
    "gober": 2,
    "goberstein": 3,
    "goberstein(1)": 3,
    "gobert": 2,
    "gobi": 2,
    "gobie": 2,
    "gobin": 2,
    "gobinot": 3,
    "gobioff": 3,
    "goble": 2,
    "goblet": 2,
    "goblin": 2,
    "goblins": 2,
    "goblirsch": 2,
    "gobs": 1,
    "gochenour": 3,
    "gochnauer": 3,
    "gochnour": 2,
    "gocke": 1,
    "gockel": 2,
    "gockley": 2,
    "god": 1,
    "god's": 1,
    "goda": 2,
    "godar": 2,
    "godard": 2,
    "godart": 2,
    "godbee": 2,
    "godbey": 2,
    "godbold": 2,
    "godbolt": 2,
    "godbout": 2,
    "godby": 2,
    "goddam": 2,
    "goddamn": 2,
    "goddard": 2,
    "goddart": 2,
    "goddeau": 2,
    "godden": 2,
    "goddess": 2,
    "goddesses": 3,
    "godding": 2,
    "godek": 2,
    "godette": 2,
    "godfather": 3,
    "godfather's": 3,
    "godfathers": 3,
    "godfrey": 2,
    "godfrey's": 2,
    "godhead": 2,
    "godin": 2,
    "godina": 3,
    "godine": 2,
    "godines": 2,
    "godinez": 3,
    "goding": 2,
    "godino": 3,
    "godiva": 3,
    "godkin": 2,
    "godleski": 3,
    "godless": 2,
    "godlewski": 3,
    "godley": 2,
    "godlove": 2,
    "godly": 2,
    "godman": 2,
    "godmother": 3,
    "godmothers": 3,
    "godot": 2,
    "godot's": 2,
    "godown": 2,
    "godoy": 2,
    "godrej": 2,
    "gods": 1,
    "godsell": 2,
    "godsend": 2,
    "godsends": 2,
    "godsey": 2,
    "godshalk": 2,
    "godshall": 2,
    "godspeed": 2,
    "godspell": 2,
    "godunov": 3,
    "godwin": 2,
    "godzilla": 3,
    "goe": 1,
    "goeas": 3,
    "goeas(1)": 2,
    "goebbels": 2,
    "goebel": 2,
    "goecke": 1,
    "goedde": 1,
    "goede": 1,
    "goedecke": 2,
    "goeden": 2,
    "goedert": 2,
    "goedken": 2,
    "goeglein": 2,
    "goehner": 2,
    "goehring": 2,
    "goeke": 1,
    "goeken": 2,
    "goeller": 2,
    "goellner": 2,
    "goelz": 1,
    "goelzer": 2,
    "goeman": 2,
    "goemon": 3,
    "goen": 1,
    "goens": 1,
    "goepfert": 2,
    "goer": 2,
    "goergen": 2,
    "goering": 3,
    "goerke": 1,
    "goerlitz": 2,
    "goerner": 2,
    "goers": 2,
    "goertz": 1,
    "goertzen": 2,
    "goes": 1,
    "goeser": 2,
    "goetabanken": 4,
    "goethals": 2,
    "goethe": 1,
    "goetsch": 1,
    "goette": 1,
    "goettel": 2,
    "goetting": 2,
    "goettl": 2,
    "goettsch": 1,
    "goetz": 1,
    "goetze": 1,
    "goetzinger": 3,
    "goetzke": 2,
    "goetzman": 2,
    "goewey": 3,
    "goff": 1,
    "goffin": 2,
    "goffinet": 3,
    "goffman": 2,
    "goffman's": 2,
    "goffney": 2,
    "goffredo": 3,
    "goforth": 2,
    "goga": 2,
    "gogan": 2,
    "gogel": 2,
    "goggans": 2,
    "goggin": 2,
    "goggins": 2,
    "goggle": 2,
    "goggles": 2,
    "gogh": 1,
    "goghs": 1,
    "goglia": 3,
    "gogo": 2,
    "goguen": 2,
    "goh": 1,
    "goheen": 2,
    "gohl": 1,
    "gohlke": 1,
    "gohlke(1)": 1,
    "gohman": 2,
    "gohn": 1,
    "gohr": 1,
    "goin": 1,
    "goin'": 2,
    "goines": 1,
    "going": 2,
    "going(1)": 2,
    "goings": 2,
    "goings-on": 3,
    "goings-ons": 3,
    "goins": 1,
    "goiter": 2,
    "goizueta": 3,
    "gokey": 2,
    "goksel": 2,
    "gola": 2,
    "golab": 2,
    "golan": 2,
    "golan(1)": 2,
    "goland": 2,
    "golas": 2,
    "golaszewski": 4,
    "golay": 2,
    "golba": 2,
    "golberg": 2,
    "golconda": 3,
    "gold": 1,
    "gold's": 1,
    "golda": 2,
    "goldade": 2,
    "goldammer": 3,
    "goldbach": 2,
    "goldbaum": 2,
    "goldbeck": 2,
    "goldberg": 2,
    "goldberg's": 2,
    "goldberger": 3,
    "goldblatt": 2,
    "goldblum": 2,
    "goldcor": 2,
    "goldcreek": 2,
    "goldcrest": 2,
    "golde": 1,
    "golden": 2,
    "golden's": 2,
    "goldenberg": 3,
    "goldeneye": 3,
    "goldenrod": 3,
    "goldenson": 3,
    "goldenson's": 3,
    "goldenstein": 3,
    "goldenstein(1)": 3,
    "goldenthal": 3,
    "goldenthal's": 3,
    "golder": 2,
    "goldest": 2,
    "goldey": 2,
    "goldfarb": 2,
    "goldfeder": 3,
    "goldfield": 2,
    "goldfields": 2,
    "goldfinch": 2,
    "goldfinches": 3,
    "goldfine": 2,
    "goldfinger": 3,
    "goldfish": 2,
    "goldfus": 2,
    "goldhammer": 3,
    "goldie": 2,
    "goldilocks": 3,
    "goldin": 2,
    "golding": 2,
    "goldinger": 3,
    "goldman": 2,
    "goldman's": 2,
    "goldmann": 2,
    "goldmans": 2,
    "goldmark": 2,
    "goldmine": 2,
    "goldner": 2,
    "goldome": 2,
    "goldress": 2,
    "goldrick": 2,
    "goldring": 2,
    "golds": 1,
    "goldsberry": 3,
    "goldsborough": 3,
    "goldsby": 2,
    "goldschmid": 2,
    "goldschmidt": 2,
    "goldsmith": 2,
    "goldsmith's": 2,
    "goldson": 2,
    "goldstar": 2,
    "goldstein": 2,
    "goldstein(1)": 2,
    "goldstein's": 2,
    "goldstein's(1)": 2,
    "goldstock": 2,
    "goldston": 2,
    "goldstone": 2,
    "goldstrike": 2,
    "goldsworthy": 3,
    "goldthwaite": 2,
    "goldwasser": 3,
    "goldwater": 3,
    "goldwater's": 3,
    "goldwin": 2,
    "goldwire": 2,
    "goldwyn": 2,
    "goldy": 2,
    "golec": 2,
    "golem": 2,
    "goleman": 2,
    "golembeski": 4,
    "golembiewski": 5,
    "golen": 2,
    "goley": 2,
    "golf": 1,
    "golf(1)": 1,
    "golf's": 1,
    "golfarb": 2,
    "golfed": 1,
    "golfer": 2,
    "golfer's": 2,
    "golfers": 2,
    "golfie": 2,
    "golfing": 2,
    "golfing(1)": 2,
    "golfman": 2,
    "golfs": 1,
    "golgi": 2,
    "golgo": 2,
    "goliath": 3,
    "goliaths": 3,
    "golightly": 3,
    "golinski": 3,
    "golisano": 4,
    "golkar": 2,
    "goll": 1,
    "golla": 2,
    "golladay": 3,
    "golle": 1,
    "goller": 2,
    "golliday": 3,
    "golliher": 3,
    "gollnick": 2,
    "gollum": 2,
    "gollust": 2,
    "golly": 2,
    "golob": 2,
    "golomb": 2,
    "golombek": 3,
    "golonka": 3,
    "goloven": 3,
    "golphin": 2,
    "golson": 2,
    "golston": 2,
    "goltz": 1,
    "golub": 2,
    "golubski": 3,
    "golz": 1,
    "goma": 2,
    "gombar": 2,
    "gomberg": 2,
    "gombert": 2,
    "gombos": 2,
    "gomer": 2,
    "gomery": 3,
    "gomes": 2,
    "gomez": 2,
    "gomillion": 3,
    "gomoll": 2,
    "gomorrah": 3,
    "gomory": 3,
    "gonad": 2,
    "gonads": 2,
    "gonaives": 2,
    "goncalves": 3,
    "gonce": 1,
    "goncharov": 3,
    "gond": 1,
    "gonda": 2,
    "gondek": 2,
    "gonder": 2,
    "gondola": 3,
    "gondola(1)": 3,
    "gondolas": 3,
    "gondolas(1)": 3,
    "gondolier": 3,
    "gondoliers": 3,
    "gondwana": 3,
    "gondwanaland": 4,
    "gone": 1,
    "goner": 2,
    "gonet": 2,
    "gong": 1,
    "gongaware": 3,
    "gongora": 3,
    "gongs": 1,
    "gonia": 3,
    "goniometer": 5,
    "gonium": 3,
    "gonna": 2,
    "gonnella": 3,
    "gonnerman": 3,
    "gonococcal": 4,
    "gonorrhea": 4,
    "gonsales": 2,
    "gonsalez": 3,
    "gonsalves": 3,
    "gonser": 2,
    "gonsoulin": 3,
    "gonterman": 3,
    "gonya": 2,
    "gonyea": 2,
    "gonyer": 2,
    "gonyo": 2,
    "gonzales": 3,
    "gonzalez": 3,
    "gonzalez's": 4,
    "gonzalo": 3,
    "gonzo": 2,
    "gonzo's": 2,
    "goo": 1,
    "gooch": 1,
    "good": 1,
    "good(1)": 1,
    "good's": 1,
    "good-bye": 2,
    "good-bye(1)": 2,
    "good-heartedly": 4,
    "good-naturedly": 4,
    "gooda": 2,
    "gooda(1)": 2,
    "goodale": 2,
    "goodall": 2,
    "goodbar": 2,
    "goodbread": 2,
    "goodby": 2,
    "goodbye": 2,
    "goodbyes": 2,
    "goodbyes(1)": 2,
    "goodchild": 2,
    "goode": 1,
    "goodell": 2,
    "gooden": 2,
    "gooden's": 2,
    "goodenough": 3,
    "goodenow": 3,
    "gooder": 2,
    "gooderham": 3,
    "gooders": 2,
    "goodfella": 3,
    "goodfellas": 3,
    "goodfellow": 3,
    "goodfellows": 3,
    "goodfriend": 2,
    "goodfriends": 2,
    "goodgame": 2,
    "goodhart": 2,
    "goodheart": 2,
    "goodhue": 2,
    "goodie": 2,
    "goodies": 2,
    "goodin": 2,
    "goodine": 2,
    "gooding": 2,
    "gooding's": 2,
    "goodison": 3,
    "goodkin": 2,
    "goodland": 2,
    "goodland(1)": 2,
    "goodlet": 2,
    "goodlett": 2,
    "goodley": 2,
    "goodlin": 2,
    "goodling": 2,
    "goodloe": 2,
    "goodlow": 2,
    "goodly": 2,
    "goodman": 2,
    "goodman's": 2,
    "goodmorning": 3,
    "goodner": 2,
    "goodness": 2,
    "goodness(1)": 2,
    "goodnight": 2,
    "goodnights": 2,
    "goodnough": 2,
    "goodnow": 2,
    "goodpaster": 3,
    "goodpasture": 3,
    "goodreau": 2,
    "goodrich": 2,
    "goodrich's": 3,
    "goodrick": 2,
    "goodridge": 2,
    "goodroe": 2,
    "goodrow": 2,
    "goodrum": 2,
    "goods": 1,
    "goodsell": 2,
    "goodson": 2,
    "goodson's": 2,
    "goodspeed": 2,
    "goodspeed's": 2,
    "goodstein": 2,
    "goodstein(1)": 2,
    "goodtab": 2,
    "goodwill": 2,
    "goodwin": 2,
    "goodwine": 2,
    "goodwyn": 2,
    "goody": 2,
    "goody's": 2,
    "goodyear": 2,
    "goodyear(1)": 2,
    "goodyear's": 2,
    "gooey": 2,
    "goof": 1,
    "goofed": 1,
    "goofing": 2,
    "goofs": 1,
    "goofy": 2,
    "googe": 1,
    "googin": 2,
    "googins": 2,
    "google": 2,
    "googleverse": 3,
    "gook": 1,
    "gookin": 2,
    "goold": 1,
    "gooley": 2,
    "goolsby": 2,
    "goon": 1,
    "goonan": 2,
    "goons": 1,
    "goop": 1,
    "goos": 1,
    "goosby": 2,
    "goose": 1,
    "gooseberries": 3,
    "gooseberry": 3,
    "goosefish": 2,
    "goosefoot": 2,
    "goosen": 2,
    "goosey": 2,
    "goossen": 2,
    "goossens": 2,
    "goostree": 2,
    "gootee": 2,
    "gopac": 2,
    "gopac's": 2,
    "gopal": 2,
    "gopher": 2,
    "gophers": 2,
    "gopi": 2,
    "gopinath": 3,
    "gora": 2,
    "goracke": 2,
    "goradze": 3,
    "goral": 2,
    "goralski": 3,
    "goran": 2,
    "goranson": 3,
    "gorazde": 3,
    "gorazde(1)": 3,
    "gorazde's": 3,
    "gorazde's(1)": 3,
    "gorbachev": 3,
    "gorbachev(1)": 3,
    "gorbachev's": 3,
    "gorbachev's(1)": 3,
    "gorbachevs": 3,
    "gorbachevs(1)": 3,
    "gorby": 2,
    "gorczyca": 3,
    "gorczynski": 3,
    "gorda": 2,
    "gordan": 2,
    "gordana": 3,
    "gorden": 2,
    "gorder": 2,
    "gordeyev": 3,
    "gordian": 3,
    "gordie": 2,
    "gordillo": 3,
    "gordin": 2,
    "gordinier": 4,
    "gordji": 2,
    "gordner": 2,
    "gordon": 2,
    "gordon's": 2,
    "gordy": 2,
    "gordy's": 2,
    "gore": 1,
    "gore's": 1,
    "gorecki": 3,
    "gored": 1,
    "goree": 2,
    "gorelick": 3,
    "goren": 2,
    "gorenflo": 3,
    "gores": 1,
    "gorey": 2,
    "gorgas": 2,
    "gorge": 1,
    "gorgeous": 2,
    "gorges": 2,
    "gorges(1)": 2,
    "gorgets": 2,
    "gorgon": 2,
    "gorgone": 2,
    "gorgonian": 4,
    "gorgons": 2,
    "gorguze": 2,
    "gorham": 2,
    "gori": 2,
    "goria": 3,
    "gorilla": 3,
    "gorillas": 3,
    "gorin": 2,
    "goring": 2,
    "goris": 2,
    "gorka": 2,
    "gorki": 2,
    "gorky": 2,
    "gorky's": 2,
    "gorley": 2,
    "gorman": 2,
    "gormley": 2,
    "gormly": 2,
    "gorney": 2,
    "gorniak": 3,
    "gornick": 2,
    "gornik": 2,
    "gornto": 2,
    "gorny": 2,
    "gorospe": 3,
    "gorr": 1,
    "gorrell": 2,
    "gorriak": 3,
    "gorrid": 2,
    "gorrids": 2,
    "gorski": 2,
    "gorsky": 2,
    "gorsline": 2,
    "gorsuch": 2,
    "gort": 1,
    "gortari": 3,
    "gorter": 2,
    "gortney": 2,
    "gorton": 2,
    "gorum": 2,
    "gory": 2,
    "gosa": 2,
    "gosbank": 2,
    "gosch": 1,
    "gosdin": 2,
    "gose": 1,
    "gosh": 1,
    "gosha": 2,
    "goshawk": 2,
    "goshen": 2,
    "goshorn": 2,
    "goslee": 2,
    "goslin": 2,
    "gosline": 2,
    "gosman": 2,
    "gosnell": 2,
    "gosney": 2,
    "gosornstem": 3,
    "gospel": 2,
    "gospel(1)": 2,
    "gospels": 2,
    "gosplan": 2,
    "goss": 1,
    "gossage": 2,
    "gossamer": 3,
    "gossard": 2,
    "gosse": 1,
    "gosselin": 3,
    "gossen": 2,
    "gosser": 2,
    "gossett": 2,
    "gossip": 2,
    "gossiper": 3,
    "gossipers": 3,
    "gossiping": 3,
    "gossips": 2,
    "gossipy": 3,
    "gossman": 2,
    "gostev": 2,
    "gostomski": 3,
    "goswick": 2,
    "got": 1,
    "gotaas": 2,
    "gotbaum": 2,
    "gotbaum(1)": 2,
    "gotch": 1,
    "gotcha": 2,
    "gotcher": 2,
    "goth": 1,
    "gotham": 2,
    "gothard": 2,
    "gothenburg": 3,
    "gothenburg(1)": 3,
    "gothic": 2,
    "gotlieb": 2,
    "goto": 2,
    "goto(1)": 2,
    "gotsch": 1,
    "gotschal": 2,
    "gotschall": 2,
    "gotshal": 2,
    "gotshal's": 2,
    "gotshall": 2,
    "gott": 1,
    "gotta": 2,
    "gotten": 2,
    "gotten(1)": 2,
    "gotterdammerung": 5,
    "gottesman": 2,
    "gottfried": 2,
    "gotthardt": 2,
    "gotthelf": 2,
    "gotti": 2,
    "gottis": 2,
    "gottis(1)": 2,
    "gottlieb": 2,
    "gottlieb's": 2,
    "gottman": 2,
    "gotts": 1,
    "gottsch": 1,
    "gottschalk": 2,
    "gottschalks": 2,
    "gottschall": 2,
    "gottshall": 2,
    "gottwald": 2,
    "gotwalt": 2,
    "gotz": 1,
    "goucher": 2,
    "goude": 1,
    "goudeau": 2,
    "goudie": 2,
    "goudreau": 2,
    "goudy": 2,
    "gouge": 1,
    "gouged": 1,
    "gougeon": 2,
    "gouger": 2,
    "gough": 1,
    "goughnour": 2,
    "gouging": 2,
    "gouin": 1,
    "gouker": 2,
    "goulart": 2,
    "goulash": 2,
    "gould": 1,
    "gould's": 1,
    "goulden": 2,
    "goulding": 2,
    "goulet": 2,
    "goulette": 2,
    "goulston": 2,
    "gounod": 2,
    "goupil": 2,
    "gourd": 1,
    "gourdine": 2,
    "gourds": 1,
    "gourlay": 2,
    "gourley": 2,
    "gourment": 2,
    "gourmet": 2,
    "gourmets": 2,
    "gousha": 2,
    "gout": 1,
    "goutal": 2,
    "gouty": 2,
    "gouvea": 3,
    "gouveia": 4,
    "gov": 1,
    "gov(1)": 3,
    "govan": 2,
    "gove": 1,
    "govea": 3,
    "gover": 2,
    "govern": 2,
    "governale": 3,
    "governance": 3,
    "governed": 2,
    "governess": 3,
    "governing": 3,
    "government": 3,
    "government(1)": 3,
    "government's": 3,
    "government's(1)": 3,
    "governmental": 4,
    "governmental(1)": 4,
    "governmentally": 5,
    "governmentally(1)": 5,
    "governments": 3,
    "governments(1)": 3,
    "governments'": 3,
    "governments'(1)": 3,
    "governor": 3,
    "governor's": 3,
    "governors": 3,
    "governors'": 3,
    "governorship": 4,
    "governorships": 4,
    "governs": 2,
    "govett": 2,
    "govier": 3,
    "govoni": 3,
    "govpx": 3,
    "govs": 1,
    "govs(1)": 3,
    "gow": 1,
    "gowan": 2,
    "gowans": 2,
    "goward": 2,
    "gowdy": 2,
    "gowell": 2,
    "gowen": 2,
    "gowens": 2,
    "gower": 2,
    "gowin": 2,
    "gowing": 2,
    "gowins": 2,
    "gown": 1,
    "gowns": 1,
    "goy": 1,
    "goya": 2,
    "goya's": 2,
    "goyer": 2,
    "goyette": 2,
    "goyim": 2,
    "goyko": 2,
    "goyne": 1,
    "goynes": 1,
    "goza": 2,
    "gozo": 2,
    "gozo's": 2,
    "gozofsky": 3,
    "grab": 1,
    "grabau": 2,
    "grabbe": 1,
    "grabbed": 1,
    "grabber": 2,
    "grabbers": 2,
    "grabbing": 2,
    "grabe": 1,
    "grabel": 2,
    "graben": 2,
    "grabens": 2,
    "grabenstein": 3,
    "grabenstein(1)": 3,
    "graber": 2,
    "grabert": 2,
    "grabill": 2,
    "grabinski": 3,
    "grable": 2,
    "grabner": 2,
    "graboski": 3,
    "grabow": 2,
    "grabowski": 3,
    "graboy": 2,
    "grabs": 1,
    "grabski": 2,
    "grace": 1,
    "grace's": 2,
    "graced": 1,
    "graceffa": 3,
    "graceful": 2,
    "gracefully": 3,
    "graceland": 2,
    "graceless": 2,
    "graces": 2,
    "gracey": 2,
    "grachev": 2,
    "grachev's": 2,
    "grachov": 2,
    "graci": 2,
    "gracia": 2,
    "graciano": 4,
    "gracie": 2,
    "gracile": 2,
    "gracing": 2,
    "gracious": 2,
    "graciously": 3,
    "graciousness": 3,
    "grackle": 2,
    "grackles": 2,
    "graco": 2,
    "gracy": 2,
    "graczyk": 2,
    "grad": 1,
    "gradate": 2,
    "gradation": 3,
    "gradations": 3,
    "gradchev": 2,
    "gradchev(1)": 2,
    "gradco": 2,
    "graddy": 2,
    "grade": 1,
    "graded": 2,
    "graded(1)": 2,
    "gradel": 2,
    "graden": 2,
    "grader": 2,
    "graders": 2,
    "grades": 1,
    "gradient": 3,
    "gradients": 3,
    "grading": 2,
    "gradison": 3,
    "gradney": 2,
    "grado": 2,
    "gradov": 2,
    "gradovs": 2,
    "grads": 1,
    "gradstein": 2,
    "gradstein(1)": 2,
    "gradstein's": 2,
    "gradstein's(1)": 2,
    "gradual": 3,
    "gradualism": 5,
    "gradualist": 4,
    "gradually": 4,
    "gradually(1)": 3,
    "graduate": 3,
    "graduate(1)": 3,
    "graduate(2)": 3,
    "graduate(3)": 3,
    "graduated": 4,
    "graduated(1)": 4,
    "graduates": 3,
    "graduates(1)": 3,
    "graduates(2)": 3,
    "graduates(3)": 3,
    "graduating": 4,
    "graduating(1)": 4,
    "graduation": 4,
    "graduation(1)": 4,
    "graduations": 4,
    "graduations(1)": 4,
    "gradus": 2,
    "grady": 2,
    "graeber": 2,
    "graebner": 2,
    "graef": 1,
    "graef(1)": 1,
    "graefe": 1,
    "graefe(1)": 1,
    "graeff": 1,
    "graeff(1)": 1,
    "graeme": 1,
    "graeme(1)": 1,
    "graeser": 2,
    "graessle": 2,
    "graetz": 1,
    "graf": 1,
    "grafe": 1,
    "graff": 1,
    "graffam": 2,
    "graffeo": 3,
    "graffiti": 3,
    "graffius": 3,
    "graft": 1,
    "grafted": 2,
    "grafting": 2,
    "grafton": 2,
    "grafts": 1,
    "grage": 1,
    "gragert": 2,
    "gragg": 1,
    "graham": 2,
    "graham(1)": 1,
    "graham's": 2,
    "graham's(1)": 1,
    "grahams": 1,
    "grahams(1)": 2,
    "grahek": 2,
    "grahl": 1,
    "grahn": 1,
    "graichen": 2,
    "grail": 1,
    "grain": 1,
    "grained": 1,
    "grainery": 3,
    "grainger": 3,
    "grains": 1,
    "grainy": 2,
    "grajeda": 3,
    "graley": 2,
    "grall": 1,
    "gram": 1,
    "grama": 2,
    "gramaphone": 3,
    "grambling": 2,
    "grambling(1)": 3,
    "gramer": 2,
    "gramercy": 3,
    "gramersey": 3,
    "grames": 1,
    "gramley": 2,
    "gramlich": 2,
    "gramling": 2,
    "gramm": 1,
    "gramm's": 1,
    "grammar": 2,
    "grammatical": 4,
    "grammatical(1)": 4,
    "grammatico": 4,
    "grammer": 2,
    "grammies": 2,
    "grammophon": 3,
    "gramms": 1,
    "grammy": 2,
    "grammy's": 2,
    "grammys": 2,
    "grams": 1,
    "gramza": 2,
    "gran": 1,
    "grana": 2,
    "granada": 3,
    "granada's": 3,
    "granade": 2,
    "granado": 3,
    "granados": 3,
    "granahan": 3,
    "granat": 2,
    "granata": 3,
    "granato": 3,
    "granberg": 2,
    "granberry": 3,
    "grancare": 2,
    "grand": 1,
    "grand's": 1,
    "granda": 2,
    "grandad": 2,
    "grandbabies": 3,
    "grandbabies(1)": 3,
    "grandbaby": 3,
    "grandbaby(1)": 3,
    "grandberry": 3,
    "grandchamp": 2,
    "grandchild": 2,
    "grandchild(1)": 2,
    "grandchildren": 3,
    "grandchildren(1)": 3,
    "grandchildren's": 3,
    "grandchildren's(1)": 3,
    "granddaddy": 3,
    "granddaughter": 3,
    "granddaughter's": 3,
    "granddaughters": 3,
    "grande": 1,
    "grander": 2,
    "granderson": 3,
    "grandest": 2,
    "grandeur": 2,
    "grandfather": 3,
    "grandfather(1)": 3,
    "grandfather's": 3,
    "grandfather's(1)": 3,
    "grandfathered": 3,
    "grandfathered(1)": 3,
    "grandfathering": 4,
    "grandfathering(1)": 4,
    "grandfatherly": 4,
    "grandfatherly(1)": 4,
    "grandfathers": 3,
    "grandfathers(1)": 3,
    "grandfield": 2,
    "grandi": 2,
    "grandillo": 3,
    "grandiloquent": 4,
    "grandin": 2,
    "grandinetti": 4,
    "grandiose": 3,
    "grandiose(1)": 3,
    "grandis": 2,
    "grandison": 3,
    "grandkid": 2,
    "grandkid(1)": 2,
    "grandkids": 2,
    "grandkids(1)": 2,
    "grandly": 2,
    "grandma": 2,
    "grandma(1)": 2,
    "grandma's": 2,
    "grandma's(1)": 2,
    "grandmaison": 3,
    "grandmaison(1)": 3,
    "grandmas": 2,
    "grandmas(1)": 2,
    "grandmas(2)": 2,
    "grandmaster": 3,
    "grandmaster(1)": 3,
    "grandmet": 2,
    "grandmother": 3,
    "grandmother(1)": 3,
    "grandmother(2)": 3,
    "grandmother's": 3,
    "grandmother's(1)": 3,
    "grandmother's(2)": 3,
    "grandmotherly": 4,
    "grandmotherly(1)": 4,
    "grandmotherly(2)": 4,
    "grandmothers": 3,
    "grandmothers(1)": 3,
    "grandmothers(2)": 3,
    "grandnephew": 3,
    "grandnephews": 3,
    "grandon": 2,
    "grandpa": 2,
    "grandpa(1)": 2,
    "grandpa(2)": 2,
    "grandparent": 3,
    "grandparent(1)": 3,
    "grandparents": 3,
    "grandparents(1)": 3,
    "grandparents'": 3,
    "grandparents'(1)": 3,
    "grandpre": 2,
    "grands": 1,
    "grandson": 2,
    "grandson(1)": 2,
    "grandson's": 2,
    "grandson's(1)": 2,
    "grandsons": 2,
    "grandsons(1)": 2,
    "grandstaff": 2,
    "grandstaff(1)": 2,
    "grandstand": 2,
    "grandstand(1)": 2,
    "grandstanding": 3,
    "grandstanding(1)": 3,
    "grandt": 1,
    "granduncle": 3,
    "granduncles": 3,
    "grandview": 2,
    "grandy": 2,
    "graner": 2,
    "granese": 2,
    "graney": 2,
    "granfield": 2,
    "grange": 1,
    "granger": 2,
    "grangers": 2,
    "granges": 2,
    "granholm": 2,
    "granier": 3,
    "granieri": 3,
    "granillo": 3,
    "graningeverken": 5,
    "graningeverken's": 5,
    "granite": 2,
    "granite(1)": 2,
    "granitic": 3,
    "granito": 3,
    "granlund": 2,
    "grannan": 2,
    "grannies": 2,
    "grannis": 2,
    "granny": 2,
    "grano": 2,
    "granoff": 2,
    "granola": 3,
    "granquist": 2,
    "granstrom": 2,
    "grant": 1,
    "grant's": 1,
    "granted": 2,
    "granted(1)": 2,
    "granted(2)": 2,
    "granted(3)": 2,
    "grantham": 2,
    "granting": 2,
    "granting(1)": 2,
    "grantland": 2,
    "grantor": 2,
    "grantors": 2,
    "grantree": 2,
    "grantree's": 2,
    "grants": 1,
    "grantz": 1,
    "granular": 3,
    "granulation": 4,
    "granule": 2,
    "granules": 2,
    "granulocyte": 4,
    "granum": 2,
    "granville": 2,
    "granville's": 2,
    "granz": 1,
    "granzow": 2,
    "grapage": 2,
    "grape": 1,
    "grapefruit": 2,
    "grapefruits": 2,
    "graper": 2,
    "grapes": 1,
    "grapeshot": 2,
    "grapevine": 2,
    "grapevines": 2,
    "graph": 1,
    "graphic": 2,
    "graphical": 3,
    "graphically": 3,
    "graphics": 2,
    "graphics'": 2,
    "graphite": 2,
    "graphology": 4,
    "graphs": 1,
    "grapple": 2,
    "grappled": 2,
    "grapples": 2,
    "grappling": 2,
    "grappling(1)": 3,
    "gras": 1,
    "gras(1)": 1,
    "graser": 2,
    "grasmick": 2,
    "grasp": 1,
    "grasped": 1,
    "grasping": 2,
    "grasps": 1,
    "grass": 1,
    "grasse": 1,
    "grassed": 1,
    "grassel": 2,
    "grasser": 2,
    "grassers": 2,
    "grasses": 2,
    "grasses(1)": 2,
    "grassfield": 2,
    "grassfield's": 2,
    "grassgreen": 2,
    "grasshopper": 3,
    "grasshoppers": 3,
    "grassi": 2,
    "grassia": 3,
    "grassings": 2,
    "grassl": 2,
    "grassland": 2,
    "grasslands": 2,
    "grassley": 2,
    "grasslike": 2,
    "grassman": 2,
    "grasso": 2,
    "grassroot": 2,
    "grassroots": 2,
    "grassy": 2,
    "grasty": 2,
    "grata": 2,
    "grate": 1,
    "grated": 2,
    "grateful": 2,
    "gratefully": 3,
    "grater": 2,
    "grates": 1,
    "grathwohl": 2,
    "gratification": 5,
    "gratified": 3,
    "gratifies": 3,
    "gratify": 3,
    "gratifying": 4,
    "grating": 2,
    "gratis": 2,
    "gratitude": 3,
    "grattan": 2,
    "gratton": 2,
    "gratuities": 4,
    "gratuitous": 4,
    "gratuitously": 5,
    "gratuity": 4,
    "gratz": 1,
    "gratzer": 2,
    "grau": 1,
    "grauberger": 3,
    "graue": 1,
    "graue(1)": 1,
    "grauel": 2,
    "grauel(1)": 2,
    "grauer": 2,
    "grauer(1)": 2,
    "graul": 1,
    "grauman": 2,
    "graumann": 2,
    "graunke": 1,
    "gravano": 3,
    "gravano(1)": 3,
    "gravatt": 2,
    "grave": 1,
    "gravel": 2,
    "graveline": 2,
    "gravell": 2,
    "gravelle": 2,
    "gravelly": 3,
    "gravely": 2,
    "graven": 2,
    "graver": 2,
    "graves": 1,
    "graves's": 2,
    "graveside": 2,
    "gravesite": 2,
    "gravest": 2,
    "gravestone": 2,
    "gravestones": 2,
    "gravett": 2,
    "gravette": 2,
    "graveyard": 2,
    "graveyards": 2,
    "gravies": 2,
    "gravimeter": 4,
    "gravimetric": 4,
    "gravina": 3,
    "gravino": 3,
    "gravitas": 3,
    "gravitate": 3,
    "gravitated": 4,
    "gravitates": 3,
    "gravitating": 4,
    "gravitation": 4,
    "gravitational": 5,
    "gravitationally": 5,
    "gravitt": 2,
    "gravitt's": 2,
    "gravity": 3,
    "gravity(1)": 3,
    "gravley": 2,
    "gravlin": 2,
    "gravois": 2,
    "gravy": 2,
    "graw": 1,
    "grawe": 1,
    "gray": 1,
    "gray's": 1,
    "graybeal": 2,
    "graybeard": 2,
    "graybeards": 2,
    "graybill": 2,
    "graydon": 2,
    "graye": 1,
    "grayer": 2,
    "grayest": 2,
    "graying": 2,
    "grayish": 2,
    "grayling": 2,
    "grays": 1,
    "grayson": 2,
    "graze": 1,
    "grazed": 1,
    "grazer": 2,
    "graziani": 4,
    "graziano": 4,
    "grazier": 3,
    "grazing": 2,
    "grbavica": 4,
    "grbavica(1)": 4,
    "greaney": 2,
    "grear": 1,
    "grease": 1,
    "greased": 1,
    "greaser": 2,
    "greasewood": 2,
    "greasing": 2,
    "greason": 2,
    "greasy": 2,
    "great": 1,
    "great's": 1,
    "great-circle": 3,
    "greater": 2,
    "greatest": 2,
    "greathouse": 2,
    "greatly": 2,
    "greatness": 2,
    "greats": 1,
    "greave": 1,
    "greaves": 1,
    "greb": 1,
    "grebe": 1,
    "greber": 2,
    "grebner": 2,
    "grecco": 2,
    "grech": 1,
    "grecian": 2,
    "grecko": 2,
    "greco": 2,
    "greco-roman": 4,
    "grede": 1,
    "gredel": 2,
    "greditor": 3,
    "greear": 2,
    "greece": 1,
    "greece's": 2,
    "greed": 1,
    "greedier": 3,
    "greediest": 3,
    "greedily": 3,
    "greedy": 2,
    "greek": 1,
    "greeks": 1,
    "greeley": 2,
    "greeleyville": 3,
    "greelieville": 3,
    "greely": 2,
    "green": 1,
    "green's": 1,
    "greenan": 2,
    "greenawalt": 3,
    "greenaway": 3,
    "greenback": 2,
    "greenback's": 2,
    "greenbacks": 2,
    "greenbaum": 2,
    "greenbelt": 2,
    "greenberg": 2,
    "greenberg's": 2,
    "greenberger": 3,
    "greenblatt": 2,
    "greenburg": 2,
    "greenbury": 3,
    "greenbush": 2,
    "greencastle": 3,
    "greene": 1,
    "greene's": 1,
    "greened": 1,
    "greener": 2,
    "greenery": 3,
    "greenest": 2,
    "greenfeld": 2,
    "greenfeld's": 2,
    "greenfell": 2,
    "greenfell's": 2,
    "greenfield": 2,
    "greenfield's": 2,
    "greenhalgh": 2,
    "greenham": 2,
    "greenhaw": 2,
    "greenhill": 2,
    "greenhoe": 2,
    "greenhouse": 2,
    "greenhouses": 3,
    "greenhouses(1)": 3,
    "greenhut": 2,
    "greeniaus": 3,
    "greenidge": 2,
    "greening": 2,
    "greenish": 2,
    "greenland": 2,
    "greenland(1)": 2,
    "greenlaw": 2,
    "greenleaf": 2,
    "greenlee": 2,
    "greenlees": 2,
    "greenley": 2,
    "greenly": 2,
    "greenmail": 2,
    "greenmailer": 3,
    "greenman": 2,
    "greenness": 2,
    "greeno": 2,
    "greenough": 2,
    "greenpeace": 2,
    "greenpeace's": 3,
    "greens": 1,
    "greens'": 1,
    "greensboro": 3,
    "greensburg": 2,
    "greenshield": 2,
    "greenshields": 2,
    "greenslade": 2,
    "greenslet": 2,
    "greenspan": 2,
    "greenspan's": 2,
    "greenspon": 2,
    "greenspun": 2,
    "greenstein": 2,
    "greenstein(1)": 2,
    "greenstone": 2,
    "greenstreet": 2,
    "greenup": 2,
    "greenvale": 2,
    "greenville": 2,
    "greenwald": 2,
    "greenwald's": 2,
    "greenwalds": 2,
    "greenwalt": 2,
    "greenway": 2,
    "greenwell": 2,
    "greenwich": 2,
    "greenwich(1)": 2,
    "greenwich's": 3,
    "greenwood": 2,
    "greer": 1,
    "greeson": 2,
    "greet": 1,
    "greeted": 2,
    "greeted(1)": 2,
    "greetham": 2,
    "greeting": 2,
    "greetings": 2,
    "greets": 1,
    "greever": 2,
    "grefe": 1,
    "greff": 1,
    "greg": 1,
    "greg's": 1,
    "grega": 2,
    "gregarious": 4,
    "greger": 2,
    "gregersen": 3,
    "gregerson": 3,
    "gregg": 1,
    "greggs": 1,
    "grego": 2,
    "gregoire": 2,
    "gregor": 2,
    "gregori": 3,
    "gregoria": 4,
    "gregorian": 4,
    "gregorich": 3,
    "gregorie": 3,
    "gregorio": 4,
    "gregory": 3,
    "gregory's": 3,
    "gregson": 2,
    "gregston": 2,
    "gregus": 2,
    "greider": 2,
    "greif": 1,
    "greiff": 1,
    "greiff(1)": 1,
    "greig": 1,
    "greim": 1,
    "greiman": 2,
    "grein": 1,
    "greiner": 2,
    "greinke": 1,
    "greis": 1,
    "greitz": 1,
    "greitz(1)": 1,
    "greiwe": 1,
    "grell": 1,
    "grella": 2,
    "grelle": 1,
    "gremban": 2,
    "gremillion": 3,
    "gremlin": 2,
    "gremlins": 2,
    "gren": 1,
    "grenada": 3,
    "grenada(1)": 3,
    "grenade": 2,
    "grenades": 2,
    "grenda": 2,
    "grendel": 2,
    "grendel's": 2,
    "grenell": 2,
    "grenfell": 2,
    "grenier": 3,
    "greninger": 3,
    "grennan": 2,
    "grenoble": 3,
    "grenon": 2,
    "grenouille": 3,
    "grenz": 1,
    "gresh": 1,
    "gresham": 2,
    "gresham's": 2,
    "gresko": 2,
    "gress": 1,
    "gresser": 2,
    "gressett": 2,
    "gressley": 2,
    "gressman": 2,
    "greta": 2,
    "greta's": 2,
    "gretal": 2,
    "gretchen": 2,
    "grete": 1,
    "gretel": 2,
    "greth": 1,
    "grethel": 2,
    "grether": 2,
    "gretna": 2,
    "gretna's": 2,
    "grettenberger": 4,
    "gretz": 1,
    "gretzinger": 3,
    "gretzky": 2,
    "greubel": 2,
    "greuel": 2,
    "greulich": 2,
    "greunke": 1,
    "greve": 1,
    "grever": 2,
    "grew": 1,
    "grewal": 2,
    "grewe": 1,
    "grewell": 2,
    "grey": 1,
    "grey's": 1,
    "greyhound": 2,
    "greyhound's": 2,
    "greying": 2,
    "greylag": 2,
    "greystone": 2,
    "gribben": 2,
    "gribbin": 2,
    "gribbins": 2,
    "gribble": 2,
    "gribbles": 2,
    "gribbon": 2,
    "grice": 1,
    "grid": 1,
    "grid's": 1,
    "grider": 2,
    "gridiron": 3,
    "gridley": 2,
    "gridley's": 2,
    "gridlock": 2,
    "gridlock's": 2,
    "gridlocked": 2,
    "gridlocks": 2,
    "grids": 1,
    "grieb": 1,
    "griebel": 2,
    "grieco": 2,
    "grieder": 2,
    "grief": 1,
    "grieger": 2,
    "griego": 2,
    "grieme": 1,
    "griep": 1,
    "griepentrog": 3,
    "grier": 2,
    "grier(1)": 1,
    "grier's": 2,
    "grier's(1)": 1,
    "grierson": 2,
    "gries": 1,
    "griesa": 3,
    "griesbach": 2,
    "griese": 1,
    "griesemer": 3,
    "grieser": 2,
    "grieshaber": 3,
    "griesinger": 3,
    "griess": 1,
    "griesser": 2,
    "griest": 2,
    "grievance": 2,
    "grievances": 3,
    "grievances(1)": 3,
    "grieve": 1,
    "grieved": 1,
    "griever": 2,
    "grievers": 2,
    "grieves": 1,
    "grieveson": 3,
    "grieveson(1)": 2,
    "grieving": 2,
    "grievous": 2,
    "grievously": 3,
    "griff": 1,
    "griffee": 2,
    "griffen": 2,
    "griffeth": 2,
    "griffey": 2,
    "griffey's": 2,
    "griffie": 2,
    "griffin": 2,
    "griffin's": 2,
    "griffing": 2,
    "griffis": 2,
    "griffith": 2,
    "griffith(1)": 2,
    "griffith's": 2,
    "griffiths": 2,
    "griffitts": 2,
    "griffo": 2,
    "griffon": 2,
    "griffy": 2,
    "grigas": 2,
    "grigg": 1,
    "griggs": 1,
    "griggy": 2,
    "grignon": 2,
    "grigoli": 3,
    "grigorovich": 4,
    "grigory": 3,
    "grigory(1)": 3,
    "grigoryant": 3,
    "grigoryants": 3,
    "grigsby": 2,
    "grijalva": 3,
    "grill": 1,
    "grille": 1,
    "grilled": 1,
    "grilli": 2,
    "grilling": 2,
    "grilliot": 3,
    "grillo": 2,
    "grillot": 2,
    "grills": 1,
    "grim": 1,
    "grima": 2,
    "grimace": 2,
    "grimaced": 2,
    "grimaces": 3,
    "grimacing": 3,
    "grimaldi": 3,
    "grimaldo": 3,
    "grime": 1,
    "grimes": 1,
    "grimley": 2,
    "grimly": 2,
    "grimm": 1,
    "grimm's": 1,
    "grimme": 1,
    "grimmer": 2,
    "grimmest": 2,
    "grimmett": 2,
    "grimness": 2,
    "grimshaw": 2,
    "grimsley": 2,
    "grimstad": 2,
    "grimwood": 2,
    "grimy": 2,
    "grin": 1,
    "grinage": 2,
    "grinald": 2,
    "grinalds": 2,
    "grinberg": 2,
    "grinch": 1,
    "grind": 1,
    "grinde": 1,
    "grinder": 2,
    "grinders": 2,
    "grinding": 2,
    "grindlay": 2,
    "grindlay(1)": 2,
    "grindlays": 2,
    "grindlays(1)": 2,
    "grindle": 2,
    "grindley": 2,
    "grindrod": 2,
    "grinds": 1,
    "grindstaff": 2,
    "grindstone": 2,
    "grine": 1,
    "griner": 2,
    "gring": 1,
    "gringo": 2,
    "gringos": 2,
    "grinned": 1,
    "grinnell": 2,
    "grinning": 2,
    "grins": 1,
    "grinstead": 2,
    "grinstein": 2,
    "grinstein(1)": 2,
    "grip": 1,
    "gripe": 1,
    "griped": 1,
    "gripes": 1,
    "griping": 2,
    "gripp": 1,
    "gripped": 1,
    "grippi": 2,
    "gripping": 2,
    "grippo": 2,
    "grips": 1,
    "grisanti": 3,
    "grisby": 2,
    "griscom": 2,
    "grise": 1,
    "grisham": 2,
    "grisham's": 2,
    "grishilda": 3,
    "grishman": 2,
    "grisly": 2,
    "grismer": 4,
    "grismer(1)": 2,
    "grismore": 2,
    "grissett": 2,
    "grissinger": 3,
    "grisso": 2,
    "grissom": 2,
    "grisson": 2,
    "grist": 1,
    "gristle": 2,
    "griswell": 2,
    "griswold": 2,
    "grit": 1,
    "grites": 1,
    "grits": 1,
    "gritter": 2,
    "gritting": 2,
    "gritton": 2,
    "gritty": 2,
    "gritz": 1,
    "gritzmacher": 3,
    "grivas": 2,
    "griz": 1,
    "grizelda": 3,
    "grizzard": 2,
    "grizzell": 2,
    "grizzle": 2,
    "grizzled": 2,
    "grizzlies": 2,
    "grizzly": 2,
    "gro": 1,
    "groan": 1,
    "groaned": 1,
    "groaning": 2,
    "groans": 1,
    "groat": 1,
    "grob": 1,
    "grobe": 1,
    "groben": 2,
    "grober": 2,
    "grobian": 3,
    "grobler": 2,
    "groce": 1,
    "grocer": 2,
    "grocer's": 2,
    "groceries": 3,
    "groceries(1)": 2,
    "grocers": 2,
    "grocery": 3,
    "grocery(1)": 2,
    "groch": 1,
    "grochowski": 3,
    "grode": 1,
    "groden": 2,
    "grodin": 2,
    "grodsky": 2,
    "groebner": 2,
    "groeger": 2,
    "groen": 1,
    "groene": 2,
    "groeneveld": 3,
    "groenewold": 3,
    "groening": 3,
    "groep": 1,
    "groer": 2,
    "groesbeck": 2,
    "groff": 1,
    "groft": 1,
    "grog": 1,
    "grogan": 2,
    "grogg": 1,
    "groggy": 2,
    "groh": 1,
    "grohman": 2,
    "grohs": 1,
    "groin": 1,
    "groined": 1,
    "groins": 1,
    "groleau": 2,
    "grolier": 2,
    "groll": 1,
    "grom": 1,
    "groma": 2,
    "groman": 2,
    "gromek": 2,
    "gromer": 2,
    "gromes": 1,
    "gromyko": 3,
    "gronau": 2,
    "gronberg": 2,
    "grondahl": 2,
    "grondin": 2,
    "grone": 1,
    "gronemeyer": 4,
    "groner": 2,
    "gronewold": 3,
    "groninger": 3,
    "gronlund": 2,
    "gronowski": 3,
    "gronseth": 2,
    "gronski": 2,
    "groom": 1,
    "groome": 1,
    "groomed": 1,
    "groomer": 2,
    "groomers": 2,
    "groomes": 1,
    "grooming": 2,
    "grooms": 1,
    "groopman": 2,
    "groos": 1,
    "groot": 1,
    "grooters": 2,
    "groove": 1,
    "groover": 2,
    "grooves": 1,
    "grooviest": 3,
    "groovy": 2,
    "grope": 1,
    "groped": 1,
    "groping": 2,
    "gropp": 1,
    "gropper": 2,
    "groppy": 2,
    "groppy's": 2,
    "gros": 1,
    "grosbeak": 2,
    "grosbeaks": 2,
    "grosch": 1,
    "grose": 1,
    "groseclose": 3,
    "grosh": 1,
    "groshek": 2,
    "groshong": 2,
    "grosjean": 2,
    "groskopf": 2,
    "groskopf(1)": 2,
    "gross": 1,
    "gross's": 2,
    "grossbard": 2,
    "grossberg": 2,
    "grosse": 1,
    "grossed": 1,
    "grossenbacher": 4,
    "grosser": 2,
    "grosses": 2,
    "grossfeld": 2,
    "grosshans": 2,
    "grossi": 2,
    "grossing": 2,
    "grosskopf": 2,
    "grosskopf(1)": 2,
    "grossly": 2,
    "grossman": 2,
    "grossman's": 2,
    "grossmann": 2,
    "grossnickle": 3,
    "grosso": 2,
    "grosvenor": 2,
    "grosz": 1,
    "grote": 1,
    "grotesque": 2,
    "grotesquely": 3,
    "groth": 1,
    "grothaus": 2,
    "grothe": 1,
    "grotheer": 2,
    "groton": 2,
    "grotto": 2,
    "grotz": 1,
    "grouch": 1,
    "groucho": 2,
    "groucho(1)": 2,
    "grouchy": 2,
    "groulx": 1,
    "ground": 1,
    "groundbreaking": 3,
    "groundbreaking(1)": 3,
    "grounded": 2,
    "grounder": 2,
    "groundhog": 2,
    "grounding": 2,
    "groundless": 2,
    "groundling": 2,
    "groundnut": 2,
    "groundnuts": 2,
    "grounds": 1,
    "grounds(1)": 1,
    "groundskeeper": 3,
    "groundskeepers": 3,
    "groundswell": 2,
    "groundwater": 3,
    "groundwater(1)": 3,
    "groundwork": 2,
    "group": 1,
    "group's": 1,
    "groupe": 1,
    "grouped": 1,
    "groupement": 2,
    "grouper": 2,
    "groupers": 2,
    "groupie": 2,
    "groupies": 2,
    "grouping": 2,
    "groupings": 2,
    "groups": 1,
    "groups'": 1,
    "groupware": 2,
    "grouse": 1,
    "groused": 1,
    "grouses": 2,
    "grousing": 2,
    "groussman": 2,
    "grout": 1,
    "grouting": 2,
    "grove": 1,
    "grove's": 1,
    "grovel": 2,
    "groveling": 3,
    "groveling(1)": 2,
    "groveman": 2,
    "grover": 2,
    "grover's": 2,
    "grovers": 2,
    "groves": 1,
    "grow": 1,
    "growe": 1,
    "grower": 2,
    "growers": 2,
    "growers'": 2,
    "growing": 2,
    "growl": 1,
    "growled": 1,
    "growling": 2,
    "growls": 1,
    "grown": 1,
    "grownup": 2,
    "grownups": 2,
    "grows": 1,
    "growth": 1,
    "growth's": 1,
    "growths": 1,
    "grozny": 2,
    "grozny's": 2,
    "grua": 2,
    "grub": 1,
    "gruba": 2,
    "grubaugh": 2,
    "grubb": 1,
    "grubbs": 1,
    "grubby": 2,
    "grube": 1,
    "gruben": 2,
    "gruber": 2,
    "gruberova": 4,
    "grubman": 2,
    "grubs": 1,
    "grubstein": 2,
    "grubstein(1)": 2,
    "grucci": 2,
    "grudenstein": 3,
    "grudenstein(1)": 3,
    "grudge": 1,
    "grudges": 2,
    "grudging": 2,
    "grudgingly": 3,
    "grudgingly(1)": 3,
    "grudzien": 2,
    "grudzinski": 3,
    "gruel": 2,
    "grueling": 3,
    "grueling(1)": 2,
    "gruen": 1,
    "gruenberg": 2,
    "gruener": 2,
    "gruenewald": 3,
    "gruenhagen": 3,
    "gruenwald": 2,
    "gruesome": 2,
    "gruet": 2,
    "gruetzmacher": 3,
    "gruff": 1,
    "gruffly": 2,
    "gruhlke": 1,
    "gruhn": 1,
    "gruis": 2,
    "grulke": 1,
    "grullon": 2,
    "grum": 1,
    "grumbine": 2,
    "grumble": 2,
    "grumbled": 2,
    "grumbles": 2,
    "grumbling": 3,
    "grumbling(1)": 2,
    "grumblings": 3,
    "grumblings(1)": 2,
    "grumman": 2,
    "grumman's": 2,
    "grummond": 2,
    "grummond's": 2,
    "grump": 1,
    "grumpier": 3,
    "grumpier(1)": 2,
    "grumpy": 2,
    "grun": 1,
    "grunberg": 2,
    "grund": 1,
    "grunden": 2,
    "grunder": 2,
    "grundfest": 2,
    "grundfest(1)": 2,
    "grundhofer": 3,
    "grundig": 2,
    "grundman": 2,
    "grundstrom": 2,
    "grundy": 2,
    "grunebaum": 2,
    "gruneich": 2,
    "gruner": 2,
    "grunert": 2,
    "grunewald": 3,
    "grunewald(1)": 2,
    "grunge": 1,
    "grungy": 2,
    "grunion": 2,
    "grunow": 2,
    "grunt": 1,
    "gruntal": 2,
    "gruntal's": 2,
    "grunted": 2,
    "grunting": 2,
    "grunts": 1,
    "grunwald": 2,
    "grupe": 1,
    "grupo": 2,
    "grupp": 1,
    "gruppo": 2,
    "grush": 1,
    "grushow": 2,
    "gruss": 1,
    "grussing": 2,
    "gruszka": 2,
    "grutman": 2,
    "gruver": 2,
    "gruwell": 2,
    "gruza": 2,
    "gryder": 2,
    "grygiel": 2,
    "gryphons": 2,
    "grzelak": 3,
    "grzesiak": 4,
    "grzeskowiak": 5,
    "grzyb": 2,
    "grzybowski": 4,
    "grzywacz": 3,
    "grzywinski": 4,
    "gschwind": 2,
    "gsell": 2,
    "gtech": 2,
    "gtech's": 2,
    "gu": 1,
    "guacamole": 4,
    "guadagno": 3,
    "guadalajara": 5,
    "guadalajara(1)": 4,
    "guadalcanal": 4,
    "guadalupe": 3,
    "guadalupe(1)": 4,
    "guadarrama": 5,
    "guadeloupe": 3,
    "guagliardo": 4,
    "guajardo": 3,
    "gualdoni": 3,
    "gualtieri": 3,
    "guam": 1,
    "guam's": 1,
    "guanaco": 3,
    "guandjo": 2,
    "guandjo's": 2,
    "guandjong": 2,
    "guandjong's": 2,
    "guandong": 2,
    "guandong's": 2,
    "guangdong": 2,
    "guangdong(1)": 2,
    "guangjo": 2,
    "guangjo's": 2,
    "guangzhou": 2,
    "guanine": 2,
    "guano": 2,
    "guantanamo": 4,
    "guantanamo's": 4,
    "guarani": 3,
    "guarani(1)": 3,
    "guarantee": 3,
    "guarantee's": 3,
    "guaranteed": 3,
    "guaranteeing": 4,
    "guarantees": 3,
    "guaranties": 3,
    "guarantor": 3,
    "guarantors": 3,
    "guaranty": 3,
    "guaranty's": 3,
    "guaranty-first": 4,
    "guard": 1,
    "guard's": 1,
    "guardado": 3,
    "guarded": 2,
    "guarded(1)": 2,
    "guardedly": 3,
    "guardfish": 2,
    "guardfish's": 3,
    "guardia": 3,
    "guardian": 3,
    "guardian's": 3,
    "guardians": 3,
    "guardianship": 4,
    "guardin": 2,
    "guarding": 2,
    "guardino": 3,
    "guardiola": 4,
    "guardrail": 2,
    "guardrails": 2,
    "guards": 1,
    "guardsman": 2,
    "guardsman(1)": 2,
    "guardsmen": 2,
    "guariglia": 4,
    "guarin": 2,
    "guarin(1)": 2,
    "guarini": 3,
    "guarino": 3,
    "guarisco": 3,
    "guarnaccia": 4,
    "guarneri": 3,
    "guarnieri": 3,
    "guasch": 1,
    "guastella": 3,
    "guatemala": 4,
    "guatemala's": 4,
    "guatemalan": 4,
    "guatemalans": 4,
    "guattery": 3,
    "guava": 2,
    "guavas": 2,
    "guay": 1,
    "guayabera": 4,
    "guba": 2,
    "guba's": 2,
    "gubbels": 2,
    "gubbins": 2,
    "guber": 2,
    "guber(1)": 2,
    "guberman": 3,
    "gubernatorial": 6,
    "gubler": 3,
    "gubler(1)": 2,
    "gubser": 2,
    "gucci": 2,
    "gucciardo": 3,
    "guccio": 3,
    "guccione": 3,
    "guck": 1,
    "guckert": 2,
    "gucwa": 2,
    "gude": 1,
    "gudelay": 3,
    "guderian": 4,
    "gudgel": 2,
    "gudgeon": 2,
    "gudger": 2,
    "gudino": 3,
    "gudmundson": 3,
    "gue": 1,
    "guedry": 2,
    "guei-yuan": 3,
    "guel": 1,
    "guenette": 2,
    "guenna": 2,
    "guenter": 2,
    "guenther": 2,
    "guenthner": 2,
    "guerard": 2,
    "guercio": 3,
    "guerette": 2,
    "guerilla": 3,
    "guerillas": 3,
    "guerin": 2,
    "guerino": 3,
    "guerneville": 3,
    "guernsey": 2,
    "guernseys": 2,
    "guerra": 2,
    "guerrant": 2,
    "guerre": 1,
    "guerrera": 3,
    "guerrero": 3,
    "guerrette": 2,
    "guerrier": 3,
    "guerrieri": 3,
    "guerriero": 3,
    "guerrilla": 3,
    "guerrillas": 3,
    "guerrillas'": 3,
    "guerrini": 3,
    "guerry": 2,
    "guertin": 2,
    "guess": 1,
    "guessed": 1,
    "guesser": 2,
    "guessers": 2,
    "guesses": 2,
    "guesses(1)": 2,
    "guessing": 2,
    "guesstimate": 3,
    "guesstimate(1)": 3,
    "guesstimates": 3,
    "guesstimates(1)": 3,
    "guesswork": 2,
    "guest": 1,
    "guest's": 1,
    "guested": 2,
    "guesthouse": 2,
    "guesthouses": 3,
    "guests": 1,
    "guests'": 1,
    "guettler": 3,
    "guettler(1)": 2,
    "guevara": 3,
    "guevara(1)": 3,
    "guevara's": 3,
    "guevara's(1)": 3,
    "guez": 1,
    "guez's": 2,
    "guff": 1,
    "guffaw": 2,
    "guffaws": 2,
    "guffey": 2,
    "guffin": 2,
    "guffy": 2,
    "gugel": 2,
    "guggenheim": 3,
    "guggenheim's": 3,
    "guggisberg": 3,
    "gugino": 3,
    "guglielmetti": 5,
    "guglielmi": 4,
    "guglielmo": 4,
    "gugliotta": 4,
    "gugliotti": 4,
    "gugliuzza": 4,
    "guhl": 1,
    "guiana": 3,
    "guice": 1,
    "guichard": 2,
    "guida": 2,
    "guidance": 2,
    "guide": 1,
    "guide's": 1,
    "guidebook": 2,
    "guidebooks": 2,
    "guided": 2,
    "guided(1)": 2,
    "guideline": 2,
    "guidelines": 2,
    "guidepost": 2,
    "guideposts": 2,
    "guider": 2,
    "guidera": 3,
    "guides": 1,
    "guidi": 2,
    "guidice": 2,
    "guiding": 2,
    "guido": 2,
    "guidone": 3,
    "guidotti": 3,
    "guidroz": 2,
    "guidry": 3,
    "guier": 2,
    "guiffre": 2,
    "guilbault": 2,
    "guilbeau": 2,
    "guilbeault": 2,
    "guilbeaux": 2,
    "guilbert": 2,
    "guild": 1,
    "guild's": 1,
    "guilder": 2,
    "guilder's": 2,
    "guilders": 2,
    "guildhall": 2,
    "guilds": 1,
    "guile": 1,
    "guileless": 2,
    "guiles": 1,
    "guilfoil": 2,
    "guilford": 2,
    "guilford's": 2,
    "guilfoyle": 2,
    "guiliani": 4,
    "guiliano": 4,
    "guilin": 2,
    "guill": 1,
    "guilla": 2,
    "guillaume": 2,
    "guillaume(1)": 2,
    "guillemette": 3,
    "guillen": 2,
    "guillermo": 3,
    "guillermo(1)": 3,
    "guillermo(2)": 3,
    "guillet": 2,
    "guillette": 2,
    "guilliams": 3,
    "guillory": 3,
    "guillot": 2,
    "guillotine": 3,
    "guillotine(1)": 3,
    "guillotte": 2,
    "guilmartin": 3,
    "guilmette": 2,
    "guilt": 1,
    "guiltless": 2,
    "guilty": 2,
    "guimaraes": 3,
    "guimond": 2,
    "guimont": 2,
    "guin": 1,
    "guinan": 2,
    "guinarou": 3,
    "guinarou's": 3,
    "guindon": 2,
    "guinea": 2,
    "guineas": 2,
    "guiness": 2,
    "guiney": 2,
    "guinier": 2,
    "guinier's": 2,
    "guinn": 1,
    "guinness": 2,
    "guinness's": 3,
    "guinta": 2,
    "guinther": 2,
    "guinto": 2,
    "guinyard": 2,
    "guion": 2,
    "guire": 1,
    "guise": 1,
    "guises": 2,
    "guises(1)": 2,
    "guisewite": 2,
    "guisinger": 3,
    "guitar": 2,
    "guitarist": 3,
    "guitarist's": 3,
    "guitarists": 3,
    "guitarro": 3,
    "guitarro's": 3,
    "guitars": 2,
    "guiterrez": 3,
    "guitierrez": 3,
    "guizar": 2,
    "gujarat": 3,
    "gul": 1,
    "gula": 2,
    "gulag": 2,
    "gulag(1)": 2,
    "gulas": 2,
    "gulbrandsen": 3,
    "gulbrandson": 3,
    "gulbransen": 3,
    "gulbranson": 3,
    "gulbuddin": 3,
    "gulbuddin's": 3,
    "gulch": 1,
    "guldin": 2,
    "gulf": 1,
    "gulf's": 1,
    "gulfport": 2,
    "gulfs": 1,
    "gulfstream": 2,
    "gulick": 2,
    "gulino": 3,
    "gull": 1,
    "gull's": 1,
    "gulla": 2,
    "gullah": 2,
    "gullatt": 2,
    "gulledge": 2,
    "gullet": 2,
    "gullett": 2,
    "gullette": 2,
    "gulley": 2,
    "gulli": 2,
    "gullibility": 5,
    "gullible": 3,
    "gullick": 2,
    "gullickson": 3,
    "gullies": 2,
    "gulliford": 3,
    "gullikson": 3,
    "gullion": 2,
    "gulliver": 3,
    "gullo": 2,
    "gulls": 1,
    "gully": 2,
    "gulp": 1,
    "gulped": 1,
    "gulping": 2,
    "gulps": 1,
    "gulyas": 2,
    "gum": 1,
    "gumaer": 3,
    "gumaer(1)": 2,
    "gumbel": 2,
    "gumbert": 2,
    "gumbi": 2,
    "gumbi's": 2,
    "gumbiner": 3,
    "gumbinger": 3,
    "gumbo": 2,
    "gumbo-limbo": 4,
    "gumbs": 1,
    "gumi": 2,
    "gumina": 3,
    "gumm": 1,
    "gummed": 1,
    "gummi": 2,
    "gummy": 2,
    "gump": 1,
    "gump's": 1,
    "gumpert": 2,
    "gumport": 2,
    "gumpp": 1,
    "gumption": 2,
    "gums": 1,
    "gumshoe": 2,
    "gumucio": 4,
    "gumz": 1,
    "gun": 1,
    "gun's": 1,
    "gunadi": 3,
    "gunatilake": 5,
    "gunboat": 2,
    "gunboats": 2,
    "gunby": 2,
    "guncotton": 3,
    "gundel": 2,
    "gunder": 2,
    "gunderman": 3,
    "gundersen": 3,
    "gunderson": 3,
    "gundlach": 2,
    "gundle": 2,
    "gundog": 2,
    "gundrum": 2,
    "gundry": 3,
    "gundy": 2,
    "gunfight": 2,
    "gunfighter": 3,
    "gunfighter's": 3,
    "gunfighters": 3,
    "gunfighting": 3,
    "gunfights": 2,
    "gunfire": 3,
    "gunfire(1)": 2,
    "gunflint": 2,
    "gung": 1,
    "gunhilda": 3,
    "gunia": 3,
    "gunkel": 2,
    "gunlick": 2,
    "gunlicks": 2,
    "gunman": 2,
    "gunman's": 2,
    "gunmen": 2,
    "gunn": 1,
    "gunn's": 1,
    "gunnar": 2,
    "gunnarson": 3,
    "gunned": 1,
    "gunnell": 2,
    "gunnells": 2,
    "gunnels": 2,
    "gunner": 2,
    "gunners": 2,
    "gunnerson": 3,
    "gunnery": 3,
    "gunning": 2,
    "gunnison": 3,
    "gunnoe": 2,
    "gunny": 2,
    "gunnysack": 3,
    "gunnysacks": 3,
    "gunpoint": 2,
    "gunpowder": 3,
    "gunrunner": 3,
    "guns": 1,
    "gunsalus": 3,
    "gunship": 2,
    "gunships": 2,
    "gunshot": 2,
    "gunshots": 2,
    "gunslinger": 3,
    "gunslingers": 3,
    "gunsmoke": 2,
    "gunst": 1,
    "gunter": 2,
    "gunther": 2,
    "guntur": 2,
    "gunty": 2,
    "guppies": 2,
    "guppy": 2,
    "gupta": 2,
    "guptill": 2,
    "gupton": 2,
    "gura": 2,
    "gural": 2,
    "gurevich": 3,
    "gurganious": 4,
    "gurganus": 3,
    "gurgle": 2,
    "gurgling": 3,
    "gurgling(1)": 2,
    "gurian": 3,
    "gurion": 3,
    "gurit": 2,
    "gurit(1)": 2,
    "gurka": 2,
    "gurkin": 2,
    "gurley": 2,
    "gurnards": 2,
    "gurnee": 2,
    "gurney": 2,
    "gurney's": 2,
    "gurnsey": 2,
    "gurr": 1,
    "gurria": 3,
    "gurrola": 3,
    "gurry": 2,
    "gurski": 2,
    "gursky": 2,
    "gurtler": 3,
    "gurtler(1)": 2,
    "gurtner": 2,
    "gurtz": 1,
    "guru": 2,
    "guru's": 2,
    "gurule": 2,
    "gurus": 2,
    "gus": 1,
    "gusciora": 4,
    "guse": 1,
    "gusella": 3,
    "guseman": 2,
    "guses": 2,
    "guses(1)": 2,
    "gush": 1,
    "gushed": 1,
    "gusher": 2,
    "gushers": 2,
    "gushes": 2,
    "gushing": 2,
    "gusinsky": 3,
    "gusky": 2,
    "guslan": 2,
    "gusler": 3,
    "gusler(1)": 2,
    "gusman": 2,
    "guss": 1,
    "gussie": 2,
    "gussied": 2,
    "gussman": 2,
    "gussy": 2,
    "gust": 1,
    "gustaf": 2,
    "gustafson": 3,
    "gustafsson": 3,
    "gustav": 2,
    "gustava": 3,
    "gustave": 3,
    "gustaveson": 4,
    "gustavo": 3,
    "gustavson": 3,
    "gustavus": 3,
    "guste": 1,
    "gusted": 2,
    "guster": 2,
    "gustin": 2,
    "gusting": 2,
    "gusto": 2,
    "guston": 2,
    "gusts": 1,
    "gustus": 2,
    "gusty": 2,
    "gut": 1,
    "gutekunst": 3,
    "gutenberg": 3,
    "guterman": 3,
    "gutermuth": 3,
    "gutfeld": 2,
    "gutfreund": 2,
    "guth": 1,
    "gutherie": 3,
    "guthery": 3,
    "guthmiller": 3,
    "guthridge": 2,
    "guthrie": 2,
    "guthrie's": 2,
    "gutierez": 3,
    "gutierres": 3,
    "gutierrez": 3,
    "gutknecht": 2,
    "gutkowski": 3,
    "gutless": 2,
    "gutman": 2,
    "gutmann": 2,
    "gutowski": 3,
    "gutridge": 2,
    "guts": 1,
    "gutshall": 2,
    "gutsy": 2,
    "gutt": 1,
    "gutted": 2,
    "guttenberg": 3,
    "gutter": 2,
    "guttered": 2,
    "guttering": 3,
    "gutterman": 3,
    "gutters": 2,
    "gutting": 2,
    "guttmacher": 3,
    "guttman": 2,
    "guttmann": 2,
    "guttural": 3,
    "gutwaks": 2,
    "gutwein": 2,
    "gutzman": 2,
    "gutzmer": 2,
    "gutzwiller": 3,
    "guy": 1,
    "guy's": 1,
    "guyana": 3,
    "guyer": 2,
    "guyett": 2,
    "guyette": 2,
    "guymon": 2,
    "guynes": 1,
    "guynn": 1,
    "guyon": 2,
    "guyot": 2,
    "guys": 1,
    "guys'": 1,
    "guyton": 2,
    "guza": 2,
    "guzek": 2,
    "guzik": 2,
    "guzman": 2,
    "guzman(1)": 2,
    "guzowski": 3,
    "guzy": 2,
    "guzzardo": 3,
    "guzzetta": 3,
    "guzzetti": 3,
    "guzzi": 2,
    "guzzle": 2,
    "guzzler": 2,
    "guzzler's": 3,
    "guzzler's(1)": 2,
    "guzzlers": 3,
    "guzzlers(1)": 2,
    "guzzles": 2,
    "guzzling": 3,
    "guzzling(1)": 2,
    "guzzo": 2,
    "gvaryahu": 4,
    "gwaltney": 2,
    "gwartney": 2,
    "gway": 1,
    "gway(1)": 2,
    "gwen": 1,
    "gwenda": 2,
    "gwendolyn": 3,
    "gwennie": 2,
    "gwenore": 2,
    "gwin": 1,
    "gwinn": 1,
    "gwinn's": 1,
    "gwinner": 2,
    "gwinnett": 2,
    "gwizdala": 3,
    "gwozdz": 1,
    "gwyn": 1,
    "gwyneth": 2,
    "gwyneth's": 2,
    "gwyneths": 2,
    "gwynn": 1,
    "gwynne": 1,
    "gyger": 2,
    "gyi": 1,
    "gyi(1)": 3,
    "gyles": 1,
    "gyllenhammar": 4,
    "gym": 1,
    "gym's": 1,
    "gymboree": 3,
    "gymnasia": 4,
    "gymnasium": 4,
    "gymnasiums": 4,
    "gymnast": 2,
    "gymnastic": 3,
    "gymnastics": 3,
    "gymnasts": 2,
    "gyms": 1,
    "gyn": 1,
    "gyn(1)": 1,
    "gynecologic": 5,
    "gynecological": 6,
    "gynecologist": 5,
    "gynecologists": 5,
    "gynecology": 5,
    "gynex": 2,
    "gyohten": 2,
    "gyosai": 2,
    "gyp": 1,
    "gypped": 1,
    "gypsies": 2,
    "gypsum": 2,
    "gypsum's": 2,
    "gypsy": 2,
    "gyr": 1,
    "gyrate": 2,
    "gyrated": 3,
    "gyrates": 2,
    "gyrating": 3,
    "gyration": 3,
    "gyrations": 3,
    "gyro": 2,
    "gyrocompass": 4,
    "gyrodyne": 3,
    "gyrodynes": 3,
    "gyropilot": 4,
    "gyros": 2,
    "gyroscope": 3,
    "gyroscopes": 3,
    "gyroscopic": 4,
    "gytha": 2,
    "gyuhama": 3,
    "h": 1,
    "h's": 2,
    "h.": 1,
    "h.'s": 2,
    "ha": 1,
    "ha(1)": 2,
    "ha'aretz": 2,
    "ha'aretz(1)": 3,
    "ha'etzni": 3,
    "haab": 1,
    "haack": 1,
    "haacke": 1,
    "haaf": 1,
    "haag": 1,
    "haagen": 2,
    "haagenson": 3,
    "haak": 1,
    "haake": 1,
    "haakenson": 3,
    "haaland": 2,
    "haan": 1,
    "haapala": 3,
    "haar": 1,
    "haas": 1,
    "haase": 1,
    "haass": 1,
    "haavelmo": 3,
    "habben": 2,
    "habeas": 3,
    "habeck": 2,
    "habecker": 3,
    "habeeb": 2,
    "habegger": 3,
    "habel": 2,
    "habenicht": 3,
    "haber": 2,
    "haberdashery": 5,
    "haberer": 3,
    "haberkorn": 3,
    "haberl": 2,
    "haberland": 3,
    "haberle": 3,
    "haberman": 3,
    "habermann": 3,
    "habermehl": 3,
    "haberson": 3,
    "haberson(1)": 3,
    "haberstroh": 3,
    "habib": 2,
    "habibi": 3,
    "habibie": 3,
    "habich": 2,
    "habicht": 2,
    "habig": 2,
    "habiger": 3,
    "habit": 2,
    "habitable": 4,
    "habitat": 3,
    "habitat's": 3,
    "habitation": 4,
    "habitats": 3,
    "habits": 2,
    "habitual": 4,
    "habitually": 5,
    "habitually(1)": 4,
    "habitues": 3,
    "hable": 2,
    "habs": 1,
    "habsburg": 2,
    "haby": 2,
    "habyarimana": 6,
    "habyarimana(1)": 6,
    "hach": 1,
    "hachette": 2,
    "hachey": 2,
    "hachtel": 2,
    "hacienda": 4,
    "hack": 1,
    "hackathorn": 3,
    "hackbart": 2,
    "hackbarth": 2,
    "hackberry": 3,
    "hacke": 1,
    "hacked": 1,
    "hackel": 2,
    "hackenberg": 3,
    "hackensack": 3,
    "hacker": 2,
    "hacker's": 2,
    "hackers": 2,
    "hackert": 2,
    "hackett": 2,
    "hackford": 2,
    "hacking": 2,
    "hackl": 2,
    "hackle": 2,
    "hackleman": 3,
    "hackler": 3,
    "hackler(1)": 2,
    "hackles": 2,
    "hackley": 2,
    "hackman": 2,
    "hackman(1)": 2,
    "hackmann": 2,
    "hackmatack": 3,
    "hackney": 2,
    "hackneyed": 2,
    "hacks": 1,
    "hacksaw": 2,
    "hackstaff": 2,
    "hackworth": 2,
    "had": 1,
    "hada": 2,
    "hadad": 2,
    "hadaway": 3,
    "hadd": 1,
    "haddad": 2,
    "haddan": 2,
    "haddaway": 3,
    "hadden": 2,
    "haddock": 2,
    "haddon": 2,
    "haddonfield": 3,
    "haddow": 2,
    "hade": 1,
    "haden": 2,
    "hader": 2,
    "hades": 2,
    "hades(1)": 1,
    "hadfield": 2,
    "hadid": 2,
    "hadleigh": 2,
    "hadler": 3,
    "hadler(1)": 2,
    "hadley": 2,
    "hadline": 2,
    "hadlock": 2,
    "hadn't": 2,
    "hadn't(1)": 2,
    "hadnot": 2,
    "hadoya": 3,
    "hadria": 3,
    "hadrian": 3,
    "hadrian(1)": 3,
    "hadrian's": 3,
    "hadron": 2,
    "hadsall": 2,
    "hadsell": 2,
    "hadson": 2,
    "hadwin": 2,
    "haeberle": 3,
    "haecker": 2,
    "haefele": 2,
    "haeffner": 2,
    "haefner": 2,
    "haegele": 2,
    "haeger": 2,
    "haen": 1,
    "haenel": 2,
    "haering": 3,
    "haertel": 2,
    "haese": 1,
    "haessly": 2,
    "haeussler": 2,
    "hafele": 2,
    "hafeman": 2,
    "hafen": 2,
    "hafer": 2,
    "hafey": 2,
    "hafez": 2,
    "haff": 1,
    "haffey": 2,
    "haffez": 2,
    "haffner": 2,
    "hafford": 2,
    "hafif": 2,
    "hafif's": 2,
    "hafley": 2,
    "hafner": 2,
    "hafnia": 3,
    "hafnium": 3,
    "haft": 1,
    "haft's": 1,
    "haft's(1)": 1,
    "hafta": 2,
    "hafts": 1,
    "hafts(1)": 1,
    "hafts'": 1,
    "hafts'(1)": 1,
    "hag": 1,
    "haga": 2,
    "hagadorn": 3,
    "hagaman": 3,
    "hagan": 2,
    "hagans": 2,
    "hagar": 2,
    "hagar(1)": 2,
    "hagarty": 3,
    "hagberg": 2,
    "hage": 1,
    "hagedorn": 3,
    "hagee": 2,
    "hagel": 2,
    "hagelin": 3,
    "hageman": 2,
    "hagemann": 2,
    "hagemeier": 4,
    "hagemeister": 4,
    "hagemeyer": 4,
    "hagen": 2,
    "hagenbuch": 3,
    "hagenlocker": 4,
    "hagenow": 3,
    "hagens": 2,
    "hager": 2,
    "hagerman": 3,
    "hagerstown": 3,
    "hagerty": 3,
    "hagewood": 2,
    "hagey": 2,
    "hagfish": 2,
    "hagg": 1,
    "haggadah": 3,
    "haggan": 2,
    "haggar": 2,
    "haggard": 2,
    "haggart": 2,
    "haggarty": 3,
    "hagge": 1,
    "haggerty": 3,
    "haggett": 2,
    "haggins": 2,
    "haggle": 2,
    "haggled": 2,
    "haggling": 3,
    "haggling(1)": 2,
    "hagglund": 2,
    "haggstrom": 2,
    "hagin": 2,
    "hagin(1)": 2,
    "hagins": 2,
    "hagins(1)": 2,
    "hagiography": 5,
    "hagiwara": 4,
    "hagle": 2,
    "hagler": 2,
    "hagley": 2,
    "haglund": 2,
    "hagman": 2,
    "hagmann": 2,
    "hagner": 2,
    "hagood": 2,
    "hagopian": 4,
    "hagstrom": 2,
    "hague": 1,
    "hagwood": 2,
    "hagy": 2,
    "hah": 1,
    "hahl": 1,
    "hahm": 1,
    "hahn": 1,
    "hahne": 1,
    "hahner": 2,
    "hahs": 1,
    "haid": 1,
    "haida": 2,
    "haidee": 2,
    "haider": 2,
    "haidet": 2,
    "haifa": 2,
    "haifong": 2,
    "haig": 1,
    "haig's": 1,
    "haigh": 1,
    "haight": 1,
    "haigler": 2,
    "haik": 1,
    "haiku": 2,
    "haikus": 2,
    "hail": 1,
    "hailand": 2,
    "haile": 1,
    "haile(1)": 2,
    "hailed": 1,
    "hailes": 1,
    "hailes(1)": 2,
    "hailey": 2,
    "hailing": 2,
    "hails": 1,
    "hailstone": 2,
    "hailstones": 2,
    "hailstorm": 2,
    "haim": 1,
    "haim(1)": 1,
    "haimes": 1,
    "haimovitch": 3,
    "haimovitz": 3,
    "haimowitz": 3,
    "hain": 1,
    "hainan": 2,
    "hainer": 2,
    "haines": 1,
    "hainey": 2,
    "hainley": 2,
    "hainline": 2,
    "hains": 1,
    "hainsworth": 2,
    "hair": 1,
    "hair's": 1,
    "haircut": 2,
    "haircuts": 2,
    "hairdo": 2,
    "hairdos": 2,
    "hairdresser": 3,
    "hairdressers": 3,
    "hairdressing": 3,
    "haire": 1,
    "haired": 1,
    "hairfield": 2,
    "hairgrove": 2,
    "hairiness": 3,
    "hairless": 2,
    "hairline": 2,
    "hairr": 1,
    "hairs": 1,
    "hairspray": 2,
    "hairston": 2,
    "hairstyle": 2,
    "hairy": 2,
    "haisley": 2,
    "haislip": 2,
    "haist": 2,
    "hait": 1,
    "haith": 1,
    "haithcock": 2,
    "haiti": 2,
    "haiti's": 2,
    "haitian": 2,
    "haitians": 2,
    "haitien": 2,
    "haitiens": 2,
    "haitis": 2,
    "haizlip": 2,
    "hajdu": 2,
    "hajduk": 2,
    "hajek": 2,
    "hajime": 3,
    "hajj": 1,
    "hajjar": 2,
    "hakala": 3,
    "hakan": 2,
    "hakan(1)": 2,
    "hakanson": 3,
    "hake": 1,
    "hakeem": 2,
    "hakeem's": 2,
    "hakes": 1,
    "hakim": 2,
    "hakim(1)": 2,
    "hakim's": 2,
    "hakim's(1)": 2,
    "hakki": 2,
    "hakko": 2,
    "hakon": 2,
    "hakuhodo": 4,
    "hal": 1,
    "hal's": 1,
    "halama": 3,
    "halamandaris": 5,
    "halas": 2,
    "halasz": 2,
    "halbach": 2,
    "halberg": 2,
    "halberstadt": 3,
    "halberstam": 3,
    "halbert": 2,
    "halbig": 2,
    "halbrook": 2,
    "halbrooks": 2,
    "halbur": 2,
    "halbutogullari": 6,
    "halcion": 3,
    "halcion's": 3,
    "halcomb": 2,
    "halcyon": 3,
    "halcyone": 3,
    "hald": 1,
    "haldan": 2,
    "haldana": 3,
    "haldeman": 2,
    "haldeman(1)": 3,
    "haldeman's": 2,
    "haldeman's(1)": 3,
    "halden": 2,
    "halder": 2,
    "halderman": 3,
    "hale": 1,
    "hale's": 1,
    "halebopp": 2,
    "halen": 2,
    "hales": 1,
    "halevi": 3,
    "halevi(1)": 3,
    "haley": 2,
    "haley's": 2,
    "half": 1,
    "half's": 1,
    "halfacre": 3,
    "halfback": 2,
    "halfbacks": 2,
    "halfdan": 2,
    "halferty": 3,
    "halfhearted": 3,
    "halfhill": 2,
    "halfman": 2,
    "halfmann": 2,
    "halford": 2,
    "halfrida": 3,
    "halftime": 2,
    "halftimes": 2,
    "halftone": 2,
    "halftones": 2,
    "halfway": 2,
    "halfwit": 2,
    "halfwits": 2,
    "halgren": 2,
    "haliburton": 4,
    "halibut": 3,
    "halide": 2,
    "halifa": 3,
    "halifax": 3,
    "halik": 2,
    "halima": 3,
    "halimeda": 4,
    "halite": 2,
    "halko": 2,
    "hall": 1,
    "hall's": 1,
    "halla": 2,
    "halladay": 3,
    "hallahan": 3,
    "hallam": 2,
    "hallanan": 3,
    "hallandale": 3,
    "hallas": 2,
    "hallauer": 3,
    "hallbauer": 2,
    "hallberg": 2,
    "halle": 1,
    "halle(1)": 2,
    "halleck": 2,
    "hallelujah": 4,
    "hallen": 2,
    "hallenbeck": 3,
    "haller": 2,
    "halleran": 3,
    "hallet": 2,
    "hallett": 2,
    "halley": 2,
    "halley(1)": 2,
    "hallford": 2,
    "hallgarten": 3,
    "hallgren": 2,
    "halliburton": 4,
    "halliburton's": 4,
    "halliciforn": 4,
    "halliday": 3,
    "hallie": 2,
    "halligan": 3,
    "hallin": 2,
    "hallinan": 3,
    "halling": 2,
    "hallingby": 3,
    "hallisey": 3,
    "hallman": 2,
    "hallmark": 2,
    "hallmark's": 2,
    "hallmarks": 2,
    "hallock": 2,
    "halloran": 3,
    "hallow": 2,
    "halloway": 3,
    "hallowe'en": 3,
    "hallowed": 2,
    "halloween": 3,
    "hallowell": 3,
    "hallows": 2,
    "hallquist": 2,
    "halls": 1,
    "hallstrom": 2,
    "hallucinate": 4,
    "hallucinated": 5,
    "hallucinates": 4,
    "hallucinating": 5,
    "hallucinating(1)": 5,
    "hallucination": 5,
    "hallucinations": 5,
    "hallucinatory": 6,
    "hallucinogenic": 6,
    "hallum": 2,
    "hallums": 2,
    "hallward": 2,
    "hallway": 2,
    "hallways": 2,
    "hallwood": 2,
    "hally": 2,
    "halm": 1,
    "halmi": 2,
    "halmos": 2,
    "halmstad": 2,
    "halo": 2,
    "halogen": 3,
    "halogenate": 4,
    "halogenated": 5,
    "halon": 2,
    "halophytic": 4,
    "halos": 2,
    "halper": 2,
    "halperin": 3,
    "halperin(1)": 2,
    "halpern": 2,
    "halperstant": 3,
    "halpert": 2,
    "halpin": 2,
    "halprin": 2,
    "halsell": 2,
    "halseth": 2,
    "halsey": 2,
    "halstead": 2,
    "halsted": 2,
    "halston": 2,
    "halston's": 2,
    "halt": 1,
    "halted": 2,
    "halted(1)": 2,
    "halteman": 2,
    "halter": 2,
    "halter's": 2,
    "halterman": 3,
    "halters": 2,
    "halting": 2,
    "haltingly": 3,
    "haltiwanger": 4,
    "haltom": 2,
    "halton": 2,
    "halts": 1,
    "haluska": 3,
    "halve": 1,
    "halved": 1,
    "halverson": 3,
    "halves": 1,
    "halving": 2,
    "halvorsen": 3,
    "halvorson": 3,
    "ham": 1,
    "hama": 2,
    "hamacher": 3,
    "hamad": 2,
    "hamada": 3,
    "hamadei": 3,
    "hamadi": 3,
    "hamaker": 3,
    "hamal": 2,
    "hamamoto": 4,
    "haman": 2,
    "hamanaka": 4,
    "hamann": 2,
    "hamar": 2,
    "hamas": 2,
    "hamas'": 2,
    "hamasaki": 4,
    "hambelton": 3,
    "hamberg": 2,
    "hamberger": 3,
    "hamblen": 3,
    "hamblet": 2,
    "hambleton": 3,
    "hambley": 2,
    "hamblin": 2,
    "hambly": 2,
    "hambrecht": 2,
    "hambrick": 2,
    "hambright": 2,
    "hambro": 2,
    "hambros": 2,
    "hamburg": 2,
    "hamburger": 3,
    "hamburgers": 3,
    "hamby": 2,
    "hamdan": 2,
    "hamdoon": 2,
    "hamdun": 2,
    "hamed": 1,
    "hameister": 3,
    "hamel": 2,
    "hamelin": 3,
    "hamelin(1)": 2,
    "hamer": 2,
    "hames": 1,
    "hamid": 2,
    "hamiel": 2,
    "hamil": 2,
    "hamill": 2,
    "hamilton": 3,
    "hamilton's": 3,
    "hamiltons": 3,
    "hamish": 2,
    "hamiter": 3,
    "hamitic": 3,
    "hamler": 3,
    "hamler(1)": 2,
    "hamlet": 2,
    "hamlet(1)": 2,
    "hamlets": 2,
    "hamlett": 2,
    "hamley": 2,
    "hamley's": 2,
    "hamlin": 2,
    "hamling": 2,
    "hamlisch": 2,
    "hamlisch's": 3,
    "hamm": 1,
    "hammac": 2,
    "hammacher": 3,
    "hammack": 2,
    "hammaker": 3,
    "hamman": 2,
    "hammann": 2,
    "hammar": 2,
    "hammas": 2,
    "hammas'": 2,
    "hammas's": 3,
    "hamme": 1,
    "hammel": 2,
    "hammell": 2,
    "hammen": 2,
    "hammer": 2,
    "hammer's": 2,
    "hammered": 2,
    "hammering": 3,
    "hammerle": 3,
    "hammerlock": 3,
    "hammerman": 3,
    "hammermeister": 4,
    "hammermill": 3,
    "hammers": 2,
    "hammerschmidt": 3,
    "hammersley": 3,
    "hammersmith": 3,
    "hammerson": 3,
    "hammerstein": 3,
    "hammerstein(1)": 3,
    "hammerstein's": 3,
    "hammerstein's(1)": 3,
    "hammerstrom": 3,
    "hammes": 1,
    "hammett": 2,
    "hammill": 2,
    "hammitt": 2,
    "hammock": 2,
    "hammocks": 2,
    "hammon": 2,
    "hammond": 2,
    "hammonds": 2,
    "hammons": 2,
    "hammontree": 3,
    "hamner": 2,
    "hamon": 2,
    "hamor": 2,
    "hamp": 1,
    "hampe": 1,
    "hampel": 2,
    "hamper": 2,
    "hampered": 2,
    "hampering": 3,
    "hampers": 2,
    "hample": 2,
    "hampshire": 2,
    "hampshire(1)": 2,
    "hampshire(2)": 3,
    "hampshire(3)": 3,
    "hampshire's": 2,
    "hampshire's(1)": 2,
    "hampshire's(2)": 3,
    "hampshire's(3)": 3,
    "hampshirites": 3,
    "hampson": 2,
    "hampstead": 2,
    "hampton": 2,
    "hampton's": 2,
    "hamptons": 2,
    "hamptonshire": 3,
    "hamptonshire's": 3,
    "hamre": 2,
    "hamric": 2,
    "hamrick": 2,
    "hamrock": 2,
    "hams": 1,
    "hamsher": 2,
    "hamson": 2,
    "hamsphire": 2,
    "hamster": 2,
    "hamsters": 2,
    "hamstra": 2,
    "hamstring": 2,
    "hamstrings": 2,
    "hamstrung": 2,
    "hamtramck": 3,
    "han": 1,
    "han(1)": 1,
    "han's": 1,
    "han's(1)": 1,
    "hana": 2,
    "hanafin": 3,
    "hanagan": 3,
    "hanahan": 3,
    "hanak": 2,
    "hanan": 2,
    "hanas": 2,
    "hanauer": 3,
    "hanawalt": 3,
    "hanaway": 3,
    "hanback": 2,
    "hanberry": 3,
    "hanbo": 2,
    "hanbury": 3,
    "hanby": 2,
    "hance": 1,
    "hancher": 2,
    "hanchett": 2,
    "hanchey": 2,
    "hancock": 2,
    "hancock's": 2,
    "hancox": 2,
    "hand": 1,
    "handa": 2,
    "handbag": 2,
    "handbags": 2,
    "handball": 2,
    "handballs": 2,
    "handbill": 2,
    "handbills": 2,
    "handbook": 2,
    "handbooks": 2,
    "handclasp": 2,
    "handcraft": 2,
    "handcrafted": 3,
    "handcrafts": 2,
    "handcuff": 2,
    "handcuffed": 2,
    "handcuffing": 3,
    "handcuffs": 2,
    "handed": 2,
    "handed(1)": 2,
    "handedly": 3,
    "handedness": 3,
    "handel": 2,
    "handel's": 2,
    "handeland": 3,
    "handelman": 3,
    "handels": 2,
    "handelsbank": 3,
    "handelsbanken": 4,
    "handelsman": 3,
    "hander": 2,
    "handers": 2,
    "handford": 2,
    "handful": 2,
    "handfuls": 2,
    "handgun": 2,
    "handguns": 2,
    "handheld": 2,
    "handhold": 2,
    "handholding": 3,
    "handicap": 3,
    "handicapped": 3,
    "handicapper": 4,
    "handicappers": 4,
    "handicapping": 4,
    "handicaps": 3,
    "handicraft": 3,
    "handicrafts": 3,
    "handier": 3,
    "handiest": 3,
    "handily": 3,
    "handing": 2,
    "handiwork": 3,
    "handke": 2,
    "handkerchief": 3,
    "handkerchief(1)": 3,
    "handkerchiefs": 3,
    "handkerchiefs(1)": 3,
    "handle": 2,
    "handlebar": 3,
    "handlebars": 3,
    "handled": 2,
    "handler": 2,
    "handler(1)": 3,
    "handlers": 2,
    "handlers(1)": 3,
    "handles": 2,
    "handley": 2,
    "handlin": 2,
    "handling": 2,
    "handling(1)": 3,
    "handlon": 2,
    "handloom": 2,
    "handlooms": 2,
    "handly": 2,
    "handmade": 2,
    "handmade(1)": 2,
    "handout": 2,
    "handouts": 2,
    "handover": 3,
    "handpick": 2,
    "handpicked": 2,
    "handrail": 2,
    "handrails": 2,
    "handrich": 2,
    "handros": 2,
    "hands": 1,
    "hands(1)": 1,
    "handsaw": 2,
    "handsaws": 2,
    "handset": 2,
    "handsets": 2,
    "handshake": 2,
    "handshakes": 2,
    "handshaking": 3,
    "handsome": 2,
    "handsomely": 3,
    "handstand": 2,
    "handstands": 2,
    "handwerk": 2,
    "handwerker": 3,
    "handwoven": 3,
    "handwoven(1)": 3,
    "handwriting": 3,
    "handwritten": 3,
    "handy": 2,
    "handyman": 3,
    "handymen": 3,
    "hane": 1,
    "haneda": 3,
    "hanel": 2,
    "haneline": 3,
    "hanemann": 2,
    "haner": 2,
    "hanes": 1,
    "haney": 2,
    "hanf": 1,
    "hanford": 2,
    "hanft": 1,
    "hang": 1,
    "hangar": 2,
    "hangars": 2,
    "hangartner": 3,
    "hanged": 1,
    "hangen": 2,
    "hanger": 2,
    "hangers": 2,
    "hangin'": 2,
    "hanging": 2,
    "hanging(1)": 2,
    "hangings": 2,
    "hangman": 2,
    "hangout": 2,
    "hangouts": 2,
    "hangover": 3,
    "hangovers": 3,
    "hangs": 1,
    "hangsang": 2,
    "hangsang's": 2,
    "hangul": 2,
    "hangup": 2,
    "hangups": 2,
    "hani": 2,
    "hani's": 2,
    "hanifen": 3,
    "hanifin": 3,
    "hanigan": 3,
    "haning": 2,
    "hanisch": 2,
    "hanisee": 3,
    "hanish": 2,
    "hanjin": 2,
    "hank": 1,
    "hank's": 1,
    "hanke": 1,
    "hankel": 2,
    "hanken": 2,
    "hanker": 2,
    "hankering": 3,
    "hankerson": 3,
    "hankes": 1,
    "hankey": 2,
    "hankin": 2,
    "hankins": 2,
    "hankinson": 3,
    "hankla": 2,
    "hanko": 2,
    "hanks": 1,
    "hanky": 2,
    "hanley": 2,
    "hanley's": 2,
    "hanlin": 2,
    "hanlon": 2,
    "hanly": 2,
    "hanmer": 2,
    "hann": 1,
    "hanna": 2,
    "hanna's": 2,
    "hannaford": 3,
    "hannagan": 3,
    "hannah": 2,
    "hannahs": 2,
    "hannam": 2,
    "hannaman": 3,
    "hannan": 2,
    "hannay": 2,
    "hanneken": 3,
    "hanneman": 2,
    "hannemann": 2,
    "hannen": 2,
    "hanner": 2,
    "hanners": 2,
    "hannes": 1,
    "hannesson": 3,
    "hanney": 2,
    "hanni": 2,
    "hannibal": 3,
    "hannie": 2,
    "hannifin": 3,
    "hannig": 2,
    "hannigan": 3,
    "hanning": 2,
    "hannis": 2,
    "hannity": 3,
    "hannoch": 2,
    "hannold": 2,
    "hannon": 2,
    "hannula": 3,
    "hannum": 2,
    "hanny": 2,
    "hano": 2,
    "hanoi": 2,
    "hanoi's": 2,
    "hanold": 2,
    "hanover": 3,
    "hanover's": 3,
    "hanoverian": 5,
    "hanrahan": 3,
    "hanratty": 3,
    "hans": 1,
    "hans(1)": 1,
    "hansa": 2,
    "hansard": 2,
    "hansberger": 3,
    "hansberry": 3,
    "hansbrough": 2,
    "hansbury": 3,
    "hansche": 2,
    "hanscom": 2,
    "hanseatic": 4,
    "hansel": 2,
    "hansell": 2,
    "hanselman": 3,
    "hansen": 2,
    "hansen's": 2,
    "hanser": 2,
    "hansford": 2,
    "hanshaw": 2,
    "hanshew": 2,
    "hanshin": 2,
    "hansley": 2,
    "hansma": 2,
    "hansman": 2,
    "hansmann": 2,
    "hansom": 2,
    "hanson": 2,
    "hanson's": 2,
    "hanssen": 2,
    "hansson": 2,
    "hanta": 2,
    "hanta(1)": 2,
    "hantavirus": 4,
    "hanten": 2,
    "hanthorn": 2,
    "hantman": 2,
    "hantz": 1,
    "hanukkah": 3,
    "hanukkah's": 3,
    "hanukkahs": 3,
    "hanus": 2,
    "hanvey": 2,
    "hanwa": 2,
    "hanwa's": 2,
    "hanway": 2,
    "hany": 2,
    "hany's": 2,
    "hanzel": 2,
    "hanzlik": 2,
    "hao": 1,
    "hao-chi": 2,
    "hap": 1,
    "hapag": 2,
    "hapeman": 2,
    "hapgood": 2,
    "haphazard": 3,
    "haphazardly": 4,
    "haphazardly(1)": 4,
    "hapke": 2,
    "hapless": 2,
    "haploid": 2,
    "hapner": 2,
    "hapoalim": 3,
    "hapoalim(1)": 4,
    "happ": 1,
    "happe": 1,
    "happel": 2,
    "happen": 2,
    "happened": 2,
    "happening": 3,
    "happening(1)": 2,
    "happenings": 3,
    "happenings(1)": 2,
    "happens": 2,
    "happenstance": 3,
    "happier": 3,
    "happiest": 3,
    "happily": 3,
    "happiness": 3,
    "happy": 2,
    "hapsburg": 2,
    "haq": 1,
    "haq's": 1,
    "haque": 1,
    "har": 1,
    "hara": 2,
    "hara-kiri": 4,
    "harada": 3,
    "haradim": 3,
    "haradim(1)": 3,
    "harahan": 3,
    "harald": 2,
    "haralda": 3,
    "haralson": 3,
    "haran": 2,
    "harangue": 2,
    "harangued": 2,
    "harangues": 2,
    "haranguing": 3,
    "harare": 3,
    "harass": 2,
    "harassed": 2,
    "harasser": 3,
    "harassers": 3,
    "harasses": 3,
    "harassing": 3,
    "harassment": 3,
    "haraszti": 3,
    "haraway": 3,
    "harb": 1,
    "harbach": 2,
    "harbaugh": 2,
    "harbeck": 2,
    "harber": 2,
    "harbert": 2,
    "harberts": 2,
    "harbeson": 3,
    "harbin": 2,
    "harbinger": 3,
    "harbingers": 3,
    "harbinson": 3,
    "harbison": 3,
    "harbold": 2,
    "harbor": 2,
    "harbor's": 2,
    "harbored": 2,
    "harboring": 3,
    "harbors": 2,
    "harborside": 3,
    "harbory": 3,
    "harbour": 2,
    "harbuck": 2,
    "harbury": 3,
    "harc": 1,
    "harclerode": 4,
    "harclerode(1)": 3,
    "harcourt": 2,
    "harcourt's": 2,
    "harcrow": 2,
    "harcum": 2,
    "hard": 1,
    "hardacre": 3,
    "hardage": 2,
    "hardart": 2,
    "hardaway": 3,
    "hardback": 2,
    "hardball": 2,
    "hardboard": 2,
    "hardcastle": 3,
    "hardcastle's": 3,
    "hardcore": 2,
    "hardcover": 3,
    "hardcovers": 3,
    "hardebeck": 2,
    "hardee": 2,
    "hardee's": 2,
    "hardegree": 3,
    "hardeman": 2,
    "harden": 2,
    "harden's": 2,
    "hardenbrook": 3,
    "hardened": 2,
    "hardener": 3,
    "hardeners": 3,
    "hardening": 3,
    "hardening(1)": 2,
    "hardens": 2,
    "harder": 2,
    "harders": 2,
    "hardest": 2,
    "hardesty": 3,
    "hardey": 2,
    "hardgood": 2,
    "hardgoods": 2,
    "hardgrave": 2,
    "hardgrove": 2,
    "hardhead": 2,
    "hardheaded": 3,
    "hardick": 2,
    "hardie": 2,
    "hardier": 3,
    "hardiest": 3,
    "hardigree": 3,
    "hardiman": 3,
    "hardimon": 3,
    "hardin": 2,
    "harding": 2,
    "harding's": 2,
    "hardinger": 3,
    "hardison": 3,
    "hardister": 3,
    "hardisty": 3,
    "hardline": 2,
    "hardliner": 3,
    "hardliners": 3,
    "hardly": 2,
    "hardman": 2,
    "hardness": 2,
    "hardnett": 2,
    "hardpressed": 2,
    "hardrick": 2,
    "hards": 1,
    "hardscrabble": 3,
    "hardship": 2,
    "hardships": 2,
    "hardt": 1,
    "hardtke": 2,
    "hardware": 2,
    "hardway": 2,
    "hardwick": 2,
    "hardwicke": 2,
    "hardwin": 2,
    "hardwood": 2,
    "hardwoods": 2,
    "hardwork": 2,
    "hardworking": 3,
    "hardy": 2,
    "hardy's": 2,
    "hardymon": 3,
    "hare": 1,
    "hare's": 1,
    "harebrained": 2,
    "harelson": 3,
    "harem": 2,
    "haren": 2,
    "harer": 2,
    "hares": 1,
    "harewood": 2,
    "harff": 1,
    "harford": 2,
    "hargadon": 3,
    "hargan": 2,
    "hargarten": 3,
    "hargens": 2,
    "harger": 2,
    "hargett": 2,
    "hargis": 2,
    "hargrave": 2,
    "hargraves": 2,
    "hargreaves": 2,
    "hargrove": 2,
    "hargus": 2,
    "hari": 2,
    "harig": 2,
    "harima": 3,
    "haring": 2,
    "hariri": 3,
    "haris": 2,
    "haris(1)": 2,
    "haritos": 3,
    "hariz": 2,
    "harjo": 2,
    "harju": 2,
    "hark": 1,
    "harkavy": 3,
    "harke": 1,
    "harken": 2,
    "harker": 2,
    "harkey": 2,
    "harkin": 2,
    "harkin's": 2,
    "harking": 2,
    "harkins": 2,
    "harkleroad": 3,
    "harkless": 2,
    "harkness": 2,
    "harkrader": 3,
    "harkrider": 3,
    "harks": 1,
    "harl": 1,
    "harlacher": 3,
    "harlan": 2,
    "harland": 2,
    "harle": 2,
    "harlem": 2,
    "harlem's": 2,
    "harleman": 3,
    "harlequin": 3,
    "harless": 2,
    "harley": 2,
    "harley's": 2,
    "harleysville": 3,
    "harlin": 2,
    "harlin's": 2,
    "harling": 2,
    "harlingen": 3,
    "harlison": 3,
    "harloff": 2,
    "harlot": 2,
    "harlow": 2,
    "harm": 1,
    "harm's": 1,
    "harman": 2,
    "harmata": 3,
    "harmattan": 3,
    "harmed": 1,
    "harmel": 2,
    "harmen": 2,
    "harmening": 3,
    "harmer": 2,
    "harmes": 1,
    "harmetz": 2,
    "harmeyer": 3,
    "harmful": 2,
    "harmfully": 3,
    "harmfulness": 3,
    "harming": 2,
    "harmison": 3,
    "harmless": 2,
    "harmlessly": 3,
    "harmon": 2,
    "harmon's": 2,
    "harmonia": 4,
    "harmonic": 3,
    "harmonica": 4,
    "harmonics": 3,
    "harmonie": 3,
    "harmonies": 3,
    "harmonious": 4,
    "harmoniously": 5,
    "harmonium": 4,
    "harmonization": 5,
    "harmonize": 3,
    "harmonized": 3,
    "harmonizes": 4,
    "harmonizing": 4,
    "harmony": 3,
    "harms": 1,
    "harmsen": 2,
    "harn": 1,
    "harnack": 2,
    "harnage": 2,
    "harnden": 2,
    "harne": 1,
    "harned": 1,
    "harner": 2,
    "harness": 2,
    "harness(1)": 2,
    "harnessed": 2,
    "harnesses": 3,
    "harnesses(1)": 3,
    "harnessing": 3,
    "harnett": 2,
    "harney": 2,
    "harnisch": 2,
    "harnischfeger": 4,
    "harnischfeger's": 4,
    "harnish": 2,
    "harnois": 2,
    "haro": 2,
    "harold": 2,
    "harold's": 2,
    "haroldson": 3,
    "harp": 1,
    "harpe": 1,
    "harped": 1,
    "harpel": 2,
    "harpenau": 3,
    "harper": 2,
    "harper's": 2,
    "harpercollins": 4,
    "harpers": 2,
    "harpham": 2,
    "harpin": 2,
    "harping": 2,
    "harpist": 2,
    "harpists": 2,
    "harpley": 2,
    "harpo": 2,
    "harpold": 2,
    "harpole": 2,
    "harpoon": 2,
    "harpoons": 2,
    "harpootlian": 4,
    "harps": 1,
    "harpsichord": 3,
    "harpst": 1,
    "harpster": 2,
    "harquebus": 3,
    "harr": 1,
    "harra": 2,
    "harrah": 2,
    "harrah's": 2,
    "harral": 2,
    "harralson": 3,
    "harre": 1,
    "harrel": 2,
    "harreld": 2,
    "harrell": 2,
    "harrell's": 2,
    "harrelson": 3,
    "harren": 2,
    "harrer": 2,
    "harried": 2,
    "harrier": 3,
    "harries": 2,
    "harriet": 3,
    "harriette": 3,
    "harrigan": 3,
    "harriger": 3,
    "harrill": 2,
    "harriman": 3,
    "harring": 2,
    "harrington": 3,
    "harriott": 3,
    "harris": 2,
    "harris'": 2,
    "harris's": 3,
    "harrisburg": 3,
    "harrisburg(1)": 3,
    "harrisburg's": 3,
    "harrisburg's(1)": 3,
    "harrisburgh": 3,
    "harrisburgh(1)": 3,
    "harrisburgh's": 3,
    "harrisburgh's(1)": 3,
    "harrises": 3,
    "harrison": 3,
    "harrison's": 3,
    "harriss": 2,
    "harrity": 3,
    "harrod": 2,
    "harrod's": 2,
    "harrods": 2,
    "harrold": 2,
    "harron": 2,
    "harrop": 2,
    "harroun": 2,
    "harrow": 2,
    "harrower": 3,
    "harrowing": 3,
    "harry": 2,
    "harry's": 2,
    "harryman": 3,
    "harsch": 1,
    "harsco": 2,
    "harsh": 1,
    "harsha": 2,
    "harsham": 2,
    "harshaw": 2,
    "harshbarger": 3,
    "harshberger": 3,
    "harsher": 2,
    "harshest": 2,
    "harshfield": 2,
    "harshly": 2,
    "harshman": 2,
    "harshness": 2,
    "harstad": 2,
    "harston": 2,
    "hart": 1,
    "hart's": 1,
    "harte": 1,
    "hartel": 2,
    "hartell": 2,
    "harten": 2,
    "hartenstein": 3,
    "hartenstein(1)": 3,
    "harter": 2,
    "hartfiel": 2,
    "hartfield": 2,
    "hartford": 2,
    "hartford's": 2,
    "hartgraves": 2,
    "hartgrove": 2,
    "harth": 1,
    "hartig": 2,
    "hartigan": 3,
    "hartin": 2,
    "harting": 2,
    "hartinger": 3,
    "hartis": 2,
    "hartje": 2,
    "hartke": 2,
    "hartkopf": 2,
    "hartl": 2,
    "hartlage": 2,
    "hartland": 2,
    "hartlaub": 2,
    "hartle": 2,
    "hartless": 2,
    "hartley": 2,
    "hartlieb": 2,
    "hartline": 2,
    "hartling": 2,
    "hartman": 2,
    "hartmann": 2,
    "hartmarx": 2,
    "hartnell": 2,
    "hartner": 2,
    "hartness": 2,
    "hartnett": 2,
    "hartney": 2,
    "hartog": 2,
    "harton": 2,
    "hartong": 2,
    "hartranft": 2,
    "harts": 1,
    "hartsell": 2,
    "hartsfield": 2,
    "hartshorn": 2,
    "hartshorne": 2,
    "hartsock": 2,
    "hartsoe": 2,
    "hartson": 2,
    "hartsook": 2,
    "hartsough": 2,
    "hartstein": 2,
    "hartstein(1)": 2,
    "hartsville": 2,
    "hartt": 1,
    "hartter": 2,
    "hartung": 2,
    "hartwell": 2,
    "hartwick": 2,
    "hartwig": 2,
    "hartwood": 2,
    "harty": 2,
    "hartz": 1,
    "hartzel": 2,
    "hartzell": 2,
    "hartzler": 2,
    "hartzog": 2,
    "haruo": 3,
    "harv": 1,
    "harvard": 2,
    "harvard's": 2,
    "harvath": 2,
    "harve": 1,
    "harvel": 2,
    "harvell": 2,
    "harvest": 2,
    "harvestable": 4,
    "harvested": 3,
    "harvested(1)": 3,
    "harvester": 3,
    "harvesters": 3,
    "harvesting": 3,
    "harvests": 2,
    "harvey": 2,
    "harvey's": 2,
    "harvie": 2,
    "harvill": 2,
    "harville": 2,
    "harvin": 2,
    "harvison": 3,
    "harward": 2,
    "harwell": 2,
    "harwick": 2,
    "harwood": 2,
    "haryana": 3,
    "has": 1,
    "has(1)": 1,
    "has-been": 2,
    "has-beens": 2,
    "hasan": 2,
    "hasbro": 2,
    "hasbro's": 2,
    "hasbrook": 2,
    "hasbrouck": 2,
    "hascall": 2,
    "hasch": 1,
    "haschke": 1,
    "hase": 1,
    "hasegawa": 4,
    "hasek": 2,
    "haselden": 3,
    "haseley": 3,
    "haselhorst": 3,
    "haseltine": 3,
    "haselton": 3,
    "haseman": 2,
    "hasenauer": 4,
    "hasenfus": 3,
    "haser": 2,
    "hash": 1,
    "hashagen": 3,
    "hashed": 1,
    "hashem": 2,
    "hashemi": 3,
    "hashemite": 3,
    "hasher": 2,
    "hasher's": 2,
    "hashers": 2,
    "hashes": 2,
    "hashi": 2,
    "hashim": 2,
    "hashimoto": 4,
    "hashing": 2,
    "hashish": 2,
    "hashish(1)": 2,
    "hashman": 2,
    "hashmark": 2,
    "hashmi": 2,
    "hashmi(1)": 2,
    "hasidic": 3,
    "hasidic(1)": 3,
    "hasidim": 3,
    "hasidim(1)": 3,
    "haske": 1,
    "haskell": 2,
    "haskett": 2,
    "haskew": 2,
    "haskin": 2,
    "haskins": 2,
    "haslam": 2,
    "hasler": 3,
    "hasler(1)": 2,
    "haslett": 2,
    "hasley": 2,
    "hasman": 2,
    "hasn't": 2,
    "haso": 2,
    "haso's": 2,
    "haspel": 2,
    "hass": 1,
    "hassan": 2,
    "hasse": 1,
    "hassebrock": 3,
    "hassel": 2,
    "hasselbach": 3,
    "hasselbring": 3,
    "hassell": 2,
    "hasselman": 3,
    "hassen": 2,
    "hassenberg": 3,
    "hassenfeld": 3,
    "hassett": 2,
    "hassey": 2,
    "hassig": 2,
    "hassing": 2,
    "hassinger": 3,
    "hassle": 2,
    "hassled": 2,
    "hassler": 2,
    "hassles": 2,
    "hassling": 3,
    "hassling(1)": 2,
    "hassman": 2,
    "hasson": 2,
    "hast": 1,
    "hasta": 2,
    "hasta(1)": 2,
    "haste": 1,
    "hasten": 2,
    "hastened": 2,
    "hastening": 3,
    "hastening(1)": 2,
    "hastens": 2,
    "hastert": 2,
    "hastey": 2,
    "hastie": 2,
    "hastily": 3,
    "hasting": 2,
    "hastings": 2,
    "haston": 2,
    "hasty": 2,
    "haswell": 2,
    "hasz": 1,
    "hat": 1,
    "hat's": 1,
    "hata": 2,
    "hatala": 3,
    "hataway": 3,
    "hatch": 1,
    "hatch's": 2,
    "hatchback": 2,
    "hatched": 1,
    "hatchel": 2,
    "hatchell": 2,
    "hatcher": 2,
    "hatcheries": 3,
    "hatchery": 3,
    "hatches": 2,
    "hatchet": 2,
    "hatchets": 2,
    "hatchett": 2,
    "hatching": 2,
    "hate": 1,
    "hated": 2,
    "hated(1)": 2,
    "hateful": 2,
    "hatem": 2,
    "hater": 2,
    "haters": 2,
    "hates": 1,
    "hatfield": 2,
    "hatfield's": 2,
    "hath": 1,
    "hathaway": 3,
    "hathaway's": 3,
    "hathcoat": 2,
    "hathcock": 2,
    "hatheway": 2,
    "hathorn": 2,
    "hathorne": 2,
    "hating": 2,
    "hatler": 3,
    "hatler(1)": 2,
    "hatlestad": 3,
    "hatley": 2,
    "hatmaker": 3,
    "haton": 2,
    "haton(1)": 2,
    "hatred": 2,
    "hatreds": 2,
    "hatrick": 2,
    "hats": 1,
    "hatt": 1,
    "hattabaugh": 3,
    "hattan": 2,
    "hattaway": 3,
    "hatten": 2,
    "hattendorf": 3,
    "hatter": 2,
    "hatteras": 3,
    "hattersley": 3,
    "hattery": 3,
    "hattie": 2,
    "hatton": 2,
    "hattori": 3,
    "hattusas": 3,
    "hatty": 2,
    "hatz": 1,
    "hau": 1,
    "haub": 1,
    "hauber": 2,
    "haubert": 2,
    "haubner": 2,
    "haubrich": 2,
    "hauch": 1,
    "hauck": 1,
    "hauenstein": 3,
    "hauenstein(1)": 3,
    "hauer": 2,
    "haueter": 2,
    "hauf": 1,
    "haufer": 2,
    "hauff": 1,
    "haug": 1,
    "haugan": 2,
    "hauge": 1,
    "haugen": 2,
    "hauger": 2,
    "haugh": 1,
    "haughey": 2,
    "haughn": 1,
    "haught": 1,
    "haughtily": 3,
    "haughton": 2,
    "haughty": 2,
    "haugland": 2,
    "hauk": 1,
    "hauke": 1,
    "haul": 1,
    "hauled": 1,
    "hauler": 2,
    "haulers": 2,
    "hauling": 2,
    "hauls": 1,
    "haulsey": 2,
    "haun": 1,
    "haunt": 1,
    "haunted": 2,
    "haunted(1)": 2,
    "haunting": 2,
    "hauntingly": 3,
    "haunts": 1,
    "haupert": 2,
    "hauppauge": 2,
    "haupt": 1,
    "hauptfuhrer": 3,
    "hauptman": 2,
    "hauptmann": 2,
    "haury": 2,
    "haus": 1,
    "hausa": 2,
    "hausauer": 3,
    "hausch": 1,
    "hauschild": 2,
    "hauschildt": 2,
    "hause": 1,
    "hausen": 2,
    "hauser": 2,
    "hauserman": 3,
    "hausfeld": 2,
    "hausky": 2,
    "hausler": 3,
    "hausler(1)": 2,
    "hausman": 2,
    "hausmann": 2,
    "hausner": 2,
    "hauss": 1,
    "hausser": 2,
    "haussler": 3,
    "haussler(1)": 2,
    "haussmann": 2,
    "hausummi": 3,
    "hauswirth": 2,
    "haut": 1,
    "hautala": 3,
    "haute": 1,
    "haute(1)": 1,
    "hauter": 2,
    "hauth": 1,
    "hauver": 2,
    "havana": 3,
    "havana's": 3,
    "havard": 2,
    "havas": 2,
    "have": 1,
    "havel": 2,
    "havelka": 3,
    "havelock": 2,
    "haveman": 2,
    "havemann": 3,
    "haven": 2,
    "haven't": 2,
    "haven't(1)": 2,
    "havener": 3,
    "havens": 2,
    "haver": 2,
    "haverfield": 3,
    "haverford": 3,
    "haverkamp": 3,
    "haverland": 3,
    "haverly": 3,
    "haverstick": 3,
    "haverstock": 3,
    "haverty": 3,
    "haves": 1,
    "havey": 2,
    "havier": 2,
    "haviland": 3,
    "havill": 2,
    "havilland": 3,
    "havin'": 2,
    "having": 2,
    "havington": 3,
    "havington's": 3,
    "havins": 2,
    "havis": 2,
    "havlicek": 3,
    "havlik": 2,
    "havlin": 2,
    "havner": 2,
    "havoc": 2,
    "havran": 2,
    "havranek": 3,
    "havrilla": 3,
    "havron": 2,
    "haw": 1,
    "hawaii": 3,
    "hawaii's": 3,
    "hawaiian": 3,
    "hawaiians": 3,
    "hawass": 2,
    "hawbaker": 3,
    "hawe": 1,
    "hawes": 1,
    "hawing": 2,
    "hawk": 1,
    "hawkbill": 2,
    "hawkbill's": 2,
    "hawke": 1,
    "hawke's": 1,
    "hawked": 1,
    "hawken": 2,
    "hawker": 2,
    "hawkers": 2,
    "hawkes": 1,
    "hawkey": 2,
    "hawkeye": 2,
    "hawkeye's": 2,
    "hawkiness": 2,
    "hawking": 2,
    "hawkins": 2,
    "hawkins'": 2,
    "hawkinson": 3,
    "hawkish": 2,
    "hawks": 1,
    "hawksley": 2,
    "hawley": 2,
    "hawley's": 2,
    "hawn": 1,
    "haworth": 2,
    "haws": 1,
    "hawthorn": 2,
    "hawthorne": 2,
    "hawthorne's": 2,
    "hawthorns": 2,
    "hawver": 2,
    "haxton": 2,
    "hay": 1,
    "hayashi": 3,
    "hayashida": 4,
    "haycock": 2,
    "haycraft": 2,
    "haydel": 2,
    "hayden": 2,
    "haydn": 2,
    "haydn's": 2,
    "haydock": 2,
    "haydon": 2,
    "haydu": 2,
    "hayduk": 2,
    "haye": 1,
    "hayek": 2,
    "hayen": 2,
    "hayenga": 3,
    "hayer": 2,
    "hayes": 1,
    "hayfield": 2,
    "hayfields": 2,
    "hayford": 2,
    "haygood": 2,
    "hayhurst": 2,
    "haying": 2,
    "hayles": 1,
    "hayley": 2,
    "hayloft": 2,
    "haylofts": 2,
    "haymaker": 3,
    "haymakers": 3,
    "hayman": 2,
    "haymarket": 3,
    "haymarkets": 3,
    "haymes": 1,
    "haymon": 2,
    "haymond": 2,
    "haymore": 2,
    "hayn": 1,
    "hayne": 1,
    "hayner": 2,
    "haynes": 1,
    "haynesworth": 2,
    "haynie": 2,
    "haynsworth": 2,
    "hays": 1,
    "hayse": 1,
    "hayslett": 2,
    "hayslip": 2,
    "haystack": 2,
    "haystacks": 2,
    "hayter": 2,
    "hayton": 2,
    "hayward": 2,
    "hayward's": 2,
    "haywire": 2,
    "haywood": 2,
    "hayworth": 2,
    "hazan": 2,
    "hazard": 2,
    "hazardous": 3,
    "hazards": 2,
    "haze": 1,
    "hazel": 2,
    "hazelbaker": 4,
    "hazelett": 3,
    "hazelett(1)": 2,
    "hazelip": 3,
    "hazell": 2,
    "hazelnut": 3,
    "hazelnuts": 3,
    "hazelrigg": 3,
    "hazelrigg(1)": 3,
    "hazeltine": 3,
    "hazelton": 3,
    "hazelwood": 3,
    "hazelwood's": 3,
    "hazen": 2,
    "hazier": 3,
    "hazing": 2,
    "hazle": 2,
    "hazleton": 3,
    "hazlett": 2,
    "hazlewood": 3,
    "hazy": 2,
    "hazzard": 2,
    "hbox": 2,
    "hces": 4,
    "he": 1,
    "he'd": 1,
    "he'll": 1,
    "he's": 1,
    "heaberlin": 3,
    "heacock": 2,
    "heacox": 2,
    "head": 1,
    "head's": 1,
    "headache": 2,
    "headaches": 2,
    "headband": 2,
    "headbands": 2,
    "headboard": 2,
    "headboards": 2,
    "headcheese": 2,
    "headcount": 2,
    "headcounts": 2,
    "headdress": 2,
    "headdresses": 3,
    "headed": 2,
    "headed(1)": 2,
    "headen": 2,
    "header": 2,
    "headers": 2,
    "headfirst": 2,
    "headgear": 2,
    "headhunter": 3,
    "headhunters": 3,
    "heading": 2,
    "headings": 2,
    "headington": 3,
    "headlee": 2,
    "headless": 2,
    "headley": 2,
    "headlight": 2,
    "headlights": 2,
    "headline": 2,
    "headlined": 2,
    "headliner": 3,
    "headliners": 3,
    "headlines": 2,
    "headlining": 3,
    "headlong": 2,
    "headlund": 2,
    "headman": 2,
    "headmaster": 3,
    "headmasters": 3,
    "headmistress": 3,
    "headmistresses": 4,
    "headphone": 2,
    "headphones": 2,
    "headquarter": 3,
    "headquarter(1)": 3,
    "headquartered": 3,
    "headquartered(1)": 3,
    "headquarters": 3,
    "headquarters(1)": 3,
    "headrest": 2,
    "headrests": 2,
    "headrick": 2,
    "headroom": 2,
    "heads": 1,
    "headset": 2,
    "headsets": 2,
    "headship": 2,
    "headsman": 2,
    "headstart": 2,
    "headstarts": 2,
    "headstone": 2,
    "headstones": 2,
    "headstrong": 2,
    "headwater": 3,
    "headwaters": 3,
    "headway": 2,
    "headwind": 2,
    "headwinds": 2,
    "heady": 2,
    "heafner": 2,
    "heagle": 2,
    "heagney": 2,
    "heagy": 2,
    "heal": 1,
    "heald": 1,
    "healed": 1,
    "healer": 2,
    "healers": 2,
    "healey": 2,
    "healing": 2,
    "heals": 1,
    "health": 1,
    "health's": 1,
    "healthamerica": 5,
    "healthcare": 2,
    "healthcare's": 2,
    "healthcorp": 2,
    "healthcorp(1)": 2,
    "healthdyne": 2,
    "healthful": 2,
    "healthier": 3,
    "healthiest": 3,
    "healthiness": 3,
    "healthsource": 2,
    "healthsouth": 2,
    "healthtrust": 2,
    "healthtrust's": 2,
    "healthvest": 2,
    "healthweek": 2,
    "healthwork": 2,
    "healthworks": 2,
    "healthy": 2,
    "healy": 2,
    "healy's": 2,
    "heaney": 2,
    "heap": 1,
    "heape": 1,
    "heaped": 1,
    "heaphy": 2,
    "heaping": 2,
    "heaps": 1,
    "hear": 1,
    "heard": 1,
    "hearer": 2,
    "hearers": 2,
    "hearin": 2,
    "hearing": 2,
    "hearing's": 2,
    "hearings": 2,
    "hearkens": 2,
    "hearl": 1,
    "hearn": 1,
    "hearne": 1,
    "hearns": 1,
    "hearon": 2,
    "hearron": 2,
    "hears": 1,
    "hearsay": 2,
    "hearse": 1,
    "hearst": 1,
    "hearst's": 1,
    "heart": 1,
    "heart's": 1,
    "heartache": 2,
    "heartbeat": 2,
    "heartbeats": 2,
    "heartbreak": 2,
    "heartbreaking": 3,
    "heartbreaks": 2,
    "heartbroken": 3,
    "heartburn": 2,
    "hearted": 2,
    "hearted(1)": 2,
    "heartedly": 3,
    "hearten": 2,
    "heartened": 2,
    "heartening": 3,
    "heartening(1)": 2,
    "heartfelt": 2,
    "hearth": 1,
    "hearths": 1,
    "heartier": 3,
    "heartiest": 3,
    "heartily": 3,
    "heartland": 2,
    "heartless": 2,
    "hearts": 1,
    "heartscan": 2,
    "heartthrob": 2,
    "heartthrobs": 2,
    "heartwarming": 3,
    "heartwise": 2,
    "heartwood": 2,
    "hearty": 2,
    "heasley": 2,
    "heaslip": 2,
    "heaston": 2,
    "heat": 1,
    "heat's": 1,
    "heated": 2,
    "heated(1)": 2,
    "heatedly": 3,
    "heater": 2,
    "heaters": 2,
    "heath": 1,
    "heath's": 1,
    "heathcliff": 2,
    "heathcock": 2,
    "heathcote": 2,
    "heathen": 2,
    "heather": 2,
    "heather's": 2,
    "heatherington": 4,
    "heatherly": 3,
    "heathers": 2,
    "heathman": 2,
    "heathrow": 2,
    "heathrow's": 2,
    "heathwood": 2,
    "heating": 2,
    "heatley": 2,
    "heaton": 2,
    "heats": 1,
    "heatwole": 2,
    "heave": 1,
    "heaved": 1,
    "heaven": 2,
    "heaven's": 2,
    "heavener": 3,
    "heavenly": 3,
    "heavens": 2,
    "heaves": 1,
    "heavey": 2,
    "heavier": 3,
    "heavies": 2,
    "heaviest": 3,
    "heavily": 3,
    "heavin": 2,
    "heaving": 2,
    "heavner": 2,
    "heavrin": 2,
    "heavy": 2,
    "heavyhanded": 4,
    "heavyset": 3,
    "heavyweight": 3,
    "heavyweights": 3,
    "hebard": 2,
    "hebb": 1,
    "hebda": 2,
    "hebding": 2,
    "hebe": 1,
    "heb