import * as lambda from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
import { BundlingOptions } from './types';
/**
 * Properties for a .NET Function
 */
export interface DotNetFunctionProps extends lambda.FunctionOptions {
    /**
     * The runtime environment. Only runtimes of the .NET family and provided family are supported.
     *
     * @default lambda.Runtime.PROVIDED_AL2
     */
    readonly runtime?: lambda.Runtime;
    /**
     * Directory containing your .csproj file
     */
    readonly projectDir: string;
    /**
     * Directory containing your .sln file
     *
     * This will be used as the source of the volume mounted in the Docker
     * container and will be the directory where it will run `dotnet build` from.
     *
     * @default - the path is found by walking up parent directories searching for
     * a `.sln` file from the location of `projectDir`. If no `.sln` file is found,
     * the `projectDir` will be used.
     */
    readonly solutionDir?: string;
    /**
     * The name of the method within your code that Lambda calls to execute your function.
     * The format includes the file name. It can also include namespaces and other qualifiers,
     * depending on the runtime. For more information,
     * see https://docs.aws.amazon.com/lambda/latest/dg/foundation-progmodel.html.
     *
     * @default - the .csproj file is used as project name and the handler is set to the project name
     * or the handler is found reading the aws-lambda-tools-defaults.json file in the project directory.
     */
    readonly handler?: string;
    /**
     * Bundling options
     *
     * @default - use default bundling options
     */
    readonly bundling?: BundlingOptions;
}
/**
 * A .NET Lambda function
 */
export declare class DotNetFunction extends lambda.Function {
    constructor(scope: Construct, id: string, props: DotNetFunctionProps);
}
