# =============================================================================
# Minet Mediacloud Topic
# =============================================================================
#
# Function related to topics.
#
from minet.web import request
from minet.mediacloud.constants import MEDIACLOUD_API_BASE_URL, MEDIACLOUD_DEFAULT_BATCH
from minet.mediacloud.utils import get_next_link_id
from minet.mediacloud.types import MediacloudTopicStory


def url_forge(
    token=None, topic_id=None, link_id=None, media_id=None, from_media_id=None
):
    url = "%s/topics/%s/stories/list?key=%s&limit=%i" % (
        MEDIACLOUD_API_BASE_URL,
        topic_id,
        token,
        MEDIACLOUD_DEFAULT_BATCH,
    )

    if link_id is not None:
        url += "&link_id=%s" % link_id

    if media_id is not None:
        url += "&media_id=%s" % media_id

    if from_media_id is not None:
        url += "&link_from_media_id=%s" % from_media_id

    return url


def mediacloud_topic_stories(
    pool_manager,
    token,
    topic_id,
    link_id=None,
    media_id=None,
    from_media_id=None,
    raw=False,
):
    while True:
        url = url_forge(
            token,
            topic_id=topic_id,
            link_id=link_id,
            media_id=media_id,
            from_media_id=from_media_id,
        )

        response = request(url, pool_manager=pool_manager)
        data = response.json()

        if "stories" not in data or len(data["stories"]) == 0:
            return

        next_link_id = get_next_link_id(data)

        for story in data["stories"]:
            if not raw:
                story = MediacloudTopicStory.from_payload(story, next_link_id)

            yield story

        if next_link_id is None:
            return

        link_id = next_link_id
