"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaToBedrockinferenceprofile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const defaults = require("@aws-solutions-constructs/core");
const cdk = require("aws-cdk-lib");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
const core_1 = require("@aws-solutions-constructs/core");
/**
 * @summary The LambdaToBedrockinferenceprofile class.
 */
class LambdaToBedrockinferenceprofile extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the LambdaToSns class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {LambdaToSnsProps} props - user provided props for the construct.
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        (0, core_1.CheckBedrockInferenceProps)(props);
        defaults.CheckVpcProps(props);
        defaults.CheckLambdaProps(props);
        if (props.deployVpc || props.existingVpc) {
            this.vpc = defaults.buildVpc(scope, {
                defaultVpcProps: defaults.DefaultIsolatedVpcProps(),
                existingVpc: props.existingVpc,
                userVpcProps: props.vpcProps,
                constructVpcProps: {
                    enableDnsHostnames: true,
                    enableDnsSupport: true,
                },
            });
            defaults.AddAwsServiceEndpoint(scope, this.vpc, defaults.ServiceEndpointTypes.BEDROCK);
            defaults.AddAwsServiceEndpoint(scope, this.vpc, defaults.ServiceEndpointTypes.BEDROCK_RUNTIME);
        }
        const constructFunctionProps = defaults.consolidateProps({ timeout: cdk.Duration.seconds(30) }, props.lambdaFunctionProps);
        // Setup the Lambda function
        this.lambdaFunction = defaults.buildLambdaFunction(this, {
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps: constructFunctionProps,
            vpc: this.vpc,
        });
        const buildInferenceResponse = (0, core_1.buildInferenceProfile)(this, id, {
            bedrockModelId: props.bedrockModelId,
            deployCrossRegionProfile: props.deployCrossRegionProfile,
            inferenceProfileProps: props.inferenceProfileProps
        });
        this.inferenceProfile = buildInferenceResponse.inferenceProfile;
        const regionMapping = (0, core_1.createAreaRegionMapping)(this, id, props.bedrockModelId);
        const regionPrefix = cdk.Fn.select(0, cdk.Fn.split('-', cdk.Aws.REGION));
        this.lambdaFunction.addToRolePolicy(new iam.PolicyStatement({
            actions: ['bedrock:Invoke*'],
            resources: [
                this.inferenceProfile.attrInferenceProfileArn,
            ]
        }));
        this.lambdaFunction.addToRolePolicy(new iam.PolicyStatement({
            actions: ['bedrock:Invoke*'],
            resources: defaults.IsCrossRegionProfile(props.deployCrossRegionProfile) ?
                cdk.Fn.split(",", cdk.Fn.findInMap(regionMapping.mappingName, regionPrefix, 'regionalModels')) :
                [`arn:${cdk.Aws.PARTITION}:bedrock:${cdk.Aws.REGION}::foundation-model/${props.bedrockModelId}`]
        }));
        // Configure environment variables
        const foundationModelEnvironmentVariableName = props.foundationModelEnvironmentVariableName || 'BEDROCK_MODEL';
        this.lambdaFunction.addEnvironment(foundationModelEnvironmentVariableName, props.bedrockModelId);
        const inferenceProfileEnvironmentVariableName = props.inferenceProfileEnvironmentVariableName || 'BEDROCK_PROFILE';
        this.lambdaFunction.addEnvironment(inferenceProfileEnvironmentVariableName, this.inferenceProfile.attrInferenceProfileArn);
    }
}
exports.LambdaToBedrockinferenceprofile = LambdaToBedrockinferenceprofile;
_a = JSII_RTTI_SYMBOL_1;
LambdaToBedrockinferenceprofile[_a] = { fqn: "@aws-solutions-constructs/aws-lambda-bedrockinferenceprofile.LambdaToBedrockinferenceprofile", version: "2.84.0" };
//# sourceMappingURL=data:application/json;base64,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