"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const child_process_1 = require("child_process");
const path = require("path");
beforeAll(() => {
    child_process_1.spawnSync('docker', ['build', '-t', 'parcel', path.join(__dirname, '../parcel')]);
});
test('parcel is available', async () => {
    const proc = child_process_1.spawnSync('docker', [
        'run', 'parcel',
        'sh', '-c',
        '$(node -p "require.resolve(\'parcel\')") --version',
    ]);
    expect(proc.status).toEqual(0);
});
test('parcel is installed without a package-lock.json file', async () => {
    // We don't want a lock file at / to prevent Parcel from considering that /asset-input
    // is part of a monorepo.
    // See https://github.com/aws/aws-cdk/pull/10039#issuecomment-682738396
    const proc = child_process_1.spawnSync('docker', [
        'run', 'parcel',
        'sh', '-c',
        'test ! -f /package-lock.json',
    ]);
    expect(proc.status).toEqual(0);
});
test('can npm install with non root user', async () => {
    const proc = child_process_1.spawnSync('docker', [
        'run', '-u', '1000:1000',
        'parcel',
        'sh', '-c', [
            'mkdir /tmp/test',
            'cd /tmp/test',
            'npm i constructs',
        ].join(' && '),
    ]);
    expect(proc.status).toEqual(0);
});
test('can yarn install with non root user', async () => {
    const proc = child_process_1.spawnSync('docker', [
        'run', '-u', '500:500',
        'parcel',
        'sh', '-c', [
            'mkdir /tmp/test',
            'cd /tmp/test',
            'yarn add constructs',
        ].join(' && '),
    ]);
    expect(proc.status).toEqual(0);
});
//# sourceMappingURL=data:application/json;base64,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