"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DbAgent = exports.DbAgentProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const hbr_generated_1 = require("./hbr.generated");
Object.defineProperty(exports, "DbAgentProperty", { enumerable: true, get: function () { return hbr_generated_1.RosDbAgent; } });
/**
 * A ROS resource type:  `ALIYUN::HBR::DbAgent`
 */
class DbAgent extends ros.Resource {
    /**
     * Create a new `ALIYUN::HBR::DbAgent`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDbAgent = new hbr_generated_1.RosDbAgent(this, id, {
            instanceInfo: props.instanceInfo,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDbAgent;
        this.attrInstanceIds = rosDbAgent.attrInstanceIds;
        this.attrTaskId = rosDbAgent.attrTaskId;
        this.attrUniBackupInstanceDetails = rosDbAgent.attrUniBackupInstanceDetails;
        this.attrUniBackupInstances = rosDbAgent.attrUniBackupInstances;
    }
}
exports.DbAgent = DbAgent;
//# sourceMappingURL=data:application/json;base64,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