"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RestoreJob = exports.RestoreJobProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const hbr_generated_1 = require("./hbr.generated");
Object.defineProperty(exports, "RestoreJobProperty", { enumerable: true, get: function () { return hbr_generated_1.RosRestoreJob; } });
/**
 * A ROS resource type:  `ALIYUN::HBR::RestoreJob`
 */
class RestoreJob extends ros.Resource {
    /**
     * Create a new `ALIYUN::HBR::RestoreJob`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosRestoreJob = new hbr_generated_1.RosRestoreJob(this, id, {
            snapshotId: props.snapshotId,
            targetClientId: props.targetClientId,
            targetPath: props.targetPath,
            sourceType: props.sourceType,
            sourceClientId: props.sourceClientId,
            targetInstanceId: props.targetInstanceId,
            vaultId: props.vaultId,
            sourceInstanceId: props.sourceInstanceId,
            restoreType: props.restoreType,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosRestoreJob;
        this.attrErrorMessage = rosRestoreJob.attrErrorMessage;
        this.attrRestoreId = rosRestoreJob.attrRestoreId;
        this.attrRestoreType = rosRestoreJob.attrRestoreType;
        this.attrSourceType = rosRestoreJob.attrSourceType;
        this.attrStatus = rosRestoreJob.attrStatus;
    }
}
exports.RestoreJob = RestoreJob;
//# sourceMappingURL=data:application/json;base64,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