/* Copyright 2016 Carnegie Mellon University
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

#include "scanner/api/op.h"
#include "scanner/engine/op_info.h"

#include "scanner/util/common.h"

#include <map>

namespace scanner {
namespace internal {

class SamplerRegistry {
 public:
  void add_sampler(const std::string& name, Sampler* info);

  OpInfo* get_op_info(const std::string& name) const;

  bool has_op(const std::string& name) const;

 private:
  std::map<std::string, OpInfo*> ops_;
};

OpRegistry* get_op_registry();
}
}
