from collections.abc import Mapping
from typing import Any, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="AmountRangeRule")


@_attrs_define
class AmountRangeRule:
    """Range of amounts allowed for a given payment method

    Attributes:
        min_amount (Union[Unset, float]):
        max_amount (Union[Unset, float]):
    """

    min_amount: Union[Unset, float] = UNSET
    max_amount: Union[Unset, float] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        min_amount = self.min_amount

        max_amount = self.max_amount

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if min_amount is not UNSET:
            field_dict["minAmount"] = min_amount
        if max_amount is not UNSET:
            field_dict["maxAmount"] = max_amount

        return field_dict

    @classmethod
    def from_dict(cls: type[T], src_dict: Mapping[str, Any]) -> T:
        d = dict(src_dict)
        min_amount = d.pop("minAmount", UNSET)

        max_amount = d.pop("maxAmount", UNSET)

        amount_range_rule = cls(
            min_amount=min_amount,
            max_amount=max_amount,
        )

        amount_range_rule.additional_properties = d
        return amount_range_rule

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
