"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * The type of asset hash
 */
var AssetHashType;
(function (AssetHashType) {
    /**
     * Based on the content of the source path
     */
    AssetHashType["SOURCE"] = "source";
    /**
     * Based on the content of the bundled path
     */
    AssetHashType["BUNDLE"] = "bundle";
    /**
     * Use a custom hash
     */
    AssetHashType["CUSTOM"] = "custom";
})(AssetHashType = exports.AssetHashType || (exports.AssetHashType = {}));
/**
 * Packaging modes for file assets.
 */
var FileAssetPackaging;
(function (FileAssetPackaging) {
    /**
     * The asset source path points to a directory, which should be archived using
     * zip and and then uploaded to Amazon S3.
     */
    FileAssetPackaging["ZIP_DIRECTORY"] = "zip";
    /**
     * The asset source path points to a single file, which should be uploaded
     * to Amazon S3.
     */
    FileAssetPackaging["FILE"] = "file";
})(FileAssetPackaging = exports.FileAssetPackaging || (exports.FileAssetPackaging = {}));
//# sourceMappingURL=data:application/json;base64,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