# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AutonomousDatabaseWalletArgs', 'AutonomousDatabaseWallet']

@pulumi.input_type
class AutonomousDatabaseWalletArgs:
    def __init__(__self__, *,
                 autonomous_database_id: pulumi.Input[str],
                 password: pulumi.Input[str],
                 base64_encode_content: Optional[pulumi.Input[bool]] = None,
                 generate_type: Optional[pulumi.Input[str]] = None,
                 is_regional: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a AutonomousDatabaseWallet resource.
        :param pulumi.Input[str] autonomous_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] password: The password to encrypt the keys inside the wallet. The password must be at least 8 characters long and must include at least 1 letter and either 1 numeric character or 1 special character.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] generate_type: The type of wallet to generate.
               
               **Serverless instance usage:**
               * `SINGLE` - used to generate a wallet for a single database
               * `ALL` - used to generate wallet for all databases in the region
               
               **Dedicated Exadata infrastructure usage:** Value must be `NULL` if attribute is used.
        :param pulumi.Input[bool] is_regional: True when requesting regional connection strings in PDB connect info, applicable to cross-region DG only.
        """
        pulumi.set(__self__, "autonomous_database_id", autonomous_database_id)
        pulumi.set(__self__, "password", password)
        if base64_encode_content is not None:
            pulumi.set(__self__, "base64_encode_content", base64_encode_content)
        if generate_type is not None:
            pulumi.set(__self__, "generate_type", generate_type)
        if is_regional is not None:
            pulumi.set(__self__, "is_regional", is_regional)

    @property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> pulumi.Input[str]:
        """
        The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "autonomous_database_id")

    @autonomous_database_id.setter
    def autonomous_database_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "autonomous_database_id", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        The password to encrypt the keys inside the wallet. The password must be at least 8 characters long and must include at least 1 letter and either 1 numeric character or 1 special character.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="base64EncodeContent")
    def base64_encode_content(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "base64_encode_content")

    @base64_encode_content.setter
    def base64_encode_content(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "base64_encode_content", value)

    @property
    @pulumi.getter(name="generateType")
    def generate_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of wallet to generate.

        **Serverless instance usage:**
        * `SINGLE` - used to generate a wallet for a single database
        * `ALL` - used to generate wallet for all databases in the region

        **Dedicated Exadata infrastructure usage:** Value must be `NULL` if attribute is used.
        """
        return pulumi.get(self, "generate_type")

    @generate_type.setter
    def generate_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "generate_type", value)

    @property
    @pulumi.getter(name="isRegional")
    def is_regional(self) -> Optional[pulumi.Input[bool]]:
        """
        True when requesting regional connection strings in PDB connect info, applicable to cross-region DG only.
        """
        return pulumi.get(self, "is_regional")

    @is_regional.setter
    def is_regional(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_regional", value)


@pulumi.input_type
class _AutonomousDatabaseWalletState:
    def __init__(__self__, *,
                 autonomous_database_id: Optional[pulumi.Input[str]] = None,
                 base64_encode_content: Optional[pulumi.Input[bool]] = None,
                 content: Optional[pulumi.Input[str]] = None,
                 generate_type: Optional[pulumi.Input[str]] = None,
                 is_regional: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AutonomousDatabaseWallet resources.
        :param pulumi.Input[str] autonomous_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] content: content of the downloaded zipped wallet for the Autonomous Database. If `base64_encode_content` is set to `true`, then this content will be base64 encoded.
        :param pulumi.Input[str] generate_type: The type of wallet to generate.
               
               **Serverless instance usage:**
               * `SINGLE` - used to generate a wallet for a single database
               * `ALL` - used to generate wallet for all databases in the region
               
               **Dedicated Exadata infrastructure usage:** Value must be `NULL` if attribute is used.
        :param pulumi.Input[bool] is_regional: True when requesting regional connection strings in PDB connect info, applicable to cross-region DG only.
        :param pulumi.Input[str] password: The password to encrypt the keys inside the wallet. The password must be at least 8 characters long and must include at least 1 letter and either 1 numeric character or 1 special character.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if autonomous_database_id is not None:
            pulumi.set(__self__, "autonomous_database_id", autonomous_database_id)
        if base64_encode_content is not None:
            pulumi.set(__self__, "base64_encode_content", base64_encode_content)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if generate_type is not None:
            pulumi.set(__self__, "generate_type", generate_type)
        if is_regional is not None:
            pulumi.set(__self__, "is_regional", is_regional)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> Optional[pulumi.Input[str]]:
        """
        The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "autonomous_database_id")

    @autonomous_database_id.setter
    def autonomous_database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "autonomous_database_id", value)

    @property
    @pulumi.getter(name="base64EncodeContent")
    def base64_encode_content(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "base64_encode_content")

    @base64_encode_content.setter
    def base64_encode_content(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "base64_encode_content", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        content of the downloaded zipped wallet for the Autonomous Database. If `base64_encode_content` is set to `true`, then this content will be base64 encoded.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="generateType")
    def generate_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of wallet to generate.

        **Serverless instance usage:**
        * `SINGLE` - used to generate a wallet for a single database
        * `ALL` - used to generate wallet for all databases in the region

        **Dedicated Exadata infrastructure usage:** Value must be `NULL` if attribute is used.
        """
        return pulumi.get(self, "generate_type")

    @generate_type.setter
    def generate_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "generate_type", value)

    @property
    @pulumi.getter(name="isRegional")
    def is_regional(self) -> Optional[pulumi.Input[bool]]:
        """
        True when requesting regional connection strings in PDB connect info, applicable to cross-region DG only.
        """
        return pulumi.get(self, "is_regional")

    @is_regional.setter
    def is_regional(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_regional", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password to encrypt the keys inside the wallet. The password must be at least 8 characters long and must include at least 1 letter and either 1 numeric character or 1 special character.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)


class AutonomousDatabaseWallet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autonomous_database_id: Optional[pulumi.Input[str]] = None,
                 base64_encode_content: Optional[pulumi.Input[bool]] = None,
                 generate_type: Optional[pulumi.Input[str]] = None,
                 is_regional: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Autonomous Database Wallet resource in Oracle Cloud Infrastructure Database service.

        Creates and downloads a wallet for the specified Autonomous Database.

        If passing the base64 encoded content to a `local_file` resource, please use the `content_base64` attribute of the `local_file` resource.
        See this example for more details.

        Recreate the resource to create and download a new wallet.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_autonomous_database_wallet = oci.database.AutonomousDatabaseWallet("test_autonomous_database_wallet",
            autonomous_database_id=test_autonomous_database["id"],
            password=autonomous_database_wallet_password,
            base64_encode_content=False,
            generate_type=autonomous_database_wallet_generate_type,
            is_regional=autonomous_database_wallet_is_regional)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] autonomous_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] generate_type: The type of wallet to generate.
               
               **Serverless instance usage:**
               * `SINGLE` - used to generate a wallet for a single database
               * `ALL` - used to generate wallet for all databases in the region
               
               **Dedicated Exadata infrastructure usage:** Value must be `NULL` if attribute is used.
        :param pulumi.Input[bool] is_regional: True when requesting regional connection strings in PDB connect info, applicable to cross-region DG only.
        :param pulumi.Input[str] password: The password to encrypt the keys inside the wallet. The password must be at least 8 characters long and must include at least 1 letter and either 1 numeric character or 1 special character.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutonomousDatabaseWalletArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Autonomous Database Wallet resource in Oracle Cloud Infrastructure Database service.

        Creates and downloads a wallet for the specified Autonomous Database.

        If passing the base64 encoded content to a `local_file` resource, please use the `content_base64` attribute of the `local_file` resource.
        See this example for more details.

        Recreate the resource to create and download a new wallet.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_autonomous_database_wallet = oci.database.AutonomousDatabaseWallet("test_autonomous_database_wallet",
            autonomous_database_id=test_autonomous_database["id"],
            password=autonomous_database_wallet_password,
            base64_encode_content=False,
            generate_type=autonomous_database_wallet_generate_type,
            is_regional=autonomous_database_wallet_is_regional)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param AutonomousDatabaseWalletArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutonomousDatabaseWalletArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autonomous_database_id: Optional[pulumi.Input[str]] = None,
                 base64_encode_content: Optional[pulumi.Input[bool]] = None,
                 generate_type: Optional[pulumi.Input[str]] = None,
                 is_regional: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutonomousDatabaseWalletArgs.__new__(AutonomousDatabaseWalletArgs)

            if autonomous_database_id is None and not opts.urn:
                raise TypeError("Missing required property 'autonomous_database_id'")
            __props__.__dict__["autonomous_database_id"] = autonomous_database_id
            __props__.__dict__["base64_encode_content"] = base64_encode_content
            __props__.__dict__["generate_type"] = generate_type
            __props__.__dict__["is_regional"] = is_regional
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["content"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AutonomousDatabaseWallet, __self__).__init__(
            'oci:Database/autonomousDatabaseWallet:AutonomousDatabaseWallet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            autonomous_database_id: Optional[pulumi.Input[str]] = None,
            base64_encode_content: Optional[pulumi.Input[bool]] = None,
            content: Optional[pulumi.Input[str]] = None,
            generate_type: Optional[pulumi.Input[str]] = None,
            is_regional: Optional[pulumi.Input[bool]] = None,
            password: Optional[pulumi.Input[str]] = None) -> 'AutonomousDatabaseWallet':
        """
        Get an existing AutonomousDatabaseWallet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] autonomous_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] content: content of the downloaded zipped wallet for the Autonomous Database. If `base64_encode_content` is set to `true`, then this content will be base64 encoded.
        :param pulumi.Input[str] generate_type: The type of wallet to generate.
               
               **Serverless instance usage:**
               * `SINGLE` - used to generate a wallet for a single database
               * `ALL` - used to generate wallet for all databases in the region
               
               **Dedicated Exadata infrastructure usage:** Value must be `NULL` if attribute is used.
        :param pulumi.Input[bool] is_regional: True when requesting regional connection strings in PDB connect info, applicable to cross-region DG only.
        :param pulumi.Input[str] password: The password to encrypt the keys inside the wallet. The password must be at least 8 characters long and must include at least 1 letter and either 1 numeric character or 1 special character.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutonomousDatabaseWalletState.__new__(_AutonomousDatabaseWalletState)

        __props__.__dict__["autonomous_database_id"] = autonomous_database_id
        __props__.__dict__["base64_encode_content"] = base64_encode_content
        __props__.__dict__["content"] = content
        __props__.__dict__["generate_type"] = generate_type
        __props__.__dict__["is_regional"] = is_regional
        __props__.__dict__["password"] = password
        return AutonomousDatabaseWallet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> pulumi.Output[str]:
        """
        The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "autonomous_database_id")

    @property
    @pulumi.getter(name="base64EncodeContent")
    def base64_encode_content(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "base64_encode_content")

    @property
    @pulumi.getter
    def content(self) -> pulumi.Output[str]:
        """
        content of the downloaded zipped wallet for the Autonomous Database. If `base64_encode_content` is set to `true`, then this content will be base64 encoded.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="generateType")
    def generate_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of wallet to generate.

        **Serverless instance usage:**
        * `SINGLE` - used to generate a wallet for a single database
        * `ALL` - used to generate wallet for all databases in the region

        **Dedicated Exadata infrastructure usage:** Value must be `NULL` if attribute is used.
        """
        return pulumi.get(self, "generate_type")

    @property
    @pulumi.getter(name="isRegional")
    def is_regional(self) -> pulumi.Output[bool]:
        """
        True when requesting regional connection strings in PDB connect info, applicable to cross-region DG only.
        """
        return pulumi.get(self, "is_regional")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        The password to encrypt the keys inside the wallet. The password must be at least 8 characters long and must include at least 1 letter and either 1 numeric character or 1 special character.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "password")

