# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAutonomousDatabasesClonesResult',
    'AwaitableGetAutonomousDatabasesClonesResult',
    'get_autonomous_databases_clones',
    'get_autonomous_databases_clones_output',
]

@pulumi.output_type
class GetAutonomousDatabasesClonesResult:
    """
    A collection of values returned by getAutonomousDatabasesClones.
    """
    def __init__(__self__, autonomous_database_id=None, autonomous_databases=None, clone_type=None, compartment_id=None, display_name=None, filters=None, id=None, state=None):
        if autonomous_database_id and not isinstance(autonomous_database_id, str):
            raise TypeError("Expected argument 'autonomous_database_id' to be a str")
        pulumi.set(__self__, "autonomous_database_id", autonomous_database_id)
        if autonomous_databases and not isinstance(autonomous_databases, list):
            raise TypeError("Expected argument 'autonomous_databases' to be a list")
        pulumi.set(__self__, "autonomous_databases", autonomous_databases)
        if clone_type and not isinstance(clone_type, str):
            raise TypeError("Expected argument 'clone_type' to be a str")
        pulumi.set(__self__, "clone_type", clone_type)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> str:
        return pulumi.get(self, "autonomous_database_id")

    @property
    @pulumi.getter(name="autonomousDatabases")
    def autonomous_databases(self) -> Sequence['outputs.GetAutonomousDatabasesClonesAutonomousDatabaseResult']:
        """
        The list of autonomous_databases.
        """
        return pulumi.get(self, "autonomous_databases")

    @property
    @pulumi.getter(name="cloneType")
    def clone_type(self) -> Optional[str]:
        return pulumi.get(self, "clone_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The user-friendly name for the Autonomous Database. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAutonomousDatabasesClonesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the Autonomous Database.
        """
        return pulumi.get(self, "state")


class AwaitableGetAutonomousDatabasesClonesResult(GetAutonomousDatabasesClonesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousDatabasesClonesResult(
            autonomous_database_id=self.autonomous_database_id,
            autonomous_databases=self.autonomous_databases,
            clone_type=self.clone_type,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_autonomous_databases_clones(autonomous_database_id: Optional[str] = None,
                                    clone_type: Optional[str] = None,
                                    compartment_id: Optional[str] = None,
                                    display_name: Optional[str] = None,
                                    filters: Optional[Sequence[Union['GetAutonomousDatabasesClonesFilterArgs', 'GetAutonomousDatabasesClonesFilterArgsDict']]] = None,
                                    state: Optional[str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousDatabasesClonesResult:
    """
    This data source provides the list of Autonomous Databases Clones in Oracle Cloud Infrastructure Database service.

    Lists the Autonomous Database clones for the specified Autonomous Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_databases_clones = oci.Database.get_autonomous_databases_clones(autonomous_database_id=test_autonomous_database["id"],
        compartment_id=compartment_id,
        clone_type=autonomous_databases_clone_clone_type,
        display_name=autonomous_databases_clone_display_name,
        state=autonomous_databases_clone_state)
    ```


    :param str autonomous_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str clone_type: A filter to return only resources that match the given clone type exactly.
    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    __args__ = dict()
    __args__['autonomousDatabaseId'] = autonomous_database_id
    __args__['cloneType'] = clone_type
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getAutonomousDatabasesClones:getAutonomousDatabasesClones', __args__, opts=opts, typ=GetAutonomousDatabasesClonesResult).value

    return AwaitableGetAutonomousDatabasesClonesResult(
        autonomous_database_id=pulumi.get(__ret__, 'autonomous_database_id'),
        autonomous_databases=pulumi.get(__ret__, 'autonomous_databases'),
        clone_type=pulumi.get(__ret__, 'clone_type'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_autonomous_databases_clones)
def get_autonomous_databases_clones_output(autonomous_database_id: Optional[pulumi.Input[str]] = None,
                                           clone_type: Optional[pulumi.Input[Optional[str]]] = None,
                                           compartment_id: Optional[pulumi.Input[str]] = None,
                                           display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                           filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAutonomousDatabasesClonesFilterArgs', 'GetAutonomousDatabasesClonesFilterArgsDict']]]]] = None,
                                           state: Optional[pulumi.Input[Optional[str]]] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAutonomousDatabasesClonesResult]:
    """
    This data source provides the list of Autonomous Databases Clones in Oracle Cloud Infrastructure Database service.

    Lists the Autonomous Database clones for the specified Autonomous Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_databases_clones = oci.Database.get_autonomous_databases_clones(autonomous_database_id=test_autonomous_database["id"],
        compartment_id=compartment_id,
        clone_type=autonomous_databases_clone_clone_type,
        display_name=autonomous_databases_clone_display_name,
        state=autonomous_databases_clone_state)
    ```


    :param str autonomous_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str clone_type: A filter to return only resources that match the given clone type exactly.
    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param str state: A filter to return only resources that match the given lifecycle state exactly.
    """
    ...
