# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAutonomousDbPreviewVersionsResult',
    'AwaitableGetAutonomousDbPreviewVersionsResult',
    'get_autonomous_db_preview_versions',
    'get_autonomous_db_preview_versions_output',
]

@pulumi.output_type
class GetAutonomousDbPreviewVersionsResult:
    """
    A collection of values returned by getAutonomousDbPreviewVersions.
    """
    def __init__(__self__, autonomous_db_preview_versions=None, compartment_id=None, filters=None, id=None):
        if autonomous_db_preview_versions and not isinstance(autonomous_db_preview_versions, list):
            raise TypeError("Expected argument 'autonomous_db_preview_versions' to be a list")
        pulumi.set(__self__, "autonomous_db_preview_versions", autonomous_db_preview_versions)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="autonomousDbPreviewVersions")
    def autonomous_db_preview_versions(self) -> Sequence['outputs.GetAutonomousDbPreviewVersionsAutonomousDbPreviewVersionResult']:
        """
        The list of autonomous_db_preview_versions.
        """
        return pulumi.get(self, "autonomous_db_preview_versions")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAutonomousDbPreviewVersionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetAutonomousDbPreviewVersionsResult(GetAutonomousDbPreviewVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAutonomousDbPreviewVersionsResult(
            autonomous_db_preview_versions=self.autonomous_db_preview_versions,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id)


def get_autonomous_db_preview_versions(compartment_id: Optional[str] = None,
                                       filters: Optional[Sequence[Union['GetAutonomousDbPreviewVersionsFilterArgs', 'GetAutonomousDbPreviewVersionsFilterArgsDict']]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAutonomousDbPreviewVersionsResult:
    """
    This data source provides the list of Autonomous Db Preview Versions in Oracle Cloud Infrastructure Database service.

    Gets a list of supported Autonomous Database versions. Note that preview version software is only available for
    Autonomous Database Serverless (https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) databases.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_db_preview_versions = oci.Database.get_autonomous_db_preview_versions(compartment_id=compartment_id)
    ```


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getAutonomousDbPreviewVersions:getAutonomousDbPreviewVersions', __args__, opts=opts, typ=GetAutonomousDbPreviewVersionsResult).value

    return AwaitableGetAutonomousDbPreviewVersionsResult(
        autonomous_db_preview_versions=pulumi.get(__ret__, 'autonomous_db_preview_versions'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))


@_utilities.lift_output_func(get_autonomous_db_preview_versions)
def get_autonomous_db_preview_versions_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                              filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAutonomousDbPreviewVersionsFilterArgs', 'GetAutonomousDbPreviewVersionsFilterArgsDict']]]]] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAutonomousDbPreviewVersionsResult]:
    """
    This data source provides the list of Autonomous Db Preview Versions in Oracle Cloud Infrastructure Database service.

    Gets a list of supported Autonomous Database versions. Note that preview version software is only available for
    Autonomous Database Serverless (https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) databases.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_autonomous_db_preview_versions = oci.Database.get_autonomous_db_preview_versions(compartment_id=compartment_id)
    ```


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    ...
