# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetDelegatedResourceAccessRequestResult',
    'AwaitableGetDelegatedResourceAccessRequestResult',
    'get_delegated_resource_access_request',
    'get_delegated_resource_access_request_output',
]

@pulumi.output_type
class GetDelegatedResourceAccessRequestResult:
    """
    A collection of values returned by getDelegatedResourceAccessRequest.
    """
    def __init__(__self__, approval_infos=None, audit_types=None, closure_comment=None, compartment_id=None, database_name_lists=None, defined_tags=None, delegated_resource_access_request_id=None, delegation_control_id=None, delegation_subscription_ids=None, description=None, display_name=None, duration_in_hours=None, extend_duration_in_hours=None, freeform_tags=None, id=None, is_auto_approved=None, is_pending_more_info=None, lifecycle_state_details=None, num_extension_approvals=None, num_initial_approvals=None, provided_service_types=None, reason_for_request=None, request_status=None, requested_action_names=None, requester_type=None, resource_id=None, resource_name=None, resource_type=None, severity=None, state=None, system_tags=None, ticket_numbers=None, time_access_requested=None, time_created=None, time_updated=None):
        if approval_infos and not isinstance(approval_infos, list):
            raise TypeError("Expected argument 'approval_infos' to be a list")
        pulumi.set(__self__, "approval_infos", approval_infos)
        if audit_types and not isinstance(audit_types, list):
            raise TypeError("Expected argument 'audit_types' to be a list")
        pulumi.set(__self__, "audit_types", audit_types)
        if closure_comment and not isinstance(closure_comment, str):
            raise TypeError("Expected argument 'closure_comment' to be a str")
        pulumi.set(__self__, "closure_comment", closure_comment)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if database_name_lists and not isinstance(database_name_lists, list):
            raise TypeError("Expected argument 'database_name_lists' to be a list")
        pulumi.set(__self__, "database_name_lists", database_name_lists)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if delegated_resource_access_request_id and not isinstance(delegated_resource_access_request_id, str):
            raise TypeError("Expected argument 'delegated_resource_access_request_id' to be a str")
        pulumi.set(__self__, "delegated_resource_access_request_id", delegated_resource_access_request_id)
        if delegation_control_id and not isinstance(delegation_control_id, str):
            raise TypeError("Expected argument 'delegation_control_id' to be a str")
        pulumi.set(__self__, "delegation_control_id", delegation_control_id)
        if delegation_subscription_ids and not isinstance(delegation_subscription_ids, list):
            raise TypeError("Expected argument 'delegation_subscription_ids' to be a list")
        pulumi.set(__self__, "delegation_subscription_ids", delegation_subscription_ids)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if duration_in_hours and not isinstance(duration_in_hours, int):
            raise TypeError("Expected argument 'duration_in_hours' to be a int")
        pulumi.set(__self__, "duration_in_hours", duration_in_hours)
        if extend_duration_in_hours and not isinstance(extend_duration_in_hours, int):
            raise TypeError("Expected argument 'extend_duration_in_hours' to be a int")
        pulumi.set(__self__, "extend_duration_in_hours", extend_duration_in_hours)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_auto_approved and not isinstance(is_auto_approved, bool):
            raise TypeError("Expected argument 'is_auto_approved' to be a bool")
        pulumi.set(__self__, "is_auto_approved", is_auto_approved)
        if is_pending_more_info and not isinstance(is_pending_more_info, bool):
            raise TypeError("Expected argument 'is_pending_more_info' to be a bool")
        pulumi.set(__self__, "is_pending_more_info", is_pending_more_info)
        if lifecycle_state_details and not isinstance(lifecycle_state_details, str):
            raise TypeError("Expected argument 'lifecycle_state_details' to be a str")
        pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)
        if num_extension_approvals and not isinstance(num_extension_approvals, int):
            raise TypeError("Expected argument 'num_extension_approvals' to be a int")
        pulumi.set(__self__, "num_extension_approvals", num_extension_approvals)
        if num_initial_approvals and not isinstance(num_initial_approvals, int):
            raise TypeError("Expected argument 'num_initial_approvals' to be a int")
        pulumi.set(__self__, "num_initial_approvals", num_initial_approvals)
        if provided_service_types and not isinstance(provided_service_types, list):
            raise TypeError("Expected argument 'provided_service_types' to be a list")
        pulumi.set(__self__, "provided_service_types", provided_service_types)
        if reason_for_request and not isinstance(reason_for_request, str):
            raise TypeError("Expected argument 'reason_for_request' to be a str")
        pulumi.set(__self__, "reason_for_request", reason_for_request)
        if request_status and not isinstance(request_status, str):
            raise TypeError("Expected argument 'request_status' to be a str")
        pulumi.set(__self__, "request_status", request_status)
        if requested_action_names and not isinstance(requested_action_names, list):
            raise TypeError("Expected argument 'requested_action_names' to be a list")
        pulumi.set(__self__, "requested_action_names", requested_action_names)
        if requester_type and not isinstance(requester_type, str):
            raise TypeError("Expected argument 'requester_type' to be a str")
        pulumi.set(__self__, "requester_type", requester_type)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if resource_name and not isinstance(resource_name, str):
            raise TypeError("Expected argument 'resource_name' to be a str")
        pulumi.set(__self__, "resource_name", resource_name)
        if resource_type and not isinstance(resource_type, str):
            raise TypeError("Expected argument 'resource_type' to be a str")
        pulumi.set(__self__, "resource_type", resource_type)
        if severity and not isinstance(severity, str):
            raise TypeError("Expected argument 'severity' to be a str")
        pulumi.set(__self__, "severity", severity)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if ticket_numbers and not isinstance(ticket_numbers, list):
            raise TypeError("Expected argument 'ticket_numbers' to be a list")
        pulumi.set(__self__, "ticket_numbers", ticket_numbers)
        if time_access_requested and not isinstance(time_access_requested, str):
            raise TypeError("Expected argument 'time_access_requested' to be a str")
        pulumi.set(__self__, "time_access_requested", time_access_requested)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="approvalInfos")
    def approval_infos(self) -> Sequence['outputs.GetDelegatedResourceAccessRequestApprovalInfoResult']:
        """
        In case of single approval, this will have only one item. Else, a list of approvals.
        """
        return pulumi.get(self, "approval_infos")

    @property
    @pulumi.getter(name="auditTypes")
    def audit_types(self) -> Sequence[str]:
        """
        Specifies the type of auditing to be enabled. There are two levels of auditing: command-level and keystroke-level.  By default, both command-level and keystroke-level auditing are enabled, i.e. commands and key strokes issued by the support operator are logged.
        """
        return pulumi.get(self, "audit_types")

    @property
    @pulumi.getter(name="closureComment")
    def closure_comment(self) -> str:
        """
        The comment entered by the support operator while closing the request.
        """
        return pulumi.get(self, "closure_comment")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the Delegated Resource Access Request.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="databaseNameLists")
    def database_name_lists(self) -> Sequence[str]:
        """
        List of Database unique names for which access is requested. This parameter is required for DLGT_MGMT_SYS_MAINT_ACCESS cage when database access in needed.
        """
        return pulumi.get(self, "database_name_lists")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="delegatedResourceAccessRequestId")
    def delegated_resource_access_request_id(self) -> str:
        return pulumi.get(self, "delegated_resource_access_request_id")

    @property
    @pulumi.getter(name="delegationControlId")
    def delegation_control_id(self) -> str:
        """
        The OCID of the Delegation Control governing the target resource.
        """
        return pulumi.get(self, "delegation_control_id")

    @property
    @pulumi.getter(name="delegationSubscriptionIds")
    def delegation_subscription_ids(self) -> Sequence[str]:
        """
        List of Delegation Subscription OCID that are associated with this Delegated Resource Access Request based on the service types being requested.
        """
        return pulumi.get(self, "delegation_subscription_ids")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Detailed description of this Delegated Resource Access Request.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Display name. This is generated by the system automatically.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="durationInHours")
    def duration_in_hours(self) -> int:
        """
        Duration in hours for which access is sought on the target resource.
        """
        return pulumi.get(self, "duration_in_hours")

    @property
    @pulumi.getter(name="extendDurationInHours")
    def extend_duration_in_hours(self) -> int:
        """
        Duration in hours for which extension access is sought on the target resource.
        """
        return pulumi.get(self, "extend_duration_in_hours")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAutoApproved")
    def is_auto_approved(self) -> bool:
        """
        Set to true if the request is approved automatically based on preApprovedServiceProviderActionNames or isAutoApproveDuringMaintenance in the associated Delegation Control.
        """
        return pulumi.get(self, "is_auto_approved")

    @property
    @pulumi.getter(name="isPendingMoreInfo")
    def is_pending_more_info(self) -> bool:
        """
        Indicates if the delegated resource access request is waiting on more information from the operator
        """
        return pulumi.get(self, "is_pending_more_info")

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> str:
        """
        Description of the current lifecycle state in more detail.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @property
    @pulumi.getter(name="numExtensionApprovals")
    def num_extension_approvals(self) -> int:
        """
        Number of extension approvals that have been obtained so far.
        """
        return pulumi.get(self, "num_extension_approvals")

    @property
    @pulumi.getter(name="numInitialApprovals")
    def num_initial_approvals(self) -> int:
        """
        Number of initial approvals that have been obtained so far.
        """
        return pulumi.get(self, "num_initial_approvals")

    @property
    @pulumi.getter(name="providedServiceTypes")
    def provided_service_types(self) -> Sequence[str]:
        """
        List of Service Provider Service Types being provided by the support operator user.
        """
        return pulumi.get(self, "provided_service_types")

    @property
    @pulumi.getter(name="reasonForRequest")
    def reason_for_request(self) -> str:
        """
        A short description explaining why this Delegated Resource Access Request is needed by the support operator.
        """
        return pulumi.get(self, "reason_for_request")

    @property
    @pulumi.getter(name="requestStatus")
    def request_status(self) -> str:
        """
        The current status of the Delegated Resource Access Request.
        """
        return pulumi.get(self, "request_status")

    @property
    @pulumi.getter(name="requestedActionNames")
    def requested_action_names(self) -> Sequence[str]:
        """
        List of Service Provider Action names for which approval is sought by the support operator user. The list of pre-defined Service Provider Actions can be obtained from the ListServiceProviderActions API.
        """
        return pulumi.get(self, "requested_action_names")

    @property
    @pulumi.getter(name="requesterType")
    def requester_type(self) -> str:
        """
        Requester type
        """
        return pulumi.get(self, "requester_type")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The OCID of the target resource associated with the Delegated Resource Access Request. The support operator raises a Delegated Resource Access Request to get approval to  access the target resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> str:
        """
        The name of the target resource associated with the Delegated Resource Access Request. The support operator raises a Delegated Resource Access Request to get approval to  access the target resource.
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        Resource type for which the associated Delegation Control is applicable to.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        Priority assigned to the Delegated Resource Access Request by the support operator
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifecycle state of the Delegated Resource Access Request.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="ticketNumbers")
    def ticket_numbers(self) -> Sequence[str]:
        """
        A list of ticket numbers related to this Delegated Resource Access Request, e.g. Service Request (SR) number and JIRA ticket number.
        """
        return pulumi.get(self, "ticket_numbers")

    @property
    @pulumi.getter(name="timeAccessRequested")
    def time_access_requested(self) -> str:
        """
        Requested access start time in UTC.
        """
        return pulumi.get(self, "time_access_requested")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Time when the Delegated Resource Access Request was created in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        Time when the Delegated Resource Access Request was last modified in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetDelegatedResourceAccessRequestResult(GetDelegatedResourceAccessRequestResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDelegatedResourceAccessRequestResult(
            approval_infos=self.approval_infos,
            audit_types=self.audit_types,
            closure_comment=self.closure_comment,
            compartment_id=self.compartment_id,
            database_name_lists=self.database_name_lists,
            defined_tags=self.defined_tags,
            delegated_resource_access_request_id=self.delegated_resource_access_request_id,
            delegation_control_id=self.delegation_control_id,
            delegation_subscription_ids=self.delegation_subscription_ids,
            description=self.description,
            display_name=self.display_name,
            duration_in_hours=self.duration_in_hours,
            extend_duration_in_hours=self.extend_duration_in_hours,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_auto_approved=self.is_auto_approved,
            is_pending_more_info=self.is_pending_more_info,
            lifecycle_state_details=self.lifecycle_state_details,
            num_extension_approvals=self.num_extension_approvals,
            num_initial_approvals=self.num_initial_approvals,
            provided_service_types=self.provided_service_types,
            reason_for_request=self.reason_for_request,
            request_status=self.request_status,
            requested_action_names=self.requested_action_names,
            requester_type=self.requester_type,
            resource_id=self.resource_id,
            resource_name=self.resource_name,
            resource_type=self.resource_type,
            severity=self.severity,
            state=self.state,
            system_tags=self.system_tags,
            ticket_numbers=self.ticket_numbers,
            time_access_requested=self.time_access_requested,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_delegated_resource_access_request(delegated_resource_access_request_id: Optional[str] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDelegatedResourceAccessRequestResult:
    """
    This data source provides details about a specific Delegated Resource Access Request resource in Oracle Cloud Infrastructure Delegate Access Control service.

    Gets details of a Delegated Resource Access Request.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_delegated_resource_access_request = oci.DelegateAccessControl.get_delegated_resource_access_request(delegated_resource_access_request_id=test_delegated_resource_access_request_oci_delegate_access_control_delegated_resource_access_request["id"])
    ```


    :param str delegated_resource_access_request_id: Unique Delegated Resource Access Request identifier
    """
    __args__ = dict()
    __args__['delegatedResourceAccessRequestId'] = delegated_resource_access_request_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DelegateAccessControl/getDelegatedResourceAccessRequest:getDelegatedResourceAccessRequest', __args__, opts=opts, typ=GetDelegatedResourceAccessRequestResult).value

    return AwaitableGetDelegatedResourceAccessRequestResult(
        approval_infos=pulumi.get(__ret__, 'approval_infos'),
        audit_types=pulumi.get(__ret__, 'audit_types'),
        closure_comment=pulumi.get(__ret__, 'closure_comment'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        database_name_lists=pulumi.get(__ret__, 'database_name_lists'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        delegated_resource_access_request_id=pulumi.get(__ret__, 'delegated_resource_access_request_id'),
        delegation_control_id=pulumi.get(__ret__, 'delegation_control_id'),
        delegation_subscription_ids=pulumi.get(__ret__, 'delegation_subscription_ids'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        duration_in_hours=pulumi.get(__ret__, 'duration_in_hours'),
        extend_duration_in_hours=pulumi.get(__ret__, 'extend_duration_in_hours'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_auto_approved=pulumi.get(__ret__, 'is_auto_approved'),
        is_pending_more_info=pulumi.get(__ret__, 'is_pending_more_info'),
        lifecycle_state_details=pulumi.get(__ret__, 'lifecycle_state_details'),
        num_extension_approvals=pulumi.get(__ret__, 'num_extension_approvals'),
        num_initial_approvals=pulumi.get(__ret__, 'num_initial_approvals'),
        provided_service_types=pulumi.get(__ret__, 'provided_service_types'),
        reason_for_request=pulumi.get(__ret__, 'reason_for_request'),
        request_status=pulumi.get(__ret__, 'request_status'),
        requested_action_names=pulumi.get(__ret__, 'requested_action_names'),
        requester_type=pulumi.get(__ret__, 'requester_type'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        resource_name=pulumi.get(__ret__, 'resource_name'),
        resource_type=pulumi.get(__ret__, 'resource_type'),
        severity=pulumi.get(__ret__, 'severity'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        ticket_numbers=pulumi.get(__ret__, 'ticket_numbers'),
        time_access_requested=pulumi.get(__ret__, 'time_access_requested'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_delegated_resource_access_request)
def get_delegated_resource_access_request_output(delegated_resource_access_request_id: Optional[pulumi.Input[str]] = None,
                                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDelegatedResourceAccessRequestResult]:
    """
    This data source provides details about a specific Delegated Resource Access Request resource in Oracle Cloud Infrastructure Delegate Access Control service.

    Gets details of a Delegated Resource Access Request.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_delegated_resource_access_request = oci.DelegateAccessControl.get_delegated_resource_access_request(delegated_resource_access_request_id=test_delegated_resource_access_request_oci_delegate_access_control_delegated_resource_access_request["id"])
    ```


    :param str delegated_resource_access_request_id: Unique Delegated Resource Access Request identifier
    """
    ...
