# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetDelegatedResourceAccessRequestApprovalInfoResult',
    'GetDelegatedResourceAccessRequestHistoriesDelegatedResourceAccessRequestHistoryCollectionResult',
    'GetDelegatedResourceAccessRequestHistoriesDelegatedResourceAccessRequestHistoryCollectionItemResult',
    'GetDelegatedResourceAccessRequestHistoriesFilterResult',
    'GetDelegatedResourceAccessRequestsDelegatedResourceAccessRequestSummaryCollectionResult',
    'GetDelegatedResourceAccessRequestsDelegatedResourceAccessRequestSummaryCollectionItemResult',
    'GetDelegatedResourceAccessRequestsDelegatedResourceAccessRequestSummaryCollectionItemApprovalInfoResult',
    'GetDelegatedResourceAccessRequestsFilterResult',
    'GetDelegationControlResourcesDelegationControlResourceCollectionResult',
    'GetDelegationControlResourcesDelegationControlResourceCollectionItemResult',
    'GetDelegationControlResourcesFilterResult',
    'GetDelegationControlsDelegationControlSummaryCollectionResult',
    'GetDelegationControlsDelegationControlSummaryCollectionItemResult',
    'GetDelegationControlsFilterResult',
    'GetDelegationSubscriptionsDelegationSubscriptionSummaryCollectionResult',
    'GetDelegationSubscriptionsDelegationSubscriptionSummaryCollectionItemResult',
    'GetDelegationSubscriptionsFilterResult',
    'GetServiceProviderActionPropertyResult',
    'GetServiceProviderActionsFilterResult',
    'GetServiceProviderActionsServiceProviderActionSummaryCollectionResult',
    'GetServiceProviderActionsServiceProviderActionSummaryCollectionItemResult',
    'GetServiceProviderActionsServiceProviderActionSummaryCollectionItemPropertyResult',
    'GetServiceProvidersFilterResult',
    'GetServiceProvidersServiceProviderSummaryCollectionResult',
    'GetServiceProvidersServiceProviderSummaryCollectionItemResult',
]

@pulumi.output_type
class GetDelegatedResourceAccessRequestApprovalInfoResult(dict):
    def __init__(__self__, *,
                 approval_action: str,
                 approval_type: str,
                 approver_additional_message: str,
                 approver_comment: str,
                 approver_id: str,
                 time_approved_for_access: str):
        """
        :param str approval_action: Indicated whether the request is approved or rejected.
        :param str approval_type: approval type, initial or extension
        :param str approver_additional_message: Additional message specified by the approver of the request.
        :param str approver_comment: Comment specified by the approver of the request.
        :param str approver_id: User ID of the approver.
        :param str time_approved_for_access: Access start time that is actually approved by the customer in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'.
        """
        pulumi.set(__self__, "approval_action", approval_action)
        pulumi.set(__self__, "approval_type", approval_type)
        pulumi.set(__self__, "approver_additional_message", approver_additional_message)
        pulumi.set(__self__, "approver_comment", approver_comment)
        pulumi.set(__self__, "approver_id", approver_id)
        pulumi.set(__self__, "time_approved_for_access", time_approved_for_access)

    @property
    @pulumi.getter(name="approvalAction")
    def approval_action(self) -> str:
        """
        Indicated whether the request is approved or rejected.
        """
        return pulumi.get(self, "approval_action")

    @property
    @pulumi.getter(name="approvalType")
    def approval_type(self) -> str:
        """
        approval type, initial or extension
        """
        return pulumi.get(self, "approval_type")

    @property
    @pulumi.getter(name="approverAdditionalMessage")
    def approver_additional_message(self) -> str:
        """
        Additional message specified by the approver of the request.
        """
        return pulumi.get(self, "approver_additional_message")

    @property
    @pulumi.getter(name="approverComment")
    def approver_comment(self) -> str:
        """
        Comment specified by the approver of the request.
        """
        return pulumi.get(self, "approver_comment")

    @property
    @pulumi.getter(name="approverId")
    def approver_id(self) -> str:
        """
        User ID of the approver.
        """
        return pulumi.get(self, "approver_id")

    @property
    @pulumi.getter(name="timeApprovedForAccess")
    def time_approved_for_access(self) -> str:
        """
        Access start time that is actually approved by the customer in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'.
        """
        return pulumi.get(self, "time_approved_for_access")


@pulumi.output_type
class GetDelegatedResourceAccessRequestHistoriesDelegatedResourceAccessRequestHistoryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDelegatedResourceAccessRequestHistoriesDelegatedResourceAccessRequestHistoryCollectionItemResult']):
        """
        :param Sequence['GetDelegatedResourceAccessRequestHistoriesDelegatedResourceAccessRequestHistoryCollectionItemArgs'] items: List of DelegatedResourceAccessRequestHistorySummary objects.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDelegatedResourceAccessRequestHistoriesDelegatedResourceAccessRequestHistoryCollectionItemResult']:
        """
        List of DelegatedResourceAccessRequestHistorySummary objects.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDelegatedResourceAccessRequestHistoriesDelegatedResourceAccessRequestHistoryCollectionItemResult(dict):
    def __init__(__self__, *,
                 comment: str,
                 request_status: str,
                 state: str,
                 timestamp: str,
                 user_id: str):
        """
        :param str comment: Comment about the status change.
        :param str request_status: The current status of the Delegated Resource Access Request.
        :param str state: The current lifecycle state of the Delegated Resource Access Request.
        :param str timestamp: Time when the respective action happened in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'.
        :param str user_id: ID of user who modified the Delegated Resource Access Request. For operator, this field is "Operator".
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "request_status", request_status)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "timestamp", timestamp)
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def comment(self) -> str:
        """
        Comment about the status change.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="requestStatus")
    def request_status(self) -> str:
        """
        The current status of the Delegated Resource Access Request.
        """
        return pulumi.get(self, "request_status")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifecycle state of the Delegated Resource Access Request.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def timestamp(self) -> str:
        """
        Time when the respective action happened in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'.
        """
        return pulumi.get(self, "timestamp")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        ID of user who modified the Delegated Resource Access Request. For operator, this field is "Operator".
        """
        return pulumi.get(self, "user_id")


@pulumi.output_type
class GetDelegatedResourceAccessRequestHistoriesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDelegatedResourceAccessRequestsDelegatedResourceAccessRequestSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDelegatedResourceAccessRequestsDelegatedResourceAccessRequestSummaryCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDelegatedResourceAccessRequestsDelegatedResourceAccessRequestSummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDelegatedResourceAccessRequestsDelegatedResourceAccessRequestSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 approval_infos: Sequence['outputs.GetDelegatedResourceAccessRequestsDelegatedResourceAccessRequestSummaryCollectionItemApprovalInfoResult'],
                 audit_types: Sequence[str],
                 closure_comment: str,
                 compartment_id: str,
                 database_name_lists: Sequence[str],
                 defined_tags: Mapping[str, str],
                 delegation_control_id: str,
                 delegation_subscription_ids: Sequence[str],
                 description: str,
                 display_name: str,
                 duration_in_hours: int,
                 extend_duration_in_hours: int,
                 freeform_tags: Mapping[str, str],
                 id: str,
                 is_auto_approved: bool,
                 is_pending_more_info: bool,
                 lifecycle_state_details: str,
                 num_extension_approvals: int,
                 num_initial_approvals: int,
                 provided_service_types: Sequence[str],
                 reason_for_request: str,
                 request_status: str,
                 requested_action_names: Sequence[str],
                 requester_type: str,
                 resource_id: str,
                 resource_name: str,
                 resource_type: str,
                 severity: str,
                 state: str,
                 system_tags: Mapping[str, str],
                 ticket_numbers: Sequence[str],
                 time_access_requested: str,
                 time_created: str,
                 time_updated: str):
        """
        :param Sequence['GetDelegatedResourceAccessRequestsDelegatedResourceAccessRequestSummaryCollectionItemApprovalInfoArgs'] approval_infos: In case of single approval, this will have only one item. Else, a list of approvals.
        :param Sequence[str] audit_types: Specifies the type of auditing to be enabled. There are two levels of auditing: command-level and keystroke-level.  By default, both command-level and keystroke-level auditing are enabled, i.e. commands and key strokes issued by the support operator are logged.
        :param str closure_comment: The comment entered by the support operator while closing the request.
        :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param Sequence[str] database_name_lists: List of Database unique names for which access is requested. This parameter is required for DLGT_MGMT_SYS_MAINT_ACCESS cage when database access in needed.
        :param Mapping[str, str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param str delegation_control_id: unique Delegation Control identifier
        :param Sequence[str] delegation_subscription_ids: List of Delegation Subscription OCID that are associated with this Delegated Resource Access Request based on the service types being requested.
        :param str description: Detailed description of this Delegated Resource Access Request.
        :param str display_name: Display name. This is generated by the system automatically.
        :param int duration_in_hours: Duration in hours for which access is sought on the target resource.
        :param int extend_duration_in_hours: Duration in hours for which extension access is sought on the target resource.
        :param Mapping[str, str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param str id: The OCID of the Delegated Resource Access Request.
        :param bool is_auto_approved: Set to true if the request is approved automatically based on preApprovedServiceProviderActionNames or isAutoApproveDuringMaintenance in the associated Delegation Control.
        :param bool is_pending_more_info: Indicates if the delegated resource access request is waiting on more information from the operator
        :param str lifecycle_state_details: Description of the current lifecycle state in more detail.
        :param int num_extension_approvals: Number of extension approvals that have been obtained so far.
        :param int num_initial_approvals: Number of initial approvals that have been obtained so far.
        :param Sequence[str] provided_service_types: List of Service Provider Service Types being provided by the support operator user.
        :param str reason_for_request: A short description explaining why this Delegated Resource Access Request is needed by the support operator.
        :param str request_status: A filter to return only Delegated Resource Access Requests whose status matches the given Delegated Resource Access Request status.
        :param Sequence[str] requested_action_names: List of Service Provider Action names for which approval is sought by the support operator user. The list of pre-defined Service Provider Actions can be obtained from the ListServiceProviderActions API.
        :param str requester_type: Requester type
        :param str resource_id: A filter to return only Delegated Resource Access Requests for the given resource identifier.
        :param str resource_name: The name of the target resource associated with the Delegated Resource Access Request. The support operator raises a Delegated Resource Access Request to get approval to  access the target resource.
        :param str resource_type: Resource type for which the associated Delegation Control is applicable to.
        :param str severity: Priority assigned to the Delegated Resource Access Request by the support operator
        :param str state: A filter to return only Delegated Resource Access Requests whose lifecycleState matches the given Delegated Resource Access Request lifecycleState.
        :param Mapping[str, str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param Sequence[str] ticket_numbers: A list of ticket numbers related to this Delegated Resource Access Request, e.g. Service Request (SR) number and JIRA ticket number.
        :param str time_access_requested: Requested access start time in UTC.
        :param str time_created: Time when the Delegated Resource Access Request was created in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'.
        :param str time_updated: Time when the Delegated Resource Access Request was last modified in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'.
        """
        pulumi.set(__self__, "approval_infos", approval_infos)
        pulumi.set(__self__, "audit_types", audit_types)
        pulumi.set(__self__, "closure_comment", closure_comment)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "database_name_lists", database_name_lists)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "delegation_control_id", delegation_control_id)
        pulumi.set(__self__, "delegation_subscription_ids", delegation_subscription_ids)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "duration_in_hours", duration_in_hours)
        pulumi.set(__self__, "extend_duration_in_hours", extend_duration_in_hours)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_auto_approved", is_auto_approved)
        pulumi.set(__self__, "is_pending_more_info", is_pending_more_info)
        pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)
        pulumi.set(__self__, "num_extension_approvals", num_extension_approvals)
        pulumi.set(__self__, "num_initial_approvals", num_initial_approvals)
        pulumi.set(__self__, "provided_service_types", provided_service_types)
        pulumi.set(__self__, "reason_for_request", reason_for_request)
        pulumi.set(__self__, "request_status", request_status)
        pulumi.set(__self__, "requested_action_names", requested_action_names)
        pulumi.set(__self__, "requester_type", requester_type)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_name", resource_name)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "ticket_numbers", ticket_numbers)
        pulumi.set(__self__, "time_access_requested", time_access_requested)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="approvalInfos")
    def approval_infos(self) -> Sequence['outputs.GetDelegatedResourceAccessRequestsDelegatedResourceAccessRequestSummaryCollectionItemApprovalInfoResult']:
        """
        In case of single approval, this will have only one item. Else, a list of approvals.
        """
        return pulumi.get(self, "approval_infos")

    @property
    @pulumi.getter(name="auditTypes")
    def audit_types(self) -> Sequence[str]:
        """
        Specifies the type of auditing to be enabled. There are two levels of auditing: command-level and keystroke-level.  By default, both command-level and keystroke-level auditing are enabled, i.e. commands and key strokes issued by the support operator are logged.
        """
        return pulumi.get(self, "audit_types")

    @property
    @pulumi.getter(name="closureComment")
    def closure_comment(self) -> str:
        """
        The comment entered by the support operator while closing the request.
        """
        return pulumi.get(self, "closure_comment")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="databaseNameLists")
    def database_name_lists(self) -> Sequence[str]:
        """
        List of Database unique names for which access is requested. This parameter is required for DLGT_MGMT_SYS_MAINT_ACCESS cage when database access in needed.
        """
        return pulumi.get(self, "database_name_lists")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="delegationControlId")
    def delegation_control_id(self) -> str:
        """
        unique Delegation Control identifier
        """
        return pulumi.get(self, "delegation_control_id")

    @property
    @pulumi.getter(name="delegationSubscriptionIds")
    def delegation_subscription_ids(self) -> Sequence[str]:
        """
        List of Delegation Subscription OCID that are associated with this Delegated Resource Access Request based on the service types being requested.
        """
        return pulumi.get(self, "delegation_subscription_ids")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Detailed description of this Delegated Resource Access Request.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Display name. This is generated by the system automatically.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="durationInHours")
    def duration_in_hours(self) -> int:
        """
        Duration in hours for which access is sought on the target resource.
        """
        return pulumi.get(self, "duration_in_hours")

    @property
    @pulumi.getter(name="extendDurationInHours")
    def extend_duration_in_hours(self) -> int:
        """
        Duration in hours for which extension access is sought on the target resource.
        """
        return pulumi.get(self, "extend_duration_in_hours")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the Delegated Resource Access Request.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAutoApproved")
    def is_auto_approved(self) -> bool:
        """
        Set to true if the request is approved automatically based on preApprovedServiceProviderActionNames or isAutoApproveDuringMaintenance in the associated Delegation Control.
        """
        return pulumi.get(self, "is_auto_approved")

    @property
    @pulumi.getter(name="isPendingMoreInfo")
    def is_pending_more_info(self) -> bool:
        """
        Indicates if the delegated resource access request is waiting on more information from the operator
        """
        return pulumi.get(self, "is_pending_more_info")

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> str:
        """
        Description of the current lifecycle state in more detail.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @property
    @pulumi.getter(name="numExtensionApprovals")
    def num_extension_approvals(self) -> int:
        """
        Number of extension approvals that have been obtained so far.
        """
        return pulumi.get(self, "num_extension_approvals")

    @property
    @pulumi.getter(name="numInitialApprovals")
    def num_initial_approvals(self) -> int:
        """
        Number of initial approvals that have been obtained so far.
        """
        return pulumi.get(self, "num_initial_approvals")

    @property
    @pulumi.getter(name="providedServiceTypes")
    def provided_service_types(self) -> Sequence[str]:
        """
        List of Service Provider Service Types being provided by the support operator user.
        """
        return pulumi.get(self, "provided_service_types")

    @property
    @pulumi.getter(name="reasonForRequest")
    def reason_for_request(self) -> str:
        """
        A short description explaining why this Delegated Resource Access Request is needed by the support operator.
        """
        return pulumi.get(self, "reason_for_request")

    @property
    @pulumi.getter(name="requestStatus")
    def request_status(self) -> str:
        """
        A filter to return only Delegated Resource Access Requests whose status matches the given Delegated Resource Access Request status.
        """
        return pulumi.get(self, "request_status")

    @property
    @pulumi.getter(name="requestedActionNames")
    def requested_action_names(self) -> Sequence[str]:
        """
        List of Service Provider Action names for which approval is sought by the support operator user. The list of pre-defined Service Provider Actions can be obtained from the ListServiceProviderActions API.
        """
        return pulumi.get(self, "requested_action_names")

    @property
    @pulumi.getter(name="requesterType")
    def requester_type(self) -> str:
        """
        Requester type
        """
        return pulumi.get(self, "requester_type")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        A filter to return only Delegated Resource Access Requests for the given resource identifier.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> str:
        """
        The name of the target resource associated with the Delegated Resource Access Request. The support operator raises a Delegated Resource Access Request to get approval to  access the target resource.
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        Resource type for which the associated Delegation Control is applicable to.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        Priority assigned to the Delegated Resource Access Request by the support operator
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only Delegated Resource Access Requests whose lifecycleState matches the given Delegated Resource Access Request lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="ticketNumbers")
    def ticket_numbers(self) -> Sequence[str]:
        """
        A list of ticket numbers related to this Delegated Resource Access Request, e.g. Service Request (SR) number and JIRA ticket number.
        """
        return pulumi.get(self, "ticket_numbers")

    @property
    @pulumi.getter(name="timeAccessRequested")
    def time_access_requested(self) -> str:
        """
        Requested access start time in UTC.
        """
        return pulumi.get(self, "time_access_requested")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Time when the Delegated Resource Access Request was created in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        Time when the Delegated Resource Access Request was last modified in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetDelegatedResourceAccessRequestsDelegatedResourceAccessRequestSummaryCollectionItemApprovalInfoResult(dict):
    def __init__(__self__, *,
                 approval_action: str,
                 approval_type: str,
                 approver_additional_message: str,
                 approver_comment: str,
                 approver_id: str,
                 time_approved_for_access: str):
        """
        :param str approval_action: Indicated whether the request is approved or rejected.
        :param str approval_type: approval type, initial or extension
        :param str approver_additional_message: Additional message specified by the approver of the request.
        :param str approver_comment: Comment specified by the approver of the request.
        :param str approver_id: User ID of the approver.
        :param str time_approved_for_access: Access start time that is actually approved by the customer in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'.
        """
        pulumi.set(__self__, "approval_action", approval_action)
        pulumi.set(__self__, "approval_type", approval_type)
        pulumi.set(__self__, "approver_additional_message", approver_additional_message)
        pulumi.set(__self__, "approver_comment", approver_comment)
        pulumi.set(__self__, "approver_id", approver_id)
        pulumi.set(__self__, "time_approved_for_access", time_approved_for_access)

    @property
    @pulumi.getter(name="approvalAction")
    def approval_action(self) -> str:
        """
        Indicated whether the request is approved or rejected.
        """
        return pulumi.get(self, "approval_action")

    @property
    @pulumi.getter(name="approvalType")
    def approval_type(self) -> str:
        """
        approval type, initial or extension
        """
        return pulumi.get(self, "approval_type")

    @property
    @pulumi.getter(name="approverAdditionalMessage")
    def approver_additional_message(self) -> str:
        """
        Additional message specified by the approver of the request.
        """
        return pulumi.get(self, "approver_additional_message")

    @property
    @pulumi.getter(name="approverComment")
    def approver_comment(self) -> str:
        """
        Comment specified by the approver of the request.
        """
        return pulumi.get(self, "approver_comment")

    @property
    @pulumi.getter(name="approverId")
    def approver_id(self) -> str:
        """
        User ID of the approver.
        """
        return pulumi.get(self, "approver_id")

    @property
    @pulumi.getter(name="timeApprovedForAccess")
    def time_approved_for_access(self) -> str:
        """
        Access start time that is actually approved by the customer in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'.
        """
        return pulumi.get(self, "time_approved_for_access")


@pulumi.output_type
class GetDelegatedResourceAccessRequestsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDelegationControlResourcesDelegationControlResourceCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDelegationControlResourcesDelegationControlResourceCollectionItemResult']):
        """
        :param Sequence['GetDelegationControlResourcesDelegationControlResourceCollectionItemArgs'] items: List of DelegationControlResourceSummary objects.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDelegationControlResourcesDelegationControlResourceCollectionItemResult']:
        """
        List of DelegationControlResourceSummary objects.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDelegationControlResourcesDelegationControlResourceCollectionItemResult(dict):
    def __init__(__self__, *,
                 id: str,
                 resource_status: str):
        """
        :param str id: OCID of the resource.
        :param str resource_status: The current status of the resource in Delegation Control.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "resource_status", resource_status)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        OCID of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resourceStatus")
    def resource_status(self) -> str:
        """
        The current status of the resource in Delegation Control.
        """
        return pulumi.get(self, "resource_status")


@pulumi.output_type
class GetDelegationControlResourcesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDelegationControlsDelegationControlSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDelegationControlsDelegationControlSummaryCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDelegationControlsDelegationControlSummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDelegationControlsDelegationControlSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, str],
                 delegation_subscription_ids: Sequence[str],
                 description: str,
                 display_name: str,
                 freeform_tags: Mapping[str, str],
                 id: str,
                 is_auto_approve_during_maintenance: bool,
                 lifecycle_state_details: str,
                 notification_message_format: str,
                 notification_topic_id: str,
                 num_approvals_required: int,
                 pre_approved_service_provider_action_names: Sequence[str],
                 resource_ids: Sequence[str],
                 resource_type: str,
                 state: str,
                 system_tags: Mapping[str, str],
                 time_created: str,
                 time_deleted: str,
                 time_updated: str,
                 vault_id: str,
                 vault_key_id: str):
        """
        :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param Mapping[str, str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param Sequence[str] delegation_subscription_ids: List of Delegation Subscription OCID that are allowed for this Delegation Control. The allowed subscriptions will determine the available Service Provider Actions. Only support operators for the allowed subscriptions are allowed to create Delegated Resource Access Request.
        :param str description: Description of the Delegation Control.
        :param str display_name: A filter to return Delegation Control resources that match the given display name.
        :param Mapping[str, str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param str id: The OCID of the Delegation Control.
        :param bool is_auto_approve_during_maintenance: Set to true to allow all Delegated Resource Access Request to be approved automatically during maintenance.
        :param str lifecycle_state_details: Description of the current lifecycle state in more detail.
        :param str notification_message_format: The format of the Oracle Cloud Infrastructure Notification messages for this Delegation Control.
        :param str notification_topic_id: The OCID of the Oracle Cloud Infrastructure Notification topic to publish messages related to this Delegation Control.
        :param int num_approvals_required: number of approvals required.
        :param Sequence[str] pre_approved_service_provider_action_names: List of pre-approved Service Provider Action names. The list of pre-defined Service Provider Actions can be obtained from the ListServiceProviderActions API. Delegated Resource Access Requests associated with a resource governed by this Delegation Control will be automatically approved if the Delegated Resource Access Request only contain Service Provider Actions in the pre-approved list.
        :param Sequence[str] resource_ids: The OCID of the selected resources that this Delegation Control is applicable to.
        :param str resource_type: A filter to return only resources that match the given resource type.
        :param str state: A filter to return only Delegation Control resources whose lifecycleState matches the given Delegation Control lifecycle state.
        :param Mapping[str, str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: Time when the Delegation Control was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        :param str time_deleted: Time when the Delegation Control was deleted expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'. Note a deleted Delegation Control still stays in the system, so that you can still audit Service Provider Actions associated with Delegated Resource Access Requests raised on target resources governed by the deleted Delegation Control.
        :param str time_updated: Time when the Delegation Control was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        :param str vault_id: The OCID of the Oracle Cloud Infrastructure Vault that will store the secrets containing the SSH keys to access the resource governed by this Delegation Control by Delegate Access Control Service. This property is required when resourceType is CLOUDVMCLUSTER. Delegate Access Control Service will generate the SSH keys and store them as secrets in the Oracle Cloud Infrastructure Vault.
        :param str vault_key_id: The OCID of the Master Encryption Key in the Oracle Cloud Infrastructure Vault specified by vaultId. This key will be used to encrypt the SSH keys to access the resource governed by this Delegation Control by Delegate Access Control Service. This property is required when resourceType is CLOUDVMCLUSTER.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "delegation_subscription_ids", delegation_subscription_ids)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_auto_approve_during_maintenance", is_auto_approve_during_maintenance)
        pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)
        pulumi.set(__self__, "notification_message_format", notification_message_format)
        pulumi.set(__self__, "notification_topic_id", notification_topic_id)
        pulumi.set(__self__, "num_approvals_required", num_approvals_required)
        pulumi.set(__self__, "pre_approved_service_provider_action_names", pre_approved_service_provider_action_names)
        pulumi.set(__self__, "resource_ids", resource_ids)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_deleted", time_deleted)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "vault_id", vault_id)
        pulumi.set(__self__, "vault_key_id", vault_key_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="delegationSubscriptionIds")
    def delegation_subscription_ids(self) -> Sequence[str]:
        """
        List of Delegation Subscription OCID that are allowed for this Delegation Control. The allowed subscriptions will determine the available Service Provider Actions. Only support operators for the allowed subscriptions are allowed to create Delegated Resource Access Request.
        """
        return pulumi.get(self, "delegation_subscription_ids")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the Delegation Control.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return Delegation Control resources that match the given display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the Delegation Control.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAutoApproveDuringMaintenance")
    def is_auto_approve_during_maintenance(self) -> bool:
        """
        Set to true to allow all Delegated Resource Access Request to be approved automatically during maintenance.
        """
        return pulumi.get(self, "is_auto_approve_during_maintenance")

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> str:
        """
        Description of the current lifecycle state in more detail.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @property
    @pulumi.getter(name="notificationMessageFormat")
    def notification_message_format(self) -> str:
        """
        The format of the Oracle Cloud Infrastructure Notification messages for this Delegation Control.
        """
        return pulumi.get(self, "notification_message_format")

    @property
    @pulumi.getter(name="notificationTopicId")
    def notification_topic_id(self) -> str:
        """
        The OCID of the Oracle Cloud Infrastructure Notification topic to publish messages related to this Delegation Control.
        """
        return pulumi.get(self, "notification_topic_id")

    @property
    @pulumi.getter(name="numApprovalsRequired")
    def num_approvals_required(self) -> int:
        """
        number of approvals required.
        """
        return pulumi.get(self, "num_approvals_required")

    @property
    @pulumi.getter(name="preApprovedServiceProviderActionNames")
    def pre_approved_service_provider_action_names(self) -> Sequence[str]:
        """
        List of pre-approved Service Provider Action names. The list of pre-defined Service Provider Actions can be obtained from the ListServiceProviderActions API. Delegated Resource Access Requests associated with a resource governed by this Delegation Control will be automatically approved if the Delegated Resource Access Request only contain Service Provider Actions in the pre-approved list.
        """
        return pulumi.get(self, "pre_approved_service_provider_action_names")

    @property
    @pulumi.getter(name="resourceIds")
    def resource_ids(self) -> Sequence[str]:
        """
        The OCID of the selected resources that this Delegation Control is applicable to.
        """
        return pulumi.get(self, "resource_ids")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        A filter to return only resources that match the given resource type.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only Delegation Control resources whose lifecycleState matches the given Delegation Control lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Time when the Delegation Control was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeDeleted")
    def time_deleted(self) -> str:
        """
        Time when the Delegation Control was deleted expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'. Note a deleted Delegation Control still stays in the system, so that you can still audit Service Provider Actions associated with Delegated Resource Access Requests raised on target resources governed by the deleted Delegation Control.
        """
        return pulumi.get(self, "time_deleted")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        Time when the Delegation Control was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        The OCID of the Oracle Cloud Infrastructure Vault that will store the secrets containing the SSH keys to access the resource governed by this Delegation Control by Delegate Access Control Service. This property is required when resourceType is CLOUDVMCLUSTER. Delegate Access Control Service will generate the SSH keys and store them as secrets in the Oracle Cloud Infrastructure Vault.
        """
        return pulumi.get(self, "vault_id")

    @property
    @pulumi.getter(name="vaultKeyId")
    def vault_key_id(self) -> str:
        """
        The OCID of the Master Encryption Key in the Oracle Cloud Infrastructure Vault specified by vaultId. This key will be used to encrypt the SSH keys to access the resource governed by this Delegation Control by Delegate Access Control Service. This property is required when resourceType is CLOUDVMCLUSTER.
        """
        return pulumi.get(self, "vault_key_id")


@pulumi.output_type
class GetDelegationControlsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDelegationSubscriptionsDelegationSubscriptionSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDelegationSubscriptionsDelegationSubscriptionSummaryCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDelegationSubscriptionsDelegationSubscriptionSummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDelegationSubscriptionsDelegationSubscriptionSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, str],
                 description: str,
                 display_name: str,
                 freeform_tags: Mapping[str, str],
                 id: str,
                 lifecycle_state_details: str,
                 service_provider_id: str,
                 state: str,
                 subscribed_service_type: str,
                 system_tags: Mapping[str, str],
                 time_created: str,
                 time_updated: str):
        """
        :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param Mapping[str, str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param str description: Description of the Delegation Subscription.
        :param str display_name: A filter to return Delegation Subscription resources that match the given display name.
        :param Mapping[str, str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param str id: Unique identifier for the Delegation Subscription.
        :param str lifecycle_state_details: Description of the current lifecycle state in more detail.
        :param str service_provider_id: Unique identifier of the Service Provider.
        :param str state: A filter to return only Delegation Subscription resources whose lifecycleState matches the given Delegation Subscription lifecycle state.
        :param str subscribed_service_type: Subscribed Service Provider Service Type.
        :param Mapping[str, str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: Time when the Service Provider was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        :param str time_updated: Time when the Service Provider was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)
        pulumi.set(__self__, "service_provider_id", service_provider_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subscribed_service_type", subscribed_service_type)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the Delegation Subscription.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return Delegation Subscription resources that match the given display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier for the Delegation Subscription.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> str:
        """
        Description of the current lifecycle state in more detail.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @property
    @pulumi.getter(name="serviceProviderId")
    def service_provider_id(self) -> str:
        """
        Unique identifier of the Service Provider.
        """
        return pulumi.get(self, "service_provider_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only Delegation Subscription resources whose lifecycleState matches the given Delegation Subscription lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subscribedServiceType")
    def subscribed_service_type(self) -> str:
        """
        Subscribed Service Provider Service Type.
        """
        return pulumi.get(self, "subscribed_service_type")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Time when the Service Provider was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        Time when the Service Provider was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetDelegationSubscriptionsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetServiceProviderActionPropertyResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: Name of the property
        :param str value: value of the property
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        value of the property
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServiceProviderActionsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A filter to return only resources that match the entire name given.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the entire name given.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetServiceProviderActionsServiceProviderActionSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetServiceProviderActionsServiceProviderActionSummaryCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetServiceProviderActionsServiceProviderActionSummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetServiceProviderActionsServiceProviderActionSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 component: str,
                 customer_display_name: str,
                 description: str,
                 id: str,
                 name: str,
                 properties: Sequence['outputs.GetServiceProviderActionsServiceProviderActionSummaryCollectionItemPropertyResult'],
                 resource_type: str,
                 service_provider_service_types: Sequence[str],
                 state: str):
        """
        :param str component: Name of the infrastructure layer associated with the Service Provider Action.
        :param str customer_display_name: Display Name of the Service Provider Action.
        :param str description: Description of the Service Provider Action in terms of associated risk profile, and characteristics of the operating system commands made available to the support operator under this Service Provider Action.
        :param str id: Unique Oracle assigned identifier for the Service Provider Action.
        :param str name: A filter to return only resources that match the entire name given.
        :param Sequence['GetServiceProviderActionsServiceProviderActionSummaryCollectionItemPropertyArgs'] properties: Fine grained properties associated with the Delegation Control.
        :param str resource_type: A filter to return only resources that match the given resource type.
        :param Sequence[str] service_provider_service_types: List of Service Provider Service Types that this Service Provider Action is applicable to.
        :param str state: A filter to return only resources whose lifecycleState matches the given Service Provider Action lifecycleState.
        """
        pulumi.set(__self__, "component", component)
        pulumi.set(__self__, "customer_display_name", customer_display_name)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "service_provider_service_types", service_provider_service_types)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def component(self) -> str:
        """
        Name of the infrastructure layer associated with the Service Provider Action.
        """
        return pulumi.get(self, "component")

    @property
    @pulumi.getter(name="customerDisplayName")
    def customer_display_name(self) -> str:
        """
        Display Name of the Service Provider Action.
        """
        return pulumi.get(self, "customer_display_name")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the Service Provider Action in terms of associated risk profile, and characteristics of the operating system commands made available to the support operator under this Service Provider Action.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique Oracle assigned identifier for the Service Provider Action.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the entire name given.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> Sequence['outputs.GetServiceProviderActionsServiceProviderActionSummaryCollectionItemPropertyResult']:
        """
        Fine grained properties associated with the Delegation Control.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        A filter to return only resources that match the given resource type.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter(name="serviceProviderServiceTypes")
    def service_provider_service_types(self) -> Sequence[str]:
        """
        List of Service Provider Service Types that this Service Provider Action is applicable to.
        """
        return pulumi.get(self, "service_provider_service_types")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources whose lifecycleState matches the given Service Provider Action lifecycleState.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetServiceProviderActionsServiceProviderActionSummaryCollectionItemPropertyResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: A filter to return only resources that match the entire name given.
        :param str value: value of the property
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the entire name given.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        value of the property
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServiceProvidersFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A filter to return Service Provider resources that match the given name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return Service Provider resources that match the given name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetServiceProvidersServiceProviderSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetServiceProvidersServiceProviderSummaryCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetServiceProvidersServiceProviderSummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetServiceProvidersServiceProviderSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, str],
                 description: str,
                 freeform_tags: Mapping[str, str],
                 id: str,
                 lifecycle_state_details: str,
                 name: str,
                 service_provider_type: str,
                 service_types: Sequence[str],
                 state: str,
                 supported_resource_types: Sequence[str],
                 system_tags: Mapping[str, str],
                 time_created: str,
                 time_updated: str):
        """
        :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param Mapping[str, str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param str description: Description of the Service Provider.
        :param Mapping[str, str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param str id: Unique identifier for the Service Provider.
        :param str lifecycle_state_details: Description of the current lifecycle state in more detail.
        :param str name: A filter to return Service Provider resources that match the given name.
        :param str service_provider_type: A filter to return only Service Provider resources whose provider type matches the given provider type.
        :param Sequence[str] service_types: Types of services offered by this provider.
        :param str state: A filter to return only Service Provider resources whose lifecycleState matches the given Service Provider lifecycle state.
        :param Sequence[str] supported_resource_types: Resource types for which this provider will provide service. Default to all if not specified.
        :param Mapping[str, str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: Time when the Service Provider was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        :param str time_updated: Time when the Service Provider was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "service_provider_type", service_provider_type)
        pulumi.set(__self__, "service_types", service_types)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "supported_resource_types", supported_resource_types)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the Service Provider.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier for the Service Provider.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> str:
        """
        Description of the current lifecycle state in more detail.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return Service Provider resources that match the given name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceProviderType")
    def service_provider_type(self) -> str:
        """
        A filter to return only Service Provider resources whose provider type matches the given provider type.
        """
        return pulumi.get(self, "service_provider_type")

    @property
    @pulumi.getter(name="serviceTypes")
    def service_types(self) -> Sequence[str]:
        """
        Types of services offered by this provider.
        """
        return pulumi.get(self, "service_types")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only Service Provider resources whose lifecycleState matches the given Service Provider lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="supportedResourceTypes")
    def supported_resource_types(self) -> Sequence[str]:
        """
        Resource types for which this provider will provide service. Default to all if not specified.
        """
        return pulumi.get(self, "supported_resource_types")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Time when the Service Provider was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        Time when the Service Provider was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_updated")


