# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetDrPlanExecutionResult',
    'AwaitableGetDrPlanExecutionResult',
    'get_dr_plan_execution',
    'get_dr_plan_execution_output',
]

@pulumi.output_type
class GetDrPlanExecutionResult:
    """
    A collection of values returned by getDrPlanExecution.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, display_name=None, dr_plan_execution_id=None, dr_protection_group_id=None, execution_duration_in_sec=None, execution_options=None, freeform_tags=None, group_executions=None, id=None, life_cycle_details=None, log_locations=None, peer_dr_protection_group_id=None, peer_region=None, plan_execution_type=None, plan_id=None, state=None, system_tags=None, time_created=None, time_ended=None, time_started=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if dr_plan_execution_id and not isinstance(dr_plan_execution_id, str):
            raise TypeError("Expected argument 'dr_plan_execution_id' to be a str")
        pulumi.set(__self__, "dr_plan_execution_id", dr_plan_execution_id)
        if dr_protection_group_id and not isinstance(dr_protection_group_id, str):
            raise TypeError("Expected argument 'dr_protection_group_id' to be a str")
        pulumi.set(__self__, "dr_protection_group_id", dr_protection_group_id)
        if execution_duration_in_sec and not isinstance(execution_duration_in_sec, int):
            raise TypeError("Expected argument 'execution_duration_in_sec' to be a int")
        pulumi.set(__self__, "execution_duration_in_sec", execution_duration_in_sec)
        if execution_options and not isinstance(execution_options, list):
            raise TypeError("Expected argument 'execution_options' to be a list")
        pulumi.set(__self__, "execution_options", execution_options)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if group_executions and not isinstance(group_executions, list):
            raise TypeError("Expected argument 'group_executions' to be a list")
        pulumi.set(__self__, "group_executions", group_executions)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if life_cycle_details and not isinstance(life_cycle_details, str):
            raise TypeError("Expected argument 'life_cycle_details' to be a str")
        pulumi.set(__self__, "life_cycle_details", life_cycle_details)
        if log_locations and not isinstance(log_locations, list):
            raise TypeError("Expected argument 'log_locations' to be a list")
        pulumi.set(__self__, "log_locations", log_locations)
        if peer_dr_protection_group_id and not isinstance(peer_dr_protection_group_id, str):
            raise TypeError("Expected argument 'peer_dr_protection_group_id' to be a str")
        pulumi.set(__self__, "peer_dr_protection_group_id", peer_dr_protection_group_id)
        if peer_region and not isinstance(peer_region, str):
            raise TypeError("Expected argument 'peer_region' to be a str")
        pulumi.set(__self__, "peer_region", peer_region)
        if plan_execution_type and not isinstance(plan_execution_type, str):
            raise TypeError("Expected argument 'plan_execution_type' to be a str")
        pulumi.set(__self__, "plan_execution_type", plan_execution_type)
        if plan_id and not isinstance(plan_id, str):
            raise TypeError("Expected argument 'plan_id' to be a str")
        pulumi.set(__self__, "plan_id", plan_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_ended and not isinstance(time_ended, str):
            raise TypeError("Expected argument 'time_ended' to be a str")
        pulumi.set(__self__, "time_ended", time_ended)
        if time_started and not isinstance(time_started, str):
            raise TypeError("Expected argument 'time_started' to be a str")
        pulumi.set(__self__, "time_started", time_started)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment containing this DR plan execution.  Example: `ocid1.compartment.oc1..uniqueID`
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the step execution.  Example: `DATABASE_SWITCHOVER`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="drPlanExecutionId")
    def dr_plan_execution_id(self) -> str:
        return pulumi.get(self, "dr_plan_execution_id")

    @property
    @pulumi.getter(name="drProtectionGroupId")
    def dr_protection_group_id(self) -> str:
        """
        The OCID of the DR protection group to which this DR plan execution belongs.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
        """
        return pulumi.get(self, "dr_protection_group_id")

    @property
    @pulumi.getter(name="executionDurationInSec")
    def execution_duration_in_sec(self) -> int:
        """
        The total duration in seconds taken to complete the step execution.  Example: `35`
        """
        return pulumi.get(self, "execution_duration_in_sec")

    @property
    @pulumi.getter(name="executionOptions")
    def execution_options(self) -> Sequence['outputs.GetDrPlanExecutionExecutionOptionResult']:
        """
        The options for a plan execution.
        """
        return pulumi.get(self, "execution_options")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="groupExecutions")
    def group_executions(self) -> Sequence['outputs.GetDrPlanExecutionGroupExecutionResult']:
        """
        A list of groups executed in this DR plan execution.
        """
        return pulumi.get(self, "group_executions")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the DR plan execution.  Example: `ocid1.drplanexecution.oc1..uniqueID`
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifeCycleDetails")
    def life_cycle_details(self) -> str:
        """
        A message describing the DR plan execution's current state in more detail.
        """
        return pulumi.get(self, "life_cycle_details")

    @property
    @pulumi.getter(name="logLocations")
    def log_locations(self) -> Sequence['outputs.GetDrPlanExecutionLogLocationResult']:
        """
        The details of an object storage log location for a DR protection group.
        """
        return pulumi.get(self, "log_locations")

    @property
    @pulumi.getter(name="peerDrProtectionGroupId")
    def peer_dr_protection_group_id(self) -> str:
        """
        The OCID of peer DR protection group associated with this plan's DR protection group.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
        """
        return pulumi.get(self, "peer_dr_protection_group_id")

    @property
    @pulumi.getter(name="peerRegion")
    def peer_region(self) -> str:
        """
        The region of the peer DR protection group associated with this plan's DR protection group.  Example: `us-ashburn-1`
        """
        return pulumi.get(self, "peer_region")

    @property
    @pulumi.getter(name="planExecutionType")
    def plan_execution_type(self) -> str:
        """
        The type of the DR plan executed.
        """
        return pulumi.get(self, "plan_execution_type")

    @property
    @pulumi.getter(name="planId")
    def plan_id(self) -> str:
        """
        The OCID of the DR plan.  Example: `ocid1.drplan.oc1..uniqueID`
        """
        return pulumi.get(self, "plan_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the DR plan execution.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time at which DR plan execution was created. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> str:
        """
        The date and time at which DR plan execution succeeded, failed, was paused, or was canceled. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_ended")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> str:
        """
        The date and time at which DR plan execution began. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_started")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time when DR plan execution was last updated. An RFC3339 formatted datetime string.  Example: `2019-03-29T09:36:42Z`
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetDrPlanExecutionResult(GetDrPlanExecutionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDrPlanExecutionResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            dr_plan_execution_id=self.dr_plan_execution_id,
            dr_protection_group_id=self.dr_protection_group_id,
            execution_duration_in_sec=self.execution_duration_in_sec,
            execution_options=self.execution_options,
            freeform_tags=self.freeform_tags,
            group_executions=self.group_executions,
            id=self.id,
            life_cycle_details=self.life_cycle_details,
            log_locations=self.log_locations,
            peer_dr_protection_group_id=self.peer_dr_protection_group_id,
            peer_region=self.peer_region,
            plan_execution_type=self.plan_execution_type,
            plan_id=self.plan_id,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_ended=self.time_ended,
            time_started=self.time_started,
            time_updated=self.time_updated)


def get_dr_plan_execution(dr_plan_execution_id: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDrPlanExecutionResult:
    """
    This data source provides details about a specific Dr Plan Execution resource in Oracle Cloud Infrastructure Disaster Recovery service.

    Get details for the DR plan execution identified by *drPlanExecutionId*.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_dr_plan_execution = oci.DisasterRecovery.get_dr_plan_execution(dr_plan_execution_id=test_dr_plan_execution_oci_disaster_recovery_dr_plan_execution["id"])
    ```


    :param str dr_plan_execution_id: The OCID of the DR plan execution.  Example: `ocid1.drplanexecution.oc1..uniqueID`
    """
    __args__ = dict()
    __args__['drPlanExecutionId'] = dr_plan_execution_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DisasterRecovery/getDrPlanExecution:getDrPlanExecution', __args__, opts=opts, typ=GetDrPlanExecutionResult).value

    return AwaitableGetDrPlanExecutionResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        dr_plan_execution_id=pulumi.get(__ret__, 'dr_plan_execution_id'),
        dr_protection_group_id=pulumi.get(__ret__, 'dr_protection_group_id'),
        execution_duration_in_sec=pulumi.get(__ret__, 'execution_duration_in_sec'),
        execution_options=pulumi.get(__ret__, 'execution_options'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        group_executions=pulumi.get(__ret__, 'group_executions'),
        id=pulumi.get(__ret__, 'id'),
        life_cycle_details=pulumi.get(__ret__, 'life_cycle_details'),
        log_locations=pulumi.get(__ret__, 'log_locations'),
        peer_dr_protection_group_id=pulumi.get(__ret__, 'peer_dr_protection_group_id'),
        peer_region=pulumi.get(__ret__, 'peer_region'),
        plan_execution_type=pulumi.get(__ret__, 'plan_execution_type'),
        plan_id=pulumi.get(__ret__, 'plan_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_ended=pulumi.get(__ret__, 'time_ended'),
        time_started=pulumi.get(__ret__, 'time_started'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_dr_plan_execution)
def get_dr_plan_execution_output(dr_plan_execution_id: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDrPlanExecutionResult]:
    """
    This data source provides details about a specific Dr Plan Execution resource in Oracle Cloud Infrastructure Disaster Recovery service.

    Get details for the DR plan execution identified by *drPlanExecutionId*.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_dr_plan_execution = oci.DisasterRecovery.get_dr_plan_execution(dr_plan_execution_id=test_dr_plan_execution_oci_disaster_recovery_dr_plan_execution["id"])
    ```


    :param str dr_plan_execution_id: The OCID of the DR plan execution.  Example: `ocid1.drplanexecution.oc1..uniqueID`
    """
    ...
