# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetResolverResult',
    'AwaitableGetResolverResult',
    'get_resolver',
    'get_resolver_output',
]

@pulumi.output_type
class GetResolverResult:
    """
    A collection of values returned by getResolver.
    """
    def __init__(__self__, attached_vcn_id=None, attached_views=None, compartment_id=None, default_view_id=None, defined_tags=None, display_name=None, endpoints=None, freeform_tags=None, id=None, is_protected=None, resolver_id=None, rules=None, scope=None, self=None, state=None, time_created=None, time_updated=None):
        if attached_vcn_id and not isinstance(attached_vcn_id, str):
            raise TypeError("Expected argument 'attached_vcn_id' to be a str")
        pulumi.set(__self__, "attached_vcn_id", attached_vcn_id)
        if attached_views and not isinstance(attached_views, list):
            raise TypeError("Expected argument 'attached_views' to be a list")
        pulumi.set(__self__, "attached_views", attached_views)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if default_view_id and not isinstance(default_view_id, str):
            raise TypeError("Expected argument 'default_view_id' to be a str")
        pulumi.set(__self__, "default_view_id", default_view_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if endpoints and not isinstance(endpoints, list):
            raise TypeError("Expected argument 'endpoints' to be a list")
        pulumi.set(__self__, "endpoints", endpoints)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_protected and not isinstance(is_protected, bool):
            raise TypeError("Expected argument 'is_protected' to be a bool")
        pulumi.set(__self__, "is_protected", is_protected)
        if resolver_id and not isinstance(resolver_id, str):
            raise TypeError("Expected argument 'resolver_id' to be a str")
        pulumi.set(__self__, "resolver_id", resolver_id)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if scope and not isinstance(scope, str):
            raise TypeError("Expected argument 'scope' to be a str")
        pulumi.set(__self__, "scope", scope)
        if self and not isinstance(self, str):
            raise TypeError("Expected argument 'self' to be a str")
        pulumi.set(__self__, "self", self)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="attachedVcnId")
    def attached_vcn_id(self) -> str:
        """
        The OCID of the attached VCN.
        """
        return pulumi.get(self, "attached_vcn_id")

    @property
    @pulumi.getter(name="attachedViews")
    def attached_views(self) -> Sequence['outputs.GetResolverAttachedViewResult']:
        """
        The attached views. Views are evaluated in order.
        """
        return pulumi.get(self, "attached_views")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the owning compartment. This will match the resolver that the resolver endpoint is under and will be updated if the resolver's compartment is changed.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="defaultViewId")
    def default_view_id(self) -> str:
        """
        The OCID of the default view.
        """
        return pulumi.get(self, "default_view_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the resolver.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.GetResolverEndpointResult']:
        """
        Read-only array of endpoints for the resolver.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the resolver.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isProtected")
    def is_protected(self) -> bool:
        """
        A Boolean flag indicating whether or not parts of the resource are unable to be explicitly managed.
        """
        return pulumi.get(self, "is_protected")

    @property
    @pulumi.getter(name="resolverId")
    def resolver_id(self) -> str:
        return pulumi.get(self, "resolver_id")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetResolverRuleResult']:
        """
        Rules for the resolver. Rules are evaluated in order.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def self(self) -> str:
        """
        The canonical absolute URL of the resource.
        """
        return pulumi.get(self, "self")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the resource was created in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the resource was last updated in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetResolverResult(GetResolverResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResolverResult(
            attached_vcn_id=self.attached_vcn_id,
            attached_views=self.attached_views,
            compartment_id=self.compartment_id,
            default_view_id=self.default_view_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            endpoints=self.endpoints,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_protected=self.is_protected,
            resolver_id=self.resolver_id,
            rules=self.rules,
            scope=self.scope,
            self=self.self,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_resolver(resolver_id: Optional[str] = None,
                 scope: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResolverResult:
    """
    This data source provides details about a specific Resolver resource in Oracle Cloud Infrastructure DNS service.

    Gets information about a specific resolver. Note that attempting to get a
    resolver in the DELETED lifecycleState will result in a `404` response to be
    consistent with other operations of the API. Requires a `PRIVATE` scope query parameter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_resolver = oci.Dns.get_resolver(resolver_id=test_resolver_oci_dns_resolver["id"],
        scope="PRIVATE")
    ```


    :param str resolver_id: The OCID of the target resolver.
    :param str scope: Value must be `PRIVATE` when listing private name resolvers.
    """
    __args__ = dict()
    __args__['resolverId'] = resolver_id
    __args__['scope'] = scope
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Dns/getResolver:getResolver', __args__, opts=opts, typ=GetResolverResult).value

    return AwaitableGetResolverResult(
        attached_vcn_id=pulumi.get(__ret__, 'attached_vcn_id'),
        attached_views=pulumi.get(__ret__, 'attached_views'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        default_view_id=pulumi.get(__ret__, 'default_view_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        endpoints=pulumi.get(__ret__, 'endpoints'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_protected=pulumi.get(__ret__, 'is_protected'),
        resolver_id=pulumi.get(__ret__, 'resolver_id'),
        rules=pulumi.get(__ret__, 'rules'),
        scope=pulumi.get(__ret__, 'scope'),
        self=pulumi.get(__ret__, 'self'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_resolver)
def get_resolver_output(resolver_id: Optional[pulumi.Input[str]] = None,
                        scope: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetResolverResult]:
    """
    This data source provides details about a specific Resolver resource in Oracle Cloud Infrastructure DNS service.

    Gets information about a specific resolver. Note that attempting to get a
    resolver in the DELETED lifecycleState will result in a `404` response to be
    consistent with other operations of the API. Requires a `PRIVATE` scope query parameter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_resolver = oci.Dns.get_resolver(resolver_id=test_resolver_oci_dns_resolver["id"],
        scope="PRIVATE")
    ```


    :param str resolver_id: The OCID of the target resolver.
    :param str scope: Value must be `PRIVATE` when listing private name resolvers.
    """
    ...
