# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetManagementAgentPluginCountResult',
    'AwaitableGetManagementAgentPluginCountResult',
    'get_management_agent_plugin_count',
    'get_management_agent_plugin_count_output',
]

@pulumi.output_type
class GetManagementAgentPluginCountResult:
    """
    A collection of values returned by getManagementAgentPluginCount.
    """
    def __init__(__self__, compartment_id=None, group_by=None, id=None, items=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if group_by and not isinstance(group_by, str):
            raise TypeError("Expected argument 'group_by' to be a str")
        pulumi.set(__self__, "group_by", group_by)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="groupBy")
    def group_by(self) -> str:
        return pulumi.get(self, "group_by")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetManagementAgentPluginCountItemResult']:
        """
        List in which each item describes an aggregation of Managment Agent Plugins
        """
        return pulumi.get(self, "items")


class AwaitableGetManagementAgentPluginCountResult(GetManagementAgentPluginCountResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagementAgentPluginCountResult(
            compartment_id=self.compartment_id,
            group_by=self.group_by,
            id=self.id,
            items=self.items)


def get_management_agent_plugin_count(compartment_id: Optional[str] = None,
                                      group_by: Optional[str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagementAgentPluginCountResult:
    """
    This data source provides details about a specific Management Agent Plugin Count resource in Oracle Cloud Infrastructure Management Agent service.

    Gets count of the inventory of management agent plugins for a given compartment id and group by parameter.
    Supported groupBy parameter: pluginName

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_management_agent_plugin_count = oci.ManagementAgent.get_management_agent_plugin_count(compartment_id=compartment_id,
        group_by=management_agent_plugin_count_group_by)
    ```


    :param str compartment_id: The OCID of the compartment to which a request will be scoped.
    :param str group_by: The field by which to group Management Agent Plugins
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['groupBy'] = group_by
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ManagementAgent/getManagementAgentPluginCount:getManagementAgentPluginCount', __args__, opts=opts, typ=GetManagementAgentPluginCountResult).value

    return AwaitableGetManagementAgentPluginCountResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        group_by=pulumi.get(__ret__, 'group_by'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'))


@_utilities.lift_output_func(get_management_agent_plugin_count)
def get_management_agent_plugin_count_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                             group_by: Optional[pulumi.Input[str]] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagementAgentPluginCountResult]:
    """
    This data source provides details about a specific Management Agent Plugin Count resource in Oracle Cloud Infrastructure Management Agent service.

    Gets count of the inventory of management agent plugins for a given compartment id and group by parameter.
    Supported groupBy parameter: pluginName

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_management_agent_plugin_count = oci.ManagementAgent.get_management_agent_plugin_count(compartment_id=compartment_id,
        group_by=management_agent_plugin_count_group_by)
    ```


    :param str compartment_id: The OCID of the compartment to which a request will be scoped.
    :param str group_by: The field by which to group Management Agent Plugins
    """
    ...
