# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetEdgeSubnetsResult',
    'AwaitableGetEdgeSubnetsResult',
    'get_edge_subnets',
    'get_edge_subnets_output',
]

@pulumi.output_type
class GetEdgeSubnetsResult:
    """
    A collection of values returned by getEdgeSubnets.
    """
    def __init__(__self__, edge_subnets=None, filters=None, id=None):
        if edge_subnets and not isinstance(edge_subnets, list):
            raise TypeError("Expected argument 'edge_subnets' to be a list")
        pulumi.set(__self__, "edge_subnets", edge_subnets)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="edgeSubnets")
    def edge_subnets(self) -> Sequence['outputs.GetEdgeSubnetsEdgeSubnetResult']:
        """
        The list of edge_subnets.
        """
        return pulumi.get(self, "edge_subnets")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetEdgeSubnetsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetEdgeSubnetsResult(GetEdgeSubnetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEdgeSubnetsResult(
            edge_subnets=self.edge_subnets,
            filters=self.filters,
            id=self.id)


def get_edge_subnets(filters: Optional[Sequence[Union['GetEdgeSubnetsFilterArgs', 'GetEdgeSubnetsFilterArgsDict']]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEdgeSubnetsResult:
    """
    This data source provides the list of Edge Subnets in Oracle Cloud Infrastructure Web Application Acceleration and Security service.

    Return the list of the tenant's edge node subnets. Use these CIDR blocks to restrict incoming traffic to your origin. These subnets are owned by Oracle Cloud Infrastructure and forward traffic to customer origins. They are not associated with specific regions or compartments.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_edge_subnets = oci.Waas.get_edge_subnets()
    ```
    """
    __args__ = dict()
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Waas/getEdgeSubnets:getEdgeSubnets', __args__, opts=opts, typ=GetEdgeSubnetsResult).value

    return AwaitableGetEdgeSubnetsResult(
        edge_subnets=pulumi.get(__ret__, 'edge_subnets'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))


@_utilities.lift_output_func(get_edge_subnets)
def get_edge_subnets_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetEdgeSubnetsFilterArgs', 'GetEdgeSubnetsFilterArgsDict']]]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEdgeSubnetsResult]:
    """
    This data source provides the list of Edge Subnets in Oracle Cloud Infrastructure Web Application Acceleration and Security service.

    Return the list of the tenant's edge node subnets. Use these CIDR blocks to restrict incoming traffic to your origin. These subnets are owned by Oracle Cloud Infrastructure and forward traffic to customer origins. They are not associated with specific regions or compartments.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_edge_subnets = oci.Waas.get_edge_subnets()
    ```
    """
    ...
