import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermBatchApplicationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_application#account_name DataAzurermBatchApplication#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_application#name DataAzurermBatchApplication#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_application#resource_group_name DataAzurermBatchApplication#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_application#timeouts DataAzurermBatchApplication#timeouts}
    */
    readonly timeouts?: DataAzurermBatchApplicationTimeouts;
}
export interface DataAzurermBatchApplicationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/batch_application#read DataAzurermBatchApplication#read}
    */
    readonly read?: string;
}
export declare function dataAzurermBatchApplicationTimeoutsToTerraform(struct?: DataAzurermBatchApplicationTimeoutsOutputReference | DataAzurermBatchApplicationTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermBatchApplicationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermBatchApplicationTimeouts | undefined;
    set internalValue(value: DataAzurermBatchApplicationTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/batch_application azurerm_batch_application}
*/
export declare class DataAzurermBatchApplication extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_batch_application";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/batch_application azurerm_batch_application} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermBatchApplicationConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermBatchApplicationConfig);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    get allowUpdates(): cdktf.IResolvable;
    get defaultVersion(): string;
    get displayName(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermBatchApplicationTimeoutsOutputReference;
    putTimeouts(value: DataAzurermBatchApplicationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermBatchApplicationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
