import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermBlueprintPublishedVersionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/blueprint_published_version#blueprint_name DataAzurermBlueprintPublishedVersion#blueprint_name}
    */
    readonly blueprintName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/blueprint_published_version#scope_id DataAzurermBlueprintPublishedVersion#scope_id}
    */
    readonly scopeId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/blueprint_published_version#version DataAzurermBlueprintPublishedVersion#version}
    */
    readonly version: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/blueprint_published_version#timeouts DataAzurermBlueprintPublishedVersion#timeouts}
    */
    readonly timeouts?: DataAzurermBlueprintPublishedVersionTimeouts;
}
export interface DataAzurermBlueprintPublishedVersionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/blueprint_published_version#read DataAzurermBlueprintPublishedVersion#read}
    */
    readonly read?: string;
}
export declare function dataAzurermBlueprintPublishedVersionTimeoutsToTerraform(struct?: DataAzurermBlueprintPublishedVersionTimeoutsOutputReference | DataAzurermBlueprintPublishedVersionTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermBlueprintPublishedVersionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermBlueprintPublishedVersionTimeouts | undefined;
    set internalValue(value: DataAzurermBlueprintPublishedVersionTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/blueprint_published_version azurerm_blueprint_published_version}
*/
export declare class DataAzurermBlueprintPublishedVersion extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_blueprint_published_version";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/blueprint_published_version azurerm_blueprint_published_version} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermBlueprintPublishedVersionConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermBlueprintPublishedVersionConfig);
    private _blueprintName?;
    get blueprintName(): string;
    set blueprintName(value: string);
    get blueprintNameInput(): string | undefined;
    get description(): string;
    get displayName(): string;
    get id(): string;
    get lastModified(): string;
    private _scopeId?;
    get scopeId(): string;
    set scopeId(value: string);
    get scopeIdInput(): string | undefined;
    get targetScope(): string;
    get timeCreated(): string;
    get type(): string;
    private _version?;
    get version(): string;
    set version(value: string);
    get versionInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermBlueprintPublishedVersionTimeoutsOutputReference;
    putTimeouts(value: DataAzurermBlueprintPublishedVersionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermBlueprintPublishedVersionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
