import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDedicatedHostConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dedicated_host#dedicated_host_group_name DataAzurermDedicatedHost#dedicated_host_group_name}
    */
    readonly dedicatedHostGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dedicated_host#name DataAzurermDedicatedHost#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dedicated_host#resource_group_name DataAzurermDedicatedHost#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dedicated_host#timeouts DataAzurermDedicatedHost#timeouts}
    */
    readonly timeouts?: DataAzurermDedicatedHostTimeouts;
}
export interface DataAzurermDedicatedHostTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dedicated_host#read DataAzurermDedicatedHost#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDedicatedHostTimeoutsToTerraform(struct?: DataAzurermDedicatedHostTimeoutsOutputReference | DataAzurermDedicatedHostTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDedicatedHostTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermDedicatedHostTimeouts | undefined;
    set internalValue(value: DataAzurermDedicatedHostTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/dedicated_host azurerm_dedicated_host}
*/
export declare class DataAzurermDedicatedHost extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_dedicated_host";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/dedicated_host azurerm_dedicated_host} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDedicatedHostConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDedicatedHostConfig);
    private _dedicatedHostGroupName?;
    get dedicatedHostGroupName(): string;
    set dedicatedHostGroupName(value: string);
    get dedicatedHostGroupNameInput(): string | undefined;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermDedicatedHostTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDedicatedHostTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermDedicatedHostTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
