import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDevTestLabConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dev_test_lab#name DataAzurermDevTestLab#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dev_test_lab#resource_group_name DataAzurermDevTestLab#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dev_test_lab#timeouts DataAzurermDevTestLab#timeouts}
    */
    readonly timeouts?: DataAzurermDevTestLabTimeouts;
}
export interface DataAzurermDevTestLabTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/dev_test_lab#read DataAzurermDevTestLab#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDevTestLabTimeoutsToTerraform(struct?: DataAzurermDevTestLabTimeoutsOutputReference | DataAzurermDevTestLabTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDevTestLabTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermDevTestLabTimeouts | undefined;
    set internalValue(value: DataAzurermDevTestLabTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/dev_test_lab azurerm_dev_test_lab}
*/
export declare class DataAzurermDevTestLab extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_dev_test_lab";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/dev_test_lab azurerm_dev_test_lab} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDevTestLabConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDevTestLabConfig);
    get artifactsStorageAccountId(): string;
    get defaultPremiumStorageAccountId(): string;
    get defaultStorageAccountId(): string;
    get id(): string;
    get keyVaultId(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get premiumDataDiskStorageAccountId(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get storageType(): string;
    tags(key: string): string | cdktf.IResolvable;
    get uniqueIdentifier(): string;
    private _timeouts;
    get timeouts(): DataAzurermDevTestLabTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDevTestLabTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermDevTestLabTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
