import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermKubernetesServiceVersionsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_service_versions#include_preview DataAzurermKubernetesServiceVersions#include_preview}
    */
    readonly includePreview?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_service_versions#location DataAzurermKubernetesServiceVersions#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_service_versions#version_prefix DataAzurermKubernetesServiceVersions#version_prefix}
    */
    readonly versionPrefix?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_service_versions#timeouts DataAzurermKubernetesServiceVersions#timeouts}
    */
    readonly timeouts?: DataAzurermKubernetesServiceVersionsTimeouts;
}
export interface DataAzurermKubernetesServiceVersionsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_service_versions#read DataAzurermKubernetesServiceVersions#read}
    */
    readonly read?: string;
}
export declare function dataAzurermKubernetesServiceVersionsTimeoutsToTerraform(struct?: DataAzurermKubernetesServiceVersionsTimeoutsOutputReference | DataAzurermKubernetesServiceVersionsTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermKubernetesServiceVersionsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermKubernetesServiceVersionsTimeouts | undefined;
    set internalValue(value: DataAzurermKubernetesServiceVersionsTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_service_versions azurerm_kubernetes_service_versions}
*/
export declare class DataAzurermKubernetesServiceVersions extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_kubernetes_service_versions";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_service_versions azurerm_kubernetes_service_versions} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermKubernetesServiceVersionsConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermKubernetesServiceVersionsConfig);
    get id(): string;
    private _includePreview?;
    get includePreview(): boolean | cdktf.IResolvable;
    set includePreview(value: boolean | cdktf.IResolvable);
    resetIncludePreview(): void;
    get includePreviewInput(): boolean | cdktf.IResolvable | undefined;
    get latestVersion(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _versionPrefix?;
    get versionPrefix(): string;
    set versionPrefix(value: string);
    resetVersionPrefix(): void;
    get versionPrefixInput(): string | undefined;
    get versions(): string[];
    private _timeouts;
    get timeouts(): DataAzurermKubernetesServiceVersionsTimeoutsOutputReference;
    putTimeouts(value: DataAzurermKubernetesServiceVersionsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermKubernetesServiceVersionsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
