import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermManagedApplicationDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/managed_application_definition#name DataAzurermManagedApplicationDefinition#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/managed_application_definition#resource_group_name DataAzurermManagedApplicationDefinition#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/managed_application_definition#timeouts DataAzurermManagedApplicationDefinition#timeouts}
    */
    readonly timeouts?: DataAzurermManagedApplicationDefinitionTimeouts;
}
export interface DataAzurermManagedApplicationDefinitionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/managed_application_definition#read DataAzurermManagedApplicationDefinition#read}
    */
    readonly read?: string;
}
export declare function dataAzurermManagedApplicationDefinitionTimeoutsToTerraform(struct?: DataAzurermManagedApplicationDefinitionTimeoutsOutputReference | DataAzurermManagedApplicationDefinitionTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermManagedApplicationDefinitionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermManagedApplicationDefinitionTimeouts | undefined;
    set internalValue(value: DataAzurermManagedApplicationDefinitionTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/managed_application_definition azurerm_managed_application_definition}
*/
export declare class DataAzurermManagedApplicationDefinition extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_managed_application_definition";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/managed_application_definition azurerm_managed_application_definition} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermManagedApplicationDefinitionConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermManagedApplicationDefinitionConfig);
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermManagedApplicationDefinitionTimeoutsOutputReference;
    putTimeouts(value: DataAzurermManagedApplicationDefinitionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermManagedApplicationDefinitionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
