import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermPlatformImageConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/platform_image#location DataAzurermPlatformImage#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/platform_image#offer DataAzurermPlatformImage#offer}
    */
    readonly offer: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/platform_image#publisher DataAzurermPlatformImage#publisher}
    */
    readonly publisher: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/platform_image#sku DataAzurermPlatformImage#sku}
    */
    readonly sku: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/platform_image#version DataAzurermPlatformImage#version}
    */
    readonly version?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/platform_image#timeouts DataAzurermPlatformImage#timeouts}
    */
    readonly timeouts?: DataAzurermPlatformImageTimeouts;
}
export interface DataAzurermPlatformImageTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/platform_image#read DataAzurermPlatformImage#read}
    */
    readonly read?: string;
}
export declare function dataAzurermPlatformImageTimeoutsToTerraform(struct?: DataAzurermPlatformImageTimeoutsOutputReference | DataAzurermPlatformImageTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermPlatformImageTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermPlatformImageTimeouts | undefined;
    set internalValue(value: DataAzurermPlatformImageTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/platform_image azurerm_platform_image}
*/
export declare class DataAzurermPlatformImage extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_platform_image";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/platform_image azurerm_platform_image} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermPlatformImageConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermPlatformImageConfig);
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _offer?;
    get offer(): string;
    set offer(value: string);
    get offerInput(): string | undefined;
    private _publisher?;
    get publisher(): string;
    set publisher(value: string);
    get publisherInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    get skuInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermPlatformImageTimeoutsOutputReference;
    putTimeouts(value: DataAzurermPlatformImageTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermPlatformImageTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
