import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSentinelAlertRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sentinel_alert_rule#log_analytics_workspace_id DataAzurermSentinelAlertRule#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sentinel_alert_rule#name DataAzurermSentinelAlertRule#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sentinel_alert_rule#timeouts DataAzurermSentinelAlertRule#timeouts}
    */
    readonly timeouts?: DataAzurermSentinelAlertRuleTimeouts;
}
export interface DataAzurermSentinelAlertRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sentinel_alert_rule#read DataAzurermSentinelAlertRule#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSentinelAlertRuleTimeoutsToTerraform(struct?: DataAzurermSentinelAlertRuleTimeoutsOutputReference | DataAzurermSentinelAlertRuleTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSentinelAlertRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermSentinelAlertRuleTimeouts | undefined;
    set internalValue(value: DataAzurermSentinelAlertRuleTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/sentinel_alert_rule azurerm_sentinel_alert_rule}
*/
export declare class DataAzurermSentinelAlertRule extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_sentinel_alert_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/sentinel_alert_rule azurerm_sentinel_alert_rule} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSentinelAlertRuleConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSentinelAlertRuleConfig);
    get id(): string;
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermSentinelAlertRuleTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSentinelAlertRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermSentinelAlertRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
