import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermVirtualWanConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_wan#name DataAzurermVirtualWan#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_wan#resource_group_name DataAzurermVirtualWan#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_wan#timeouts DataAzurermVirtualWan#timeouts}
    */
    readonly timeouts?: DataAzurermVirtualWanTimeouts;
}
export interface DataAzurermVirtualWanTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_wan#read DataAzurermVirtualWan#read}
    */
    readonly read?: string;
}
export declare function dataAzurermVirtualWanTimeoutsToTerraform(struct?: DataAzurermVirtualWanTimeoutsOutputReference | DataAzurermVirtualWanTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermVirtualWanTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermVirtualWanTimeouts | undefined;
    set internalValue(value: DataAzurermVirtualWanTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_wan azurerm_virtual_wan}
*/
export declare class DataAzurermVirtualWan extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_virtual_wan";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_wan azurerm_virtual_wan} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermVirtualWanConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermVirtualWanConfig);
    get allowBranchToBranchTraffic(): cdktf.IResolvable;
    get disableVpnEncryption(): cdktf.IResolvable;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get office365LocalBreakoutCategory(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sku(): string;
    tags(key: string): string | cdktf.IResolvable;
    get virtualHubIds(): string[];
    get vpnSiteIds(): string[];
    private _timeouts;
    get timeouts(): DataAzurermVirtualWanTimeoutsOutputReference;
    putTimeouts(value: DataAzurermVirtualWanTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermVirtualWanTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
