import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LogicAppTriggerHttpRequestConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_http_request#logic_app_id LogicAppTriggerHttpRequest#logic_app_id}
    */
    readonly logicAppId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_http_request#method LogicAppTriggerHttpRequest#method}
    */
    readonly method?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_http_request#name LogicAppTriggerHttpRequest#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_http_request#relative_path LogicAppTriggerHttpRequest#relative_path}
    */
    readonly relativePath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_http_request#schema LogicAppTriggerHttpRequest#schema}
    */
    readonly schema: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_http_request#timeouts LogicAppTriggerHttpRequest#timeouts}
    */
    readonly timeouts?: LogicAppTriggerHttpRequestTimeouts;
}
export interface LogicAppTriggerHttpRequestTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_http_request#create LogicAppTriggerHttpRequest#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_http_request#delete LogicAppTriggerHttpRequest#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_http_request#read LogicAppTriggerHttpRequest#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_http_request#update LogicAppTriggerHttpRequest#update}
    */
    readonly update?: string;
}
export declare function logicAppTriggerHttpRequestTimeoutsToTerraform(struct?: LogicAppTriggerHttpRequestTimeoutsOutputReference | LogicAppTriggerHttpRequestTimeouts | cdktf.IResolvable): any;
export declare class LogicAppTriggerHttpRequestTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LogicAppTriggerHttpRequestTimeouts | undefined;
    set internalValue(value: LogicAppTriggerHttpRequestTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_http_request azurerm_logic_app_trigger_http_request}
*/
export declare class LogicAppTriggerHttpRequest extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_logic_app_trigger_http_request";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/logic_app_trigger_http_request azurerm_logic_app_trigger_http_request} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LogicAppTriggerHttpRequestConfig
    */
    constructor(scope: Construct, id: string, config: LogicAppTriggerHttpRequestConfig);
    get callbackUrl(): string;
    get id(): string;
    private _logicAppId?;
    get logicAppId(): string;
    set logicAppId(value: string);
    get logicAppIdInput(): string | undefined;
    private _method?;
    get method(): string;
    set method(value: string);
    resetMethod(): void;
    get methodInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _relativePath?;
    get relativePath(): string;
    set relativePath(value: string);
    resetRelativePath(): void;
    get relativePathInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _timeouts;
    get timeouts(): LogicAppTriggerHttpRequestTimeoutsOutputReference;
    putTimeouts(value: LogicAppTriggerHttpRequestTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): LogicAppTriggerHttpRequestTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
