"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MediaContentKeyPolicy = exports.MediaContentKeyPolicyTimeoutsOutputReference = exports.mediaContentKeyPolicyTimeoutsToTerraform = exports.mediaContentKeyPolicyPolicyOptionToTerraform = exports.MediaContentKeyPolicyPolicyOptionTokenRestrictionOutputReference = exports.mediaContentKeyPolicyPolicyOptionTokenRestrictionToTerraform = exports.mediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaimToTerraform = exports.mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicenseToTerraform = exports.MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightOutputReference = exports.mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightToTerraform = exports.MediaContentKeyPolicyPolicyOptionFairplayConfigurationOutputReference = exports.mediaContentKeyPolicyPolicyOptionFairplayConfigurationToTerraform = exports.MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference = exports.mediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function mediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        playback_duration_seconds: cdktf.numberToTerraform(struct.playbackDurationSeconds),
        storage_duration_seconds: cdktf.numberToTerraform(struct.storageDurationSeconds),
    };
}
exports.mediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationToTerraform = mediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationToTerraform;
class MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._playbackDurationSeconds !== undefined) {
            hasAnyValues = true;
            internalValueResult.playbackDurationSeconds = this._playbackDurationSeconds;
        }
        if (this._storageDurationSeconds !== undefined) {
            hasAnyValues = true;
            internalValueResult.storageDurationSeconds = this._storageDurationSeconds;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._playbackDurationSeconds = undefined;
            this._storageDurationSeconds = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._playbackDurationSeconds = value.playbackDurationSeconds;
            this._storageDurationSeconds = value.storageDurationSeconds;
        }
    }
    get playbackDurationSeconds() {
        return this.getNumberAttribute('playback_duration_seconds');
    }
    set playbackDurationSeconds(value) {
        this._playbackDurationSeconds = value;
    }
    resetPlaybackDurationSeconds() {
        this._playbackDurationSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get playbackDurationSecondsInput() {
        return this._playbackDurationSeconds;
    }
    get storageDurationSeconds() {
        return this.getNumberAttribute('storage_duration_seconds');
    }
    set storageDurationSeconds(value) {
        this._storageDurationSeconds = value;
    }
    resetStorageDurationSeconds() {
        this._storageDurationSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get storageDurationSecondsInput() {
        return this._storageDurationSeconds;
    }
}
exports.MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference = MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference;
_a = JSII_RTTI_SYMBOL_1;
MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference[_a] = { fqn: "@cdktf/provider-azurerm.MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference", version: "0.6.13" };
function mediaContentKeyPolicyPolicyOptionFairplayConfigurationToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        ask: cdktf.stringToTerraform(struct.ask),
        pfx: cdktf.stringToTerraform(struct.pfx),
        pfx_password: cdktf.stringToTerraform(struct.pfxPassword),
        rental_and_lease_key_type: cdktf.stringToTerraform(struct.rentalAndLeaseKeyType),
        rental_duration_seconds: cdktf.numberToTerraform(struct.rentalDurationSeconds),
        offline_rental_configuration: mediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationToTerraform(struct.offlineRentalConfiguration),
    };
}
exports.mediaContentKeyPolicyPolicyOptionFairplayConfigurationToTerraform = mediaContentKeyPolicyPolicyOptionFairplayConfigurationToTerraform;
class MediaContentKeyPolicyPolicyOptionFairplayConfigurationOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
        // offline_rental_configuration - computed: false, optional: true, required: false
        this._offlineRentalConfiguration = new MediaContentKeyPolicyPolicyOptionFairplayConfigurationOfflineRentalConfigurationOutputReference(this, "offline_rental_configuration");
    }
    get internalValue() {
        var _g, _h;
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._ask !== undefined) {
            hasAnyValues = true;
            internalValueResult.ask = this._ask;
        }
        if (this._pfx !== undefined) {
            hasAnyValues = true;
            internalValueResult.pfx = this._pfx;
        }
        if (this._pfxPassword !== undefined) {
            hasAnyValues = true;
            internalValueResult.pfxPassword = this._pfxPassword;
        }
        if (this._rentalAndLeaseKeyType !== undefined) {
            hasAnyValues = true;
            internalValueResult.rentalAndLeaseKeyType = this._rentalAndLeaseKeyType;
        }
        if (this._rentalDurationSeconds !== undefined) {
            hasAnyValues = true;
            internalValueResult.rentalDurationSeconds = this._rentalDurationSeconds;
        }
        if (((_g = this._offlineRentalConfiguration) === null || _g === void 0 ? void 0 : _g.internalValue) !== undefined) {
            hasAnyValues = true;
            internalValueResult.offlineRentalConfiguration = (_h = this._offlineRentalConfiguration) === null || _h === void 0 ? void 0 : _h.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._ask = undefined;
            this._pfx = undefined;
            this._pfxPassword = undefined;
            this._rentalAndLeaseKeyType = undefined;
            this._rentalDurationSeconds = undefined;
            this._offlineRentalConfiguration.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._ask = value.ask;
            this._pfx = value.pfx;
            this._pfxPassword = value.pfxPassword;
            this._rentalAndLeaseKeyType = value.rentalAndLeaseKeyType;
            this._rentalDurationSeconds = value.rentalDurationSeconds;
            this._offlineRentalConfiguration.internalValue = value.offlineRentalConfiguration;
        }
    }
    get ask() {
        return this.getStringAttribute('ask');
    }
    set ask(value) {
        this._ask = value;
    }
    resetAsk() {
        this._ask = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get askInput() {
        return this._ask;
    }
    get pfx() {
        return this.getStringAttribute('pfx');
    }
    set pfx(value) {
        this._pfx = value;
    }
    resetPfx() {
        this._pfx = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pfxInput() {
        return this._pfx;
    }
    get pfxPassword() {
        return this.getStringAttribute('pfx_password');
    }
    set pfxPassword(value) {
        this._pfxPassword = value;
    }
    resetPfxPassword() {
        this._pfxPassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get pfxPasswordInput() {
        return this._pfxPassword;
    }
    get rentalAndLeaseKeyType() {
        return this.getStringAttribute('rental_and_lease_key_type');
    }
    set rentalAndLeaseKeyType(value) {
        this._rentalAndLeaseKeyType = value;
    }
    resetRentalAndLeaseKeyType() {
        this._rentalAndLeaseKeyType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rentalAndLeaseKeyTypeInput() {
        return this._rentalAndLeaseKeyType;
    }
    get rentalDurationSeconds() {
        return this.getNumberAttribute('rental_duration_seconds');
    }
    set rentalDurationSeconds(value) {
        this._rentalDurationSeconds = value;
    }
    resetRentalDurationSeconds() {
        this._rentalDurationSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get rentalDurationSecondsInput() {
        return this._rentalDurationSeconds;
    }
    get offlineRentalConfiguration() {
        return this._offlineRentalConfiguration;
    }
    putOfflineRentalConfiguration(value) {
        this._offlineRentalConfiguration.internalValue = value;
    }
    resetOfflineRentalConfiguration() {
        this._offlineRentalConfiguration.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get offlineRentalConfigurationInput() {
        return this._offlineRentalConfiguration.internalValue;
    }
}
exports.MediaContentKeyPolicyPolicyOptionFairplayConfigurationOutputReference = MediaContentKeyPolicyPolicyOptionFairplayConfigurationOutputReference;
_b = JSII_RTTI_SYMBOL_1;
MediaContentKeyPolicyPolicyOptionFairplayConfigurationOutputReference[_b] = { fqn: "@cdktf/provider-azurerm.MediaContentKeyPolicyPolicyOptionFairplayConfigurationOutputReference", version: "0.6.13" };
function mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        agc_and_color_stripe_restriction: cdktf.numberToTerraform(struct.agcAndColorStripeRestriction),
        allow_passing_video_content_to_unknown_output: cdktf.stringToTerraform(struct.allowPassingVideoContentToUnknownOutput),
        analog_video_opl: cdktf.numberToTerraform(struct.analogVideoOpl),
        compressed_digital_audio_opl: cdktf.numberToTerraform(struct.compressedDigitalAudioOpl),
        digital_video_only_content_restriction: cdktf.booleanToTerraform(struct.digitalVideoOnlyContentRestriction),
        first_play_expiration: cdktf.stringToTerraform(struct.firstPlayExpiration),
        image_constraint_for_analog_component_video_restriction: cdktf.booleanToTerraform(struct.imageConstraintForAnalogComponentVideoRestriction),
        image_constraint_for_analog_computer_monitor_restriction: cdktf.booleanToTerraform(struct.imageConstraintForAnalogComputerMonitorRestriction),
        scms_restriction: cdktf.numberToTerraform(struct.scmsRestriction),
        uncompressed_digital_audio_opl: cdktf.numberToTerraform(struct.uncompressedDigitalAudioOpl),
        uncompressed_digital_video_opl: cdktf.numberToTerraform(struct.uncompressedDigitalVideoOpl),
    };
}
exports.mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightToTerraform = mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightToTerraform;
class MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._agcAndColorStripeRestriction !== undefined) {
            hasAnyValues = true;
            internalValueResult.agcAndColorStripeRestriction = this._agcAndColorStripeRestriction;
        }
        if (this._allowPassingVideoContentToUnknownOutput !== undefined) {
            hasAnyValues = true;
            internalValueResult.allowPassingVideoContentToUnknownOutput = this._allowPassingVideoContentToUnknownOutput;
        }
        if (this._analogVideoOpl !== undefined) {
            hasAnyValues = true;
            internalValueResult.analogVideoOpl = this._analogVideoOpl;
        }
        if (this._compressedDigitalAudioOpl !== undefined) {
            hasAnyValues = true;
            internalValueResult.compressedDigitalAudioOpl = this._compressedDigitalAudioOpl;
        }
        if (this._digitalVideoOnlyContentRestriction !== undefined) {
            hasAnyValues = true;
            internalValueResult.digitalVideoOnlyContentRestriction = this._digitalVideoOnlyContentRestriction;
        }
        if (this._firstPlayExpiration !== undefined) {
            hasAnyValues = true;
            internalValueResult.firstPlayExpiration = this._firstPlayExpiration;
        }
        if (this._imageConstraintForAnalogComponentVideoRestriction !== undefined) {
            hasAnyValues = true;
            internalValueResult.imageConstraintForAnalogComponentVideoRestriction = this._imageConstraintForAnalogComponentVideoRestriction;
        }
        if (this._imageConstraintForAnalogComputerMonitorRestriction !== undefined) {
            hasAnyValues = true;
            internalValueResult.imageConstraintForAnalogComputerMonitorRestriction = this._imageConstraintForAnalogComputerMonitorRestriction;
        }
        if (this._scmsRestriction !== undefined) {
            hasAnyValues = true;
            internalValueResult.scmsRestriction = this._scmsRestriction;
        }
        if (this._uncompressedDigitalAudioOpl !== undefined) {
            hasAnyValues = true;
            internalValueResult.uncompressedDigitalAudioOpl = this._uncompressedDigitalAudioOpl;
        }
        if (this._uncompressedDigitalVideoOpl !== undefined) {
            hasAnyValues = true;
            internalValueResult.uncompressedDigitalVideoOpl = this._uncompressedDigitalVideoOpl;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._agcAndColorStripeRestriction = undefined;
            this._allowPassingVideoContentToUnknownOutput = undefined;
            this._analogVideoOpl = undefined;
            this._compressedDigitalAudioOpl = undefined;
            this._digitalVideoOnlyContentRestriction = undefined;
            this._firstPlayExpiration = undefined;
            this._imageConstraintForAnalogComponentVideoRestriction = undefined;
            this._imageConstraintForAnalogComputerMonitorRestriction = undefined;
            this._scmsRestriction = undefined;
            this._uncompressedDigitalAudioOpl = undefined;
            this._uncompressedDigitalVideoOpl = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._agcAndColorStripeRestriction = value.agcAndColorStripeRestriction;
            this._allowPassingVideoContentToUnknownOutput = value.allowPassingVideoContentToUnknownOutput;
            this._analogVideoOpl = value.analogVideoOpl;
            this._compressedDigitalAudioOpl = value.compressedDigitalAudioOpl;
            this._digitalVideoOnlyContentRestriction = value.digitalVideoOnlyContentRestriction;
            this._firstPlayExpiration = value.firstPlayExpiration;
            this._imageConstraintForAnalogComponentVideoRestriction = value.imageConstraintForAnalogComponentVideoRestriction;
            this._imageConstraintForAnalogComputerMonitorRestriction = value.imageConstraintForAnalogComputerMonitorRestriction;
            this._scmsRestriction = value.scmsRestriction;
            this._uncompressedDigitalAudioOpl = value.uncompressedDigitalAudioOpl;
            this._uncompressedDigitalVideoOpl = value.uncompressedDigitalVideoOpl;
        }
    }
    get agcAndColorStripeRestriction() {
        return this.getNumberAttribute('agc_and_color_stripe_restriction');
    }
    set agcAndColorStripeRestriction(value) {
        this._agcAndColorStripeRestriction = value;
    }
    resetAgcAndColorStripeRestriction() {
        this._agcAndColorStripeRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get agcAndColorStripeRestrictionInput() {
        return this._agcAndColorStripeRestriction;
    }
    get allowPassingVideoContentToUnknownOutput() {
        return this.getStringAttribute('allow_passing_video_content_to_unknown_output');
    }
    set allowPassingVideoContentToUnknownOutput(value) {
        this._allowPassingVideoContentToUnknownOutput = value;
    }
    resetAllowPassingVideoContentToUnknownOutput() {
        this._allowPassingVideoContentToUnknownOutput = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowPassingVideoContentToUnknownOutputInput() {
        return this._allowPassingVideoContentToUnknownOutput;
    }
    get analogVideoOpl() {
        return this.getNumberAttribute('analog_video_opl');
    }
    set analogVideoOpl(value) {
        this._analogVideoOpl = value;
    }
    resetAnalogVideoOpl() {
        this._analogVideoOpl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get analogVideoOplInput() {
        return this._analogVideoOpl;
    }
    get compressedDigitalAudioOpl() {
        return this.getNumberAttribute('compressed_digital_audio_opl');
    }
    set compressedDigitalAudioOpl(value) {
        this._compressedDigitalAudioOpl = value;
    }
    resetCompressedDigitalAudioOpl() {
        this._compressedDigitalAudioOpl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get compressedDigitalAudioOplInput() {
        return this._compressedDigitalAudioOpl;
    }
    get digitalVideoOnlyContentRestriction() {
        return this.getBooleanAttribute('digital_video_only_content_restriction');
    }
    set digitalVideoOnlyContentRestriction(value) {
        this._digitalVideoOnlyContentRestriction = value;
    }
    resetDigitalVideoOnlyContentRestriction() {
        this._digitalVideoOnlyContentRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get digitalVideoOnlyContentRestrictionInput() {
        return this._digitalVideoOnlyContentRestriction;
    }
    get firstPlayExpiration() {
        return this.getStringAttribute('first_play_expiration');
    }
    set firstPlayExpiration(value) {
        this._firstPlayExpiration = value;
    }
    resetFirstPlayExpiration() {
        this._firstPlayExpiration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get firstPlayExpirationInput() {
        return this._firstPlayExpiration;
    }
    get imageConstraintForAnalogComponentVideoRestriction() {
        return this.getBooleanAttribute('image_constraint_for_analog_component_video_restriction');
    }
    set imageConstraintForAnalogComponentVideoRestriction(value) {
        this._imageConstraintForAnalogComponentVideoRestriction = value;
    }
    resetImageConstraintForAnalogComponentVideoRestriction() {
        this._imageConstraintForAnalogComponentVideoRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get imageConstraintForAnalogComponentVideoRestrictionInput() {
        return this._imageConstraintForAnalogComponentVideoRestriction;
    }
    get imageConstraintForAnalogComputerMonitorRestriction() {
        return this.getBooleanAttribute('image_constraint_for_analog_computer_monitor_restriction');
    }
    set imageConstraintForAnalogComputerMonitorRestriction(value) {
        this._imageConstraintForAnalogComputerMonitorRestriction = value;
    }
    resetImageConstraintForAnalogComputerMonitorRestriction() {
        this._imageConstraintForAnalogComputerMonitorRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get imageConstraintForAnalogComputerMonitorRestrictionInput() {
        return this._imageConstraintForAnalogComputerMonitorRestriction;
    }
    get scmsRestriction() {
        return this.getNumberAttribute('scms_restriction');
    }
    set scmsRestriction(value) {
        this._scmsRestriction = value;
    }
    resetScmsRestriction() {
        this._scmsRestriction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get scmsRestrictionInput() {
        return this._scmsRestriction;
    }
    get uncompressedDigitalAudioOpl() {
        return this.getNumberAttribute('uncompressed_digital_audio_opl');
    }
    set uncompressedDigitalAudioOpl(value) {
        this._uncompressedDigitalAudioOpl = value;
    }
    resetUncompressedDigitalAudioOpl() {
        this._uncompressedDigitalAudioOpl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get uncompressedDigitalAudioOplInput() {
        return this._uncompressedDigitalAudioOpl;
    }
    get uncompressedDigitalVideoOpl() {
        return this.getNumberAttribute('uncompressed_digital_video_opl');
    }
    set uncompressedDigitalVideoOpl(value) {
        this._uncompressedDigitalVideoOpl = value;
    }
    resetUncompressedDigitalVideoOpl() {
        this._uncompressedDigitalVideoOpl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get uncompressedDigitalVideoOplInput() {
        return this._uncompressedDigitalVideoOpl;
    }
}
exports.MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightOutputReference = MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightOutputReference;
_c = JSII_RTTI_SYMBOL_1;
MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightOutputReference[_c] = { fqn: "@cdktf/provider-azurerm.MediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightOutputReference", version: "0.6.13" };
function mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicenseToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allow_test_devices: cdktf.booleanToTerraform(struct.allowTestDevices),
        begin_date: cdktf.stringToTerraform(struct.beginDate),
        content_key_location_from_header_enabled: cdktf.booleanToTerraform(struct.contentKeyLocationFromHeaderEnabled),
        content_key_location_from_key_id: cdktf.stringToTerraform(struct.contentKeyLocationFromKeyId),
        content_type: cdktf.stringToTerraform(struct.contentType),
        expiration_date: cdktf.stringToTerraform(struct.expirationDate),
        grace_period: cdktf.stringToTerraform(struct.gracePeriod),
        license_type: cdktf.stringToTerraform(struct.licenseType),
        relative_begin_date: cdktf.stringToTerraform(struct.relativeBeginDate),
        relative_expiration_date: cdktf.stringToTerraform(struct.relativeExpirationDate),
        play_right: mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicensePlayRightToTerraform(struct.playRight),
    };
}
exports.mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicenseToTerraform = mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicenseToTerraform;
function mediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaimToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        type: cdktf.stringToTerraform(struct.type),
        value: cdktf.stringToTerraform(struct.value),
    };
}
exports.mediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaimToTerraform = mediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaimToTerraform;
function mediaContentKeyPolicyPolicyOptionTokenRestrictionToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        audience: cdktf.stringToTerraform(struct.audience),
        issuer: cdktf.stringToTerraform(struct.issuer),
        open_id_connect_discovery_document: cdktf.stringToTerraform(struct.openIdConnectDiscoveryDocument),
        primary_rsa_token_key_exponent: cdktf.stringToTerraform(struct.primaryRsaTokenKeyExponent),
        primary_rsa_token_key_modulus: cdktf.stringToTerraform(struct.primaryRsaTokenKeyModulus),
        primary_symmetric_token_key: cdktf.stringToTerraform(struct.primarySymmetricTokenKey),
        primary_x509_token_key_raw: cdktf.stringToTerraform(struct.primaryX509TokenKeyRaw),
        token_type: cdktf.stringToTerraform(struct.tokenType),
        required_claim: cdktf.listMapper(mediaContentKeyPolicyPolicyOptionTokenRestrictionRequiredClaimToTerraform)(struct.requiredClaim),
    };
}
exports.mediaContentKeyPolicyPolicyOptionTokenRestrictionToTerraform = mediaContentKeyPolicyPolicyOptionTokenRestrictionToTerraform;
class MediaContentKeyPolicyPolicyOptionTokenRestrictionOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._audience !== undefined) {
            hasAnyValues = true;
            internalValueResult.audience = this._audience;
        }
        if (this._issuer !== undefined) {
            hasAnyValues = true;
            internalValueResult.issuer = this._issuer;
        }
        if (this._openIdConnectDiscoveryDocument !== undefined) {
            hasAnyValues = true;
            internalValueResult.openIdConnectDiscoveryDocument = this._openIdConnectDiscoveryDocument;
        }
        if (this._primaryRsaTokenKeyExponent !== undefined) {
            hasAnyValues = true;
            internalValueResult.primaryRsaTokenKeyExponent = this._primaryRsaTokenKeyExponent;
        }
        if (this._primaryRsaTokenKeyModulus !== undefined) {
            hasAnyValues = true;
            internalValueResult.primaryRsaTokenKeyModulus = this._primaryRsaTokenKeyModulus;
        }
        if (this._primarySymmetricTokenKey !== undefined) {
            hasAnyValues = true;
            internalValueResult.primarySymmetricTokenKey = this._primarySymmetricTokenKey;
        }
        if (this._primaryX509TokenKeyRaw !== undefined) {
            hasAnyValues = true;
            internalValueResult.primaryX509TokenKeyRaw = this._primaryX509TokenKeyRaw;
        }
        if (this._tokenType !== undefined) {
            hasAnyValues = true;
            internalValueResult.tokenType = this._tokenType;
        }
        if (this._requiredClaim !== undefined) {
            hasAnyValues = true;
            internalValueResult.requiredClaim = this._requiredClaim;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._audience = undefined;
            this._issuer = undefined;
            this._openIdConnectDiscoveryDocument = undefined;
            this._primaryRsaTokenKeyExponent = undefined;
            this._primaryRsaTokenKeyModulus = undefined;
            this._primarySymmetricTokenKey = undefined;
            this._primaryX509TokenKeyRaw = undefined;
            this._tokenType = undefined;
            this._requiredClaim = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._audience = value.audience;
            this._issuer = value.issuer;
            this._openIdConnectDiscoveryDocument = value.openIdConnectDiscoveryDocument;
            this._primaryRsaTokenKeyExponent = value.primaryRsaTokenKeyExponent;
            this._primaryRsaTokenKeyModulus = value.primaryRsaTokenKeyModulus;
            this._primarySymmetricTokenKey = value.primarySymmetricTokenKey;
            this._primaryX509TokenKeyRaw = value.primaryX509TokenKeyRaw;
            this._tokenType = value.tokenType;
            this._requiredClaim = value.requiredClaim;
        }
    }
    get audience() {
        return this.getStringAttribute('audience');
    }
    set audience(value) {
        this._audience = value;
    }
    resetAudience() {
        this._audience = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get audienceInput() {
        return this._audience;
    }
    get issuer() {
        return this.getStringAttribute('issuer');
    }
    set issuer(value) {
        this._issuer = value;
    }
    resetIssuer() {
        this._issuer = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get issuerInput() {
        return this._issuer;
    }
    get openIdConnectDiscoveryDocument() {
        return this.getStringAttribute('open_id_connect_discovery_document');
    }
    set openIdConnectDiscoveryDocument(value) {
        this._openIdConnectDiscoveryDocument = value;
    }
    resetOpenIdConnectDiscoveryDocument() {
        this._openIdConnectDiscoveryDocument = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get openIdConnectDiscoveryDocumentInput() {
        return this._openIdConnectDiscoveryDocument;
    }
    get primaryRsaTokenKeyExponent() {
        return this.getStringAttribute('primary_rsa_token_key_exponent');
    }
    set primaryRsaTokenKeyExponent(value) {
        this._primaryRsaTokenKeyExponent = value;
    }
    resetPrimaryRsaTokenKeyExponent() {
        this._primaryRsaTokenKeyExponent = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get primaryRsaTokenKeyExponentInput() {
        return this._primaryRsaTokenKeyExponent;
    }
    get primaryRsaTokenKeyModulus() {
        return this.getStringAttribute('primary_rsa_token_key_modulus');
    }
    set primaryRsaTokenKeyModulus(value) {
        this._primaryRsaTokenKeyModulus = value;
    }
    resetPrimaryRsaTokenKeyModulus() {
        this._primaryRsaTokenKeyModulus = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get primaryRsaTokenKeyModulusInput() {
        return this._primaryRsaTokenKeyModulus;
    }
    get primarySymmetricTokenKey() {
        return this.getStringAttribute('primary_symmetric_token_key');
    }
    set primarySymmetricTokenKey(value) {
        this._primarySymmetricTokenKey = value;
    }
    resetPrimarySymmetricTokenKey() {
        this._primarySymmetricTokenKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get primarySymmetricTokenKeyInput() {
        return this._primarySymmetricTokenKey;
    }
    get primaryX509TokenKeyRaw() {
        return this.getStringAttribute('primary_x509_token_key_raw');
    }
    set primaryX509TokenKeyRaw(value) {
        this._primaryX509TokenKeyRaw = value;
    }
    resetPrimaryX509TokenKeyRaw() {
        this._primaryX509TokenKeyRaw = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get primaryX509TokenKeyRawInput() {
        return this._primaryX509TokenKeyRaw;
    }
    get tokenType() {
        return this.getStringAttribute('token_type');
    }
    set tokenType(value) {
        this._tokenType = value;
    }
    resetTokenType() {
        this._tokenType = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenTypeInput() {
        return this._tokenType;
    }
    get requiredClaim() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('required_claim');
    }
    set requiredClaim(value) {
        this._requiredClaim = value;
    }
    resetRequiredClaim() {
        this._requiredClaim = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requiredClaimInput() {
        return this._requiredClaim;
    }
}
exports.MediaContentKeyPolicyPolicyOptionTokenRestrictionOutputReference = MediaContentKeyPolicyPolicyOptionTokenRestrictionOutputReference;
_d = JSII_RTTI_SYMBOL_1;
MediaContentKeyPolicyPolicyOptionTokenRestrictionOutputReference[_d] = { fqn: "@cdktf/provider-azurerm.MediaContentKeyPolicyPolicyOptionTokenRestrictionOutputReference", version: "0.6.13" };
function mediaContentKeyPolicyPolicyOptionToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        clear_key_configuration_enabled: cdktf.booleanToTerraform(struct.clearKeyConfigurationEnabled),
        name: cdktf.stringToTerraform(struct.name),
        open_restriction_enabled: cdktf.booleanToTerraform(struct.openRestrictionEnabled),
        widevine_configuration_template: cdktf.stringToTerraform(struct.widevineConfigurationTemplate),
        fairplay_configuration: mediaContentKeyPolicyPolicyOptionFairplayConfigurationToTerraform(struct.fairplayConfiguration),
        playready_configuration_license: cdktf.listMapper(mediaContentKeyPolicyPolicyOptionPlayreadyConfigurationLicenseToTerraform)(struct.playreadyConfigurationLicense),
        token_restriction: mediaContentKeyPolicyPolicyOptionTokenRestrictionToTerraform(struct.tokenRestriction),
    };
}
exports.mediaContentKeyPolicyPolicyOptionToTerraform = mediaContentKeyPolicyPolicyOptionToTerraform;
function mediaContentKeyPolicyTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.mediaContentKeyPolicyTimeoutsToTerraform = mediaContentKeyPolicyTimeoutsToTerraform;
class MediaContentKeyPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read !== undefined) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update !== undefined) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
    get read() {
        return this.getStringAttribute('read');
    }
    set read(value) {
        this._read = value;
    }
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get readInput() {
        return this._read;
    }
    get update() {
        return this.getStringAttribute('update');
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
}
exports.MediaContentKeyPolicyTimeoutsOutputReference = MediaContentKeyPolicyTimeoutsOutputReference;
_e = JSII_RTTI_SYMBOL_1;
MediaContentKeyPolicyTimeoutsOutputReference[_e] = { fqn: "@cdktf/provider-azurerm.MediaContentKeyPolicyTimeoutsOutputReference", version: "0.6.13" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy azurerm_media_content_key_policy}
*/
class MediaContentKeyPolicy extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/media_content_key_policy azurerm_media_content_key_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MediaContentKeyPolicyConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azurerm_media_content_key_policy',
            terraformGeneratorMetadata: {
                providerName: 'azurerm',
                providerVersion: '2.99.0',
                providerVersionConstraint: '~> 2.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new MediaContentKeyPolicyTimeoutsOutputReference(this, "timeouts");
        this._description = config.description;
        this._mediaServicesAccountName = config.mediaServicesAccountName;
        this._name = config.name;
        this._resourceGroupName = config.resourceGroupName;
        this._policyOption = config.policyOption;
        this._timeouts.internalValue = config.timeouts;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get mediaServicesAccountName() {
        return this.getStringAttribute('media_services_account_name');
    }
    set mediaServicesAccountName(value) {
        this._mediaServicesAccountName = value;
    }
    // Temporarily expose input value. Use with caution.
    get mediaServicesAccountNameInput() {
        return this._mediaServicesAccountName;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get resourceGroupName() {
        return this.getStringAttribute('resource_group_name');
    }
    set resourceGroupName(value) {
        this._resourceGroupName = value;
    }
    // Temporarily expose input value. Use with caution.
    get resourceGroupNameInput() {
        return this._resourceGroupName;
    }
    get policyOption() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('policy_option')));
    }
    set policyOption(value) {
        this._policyOption = value;
    }
    // Temporarily expose input value. Use with caution.
    get policyOptionInput() {
        return this._policyOption;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            description: cdktf.stringToTerraform(this._description),
            media_services_account_name: cdktf.stringToTerraform(this._mediaServicesAccountName),
            name: cdktf.stringToTerraform(this._name),
            resource_group_name: cdktf.stringToTerraform(this._resourceGroupName),
            policy_option: cdktf.listMapper(mediaContentKeyPolicyPolicyOptionToTerraform)(this._policyOption),
            timeouts: mediaContentKeyPolicyTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.MediaContentKeyPolicy = MediaContentKeyPolicy;
_f = JSII_RTTI_SYMBOL_1;
MediaContentKeyPolicy[_f] = { fqn: "@cdktf/provider-azurerm.MediaContentKeyPolicy", version: "0.6.13" };
// =================
// STATIC PROPERTIES
// =================
MediaContentKeyPolicy.tfResourceType = "azurerm_media_content_key_policy";
//# sourceMappingURL=data:application/json;base64,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