import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MssqlDatabaseExtendedAuditingPolicyAConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_extended_auditing_policy#database_id MssqlDatabaseExtendedAuditingPolicyA#database_id}
    */
    readonly databaseId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_extended_auditing_policy#enabled MssqlDatabaseExtendedAuditingPolicyA#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_extended_auditing_policy#log_monitoring_enabled MssqlDatabaseExtendedAuditingPolicyA#log_monitoring_enabled}
    */
    readonly logMonitoringEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_extended_auditing_policy#retention_in_days MssqlDatabaseExtendedAuditingPolicyA#retention_in_days}
    */
    readonly retentionInDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_extended_auditing_policy#storage_account_access_key MssqlDatabaseExtendedAuditingPolicyA#storage_account_access_key}
    */
    readonly storageAccountAccessKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_extended_auditing_policy#storage_account_access_key_is_secondary MssqlDatabaseExtendedAuditingPolicyA#storage_account_access_key_is_secondary}
    */
    readonly storageAccountAccessKeyIsSecondary?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_extended_auditing_policy#storage_endpoint MssqlDatabaseExtendedAuditingPolicyA#storage_endpoint}
    */
    readonly storageEndpoint?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_extended_auditing_policy#timeouts MssqlDatabaseExtendedAuditingPolicyA#timeouts}
    */
    readonly timeouts?: MssqlDatabaseExtendedAuditingPolicyTimeouts;
}
export interface MssqlDatabaseExtendedAuditingPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_extended_auditing_policy#create MssqlDatabaseExtendedAuditingPolicyA#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_extended_auditing_policy#delete MssqlDatabaseExtendedAuditingPolicyA#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_extended_auditing_policy#read MssqlDatabaseExtendedAuditingPolicyA#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_extended_auditing_policy#update MssqlDatabaseExtendedAuditingPolicyA#update}
    */
    readonly update?: string;
}
export declare function mssqlDatabaseExtendedAuditingPolicyTimeoutsToTerraform(struct?: MssqlDatabaseExtendedAuditingPolicyTimeoutsOutputReference | MssqlDatabaseExtendedAuditingPolicyTimeouts | cdktf.IResolvable): any;
export declare class MssqlDatabaseExtendedAuditingPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlDatabaseExtendedAuditingPolicyTimeouts | undefined;
    set internalValue(value: MssqlDatabaseExtendedAuditingPolicyTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_extended_auditing_policy azurerm_mssql_database_extended_auditing_policy}
*/
export declare class MssqlDatabaseExtendedAuditingPolicyA extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mssql_database_extended_auditing_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_database_extended_auditing_policy azurerm_mssql_database_extended_auditing_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MssqlDatabaseExtendedAuditingPolicyAConfig
    */
    constructor(scope: Construct, id: string, config: MssqlDatabaseExtendedAuditingPolicyAConfig);
    private _databaseId?;
    get databaseId(): string;
    set databaseId(value: string);
    get databaseIdInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _logMonitoringEnabled?;
    get logMonitoringEnabled(): boolean | cdktf.IResolvable;
    set logMonitoringEnabled(value: boolean | cdktf.IResolvable);
    resetLogMonitoringEnabled(): void;
    get logMonitoringEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _retentionInDays?;
    get retentionInDays(): number;
    set retentionInDays(value: number);
    resetRetentionInDays(): void;
    get retentionInDaysInput(): number | undefined;
    private _storageAccountAccessKey?;
    get storageAccountAccessKey(): string;
    set storageAccountAccessKey(value: string);
    resetStorageAccountAccessKey(): void;
    get storageAccountAccessKeyInput(): string | undefined;
    private _storageAccountAccessKeyIsSecondary?;
    get storageAccountAccessKeyIsSecondary(): boolean | cdktf.IResolvable;
    set storageAccountAccessKeyIsSecondary(value: boolean | cdktf.IResolvable);
    resetStorageAccountAccessKeyIsSecondary(): void;
    get storageAccountAccessKeyIsSecondaryInput(): boolean | cdktf.IResolvable | undefined;
    private _storageEndpoint?;
    get storageEndpoint(): string;
    set storageEndpoint(value: string);
    resetStorageEndpoint(): void;
    get storageEndpointInput(): string | undefined;
    private _timeouts;
    get timeouts(): MssqlDatabaseExtendedAuditingPolicyTimeoutsOutputReference;
    putTimeouts(value: MssqlDatabaseExtendedAuditingPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): MssqlDatabaseExtendedAuditingPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
