import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MssqlManagedInstanceActiveDirectoryAdministratorConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_managed_instance_active_directory_administrator#azuread_authentication_only MssqlManagedInstanceActiveDirectoryAdministrator#azuread_authentication_only}
    */
    readonly azureadAuthenticationOnly?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_managed_instance_active_directory_administrator#login_username MssqlManagedInstanceActiveDirectoryAdministrator#login_username}
    */
    readonly loginUsername: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_managed_instance_active_directory_administrator#managed_instance_id MssqlManagedInstanceActiveDirectoryAdministrator#managed_instance_id}
    */
    readonly managedInstanceId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_managed_instance_active_directory_administrator#object_id MssqlManagedInstanceActiveDirectoryAdministrator#object_id}
    */
    readonly objectId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_managed_instance_active_directory_administrator#tenant_id MssqlManagedInstanceActiveDirectoryAdministrator#tenant_id}
    */
    readonly tenantId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_managed_instance_active_directory_administrator#timeouts MssqlManagedInstanceActiveDirectoryAdministrator#timeouts}
    */
    readonly timeouts?: MssqlManagedInstanceActiveDirectoryAdministratorTimeouts;
}
export interface MssqlManagedInstanceActiveDirectoryAdministratorTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_managed_instance_active_directory_administrator#create MssqlManagedInstanceActiveDirectoryAdministrator#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_managed_instance_active_directory_administrator#delete MssqlManagedInstanceActiveDirectoryAdministrator#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_managed_instance_active_directory_administrator#read MssqlManagedInstanceActiveDirectoryAdministrator#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_managed_instance_active_directory_administrator#update MssqlManagedInstanceActiveDirectoryAdministrator#update}
    */
    readonly update?: string;
}
export declare function mssqlManagedInstanceActiveDirectoryAdministratorTimeoutsToTerraform(struct?: MssqlManagedInstanceActiveDirectoryAdministratorTimeoutsOutputReference | MssqlManagedInstanceActiveDirectoryAdministratorTimeouts | cdktf.IResolvable): any;
export declare class MssqlManagedInstanceActiveDirectoryAdministratorTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MssqlManagedInstanceActiveDirectoryAdministratorTimeouts | undefined;
    set internalValue(value: MssqlManagedInstanceActiveDirectoryAdministratorTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_managed_instance_active_directory_administrator azurerm_mssql_managed_instance_active_directory_administrator}
*/
export declare class MssqlManagedInstanceActiveDirectoryAdministrator extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_mssql_managed_instance_active_directory_administrator";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_managed_instance_active_directory_administrator azurerm_mssql_managed_instance_active_directory_administrator} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MssqlManagedInstanceActiveDirectoryAdministratorConfig
    */
    constructor(scope: Construct, id: string, config: MssqlManagedInstanceActiveDirectoryAdministratorConfig);
    private _azureadAuthenticationOnly?;
    get azureadAuthenticationOnly(): boolean | cdktf.IResolvable;
    set azureadAuthenticationOnly(value: boolean | cdktf.IResolvable);
    resetAzureadAuthenticationOnly(): void;
    get azureadAuthenticationOnlyInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _loginUsername?;
    get loginUsername(): string;
    set loginUsername(value: string);
    get loginUsernameInput(): string | undefined;
    private _managedInstanceId?;
    get managedInstanceId(): string;
    set managedInstanceId(value: string);
    get managedInstanceIdInput(): string | undefined;
    private _objectId?;
    get objectId(): string;
    set objectId(value: string);
    get objectIdInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    get tenantIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): MssqlManagedInstanceActiveDirectoryAdministratorTimeoutsOutputReference;
    putTimeouts(value: MssqlManagedInstanceActiveDirectoryAdministratorTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): MssqlManagedInstanceActiveDirectoryAdministratorTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
