import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NatGatewayPublicIpPrefixAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/nat_gateway_public_ip_prefix_association#nat_gateway_id NatGatewayPublicIpPrefixAssociation#nat_gateway_id}
    */
    readonly natGatewayId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/nat_gateway_public_ip_prefix_association#public_ip_prefix_id NatGatewayPublicIpPrefixAssociation#public_ip_prefix_id}
    */
    readonly publicIpPrefixId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/nat_gateway_public_ip_prefix_association#timeouts NatGatewayPublicIpPrefixAssociation#timeouts}
    */
    readonly timeouts?: NatGatewayPublicIpPrefixAssociationTimeouts;
}
export interface NatGatewayPublicIpPrefixAssociationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/nat_gateway_public_ip_prefix_association#create NatGatewayPublicIpPrefixAssociation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/nat_gateway_public_ip_prefix_association#delete NatGatewayPublicIpPrefixAssociation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/nat_gateway_public_ip_prefix_association#read NatGatewayPublicIpPrefixAssociation#read}
    */
    readonly read?: string;
}
export declare function natGatewayPublicIpPrefixAssociationTimeoutsToTerraform(struct?: NatGatewayPublicIpPrefixAssociationTimeoutsOutputReference | NatGatewayPublicIpPrefixAssociationTimeouts | cdktf.IResolvable): any;
export declare class NatGatewayPublicIpPrefixAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NatGatewayPublicIpPrefixAssociationTimeouts | undefined;
    set internalValue(value: NatGatewayPublicIpPrefixAssociationTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/nat_gateway_public_ip_prefix_association azurerm_nat_gateway_public_ip_prefix_association}
*/
export declare class NatGatewayPublicIpPrefixAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_nat_gateway_public_ip_prefix_association";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/nat_gateway_public_ip_prefix_association azurerm_nat_gateway_public_ip_prefix_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NatGatewayPublicIpPrefixAssociationConfig
    */
    constructor(scope: Construct, id: string, config: NatGatewayPublicIpPrefixAssociationConfig);
    get id(): string;
    private _natGatewayId?;
    get natGatewayId(): string;
    set natGatewayId(value: string);
    get natGatewayIdInput(): string | undefined;
    private _publicIpPrefixId?;
    get publicIpPrefixId(): string;
    set publicIpPrefixId(value: string);
    get publicIpPrefixIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): NatGatewayPublicIpPrefixAssociationTimeoutsOutputReference;
    putTimeouts(value: NatGatewayPublicIpPrefixAssociationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): NatGatewayPublicIpPrefixAssociationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
