import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkSecurityRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#access NetworkSecurityRule#access}
    */
    readonly access: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#description NetworkSecurityRule#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#destination_address_prefix NetworkSecurityRule#destination_address_prefix}
    */
    readonly destinationAddressPrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#destination_address_prefixes NetworkSecurityRule#destination_address_prefixes}
    */
    readonly destinationAddressPrefixes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#destination_application_security_group_ids NetworkSecurityRule#destination_application_security_group_ids}
    */
    readonly destinationApplicationSecurityGroupIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#destination_port_range NetworkSecurityRule#destination_port_range}
    */
    readonly destinationPortRange?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#destination_port_ranges NetworkSecurityRule#destination_port_ranges}
    */
    readonly destinationPortRanges?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#direction NetworkSecurityRule#direction}
    */
    readonly direction: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#name NetworkSecurityRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#network_security_group_name NetworkSecurityRule#network_security_group_name}
    */
    readonly networkSecurityGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#priority NetworkSecurityRule#priority}
    */
    readonly priority: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#protocol NetworkSecurityRule#protocol}
    */
    readonly protocol: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#resource_group_name NetworkSecurityRule#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#source_address_prefix NetworkSecurityRule#source_address_prefix}
    */
    readonly sourceAddressPrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#source_address_prefixes NetworkSecurityRule#source_address_prefixes}
    */
    readonly sourceAddressPrefixes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#source_application_security_group_ids NetworkSecurityRule#source_application_security_group_ids}
    */
    readonly sourceApplicationSecurityGroupIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#source_port_range NetworkSecurityRule#source_port_range}
    */
    readonly sourcePortRange?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#source_port_ranges NetworkSecurityRule#source_port_ranges}
    */
    readonly sourcePortRanges?: string[];
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#timeouts NetworkSecurityRule#timeouts}
    */
    readonly timeouts?: NetworkSecurityRuleTimeouts;
}
export interface NetworkSecurityRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#create NetworkSecurityRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#delete NetworkSecurityRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#read NetworkSecurityRule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule#update NetworkSecurityRule#update}
    */
    readonly update?: string;
}
export declare function networkSecurityRuleTimeoutsToTerraform(struct?: NetworkSecurityRuleTimeoutsOutputReference | NetworkSecurityRuleTimeouts | cdktf.IResolvable): any;
export declare class NetworkSecurityRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkSecurityRuleTimeouts | undefined;
    set internalValue(value: NetworkSecurityRuleTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule azurerm_network_security_rule}
*/
export declare class NetworkSecurityRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_network_security_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/network_security_rule azurerm_network_security_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkSecurityRuleConfig
    */
    constructor(scope: Construct, id: string, config: NetworkSecurityRuleConfig);
    private _access?;
    get access(): string;
    set access(value: string);
    get accessInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _destinationAddressPrefix?;
    get destinationAddressPrefix(): string;
    set destinationAddressPrefix(value: string);
    resetDestinationAddressPrefix(): void;
    get destinationAddressPrefixInput(): string | undefined;
    private _destinationAddressPrefixes?;
    get destinationAddressPrefixes(): string[];
    set destinationAddressPrefixes(value: string[]);
    resetDestinationAddressPrefixes(): void;
    get destinationAddressPrefixesInput(): string[] | undefined;
    private _destinationApplicationSecurityGroupIds?;
    get destinationApplicationSecurityGroupIds(): string[];
    set destinationApplicationSecurityGroupIds(value: string[]);
    resetDestinationApplicationSecurityGroupIds(): void;
    get destinationApplicationSecurityGroupIdsInput(): string[] | undefined;
    private _destinationPortRange?;
    get destinationPortRange(): string;
    set destinationPortRange(value: string);
    resetDestinationPortRange(): void;
    get destinationPortRangeInput(): string | undefined;
    private _destinationPortRanges?;
    get destinationPortRanges(): string[];
    set destinationPortRanges(value: string[]);
    resetDestinationPortRanges(): void;
    get destinationPortRangesInput(): string[] | undefined;
    private _direction?;
    get direction(): string;
    set direction(value: string);
    get directionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkSecurityGroupName?;
    get networkSecurityGroupName(): string;
    set networkSecurityGroupName(value: string);
    get networkSecurityGroupNameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sourceAddressPrefix?;
    get sourceAddressPrefix(): string;
    set sourceAddressPrefix(value: string);
    resetSourceAddressPrefix(): void;
    get sourceAddressPrefixInput(): string | undefined;
    private _sourceAddressPrefixes?;
    get sourceAddressPrefixes(): string[];
    set sourceAddressPrefixes(value: string[]);
    resetSourceAddressPrefixes(): void;
    get sourceAddressPrefixesInput(): string[] | undefined;
    private _sourceApplicationSecurityGroupIds?;
    get sourceApplicationSecurityGroupIds(): string[];
    set sourceApplicationSecurityGroupIds(value: string[]);
    resetSourceApplicationSecurityGroupIds(): void;
    get sourceApplicationSecurityGroupIdsInput(): string[] | undefined;
    private _sourcePortRange?;
    get sourcePortRange(): string;
    set sourcePortRange(value: string);
    resetSourcePortRange(): void;
    get sourcePortRangeInput(): string | undefined;
    private _sourcePortRanges?;
    get sourcePortRanges(): string[];
    set sourcePortRanges(value: string[]);
    resetSourcePortRanges(): void;
    get sourcePortRangesInput(): string[] | undefined;
    private _timeouts;
    get timeouts(): NetworkSecurityRuleTimeoutsOutputReference;
    putTimeouts(value: NetworkSecurityRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): NetworkSecurityRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
