import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PolicyRemediationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_remediation#location_filters PolicyRemediation#location_filters}
    */
    readonly locationFilters?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_remediation#name PolicyRemediation#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_remediation#policy_assignment_id PolicyRemediation#policy_assignment_id}
    */
    readonly policyAssignmentId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_remediation#policy_definition_reference_id PolicyRemediation#policy_definition_reference_id}
    */
    readonly policyDefinitionReferenceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_remediation#resource_discovery_mode PolicyRemediation#resource_discovery_mode}
    */
    readonly resourceDiscoveryMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_remediation#scope PolicyRemediation#scope}
    */
    readonly scope: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_remediation#timeouts PolicyRemediation#timeouts}
    */
    readonly timeouts?: PolicyRemediationTimeouts;
}
export interface PolicyRemediationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_remediation#create PolicyRemediation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_remediation#delete PolicyRemediation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_remediation#read PolicyRemediation#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/policy_remediation#update PolicyRemediation#update}
    */
    readonly update?: string;
}
export declare function policyRemediationTimeoutsToTerraform(struct?: PolicyRemediationTimeoutsOutputReference | PolicyRemediationTimeouts | cdktf.IResolvable): any;
export declare class PolicyRemediationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PolicyRemediationTimeouts | undefined;
    set internalValue(value: PolicyRemediationTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/policy_remediation azurerm_policy_remediation}
*/
export declare class PolicyRemediation extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_policy_remediation";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/policy_remediation azurerm_policy_remediation} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PolicyRemediationConfig
    */
    constructor(scope: Construct, id: string, config: PolicyRemediationConfig);
    get id(): string;
    private _locationFilters?;
    get locationFilters(): string[];
    set locationFilters(value: string[]);
    resetLocationFilters(): void;
    get locationFiltersInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _policyAssignmentId?;
    get policyAssignmentId(): string;
    set policyAssignmentId(value: string);
    get policyAssignmentIdInput(): string | undefined;
    private _policyDefinitionReferenceId?;
    get policyDefinitionReferenceId(): string;
    set policyDefinitionReferenceId(value: string);
    resetPolicyDefinitionReferenceId(): void;
    get policyDefinitionReferenceIdInput(): string | undefined;
    private _resourceDiscoveryMode?;
    get resourceDiscoveryMode(): string;
    set resourceDiscoveryMode(value: string);
    resetResourceDiscoveryMode(): void;
    get resourceDiscoveryModeInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    get scopeInput(): string | undefined;
    private _timeouts;
    get timeouts(): PolicyRemediationTimeoutsOutputReference;
    putTimeouts(value: PolicyRemediationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): PolicyRemediationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
