import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RouteTableConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route_table#disable_bgp_route_propagation RouteTable#disable_bgp_route_propagation}
    */
    readonly disableBgpRoutePropagation?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route_table#location RouteTable#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route_table#name RouteTable#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route_table#resource_group_name RouteTable#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route_table#route RouteTable#route}
    */
    readonly route?: RouteTableRoute[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route_table#tags RouteTable#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route_table#timeouts RouteTable#timeouts}
    */
    readonly timeouts?: RouteTableTimeouts;
}
export interface RouteTableRoute {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route_table#address_prefix RouteTable#address_prefix}
    */
    readonly addressPrefix?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route_table#name RouteTable#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route_table#next_hop_in_ip_address RouteTable#next_hop_in_ip_address}
    */
    readonly nextHopInIpAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route_table#next_hop_type RouteTable#next_hop_type}
    */
    readonly nextHopType?: string;
}
export declare function routeTableRouteToTerraform(struct?: RouteTableRoute | cdktf.IResolvable): any;
export interface RouteTableTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route_table#create RouteTable#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route_table#delete RouteTable#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route_table#read RouteTable#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/route_table#update RouteTable#update}
    */
    readonly update?: string;
}
export declare function routeTableTimeoutsToTerraform(struct?: RouteTableTimeoutsOutputReference | RouteTableTimeouts | cdktf.IResolvable): any;
export declare class RouteTableTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): RouteTableTimeouts | undefined;
    set internalValue(value: RouteTableTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/route_table azurerm_route_table}
*/
export declare class RouteTable extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_route_table";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/route_table azurerm_route_table} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RouteTableConfig
    */
    constructor(scope: Construct, id: string, config: RouteTableConfig);
    private _disableBgpRoutePropagation?;
    get disableBgpRoutePropagation(): boolean | cdktf.IResolvable;
    set disableBgpRoutePropagation(value: boolean | cdktf.IResolvable);
    resetDisableBgpRoutePropagation(): void;
    get disableBgpRoutePropagationInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _route?;
    get route(): RouteTableRoute[] | cdktf.IResolvable;
    set route(value: RouteTableRoute[] | cdktf.IResolvable);
    resetRoute(): void;
    get routeInput(): cdktf.IResolvable | RouteTableRoute[] | undefined;
    get subnets(): string[];
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): RouteTableTimeoutsOutputReference;
    putTimeouts(value: RouteTableTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): RouteTableTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
